/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.quickshulker.util;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.kyrptonaught.quickshulker.api.QuickOpenableRegistry;
import net.kyrptonaught.quickshulker.api.QuickShulkerData;
import net.kyrptonaught.quickshulker.api.Util;
import net.kyrptonaught.shulkerutils.ShulkerUtils;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_5536;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BundleHelper {
    public static boolean shouldAttemptBundle(class_1657 player, class_5536 clickType, class_1799 hostStack, class_1799 insertStack, boolean enabledInConfig) {
        return enabledInConfig && clickType == class_5536.field_27014 && Util.isOpenableItem(hostStack) != false && BundleHelper.isAcceptedInsertItem(insertStack) && Util.getQuickItemInventory(player, hostStack) != null;
    }

    public static boolean shouldAttemptUnBundle(class_1657 player, class_5536 clickType, class_1799 hostStack, class_1799 insertStack, boolean enabledInConfig) {
        class_1263 stackInv = Util.getQuickItemInventory(player, hostStack);
        if (stackInv != null) {
            return enabledInConfig && clickType == class_5536.field_27014 && hostStack.method_7947() == 1 && !stackInv.method_5442() && insertStack.method_7960();
        }
        return false;
    }

    public static boolean shouldAttemptTransfer(class_1657 player, class_5536 clickType, class_1799 hostStack, class_1799 insertStack, boolean enabledInConfig) {
        return enabledInConfig && clickType == class_5536.field_27014 && ShulkerUtils.isShulkerItem(hostStack) && hostStack.method_7947() == 1 && Util.getQuickItemInventory(player, hostStack) != null && BundleHelper.isAcceptedTransferItem(player, insertStack);
    }

    private static boolean isAcceptedInsertItem(class_1799 insertStack) {
        return !insertStack.method_7960() && !ShulkerUtils.isShulkerItem(insertStack);
    }

    private static boolean isAcceptedTransferItem(class_1657 player, class_1799 insertStack) {
        return ShulkerUtils.isShulkerItem(insertStack) && insertStack.method_7947() == 1 && Util.getQuickItemInventory(player, insertStack) != null;
    }

    public static void bundleItemIntoStack(class_1657 player, class_1799 hostStack, class_1799 insertStack, CallbackInfoReturnable<Boolean> cir) {
        if (BundleHelper.bundleItem(player, hostStack, insertStack) != null && cir != null) {
            cir.setReturnValue((Object)true);
        }
    }

    public static void bundleItemIntoStack(class_1657 player, class_1799 hostStack, class_1799 insertStack, class_1735 slot, CallbackInfoReturnable<Boolean> cir) {
        if (BundleHelper.bundleItem(player, hostStack, insertStack, slot) != null && cir != null) {
            cir.setReturnValue((Object)true);
        }
    }

    public static void unbundleStackIntoSlot(class_1657 player, class_1799 hostStack, class_1735 unbundleSlot, CallbackInfoReturnable<Boolean> cir) {
        class_1799 output = BundleHelper.unbundleItem(player, hostStack, unbundleSlot);
        if (output != null) {
            unbundleSlot.method_53512(output);
            cir.setReturnValue((Object)true);
        }
    }

    public static void transferItemsToShulker(class_1657 player, class_1799 hostStack, class_1799 insertStack, CallbackInfoReturnable<Boolean> cir) {
        class_1277 source = (class_1277)Util.getQuickItemInventory(player, insertStack);
        class_1277 target = (class_1277)Util.getQuickItemInventory(player, hostStack);
        if (source != null && target != null) {
            int temp = 0;
            for (int i = source.method_5439() - 1; i >= 0; --i) {
                class_1799 stack = source.method_5438(i);
                if (stack.method_7960() || !target.method_27070(stack)) continue;
                class_1799 output = target.method_5491(stack);
                source.method_5447(i, output);
                ++temp;
            }
            if (temp > 0 && cir != null) {
                target.method_5432((class_11565)player);
                source.method_5432((class_11565)player);
                cir.setReturnValue((Object)true);
            }
        }
    }

    public static class_1799 unbundleItem(class_1657 player, class_1799 hostStack, class_1735 unbundleSlot) {
        class_1263 inv = Util.getQuickItemInventory(player, hostStack);
        class_1799 output = null;
        for (int i = inv.method_5439() - 1; i >= 0; --i) {
            output = inv.method_5438(i);
            if (output.method_7960() || !unbundleSlot.method_7680(output)) continue;
            output = inv.method_5441(i);
            inv.method_5432((class_11565)player);
            return output;
        }
        return null;
    }

    private static class_1799 bundleItem(class_1657 player, class_1799 hostStack, class_1799 insertStack) {
        class_1263 bundlingInv = Util.getQuickItemInventory(player, hostStack);
        int amount = BundleHelper.insertIntoInv(bundlingInv, player, hostStack, insertStack);
        if (amount != 0) {
            insertStack.method_7934(amount);
            return insertStack;
        }
        return null;
    }

    private static class_1799 bundleItem(class_1657 player, class_1799 hostStack, class_1799 insertStack, class_1735 slot) {
        if (!slot.method_7674(player)) {
            return null;
        }
        class_1263 bundlingInv = Util.getQuickItemInventory(player, hostStack);
        int amount = BundleHelper.insertIntoInv(bundlingInv, player, hostStack, insertStack);
        if (amount != 0) {
            insertStack = slot.method_32753(amount, insertStack.method_7947(), player);
            return insertStack;
        }
        return null;
    }

    private static int insertIntoInv(class_1263 bundlingInv, class_1657 player, class_1799 hostStack, class_1799 insertStack) {
        QuickShulkerData qsdata = QuickOpenableRegistry.getQuickie((class_1935)hostStack.method_7909());
        int amount = 0;
        if (bundlingInv != null && qsdata.canBundleInsertItem(player, bundlingInv, hostStack, insertStack)) {
            try (Transaction transaction = Transaction.openOuter();){
                amount = (int)InventoryStorage.of((class_1263)bundlingInv, null).insert((Object)ItemVariant.of((class_1799)insertStack), (long)insertStack.method_7947(), (TransactionContext)transaction);
                transaction.commit();
                bundlingInv.method_5432((class_11565)player);
                int n = amount;
                return n;
            }
        }
        return amount;
    }
}

