/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config.screen.items;

import java.util.ArrayList;
import java.util.List;
import net.kyrptonaught.kyrptconfig.config.screen.items.ConfigItem;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class SubItem<E>
extends ConfigItem<E> {
    protected boolean expanded = false;
    protected int subStart = 0;
    protected List<ConfigItem<?>> configs = new ArrayList();

    public SubItem(class_2561 name, boolean isExpanded) {
        super(name, null, null);
        this.expanded = isExpanded;
    }

    public SubItem(class_2561 name) {
        this(name, false);
    }

    @Override
    public boolean requiresRestart() {
        for (ConfigItem<?> item : this.configs) {
            if (!item.requiresRestart()) continue;
            return true;
        }
        return super.requiresRestart();
    }

    @Override
    public void save() {
        for (ConfigItem<?> item : this.configs) {
            item.save();
        }
        super.save();
    }

    @Override
    public boolean isValueDefault() {
        for (ConfigItem<?> item : this.configs) {
            if (item.isValueDefault()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void tick() {
        for (ConfigItem<?> item : this.configs) {
            if (item.isHidden()) continue;
            item.tick();
        }
    }

    @Override
    public void mouseClicked(class_11909 click, boolean doubled) {
        super.mouseClicked(click, doubled);
        if (!this.isHidden() && click.comp_4799() > (double)this.subStart && click.comp_4799() < (double)(this.subStart + 20)) {
            boolean bl = this.expanded = !this.expanded;
        }
        if (this.expanded && !this.isHidden()) {
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden()) continue;
                item.mouseClicked(click, doubled);
            }
        }
    }

    @Override
    public boolean charTyped(class_11905 input) {
        if (this.expanded && !this.isHidden()) {
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden() || !item.charTyped(input)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyPressed(class_11908 input) {
        if (this.expanded && !this.isHidden()) {
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden() || !item.keyPressed(input)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getContentSize() {
        if (this.expanded && !this.isHidden()) {
            int size = 0;
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden()) continue;
                size += item.getSize() + 3;
            }
            return size;
        }
        return 0;
    }

    public void clearConfigItems() {
        this.configs.clear();
    }

    public ConfigItem<?> addConfigItem(ConfigItem<?> item) {
        this.configs.add(item);
        return item;
    }

    @Override
    public void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        super.render(context, x, y, mouseX, mouseY, delta);
        if (this.isHidden()) {
            return;
        }
        context.method_51433(class_310.method_1551().field_1772, this.expanded ? "-" : "+", x - 10, y + 5, -1, false);
        this.subStart = y;
        if (this.expanded) {
            int runningY = this.subStart + 23;
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden()) continue;
                item.render(context, 30, runningY, mouseX, mouseY, delta);
                runningY += item.getSize() + 3;
            }
        }
    }

    @Override
    public void render2(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        super.render2(context, x, y, mouseX, mouseY, delta);
        if (this.isHidden()) {
            return;
        }
        if (this.expanded) {
            int runningY = y + 23;
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden()) continue;
                item.render2(context, 30, runningY, mouseX, mouseY, delta);
                runningY += item.getSize() + 3;
            }
        }
    }
}

