/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config.screen.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kyrptonaught.kyrptconfig.config.screen.NotSuckyButton;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9848;

public abstract class ConfigItem<T> {
    private class_2561 fieldTitle;
    private List<class_2561> toolTipText;
    protected Consumer<T> saveConsumer;
    protected Consumer<T> valueUpdatedEvent;
    protected NotSuckyButton resetButton;
    protected T value;
    protected T defaultValue;
    private boolean requiresRestart = false;
    private boolean isHidden = false;

    public ConfigItem(class_2561 name, T value, T defaultValue) {
        this.fieldTitle = name;
        this.value = value;
        this.defaultValue = defaultValue;
    }

    public ConfigItem<?> setSaveConsumer(Consumer<T> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public ConfigItem<?> setValueUpdatedEvent(Consumer<T> valueUpdatedEvent) {
        this.valueUpdatedEvent = valueUpdatedEvent;
        return this;
    }

    public ConfigItem<?> setRequiresRestart() {
        this.requiresRestart = true;
        ((class_5250)this.fieldTitle).method_27693(" *");
        return this;
    }

    public class_2561 getTitleText() {
        return this.fieldTitle;
    }

    public ConfigItem<?> setTitleText(class_2561 title) {
        this.fieldTitle = title;
        return this;
    }

    public ConfigItem<?> setToolTipWithNewLine(String translatableKey) {
        String[] translated = class_2477.method_10517().method_48307(translatableKey).split("\n");
        this.toolTipText = new ArrayList<class_2561>();
        for (String line : translated) {
            this.toolTipText.add((class_2561)class_2561.method_43470((String)line));
        }
        return this;
    }

    public ConfigItem<?> setToolTip(class_2561 toolTip) {
        this.toolTipText = List.of(toolTip);
        return this;
    }

    public ConfigItem<?> setToolTip(class_2561 ... toolTips) {
        this.toolTipText = List.of(toolTips);
        return this;
    }

    public ConfigItem<?> setHidden(boolean hidden) {
        this.isHidden = hidden;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean requiresRestart() {
        return this.requiresRestart;
    }

    protected void runSaveConsumer(T value) {
        if (this.saveConsumer != null && value != null) {
            this.saveConsumer.accept(value);
        }
    }

    public void save() {
        this.runSaveConsumer(this.value);
    }

    public int getSize() {
        if (this.isHidden) {
            return 0;
        }
        return this.getHeaderSize() + this.getContentSize();
    }

    public int getHeaderSize() {
        return 20;
    }

    public int getContentSize() {
        return 0;
    }

    public void useDefaultResetBTN() {
        this.resetButton = new NotSuckyButton(0, 0, 35, 20, (class_2561)class_2561.method_43471((String)"key.kyrptconfig.config.reset"), widget -> this.resetToDefault());
    }

    public void resetToDefault() {
        this.setValue(this.defaultValue);
    }

    public boolean isValueDefault() {
        return this.value.equals(this.defaultValue);
    }

    public void setValue(T value) {
        this.value = value;
        if (this.valueUpdatedEvent != null) {
            this.valueUpdatedEvent.accept(this.value);
        }
    }

    public void tick() {
    }

    public void mouseClicked(class_11909 click, boolean doubled) {
        if (this.isHidden) {
            return;
        }
        if (this.resetButton != null) {
            this.resetButton.method_25402(click, doubled);
        }
    }

    public boolean charTyped(class_11905 input) {
        return false;
    }

    public boolean keyPressed(class_11908 input) {
        return false;
    }

    public void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        if (this.isHidden) {
            return;
        }
        int width = class_310.method_1551().method_22683().method_4486();
        int height = y + this.getHeaderSize();
        if (mouseY > y && mouseY < height) {
            context.method_25294(0, y - 1, width, height + 1, class_9848.method_61324((int)50, (int)255, (int)255, (int)255));
        }
        context.method_51439(class_310.method_1551().field_1772, this.fieldTitle, x, y + 6, -1, true);
        if (this.resetButton != null) {
            this.resetButton.method_46419(y);
            this.resetButton.method_46421(width - this.resetButton.method_25368() - 20);
            this.resetButton.field_22763 = !this.isValueDefault();
            this.resetButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public void render2(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        if (this.isHidden) {
            return;
        }
        if (mouseX > x && mouseX < x + class_310.method_1551().field_1772.method_27525((class_5348)this.fieldTitle) && mouseY > y && mouseY < y + 12) {
            this.renderToolTip(context, mouseX, mouseY);
        }
    }

    public void renderToolTip(class_332 context, int x, int y) {
        if (this.toolTipText != null && this.requiresRestart) {
            ArrayList<class_2561> newList = new ArrayList<class_2561>(this.toolTipText);
            newList.add((class_2561)class_2561.method_43471((String)"key.kyrptconfig.config.restartRequired"));
            context.method_51434(class_310.method_1551().field_1772, newList, x, y);
        } else if (this.toolTipText != null) {
            context.method_51434(class_310.method_1551().field_1772, this.toolTipText, x, y);
        } else if (this.requiresRestart) {
            context.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"key.kyrptconfig.config.restartRequired"), x, y);
        }
    }
}

