/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config.screen;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyrptonaught.kyrptconfig.config.screen.ConfigScreen;
import net.kyrptonaught.kyrptconfig.config.screen.NotSuckyButton;
import net.kyrptonaught.kyrptconfig.config.screen.items.ConfigItem;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class ConfigSection
extends class_437 {
    class_2561 title;
    public List<ConfigItem<?>> configs = new CopyOnWriteArrayList();
    public NotSuckyButton sectionSelectionBTN;
    int selectionIndex = 0;
    int scrollOffset = 0;

    public ConfigSection(ConfigScreen configScreen, class_2561 title) {
        super(title);
        this.title = title;
        this.sectionSelectionBTN = new NotSuckyButton(0, 32, 10, 20, title, widget -> configScreen.setSelectedSection(this.selectionIndex));
        configScreen.addConfigSection(this);
    }

    public void save() {
        for (ConfigItem<?> configItem : this.configs) {
            configItem.save();
        }
    }

    public int getTotalSectionSize() {
        int size = this.configs.size() * 3 + 5;
        for (ConfigItem<?> configItem : this.configs) {
            size += configItem.getSize();
        }
        return size;
    }

    public ConfigItem<?> addConfigItem(ConfigItem<?> item) {
        this.configs.add(item);
        return item;
    }

    public ConfigItem<?> insertConfigItem(ConfigItem<?> item, int slot) {
        this.configs.add(slot, item);
        return item;
    }

    public ConfigItem<?> removeConfigItem(int slot) {
        return this.configs.remove(slot);
    }

    public void method_25393() {
        super.method_25393();
        for (ConfigItem<?> configItem : this.configs) {
            configItem.tick();
        }
    }

    public boolean method_25404(class_11908 input) {
        for (ConfigItem<?> configItem : this.configs) {
            if (!configItem.keyPressed(input)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25400(class_11905 input) {
        for (ConfigItem<?> configItem : this.configs) {
            if (!configItem.charTyped(input)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        for (ConfigItem<?> configItem : this.configs) {
            configItem.mouseClicked(click, doubled);
        }
        this.method_25401(click.comp_4798(), click.comp_4799(), 0.0, 0.0);
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset + (int)(verticalAmount * 15.0)), (int)(-this.calculateSectionHeight()), (int)0);
        return true;
    }

    public int calculateSectionHeight() {
        int visibleHeight = this.field_22790;
        int sectionSize = this.getTotalSectionSize();
        if (sectionSize <= visibleHeight) {
            return 0;
        }
        return sectionSize - visibleHeight;
    }

    public void render(class_332 context, int startY, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int runningY = this.scrollOffset + startY + 5;
        for (ConfigItem<?> configItem : this.configs) {
            configItem.render(context, 20, runningY, mouseX, mouseY, delta);
            runningY += configItem.getSize() + 3;
        }
    }

    public void render2(class_332 context, int startY, int mouseX, int mouseY, float delta) {
        int runningY = this.scrollOffset + startY + 5;
        for (ConfigItem<?> configItem : this.configs) {
            configItem.render2(context, 20, runningY, mouseX, mouseY, delta);
            runningY += configItem.getSize() + 3;
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }
}

