/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.kyrptonaught.jankson.Jankson;
import net.kyrptonaught.kyrptconfig.config.AbstractConfigFile;
import net.kyrptonaught.kyrptconfig.config.ConfigStorage;
import net.kyrptonaught.kyrptconfig.config.CustomJankson;
import net.kyrptonaught.kyrptconfig.config.JanksonJsonLoader;
import net.kyrptonaught.kyrptconfig.config.JsonLoader;
import net.minecraft.class_2960;

public class ConfigManager {
    protected JsonLoader JANKSON;
    protected final HashMap<String, ConfigStorage> configs = new HashMap();
    protected Path dir;
    protected String MOD_ID;

    private ConfigManager(String mod_id) {
        this.MOD_ID = mod_id;
        this.dir = FabricLoader.getInstance().getConfigDir();
        this.buildJankson();
    }

    public void buildJankson() {
        this.JANKSON = new JanksonJsonLoader();
        Jankson.Builder builder = CustomJankson.customJanksonBuilder();
        this.setJANKSON(builder.registerSerializer(class_2960.class, (identifier, marshaller) -> marshaller.serialize(identifier.toString())).registerDeserializer(String.class, class_2960.class, (s, m) -> class_2960.method_60654((String)s)).build());
    }

    public AbstractConfigFile getConfig(String name) {
        if (!((String)name).endsWith(".json5")) {
            name = (String)name + ".json5";
        }
        return this.configs.get((Object)name).config;
    }

    public AbstractConfigFile getConfigDefault(String name) {
        if (!((String)name).endsWith(".json5")) {
            name = (String)name + ".json5";
        }
        return this.configs.get(name).getDefaultConfig();
    }

    public void registerFile(String name, AbstractConfigFile defaultConfig) {
        if (this.JANKSON == null) {
            this.buildJankson();
        }
        this.registerFile(name, defaultConfig, this.JANKSON);
    }

    public void registerFile(String name, AbstractConfigFile defaultConfig, JsonLoader jsonLoader) {
        if (!((String)name).endsWith(".json5")) {
            name = (String)name + ".json5";
        }
        this.configs.put((String)name, new ConfigStorage(this.dir.resolve((String)name), defaultConfig, jsonLoader));
    }

    public void save() {
        this.configs.values().forEach(configStorage -> configStorage.save(this.MOD_ID));
    }

    public void load() {
        this.configs.values().forEach(configStorage -> configStorage.load(this.MOD_ID));
        this.save();
    }

    public Jankson getJANKSON() {
        return ((JanksonJsonLoader)this.JANKSON).getJankson();
    }

    public void setJANKSON(Jankson jankson) {
        ((JanksonJsonLoader)this.JANKSON).provideJankson(jankson);
    }

    public static class MultiConfigManager
    extends ConfigManager {
        public MultiConfigManager(String mod_id) {
            super(mod_id);
            this.dir = Path.of(String.valueOf(this.dir) + "/" + this.MOD_ID, new String[0]);
            if (!Files.exists(this.dir, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.dir, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void load(String config) {
            if (!((String)config).endsWith(".json5")) {
                config = (String)config + ".json5";
            }
            ((ConfigStorage)this.configs.get(config)).load(this.MOD_ID);
            this.save((String)config);
        }

        public void save(String config) {
            if (!((String)config).endsWith(".json5")) {
                config = (String)config + ".json5";
            }
            ((ConfigStorage)this.configs.get(config)).save(this.MOD_ID);
        }
    }

    public static class SingleConfigManager
    extends ConfigManager {
        public SingleConfigManager(String mod_id, AbstractConfigFile defaultConfig) {
            super(mod_id);
            this.registerFile(mod_id + "config", defaultConfig);
        }

        public AbstractConfigFile getConfig() {
            return this.getConfig(this.MOD_ID + "config");
        }

        public AbstractConfigFile getConfigDefault() {
            return this.getConfigDefault(this.MOD_ID + "config");
        }
    }
}

