const lib = require("blib");
const items = require("game/items");

const T2melter = extend(AttributeCrafter, "T2melter", {});
lib.setBuildingSimple(T2melter, AttributeCrafter.AttributeCrafterBuild, {
    draw(){
        this.super$draw();
        Draw.color(this.liquids.current().color);
        Draw.alpha(this.liquids.get(this.liquids.current()) / T2melter.liquidCapacity);
        Draw.rect(Core.atlas.find(lib.aModName + "-T2melter-liquid"), this.x, this.y);
        Draw.color();
    },
});
T2melter.outputLiquid = new LiquidStack(Liquids.slag, 0.55);
T2melter.craftTime = 10;
T2melter.size = 2;
T2melter.health = 200*2*2;
T2melter.hasPower = true;
T2melter.hasLiquids = true;
T2melter.consumePower(1.5);
T2melter.consumeItem(Items.scrap, 2);
T2melter.requirements = ItemStack.with(
    Items.lead, 60,
    items.crispSteel, 40,
    Items.silicon, 30,
    Items.graphite, 40
);
T2melter.itemCapacity = 10;
T2melter.boostScale = 0.55;
T2melter.buildVisibility = BuildVisibility.shown;
T2melter.category = Category.crafting;

exports.T2melter = T2melter;