/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.unit;

import ExtraUtilities.content.EUGet;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.graphics.Pal;
import mindustry.type.unit.ErekirUnitType;

public class bossType
extends ErekirUnitType {
    public bossType(String name) {
        super(name);
    }

    public static class pickedBlock
    extends Building {
        public int size;
        public String name;
        private float moTime;
        private float angleTime;

        public pickedBlock set(float health, int size, String name, Team team) {
            this.maxHealth = health;
            this.health = health;
            this.size = size;
            this.name = name;
            this.team = team;
            return this;
        }

        public String name() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }

        public void setX(float x) {
            this.x = x;
        }

        public void setY(float y) {
            this.y = y;
        }

        public void setPos(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public void draw() {
            Draw.rect((TextureRegion)Core.atlas.find(this.name), (float)this.x, (float)this.y);
            Lines.stroke((float)6.0f, (Color)Pal.remove);
            Lines.lineAngle((float)(this.x - (float)(this.size * 8)), (float)(this.y - (float)(this.size * 8)), (float)0.0f, (float)((float)(this.size * 8) * this.health / this.maxHealth));
            Draw.reset();
        }

        public void update() {
            if (this.health <= 0.0f) {
                this.remove();
            }
            float finSize = (float)this.size + 0.2f;
            Groups.bullet.intersect(this.x - finSize * 8.0f, this.y - finSize * 8.0f, finSize * 8.0f * 2.0f, finSize * 8.0f * 2.0f, bullet -> {
                if (bullet.team != this.team && !bullet.collided.contains(this.id) && bullet.type != null && bullet.type.collides) {
                    if (!bullet.type.removeAfterPierce || bullet.type.pierceCap <= 0) {
                        bullet.remove();
                    } else if (bullet.type.hitEffect != Fx.none) {
                        bullet.type.hitEffect.at(bullet.x, bullet.y);
                    }
                    if (bullet.damage > 0.0f) {
                        this.health -= bullet.damage;
                    }
                    bullet.collided.add(this.id);
                }
            });
        }

        public void moveTo(float toX, float toY) {
            if (!Vars.state.isPaused()) {
                this.moTime += Time.delta * 0.04f;
            }
            this.x = EUGet.dx(toX, Math.max(this.dst(toX, toY) - this.moTime, 0.0f), this.angleTo(toX, toY) + 180.0f);
            this.y = EUGet.dy(toY, Math.max(this.dst(toX, toY) - this.moTime, 0.0f), this.angleTo(toX, toY) + 180.0f);
        }

        public void moveTo(Position pos) {
            this.moveTo(pos.getX(), pos.getY());
        }

        public void rotateTo(float cx, float cy, float range, float angle) {
            this.x = EUGet.dx(cx, range, angle);
            this.y = EUGet.dy(cy, range, angle);
        }

        public void rotateTo(Position pos, float range, float angle) {
            if (!Vars.state.isPaused()) {
                this.angleTime = Math.min(this.angleTime + Time.delta * 0.01f, 1.0f);
            }
            this.rotateTo(pos.getX(), pos.getY(), range, angle * this.angleTime);
        }
    }
}

