/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.blocks.power.PowerNode;

public class SCSBullet
extends BasicBulletType {
    public int maxFind = 12;
    Seq<Unit> unitTarget = new Seq();

    public SCSBullet() {
        this.lifetime = 150.0f;
        this.damage = 120.0f;
        this.speed = 3.0f;
        this.status = StatusEffects.sapped;
        this.statusDuration = 120.0f;
        this.width = 28.0f;
        this.height = 18.0f;
        this.backColor = Pal.sapBulletBack;
        this.frontColor = Pal.sapBullet;
        this.trailLength = 18;
        this.trailWidth = 8.0f;
        this.trailColor = Pal.sapBulletBack;
        this.trailInterval = 3.0f;
        this.trailRotation = true;
        this.splashDamage = 150.0f;
        this.splashDamageRadius = 100.0f;
        this.hitShake = 4.0f;
        this.trailEffect = new Effect(16.0f, e -> {
            Draw.color((Color)Pal.sapBulletBack);
            for (int s : Mathf.signs) {
                Drawf.tri((float)e.x, (float)e.y, (float)4.0f, (float)(30.0f * e.fslope()), (float)(e.rotation + (float)(90 * s)));
            }
        });
        this.despawnHit = true;
        this.despawnEffect = new Effect(18.0f, e -> {
            Draw.color((Color)this.backColor);
            Lines.stroke((float)(e.fout() * 2.0f + 0.2f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * this.splashDamageRadius));
        });
        this.despawnSound = Sounds.spark;
        this.homingPower = 0.08f;
        this.homingRange = 256.0f;
        this.homingDelay = 30.0f;
        this.keepVelocity = false;
        this.shrinkY = 0.0f;
        this.collides = false;
    }

    public void update(Bullet b) {
        super.update(b);
        Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)this.homingRange, u -> {
            if (u.targetable(b.team) && !u.inFogTo(b.team)) {
                this.unitTarget.add(u);
            }
        });
        this.unitTarget.removeAll(unit -> unit.dead || !unit.within((Position)b, this.homingRange));
        this.unitTarget.sort(unit -> unit.dst2((Position)b));
        int find = Math.min(this.maxFind, this.unitTarget.size);
        if (b.timer.get(3, 5.0f)) {
            for (int a = 0; a < find; ++a) {
                Unit other = (Unit)this.unitTarget.get(a);
                if (other == null) continue;
                other.damage(this.damage / 6.0f);
                other.apply(this.status, this.statusDuration);
                Fx.chainLightning.at(b.x, b.y, 0.0f, Pal.sapBulletBack, (Object)other);
                Fx.hitLaserBlast.at(other.x, other.y, b.angleTo((Position)other), Pal.sapBulletBack);
            }
        }
        this.unitTarget.clear();
    }

    public void hit(Bullet b) {
        Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)this.splashDamageRadius, unit -> {
            if (unit.targetable(b.team)) {
                unit.damage(this.splashDamage);
                unit.apply(this.status, this.statusDuration);
                Fx.chainLightning.at(b.x, b.y, 0.0f, Pal.sapBulletBack, unit);
                Fx.hitLaserBlast.at(unit.x, unit.y, b.angleTo((Position)unit), Pal.sapBulletBack);
            }
        });
        Vars.indexer.allBuildings(b.x, b.y, this.splashDamageRadius, building -> {
            if (building.block != null && building.team != b.team && building.block instanceof PowerNode && building.power.links.size > 0) {
                building.configureAny(null);
            }
        });
        Damage.damage((Team)b.team, (float)b.x, (float)b.y, (float)this.splashDamageRadius, (float)this.splashDamage, (boolean)false);
    }
}

