/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUBulletTypes;
import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.worlds.entity.bullet.ChainLightningFade;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.effect.ExplosionEffect;
import mindustry.entities.effect.MultiEffect;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Trail;

public class MagneticStormBulletType
extends BasicBulletType {
    public Color cor;
    public Color liC;
    public float[] damages = new float[]{16.0f, 18.0f, 20.0f, 32.0f};
    public int msTl = 15;
    public float dsRange = 160.0f;
    public ChainLightningFade lightning;
    private final Effect tef = new Effect(30.0f, e -> {
        Draw.color((Color)this.liC, (Color)this.cor, (float)e.fin());
        float ex = e.x + Mathf.randomSeed((long)e.id, (float)-4.0f, (float)4.0f);
        float ey = e.y + (float)Mathf.randomSeed((long)e.id, (int)-4, (int)4);
        Fill.circle((float)ex, (float)ey, (float)(4.2f * e.fout()));
    });

    public MagneticStormBulletType(Color c1, Color c2) {
        this.cor = c1;
        this.liC = c2;
        this.absorbable = false;
        ExplosionEffect expEffSmall = new ExplosionEffect(){
            {
                this.lifetime = 20.0f;
                this.waveLife = 12.0f;
                this.waveStroke = 2.0f;
                this.waveColor = MagneticStormBulletType.this.liC;
                this.waveRad = 12.0f;
                this.smokeSize = 2.0f;
                this.smokes = 4;
                this.sparks = 3;
                this.sparkStroke = 1.0f;
                this.sparkLen = 3.0f;
                this.smokeRad = 15.0f;
                this.sparkRad = 15.0f;
                this.smokeColor = MagneticStormBulletType.this.cor;
                this.sparkColor = MagneticStormBulletType.this.liC;
            }
        };
        this.intervalBullet = new BulletType((Effect)expEffSmall){
            final /* synthetic */ Effect val$expEffSmall;
            {
                this.val$expEffSmall = effect;
                this.lifetime = 120.0f;
                this.speed = 4.0f;
                this.damage = 50.0f;
                this.keepVelocity = false;
                this.trailColor = MagneticStormBulletType.this.liC;
                this.trailWidth = 0.0f;
                this.trailLength = 18;
                this.splashDamage = 50.0f;
                this.splashDamageRadius = 15.0f;
                this.hitEffect = this.val$expEffSmall;
                this.despawnEffect = Fx.none;
                this.buildingDamageMultiplier = 0.5f;
            }

            public void update(Bullet b) {
                super.update(b);
                if (!(b instanceof mgs)) {
                    return;
                }
                mgs mgs2 = (mgs)b;
                Teamc target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)80.0f, e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> t != null && this.collidesGround && !b.hasCollided(t.id));
                if (b.time < 30.0f || target == null) {
                    b.initVel(b.rotation(), this.speed * 1.5f * Math.max(0.0f, 1.0f - b.fin() * 3.0f));
                } else {
                    b.initVel(b.angleTo((Position)target), this.speed);
                }
                for (int i = 0; i < 2; ++i) {
                    if (!Vars.headless) {
                        if (mgs2.trails[i] == null) {
                            mgs2.trails[i] = new Trail(22);
                        }
                        mgs2.trails[i].length = 22;
                    }
                    float dx = EUGet.dx(b.x, 10.0f, b.time * (8.0f - (i % 2 == 0 ? 0.6f : 0.0f)) + Mathf.randomSeed((long)b.id, (float)360.0f) + (float)(180 * i));
                    float dy = EUGet.dy(b.y, 10.0f, b.time * (8.0f - (i % 2 != 0 ? 0.6f : 0.0f)) + Mathf.randomSeed((long)b.id, (float)360.0f) + (float)(180 * i));
                    if (!Vars.headless) {
                        mgs2.trails[i].update(dx, dy, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
                    }
                    if (mgs2.vs[i] == null) continue;
                    mgs2.vs[i].set(dx, dy);
                }
            }

            public void draw(Bullet b) {
                super.draw(b);
                float vel = Math.max(0.0f, b.vel.len() / this.speed);
                float out = b.time > b.lifetime - 12.0f ? (b.lifetime - b.time) / 12.0f : 1.0f;
                Draw.color((Color)this.trailColor);
                Drawf.tri((float)b.x, (float)b.y, (float)4.0f, (float)(7.0f * vel), (float)b.rotation());
                Fill.circle((float)b.x, (float)b.y, (float)(6.0f * (1.0f - vel) * out));
                if (!(b instanceof mgs)) {
                    return;
                }
                mgs mgs2 = (mgs)b;
                float z = Draw.z();
                Draw.z((float)(z - 1.0E-4f));
                for (int i = 0; i < 2; ++i) {
                    if (MagneticStormBulletType.this.msTl > 0 && mgs2.trails[i] != null) {
                        mgs2.trails[i].draw(i % 2 == 0 ? MagneticStormBulletType.this.liC : MagneticStormBulletType.this.cor, 1.2f * (1.0f - vel) * out);
                    }
                    if (mgs2.vs[i] == null) continue;
                    Draw.color((Color)(i % 2 == 0 ? MagneticStormBulletType.this.liC : MagneticStormBulletType.this.cor));
                    Fill.circle((float)mgs2.vs[i].x, (float)mgs2.vs[i].y, (float)(1.2f * (1.0f - vel) * out));
                }
                Draw.z((float)z);
            }

            public void drawTrail(Bullet b) {
                if (this.trailLength > 0 && b.trail != null) {
                    float z = Draw.z();
                    Draw.z((float)(z - 1.0E-4f));
                    b.trail.draw(this.trailColor, 3.1f);
                    Draw.z((float)z);
                }
            }

            public void init(Bullet b) {
                super.init(b);
                if (!(b instanceof mgs)) {
                    return;
                }
                mgs mgs2 = (mgs)b;
                for (int i = 0; i < 2; ++i) {
                    mgs2.vs[i] = new Vec2();
                }
            }

            public boolean testCollision(Bullet bullet, Building tile) {
                return bullet.time > 30.0f && super.testCollision(bullet, tile);
            }

            @Nullable
            public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
                mgs bullet = mgs.create();
                for (int i = 0; i < 2; ++i) {
                    if (bullet.trails[i] == null) continue;
                    bullet.trails[i].clear();
                }
                return EUGet.anyOtherCreate(bullet, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
            }
        };
        this.intervalBullets = 3;
        this.bulletInterval = 30.0f;
        this.lightning = new ChainLightningFade(12.0f, 12.0f, 2.5f, this.cor, 20.0f, Fx.hitLancer){
            {
                this.buildingDamageMultiplier = 0.15f - (ExtraUtilitiesMod.hardMod ? 0.1f : 0.0f);
            }
        };
        this.despawnEffect = new MultiEffect(new Effect[]{EUFx.StormExp(this.cor, this.liC)});
        this.fragBullet = new BulletType((Effect)expEffSmall){
            final /* synthetic */ Effect val$expEffSmall;
            {
                this.val$expEffSmall = effect;
                this.speed = 3.2f;
                this.lifetime = 72.0f;
                this.damage = 20.0f;
                this.intervalBullets = 2;
                this.intervalBullet = new ChainLightningFade(12.0f, 12.0f, 2.5f, MagneticStormBulletType.this.cor, 20.0f, Fx.hitLancer){
                    {
                        this.despawnEffect = val$expEffSmall;
                        this.splashDamage = 30.0f;
                        this.splashDamageRadius = 15.0f;
                        this.buildingDamageMultiplier = 0.15f - (ExtraUtilitiesMod.hardMod ? 0.1f : 0.0f);
                        this.collidesTiles = false;
                        this.back = true;
                    }
                };
                this.bulletInterval = 7.2f;
                this.hitEffect = Fx.hitLancer;
                this.despawnEffect = Fx.none;
                this.keepVelocity = false;
                this.hittable = false;
                this.absorbable = false;
                this.pierce = true;
                this.pierceBuilding = true;
                this.trailWidth = 0.0f;
                this.trailLength = 25;
                this.trailEffect = MagneticStormBulletType.this.tef;
                this.trailInterval = 1.0f;
                this.buildingDamageMultiplier = 0.5f;
            }

            public void update(Bullet b) {
                super.update(b);
                b.rotation(b.rotation() - Time.delta * 3.7f);
            }

            public void updateBulletInterval(Bullet b) {
                Object object = b.data;
                if (!(object instanceof Position)) {
                    return;
                }
                Position pos = (Position)object;
                if (b.timer.get(2, this.bulletInterval)) {
                    float px = b.x + (float)Mathf.random((int)-80, (int)80);
                    float py = b.y + (float)Mathf.random((int)-80, (int)80);
                    this.intervalBullet.create((Entityc)b, b.team, b.x, b.y, b.angleTo(pos), -1.0f, 1.0f, 1.0f, (Object)pos);
                    this.intervalBullet.create((Entityc)b, b.team, px, py, b.angleTo(px, py) + 180.0f, -1.0f, 1.0f, 1.0f, (Object)b);
                    Sounds.spark.at(b.x, b.y, 3.0f, 0.4f);
                }
            }

            public void drawTrail(Bullet b) {
                if (this.trailLength > 0 && b.trail != null) {
                    float d = b.time < b.lifetime / 2.0f ? b.fin() * 2.0f : b.fout() * 2.0f;
                    float z = Draw.z();
                    Draw.z((float)(z - 1.0E-4f));
                    b.trail.draw(Tmp.c4.set(MagneticStormBulletType.this.liC).lerp(MagneticStormBulletType.this.cor, b.fin()), 3.5f * d + 1.0f);
                    Draw.z((float)z);
                }
            }

            public void draw(Bullet b) {
                super.draw(b);
                float d = b.time < b.lifetime / 2.0f ? b.fin() * 2.0f : b.fout() * 2.0f;
                Draw.color((Color)MagneticStormBulletType.this.liC, (Color)MagneticStormBulletType.this.cor, (float)b.fin());
                Fill.circle((float)b.x, (float)b.y, (float)(2.5f * d + 1.0f));
            }
        };
        this.fragBullets = 6;
    }

    public MagneticStormBulletType() {
    }

    public void update(Bullet b) {
        int i;
        boolean able;
        this.updateHoming(b);
        boolean bl = able = !Vars.headless && this.msTl > 0;
        if (!(b instanceof mgs)) {
            return;
        }
        mgs mgs2 = (mgs)b;
        int p = 0;
        for (int s = 0; s < 3; ++s) {
            for (int a : Mathf.signs) {
                if (able) {
                    if (mgs2.trails[p] == null) {
                        mgs2.trails[p] = new Trail(this.msTl);
                    }
                    mgs2.trails[p].length = this.msTl;
                }
                float dx = EUGet.dx(b.x, 40 - 12 * s, b.time * 6.0f * (float)a + Mathf.randomSeed((long)b.id, (float)360.0f) + (float)(120 * s));
                float dy = EUGet.dy(b.y, 40 - 12 * s, b.time * 5.8f * (float)a + Mathf.randomSeed((long)b.id, (float)360.0f) + (float)(120 * s));
                if (able) {
                    mgs2.trails[p].update(dx, dy, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
                }
                if (mgs2.vs[p] != null) {
                    mgs2.vs[p].set(dx, dy);
                }
                ++p;
            }
        }
        if (b.timer.get(1, 12.0f)) {
            for (i = 0; i < 6; ++i) {
                Vec2 v = mgs2.vs[i];
                if (v != null) {
                    Lightning.create((Team)b.team, (Color)(i % 2 == 0 ? this.liC : this.cor), (float)this.damages[1], (float)v.x, (float)v.y, (float)v.angleTo((Position)b), (int)((int)v.dst((Position)b) / 8 + 1));
                    Lightning.create((Team)b.team, (Color)(i % 2 == 0 ? this.cor : this.liC), (float)this.damages[2], (float)b.x, (float)b.y, (float)b.angleTo((Position)v), (int)((int)v.dst((Position)b) / 8 + 1));
                }
                Lightning.create((Team)b.team, (Color)this.cor, (float)this.damages[3], (float)(b.x + (float)Mathf.random((int)-40, (int)40)), (float)(b.y + (float)Mathf.random((int)-40, (int)40)), (float)Mathf.random((int)360), (int)Mathf.random((int)3, (int)7));
            }
        }
        if (b.timer.get(2, 9.0f)) {
            Groups.bullet.intersect(b.x - this.dsRange, b.y - this.dsRange, this.dsRange * 2.0f, this.dsRange * 2.0f, ob -> {
                if (ob instanceof mgs && ob.within((Position)b, this.dsRange) && ob.team == b.team && ob != b) {
                    float bdx = b.x + (float)Mathf.random((int)-20, (int)20);
                    float bdy = b.y + (float)Mathf.random((int)-20, (int)20);
                    this.lightning.create((Entityc)b, b.team, bdx, bdy, ob.angleTo(bdx, bdy) + 180.0f, -1.0f, 1.0f, 1.0f, ob);
                }
            });
            Sounds.spark.at(b.x, b.y, 3.0f, 0.4f);
        }
        if (b.timer.get(3, this.bulletInterval)) {
            for (i = 0; i < this.intervalBullets; ++i) {
                this.intervalBullet.create(b, b.x, b.y, (float)Mathf.random((int)360));
            }
        }
    }

    public void init(Bullet b) {
        super.init(b);
        if (!(b instanceof mgs)) {
            return;
        }
        mgs mgs2 = (mgs)b;
        for (int i = 0; i < 6; ++i) {
            mgs2.vs[i] = new Vec2();
        }
    }

    public void draw(Bullet b) {
        int plasmas = 6;
        for (int i = 0; i < plasmas; ++i) {
            Draw.color((Color)this.liC, (Color)this.cor, (float)((float)i / 6.0f));
            Draw.alpha((float)(0.3f + Mathf.absin((float)Time.time, (float)(2.0f + (float)i * 2.0f), (float)(0.3f + (float)i * 0.05f))));
            Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.ModName + "-plasma-" + i), (float)b.x, (float)b.y, (float)this.width, (float)this.height, (float)(Time.time * (float)(12 + i * 6)));
        }
        if (!(b instanceof mgs)) {
            return;
        }
        mgs mgs2 = (mgs)b;
        float z = Draw.z();
        Draw.z((float)(z - 1.0E-4f));
        for (int i = 0; i < 6; ++i) {
            if (this.msTl > 0 && mgs2.trails[i] != null) {
                mgs2.trails[i].draw(i % 2 == 0 ? this.liC : this.cor, 2.5f * b.fout() + 2.0f);
            }
            if (mgs2.vs[i] == null) continue;
            Draw.color((Color)(i % 2 == 0 ? this.liC : this.cor));
            Fill.circle((float)mgs2.vs[i].x, (float)mgs2.vs[i].y, (float)(1.5f * b.fout() + 2.0f));
        }
        Draw.z((float)z);
    }

    public void createFrags(Bullet b, float x, float y) {
        Bullet psb = EUBulletTypes.setPos.create(b, b.x, b.y, 0.0f);
        for (int i = 0; i < this.fragBullets; ++i) {
            float a = Mathf.randomSeed((long)b.id, (float)360.0f) + (float)(60 * i);
            this.fragBullet.create((Entityc)b, b.team, b.x, b.y, a, -1.0f, 1.0f, 1.0f, (Object)psb);
        }
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        mgs bullet = mgs.create();
        for (int i = 0; i < 6; ++i) {
            if (bullet.trails[i] == null) continue;
            bullet.trails[i].clear();
        }
        return EUGet.anyOtherCreate(bullet, (BulletType)this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
    }

    public static class mgs
    extends Bullet {
        @Nullable
        public Trail[] trails = new Trail[6];
        public Vec2[] vs = new Vec2[6];

        public static mgs create() {
            return (mgs)((Object)Pools.obtain(mgs.class, mgs::new));
        }
    }
}

