/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.worlds.blocks.liquid.LiquidMassDriver;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.geom.Position;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;

public class LiquidMassDriverBolt
extends BulletType {
    public LiquidMassDriverBolt() {
        super(1.0f, 75.0f);
        this.collidesTiles = false;
        this.lifetime = 1.0f;
        this.despawnEffect = Fx.smeltsmoke;
        this.hitEffect = Fx.hitBulletBig;
    }

    public void draw(Bullet b) {
        Object object = b.data();
        if (!(object instanceof LiquidMassDriver.LiquidBulletData)) {
            return;
        }
        LiquidMassDriver.LiquidBulletData data = (LiquidMassDriver.LiquidBulletData)object;
        float mid = 100.0f;
        float p = Math.min((int)(data.amount / mid) + 1, 3);
        float w = 4.0f * p;
        float h = 5.0f * p;
        Draw.color((Color)data.liquid.color);
        Draw.rect((String)"shell-back", (float)b.x, (float)b.y, (float)w, (float)h, (float)(b.rotation() + 90.0f));
        Draw.rect((String)"shell", (float)b.x, (float)b.y, (float)w, (float)h, (float)(b.rotation() + 90.0f));
        Draw.reset();
    }

    public void update(Bullet b) {
        float baseAngle;
        float angleTo;
        Object object = b.data();
        if (!(object instanceof LiquidMassDriver.LiquidBulletData)) {
            this.hit(b);
            return;
        }
        LiquidMassDriver.LiquidBulletData data = (LiquidMassDriver.LiquidBulletData)object;
        float hitDst = 7.0f;
        if (data.to.dead()) {
            return;
        }
        float baseDst = data.from.dst((Position)data.to);
        float dst1 = b.dst((Position)data.from);
        float dst2 = b.dst((Position)data.to);
        boolean intersect = false;
        if (dst1 > baseDst && Angles.near((float)(angleTo = b.angleTo((Position)data.to)), (float)(baseAngle = data.to.angleTo((Position)data.from)), (float)2.0f)) {
            intersect = true;
            b.set(data.to.x + Angles.trnsx((float)baseAngle, (float)hitDst), data.to.y + Angles.trnsy((float)baseAngle, (float)hitDst));
        }
        if (Math.abs(dst1 + dst2 - baseDst) < 4.0f && dst2 <= hitDst) {
            intersect = true;
        }
        if (intersect) {
            data.to.handlePayload(b, data);
        }
    }

    public void despawned(Bullet b) {
        super.despawned(b);
        Object object = b.data();
        if (!(object instanceof LiquidMassDriver.LiquidBulletData)) {
            return;
        }
        LiquidMassDriver.LiquidBulletData data = (LiquidMassDriver.LiquidBulletData)object;
        Fx.hitLiquid.at(b.x, b.y, b.rotation(), data.liquid.color);
    }

    public void hit(Bullet b, float x, float y) {
        super.hit(b, x, y);
        this.despawned(b);
    }
}

