/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUGet;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.effect.ExplosionEffect;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;

public class FireWorkBullet
extends BulletType {
    public String sprite;
    public boolean colorful = false;
    public boolean childColorful = true;
    public Color[] colors = new Color[]{Color.valueOf((String)"FF4B4B"), Color.valueOf((String)"FEFF4A"), Color.valueOf((String)"724AFF"), Color.valueOf((String)"89C2FF"), Color.valueOf((String)"39c5bb"), Color.white};
    public Color color;
    public boolean outline = false;
    public float width = 15.0f;
    public float height = 15.0f;
    public boolean breaker = false;
    public int num = 30;
    @Nullable
    public BulletType fire;
    @Nullable
    public BulletType textFire = null;
    public TextureRegion ammo;

    public FireWorkBullet(float damage, float speed, String sprite, final Color color, final float rad) {
        this.damage = damage;
        this.speed = speed;
        this.sprite = sprite;
        this.color = color;
        this.trailColor = color;
        this.trailInterval = 3.0f;
        this.splashDamage = damage;
        this.splashDamageRadius = rad;
        this.hitEffect = this.despawnEffect = new ExplosionEffect(){
            {
                this.lifetime = 60.0f;
                this.waveStroke = 5.0f;
                this.waveLife = 8.0f;
                this.waveColor = Color.white;
                this.sparkColor = color;
                this.smokeColor = Pal.darkerGray;
                this.waveRad = rad;
                this.smokeSize = rad / 8.0f;
                this.smokes = 7;
                this.smokeSizeBase = 0.0f;
                this.sparks = 10;
                this.sparkRad = rad;
                this.sparkLen = 6.0f;
                this.sparkStroke = 2.0f;
            }
        };
        this.shootEffect = Fx.none;
        this.smokeEffect = Fx.none;
        this.despawnSound = this.hitSound = Sounds.bang;
        this.lifetime = 50.0f;
        this.ammoMultiplier = 1.0f;
        this.status = StatusEffects.blasted;
        this.statusDuration = 180.0f;
        this.fire = new colorFire(true);
    }

    public FireWorkBullet(float damage, float speed, Color color) {
        this(damage, speed, ExtraUtilitiesMod.name("mb-b"), color, 48.0f);
    }

    public FireWorkBullet(float damage, float speed) {
        this(damage, speed, ExtraUtilitiesMod.name("mb-b"), Color.gray, 48.0f);
    }

    public void load() {
        super.load();
        this.ammo = Core.atlas.find(this.sprite);
    }

    public void drawTrail(Bullet b) {
        if (this.trailLength > 0 && b.trail != null) {
            float z = Draw.z();
            Draw.z((float)(z - 1.0E-4f));
            b.trail.draw(this.colorful ? EUGet.EC1.set(EUGet.rainBowRed).a(0.7f).shiftHue(b.time * 2.0f) : this.color, this.trailWidth);
            Draw.z((float)z);
        }
    }

    public void draw(Bullet b) {
        super.draw(b);
        if (this.outline) {
            Draw.color((Color)(this.colorful ? EUGet.EC2.set(EUGet.rainBowRed).shiftHue(b.time * 2.0f) : this.color));
            Draw.rect((TextureRegion)this.ammo, (float)b.x, (float)b.y, (float)(this.width * 1.1f), (float)(this.height * 1.1f), (float)(b.rotation() - 90.0f));
            Draw.color((Color)Color.darkGray);
            Draw.rect((TextureRegion)this.ammo, (float)b.x, (float)b.y, (float)(this.width * 0.8f), (float)(this.height * 0.8f), (float)(b.rotation() - 90.0f));
        } else {
            Draw.color((Color)(this.colorful ? EUGet.EC2.set(EUGet.rainBowRed).shiftHue(b.time * 2.0f) : this.color));
            Draw.rect((TextureRegion)this.ammo, (float)b.x, (float)b.y, (float)this.width, (float)this.height, (float)(b.rotation() - 90.0f));
        }
        Draw.reset();
    }

    public void hitEntity(Bullet b, Hitboxc entity, float health) {
        super.hitEntity(b, entity, health);
        if (!this.pierce || b.collided.size >= this.pierceCap) {
            this.explode(b);
        }
    }

    public void hit(Bullet b) {
        super.hit(b);
        this.explode(b);
    }

    public void explode(Bullet b) {
        if (this.fire == null) {
            return;
        }
        for (int i = 0; i < this.num; ++i) {
            if (this.colorful && this.childColorful) {
                Color c = this.colors[Mathf.random((int)0, (int)(this.colors.length - 1))];
                this.fire.create((Entityc)b, b.team, b.x, b.y, (float)Mathf.random((int)360), -1.0f, 1.0f, 1.0f, (Object)c);
                continue;
            }
            this.fire.create((Entityc)b, b.team, b.x, b.y, (float)Mathf.random((int)360), -1.0f, 1.0f, 1.0f, (Object)this.color);
        }
        if (this.textFire != null) {
            if (this.colorful) {
                Color c = this.colors[Mathf.random((int)0, (int)(this.colors.length - 1))];
                this.textFire.create((Entityc)b, b.team, b.x, b.y, 0.0f, -1.0f, 1.0f, 1.0f, (Object)c);
            } else {
                this.textFire.create((Entityc)b, b.team, b.x, b.y, 0.0f, -1.0f, 1.0f, 1.0f, (Object)this.color);
            }
        }
    }

    public static class colorFire
    extends BulletType {
        public boolean stop;
        public float stopFrom = 0.3f;
        public float stopTo = 0.6f;
        public float rotSpeed = 4.0f;
        public float speedRod = 1.0f;

        public colorFire(boolean stop, float speed, float lifetime) {
            this.stop = stop;
            this.damage = 0.0f;
            this.collidesGround = false;
            this.collidesAir = false;
            this.collides = false;
            this.speed = speed;
            this.lifetime = lifetime;
            this.trailWidth = 1.7f;
            this.trailLength = 6;
            this.hitEffect = this.despawnEffect = Fx.none;
            this.reflectable = false;
            this.hittable = false;
            this.absorbable = false;
            this.keepVelocity = false;
        }

        public colorFire(boolean stop) {
            this(stop, 5.0f, 60.0f);
        }

        public void update(Bullet b) {
            super.update(b);
            if (this.stop) {
                b.initVel(b.rotation(), this.speed * Math.max(b.fout() - Mathf.random((float)this.stopFrom, (float)this.stopTo), 0.0f) * Mathf.random((float)this.speedRod, (float)1.0f));
            } else {
                b.initVel(b.rotation(), this.speed * b.fout() * Mathf.random((float)this.speedRod, (float)1.0f));
                b.rotation(Angles.moveToward((float)b.rotation(), (float)-90.0f, (float)(this.rotSpeed * Math.max(b.fin() - Mathf.random((float)this.stopFrom, (float)this.stopTo), 0.0f))));
            }
        }

        public void draw(Bullet b) {
            super.draw(b);
            if (!(b.data instanceof Color)) {
                return;
            }
            Draw.color((Color)(b.data == Color.white ? EUGet.EC18.set(EUGet.rainBowRed).shiftHue(b.time * 2.0f) : (Color)b.data));
            Draw.z((float)100.0f);
            for (int i = 0; i < 4; ++i) {
                Drawf.tri((float)b.x, (float)b.y, (float)1.6f, (float)2.2f, (float)(b.rotation() + (float)(90 * i)));
            }
            Draw.reset();
        }

        public void drawTrail(Bullet b) {
            if (this.trailLength > 0 && b.trail != null) {
                float z = Draw.z();
                Draw.z((float)(z - 1.0E-4f));
                b.trail.draw(b.data == Color.white ? EUGet.EC19.set(EUGet.rainBowRed).shiftHue(b.time * 2.0f) : (Color)b.data, this.trailWidth);
                Draw.z((float)z);
            }
        }
    }

    public static class spriteBullet
    extends BulletType {
        public String sprite;
        public float width;
        public float height;
        public TextureRegion string;

        public spriteBullet(String sprite, float width, float height) {
            this.sprite = sprite;
            this.width = width;
            this.height = height;
            this.damage = 0.0f;
            this.collidesGround = false;
            this.collidesAir = false;
            this.collides = false;
            this.speed = 0.0f;
            this.lifetime = 60.0f;
            this.hitEffect = this.despawnEffect = Fx.none;
            this.hittable = false;
            this.absorbable = false;
            this.reflectable = false;
            this.keepVelocity = false;
        }

        public spriteBullet(String sprite) {
            this(sprite, 96.0f, 96.0f);
        }

        public void load() {
            super.load();
            this.string = Core.atlas.find(this.sprite);
        }

        public void draw(Bullet b) {
            super.draw(b);
            if (!(b.data instanceof Color)) {
                return;
            }
            Draw.z((float)100.0f);
            Draw.color((Color)(b.data == Color.white ? EUGet.EC20.set(EUGet.rainBowRed).shiftHue(b.time * 2.0f) : (Color)b.data));
            Draw.rect((TextureRegion)this.string, (float)b.x, (float)b.y, (float)(this.width * b.fout()), (float)(this.height * b.fout()), (float)0.0f);
        }
    }
}

