/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.ability;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUGet;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.ui.Styles;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class RepairField
extends Ability {
    public float range = 200.0f;
    public float reload = 180.0f;
    public float rotSpeed = 0.9f;
    public float unitHeal = 100.0f;
    public float blockHealPercent = 10.0f;
    public Color color = Pal.heal;
    public Effect healFx = new Effect(50.0f, e -> {
        Draw.color((Color)Pal.heal);
        Angles.randLenVectors((long)e.id, (int)3, (float)(8.0f * e.finpow()), (float)e.rotation, (float)360.0f, (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(6.0f * e.foutpow())));
    });
    public float fxChance = 0.05f;
    public StatusEffect status = StatusEffects.none;
    protected float timer = 0.0f;
    protected boolean healing;
    protected boolean wasHeal;
    protected float warmup = 0.0f;
    protected float remoteTime;

    public String localized() {
        return Core.bundle.format("ability." + ExtraUtilitiesMod.name("RepairFieldAbility"), new Object[0]);
    }

    public void update(Unit unit) {
        this.healing = false;
        Units.nearby((Team)unit.team, (float)unit.x, (float)unit.y, (float)this.range, u -> {
            if (u != unit && this.status != StatusEffects.none) {
                u.apply(this.status, 60.0f);
            }
            if (this.unitHeal > 0.0f && !u.dead && u.health < u.maxHealth) {
                u.heal(this.unitHeal / 60.0f * Time.delta);
                if (Mathf.chance((double)this.fxChance)) {
                    this.healFx.at(u.x + Mathf.random((float)(-u.hitSize / 2.0f), (float)(u.hitSize / 2.0f)), u.y + Mathf.random((float)(-u.hitSize / 2.0f), (float)(u.hitSize / 2.0f)));
                }
                this.healing = true;
            }
        });
        Vars.indexer.eachBlock((Teamc)unit, this.range, b -> b.damaged() && !b.isHealSuppressed(), other -> {
            this.healing = true;
        });
        this.timer += Time.delta;
        if (this.timer >= this.reload) {
            this.timer -= this.reload;
            Vars.indexer.eachBlock((Teamc)unit, this.range, b -> b.damaged() && !b.isHealSuppressed(), other -> {
                other.heal(other.maxHealth() * this.blockHealPercent / 100.0f);
                other.recentlyHealed();
                Fx.healBlockFull.at(other.x, other.y, (float)other.block.size, this.color, (Object)other.block);
            });
        }
        this.wasHeal = this.healing;
    }

    public void draw(Unit unit) {
        if (!Vars.state.isPaused()) {
            if (this.wasHeal) {
                this.remoteTime = (this.remoteTime + Time.delta * this.rotSpeed) % 360.0f;
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)1.0f, (float)0.02f);
            } else {
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)0.06f);
            }
        }
        Lines.stroke((float)(2.0f * this.warmup), (Color)this.color);
        Lines.circle((float)unit.x, (float)unit.y, (float)this.range);
        Draw.alpha((float)(0.05f * this.warmup));
        Fill.circle((float)unit.x, (float)unit.y, (float)this.range);
        float ag = 20.0f * this.warmup;
        int i = 0;
        while ((float)i < ag) {
            Draw.alpha((float)((1.0f - (float)i / ag) * this.warmup));
            float r = this.remoteTime - (float)i + 0.1f;
            float tx = unit.x + Angles.trnsx((float)r, (float)this.range);
            float ty = unit.y + Angles.trnsy((float)r, (float)this.range);
            Drawf.tri((float)tx, (float)ty, (float)(2.0f * this.range * (float)Math.tan(Math.PI / 360)), (float)this.range, (float)(r - 180.0f));
            ++i;
        }
        Draw.reset();
    }

    public void addStats(Table t) {
        t.add((CharSequence)("[lightgray]" + Stat.repairSpeed.localized() + ": [white]" + Strings.autoFixed((float)this.unitHeal, (int)2) + StatUnit.perSecond.localized()));
        t.row();
        t.add((CharSequence)("[lightgray]" + Stat.repairTime.localized() + ": [white]" + Strings.autoFixed((float)(100.0f / this.blockHealPercent * this.reload / 60.0f), (int)2) + StatUnit.seconds.localized()));
        t.row();
        t.add((CharSequence)("[lightgray]" + Stat.range.localized() + ": [white]" + Strings.autoFixed((float)(this.range / 8.0f), (int)2) + " " + StatUnit.blocks.localized()));
        t.row();
        if (this.status == StatusEffects.none) {
            return;
        }
        t.add((CharSequence)"[lightgray]status: ").row();
        t.table(i -> {
            i.add((Element)EUGet.selfStyleImageButton((Drawable)new TextureRegionDrawable(this.status.uiIcon), Styles.emptyi, () -> Vars.ui.content.show((UnlockableContent)this.status))).size(24.0f);
            i.add((CharSequence)("[white]" + this.status.localizedName + "[]")).padLeft(5.0f);
        });
        t.row();
    }
}

