/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;

public class DrawTri
extends DrawPart {
    public float x;
    public float y;
    public float get;
    public Color color = Color.white;
    public Color cColor = Color.white;
    public float rotateSpeed = 0.0f;
    public float r1 = 5.0f;
    public float r2 = 6.0f;
    public float maxR = 0.0f;
    public float layer = -1.0f;
    public float layerOffset = 0.0f;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public int amount = 2;
    public boolean back = false;
    public float width = 4.0f;
    public float length = 30.0f;

    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z((float)(z - 1.0E-4f));
        }
        Draw.z((float)(Draw.z() + this.layerOffset));
        float p = this.progress.getClamp(params);
        float rot = Time.time * this.rotateSpeed;
        int i = params.sideOverride == -1 ? 0 : params.sideOverride;
        float sin = Mathf.sin((float)Time.time, (float)6.0f, (float)0.6f);
        float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
        if (!this.back) {
            Tmp.v1.set(this.x * sign, this.get + this.y * p).rotate(params.rotation - 90.0f);
            Tmp.v3.set(this.x * sign, this.get).rotate(params.rotation - 90.0f);
        } else {
            Tmp.v1.set(this.x * sign, this.get).rotate(params.rotation - 90.0f);
            Tmp.v3.set(this.x * sign, this.get + this.y * p).rotate(params.rotation - 90.0f);
        }
        Tmp.v2.set(this.x * sign, this.get + this.y * p / 2.0f).rotate(params.rotation - 90.0f);
        float rx = params.x + Tmp.v1.x;
        float ry = params.y + Tmp.v1.y;
        float px = params.x + Tmp.v2.x;
        float py = params.y + Tmp.v2.y;
        float ex = params.x + Tmp.v3.x;
        float ey = params.y + Tmp.v3.y;
        Draw.color((Color)this.cColor);
        for (int a = 0; a < this.amount; ++a) {
            Drawf.tri((float)rx, (float)ry, (float)(this.width * p), (float)this.length, (float)(360.0f / (float)this.amount * (float)a + params.rotation + 90.0f + rot));
        }
        Lines.stroke((float)p);
        Lines.circle((float)rx, (float)ry, (float)(this.maxR * p));
        Draw.color((Color)this.color);
        Fill.circle((float)rx, (float)ry, (float)(this.r1 * p));
        Fill.circle((float)ex, (float)ey, (float)((this.r2 + sin) * p));
        Lines.stroke((float)((double)p > 0.001 ? 2.0f : 0.0f));
        Lines.circle((float)px, (float)py, (float)Math.abs(this.y * p / 2.0f));
    }

    public void load(String name) {
    }
}

