/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUGet;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawBlock;

public class DrawLA
extends DrawBlock {
    public Color color;
    public float move;
    public BulletType lightBullet = new BulletType(){
        {
            this.collides = false;
            this.collidesGround = false;
            this.collidesAir = false;
            this.absorbable = false;
            this.hittable = false;
            this.lifetime = 240.0f;
            this.speed = 5.0f;
            this.trailLength = 15;
            this.trailWidth = 1.3f;
            this.despawnEffect = Fx.none;
        }

        public void update(Bullet b) {
            Object object;
            super.update(b);
            if (b.time > 10.0f && b.time <= 30.0f) {
                b.rotation(b.rotation() + 18.0f * Time.delta);
            }
            if (b.time > 33.0f && b.time <= 53.0f) {
                b.rotation(b.rotation() - 18.0f * Time.delta);
            }
            if (b.time > 63.0f && (object = b.data) instanceof Position) {
                Position pos = (Position)object;
                b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo(pos), (float)(Time.delta * 6.0f)));
                b.initVel(b.rotation(), this.speed + b.dst(pos) / 40.0f);
                if (b.within(pos, 8.0f)) {
                    b.remove();
                }
            }
        }

        public void drawTrail(Bullet b) {
            if (this.trailLength > 0 && b.trail != null) {
                float z = Draw.z();
                Draw.z((float)(z - 1.0E-4f));
                b.trail.draw(EUGet.EC17.set(EUGet.rainBowRed).shiftHue(30.0f + b.time / 4.0f), this.trailWidth);
                Draw.z((float)z);
            }
        }
    };

    public DrawLA(Color color, float move) {
        this.color = color;
        this.move = move;
        this.lightBullet.trailColor = color;
    }

    public static void drawBeam(GenericCrafter.GenericCrafterBuild build, int id, float x, float y, float rotation, float length, float strength, float beamWidth, Vec2 lastEnd, Vec2 offset, Color laserColor) {
        rand.setSeed((long)(build.id + id));
        float originX = x + Angles.trnsx((float)rotation, (float)length);
        float originY = y + Angles.trnsy((float)rotation, (float)length);
        lastEnd.set((Position)build).sub(originX, originY);
        lastEnd.setLength(Math.max(2.0f, lastEnd.len()));
        lastEnd.add(offset.trns(rand.random(360.0f) + Time.time / 2.0f, Mathf.sin((float)(Time.time + rand.random(200.0f)), (float)(15.0f / Math.max(build.efficiency, 1.0E-5f)), (float)rand.random(1.6f, 5.6f))).rotate(0.0f));
        lastEnd.add(originX, originY);
        if (strength > 0.001f) {
            Draw.alpha((float)strength);
            Lines.stroke((float)(beamWidth * strength), (Color)laserColor);
            Lines.line((float)originX, (float)originY, (float)lastEnd.x, (float)lastEnd.y);
            Fill.circle((float)lastEnd.x, (float)lastEnd.y, (float)0.7f);
            Draw.color();
        }
    }

    public void draw(Building build) {
        GenericCrafter block = (GenericCrafter)build.block;
        GenericCrafter.GenericCrafterBuild b = (GenericCrafter.GenericCrafterBuild)build;
        this.realDraw(block, b);
    }

    public void realDraw(GenericCrafter block, GenericCrafter.GenericCrafterBuild build) {
        float bx = build.x;
        float by = build.y;
        Item item = block.outputItem.item;
        Draw.alpha((float)(build.progress * 1.2f));
        Draw.rect((TextureRegion)item.uiIcon, (float)bx, (float)by);
        float sin = Mathf.sin((float)build.totalProgress, (float)(30.0f / Math.max(build.efficiency, 1.0E-5f)), (float)6.0f);
        Lines.stroke((float)build.warmup);
        Draw.color((Color)this.color);
        for (int i = -1; i <= 1; ++i) {
            if (i == 0) continue;
            Lines.lineAngleCenter((float)(bx + (float)i * sin), (float)by, (float)90.0f, (float)7.0f);
            Lines.lineAngleCenter((float)bx, (float)(by + (float)i * sin), (float)0.0f, (float)7.0f);
        }
        if (this.move == 0.0f) {
            this.move = (float)block.size / 2.0f * 8.0f;
        }
        Lines.stroke((float)1.0f);
        if (build.efficiency > 0.0f) {
            float y;
            float x;
            for (float mx : new float[]{this.move, -this.move}) {
                for (float my : new float[]{this.move, -this.move}) {
                    Draw.z((float)122.0f);
                    Draw.alpha((float)Math.max(Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f) * build.warmup(), 0.9f));
                    x = bx + mx;
                    y = by + my;
                    Drawf.buildBeam((float)x, (float)y, (float)bx, (float)by, (float)3.6f);
                }
            }
            Draw.alpha((float)build.warmup);
            for (float mx : new float[]{this.move, -this.move}) {
                for (float my : new float[]{this.move, -this.move}) {
                    Draw.color((Color)this.color);
                    Draw.z((float)110.0f);
                    x = bx + mx;
                    y = by + my;
                    Fill.circle((float)x, (float)y, (float)1.0f);
                    DrawLA.drawBeam(build, 0, x, y, Angles.angle((float)x, (float)y, (float)bx, (float)by), build.dst(x, y) * 2.0f, build.warmup, 0.8f, new Vec2(), new Vec2(), this.color);
                }
            }
            if (build.wasVisible && !Vars.state.isPaused() && Mathf.chance((double)block.updateEffectChance)) {
                float range = (float)(block.size * 8) / 2.0f;
                float x1 = bx + Mathf.random((float)(-range), (float)range);
                float x2 = bx + Mathf.random((float)(-range), (float)range);
                float y1 = by + Mathf.random((float)(-range), (float)range);
                float y2 = by + Mathf.random((float)(-range), (float)range);
                float ang = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
                float len = Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2);
                EUFx.chainLightning.at(x1, y1, ang, this.color, (Object)Float.valueOf(len));
                if (Mathf.chance((double)0.1f)) {
                    this.lightBullet.create((Entityc)build, build.team, bx, by, Mathf.random((float)360.0f), -1.0f, 1.0f, 1.0f, (Object)build);
                    Sounds.malignShoot.at(bx, by, 0.6f, 0.5f);
                }
            }
        }
        Draw.color();
    }
}

