/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret.TowerDefence;

import arc.Core;
import arc.Graphics;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.Ranged;
import mindustry.type.StatusEffect;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ItemSelection;

public class CrystalTower
extends Block {
    public float range = 200.0f;
    public float speedUp = 1.75f;
    public Color bloomColor = Color.valueOf((String)"#bf92f9");
    public boolean ctrlColor = false;

    public CrystalTower(String name) {
        super(name);
        this.solid = true;
        this.noUpdateDisabled = false;
        this.configurable = true;
        this.drawTeamOverlay = false;
        this.update = true;
        this.canOverdrive = false;
        this.privileged = true;
        this.targetable = false;
        this.underBullets = true;
        this.breakable = false;
        this.forceDark = true;
        this.config(int[].class, (tile, value) -> {
            if (!this.accessible()) {
                return;
            }
            tile.conf = value;
        });
    }

    public boolean accessible() {
        return !this.privileged || Vars.state.rules.editor || Vars.state.playtestingMap != null;
    }

    public boolean checkForceDark(Tile tile) {
        return !this.accessible();
    }

    public boolean canBreak(Tile tile) {
        return this.accessible();
    }

    public class CrystalTowerBuild
    extends Building
    implements Ranged {
        public StatusEffect statusEffect = StatusEffects.none;
        public int[] conf;

        public CrystalTowerBuild() {
            this.conf = new int[]{Pal.accent.rgba(), StatusEffects.none.id};
        }

        public void updateTile() {
            if (this.conf[1] >= Vars.content.statusEffects().size || Vars.content.statusEffects().get(this.conf[1]) == null) {
                this.statusEffect = StatusEffects.none;
                this.conf[1] = StatusEffects.none.id;
            } else {
                this.statusEffect = (StatusEffect)Vars.content.statusEffects().get(this.conf[1]);
            }
            Vars.indexer.eachBlock(null, this.x, this.y, CrystalTower.this.range, other -> other.block.canOverdrive, other -> other.applyBoost(CrystalTower.this.speedUp, 61.0f));
            Units.nearby((float)(this.x - CrystalTower.this.range), (float)(this.y - CrystalTower.this.range), (float)(CrystalTower.this.range * 2.0f), (float)(CrystalTower.this.range * 2.0f), unit -> {
                if ((this.team == Team.derelict || unit.team == this.team) && unit.within(this.x, this.y, CrystalTower.this.range + unit.hitSize / 2.0f) && this.statusEffect != null && this.statusEffect != StatusEffects.none) {
                    unit.apply(this.statusEffect, 30.0f);
                }
            });
        }

        public void draw() {
            super.draw();
            Draw.color((Color)CrystalTower.this.bloomColor);
            Draw.rect((TextureRegion)Core.atlas.find(CrystalTower.this.name + "-bloom"), (float)this.x, (float)this.y);
            Lines.stroke((float)2.0f, (Color)Tmp.c1.set(this.conf[0]));
            Lines.square((float)this.x, (float)this.y, (float)9.0f, (float)Time.time);
            Lines.square((float)this.x, (float)this.y, (float)6.0f, (float)(-Time.time));
            for (int i = 0; i < 5; ++i) {
                float rot = (float)i * 360.0f / 5.0f + Time.time * 0.8f;
                Lines.arc((float)this.x, (float)this.y, (float)CrystalTower.this.range, (float)0.15f, (float)rot);
            }
        }

        public boolean collide(Bullet other) {
            return !CrystalTower.this.privileged;
        }

        public boolean displayable() {
            return CrystalTower.this.accessible();
        }

        public void damage(float damage) {
            if (!CrystalTower.this.privileged) {
                super.damage(damage);
            }
        }

        public Graphics.Cursor getCursor() {
            return !CrystalTower.this.accessible() ? Graphics.Cursor.SystemCursor.arrow : super.getCursor();
        }

        public boolean canPickup() {
            return false;
        }

        public float range() {
            return CrystalTower.this.range;
        }

        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            if (type == LAccess.color) {
                this.conf[0] = Tmp.c1.fromDouble(p1).rgba8888();
            }
            super.control(type, p1, p2, p3, p4);
        }

        public void setConf(StatusEffect statusEffect) {
            this.conf[1] = statusEffect == null ? StatusEffects.none.id : statusEffect.id;
            this.configure(this.conf);
        }

        public void buildConfiguration(Table table) {
            if (!CrystalTower.this.accessible() && !CrystalTower.this.ctrlColor) {
                this.deselect();
                return;
            }
            if (CrystalTower.this.accessible()) {
                ItemSelection.buildTable((Block)CrystalTower.this, (Table)table, (Seq)Vars.content.statusEffects(), () -> {
                    if (Vars.content.statusEffects().get(this.conf[1]) == null) {
                        return StatusEffects.none;
                    }
                    this.statusEffect = (StatusEffect)Vars.content.statusEffects().get(this.conf[1]);
                    return this.statusEffect;
                }, this::setConf, (int)CrystalTower.this.selectionRows, (int)CrystalTower.this.selectionColumns);
            }
            table.button((Drawable)Icon.pencil, Styles.cleari, () -> {
                Vars.ui.picker.show(Tmp.c1.set(this.conf[0]).a(0.8f), false, res -> {
                    this.conf[0] = res.rgba();
                    this.configure(this.conf);
                });
                this.deselect();
            }).size(40.0f);
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                this.deselect();
                return false;
            }
            return true;
        }

        public int[] config() {
            return this.conf;
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.conf[0]);
            StatusEffect s = (StatusEffect)Vars.content.statusEffects().get(this.conf[1]);
            String name = s == null ? null : s.name;
            write.str(name);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.conf[0] = read.i();
            String s = read.str();
            this.conf[1] = s == null || Vars.content.statusEffect(s) == null ? StatusEffects.none.id : Vars.content.statusEffect((String)s).id;
        }
    }
}

