/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.ui.ItemDisplay;
import ExtraUtilities.worlds.entity.bullet.HealCone;
import arc.func.Boolf;
import arc.math.Mathf;
import arc.scene.Element;
import arc.util.Strings;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Healthc;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.ui.Styles;
import mindustry.world.blocks.defense.turrets.ContinuousTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class MendTurret
extends ContinuousTurret {
    public float amountBoost = 0.5f;
    public float angleBoost = 0.25f;
    public float consTime = 240.0f;

    public MendTurret(String name) {
        super(name);
    }

    public void setStats() {
        this.stats.timePeriod = this.consTime;
        super.setStats();
        this.stats.remove(Stat.ammo);
        this.stats.remove(Stat.targetsGround);
        this.stats.remove(Stat.targetsAir);
        BulletType bulletType = this.shootType;
        if (bulletType instanceof HealCone) {
            HealCone hc = (HealCone)bulletType;
            this.stats.add(Stat.repairSpeed, hc.percentHeal ? hc.healPercent : hc.healAmount, hc.percentHeal ? StatUnit.percent : StatUnit.perSecond);
            this.stats.add(Stat.repairSpeed, t -> t.add((CharSequence)(Strings.autoFixed((float)hc.findAngle, (int)1) + "\u00b0")));
            Consume consume = this.findConsumer(c -> c instanceof ConsumeItems);
            if (consume instanceof ConsumeItems) {
                ConsumeItems cons = (ConsumeItems)consume;
                this.stats.remove(Stat.booster);
                this.stats.add(Stat.booster, table -> {
                    table.row();
                    Boolf cs = arg_0 -> ((MendTurret)this).consumesItem(arg_0);
                    table.table(c -> {
                        for (Item item : Vars.content.items()) {
                            if (!cs.get((Object)item)) continue;
                            c.table(Styles.grayPanel, b -> {
                                for (ItemStack stack : cons.items) {
                                    if (this.stats.timePeriod < 0.0f) {
                                        b.add((Element)new ItemDisplay(stack.item, stack.amount, true)).pad(20.0f).left();
                                    } else {
                                        b.add((Element)new ItemDisplay(stack.item, stack.amount, this.stats.timePeriod, true)).pad(20.0f).left();
                                    }
                                    if (cons.items.length <= 1) continue;
                                    b.row();
                                }
                                b.table(bt -> {
                                    bt.right().defaults().padRight(3.0f).left();
                                    if (this.angleBoost != 0.0f) {
                                        bt.add((CharSequence)("[lightgray]+ [stat]" + Strings.autoFixed((float)(this.angleBoost * hc.findAngle), (int)2) + "[lightgray]\u00b0")).row();
                                    }
                                    if (this.amountBoost != 0.0f) {
                                        if (hc.percentHeal) {
                                            bt.add((CharSequence)("[lightgray]+ [stat]" + Strings.autoFixed((float)(this.amountBoost * hc.healPercent), (int)2) + "[lightgray]" + StatUnit.percent.localized() + Stat.repairSpeed.localized()));
                                        } else {
                                            bt.add((CharSequence)("[lightgray]+ [stat]" + Strings.autoFixed((float)(this.amountBoost * hc.healAmount), (int)2) + " [lightgray]" + Stat.repairSpeed.localized()));
                                        }
                                    }
                                }).right().grow().pad(10.0f).padRight(15.0f);
                            }).growX().pad(5.0f).padBottom(-5.0f).row();
                        }
                    }).growX().colspan(table.getColumns());
                    table.row();
                });
            }
        }
    }

    public class MendTurretBuild
    extends ContinuousTurret.ContinuousTurretBuild {
        public float timerCons;
        public float boostWarmup;

        public MendTurretBuild() {
            super((ContinuousTurret)MendTurret.this);
            this.timerCons = 0.0f;
            this.boostWarmup = 0.0f;
        }

        public void updateTile() {
            super.updateTile();
            if (this.items.any()) {
                this.boostWarmup = Mathf.lerpDelta((float)this.boostWarmup, (float)1.0f, (float)0.04f);
                if (this.canConsume() && this.shouldConsume()) {
                    this.timerCons += this.edelta();
                }
            } else {
                this.boostWarmup = Mathf.lerpDelta((float)this.boostWarmup, (float)0.0f, (float)0.08f);
            }
            if (this.timerCons >= MendTurret.this.consTime) {
                this.consume();
                this.timerCons = 0.0f;
            }
        }

        protected void findTarget() {
            float range = this.range();
            this.target = Units.findAllyTile((Team)this.team, (float)this.x, (float)this.y, (float)range, b -> b.health < b.maxHealth - 0.001f && b != this);
            if (this.target != null) {
                return;
            }
            this.target = Units.closest((Team)this.team, (float)this.x, (float)this.y, (float)range, Healthc::damaged);
        }

        protected boolean validateTarget() {
            return this.target != null || this.isControlled() || this.logicControlled();
        }

        protected void updateBullet(Turret.BulletEntry entry) {
            super.updateBullet(entry);
            if (this.isShooting() && this.hasAmmo()) {
                entry.bullet.data = Float.valueOf(this.angleMti());
            }
        }

        public float angleMti() {
            return this.efficiency * (1.0f + MendTurret.this.angleBoost * this.boostWarmup);
        }

        public float amountMti() {
            float boost = MendTurret.this.amountBoost * this.boostWarmup;
            float scale = this.timeScale > 1.0f ? boost + this.timeScale - 1.0f : boost * this.timeScale;
            return this.efficiency * (1.0f + scale);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.timerCons);
            write.f(this.boostWarmup);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.timerCons = read.f();
            this.boostWarmup = read.f();
        }
    }
}

