/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.production;

import arc.math.Mathf;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.consumers.ConsumeLiquids;
import mindustry.world.consumers.ConsumeLiquidsDynamic;

public class Randomer
extends Block {
    public int itemsPerSecond = 60000;
    public float powerProduction = 16666.666f;
    public float heat = 1000.0f;

    public Randomer(String name) {
        super(name);
        this.hasItems = true;
        this.update = true;
        this.solid = true;
        this.noUpdateDisabled = true;
        this.envEnabled = -1;
        this.alwaysReplace = true;
        this.hasPower = true;
        this.consumesPower = false;
        this.outputsPower = true;
    }

    public void setBars() {
        super.setBars();
        this.removeBar("items");
    }

    public boolean outputsItems() {
        return true;
    }

    public class RandomBuild
    extends Building
    implements HeatBlock {
        public float counter;

        public void updateTile() {
            int r = Mathf.random((int)Vars.content.items().size);
            Item outputItem = Vars.content.item(r);
            int l = Mathf.random((int)Vars.content.liquids().size);
            Liquid outLiquid = Vars.content.liquid(l);
            this.counter += this.edelta();
            float limit = 60.0f / (float)Randomer.this.itemsPerSecond;
            while (this.counter >= limit && outputItem != null) {
                this.items.set(outputItem, 1);
                this.dump(outputItem);
                this.items.set(outputItem, 0);
                this.counter -= limit;
            }
            for (int i = 0; i < this.proximity.size; ++i) {
                Building bd = (Building)this.proximity.get(i);
                if (bd == null || bd.block == null) continue;
                boolean has = false;
                if (bd.block.consumers != null && bd.block.consumers.length > 0) {
                    for (Consume c : bd.block.consumers) {
                        Object ls;
                        if (c instanceof ConsumeLiquid) {
                            ConsumeLiquid cl = (ConsumeLiquid)c;
                            has = true;
                            if (!bd.acceptLiquid((Building)this, cl.liquid) || !(bd.liquids.get(cl.liquid) < bd.block.liquidCapacity * 2.0f)) continue;
                            bd.handleLiquid((Building)this, cl.liquid, cl.amount);
                            continue;
                        }
                        if (c instanceof ConsumeLiquids) {
                            ConsumeLiquids cls = (ConsumeLiquids)c;
                            has = true;
                            ls = cls.liquids;
                            if (((LiquidStack[])ls).length <= 0) continue;
                            for (Object lk : ls) {
                                if (!bd.acceptLiquid((Building)this, lk.liquid) || !(bd.liquids.get(lk.liquid) < bd.block.liquidCapacity * 2.0f)) continue;
                                bd.handleLiquid((Building)this, lk.liquid, lk.amount);
                            }
                            continue;
                        }
                        if (c instanceof ConsumeLiquidFilter) {
                            ConsumeLiquidFilter lf = (ConsumeLiquidFilter)c;
                            has = true;
                            for (Liquid liquid : Vars.content.liquids()) {
                                if (!lf.filter.get((Object)liquid) || !bd.acceptLiquid((Building)this, liquid) || !(bd.liquids.get(liquid) < bd.block.liquidCapacity * 2.0f)) continue;
                                bd.handleLiquid((Building)this, liquid, lf.amount);
                            }
                            continue;
                        }
                        if (!(c instanceof ConsumeLiquidsDynamic)) continue;
                        ConsumeLiquidsDynamic ld = (ConsumeLiquidsDynamic)c;
                        has = true;
                        ls = (LiquidStack[])ld.liquids.get((Object)bd);
                        if (((Object)ls).length <= 0) continue;
                        for (Object lk : ls) {
                            if (!bd.acceptLiquid((Building)this, lk.liquid) || !(bd.liquids.get(lk.liquid) < bd.block.liquidCapacity * 2.0f)) continue;
                            bd.handleLiquid((Building)this, lk.liquid, lk.amount);
                        }
                    }
                }
                if (has || outLiquid == null || !bd.acceptLiquid((Building)this, outLiquid)) continue;
                bd.handleLiquid((Building)this, outLiquid, bd.block.liquidCapacity - bd.liquids.get(outLiquid));
            }
        }

        public float getPowerProduction() {
            return this.enabled ? Randomer.this.powerProduction : 0.0f;
        }

        public float heat() {
            return Randomer.this.heat;
        }

        public float heatFrac() {
            return 1.0f;
        }
    }
}

