/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.production;

import ExtraUtilities.ai.MinerPointAI;
import ExtraUtilities.content.EUUnitTypes;
import ExtraUtilities.net.EUCall;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.struct.EnumSet;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.BuildingTetherc;
import mindustry.gen.Groups;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class MinerPoint
extends Block {
    @Nullable
    public Item blockedItem;
    public int range = 12;
    public int tier = 2;
    public int dronesCreated = 3;
    public float droneConstructTime = 300.0f;
    public float polyStroke = 1.8f;
    public float polyRadius = 8.0f;
    public int polySides = 6;
    public float polyRotateSpeed = 1.0f;
    public Color polyColor = Color.valueOf((String)"92dd7e");
    public boolean alwaysCons = false;
    public boolean limitSize = true;
    public UnitType MinerUnit = EUUnitTypes.miner;
    public boolean canPickUp = false;

    public MinerPoint(String name) {
        super(name);
        this.size = 3;
        this.solid = true;
        this.update = true;
        this.hasItems = true;
        this.hasPower = true;
        this.itemCapacity = 200;
        this.configurable = true;
        this.copyConfig = false;
        this.sync = true;
        this.buildCostMultiplier = 0.0f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.factory});
        this.config(Integer.class, (tile, i) -> {
            tile.sort = i;
        });
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (Vars.world.tile(x, y) != null && !this.canPlaceOn(Vars.world.tile(x, y), Vars.player.team(), rotation)) {
            this.drawPlaceText(Core.bundle.get(Vars.player.team().core() != null && Vars.player.team().core().items.has(this.requirements, Vars.state.rules.buildCostMultiplier) || Vars.state.rules.infiniteResources ? "bar.extra-utilities-close" : "bar.noresources"), x, y, valid);
        }
        Drawf.dashSquare((Color)Pal.accent, (float)(x *= 8), (float)(y *= 8), (float)(this.range * 8 * 2));
    }

    public Rect getRect(Rect rect, float x, float y, float range) {
        rect.setCentered(x, y, range * 2.0f * 8.0f);
        return rect;
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        CoreBlock.CoreBuild core = team.core();
        if (core == null || !Vars.state.rules.infiniteResources && !core.items.has(this.requirements, Vars.state.rules.buildCostMultiplier)) {
            return false;
        }
        if (!this.limitSize) {
            return true;
        }
        Rect rect = this.getRect(Tmp.r1, tile.worldx() + this.offset, tile.worldy() + this.offset, this.range).grow(0.1f);
        return !Vars.indexer.getFlagged(team, BlockFlag.factory).contains(b -> {
            if (b instanceof MinerPointBuild) {
                MinerPointBuild build = (MinerPointBuild)((Object)b);
                MinerPoint block = (MinerPoint)b.block;
                return this.getRect(Tmp.r2, build.x, build.y, block.range).overlaps(rect);
            }
            return false;
        });
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.drillTier, StatValues.blocks(b -> {
            if (b instanceof Floor) {
                Floor f = (Floor)b;
                return f.wallOre && f.itemDrop != null && f.itemDrop != this.blockedItem && f.itemDrop.hardness <= this.tier || !f.wallOre && f.itemDrop != null && f.itemDrop.hardness <= this.tier && f.itemDrop != this.blockedItem && (Vars.indexer.isBlockPresent((Block)f) || Vars.state.isMenu());
            }
            if (b instanceof StaticWall) {
                StaticWall w = (StaticWall)b;
                return w.itemDrop != null && w.itemDrop != this.blockedItem && w.itemDrop.hardness <= this.tier;
            }
            return false;
        }));
        this.stats.add(Stat.range, (float)this.range);
        this.stats.remove(Stat.buildTime);
    }

    public void setBars() {
        super.setBars();
        this.addBar("units", e -> new Bar(() -> Core.bundle.format("bar.unitcap", new Object[]{Fonts.getUnicodeStr((String)this.MinerUnit.name), e.units.size, this.dronesCreated}), () -> Pal.power, () -> (float)e.units.size / (float)this.dronesCreated));
    }

    public boolean outputsItems() {
        return true;
    }

    public static void minerPointDroneSpawned(Tile tile, int id) {
        if (tile == null || !(tile.build instanceof MinerPointBuild)) {
            return;
        }
        ((MinerPointBuild)tile.build).spawned(id);
    }

    public class MinerPointBuild
    extends Building {
        @Nullable
        public Tile sortTile = null;
        public int sort = -1;
        public int lastSort = -1;
        public Seq<Tile> tiles = new Seq();
        protected IntSeq readUnits = new IntSeq();
        protected IntSeq whenSyncedUnits = new IntSeq();
        public Seq<Unit> units = new Seq();
        public float droneWarmup;
        public float powerWarmup;
        public float warmup;
        public float readyness;
        public float droneProgress;
        public float totalDroneProgress;
        public boolean placeInAir = false;

        public void updateTile() {
            if (this.sort != -1 && this.lastSort != this.sort) {
                this.lastSort = this.sort;
                this.sortTile = Vars.world.tile(this.sort);
            }
            if (this.sort == -1 && this.lastSort != this.sort) {
                this.lastSort = this.sort;
                this.sortTile = null;
            }
            if (!(this.sortTile == null || this.checkOre(this.sortTile) && this.validOre(this.sortTile))) {
                this.sortTile = null;
                this.sort = -1;
            }
            this.dumpAccumulate();
            if (!this.readUnits.isEmpty()) {
                this.units.clear();
                this.readUnits.each(i -> {
                    Unit unit = (Unit)Groups.unit.getByID(i);
                    if (unit != null) {
                        this.units.add((Object)unit);
                    }
                });
                this.readUnits.clear();
            }
            if (this.units.size < MinerPoint.this.dronesCreated && this.whenSyncedUnits.size > 0) {
                this.whenSyncedUnits.each(id -> {
                    Unit unit = (Unit)Groups.unit.getByID(id);
                    if (unit != null) {
                        this.units.addUnique((Object)unit);
                    }
                });
            }
            this.units.removeAll(u -> !u.isAdded() || u.dead || !(u.controller() instanceof MinerPointAI));
            if (!this.allowUpdate()) {
                this.droneProgress = 0.0f;
                this.units.each(Unitc::kill);
                this.units.clear();
            }
            float powerStatus = this.power == null ? 1.0f : this.power.status;
            this.powerWarmup = Mathf.lerpDelta((float)powerStatus, (float)(powerStatus > 1.0E-4f ? 1.0f : 0.0f), (float)0.1f);
            this.droneWarmup = Mathf.lerpDelta((float)this.droneWarmup, (float)(this.units.size < MinerPoint.this.dronesCreated ? powerStatus : 0.0f), (float)0.1f);
            this.totalDroneProgress += this.droneWarmup * this.edelta();
            this.warmup = Mathf.approachDelta((float)this.warmup, (float)this.efficiency, (float)0.016666668f);
            this.readyness = Mathf.approachDelta((float)this.readyness, (float)(this.units.size == MinerPoint.this.dronesCreated ? 1.0f : 0.0f), (float)0.016666668f);
            if (this.units.size < MinerPoint.this.dronesCreated) {
                float f;
                this.droneProgress += this.edelta() * Vars.state.rules.unitBuildSpeed(this.team) * powerStatus / MinerPoint.this.droneConstructTime;
                if (f >= 1.0f && !Vars.net.client()) {
                    Unit unit = MinerPoint.this.MinerUnit.create(this.team);
                    if (unit instanceof BuildingTetherc) {
                        ((BuildingTetherc)unit).building((Building)this);
                    }
                    unit.set(this.x, this.y);
                    unit.rotation = 90.0f;
                    unit.add();
                    this.units.add((Object)unit);
                    EUCall.minerPointDroneSpawned(this.tile, unit.id);
                }
            }
            if (this.units.size >= MinerPoint.this.dronesCreated) {
                this.droneProgress = 0.0f;
            }
            for (int i2 = 0; i2 < this.units.size; ++i2) {
                Unit unit = (Unit)this.units.get(i2);
                MinerPointAI ai = (MinerPointAI)unit.controller();
                ai.ore = MinerPoint.this.alwaysCons ? ((double)this.efficiency > 0.4 ? this.sortTile : null) : this.sortTile;
            }
        }

        public boolean canPickup() {
            return MinerPoint.this.canPickUp;
        }

        public void pickedUp() {
            if (MinerPoint.this.canPickUp) {
                this.configure(-1);
                this.sortTile = null;
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y);
            if (this.units.size < MinerPoint.this.dronesCreated) {
                Draw.draw((float)35.0f, () -> Drawf.construct((Building)this, (TextureRegion)MinerPoint.this.MinerUnit.fullIcon, (float)0.0f, (float)this.droneProgress, (float)this.warmup, (float)this.totalDroneProgress));
            } else {
                Draw.z((float)99.99f);
                Draw.color((Color)MinerPoint.this.polyColor);
                Lines.stroke((float)(MinerPoint.this.polyStroke * this.readyness));
                Lines.poly((float)this.x, (float)this.y, (int)MinerPoint.this.polySides, (float)MinerPoint.this.polyRadius, (float)(Time.time * MinerPoint.this.polyRotateSpeed));
                Draw.reset();
                Draw.z((float)30.0f);
            }
        }

        public void drawConfigure() {
            super.drawConfigure();
            Drawf.dashSquare((Color)Pal.accent, (float)this.x, (float)this.y, (float)(MinerPoint.this.range * 8 * 2));
            if (Core.settings != null && Core.settings.getBool("eu-show-miner-point")) {
                if (this.tiles.size == 0 && !this.placeInAir) {
                    this.findOre();
                    if (this.tiles.size == 0) {
                        this.placeInAir = true;
                        return;
                    }
                }
                if (this.tiles.size > 0) {
                    float z = Draw.z();
                    Draw.z((float)27.0f);
                    float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)0.8f);
                    for (Tile t : this.tiles) {
                        Item i = this.oreDrop(t);
                        if (i == null || !this.validOre(t)) continue;
                        Draw.color((Color)Tmp.c1.set(i.color).a(sin));
                        Fill.square((float)t.worldx(), (float)t.worldy(), (float)4.0f);
                    }
                    Draw.reset();
                    Draw.z((float)z);
                }
            }
            if (this.sortTile == null) {
                return;
            }
            Tmp.v1.set(this.sortTile.getX(), this.sortTile.getY()).sub(this.x, this.y).limit(((float)MinerPoint.this.size / 2.0f + 1.0f) * 8.0f + 0.5f);
            float xx = this.x + Tmp.v1.x;
            float yy = this.y + Tmp.v1.y;
            int segs = (int)(this.dst(this.sortTile.getX(), this.sortTile.getY()) / 8.0f);
            Lines.stroke((float)4.0f, (Color)Pal.gray);
            Lines.dashLine((float)xx, (float)yy, (float)this.sortTile.getX(), (float)this.sortTile.getY(), (int)segs);
            Lines.stroke((float)2.0f, (Color)Pal.accent);
            Lines.dashLine((float)xx, (float)yy, (float)this.sortTile.getX(), (float)this.sortTile.getY(), (int)segs);
            Drawf.square((float)this.sortTile.getX(), (float)this.sortTile.getY(), (float)5.0f, (Color)Pal.accent);
        }

        public void spawned(int id) {
            Fx.spawn.at(this.x, this.y);
            this.droneProgress = 0.0f;
            if (Vars.net.client()) {
                this.whenSyncedUnits.add(id);
            }
        }

        public boolean checkOre(Tile t) {
            return Mathf.equal((float)this.tile.x, (float)t.x, (float)MinerPoint.this.range) && Mathf.equal((float)this.tile.y, (float)t.y, (float)MinerPoint.this.range);
        }

        private boolean validOre(Tile t) {
            return t.solid() && t.wallDrop() != null && t.wallDrop() != MinerPoint.this.blockedItem && t.wallDrop().hardness <= MinerPoint.this.tier || t.block() == Blocks.air && t.drop() != null && t.drop() != MinerPoint.this.blockedItem && t.drop().hardness <= MinerPoint.this.tier;
        }

        private Item oreDrop(Tile t) {
            if (t.solid() && t.wallDrop() != null) {
                return t.wallDrop();
            }
            if (t.block() == Blocks.air && t.drop() != null) {
                return t.drop();
            }
            return null;
        }

        private void findOre() {
            this.tiles.clear();
            short tx = this.tile.x;
            short ty = this.tile.y;
            int tr = MinerPoint.this.range;
            for (int x = -tr; x <= tr; ++x) {
                for (int y = -tr; y <= tr; ++y) {
                    Tile other = Vars.world.tile(x + tx, y + ty);
                    if (other == null || !this.checkOre(other)) continue;
                    this.tiles.add((Object)other);
                }
            }
        }

        public int acceptStack(Item item, int amount, Teamc source) {
            return Math.min(MinerPoint.this.itemCapacity - this.items.get(item), amount);
        }

        public boolean onConfigureTapped(float x, float y) {
            Tile t = Vars.world.tileWorld(x, y);
            if (t != null && this.checkOre(t) && this.validOre(t)) {
                if (this.sort == t.pos()) {
                    this.configure(-1);
                } else {
                    this.configure(t.pos());
                }
                return true;
            }
            return false;
        }

        public Integer config() {
            return this.sort;
        }

        public boolean shouldConsume() {
            return MinerPoint.this.alwaysCons || this.units.size < MinerPoint.this.dronesCreated;
        }

        public float totalProgress() {
            return this.totalDroneProgress;
        }

        public float progress() {
            return this.droneProgress;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.droneWarmup);
            write.f(this.droneProgress);
            write.b(this.units.size);
            for (Unit unit : this.units) {
                write.i(unit.id);
            }
            write.i(this.sortTile == null ? -1 : this.sortTile.pos());
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.droneWarmup = read.f();
            this.droneProgress = read.f();
            int count = read.b();
            this.readUnits.clear();
            for (int i = 0; i < count; ++i) {
                this.readUnits.add(read.i());
            }
            this.whenSyncedUnits.clear();
            this.sort = read.i();
        }
    }
}

