/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.power;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.ui.Bar;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawPlasma;
import mindustry.world.draw.DrawRegion;

public class ThermalReactor
extends ThermalGenerator {
    public float addSpeed = 3.0E-4f;
    private final String[] load = new String[]{"loading", "loading .", "loading ..", "loading ..."};
    public float workdamage = 6.0f;

    public ThermalReactor(String name) {
        super(name);
        this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawPlasma(), new DrawDefault()});
    }

    public void setBars() {
        super.setBars();
        this.addBar("load", entity -> new Bar(() -> (double)entity.warmup() > 0.999 ? "complete" : this.load[(int)(Time.time / (float)(this.load.length * 10)) % this.load.length], () -> Color.valueOf((String)"ffd06d"), entity::warmup));
    }

    public class ThermalReactorBuild
    extends ThermalGenerator.ThermalGeneratorBuild {
        public float st;

        public ThermalReactorBuild() {
            super((ThermalGenerator)ThermalReactor.this);
            this.st = 0.0f;
        }

        public float warmup() {
            return this.getPowerProduction() / (ThermalReactor.this.powerProduction * this.productionEfficiency);
        }

        public void updateTile() {
            super.updateTile();
            if (this.st > 0.001f) {
                this.damage(ThermalReactor.this.workdamage / 60.0f * Time.delta);
            }
        }

        public float getPowerProduction() {
            this.st = Mathf.lerpDelta((float)this.st, (float)1.0f, (float)ThermalReactor.this.addSpeed);
            if (Mathf.equal((float)this.st, (float)1.0f, (float)0.001f)) {
                this.st = 1.0f;
            }
            return ThermalReactor.this.powerProduction * this.productionEfficiency * this.st;
        }

        public void draw() {
            ThermalReactor.this.drawer.draw((Building)this);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.st);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.st = read.f();
        }
    }
}

