/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.liquid;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.meta.BlockGroup;

public class LiquidUnloader
extends Block {
    public String center;
    public float speed = 3.0f;

    public LiquidUnloader(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasLiquids = true;
        this.liquidCapacity = 10.0f;
        this.configurable = true;
        this.outputsLiquid = true;
        this.saveConfig = true;
        this.noUpdateDisabled = true;
        this.displayFlow = false;
        this.group = BlockGroup.liquids;
        this.envEnabled = -1;
        this.clearOnDoubleTap = true;
        this.config(Liquid.class, (tile, l) -> {
            tile.sortLiquid = l;
        });
        this.configClear(tile -> {
            tile.sortLiquid = null;
        });
    }

    public void load() {
        super.load();
        this.center = this.name + "-center";
    }

    public void setBars() {
        super.setBars();
        this.removeBar("liquid");
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, this.center, true);
    }

    public class LiquidUnloaderBuild
    extends Building {
        public Liquid sortLiquid = null;
        public Liquid lastSort = null;
        public Building dumpingTo = null;
        public float offset = 0.0f;

        public void updateTile() {
            if (this.lastSort != this.sortLiquid) {
                this.liquids.clear();
                this.lastSort = this.sortLiquid;
            }
            for (int i = 0; i < this.proximity.size; ++i) {
                int pos = (int)(this.offset + (float)i) % this.proximity.size;
                Building other = (Building)this.proximity.get(pos);
                if (!other.interactable(this.team) || !other.block.hasLiquids || other instanceof LiquidBlock.LiquidBuild && other.block.size == 1 || this.sortLiquid == null || !(other.liquids.get(this.sortLiquid) > 0.0f)) continue;
                this.dumpingTo = other;
                if (!(this.liquids.get(this.sortLiquid) < this.block.liquidCapacity)) continue;
                float amount = Math.min(LiquidUnloader.this.speed, other.liquids.get(this.sortLiquid));
                this.liquids.add(this.sortLiquid, amount);
                other.liquids.remove(this.sortLiquid, amount);
            }
            if (this.proximity.size > 0) {
                this.offset += 1.0f;
                this.offset %= (float)this.proximity.size;
            }
            this.dumpLiquid(this.liquids.current());
        }

        public boolean canDumpLiquid(Building to, Liquid liquid) {
            return to != this.dumpingTo;
        }

        public void draw() {
            super.draw();
            Draw.color((Color)(this.sortLiquid == null ? Color.clear : this.sortLiquid.color));
            Draw.rect((TextureRegion)Core.atlas.find(LiquidUnloader.this.center), (float)this.x, (float)this.y);
            Draw.color();
        }

        public void buildConfiguration(Table table) {
            ItemSelection.buildTable((Block)LiquidUnloader.this, (Table)table, (Seq)Vars.content.liquids(), () -> this.sortLiquid, arg_0 -> ((LiquidUnloaderBuild)this).configure(arg_0));
        }

        public Liquid config() {
            return this.sortLiquid;
        }

        public byte version() {
            return 1;
        }

        public void write(Writes write) {
            super.write(write);
            write.s(this.sortLiquid == null ? -1 : (int)this.sortLiquid.id);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.sortLiquid = id == -1 ? null : Vars.content.liquid((int)id);
        }
    }
}

