/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.heat;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.blocks.heat.HeatConsumer;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class HeatDriver
extends Block {
    public int range = 240;
    public float lost = 0.15f;
    public float visualMaxHeat = 15.0f;
    public DrawBlock drawer = new DrawDefault();
    public boolean splitHeat = false;

    public HeatDriver(String name) {
        super(name);
        this.sync = true;
        this.envEnabled |= 2;
        this.configurable = true;
        this.hasPower = true;
        this.rotate = true;
        this.solid = true;
        this.update = true;
        this.rotateDraw = false;
        this.size = 3;
        this.config(Point2.class, (tile, point) -> {
            tile.link = Point2.pack((int)(point.x + tile.tileX()), (int)(point.y + tile.tileY()));
        });
        this.config(Integer.class, (tile, point) -> {
            tile.link = point;
        });
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shootRange, (float)this.range / 8.0f, StatUnit.blocks);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.accent);
    }

    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar(() -> Core.bundle.format("bar.heatamount", new Object[]{(int)(entity.heat + 0.001f)}), () -> Pal.lightOrange, () -> entity.heat / this.visualMaxHeat));
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public class HeatDriverBuild
    extends Building
    implements HeatBlock,
    HeatConsumer {
        public float rotation = 90.0f;
        public float progress = 0.0f;
        public float resProgress = 0.0f;
        public int link = -1;
        public Seq<Building> owners = new Seq();
        public float heat = 0.0f;
        public float[] sideHeat = new float[4];
        public IntSet cameFrom = new IntSet();
        public long lastHeatUpdate = -1L;

        public void draw() {
            HeatDriver.this.drawer.draw((Building)this);
        }

        public void drawLight() {
            super.drawLight();
            HeatDriver.this.drawer.drawLight((Building)this);
        }

        public void updateTile() {
            if (this.owners.size == 0 && this.link == -1) {
                this.heat = 0.0f;
            }
            this.checkOwner();
            Building linked = Vars.world.build(this.link);
            boolean hasLink = this.linkValid();
            if (hasLink) {
                HeatDriverBuild other = (HeatDriverBuild)linked;
                if (other.checkOneOwner(this)) {
                    other.owners.add((Object)this);
                }
                float toRotation = this.angleTo((Position)other);
                this.rotation = Mathf.slerpDelta((float)this.rotation, (float)toRotation, (float)(0.02f * this.power.status));
                if (Angles.near((float)this.rotation, (float)toRotation, (float)2.0f)) {
                    this.updateTransfer();
                    other.updateTransfer();
                    this.progress = Mathf.slerpDelta((float)this.progress, (float)1.0f, (float)(0.02f * this.power.status));
                } else {
                    this.progress = Mathf.slerpDelta((float)this.progress, (float)0.0f, (float)0.04f);
                }
            } else {
                this.progress = Mathf.slerpDelta((float)this.progress, (float)0.0f, (float)0.04f);
            }
            float p = Math.min(this.heat / HeatDriver.this.visualMaxHeat, 1.0f);
            this.resProgress = this.owners.size > 0 && p > 0.0f ? Mathf.slerpDelta((float)this.resProgress, (float)1.0f, (float)(0.02f * p)) : Mathf.slerpDelta((float)this.resProgress, (float)0.0f, (float)0.05f);
        }

        public void updateTransfer() {
            if (this.owners.size > 0) {
                float totalHeat = 0.0f;
                for (int i = 0; i < this.owners.size; ++i) {
                    Building o = (Building)this.owners.get(i);
                    HeatDriverBuild owner = (HeatDriverBuild)o;
                    float dst = this.dst((Position)owner) / (float)HeatDriver.this.range;
                    if (!Angles.near((float)owner.rotation, (float)owner.angleTo((Position)this), (float)2.0f)) continue;
                    totalHeat += owner.heat * (1.0f - dst * HeatDriver.this.lost);
                    totalHeat *= owner.power.status;
                }
                this.heat = totalHeat;
            } else {
                this.updateHeat();
            }
        }

        public void updateHeat() {
            if (this.lastHeatUpdate == Vars.state.updateId) {
                return;
            }
            this.lastHeatUpdate = Vars.state.updateId;
            this.heat = this.calculateHeat(this.sideHeat, this.cameFrom);
        }

        public float heatRequirement() {
            return this.linkValid() ? HeatDriver.this.visualMaxHeat : Float.MAX_VALUE;
        }

        public float warmup() {
            return this.heat;
        }

        public float heat() {
            return this.owners.size > 0 && this.link == -1 ? this.heat : 0.0f;
        }

        public float heatFrac() {
            return this.heat / HeatDriver.this.visualMaxHeat / (HeatDriver.this.splitHeat ? 3.0f : 1.0f);
        }

        public float[] sideHeat() {
            return this.sideHeat;
        }

        public void drawConfigure() {
            float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Drawf.circles((float)this.x, (float)this.y, (float)(((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.accent);
            this.owners.each(owner -> {
                Drawf.circles((float)owner.x, (float)owner.y, (float)(((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)owner.x, (float)owner.y, (float)this.x, (float)this.y, (float)((float)(HeatDriver.this.size * 8) + sin), (float)(4.0f + sin), (Color)Pal.place);
            });
            if (this.linkValid()) {
                Building target = Vars.world.build(this.link);
                Drawf.circles((float)target.x, (float)target.y, (float)(((float)target.block.size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)this.x, (float)this.y, (float)target.x, (float)target.y, (float)((float)(HeatDriver.this.size * 8) + sin), (float)(4.0f + sin));
            }
            Drawf.dashCircle((float)this.x, (float)this.y, (float)HeatDriver.this.range, (Color)Pal.accent);
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                if (this.link == -1) {
                    this.deselect();
                }
                this.configure(-1);
                return false;
            }
            if (this.link == other.pos()) {
                this.configure(-1);
                return false;
            }
            if (other.block == this.block && other.dst((Position)this.tile) <= (float)HeatDriver.this.range && other.team == this.team && this.checkOneOwner(other)) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        public void checkOwner() {
            for (int i = 0; i < this.owners.size; ++i) {
                int pos = ((Building)this.owners.get(i)).pos();
                Building build = Vars.world.build(pos);
                if (build instanceof HeatDriverBuild) {
                    HeatDriverBuild owner = (HeatDriverBuild)build;
                    if (owner.block == this.block && owner.link == this.pos()) continue;
                    this.owners.remove(i);
                    continue;
                }
                this.owners.remove(i);
            }
        }

        protected boolean checkOneOwner(Building other) {
            if (this.owners.size == 0) {
                return true;
            }
            return !this.owners.contains((Object)other);
        }

        public Point2 config() {
            if (this.tile == null) {
                return null;
            }
            return Point2.unpack((int)this.link).sub((int)this.tile.x, (int)this.tile.y);
        }

        public boolean linkValid() {
            if (this.link == -1) {
                return false;
            }
            Building other = Vars.world.build(this.link);
            if (other == null) {
                this.link = -1;
                return false;
            }
            return other.block == this.block && other.team == this.team && this.within((Position)other, HeatDriver.this.range);
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.rotation);
            write.f(this.progress);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.rotation = read.f();
            this.progress = read.f();
        }
    }
}

