/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.graphics;

import ExtraUtilities.graphics.MainShader;
import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.struct.Seq;
import arc.util.Tmp;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.game.EventType;

public class MainRenderer {
    private final Seq<BlackHole> holes = new Seq();
    private static MainRenderer renderer;
    private FrameBuffer buffer;
    private static final float[][] initFloat;
    private static final Pool<BlackHole> holePool;

    protected MainRenderer() {
        if (!Vars.headless) {
            MainShader.createShader();
            this.buffer = new FrameBuffer();
            Events.run((Object)EventType.Trigger.draw, this::advancedDraw);
        }
    }

    public static void init() {
        if (renderer == null) {
            renderer = new MainRenderer();
        }
        for (int i = 0; i < 512; ++i) {
            MainRenderer.initFloat[i] = new float[i * 4];
        }
    }

    public static void addBlackHole(float x, float y, float inRadius, float outRadius, float alpha) {
        if (!Vars.headless) {
            renderer.addHole(x, y, inRadius, outRadius, alpha);
        }
    }

    public static void addBlackHole(float x, float y, float inRadius, float outRadius) {
        if (!Vars.headless) {
            renderer.addHole(x, y, inRadius, outRadius, 1.0f);
        }
    }

    private void advancedDraw() {
        if (Core.settings.getBool("pixelate") || this.holes.size >= 512) {
            this.holes.clear();
            return;
        }
        Draw.draw((float)-11.0f, () -> {
            this.buffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
            this.buffer.begin();
        });
        Draw.draw((float)219.0f, () -> {
            this.buffer.end();
            if (this.holes.size >= MainShader.MaxCont) {
                MainShader.createShader();
            }
            float[] blackholes = initFloat[this.holes.size];
            for (int i = 0; i < this.holes.size; ++i) {
                BlackHole hole = (BlackHole)this.holes.get(i);
                blackholes[i * 4] = hole.x;
                blackholes[i * 4 + 1] = hole.y;
                blackholes[i * 4 + 2] = hole.inRadius;
                blackholes[i * 4 + 3] = hole.outRadius;
                Draw.color((Color)Tmp.c2.set(Color.black).a(hole.alpha));
                Fill.circle((float)hole.x, (float)hole.y, (float)(hole.inRadius * 1.5f));
                Draw.color();
                holePool.free((Object)hole);
            }
            MainShader.holeShader.blackHoles = blackholes;
            this.buffer.blit((Shader)MainShader.holeShader);
            this.buffer.begin();
            Draw.rect();
            this.buffer.end();
            this.holes.clear();
        });
    }

    private void addHole(float x, float y, float inRadius, float outRadius, float alpha) {
        if (inRadius > outRadius || outRadius <= 0.0f) {
            return;
        }
        this.holes.add((Object)((BlackHole)holePool.obtain()).set(x, y, inRadius, outRadius, alpha));
    }

    static {
        initFloat = new float[512][];
        holePool = Pools.get(BlackHole.class, BlackHole::new);
    }

    private static class BlackHole {
        float x;
        float y;
        float inRadius;
        float outRadius;
        float alpha;

        public BlackHole set(float x, float y, float inRadius, float outRadius, float alpha) {
            this.x = x;
            this.y = y;
            this.inRadius = inRadius;
            this.outRadius = outRadius;
            this.alpha = alpha;
            return this;
        }
    }
}

