/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.content;

import ExtraUtilities.ExtraUtilitiesMod;
import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Table;
import arc.struct.IntMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.ai.types.MissileAI;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.PointBulletType;
import mindustry.entities.pattern.ShootSpread;
import mindustry.entities.units.UnitController;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Icon;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.gen.Velc;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class EUGet {
    public static int[] signsZero = new int[]{-1, 0, 1};
    public static Color rainBowRed = Color.valueOf((String)"ff8787");
    public static Color MIKU = Color.valueOf((String)"39c5bb");
    public static Color EC1 = new Color();
    public static Color EC2 = new Color();
    public static Color EC3 = new Color();
    public static Color EC4 = new Color();
    public static Color EC5 = new Color();
    public static Color EC6 = new Color();
    public static Color EC7 = new Color();
    public static Color EC8 = new Color();
    public static Color EC9 = new Color();
    public static Color EC10 = new Color();
    public static Color EC11 = new Color();
    public static Color EC12 = new Color();
    public static Color EC13 = new Color();
    public static Color EC14 = new Color();
    public static Color EC15 = new Color();
    public static Color EC16 = new Color();
    public static Color EC17 = new Color();
    public static Color EC18 = new Color();
    public static Color EC19 = new Color();
    public static Color EC20 = new Color();
    public static Color EC21 = new Color();
    public static String[] donors = new String[]{"\u51b7\u51bb\u6db2", "zhraa11", "\u6807\u67aa", "\u82b1\u6768\u6c38\u701b", "\u7070\u5c18\u5e99", "\u7ef4\u751f\u7d20", "\u9c7c\u9c7c", "penitent"};
    public static String[] developers = new String[]{"guiY", "carrot"};
    public static IntMap<Seq<UnlockableContent>> donorMap = new IntMap();
    public static IntMap<Seq<UnlockableContent>> developerMap = new IntMap();
    public static Seq<UnlockableContent> donorItems;
    public static Seq<UnlockableContent> developerItems;
    private static final String DONOR;
    private static final String DEVELOPER;

    public static void loadItems() {
        for (UnlockableContent c : donorItems) {
            c.description = c.description == null ? DONOR : c.description + "\n" + DONOR;
        }
        for (UnlockableContent c : developerItems) {
            c.description = c.description == null ? DEVELOPER : c.description + "\n" + DEVELOPER;
        }
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static Position pos(final float x, final float y) {
        return new Position(){

            public float getX() {
                return x;
            }

            public float getY() {
                return y;
            }
        };
    }

    public static float pointAngleX(float px, float angle, float dst) {
        return px + dst * Mathf.cosDeg((float)angle);
    }

    public static float pointAngleY(float py, float angle, float dst) {
        return py + dst * Mathf.sinDeg((float)angle);
    }

    public static float dx(float px, float r, float angle) {
        return px + r * (float)Math.cos((double)angle * Math.PI / 180.0);
    }

    public static float dy(float py, float r, float angle) {
        return py + r * (float)Math.sin((double)angle * Math.PI / 180.0);
    }

    public static float txy(float px, float py, float a, float b, float theta, float angle, int xy) {
        float x = a * Mathf.cosDeg((float)angle);
        float y = b * Mathf.sinDeg((float)angle);
        float xRotated = x * Mathf.cosDeg((float)theta) - y * Mathf.sinDeg((float)theta) + px;
        float yRotated = x * Mathf.sinDeg((float)theta) + y * Mathf.cosDeg((float)theta) + py;
        return xy == 0 ? xRotated : yRotated;
    }

    public static float posx(float x, float length, float angle) {
        float a = (float)(Math.PI * (double)angle / 180.0);
        float cos = (float)Math.cos(a);
        return x + length * cos;
    }

    public static float posy(float y, float length, float angle) {
        float a = (float)(Math.PI * (double)angle / 180.0);
        float sin = (float)Math.sin(a);
        return y + length * sin;
    }

    public static boolean isInstanceButNotSubclass(Object obj, Class<?> clazz) {
        if (clazz.isInstance(obj)) {
            try {
                if (EUGet.getClassSubclassHierarchy(obj.getClass()).contains(clazz)) {
                    return false;
                }
            }
            catch (ClassCastException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static Seq<Class<?>> getClassSubclassHierarchy(Class<?> clazz) {
        Seq hierarchy = new Seq();
        for (Class<?> c = clazz.getSuperclass(); c != null; c = c.getSuperclass()) {
            hierarchy.add(c);
            Class<?>[] interfaces = c.getInterfaces();
            hierarchy.addAll(Arrays.asList(interfaces));
        }
        return hierarchy;
    }

    public static Seq<Turret> turrets() {
        Seq turretSeq = new Seq();
        int size = Vars.content.blocks().size;
        for (int i = 0; i < size; ++i) {
            Block b = Vars.content.block(i);
            if (!(b instanceof Turret)) continue;
            turretSeq.addUnique((Object)((Turret)b));
        }
        return turretSeq;
    }

    public static Seq<BulletType> bulletTypes() {
        Seq bullets = new Seq();
        for (final Turret t : EUGet.turrets()) {
            if (!(t instanceof ItemTurret)) continue;
            for (Item i : ((ItemTurret)t).ammoTypes.keys()) {
                final BulletType b = (BulletType)((ItemTurret)t).ammoTypes.get((Object)i);
                if (t.shoot.shots == 1 || b instanceof PointBulletType || b instanceof ArtilleryBulletType) {
                    bullets.add((Object)b);
                    continue;
                }
                BulletType bulletType = new BulletType(){
                    {
                        this.fragBullet = b;
                        this.fragBullets = t.shoot.shots;
                        this.fragAngle = 0.0f;
                        if (t.shoot instanceof ShootSpread) {
                            this.fragSpread = ((ShootSpread)t.shoot).spread;
                        }
                        this.fragRandomSpread = t.inaccuracy;
                        this.fragVelocityMin = 1.0f - t.velocityRnd;
                        this.collidesAir = false;
                        this.collidesGround = false;
                        this.collides = false;
                        this.hittable = false;
                        this.absorbable = false;
                        this.despawnHit = true;
                        this.speed = 0.0f;
                        this.damage = 0.0f;
                        this.lifetime = 0.0f;
                        this.hitEffect = this.despawnEffect = Fx.none;
                    }
                };
                bullets.add((Object)bulletType);
            }
        }
        return bullets;
    }

    public static Bullet anyOtherCreate(Bullet bullet, BulletType bt, Entityc shooter, Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        if (bt == null) {
            return null;
        }
        angle += bt.angleOffset + Mathf.range((float)bt.randomAngleOffset);
        if (!Mathf.chance((double)bt.createChance)) {
            return null;
        }
        if (bt.ignoreSpawnAngle) {
            angle = 0.0f;
        }
        if (bt.spawnUnit != null) {
            Healthc h;
            if (!Vars.net.client()) {
                UnitController unitController;
                Unit spawned = bt.spawnUnit.create(team);
                spawned.set(x, y);
                spawned.rotation = angle;
                if (bt.spawnUnit.missileAccelTime <= 0.0f) {
                    spawned.vel.trns(angle, bt.spawnUnit.speed);
                }
                if ((unitController = spawned.controller()) instanceof MissileAI) {
                    MissileAI ai = (MissileAI)unitController;
                    if (shooter instanceof Unit) {
                        Unit unit;
                        ai.shooter = unit = (Unit)shooter;
                    }
                    if (shooter instanceof ControlBlock) {
                        ControlBlock control = (ControlBlock)shooter;
                        ai.shooter = control.unit();
                    }
                }
                spawned.add();
                Units.notifyUnitSpawn((Unit)spawned);
            }
            if (bt.killShooter && owner instanceof Healthc && !(h = (Healthc)owner).dead()) {
                h.kill();
            }
            return null;
        }
        bullet.type = bt;
        bullet.owner = owner;
        bullet.shooter = shooter == null ? owner : shooter;
        bullet.team = team;
        bullet.time = 0.0f;
        bullet.originX = x;
        bullet.originY = y;
        if (aimX != -1.0f || aimY != -1.0f) {
            Tile tile;
            if (target instanceof Building) {
                Building b = (Building)target;
                tile = b.tile;
            } else {
                tile = Vars.world.tileWorld(aimX, aimY);
            }
            bullet.aimTile = tile;
        }
        bullet.aimX = aimX;
        bullet.aimY = aimY;
        bullet.initVel(angle, bt.speed * velocityScl * (bt.velocityScaleRandMin != 1.0f || bt.velocityScaleRandMax != 1.0f ? Mathf.random((float)bt.velocityScaleRandMin, (float)bt.velocityScaleRandMax) : 1.0f));
        bullet.set(x, y);
        bullet.lastX = x;
        bullet.lastY = y;
        bullet.lifetime = bt.lifetime * lifetimeScl * (bt.lifeScaleRandMin != 1.0f || bt.lifeScaleRandMax != 1.0f ? Mathf.random((float)bt.lifeScaleRandMin, (float)bt.lifeScaleRandMax) : 1.0f);
        bullet.data = data;
        bullet.hitSize = bt.hitSize;
        bullet.mover = mover;
        bullet.damage = (damage < 0.0f ? bt.damage : damage) * bullet.damageMultiplier();
        if (bullet.trail != null) {
            bullet.trail.clear();
        }
        bullet.add();
        if (bt.keepVelocity && owner instanceof Velc) {
            Velc v = (Velc)owner;
            bullet.vel.add(v.vel());
        }
        return bullet;
    }

    public static void liquid(ObjectMap<Integer, Cons<Liquid>> cons, String name, Color color, final float exp, final float fla, final float htc, final float vis, final float temp) {
        for (int i = 1; i < 10; ++i) {
            final int index = i;
            Liquid l = new Liquid(name + index, color){
                {
                    super(arg0, arg1);
                    this.explosiveness = exp * (float)index;
                    this.flammability = fla * (float)index;
                    this.heatCapacity = htc * (float)index;
                    this.viscosity = vis * (float)index;
                    this.temperature = temp / (float)index;
                }
            };
            if (cons == null || cons.size <= 0 || !cons.containsKey((Object)i)) continue;
            ((Cons)cons.get((Object)i)).get((Object)l);
        }
    }

    public static void liquid(String name, Color color, float exp, float fla, float htc, float vis, float temp) {
        EUGet.liquid(null, name, color, exp, fla, htc, vis, temp);
    }

    public static void item(ObjectMap<Integer, Cons<Item>> cons, String name, Color color, final float exp, final float fla, final float cos, final float radio, final float chg, final float health) {
        for (int i = 1; i < 10; ++i) {
            final int index = i;
            Item item = new Item(name + index, color){
                {
                    super(arg0, arg1);
                    this.explosiveness = exp * (float)index;
                    this.flammability = fla * (float)index;
                    this.cost = cos * (float)index;
                    this.radioactivity = radio * (float)index;
                    this.charge = chg * (float)index;
                    this.healthScaling = health * (float)index;
                }
            };
            if (cons == null || cons.size <= 0 || !cons.containsKey((Object)i)) continue;
            ((Cons)cons.get((Object)i)).get((Object)item);
        }
    }

    public static void test() {
        int finalI;
        int i;
        ObjectMap cons;
        int size = 40;
        for (Liquid liquid : new Liquid[]{Liquids.water, Liquids.slag, Liquids.oil, Liquids.cryofluid, Liquids.arkycite, Liquids.gallium, Liquids.neoplasm, Liquids.ozone, Liquids.hydrogen, Liquids.nitrogen, Liquids.cyanogen}) {
            if (liquid.hidden) continue;
            cons = new ObjectMap();
            for (i = 1; i < 10; ++i) {
                finalI = i;
                cons.put((Object)i, ld -> {
                    PixmapRegion base = Core.atlas.getPixmap(l.uiIcon);
                    Pixmap mix = base.crop();
                    TextureAtlas.AtlasRegion number = Core.atlas.find(ExtraUtilitiesMod.name("number-" + finalI));
                    if (number.found()) {
                        PixmapRegion region = TextureAtlas.blankAtlas().getPixmap(number);
                        mix.draw(region.pixmap, region.x, region.y, region.width, region.height, 0, base.height - size, size, size, false, true);
                    }
                    ld.uiIcon = ld.fullIcon = new TextureRegion(new Texture(mix));
                });
            }
            EUGet.liquid((ObjectMap<Integer, Cons<Liquid>>)cons, liquid.name, liquid.color, liquid.explosiveness, liquid.flammability, liquid.heatCapacity, liquid.viscosity, liquid.temperature);
        }
        for (Liquid liquid : new Item[]{Items.scrap, Items.copper, Items.lead, Items.graphite, Items.coal, Items.titanium, Items.thorium, Items.silicon, Items.plastanium, Items.phaseFabric, Items.surgeAlloy, Items.sporePod, Items.sand, Items.blastCompound, Items.pyratite, Items.metaglass, Items.beryllium, Items.tungsten, Items.oxide, Items.carbide, Items.fissileMatter, Items.dormantCyst}) {
            if (liquid.hidden) continue;
            cons = new ObjectMap();
            for (i = 1; i < 10; ++i) {
                finalI = i;
                cons.put((Object)i, arg_0 -> EUGet.lambda$test$1((Item)liquid, finalI, size, arg_0));
            }
            EUGet.item((ObjectMap<Integer, Cons<Item>>)cons, liquid.name, liquid.color, liquid.explosiveness, liquid.flammability, liquid.cost, liquid.radioactivity, liquid.charge, liquid.healthScaling);
        }
        Draw.color();
    }

    public static ImageButton selfStyleImageButton(Drawable imageUp, ImageButton.ImageButtonStyle is, Runnable listener) {
        ImageButton ib = new ImageButton(new ImageButton.ImageButtonStyle(null, null, null, imageUp, null, null));
        ImageButton.ImageButtonStyle style = new ImageButton.ImageButtonStyle(is);
        style.imageUp = imageUp;
        ib.setStyle((Button.ButtonStyle)style);
        if (listener != null) {
            ib.changed(listener);
        }
        return ib;
    }

    public static void CollapseTextToTable(Table t, String text) {
        Table ic = new Table();
        ic.add((CharSequence)text).wrap().fillX().width(500.0f).padTop(2.0f).padBottom(6.0f).left();
        ic.row();
        Collapser coll = new Collapser(ic, true);
        coll.setDuration(0.1f);
        t.row();
        t.table(st -> {
            st.add((CharSequence)Core.bundle.get("eu-clickToShow")).center();
            st.row();
            st.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(true)).update(i -> {
                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
            }).pad(5.0f).size(8.0f).center();
        }).left();
        t.row();
        t.add((Element)coll);
        t.row();
    }

    public static void movePoint(Bullet b, float endX, float endY, float speed) {
        float distance = (float)Math.sqrt(Math.pow(endX - b.x, 2.0) + Math.pow(endY - b.y, 2.0));
        float moveSpeed = distance * speed;
        float dx = (endX - b.x) / distance;
        float dy = (endY - b.y) / distance;
        float moveDistance = moveSpeed * Time.delta;
        Vars.collisions.move((Hitboxc)b, dx * moveDistance, dy * moveDistance);
        if (Math.abs(b.x - endX) < 1.0E-4f && Math.abs(b.y - endY) < 1.0E-4f) {
            b.set(endX, endY);
        }
    }

    public float lineY(float x1, float y1, float x2, float y2, float x) {
        float slope = (y2 - y1) / (x2 - x1);
        float intercept = y1 - slope * x1;
        return slope * x + intercept;
    }

    public float angleY(float x1, float y1, float angle, float x2) {
        if (angle == 90.0f || angle == 270.0f) {
            return y1;
        }
        float slope = (float)Math.tan(Math.toRadians(angle));
        return slope * (x2 - x1) + y1;
    }

    public static boolean isDeBuff(StatusEffect status) {
        return status != null && status != StatusEffects.none && (status.damage > 0.0f || status.damageMultiplier < 1.0f || status.disarm || status.speedMultiplier < 1.0f || status.reloadMultiplier < 1.0f || status.healthMultiplier < 1.0f);
    }

    private static /* synthetic */ void lambda$test$1(Item item, int finalI, int size, Item it) {
        PixmapRegion base = Core.atlas.getPixmap(item.uiIcon);
        Pixmap mix = base.crop();
        TextureAtlas.AtlasRegion number = Core.atlas.find(ExtraUtilitiesMod.name("number-" + finalI));
        if (number.found()) {
            PixmapRegion region = TextureAtlas.blankAtlas().getPixmap(number);
            mix.draw(region.pixmap, region.x, region.y, region.width, region.height, 0, base.height - size, size, size, false, true);
        }
        it.uiIcon = it.fullIcon = new TextureRegion(new Texture(mix));
        it.buildable = item.buildable;
        it.hardness = item.hardness + finalI;
        it.lowPriority = item.lowPriority;
    }

    static {
        donorMap.put(0, (Object)new Seq());
        donorMap.put(1, (Object)new Seq());
        donorMap.put(2, (Object)new Seq());
        donorMap.put(3, (Object)new Seq());
        donorMap.put(4, (Object)new Seq());
        donorMap.put(5, (Object)new Seq());
        donorMap.put(6, (Object)new Seq());
        donorMap.put(7, (Object)new Seq());
        developerMap.put(0, (Object)new Seq());
        developerMap.put(1, (Object)new Seq());
        donorItems = new Seq();
        developerItems = new Seq();
        DONOR = Core.bundle.get("mod.extra-utilities-donor-item");
        DEVELOPER = Core.bundle.get("mod.extra-utilities-developer-item");
    }

    public static class EPos
    implements Position {
        public float x;
        public float y;

        public EPos set(float x, float y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }
    }
}

