/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;

public class WellKnownSourceFileClassNameConverter
implements SourceFileClassNameConverter {
    private static final String MODULE_INFO = "module-info";
    private static final String PACKAGE_INFO = "package-info";
    private final SourceFileClassNameConverter delegate;
    private final String fileExtension;

    public WellKnownSourceFileClassNameConverter(SourceFileClassNameConverter delegate, String fileExtension) {
        this.delegate = delegate;
        this.fileExtension = fileExtension;
    }

    public static boolean isPackageInfo(String className) {
        return className.endsWith(PACKAGE_INFO);
    }

    public static boolean isModuleInfo(String className) {
        return className.equals(MODULE_INFO);
    }

    @Override
    public Collection<String> getClassNames(String sourceFileRelativePath) {
        String withoutExtension = StringUtils.removeEnd((String)sourceFileRelativePath, (String)this.fileExtension);
        if (WellKnownSourceFileClassNameConverter.isModuleInfo(withoutExtension)) {
            return Collections.singleton(MODULE_INFO);
        }
        if (WellKnownSourceFileClassNameConverter.isPackageInfo(withoutExtension)) {
            String packageName = withoutExtension.replace('/', '.');
            return Collections.singleton(packageName);
        }
        return this.delegate.getClassNames(sourceFileRelativePath);
    }

    @Override
    public Collection<String> getRelativeSourcePaths(String className) {
        if (WellKnownSourceFileClassNameConverter.isModuleInfo(className) || WellKnownSourceFileClassNameConverter.isPackageInfo(className)) {
            return Collections.singleton(className.replace('.', '/') + this.fileExtension);
        }
        return this.delegate.getRelativeSourcePaths(className);
    }
}

