/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.initialization.layout.ProjectCacheDir;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.resource.EmptyFileTextResource;
import org.gradle.internal.resource.TextResource;

public class UndefinedBuildWorkExecutor
implements BuildWorkExecutor {
    private final BuildWorkExecutor delegate;
    private final ProjectCacheDir projectCacheDir;

    public UndefinedBuildWorkExecutor(BuildWorkExecutor delegate, ProjectCacheDir projectCacheDir) {
        this.delegate = delegate;
        this.projectCacheDir = projectCacheDir;
    }

    @Override
    public ExecutionResult<Void> execute(GradleInternal gradle) {
        if (!StartParameterInternal.useLocationAsProjectRoot(gradle.getRootProject().getRootDir(), gradle.getStartParameter().getTaskNames()) && UndefinedBuildWorkExecutor.isUndefinedBuild(gradle)) {
            this.projectCacheDir.delete();
            throw new InvalidUserCodeException("Executing Gradle tasks as part of a build without a settings file is not supported. Make sure that you are executing Gradle from a directory within your Gradle project. Your project should have a 'settings.gradle(.kts)' file in the root directory.");
        }
        return this.delegate.execute(gradle);
    }

    private static boolean isUndefinedBuild(GradleInternal gradle) {
        BuildState buildState = gradle.getOwner();
        if (buildState instanceof IncludedBuildState && ((IncludedBuildState)buildState).hasInjectedSettingsPlugins()) {
            return false;
        }
        return !gradle.getRootProject().getBuildFile().exists() && UndefinedBuildWorkExecutor.isUndefinedResource(gradle.getSettings().getSettingsScript().getResource());
    }

    private static boolean isUndefinedResource(TextResource settingsScript) {
        return settingsScript instanceof EmptyFileTextResource && settingsScript.getFile() == null;
    }
}

