/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.project.taskfactory.IncrementalInputsTaskAction;
import org.gradle.api.internal.project.taskfactory.IncrementalTaskInputsTaskAction;
import org.gradle.api.internal.tasks.DefaultTaskValidationContext;
import org.gradle.api.internal.tasks.InputChangesAwareTaskAction;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationResult;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.EmptySourceTaskSkipper;
import org.gradle.api.internal.tasks.execution.ExecuteTaskActionBuildOperationType;
import org.gradle.api.internal.tasks.execution.TaskCacheabilityResolver;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputParameterUtils;
import org.gradle.api.internal.tasks.properties.InputPropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.ReservedFileSystemLocationRegistry;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.work.AsyncWorkTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteActionsTaskExecuter.class);
    private final BuildCacheState buildCacheState;
    private final ScanPluginState scanPluginState;
    private final ExecutionHistoryStore executionHistoryStore;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final TaskActionListener actionListener;
    private final TaskCacheabilityResolver taskCacheabilityResolver;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ExecutionEngine executionEngine;
    private final InputFingerprinter inputFingerprinter;
    private final ListenerManager listenerManager;
    private final ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry;
    private final EmptySourceTaskSkipper emptySourceTaskSkipper;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileOperations fileOperations;

    public ExecuteActionsTaskExecuter(BuildCacheState buildCacheState, ScanPluginState scanPluginState, ExecutionHistoryStore executionHistoryStore, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, TaskActionListener actionListener, TaskCacheabilityResolver taskCacheabilityResolver, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ExecutionEngine executionEngine, InputFingerprinter inputFingerprinter, ListenerManager listenerManager, ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry, EmptySourceTaskSkipper emptySourceTaskSkipper, FileCollectionFactory fileCollectionFactory, FileOperations fileOperations) {
        this.buildCacheState = buildCacheState;
        this.scanPluginState = scanPluginState;
        this.executionHistoryStore = executionHistoryStore;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.actionListener = actionListener;
        this.taskCacheabilityResolver = taskCacheabilityResolver;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.executionEngine = executionEngine;
        this.inputFingerprinter = inputFingerprinter;
        this.listenerManager = listenerManager;
        this.reservedFileSystemLocationRegistry = reservedFileSystemLocationRegistry;
        this.emptySourceTaskSkipper = emptySourceTaskSkipper;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileOperations = fileOperations;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskExecution work = new TaskExecution(task, context, this.executionHistoryStore, this.classLoaderHierarchyHasher, this.inputFingerprinter);
        try {
            return this.executeIfValid(task, state, context, work);
        }
        catch (WorkValidationException ex) {
            state.setOutcome((RuntimeException)((Object)ex));
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
    }

    private TaskExecuterResult executeIfValid(TaskInternal task, TaskStateInternal state, TaskExecutionContext context, TaskExecution work) {
        ExecutionEngine.Request request = this.executionEngine.createRequest((UnitOfWork)work);
        context.getTaskExecutionMode().getRebuildReason().ifPresent(arg_0 -> ((ExecutionEngine.Request)request).forceRebuild(arg_0));
        request.withValidationContext(context.getValidationContext());
        final ExecutionEngine.Result result = request.execute();
        result.getExecutionResult().ifSuccessfulOrElse(executionResult -> state.setOutcome(TaskExecutionOutcome.valueOf(executionResult.getOutcome())), failure -> state.setOutcome((RuntimeException)((Object)new TaskExecutionException(task, (Throwable)failure))));
        return new TaskExecuterResult(){

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.getReusedOutputOriginMetadata();
            }

            @Override
            public boolean executedIncrementally() {
                return (Boolean)result.getExecutionResult().map(executionResult -> executionResult.getOutcome() == ExecutionOutcome.EXECUTED_INCREMENTALLY).getOrMapFailure(throwable -> false);
            }

            @Override
            public List<String> getExecutionReasons() {
                return result.getExecutionReasons();
            }

            @Override
            public CachingState getCachingState() {
                return result.getCachingState();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeActions(TaskInternal task, @Nullable InputChangesInternal inputChanges) {
        boolean hasTaskListener = this.listenerManager.hasListeners(TaskActionListener.class) || this.listenerManager.hasListeners(TaskExecutionListener.class);
        Iterator<InputChangesAwareTaskAction> actions = new ArrayList<InputChangesAwareTaskAction>(task.getTaskActions()).iterator();
        while (actions.hasNext()) {
            InputChangesAwareTaskAction action = actions.next();
            task.getState().setDidWork(true);
            task.getStandardOutputCapture().start();
            boolean hasMoreWork = hasTaskListener || actions.hasNext();
            try {
                this.executeAction(action.getDisplayName(), task, action, inputChanges, hasMoreWork);
            }
            catch (StopActionException e) {
                LOGGER.debug("Action stopped by some action with message: {}", (Object)e.getMessage());
            }
            catch (StopExecutionException e) {
                LOGGER.info("Execution stopped by some action with message: {}", (Object)e.getMessage());
                break;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
    }

    private void executeAction(final String actionDisplayName, final TaskInternal task, final InputChangesAwareTaskAction action, @Nullable InputChangesInternal inputChanges, final boolean hasMoreWork) {
        if (inputChanges != null) {
            action.setInputChanges(inputChanges);
        }
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)(actionDisplayName + " for " + task.getIdentityPath().getPath())).name(actionDisplayName).details((Object)ExecuteTaskActionBuildOperationType.DETAILS_INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(BuildOperationContext context) {
                try {
                    BuildOperationRef currentOperation = ExecuteActionsTaskExecuter.this.buildOperationExecutor.getCurrentOperation();
                    Throwable actionFailure = null;
                    try {
                        action.execute(task);
                    }
                    catch (Throwable t) {
                        actionFailure = t;
                    }
                    finally {
                        action.clearInputChanges();
                    }
                    try {
                        ExecuteActionsTaskExecuter.this.asyncWorkTracker.waitForCompletion(currentOperation, hasMoreWork ? AsyncWorkTracker.ProjectLockRetention.RELEASE_AND_REACQUIRE_PROJECT_LOCKS : AsyncWorkTracker.ProjectLockRetention.RELEASE_PROJECT_LOCKS);
                    }
                    catch (Throwable t) {
                        ArrayList failures = Lists.newArrayList();
                        if (actionFailure != null) {
                            failures.add(actionFailure);
                        }
                        if (t instanceof MultiCauseException) {
                            failures.addAll(((MultiCauseException)t).getCauses());
                        } else {
                            failures.add(t);
                        }
                        if (failures.size() > 1) {
                            throw new MultipleTaskActionFailures("Multiple task action failures occurred:", failures);
                        }
                        throw UncheckedException.throwAsUncheckedException((Throwable)((Throwable)failures.get(0)));
                    }
                    if (actionFailure != null) {
                        context.failed(actionFailure);
                        throw UncheckedException.throwAsUncheckedException((Throwable)actionFailure);
                    }
                }
                finally {
                    context.setResult((Object)ExecuteTaskActionBuildOperationType.RESULT_INSTANCE);
                }
            }
        });
    }

    private class PreviousOutputFileCollection
    extends LazilyInitializedFileCollection {
        private final TaskInternal task;
        private final ImmutableSortedMap<String, FileSystemSnapshot> previousOutputs;

        public PreviousOutputFileCollection(TaskInternal task, ImmutableSortedMap<String, FileSystemSnapshot> previousOutputs) {
            this.task = task;
            this.previousOutputs = previousOutputs;
        }

        public FileCollectionInternal createDelegate() {
            List outputs = this.previousOutputs.values().stream().map(SnapshotUtil::index).map(Map::keySet).flatMap(Collection::stream).map(File::new).collect(Collectors.toList());
            return ExecuteActionsTaskExecuter.this.fileCollectionFactory.fixed(outputs);
        }

        public String getDisplayName() {
            return "previous output files of " + this.task.toString();
        }
    }

    @Contextual
    private static class MultipleTaskActionFailures
    extends DefaultMultiCauseException {
        public MultipleTaskActionFailures(String message, Iterable<? extends Throwable> causes) {
            super(message, causes);
        }
    }

    private class TaskExecution
    implements UnitOfWork {
        private final TaskInternal task;
        private final TaskExecutionContext context;
        private final ExecutionHistoryStore executionHistoryStore;
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
        private final InputFingerprinter inputFingerprinter;

        public TaskExecution(TaskInternal task, TaskExecutionContext context, ExecutionHistoryStore executionHistoryStore, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, InputFingerprinter inputFingerprinter) {
            this.task = task;
            this.context = context;
            this.executionHistoryStore = executionHistoryStore;
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
            this.inputFingerprinter = inputFingerprinter;
        }

        public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
            return () -> ((TaskInternal)this.task).getPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UnitOfWork.WorkOutput execute(UnitOfWork.ExecutionRequest executionRequest) {
            FileCollection previousFiles = executionRequest.getPreviouslyProducedOutputs().map(previousOutputs -> new PreviousOutputFileCollection(this.task, (ImmutableSortedMap<String, FileSystemSnapshot>)previousOutputs)).orElseGet(() -> ((FileCollectionFactory)ExecuteActionsTaskExecuter.this.fileCollectionFactory).empty());
            TaskOutputsInternal outputs = this.task.getOutputs();
            outputs.setPreviousOutputFiles(previousFiles);
            try {
                final UnitOfWork.WorkResult didWork = this.executeWithPreviousOutputFiles(executionRequest.getInputChanges().orElse(null));
                UnitOfWork.WorkOutput workOutput = new UnitOfWork.WorkOutput(){

                    public UnitOfWork.WorkResult getDidWork() {
                        return didWork;
                    }

                    public Object getOutput() {
                        throw new UnsupportedOperationException();
                    }
                };
                return workOutput;
            }
            finally {
                outputs.setPreviousOutputFiles(null);
            }
        }

        private UnitOfWork.WorkResult executeWithPreviousOutputFiles(@Nullable InputChangesInternal inputChanges) {
            this.task.getState().setExecuting(true);
            try {
                LOGGER.debug("Executing actions for {}.", (Object)this.task);
                ExecuteActionsTaskExecuter.this.actionListener.beforeActions((Task)this.task);
                ExecuteActionsTaskExecuter.this.executeActions(this.task, inputChanges);
                UnitOfWork.WorkResult workResult = this.task.getState().getDidWork() ? UnitOfWork.WorkResult.DID_WORK : UnitOfWork.WorkResult.DID_NO_WORK;
                return workResult;
            }
            finally {
                this.task.getState().setExecuting(false);
                ExecuteActionsTaskExecuter.this.actionListener.afterActions((Task)this.task);
            }
        }

        public WorkspaceProvider getWorkspaceProvider() {
            return new WorkspaceProvider(){

                public <T> T withWorkspace(String path, WorkspaceProvider.WorkspaceAction<T> action) {
                    return (T)action.executeInWorkspace(null, TaskExecution.this.context.getTaskExecutionMode().isTaskHistoryMaintained() ? TaskExecution.this.executionHistoryStore : null);
                }
            };
        }

        public InputFingerprinter getInputFingerprinter() {
            return this.inputFingerprinter;
        }

        public void visitImplementations(UnitOfWork.ImplementationVisitor visitor) {
            visitor.visitImplementation(this.task.getClass());
            List<InputChangesAwareTaskAction> taskActions = this.task.getTaskActions();
            for (InputChangesAwareTaskAction taskAction : taskActions) {
                visitor.visitImplementation(taskAction.getActionImplementation(this.classLoaderHierarchyHasher));
            }
        }

        public void visitRegularInputs(InputFingerprinter.InputVisitor visitor) {
            ImmutableSortedSet<InputPropertySpec> inputProperties = this.context.getTaskProperties().getInputProperties();
            ImmutableSortedSet<InputFilePropertySpec> inputFileProperties = this.context.getTaskProperties().getInputFileProperties();
            for (InputPropertySpec inputProperty : inputProperties) {
                visitor.visitInputProperty(inputProperty.getPropertyName(), () -> InputParameterUtils.prepareInputParameterValue(inputProperty, this.task));
            }
            for (InputFilePropertySpec inputFileProperty : inputFileProperties) {
                Object value = inputFileProperty.getValue();
                InputFingerprinter.InputPropertyType type = inputFileProperty.isSkipWhenEmpty() ? InputFingerprinter.InputPropertyType.PRIMARY : (inputFileProperty.isIncremental() ? InputFingerprinter.InputPropertyType.INCREMENTAL : InputFingerprinter.InputPropertyType.NON_INCREMENTAL);
                String propertyName = inputFileProperty.getPropertyName();
                visitor.visitInputFileProperty(propertyName, type, new InputFingerprinter.FileValueSupplier(value, inputFileProperty.getNormalizer(), inputFileProperty.getDirectorySensitivity(), inputFileProperty.getLineEndingNormalization(), inputFileProperty::getPropertyFiles));
            }
        }

        public void visitOutputs(File workspace, UnitOfWork.OutputVisitor visitor) {
            for (OutputFilePropertySpec property : this.context.getTaskProperties().getOutputFileProperties()) {
                File outputFile = property.getOutputFile();
                if (outputFile == null) continue;
                visitor.visitOutputProperty(property.getPropertyName(), property.getOutputType(), outputFile, (FileCollection)property.getPropertyFiles());
            }
            for (File localStateRoot : this.context.getTaskProperties().getLocalStateFiles()) {
                visitor.visitLocalState(localStateRoot);
            }
            for (File destroyableRoot : this.context.getTaskProperties().getDestroyableFiles()) {
                visitor.visitDestroyable(destroyableRoot);
            }
        }

        public UnitOfWork.OverlappingOutputHandling getOverlappingOutputHandling() {
            return UnitOfWork.OverlappingOutputHandling.DETECT_OVERLAPS;
        }

        public boolean shouldCleanupOutputsOnNonIncrementalExecution() {
            return this.getInputChangeTrackingStrategy() == UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS;
        }

        public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
            if (this.task.isHasCustomActions()) {
                LOGGER.info("Custom actions are attached to {}.", (Object)this.task);
            }
            return ExecuteActionsTaskExecuter.this.taskCacheabilityResolver.shouldDisableCaching(this.context.getTaskProperties().hasDeclaredOutputs(), this.context.getTaskProperties().getOutputFileProperties(), this.task, this.task.getOutputs().getCacheIfSpecs(), this.task.getOutputs().getDoNotCacheIfSpecs(), detectedOverlappingOutputs);
        }

        public boolean isAllowedToLoadFromCache() {
            return this.context.getTaskExecutionMode().isAllowedToUseCachedResults();
        }

        public Optional<Duration> getTimeout() {
            return Optional.ofNullable((Duration)this.task.getTimeout().getOrNull());
        }

        public UnitOfWork.InputChangeTrackingStrategy getInputChangeTrackingStrategy() {
            for (InputChangesAwareTaskAction taskAction : this.task.getTaskActions()) {
                if (taskAction instanceof IncrementalInputsTaskAction) {
                    return UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS;
                }
                if (!(taskAction instanceof IncrementalTaskInputsTaskAction)) continue;
                return UnitOfWork.InputChangeTrackingStrategy.ALL_PARAMETERS;
            }
            return UnitOfWork.InputChangeTrackingStrategy.NONE;
        }

        public void markLegacySnapshottingInputsStarted() {
            if (ExecuteActionsTaskExecuter.this.buildCacheState == BuildCacheState.ENABLED || ExecuteActionsTaskExecuter.this.scanPluginState == ScanPluginState.APPLIED) {
                BuildOperationContext operationContext = ExecuteActionsTaskExecuter.this.buildOperationExecutor.start(BuildOperationDescriptor.displayName((String)("Snapshot task inputs for " + this.task.getIdentityPath())).name("Snapshot task inputs").details((Object)SnapshotTaskInputsBuildOperationType.Details.INSTANCE));
                this.context.setSnapshotTaskInputsBuildOperationContext(operationContext);
            }
        }

        public void markLegacySnapshottingInputsFinished(CachingState cachingState) {
            this.context.removeSnapshotTaskInputsBuildOperationContext().ifPresent(operation -> operation.setResult((Object)new SnapshotTaskInputsBuildOperationResult(cachingState)));
        }

        public void ensureLegacySnapshottingInputsClosed() {
            this.context.removeSnapshotTaskInputsBuildOperationContext().ifPresent(operation -> operation.setResult((Object)new SnapshotTaskInputsBuildOperationResult(CachingState.NOT_DETERMINED)));
        }

        public void validate(WorkValidationContext validationContext) {
            Class taskType = GeneratedSubclasses.unpackType((Object)this.task);
            boolean cacheable = taskType.isAnnotationPresent(CacheableTask.class);
            TypeValidationContext typeValidationContext = validationContext.forType(taskType, cacheable);
            this.context.getTaskProperties().validateType(typeValidationContext);
            this.context.getTaskProperties().validate(new DefaultTaskValidationContext(ExecuteActionsTaskExecuter.this.fileOperations, ExecuteActionsTaskExecuter.this.reservedFileSystemLocationRegistry, typeValidationContext));
            this.context.getValidationAction().validate(this.context.getTaskExecutionMode().isTaskHistoryMaintained(), typeValidationContext);
        }

        public Optional<ExecutionOutcome> skipIfInputsEmpty(ImmutableSortedMap<String, FileSystemSnapshot> outputFilesAfterPreviousExecution) {
            TaskProperties properties = this.context.getTaskProperties();
            FileCollection inputFiles = properties.getInputFiles();
            FileCollection sourceFiles = properties.getSourceFiles();
            boolean hasSourceFiles = properties.hasSourceFiles();
            return ExecuteActionsTaskExecuter.this.emptySourceTaskSkipper.skipIfEmptySources(this.task, hasSourceFiles, inputFiles, sourceFiles, (Map<String, FileSystemSnapshot>)outputFilesAfterPreviousExecution);
        }

        public String getDisplayName() {
            return this.task.toString();
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static enum ScanPluginState {
        APPLIED,
        NOT_APPLIED;

    }

    public static enum BuildCacheState {
        ENABLED,
        DISABLED;

    }
}

