/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isAllowedArray", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isAllowedClassKind", "cone", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "checkers"})
public final class FirAnnotationClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirAnnotationClassDeclarationChecker INSTANCE = new FirAnnotationClassDeclarationChecker();

    private FirAnnotationClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirClassLikeDeclaration $this$isLocal$iv = declaration2;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            DiagnosticReporterKt.reportOn(reporter, declaration2.getSource(), FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR(), context2);
        }
        if (declaration2.getSuperTypeRefs().size() != 1) {
            DiagnosticReporterKt.reportOn(reporter, declaration2.getSource(), FirErrors.INSTANCE.getSUPERTYPES_FOR_ANNOTATION_CLASS(), context2);
        }
        for (FirDeclaration it : declaration2.getDeclarations()) {
            Object object;
            if (it instanceof FirConstructor && ((FirConstructor)it).isPrimary()) {
                object = ((FirConstructor)it).getValueParameters().iterator();
                while (object.hasNext()) {
                    ConeLookupTagBasedType coneType;
                    ConeLookupTagBasedType coneLookupTagBasedType;
                    ClassId classId;
                    FirTypeRef typeRef;
                    FirValueParameter parameter = (FirValueParameter)object.next();
                    FirSourceElement firSourceElement = parameter.getSource();
                    if (firSourceElement == null) continue;
                    FirSourceElement source = firSourceElement;
                    if (!LightTreePositioningStrategiesKt.hasValOrVar(source)) {
                        DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER(), context2);
                    } else if (LightTreePositioningStrategiesKt.hasVar(source)) {
                        DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER(), context2);
                    }
                    FirTypeRef $this$coneTypeSafe$iv = typeRef = parameter.getReturnTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                    if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                        coneKotlinType = null;
                    }
                    ClassId classId2 = classId = (coneLookupTagBasedType = (coneType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType)))) == null ? null : ConeTypeUtilsKt.getClassId(coneLookupTagBasedType);
                    if (coneType == null || Intrinsics.areEqual((Object)classId, (Object)ClassId.fromString("<error>"))) continue;
                    if (ConeTypeUtilsKt.isNullable(coneType)) {
                        DiagnosticReporterKt.reportOn(reporter, typeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER(), context2);
                        continue;
                    }
                    if (CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveTypes(), (Object)classId) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedTypes(), (Object)classId) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getKClass()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getString()) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values(), (Object)classId)) continue;
                    if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray())) {
                        if (this.isAllowedArray(typeRef, context2.getSession())) continue;
                        DiagnosticReporterKt.reportOn(reporter, typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), context2);
                        continue;
                    }
                    if (this.isAllowedClassKind(coneType, context2.getSession())) continue;
                    DiagnosticReporterKt.reportOn(reporter, typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), context2);
                }
                continue;
            }
            if (it instanceof FirRegularClass || it instanceof FirProperty && Intrinsics.areEqual((Object)((object = it.getSource()) == null ? null : ((FirSourceElement)object).getElementType()), (Object)KtNodeTypes.VALUE_PARAMETER) || it instanceof FirSimpleFunction && !Intrinsics.areEqual((Object)((object = it.getSource()) == null ? null : ((FirSourceElement)object).getElementType()), (Object)KtNodeTypes.FUN)) continue;
            DiagnosticReporterKt.reportOn(reporter, it.getSource(), FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER(), context2);
        }
    }

    private final boolean isAllowedClassKind(ConeLookupTagBasedType cone, FirSession session2) {
        ClassKind classKind;
        FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.toSymbol(cone.getLookupTag(), session2);
        Object var6_4 = firClassifierSymbol == null ? null : firClassifierSymbol.getFir();
        FirRegularClass firRegularClass = var6_4 instanceof FirRegularClass ? (FirRegularClass)var6_4 : null;
        ClassKind classKind2 = classKind = firRegularClass == null ? null : firRegularClass.getClassKind();
        if (classKind == null) {
            return false;
        }
        ClassKind typeRefClassKind = classKind;
        return typeRefClassKind == ClassKind.ANNOTATION_CLASS || typeRefClassKind == ClassKind.ENUM_CLASS;
    }

    private final boolean isAllowedArray(FirTypeRef typeRef, FirSession session2) {
        ConeKotlinType coneKotlinType;
        ConeTypeProjection[] typeArguments2 = FirTypeUtilsKt.getConeType(typeRef).getTypeArguments();
        if (typeArguments2.length != 1) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = typeArguments2[0];
        ConeKotlinTypeProjection coneKotlinTypeProjection = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
        ConeKotlinType coneKotlinType2 = coneKotlinType = coneKotlinTypeProjection == null ? null : coneKotlinTypeProjection.getType();
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType arrayType = coneKotlinType;
        if (ConeTypeUtilsKt.isNullable(arrayType)) {
            return false;
        }
        ClassId arrayTypeClassId = ConeTypeUtilsKt.getClassId(arrayType);
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getKClass())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getString())) {
            return true;
        }
        return this.isAllowedClassKind((ConeLookupTagBasedType)arrayType, session2);
    }
}

