/**
  ******************************************************************************
  * @file    stm32wba65xx.h
  * @author  MCD Application Team
  * @brief   CMSIS STM32WBA65xx Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripheral's registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
#ifndef STM32WBA65xx_H
#define STM32WBA65xx_H

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup ST
  * @{
  */

/** @addtogroup STM32WBA65xx
  * @{
  */

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */
typedef enum
{
/* =======================================  ARM Cortex-M33 Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,    /*!< -15 Reset Vector, invoked on Power up and warm reset              */
  NonMaskableInt_IRQn       = -14,    /*!< -14 Non maskable Interrupt, cannot be stopped or preempted        */
  HardFault_IRQn            = -13,    /*!< -13 Hard Fault, all classes of Fault                              */
  MemoryManagement_IRQn     = -12,    /*!< -12 Memory Management, MPU mismatch, including Access Violation
                                               and No Match                                                  */
  BusFault_IRQn             = -11,    /*!< -11 Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                               related Fault                                                 */
  UsageFault_IRQn           = -10,    /*!< -10 Usage Fault, i.e. Undef Instruction, Illegal State Transition */
  SecureFault_IRQn          =  -9,    /*!< -9  Secure Fault                                                  */
  SVCall_IRQn               =  -5,    /*!< -5  System Service Call via SVC instruction                       */
  DebugMonitor_IRQn         =  -4,    /*!< -4  Debug Monitor                                                 */
  PendSV_IRQn               =  -2,    /*!< -2  Pendable request for system service                           */
  SysTick_IRQn              =  -1,    /*!< -1  System Tick Timer                                             */

/* ===========================================  STM32WBA65xx Specific Interrupt Numbers  ====================================== */
  WWDG_IRQn                 = 0,      /*!< Window WatchDog interrupt                                         */
  PVD_IRQn                  = 1,      /*!< PVD through EXTI Line detection Interrupt                         */
  RTC_IRQn                  = 2,      /*!< RTC non-secure interrupt                                          */
  RTC_S_IRQn                = 3,      /*!< RTC secure interrupt                                              */
  TAMP_IRQn                 = 4,      /*!< Tamper global interrupt                                           */
  RAMCFG_IRQn               = 5,      /*!< RAMCFG global interrupt                                           */
  FLASH_IRQn                = 6,      /*!< FLASH non-secure global interrupt                                 */
  FLASH_S_IRQn              = 7,      /*!< FLASH secure global interrupt                                     */
  GTZC_IRQn                 = 8,      /*!< Global TrustZone Controller interrupt                             */
  RCC_IRQn                  = 9,      /*!< RCC non secure global interrupt                                   */
  RCC_S_IRQn                = 10,     /*!< RCC secure global interrupt                                       */
  EXTI0_IRQn                = 11,     /*!< EXTI Line0 interrupt                                              */
  EXTI1_IRQn                = 12,     /*!< EXTI Line1 interrupt                                              */
  EXTI2_IRQn                = 13,     /*!< EXTI Line2 interrupt                                              */
  EXTI3_IRQn                = 14,     /*!< EXTI Line3 interrupt                                              */
  EXTI4_IRQn                = 15,     /*!< EXTI Line4 interrupt                                              */
  EXTI5_IRQn                = 16,     /*!< EXTI Line5 interrupt                                              */
  EXTI6_IRQn                = 17,     /*!< EXTI Line6 interrupt                                              */
  EXTI7_IRQn                = 18,     /*!< EXTI Line7 interrupt                                              */
  EXTI8_IRQn                = 19,     /*!< EXTI Line8 interrupt                                              */
  EXTI9_IRQn                = 20,     /*!< EXTI Line9 interrupt                                              */
  EXTI10_IRQn               = 21,     /*!< EXTI Line10 interrupt                                             */
  EXTI11_IRQn               = 22,     /*!< EXTI Line11 interrupt                                             */
  EXTI12_IRQn               = 23,     /*!< EXTI Line12 interrupt                                             */
  EXTI13_IRQn               = 24,     /*!< EXTI Line13 interrupt                                             */
  EXTI14_IRQn               = 25,     /*!< EXTI Line14 interrupt                                             */
  EXTI15_IRQn               = 26,     /*!< EXTI Line15 interrupt                                             */
  IWDG_IRQn                 = 27,     /*!< IWDG global interrupt                                             */
  SAES_IRQn                 = 28,     /*!< Secure AES global interrupt                                       */
  GPDMA1_Channel0_IRQn      = 29,     /*!< GPDMA1 Channel 0 global interrupt                                 */
  GPDMA1_Channel1_IRQn      = 30,     /*!< GPDMA1 Channel 1 global interrupt                                 */
  GPDMA1_Channel2_IRQn      = 31,     /*!< GPDMA1 Channel 2 global interrupt                                 */
  GPDMA1_Channel3_IRQn      = 32,     /*!< GPDMA1 Channel 3 global interrupt                                 */
  GPDMA1_Channel4_IRQn      = 33,     /*!< GPDMA1 Channel 4 global interrupt                                 */
  GPDMA1_Channel5_IRQn      = 34,     /*!< GPDMA1 Channel 5 global interrupt                                 */
  GPDMA1_Channel6_IRQn      = 35,     /*!< GPDMA1 Channel 6 global interrupt                                 */
  GPDMA1_Channel7_IRQn      = 36,     /*!< GPDMA1 Channel 7 global interrupt                                 */
  TIM1_BRK_IRQn             = 37,     /*!< TIM1 Break interrupt                                              */
  TIM1_UP_IRQn              = 38,     /*!< TIM1 Update interrupt                                             */
  TIM1_TRG_COM_IRQn         = 39,     /*!< TIM1 Trigger and Commutation interrupt                            */
  TIM1_CC_IRQn              = 40,     /*!< TIM1 Capture Compare interrupt                                    */
  TIM2_IRQn                 = 41,     /*!< TIM2 global interrupt                                             */
  TIM3_IRQn                 = 42,     /*!< TIM3 global interrupt                                             */
  I2C1_EV_IRQn              = 43,     /*!< I2C1 Event interrupt                                              */
  I2C1_ER_IRQn              = 44,     /*!< I2C1 Error interrupt                                              */
  SPI1_IRQn                 = 45,     /*!< SPI1 global interrupt                                             */
  USART1_IRQn               = 46,     /*!< USART1 global interrupt                                           */
  USART2_IRQn               = 47,     /*!< USART2 global interrupt                                           */
  LPUART1_IRQn              = 48,     /*!< LPUART1 global interrupt                                          */
  LPTIM1_IRQn               = 49,     /*!< LPTIM1 global interrupt                                           */
  LPTIM2_IRQn               = 50,     /*!< LPTIM2 global interrupt                                           */
  TIM16_IRQn                = 51,     /*!< TIM16 global interrupt                                            */
  TIM17_IRQn                = 52,     /*!< TIM17 global interrupt                                            */
  COMP_IRQn                 = 53,     /*!< COMP1 and COMP2 through EXTI Lines interrupts                     */
  I2C3_EV_IRQn              = 54,     /*!< I2C3 Event interrupt                                              */
  I2C3_ER_IRQn              = 55,     /*!< I2C3 Error interrupt                                              */
  SAI1_IRQn                 = 56,     /*!< Serial Audio Interface 1 global interrupt                         */
  TSC_IRQn                  = 57,     /*!< Touch Sense Controller global interrupt                           */
  AES_IRQn                  = 58,     /*!< AES global interrupt                                              */
  RNG_IRQn                  = 59,     /*!< RNG global interrupt                                              */
  FPU_IRQn                  = 60,     /*!< FPU global interrupt                                              */
  HASH_IRQn                 = 61,     /*!< HASH global interrupt                                             */
  PKA_IRQn                  = 62,     /*!< PKA global interrupt                                              */
  SPI3_IRQn                 = 63,     /*!< SPI3 global interrupt                                             */
  ICACHE_IRQn               = 64,     /*!< Instruction cache global interrupt                                */
  ADC4_IRQn                 = 65,     /*!< ADC4 global interrupt                                             */
  RADIO_IRQn                = 66,     /*!< 2.4GHz RADIO global interrupt                                     */
  WKUP_IRQn                 = 67,     /*!< PWR non-secure global WKUP pin interrupt                          */
  HSEM_IRQn                 = 68,     /*!< HSEM non-secure global interrupt                                  */
  HSEM_S_IRQn               = 69,     /*!< HSEM secure global interrupt                                      */
  WKUP_S_IRQn               = 70,     /*!< PWR secure global WKUP pin interrupt                              */
  RCC_AUDIOSYNC_IRQn        = 71,     /*!< RCC audio synchronization interrupt                               */
  TIM4_IRQn                 = 72,     /*!< TIM4 global interrupt                                             */
  I2C2_EV_IRQn              = 73,     /*!< I2C2 event interrupt                                              */
  I2C2_ER_IRQn              = 74,     /*!< I2c2 error interrupt                                              */
  SPI2_IRQn                 = 75,     /*!< SPI2 global interrupt                                             */
  USB_OTG_HS_IRQn           = 76,     /*!< USB OTG_HS global interrupt                                       */
  I2C4_EV_IRQn              = 77,     /*!< I2C4 event global interrupt                                       */
  I2C4_ER_IRQn              = 78,     /*!< I2C4 error global interrupt                                       */
  USART3_IRQn               = 79,     /*!< USART3 global interrupt                                           */
  EXTI19_RADIO_IO_IRQn      = 80,     /*!< EXTI line 19 interrupt, 2.4 GHz RADIO io[x]                       */
  EXTI20_RADIO_IO_IRQn      = 81,     /*!< EXTI line 20 interrupt, 2.4 GHz RADIO io[y]                       */
} IRQn_Type;


/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */
/* -------  Start of section using anonymous unions and disabling warnings  ------- */
#if   defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif

/* --------  Configuration of the STM32WBAxx System On Chip ------ */

/* --------  Configuration of the Cortex-M33 Processor and Core Peripherals  ------ */
#define __CM33_REV                0x0000U   /* Core revision r0p1 */
#define __SAUREGION_PRESENT       1U        /* SAU regions present */
#define __MPU_PRESENT             1U        /* MPU present */
#define __VTOR_PRESENT            1U        /* VTOR present */
#define __NVIC_PRIO_BITS          4U        /* Number of Bits used for Priority Levels */
#define __Vendor_SysTickConfig    0U        /* Set to 1 if different SysTick Config is used */
#define __FPU_PRESENT             1U        /* FPU present */
#define __DSP_PRESENT             1U        /* DSP extension present */

/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm33.h"                   /*!< ARM Cortex-M33 processor and core peripherals */
#include "system_stm32wbaxx.h"           /*!< system_stm32wbaxx System */


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */
/** @addtogroup STM32WBAxx_peripherals
  * @{
  */

/**
  * @brief Analog to Digital Converter (ADC)
  */
typedef struct
{
  __IO uint32_t ISR;          /*!< ADC interrupt and status register,             Address offset: 0x00 */
  __IO uint32_t IER;          /*!< ADC interrupt enable register,                 Address offset: 0x04 */
  __IO uint32_t CR;           /*!< ADC control register,                          Address offset: 0x08 */
  __IO uint32_t CFGR1;        /*!< ADC configuration register 1,                  Address offset: 0x0C */
  __IO uint32_t CFGR2;        /*!< ADC configuration register 2,                  Address offset: 0x10 */
  __IO uint32_t SMPR;         /*!< ADC sampling time register,                    Address offset: 0x14 */
       uint32_t RESERVED0[2]; /*!< Reserved,                                      Address offset: 0x18-0x1C */
  __IO uint32_t AWD1TR;       /*!< ADC analog watchdog 1 threshold register,      Address offset: 0x20 */
  __IO uint32_t AWD2TR;       /*!< ADC watchdog threshold register,               Address offset: 0x24 */
  __IO uint32_t CHSELR;       /*!< ADC channel select register,                   Address offset: 0x28 */
  __IO uint32_t AWD3TR;       /*!< ADC watchdog threshold register,               Address offset: 0x02C */
       uint32_t RESERVED1[4]; /*!< Reserved,                                      Address offset: 0x30-0x3C */
  __IO uint32_t DR;           /*!< ADC group regular data register,               Address offset: 0x40 */
  __IO uint32_t PWRR;         /*!< ADC power register,                            Address offset: 0x44 */
       uint32_t RESERVED2[22];/*!< Reserved,                                      Address offset: 0x48-0x9C */
  __IO uint32_t AWD2CR;       /*!< ADC analog watchdog 2 configuration register,  Address offset: 0xA0 */
  __IO uint32_t AWD3CR;       /*!< ADC analog watchdog 3 configuration register,  Address offset: 0xA4 */
       uint32_t RESERVED3[7]; /*!< Reserved,                                      Address offset: 0xA8-0xC0 */
  __IO uint32_t CALFACT;      /*!< ADC Calibration factor register,               Address offset: 0xC4 */
} ADC_TypeDef;

typedef struct
{
  __IO uint32_t CCR;          /*!< ADC common configuration register,             Address offset: 0x308 */
} ADC_Common_TypeDef;

/**
  * @brief Analog comparators (COMP)
  */
typedef struct
{
  __IO uint32_t CSR;            /*!< Comparator control and status register,   Address offset: 0x00 */
} COMP_TypeDef;

typedef struct
{
  __IO uint32_t CSR_ODD;        /*!< COMP control and status register located in register of comparator instance odd, used for bits common to several COMP instances, Address offset: 0x00 */
  __IO uint32_t CSR_EVEN;       /*!< COMP control and status register located in register of comparator instance even, used for bits common to several COMP instances, Address offset: 0x04 */
} COMP_Common_TypeDef;

/**
  * @brief CRC calculation unit
  */
typedef struct
{
  __IO uint32_t DR;             /*!< CRC Data register,                           Address offset: 0x00 */
  __IO uint32_t IDR;            /*!< CRC Independent data register,               Address offset: 0x04 */
  __IO uint32_t CR;             /*!< CRC Control register,                        Address offset: 0x08 */
       uint32_t RESERVED0;      /*!< Reserved,                                                    0x0C */
  __IO uint32_t INIT;           /*!< Initial CRC value register,                  Address offset: 0x10 */
  __IO uint32_t POL;            /*!< CRC polynomial register,                     Address offset: 0x14 */
} CRC_TypeDef;

/**
  * @brief AES hardware accelerator
  */
typedef struct
{
  __IO uint32_t CR;          /*!< AES control register,                        Address offset: 0x00 */
  __IO uint32_t SR;          /*!< AES status register,                         Address offset: 0x04 */
  __IO uint32_t DINR;        /*!< AES data input register,                     Address offset: 0x08 */
  __IO uint32_t DOUTR;       /*!< AES data output register,                    Address offset: 0x0C */
  __IO uint32_t KEYR0;       /*!< AES key register 0,                          Address offset: 0x10 */
  __IO uint32_t KEYR1;       /*!< AES key register 1,                          Address offset: 0x14 */
  __IO uint32_t KEYR2;       /*!< AES key register 2,                          Address offset: 0x18 */
  __IO uint32_t KEYR3;       /*!< AES key register 3,                          Address offset: 0x1C */
  __IO uint32_t IVR0;        /*!< AES initialization vector register 0,        Address offset: 0x20 */
  __IO uint32_t IVR1;        /*!< AES initialization vector register 1,        Address offset: 0x24 */
  __IO uint32_t IVR2;        /*!< AES initialization vector register 2,        Address offset: 0x28 */
  __IO uint32_t IVR3;        /*!< AES initialization vector register 3,        Address offset: 0x2C */
  __IO uint32_t KEYR4;       /*!< AES key register 4,                          Address offset: 0x30 */
  __IO uint32_t KEYR5;       /*!< AES key register 5,                          Address offset: 0x34 */
  __IO uint32_t KEYR6;       /*!< AES key register 6,                          Address offset: 0x38 */
  __IO uint32_t KEYR7;       /*!< AES key register 7,                          Address offset: 0x3C */
  __IO uint32_t SUSP0R;      /*!< AES Suspend register 0,                      Address offset: 0x40 */
  __IO uint32_t SUSP1R;      /*!< AES Suspend register 1,                      Address offset: 0x44 */
  __IO uint32_t SUSP2R;      /*!< AES Suspend register 2,                      Address offset: 0x48 */
  __IO uint32_t SUSP3R;      /*!< AES Suspend register 3,                      Address offset: 0x4C */
  __IO uint32_t SUSP4R;      /*!< AES Suspend register 4,                      Address offset: 0x50 */
  __IO uint32_t SUSP5R;      /*!< AES Suspend register 5,                      Address offset: 0x54 */
  __IO uint32_t SUSP6R;      /*!< AES Suspend register 6,                      Address offset: 0x58 */
  __IO uint32_t SUSP7R;      /*!< AES Suspend register 7,                      Address offset: 0x5C */
       uint32_t RESERVED1[168];/*!< Reserved,                                  Address offset: 0x60 -- 0x2FC */
  __IO uint32_t IER;         /*!< AES Interrupt Enable Register,               Address offset: 0x300 */
  __IO uint32_t ISR;         /*!< AES Interrupt Status Register,               Address offset: 0x304 */
  __IO uint32_t ICR;         /*!< AES Interrupt Clear Register,                Address offset: 0x308 */
} AES_TypeDef;

/**
  * @brief Debug MCU
  */
typedef struct
{
  __IO uint32_t IDCODE;          /*!< MCU device ID code,                             Address offset: 0x00 */
  __IO uint32_t SCR;             /*!< Debug MCU status and configuration register,    Address offset: 0x04 */
  __IO uint32_t APB1LFZR;        /*!< Debug MCU APB1 freeze register 1,               Address offset: 0x08 */
  __IO uint32_t APB1HFZR;        /*!< Debug MCU APB1 freeze register 2,               Address offset: 0x0C */
  __IO uint32_t APB2FZR;         /*!< Debug MCU APB2 freeze register,                 Address offset: 0x10 */
       uint32_t RESERVED1[4];    /*!< Reserved,                                       Address offset: 0x14 - 0x20 */
  __IO uint32_t APB7FZR;         /*!< Debug MCU APB7 freeze register,                 Address offset: 0x24 */
  __IO uint32_t AHB1FZR;         /*!< Debug MCU AHB1 freeze register,                 Address offset: 0x28 */
} DBGMCU_TypeDef;

/**
  * @brief DMA Controller
  */
typedef struct
{
  __IO uint32_t SECCFGR;      /*!< DMA secure configuration register,               Address offset: 0x00  */
  __IO uint32_t PRIVCFGR;     /*!< DMA privileged configuration register,           Address offset: 0x04  */
  __IO uint32_t RCFGLOCKR;    /*!< DMA secure and privilege lock register,          Address offset: 0x08  */
  __IO uint32_t MISR;         /*!< DMA non secure masked interrupt status register, Address offset: 0x0C  */
  __IO uint32_t SMISR;        /*!< DMA secure masked interrupt status register,     Address offset: 0x10  */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t CLBAR;         /*!< DMA channel x linked-list base address register, Address offset: 0x50 + (x * 0x80) */
       uint32_t RESERVED1[2];  /*!< Reserved 1,                                      Address offset: 0x54 -- 0x58      */
  __IO uint32_t CFCR;          /*!< DMA channel x flag clear register,               Address offset: 0x5C + (x * 0x80) */
  __IO uint32_t CSR;           /*!< DMA channel x flag status register,              Address offset: 0x60 + (x * 0x80) */
  __IO uint32_t CCR;           /*!< DMA channel x control register,                  Address offset: 0x64 + (x * 0x80) */
       uint32_t RESERVED2[10]; /*!< Reserved 2,                                      Address offset: 0x68 -- 0x8C      */
  __IO uint32_t CTR1;          /*!< DMA channel x transfer register 1,               Address offset: 0x90 + (x * 0x80) */
  __IO uint32_t CTR2;          /*!< DMA channel x transfer register 2,               Address offset: 0x94 + (x * 0x80) */
  __IO uint32_t CBR1;          /*!< DMA channel x block register 1,                  Address offset: 0x98 + (x * 0x80) */
  __IO uint32_t CSAR;          /*!< DMA channel x source address register,           Address offset: 0x9C + (x * 0x80) */
  __IO uint32_t CDAR;          /*!< DMA channel x destination address register,      Address offset: 0xA0 + (x * 0x80) */
       uint32_t RESERVED3[10]; /*!< Reserved 3,                                      Address offset: 0xA4 -- 0xC8      */
  __IO uint32_t CLLR;          /*!< DMA channel x linked-list address register,      Address offset: 0xCC + (x * 0x80) */
} DMA_Channel_TypeDef;

/**
  * @brief Asynch Interrupt/Event Controller (EXTI)
  */
typedef struct
{
  __IO uint32_t RTSR1;          /*!< EXTI Rising Trigger Selection Register 1,        Address offset:   0x00 */
  __IO uint32_t FTSR1;          /*!< EXTI Falling Trigger Selection Register 1,       Address offset:   0x04 */
  __IO uint32_t SWIER1;         /*!< EXTI Software Interrupt event Register 1,        Address offset:   0x08 */
  __IO uint32_t RPR1;           /*!< EXTI Rising Pending Register 1,                  Address offset:   0x0C */
  __IO uint32_t FPR1;           /*!< EXTI Falling Pending Register 1,                 Address offset:   0x10 */
  __IO uint32_t SECCFGR1;       /*!< EXTI Security Configuration Register 1,          Address offset:   0x14 */
  __IO uint32_t PRIVCFGR1;      /*!< EXTI Privilege Configuration Register 1,         Address offset:   0x18 */
       uint32_t RESERVED1[17];  /*!< Reserved 1,                                                0x1C -- 0x5C */
  __IO uint32_t EXTICR[4];      /*!< EXIT External Interrupt Configuration Register,            0x60 -- 0x6C */
  __IO uint32_t LOCKR;          /*!< EXTI Lock Register,                              Address offset:   0x70 */
       uint32_t RESERVED2[3];   /*!< Reserved 2,                                                0x74 -- 0x7C */
  __IO uint32_t IMR1;           /*!< EXTI Interrupt Mask Register 1,                  Address offset:   0x80 */
  __IO uint32_t EMR1;           /*!< EXTI Event Mask Register 1,                      Address offset:   0x84 */
} EXTI_TypeDef;

/**
  * @brief FLASH Registers
  */
typedef struct
{
  __IO uint32_t ACR;              /*!< FLASH access control register,                      Address offset: 0x00 */
       uint32_t RESERVED0;        /*!< RESERVED1,                                          Address offset: 0x04 */
  __IO uint32_t NSKEYR;           /*!< FLASH non-secure key register,                      Address offset: 0x08 */
  __IO uint32_t SECKEYR;          /*!< FLASH secure key register,                          Address offset: 0x0C */
  __IO uint32_t OPTKEYR;          /*!< FLASH option key register,                          Address offset: 0x10 */
       uint32_t RESERVED1;        /*!< Reserved1,                                          Address offset: 0x14 */
  __IO uint32_t PDKEY1R;          /*!< FLASH Bank 1 power-down key register,               Address offset: 0x18 */
  __IO uint32_t PDKEY2R;          /*!< FLASH Bank 2 power-down key register,               Address offset: 0x1C */
  __IO uint32_t NSSR;             /*!< FLASH non-secure status register,                   Address offset: 0x20 */
  __IO uint32_t SECSR;            /*!< FLASH secure status register,                       Address offset: 0x24 */
  __IO uint32_t NSCR1;            /*!< FLASH non-secure control register,                  Address offset: 0x28 */
  __IO uint32_t SECCR1;           /*!< FLASH secure control register,                      Address offset: 0x2C */
  __IO uint32_t ECCR;             /*!< FLASH ECC register,                                 Address offset: 0x30 */
  __IO uint32_t OPSR;             /*!< FLASH OPSR register,                                Address offset: 0x34 */
  __IO uint32_t NSCR2;            /*!< FLASH non-secure control register,                  Address offset: 0x38 */
  __IO uint32_t SECCR2;           /*!< FLASH secure control register,                      Address offset: 0x3C */
  __IO uint32_t OPTR;             /*!< FLASH option control register,                      Address offset: 0x40 */
  __IO uint32_t NSBOOTADD0R;      /*!< FLASH non-secure boot address 0 register,           Address offset: 0x44 */
  __IO uint32_t NSBOOTADD1R;      /*!< FLASH non-secure boot address 1 register,           Address offset: 0x48 */
  __IO uint32_t SECBOOTADD0R;     /*!< FLASH secure boot address 0 register,               Address offset: 0x4C */
  __IO uint32_t SECWM1R1;         /*!< FLASH bank 1 secure watermark1 register 1,          Address offset: 0x50 */
  __IO uint32_t SECWM1R2;         /*!< FLASH bank 1 secure watermark1 register 2,          Address offset: 0x54 */
  __IO uint32_t WRP1AR;           /*!< FLASH WRP bank 1 area A address register,           Address offset: 0x58 */
  __IO uint32_t WRP1BR;           /*!< FLASH WRP bank 1 area B address register,           Address offset: 0x5C */
  __IO uint32_t SECWM2R1;         /*!< FLASH bank 2 secure watermark2 register 1,          Address offset: 0x60 */
  __IO uint32_t SECWM2R2;         /*!< FLASH bank 2 secure watermark2 register 2,          Address offset: 0x64 */
  __IO uint32_t WRP2AR;           /*!< FLASH WRP bank 2 area A address register,           Address offset: 0x68 */
  __IO uint32_t WRP2BR;           /*!< FLASH WRP bank 2 area B address register,           Address offset: 0x6C */
  __IO uint32_t OEM1KEYR1;        /*!< FLASH OEM1 key register 1,                          Address offset: 0x70 */
  __IO uint32_t OEM1KEYR2;        /*!< FLASH OEM1 key register 2,                          Address offset: 0x74 */
  __IO uint32_t OEM2KEYR1;        /*!< FLASH OEM2 key register 1,                          Address offset: 0x78 */
  __IO uint32_t OEM2KEYR2;        /*!< FLASH OEM2 key register 2,                          Address offset: 0x7C */
  __IO uint32_t SECBB1R1;         /*!< FLASH bank 1 secure block-based bank register 1,    Address offset: 0x80 */
  __IO uint32_t SECBB1R2;         /*!< FLASH bank 1 secure block-based bank register 2,    Address offset: 0x84 */
  __IO uint32_t SECBB1R3;         /*!< FLASH bank 1 secure block-based bank register 3,    Address offset: 0x88 */
  __IO uint32_t SECBB1R4;         /*!< FLASH bank 1 secure block-based bank register 4,    Address offset: 0x8C */
       uint32_t RESERVED2[4];     /*!< Reserved2,                                          Address offset: 0x90-0x9C */
  __IO uint32_t SECBB2R1;         /*!< FLASH bank 2 secure block-based bank register 1,    Address offset: 0xA0 */
  __IO uint32_t SECBB2R2;         /*!< FLASH bank 2 secure block-based bank register 2,    Address offset: 0xA4 */
  __IO uint32_t SECBB2R3;         /*!< FLASH bank 2 secure block-based bank register 3,    Address offset: 0xA8 */
  __IO uint32_t SECBB2R4;         /*!< FLASH bank 2 secure block-based bank register 4,    Address offset: 0xAC */
       uint32_t RESERVED3[4];     /*!< Reserved3,                                          Address offset: 0xB0-0xBC */
  __IO uint32_t SECHDPCR;         /*!< FLASH secure HDP control register,                  Address offset: 0xC0 */
  __IO uint32_t PRIVCFGR;         /*!< FLASH privilege configuration register,             Address offset: 0xC4 */
       uint32_t RESERVED4[2];     /*!< Reserved4,                                          Address offset: 0xC8-0xCC */
  __IO uint32_t PRIVBB1R1;        /*!< FLASH bank 1 privilege block-based bank register 1, Address offset: 0xD0 */
  __IO uint32_t PRIVBB1R2;        /*!< FLASH bank 1 privilege block-based bank register 2, Address offset: 0xD4 */
  __IO uint32_t PRIVBB1R3;        /*!< FLASH bank 1 privilege block-based bank register 3, Address offset: 0xD8 */
  __IO uint32_t PRIVBB1R4;        /*!< FLASH bank 1 privilege block-based bank register 4, Address offset: 0xDC */
       uint32_t RESERVED5[4];     /*!< Reserved5,                                          Address offset: 0xE0-0xEC */
  __IO uint32_t PRIVBB2R1;        /*!< FLASH bank 2 privilege block-based bank register 1, Address offset: 0xF0 */
  __IO uint32_t PRIVBB2R2;        /*!< FLASH bank 2 privilege block-based bank register 2, Address offset: 0xF4 */
  __IO uint32_t PRIVBB2R3;        /*!< FLASH bank 2 privilege block-based bank register 3, Address offset: 0xF8 */
  __IO uint32_t PRIVBB2R4;        /*!< FLASH bank 2 privilege block-based bank register 4, Address offset: 0xFC */
} FLASH_TypeDef;

/**
  * @brief General Purpose I/O
  */
typedef struct
{
  __IO uint32_t MODER;       /*!< GPIO port mode register,               Address offset: 0x00      */
  __IO uint32_t OTYPER;      /*!< GPIO port output type register,        Address offset: 0x04      */
  __IO uint32_t OSPEEDR;     /*!< GPIO port output speed register,       Address offset: 0x08      */
  __IO uint32_t PUPDR;       /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
  __IO uint32_t IDR;         /*!< GPIO port input data register,         Address offset: 0x10      */
  __IO uint32_t ODR;         /*!< GPIO port output data register,        Address offset: 0x14      */
  __IO uint32_t BSRR;        /*!< GPIO port bit set/reset  register,     Address offset: 0x18      */
  __IO uint32_t LCKR;        /*!< GPIO port configuration lock register, Address offset: 0x1C      */
  __IO uint32_t AFR[2];      /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
  __IO uint32_t BRR;         /*!< GPIO Bit Reset register,               Address offset: 0x28      */
  __IO uint32_t HSLVR;       /*!< GPIO high-speed low voltage register,  Address offset: 0x2C      */
  __IO uint32_t SECCFGR;     /*!< GPIO secure configuration register,    Address offset: 0x30      */
} GPIO_TypeDef;

/**
  * @brief Global TrustZone Controller
  */
typedef struct
{
  __IO uint32_t CR;             /*!< TZSC control register,                                                Address offset: 0x00      */
       uint32_t RESERVED1[3];   /*!< Reserved1,                                                            Address offset: 0x04-0x0C */
  __IO uint32_t SECCFGR1;       /*!< TZSC secure configuration register 1,                                 Address offset: 0x10      */
  __IO uint32_t SECCFGR2;       /*!< TZSC secure configuration register 2,                                 Address offset: 0x14      */
  __IO uint32_t SECCFGR3;       /*!< TZSC secure configuration register 3,                                 Address offset: 0x18      */
       uint32_t RESERVED2;      /*!< Reserved2,                                                            Address offset: 0x1C      */
  __IO uint32_t PRIVCFGR1;      /*!< TZSC privilege configuration register 1,                              Address offset: 0x20      */
  __IO uint32_t PRIVCFGR2;      /*!< TZSC privilege configuration register 2,                              Address offset: 0x24      */
  __IO uint32_t PRIVCFGR3;      /*!< TZSC privilege configuration register 3,                              Address offset: 0x28      */
} GTZC_TZSC_TypeDef;

typedef struct
{
  __IO uint32_t CR;             /*!< MPCBBx control register,                  Address offset: 0x00        */
  uint32_t RESERVED1[3];        /*!< Reserved1,                                Address offset: 0x04-0x0C   */
  __IO uint32_t CFGLOCK;        /*!< MPCBBx lock register,                     Address offset: 0x10        */
  uint32_t RESERVED2[59];       /*!< Reserved2,                                Address offset: 0x14-0xFC   */
  __IO uint32_t SECCFGR[28];     /*!< MPCBBx security configuration registers, Address offset: 0x100-0x16C */
  uint32_t RESERVED3[36];       /*!< Reserved3,                                Address offset: 0x170-0x1FC */
  __IO uint32_t PRIVCFGR[28];    /*!< MPCBBx privilege configuration registers,Address offset: 0x200-0x26C */
} GTZC_MPCBB_TypeDef;

typedef struct
{
  __IO uint32_t IER1;           /*!< TZIC interrupt enable register 1, Address offset: 0x00 */
  __IO uint32_t IER2;           /*!< TZIC interrupt enable register 2, Address offset: 0x04 */
  __IO uint32_t IER3;           /*!< TZIC interrupt enable register 3, Address offset: 0x08 */
  __IO uint32_t IER4;           /*!< TZIC interrupt enable register 4, Address offset: 0x0C */
  __IO uint32_t SR1;            /*!< TZIC status register 1,           Address offset: 0x10 */
  __IO uint32_t SR2;            /*!< TZIC status register 2,           Address offset: 0x14 */
  __IO uint32_t SR3;            /*!< TZIC status register 3,           Address offset: 0x18 */
  __IO uint32_t SR4;            /*!< TZIC status register 4,           Address offset: 0x1C */
  __IO uint32_t FCR1;           /*!< TZIC flag clear register 1,       Address offset: 0x20 */
  __IO uint32_t FCR2;           /*!< TZIC flag clear register 2,       Address offset: 0x24 */
  __IO uint32_t FCR3;           /*!< TZIC flag clear register 3,       Address offset: 0x28 */
  __IO uint32_t FCR4;           /*!< TZIC flag clear register 3,       Address offset: 0x2C */
} GTZC_TZIC_TypeDef;

/**
  * @brief HASH
  */
typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
       uint32_t RESERVED0[52];    /*!< Reserved,                       Address offset: 0x28-0xF4   */
  __IO uint32_t CSR[54];          /*!< HASH context swap registers,    Address offset: 0x0F8-0x1CC */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */
typedef struct
{
  __IO uint32_t HR[8];     /*!< HASH digest registers,          Address offset: 0x310-0x32C */
} HASH_DIGEST_TypeDef;

/**
  * @brief HW Semaphore HSEM
  */
typedef struct
{
  __IO uint32_t R[16];      /*!< HSEM 2-step write lock and read back registers, Address offset: 00h-3Ch   */
   uint32_t  Reserved1[16]; /*!< Reserved                                        Address offset: 40h-7Ch   */
  __IO uint32_t RLR[16];    /*!< HSEM 1-step read lock registers,                Address offset: 80h-BCh   */
   uint32_t  Reserved2[16]; /*!< Reserved                                        Address offset: C0h-FCh   */
  __IO uint32_t IER;        /*!< HSEM interrupt enable register,                 Address offset: 100h      */
  __IO uint32_t ICR;        /*!< HSEM interrupt clear register,                  Address offset: 104h      */
  __IO uint32_t ISR;        /*!< HSEM interrupt status register,                 Address offset: 108h      */
  __IO uint32_t MISR;       /*!< HSEM masked interrupt status register,          Address offset: 10Ch      */
   uint32_t  Reserved3[28]; /*!< Reserved                                        Address offset: 110h-17Ch */
  __IO uint32_t SIER;       /*!< HSEM secure interrupt enable register,          Address offset: 180h      */
  __IO uint32_t SICR;       /*!< HSEM secure interrupt clear register,           Address offset: 184h      */
  __IO uint32_t SISR;       /*!< HSEM secure interrupt status register,          Address offset: 188h      */
  __IO uint32_t SMISR;      /*!< HSEM secure masked interrupt status register,   Address offset: 18Ch      */
   uint32_t  Reserved4[28]; /*!< Reserved                                        Address offset: 190h-1FCh */
  __IO uint32_t SECCFGR;    /*!< HSEM security configuration register,           Address offset: 200h      */
   uint32_t  Reserved5[3];  /*!< Reserved                                        Address offset: 204h-20Ch */
  __IO uint32_t PRIVCFGR;   /*!< HSEM privilege configuration register,          Address offset: 210h      */
   uint32_t  Reserved6[7];  /*!< Reserved                                        Address offset: 214h-22Ch */
  __IO uint32_t CR;         /*!< HSEM Semaphore clear register,                  Address offset: 230h      */
  __IO uint32_t KEYR;       /*!< HSEM Semaphore clear key register,              Address offset: 234h      */
} HSEM_TypeDef;

typedef struct
{
  __IO uint32_t IER;        /*!< HSEM interrupt enable register,                 Address offset:   0h      */
  __IO uint32_t ICR;        /*!< HSEM interrupt clear register,                  Address offset:   4h      */
  __IO uint32_t ISR;        /*!< HSEM interrupt status register,                 Address offset:   8h      */
  __IO uint32_t MISR;       /*!< HSEM masked interrupt status register,          Address offset:   Ch      */
   uint32_t  Reserved3[28]; /*!< Reserved                                        Address offset: 10h-7Ch   */
  __IO uint32_t SIER;       /*!< HSEM secure interrupt enable register,          Address offset: 80h       */
  __IO uint32_t SICR;       /*!< HSEM secure interrupt clear register,           Address offset: 84h       */
  __IO uint32_t SISR;       /*!< HSEM secure interrupt status register,          Address offset: 88h       */
  __IO uint32_t SMISR;      /*!< HSEM secure masked interrupt status register,   Address offset: 8Ch       */
} HSEM_Common_TypeDef;

/**
  * @brief Instruction Cache
  */
typedef struct
{
  __IO uint32_t CR;             /*!< ICACHE control register,                Address offset: 0x00 */
  __IO uint32_t SR;             /*!< ICACHE status register,                 Address offset: 0x04 */
  __IO uint32_t IER;            /*!< ICACHE interrupt enable register,       Address offset: 0x08 */
  __IO uint32_t FCR;            /*!< ICACHE Flag clear register,             Address offset: 0x0C */
  __IO uint32_t HMONR;          /*!< ICACHE hit monitor register,            Address offset: 0x10 */
  __IO uint32_t MMONR;          /*!< ICACHE miss monitor register,           Address offset: 0x14 */
       uint32_t RESERVED1[2];   /*!< Reserved,                               Address offset: 0x018-0x01C */
  __IO uint32_t CRR0;           /*!< ICACHE region 0 configuration register, Address offset: 0x20 */
  __IO uint32_t CRR1;           /*!< ICACHE region 1 configuration register, Address offset: 0x24 */
  __IO uint32_t CRR2;           /*!< ICACHE region 2 configuration register, Address offset: 0x28 */
  __IO uint32_t CRR3;           /*!< ICACHE region 3 configuration register, Address offset: 0x2C */
} ICACHE_TypeDef;

/**
  * @brief Inter-integrated Circuit Interface
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< I2C Control register 1,                         Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< I2C Control register 2,                         Address offset: 0x04 */
  __IO uint32_t OAR1;        /*!< I2C Own address 1 register,                     Address offset: 0x08 */
  __IO uint32_t OAR2;        /*!< I2C Own address 2 register,                     Address offset: 0x0C */
  __IO uint32_t TIMINGR;     /*!< I2C Timing register,                            Address offset: 0x10 */
  __IO uint32_t TIMEOUTR;    /*!< I2C Timeout register,                           Address offset: 0x14 */
  __IO uint32_t ISR;         /*!< I2C Interrupt and status register,              Address offset: 0x18 */
  __IO uint32_t ICR;         /*!< I2C Interrupt clear register,                   Address offset: 0x1C */
  __IO uint32_t PECR;        /*!< I2C PEC register,                               Address offset: 0x20 */
  __IO uint32_t RXDR;        /*!< I2C Receive data register,                      Address offset: 0x24 */
  __IO uint32_t TXDR;        /*!< I2C Transmit data register,                     Address offset: 0x28 */
  __IO uint32_t AUTOCR;      /*!< I2C Autonomous mode control register,           Address offset: 0x2C */
} I2C_TypeDef;

/**
  * @brief IWDG
  */
typedef struct
{
  __IO uint32_t KR;            /*!< IWDG Key register,          Address offset: 0x00 */
  __IO uint32_t PR;            /*!< IWDG Prescaler register,    Address offset: 0x04 */
  __IO uint32_t RLR;           /*!< IWDG Reload register,       Address offset: 0x08 */
  __IO uint32_t SR;            /*!< IWDG Status register,       Address offset: 0x0C */
  __IO uint32_t WINR;          /*!< IWDG Window register,       Address offset: 0x10 */
  __IO uint32_t EWCR;          /*!< IWDG Early Wakeup register, Address offset: 0x14 */
} IWDG_TypeDef;

/**
  * @brief LPTIMER
  */
typedef struct
{
  __IO uint32_t ISR;            /*!< LPTIM Interrupt and Status register,    Address offset: 0x00 */
  __IO uint32_t ICR;            /*!< LPTIM Interrupt Clear register,         Address offset: 0x04 */
  __IO uint32_t DIER;           /*!< LPTIM Interrupt Enable register,        Address offset: 0x08 */
  __IO uint32_t CFGR;           /*!< LPTIM Configuration register,           Address offset: 0x0C */
  __IO uint32_t CR;             /*!< LPTIM Control register,                 Address offset: 0x10 */
  __IO uint32_t CCR1;           /*!< LPTIM Capture/Compare register 1,       Address offset: 0x14 */
  __IO uint32_t ARR;            /*!< LPTIM Autoreload register,              Address offset: 0x18 */
  __IO uint32_t CNT;            /*!< LPTIM Counter register,                 Address offset: 0x1C */
  __IO uint32_t RESERVED0;      /*!< Reserved,                               Address offset: 0x20 */
  __IO uint32_t CFGR2;          /*!< LPTIM Configuration register 2,         Address offset: 0x24 */
  __IO uint32_t RCR;            /*!< LPTIM Repetition register,              Address offset: 0x28 */
  __IO uint32_t CCMR1;          /*!< LPTIM Capture/Compare mode register,    Address offset: 0x2C */
  __IO uint32_t RESERVED1;      /*!< Reserved,                               Address offset: 0x30 */
  __IO uint32_t CCR2;           /*!< LPTIM Capture/Compare register 2,       Address offset: 0x34 */
} LPTIM_TypeDef;

/**
  * @brief PKA
  */
typedef struct
{
  __IO uint32_t CR;            /*!< PKA control register,             Address offset: 0x00 */
  __IO uint32_t SR;            /*!< PKA status register,              Address offset: 0x04 */
  __IO uint32_t CLRFR;         /*!< PKA clear flag register,          Address offset: 0x08 */
  uint32_t Reserved[253];      /*!< Reserved memory area              Address offset: 0x0C  -> 0x03FC */
  __IO uint32_t RAM[1334];     /*!< PKA RAM                           Address offset: 0x400 -> 0x18D4 */
} PKA_TypeDef;

/**
  * @brief PTACONV
  */
typedef struct
{
  __IO uint32_t ACTCR;         /*!< PTACONV active control register,                     Address offset: 0x00 */
  __IO uint32_t PRICR;         /*!< PTACONV priority control register,                   Address offset: 0x04 */
  __IO uint32_t CR;            /*!< PTACONV control register,                            Address offset: 0x08 */
} PTACONV_TypeDef;

/**
  * @brief Power Control
  */
typedef struct
{
  __IO uint32_t CR1;           /*!< PWR power control register 1,                        Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< PWR power control register 2,                        Address offset: 0x04 */
  __IO uint32_t CR3;           /*!< PWR power control register 3,                        Address offset: 0x08 */
  __IO uint32_t VOSR;          /*!< PWR voltage scaling register,                        Address offset: 0x0C */
  __IO uint32_t SVMCR;         /*!< PWR supply voltage monitoring control register,      Address offset: 0x10 */
  __IO uint32_t WUCR1;         /*!< PWR wakeup control register 1,                       Address offset: 0x14 */
  __IO uint32_t WUCR2;         /*!< PWR wakeup control register 2,                       Address offset: 0x18 */
  __IO uint32_t WUCR3;         /*!< PWR wakeup control register 3,                       Address offset: 0x1C */
  __IO uint32_t RESERVED0[2];  /*!< Reserved,                                            Address offset: 0x20 -- 0x24 */
  __IO uint32_t DBPR;          /*!< PWR disable backup domain register,                  Address offset: 0x28 */
       uint32_t RESERVED1;     /*!< Reserved,                                            Address offset: 0x2C */
  __IO uint32_t SECCFGR;       /*!< PWR Security configuration register,                 Address offset: 0x30 */
  __IO uint32_t PRIVCFGR;      /*!< PWR privilege control register,                      Address offset: 0x34 */
  __IO uint32_t SR;            /*!< PWR status register,                                 Address offset: 0x38 */
  __IO uint32_t SVMSR;         /*!< PWR supply voltage monitoring status register,       Address offset: 0x3C */
       uint32_t RESERVED2;     /*!< Reserved,                                            Address offset: 0x40 */
  __IO uint32_t WUSR;          /*!< PWR wakeup status register,                          Address offset: 0x44 */
  __IO uint32_t WUSCR;         /*!< PWR wakeup status clear register,                    Address offset: 0x48 */
  __IO uint32_t APCR;          /*!< PWR apply pull configuration register,               Address offset: 0x4C */
  __IO uint32_t IORETENRA;     /*!< PWR Port A IO retention in Standby register,         Address offset: 0x50 */
  __IO uint32_t IORETRA;       /*!< PWR Port A IO retention status in Standby register,  Address offset: 0x54 */
  __IO uint32_t IORETENRB;     /*!< PWR Port B IO retention in Standby register,         Address offset: 0x58 */
  __IO uint32_t IORETRB;       /*!< PWR Port B IO retention status in Standby register,  Address offset: 0x5C */
  __IO uint32_t IORETENRC;     /*!< PWR Port C IO retention in Standby register,         Address offset: 0x60 */
  __IO uint32_t IORETRC;       /*!< PWR Port C IO retention status in Standby register,  Address offset: 0x64 */
  __IO uint32_t IORETENRD;     /*!< PWR Port D IO retention in Standby register,         Address offset: 0x68 */
  __IO uint32_t IORETRD;       /*!< PWR Port D IO retention status in Standby register,  Address offset: 0x6C */
  __IO uint32_t IORETENRE;     /*!< PWR Port E IO retention in Standby register,         Address offset: 0x70 */
  __IO uint32_t IORETRE;       /*!< PWR Port E IO retention status in Standby register,  Address offset: 0x74 */
       uint32_t RESERVED3[2];  /*!< Reserved,                                            Address offset: 0x78 -- 0x7C */
  __IO uint32_t IORETENRG;     /*!< PWR Port G IO retention in Standby register,         Address offset: 0x80 */
  __IO uint32_t IORETRG;       /*!< PWR Port G IO retention status in Standby register,  Address offset: 0x84 */
  __IO uint32_t IORETENRH;     /*!< PWR Port H IO retention in Standby register,         Address offset: 0x88 */
  __IO uint32_t IORETRH;       /*!< PWR Port H IO retention status in Standby register,  Address offset: 0x8C */
       uint32_t RESERVED4[28]; /*!< Reserved,                                            Address offset: 0x90 -- 0xFC */
  __IO uint32_t RADIOSCR;      /*!< PWR 2.4 GHZ radio status and control register,       Address offset: 0x100 */
  __IO uint32_t S2RETR;        /*!< PWR Stop 2 peripheral IOs retention register,        Address offset: 0x104 */
} PWR_TypeDef;

/**
  * @brief SRAMs configuration controller
  */
typedef struct
{
  __IO uint32_t CR;           /*!< Control Register,                  Address offset: 0x00 */
  __IO uint32_t IER;          /*!< Interrupt enable register,         Address offset: 0x04 */
  __IO uint32_t ISR;          /*!< Interrupt status register,         Address offset: 0x08 */
  uint32_t      RESERVED0;    /*!< Reserved,                          Address offset: 0x0C */
  __IO uint32_t PEAR;         /*!< Parity error address register,     Address offset: 0x10 */
  __IO uint32_t ICR;          /*!< Interrupt clear register,          Address offset: 0x14 */
  __IO uint32_t WPR1;         /*!< Write protection register 1,       Address offset: 0x18 */
  __IO uint32_t WPR2;         /*!< Write protection register 2,       Address offset: 0x1C */
  uint32_t      RESERVED1[2]; /*!< Reserved,                          Address offset: 0x20 -- 0x24 */
  __IO uint32_t ERKEYR;       /*!< Erase key register,                Address offset: 0x28 */
}RAMCFG_TypeDef;

/**
  * @brief Reset and Clock Control
  */
typedef struct
{
  __IO uint32_t CR;             /*!< RCC clock control register                             Address offset: 0x000 */
  uint32_t      RESERVED0[3];   /*!< Reserved                                                      0x004 -- 0x00C */
  __IO uint32_t ICSCR3;         /*!< RCC internal clock sources calibration register 3      Address offset: 0x010 */
  uint32_t      RESERVED1[2];   /*!< Reserved                                                      0x014 -- 0x018 */
  __IO uint32_t CFGR1;          /*!< RCC clock configuration register 1                     Address offset: 0x01C */
  __IO uint32_t CFGR2;          /*!< RCC clock configuration register 2                     Address offset: 0x020 */
  __IO uint32_t CFGR3;          /*!< RCC clock configuration register 3                     Address offset: 0x024 */
  __IO uint32_t PLL1CFGR;       /*!< PLL1 Configuration Register                            Address offset: 0x028 */
  uint32_t      RESERVED2[2];   /*!< Reserved                                                      0x02C -- 0x030 */
  __IO uint32_t PLL1DIVR;       /*!< PLL1 Dividers Configuration Register                   Address offset: 0x034 */
  __IO uint32_t PLL1FRACR;      /*!< PLL1 Fractional Divider Configuration Register         Address offset: 0x038 */
  uint32_t      RESERVED3[5];   /*!< Reserved                                                      0x03C -- 0x04C */
  __IO uint32_t CIER;           /*!< Clock Interrupt Enable Register                        Address offset: 0x050 */
  __IO uint32_t CIFR;           /*!< Clock Interrupt Flag Register                          Address offset: 0x054 */
  __IO uint32_t CICR;           /*!< Clock Interrupt Clear Register                         Address offset: 0x058 */
  uint32_t      RESERVED4;      /*!< Reserved                                               Address offset: 0x05C */
  __IO uint32_t AHB1RSTR;       /*!< AHB1 Peripherals Reset Register                        Address offset: 0x060 */
  __IO uint32_t AHB2RSTR;       /*!< AHB2 Peripherals Reset Register                        Address offset: 0x064 */
  uint32_t      RESERVED5;      /*!< Reserved                                               Address offset: 0x068 */
  __IO uint32_t AHB4RSTR;       /*!< AHB4 Peripherals Reset Register                        Address offset: 0x06C */
  __IO uint32_t AHB5RSTR;       /*!< AHB5 Peripherals Reset Register                        Address offset: 0x070 */
  __IO uint32_t APB1RSTR1;      /*!< APB1 Peripherals Reset Low Register                    Address offset: 0x074 */
  __IO uint32_t APB1RSTR2;      /*!< APB1 Peripherals Reset High Register                   Address offset: 0x078 */
  __IO uint32_t APB2RSTR;       /*!< APB2 Peripherals Reset Register                        Address offset: 0x07C */
  __IO uint32_t APB7RSTR;       /*!< APB7 Peripherals Reset Register                        Address offset: 0x080 */
  uint32_t      RESERVED6;      /*!< Reserved                                               Address offset: 0x084 */
  __IO uint32_t AHB1ENR;        /*!< AHB1 Peripherals Clock Enable Register                 Address offset: 0x088 */
  __IO uint32_t AHB2ENR;        /*!< AHB2 Peripherals Clock Enable Register                 Address offset: 0x08C */
  uint32_t      RESERVED7;      /*!< Reserved                                               Address offset: 0x090 */
  __IO uint32_t AHB4ENR;        /*!< AHB4 Peripherals Clock Enable Register                 Address offset: 0x094 */
  __IO uint32_t AHB5ENR;        /*!< AHB5 Peripherals Clock Enable Register                 Address offset: 0x098 */
  __IO uint32_t APB1ENR1;       /*!< APB1 Peripherals Clock Enable Low Register             Address offset: 0x09C */
  __IO uint32_t APB1ENR2;       /*!< APB1 Peripherals Clock Enable High Register            Address offset: 0x0A0 */
  __IO uint32_t APB2ENR;        /*!< APB2 Peripherals Clock Enable Register                 Address offset: 0x0A4 */
  __IO uint32_t APB7ENR;        /*!< APB7 Peripherals Clock Enable Register                 Address offset: 0x0A8 */
  uint32_t      RESERVED8;      /*!< Reserved                                               Address offset: 0x0AC */
  __IO uint32_t AHB1SMENR;      /*!< AHB1 Peripherals Clock Low Power Enable Register       Address offset: 0x0B0 */
  __IO uint32_t AHB2SMENR;      /*!< AHB2 Peripherals Clock Low Power Enable Register       Address offset: 0x0B4 */
  uint32_t      RESERVED9;      /*!< Reserved                                               Address offset: 0x0B8 */
  __IO uint32_t AHB4SMENR;      /*!< AHB4 Peripherals Clock Low Power Enable Register       Address offset: 0x0BC */
  __IO uint32_t AHB5SMENR;      /*!< AHB5 Peripherals Clock Low Power Enable Register       Address offset: 0x0C0 */
  __IO uint32_t APB1SMENR1;     /*!< APB1 Peripherals Clock Low Power Enable Low Register   Address offset: 0x0C4 */
  __IO uint32_t APB1SMENR2;     /*!< APB1 Peripherals Clock Low Power Enable High Register  Address offset: 0x0C8 */
  __IO uint32_t APB2SMENR;      /*!< APB2 Peripherals Clock Low Power Enable Register       Address offset: 0x0CC */
  __IO uint32_t APB7SMENR;      /*!< APB7 Peripherals Clock Low Power Enable Register       Address offset: 0x0D0 */
  uint32_t      RESERVED10[3];  /*!< Reserved                                                      0x0D4 -- 0x0DC */
  __IO uint32_t CCIPR1;         /*!< IPs Clocks Configuration Register 1                    Address offset: 0x0E0 */
  __IO uint32_t CCIPR2;         /*!< IPs Clocks Configuration Register 2                    Address offset: 0x0E4 */
  __IO uint32_t CCIPR3;         /*!< IPs Clocks Configuration Register 3                    Address offset: 0x0E8 */
  uint32_t      RESERVED11;     /*!< Reserved,                                              Address offset: 0x0EC */
  __IO uint32_t BDCR1;          /*!< Backup Domain Control Register 1                       Address offset: 0x0F0 */
  __IO uint32_t CSR;            /*!< V33 Clock Control & Status Register                    Address offset: 0x0F4 */
  __IO uint32_t BDCR2;          /*!< Backup Domain Control Register 2                       Address offset: 0x0F8 */
  uint32_t      RESERVED12[5];  /*!< Reserved                                                     0x0FC -- 0x010C */
  __IO uint32_t SECCFGR;        /*!< RCC secure configuration register                      Address offset: 0x110 */
  __IO uint32_t PRIVCFGR;       /*!< RCC privilege configuration register                   Address offset: 0x114 */
  uint32_t      RESERVED13[42]; /*!< Reserved                                                      0x118 -- 0x1BC */
  __IO uint32_t ASCR;           /*!< RCC privilege configuration register                   Address offset: 0x1C0 */
  __IO uint32_t ASIER;          /*!< RCC privilege configuration register                   Address offset: 0x1C4 */
  __IO uint32_t ASSR;           /*!< RCC privilege configuration register                   Address offset: 0x1C8 */
  __IO uint32_t ASCNTR;         /*!< RCC privilege configuration register                   Address offset: 0x1CC */
  __IO uint32_t ASARR;          /*!< RCC privilege configuration register                   Address offset: 0x1D0 */
  __IO uint32_t ASCAR;          /*!< RCC privilege configuration register                   Address offset: 0x1D4 */
  __IO uint32_t ASCOR;          /*!< RCC privilege configuration register                   Address offset: 0x1D8 */
  uint32_t      RESERVED14[9];  /*!< Reserved                                                      0x1DC -- 0x1FC */
  __IO uint32_t CFGR4;          /*!< RCC clock configuration register 4                     Address offset: 0x200 */
  uint32_t      RESERVED15;     /*!< Reserved                                               Address offset: 0x204 */
  __IO uint32_t RADIOENR;       /*!< RCC RADIO peripheral clock enable register             Address offset: 0x208 */
  uint32_t      RESERVED16;     /*!< Reserved                                               Address offset: 0x20C */
  __IO uint32_t ECSCR1;         /*!< RCC external clock sources calibration register 1      Address offset: 0x210 */
} RCC_TypeDef;

/**
  * @brief RNG
  */
typedef struct
{
  __IO uint32_t CR;      /*!< RNG control register,                   Address offset: 0x00 */
  __IO uint32_t SR;      /*!< RNG status register,                    Address offset: 0x04 */
  __IO uint32_t DR;      /*!< RNG data register,                      Address offset: 0x08 */
  uint32_t RESERVED;
  __IO uint32_t HTCR;    /*!< RNG health test configuration register, Address offset: 0x10 */
} RNG_TypeDef;

/*
* @brief RTC Specific device feature definitions
*/
#define RTC_BKP_NB         32U
#define RTC_BACKUP_NB      RTC_BKP_NB

#define RTC_TAMP_NB        6U

/**
  * @brief Real-Time Clock
  */
typedef struct
{
  __IO uint32_t TR;          /*!< RTC time register,                              Address offset: 0x00 */
  __IO uint32_t DR;          /*!< RTC date register,                              Address offset: 0x04 */
  __IO uint32_t SSR;         /*!< RTC sub second register,                        Address offset: 0x08 */
  __IO uint32_t ICSR;        /*!< RTC initialization control and status register, Address offset: 0x0C */
  __IO uint32_t PRER;        /*!< RTC prescaler register,                         Address offset: 0x10 */
  __IO uint32_t WUTR;        /*!< RTC wakeup timer register,                      Address offset: 0x14 */
  __IO uint32_t CR;          /*!< RTC control register,                           Address offset: 0x18 */
  __IO uint32_t PRIVCFGR;    /*!< RTC privilege mode control register,            Address offset: 0x1C */
  __IO uint32_t SECCFGR;     /*!< RTC secure mode control register,               Address offset: 0x20 */
  __IO uint32_t WPR;         /*!< RTC write protection register,                  Address offset: 0x24 */
  __IO uint32_t CALR;        /*!< RTC calibration register,                       Address offset: 0x28 */
  __IO uint32_t SHIFTR;      /*!< RTC shift control register,                     Address offset: 0x2C */
  __IO uint32_t TSTR;        /*!< RTC time stamp time register,                   Address offset: 0x30 */
  __IO uint32_t TSDR;        /*!< RTC time stamp date register,                   Address offset: 0x34 */
  __IO uint32_t TSSSR;       /*!< RTC time-stamp sub second register,             Address offset: 0x38 */
       uint32_t RESERVED1;   /*!< Reserved,                                       Address offset: 0x3C */
  __IO uint32_t ALRMAR;      /*!< RTC alarm A register,                           Address offset: 0x40 */
  __IO uint32_t ALRMASSR;    /*!< RTC alarm A sub second register,                Address offset: 0x44 */
  __IO uint32_t ALRMBR;      /*!< RTC alarm B register,                           Address offset: 0x48 */
  __IO uint32_t ALRMBSSR;    /*!< RTC alarm B sub second register,                Address offset: 0x4C */
  __IO uint32_t SR;          /*!< RTC Status register,                            Address offset: 0x50 */
  __IO uint32_t MISR;        /*!< RTC masked interrupt status register,           Address offset: 0x54 */
  __IO uint32_t SMISR;       /*!< RTC secure masked interrupt status register,    Address offset: 0x58 */
  __IO uint32_t SCR;         /*!< RTC status Clear register,                      Address offset: 0x5C */
       uint32_t RESERVED3[4];/*!< Reserved,                                       Address offset: 0x58 */
  __IO uint32_t ALRABINR;    /*!< RTC alarm A binary mode register,               Address offset: 0x70 */
  __IO uint32_t ALRBBINR;    /*!< RTC alarm B binary mode register,               Address offset: 0x74 */
} RTC_TypeDef;

/**
  * @brief Serial Audio Interface
  */
typedef struct
{
  __IO uint32_t GCR;          /*!< SAI global configuration register,        Address offset: 0x00 */
       uint32_t RESERVED[16]; /*!< Reserved,                                 Address offset: 0x04 to 0x40 */
  __IO uint32_t PDMCR;        /*!< SAI PDM control register,                 Address offset: 0x44 */
  __IO uint32_t PDMDLY;       /*!< SAI PDM delay register,                   Address offset: 0x48 */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;         /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;         /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;        /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;       /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;         /*!< SAI block x interrupt mask register,      Address offset: 0x14 */
  __IO uint32_t SR;          /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;       /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;          /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;

/**
  * @brief SPI
  */
typedef struct
{
  __IO uint32_t CR1;           /*!< SPI/I2S Control register 1,                      Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< SPI Control register 2,                          Address offset: 0x04 */
  __IO uint32_t CFG1;          /*!< SPI Configuration register 1,                    Address offset: 0x08 */
  __IO uint32_t CFG2;          /*!< SPI Configuration register 2,                    Address offset: 0x0C */
  __IO uint32_t IER;           /*!< SPI Interrupt Enable register,                   Address offset: 0x10 */
  __IO uint32_t SR;            /*!< SPI Status register,                             Address offset: 0x14 */
  __IO uint32_t IFCR;          /*!< SPI Interrupt/Status Flags Clear register,       Address offset: 0x18 */
  __IO uint32_t AUTOCR;        /*!< SPI Autonomous Mode Control register,            Address offset: 0x1C */
  __IO uint32_t TXDR;          /*!< SPI Transmit data register,                      Address offset: 0x20 */
  uint32_t      RESERVED1[3];  /*!< Reserved, 0x24-0x2C                                                   */
  __IO uint32_t RXDR;          /*!< SPI/I2S data register,                           Address offset: 0x30 */
  uint32_t      RESERVED2[3];  /*!< Reserved, 0x34-0x3C                                                   */
  __IO uint32_t CRCPOLY;       /*!< SPI CRC Polynomial register,                     Address offset: 0x40 */
  __IO uint32_t TXCRC;         /*!< SPI Transmitter CRC register,                    Address offset: 0x44 */
  __IO uint32_t RXCRC;         /*!< SPI Receiver CRC register,                       Address offset: 0x48 */
  __IO uint32_t UDRDR;         /*!< SPI Underrun data register,                      Address offset: 0x4C */
} SPI_TypeDef;

/**
  * @brief System configuration controller
  */
typedef struct
{
  __IO uint32_t SECCFGR;        /*!< SYSCFG secure configuration register,            Address offset: 0x00 */
  __IO uint32_t CFGR1;          /*!< SYSCFG configuration register 1,                 Address offset: 0x04 */
  __IO uint32_t FPUIMR;         /*!< SYSCFG FPU interrupt mask register,              Address offset: 0x08 */
  __IO uint32_t CNSLCKR;        /*!< SYSCFG CPU non-secure lock register,             Address offset: 0x0C */
  __IO uint32_t CSLCKR;         /*!< SYSCFG CPU secure lock register,                 Address offset: 0x10 */
  __IO uint32_t CFGR2;          /*!< SYSCFG configuration register 2,                 Address offset: 0x14 */
  __IO uint32_t MESR;           /*!< SYSCFG Memory Erase Status register,             Address offset: 0x18 */
  __IO uint32_t CCCSR;          /*!< SYSCFG Conpensation Cell Control&Status register,Address offset: 0x1C */
  __IO uint32_t CCVR;           /*!< SYSCFG Conpensation Cell value register,         Address offset: 0x20 */
  __IO uint32_t CCCR;           /*!< SYSCFG Conpensation Cell Code register,          Address offset: 0x24 */
       uint32_t RESERVED1;      /*!< RESERVED1,                                       Address offset: 0x28 */
  __IO uint32_t RSSCMDR;        /*!< SYSCFG RSS command mode register,                Address offset: 0x2C */
       uint32_t RESERVED2[17];  /*!< RESERVED2,                                       Address offset: 0x30-0x70 */
  __IO uint32_t OTGHSPHYCR;     /*!< SYSCFG USB OTG HS PHY control register,          Address offset: 0x74 */
       uint32_t RESERVED3;      /*!< RESERVED3,                                       Address offset: 0x78 */
  __IO uint32_t OTGHSPHYTUNER2; /*!< SYSCFG USB OTG HS PHY tune register 2,           Address offset: 0x7C */
} SYSCFG_TypeDef;

/**
  * @brief Tamper and backup registers
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< TAMP configuration register 1,                    Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TAMP configuration register 2,                    Address offset: 0x04 */
  __IO uint32_t CR3;         /*!< TAMP configuration register 3,                    Address offset: 0x08 */
  __IO uint32_t FLTCR;       /*!< TAMP filter control register,                     Address offset: 0x0C */
  __IO uint32_t ATCR1;       /*!< TAMP filter control register 1                    Address offset: 0x10 */
  __IO uint32_t ATSEEDR;     /*!< TAMP active tamper seed register,                 Address offset: 0x14 */
  __IO uint32_t ATOR;        /*!< TAMP active tamper output register,               Address offset: 0x18 */
  __IO uint32_t ATCR2;       /*!< TAMP filter control register 2,                   Address offset: 0x1C */
  __IO uint32_t SECCFGR;     /*!< TAMP secure mode control register,                Address offset: 0x20 */
  __IO uint32_t PRIVCFGR;    /*!< TAMP privilege mode control register,             Address offset: 0x24 */
       uint32_t RESERVED0;   /*!< Reserved,                                         Address offset: 0x28 */
  __IO uint32_t IER;         /*!< TAMP interrupt enable register,                   Address offset: 0x2C */
  __IO uint32_t SR;          /*!< TAMP status register,                             Address offset: 0x30 */
  __IO uint32_t MISR;        /*!< TAMP masked interrupt status register,            Address offset: 0x34 */
  __IO uint32_t SMISR;       /*!< TAMP secure masked interrupt status register,     Address offset: 0x38 */
  __IO uint32_t SCR;         /*!< TAMP status clear register,                       Address offset: 0x3C */
  __IO uint32_t COUNT1R;     /*!< TAMP monotonic counter 1 register,                Address offset: 0x40 */
       uint32_t RESERVED2[4];/*!< Reserved,                                         Address offset: 0x44 -- 0x50 */
  __IO uint32_t RPCFGR;      /*!< TAMP resources protection configuration register, Address offset: 0x54 */
       uint32_t RESERVED3[42];/*!< Reserved,                                        Address offset: 0x58 -- 0xFC */
  __IO uint32_t BKP0R;       /*!< TAMP backup register 0,                   Address offset: 0x100 */
  __IO uint32_t BKP1R;       /*!< TAMP backup register 1,                   Address offset: 0x104 */
  __IO uint32_t BKP2R;       /*!< TAMP backup register 2,                   Address offset: 0x108 */
  __IO uint32_t BKP3R;       /*!< TAMP backup register 3,                   Address offset: 0x10C */
  __IO uint32_t BKP4R;       /*!< TAMP backup register 4,                   Address offset: 0x110 */
  __IO uint32_t BKP5R;       /*!< TAMP backup register 5,                   Address offset: 0x114 */
  __IO uint32_t BKP6R;       /*!< TAMP backup register 6,                   Address offset: 0x118 */
  __IO uint32_t BKP7R;       /*!< TAMP backup register 7,                   Address offset: 0x11C */
  __IO uint32_t BKP8R;       /*!< TAMP backup register 8,                   Address offset: 0x120 */
  __IO uint32_t BKP9R;       /*!< TAMP backup register 9,                   Address offset: 0x124 */
  __IO uint32_t BKP10R;      /*!< TAMP backup register 10,                  Address offset: 0x128 */
  __IO uint32_t BKP11R;      /*!< TAMP backup register 11,                  Address offset: 0x12C */
  __IO uint32_t BKP12R;      /*!< TAMP backup register 12,                  Address offset: 0x130 */
  __IO uint32_t BKP13R;      /*!< TAMP backup register 13,                  Address offset: 0x134 */
  __IO uint32_t BKP14R;      /*!< TAMP backup register 14,                  Address offset: 0x138 */
  __IO uint32_t BKP15R;      /*!< TAMP backup register 15,                  Address offset: 0x13C */
  __IO uint32_t BKP16R;      /*!< TAMP backup register 16,                  Address offset: 0x140 */
  __IO uint32_t BKP17R;      /*!< TAMP backup register 17,                  Address offset: 0x144 */
  __IO uint32_t BKP18R;      /*!< TAMP backup register 18,                  Address offset: 0x148 */
  __IO uint32_t BKP19R;      /*!< TAMP backup register 19,                  Address offset: 0x14C */
  __IO uint32_t BKP20R;      /*!< TAMP backup register 20,                  Address offset: 0x150 */
  __IO uint32_t BKP21R;      /*!< TAMP backup register 21,                  Address offset: 0x154 */
  __IO uint32_t BKP22R;      /*!< TAMP backup register 22,                  Address offset: 0x158 */
  __IO uint32_t BKP23R;      /*!< TAMP backup register 23,                  Address offset: 0x15C */
  __IO uint32_t BKP24R;      /*!< TAMP backup register 24,                  Address offset: 0x160 */
  __IO uint32_t BKP25R;      /*!< TAMP backup register 25,                  Address offset: 0x164 */
  __IO uint32_t BKP26R;      /*!< TAMP backup register 26,                  Address offset: 0x168 */
  __IO uint32_t BKP27R;      /*!< TAMP backup register 27,                  Address offset: 0x16C */
  __IO uint32_t BKP28R;      /*!< TAMP backup register 28,                  Address offset: 0x170 */
  __IO uint32_t BKP29R;      /*!< TAMP backup register 29,                  Address offset: 0x174 */
  __IO uint32_t BKP30R;      /*!< TAMP backup register 30,                  Address offset: 0x178 */
  __IO uint32_t BKP31R;      /*!< TAMP backup register 31,                  Address offset: 0x17C */
} TAMP_TypeDef;

/**
  * @brief TIM
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< TIM control register 1,                   Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TIM control register 2,                   Address offset: 0x04 */
  __IO uint32_t SMCR;        /*!< TIM slave mode control register,          Address offset: 0x08 */
  __IO uint32_t DIER;        /*!< TIM DMA/interrupt enable register,        Address offset: 0x0C */
  __IO uint32_t SR;          /*!< TIM status register,                      Address offset: 0x10 */
  __IO uint32_t EGR;         /*!< TIM event generation register,            Address offset: 0x14 */
  __IO uint32_t CCMR1;       /*!< TIM capture/compare mode register 1,      Address offset: 0x18 */
  __IO uint32_t CCMR2;       /*!< TIM capture/compare mode register 2,      Address offset: 0x1C */
  __IO uint32_t CCER;        /*!< TIM capture/compare enable register,      Address offset: 0x20 */
  __IO uint32_t CNT;         /*!< TIM counter register,                     Address offset: 0x24 */
  __IO uint32_t PSC;         /*!< TIM prescaler,                            Address offset: 0x28 */
  __IO uint32_t ARR;         /*!< TIM auto-reload register,                 Address offset: 0x2C */
  __IO uint32_t RCR;         /*!< TIM repetition counter register,          Address offset: 0x30 */
  __IO uint32_t CCR1;        /*!< TIM capture/compare register 1,           Address offset: 0x34 */
  __IO uint32_t CCR2;        /*!< TIM capture/compare register 2,           Address offset: 0x38 */
  __IO uint32_t CCR3;        /*!< TIM capture/compare register 3,           Address offset: 0x3C */
  __IO uint32_t CCR4;        /*!< TIM capture/compare register 4,           Address offset: 0x40 */
  __IO uint32_t BDTR;        /*!< TIM break and dead-time register,         Address offset: 0x44 */
  __IO uint32_t CCR5;        /*!< TIM capture/compare register 5,           Address offset: 0x48 */
  __IO uint32_t CCR6;        /*!< TIM capture/compare register 6,           Address offset: 0x4C */
  __IO uint32_t CCMR3;       /*!< TIM capture/compare mode register 3,      Address offset: 0x50 */
  __IO uint32_t DTR2;        /*!< TIM deadtime register 2,                  Address offset: 0x54 */
  __IO uint32_t ECR;         /*!< TIM encoder control register,             Address offset: 0x58 */
  __IO uint32_t TISEL;       /*!< TIM Input Selection register,             Address offset: 0x5C */
  __IO uint32_t AF1;         /*!< TIM alternate function option register 1, Address offset: 0x60 */
  __IO uint32_t AF2;         /*!< TIM alternate function option register 2, Address offset: 0x64 */
  __IO uint32_t OR;          /*!< TIM option register,                      Address offset: 0x68 */
       uint32_t RESERVED0[220];/*!< Reserved,                               Address offset: 0x68-0x3D8 */
  __IO uint32_t DCR;         /*!< TIM DMA control register,                 Address offset: 0x3DC */
  __IO uint32_t DMAR;        /*!< TIM DMA address for full transfer,        Address offset: 0x3E0 */
} TIM_TypeDef;

/**
  * @brief TSC
  */
typedef struct
{
  __IO uint32_t CR;            /*!< TSC Control register,                            Address offset: 0x00 */
  __IO uint32_t IER;           /*!< TSC Interrupt Enable register,                   Address offset: 0x04 */
  __IO uint32_t ICR;           /*!< TSC Interrupt Control register,                  Address offset: 0x08 */
  __IO uint32_t ISR;           /*!< TSC Interrupt Status register,                   Address offset: 0x0C */
  __IO uint32_t IOHCR;         /*!< TSC I/O hysteresis control register,             Address offset: 0x10 */
  uint32_t      RESERVED0;     /*!< Reserved,                                        Address offset: 0x14 */
  __IO uint32_t IOASCR;        /*!< TSC I/O analog switch control register,          Address offset: 0x18 */
  uint32_t      RESERVED1;     /*!< Reserved,                                        Address offset: 0x1C */
  __IO uint32_t IOSCR;         /*!< TSC I/O sampling control register,               Address offset: 0x20 */
  uint32_t      RESERVED2;     /*!< Reserved,                                        Address offset: 0x24 */
  __IO uint32_t IOCCR;         /*!< TSC I/O channel control register,                Address offset: 0x28 */
  uint32_t      RESERVED3;     /*!< Reserved,                                        Address offset: 0x2C */
  __IO uint32_t IOGCSR;        /*!< TSC I/O group control status register,           Address offset: 0x30 */
  __IO uint32_t IOGXCR[7];     /*!< TSC I/O group x counter register,                Address offset: 0x34-4C */
} TSC_TypeDef;

/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< USART Control register 1,                 Address offset: 0x00  */
  __IO uint32_t CR2;         /*!< USART Control register 2,                 Address offset: 0x04  */
  __IO uint32_t CR3;         /*!< USART Control register 3,                 Address offset: 0x08  */
  __IO uint32_t BRR;         /*!< USART Baud rate register,                 Address offset: 0x0C  */
  __IO uint32_t GTPR;        /*!< USART Guard time and prescaler register,  Address offset: 0x10  */
  __IO uint32_t RTOR;        /*!< USART Receiver Time Out register,         Address offset: 0x14  */
  __IO uint32_t RQR;         /*!< USART Request register,                   Address offset: 0x18  */
  __IO uint32_t ISR;         /*!< USART Interrupt and status register,      Address offset: 0x1C  */
  __IO uint32_t ICR;         /*!< USART Interrupt flag Clear register,      Address offset: 0x20  */
  __IO uint32_t RDR;         /*!< USART Receive Data register,              Address offset: 0x24  */
  __IO uint32_t TDR;         /*!< USART Transmit Data register,             Address offset: 0x28  */
  __IO uint32_t PRESC;       /*!< USART Prescaler register,                 Address offset: 0x2C  */
  __IO uint32_t AUTOCR;      /*!< USART Autonomous mode control register    Address offset: 0x30  */
} USART_TypeDef;

/**
  * @brief VREFBUF
  */

typedef struct
{
  __IO uint32_t CSR;         /*!< VREFBUF control and status register,         Address offset: 0x00 */
  __IO uint32_t CCR;         /*!< VREFBUF calibration and control register,    Address offset: 0x04 */
} VREFBUF_TypeDef;

/**
  * @brief WWDG
  */
typedef struct
{
  __IO uint32_t CR;          /*!< WWDG Control register,       Address offset: 0x00 */
  __IO uint32_t CFR;         /*!< WWDG Configuration register, Address offset: 0x04 */
  __IO uint32_t SR;          /*!< WWDG Status register,        Address offset: 0x08 */
} WWDG_TypeDef;

/**
  * @brief USB_OTG_Core_Registers
  */
typedef struct
{
  __IO uint32_t GOTGCTL;              /*!< USB_OTG Control and Status Register          000h */
  __IO uint32_t GOTGINT;              /*!< USB_OTG Interrupt Register                   004h */
  __IO uint32_t GAHBCFG;              /*!< Core AHB Configuration Register              008h */
  __IO uint32_t GUSBCFG;              /*!< Core USB Configuration Register              00Ch */
  __IO uint32_t GRSTCTL;              /*!< Core Reset Register                          010h */
  __IO uint32_t GINTSTS;              /*!< Core Interrupt Register                      014h */
  __IO uint32_t GINTMSK;              /*!< Core Interrupt Mask Register                 018h */
  __IO uint32_t GRXSTSR;              /*!< Receive Sts Q Read Register                  01Ch */
  __IO uint32_t GRXSTSP;              /*!< Receive Sts Q Read & POP Register            020h */
  __IO uint32_t GRXFSIZ;              /*!< Receive FIFO Size Register                   024h */
  __IO uint32_t DIEPTXF0_HNPTXFSIZ;   /*!< EP0 / Non Periodic Tx FIFO Size Register     028h */
  __IO uint32_t HNPTXSTS;             /*!< Non Periodic Tx FIFO/Queue Sts reg           02Ch */
  uint32_t Reserved30[2];             /*!< Reserved                                     030h */
  __IO uint32_t GCCFG;                /*!< General Purpose IO Register                  038h */
  __IO uint32_t CID;                  /*!< User ID Register                             03Ch */
  __IO uint32_t GSNPSID;              /*! USB_OTG core ID                               040h */
    uint32_t Reserved44[4];           /*!< Reserved                                     044h */
  __IO uint32_t GLPMCFG;              /*!< LPM Register                                 054h */
  __IO uint32_t GPWRDN;               /*!< Power Down Register                          058h */
  __IO uint32_t GDFIFOCFG;            /*!< DFIFO Software Config Register               05Ch */
    uint32_t  Reserved60[40];         /*!< Reserved                                060h-0FFh */
  __IO uint32_t HPTXFSIZ;             /*!< Host Periodic Tx FIFO Size Reg               100h */
  __IO uint32_t DIEPTXF[0x0F];        /*!< dev Periodic Transmit FIFO                   104h */
} USB_OTG_GlobalTypeDef;


/**
  * @brief USB_OTG_device_Registers
  */
typedef struct
{
  __IO uint32_t DCFG;            /*!< dev Configuration Register   800h */
  __IO uint32_t DCTL;            /*!< dev Control Register         804h */
  __IO uint32_t DSTS;            /*!< dev Status Register (RO)     808h */
  uint32_t Reserved0C;           /*!< Reserved                     80Ch */
  __IO uint32_t DIEPMSK;         /*!< dev IN Endpoint Mask         810h */
  __IO uint32_t DOEPMSK;         /*!< dev OUT Endpoint Mask        814h */
  __IO uint32_t DAINT;           /*!< dev All Endpoints Itr Reg    818h */
  __IO uint32_t DAINTMSK;        /*!< dev All Endpoints Itr Mask   81Ch */
  uint32_t  Reserved20;          /*!< Reserved                     820h */
  uint32_t Reserved9;            /*!< Reserved                     824h */
  __IO uint32_t DVBUSDIS;        /*!< dev VBUS discharge Register  828h */
  __IO uint32_t DVBUSPULSE;      /*!< dev VBUS Pulse Register      82Ch */
  __IO uint32_t DTHRCTL;         /*!< dev threshold                830h */
  __IO uint32_t DIEPEMPMSK;      /*!< dev empty msk                834h */
  __IO uint32_t DEACHINT;        /*!< dedicated EP interrupt       838h */
  __IO uint32_t DEACHMSK;        /*!< dedicated EP msk             83Ch */
  uint32_t Reserved40;           /*!< dedicated EP mask            840h */
  __IO uint32_t DINEP1MSK;       /*!< dedicated EP mask            844h */
  uint32_t  Reserved44[15];      /*!< Reserved                 844-87Ch */
  __IO uint32_t DOUTEP1MSK;      /*!< dedicated EP msk             884h */
} USB_OTG_DeviceTypeDef;


/**
  * @brief USB_OTG_IN_Endpoint-Specific_Register
  */
typedef struct
{
  __IO uint32_t DIEPCTL;           /*!< dev IN Endpoint Control Reg    900h + (ep_num * 20h) + 00h */
  uint32_t Reserved04;             /*!< Reserved                       900h + (ep_num * 20h) + 04h */
  __IO uint32_t DIEPINT;           /*!< dev IN Endpoint Itr Reg        900h + (ep_num * 20h) + 08h */
  uint32_t Reserved0C;             /*!< Reserved                       900h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DIEPTSIZ;          /*!< IN Endpoint Txfer Size         900h + (ep_num * 20h) + 10h */
  __IO uint32_t DIEPDMA;           /*!< IN Endpoint DMA Address Reg    900h + (ep_num * 20h) + 14h */
  __IO uint32_t DTXFSTS;           /*!< IN Endpoint Tx FIFO Status Reg 900h + (ep_num * 20h) + 18h */
  uint32_t Reserved18;             /*!< Reserved 900h+(ep_num*20h)+1Ch-900h + (ep_num * 20h) + 1Ch */
} USB_OTG_INEndpointTypeDef;


/**
  * @brief USB_OTG_OUT_Endpoint-Specific_Registers
  */
typedef struct
{
  __IO uint32_t DOEPCTL;       /*!< dev OUT Endpoint Control Reg           B00h + (ep_num * 20h) + 00h */
  uint32_t Reserved04;         /*!< Reserved                               B00h + (ep_num * 20h) + 04h */
  __IO uint32_t DOEPINT;       /*!< dev OUT Endpoint Itr Reg               B00h + (ep_num * 20h) + 08h */
  uint32_t Reserved0C;         /*!< Reserved                               B00h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DOEPTSIZ;      /*!< dev OUT Endpoint Txfer Size            B00h + (ep_num * 20h) + 10h */
  __IO uint32_t DOEPDMA;       /*!< dev OUT Endpoint DMA Address           B00h + (ep_num * 20h) + 14h */
  uint32_t Reserved18[2];      /*!< Reserved B00h + (ep_num * 20h) + 18h - B00h + (ep_num * 20h) + 1Ch */
} USB_OTG_OUTEndpointTypeDef;


/**
  * @brief USB_OTG_Host_Mode_Register_Structures
  */
typedef struct
{
  __IO uint32_t HCFG;             /*!< Host Configuration Register          400h */
  __IO uint32_t HFIR;             /*!< Host Frame Interval Register         404h */
  __IO uint32_t HFNUM;            /*!< Host Frame Nbr/Frame Remaining       408h */
  uint32_t Reserved40C;           /*!< Reserved                             40Ch */
  __IO uint32_t HPTXSTS;          /*!< Host Periodic Tx FIFO/ Queue Status  410h */
  __IO uint32_t HAINT;            /*!< Host All Channels Interrupt Register 414h */
  __IO uint32_t HAINTMSK;         /*!< Host All Channels Interrupt Mask     418h */
} USB_OTG_HostTypeDef;

/**
  * @brief USB_OTG_Host_Channel_Specific_Registers
  */
typedef struct
{
  __IO uint32_t HCCHAR;           /*!< Host Channel Characteristics Register    500h */
  __IO uint32_t HCSPLT;           /*!< Host Channel Split Control Register      504h */
  __IO uint32_t HCINT;            /*!< Host Channel Interrupt Register          508h */
  __IO uint32_t HCINTMSK;         /*!< Host Channel Interrupt Mask Register     50Ch */
  __IO uint32_t HCTSIZ;           /*!< Host Channel Transfer Size Register      510h */
  __IO uint32_t HCDMA;            /*!< Host Channel DMA Address Register        514h */
  uint32_t Reserved[2];           /*!< Reserved                                      */
} USB_OTG_HostChannelTypeDef;

/*@}*/ /* end of group STM32WBA65xx_Peripherals */

/* --------  End of section using anonymous unions and disabling warnings  -------- */
#if   defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */
/** @addtogroup STM32WBAxx_Peripheral_peripheralAddr
  * @{
  */

/* Flash, Peripheral and internal SRAMs base addresses - Non secure */
#define FLASH_BASE_NS                   0x08000000UL  /*!< FLASH non-secure base address                      */
#define SYSTEM_FLASH_BASE_NS            0x0BF90000UL  /*!< System FLASH non-secure base address               */
#define SRAM1_BASE_NS                   0x20000000UL  /*!< SRAM1 non-secure base address                      */
#define SRAM2_BASE_NS                   0x20070000UL  /*!< SRAM2 non-secure base address                      */
#define SRAM6_BASE_NS                   0x48028000UL  /*!< 2.4 GHz RADIO TXRX SRAM non-secure base address    */
#define SEQSRAM_BASE_NS                 0x48021000UL  /*!< SRAM Sequence / retention non-secure base address  */
#define PERIPH_BASE_NS                  0x40000000UL  /*!< Peripheral non-secure base address                 */
#define DBGMCU_BASE                     0xE0044000UL  /*!< Debug MCU registers base address                   */

/*!< Memory sizes */
/* Internal Flash size */
#define FLASH_SIZE                      ((((*((uint16_t *)FLASHSIZE_BASE)) == 0xFFFFU)) ? 0x200000U : \
                                         ((((*((uint16_t *)FLASHSIZE_BASE)) == 0x0000U)) ? 0x200000U : \
                                           (((uint32_t)(*((uint16_t *)FLASHSIZE_BASE)) & (0xFFFFU)) << 10U)))

/* Internal SRAMs size */
#define SRAM1_SIZE                      0x00070000UL  /*!< SRAM1 = 448 Kbytes */
#define SRAM2_SIZE                      0x00010000UL  /*!< SRAM2 = 64 Kbytes */
#define SRAM6_SIZE                      0x00004000UL  /*!< 2.4 GHz RADIO TXRX SRAM 16 Kbytes   */
#define SEQSRAM_SIZE                    0x00000200UL  /*!< SRAM Sequence / retention 512 bytes */

/*!< OTP, Engineering bytes, Option bytes defines */
#define FLASH_OTP_BASE                  (SYSTEM_FLASH_BASE_NS + 0x00010000UL)
#define FLASH_OTP_SIZE                  0x00000200U  /*!< 512 bytes OTP (one-time programmable)          */

#define FLASH_ENGY_BASE                 (SYSTEM_FLASH_BASE_NS + 0x00010500UL)
#define PACKAGE_BASE                    (FLASH_ENGY_BASE)                 /*!< Package data register base address     */
#define UID_BASE                        (FLASH_ENGY_BASE + 0x00000200UL)  /*!< Unique device ID register base address */
#define FLASHSIZE_BASE                  (FLASH_ENGY_BASE + 0x000002A0UL)  /*!< Flash size data register base address  */
#define UID64_BASE                      (FLASH_ENGY_BASE + 0x00000500UL)  /*!< 64-bit Unique device Identification    */

/* Peripheral memory map - Non secure */
#define APB1PERIPH_BASE_NS              PERIPH_BASE_NS
#define APB2PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x00010000UL)
#define AHB1PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x00020000UL)
#define AHB2PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x02020000UL)
#define APB7PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x06000000UL)
#define AHB4PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x06020000UL)
#define AHB5PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x08020000UL)

/*!< APB1 Non secure peripherals */
#define TIM2_BASE_NS                    APB1PERIPH_BASE_NS
#define TIM3_BASE_NS                    (APB1PERIPH_BASE_NS + 0x0400UL)
#define TIM4_BASE_NS                    (APB1PERIPH_BASE_NS + 0x0800UL)
#define WWDG_BASE_NS                    (APB1PERIPH_BASE_NS + 0x2C00UL)
#define IWDG_BASE_NS                    (APB1PERIPH_BASE_NS + 0x3000UL)
#define SPI2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x3800UL)
#define USART2_BASE_NS                  (APB1PERIPH_BASE_NS + 0x4400UL)
#define USART3_BASE_NS                  (APB1PERIPH_BASE_NS + 0x4800UL)
#define I2C1_BASE_NS                    (APB1PERIPH_BASE_NS + 0x5400UL)
#define I2C2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x5800UL)
#define I2C4_BASE_NS                    (APB1PERIPH_BASE_NS + 0x8400UL)
#define LPTIM2_BASE_NS                  (APB1PERIPH_BASE_NS + 0x9400UL)

/*!< APB2 Non secure peripherals */
#define TIM1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x2C00UL)
#define SPI1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x3000UL)
#define USART1_BASE_NS                  (APB2PERIPH_BASE_NS + 0x3800UL)
#define TIM16_BASE_NS                   (APB2PERIPH_BASE_NS + 0x4400UL)
#define TIM17_BASE_NS                   (APB2PERIPH_BASE_NS + 0x4800UL)
#define SAI1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x5400UL)
#define SAI1_Block_A_BASE_NS            (SAI1_BASE_NS + 0x004UL)
#define SAI1_Block_B_BASE_NS            (SAI1_BASE_NS + 0x024UL)

/*!< AHB1 Non secure peripherals */
#define GPDMA1_BASE_NS                  AHB1PERIPH_BASE_NS
#define FLASH_R_BASE_NS                 (AHB1PERIPH_BASE_NS + 0x02000UL)
#define CRC_BASE_NS                     (AHB1PERIPH_BASE_NS + 0x03000UL)
#define TSC_BASE_NS                     (AHB1PERIPH_BASE_NS + 0x04000UL)
#define RAMCFG_BASE_NS                  (AHB1PERIPH_BASE_NS + 0x06000UL)
#define ICACHE_BASE_NS                  (AHB1PERIPH_BASE_NS + 0x10400UL)
#define GTZC_TZSC_BASE_NS               (AHB1PERIPH_BASE_NS + 0x12400UL)
#define GTZC_MPCBB1_BASE_NS             (AHB1PERIPH_BASE_NS + 0x12C00UL)
#define GTZC_MPCBB2_BASE_NS             (AHB1PERIPH_BASE_NS + 0x13000UL)
#define GTZC_MPCBB6_BASE_NS             (AHB1PERIPH_BASE_NS + 0x14000UL)

#define GPDMA1_Channel0_BASE_NS         (GPDMA1_BASE_NS + 0x0050UL)
#define GPDMA1_Channel1_BASE_NS         (GPDMA1_BASE_NS + 0x00D0UL)
#define GPDMA1_Channel2_BASE_NS         (GPDMA1_BASE_NS + 0x0150UL)
#define GPDMA1_Channel3_BASE_NS         (GPDMA1_BASE_NS + 0x01D0UL)
#define GPDMA1_Channel4_BASE_NS         (GPDMA1_BASE_NS + 0x0250UL)
#define GPDMA1_Channel5_BASE_NS         (GPDMA1_BASE_NS + 0x02D0UL)
#define GPDMA1_Channel6_BASE_NS         (GPDMA1_BASE_NS + 0x0350UL)
#define GPDMA1_Channel7_BASE_NS         (GPDMA1_BASE_NS + 0x03D0UL)

#define RAMCFG_SRAM1_BASE_NS            (RAMCFG_BASE_NS)
#define RAMCFG_SRAM2_BASE_NS            (RAMCFG_BASE_NS + 0x0040UL)
#define RAMCFG_SRAM6_BASE_NS            (RAMCFG_BASE_NS + 0x0140UL)

/*!< AHB2 Non secure peripherals */
#define GPIOA_BASE_NS                   AHB2PERIPH_BASE_NS
#define GPIOB_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00400UL)
#define GPIOC_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00800UL)
#define GPIOD_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00C00UL)
#define GPIOE_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x01000UL)
#define GPIOG_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x01800UL)
#define GPIOH_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x01C00UL)
#define USB_OTG_HS_BASE_NS              (AHB2PERIPH_BASE_NS + 0x20000UL)
#define AES_BASE_NS                     (AHB2PERIPH_BASE_NS + 0xA0000UL)
#define HASH_BASE_NS                    (AHB2PERIPH_BASE_NS + 0xA0400UL)
#define HASH_DIGEST_BASE_NS             (AHB2PERIPH_BASE_NS + 0xA0710UL)
#define RNG_BASE_NS                     (AHB2PERIPH_BASE_NS + 0xA0800UL)
#define SAES_BASE_NS                    (AHB2PERIPH_BASE_NS + 0xA0C00UL)
#define HSEM_BASE_NS                    (AHB2PERIPH_BASE_NS + 0xA1C00UL)
#define PKA_BASE_NS                     (AHB2PERIPH_BASE_NS + 0xA2000UL)
#define PKA_RAM_BASE_NS                 (AHB2PERIPH_BASE_NS + 0xA2400UL)

/*!< APB7 Non secure peripherals */
#define SYSCFG_BASE_NS                  (APB7PERIPH_BASE_NS + 0x0400UL)
#define SPI3_BASE_NS                    (APB7PERIPH_BASE_NS + 0x2000UL)
#define LPUART1_BASE_NS                 (APB7PERIPH_BASE_NS + 0x2400UL)
#define I2C3_BASE_NS                    (APB7PERIPH_BASE_NS + 0x2800UL)
#define LPTIM1_BASE_NS                  (APB7PERIPH_BASE_NS + 0x4400UL)
#define COMP12_BASE_NS                  (APB7PERIPH_BASE_NS + 0x5400UL)
#define COMP1_BASE_NS                   (COMP12_BASE_NS)
#define COMP2_BASE_NS                   (COMP12_BASE_NS + 0x04UL)
#define VREFBUF_BASE_NS                 (APB7PERIPH_BASE_NS + 0x7400UL)
#define RTC_BASE_NS                     (APB7PERIPH_BASE_NS + 0x7800UL)
#define TAMP_BASE_NS                    (APB7PERIPH_BASE_NS + 0x7C00UL)

/*!< AHB4 Non secure peripherals */
#define PWR_BASE_NS                     (AHB4PERIPH_BASE_NS + 0x0800UL)
#define RCC_BASE_NS                     (AHB4PERIPH_BASE_NS + 0x0C00UL)
#define ADC4_BASE_NS                    (AHB4PERIPH_BASE_NS + 0x1000UL)
#define ADC4_COMMON_BASE_NS             (AHB4PERIPH_BASE_NS + 0x1308UL)
#define EXTI_BASE_NS                    (AHB4PERIPH_BASE_NS + 0x2000UL)

/*!< AHB5 Non secure peripherals */
#define RADIO_BASE_NS                   AHB5PERIPH_BASE_NS
#define PTACONV_BASE_NS                 (AHB5PERIPH_BASE_NS + 0x18000UL)


#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)
/* Flash, Peripheral and internal SRAMs base addresses - Secure */
#define FLASH_BASE_S                    0x0C000000UL  /*!< FLASH secure base address                          */
#define SYSTEM_FLASH_BASE_S             0x0FF80000UL  /*!< System FLASH non-secure base address               */
#define SRAM1_BASE_S                    0x30000000UL  /*!< SRAM1 secure base address                          */
#define SRAM2_BASE_S                    0x30070000UL  /*!< SRAM2 secure base address                          */
#define SRAM6_BASE_S                    0x58028000UL  /*!< 2.4 GHz RADIO TXRX SRAM secure base address        */
#define SEQSRAM_BASE_S                  0x58021000UL  /*!< SRAM Sequence / retention non-secure base address  */
#define PERIPH_BASE_S                   0x50000000UL  /*!< Peripheral secure base address                     */

/* Peripheral memory map - Secure */
#define APB1PERIPH_BASE_S               PERIPH_BASE_S
#define APB2PERIPH_BASE_S               (PERIPH_BASE_S + 0x00010000UL)
#define AHB1PERIPH_BASE_S               (PERIPH_BASE_S + 0x00020000UL)
#define AHB2PERIPH_BASE_S               (PERIPH_BASE_S + 0x02020000UL)
#define APB7PERIPH_BASE_S               (PERIPH_BASE_S + 0x06000000UL)
#define AHB4PERIPH_BASE_S               (PERIPH_BASE_S + 0x06020000UL)
#define AHB5PERIPH_BASE_S               (PERIPH_BASE_S + 0x08020000UL)

/*!< APB1 Secure peripherals */
#define TIM2_BASE_S                      APB1PERIPH_BASE_S
#define TIM3_BASE_S                     (APB1PERIPH_BASE_S + 0x0400UL)
#define TIM4_BASE_S                     (APB1PERIPH_BASE_S + 0x0800UL)
#define WWDG_BASE_S                     (APB1PERIPH_BASE_S + 0x2C00UL)
#define IWDG_BASE_S                     (APB1PERIPH_BASE_S + 0x3000UL)
#define SPI2_BASE_S                     (APB1PERIPH_BASE_S + 0x3800UL)
#define USART2_BASE_S                   (APB1PERIPH_BASE_S + 0x4400UL)
#define USART3_BASE_S                   (APB1PERIPH_BASE_S + 0x4800UL)
#define I2C1_BASE_S                     (APB1PERIPH_BASE_S + 0x5400UL)
#define I2C2_BASE_S                     (APB1PERIPH_BASE_S + 0x5800UL)
#define I2C4_BASE_S                     (APB1PERIPH_BASE_S + 0x8400UL)
#define LPTIM2_BASE_S                   (APB1PERIPH_BASE_S + 0x9400UL)

/*!< APB2 Secure peripherals */
#define TIM1_BASE_S                     (APB2PERIPH_BASE_S + 0x2C00UL)
#define SPI1_BASE_S                     (APB2PERIPH_BASE_S + 0x3000UL)
#define USART1_BASE_S                   (APB2PERIPH_BASE_S + 0x3800UL)
#define TIM16_BASE_S                    (APB2PERIPH_BASE_S + 0x4400UL)
#define TIM17_BASE_S                    (APB2PERIPH_BASE_S + 0x4800UL)
#define SAI1_BASE_S                     (APB2PERIPH_BASE_S + 0x5400UL)
#define SAI1_Block_A_BASE_S             (SAI1_BASE_S + 0x004UL)
#define SAI1_Block_B_BASE_S             (SAI1_BASE_S + 0x024UL)

/*!< AHB1 Secure peripherals */
#define GPDMA1_BASE_S                   AHB1PERIPH_BASE_S
#define FLASH_R_BASE_S                  (AHB1PERIPH_BASE_S + 0x02000UL)
#define CRC_BASE_S                      (AHB1PERIPH_BASE_S + 0x03000UL)
#define TSC_BASE_S                      (AHB1PERIPH_BASE_S + 0x04000UL)
#define RAMCFG_BASE_S                   (AHB1PERIPH_BASE_S + 0x06000UL)
#define ICACHE_BASE_S                   (AHB1PERIPH_BASE_S + 0x10400UL)
#define GTZC_TZSC_BASE_S                (AHB1PERIPH_BASE_S + 0x12400UL)
#define GTZC_TZIC_BASE_S                (AHB1PERIPH_BASE_S + 0x12800UL)
#define GTZC_MPCBB1_BASE_S              (AHB1PERIPH_BASE_S + 0x12C00UL)
#define GTZC_MPCBB2_BASE_S              (AHB1PERIPH_BASE_S + 0x13000UL)
#define GTZC_MPCBB6_BASE_S              (AHB1PERIPH_BASE_S + 0x14000UL)

#define GPDMA1_Channel0_BASE_S          (GPDMA1_BASE_S + 0x0050UL)
#define GPDMA1_Channel1_BASE_S          (GPDMA1_BASE_S + 0x00D0UL)
#define GPDMA1_Channel2_BASE_S          (GPDMA1_BASE_S + 0x0150UL)
#define GPDMA1_Channel3_BASE_S          (GPDMA1_BASE_S + 0x01D0UL)
#define GPDMA1_Channel4_BASE_S          (GPDMA1_BASE_S + 0x0250UL)
#define GPDMA1_Channel5_BASE_S          (GPDMA1_BASE_S + 0x02D0UL)
#define GPDMA1_Channel6_BASE_S          (GPDMA1_BASE_S + 0x0350UL)
#define GPDMA1_Channel7_BASE_S          (GPDMA1_BASE_S + 0x03D0UL)

#define RAMCFG_SRAM1_BASE_S             (RAMCFG_BASE_S)
#define RAMCFG_SRAM2_BASE_S             (RAMCFG_BASE_S + 0x0040UL)
#define RAMCFG_SRAM6_BASE_S             (RAMCFG_BASE_S + 0x0140UL)

/*!< AHB2 Secure peripherals */
#define GPIOA_BASE_S                    AHB2PERIPH_BASE_S
#define GPIOB_BASE_S                    (AHB2PERIPH_BASE_S + 0x00400UL)
#define GPIOC_BASE_S                    (AHB2PERIPH_BASE_S + 0x00800UL)
#define GPIOD_BASE_S                    (AHB2PERIPH_BASE_S + 0x00C00UL)
#define GPIOE_BASE_S                    (AHB2PERIPH_BASE_S + 0x01000UL)
#define GPIOG_BASE_S                    (AHB2PERIPH_BASE_S + 0x01800UL)
#define GPIOH_BASE_S                    (AHB2PERIPH_BASE_S + 0x01C00UL)
#define USB_OTG_HS_BASE_S               (AHB2PERIPH_BASE_S + 0x20000UL)
#define AES_BASE_S                      (AHB2PERIPH_BASE_S + 0xA0000UL)
#define HASH_BASE_S                     (AHB2PERIPH_BASE_S + 0xA0400UL)
#define HASH_DIGEST_BASE_S              (AHB2PERIPH_BASE_S + 0xA0710UL)
#define RNG_BASE_S                      (AHB2PERIPH_BASE_S + 0xA0800UL)
#define SAES_BASE_S                     (AHB2PERIPH_BASE_S + 0xA0C00UL)
#define HSEM_BASE_S                     (AHB2PERIPH_BASE_S + 0xA1C00UL)
#define PKA_BASE_S                      (AHB2PERIPH_BASE_S + 0xA2000UL)
#define PKA_RAM_BASE_S                  (AHB2PERIPH_BASE_S + 0xA2400UL)

/*!< APB7 Secure peripherals */
#define SYSCFG_BASE_S                   (APB7PERIPH_BASE_S + 0x0400UL)
#define SPI3_BASE_S                     (APB7PERIPH_BASE_S + 0x2000UL)
#define LPUART1_BASE_S                  (APB7PERIPH_BASE_S + 0x2400UL)
#define I2C3_BASE_S                     (APB7PERIPH_BASE_S + 0x2800UL)
#define LPTIM1_BASE_S                   (APB7PERIPH_BASE_S + 0x4400UL)
#define COMP12_BASE_S                   (APB7PERIPH_BASE_S + 0x5400UL)
#define COMP1_BASE_S                    (COMP12_BASE_S)
#define COMP2_BASE_S                    (COMP12_BASE_S + 0x04UL)
#define VREFBUF_BASE_S                  (APB7PERIPH_BASE_S + 0x7400UL)
#define RTC_BASE_S                      (APB7PERIPH_BASE_S + 0x7800UL)
#define TAMP_BASE_S                     (APB7PERIPH_BASE_S + 0x7C00UL)

/*!< AHB4 Secure peripherals */
#define PWR_BASE_S                      (AHB4PERIPH_BASE_S + 0x0800UL)
#define RCC_BASE_S                      (AHB4PERIPH_BASE_S + 0x0C00UL)
#define ADC4_BASE_S                     (AHB4PERIPH_BASE_S + 0x1000UL)
#define ADC4_COMMON_BASE_S              (AHB4PERIPH_BASE_S + 0x1308UL)
#define EXTI_BASE_S                     (AHB4PERIPH_BASE_S + 0x2000UL)

/*!< AHB5 Secure peripherals */
#define RADIO_BASE_S                    AHB5PERIPH_BASE_S
#define PTACONV_BASE_S                  (AHB5PERIPH_BASE_S + 0x18000UL)
#endif

/************ RSSLIB SAU system Flash region definition constants *************/
#define RSSLIB_SYS_FLASH_NS_PFUNC_START (SYSTEM_FLASH_BASE_NS + 0x00007E40UL)
#define RSSLIB_SYS_FLASH_NS_PFUNC_END   (SYSTEM_FLASH_BASE_NS + 0x00007E6BUL)

/************ RSSLIB function return constants ********************************/
#define RSSLIB_ERROR                    0xF5F5F5F5UL
#define RSSLIB_SUCCESS                  0xEAEAEAEAUL

/*!< RSSLIB  pointer function structure address definition */
#define RSSLIB_PFUNC_BASE               RSSLIB_SYS_FLASH_NS_PFUNC_START
#define RSSLIB_PFUNC                    ((RSSLIB_pFunc_TypeDef *)RSSLIB_PFUNC_BASE)

/*!< HDP Area constant definition */
#define RSSLIB_HDP_AREA_Pos  (0UL)
#define RSSLIB_HDP_AREA_Msk  (0x3UL << RSSLIB_HDP_AREA_Pos )
#define RSSLIB_HDP_AREA1_Pos (0UL)
#define RSSLIB_HDP_AREA1_Msk (0x1UL << RSSLIB_HDP_AREA1_Pos )
#define RSSLIB_HDP_AREA2_Pos (1UL)
#define RSSLIB_HDP_AREA2_Msk (0x1UL << RSSLIB_HDP_AREA2_Pos )

/**
  * @brief  Prototype of RSSLIB Close and exit HDP Function
  * @detail This function close the requested hdp area passed in input
  *         parameter and jump to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  HdpArea notifies which hdp area to close, can be a combination of
  *         hdpa area 1 and hdp area 2
  * @param  VectorTableAddr pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t ( *RSSLIB_S_CloseExitHDP_TypeDef)( uint32_t HdpArea, uint32_t VectorTableAddr );


/**
  * @brief RSSLib non-secure callable function pointer structure
  */
typedef struct
{
  __IM uint32_t Reserved[8];
}NSC_pFuncTypeDef;

/**
  * @brief RSSLib secure callable function pointer structure
  */
typedef struct
{
  __IM uint32_t Reserved2[2];
  __IM RSSLIB_S_CloseExitHDP_TypeDef CloseExitHDP;       /*!< RSSLIB Close and exit HDP Address offset: 0x28 */
}S_pFuncTypeDef;

/**
  * @brief RSSLib function pointer structure
  */
typedef struct
{
  NSC_pFuncTypeDef NSC;
  S_pFuncTypeDef S;
}RSSLIB_pFunc_TypeDef;


/** @} */ /* End of group STM32WBAxx_Peripheral_peripheralAddr */
/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */
/** @addtogroup STM32WBAxx_Peripheral_declaration
  * @{
  */
#define DBGMCU                          ((DBGMCU_TypeDef *) DBGMCU_BASE)

#define ADC4_NS                         ((ADC_TypeDef *) ADC4_BASE_NS)
#define ADC4_COMMON_NS                  ((ADC_Common_TypeDef *) ADC4_COMMON_BASE_NS)
#define AES_NS                          ((AES_TypeDef *) AES_BASE_NS)
#define COMP1_NS                        ((COMP_TypeDef *) COMP1_BASE_NS)
#define COMP2_NS                        ((COMP_TypeDef *) COMP2_BASE_NS)
#define COMP12_COMMON_NS                ((COMP_Common_TypeDef *) COMP1_BASE_NS)
#define CRC_NS                          ((CRC_TypeDef *) CRC_BASE_NS)
#define EXTI_NS                         ((EXTI_TypeDef *) EXTI_BASE_NS)
#define FLASH_NS                        ((FLASH_TypeDef *) FLASH_R_BASE_NS)
#define GPDMA1_NS                       ((DMA_TypeDef *) GPDMA1_BASE_NS)
#define GPDMA1_Channel0_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_NS)
#define GPDMA1_Channel1_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_NS)
#define GPDMA1_Channel2_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_NS)
#define GPDMA1_Channel3_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_NS)
#define GPDMA1_Channel4_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_NS)
#define GPDMA1_Channel5_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_NS)
#define GPDMA1_Channel6_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_NS)
#define GPDMA1_Channel7_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_NS)
#define GPIOA_NS                        ((GPIO_TypeDef *) GPIOA_BASE_NS)
#define GPIOB_NS                        ((GPIO_TypeDef *) GPIOB_BASE_NS)
#define GPIOC_NS                        ((GPIO_TypeDef *) GPIOC_BASE_NS)
#define GPIOD_NS                        ((GPIO_TypeDef *) GPIOD_BASE_NS)
#define GPIOE_NS                        ((GPIO_TypeDef *) GPIOE_BASE_NS)
#define GPIOG_NS                        ((GPIO_TypeDef *) GPIOG_BASE_NS)
#define GPIOH_NS                        ((GPIO_TypeDef *) GPIOH_BASE_NS)
#define GTZC_MPCBB1_NS                  ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_NS)
#define GTZC_MPCBB2_NS                  ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_NS)
#define GTZC_MPCBB6_NS                  ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB6_BASE_NS)
#define GTZC_TZSC_NS                    ((GTZC_TZSC_TypeDef *) GTZC_TZSC_BASE_NS)
#define HASH_NS                         ((HASH_TypeDef *) HASH_BASE_NS)
#define HASH_DIGEST_NS                  ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_NS)
#define HSEM_NS                         ((HSEM_TypeDef *) HSEM_BASE_NS)
#define HSEM_COMMON_NS                  ((HSEM_Common_TypeDef *) (HSEM_BASE_NS + 0x100U))
#define I2C1_NS                         ((I2C_TypeDef *) I2C1_BASE_NS)
#define I2C2_NS                         ((I2C_TypeDef *) I2C2_BASE_NS)
#define I2C3_NS                         ((I2C_TypeDef *) I2C3_BASE_NS)
#define I2C4_NS                         ((I2C_TypeDef *) I2C4_BASE_NS)
#define ICACHE_NS                       ((ICACHE_TypeDef *) ICACHE_BASE_NS)
#define IWDG_NS                         ((IWDG_TypeDef *) IWDG_BASE_NS)
#define LPTIM1_NS                       ((LPTIM_TypeDef *) LPTIM1_BASE_NS)
#define LPTIM2_NS                       ((LPTIM_TypeDef *) LPTIM2_BASE_NS)
#define LPUART1_NS                      ((USART_TypeDef *) LPUART1_BASE_NS)
#define USB_OTG_HS_NS                   ((USB_OTG_GlobalTypeDef *) USB_OTG_HS_BASE_NS)
#define PKA_NS                          ((PKA_TypeDef *) PKA_BASE_NS)
#define PTACONV_NS                      ((PTACONV_TypeDef *) PTACONV_BASE_NS)
#define PWR_NS                          ((PWR_TypeDef *) PWR_BASE_NS)
#define RAMCFG_SRAM1_NS                 ((RAMCFG_TypeDef *) RAMCFG_SRAM1_BASE_NS)
#define RAMCFG_SRAM2_NS                 ((RAMCFG_TypeDef *) RAMCFG_SRAM2_BASE_NS)
#define RAMCFG_SRAM6_NS                 ((RAMCFG_TypeDef *) RAMCFG_SRAM6_BASE_NS)
#define RCC_NS                          ((RCC_TypeDef *) RCC_BASE_NS)
#define RNG_NS                          ((RNG_TypeDef *) RNG_BASE_NS)
#define RTC_NS                          ((RTC_TypeDef *) RTC_BASE_NS)
#define SAES_NS                         ((AES_TypeDef *) SAES_BASE_NS)
#define SAI1_NS                         ((SAI_TypeDef *) SAI1_BASE_NS)
#define SAI1_Block_A_NS                 ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_NS)
#define SAI1_Block_B_NS                 ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_NS)
#define SPI1_NS                         ((SPI_TypeDef *) SPI1_BASE_NS)
#define SPI2_NS                         ((SPI_TypeDef *) SPI2_BASE_NS)
#define SPI3_NS                         ((SPI_TypeDef *) SPI3_BASE_NS)
#define SYSCFG_NS                       ((SYSCFG_TypeDef *) SYSCFG_BASE_NS)
#define TAMP_NS                         ((TAMP_TypeDef *) TAMP_BASE_NS)
#define TIM1_NS                         ((TIM_TypeDef *) TIM1_BASE_NS)
#define TIM2_NS                         ((TIM_TypeDef *) TIM2_BASE_NS)
#define TIM3_NS                         ((TIM_TypeDef *) TIM3_BASE_NS)
#define TIM4_NS                         ((TIM_TypeDef *) TIM4_BASE_NS)
#define TIM16_NS                        ((TIM_TypeDef *) TIM16_BASE_NS)
#define TIM17_NS                        ((TIM_TypeDef *) TIM17_BASE_NS)
#define TSC_NS                          ((TSC_TypeDef *) TSC_BASE_NS)
#define USART1_NS                       ((USART_TypeDef *) USART1_BASE_NS)
#define USART2_NS                       ((USART_TypeDef *) USART2_BASE_NS)
#define USART3_NS                       ((USART_TypeDef *) USART3_BASE_NS)
#define VREFBUF_NS                      ((VREFBUF_TypeDef *) VREFBUF_BASE_NS)
#define WWDG_NS                         ((WWDG_TypeDef *) WWDG_BASE_NS)

/*!< Memory & Instance aliases and base addresses for Non-Secure/Secure peripherals */
#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)
#define ADC4_S                          ((ADC_TypeDef *) ADC4_BASE_S)
#define ADC4_COMMON_S                   ((ADC_Common_TypeDef *) ADC4_COMMON_BASE_S)
#define AES_S                           ((AES_TypeDef *) AES_BASE_S)
#define COMP1_S                         ((COMP_TypeDef *) COMP1_BASE_S)
#define COMP2_S                         ((COMP_TypeDef *) COMP2_BASE_S)
#define COMP12_COMMON_S                 ((COMP_Common_TypeDef *) COMP1_BASE_S)
#define CRC_S                           ((CRC_TypeDef *) CRC_BASE_S)
#define EXTI_S                          ((EXTI_TypeDef *) EXTI_BASE_S)
#define FLASH_S                         ((FLASH_TypeDef *) FLASH_R_BASE_S)
#define GPDMA1_S                        ((DMA_TypeDef *) GPDMA1_BASE_S)
#define GPDMA1_Channel0_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_S)
#define GPDMA1_Channel1_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_S)
#define GPDMA1_Channel2_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_S)
#define GPDMA1_Channel3_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_S)
#define GPDMA1_Channel4_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_S)
#define GPDMA1_Channel5_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_S)
#define GPDMA1_Channel6_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_S)
#define GPDMA1_Channel7_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_S)
#define GPIOA_S                         ((GPIO_TypeDef *) GPIOA_BASE_S)
#define GPIOB_S                         ((GPIO_TypeDef *) GPIOB_BASE_S)
#define GPIOC_S                         ((GPIO_TypeDef *) GPIOC_BASE_S)
#define GPIOD_S                         ((GPIO_TypeDef *) GPIOD_BASE_S)
#define GPIOE_S                         ((GPIO_TypeDef *) GPIOE_BASE_S)
#define GPIOG_S                         ((GPIO_TypeDef *) GPIOG_BASE_S)
#define GPIOH_S                         ((GPIO_TypeDef *) GPIOH_BASE_S)
#define GTZC_MPCBB1_S                   ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_S)
#define GTZC_MPCBB2_S                   ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_S)
#define GTZC_MPCBB6_S                   ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB6_BASE_S)
#define GTZC_TZIC_S                     ((GTZC_TZIC_TypeDef *) GTZC_TZIC_BASE_S)
#define GTZC_TZSC_S                     ((GTZC_TZSC_TypeDef *) GTZC_TZSC_BASE_S)
#define HASH_S                          ((HASH_TypeDef *) HASH_BASE_S)
#define HASH_DIGEST_S                   ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_S)
#define HSEM_S                          ((HSEM_TypeDef *) HSEM_BASE_S)
#define HSEM_COMMON_S                   ((HSEM_Common_TypeDef *) (HSEM_BASE_S + 0x100U))
#define I2C1_S                          ((I2C_TypeDef *) I2C1_BASE_S)
#define I2C2_S                          ((I2C_TypeDef *) I2C2_BASE_S)
#define I2C3_S                          ((I2C_TypeDef *) I2C3_BASE_S)
#define I2C4_S                          ((I2C_TypeDef *) I2C4_BASE_S)
#define ICACHE_S                        ((ICACHE_TypeDef *) ICACHE_BASE_S)
#define IWDG_S                          ((IWDG_TypeDef *) IWDG_BASE_S)
#define LPTIM1_S                        ((LPTIM_TypeDef *) LPTIM1_BASE_S)
#define LPTIM2_S                        ((LPTIM_TypeDef *) LPTIM2_BASE_S)
#define LPUART1_S                       ((USART_TypeDef *) LPUART1_BASE_S)
#define USB_OTG_HS_S                    ((USB_OTG_GlobalTypeDef *) USB_OTG_HS_BASE_S)
#define PKA_S                           ((PKA_TypeDef *) PKA_BASE_S)
#define PTACONV_S                       ((PTACONV_TypeDef *) PTACONV_BASE_S)
#define PWR_S                           ((PWR_TypeDef *) PWR_BASE_S)
#define RAMCFG_SRAM1_S                  ((RAMCFG_TypeDef *) RAMCFG_SRAM1_BASE_S)
#define RAMCFG_SRAM2_S                  ((RAMCFG_TypeDef *) RAMCFG_SRAM2_BASE_S)
#define RAMCFG_SRAM6_S                  ((RAMCFG_TypeDef *) RAMCFG_SRAM6_BASE_S)
#define RCC_S                           ((RCC_TypeDef *) RCC_BASE_S)
#define RNG_S                           ((RNG_TypeDef *) RNG_BASE_S)
#define RTC_S                           ((RTC_TypeDef *) RTC_BASE_S)
#define SAES_S                          ((AES_TypeDef *) SAES_BASE_S)
#define SAI1_S                          ((SAI_TypeDef *) SAI1_BASE_S)
#define SAI1_Block_A_S                  ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_S)
#define SAI1_Block_B_S                  ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_S)
#define SPI1_S                          ((SPI_TypeDef *) SPI1_BASE_S)
#define SPI2_S                          ((SPI_TypeDef *) SPI2_BASE_S)
#define SPI3_S                          ((SPI_TypeDef *) SPI3_BASE_S)
#define SYSCFG_S                        ((SYSCFG_TypeDef *) SYSCFG_BASE_S)
#define TAMP_S                          ((TAMP_TypeDef *) TAMP_BASE_S)
#define TIM1_S                          ((TIM_TypeDef *) TIM1_BASE_S)
#define TIM2_S                          ((TIM_TypeDef *) TIM2_BASE_S)
#define TIM3_S                          ((TIM_TypeDef *) TIM3_BASE_S)
#define TIM4_S                          ((TIM_TypeDef *) TIM4_BASE_S)
#define TIM16_S                         ((TIM_TypeDef *) TIM16_BASE_S)
#define TIM17_S                         ((TIM_TypeDef *) TIM17_BASE_S)
#define TSC_S                           ((TSC_TypeDef *) TSC_BASE_S)
#define USART1_S                        ((USART_TypeDef *) USART1_BASE_S)
#define USART2_S                        ((USART_TypeDef *) USART2_BASE_S)
#define USART3_S                        ((USART_TypeDef *) USART3_BASE_S)
#define VREFBUF_S                       ((VREFBUF_TypeDef *) VREFBUF_BASE_S)
#define WWDG_S                          ((WWDG_TypeDef *) WWDG_BASE_S)


/*!< Memory base addresses for Secure peripherals */
#define FLASH_BASE                      FLASH_BASE_S
#define SRAM1_BASE                      SRAM1_BASE_S
#define SRAM2_BASE                      SRAM2_BASE_S
#define SRAM6_BASE                      SRAM6_BASE_S
#define SEQSRAM_BASE                    SEQSRAM_BASE_S

/*!< Instance aliases and base addresses for Secure peripherals */
#define ADC4                            ADC4_S
#define ADC4_BASE                       ADC4_BASE_S
#define ADC4_COMMON                     ADC4_COMMON_S
#define ADC4_COMMON_BASE                ADC4_COMMON_BASE_S
#define AES                             AES_S
#define AES_BASE                        AES_BASE_S
#define COMP1                           COMP1_S
#define COMP1_BASE                      COMP1_BASE_S
#define COMP2                           COMP2_S
#define COMP2_BASE                      COMP2_BASE_S
#define COMP12_COMMON                   COMP12_COMMON_S
#define CRC                             CRC_S
#define CRC_BASE                        CRC_BASE_S
#define EXTI                            EXTI_S
#define EXTI_BASE                       EXTI_BASE_S
#define FLASH                           FLASH_S
#define FLASH_R_BASE                    FLASH_R_BASE_S
#define GPDMA1                          GPDMA1_S
#define GPDMA1_BASE                     GPDMA1_BASE_S
#define GPDMA1_Channel0                 GPDMA1_Channel0_S
#define GPDMA1_Channel0_BASE            GPDMA1_Channel0_BASE_S
#define GPDMA1_Channel1                 GPDMA1_Channel1_S
#define GPDMA1_Channel1_BASE            GPDMA1_Channel1_BASE_S
#define GPDMA1_Channel2                 GPDMA1_Channel2_S
#define GPDMA1_Channel2_BASE            GPDMA1_Channel2_BASE_S
#define GPDMA1_Channel3                 GPDMA1_Channel3_S
#define GPDMA1_Channel3_BASE            GPDMA1_Channel3_BASE_S
#define GPDMA1_Channel4                 GPDMA1_Channel4_S
#define GPDMA1_Channel4_BASE            GPDMA1_Channel4_BASE_S
#define GPDMA1_Channel5                 GPDMA1_Channel5_S
#define GPDMA1_Channel5_BASE            GPDMA1_Channel5_BASE_S
#define GPDMA1_Channel6                 GPDMA1_Channel6_S
#define GPDMA1_Channel6_BASE            GPDMA1_Channel6_BASE_S
#define GPDMA1_Channel7                 GPDMA1_Channel7_S
#define GPDMA1_Channel7_BASE            GPDMA1_Channel7_BASE_S
#define GPIOA                           GPIOA_S
#define GPIOA_BASE                      GPIOA_BASE_S
#define GPIOB                           GPIOB_S
#define GPIOB_BASE                      GPIOB_BASE_S
#define GPIOC                           GPIOC_S
#define GPIOC_BASE                      GPIOC_BASE_S
#define GPIOD                           GPIOD_S
#define GPIOD_BASE                      GPIOD_BASE_S
#define GPIOE                           GPIOE_S
#define GPIOE_BASE                      GPIOE_BASE_S
#define GPIOG                           GPIOG_S
#define GPIOG_BASE                      GPIOG_BASE_S
#define GPIOH                           GPIOH_S
#define GPIOH_BASE                      GPIOH_BASE_S
#define GTZC_MPCBB1                     GTZC_MPCBB1_S
#define GTZC_MPCBB1_BASE                GTZC_MPCBB1_BASE_S
#define GTZC_MPCBB2                     GTZC_MPCBB2_S
#define GTZC_MPCBB2_BASE                GTZC_MPCBB2_BASE_S
#define GTZC_MPCBB6                     GTZC_MPCBB6_S
#define GTZC_MPCBB6_BASE                GTZC_MPCBB6_BASE_S
#define GTZC_TZIC                       GTZC_TZIC_S
#define GTZC_TZIC_BASE                  GTZC_TZIC_BASE_S
#define GTZC_TZSC                       GTZC_TZSC_S
#define GTZC_TZSC_BASE                  GTZC_TZSC_BASE_S
#define HASH                            HASH_S
#define HASH_BASE                       HASH_BASE_S
#define HASH_DIGEST                     HASH_DIGEST_S
#define HASH_DIGEST_BASE                HASH_DIGEST_BASE_S
#define HSEM                            HSEM_S
#define HSEM_BASE                       HSEM_BASE_S
#define HSEM_COMMON                     HSEM_COMMON_S
#define I2C1                            I2C1_S
#define I2C1_BASE                       I2C1_BASE_S
#define I2C2                            I2C2_S
#define I2C2_BASE                       I2C2_BASE_S
#define I2C3                            I2C3_S
#define I2C3_BASE                       I2C3_BASE_S
#define I2C4                            I2C4_S
#define I2C4_BASE                       I2C4_BASE_S
#define ICACHE                          ICACHE_S
#define ICACHE_BASE                     ICACHE_BASE_S
#define IWDG                            IWDG_S
#define IWDG_BASE                       IWDG_BASE_S
#define LPTIM1                          LPTIM1_S
#define LPTIM1_BASE                     LPTIM1_BASE_S
#define LPTIM2                          LPTIM2_S
#define LPTIM2_BASE                     LPTIM2_BASE_S
#define LPUART1                         LPUART1_S
#define LPUART1_BASE                    LPUART1_BASE_S
#define USB_OTG_HS                      USB_OTG_HS_S
#define USB_OTG_HS_BASE                 USB_OTG_HS_BASE_S
#define PKA                             PKA_S
#define PKA_BASE                        PKA_BASE_S
#define PKA_RAM_BASE                    PKA_RAM_BASE_S
#define PTACONV_BASE                    PTACONV_BASE_S
#define PTACONV                         PTACONV_S
#define PWR                             PWR_S
#define PWR_BASE                        PWR_BASE_S
#define RADIO_BASE                      RADIO_BASE_S
#define RAMCFG_SRAM1                    RAMCFG_SRAM1_S
#define RAMCFG_SRAM1_BASE               RAMCFG_SRAM1_BASE_S
#define RAMCFG_SRAM2                    RAMCFG_SRAM2_S
#define RAMCFG_SRAM2_BASE               RAMCFG_SRAM2_BASE_S
#define RAMCFG_SRAM6                    RAMCFG_SRAM6_S
#define RAMCFG_SRAM6_BASE               RAMCFG_SRAM6_BASE_S
#define RCC                             RCC_S
#define RCC_BASE                        RCC_BASE_S
#define RNG                             RNG_S
#define RNG_BASE                        RNG_BASE_S
#define RTC                             RTC_S
#define RTC_BASE                        RTC_BASE_S
#define SAES                            SAES_S
#define SAES_BASE                       SAES_BASE_S
#define SAI1                            SAI1_S
#define SAI1_BASE                       SAI1_BASE_S
#define SAI1_Block_A                    SAI1_Block_A_S
#define SAI1_Block_A_BASE               SAI1_Block_A_BASE_S
#define SAI1_Block_B                    SAI1_Block_B_S
#define SAI1_Block_B_BASE               SAI1_Block_B_BASE_S
#define SPI1                            SPI1_S
#define SPI1_BASE                       SPI1_BASE_S
#define SPI2                            SPI2_S
#define SPI2_BASE                       SPI2_BASE_S
#define SPI3                            SPI3_S
#define SPI3_BASE                       SPI3_BASE_S
#define SYSCFG                          SYSCFG_S
#define SYSCFG_BASE                     SYSCFG_BASE_S
#define TAMP                            TAMP_S
#define TAMP_BASE                       TAMP_BASE_S
#define TIM1                            TIM1_S
#define TIM1_BASE                       TIM1_BASE_S
#define TIM2                            TIM2_S
#define TIM2_BASE                       TIM2_BASE_S
#define TIM3                            TIM3_S
#define TIM3_BASE                       TIM3_BASE_S
#define TIM4                            TIM4_S
#define TIM4_BASE                       TIM4_BASE_S
#define TIM16                           TIM16_S
#define TIM16_BASE                      TIM16_BASE_S
#define TIM17                           TIM17_S
#define TIM17_BASE                      TIM17_BASE_S
#define TSC                             TSC_S
#define TSC_BASE                        TSC_BASE_S
#define USART1                          USART1_S
#define USART1_BASE                     USART1_BASE_S
#define USART2                          USART2_S
#define USART2_BASE                     USART2_BASE_S
#define USART3                          USART3_S
#define USART3_BASE                     USART3_BASE_S
#define VREFBUF                         VREFBUF_S
#define VREFBUF_BASE                    VREFBUF_BASE_S
#define WWDG                            WWDG_S
#define WWDG_BASE                       WWDG_BASE_S

#else
/*!< Memory base addresses for Non secure peripherals */
#define FLASH_BASE                     FLASH_BASE_NS
#define SRAM1_BASE                     SRAM1_BASE_NS
#define SRAM2_BASE                     SRAM2_BASE_NS
#define SRAM6_BASE                     SRAM6_BASE_NS
#define SEQSRAM_BASE                   SEQSRAM_BASE_NS

/*!< Instance aliases and base addresses for Non secure peripherals */
#define ADC4                            ADC4_NS
#define ADC4_BASE                       ADC4_BASE_NS
#define ADC4_COMMON                     ADC4_COMMON_NS
#define ADC4_COMMON_BASE                ADC4_COMMON_BASE_NS
#define AES                             AES_NS
#define AES_BASE                        AES_BASE_NS
#define COMP1                           COMP1_NS
#define COMP1_BASE                      COMP1_BASE_NS
#define COMP2                           COMP2_NS
#define COMP2_BASE                      COMP2_BASE_NS
#define COMP12_COMMON                   COMP12_COMMON_NS
#define CRC                             CRC_NS
#define CRC_BASE                        CRC_BASE_NS
#define EXTI                            EXTI_NS
#define EXTI_BASE                       EXTI_BASE_NS
#define FLASH                           FLASH_NS
#define FLASH_R_BASE                    FLASH_R_BASE_NS
#define GPDMA1                          GPDMA1_NS
#define GPDMA1_BASE                     GPDMA1_BASE_NS
#define GPDMA1_Channel0                 GPDMA1_Channel0_NS
#define GPDMA1_Channel0_BASE            GPDMA1_Channel0_BASE_NS
#define GPDMA1_Channel1                 GPDMA1_Channel1_NS
#define GPDMA1_Channel1_BASE            GPDMA1_Channel1_BASE_NS
#define GPDMA1_Channel2                 GPDMA1_Channel2_NS
#define GPDMA1_Channel2_BASE            GPDMA1_Channel2_BASE_NS
#define GPDMA1_Channel3                 GPDMA1_Channel3_NS
#define GPDMA1_Channel3_BASE            GPDMA1_Channel3_BASE_NS
#define GPDMA1_Channel4                 GPDMA1_Channel4_NS
#define GPDMA1_Channel4_BASE            GPDMA1_Channel4_BASE_NS
#define GPDMA1_Channel5                 GPDMA1_Channel5_NS
#define GPDMA1_Channel5_BASE            GPDMA1_Channel5_BASE_NS
#define GPDMA1_Channel6                 GPDMA1_Channel6_NS
#define GPDMA1_Channel6_BASE            GPDMA1_Channel6_BASE_NS
#define GPDMA1_Channel7                 GPDMA1_Channel7_NS
#define GPDMA1_Channel7_BASE            GPDMA1_Channel7_BASE_NS
#define GPIOA                           GPIOA_NS
#define GPIOA_BASE                      GPIOA_BASE_NS
#define GPIOB                           GPIOB_NS
#define GPIOB_BASE                      GPIOB_BASE_NS
#define GPIOC                           GPIOC_NS
#define GPIOC_BASE                      GPIOC_BASE_NS
#define GPIOD                           GPIOD_NS
#define GPIOD_BASE                      GPIOD_BASE_NS
#define GPIOE                           GPIOE_NS
#define GPIOE_BASE                      GPIOE_BASE_NS
#define GPIOG                           GPIOG_NS
#define GPIOG_BASE                      GPIOG_BASE_NS
#define GPIOH                           GPIOH_NS
#define GPIOH_BASE                      GPIOH_BASE_NS
#define GTZC_MPCBB1                     GTZC_MPCBB1_NS
#define GTZC_MPCBB1_BASE                GTZC_MPCBB1_BASE_NS
#define GTZC_MPCBB2                     GTZC_MPCBB2_NS
#define GTZC_MPCBB2_BASE                GTZC_MPCBB2_BASE_NS
#define GTZC_MPCBB6                     GTZC_MPCBB6_NS
#define GTZC_MPCBB6_BASE                GTZC_MPCBB6_BASE_NS
#define GTZC_TZSC                       GTZC_TZSC_NS
#define GTZC_TZSC_BASE                  GTZC_TZSC_BASE_NS
#define HASH                            HASH_NS
#define HASH_BASE                       HASH_BASE_NS
#define HASH_DIGEST                     HASH_DIGEST_NS
#define HASH_DIGEST_BASE                HASH_DIGEST_BASE_NS
#define HSEM                            HSEM_NS
#define HSEM_BASE                       HSEM_BASE_NS
#define HSEM_COMMON                     HSEM_COMMON_NS
#define I2C1                            I2C1_NS
#define I2C1_BASE                       I2C1_BASE_NS
#define I2C2                            I2C2_NS
#define I2C2_BASE                       I2C2_BASE_NS
#define I2C3                            I2C3_NS
#define I2C3_BASE                       I2C3_BASE_NS
#define I2C4                            I2C4_NS
#define I2C4_BASE                       I2C4_BASE_NS
#define ICACHE                          ICACHE_NS
#define ICACHE_BASE                     ICACHE_BASE_NS
#define IWDG                            IWDG_NS
#define IWDG_BASE                       IWDG_BASE_NS
#define LPTIM1                          LPTIM1_NS
#define LPTIM1_BASE                     LPTIM1_BASE_NS
#define LPTIM2                          LPTIM2_NS
#define LPTIM2_BASE                     LPTIM2_BASE_NS
#define LPUART1                         LPUART1_NS
#define LPUART1_BASE                    LPUART1_BASE_NS
#define USB_OTG_HS                      USB_OTG_HS_NS
#define USB_OTG_HS_BASE                 USB_OTG_HS_BASE_NS
#define PKA                             PKA_NS
#define PKA_BASE                        PKA_BASE_NS
#define PKA_RAM_BASE                    PKA_RAM_BASE_NS
#define PTACONV_BASE                    PTACONV_BASE_NS
#define PTACONV                         PTACONV_NS
#define PWR                             PWR_NS
#define PWR_BASE                        PWR_BASE_NS
#define RADIO_BASE                      RADIO_BASE_NS
#define RAMCFG_SRAM1                    RAMCFG_SRAM1_NS
#define RAMCFG_SRAM1_BASE               RAMCFG_SRAM1_BASE_NS
#define RAMCFG_SRAM2                    RAMCFG_SRAM2_NS
#define RAMCFG_SRAM2_BASE               RAMCFG_SRAM2_BASE_NS
#define RAMCFG_SRAM6                    RAMCFG_SRAM6_NS
#define RAMCFG_SRAM6_BASE               RAMCFG_SRAM6_BASE_NS
#define RCC                             RCC_NS
#define RCC_BASE                        RCC_BASE_NS
#define RNG                             RNG_NS
#define RNG_BASE                        RNG_BASE_NS
#define RTC                             RTC_NS
#define RTC_BASE                        RTC_BASE_NS
#define SAES                            SAES_NS
#define SAES_BASE                       SAES_BASE_NS
#define SAI1                            SAI1_NS
#define SAI1_BASE                       SAI1_BASE_NS
#define SAI1_Block_A                    SAI1_Block_A_NS
#define SAI1_Block_A_BASE               SAI1_Block_A_BASE_NS
#define SAI1_Block_B                    SAI1_Block_B_NS
#define SAI1_Block_B_BASE               SAI1_Block_B_BASE_NS
#define SPI1                            SPI1_NS
#define SPI1_BASE                       SPI1_BASE_NS
#define SPI2                            SPI2_NS
#define SPI2_BASE                       SPI2_BASE_NS
#define SPI3                            SPI3_NS
#define SPI3_BASE                       SPI3_BASE_NS
#define SYSCFG                          SYSCFG_NS
#define SYSCFG_BASE                     SYSCFG_BASE_NS
#define TAMP                            TAMP_NS
#define TAMP_BASE                       TAMP_BASE_NS
#define TIM1                            TIM1_NS
#define TIM1_BASE                       TIM1_BASE_NS
#define TIM2                            TIM2_NS
#define TIM2_BASE                       TIM2_BASE_NS
#define TIM3                            TIM3_NS
#define TIM3_BASE                       TIM3_BASE_NS
#define TIM4                            TIM4_NS
#define TIM4_BASE                       TIM4_BASE_NS
#define TIM16                           TIM16_NS
#define TIM16_BASE                      TIM16_BASE_NS
#define TIM17                           TIM17_NS
#define TIM17_BASE                      TIM17_BASE_NS
#define TSC                             TSC_NS
#define TSC_BASE                        TSC_BASE_NS
#define USART1                          USART1_NS
#define USART1_BASE                     USART1_BASE_NS
#define USART2                          USART2_NS
#define USART2_BASE                     USART2_BASE_NS
#define USART3                          USART3_NS
#define USART3_BASE                     USART3_BASE_NS
#define VREFBUF                         VREFBUF_NS
#define VREFBUF_BASE                    VREFBUF_BASE_NS
#define WWDG                            WWDG_NS
#define WWDG_BASE                       WWDG_BASE_NS
#endif


/** @addtogroup Exported_constants
  * @{
  */

/** @addtogroup Hardware_Constant_Definition
  * @{
  */
#define LSI_STARTUP_TIME                16000U /*!< LSI Maximum startup time in us : 4 cycles @ 250 Hz = 16 ms */
/**
  * @}
  */

/** @addtogroup Peripheral_Registers_Bits_Definition
  * @{
  */

/******************************************************************************/
/*                                                                            */
/*                      Analog to Digital Converter (ADC)                     */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for ADC_ISR register  *******************/
#define ADC_ISR_ADRDY_Pos              (0UL)
#define ADC_ISR_ADRDY_Msk              (0x1UL << ADC_ISR_ADRDY_Pos)            /*!< 0x00000001 */
#define ADC_ISR_ADRDY                  ADC_ISR_ADRDY_Msk                       /*!< ADC ready flag */
#define ADC_ISR_EOSMP_Pos              (1UL)
#define ADC_ISR_EOSMP_Msk              (0x1UL << ADC_ISR_EOSMP_Pos)            /*!< 0x00000002 */
#define ADC_ISR_EOSMP                  ADC_ISR_EOSMP_Msk                       /*!< ADC group regular end of sampling flag */
#define ADC_ISR_EOC_Pos                (2UL)
#define ADC_ISR_EOC_Msk                (0x1UL << ADC_ISR_EOC_Pos)              /*!< 0x00000004 */
#define ADC_ISR_EOC                    ADC_ISR_EOC_Msk                         /*!< ADC group regular end of unitary conversion flag */
#define ADC_ISR_EOS_Pos                (3UL)
#define ADC_ISR_EOS_Msk                (0x1UL << ADC_ISR_EOS_Pos)              /*!< 0x00000008 */
#define ADC_ISR_EOS                    ADC_ISR_EOS_Msk                         /*!< ADC group regular end of sequence conversions flag */
#define ADC_ISR_OVR_Pos                (4UL)
#define ADC_ISR_OVR_Msk                (0x1UL << ADC_ISR_OVR_Pos)              /*!< 0x00000010 */
#define ADC_ISR_OVR                    ADC_ISR_OVR_Msk                         /*!< ADC group regular overrun flag */
#define ADC_ISR_AWD1_Pos               (7UL)
#define ADC_ISR_AWD1_Msk               (0x1UL << ADC_ISR_AWD1_Pos)             /*!< 0x00000080 */
#define ADC_ISR_AWD1                   ADC_ISR_AWD1_Msk                        /*!< ADC analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos               (8UL)
#define ADC_ISR_AWD2_Msk               (0x1UL << ADC_ISR_AWD2_Pos)             /*!< 0x00000100 */
#define ADC_ISR_AWD2                   ADC_ISR_AWD2_Msk                        /*!< ADC analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos               (9UL)
#define ADC_ISR_AWD3_Msk               (0x1UL << ADC_ISR_AWD3_Pos)             /*!< 0x00000200 */
#define ADC_ISR_AWD3                   ADC_ISR_AWD3_Msk                        /*!< ADC analog watchdog 3 flag */
#define ADC_ISR_EOCAL_Pos              (11UL)
#define ADC_ISR_EOCAL_Msk              (0x1UL << ADC_ISR_EOCAL_Pos)            /*!< 0x00000800 */
#define ADC_ISR_EOCAL                  ADC_ISR_EOCAL_Msk                       /*!< ADC end of calibration flag */
#define ADC_ISR_LDORDY_Pos             (12UL)
#define ADC_ISR_LDORDY_Msk             (0x1UL << ADC_ISR_LDORDY_Pos)           /*!< 0x00001000 */
#define ADC_ISR_LDORDY                 ADC_ISR_LDORDY_Msk                      /*!< ADC internal voltage regulator ready flag */

/********************  Bit definition for ADC_IER register  *******************/
#define ADC_IER_ADRDYIE_Pos            (0UL)
#define ADC_IER_ADRDYIE_Msk            (0x1UL << ADC_IER_ADRDYIE_Pos)          /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                ADC_IER_ADRDYIE_Msk                     /*!< ADC ready interrupt */
#define ADC_IER_EOSMPIE_Pos            (1UL)
#define ADC_IER_EOSMPIE_Msk            (0x1UL << ADC_IER_EOSMPIE_Pos)          /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                ADC_IER_EOSMPIE_Msk                     /*!< ADC group regular end of sampling interrupt */
#define ADC_IER_EOCIE_Pos              (2UL)
#define ADC_IER_EOCIE_Msk              (0x1UL << ADC_IER_EOCIE_Pos)            /*!< 0x00000004 */
#define ADC_IER_EOCIE                  ADC_IER_EOCIE_Msk                       /*!< ADC group regular end of unitary conversion interrupt */
#define ADC_IER_EOSIE_Pos              (3UL)
#define ADC_IER_EOSIE_Msk              (0x1UL << ADC_IER_EOSIE_Pos)            /*!< 0x00000008 */
#define ADC_IER_EOSIE                  ADC_IER_EOSIE_Msk                       /*!< ADC group regular end of sequence conversions interrupt */
#define ADC_IER_OVRIE_Pos              (4UL)
#define ADC_IER_OVRIE_Msk              (0x1UL << ADC_IER_OVRIE_Pos)            /*!< 0x00000010 */
#define ADC_IER_OVRIE                  ADC_IER_OVRIE_Msk                       /*!< ADC group regular overrun interrupt */
#define ADC_IER_AWD1IE_Pos             (7UL)
#define ADC_IER_AWD1IE_Msk             (0x1UL << ADC_IER_AWD1IE_Pos)           /*!< 0x00000080 */
#define ADC_IER_AWD1IE                 ADC_IER_AWD1IE_Msk                      /*!< ADC analog watchdog 1 interrupt */
#define ADC_IER_AWD2IE_Pos             (8UL)
#define ADC_IER_AWD2IE_Msk             (0x1UL << ADC_IER_AWD2IE_Pos)           /*!< 0x00000100 */
#define ADC_IER_AWD2IE                 ADC_IER_AWD2IE_Msk                      /*!< ADC analog watchdog 2 interrupt */
#define ADC_IER_AWD3IE_Pos             (9UL)
#define ADC_IER_AWD3IE_Msk             (0x1UL << ADC_IER_AWD3IE_Pos)           /*!< 0x00000200 */
#define ADC_IER_AWD3IE                 ADC_IER_AWD3IE_Msk                      /*!< ADC analog watchdog 3 interrupt */
#define ADC_IER_EOCALIE_Pos            (11UL)
#define ADC_IER_EOCALIE_Msk            (0x1UL << ADC_IER_EOCALIE_Pos)          /*!< 0x00000800 */
#define ADC_IER_EOCALIE                ADC_IER_EOCALIE_Msk                     /*!< ADC end of calibration interrupt */
#define ADC_IER_LDORDYIE_Pos           (12UL)
#define ADC_IER_LDORDYIE_Msk           (0x1UL << ADC_IER_LDORDYIE_Pos)         /*!< 0x00001000 */
#define ADC_IER_LDORDYIE               ADC_IER_LDORDYIE_Msk                    /*!< ADC Voltage Regulator Ready interrupt source */

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                (0UL)
#define ADC_CR_ADEN_Msk                (0x1UL << ADC_CR_ADEN_Pos)              /*!< 0x00000001 */
#define ADC_CR_ADEN                    ADC_CR_ADEN_Msk                         /*!< ADC enable */
#define ADC_CR_ADDIS_Pos               (1UL)
#define ADC_CR_ADDIS_Msk               (0x1UL << ADC_CR_ADDIS_Pos)             /*!< 0x00000002 */
#define ADC_CR_ADDIS                   ADC_CR_ADDIS_Msk                        /*!< ADC disable */
#define ADC_CR_ADSTART_Pos             (2UL)
#define ADC_CR_ADSTART_Msk             (0x1UL << ADC_CR_ADSTART_Pos)           /*!< 0x00000004 */
#define ADC_CR_ADSTART                 ADC_CR_ADSTART_Msk                      /*!< ADC group regular conversion start */
#define ADC_CR_ADSTP_Pos               (4UL)
#define ADC_CR_ADSTP_Msk               (0x1UL << ADC_CR_ADSTP_Pos)             /*!< 0x00000010 */
#define ADC_CR_ADSTP                   ADC_CR_ADSTP_Msk                        /*!< ADC group regular conversion stop */
#define ADC_CR_ADVREGEN_Pos            (28UL)
#define ADC_CR_ADVREGEN_Msk            (0x1UL << ADC_CR_ADVREGEN_Pos)          /*!< 0x10000000 */
#define ADC_CR_ADVREGEN                ADC_CR_ADVREGEN_Msk                     /*!< ADC voltage regulator enable */
#define ADC_CR_ADCAL_Pos               (31UL)
#define ADC_CR_ADCAL_Msk               (0x1UL << ADC_CR_ADCAL_Pos)             /*!< 0x80000000 */
#define ADC_CR_ADCAL                   ADC_CR_ADCAL_Msk                        /*!< ADC calibration */

/********************  Bit definition for ADC_CFGR1 register  *****************/
#define ADC_CFGR1_DMAEN_Pos            (0UL)
#define ADC_CFGR1_DMAEN_Msk            (0x1UL << ADC_CFGR1_DMAEN_Pos)          /*!< 0x00000001 */
#define ADC_CFGR1_DMAEN                ADC_CFGR1_DMAEN_Msk                     /*!< ADC DMA transfer enable */
#define ADC_CFGR1_DMACFG_Pos           (1UL)
#define ADC_CFGR1_DMACFG_Msk           (0x1UL << ADC_CFGR1_DMACFG_Pos)         /*!< 0x00000002 */
#define ADC_CFGR1_DMACFG               ADC_CFGR1_DMACFG_Msk                    /*!< ADC DMA transfer configuration */

#define ADC_CFGR1_RES_Pos              (2UL)
#define ADC_CFGR1_RES_Msk              (0x3UL << ADC_CFGR1_RES_Pos)            /*!< 0x0000000C */
#define ADC_CFGR1_RES                  ADC_CFGR1_RES_Msk                       /*!< ADC Data resolution */
#define ADC_CFGR1_RES_0                (0x1UL << ADC_CFGR1_RES_Pos)            /*!< 0x00000004 */
#define ADC_CFGR1_RES_1                (0x2UL << ADC_CFGR1_RES_Pos)            /*!< 0x00000008 */

#define ADC_CFGR1_SCANDIR_Pos          (4UL)
#define ADC_CFGR1_SCANDIR_Msk          (0x1UL << ADC_CFGR1_SCANDIR_Pos)        /*!< 0x00000010 */
#define ADC_CFGR1_SCANDIR              ADC_CFGR1_SCANDIR_Msk                   /*!< ADC group regular sequencer scan direction */
#define ADC_CFGR1_ALIGN_Pos            (5UL)
#define ADC_CFGR1_ALIGN_Msk            (0x1UL << ADC_CFGR1_ALIGN_Pos)          /*!< 0x00000020 */
#define ADC_CFGR1_ALIGN                ADC_CFGR1_ALIGN_Msk                     /*!< ADC data alignment */

#define ADC_CFGR1_EXTSEL_Pos           (6UL)
#define ADC_CFGR1_EXTSEL_Msk           (0x7UL << ADC_CFGR1_EXTSEL_Pos)         /*!< 0x000001C0 */
#define ADC_CFGR1_EXTSEL               ADC_CFGR1_EXTSEL_Msk                    /*!< ADC group regular external trigger source */
#define ADC_CFGR1_EXTSEL_0             (0x1UL << ADC_CFGR1_EXTSEL_Pos)         /*!< 0x00000040 */
#define ADC_CFGR1_EXTSEL_1             (0x2UL << ADC_CFGR1_EXTSEL_Pos)         /*!< 0x00000080 */
#define ADC_CFGR1_EXTSEL_2             (0x4UL << ADC_CFGR1_EXTSEL_Pos)         /*!< 0x00000100 */

#define ADC_CFGR1_EXTEN_Pos            (10UL)
#define ADC_CFGR1_EXTEN_Msk            (0x3UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000C00 */
#define ADC_CFGR1_EXTEN                ADC_CFGR1_EXTEN_Msk                     /*!< ADC group regular external trigger polarity */
#define ADC_CFGR1_EXTEN_0              (0x1UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000400 */
#define ADC_CFGR1_EXTEN_1              (0x2UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000800 */

#define ADC_CFGR1_OVRMOD_Pos           (12UL)
#define ADC_CFGR1_OVRMOD_Msk           (0x1UL << ADC_CFGR1_OVRMOD_Pos)         /*!< 0x00001000 */
#define ADC_CFGR1_OVRMOD               ADC_CFGR1_OVRMOD_Msk                    /*!< ADC group regular overrun configuration */
#define ADC_CFGR1_CONT_Pos             (13UL)
#define ADC_CFGR1_CONT_Msk             (0x1UL << ADC_CFGR1_CONT_Pos)           /*!< 0x00002000 */
#define ADC_CFGR1_CONT                 ADC_CFGR1_CONT_Msk                      /*!< ADC group regular continuous conversion mode */
#define ADC_CFGR1_WAIT_Pos             (14UL)
#define ADC_CFGR1_WAIT_Msk             (0x1UL << ADC_CFGR1_WAIT_Pos)           /*!< 0x00004000 */
#define ADC_CFGR1_WAIT                 ADC_CFGR1_WAIT_Msk                      /*!< ADC low power auto wait */
#define ADC_CFGR1_DISCEN_Pos           (16UL)
#define ADC_CFGR1_DISCEN_Msk           (0x1UL << ADC_CFGR1_DISCEN_Pos)         /*!< 0x00010000 */
#define ADC_CFGR1_DISCEN               ADC_CFGR1_DISCEN_Msk                    /*!< ADC group regular sequencer discontinuous mode */
#define ADC_CFGR1_CHSELRMOD_Pos        (21UL)
#define ADC_CFGR1_CHSELRMOD_Msk        (0x1UL << ADC_CFGR1_CHSELRMOD_Pos)      /*!< 0x00200000 */
#define ADC_CFGR1_CHSELRMOD            ADC_CFGR1_CHSELRMOD_Msk                 /*!< ADC group regular sequencer mode */

#define ADC_CFGR1_AWD1SGL_Pos          (22UL)
#define ADC_CFGR1_AWD1SGL_Msk          (0x1UL << ADC_CFGR1_AWD1SGL_Pos)        /*!< 0x00400000 */
#define ADC_CFGR1_AWD1SGL              ADC_CFGR1_AWD1SGL_Msk                   /*!< ADC analog watchdog 1 monitoring a single channel or all channels */
#define ADC_CFGR1_AWD1EN_Pos           (23UL)
#define ADC_CFGR1_AWD1EN_Msk           (0x1UL << ADC_CFGR1_AWD1EN_Pos)         /*!< 0x00800000 */
#define ADC_CFGR1_AWD1EN               ADC_CFGR1_AWD1EN_Msk                    /*!< ADC analog watchdog 1 enable on scope ADC group regular */

#define ADC_CFGR1_AWD1CH_Pos           (26UL)
#define ADC_CFGR1_AWD1CH_Msk           (0x1FUL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x7C000000 */
#define ADC_CFGR1_AWD1CH               ADC_CFGR1_AWD1CH_Msk                    /*!< ADC analog watchdog 1 monitored channel selection */
#define ADC_CFGR1_AWD1CH_0             (0x01UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x04000000 */
#define ADC_CFGR1_AWD1CH_1             (0x02UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x08000000 */
#define ADC_CFGR1_AWD1CH_2             (0x04UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x10000000 */
#define ADC_CFGR1_AWD1CH_3             (0x08UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x20000000 */
#define ADC_CFGR1_AWD1CH_4             (0x10UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x40000000 */

/********************  Bit definition for ADC_CFGR2 register  *****************/
#define ADC_CFGR2_OVSE_Pos             (0UL)
#define ADC_CFGR2_OVSE_Msk             (0x1UL << ADC_CFGR2_OVSE_Pos)           /*!< 0x00000001 */
#define ADC_CFGR2_OVSE                 ADC_CFGR2_OVSE_Msk                      /*!< ADC oversampler enable on scope ADC group regular */

#define ADC_CFGR2_OVSR_Pos             (2UL)
#define ADC_CFGR2_OVSR_Msk             (0x7UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x0000001C */
#define ADC_CFGR2_OVSR                 ADC_CFGR2_OVSR_Msk                      /*!< ADC oversampling ratio */
#define ADC_CFGR2_OVSR_0               (0x1UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000004 */
#define ADC_CFGR2_OVSR_1               (0x2UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000008 */
#define ADC_CFGR2_OVSR_2               (0x4UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000010 */

#define ADC_CFGR2_OVSS_Pos             (5UL)
#define ADC_CFGR2_OVSS_Msk             (0xFUL << ADC_CFGR2_OVSS_Pos)           /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                 ADC_CFGR2_OVSS_Msk                      /*!< ADC oversampling shift */
#define ADC_CFGR2_OVSS_0               (0x1UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1               (0x2UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2               (0x4UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3               (0x8UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000100 */

#define ADC_CFGR2_TOVS_Pos             (9UL)
#define ADC_CFGR2_TOVS_Msk             (0x1UL << ADC_CFGR2_TOVS_Pos)           /*!< 0x00000200 */
#define ADC_CFGR2_TOVS                 ADC_CFGR2_TOVS_Msk                      /*!< ADC oversampling discontinuous mode (triggered mode) for ADC group regular */

#define ADC_CFGR2_LFTRIG_Pos           (29UL)
#define ADC_CFGR2_LFTRIG_Msk           (0x1UL << ADC_CFGR2_LFTRIG_Pos)         /*!< 0x20000000 */
#define ADC_CFGR2_LFTRIG               ADC_CFGR2_LFTRIG_Msk                    /*!< ADC low frequency trigger mode */

/********************  Bit definition for ADC_SMPR register  ******************/
#define ADC_SMPR_SMP1_Pos              (0UL)
#define ADC_SMPR_SMP1_Msk              (0x7UL << ADC_SMPR_SMP1_Pos)            /*!< 0x00000007 */
#define ADC_SMPR_SMP1                  ADC_SMPR_SMP1_Msk                       /*!< ADC group of channels sampling time 1 */
#define ADC_SMPR_SMP1_0                (0x1UL << ADC_SMPR_SMP1_Pos)            /*!< 0x00000001 */
#define ADC_SMPR_SMP1_1                (0x2UL << ADC_SMPR_SMP1_Pos)            /*!< 0x00000002 */
#define ADC_SMPR_SMP1_2                (0x4UL << ADC_SMPR_SMP1_Pos)            /*!< 0x00000004 */

#define ADC_SMPR_SMP2_Pos              (4UL)
#define ADC_SMPR_SMP2_Msk              (0x7UL << ADC_SMPR_SMP2_Pos)            /*!< 0x00000070 */
#define ADC_SMPR_SMP2                  ADC_SMPR_SMP2_Msk                       /*!< ADC group of channels sampling time 2 */
#define ADC_SMPR_SMP2_0                (0x1UL << ADC_SMPR_SMP2_Pos)            /*!< 0x00000010 */
#define ADC_SMPR_SMP2_1                (0x2UL << ADC_SMPR_SMP2_Pos)            /*!< 0x00000020 */
#define ADC_SMPR_SMP2_2                (0x4UL << ADC_SMPR_SMP2_Pos)            /*!< 0x00000040 */

#define ADC_SMPR_SMPSEL_Pos            (8UL)
#define ADC_SMPR_SMPSEL_Msk            (0x3FFFFUL << ADC_SMPR_SMPSEL_Pos)      /*!< 0x03FFFF00 */
#define ADC_SMPR_SMPSEL                ADC_SMPR_SMPSEL_Msk                     /*!< ADC all channels sampling time selection */
#define ADC_SMPR_SMPSEL0_Pos           (8UL)
#define ADC_SMPR_SMPSEL0_Msk           (0x1UL << ADC_SMPR_SMPSEL0_Pos)         /*!< 0x00000100 */
#define ADC_SMPR_SMPSEL0               ADC_SMPR_SMPSEL0_Msk                    /*!< ADC channel 0 sampling time selection */
#define ADC_SMPR_SMPSEL1_Pos           (9UL)
#define ADC_SMPR_SMPSEL1_Msk           (0x1UL << ADC_SMPR_SMPSEL1_Pos)         /*!< 0x00000200 */
#define ADC_SMPR_SMPSEL1               ADC_SMPR_SMPSEL1_Msk                    /*!< ADC channel 1 sampling time selection */
#define ADC_SMPR_SMPSEL2_Pos           (10UL)
#define ADC_SMPR_SMPSEL2_Msk           (0x1UL << ADC_SMPR_SMPSEL2_Pos)         /*!< 0x00000400 */
#define ADC_SMPR_SMPSEL2               ADC_SMPR_SMPSEL2_Msk                    /*!< ADC channel 2 sampling time selection */
#define ADC_SMPR_SMPSEL3_Pos           (11UL)
#define ADC_SMPR_SMPSEL3_Msk           (0x1UL << ADC_SMPR_SMPSEL3_Pos)         /*!< 0x00000800 */
#define ADC_SMPR_SMPSEL3               ADC_SMPR_SMPSEL3_Msk                    /*!< ADC channel 3 sampling time selection */
#define ADC_SMPR_SMPSEL4_Pos           (12UL)
#define ADC_SMPR_SMPSEL4_Msk           (0x1UL << ADC_SMPR_SMPSEL4_Pos)         /*!< 0x00001000 */
#define ADC_SMPR_SMPSEL4               ADC_SMPR_SMPSEL4_Msk                    /*!< ADC channel 4 sampling time selection */
#define ADC_SMPR_SMPSEL5_Pos           (13UL)
#define ADC_SMPR_SMPSEL5_Msk           (0x1UL << ADC_SMPR_SMPSEL5_Pos)         /*!< 0x00002000 */
#define ADC_SMPR_SMPSEL5               ADC_SMPR_SMPSEL5_Msk                    /*!< ADC channel 5 sampling time selection */
#define ADC_SMPR_SMPSEL6_Pos           (14UL)
#define ADC_SMPR_SMPSEL6_Msk           (0x1UL << ADC_SMPR_SMPSEL6_Pos)         /*!< 0x00004000 */
#define ADC_SMPR_SMPSEL6               ADC_SMPR_SMPSEL6_Msk                    /*!< ADC channel 6 sampling time selection */
#define ADC_SMPR_SMPSEL7_Pos           (15UL)
#define ADC_SMPR_SMPSEL7_Msk           (0x1UL << ADC_SMPR_SMPSEL7_Pos)         /*!< 0x00008000 */
#define ADC_SMPR_SMPSEL7               ADC_SMPR_SMPSEL7_Msk                    /*!< ADC channel 7 sampling time selection */
#define ADC_SMPR_SMPSEL8_Pos           (16UL)
#define ADC_SMPR_SMPSEL8_Msk           (0x1UL << ADC_SMPR_SMPSEL8_Pos)         /*!< 0x00010000 */
#define ADC_SMPR_SMPSEL8               ADC_SMPR_SMPSEL8_Msk                    /*!< ADC channel 8 sampling time selection */
#define ADC_SMPR_SMPSEL9_Pos           (17UL)
#define ADC_SMPR_SMPSEL9_Msk           (0x1UL << ADC_SMPR_SMPSEL9_Pos)         /*!< 0x00020000 */
#define ADC_SMPR_SMPSEL9               ADC_SMPR_SMPSEL9_Msk                    /*!< ADC channel 9 sampling time selection */
#define ADC_SMPR_SMPSEL10_Pos          (18UL)
#define ADC_SMPR_SMPSEL10_Msk          (0x1UL << ADC_SMPR_SMPSEL10_Pos)        /*!< 0x00040000 */
#define ADC_SMPR_SMPSEL10              ADC_SMPR_SMPSEL10_Msk                   /*!< ADC channel 10 sampling time selection */
#define ADC_SMPR_SMPSEL11_Pos          (19UL)
#define ADC_SMPR_SMPSEL11_Msk          (0x1UL << ADC_SMPR_SMPSEL11_Pos)        /*!< 0x00080000 */
#define ADC_SMPR_SMPSEL11              ADC_SMPR_SMPSEL11_Msk                   /*!< ADC channel 11 sampling time selection */
#define ADC_SMPR_SMPSEL12_Pos          (20UL)
#define ADC_SMPR_SMPSEL12_Msk          (0x1UL << ADC_SMPR_SMPSEL12_Pos)        /*!< 0x00100000 */
#define ADC_SMPR_SMPSEL12              ADC_SMPR_SMPSEL12_Msk                   /*!< ADC channel 12 sampling time selection */
#define ADC_SMPR_SMPSEL13_Pos          (21UL)
#define ADC_SMPR_SMPSEL13_Msk          (0x1UL << ADC_SMPR_SMPSEL13_Pos)        /*!< 0x00200000 */
#define ADC_SMPR_SMPSEL13              ADC_SMPR_SMPSEL13_Msk                   /*!< ADC channel 13 sampling time selection */
#define ADC_SMPR_SMPSEL14_Pos          (22UL)
#define ADC_SMPR_SMPSEL14_Msk          (0x1UL << ADC_SMPR_SMPSEL14_Pos)        /*!< 0x00400000 */
#define ADC_SMPR_SMPSEL14              ADC_SMPR_SMPSEL14_Msk                   /*!< ADC channel 14 sampling time selection */
#define ADC_SMPR_SMPSEL15_Pos          (23UL)
#define ADC_SMPR_SMPSEL15_Msk          (0x1UL << ADC_SMPR_SMPSEL15_Pos)        /*!< 0x00800000 */
#define ADC_SMPR_SMPSEL15              ADC_SMPR_SMPSEL15_Msk                   /*!< ADC channel 15 sampling time selection */
#define ADC_SMPR_SMPSEL16_Pos          (24UL)
#define ADC_SMPR_SMPSEL16_Msk          (0x1UL << ADC_SMPR_SMPSEL16_Pos)        /*!< 0x01000000 */
#define ADC_SMPR_SMPSEL16              ADC_SMPR_SMPSEL16_Msk                   /*!< ADC channel 16 sampling time selection */
#define ADC_SMPR_SMPSEL17_Pos          (25UL)
#define ADC_SMPR_SMPSEL17_Msk          (0x1UL << ADC_SMPR_SMPSEL17_Pos)        /*!< 0x02000000 */
#define ADC_SMPR_SMPSEL17              ADC_SMPR_SMPSEL17_Msk                   /*!< ADC channel 17 sampling time selection */

/********************  Bit definition for ADC_AWD1TR register  *******************/
#define ADC_AWD1TR_LT1_Pos             (0UL)
#define ADC_AWD1TR_LT1_Msk             (0xFFFUL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000FFF */
#define ADC_AWD1TR_LT1                 ADC_AWD1TR_LT1_Msk                      /*!< ADC analog watchdog 1 threshold low */
#define ADC_AWD1TR_LT1_0               (0x001UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000001 */
#define ADC_AWD1TR_LT1_1               (0x002UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000002 */
#define ADC_AWD1TR_LT1_2               (0x004UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000004 */
#define ADC_AWD1TR_LT1_3               (0x008UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000008 */
#define ADC_AWD1TR_LT1_4               (0x010UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000010 */
#define ADC_AWD1TR_LT1_5               (0x020UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000020 */
#define ADC_AWD1TR_LT1_6               (0x040UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000040 */
#define ADC_AWD1TR_LT1_7               (0x080UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000080 */
#define ADC_AWD1TR_LT1_8               (0x100UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000100 */
#define ADC_AWD1TR_LT1_9               (0x200UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000200 */
#define ADC_AWD1TR_LT1_10              (0x400UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000400 */
#define ADC_AWD1TR_LT1_11              (0x800UL << ADC_AWD1TR_LT1_Pos)         /*!< 0x00000800 */

#define ADC_AWD1TR_HT1_Pos             (16UL)
#define ADC_AWD1TR_HT1_Msk             (0xFFFUL << ADC_AWD1TR_HT1_Pos)         /*!< 0x0FFF0000 */
#define ADC_AWD1TR_HT1                 ADC_AWD1TR_HT1_Msk                      /*!< ADC Analog watchdog 1 threshold high */
#define ADC_AWD1TR_HT1_0               (0x001UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x00010000 */
#define ADC_AWD1TR_HT1_1               (0x002UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x00020000 */
#define ADC_AWD1TR_HT1_2               (0x004UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x00040000 */
#define ADC_AWD1TR_HT1_3               (0x008UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x00080000 */
#define ADC_AWD1TR_HT1_4               (0x010UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x00100000 */
#define ADC_AWD1TR_HT1_5               (0x020UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x00200000 */
#define ADC_AWD1TR_HT1_6               (0x040UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x00400000 */
#define ADC_AWD1TR_HT1_7               (0x080UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x00800000 */
#define ADC_AWD1TR_HT1_8               (0x100UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x01000000 */
#define ADC_AWD1TR_HT1_9               (0x200UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x02000000 */
#define ADC_AWD1TR_HT1_10              (0x400UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x04000000 */
#define ADC_AWD1TR_HT1_11              (0x800UL << ADC_AWD1TR_HT1_Pos)         /*!< 0x08000000 */

/********************  Bit definition for ADC_AWDTR2 register  *******************/
#define ADC_AWD2TR_LT2_Pos             (0UL)
#define ADC_AWD2TR_LT2_Msk             (0xFFFUL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000FFF */
#define ADC_AWD2TR_LT2                 ADC_AWD2TR_LT2_Msk                      /*!< ADC analog watchdog 2 threshold low */
#define ADC_AWD2TR_LT2_0               (0x001UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000001 */
#define ADC_AWD2TR_LT2_1               (0x002UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000002 */
#define ADC_AWD2TR_LT2_2               (0x004UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000004 */
#define ADC_AWD2TR_LT2_3               (0x008UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000008 */
#define ADC_AWD2TR_LT2_4               (0x010UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000010 */
#define ADC_AWD2TR_LT2_5               (0x020UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000020 */
#define ADC_AWD2TR_LT2_6               (0x040UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000040 */
#define ADC_AWD2TR_LT2_7               (0x080UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000080 */
#define ADC_AWD2TR_LT2_8               (0x100UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000100 */
#define ADC_AWD2TR_LT2_9               (0x200UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000200 */
#define ADC_AWD2TR_LT2_10              (0x400UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000400 */
#define ADC_AWD2TR_LT2_11              (0x800UL << ADC_AWD2TR_LT2_Pos)         /*!< 0x00000800 */

#define ADC_AWD2TR_HT2_Pos             (16UL)
#define ADC_AWD2TR_HT2_Msk             (0xFFFUL << ADC_AWD2TR_HT2_Pos)         /*!< 0x0FFF0000 */
#define ADC_AWD2TR_HT2                 ADC_AWD2TR_HT2_Msk                      /*!< ADC analog watchdog 2 threshold high */
#define ADC_AWD2TR_HT2_0               (0x001UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x00010000 */
#define ADC_AWD2TR_HT2_1               (0x002UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x00020000 */
#define ADC_AWD2TR_HT2_2               (0x004UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x00040000 */
#define ADC_AWD2TR_HT2_3               (0x008UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x00080000 */
#define ADC_AWD2TR_HT2_4               (0x010UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x00100000 */
#define ADC_AWD2TR_HT2_5               (0x020UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x00200000 */
#define ADC_AWD2TR_HT2_6               (0x040UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x00400000 */
#define ADC_AWD2TR_HT2_7               (0x080UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x00800000 */
#define ADC_AWD2TR_HT2_8               (0x100UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x01000000 */
#define ADC_AWD2TR_HT2_9               (0x200UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x02000000 */
#define ADC_AWD2TR_HT2_10              (0x400UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x04000000 */
#define ADC_AWD2TR_HT2_11              (0x800UL << ADC_AWD2TR_HT2_Pos)         /*!< 0x08000000 */

/********************  Bit definition for ADC_CHSELR register  ****************/
#define ADC_CHSELR_CHSEL_Pos           (0UL)
#define ADC_CHSELR_CHSEL_Msk           (0x3FFFFUL << ADC_CHSELR_CHSEL_Pos)     /*!< 0x0003FFFF */
#define ADC_CHSELR_CHSEL               ADC_CHSELR_CHSEL_Msk                    /*!< ADC group regular sequencer channels, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL17_Pos         (17UL)
#define ADC_CHSELR_CHSEL17_Msk         (0x1UL << ADC_CHSELR_CHSEL17_Pos)       /*!< 0x00020000 */
#define ADC_CHSELR_CHSEL17             ADC_CHSELR_CHSEL17_Msk                  /*!< ADC group regular sequencer channel 17, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL16_Pos         (16UL)
#define ADC_CHSELR_CHSEL16_Msk         (0x1UL << ADC_CHSELR_CHSEL16_Pos)       /*!< 0x00010000 */
#define ADC_CHSELR_CHSEL16             ADC_CHSELR_CHSEL16_Msk                  /*!< ADC group regular sequencer channel 16, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL15_Pos         (15UL)
#define ADC_CHSELR_CHSEL15_Msk         (0x1UL << ADC_CHSELR_CHSEL15_Pos)       /*!< 0x00008000 */
#define ADC_CHSELR_CHSEL15             ADC_CHSELR_CHSEL15_Msk                  /*!< ADC group regular sequencer channel 15, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL14_Pos         (14UL)
#define ADC_CHSELR_CHSEL14_Msk         (0x1UL << ADC_CHSELR_CHSEL14_Pos)       /*!< 0x00004000 */
#define ADC_CHSELR_CHSEL14             ADC_CHSELR_CHSEL14_Msk                  /*!< ADC group regular sequencer channel 14, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL13_Pos         (13UL)
#define ADC_CHSELR_CHSEL13_Msk         (0x1UL << ADC_CHSELR_CHSEL13_Pos)       /*!< 0x00002000 */
#define ADC_CHSELR_CHSEL13             ADC_CHSELR_CHSEL13_Msk                  /*!< ADC group regular sequencer channel 13, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL12_Pos         (12UL)
#define ADC_CHSELR_CHSEL12_Msk         (0x1UL << ADC_CHSELR_CHSEL12_Pos)       /*!< 0x00001000 */
#define ADC_CHSELR_CHSEL12             ADC_CHSELR_CHSEL12_Msk                  /*!< ADC group regular sequencer channel 12, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL11_Pos         (11UL)
#define ADC_CHSELR_CHSEL11_Msk         (0x1UL << ADC_CHSELR_CHSEL11_Pos)       /*!< 0x00000800 */
#define ADC_CHSELR_CHSEL11             ADC_CHSELR_CHSEL11_Msk                  /*!< ADC group regular sequencer channel 11, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL10_Pos         (10UL)
#define ADC_CHSELR_CHSEL10_Msk         (0x1UL << ADC_CHSELR_CHSEL10_Pos)       /*!< 0x00000400 */
#define ADC_CHSELR_CHSEL10             ADC_CHSELR_CHSEL10_Msk                  /*!< ADC group regular sequencer channel 10, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL9_Pos          (9UL)
#define ADC_CHSELR_CHSEL9_Msk          (0x1UL << ADC_CHSELR_CHSEL9_Pos)        /*!< 0x00000200 */
#define ADC_CHSELR_CHSEL9              ADC_CHSELR_CHSEL9_Msk                   /*!< ADC group regular sequencer channel 9, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL8_Pos          (8UL)
#define ADC_CHSELR_CHSEL8_Msk          (0x1UL << ADC_CHSELR_CHSEL8_Pos)        /*!< 0x00000100 */
#define ADC_CHSELR_CHSEL8              ADC_CHSELR_CHSEL8_Msk                   /*!< ADC group regular sequencer channel 8, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL7_Pos          (7UL)
#define ADC_CHSELR_CHSEL7_Msk          (0x1UL << ADC_CHSELR_CHSEL7_Pos)        /*!< 0x00000080 */
#define ADC_CHSELR_CHSEL7              ADC_CHSELR_CHSEL7_Msk                   /*!< ADC group regular sequencer channel 7, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL6_Pos          (6UL)
#define ADC_CHSELR_CHSEL6_Msk          (0x1UL << ADC_CHSELR_CHSEL6_Pos)        /*!< 0x00000040 */
#define ADC_CHSELR_CHSEL6              ADC_CHSELR_CHSEL6_Msk                   /*!< ADC group regular sequencer channel 6, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL5_Pos          (5UL)
#define ADC_CHSELR_CHSEL5_Msk          (0x1UL << ADC_CHSELR_CHSEL5_Pos)        /*!< 0x00000020 */
#define ADC_CHSELR_CHSEL5              ADC_CHSELR_CHSEL5_Msk                   /*!< ADC group regular sequencer channel 5, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL4_Pos          (4UL)
#define ADC_CHSELR_CHSEL4_Msk          (0x1UL << ADC_CHSELR_CHSEL4_Pos)        /*!< 0x00000010 */
#define ADC_CHSELR_CHSEL4              ADC_CHSELR_CHSEL4_Msk                   /*!< ADC group regular sequencer channel 4, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL3_Pos          (3UL)
#define ADC_CHSELR_CHSEL3_Msk          (0x1UL << ADC_CHSELR_CHSEL3_Pos)        /*!< 0x00000008 */
#define ADC_CHSELR_CHSEL3              ADC_CHSELR_CHSEL3_Msk                   /*!< ADC group regular sequencer channel 3, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL2_Pos          (2UL)
#define ADC_CHSELR_CHSEL2_Msk          (0x1UL << ADC_CHSELR_CHSEL2_Pos)        /*!< 0x00000004 */
#define ADC_CHSELR_CHSEL2              ADC_CHSELR_CHSEL2_Msk                   /*!< ADC group regular sequencer channel 2, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL1_Pos          (1UL)
#define ADC_CHSELR_CHSEL1_Msk          (0x1UL << ADC_CHSELR_CHSEL1_Pos)        /*!< 0x00000002 */
#define ADC_CHSELR_CHSEL1              ADC_CHSELR_CHSEL1_Msk                   /*!< ADC group regular sequencer channel 1, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL0_Pos          (0UL)
#define ADC_CHSELR_CHSEL0_Msk          (0x1UL << ADC_CHSELR_CHSEL0_Pos)        /*!< 0x00000001 */
#define ADC_CHSELR_CHSEL0              ADC_CHSELR_CHSEL0_Msk                   /*!< ADC group regular sequencer channel 0, available when ADC_CFGR1_CHSELRMOD is reset */

#define ADC_CHSELR_SQ_ALL_Pos          (0UL)
#define ADC_CHSELR_SQ_ALL_Msk          (0xFFFFFFFFUL << ADC_CHSELR_SQ_ALL_Pos) /*!< 0xFFFFFFFF */
#define ADC_CHSELR_SQ_ALL              ADC_CHSELR_SQ_ALL_Msk                   /*!< ADC group regular sequencer all ranks, available when ADC_CFGR1_CHSELRMOD is set */

#define ADC_CHSELR_SQ8_Pos             (28UL)
#define ADC_CHSELR_SQ8_Msk             (0xFUL << ADC_CHSELR_SQ8_Pos)           /*!< 0xF0000000 */
#define ADC_CHSELR_SQ8                 ADC_CHSELR_SQ8_Msk                      /*!< ADC group regular sequencer rank 8, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ8_0               (0x1UL << ADC_CHSELR_SQ8_Pos)           /*!< 0x10000000 */
#define ADC_CHSELR_SQ8_1               (0x2UL << ADC_CHSELR_SQ8_Pos)           /*!< 0x20000000 */
#define ADC_CHSELR_SQ8_2               (0x4UL << ADC_CHSELR_SQ8_Pos)           /*!< 0x40000000 */
#define ADC_CHSELR_SQ8_3               (0x8UL << ADC_CHSELR_SQ8_Pos)           /*!< 0x80000000 */

#define ADC_CHSELR_SQ7_Pos             (24UL)
#define ADC_CHSELR_SQ7_Msk             (0xFUL << ADC_CHSELR_SQ7_Pos)           /*!< 0x0F000000 */
#define ADC_CHSELR_SQ7                 ADC_CHSELR_SQ7_Msk                      /*!< ADC group regular sequencer rank 7, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ7_0               (0x1UL << ADC_CHSELR_SQ7_Pos)           /*!< 0x01000000 */
#define ADC_CHSELR_SQ7_1               (0x2UL << ADC_CHSELR_SQ7_Pos)           /*!< 0x02000000 */
#define ADC_CHSELR_SQ7_2               (0x4UL << ADC_CHSELR_SQ7_Pos)           /*!< 0x04000000 */
#define ADC_CHSELR_SQ7_3               (0x8UL << ADC_CHSELR_SQ7_Pos)           /*!< 0x08000000 */

#define ADC_CHSELR_SQ6_Pos             (20UL)
#define ADC_CHSELR_SQ6_Msk             (0xFUL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00F00000 */
#define ADC_CHSELR_SQ6                 ADC_CHSELR_SQ6_Msk                      /*!< ADC group regular sequencer rank 6, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ6_0               (0x1UL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00100000 */
#define ADC_CHSELR_SQ6_1               (0x2UL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00200000 */
#define ADC_CHSELR_SQ6_2               (0x4UL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00400000 */
#define ADC_CHSELR_SQ6_3               (0x8UL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00800000 */

#define ADC_CHSELR_SQ5_Pos             (16UL)
#define ADC_CHSELR_SQ5_Msk             (0xFUL << ADC_CHSELR_SQ5_Pos)           /*!< 0x000F0000 */
#define ADC_CHSELR_SQ5                 ADC_CHSELR_SQ5_Msk                      /*!< ADC group regular sequencer rank 5, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ5_0               (0x1UL << ADC_CHSELR_SQ5_Pos)           /*!< 0x00010000 */
#define ADC_CHSELR_SQ5_1               (0x2UL << ADC_CHSELR_SQ5_Pos)           /*!< 0x00020000 */
#define ADC_CHSELR_SQ5_2               (0x4UL << ADC_CHSELR_SQ5_Pos)           /*!< 0x00040000 */
#define ADC_CHSELR_SQ5_3               (0x8UL << ADC_CHSELR_SQ5_Pos)           /*!< 0x00080000 */

#define ADC_CHSELR_SQ4_Pos             (12UL)
#define ADC_CHSELR_SQ4_Msk             (0xFUL << ADC_CHSELR_SQ4_Pos)           /*!< 0x0000F000 */
#define ADC_CHSELR_SQ4                 ADC_CHSELR_SQ4_Msk                      /*!< ADC group regular sequencer rank 4, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ4_0               (0x1UL << ADC_CHSELR_SQ4_Pos)           /*!< 0x00001000 */
#define ADC_CHSELR_SQ4_1               (0x2UL << ADC_CHSELR_SQ4_Pos)           /*!< 0x00002000 */
#define ADC_CHSELR_SQ4_2               (0x4UL << ADC_CHSELR_SQ4_Pos)           /*!< 0x00004000 */
#define ADC_CHSELR_SQ4_3               (0x8UL << ADC_CHSELR_SQ4_Pos)           /*!< 0x00008000 */

#define ADC_CHSELR_SQ3_Pos             (8UL)
#define ADC_CHSELR_SQ3_Msk             (0xFUL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000F00 */
#define ADC_CHSELR_SQ3                 ADC_CHSELR_SQ3_Msk                      /*!< ADC group regular sequencer rank 3, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ3_0               (0x1UL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000100 */
#define ADC_CHSELR_SQ3_1               (0x2UL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000200 */
#define ADC_CHSELR_SQ3_2               (0x4UL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000400 */
#define ADC_CHSELR_SQ3_3               (0x8UL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000800 */

#define ADC_CHSELR_SQ2_Pos             (4UL)
#define ADC_CHSELR_SQ2_Msk             (0xFUL << ADC_CHSELR_SQ2_Pos)           /*!< 0x000000F0 */
#define ADC_CHSELR_SQ2                 ADC_CHSELR_SQ2_Msk                      /*!< ADC group regular sequencer rank 2, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ2_0               (0x1UL << ADC_CHSELR_SQ2_Pos)           /*!< 0x00000010 */
#define ADC_CHSELR_SQ2_1               (0x2UL << ADC_CHSELR_SQ2_Pos)           /*!< 0x00000020 */
#define ADC_CHSELR_SQ2_2               (0x4UL << ADC_CHSELR_SQ2_Pos)           /*!< 0x00000040 */
#define ADC_CHSELR_SQ2_3               (0x8UL << ADC_CHSELR_SQ2_Pos)           /*!< 0x00000080 */

#define ADC_CHSELR_SQ1_Pos             (0UL)
#define ADC_CHSELR_SQ1_Msk             (0xFUL << ADC_CHSELR_SQ1_Pos)           /*!< 0x0000000F */
#define ADC_CHSELR_SQ1                 ADC_CHSELR_SQ1_Msk                      /*!< ADC group regular sequencer rank 1, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ1_0               (0x1UL << ADC_CHSELR_SQ1_Pos)           /*!< 0x00000001 */
#define ADC_CHSELR_SQ1_1               (0x2UL << ADC_CHSELR_SQ1_Pos)           /*!< 0x00000002 */
#define ADC_CHSELR_SQ1_2               (0x4UL << ADC_CHSELR_SQ1_Pos)           /*!< 0x00000004 */
#define ADC_CHSELR_SQ1_3               (0x8UL << ADC_CHSELR_SQ1_Pos)           /*!< 0x00000008 */

/********************  Bit definition for ADC_AWD3TR register  *******************/
#define ADC_AWD3TR_LT3_Pos             (0UL)
#define ADC_AWD3TR_LT3_Msk             (0xFFFUL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000FFF */
#define ADC_AWD3TR_LT3                 ADC_AWD3TR_LT3_Msk                      /*!< ADC analog watchdog 3 threshold low */
#define ADC_AWD3TR_LT3_0               (0x001UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000001 */
#define ADC_AWD3TR_LT3_1               (0x002UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000002 */
#define ADC_AWD3TR_LT3_2               (0x004UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000004 */
#define ADC_AWD3TR_LT3_3               (0x008UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000008 */
#define ADC_AWD3TR_LT3_4               (0x010UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000010 */
#define ADC_AWD3TR_LT3_5               (0x020UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000020 */
#define ADC_AWD3TR_LT3_6               (0x040UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000040 */
#define ADC_AWD3TR_LT3_7               (0x080UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000080 */
#define ADC_AWD3TR_LT3_8               (0x100UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000100 */
#define ADC_AWD3TR_LT3_9               (0x200UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000200 */
#define ADC_AWD3TR_LT3_10              (0x400UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000400 */
#define ADC_AWD3TR_LT3_11              (0x800UL << ADC_AWD3TR_LT3_Pos)         /*!< 0x00000800 */

#define ADC_AWD3TR_HT3_Pos             (16UL)
#define ADC_AWD3TR_HT3_Msk             (0xFFFUL << ADC_AWD3TR_HT3_Pos)         /*!< 0x0FFF0000 */
#define ADC_AWD3TR_HT3                 ADC_AWD3TR_HT3_Msk                      /*!< ADC analog watchdog 3 threshold high */
#define ADC_AWD3TR_HT3_0               (0x001UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x00010000 */
#define ADC_AWD3TR_HT3_1               (0x002UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x00020000 */
#define ADC_AWD3TR_HT3_2               (0x004UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x00040000 */
#define ADC_AWD3TR_HT3_3               (0x008UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x00080000 */
#define ADC_AWD3TR_HT3_4               (0x010UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x00100000 */
#define ADC_AWD3TR_HT3_5               (0x020UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x00200000 */
#define ADC_AWD3TR_HT3_6               (0x040UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x00400000 */
#define ADC_AWD3TR_HT3_7               (0x080UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x00800000 */
#define ADC_AWD3TR_HT3_8               (0x100UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x01000000 */
#define ADC_AWD3TR_HT3_9               (0x200UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x02000000 */
#define ADC_AWD3TR_HT3_10              (0x400UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x04000000 */
#define ADC_AWD3TR_HT3_11              (0x800UL << ADC_AWD3TR_HT3_Pos)         /*!< 0x08000000 */

/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_DATA_Pos                (0UL)
#define ADC_DR_DATA_Msk                (0xFFFFUL << ADC_DR_DATA_Pos)           /*!< 0x0000FFFF */
#define ADC_DR_DATA                    ADC_DR_DATA_Msk                         /*!< ADC group regular conversion data */

/********************  Bit definition for ADC_PWRR register  ******************/
#define ADC_PWRR_AUTOFF_Pos            (0UL)
#define ADC_PWRR_AUTOFF_Msk            (0x1UL << ADC_PWRR_AUTOFF_Pos)          /*!< 0x00000001 */
#define ADC_PWRR_AUTOFF                ADC_PWRR_AUTOFF_Msk                     /*!< ADC auto-off mode */
#define ADC_PWRR_DPD_Pos               (1UL)
#define ADC_PWRR_DPD_Msk               (0x1UL << ADC_PWRR_DPD_Pos)             /*!< 0x00000002 */
#define ADC_PWRR_DPD                   ADC_PWRR_DPD_Msk                        /*!< ADC deep power down mode */

/********************  Bit definition for ADC_AWD2CR register  ****************/
#define ADC_AWD2CR_AWD2CH_Pos          (0UL)
#define ADC_AWD2CR_AWD2CH_Msk          (0x3FFFFUL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x0003FFFF */
#define ADC_AWD2CR_AWD2CH              ADC_AWD2CR_AWD2CH_Msk                   /*!< ADC analog watchdog 2 monitored channel selection */
#define ADC_AWD2CR_AWD2CH_0            (0x00001UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1            (0x00002UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2            (0x00004UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3            (0x00008UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4            (0x00010UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5            (0x00020UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6            (0x00040UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7            (0x00080UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8            (0x00100UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9            (0x00200UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10           (0x00400UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11           (0x00800UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12           (0x01000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13           (0x02000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14           (0x04000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15           (0x08000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16           (0x10000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17           (0x20000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00020000 */

/********************  Bit definition for ADC_AWD3CR register  ****************/
#define ADC_AWD3CR_AWD3CH_Pos          (0UL)
#define ADC_AWD3CR_AWD3CH_Msk          (0x3FFFFUL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x0003FFFF */
#define ADC_AWD3CR_AWD3CH              ADC_AWD3CR_AWD3CH_Msk                   /*!< ADC analog watchdog 3 monitored channel selection */
#define ADC_AWD3CR_AWD3CH_0            (0x00001UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1            (0x00002UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2            (0x00004UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3            (0x00008UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4            (0x00010UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5            (0x00020UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6            (0x00040UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7            (0x00080UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8            (0x00100UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9            (0x00200UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10           (0x00400UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11           (0x00800UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12           (0x01000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13           (0x02000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14           (0x04000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15           (0x08000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16           (0x10000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17           (0x20000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00020000 */

/********************  Bit definition for ADC_CALFACT register  ***************/
#define ADC_CALFACT_CALFACT_Pos        (0UL)
#define ADC_CALFACT_CALFACT_Msk        (0x7FUL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x0000007F */
#define ADC_CALFACT_CALFACT            ADC_CALFACT_CALFACT_Msk                 /*!< ADC calibration factor in single-ended mode */
#define ADC_CALFACT_CALFACT_0          (0x01UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_1          (0x02UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_2          (0x04UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_3          (0x08UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_4          (0x10UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_5          (0x20UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_6          (0x40UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000040 */

/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CCR register  *******************/
#define ADC_CCR_PRESC_Pos              (18UL)
#define ADC_CCR_PRESC_Msk              (0xFUL << ADC_CCR_PRESC_Pos)            /*!< 0x003C0000 */
#define ADC_CCR_PRESC                  ADC_CCR_PRESC_Msk                       /*!< ADC common clock prescaler */
#define ADC_CCR_PRESC_0                (0x1UL << ADC_CCR_PRESC_Pos)            /*!< 0x00040000 */
#define ADC_CCR_PRESC_1                (0x2UL << ADC_CCR_PRESC_Pos)            /*!< 0x00080000 */
#define ADC_CCR_PRESC_2                (0x4UL << ADC_CCR_PRESC_Pos)            /*!< 0x00100000 */
#define ADC_CCR_PRESC_3                (0x8UL << ADC_CCR_PRESC_Pos)            /*!< 0x00200000 */

#define ADC_CCR_VREFEN_Pos             (22UL)
#define ADC_CCR_VREFEN_Msk             (0x1UL << ADC_CCR_VREFEN_Pos)           /*!< 0x00400000 */
#define ADC_CCR_VREFEN                 ADC_CCR_VREFEN_Msk                      /*!< ADC internal path to VrefInt enable */
#define ADC_CCR_TSEN_Pos               (23UL)
#define ADC_CCR_TSEN_Msk               (0x1UL << ADC_CCR_TSEN_Pos)             /*!< 0x00800000 */
#define ADC_CCR_TSEN                   ADC_CCR_TSEN_Msk                        /*!< ADC internal path to temperature sensor enable */


/******************************************************************************/
/*                                                                            */
/*                      Analog comparators (COMP)                             */
/*                                                                            */
/******************************************************************************/
/**********************  Bit definition for COMP_CSR register  ****************/
#define COMP_CSR_EN_Pos                (0UL)
#define COMP_CSR_EN_Msk                (0x1UL << COMP_CSR_EN_Pos)              /*!< 0x00000001 */
#define COMP_CSR_EN                    COMP_CSR_EN_Msk                         /*!< Comparator enable */

#define COMP_CSR_INMSEL_Pos            (4UL)
#define COMP_CSR_INMSEL_Msk            (0xFUL << COMP_CSR_INMSEL_Pos)          /*!< 0x000000F0 */
#define COMP_CSR_INMSEL                COMP_CSR_INMSEL_Msk                     /*!< Comparator input minus selection */
#define COMP_CSR_INMSEL_0              (0x1UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00000010 */
#define COMP_CSR_INMSEL_1              (0x2UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00000020 */
#define COMP_CSR_INMSEL_2              (0x4UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00000040 */
#define COMP_CSR_INMSEL_3              (0x8UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00000080 */

#define COMP_CSR_INPSEL_Pos            (8UL)
#define COMP_CSR_INPSEL_Msk            (0x3UL << COMP_CSR_INPSEL_Pos)          /*!< 0x00000300 */
#define COMP_CSR_INPSEL                COMP_CSR_INPSEL_Msk                     /*!< Comparator input plus selection */
#define COMP_CSR_INPSEL_0              (0x1UL << COMP_CSR_INPSEL_Pos)          /*!< 0x00000100 */
#define COMP_CSR_INPSEL_1              (0x2UL << COMP_CSR_INPSEL_Pos)          /*!< 0x00000200 */

#define COMP_CSR_WINMODE_Pos           (11UL)
#define COMP_CSR_WINMODE_Msk           (0x1UL << COMP_CSR_WINMODE_Pos)         /*!< 0x00000800 */
#define COMP_CSR_WINMODE               COMP_CSR_WINMODE_Msk                    /*!< Pair of comparators window mode. Bit intended to be used with COMP common instance (COMP_Common_TypeDef) */

#define COMP_CSR_WINOUT_Pos            (14UL)
#define COMP_CSR_WINOUT_Msk            (0x1UL << COMP_CSR_WINOUT_Pos)          /*!< 0x00004000 */
#define COMP_CSR_WINOUT                COMP_CSR_WINOUT_Msk                     /*!< Pair of comparators window output level. Bit intended to be used with COMP common instance (COMP_Common_TypeDef) */

#define COMP_CSR_POLARITY_Pos          (15UL)
#define COMP_CSR_POLARITY_Msk          (0x1UL << COMP_CSR_POLARITY_Pos)        /*!< 0x00008000 */
#define COMP_CSR_POLARITY              COMP_CSR_POLARITY_Msk                   /*!< Comparator output polarity */

#define COMP_CSR_HYST_Pos              (16UL)
#define COMP_CSR_HYST_Msk              (0x3UL << COMP_CSR_HYST_Pos)            /*!< 0x00030000 */
#define COMP_CSR_HYST                  COMP_CSR_HYST_Msk                       /*!< Comparator input hysteresis */
#define COMP_CSR_HYST_0                (0x1UL << COMP_CSR_HYST_Pos)            /*!< 0x00010000 */
#define COMP_CSR_HYST_1                (0x2UL << COMP_CSR_HYST_Pos)            /*!< 0x00020000 */

#define COMP_CSR_PWRMODE_Pos           (18UL)
#define COMP_CSR_PWRMODE_Msk           (0x3UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x000C0000 */
#define COMP_CSR_PWRMODE               COMP_CSR_PWRMODE_Msk                    /*!< Comparator power mode */
#define COMP_CSR_PWRMODE_0             (0x1UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x00001000 */
#define COMP_CSR_PWRMODE_1             (0x2UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x00002000 */

#define COMP_CSR_BLANKSEL_Pos          (20UL)
#define COMP_CSR_BLANKSEL_Msk          (0x1FUL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x01F00000 */
#define COMP_CSR_BLANKSEL              COMP_CSR_BLANKSEL_Msk                   /*!< Comparator blanking source */
#define COMP_CSR_BLANKSEL_0            (0x01UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x00100000 */
#define COMP_CSR_BLANKSEL_1            (0x02UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x00200000 */
#define COMP_CSR_BLANKSEL_2            (0x04UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x00400000 */
#define COMP_CSR_BLANKSEL_3            (0x08UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x00800000 */
#define COMP_CSR_BLANKSEL_4            (0x10UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x01000000 */

#define COMP_CSR_VALUE_Pos             (30UL)
#define COMP_CSR_VALUE_Msk             (0x1UL << COMP_CSR_VALUE_Pos)           /*!< 0x40000000 */
#define COMP_CSR_VALUE                 COMP_CSR_VALUE_Msk                      /*!< Comparator output level */

#define COMP_CSR_LOCK_Pos              (31UL)
#define COMP_CSR_LOCK_Msk              (0x1UL << COMP_CSR_LOCK_Pos)            /*!< 0x80000000 */
#define COMP_CSR_LOCK                  COMP_CSR_LOCK_Msk                       /*!< Comparator lock */



/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos                       (0UL)
#define CRC_DR_DR_Msk                       (0xFFFFFFFFUL << CRC_DR_DR_Pos)         /*!< 0xFFFFFFFF */
#define CRC_DR_DR                           CRC_DR_DR_Msk                           /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos                     (0UL)
#define CRC_IDR_IDR_Msk                     (0xFFFFFFFFUL << CRC_IDR_IDR_Pos)       /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR                         CRC_IDR_IDR_Msk                         /*!< General-purpose 32-bits data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos                    (0UL)
#define CRC_CR_RESET_Msk                    (0x1UL << CRC_CR_RESET_Pos)             /*!< 0x00000001 */
#define CRC_CR_RESET                        CRC_CR_RESET_Msk                        /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos                 (3UL)
#define CRC_CR_POLYSIZE_Msk                 (0x3UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000018 */
#define CRC_CR_POLYSIZE                     CRC_CR_POLYSIZE_Msk                     /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0                   (0x1UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1                   (0x2UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos                   (5UL)
#define CRC_CR_REV_IN_Msk                   (0x3UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000060 */
#define CRC_CR_REV_IN                       CRC_CR_REV_IN_Msk                       /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0                     (0x1UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000020 */
#define CRC_CR_REV_IN_1                     (0x2UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos                  (7UL)
#define CRC_CR_REV_OUT_Msk                  (0x1UL << CRC_CR_REV_OUT_Pos)           /*!< 0x00000080 */
#define CRC_CR_REV_OUT                      CRC_CR_REV_OUT_Msk                      /*!< REV_OUT Reverse Output Data bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos                   (0UL)
#define CRC_INIT_INIT_Msk                   (0xFFFFFFFFUL << CRC_INIT_INIT_Pos)     /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT                       CRC_INIT_INIT_Msk                       /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos                     (0UL)
#define CRC_POL_POL_Msk                     (0xFFFFFFFFUL << CRC_POL_POL_Pos)       /*!< 0xFFFFFFFF */
#define CRC_POL_POL                         CRC_POL_POL_Msk                         /*!< Coefficients of the polynomial */


/******************************************************************************/
/*                                                                            */
/*                       Advanced Encryption Standard (AES)                   */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for AES_CR register  *********************/
#define AES_CR_EN_Pos                       (0UL)
#define AES_CR_EN_Msk                       (0x1UL << AES_CR_EN_Pos)                /*!< 0x00000001 */
#define AES_CR_EN                           AES_CR_EN_Msk                           /*!< AES Enable */
#define AES_CR_DATATYPE_Pos                 (1UL)
#define AES_CR_DATATYPE_Msk                 (0x3UL << AES_CR_DATATYPE_Pos)          /*!< 0x00000006 */
#define AES_CR_DATATYPE                     AES_CR_DATATYPE_Msk                     /*!< Data type selection */
#define AES_CR_DATATYPE_0                   (0x1UL << AES_CR_DATATYPE_Pos)          /*!< 0x00000002 */
#define AES_CR_DATATYPE_1                   (0x2UL << AES_CR_DATATYPE_Pos)          /*!< 0x00000004 */
#define AES_CR_MODE_Pos                     (3UL)
#define AES_CR_MODE_Msk                     (0x3UL << AES_CR_MODE_Pos)              /*!< 0x00000018 */
#define AES_CR_MODE                         AES_CR_MODE_Msk                         /*!< AES Mode Of Operation */
#define AES_CR_MODE_0                       (0x1UL << AES_CR_MODE_Pos)              /*!< 0x00000008 */
#define AES_CR_MODE_1                       (0x2UL << AES_CR_MODE_Pos)              /*!< 0x00000010 */
#define AES_CR_CHMOD_Pos                    (5UL)
#define AES_CR_CHMOD_Msk                    (0x803UL << AES_CR_CHMOD_Pos)           /*!< 0x00010060 */
#define AES_CR_CHMOD                        AES_CR_CHMOD_Msk                        /*!< AES Chaining Mode */
#define AES_CR_CHMOD_0                      (0x001UL << AES_CR_CHMOD_Pos)           /*!< 0x00000020 */
#define AES_CR_CHMOD_1                      (0x002UL << AES_CR_CHMOD_Pos)           /*!< 0x00000040 */
#define AES_CR_CHMOD_2                      (0x800UL << AES_CR_CHMOD_Pos)           /*!< 0x00010000 */
#define AES_CR_DMAINEN_Pos                  (11UL)
#define AES_CR_DMAINEN_Msk                  (0x1UL << AES_CR_DMAINEN_Pos)           /*!< 0x00000800 */
#define AES_CR_DMAINEN                      AES_CR_DMAINEN_Msk                      /*!< Enable data input phase DMA management  */
#define AES_CR_DMAOUTEN_Pos                 (12UL)
#define AES_CR_DMAOUTEN_Msk                 (0x1UL << AES_CR_DMAOUTEN_Pos)          /*!< 0x00001000 */
#define AES_CR_DMAOUTEN                     AES_CR_DMAOUTEN_Msk                     /*!< Enable data output phase DMA management */
#define AES_CR_GCMPH_Pos                    (13UL)
#define AES_CR_GCMPH_Msk                    (0x3UL << AES_CR_GCMPH_Pos)             /*!< 0x00006000 */
#define AES_CR_GCMPH                        AES_CR_GCMPH_Msk                        /*!< GCM Phase */
#define AES_CR_GCMPH_0                      (0x1UL << AES_CR_GCMPH_Pos)             /*!< 0x00002000 */
#define AES_CR_GCMPH_1                      (0x2UL << AES_CR_GCMPH_Pos)             /*!< 0x00004000 */
#define AES_CR_KEYSIZE_Pos                  (18UL)
#define AES_CR_KEYSIZE_Msk                  (0x1UL << AES_CR_KEYSIZE_Pos)           /*!< 0x00040000 */
#define AES_CR_KEYSIZE                      AES_CR_KEYSIZE_Msk                      /*!< Key size selection */
#define AES_CR_KEYPROT_Pos                  (19UL)
#define AES_CR_KEYPROT_Msk                  (0x1UL << AES_CR_KEYPROT_Pos)           /*!< 0x00080000 */
#define AES_CR_KEYPROT                      AES_CR_KEYPROT_Msk                      /*!<  Key protection */
#define AES_CR_NPBLB_Pos                    (20UL)
#define AES_CR_NPBLB_Msk                    (0xFUL << AES_CR_NPBLB_Pos)             /*!< 0x00F00000 */
#define AES_CR_NPBLB                        AES_CR_NPBLB_Msk                        /*!< Number of padding bytes in payload last block */
#define AES_CR_NPBLB_0                      (0x1UL << AES_CR_NPBLB_Pos)             /*!< 0x00100000 */
#define AES_CR_NPBLB_1                      (0x2UL << AES_CR_NPBLB_Pos)             /*!< 0x00200000 */
#define AES_CR_NPBLB_2                      (0x4UL << AES_CR_NPBLB_Pos)             /*!< 0x00400000 */
#define AES_CR_NPBLB_3                      (0x8UL << AES_CR_NPBLB_Pos)             /*!< 0x00800000 */
#define AES_CR_KMOD_Pos                     (24UL)
#define AES_CR_KMOD_Msk                     (0x3UL << AES_CR_KMOD_Pos)              /*!< 0x03000000 */
#define AES_CR_KMOD                         AES_CR_KMOD_Msk                         /*!< Key mode selection */
#define AES_CR_KMOD_0                       (0x1UL << AES_CR_KMOD_Pos)              /*!< 0x01000000 */
#define AES_CR_KMOD_1                       (0x2UL << AES_CR_KMOD_Pos)              /*!< 0x02000000 */
#define AES_CR_KSHAREID_Pos                 (26UL)
#define AES_CR_KSHAREID_Msk                 (0x3UL << AES_CR_KSHAREID_Pos)          /*!< 0x0C000000 */
#define AES_CR_KSHAREID                     AES_CR_KSHAREID_Msk                     /*!< Key Shared ID */
#define AES_CR_KEYSEL_Pos                   (28UL)
#define AES_CR_KEYSEL_Msk                   (0x7UL << AES_CR_KEYSEL_Pos)            /*!< 0x70000000 */
#define AES_CR_KEYSEL                       AES_CR_KEYSEL_Msk                       /*!< Key Selection */
#define AES_CR_KEYSEL_0                     (0x1UL << AES_CR_KEYSEL_Pos)            /*!< 0x10000000 */
#define AES_CR_KEYSEL_1                     (0x2UL << AES_CR_KEYSEL_Pos)            /*!< 0x20000000 */
#define AES_CR_KEYSEL_2                     (0x4UL << AES_CR_KEYSEL_Pos)            /*!< 0x40000000 */
#define AES_CR_IPRST_Pos                    (31UL)
#define AES_CR_IPRST_Msk                    (0x1UL << AES_CR_IPRST_Pos)             /*!< 0x80000000 */
#define AES_CR_IPRST                        AES_CR_IPRST_Msk                        /*!< AES IP software reset */


/*******************  Bit definition for AES_SR register  *********************/
#define AES_SR_CCF_Pos                      (0UL)
#define AES_SR_CCF_Msk                      (0x1UL << AES_SR_CCF_Pos)               /*!< 0x00000001 */
#define AES_SR_CCF                          AES_SR_CCF_Msk                          /*!< Computation Complete Flag */
#define AES_SR_RDERR_Pos                    (1UL)
#define AES_SR_RDERR_Msk                    (0x1UL << AES_SR_RDERR_Pos)             /*!< 0x00000002 */
#define AES_SR_RDERR                        AES_SR_RDERR_Msk                        /*!< Read Error Flag */
#define AES_SR_WRERR_Pos                    (2UL)
#define AES_SR_WRERR_Msk                    (0x1UL << AES_SR_WRERR_Pos)             /*!< 0x00000004 */
#define AES_SR_WRERR                        AES_SR_WRERR_Msk                        /*!< Write Error Flag */
#define AES_SR_BUSY_Pos                     (3UL)
#define AES_SR_BUSY_Msk                     (0x1UL << AES_SR_BUSY_Pos)              /*!< 0x00000008 */
#define AES_SR_BUSY                         AES_SR_BUSY_Msk                         /*!< Busy Flag */
#define AES_SR_KEYVALID_Pos                 (7UL)
#define AES_SR_KEYVALID_Msk                 (0x1UL << AES_SR_KEYVALID_Pos)          /*!< 0x00000080 */
#define AES_SR_KEYVALID                     AES_SR_KEYVALID_Msk                     /*!< Key Valid Flag */

/*******************  Bit definition for AES_DINR register  *******************/
#define AES_DINR_Pos                        (0UL)
#define AES_DINR_Msk                        (0xFFFFFFFFUL << AES_DINR_Pos)          /*!< 0xFFFFFFFF */
#define AES_DINR                            AES_DINR_Msk                            /*!< AES Data Input Register */

/*******************  Bit definition for AES_DOUTR register  ******************/
#define AES_DOUTR_Pos                       (0UL)
#define AES_DOUTR_Msk                       (0xFFFFFFFFUL << AES_DOUTR_Pos)         /*!< 0xFFFFFFFF */
#define AES_DOUTR                           AES_DOUTR_Msk                           /*!< AES Data Output Register */

/*******************  Bit definition for AES_KEYR0 register  ******************/
#define AES_KEYR0_Pos                       (0UL)
#define AES_KEYR0_Msk                       (0xFFFFFFFFUL << AES_KEYR0_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR0                           AES_KEYR0_Msk                           /*!< AES Key Register 0 */

/*******************  Bit definition for AES_KEYR1 register  ******************/
#define AES_KEYR1_Pos                       (0UL)
#define AES_KEYR1_Msk                       (0xFFFFFFFFUL << AES_KEYR1_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR1                           AES_KEYR1_Msk                           /*!< AES Key Register 1 */

/*******************  Bit definition for AES_KEYR2 register  ******************/
#define AES_KEYR2_Pos                       (0UL)
#define AES_KEYR2_Msk                       (0xFFFFFFFFUL << AES_KEYR2_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR2                           AES_KEYR2_Msk                           /*!< AES Key Register 2 */

/*******************  Bit definition for AES_KEYR3 register  ******************/
#define AES_KEYR3_Pos                       (0UL)
#define AES_KEYR3_Msk                       (0xFFFFFFFFUL << AES_KEYR3_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR3                           AES_KEYR3_Msk                           /*!< AES Key Register 3 */

/*******************  Bit definition for AES_KEYR4 register  ******************/
#define AES_KEYR4_Pos                       (0UL)
#define AES_KEYR4_Msk                       (0xFFFFFFFFUL << AES_KEYR4_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR4                           AES_KEYR4_Msk                           /*!< AES Key Register 4 */

/*******************  Bit definition for AES_KEYR5 register  ******************/
#define AES_KEYR5_Pos                       (0UL)
#define AES_KEYR5_Msk                       (0xFFFFFFFFUL << AES_KEYR5_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR5                           AES_KEYR5_Msk                           /*!< AES Key Register 5 */

/*******************  Bit definition for AES_KEYR6 register  ******************/
#define AES_KEYR6_Pos                       (0UL)
#define AES_KEYR6_Msk                       (0xFFFFFFFFUL << AES_KEYR6_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR6                           AES_KEYR6_Msk                           /*!< AES Key Register 6 */

/*******************  Bit definition for AES_KEYR7 register  ******************/
#define AES_KEYR7_Pos                       (0UL)
#define AES_KEYR7_Msk                       (0xFFFFFFFFUL << AES_KEYR7_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR7                           AES_KEYR7_Msk                           /*!< AES Key Register 7 */

/*******************  Bit definition for AES_IVR0 register   ******************/
#define AES_IVR0_Pos                        (0UL)
#define AES_IVR0_Msk                        (0xFFFFFFFFUL << AES_IVR0_Pos)          /*!< 0xFFFFFFFF */
#define AES_IVR0                            AES_IVR0_Msk                            /*!< AES Initialization Vector Register 0 */

/*******************  Bit definition for AES_IVR1 register   ******************/
#define AES_IVR1_Pos                        (0UL)
#define AES_IVR1_Msk                        (0xFFFFFFFFUL << AES_IVR1_Pos)          /*!< 0xFFFFFFFF */
#define AES_IVR1                            AES_IVR1_Msk                            /*!< AES Initialization Vector Register 1 */

/*******************  Bit definition for AES_IVR2 register   ******************/
#define AES_IVR2_Pos                        (0UL)
#define AES_IVR2_Msk                        (0xFFFFFFFFUL << AES_IVR2_Pos)          /*!< 0xFFFFFFFF */
#define AES_IVR2                            AES_IVR2_Msk                            /*!< AES Initialization Vector Register 2 */

/*******************  Bit definition for AES_IVR3 register   ******************/
#define AES_IVR3_Pos                        (0UL)
#define AES_IVR3_Msk                        (0xFFFFFFFFUL << AES_IVR3_Pos)          /*!< 0xFFFFFFFF */
#define AES_IVR3                            AES_IVR3_Msk                            /*!< AES Initialization Vector Register 3 */

/*******************  Bit definition for AES_SUSP0R register  ******************/
#define AES_SUSP0R_Pos                      (0UL)
#define AES_SUSP0R_Msk                      (0xFFFFFFFFUL << AES_SUSP0R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP0R                          AES_SUSP0R_Msk                          /*!< AES Suspend registers 0 */

/*******************  Bit definition for AES_SUSP1R register  ******************/
#define AES_SUSP1R_Pos                      (0UL)
#define AES_SUSP1R_Msk                      (0xFFFFFFFFUL << AES_SUSP1R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP1R                          AES_SUSP1R_Msk                          /*!< AES Suspend registers 1 */

/*******************  Bit definition for AES_SUSP2R register  ******************/
#define AES_SUSP2R_Pos                      (0UL)
#define AES_SUSP2R_Msk                      (0xFFFFFFFFUL << AES_SUSP2R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP2R                          AES_SUSP2R_Msk                          /*!< AES Suspend registers 2 */

/*******************  Bit definition for AES_SUSP3R register  ******************/
#define AES_SUSP3R_Pos                      (0UL)
#define AES_SUSP3R_Msk                      (0xFFFFFFFFUL << AES_SUSP3R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP3R                          AES_SUSP3R_Msk                          /*!< AES Suspend registers 3 */

/*******************  Bit definition for AES_SUSP4R register  ******************/
#define AES_SUSP4R_Pos                      (0UL)
#define AES_SUSP4R_Msk                      (0xFFFFFFFFUL << AES_SUSP4R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP4R                          AES_SUSP4R_Msk                          /*!< AES Suspend registers 4 */

/*******************  Bit definition for AES_SUSP5R register  ******************/
#define AES_SUSP5R_Pos                      (0UL)
#define AES_SUSP5R_Msk                      (0xFFFFFFFFUL << AES_SUSP5R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP5R                          AES_SUSP5R_Msk                          /*!< AES Suspend registers 5 */

/*******************  Bit definition for AES_SUSP6R register  ******************/
#define AES_SUSP6R_Pos                      (0UL)
#define AES_SUSP6R_Msk                      (0xFFFFFFFFUL << AES_SUSP6R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP6R                          AES_SUSP6R_Msk                          /*!< AES Suspend registers 6 */

/*******************  Bit definition for AES_SUSP7R register  ******************/
#define AES_SUSP7R_Pos                      (0UL)
#define AES_SUSP7R_Msk                      (0xFFFFFFFFUL << AES_SUSP7R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP7R                          AES_SUSP7R_Msk                          /*!< AES Suspend registers 7 */

/*******************  Bit definition for AES_IER register     ******************/
#define AES_IER_CCFIE_Pos                   (0UL)
#define AES_IER_CCFIE_Msk                   (0x1UL << AES_IER_CCFIE_Pos)            /*!< 0x00000001 */
#define AES_IER_CCFIE                       AES_IER_CCFIE_Msk                       /*!< Computation complete flag interrupt enable */
#define AES_IER_RWEIE_Pos                   (1UL)
#define AES_IER_RWEIE_Msk                   (0x1UL << AES_IER_RWEIE_Pos)            /*!< 0x00000002 */
#define AES_IER_RWEIE                       AES_IER_RWEIE_Msk                       /*!< Read or write error Interrupt Enable */
#define AES_IER_KEIE_Pos                    (2UL)
#define AES_IER_KEIE_Msk                    (0x1UL << AES_IER_KEIE_Pos)             /*!< 0x00000004 */
#define AES_IER_KEIE                        AES_IER_KEIE_Msk                        /*!< Key error interrupt enable */
#define AES_IER_RNGEIE_Pos                  (3UL)
#define AES_IER_RNGEIE_Msk                  (0x1UL << AES_IER_RNGEIE_Pos)           /*!< 0x00000008 */
#define AES_IER_RNGEIE                      AES_IER_RNGEIE_Msk                      /*!< SAES Rng error interrupt enable */

/*******************  Bit definition for AES_ISR register     ******************/
#define AES_ISR_CCF_Pos                     (0UL)
#define AES_ISR_CCF_Msk                     (0x1UL << AES_ISR_CCF_Pos)              /*!< 0x00000001 */
#define AES_ISR_CCF                         AES_ISR_CCF_Msk                         /*!< Computation complete flag */
#define AES_ISR_RWEIF_Pos                   (1UL)
#define AES_ISR_RWEIF_Msk                   (0x1UL << AES_ISR_RWEIF_Pos)            /*!< 0x00000002 */
#define AES_ISR_RWEIF                       AES_ISR_RWEIF_Msk                       /*!< Read or write error Interrupt flag */
#define AES_ISR_KEIF_Pos                    (2UL)
#define AES_ISR_KEIF_Msk                    (0x1UL << AES_ISR_KEIF_Pos)             /*!< 0x00000004 */
#define AES_ISR_KEIF                        AES_ISR_KEIF_Msk                        /*!< Key error interrupt flag */
#define AES_ISR_RNGEIF_Pos                  (3UL)
#define AES_ISR_RNGEIF_Msk                  (0x1UL << AES_ISR_RNGEIF_Pos)           /*!< 0x00000008 */
#define AES_ISR_RNGEIF                      AES_ISR_RNGEIF_Msk                      /*!< SAES Rng error interrupt flag */

/*******************  Bit definition for AES_ICR register     ******************/
#define AES_ICR_CCF_Pos                     (0UL)
#define AES_ICR_CCF_Msk                     (0x1UL << AES_ICR_CCF_Pos)              /*!< 0x00000001 */
#define AES_ICR_CCF                         AES_ICR_CCF_Msk                         /*!< Computation complete flag clear */
#define AES_ICR_RWEIF_Pos                   (1UL)
#define AES_ICR_RWEIF_Msk                   (0x1UL << AES_ICR_RWEIF_Pos)            /*!< 0x00000002 */
#define AES_ICR_RWEIF                       AES_ICR_RWEIF_Msk                       /*!< Read or write error Interrupt flag clear */
#define AES_ICR_KEIF_Pos                    (2UL)
#define AES_ICR_KEIF_Msk                    (0x1UL << AES_ICR_KEIF_Pos)             /*!< 0x00000004 */
#define AES_ICR_KEIF                        AES_ICR_KEIF_Msk                        /*!< Key error interrupt flag clear */
#define AES_ICR_RNGEIF_Pos                  (3UL)
#define AES_ICR_RNGEIF_Msk                  (0x1UL << AES_ICR_RNGEIF_Pos)           /*!< 0x00000008 */
#define AES_ICR_RNGEIF                      AES_ICR_RNGEIF_Msk                      /*!< SAES Rng error interrupt flag clear */

/******************************************************************************/
/*                                                                            */
/*                                 Debug MCU                                  */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DBGMCU_IDCODE register  *************/
#define DBGMCU_IDCODE_DEV_ID_Pos            (0UL)
#define DBGMCU_IDCODE_DEV_ID_Msk            (0xFFFUL << DBGMCU_IDCODE_DEV_ID_Pos)   /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                DBGMCU_IDCODE_DEV_ID_Msk
#define DBGMCU_IDCODE_REV_ID_Pos            (16UL)
#define DBGMCU_IDCODE_REV_ID_Msk            (0xFFFFUL << DBGMCU_IDCODE_REV_ID_Pos)  /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                DBGMCU_IDCODE_REV_ID_Msk

/********************  Bit definition for DBGMCU_SCR register  *****************/
#define DBGMCU_SCR_DBG_STOP_Pos             (1UL)
#define DBGMCU_SCR_DBG_STOP_Msk             (0x1UL << DBGMCU_SCR_DBG_STOP_Pos)      /*!< 0x00000002 */
#define DBGMCU_SCR_DBG_STOP                 DBGMCU_SCR_DBG_STOP_Msk
#define DBGMCU_SCR_DBG_STANDBY_Pos          (2UL)
#define DBGMCU_SCR_DBG_STANDBY_Msk          (0x1UL << DBGMCU_SCR_DBG_STANDBY_Pos)   /*!< 0x00000004 */
#define DBGMCU_SCR_DBG_STANDBY              DBGMCU_SCR_DBG_STANDBY_Msk
#define DBGMCU_SCR_TRACE_IOEN_Pos           (4UL)
#define DBGMCU_SCR_TRACE_IOEN_Msk           (0x1UL << DBGMCU_SCR_TRACE_IOEN_Pos)    /*!< 0x00000010 */
#define DBGMCU_SCR_TRACE_IOEN               DBGMCU_SCR_TRACE_IOEN_Msk               /*!< Trace port pins enable */
#define DBGMCU_SCR_TRACE_EN_Pos             (5UL)
#define DBGMCU_SCR_TRACE_EN_Msk             (0x1UL << DBGMCU_SCR_TRACE_EN_Pos)      /*!< 0x00000020 */
#define DBGMCU_SCR_TRACE_EN                 DBGMCU_SCR_TRACE_EN_Msk                 /*!< Trace port enable */
#define DBGMCU_SCR_TRACE_MODE_Pos           (6UL)
#define DBGMCU_SCR_TRACE_MODE_Msk           (0x3UL << DBGMCU_SCR_TRACE_MODE_Pos)    /*!< 0x000000C0 */
#define DBGMCU_SCR_TRACE_MODE               DBGMCU_SCR_TRACE_MODE_Msk               /*!< Trace pin assignment */
#define DBGMCU_SCR_TRACE_MODE_0             (0x1UL << DBGMCU_SCR_TRACE_MODE_Pos)
#define DBGMCU_SCR_TRACE_MODE_1             (0x2UL << DBGMCU_SCR_TRACE_MODE_Pos)
#define DBGMCU_SCR_DBG_LPMS_Pos             (16UL)
#define DBGMCU_SCR_DBG_LPMS_Msk             (0x7UL << DBGMCU_SCR_DBG_LPMS_Pos)      /*!< 0x00070000 */
#define DBGMCU_SCR_DBG_LPMS                 DBGMCU_SCR_DBG_LPMS_Msk
#define DBGMCU_SCR_DBG_LPMS_0               (0x1UL << DBGMCU_SCR_DBG_LPMS_Pos)
#define DBGMCU_SCR_DBG_LPMS_1               (0x2UL << DBGMCU_SCR_DBG_LPMS_Pos)
#define DBGMCU_SCR_DBG_LPMS_2               (0x4UL << DBGMCU_SCR_DBG_LPMS_Pos)
#define DBGMCU_SCR_DBG_STOPF_Pos            (19UL)
#define DBGMCU_SCR_DBG_STOPF_Msk            (0x1UL << DBGMCU_SCR_DBG_STOPF_Pos)     /*!< 0x00080000 */
#define DBGMCU_SCR_DBG_STOPF                DBGMCU_SCR_DBG_STOPF_Msk
#define DBGMCU_SCR_DBG_SBF_Pos              (20UL)
#define DBGMCU_SCR_DBG_SBF_Msk              (0x1UL << DBGMCU_SCR_DBG_SBF_Pos)       /*!< 0x00100000 */
#define DBGMCU_SCR_DBG_SBF                  DBGMCU_SCR_DBG_SBF_Msk
#define DBGMCU_SCR_DBG_CS_Pos               (24UL)
#define DBGMCU_SCR_DBG_CS_Msk               (0x1UL << DBGMCU_SCR_DBG_CS_Pos)        /*!< 0x01000000 */
#define DBGMCU_SCR_DBG_CS                   DBGMCU_SCR_DBG_CS_Msk
#define DBGMCU_SCR_DBG_CDS_Pos              (25UL)
#define DBGMCU_SCR_DBG_CDS_Msk              (0x1UL << DBGMCU_SCR_DBG_CDS_Pos)       /*!< 0x02000000 */
#define DBGMCU_SCR_DBG_CDS                  DBGMCU_SCR_DBG_CDS_Msk

/********************  Bit definition for DBGMCU_APB1LFZR register  ***********/
#define DBGMCU_APB1LFZR_DBG_TIM2_STOP_Pos   (0UL)
#define DBGMCU_APB1LFZR_DBG_TIM2_STOP_Msk   (0x1UL << DBGMCU_APB1LFZR_DBG_TIM2_STOP_Pos)
#define DBGMCU_APB1LFZR_DBG_TIM2_STOP       DBGMCU_APB1LFZR_DBG_TIM2_STOP_Msk
#define DBGMCU_APB1LFZR_DBG_TIM3_STOP_Pos   (1UL)
#define DBGMCU_APB1LFZR_DBG_TIM3_STOP_Msk   (0x1UL << DBGMCU_APB1LFZR_DBG_TIM3_STOP_Pos)
#define DBGMCU_APB1LFZR_DBG_TIM3_STOP       DBGMCU_APB1LFZR_DBG_TIM3_STOP_Msk
#define DBGMCU_APB1LFZR_DBG_TIM4_STOP_Pos   (2UL)
#define DBGMCU_APB1LFZR_DBG_TIM4_STOP_Msk   (0x1UL << DBGMCU_APB1LFZR_DBG_TIM4_STOP_Pos)
#define DBGMCU_APB1LFZR_DBG_TIM4_STOP       DBGMCU_APB1LFZR_DBG_TIM4_STOP_Msk
#define DBGMCU_APB1LFZR_DBG_WWDG_STOP_Pos   (11UL)
#define DBGMCU_APB1LFZR_DBG_WWDG_STOP_Msk   (0x1UL << DBGMCU_APB1LFZR_DBG_WWDG_STOP_Pos)
#define DBGMCU_APB1LFZR_DBG_WWDG_STOP       DBGMCU_APB1LFZR_DBG_WWDG_STOP_Msk
#define DBGMCU_APB1LFZR_DBG_IWDG_STOP_Pos   (12UL)
#define DBGMCU_APB1LFZR_DBG_IWDG_STOP_Msk   (0x1UL << DBGMCU_APB1LFZR_DBG_IWDG_STOP_Pos)
#define DBGMCU_APB1LFZR_DBG_IWDG_STOP       DBGMCU_APB1LFZR_DBG_IWDG_STOP_Msk
#define DBGMCU_APB1LFZR_DBG_I2C1_STOP_Pos   (21UL)
#define DBGMCU_APB1LFZR_DBG_I2C1_STOP_Msk   (0x1UL << DBGMCU_APB1LFZR_DBG_I2C1_STOP_Pos)
#define DBGMCU_APB1LFZR_DBG_I2C1_STOP       DBGMCU_APB1LFZR_DBG_I2C1_STOP_Msk
#define DBGMCU_APB1LFZR_DBG_I2C2_STOP_Pos   (22UL)
#define DBGMCU_APB1LFZR_DBG_I2C2_STOP_Msk   (0x1UL << DBGMCU_APB1LFZR_DBG_I2C2_STOP_Pos)
#define DBGMCU_APB1LFZR_DBG_I2C2_STOP       DBGMCU_APB1LFZR_DBG_I2C2_STOP_Msk

/********************  Bit definition for DBGMCU_APB1HFZR register  ***********/
#define DBGMCU_APB1HFZR_DBG_I2C4_STOP_Pos   (1UL)
#define DBGMCU_APB1HFZR_DBG_I2C4_STOP_Msk   (0x1UL << DBGMCU_APB1HFZR_DBG_I2C4_STOP_Pos)
#define DBGMCU_APB1HFZR_DBG_I2C4_STOP       DBGMCU_APB1HFZR_DBG_I2C4_STOP_Msk
#define DBGMCU_APB1HFZR_DBG_LPTIM2_STOP_Pos (5UL)
#define DBGMCU_APB1HFZR_DBG_LPTIM2_STOP_Msk (0x1UL << DBGMCU_APB1HFZR_DBG_LPTIM2_STOP_Pos)
#define DBGMCU_APB1HFZR_DBG_LPTIM2_STOP     DBGMCU_APB1HFZR_DBG_LPTIM2_STOP_Msk

/********************  Bit definition for DBGMCU_APB2FZR register  ***********/
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos    (11UL)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk    (0x1UL << DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP        DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos   (17UL)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP       DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos   (18UL)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP       DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk

/********************  Bit definition for DBGMCU_APB7FZR register  ***********/
#define DBGMCU_APB7FZR_DBG_I2C3_STOP_Pos    (10UL)
#define DBGMCU_APB7FZR_DBG_I2C3_STOP_Msk    (0x1UL << DBGMCU_APB7FZR_DBG_I2C3_STOP_Pos)
#define DBGMCU_APB7FZR_DBG_I2C3_STOP        DBGMCU_APB7FZR_DBG_I2C3_STOP_Msk
#define DBGMCU_APB7FZR_DBG_LPTIM1_STOP_Pos  (17UL)
#define DBGMCU_APB7FZR_DBG_LPTIM1_STOP_Msk  (0x1UL << DBGMCU_APB7FZR_DBG_LPTIM1_STOP_Pos)
#define DBGMCU_APB7FZR_DBG_LPTIM1_STOP      DBGMCU_APB7FZR_DBG_LPTIM1_STOP_Msk
#define DBGMCU_APB7FZR_DBG_RTC_STOP_Pos     (30UL)
#define DBGMCU_APB7FZR_DBG_RTC_STOP_Msk     (0x1UL << DBGMCU_APB7FZR_DBG_RTC_STOP_Pos)
#define DBGMCU_APB7FZR_DBG_RTC_STOP         DBGMCU_APB7FZR_DBG_RTC_STOP_Msk

/********************  Bit definition for DBGMCU_AHB1FZR register  ***********/
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP_Pos  (0UL)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP_Pos  (1UL)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP_Pos  (2UL)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP_Pos  (3UL)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP_Pos  (4UL)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP_Pos  (5UL)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP_Pos  (6UL)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP_Pos  (7UL)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP_Msk


/******************************************************************************/
/*                                                                            */
/*                           DMA Controller (DMA)                             */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for DMA_SECCFGR register  ****************/
#define DMA_SECCFGR_SEC0_Pos                (0UL)
#define DMA_SECCFGR_SEC0_Msk                (0x1UL << DMA_SECCFGR_SEC0_Pos)         /*!< 0x00000001 */
#define DMA_SECCFGR_SEC0                    DMA_SECCFGR_SEC0_Msk                    /*!< Secure State of Channel 0 */
#define DMA_SECCFGR_SEC1_Pos                (1UL)
#define DMA_SECCFGR_SEC1_Msk                (0x1UL << DMA_SECCFGR_SEC1_Pos)         /*!< 0x00000002 */
#define DMA_SECCFGR_SEC1                    DMA_SECCFGR_SEC1_Msk                    /*!< Secure State of Channel 1 */
#define DMA_SECCFGR_SEC2_Pos                (2UL)
#define DMA_SECCFGR_SEC2_Msk                (0x1UL << DMA_SECCFGR_SEC2_Pos)         /*!< 0x00000004 */
#define DMA_SECCFGR_SEC2                    DMA_SECCFGR_SEC2_Msk                    /*!< Secure State of Channel 2 */
#define DMA_SECCFGR_SEC3_Pos                (3UL)
#define DMA_SECCFGR_SEC3_Msk                (0x1UL << DMA_SECCFGR_SEC3_Pos)         /*!< 0x00000008 */
#define DMA_SECCFGR_SEC3                    DMA_SECCFGR_SEC3_Msk                    /*!< Secure State of Channel 3 */
#define DMA_SECCFGR_SEC4_Pos                (4UL)
#define DMA_SECCFGR_SEC4_Msk                (0x1UL << DMA_SECCFGR_SEC4_Pos)         /*!< 0x00000010 */
#define DMA_SECCFGR_SEC4                    DMA_SECCFGR_SEC4_Msk                    /*!< Secure State of Channel 4 */
#define DMA_SECCFGR_SEC5_Pos                (5UL)
#define DMA_SECCFGR_SEC5_Msk                (0x1UL << DMA_SECCFGR_SEC5_Pos)         /*!< 0x00000020 */
#define DMA_SECCFGR_SEC5                    DMA_SECCFGR_SEC5_Msk                    /*!< Secure State of Channel 5 */
#define DMA_SECCFGR_SEC6_Pos                (6UL)
#define DMA_SECCFGR_SEC6_Msk                (0x1UL << DMA_SECCFGR_SEC6_Pos)         /*!< 0x00000040 */
#define DMA_SECCFGR_SEC6                    DMA_SECCFGR_SEC6_Msk                    /*!< Secure State of Channel 6 */
#define DMA_SECCFGR_SEC7_Pos                (7UL)
#define DMA_SECCFGR_SEC7_Msk                (0x1UL << DMA_SECCFGR_SEC7_Pos)         /*!< 0x00000080 */
#define DMA_SECCFGR_SEC7                    DMA_SECCFGR_SEC7_Msk                    /*!< Secure State of Channel 7 */

/*******************  Bit definition for DMA_PRIVCFGR register  ****************/
#define DMA_PRIVCFGR_PRIV0_Pos              (0UL)
#define DMA_PRIVCFGR_PRIV0_Msk              (0x1UL << DMA_PRIVCFGR_PRIV0_Pos)       /*!< 0x00000001 */
#define DMA_PRIVCFGR_PRIV0                  DMA_PRIVCFGR_PRIV0_Msk                  /*!< Privileged State of Channel 0 */
#define DMA_PRIVCFGR_PRIV1_Pos              (1UL)
#define DMA_PRIVCFGR_PRIV1_Msk              (0x1UL << DMA_PRIVCFGR_PRIV1_Pos)       /*!< 0x00000002 */
#define DMA_PRIVCFGR_PRIV1                  DMA_PRIVCFGR_PRIV1_Msk                  /*!< Privileged State of Channel 1 */
#define DMA_PRIVCFGR_PRIV2_Pos              (2UL)
#define DMA_PRIVCFGR_PRIV2_Msk              (0x1UL << DMA_PRIVCFGR_PRIV2_Pos)       /*!< 0x00000004 */
#define DMA_PRIVCFGR_PRIV2                  DMA_PRIVCFGR_PRIV2_Msk                  /*!< Privileged State of Channel 2 */
#define DMA_PRIVCFGR_PRIV3_Pos              (3UL)
#define DMA_PRIVCFGR_PRIV3_Msk              (0x1UL << DMA_PRIVCFGR_PRIV3_Pos)       /*!< 0x00000008 */
#define DMA_PRIVCFGR_PRIV3                  DMA_PRIVCFGR_PRIV3_Msk                  /*!< Privileged State of Channel 3 */
#define DMA_PRIVCFGR_PRIV4_Pos              (4UL)
#define DMA_PRIVCFGR_PRIV4_Msk              (0x1UL << DMA_PRIVCFGR_PRIV4_Pos)       /*!< 0x00000010 */
#define DMA_PRIVCFGR_PRIV4                  DMA_PRIVCFGR_PRIV4_Msk                  /*!< Privileged State of Channel 4 */
#define DMA_PRIVCFGR_PRIV5_Pos              (5UL)
#define DMA_PRIVCFGR_PRIV5_Msk              (0x1UL << DMA_PRIVCFGR_PRIV5_Pos)       /*!< 0x00000020 */
#define DMA_PRIVCFGR_PRIV5                  DMA_PRIVCFGR_PRIV5_Msk                  /*!< Privileged State of Channel 5 */
#define DMA_PRIVCFGR_PRIV6_Pos              (6UL)
#define DMA_PRIVCFGR_PRIV6_Msk              (0x1UL << DMA_PRIVCFGR_PRIV6_Pos)       /*!< 0x00000040 */
#define DMA_PRIVCFGR_PRIV6                  DMA_PRIVCFGR_PRIV6_Msk                  /*!< Privileged State of Channel 6 */
#define DMA_PRIVCFGR_PRIV7_Pos              (7UL)
#define DMA_PRIVCFGR_PRIV7_Msk              (0x1UL << DMA_PRIVCFGR_PRIV7_Pos)       /*!< 0x00000080 */
#define DMA_PRIVCFGR_PRIV7                  DMA_PRIVCFGR_PRIV7_Msk                  /*!< Privileged State of Channel 7 */

/*******************  Bit definition for DMA_RCFGLOCKR register  ****************/
#define DMA_RCFGLOCKR_LOCK0_Pos              (0UL)
#define DMA_RCFGLOCKR_LOCK0_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK0_Pos)       /*!< 0x00000001 */
#define DMA_RCFGLOCKR_LOCK0                  DMA_RCFGLOCKR_LOCK0_Msk                  /*!< Privileged and Secure State Lock of Channel 0 */
#define DMA_RCFGLOCKR_LOCK1_Pos              (1UL)
#define DMA_RCFGLOCKR_LOCK1_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK1_Pos)       /*!< 0x00000002 */
#define DMA_RCFGLOCKR_LOCK1                  DMA_RCFGLOCKR_LOCK1_Msk                  /*!< Privileged and Secure State Lock of Channel 1 */
#define DMA_RCFGLOCKR_LOCK2_Pos              (2UL)
#define DMA_RCFGLOCKR_LOCK2_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK2_Pos)       /*!< 0x00000004 */
#define DMA_RCFGLOCKR_LOCK2                  DMA_RCFGLOCKR_LOCK2_Msk                  /*!< Privileged and Secure State Lock of Channel 2 */
#define DMA_RCFGLOCKR_LOCK3_Pos              (3UL)
#define DMA_RCFGLOCKR_LOCK3_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK3_Pos)       /*!< 0x00000008 */
#define DMA_RCFGLOCKR_LOCK3                  DMA_RCFGLOCKR_LOCK3_Msk                  /*!< Privileged and Secure State Lock of Channel 3 */
#define DMA_RCFGLOCKR_LOCK4_Pos              (4UL)
#define DMA_RCFGLOCKR_LOCK4_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK4_Pos)       /*!< 0x00000010 */
#define DMA_RCFGLOCKR_LOCK4                  DMA_RCFGLOCKR_LOCK4_Msk                  /*!< Privileged and Secure State Lock of Channel 4 */
#define DMA_RCFGLOCKR_LOCK5_Pos              (5UL)
#define DMA_RCFGLOCKR_LOCK5_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK5_Pos)       /*!< 0x00000020 */
#define DMA_RCFGLOCKR_LOCK5                  DMA_RCFGLOCKR_LOCK5_Msk                  /*!< Privileged and Secure State Lock of Channel 5 */
#define DMA_RCFGLOCKR_LOCK6_Pos              (6UL)
#define DMA_RCFGLOCKR_LOCK6_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK6_Pos)       /*!< 0x00000040 */
#define DMA_RCFGLOCKR_LOCK6                  DMA_RCFGLOCKR_LOCK6_Msk                  /*!< Privileged and Secure State Lock of Channel 6 */
#define DMA_RCFGLOCKR_LOCK7_Pos              (7UL)
#define DMA_RCFGLOCKR_LOCK7_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK7_Pos)       /*!< 0x00000080 */
#define DMA_RCFGLOCKR_LOCK7                  DMA_RCFGLOCKR_LOCK7_Msk                  /*!< Privileged and Secure State Lock of Channel 7 */

/*******************  Bit definition for DMA_MISR register  ****************/
#define DMA_MISR_MIS0_Pos                   (0UL)
#define DMA_MISR_MIS0_Msk                   (0x1UL << DMA_MISR_MIS0_Pos)            /*!< 0x00000001 */
#define DMA_MISR_MIS0                       DMA_MISR_MIS0_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 0 */
#define DMA_MISR_MIS1_Pos                   (1UL)
#define DMA_MISR_MIS1_Msk                   (0x1UL << DMA_MISR_MIS1_Pos)            /*!< 0x00000002 */
#define DMA_MISR_MIS1                       DMA_MISR_MIS1_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 1 */
#define DMA_MISR_MIS2_Pos                   (2UL)
#define DMA_MISR_MIS2_Msk                   (0x1UL << DMA_MISR_MIS2_Pos)            /*!< 0x00000004 */
#define DMA_MISR_MIS2                       DMA_MISR_MIS2_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 2 */
#define DMA_MISR_MIS3_Pos                   (3UL)
#define DMA_MISR_MIS3_Msk                   (0x1UL << DMA_MISR_MIS3_Pos)            /*!< 0x00000008 */
#define DMA_MISR_MIS3                       DMA_MISR_MIS3_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 3 */
#define DMA_MISR_MIS4_Pos                   (4UL)
#define DMA_MISR_MIS4_Msk                   (0x1UL << DMA_MISR_MIS4_Pos)            /*!< 0x00000010 */
#define DMA_MISR_MIS4                       DMA_MISR_MIS4_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 4 */
#define DMA_MISR_MIS5_Pos                   (5UL)
#define DMA_MISR_MIS5_Msk                   (0x1UL << DMA_MISR_MIS5_Pos)            /*!< 0x00000020 */
#define DMA_MISR_MIS5                       DMA_MISR_MIS5_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 5 */
#define DMA_MISR_MIS6_Pos                   (6UL)
#define DMA_MISR_MIS6_Msk                   (0x1UL << DMA_MISR_MIS6_Pos)            /*!< 0x00000040 */
#define DMA_MISR_MIS6                       DMA_MISR_MIS6_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 6 */
#define DMA_MISR_MIS7_Pos                   (7UL)
#define DMA_MISR_MIS7_Msk                   (0x1UL << DMA_MISR_MIS7_Pos)            /*!< 0x00000080 */
#define DMA_MISR_MIS7                       DMA_MISR_MIS7_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 7 */

/*******************  Bit definition for DMA_SMISR register  ****************/
#define DMA_SMISR_MIS0_Pos                  (0UL)
#define DMA_SMISR_MIS0_Msk                  (0x1UL << DMA_SMISR_MIS0_Pos)           /*!< 0x00000001 */
#define DMA_SMISR_MIS0                      DMA_SMISR_MIS0_Msk                      /*!< Masked Interrupt State of Secure Channel 0 */
#define DMA_SMISR_MIS1_Pos                  (1UL)
#define DMA_SMISR_MIS1_Msk                  (0x1UL << DMA_SMISR_MIS1_Pos)           /*!< 0x00000002 */
#define DMA_SMISR_MIS1                      DMA_SMISR_MIS1_Msk                      /*!< Masked Interrupt State of Secure Channel 1 */
#define DMA_SMISR_MIS2_Pos                  (2UL)
#define DMA_SMISR_MIS2_Msk                  (0x1UL << DMA_SMISR_MIS2_Pos)           /*!< 0x00000004 */
#define DMA_SMISR_MIS2                      DMA_SMISR_MIS2_Msk                      /*!< Masked Interrupt State of Secure Channel 2 */
#define DMA_SMISR_MIS3_Pos                  (3UL)
#define DMA_SMISR_MIS3_Msk                  (0x1UL << DMA_SMISR_MIS3_Pos)           /*!< 0x00000008 */
#define DMA_SMISR_MIS3                      DMA_SMISR_MIS3_Msk                      /*!< Masked Interrupt State of Secure Channel 3 */
#define DMA_SMISR_MIS4_Pos                  (4UL)
#define DMA_SMISR_MIS4_Msk                  (0x1UL << DMA_SMISR_MIS4_Pos)           /*!< 0x00000010 */
#define DMA_SMISR_MIS4                      DMA_SMISR_MIS4_Msk                      /*!< Masked Interrupt State of Secure Channel 4 */
#define DMA_SMISR_MIS5_Pos                  (5UL)
#define DMA_SMISR_MIS5_Msk                  (0x1UL << DMA_SMISR_MIS5_Pos)           /*!< 0x00000020 */
#define DMA_SMISR_MIS5                      DMA_SMISR_MIS5_Msk                      /*!< Masked Interrupt State of Secure Channel 5 */
#define DMA_SMISR_MIS6_Pos                  (6UL)
#define DMA_SMISR_MIS6_Msk                  (0x1UL << DMA_SMISR_MIS6_Pos)           /*!< 0x00000040 */
#define DMA_SMISR_MIS6                      DMA_SMISR_MIS6_Msk                      /*!< Masked Interrupt State of Secure Channel 6 */
#define DMA_SMISR_MIS7_Pos                  (7UL)
#define DMA_SMISR_MIS7_Msk                  (0x1UL << DMA_SMISR_MIS7_Pos)           /*!< 0x00000080 */
#define DMA_SMISR_MIS7                      DMA_SMISR_MIS7_Msk                      /*!< Masked Interrupt State of Secure Channel 7 */

/*******************  Bit definition for DMA_CLBAR register  ****************/
#define DMA_CLBAR_LBA_Pos                   (16UL)
#define DMA_CLBAR_LBA_Msk                   (0xFFFFUL << DMA_CLBAR_LBA_Pos)         /*!< 0xFFFF0000 */
#define DMA_CLBAR_LBA                       DMA_CLBAR_LBA_Msk                       /*!< Linked-list Base Address of DMA channel x */

/*******************  Bit definition for DMA_CFCR register  *******************/
#define DMA_CFCR_TCF_Pos                    (8UL)
#define DMA_CFCR_TCF_Msk                    (0x1UL << DMA_CFCR_TCF_Pos)             /*!< 0x00000100 */
#define DMA_CFCR_TCF                        DMA_CFCR_TCF_Msk                        /*!< Transfer complete flag clear */
#define DMA_CFCR_HTF_Pos                    (9UL)
#define DMA_CFCR_HTF_Msk                    (0x1UL << DMA_CFCR_HTF_Pos)             /*!< 0x00000200 */
#define DMA_CFCR_HTF                        DMA_CFCR_HTF_Msk                        /*!< Half transfer complete flag clear */
#define DMA_CFCR_DTEF_Pos                   (10UL)
#define DMA_CFCR_DTEF_Msk                   (0x1UL << DMA_CFCR_DTEF_Pos)            /*!< 0x00000400 */
#define DMA_CFCR_DTEF                       DMA_CFCR_DTEF_Msk                       /*!< Data transfer error flag clear */
#define DMA_CFCR_ULEF_Pos                   (11UL)
#define DMA_CFCR_ULEF_Msk                   (0x1UL << DMA_CFCR_ULEF_Pos)            /*!< 0x00000800 */
#define DMA_CFCR_ULEF                       DMA_CFCR_ULEF_Msk                       /*!< Update linked-list item error flag clear */
#define DMA_CFCR_USEF_Pos                   (12UL)
#define DMA_CFCR_USEF_Msk                   (0x1UL << DMA_CFCR_USEF_Pos)            /*!< 0x00001000 */
#define DMA_CFCR_USEF                       DMA_CFCR_USEF_Msk                       /*!< User setting error flag clear */
#define DMA_CFCR_SUSPF_Pos                  (13UL)
#define DMA_CFCR_SUSPF_Msk                  (0x1UL << DMA_CFCR_SUSPF_Pos)           /*!< 0x00002000 */
#define DMA_CFCR_SUSPF                      DMA_CFCR_SUSPF_Msk                      /*!< Completed suspension flag clear */
#define DMA_CFCR_TOF_Pos                    (14UL)
#define DMA_CFCR_TOF_Msk                    (0x1UL << DMA_CFCR_TOF_Pos)             /*!< 0x00004000 */
#define DMA_CFCR_TOF                        DMA_CFCR_TOF_Msk                        /*!< Trigger overrun flag clear */

/*******************  Bit definition for DMA_CSR register  *******************/
#define DMA_CSR_IDLEF_Pos                   (0UL)
#define DMA_CSR_IDLEF_Msk                   (0x1UL << DMA_CSR_IDLEF_Pos)            /*!< 0x00000001 */
#define DMA_CSR_IDLEF                       DMA_CSR_IDLEF_Msk                       /*!< Idle flag */
#define DMA_CSR_TCF_Pos                     (8UL)
#define DMA_CSR_TCF_Msk                     (0x1UL << DMA_CSR_TCF_Pos)              /*!< 0x00000100 */
#define DMA_CSR_TCF                         DMA_CSR_TCF_Msk                         /*!< Transfer complete flag */
#define DMA_CSR_HTF_Pos                     (9UL)
#define DMA_CSR_HTF_Msk                     (0x1UL << DMA_CSR_HTF_Pos)              /*!< 0x00000200 */
#define DMA_CSR_HTF                         DMA_CSR_HTF_Msk                         /*!< Half transfer complete flag */
#define DMA_CSR_DTEF_Pos                    (10UL)
#define DMA_CSR_DTEF_Msk                    (0x1UL << DMA_CSR_DTEF_Pos)             /*!< 0x00000400 */
#define DMA_CSR_DTEF                        DMA_CSR_DTEF_Msk                        /*!< Data transfer error flag */
#define DMA_CSR_ULEF_Pos                    (11UL)
#define DMA_CSR_ULEF_Msk                    (0x1UL << DMA_CSR_ULEF_Pos)             /*!< 0x00000800 */
#define DMA_CSR_ULEF                        DMA_CSR_ULEF_Msk                        /*!< Update linked-list item error flag */
#define DMA_CSR_USEF_Pos                    (12UL)
#define DMA_CSR_USEF_Msk                    (0x1UL << DMA_CSR_USEF_Pos)             /*!< 0x00001000 */
#define DMA_CSR_USEF                        DMA_CSR_USEF_Msk                        /*!< User setting error flag */
#define DMA_CSR_SUSPF_Pos                   (13UL)
#define DMA_CSR_SUSPF_Msk                   (0x1UL << DMA_CSR_SUSPF_Pos)            /*!< 0x00002000 */
#define DMA_CSR_SUSPF                       DMA_CSR_SUSPF_Msk                       /*!< User setting error flag */
#define DMA_CSR_TOF_Pos                     (14UL)
#define DMA_CSR_TOF_Msk                     (0x1UL << DMA_CSR_TOF_Pos)              /*!< 0x00004000 */
#define DMA_CSR_TOF                         DMA_CSR_TOF_Msk                         /*!< Trigger overrun event flag */
#define DMA_CSR_FIFOL_Pos                   (16UL)
#define DMA_CSR_FIFOL_Msk                   (0xFFUL << DMA_CSR_FIFOL_Pos)           /*!< 0x00FF0000 */
#define DMA_CSR_FIFOL                       DMA_CSR_FIFOL_Msk                       /*!< Monitored FIFO level in bytes */

/*******************  Bit definition for DMA_CCR register  ********************/
#define DMA_CCR_EN_Pos                      (0UL)
#define DMA_CCR_EN_Msk                      (0x1UL << DMA_CCR_EN_Pos)               /*!< 0x00000001 */
#define DMA_CCR_EN                          DMA_CCR_EN_Msk                          /*!< Channel enable */
#define DMA_CCR_RESET_Pos                   (1UL)
#define DMA_CCR_RESET_Msk                   (0x1UL << DMA_CCR_RESET_Pos)            /*!< 0x00000002 */
#define DMA_CCR_RESET                       DMA_CCR_RESET_Msk                       /*!< Channel reset */
#define DMA_CCR_SUSP_Pos                    (2UL)
#define DMA_CCR_SUSP_Msk                    (0x1UL << DMA_CCR_SUSP_Pos)             /*!< 0x00000004 */
#define DMA_CCR_SUSP                        DMA_CCR_SUSP_Msk                        /*!< Channel suspend */
#define DMA_CCR_TCIE_Pos                    (8UL)
#define DMA_CCR_TCIE_Msk                    (0x1UL << DMA_CCR_TCIE_Pos)             /*!< 0x00000100 */
#define DMA_CCR_TCIE                        DMA_CCR_TCIE_Msk                        /*!< Transfer complete interrupt enable */
#define DMA_CCR_HTIE_Pos                    (9UL)
#define DMA_CCR_HTIE_Msk                    (0x1UL << DMA_CCR_HTIE_Pos)             /*!< 0x00000200 */
#define DMA_CCR_HTIE                        DMA_CCR_HTIE_Msk                        /*!< Half transfer complete interrupt enable */
#define DMA_CCR_DTEIE_Pos                   (10UL)
#define DMA_CCR_DTEIE_Msk                   (0x1UL << DMA_CCR_DTEIE_Pos)            /*!< 0x00000400 */
#define DMA_CCR_DTEIE                       DMA_CCR_DTEIE_Msk                       /*!< Data transfer error interrupt enable */
#define DMA_CCR_ULEIE_Pos                   (11UL)
#define DMA_CCR_ULEIE_Msk                   (0x1UL << DMA_CCR_ULEIE_Pos)            /*!< 0x00000800 */
#define DMA_CCR_ULEIE                       DMA_CCR_ULEIE_Msk                       /*!< Update linked-list item error interrupt enable */
#define DMA_CCR_USEIE_Pos                   (12UL)
#define DMA_CCR_USEIE_Msk                   (0x1UL << DMA_CCR_USEIE_Pos)            /*!< 0x00001000 */
#define DMA_CCR_USEIE                       DMA_CCR_USEIE_Msk                       /*!< User setting error interrupt enable */
#define DMA_CCR_SUSPIE_Pos                  (13UL)
#define DMA_CCR_SUSPIE_Msk                  (0x1UL << DMA_CCR_SUSPIE_Pos)           /*!< 0x00002000 */
#define DMA_CCR_SUSPIE                      DMA_CCR_SUSPIE_Msk                      /*!< Completed suspension interrupt enable */
#define DMA_CCR_TOIE_Pos                    (14UL)
#define DMA_CCR_TOIE_Msk                    (0x1UL << DMA_CCR_TOIE_Pos)             /*!< 0x00004000 */
#define DMA_CCR_TOIE                        DMA_CCR_TOIE_Msk                        /*!< Trigger overrun interrupt enable */
#define DMA_CCR_LSM_Pos                     (16UL)
#define DMA_CCR_LSM_Msk                     (0x1UL << DMA_CCR_LSM_Pos)              /*!< 0x00010000 */
#define DMA_CCR_LSM                         DMA_CCR_LSM_Msk                         /*!< Link step mode */
#define DMA_CCR_LAP_Pos                     (17UL)
#define DMA_CCR_LAP_Msk                     (0x1UL << DMA_CCR_LAP_Pos)              /*!< 0x00020000 */
#define DMA_CCR_LAP                         DMA_CCR_LAP_Msk                         /*!< Linked-list allocated port */
#define DMA_CCR_PRIO_Pos                    (22UL)
#define DMA_CCR_PRIO_Msk                    (0x3UL << DMA_CCR_PRIO_Pos)             /*!< 0x00C00000 */
#define DMA_CCR_PRIO                        DMA_CCR_PRIO_Msk                        /*!< Priority level */
#define DMA_CCR_PRIO_0                      (0x1UL << DMA_CCR_PRIO_Pos)             /*!< 0x00400000 */
#define DMA_CCR_PRIO_1                      (0x2UL << DMA_CCR_PRIO_Pos)             /*!< 0x00800000 */

/*******************  Bit definition for DMA_CTR1 register  *******************/
#define DMA_CTR1_SDW_LOG2_Pos               (0UL)
#define DMA_CTR1_SDW_LOG2_Msk               (0x3UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< 0x00000003 */
#define DMA_CTR1_SDW_LOG2                   DMA_CTR1_SDW_LOG2_Msk                   /*!< Binary logarithm of the source data width of a burst */
#define DMA_CTR1_SDW_LOG2_0                 (0x1UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_SDW_LOG2_1                 (0x2UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_SINC_Pos                   (3UL)
#define DMA_CTR1_SINC_Msk                   (0x1UL << DMA_CTR1_SINC_Pos)            /*!< 0x00000008 */
#define DMA_CTR1_SINC                       DMA_CTR1_SINC_Msk                       /*!< Source incrementing burst */
#define DMA_CTR1_SBL_1_Pos                  (4UL)
#define DMA_CTR1_SBL_1_Msk                  (0x3FUL << DMA_CTR1_SBL_1_Pos)          /*!< 0x000003F0 */
#define DMA_CTR1_SBL_1                      DMA_CTR1_SBL_1_Msk                      /*!< Source burst length minus 1 */
#define DMA_CTR1_PAM_Pos                    (11UL)
#define DMA_CTR1_PAM_Msk                    (0x3UL << DMA_CTR1_PAM_Pos)             /*!< 0x0001800 */
#define DMA_CTR1_PAM                        DMA_CTR1_PAM_Msk                        /*!< Padding / alignment mode */
#define DMA_CTR1_PAM_0                      (0x1UL << DMA_CTR1_PAM_Pos)             /*!< Bit 0 */
#define DMA_CTR1_PAM_1                      (0x2UL << DMA_CTR1_PAM_Pos)             /*!< Bit 1 */
#define DMA_CTR1_SBX_Pos                    (13UL)
#define DMA_CTR1_SBX_Msk                    (0x1UL << DMA_CTR1_SBX_Pos)             /*!< 0x00002000 */
#define DMA_CTR1_SBX                        DMA_CTR1_SBX_Msk                        /*!< Source byte exchange within the unaligned half-word of each source word */
#define DMA_CTR1_SAP_Pos                    (14UL)
#define DMA_CTR1_SAP_Msk                    (0x1UL << DMA_CTR1_SAP_Pos)             /*!< 0x00004000 */
#define DMA_CTR1_SAP                        DMA_CTR1_SAP_Msk                        /*!< Source allocated port */
#define DMA_CTR1_SSEC_Pos                   (15UL)
#define DMA_CTR1_SSEC_Msk                   (0x1UL << DMA_CTR1_SSEC_Pos)            /*!< 0x00008000 */
#define DMA_CTR1_SSEC                       DMA_CTR1_SSEC_Msk                       /*!< Security attribute of the DMA transfer from the source */
#define DMA_CTR1_DDW_LOG2_Pos               (16UL)
#define DMA_CTR1_DDW_LOG2_Msk               (0x3UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< 0x00030000 */
#define DMA_CTR1_DDW_LOG2                   DMA_CTR1_DDW_LOG2_Msk                   /*!< Binary logarithm of the destination data width of a burst */
#define DMA_CTR1_DDW_LOG2_0                 (0x1UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_DDW_LOG2_1                 (0x2UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_DINC_Pos                   (19UL)
#define DMA_CTR1_DINC_Msk                   (0x1UL << DMA_CTR1_DINC_Pos)            /*!< 0x00080000 */
#define DMA_CTR1_DINC                       DMA_CTR1_DINC_Msk                       /*!< Destination incrementing burst */
#define DMA_CTR1_DBL_1_Pos                  (20UL)
#define DMA_CTR1_DBL_1_Msk                  (0x3FUL << DMA_CTR1_DBL_1_Pos)          /*!< 0x03F00000 */
#define DMA_CTR1_DBL_1                      DMA_CTR1_DBL_1_Msk                      /*!< Destination burst length minus 1 */
#define DMA_CTR1_DBX_Pos                    (26UL)
#define DMA_CTR1_DBX_Msk                    (0x1UL << DMA_CTR1_DBX_Pos)             /*!< 0x04000000 */
#define DMA_CTR1_DBX                        DMA_CTR1_DBX_Msk                        /*!< Destination byte exchange */
#define DMA_CTR1_DHX_Pos                    (27UL)
#define DMA_CTR1_DHX_Msk                    (0x1UL << DMA_CTR1_DHX_Pos)             /*!< 0x08000000 */
#define DMA_CTR1_DHX                        DMA_CTR1_DHX_Msk                        /*!< Destination half-word exchange */
#define DMA_CTR1_DAP_Pos                    (30UL)
#define DMA_CTR1_DAP_Msk                    (0x1UL << DMA_CTR1_DAP_Pos)             /*!< 0x40000000 */
#define DMA_CTR1_DAP                        DMA_CTR1_DAP_Msk                        /*!< Destination allocated port */
#define DMA_CTR1_DSEC_Pos                   (31UL)
#define DMA_CTR1_DSEC_Msk                   (0x1UL << DMA_CTR1_DSEC_Pos)            /*!< 0x80000000 */
#define DMA_CTR1_DSEC                       DMA_CTR1_DSEC_Msk                       /*!< Security attribute of the DMA transfer from the destination */

/******************  Bit definition for DMA_CTR2 register  *******************/
#define DMA_CTR2_REQSEL_Pos                 (0UL)
#define DMA_CTR2_REQSEL_Msk                 (0x7FUL << DMA_CTR2_REQSEL_Pos)         /*!< 0x0000007F */
#define DMA_CTR2_REQSEL                     DMA_CTR2_REQSEL_Msk                     /*!< DMA hardware request selection */
#define DMA_CTR2_SWREQ_Pos                  (9UL)
#define DMA_CTR2_SWREQ_Msk                  (0x1UL << DMA_CTR2_SWREQ_Pos)           /*!< 0x00000100 */
#define DMA_CTR2_SWREQ                      DMA_CTR2_SWREQ_Msk                      /*!< Software request */
#define DMA_CTR2_DREQ_Pos                   (10UL)
#define DMA_CTR2_DREQ_Msk                   (0x1UL << DMA_CTR2_DREQ_Pos)            /*!< 0x00000100 */
#define DMA_CTR2_DREQ                       DMA_CTR2_DREQ_Msk                       /*!< Destination hardware request */
#define DMA_CTR2_BREQ_Pos                   (11UL)
#define DMA_CTR2_BREQ_Msk                   (0x1UL << DMA_CTR2_BREQ_Pos)            /*!< 0x00000200 */
#define DMA_CTR2_BREQ                       DMA_CTR2_BREQ_Msk                       /*!< Block hardware request */
#define DMA_CTR2_TRIGM_Pos                  (14UL)
#define DMA_CTR2_TRIGM_Msk                  (0x3UL << DMA_CTR2_TRIGM_Pos)           /*!< 0x0000C000 */
#define DMA_CTR2_TRIGM                      DMA_CTR2_TRIGM_Msk                      /*!< Trigger mode */
#define DMA_CTR2_TRIGM_0                    (0x1UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 0 */
#define DMA_CTR2_TRIGM_1                    (0x2UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 1 */
#define DMA_CTR2_TRIGSEL_Pos                (16UL)
#define DMA_CTR2_TRIGSEL_Msk                (0x1FUL << DMA_CTR2_TRIGSEL_Pos)        /*!< 0x001F0000 */
#define DMA_CTR2_TRIGSEL                    DMA_CTR2_TRIGSEL_Msk                    /*!< Trigger event input selection */
#define DMA_CTR2_TRIGPOL_Pos                (24UL)
#define DMA_CTR2_TRIGPOL_Msk                (0x3UL << DMA_CTR2_TRIGPOL_Pos)         /*!< 0x03000000 */
#define DMA_CTR2_TRIGPOL                    DMA_CTR2_TRIGPOL_Msk                    /*!< Trigger event polarity */
#define DMA_CTR2_TRIGPOL_0                  (0x1UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 0 */
#define DMA_CTR2_TRIGPOL_1                  (0x2UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 1 */
#define DMA_CTR2_TCEM_Pos                   (30UL)
#define DMA_CTR2_TCEM_Msk                   (0x3UL << DMA_CTR2_TCEM_Pos)            /*!< 0xC0000000 */
#define DMA_CTR2_TCEM                       DMA_CTR2_TCEM_Msk                       /*!< Transfer complete event mode */
#define DMA_CTR2_TCEM_0                     (0x1UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 0 */
#define DMA_CTR2_TCEM_1                     (0x2UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 1 */

/******************  Bit definition for DMA_CBR1 register  *******************/
#define DMA_CBR1_BNDT_Pos                   (0UL)
#define DMA_CBR1_BNDT_Msk                   (0xFFFFUL << DMA_CBR1_BNDT_Pos)         /*!< 0x0000FFFF */
#define DMA_CBR1_BNDT                       DMA_CBR1_BNDT_Msk                       /*!< Block number of data bytes to transfer from the source */

/******************  Bit definition for DMA_CSAR register  ********************/
#define DMA_CSAR_SA_Pos                     (0UL)
#define DMA_CSAR_SA_Msk                     (0xFFFFFFFFUL << DMA_CSAR_SA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CSAR_SA                         DMA_CSAR_SA_Msk                         /*!< Source Address */

/******************  Bit definition for DMA_CDAR register  *******************/
#define DMA_CDAR_DA_Pos                     (0UL)
#define DMA_CDAR_DA_Msk                     (0xFFFFFFFFUL << DMA_CDAR_DA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CDAR_DA                         DMA_CDAR_DA_Msk                         /*!< Destination address */

/******************  Bit definition for DMA_CLLR register  *******************/
#define DMA_CLLR_LA_Pos                     (2UL)
#define DMA_CLLR_LA_Msk                     (0x3FFFUL << DMA_CLLR_LA_Pos)           /*!< 0x0000FFFC */
#define DMA_CLLR_LA                         DMA_CLLR_LA_Msk                         /*!< Pointer to the next linked-list data structure */
#define DMA_CLLR_ULL_Pos                    (16UL)
#define DMA_CLLR_ULL_Msk                    (0x1UL << DMA_CLLR_ULL_Pos)             /*!< 0x00010000 */
#define DMA_CLLR_ULL                        DMA_CLLR_ULL_Msk                        /*!< Update link address register from memory */
#define DMA_CLLR_UDA_Pos                    (27UL)
#define DMA_CLLR_UDA_Msk                    (0x1UL << DMA_CLLR_UDA_Pos)             /*!< 0x08000000 */
#define DMA_CLLR_UDA                        DMA_CLLR_UDA_Msk                        /*!< Update destination address register from SRAM */
#define DMA_CLLR_USA_Pos                    (28UL)
#define DMA_CLLR_USA_Msk                    (0x1UL << DMA_CLLR_USA_Pos)             /*!< 0x10000000 */
#define DMA_CLLR_USA                        DMA_CLLR_USA_Msk                        /*!< Update source address register from SRAM */
#define DMA_CLLR_UB1_Pos                    (29UL)
#define DMA_CLLR_UB1_Msk                    (0x1UL << DMA_CLLR_UB1_Pos)             /*!< 0x20000000 */
#define DMA_CLLR_UB1                        DMA_CLLR_UB1_Msk                        /*!< Update block register 1 from SRAM */
#define DMA_CLLR_UT2_Pos                    (30UL)
#define DMA_CLLR_UT2_Msk                    (0x1UL << DMA_CLLR_UT2_Pos)             /*!< 0x40000000 */
#define DMA_CLLR_UT2                        DMA_CLLR_UT2_Msk                        /*!< Update transfer register 2 from SRAM */
#define DMA_CLLR_UT1_Pos                    (31UL)
#define DMA_CLLR_UT1_Msk                    (0x1UL << DMA_CLLR_UT1_Pos)             /*!< 0x80000000 */
#define DMA_CLLR_UT1                        DMA_CLLR_UT1_Msk                        /*!< Update transfer register 1 from SRAM */

/******************************************************************************/
/*                                                                            */
/*                    External Interrupt/Event Controller                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for EXTI_RTSR1 register  ******************/
#define EXTI_RTSR1_RT0_Pos                  (0UL)
#define EXTI_RTSR1_RT0_Msk                  (0x1UL << EXTI_RTSR1_RT0_Pos)           /*!< 0x00000001 */
#define EXTI_RTSR1_RT0                      EXTI_RTSR1_RT0_Msk                      /*!< Rising trigger configuration for input line 0 */
#define EXTI_RTSR1_RT1_Pos                  (1UL)
#define EXTI_RTSR1_RT1_Msk                  (0x1UL << EXTI_RTSR1_RT1_Pos)           /*!< 0x00000002 */
#define EXTI_RTSR1_RT1                      EXTI_RTSR1_RT1_Msk                      /*!< Rising trigger configuration for input line 1 */
#define EXTI_RTSR1_RT2_Pos                  (2UL)
#define EXTI_RTSR1_RT2_Msk                  (0x1UL << EXTI_RTSR1_RT2_Pos)           /*!< 0x00000004 */
#define EXTI_RTSR1_RT2                      EXTI_RTSR1_RT2_Msk                      /*!< Rising trigger configuration for input line 2 */
#define EXTI_RTSR1_RT3_Pos                  (3UL)
#define EXTI_RTSR1_RT3_Msk                  (0x1UL << EXTI_RTSR1_RT3_Pos)           /*!< 0x00000008 */
#define EXTI_RTSR1_RT3                      EXTI_RTSR1_RT3_Msk                      /*!< Rising trigger configuration for input line 3 */
#define EXTI_RTSR1_RT4_Pos                  (4UL)
#define EXTI_RTSR1_RT4_Msk                  (0x1UL << EXTI_RTSR1_RT4_Pos)           /*!< 0x00000010 */
#define EXTI_RTSR1_RT4                      EXTI_RTSR1_RT4_Msk                      /*!< Rising trigger configuration for input line 4 */
#define EXTI_RTSR1_RT5_Pos                  (5UL)
#define EXTI_RTSR1_RT5_Msk                  (0x1UL << EXTI_RTSR1_RT5_Pos)           /*!< 0x00000020 */
#define EXTI_RTSR1_RT5                      EXTI_RTSR1_RT5_Msk                      /*!< Rising trigger configuration for input line 5 */
#define EXTI_RTSR1_RT6_Pos                  (6UL)
#define EXTI_RTSR1_RT6_Msk                  (0x1UL << EXTI_RTSR1_RT6_Pos)           /*!< 0x00000040 */
#define EXTI_RTSR1_RT6                      EXTI_RTSR1_RT6_Msk                      /*!< Rising trigger configuration for input line 6 */
#define EXTI_RTSR1_RT7_Pos                  (7UL)
#define EXTI_RTSR1_RT7_Msk                  (0x1UL << EXTI_RTSR1_RT7_Pos)           /*!< 0x00000080 */
#define EXTI_RTSR1_RT7                      EXTI_RTSR1_RT7_Msk                      /*!< Rising trigger configuration for input line 7 */
#define EXTI_RTSR1_RT8_Pos                  (8UL)
#define EXTI_RTSR1_RT8_Msk                  (0x1UL << EXTI_RTSR1_RT8_Pos)           /*!< 0x00000100 */
#define EXTI_RTSR1_RT8                      EXTI_RTSR1_RT8_Msk                      /*!< Rising trigger configuration for input line 8 */
#define EXTI_RTSR1_RT9_Pos                  (9UL)
#define EXTI_RTSR1_RT9_Msk                  (0x1UL << EXTI_RTSR1_RT9_Pos)           /*!< 0x00000200 */
#define EXTI_RTSR1_RT9                      EXTI_RTSR1_RT9_Msk                      /*!< Rising trigger configuration for input line 9 */
#define EXTI_RTSR1_RT10_Pos                 (10UL)
#define EXTI_RTSR1_RT10_Msk                 (0x1UL << EXTI_RTSR1_RT10_Pos)          /*!< 0x00000400 */
#define EXTI_RTSR1_RT10                     EXTI_RTSR1_RT10_Msk                     /*!< Rising trigger configuration for input line 10 */
#define EXTI_RTSR1_RT11_Pos                 (11UL)
#define EXTI_RTSR1_RT11_Msk                 (0x1UL << EXTI_RTSR1_RT11_Pos)          /*!< 0x00000800 */
#define EXTI_RTSR1_RT11                     EXTI_RTSR1_RT11_Msk                     /*!< Rising trigger configuration for input line 11 */
#define EXTI_RTSR1_RT12_Pos                 (12UL)
#define EXTI_RTSR1_RT12_Msk                 (0x1UL << EXTI_RTSR1_RT12_Pos)          /*!< 0x00001000 */
#define EXTI_RTSR1_RT12                     EXTI_RTSR1_RT12_Msk                     /*!< Rising trigger configuration for input line 12 */
#define EXTI_RTSR1_RT13_Pos                 (13UL)
#define EXTI_RTSR1_RT13_Msk                 (0x1UL << EXTI_RTSR1_RT13_Pos)          /*!< 0x00002000 */
#define EXTI_RTSR1_RT13                     EXTI_RTSR1_RT13_Msk                     /*!< Rising trigger configuration for input line 13 */
#define EXTI_RTSR1_RT14_Pos                 (14UL)
#define EXTI_RTSR1_RT14_Msk                 (0x1UL << EXTI_RTSR1_RT14_Pos)          /*!< 0x00004000 */
#define EXTI_RTSR1_RT14                     EXTI_RTSR1_RT14_Msk                     /*!< Rising trigger configuration for input line 14 */
#define EXTI_RTSR1_RT15_Pos                 (15UL)
#define EXTI_RTSR1_RT15_Msk                 (0x1UL << EXTI_RTSR1_RT15_Pos)          /*!< 0x00008000 */
#define EXTI_RTSR1_RT15                     EXTI_RTSR1_RT15_Msk                     /*!< Rising trigger configuration for input line 15 */
#define EXTI_RTSR1_RT16_Pos                 (16UL)
#define EXTI_RTSR1_RT16_Msk                 (0x1UL << EXTI_RTSR1_RT16_Pos)          /*!< 0x00010000 */
#define EXTI_RTSR1_RT16                     EXTI_RTSR1_RT16_Msk                     /*!< Rising trigger configuration for input line 16 */
#define EXTI_RTSR1_RT17_Pos                 (17UL)
#define EXTI_RTSR1_RT17_Msk                 (0x1UL << EXTI_RTSR1_RT17_Pos)          /*!< 0x00020000 */
#define EXTI_RTSR1_RT17                     EXTI_RTSR1_RT17_Msk                     /*!< Rising trigger configuration for input line 17 */
#define EXTI_RTSR1_RT18_Pos                 (18UL)
#define EXTI_RTSR1_RT18_Msk                 (0x1UL << EXTI_RTSR1_RT18_Pos)          /*!< 0x00040000 */
#define EXTI_RTSR1_RT18                     EXTI_RTSR1_RT18_Msk                     /*!< Rising trigger configuration for input line 18 */

/******************  Bit definition for EXTI_FTSR1 register  ******************/
#define EXTI_FTSR1_FT0_Pos                  (0UL)
#define EXTI_FTSR1_FT0_Msk                  (0x1UL << EXTI_FTSR1_FT0_Pos)           /*!< 0x00000001 */
#define EXTI_FTSR1_FT0                      EXTI_FTSR1_FT0_Msk                      /*!< Falling trigger configuration for input line 0 */
#define EXTI_FTSR1_FT1_Pos                  (1UL)
#define EXTI_FTSR1_FT1_Msk                  (0x1UL << EXTI_FTSR1_FT1_Pos)           /*!< 0x00000002 */
#define EXTI_FTSR1_FT1                      EXTI_FTSR1_FT1_Msk                      /*!< Falling trigger configuration for input line 1 */
#define EXTI_FTSR1_FT2_Pos                  (2UL)
#define EXTI_FTSR1_FT2_Msk                  (0x1UL << EXTI_FTSR1_FT2_Pos)           /*!< 0x00000004 */
#define EXTI_FTSR1_FT2                      EXTI_FTSR1_FT2_Msk                      /*!< Falling trigger configuration for input line 2 */
#define EXTI_FTSR1_FT3_Pos                  (3UL)
#define EXTI_FTSR1_FT3_Msk                  (0x1UL << EXTI_FTSR1_FT3_Pos)           /*!< 0x00000008 */
#define EXTI_FTSR1_FT3                      EXTI_FTSR1_FT3_Msk                      /*!< Falling trigger configuration for input line 3 */
#define EXTI_FTSR1_FT4_Pos                  (4UL)
#define EXTI_FTSR1_FT4_Msk                  (0x1UL << EXTI_FTSR1_FT4_Pos)           /*!< 0x00000010 */
#define EXTI_FTSR1_FT4                      EXTI_FTSR1_FT4_Msk                      /*!< Falling trigger configuration for input line 4 */
#define EXTI_FTSR1_FT5_Pos                  (5UL)
#define EXTI_FTSR1_FT5_Msk                  (0x1UL << EXTI_FTSR1_FT5_Pos)           /*!< 0x00000020 */
#define EXTI_FTSR1_FT5                      EXTI_FTSR1_FT5_Msk                      /*!< Falling trigger configuration for input line 5 */
#define EXTI_FTSR1_FT6_Pos                  (6UL)
#define EXTI_FTSR1_FT6_Msk                  (0x1UL << EXTI_FTSR1_FT6_Pos)           /*!< 0x00000040 */
#define EXTI_FTSR1_FT6                      EXTI_FTSR1_FT6_Msk                      /*!< Falling trigger configuration for input line 6 */
#define EXTI_FTSR1_FT7_Pos                  (7UL)
#define EXTI_FTSR1_FT7_Msk                  (0x1UL << EXTI_FTSR1_FT7_Pos)           /*!< 0x00000080 */
#define EXTI_FTSR1_FT7                      EXTI_FTSR1_FT7_Msk                      /*!< Falling trigger configuration for input line 7 */
#define EXTI_FTSR1_FT8_Pos                  (8UL)
#define EXTI_FTSR1_FT8_Msk                  (0x1UL << EXTI_FTSR1_FT8_Pos)           /*!< 0x00000100 */
#define EXTI_FTSR1_FT8                      EXTI_FTSR1_FT8_Msk                      /*!< Falling trigger configuration for input line 8 */
#define EXTI_FTSR1_FT9_Pos                  (9UL)
#define EXTI_FTSR1_FT9_Msk                  (0x1UL << EXTI_FTSR1_FT9_Pos)           /*!< 0x00000200 */
#define EXTI_FTSR1_FT9                      EXTI_FTSR1_FT9_Msk                      /*!< Falling trigger configuration for input line 9 */
#define EXTI_FTSR1_FT10_Pos                 (10UL)
#define EXTI_FTSR1_FT10_Msk                 (0x1UL << EXTI_FTSR1_FT10_Pos)          /*!< 0x00000400 */
#define EXTI_FTSR1_FT10                     EXTI_FTSR1_FT10_Msk                     /*!< Falling trigger configuration for input line 10 */
#define EXTI_FTSR1_FT11_Pos                 (11UL)
#define EXTI_FTSR1_FT11_Msk                 (0x1UL << EXTI_FTSR1_FT11_Pos)          /*!< 0x00000800 */
#define EXTI_FTSR1_FT11                     EXTI_FTSR1_FT11_Msk                     /*!< Falling trigger configuration for input line 11 */
#define EXTI_FTSR1_FT12_Pos                 (12UL)
#define EXTI_FTSR1_FT12_Msk                 (0x1UL << EXTI_FTSR1_FT12_Pos)          /*!< 0x00001000 */
#define EXTI_FTSR1_FT12                     EXTI_FTSR1_FT12_Msk                     /*!< Falling trigger configuration for input line 12 */
#define EXTI_FTSR1_FT13_Pos                 (13UL)
#define EXTI_FTSR1_FT13_Msk                 (0x1UL << EXTI_FTSR1_FT13_Pos)          /*!< 0x00002000 */
#define EXTI_FTSR1_FT13                     EXTI_FTSR1_FT13_Msk                     /*!< Falling trigger configuration for input line 13 */
#define EXTI_FTSR1_FT14_Pos                 (14UL)
#define EXTI_FTSR1_FT14_Msk                 (0x1UL << EXTI_FTSR1_FT14_Pos)          /*!< 0x00004000 */
#define EXTI_FTSR1_FT14                     EXTI_FTSR1_FT14_Msk                     /*!< Falling trigger configuration for input line 14 */
#define EXTI_FTSR1_FT15_Pos                 (15UL)
#define EXTI_FTSR1_FT15_Msk                 (0x1UL << EXTI_FTSR1_FT15_Pos)          /*!< 0x00008000 */
#define EXTI_FTSR1_FT15                     EXTI_FTSR1_FT15_Msk                     /*!< Falling trigger configuration for input line 15 */
#define EXTI_FTSR1_FT16_Pos                 (16UL)
#define EXTI_FTSR1_FT16_Msk                 (0x1UL << EXTI_FTSR1_FT16_Pos)          /*!< 0x00010000 */
#define EXTI_FTSR1_FT16                     EXTI_FTSR1_FT16_Msk                     /*!< Falling trigger configuration for input line 16 */
#define EXTI_FTSR1_FT17_Pos                 (17UL)
#define EXTI_FTSR1_FT17_Msk                 (0x1UL << EXTI_FTSR1_FT17_Pos)          /*!< 0x00020000 */
#define EXTI_FTSR1_FT17                     EXTI_FTSR1_FT17_Msk                     /*!< Falling trigger configuration for input line 17 */
#define EXTI_FTSR1_FT18_Pos                 (18UL)
#define EXTI_FTSR1_FT18_Msk                 (0x1UL << EXTI_FTSR1_FT18_Pos)          /*!< 0x00040000 */
#define EXTI_FTSR1_FT18                     EXTI_FTSR1_FT18_Msk                     /*!< Falling trigger configuration for input line 18 */

/******************  Bit definition for EXTI_SWIER1 register  *****************/
#define EXTI_SWIER1_SWI0_Pos                (0UL)
#define EXTI_SWIER1_SWI0_Msk                (0x1UL << EXTI_SWIER1_SWI0_Pos)         /*!< 0x00000001 */
#define EXTI_SWIER1_SWI0                    EXTI_SWIER1_SWI0_Msk                    /*!< Software Interrupt on line 0 */
#define EXTI_SWIER1_SWI1_Pos                (1UL)
#define EXTI_SWIER1_SWI1_Msk                (0x1UL << EXTI_SWIER1_SWI1_Pos)         /*!< 0x00000002 */
#define EXTI_SWIER1_SWI1                    EXTI_SWIER1_SWI1_Msk                    /*!< Software Interrupt on line 1 */
#define EXTI_SWIER1_SWI2_Pos                (2UL)
#define EXTI_SWIER1_SWI2_Msk                (0x1UL << EXTI_SWIER1_SWI2_Pos)         /*!< 0x00000004 */
#define EXTI_SWIER1_SWI2                    EXTI_SWIER1_SWI2_Msk                    /*!< Software Interrupt on line 2 */
#define EXTI_SWIER1_SWI3_Pos                (3UL)
#define EXTI_SWIER1_SWI3_Msk                (0x1UL << EXTI_SWIER1_SWI3_Pos)         /*!< 0x00000008 */
#define EXTI_SWIER1_SWI3                    EXTI_SWIER1_SWI3_Msk                    /*!< Software Interrupt on line 3 */
#define EXTI_SWIER1_SWI4_Pos                (4UL)
#define EXTI_SWIER1_SWI4_Msk                (0x1UL << EXTI_SWIER1_SWI4_Pos)         /*!< 0x00000010 */
#define EXTI_SWIER1_SWI4                    EXTI_SWIER1_SWI4_Msk                    /*!< Software Interrupt on line 4 */
#define EXTI_SWIER1_SWI5_Pos                (5UL)
#define EXTI_SWIER1_SWI5_Msk                (0x1UL << EXTI_SWIER1_SWI5_Pos)         /*!< 0x00000020 */
#define EXTI_SWIER1_SWI5                    EXTI_SWIER1_SWI5_Msk                    /*!< Software Interrupt on line 5 */
#define EXTI_SWIER1_SWI6_Pos                (6UL)
#define EXTI_SWIER1_SWI6_Msk                (0x1UL << EXTI_SWIER1_SWI6_Pos)         /*!< 0x00000040 */
#define EXTI_SWIER1_SWI6                    EXTI_SWIER1_SWI6_Msk                    /*!< Software Interrupt on line 6 */
#define EXTI_SWIER1_SWI7_Pos                (7UL)
#define EXTI_SWIER1_SWI7_Msk                (0x1UL << EXTI_SWIER1_SWI7_Pos)         /*!< 0x00000080 */
#define EXTI_SWIER1_SWI7                    EXTI_SWIER1_SWI7_Msk                    /*!< Software Interrupt on line 7 */
#define EXTI_SWIER1_SWI8_Pos                (8UL)
#define EXTI_SWIER1_SWI8_Msk                (0x1UL << EXTI_SWIER1_SWI8_Pos)         /*!< 0x00000100 */
#define EXTI_SWIER1_SWI8                    EXTI_SWIER1_SWI8_Msk                    /*!< Software Interrupt on line 8 */
#define EXTI_SWIER1_SWI9_Pos                (9UL)
#define EXTI_SWIER1_SWI9_Msk                (0x1UL << EXTI_SWIER1_SWI9_Pos)         /*!< 0x00000200 */
#define EXTI_SWIER1_SWI9                    EXTI_SWIER1_SWI9_Msk                    /*!< Software Interrupt on line 9 */
#define EXTI_SWIER1_SWI10_Pos               (10UL)
#define EXTI_SWIER1_SWI10_Msk               (0x1UL << EXTI_SWIER1_SWI10_Pos)        /*!< 0x00000400 */
#define EXTI_SWIER1_SWI10                   EXTI_SWIER1_SWI10_Msk                   /*!< Software Interrupt on line 10 */
#define EXTI_SWIER1_SWI11_Pos               (11UL)
#define EXTI_SWIER1_SWI11_Msk               (0x1UL << EXTI_SWIER1_SWI11_Pos)        /*!< 0x00000800 */
#define EXTI_SWIER1_SWI11                   EXTI_SWIER1_SWI11_Msk                   /*!< Software Interrupt on line 11 */
#define EXTI_SWIER1_SWI12_Pos               (12UL)
#define EXTI_SWIER1_SWI12_Msk               (0x1UL << EXTI_SWIER1_SWI12_Pos)        /*!< 0x00001000 */
#define EXTI_SWIER1_SWI12                   EXTI_SWIER1_SWI12_Msk                   /*!< Software Interrupt on line 12 */
#define EXTI_SWIER1_SWI13_Pos               (13UL)
#define EXTI_SWIER1_SWI13_Msk               (0x1UL << EXTI_SWIER1_SWI13_Pos)        /*!< 0x00002000 */
#define EXTI_SWIER1_SWI13                   EXTI_SWIER1_SWI13_Msk                   /*!< Software Interrupt on line 13 */
#define EXTI_SWIER1_SWI14_Pos               (14UL)
#define EXTI_SWIER1_SWI14_Msk               (0x1UL << EXTI_SWIER1_SWI14_Pos)        /*!< 0x00004000 */
#define EXTI_SWIER1_SWI14                   EXTI_SWIER1_SWI14_Msk                   /*!< Software Interrupt on line 14 */
#define EXTI_SWIER1_SWI15_Pos               (15UL)
#define EXTI_SWIER1_SWI15_Msk               (0x1UL << EXTI_SWIER1_SWI15_Pos)        /*!< 0x00008000 */
#define EXTI_SWIER1_SWI15                   EXTI_SWIER1_SWI15_Msk                   /*!< Software Interrupt on line 15 */
#define EXTI_SWIER1_SWI16_Pos               (16UL)
#define EXTI_SWIER1_SWI16_Msk               (0x1UL << EXTI_SWIER1_SWI16_Pos)        /*!< 0x00010000 */
#define EXTI_SWIER1_SWI16                   EXTI_SWIER1_SWI16_Msk                   /*!< Software Interrupt on line 16 */
#define EXTI_SWIER1_SWI17_Pos               (17UL)
#define EXTI_SWIER1_SWI17_Msk               (0x1UL << EXTI_SWIER1_SWI17_Pos)        /*!< 0x00020000 */
#define EXTI_SWIER1_SWI17                   EXTI_SWIER1_SWI17_Msk                   /*!< Software Interrupt on line 17 */
#define EXTI_SWIER1_SWI18_Pos               (18UL)
#define EXTI_SWIER1_SWI18_Msk               (0x1UL << EXTI_SWIER1_SWI18_Pos)        /*!< 0x00040000 */
#define EXTI_SWIER1_SWI18                   EXTI_SWIER1_SWI18_Msk                   /*!< Software Interrupt on line 18 */

/*******************  Bit definition for EXTI_RPR1 register  ******************/
#define EXTI_RPR1_RPIF0_Pos                 (0UL)
#define EXTI_RPR1_RPIF0_Msk                 (0x1UL << EXTI_RPR1_RPIF0_Pos)          /*!< 0x00000001 */
#define EXTI_RPR1_RPIF0                     EXTI_RPR1_RPIF0_Msk                     /*!< Rising Pending Interrupt Flag on line 0 */
#define EXTI_RPR1_RPIF1_Pos                 (1UL)
#define EXTI_RPR1_RPIF1_Msk                 (0x1UL << EXTI_RPR1_RPIF1_Pos)          /*!< 0x00000002 */
#define EXTI_RPR1_RPIF1                     EXTI_RPR1_RPIF1_Msk                     /*!< Rising Pending Interrupt Flag on line 1 */
#define EXTI_RPR1_RPIF2_Pos                 (2UL)
#define EXTI_RPR1_RPIF2_Msk                 (0x1UL << EXTI_RPR1_RPIF2_Pos)          /*!< 0x00000004 */
#define EXTI_RPR1_RPIF2                     EXTI_RPR1_RPIF2_Msk                     /*!< Rising Pending Interrupt Flag on line 2 */
#define EXTI_RPR1_RPIF3_Pos                 (3UL)
#define EXTI_RPR1_RPIF3_Msk                 (0x1UL << EXTI_RPR1_RPIF3_Pos)          /*!< 0x00000008 */
#define EXTI_RPR1_RPIF3                     EXTI_RPR1_RPIF3_Msk                     /*!< Rising Pending Interrupt Flag on line 3 */
#define EXTI_RPR1_RPIF4_Pos                 (4UL)
#define EXTI_RPR1_RPIF4_Msk                 (0x1UL << EXTI_RPR1_RPIF4_Pos)          /*!< 0x00000010 */
#define EXTI_RPR1_RPIF4                     EXTI_RPR1_RPIF4_Msk                     /*!< Rising Pending Interrupt Flag on line 4 */
#define EXTI_RPR1_RPIF5_Pos                 (5UL)
#define EXTI_RPR1_RPIF5_Msk                 (0x1UL << EXTI_RPR1_RPIF5_Pos)          /*!< 0x00000020 */
#define EXTI_RPR1_RPIF5                     EXTI_RPR1_RPIF5_Msk                     /*!< Rising Pending Interrupt Flag on line 5 */
#define EXTI_RPR1_RPIF6_Pos                 (6UL)
#define EXTI_RPR1_RPIF6_Msk                 (0x1UL << EXTI_RPR1_RPIF6_Pos)          /*!< 0x00000040 */
#define EXTI_RPR1_RPIF6                     EXTI_RPR1_RPIF6_Msk                     /*!< Rising Pending Interrupt Flag on line 6 */
#define EXTI_RPR1_RPIF7_Pos                 (7UL)
#define EXTI_RPR1_RPIF7_Msk                 (0x1UL << EXTI_RPR1_RPIF7_Pos)          /*!< 0x00000080 */
#define EXTI_RPR1_RPIF7                     EXTI_RPR1_RPIF7_Msk                     /*!< Rising Pending Interrupt Flag on line 7 */
#define EXTI_RPR1_RPIF8_Pos                 (8UL)
#define EXTI_RPR1_RPIF8_Msk                 (0x1UL << EXTI_RPR1_RPIF8_Pos)          /*!< 0x00000100 */
#define EXTI_RPR1_RPIF8                     EXTI_RPR1_RPIF8_Msk                     /*!< Rising Pending Interrupt Flag on line 8 */
#define EXTI_RPR1_RPIF9_Pos                 (9UL)
#define EXTI_RPR1_RPIF9_Msk                 (0x1UL << EXTI_RPR1_RPIF9_Pos)          /*!< 0x00000200 */
#define EXTI_RPR1_RPIF9                     EXTI_RPR1_RPIF9_Msk                     /*!< Rising Pending Interrupt Flag on line 9 */
#define EXTI_RPR1_RPIF10_Pos                (10UL)
#define EXTI_RPR1_RPIF10_Msk                (0x1UL << EXTI_RPR1_RPIF10_Pos)         /*!< 0x00000400 */
#define EXTI_RPR1_RPIF10                    EXTI_RPR1_RPIF10_Msk                    /*!< Rising Pending Interrupt Flag on line 10 */
#define EXTI_RPR1_RPIF11_Pos                (11UL)
#define EXTI_RPR1_RPIF11_Msk                (0x1UL << EXTI_RPR1_RPIF11_Pos)         /*!< 0x00000800 */
#define EXTI_RPR1_RPIF11                    EXTI_RPR1_RPIF11_Msk                    /*!< Rising Pending Interrupt Flag on line 11 */
#define EXTI_RPR1_RPIF12_Pos                (12UL)
#define EXTI_RPR1_RPIF12_Msk                (0x1UL << EXTI_RPR1_RPIF12_Pos)         /*!< 0x00001000 */
#define EXTI_RPR1_RPIF12                    EXTI_RPR1_RPIF12_Msk                    /*!< Rising Pending Interrupt Flag on line 12 */
#define EXTI_RPR1_RPIF13_Pos                (13UL)
#define EXTI_RPR1_RPIF13_Msk                (0x1UL << EXTI_RPR1_RPIF13_Pos)         /*!< 0x00002000 */
#define EXTI_RPR1_RPIF13                    EXTI_RPR1_RPIF13_Msk                    /*!< Rising Pending Interrupt Flag on line 13 */
#define EXTI_RPR1_RPIF14_Pos                (14UL)
#define EXTI_RPR1_RPIF14_Msk                (0x1UL << EXTI_RPR1_RPIF14_Pos)         /*!< 0x00004000 */
#define EXTI_RPR1_RPIF14                    EXTI_RPR1_RPIF14_Msk                    /*!< Rising Pending Interrupt Flag on line 14 */
#define EXTI_RPR1_RPIF15_Pos                (15UL)
#define EXTI_RPR1_RPIF15_Msk                (0x1UL << EXTI_RPR1_RPIF15_Pos)         /*!< 0x00008000 */
#define EXTI_RPR1_RPIF15                    EXTI_RPR1_RPIF15_Msk                    /*!< Rising Pending Interrupt Flag on line 15 */
#define EXTI_RPR1_RPIF16_Pos                (16UL)
#define EXTI_RPR1_RPIF16_Msk                (0x1UL << EXTI_RPR1_RPIF16_Pos)         /*!< 0x00010000 */
#define EXTI_RPR1_RPIF16                    EXTI_RPR1_RPIF16_Msk                    /*!< Rising Pending Interrupt Flag on line 16 */
#define EXTI_RPR1_RPIF17_Pos                (17UL)
#define EXTI_RPR1_RPIF17_Msk                (0x1UL << EXTI_RPR1_RPIF17_Pos)         /*!< 0x00020000 */
#define EXTI_RPR1_RPIF17                    EXTI_RPR1_RPIF17_Msk                    /*!< Rising Pending Interrupt Flag on line 17 */
#define EXTI_RPR1_RPIF18_Pos                (18UL)
#define EXTI_RPR1_RPIF18_Msk                (0x1UL << EXTI_RPR1_RPIF18_Pos)         /*!< 0x00040000 */
#define EXTI_RPR1_RPIF18                    EXTI_RPR1_RPIF18_Msk                    /*!< Rising Pending Interrupt Flag on line 18 */

/*******************  Bit definition for EXTI_FPR1 register  ******************/
#define EXTI_FPR1_FPIF0_Pos                 (0UL)
#define EXTI_FPR1_FPIF0_Msk                 (0x1UL << EXTI_FPR1_FPIF0_Pos)          /*!< 0x00000001 */
#define EXTI_FPR1_FPIF0                     EXTI_FPR1_FPIF0_Msk                     /*!< Falling Pending Interrupt Flag on line 0 */
#define EXTI_FPR1_FPIF1_Pos                 (1UL)
#define EXTI_FPR1_FPIF1_Msk                 (0x1UL << EXTI_FPR1_FPIF1_Pos)          /*!< 0x00000002 */
#define EXTI_FPR1_FPIF1                     EXTI_FPR1_FPIF1_Msk                     /*!< Falling Pending Interrupt Flag on line 1 */
#define EXTI_FPR1_FPIF2_Pos                 (2UL)
#define EXTI_FPR1_FPIF2_Msk                 (0x1UL << EXTI_FPR1_FPIF2_Pos)          /*!< 0x00000004 */
#define EXTI_FPR1_FPIF2                     EXTI_FPR1_FPIF2_Msk                     /*!< Falling Pending Interrupt Flag on line 2 */
#define EXTI_FPR1_FPIF3_Pos                 (3UL)
#define EXTI_FPR1_FPIF3_Msk                 (0x1UL << EXTI_FPR1_FPIF3_Pos)          /*!< 0x00000008 */
#define EXTI_FPR1_FPIF3                     EXTI_FPR1_FPIF3_Msk                     /*!< Falling Pending Interrupt Flag on line 3 */
#define EXTI_FPR1_FPIF4_Pos                 (4UL)
#define EXTI_FPR1_FPIF4_Msk                 (0x1UL << EXTI_FPR1_FPIF4_Pos)          /*!< 0x00000010 */
#define EXTI_FPR1_FPIF4                     EXTI_FPR1_FPIF4_Msk                     /*!< Falling Pending Interrupt Flag on line 4 */
#define EXTI_FPR1_FPIF5_Pos                 (5UL)
#define EXTI_FPR1_FPIF5_Msk                 (0x1UL << EXTI_FPR1_FPIF5_Pos)          /*!< 0x00000020 */
#define EXTI_FPR1_FPIF5                     EXTI_FPR1_FPIF5_Msk                     /*!< Falling Pending Interrupt Flag on line 5 */
#define EXTI_FPR1_FPIF6_Pos                 (6UL)
#define EXTI_FPR1_FPIF6_Msk                 (0x1UL << EXTI_FPR1_FPIF6_Pos)          /*!< 0x00000040 */
#define EXTI_FPR1_FPIF6                     EXTI_FPR1_FPIF6_Msk                     /*!< Falling Pending Interrupt Flag on line 6 */
#define EXTI_FPR1_FPIF7_Pos                 (7UL)
#define EXTI_FPR1_FPIF7_Msk                 (0x1UL << EXTI_FPR1_FPIF7_Pos)          /*!< 0x00000080 */
#define EXTI_FPR1_FPIF7                     EXTI_FPR1_FPIF7_Msk                     /*!< Falling Pending Interrupt Flag on line 7 */
#define EXTI_FPR1_FPIF8_Pos                 (8UL)
#define EXTI_FPR1_FPIF8_Msk                 (0x1UL << EXTI_FPR1_FPIF8_Pos)          /*!< 0x00000100 */
#define EXTI_FPR1_FPIF8                     EXTI_FPR1_FPIF8_Msk                     /*!< Falling Pending Interrupt Flag on line 8 */
#define EXTI_FPR1_FPIF9_Pos                 (9UL)
#define EXTI_FPR1_FPIF9_Msk                 (0x1UL << EXTI_FPR1_FPIF9_Pos)          /*!< 0x00000200 */
#define EXTI_FPR1_FPIF9                     EXTI_FPR1_FPIF9_Msk                     /*!< Falling Pending Interrupt Flag on line 9 */
#define EXTI_FPR1_FPIF10_Pos                (10UL)
#define EXTI_FPR1_FPIF10_Msk                (0x1UL << EXTI_FPR1_FPIF10_Pos)         /*!< 0x00000400 */
#define EXTI_FPR1_FPIF10                    EXTI_FPR1_FPIF10_Msk                    /*!< Falling Pending Interrupt Flag on line 10 */
#define EXTI_FPR1_FPIF11_Pos                (11UL)
#define EXTI_FPR1_FPIF11_Msk                (0x1UL << EXTI_FPR1_FPIF11_Pos)         /*!< 0x00000800 */
#define EXTI_FPR1_FPIF11                    EXTI_FPR1_FPIF11_Msk                    /*!< Falling Pending Interrupt Flag on line 11 */
#define EXTI_FPR1_FPIF12_Pos                (12UL)
#define EXTI_FPR1_FPIF12_Msk                (0x1UL << EXTI_FPR1_FPIF12_Pos)         /*!< 0x00001000 */
#define EXTI_FPR1_FPIF12                    EXTI_FPR1_FPIF12_Msk                    /*!< Falling Pending Interrupt Flag on line 12 */
#define EXTI_FPR1_FPIF13_Pos                (13UL)
#define EXTI_FPR1_FPIF13_Msk                (0x1UL << EXTI_FPR1_FPIF13_Pos)         /*!< 0x00002000 */
#define EXTI_FPR1_FPIF13                    EXTI_FPR1_FPIF13_Msk                    /*!< Falling Pending Interrupt Flag on line 13 */
#define EXTI_FPR1_FPIF14_Pos                (14UL)
#define EXTI_FPR1_FPIF14_Msk                (0x1UL << EXTI_FPR1_FPIF14_Pos)         /*!< 0x00004000 */
#define EXTI_FPR1_FPIF14                    EXTI_FPR1_FPIF14_Msk                    /*!< Falling Pending Interrupt Flag on line 14 */
#define EXTI_FPR1_FPIF15_Pos                (15UL)
#define EXTI_FPR1_FPIF15_Msk                (0x1UL << EXTI_FPR1_FPIF15_Pos)         /*!< 0x00008000 */
#define EXTI_FPR1_FPIF15                    EXTI_FPR1_FPIF15_Msk                    /*!< Falling Pending Interrupt Flag on line 15 */
#define EXTI_FPR1_FPIF16_Pos                (16UL)
#define EXTI_FPR1_FPIF16_Msk                (0x1UL << EXTI_FPR1_FPIF16_Pos)         /*!< 0x00010000 */
#define EXTI_FPR1_FPIF16                    EXTI_FPR1_FPIF16_Msk                    /*!< Falling Pending Interrupt Flag on line 16 */
#define EXTI_FPR1_FPIF17_Pos                (17UL)
#define EXTI_FPR1_FPIF17_Msk                (0x1UL << EXTI_FPR1_FPIF17_Pos)         /*!< 0x00020000 */
#define EXTI_FPR1_FPIF17                    EXTI_FPR1_FPIF17_Msk                    /*!< Falling Pending Interrupt Flag on line 17 */
#define EXTI_FPR1_FPIF18_Pos                (18UL)
#define EXTI_FPR1_FPIF18_Msk                (0x1UL << EXTI_FPR1_FPIF18_Pos)         /*!< 0x00040000 */
#define EXTI_FPR1_FPIF18                    EXTI_FPR1_FPIF18_Msk                    /*!< Falling Pending Interrupt Flag on line 18 */

/*******************  Bit definition for EXTI_SECCFGR1 register  ******************/
#define EXTI_SECCFGR1_SEC0_Pos              (0UL)
#define EXTI_SECCFGR1_SEC0_Msk              (0x1UL << EXTI_SECCFGR1_SEC0_Pos)       /*!< 0x00000001 */
#define EXTI_SECCFGR1_SEC0                  EXTI_SECCFGR1_SEC0_Msk                  /*!< Security enable on line 0 */
#define EXTI_SECCFGR1_SEC1_Pos              (1UL)
#define EXTI_SECCFGR1_SEC1_Msk              (0x1UL << EXTI_SECCFGR1_SEC1_Pos)       /*!< 0x00000002 */
#define EXTI_SECCFGR1_SEC1                  EXTI_SECCFGR1_SEC1_Msk                  /*!< Security enable on line 1 */
#define EXTI_SECCFGR1_SEC2_Pos              (2UL)
#define EXTI_SECCFGR1_SEC2_Msk              (0x1UL << EXTI_SECCFGR1_SEC2_Pos)       /*!< 0x00000004 */
#define EXTI_SECCFGR1_SEC2                  EXTI_SECCFGR1_SEC2_Msk                  /*!< Security enable on line 2 */
#define EXTI_SECCFGR1_SEC3_Pos              (3UL)
#define EXTI_SECCFGR1_SEC3_Msk              (0x1UL << EXTI_SECCFGR1_SEC3_Pos)       /*!< 0x00000008 */
#define EXTI_SECCFGR1_SEC3                  EXTI_SECCFGR1_SEC3_Msk                  /*!< Security enable on line 3 */
#define EXTI_SECCFGR1_SEC4_Pos              (4UL)
#define EXTI_SECCFGR1_SEC4_Msk              (0x1UL << EXTI_SECCFGR1_SEC4_Pos)       /*!< 0x00000010 */
#define EXTI_SECCFGR1_SEC4                  EXTI_SECCFGR1_SEC4_Msk                  /*!< Security enable on line 4 */
#define EXTI_SECCFGR1_SEC5_Pos              (5UL)
#define EXTI_SECCFGR1_SEC5_Msk              (0x1UL << EXTI_SECCFGR1_SEC5_Pos)       /*!< 0x00000020 */
#define EXTI_SECCFGR1_SEC5                  EXTI_SECCFGR1_SEC5_Msk                  /*!< Security enable on line 5 */
#define EXTI_SECCFGR1_SEC6_Pos              (6UL)
#define EXTI_SECCFGR1_SEC6_Msk              (0x1UL << EXTI_SECCFGR1_SEC6_Pos)       /*!< 0x00000040 */
#define EXTI_SECCFGR1_SEC6                  EXTI_SECCFGR1_SEC6_Msk                  /*!< Security enable on line 6 */
#define EXTI_SECCFGR1_SEC7_Pos              (7UL)
#define EXTI_SECCFGR1_SEC7_Msk              (0x1UL << EXTI_SECCFGR1_SEC7_Pos)       /*!< 0x00000080 */
#define EXTI_SECCFGR1_SEC7                  EXTI_SECCFGR1_SEC7_Msk                  /*!< Security enable on line 7 */
#define EXTI_SECCFGR1_SEC8_Pos              (8UL)
#define EXTI_SECCFGR1_SEC8_Msk              (0x1UL << EXTI_SECCFGR1_SEC8_Pos)       /*!< 0x00000100 */
#define EXTI_SECCFGR1_SEC8                  EXTI_SECCFGR1_SEC8_Msk                  /*!< Security enable on line 8 */
#define EXTI_SECCFGR1_SEC9_Pos              (9UL)
#define EXTI_SECCFGR1_SEC9_Msk              (0x1UL << EXTI_SECCFGR1_SEC9_Pos)       /*!< 0x00000200 */
#define EXTI_SECCFGR1_SEC9                  EXTI_SECCFGR1_SEC9_Msk                  /*!< Security enable on line 9 */
#define EXTI_SECCFGR1_SEC10_Pos             (10UL)
#define EXTI_SECCFGR1_SEC10_Msk             (0x1UL << EXTI_SECCFGR1_SEC10_Pos)      /*!< 0x00000400 */
#define EXTI_SECCFGR1_SEC10                 EXTI_SECCFGR1_SEC10_Msk                 /*!< Security enable on line 10 */
#define EXTI_SECCFGR1_SEC11_Pos             (11UL)
#define EXTI_SECCFGR1_SEC11_Msk             (0x1UL << EXTI_SECCFGR1_SEC11_Pos)      /*!< 0x00000800 */
#define EXTI_SECCFGR1_SEC11                 EXTI_SECCFGR1_SEC11_Msk                 /*!< Security enable on line 11 */
#define EXTI_SECCFGR1_SEC12_Pos             (12UL)
#define EXTI_SECCFGR1_SEC12_Msk             (0x1UL << EXTI_SECCFGR1_SEC12_Pos)      /*!< 0x00001000 */
#define EXTI_SECCFGR1_SEC12                 EXTI_SECCFGR1_SEC12_Msk                 /*!< Security enable on line 12 */
#define EXTI_SECCFGR1_SEC13_Pos             (13UL)
#define EXTI_SECCFGR1_SEC13_Msk             (0x1UL << EXTI_SECCFGR1_SEC13_Pos)      /*!< 0x00002000 */
#define EXTI_SECCFGR1_SEC13                 EXTI_SECCFGR1_SEC13_Msk                 /*!< Security enable on line 13 */
#define EXTI_SECCFGR1_SEC14_Pos             (14UL)
#define EXTI_SECCFGR1_SEC14_Msk             (0x1UL << EXTI_SECCFGR1_SEC14_Pos)      /*!< 0x00004000 */
#define EXTI_SECCFGR1_SEC14                 EXTI_SECCFGR1_SEC14_Msk                 /*!< Security enable on line 14 */
#define EXTI_SECCFGR1_SEC15_Pos             (15UL)
#define EXTI_SECCFGR1_SEC15_Msk             (0x1UL << EXTI_SECCFGR1_SEC15_Pos)      /*!< 0x00008000 */
#define EXTI_SECCFGR1_SEC15                 EXTI_SECCFGR1_SEC15_Msk                 /*!< Security enable on line 15 */
#define EXTI_SECCFGR1_SEC16_Pos             (16UL)
#define EXTI_SECCFGR1_SEC16_Msk             (0x1UL << EXTI_SECCFGR1_SEC16_Pos)      /*!< 0x00010000 */
#define EXTI_SECCFGR1_SEC16                 EXTI_SECCFGR1_SEC16_Msk                 /*!< Security enable on line 16 */
#define EXTI_SECCFGR1_SEC17_Pos             (17UL)
#define EXTI_SECCFGR1_SEC17_Msk             (0x1UL << EXTI_SECCFGR1_SEC17_Pos)      /*!< 0x00020000 */
#define EXTI_SECCFGR1_SEC17                 EXTI_SECCFGR1_SEC17_Msk                 /*!< Security enable on line 17 */
#define EXTI_SECCFGR1_SEC18_Pos             (18UL)
#define EXTI_SECCFGR1_SEC18_Msk             (0x1UL << EXTI_SECCFGR1_SEC18_Pos)      /*!< 0x00040000 */
#define EXTI_SECCFGR1_SEC18                 EXTI_SECCFGR1_SEC18_Msk                 /*!< Security enable on line 18 */

/*******************  Bit definition for EXTI_PRIVCFGR1 register  ******************/
#define EXTI_PRIVCFGR1_PRIV0_Pos            (0UL)
#define EXTI_PRIVCFGR1_PRIV0_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV0_Pos)     /*!< 0x00000001 */
#define EXTI_PRIVCFGR1_PRIV0                EXTI_PRIVCFGR1_PRIV0_Msk                /*!< Privilege enable on line 0 */
#define EXTI_PRIVCFGR1_PRIV1_Pos            (1UL)
#define EXTI_PRIVCFGR1_PRIV1_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV1_Pos)     /*!< 0x00000002 */
#define EXTI_PRIVCFGR1_PRIV1                EXTI_PRIVCFGR1_PRIV1_Msk                /*!< Privilege enable on line 1 */
#define EXTI_PRIVCFGR1_PRIV2_Pos            (2UL)
#define EXTI_PRIVCFGR1_PRIV2_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV2_Pos)     /*!< 0x00000004 */
#define EXTI_PRIVCFGR1_PRIV2                EXTI_PRIVCFGR1_PRIV2_Msk                /*!< Privilege enable on line 2 */
#define EXTI_PRIVCFGR1_PRIV3_Pos            (3UL)
#define EXTI_PRIVCFGR1_PRIV3_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV3_Pos)     /*!< 0x00000008 */
#define EXTI_PRIVCFGR1_PRIV3                EXTI_PRIVCFGR1_PRIV3_Msk                /*!< Privilege enable on line 3 */
#define EXTI_PRIVCFGR1_PRIV4_Pos            (4UL)
#define EXTI_PRIVCFGR1_PRIV4_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV4_Pos)     /*!< 0x00000010 */
#define EXTI_PRIVCFGR1_PRIV4                EXTI_PRIVCFGR1_PRIV4_Msk                /*!< Privilege enable on line 4 */
#define EXTI_PRIVCFGR1_PRIV5_Pos            (5UL)
#define EXTI_PRIVCFGR1_PRIV5_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV5_Pos)     /*!< 0x00000020 */
#define EXTI_PRIVCFGR1_PRIV5                EXTI_PRIVCFGR1_PRIV5_Msk                /*!< Privilege enable on line 5 */
#define EXTI_PRIVCFGR1_PRIV6_Pos            (6UL)
#define EXTI_PRIVCFGR1_PRIV6_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV6_Pos)     /*!< 0x00000040 */
#define EXTI_PRIVCFGR1_PRIV6                EXTI_PRIVCFGR1_PRIV6_Msk                /*!< Privilege enable on line 6 */
#define EXTI_PRIVCFGR1_PRIV7_Pos            (7UL)
#define EXTI_PRIVCFGR1_PRIV7_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV7_Pos)     /*!< 0x00000080 */
#define EXTI_PRIVCFGR1_PRIV7                EXTI_PRIVCFGR1_PRIV7_Msk                /*!< Privilege enable on line 7 */
#define EXTI_PRIVCFGR1_PRIV8_Pos            (8UL)
#define EXTI_PRIVCFGR1_PRIV8_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV8_Pos)     /*!< 0x00000100 */
#define EXTI_PRIVCFGR1_PRIV8                EXTI_PRIVCFGR1_PRIV8_Msk                /*!< Privilege enable on line 8 */
#define EXTI_PRIVCFGR1_PRIV9_Pos            (9UL)
#define EXTI_PRIVCFGR1_PRIV9_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV9_Pos)     /*!< 0x00000200 */
#define EXTI_PRIVCFGR1_PRIV9                EXTI_PRIVCFGR1_PRIV9_Msk                /*!< Privilege enable on line 9 */
#define EXTI_PRIVCFGR1_PRIV10_Pos           (10UL)
#define EXTI_PRIVCFGR1_PRIV10_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV10_Pos)    /*!< 0x00000400 */
#define EXTI_PRIVCFGR1_PRIV10               EXTI_PRIVCFGR1_PRIV10_Msk               /*!< Privilege enable on line 10 */
#define EXTI_PRIVCFGR1_PRIV11_Pos           (11UL)
#define EXTI_PRIVCFGR1_PRIV11_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV11_Pos)    /*!< 0x00000800 */
#define EXTI_PRIVCFGR1_PRIV11               EXTI_PRIVCFGR1_PRIV11_Msk               /*!< Privilege enable on line 11 */
#define EXTI_PRIVCFGR1_PRIV12_Pos           (12UL)
#define EXTI_PRIVCFGR1_PRIV12_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV12_Pos)    /*!< 0x00001000 */
#define EXTI_PRIVCFGR1_PRIV12               EXTI_PRIVCFGR1_PRIV12_Msk               /*!< Privilege enable on line 12 */
#define EXTI_PRIVCFGR1_PRIV13_Pos           (13UL)
#define EXTI_PRIVCFGR1_PRIV13_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV13_Pos)    /*!< 0x00002000 */
#define EXTI_PRIVCFGR1_PRIV13               EXTI_PRIVCFGR1_PRIV13_Msk               /*!< Privilege enable on line 13 */
#define EXTI_PRIVCFGR1_PRIV14_Pos           (14UL)
#define EXTI_PRIVCFGR1_PRIV14_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV14_Pos)    /*!< 0x00004000 */
#define EXTI_PRIVCFGR1_PRIV14               EXTI_PRIVCFGR1_PRIV14_Msk               /*!< Privilege enable on line 14 */
#define EXTI_PRIVCFGR1_PRIV15_Pos           (15UL)
#define EXTI_PRIVCFGR1_PRIV15_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV15_Pos)    /*!< 0x00008000 */
#define EXTI_PRIVCFGR1_PRIV15               EXTI_PRIVCFGR1_PRIV15_Msk               /*!< Privilege enable on line 15 */
#define EXTI_PRIVCFGR1_PRIV16_Pos           (16UL)
#define EXTI_PRIVCFGR1_PRIV16_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV16_Pos)    /*!< 0x00010000 */
#define EXTI_PRIVCFGR1_PRIV16               EXTI_PRIVCFGR1_PRIV16_Msk               /*!< Privilege enable on line 16 */
#define EXTI_PRIVCFGR1_PRIV17_Pos           (17UL)
#define EXTI_PRIVCFGR1_PRIV17_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV17_Pos)    /*!< 0x00020000 */
#define EXTI_PRIVCFGR1_PRIV17               EXTI_PRIVCFGR1_PRIV17_Msk               /*!< Privilege enable on line 17 */
#define EXTI_PRIVCFGR1_PRIV18_Pos           (18UL)
#define EXTI_PRIVCFGR1_PRIV18_Msk           (0x1UL << EXTI_PRIVCFGR1_PRIV18_Pos)    /*!< 0x00040000 */
#define EXTI_PRIVCFGR1_PRIV18               EXTI_PRIVCFGR1_PRIV18_Msk               /*!< Privilege enable on line 18 */

/*****************  Bit definition for EXTI_EXTICR1 register  **************/
#define EXTI_EXTICR1_EXTI0_Pos              (0UL)
#define EXTI_EXTICR1_EXTI0_Msk              (0xFFUL << EXTI_EXTICR1_EXTI0_Pos)      /*!< 0x000000FF */
#define EXTI_EXTICR1_EXTI0                  EXTI_EXTICR1_EXTI0_Msk                  /*!< EXTI 0 configuration */
#define EXTI_EXTICR1_EXTI0_0                (0x1UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR1_EXTI0_1                (0x2UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR1_EXTI0_2                (0x4UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR1_EXTI0_3                (0x8UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR1_EXTI0_4                (0x10UL << EXTI_EXTICR1_EXTI0_Pos)      /*!< 0x00000010 */
#define EXTI_EXTICR1_EXTI0_5                (0x20UL << EXTI_EXTICR1_EXTI0_Pos)      /*!< 0x00000020 */
#define EXTI_EXTICR1_EXTI0_6                (0x40UL << EXTI_EXTICR1_EXTI0_Pos)      /*!< 0x00000040 */
#define EXTI_EXTICR1_EXTI0_7                (0x80UL << EXTI_EXTICR1_EXTI0_Pos)      /*!< 0x00000080 */
#define EXTI_EXTICR1_EXTI1_Pos              (8UL)
#define EXTI_EXTICR1_EXTI1_Msk              (0xFFUL << EXTI_EXTICR1_EXTI1_Pos)      /*!< 0x0000FF00 */
#define EXTI_EXTICR1_EXTI1                  EXTI_EXTICR1_EXTI1_Msk                  /*!< EXTI 1 configuration */
#define EXTI_EXTICR1_EXTI1_0                (0x1UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR1_EXTI1_1                (0x2UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR1_EXTI1_2                (0x4UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR1_EXTI1_3                (0x8UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR1_EXTI1_4                (0x10UL << EXTI_EXTICR1_EXTI1_Pos)      /*!< 0x00001000 */
#define EXTI_EXTICR1_EXTI1_5                (0x20UL << EXTI_EXTICR1_EXTI1_Pos)      /*!< 0x00002000 */
#define EXTI_EXTICR1_EXTI1_6                (0x40UL << EXTI_EXTICR1_EXTI1_Pos)      /*!< 0x00004000 */
#define EXTI_EXTICR1_EXTI1_7                (0x80UL << EXTI_EXTICR1_EXTI1_Pos)      /*!< 0x00008000 */
#define EXTI_EXTICR1_EXTI2_Pos              (16UL)
#define EXTI_EXTICR1_EXTI2_Msk              (0xFFUL << EXTI_EXTICR1_EXTI2_Pos)      /*!< 0x00FF0000 */
#define EXTI_EXTICR1_EXTI2                  EXTI_EXTICR1_EXTI2_Msk                  /*!< EXTI 2 configuration */
#define EXTI_EXTICR1_EXTI2_0                (0x1UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR1_EXTI2_1                (0x2UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR1_EXTI2_2                (0x4UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR1_EXTI2_3                (0x8UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR1_EXTI2_4                (0x10UL << EXTI_EXTICR1_EXTI2_Pos)      /*!< 0x00100000 */
#define EXTI_EXTICR1_EXTI2_5                (0x20UL << EXTI_EXTICR1_EXTI2_Pos)      /*!< 0x00200000 */
#define EXTI_EXTICR1_EXTI2_6                (0x40UL << EXTI_EXTICR1_EXTI2_Pos)      /*!< 0x00400000 */
#define EXTI_EXTICR1_EXTI2_7                (0x80UL << EXTI_EXTICR1_EXTI2_Pos)      /*!< 0x00800000 */
#define EXTI_EXTICR1_EXTI3_Pos              (24UL)
#define EXTI_EXTICR1_EXTI3_Msk              (0xFFUL << EXTI_EXTICR1_EXTI3_Pos)      /*!< 0xFF000000 */
#define EXTI_EXTICR1_EXTI3                  EXTI_EXTICR1_EXTI3_Msk                  /*!< EXTI 3 configuration */
#define EXTI_EXTICR1_EXTI3_0                (0x1UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR1_EXTI3_1                (0x2UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR1_EXTI3_2                (0x4UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR1_EXTI3_3                (0x8UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x08000000 */
#define EXTI_EXTICR1_EXTI3_4                (0x10UL << EXTI_EXTICR1_EXTI3_Pos)      /*!< 0x10000000 */
#define EXTI_EXTICR1_EXTI3_5                (0x20UL << EXTI_EXTICR1_EXTI3_Pos)      /*!< 0x20000000 */
#define EXTI_EXTICR1_EXTI3_6                (0x40UL << EXTI_EXTICR1_EXTI3_Pos)      /*!< 0x40000000 */
#define EXTI_EXTICR1_EXTI3_7                (0x80UL << EXTI_EXTICR1_EXTI3_Pos)      /*!< 0x80000000 */

/*****************  Bit definition for EXTI_EXTICR2 register  **************/
#define EXTI_EXTICR2_EXTI4_Pos              (0UL)
#define EXTI_EXTICR2_EXTI4_Msk              (0xFFUL << EXTI_EXTICR2_EXTI4_Pos)      /*!< 0x000000FF */
#define EXTI_EXTICR2_EXTI4                  EXTI_EXTICR2_EXTI4_Msk                  /*!< EXTI 4 configuration */
#define EXTI_EXTICR2_EXTI4_0                (0x1UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR2_EXTI4_1                (0x2UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR2_EXTI4_2                (0x4UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR2_EXTI4_3                (0x8UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR2_EXTI4_4                (0x10UL << EXTI_EXTICR2_EXTI4_Pos)      /*!< 0x00000010 */
#define EXTI_EXTICR2_EXTI4_5                (0x20UL << EXTI_EXTICR2_EXTI4_Pos)      /*!< 0x00000020 */
#define EXTI_EXTICR2_EXTI4_6                (0x40UL << EXTI_EXTICR2_EXTI4_Pos)      /*!< 0x00000040 */
#define EXTI_EXTICR2_EXTI4_7                (0x80UL << EXTI_EXTICR2_EXTI4_Pos)      /*!< 0x00000080 */
#define EXTI_EXTICR2_EXTI5_Pos              (8UL)
#define EXTI_EXTICR2_EXTI5_Msk              (0xFFUL << EXTI_EXTICR2_EXTI5_Pos)      /*!< 0x0000FF00 */
#define EXTI_EXTICR2_EXTI5                  EXTI_EXTICR2_EXTI5_Msk                  /*!< EXTI 5 configuration */
#define EXTI_EXTICR2_EXTI5_0                (0x1UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR2_EXTI5_1                (0x2UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR2_EXTI5_2                (0x4UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR2_EXTI5_3                (0x8UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR2_EXTI5_4                (0x10UL << EXTI_EXTICR2_EXTI5_Pos)      /*!< 0x00001000 */
#define EXTI_EXTICR2_EXTI5_5                (0x20UL << EXTI_EXTICR2_EXTI5_Pos)      /*!< 0x00002000 */
#define EXTI_EXTICR2_EXTI5_6                (0x40UL << EXTI_EXTICR2_EXTI5_Pos)      /*!< 0x00004000 */
#define EXTI_EXTICR2_EXTI5_7                (0x80UL << EXTI_EXTICR2_EXTI5_Pos)      /*!< 0x00008000 */
#define EXTI_EXTICR2_EXTI6_Pos              (16UL)
#define EXTI_EXTICR2_EXTI6_Msk              (0xFFUL << EXTI_EXTICR2_EXTI6_Pos)      /*!< 0x00FF0000 */
#define EXTI_EXTICR2_EXTI6                  EXTI_EXTICR2_EXTI6_Msk                  /*!< EXTI 6 configuration */
#define EXTI_EXTICR2_EXTI6_0                (0x1UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR2_EXTI6_1                (0x2UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR2_EXTI6_2                (0x4UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR2_EXTI6_3                (0x8UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR2_EXTI6_4                (0x10UL << EXTI_EXTICR2_EXTI6_Pos)      /*!< 0x00100000 */
#define EXTI_EXTICR2_EXTI6_5                (0x20UL << EXTI_EXTICR2_EXTI6_Pos)      /*!< 0x00200000 */
#define EXTI_EXTICR2_EXTI6_6                (0x40UL << EXTI_EXTICR2_EXTI6_Pos)      /*!< 0x00400000 */
#define EXTI_EXTICR2_EXTI6_7                (0x80UL << EXTI_EXTICR2_EXTI6_Pos)      /*!< 0x00800000 */
#define EXTI_EXTICR2_EXTI7_Pos              (24UL)
#define EXTI_EXTICR2_EXTI7_Msk              (0xFFUL << EXTI_EXTICR2_EXTI7_Pos)      /*!< 0xFF000000 */
#define EXTI_EXTICR2_EXTI7                  EXTI_EXTICR2_EXTI7_Msk                  /*!< EXTI 7 configuration */
#define EXTI_EXTICR2_EXTI7_0                (0x1UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR2_EXTI7_1                (0x2UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR2_EXTI7_2                (0x4UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR2_EXTI7_3                (0x8UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x08000000 */
#define EXTI_EXTICR2_EXTI7_4                (0x10UL << EXTI_EXTICR2_EXTI7_Pos)      /*!< 0x10000000 */
#define EXTI_EXTICR2_EXTI7_5                (0x20UL << EXTI_EXTICR2_EXTI7_Pos)      /*!< 0x20000000 */
#define EXTI_EXTICR2_EXTI7_6                (0x40UL << EXTI_EXTICR2_EXTI7_Pos)      /*!< 0x40000000 */
#define EXTI_EXTICR2_EXTI7_7                (0x80UL << EXTI_EXTICR2_EXTI7_Pos)      /*!< 0x80000000 */

/*****************  Bit definition for EXTI_EXTICR3 register  **************/
#define EXTI_EXTICR3_EXTI8_Pos              (0UL)
#define EXTI_EXTICR3_EXTI8_Msk              (0xFFUL << EXTI_EXTICR3_EXTI8_Pos)      /*!< 0x000000FF */
#define EXTI_EXTICR3_EXTI8                  EXTI_EXTICR3_EXTI8_Msk                  /*!< EXTI 8 configuration */
#define EXTI_EXTICR3_EXTI8_0                (0x1UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR3_EXTI8_1                (0x2UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR3_EXTI8_2                (0x4UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR3_EXTI8_3                (0x8UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR3_EXTI8_4                (0x10UL << EXTI_EXTICR3_EXTI8_Pos)      /*!< 0x00000010 */
#define EXTI_EXTICR3_EXTI8_5                (0x20UL << EXTI_EXTICR3_EXTI8_Pos)      /*!< 0x00000020 */
#define EXTI_EXTICR3_EXTI8_6                (0x40UL << EXTI_EXTICR3_EXTI8_Pos)      /*!< 0x00000040 */
#define EXTI_EXTICR3_EXTI8_7                (0x80UL << EXTI_EXTICR3_EXTI8_Pos)      /*!< 0x00000080 */
#define EXTI_EXTICR3_EXTI9_Pos              (8UL)
#define EXTI_EXTICR3_EXTI9_Msk              (0xFFUL << EXTI_EXTICR3_EXTI9_Pos)      /*!< 0x0000FF00 */
#define EXTI_EXTICR3_EXTI9                  EXTI_EXTICR3_EXTI9_Msk                  /*!< EXTI 9 configuration */
#define EXTI_EXTICR3_EXTI9_0                (0x1UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR3_EXTI9_1                (0x2UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR3_EXTI9_2                (0x4UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR3_EXTI9_3                (0x8UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR3_EXTI9_4                (0x10UL << EXTI_EXTICR3_EXTI9_Pos)      /*!< 0x00001000 */
#define EXTI_EXTICR3_EXTI9_5                (0x20UL << EXTI_EXTICR3_EXTI9_Pos)      /*!< 0x00002000 */
#define EXTI_EXTICR3_EXTI9_6                (0x40UL << EXTI_EXTICR3_EXTI9_Pos)      /*!< 0x00004000 */
#define EXTI_EXTICR3_EXTI9_7                (0x80UL << EXTI_EXTICR3_EXTI9_Pos)      /*!< 0x00008000 */
#define EXTI_EXTICR3_EXTI10_Pos             (16UL)
#define EXTI_EXTICR3_EXTI10_Msk             (0xFFUL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00FF0000 */
#define EXTI_EXTICR3_EXTI10                 EXTI_EXTICR3_EXTI10_Msk                  /*!< EXTI 10 configuration */
#define EXTI_EXTICR3_EXTI10_0               (0x1UL << EXTI_EXTICR3_EXTI10_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR3_EXTI10_1               (0x2UL << EXTI_EXTICR3_EXTI10_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR3_EXTI10_2               (0x4UL << EXTI_EXTICR3_EXTI10_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR3_EXTI10_3               (0x8UL << EXTI_EXTICR3_EXTI10_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR3_EXTI10_4               (0x10UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00100000 */
#define EXTI_EXTICR3_EXTI10_5               (0x20UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00200000 */
#define EXTI_EXTICR3_EXTI10_6               (0x40UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00400000 */
#define EXTI_EXTICR3_EXTI10_7               (0x80UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00800000 */
#define EXTI_EXTICR3_EXTI11_Pos             (24UL)
#define EXTI_EXTICR3_EXTI11_Msk             (0xFFUL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0xFF000000 */
#define EXTI_EXTICR3_EXTI11                 EXTI_EXTICR3_EXTI11_Msk                  /*!< EXTI 11 configuration */
#define EXTI_EXTICR3_EXTI11_0               (0x1UL << EXTI_EXTICR3_EXTI11_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR3_EXTI11_1               (0x2UL << EXTI_EXTICR3_EXTI11_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR3_EXTI11_2               (0x4UL << EXTI_EXTICR3_EXTI11_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR3_EXTI11_3               (0x8UL << EXTI_EXTICR3_EXTI11_Pos)       /*!< 0x08000000 */
#define EXTI_EXTICR3_EXTI11_4               (0x10UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x10000000 */
#define EXTI_EXTICR3_EXTI11_5               (0x20UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x20000000 */
#define EXTI_EXTICR3_EXTI11_6               (0x40UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x40000000 */
#define EXTI_EXTICR3_EXTI11_7               (0x80UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x80000000 */

/*****************  Bit definition for EXTI_EXTICR4 register  **************/
#define EXTI_EXTICR4_EXTI12_Pos             (0UL)
#define EXTI_EXTICR4_EXTI12_Msk             (0xFFUL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x000000FF */
#define EXTI_EXTICR4_EXTI12                 EXTI_EXTICR4_EXTI12_Msk                  /*!< EXTI 12 configuration */
#define EXTI_EXTICR4_EXTI12_0               (0x1UL << EXTI_EXTICR4_EXTI12_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR4_EXTI12_1               (0x2UL << EXTI_EXTICR4_EXTI12_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR4_EXTI12_2               (0x4UL << EXTI_EXTICR4_EXTI12_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR4_EXTI12_3               (0x8UL << EXTI_EXTICR4_EXTI12_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR4_EXTI12_4               (0x10UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000010 */
#define EXTI_EXTICR4_EXTI12_5               (0x20UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000020 */
#define EXTI_EXTICR4_EXTI12_6               (0x40UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000040 */
#define EXTI_EXTICR4_EXTI12_7               (0x80UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000080 */
#define EXTI_EXTICR4_EXTI13_Pos             (8UL)
#define EXTI_EXTICR4_EXTI13_Msk             (0xFFUL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x0000FF00 */
#define EXTI_EXTICR4_EXTI13                 EXTI_EXTICR4_EXTI13_Msk                  /*!< EXTI 13 configuration */
#define EXTI_EXTICR4_EXTI13_0               (0x1UL << EXTI_EXTICR4_EXTI13_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR4_EXTI13_1               (0x2UL << EXTI_EXTICR4_EXTI13_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR4_EXTI13_2               (0x4UL << EXTI_EXTICR4_EXTI13_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR4_EXTI13_3               (0x8UL << EXTI_EXTICR4_EXTI13_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR4_EXTI13_4               (0x10UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00001000 */
#define EXTI_EXTICR4_EXTI13_5               (0x20UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00002000 */
#define EXTI_EXTICR4_EXTI13_6               (0x40UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00004000 */
#define EXTI_EXTICR4_EXTI13_7               (0x80UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00008000 */
#define EXTI_EXTICR4_EXTI14_Pos             (16UL)
#define EXTI_EXTICR4_EXTI14_Msk             (0xFFUL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00FF0000 */
#define EXTI_EXTICR4_EXTI14                 EXTI_EXTICR4_EXTI14_Msk                  /*!< EXTI 14 configuration */
#define EXTI_EXTICR4_EXTI14_0               (0x1UL << EXTI_EXTICR4_EXTI14_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR4_EXTI14_1               (0x2UL << EXTI_EXTICR4_EXTI14_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR4_EXTI14_2               (0x4UL << EXTI_EXTICR4_EXTI14_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR4_EXTI14_3               (0x8UL << EXTI_EXTICR4_EXTI14_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR4_EXTI14_4               (0x10UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00100000 */
#define EXTI_EXTICR4_EXTI14_5               (0x20UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00200000 */
#define EXTI_EXTICR4_EXTI14_6               (0x40UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00400000 */
#define EXTI_EXTICR4_EXTI14_7               (0x80UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00800000 */
#define EXTI_EXTICR4_EXTI15_Pos             (24UL)
#define EXTI_EXTICR4_EXTI15_Msk             (0xFFUL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0xFF000000 */
#define EXTI_EXTICR4_EXTI15                 EXTI_EXTICR4_EXTI15_Msk                  /*!< EXTI 15 configuration */
#define EXTI_EXTICR4_EXTI15_0               (0x1UL << EXTI_EXTICR4_EXTI15_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR4_EXTI15_1               (0x2UL << EXTI_EXTICR4_EXTI15_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR4_EXTI15_2               (0x4UL << EXTI_EXTICR4_EXTI15_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR4_EXTI15_3               (0x8UL << EXTI_EXTICR4_EXTI15_Pos)       /*!< 0x08000000 */
#define EXTI_EXTICR4_EXTI15_4               (0x10UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x10000000 */
#define EXTI_EXTICR4_EXTI15_5               (0x20UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x20000000 */
#define EXTI_EXTICR4_EXTI15_6               (0x40UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x40000000 */
#define EXTI_EXTICR4_EXTI15_7               (0x80UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x80000000 */

/*******************  Bit definition for EXTI_LOCKR register  ******************/
#define EXTI_LOCKR_LOCK_Pos                 (0UL)
#define EXTI_LOCKR_LOCK_Msk                 (0x1UL << EXTI_LOCKR_LOCK_Pos)            /*!< 0x00000001 */
#define EXTI_LOCKR_LOCK                     EXTI_LOCKR_LOCK_Msk                       /*!< Security and privilege configuration lock */

/*******************  Bit definition for EXTI_IMR1 register  ******************/
#define EXTI_IMR1_IM0_Pos                   (0UL)
#define EXTI_IMR1_IM0_Msk                   (0x1UL << EXTI_IMR1_IM0_Pos)            /*!< 0x00000001 */
#define EXTI_IMR1_IM0                       EXTI_IMR1_IM0_Msk                       /*!< Interrupt Mask on line 0 */
#define EXTI_IMR1_IM1_Pos                   (1UL)
#define EXTI_IMR1_IM1_Msk                   (0x1UL << EXTI_IMR1_IM1_Pos)            /*!< 0x00000002 */
#define EXTI_IMR1_IM1                       EXTI_IMR1_IM1_Msk                       /*!< Interrupt Mask on line 1 */
#define EXTI_IMR1_IM2_Pos                   (2UL)
#define EXTI_IMR1_IM2_Msk                   (0x1UL << EXTI_IMR1_IM2_Pos)            /*!< 0x00000004 */
#define EXTI_IMR1_IM2                       EXTI_IMR1_IM2_Msk                       /*!< Interrupt Mask on line 2 */
#define EXTI_IMR1_IM3_Pos                   (3UL)
#define EXTI_IMR1_IM3_Msk                   (0x1UL << EXTI_IMR1_IM3_Pos)            /*!< 0x00000008 */
#define EXTI_IMR1_IM3                       EXTI_IMR1_IM3_Msk                       /*!< Interrupt Mask on line 3 */
#define EXTI_IMR1_IM4_Pos                   (4UL)
#define EXTI_IMR1_IM4_Msk                   (0x1UL << EXTI_IMR1_IM4_Pos)            /*!< 0x00000010 */
#define EXTI_IMR1_IM4                       EXTI_IMR1_IM4_Msk                       /*!< Interrupt Mask on line 4 */
#define EXTI_IMR1_IM5_Pos                   (5UL)
#define EXTI_IMR1_IM5_Msk                   (0x1UL << EXTI_IMR1_IM5_Pos)            /*!< 0x00000020 */
#define EXTI_IMR1_IM5                       EXTI_IMR1_IM5_Msk                       /*!< Interrupt Mask on line 5 */
#define EXTI_IMR1_IM6_Pos                   (6UL)
#define EXTI_IMR1_IM6_Msk                   (0x1UL << EXTI_IMR1_IM6_Pos)            /*!< 0x00000040 */
#define EXTI_IMR1_IM6                       EXTI_IMR1_IM6_Msk                       /*!< Interrupt Mask on line 6 */
#define EXTI_IMR1_IM7_Pos                   (7UL)
#define EXTI_IMR1_IM7_Msk                   (0x1UL << EXTI_IMR1_IM7_Pos)            /*!< 0x00000080 */
#define EXTI_IMR1_IM7                       EXTI_IMR1_IM7_Msk                       /*!< Interrupt Mask on line 7 */
#define EXTI_IMR1_IM8_Pos                   (8UL)
#define EXTI_IMR1_IM8_Msk                   (0x1UL << EXTI_IMR1_IM8_Pos)            /*!< 0x00000100 */
#define EXTI_IMR1_IM8                       EXTI_IMR1_IM8_Msk                       /*!< Interrupt Mask on line 8 */
#define EXTI_IMR1_IM9_Pos                   (9UL)
#define EXTI_IMR1_IM9_Msk                   (0x1UL << EXTI_IMR1_IM9_Pos)            /*!< 0x00000200 */
#define EXTI_IMR1_IM9                       EXTI_IMR1_IM9_Msk                       /*!< Interrupt Mask on line 9 */
#define EXTI_IMR1_IM10_Pos                  (10UL)
#define EXTI_IMR1_IM10_Msk                  (0x1UL << EXTI_IMR1_IM10_Pos)           /*!< 0x00000400 */
#define EXTI_IMR1_IM10                      EXTI_IMR1_IM10_Msk                      /*!< Interrupt Mask on line 10 */
#define EXTI_IMR1_IM11_Pos                  (11UL)
#define EXTI_IMR1_IM11_Msk                  (0x1UL << EXTI_IMR1_IM11_Pos)           /*!< 0x00000800 */
#define EXTI_IMR1_IM11                      EXTI_IMR1_IM11_Msk                      /*!< Interrupt Mask on line 11 */
#define EXTI_IMR1_IM12_Pos                  (12UL)
#define EXTI_IMR1_IM12_Msk                  (0x1UL << EXTI_IMR1_IM12_Pos)           /*!< 0x00001000 */
#define EXTI_IMR1_IM12                      EXTI_IMR1_IM12_Msk                      /*!< Interrupt Mask on line 12 */
#define EXTI_IMR1_IM13_Pos                  (13UL)
#define EXTI_IMR1_IM13_Msk                  (0x1UL << EXTI_IMR1_IM13_Pos)           /*!< 0x00002000 */
#define EXTI_IMR1_IM13                      EXTI_IMR1_IM13_Msk                      /*!< Interrupt Mask on line 13 */
#define EXTI_IMR1_IM14_Pos                  (14UL)
#define EXTI_IMR1_IM14_Msk                  (0x1UL << EXTI_IMR1_IM14_Pos)           /*!< 0x00004000 */
#define EXTI_IMR1_IM14                      EXTI_IMR1_IM14_Msk                      /*!< Interrupt Mask on line 14 */
#define EXTI_IMR1_IM15_Pos                  (15UL)
#define EXTI_IMR1_IM15_Msk                  (0x1UL << EXTI_IMR1_IM15_Pos)           /*!< 0x00008000 */
#define EXTI_IMR1_IM15                      EXTI_IMR1_IM15_Msk                      /*!< Interrupt Mask on line 15 */
#define EXTI_IMR1_IM16_Pos                  (16UL)
#define EXTI_IMR1_IM16_Msk                  (0x1UL << EXTI_IMR1_IM16_Pos)           /*!< 0x00010000 */
#define EXTI_IMR1_IM16                      EXTI_IMR1_IM16_Msk                      /*!< Interrupt Mask on line 16 */
#define EXTI_IMR1_IM17_Pos                  (17UL)
#define EXTI_IMR1_IM17_Msk                  (0x1UL << EXTI_IMR1_IM17_Pos)           /*!< 0x00020000 */
#define EXTI_IMR1_IM17                      EXTI_IMR1_IM17_Msk                      /*!< Interrupt Mask on line 17 */
#define EXTI_IMR1_IM18_Pos                  (18UL)
#define EXTI_IMR1_IM18_Msk                  (0x1UL << EXTI_IMR1_IM18_Pos)           /*!< 0x00040000 */
#define EXTI_IMR1_IM18                      EXTI_IMR1_IM18_Msk                      /*!< Interrupt Mask on line 18 */

/*******************  Bit definition for EXTI_EMR1 register  ******************/
#define EXTI_EMR1_EM0_Pos                   (0UL)
#define EXTI_EMR1_EM0_Msk                   (0x1UL << EXTI_EMR1_EM0_Pos)            /*!< 0x00000001 */
#define EXTI_EMR1_EM0                       EXTI_EMR1_EM0_Msk                       /*!< Event Mask on line 0 */
#define EXTI_EMR1_EM1_Pos                   (1UL)
#define EXTI_EMR1_EM1_Msk                   (0x1UL << EXTI_EMR1_EM1_Pos)            /*!< 0x00000002 */
#define EXTI_EMR1_EM1                       EXTI_EMR1_EM1_Msk                       /*!< Event Mask on line 1 */
#define EXTI_EMR1_EM2_Pos                   (2UL)
#define EXTI_EMR1_EM2_Msk                   (0x1UL << EXTI_EMR1_EM2_Pos)            /*!< 0x00000004 */
#define EXTI_EMR1_EM2                       EXTI_EMR1_EM2_Msk                       /*!< Event Mask on line 2 */
#define EXTI_EMR1_EM3_Pos                   (3UL)
#define EXTI_EMR1_EM3_Msk                   (0x1UL << EXTI_EMR1_EM3_Pos)            /*!< 0x00000008 */
#define EXTI_EMR1_EM3                       EXTI_EMR1_EM3_Msk                       /*!< Event Mask on line 3 */
#define EXTI_EMR1_EM4_Pos                   (4UL)
#define EXTI_EMR1_EM4_Msk                   (0x1UL << EXTI_EMR1_EM4_Pos)            /*!< 0x00000010 */
#define EXTI_EMR1_EM4                       EXTI_EMR1_EM4_Msk                       /*!< Event Mask on line 4 */
#define EXTI_EMR1_EM5_Pos                   (5UL)
#define EXTI_EMR1_EM5_Msk                   (0x1UL << EXTI_EMR1_EM5_Pos)            /*!< 0x00000020 */
#define EXTI_EMR1_EM5                       EXTI_EMR1_EM5_Msk                       /*!< Event Mask on line 5 */
#define EXTI_EMR1_EM6_Pos                   (6UL)
#define EXTI_EMR1_EM6_Msk                   (0x1UL << EXTI_EMR1_EM6_Pos)            /*!< 0x00000040 */
#define EXTI_EMR1_EM6                       EXTI_EMR1_EM6_Msk                       /*!< Event Mask on line 6 */
#define EXTI_EMR1_EM7_Pos                   (7UL)
#define EXTI_EMR1_EM7_Msk                   (0x1UL << EXTI_EMR1_EM7_Pos)            /*!< 0x00000080 */
#define EXTI_EMR1_EM7                       EXTI_EMR1_EM7_Msk                       /*!< Event Mask on line 7 */
#define EXTI_EMR1_EM8_Pos                   (8UL)
#define EXTI_EMR1_EM8_Msk                   (0x1UL << EXTI_EMR1_EM8_Pos)            /*!< 0x00000100 */
#define EXTI_EMR1_EM8                       EXTI_EMR1_EM8_Msk                       /*!< Event Mask on line 8 */
#define EXTI_EMR1_EM9_Pos                   (9UL)
#define EXTI_EMR1_EM9_Msk                   (0x1UL << EXTI_EMR1_EM9_Pos)            /*!< 0x00000200 */
#define EXTI_EMR1_EM9                       EXTI_EMR1_EM9_Msk                       /*!< Event Mask on line 9 */
#define EXTI_EMR1_EM10_Pos                  (10UL)
#define EXTI_EMR1_EM10_Msk                  (0x1UL << EXTI_EMR1_EM10_Pos)           /*!< 0x00000400 */
#define EXTI_EMR1_EM10                      EXTI_EMR1_EM10_Msk                      /*!< Event Mask on line 10 */
#define EXTI_EMR1_EM11_Pos                  (11UL)
#define EXTI_EMR1_EM11_Msk                  (0x1UL << EXTI_EMR1_EM11_Pos)           /*!< 0x00000800 */
#define EXTI_EMR1_EM11                      EXTI_EMR1_EM11_Msk                      /*!< Event Mask on line 11 */
#define EXTI_EMR1_EM12_Pos                  (12UL)
#define EXTI_EMR1_EM12_Msk                  (0x1UL << EXTI_EMR1_EM12_Pos)           /*!< 0x00001000 */
#define EXTI_EMR1_EM12                      EXTI_EMR1_EM12_Msk                      /*!< Event Mask on line 12 */
#define EXTI_EMR1_EM13_Pos                  (13UL)
#define EXTI_EMR1_EM13_Msk                  (0x1UL << EXTI_EMR1_EM13_Pos)           /*!< 0x00002000 */
#define EXTI_EMR1_EM13                      EXTI_EMR1_EM13_Msk                      /*!< Event Mask on line 13 */
#define EXTI_EMR1_EM14_Pos                  (14UL)
#define EXTI_EMR1_EM14_Msk                  (0x1UL << EXTI_EMR1_EM14_Pos)           /*!< 0x00004000 */
#define EXTI_EMR1_EM14                      EXTI_EMR1_EM14_Msk                      /*!< Event Mask on line 14 */
#define EXTI_EMR1_EM15_Pos                  (15UL)
#define EXTI_EMR1_EM15_Msk                  (0x1UL << EXTI_EMR1_EM15_Pos)           /*!< 0x00008000 */
#define EXTI_EMR1_EM15                      EXTI_EMR1_EM15_Msk                      /*!< Event Mask on line 15 */
#define EXTI_EMR1_EM16_Pos                  (16UL)
#define EXTI_EMR1_EM16_Msk                  (0x1UL << EXTI_EMR1_EM16_Pos)           /*!< 0x00010000 */
#define EXTI_EMR1_EM16                      EXTI_EMR1_EM16_Msk                      /*!< Event Mask on line 16 */
#define EXTI_EMR1_EM17_Pos                  (17UL)
#define EXTI_EMR1_EM17_Msk                  (0x1UL << EXTI_EMR1_EM17_Pos)           /*!< 0x00020000 */
#define EXTI_EMR1_EM17                      EXTI_EMR1_EM17_Msk                      /*!< Event Mask on line 17 */
#define EXTI_EMR1_EM18_Pos                  (18UL)
#define EXTI_EMR1_EM18_Msk                  (0x1UL << EXTI_EMR1_EM18_Pos)           /*!< 0x00040000 */
#define EXTI_EMR1_EM18                      EXTI_EMR1_EM18_Msk                      /*!< Event Mask on line 18 */


/******************************************************************************/
/*                                                                            */
/*                                    FLASH                                   */
/*                                                                            */
/******************************************************************************/
#define FLASH_DBANK_SUPPORT                 /*!< Flash feature available only on specific devices: dualbank */
#define FLASH_LATENCY_DEFAULT               FLASH_ACR_LATENCY_0                     /* FLASH Latency 1 Wait State */

/*******************  Bits definition for FLASH_ACR register  *****************/
#define FLASH_ACR_LATENCY_Pos               (0UL)
#define FLASH_ACR_LATENCY_Msk               (0xFUL << FLASH_ACR_LATENCY_Pos)        /*!< 0x0000000F */
#define FLASH_ACR_LATENCY                   FLASH_ACR_LATENCY_Msk                   /*!< Latency    */
#define FLASH_ACR_LATENCY_0                 (0x1UL << FLASH_ACR_LATENCY_Pos)        /*!< 0x00000001 */
#define FLASH_ACR_LATENCY_1                 (0x2UL << FLASH_ACR_LATENCY_Pos)        /*!< 0x00000002 */
#define FLASH_ACR_LATENCY_2                 (0x4UL << FLASH_ACR_LATENCY_Pos)        /*!< 0x00000004 */
#define FLASH_ACR_LATENCY_3                 (0x8UL << FLASH_ACR_LATENCY_Pos)        /*!< 0x00000008 */
#define FLASH_ACR_PRFTEN_Pos                (8UL)
#define FLASH_ACR_PRFTEN_Msk                (0x1UL << FLASH_ACR_PRFTEN_Pos)         /*!< 0x00000100 */
#define FLASH_ACR_PRFTEN                    FLASH_ACR_PRFTEN_Msk                    /*!< Prefetch enable */
#define FLASH_ACR_LPM_Pos                   (11UL)
#define FLASH_ACR_LPM_Msk                   (0x1UL << FLASH_ACR_LPM_Pos)            /*!< 0x00000800 */
#define FLASH_ACR_LPM                       FLASH_ACR_LPM_Msk                       /*!< Low-Power read mode */
#define FLASH_ACR_PDREQ1_Pos                (12UL)
#define FLASH_ACR_PDREQ1_Msk                (0x1UL << FLASH_ACR_PDREQ1_Pos)         /*!< 0x00001000 */
#define FLASH_ACR_PDREQ1                    FLASH_ACR_PDREQ1_Msk                    /*!< Flash bank 1 power-down mode request */
#define FLASH_ACR_PDREQ2_Pos                (13UL)
#define FLASH_ACR_PDREQ2_Msk                (0x1UL << FLASH_ACR_PDREQ2_Pos)         /*!< 0x00002000 */
#define FLASH_ACR_PDREQ2                    FLASH_ACR_PDREQ2_Msk                    /*!< Flash bank 2 power-down mode request */
#define FLASH_ACR_SLEEP_PD_Pos              (14UL)
#define FLASH_ACR_SLEEP_PD_Msk              (0x1UL << FLASH_ACR_SLEEP_PD_Pos)       /*!< 0x00004000 */
#define FLASH_ACR_SLEEP_PD                  FLASH_ACR_SLEEP_PD_Msk                  /*!< Flash power-down mode during sleep */

/******************  Bits definition for FLASH_NSKEYR register  *****************/
#define FLASH_NSKEYR_NSKEY_Pos              (0UL)
#define FLASH_NSKEYR_NSKEY_Msk              (0xFFFFFFFFUL << FLASH_NSKEYR_NSKEY_Pos)    /*!< 0xFFFFFFFFF */
#define FLASH_NSKEYR_NSKEY                  FLASH_NSKEYR_NSKEY_Msk                      /*!< Flash memory non-secure key */

/******************  Bits definition for FLASH_SECKEYR register  *****************/
#define FLASH_SECKEYR_SECKEY_Pos            (0UL)
#define FLASH_SECKEYR_SECKEY_Msk            (0xFFFFFFFFUL << FLASH_SECKEYR_SECKEY_Pos)  /*!< 0xFFFFFFFFF */
#define FLASH_SECKEYR_SECKEY                FLASH_SECKEYR_SECKEY_Msk                    /*!< Flash memory secure key */

/******************  Bits definition for FLASH_OPTKEYR register  *****************/
#define FLASH_OPTKEYR_OPTKEY_Pos            (0UL)
#define FLASH_OPTKEYR_OPTKEY_Msk            (0xFFFFFFFFUL << FLASH_OPTKEYR_OPTKEY_Pos)  /*!< 0xFFFFFFFFF */
#define FLASH_OPTKEYR_OPTKEY                FLASH_OPTKEYR_OPTKEY_Msk                    /*!< Option byte key */

/******************  Bits definition for FLASH_PDKEY1R register  *****************/
#define FLASH_PDKEY1R_PDKEY_Pos             (0UL)
#define FLASH_PDKEY1R_PDKEY_Msk             (0xFFFFFFFFUL << FLASH_PDKEY1R_PDKEY_Pos)  /*!< 0xFFFFFFFFF */
#define FLASH_PDKEY1R_PDKEY                 FLASH_PDKEY1R_PDKEY_Msk                    /*!< Flash bank 1 power-down key */

/******************  Bits definition for FLASH_PDKEY2R register  *****************/
#define FLASH_PDKEY2R_PDKEY_Pos             (0UL)
#define FLASH_PDKEY2R_PDKEY_Msk             (0xFFFFFFFFUL << FLASH_PDKEY2R_PDKEY_Pos)  /*!< 0xFFFFFFFFF */
#define FLASH_PDKEY2R_PDKEY                 FLASH_PDKEY2R_PDKEY_Msk                    /*!< Flash bank 2 power-down key */

/******************  Bits definition for FLASH_NSSR register  *****************/
#define FLASH_NSSR_EOP_Pos                  (0UL)
#define FLASH_NSSR_EOP_Msk                  (0x1UL << FLASH_NSSR_EOP_Pos)           /*!< 0x00000001 */
#define FLASH_NSSR_EOP                      FLASH_NSSR_EOP_Msk                      /*!< Non-secure end of operation */
#define FLASH_NSSR_OPERR_Pos                (1UL)
#define FLASH_NSSR_OPERR_Msk                (0x1UL << FLASH_NSSR_OPERR_Pos)         /*!< 0x00000002 */
#define FLASH_NSSR_OPERR                    FLASH_NSSR_OPERR_Msk                    /*!< Non-secure operation error */
#define FLASH_NSSR_PROGERR_Pos              (3UL)
#define FLASH_NSSR_PROGERR_Msk              (0x1UL << FLASH_NSSR_PROGERR_Pos)       /*!< 0x00000008 */
#define FLASH_NSSR_PROGERR                  FLASH_NSSR_PROGERR_Msk                  /*!< Non-secure programming error */
#define FLASH_NSSR_WRPERR_Pos               (4UL)
#define FLASH_NSSR_WRPERR_Msk               (0x1UL << FLASH_NSSR_WRPERR_Pos)        /*!< 0x00000010 */
#define FLASH_NSSR_WRPERR                   FLASH_NSSR_WRPERR_Msk                   /*!< Non-secure write protection error */
#define FLASH_NSSR_PGAERR_Pos               (5UL)
#define FLASH_NSSR_PGAERR_Msk               (0x1UL << FLASH_NSSR_PGAERR_Pos)        /*!< 0x00000020 */
#define FLASH_NSSR_PGAERR                   FLASH_NSSR_PGAERR_Msk                   /*!< Non-secure programming alignment error */
#define FLASH_NSSR_SIZERR_Pos               (6UL)
#define FLASH_NSSR_SIZERR_Msk               (0x1UL << FLASH_NSSR_SIZERR_Pos)        /*!< 0x00000040 */
#define FLASH_NSSR_SIZERR                   FLASH_NSSR_SIZERR_Msk                   /*!< Non-secure size error */
#define FLASH_NSSR_PGSERR_Pos               (7UL)
#define FLASH_NSSR_PGSERR_Msk               (0x1UL << FLASH_NSSR_PGSERR_Pos)        /*!< 0x00000080 */
#define FLASH_NSSR_PGSERR                   FLASH_NSSR_PGSERR_Msk                   /*!< Non-secure programming sequence error */
#define FLASH_NSSR_OPTWERR_Pos              (13UL)
#define FLASH_NSSR_OPTWERR_Msk              (0x1UL << FLASH_NSSR_OPTWERR_Pos)       /*!< 0x00002000 */
#define FLASH_NSSR_OPTWERR                  FLASH_NSSR_OPTWERR_Msk                  /*!< Option write error */
#define FLASH_NSSR_BSY_Pos                  (16UL)
#define FLASH_NSSR_BSY_Msk                  (0x1UL << FLASH_NSSR_BSY_Pos)           /*!< 0x00010000 */
#define FLASH_NSSR_BSY                      FLASH_NSSR_BSY_Msk                      /*!< Non-secure busy */
#define FLASH_NSSR_WDW_Pos                  (17UL)
#define FLASH_NSSR_WDW_Msk                  (0x1UL << FLASH_NSSR_WDW_Pos)           /*!< 0x00020000 */
#define FLASH_NSSR_WDW                      FLASH_NSSR_WDW_Msk                      /*!< Non-secure wait data to write */
#define FLASH_NSSR_OEM1LOCK_Pos             (18UL)
#define FLASH_NSSR_OEM1LOCK_Msk             (0x1UL << FLASH_NSSR_OEM1LOCK_Pos)      /*!< 0x00040000 */
#define FLASH_NSSR_OEM1LOCK                 FLASH_NSSR_OEM1LOCK_Msk                 /*!< OEM1 lock */
#define FLASH_NSSR_OEM2LOCK_Pos             (19UL)
#define FLASH_NSSR_OEM2LOCK_Msk             (0x1UL << FLASH_NSSR_OEM2LOCK_Pos)      /*!< 0x00080000 */
#define FLASH_NSSR_OEM2LOCK                 FLASH_NSSR_OEM2LOCK_Msk                 /*!< OEM2 lock */
#define FLASH_NSSR_PD1_Pos                  (20UL)
#define FLASH_NSSR_PD1_Msk                  (0x1UL << FLASH_NSSR_PD1_Pos)           /*!< 0x00100000 */
#define FLASH_NSSR_PD1                      FLASH_NSSR_PD1_Msk                      /*!< Flash bank 1 in power-down mode */
#define FLASH_NSSR_PD2_Pos                  (21UL)
#define FLASH_NSSR_PD2_Msk                  (0x1UL << FLASH_NSSR_PD2_Pos)           /*!< 0x00200000 */
#define FLASH_NSSR_PD2                      FLASH_NSSR_PD2_Msk                      /*!< Flash bank 2 in power-down mode */

/******************  Bits definition for FLASH_SECSR register  ****************/
#define FLASH_SECSR_EOP_Pos                 (0UL)
#define FLASH_SECSR_EOP_Msk                 (0x1UL << FLASH_SECSR_EOP_Pos)          /*!< 0x00000001 */
#define FLASH_SECSR_EOP                     FLASH_SECSR_EOP_Msk                     /*!< Secure end of operation */
#define FLASH_SECSR_OPERR_Pos               (1UL)
#define FLASH_SECSR_OPERR_Msk               (0x1UL << FLASH_SECSR_OPERR_Pos)        /*!< 0x00000002 */
#define FLASH_SECSR_OPERR                   FLASH_SECSR_OPERR_Msk                   /*!< Secure operation error */
#define FLASH_SECSR_PROGERR_Pos             (3UL)
#define FLASH_SECSR_PROGERR_Msk             (0x1UL << FLASH_SECSR_PROGERR_Pos)      /*!< 0x00000008 */
#define FLASH_SECSR_PROGERR                 FLASH_SECSR_PROGERR_Msk                 /*!< Secure programming error */
#define FLASH_SECSR_WRPERR_Pos              (4UL)
#define FLASH_SECSR_WRPERR_Msk              (0x1UL << FLASH_SECSR_WRPERR_Pos)       /*!< 0x00000010 */
#define FLASH_SECSR_WRPERR                  FLASH_SECSR_WRPERR_Msk                  /*!< Secure write protection error */
#define FLASH_SECSR_PGAERR_Pos              (5UL)
#define FLASH_SECSR_PGAERR_Msk              (0x1UL << FLASH_SECSR_PGAERR_Pos)       /*!< 0x00000020 */
#define FLASH_SECSR_PGAERR                  FLASH_SECSR_PGAERR_Msk                  /*!< Secure programming alignment error */
#define FLASH_SECSR_SIZERR_Pos              (6UL)
#define FLASH_SECSR_SIZERR_Msk              (0x1UL << FLASH_SECSR_SIZERR_Pos)       /*!< 0x00000040 */
#define FLASH_SECSR_SIZERR                  FLASH_SECSR_SIZERR_Msk                  /*!< Secure size error */
#define FLASH_SECSR_PGSERR_Pos              (7UL)
#define FLASH_SECSR_PGSERR_Msk              (0x1UL << FLASH_SECSR_PGSERR_Pos)       /*!< 0x00000080 */
#define FLASH_SECSR_PGSERR                  FLASH_SECSR_PGSERR_Msk                  /*!< Secure programming sequence error */
#define FLASH_SECSR_BSY_Pos                 (16UL)
#define FLASH_SECSR_BSY_Msk                 (0x1UL << FLASH_SECSR_BSY_Pos)          /*!< 0x00010000 */
#define FLASH_SECSR_BSY                     FLASH_SECSR_BSY_Msk                     /*!< Secure busy */
#define FLASH_SECSR_WDW_Pos                 (17UL)
#define FLASH_SECSR_WDW_Msk                 (0x1UL << FLASH_SECSR_WDW_Pos)          /*!< 0x00020000 */
#define FLASH_SECSR_WDW                     FLASH_SECSR_WDW_Msk                     /*!< Secure wait data to write */

/******************  Bits definition for FLASH_NSCR1 register  *****************/
#define FLASH_NSCR1_PG_Pos                  (0UL)
#define FLASH_NSCR1_PG_Msk                  (0x1UL << FLASH_NSCR1_PG_Pos)           /*!< 0x00000001 */
#define FLASH_NSCR1_PG                      FLASH_NSCR1_PG_Msk                      /*!< Non-secure Programming */
#define FLASH_NSCR1_PER_Pos                 (1UL)
#define FLASH_NSCR1_PER_Msk                 (0x1UL << FLASH_NSCR1_PER_Pos)          /*!< 0x00000002 */
#define FLASH_NSCR1_PER                     FLASH_NSCR1_PER_Msk                     /*!< Non-secure Page Erase */
#define FLASH_NSCR1_MER1_Pos                (2UL)
#define FLASH_NSCR1_MER1_Msk                (0x1UL << FLASH_NSCR1_MER1_Pos)         /*!< 0x00000004 */
#define FLASH_NSCR1_MER1                    FLASH_NSCR1_MER1_Msk                    /*!< Non-secure Flash Bank 1 Erase */
#define FLASH_NSCR1_PNB_Pos                 (3UL)
#define FLASH_NSCR1_PNB_Msk                 (0x7FUL << FLASH_NSCR1_PNB_Pos)         /*!< 0x000003F8 */
#define FLASH_NSCR1_PNB                     FLASH_NSCR1_PNB_Msk                     /*!< Non-secure Page Number selection */
#define FLASH_NSCR1_BKER_Pos                (11UL)
#define FLASH_NSCR1_BKER_Msk                (0x1UL << FLASH_NSCR1_BKER_Pos)         /*!< 0x00000800 */
#define FLASH_NSCR1_BKER                    FLASH_NSCR1_BKER_Msk                    /*!< Non-secure Bank Selection for Page Erase */
#define FLASH_NSCR1_BWR_Pos                 (14UL)
#define FLASH_NSCR1_BWR_Msk                 (0x1UL << FLASH_NSCR1_BWR_Pos)          /*!< 0x00004000 */
#define FLASH_NSCR1_BWR                     FLASH_NSCR1_BWR_Msk                     /*!< Non-secure Burst Write Programming mode */
#define FLASH_NSCR1_MER2_Pos                (15UL)
#define FLASH_NSCR1_MER2_Msk                (0x1UL << FLASH_NSCR1_MER2_Pos)         /*!< 0x00008000 */
#define FLASH_NSCR1_MER2                    FLASH_NSCR1_MER2_Msk                    /*!< Non-secure Flash Bank 2 Erase */
#define FLASH_NSCR1_STRT_Pos                (16UL)
#define FLASH_NSCR1_STRT_Msk                (0x1UL << FLASH_NSCR1_STRT_Pos)         /*!< 0x00010000 */
#define FLASH_NSCR1_STRT                    FLASH_NSCR1_STRT_Msk                    /*!< Non-secure Start */
#define FLASH_NSCR1_OPTSTRT_Pos             (17UL)
#define FLASH_NSCR1_OPTSTRT_Msk             (0x1UL << FLASH_NSCR1_OPTSTRT_Pos)      /*!< 0x00020000 */
#define FLASH_NSCR1_OPTSTRT                 FLASH_NSCR1_OPTSTRT_Msk                 /*!< Option Modification Start */
#define FLASH_NSCR1_EOPIE_Pos               (24UL)
#define FLASH_NSCR1_EOPIE_Msk               (0x1UL << FLASH_NSCR1_EOPIE_Pos)        /*!< 0x01000000 */
#define FLASH_NSCR1_EOPIE                   FLASH_NSCR1_EOPIE_Msk                   /*!< Non-secure End of operation interrupt enable */
#define FLASH_NSCR1_ERRIE_Pos               (25UL)
#define FLASH_NSCR1_ERRIE_Msk               (0x1UL << FLASH_NSCR1_ERRIE_Pos)        /*!< 0x02000000 */
#define FLASH_NSCR1_ERRIE                   FLASH_NSCR1_ERRIE_Msk                   /*!< Non-secure error interrupt enable */
#define FLASH_NSCR1_OBL_LAUNCH_Pos          (27UL)
#define FLASH_NSCR1_OBL_LAUNCH_Msk          (0x1UL << FLASH_NSCR1_OBL_LAUNCH_Pos)   /*!< 0x08000000 */
#define FLASH_NSCR1_OBL_LAUNCH              FLASH_NSCR1_OBL_LAUNCH_Msk              /*!< Force the option byte loading */
#define FLASH_NSCR1_OPTLOCK_Pos             (30UL)
#define FLASH_NSCR1_OPTLOCK_Msk             (0x1UL << FLASH_NSCR1_OPTLOCK_Pos)      /*!< 0x40000000 */
#define FLASH_NSCR1_OPTLOCK                 FLASH_NSCR1_OPTLOCK_Msk                 /*!< Option Lock */
#define FLASH_NSCR1_LOCK_Pos                (31UL)
#define FLASH_NSCR1_LOCK_Msk                (0x1UL << FLASH_NSCR1_LOCK_Pos)         /*!< 0x80000000 */
#define FLASH_NSCR1_LOCK                    FLASH_NSCR1_LOCK_Msk                    /*!< Non-secure Lock */

/******************  Bits definition for FLASH_SECCR1 register  ****************/
#define FLASH_SECCR1_PG_Pos                 (0UL)
#define FLASH_SECCR1_PG_Msk                 (0x1UL << FLASH_SECCR1_PG_Pos)           /*!< 0x00000001 */
#define FLASH_SECCR1_PG                     FLASH_SECCR1_PG_Msk                      /*!< Secure Programming */
#define FLASH_SECCR1_PER_Pos                (1UL)
#define FLASH_SECCR1_PER_Msk                (0x1UL << FLASH_SECCR1_PER_Pos)          /*!< 0x00000002 */
#define FLASH_SECCR1_PER                    FLASH_SECCR1_PER_Msk                     /*!< Secure Page Erase */
#define FLASH_SECCR1_MER1_Pos               (2UL)
#define FLASH_SECCR1_MER1_Msk               (0x1UL << FLASH_SECCR1_MER1_Pos)         /*!< 0x00000004 */
#define FLASH_SECCR1_MER1                   FLASH_SECCR1_MER1_Msk                    /*!< Secure Flash Bank 1 Erase */
#define FLASH_SECCR1_PNB_Pos                (3UL)
#define FLASH_SECCR1_PNB_Msk                (0x7FUL << FLASH_SECCR1_PNB_Pos)         /*!< 0x000003F8 */
#define FLASH_SECCR1_PNB                    FLASH_SECCR1_PNB_Msk                     /*!< Secure Page Number selection */
#define FLASH_SECCR1_BKER_Pos               (11UL)
#define FLASH_SECCR1_BKER_Msk               (0x1UL << FLASH_SECCR1_BKER_Pos)         /*!< 0x00000800 */
#define FLASH_SECCR1_BKER                   FLASH_SECCR1_BKER_Msk                    /*!< Secure Bank Selection for Page Erase */
#define FLASH_SECCR1_BWR_Pos                (14UL)
#define FLASH_SECCR1_BWR_Msk                (0x1UL << FLASH_SECCR1_BWR_Pos)          /*!< 0x00004000 */
#define FLASH_SECCR1_BWR                    FLASH_SECCR1_BWR_Msk                     /*!< Secure Burst Write programming mode */
#define FLASH_SECCR1_MER2_Pos               (15UL)
#define FLASH_SECCR1_MER2_Msk               (0x1UL << FLASH_SECCR1_MER2_Pos)         /*!< 0x00008000 */
#define FLASH_SECCR1_MER2                   FLASH_SECCR1_MER2_Msk                    /*!< Secure Flash Bank 2 Erase */
#define FLASH_SECCR1_STRT_Pos               (16UL)
#define FLASH_SECCR1_STRT_Msk               (0x1UL << FLASH_SECCR1_STRT_Pos)         /*!< 0x00010000 */
#define FLASH_SECCR1_STRT                   FLASH_SECCR1_STRT_Msk                    /*!< Secure Start */
#define FLASH_SECCR1_EOPIE_Pos              (24UL)
#define FLASH_SECCR1_EOPIE_Msk              (0x1UL << FLASH_SECCR1_EOPIE_Pos)        /*!< 0x01000000 */
#define FLASH_SECCR1_EOPIE                  FLASH_SECCR1_EOPIE_Msk                   /*!< Secure end of operation interrupt enable */
#define FLASH_SECCR1_ERRIE_Pos              (25UL)
#define FLASH_SECCR1_ERRIE_Msk              (0x1UL << FLASH_SECCR1_ERRIE_Pos)        /*!< 0x02000000 */
#define FLASH_SECCR1_ERRIE                  FLASH_SECCR1_ERRIE_Msk                   /*!< Secure error interrupt enable */
#define FLASH_SECCR1_INV_Pos                (29UL)
#define FLASH_SECCR1_INV_Msk                (0x1UL << FLASH_SECCR1_INV_Pos)          /*!< 0x20000000 */
#define FLASH_SECCR1_INV                    FLASH_SECCR1_INV_Msk                     /*!< Flash Security State Invert */
#define FLASH_SECCR1_LOCK_Pos               (31UL)
#define FLASH_SECCR1_LOCK_Msk               (0x1UL << FLASH_SECCR1_LOCK_Pos)         /*!< 0x80000000 */
#define FLASH_SECCR1_LOCK                   FLASH_SECCR1_LOCK_Msk                    /*!< Secure Lock */

/*******************  Bits definition for FLASH_ECCR register  ***************/
#define FLASH_ECCR_ADDR_ECC_Pos             (0UL)
#define FLASH_ECCR_ADDR_ECC_Msk             (0xFFFFFUL << FLASH_ECCR_ADDR_ECC_Pos)  /*!< 0x000FFFFF */
#define FLASH_ECCR_ADDR_ECC                 FLASH_ECCR_ADDR_ECC_Msk                 /*!< ECC fail address */
#define FLASH_ECCR_BK_ECC_Pos               (21UL)
#define FLASH_ECCR_BK_ECC_Msk               (0x1UL << FLASH_ECCR_BK_ECC_Pos)        /*!< 0x00200000 */
#define FLASH_ECCR_BK_ECC                   FLASH_ECCR_BK_ECC_Msk                   /*!< Bank ECC fail */
#define FLASH_ECCR_SYSF_ECC_Pos             (22UL)
#define FLASH_ECCR_SYSF_ECC_Msk             (0x1UL << FLASH_ECCR_SYSF_ECC_Pos)      /*!< 0x00400000 */
#define FLASH_ECCR_SYSF_ECC                 FLASH_ECCR_SYSF_ECC_Msk                 /*!< System Flash ECC fail */
#define FLASH_ECCR_ECCIE_Pos                (24UL)
#define FLASH_ECCR_ECCIE_Msk                (0x1UL << FLASH_ECCR_ECCIE_Pos)         /*!< 0x01000000 */
#define FLASH_ECCR_ECCIE                    FLASH_ECCR_ECCIE_Msk                    /*!< ECC correction interrupt enable */
#define FLASH_ECCR_ECCC_Pos                 (30UL)
#define FLASH_ECCR_ECCC_Msk                 (0x1UL << FLASH_ECCR_ECCC_Pos)          /*!< 0x40000000 */
#define FLASH_ECCR_ECCC                     FLASH_ECCR_ECCC_Msk                     /*!< ECC correction */
#define FLASH_ECCR_ECCD_Pos                 (31UL)
#define FLASH_ECCR_ECCD_Msk                 (0x1UL << FLASH_ECCR_ECCD_Pos)          /*!< 0x80000000 */
#define FLASH_ECCR_ECCD                     FLASH_ECCR_ECCD_Msk                     /*!< ECC detection */

/*******************  Bits definition for FLASH_OPSR register  ***************/
#define FLASH_OPSR_ADDR_OP_Pos              (0UL)
#define FLASH_OPSR_ADDR_OP_Msk              (0xFFFFFUL << FLASH_OPSR_ADDR_OP_Pos)   /*!< 0x000FFFFF */
#define FLASH_OPSR_ADDR_OP                  FLASH_OPSR_ADDR_OP_Msk                  /*!< Interrupted operation address */
#define FLASH_OPSR_BK_OP_Pos                (21UL)
#define FLASH_OPSR_BK_OP_Msk                (0x1UL << FLASH_OPSR_BK_OP_Pos)         /*!< 0x00200000 */
#define FLASH_OPSR_BK_OP                    FLASH_OPSR_BK_OP_Msk                    /*!< Operation in bank interrupted */
#define FLASH_OPSR_SYSF_OP_Pos              (22UL)
#define FLASH_OPSR_SYSF_OP_Msk              (0x1UL << FLASH_OPSR_SYSF_OP_Pos)       /*!< 0x00400000 */
#define FLASH_OPSR_SYSF_OP                  FLASH_OPSR_SYSF_OP_Msk                  /*!< Operation in system Flash memory interrupted */
#define FLASH_OPSR_CODE_OP_Pos              (29UL)
#define FLASH_OPSR_CODE_OP_Msk              (0x7UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x07000000 */
#define FLASH_OPSR_CODE_OP                  FLASH_OPSR_CODE_OP_Msk                  /*!<  Flash memory operation code */
#define FLASH_OPSR_CODE_OP_0                (0x1UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x01000000 */
#define FLASH_OPSR_CODE_OP_1                (0x2UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x02000000 */
#define FLASH_OPSR_CODE_OP_2                (0x4UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x04000000 */

/*******************  Bits definition for FLASH_NSCR2 register  ***************/
#define FLASH_NSCR2_PS1_Pos                 (0UL)
#define FLASH_NSCR2_PS1_Msk                 (0x1UL << FLASH_NSCR2_PS1_Pos)          /*!< 0x00000001 */
#define FLASH_NSCR2_PS1                     FLASH_NSCR2_PS1_Msk                     /*!< Bank 1 non-secure program suspend request */
#define FLASH_NSCR2_ES1_Pos                 (1UL)
#define FLASH_NSCR2_ES1_Msk                 (0x1UL << FLASH_NSCR2_ES1_Pos)          /*!< 0x00000002 */
#define FLASH_NSCR2_ES1                     FLASH_NSCR2_ES1_Msk                     /*!< Bank 1 non-secure erase suspend request */
#define FLASH_NSCR2_PS2_Pos                 (16UL)
#define FLASH_NSCR2_PS2_Msk                 (0x1UL << FLASH_NSCR2_PS2_Pos)          /*!< 0x00010000 */
#define FLASH_NSCR2_PS2                     FLASH_NSCR2_PS2_Msk                     /*!< Bank 2 non-secure program suspend request */
#define FLASH_NSCR2_ES2_Pos                 (17UL)
#define FLASH_NSCR2_ES2_Msk                 (0x1UL << FLASH_NSCR2_ES2_Pos)          /*!< 0x00020000 */
#define FLASH_NSCR2_ES2                     FLASH_NSCR2_ES2_Msk                     /*!< Bank 2 non-secure erase suspend request */

/*******************  Bits definition for FLASH_SECCR2 register  ***************/
#define FLASH_SECCR2_PS1_Pos                (0UL)
#define FLASH_SECCR2_PS1_Msk                (0x1UL << FLASH_SECCR2_PS1_Pos)         /*!< 0x00000001 */
#define FLASH_SECCR2_PS1                    FLASH_SECCR2_PS1_Msk                    /*!< Bank 1 secure program suspend request */
#define FLASH_SECCR2_ES1_Pos                (1UL)
#define FLASH_SECCR2_ES1_Msk                (0x1UL << FLASH_SECCR2_ES1_Pos)         /*!< 0x00000002 */
#define FLASH_SECCR2_ES1                    FLASH_SECCR2_ES1_Msk                    /*!< Bank 1 secure erase suspend request */
#define FLASH_SECCR2_PS2_Pos                (16UL)
#define FLASH_SECCR2_PS2_Msk                (0x1UL << FLASH_SECCR2_PS2_Pos)         /*!< 0x00010000 */
#define FLASH_SECCR2_PS2                    FLASH_SECCR2_PS2_Msk                    /*!< Bank 2 secure program suspend request */
#define FLASH_SECCR2_ES2_Pos                (17UL)
#define FLASH_SECCR2_ES2_Msk                (0x1UL << FLASH_SECCR2_ES2_Pos)         /*!< 0x00020000 */
#define FLASH_SECCR2_ES2                    FLASH_SECCR2_ES2_Msk                    /*!< Bank 2 secure erase suspend request */

/*******************  Bits definition for FLASH_OPTR register  ***************/
#define FLASH_OPTR_RDP_Pos                  (0UL)
#define FLASH_OPTR_RDP_Msk                  (0xFFUL << FLASH_OPTR_RDP_Pos)          /*!< 0x000000FF */
#define FLASH_OPTR_RDP                      FLASH_OPTR_RDP_Msk                      /*!< Readout protection level */
#define FLASH_OPTR_BOR_LEV_Pos              (8UL)
#define FLASH_OPTR_BOR_LEV_Msk              (0x7UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000700 */
#define FLASH_OPTR_BOR_LEV                  FLASH_OPTR_BOR_LEV_Msk                  /*!< BOR reset Level */
#define FLASH_OPTR_BOR_LEV_0                (0x1UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000100 */
#define FLASH_OPTR_BOR_LEV_1                (0x2UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000200 */
#define FLASH_OPTR_BOR_LEV_2                (0x4UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000400 */
#define FLASH_OPTR_nRST_STOP_Pos            (12UL)
#define FLASH_OPTR_nRST_STOP_Msk            (0x1UL << FLASH_OPTR_nRST_STOP_Pos)     /*!< 0x00001000 */
#define FLASH_OPTR_nRST_STOP                FLASH_OPTR_nRST_STOP_Msk                /*!< nRST_STOP */
#define FLASH_OPTR_nRST_STDBY_Pos           (13UL)
#define FLASH_OPTR_nRST_STDBY_Msk           (0x1UL << FLASH_OPTR_nRST_STDBY_Pos)    /*!< 0x00002000 */
#define FLASH_OPTR_nRST_STDBY               FLASH_OPTR_nRST_STDBY_Msk               /*!< nRST_STDBY */
#define FLASH_OPTR_SRAM1_RST_Pos            (15UL)
#define FLASH_OPTR_SRAM1_RST_Msk            (0x1UL << FLASH_OPTR_SRAM1_RST_Pos)     /*!< 0x00008000 */
#define FLASH_OPTR_SRAM1_RST                FLASH_OPTR_SRAM1_RST_Msk                /*!< SRAM1 erase upon system reset */
#define FLASH_OPTR_IWDG_SW_Pos              (16UL)
#define FLASH_OPTR_IWDG_SW_Msk              (0x1UL << FLASH_OPTR_IWDG_SW_Pos)       /*!< 0x00010000 */
#define FLASH_OPTR_IWDG_SW                  FLASH_OPTR_IWDG_SW_Msk                  /*!< Independent watchdog selection */
#define FLASH_OPTR_IWDG_STOP_Pos            (17UL)
#define FLASH_OPTR_IWDG_STOP_Msk            (0x1UL << FLASH_OPTR_IWDG_STOP_Pos)     /*!< 0x00020000 */
#define FLASH_OPTR_IWDG_STOP                FLASH_OPTR_IWDG_STOP_Msk                /*!< Independent watchdog counter freeze in Stop mode */
#define FLASH_OPTR_IWDG_STDBY_Pos           (18UL)
#define FLASH_OPTR_IWDG_STDBY_Msk           (0x1UL << FLASH_OPTR_IWDG_STDBY_Pos)    /*!< 0x00040000 */
#define FLASH_OPTR_IWDG_STDBY               FLASH_OPTR_IWDG_STDBY_Msk               /*!< Independent watchdog counter freeze in Standby mode */
#define FLASH_OPTR_WWDG_SW_Pos              (19UL)
#define FLASH_OPTR_WWDG_SW_Msk              (0x1UL << FLASH_OPTR_WWDG_SW_Pos)       /*!< 0x00080000 */
#define FLASH_OPTR_WWDG_SW                  FLASH_OPTR_WWDG_SW_Msk                  /*!< Window watchdog selection */
#define FLASH_OPTR_SWAP_BANK_Pos            (20UL)
#define FLASH_OPTR_SWAP_BANK_Msk            (0x1UL << FLASH_OPTR_SWAP_BANK_Pos)     /*!< 0x00100000 */
#define FLASH_OPTR_SWAP_BANK                FLASH_OPTR_SWAP_BANK_Msk                /*!< Swap bank */
#define FLASH_OPTR_DUAL_BANK_Pos            (21UL)
#define FLASH_OPTR_DUAL_BANK_Msk            (0x1UL << FLASH_OPTR_DUAL_BANK_Pos)     /*!< 0x00200000 */
#define FLASH_OPTR_DUAL_BANK                FLASH_OPTR_DUAL_BANK_Msk                /*!< Dual bank */
#define FLASH_OPTR_SRAM2_PE_Pos             (24UL)
#define FLASH_OPTR_SRAM2_PE_Msk             (0x1UL << FLASH_OPTR_SRAM2_PE_Pos)      /*!< 0x01000000 */
#define FLASH_OPTR_SRAM2_PE                 FLASH_OPTR_SRAM2_PE_Msk                 /*!< SRAM2 ECC detection and correction enable*/
#define FLASH_OPTR_SRAM2_RST_Pos            (25UL)
#define FLASH_OPTR_SRAM2_RST_Msk            (0x1UL << FLASH_OPTR_SRAM2_RST_Pos)     /*!< 0x02000000 */
#define FLASH_OPTR_SRAM2_RST                FLASH_OPTR_SRAM2_RST_Msk                /*!< SRAM2 erase when system reset */
#define FLASH_OPTR_nSWBOOT0_Pos             (26UL)
#define FLASH_OPTR_nSWBOOT0_Msk             (0x1UL << FLASH_OPTR_nSWBOOT0_Pos)      /*!< 0x04000000 */
#define FLASH_OPTR_nSWBOOT0                 FLASH_OPTR_nSWBOOT0_Msk                 /*!< Software BOOT0 */
#define FLASH_OPTR_nBOOT0_Pos               (27UL)
#define FLASH_OPTR_nBOOT0_Msk               (0x1UL << FLASH_OPTR_nBOOT0_Pos)        /*!< 0x08000000 */
#define FLASH_OPTR_nBOOT0                   FLASH_OPTR_nBOOT0_Msk                   /*!< nBOOT0 option bit */
#define FLASH_OPTR_IO_VDD_HSLV_Pos          (29UL)
#define FLASH_OPTR_IO_VDD_HSLV_Msk          (0x1UL << FLASH_OPTR_IO_VDD_HSLV_Pos)   /*!< 0x20000000 */
#define FLASH_OPTR_IO_VDD_HSLV              FLASH_OPTR_IO_VDD_HSLV_Msk              /*!< High-speed IO at low Vdd voltage configuration */
#define FLASH_OPTR_IO_VDDIO2_HSLV_Pos       (30UL)
#define FLASH_OPTR_IO_VDDIO2_HSLV_Msk       (0x1UL << FLASH_OPTR_IO_VDDIO2_HSLV_Pos) /*!< 0x40000000 */
#define FLASH_OPTR_IO_VDDIO2_HSLV           FLASH_OPTR_IO_VDDIO2_HSLV_Msk            /*!< High-speed IO at low Vddio2 voltage configuration */
#define FLASH_OPTR_TZEN_Pos                 (31UL)
#define FLASH_OPTR_TZEN_Msk                 (0x1UL << FLASH_OPTR_TZEN_Pos)          /*!< 0x80000000 */
#define FLASH_OPTR_TZEN                     FLASH_OPTR_TZEN_Msk                     /*!< Global TrustZone security enable */

/****************  Bits definition for FLASH_NSBOOTADD0R register  ************/
#define FLASH_NSBOOTADD0R_NSBOOTADD0_Pos    (7UL)
#define FLASH_NSBOOTADD0R_NSBOOTADD0_Msk    (0x1FFFFFFUL << FLASH_NSBOOTADD0R_NSBOOTADD0_Pos) /*!< 0xFFFFFF80 */
#define FLASH_NSBOOTADD0R_NSBOOTADD0        FLASH_NSBOOTADD0R_NSBOOTADD0_Msk        /*!< Non-secure boot address 0 */

/****************  Bits definition for FLASH_NSBOOTADD1R register  ************/
#define FLASH_NSBOOTADD1R_NSBOOTADD1_Pos    (7UL)
#define FLASH_NSBOOTADD1R_NSBOOTADD1_Msk    (0x1FFFFFFUL << FLASH_NSBOOTADD1R_NSBOOTADD1_Pos) /*!< 0xFFFFFF80 */
#define FLASH_NSBOOTADD1R_NSBOOTADD1        FLASH_NSBOOTADD1R_NSBOOTADD1_Msk        /*!< Non-secure boot address 1 */

/****************  Bits definition for FLASH_SECBOOTADD0R register  ***********/
#define FLASH_SECBOOTADD0R_BOOT_LOCK_Pos    (0UL)
#define FLASH_SECBOOTADD0R_BOOT_LOCK_Msk    (0x1UL << FLASH_SECBOOTADD0R_BOOT_LOCK_Pos) /*!< 0x00000001 */
#define FLASH_SECBOOTADD0R_BOOT_LOCK        FLASH_SECBOOTADD0R_BOOT_LOCK_Msk        /*!< Boot Lock */
#define FLASH_SECBOOTADD0R_SECBOOTADD0_Pos  (7UL)
#define FLASH_SECBOOTADD0R_SECBOOTADD0_Msk  (0x1FFFFFFUL << FLASH_SECBOOTADD0R_SECBOOTADD0_Pos) /*!< 0xFFFFFF80 */
#define FLASH_SECBOOTADD0R_SECBOOTADD0      FLASH_SECBOOTADD0R_SECBOOTADD0_Msk      /*!< Secure boot address 0 */

/*****************  Bits definition for FLASH_SECWM1R1 register  **************/
#define FLASH_SECWM1R1_SECWM1_PSTRT_Pos     (0UL)
#define FLASH_SECWM1R1_SECWM1_PSTRT_Msk     (0x7FUL << FLASH_SECWM1R1_SECWM1_PSTRT_Pos) /*!< 0x0000007F */
#define FLASH_SECWM1R1_SECWM1_PSTRT         FLASH_SECWM1R1_SECWM1_PSTRT_Msk             /*!< Bank 1 start page of secure area */
#define FLASH_SECWM1R1_SECWM1_PEND_Pos      (16UL)
#define FLASH_SECWM1R1_SECWM1_PEND_Msk      (0x7FUL << FLASH_SECWM1R1_SECWM1_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_SECWM1R1_SECWM1_PEND          FLASH_SECWM1R1_SECWM1_PEND_Msk             /*!< Bank 1 end page of secure area */

/*****************  Bits definition for FLASH_SECWM1R2 register  **************/
#define FLASH_SECWM1R2_HDP1_PEND_Pos        (16UL)
#define FLASH_SECWM1R2_HDP1_PEND_Msk        (0x7FUL << FLASH_SECWM1R2_HDP1_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_SECWM1R2_HDP1_PEND            FLASH_SECWM1R2_HDP1_PEND_Msk             /*!< Bank 1 end page of secure hide protection area */
#define FLASH_SECWM1R2_HDP1EN_Pos           (31UL)
#define FLASH_SECWM1R2_HDP1EN_Msk           (0x1UL << FLASH_SECWM1R2_HDP1EN_Pos)     /*!< 0x80000000 */
#define FLASH_SECWM1R2_HDP1EN               FLASH_SECWM1R2_HDP1EN_Msk                /*!< Bank 1 secure hide protection area enable */

/******************  Bits definition for FLASH_WRP1AR register  ***************/
#define FLASH_WRP1AR_WRP1A_PSTRT_Pos        (0UL)
#define FLASH_WRP1AR_WRP1A_PSTRT_Msk        (0x7FUL << FLASH_WRP1AR_WRP1A_PSTRT_Pos) /*!< 0x0000007F */
#define FLASH_WRP1AR_WRP1A_PSTRT            FLASH_WRP1AR_WRP1A_PSTRT_Msk             /*!< WPR bank 1 area A start page */
#define FLASH_WRP1AR_WRP1A_PEND_Pos         (16UL)
#define FLASH_WRP1AR_WRP1A_PEND_Msk         (0x7FUL << FLASH_WRP1AR_WRP1A_PEND_Pos)  /*!< 0x007F0000 */
#define FLASH_WRP1AR_WRP1A_PEND             FLASH_WRP1AR_WRP1A_PEND_Msk              /*!< WPR bank 1 area A end page */
#define FLASH_WRP1AR_UNLOCK_Pos             (31UL)
#define FLASH_WRP1AR_UNLOCK_Msk             (0x1UL << FLASH_WRP1AR_UNLOCK_Pos)       /*!< 0x80000000 */
#define FLASH_WRP1AR_UNLOCK                 FLASH_WRP1AR_UNLOCK_Msk                  /*!< WPR bank 1 area A unlock */

/******************  Bits definition for FLASH_WRP1BR register  ***************/
#define FLASH_WRP1BR_WRP1B_PSTRT_Pos        (0UL)
#define FLASH_WRP1BR_WRP1B_PSTRT_Msk        (0x7FUL << FLASH_WRP1BR_WRP1B_PSTRT_Pos) /*!< 0x0000007F */
#define FLASH_WRP1BR_WRP1B_PSTRT            FLASH_WRP1BR_WRP1B_PSTRT_Msk             /*!< WPR bank 1 area B start page */
#define FLASH_WRP1BR_WRP1B_PEND_Pos         (16UL)
#define FLASH_WRP1BR_WRP1B_PEND_Msk         (0x7FUL << FLASH_WRP1BR_WRP1B_PEND_Pos)  /*!< 0x007F0000 */
#define FLASH_WRP1BR_WRP1B_PEND             FLASH_WRP1BR_WRP1B_PEND_Msk              /*!< WPR bank 1 area B end page */
#define FLASH_WRP1BR_UNLOCK_Pos             (31UL)
#define FLASH_WRP1BR_UNLOCK_Msk             (0x1UL << FLASH_WRP1BR_UNLOCK_Pos)       /*!< 0x80000000 */
#define FLASH_WRP1BR_UNLOCK                 FLASH_WRP1BR_UNLOCK_Msk                  /*!< WPR bank 1 area B unlock */

/*****************  Bits definition for FLASH_SECWM2R1 register  **************/
#define FLASH_SECWM2R1_SECWM2_PSTRT_Pos     (0UL)
#define FLASH_SECWM2R1_SECWM2_PSTRT_Msk     (0x7FUL << FLASH_SECWM2R1_SECWM2_PSTRT_Pos) /*!< 0x0000007F */
#define FLASH_SECWM2R1_SECWM2_PSTRT         FLASH_SECWM2R1_SECWM2_PSTRT_Msk             /*!< Bank 2 start page of secure area */
#define FLASH_SECWM2R1_SECWM2_PEND_Pos      (16UL)
#define FLASH_SECWM2R1_SECWM2_PEND_Msk      (0x7FUL << FLASH_SECWM2R1_SECWM2_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_SECWM2R1_SECWM2_PEND          FLASH_SECWM2R1_SECWM2_PEND_Msk             /*!< Bank 2 end page of secure area */

/*****************  Bits definition for FLASH_SECWM2R2 register  **************/
#define FLASH_SECWM2R2_HDP2_PEND_Pos        (16UL)
#define FLASH_SECWM2R2_HDP2_PEND_Msk        (0x7FUL << FLASH_SECWM2R2_HDP2_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_SECWM2R2_HDP2_PEND            FLASH_SECWM2R2_HDP2_PEND_Msk             /*!< Bank 2 end page of secure hide protection area */
#define FLASH_SECWM2R2_HDP2EN_Pos           (31UL)
#define FLASH_SECWM2R2_HDP2EN_Msk           (0x1UL << FLASH_SECWM2R2_HDP2EN_Pos)     /*!< 0x80000000 */
#define FLASH_SECWM2R2_HDP2EN               FLASH_SECWM2R2_HDP2EN_Msk                /*!< Bank 2 secure hide protection area enable */

/******************  Bits definition for FLASH_WRP2AR register  ***************/
#define FLASH_WRP2AR_WRP2A_PSTRT_Pos        (0UL)
#define FLASH_WRP2AR_WRP2A_PSTRT_Msk        (0x7FUL << FLASH_WRP2AR_WRP2A_PSTRT_Pos) /*!< 0x0000007F */
#define FLASH_WRP2AR_WRP2A_PSTRT            FLASH_WRP2AR_WRP2A_PSTRT_Msk             /*!< WPR bank 2 area A start page */
#define FLASH_WRP2AR_WRP2A_PEND_Pos         (16UL)
#define FLASH_WRP2AR_WRP2A_PEND_Msk         (0x7FUL << FLASH_WRP2AR_WRP2A_PEND_Pos)  /*!< 0x007F0000 */
#define FLASH_WRP2AR_WRP2A_PEND             FLASH_WRP2AR_WRP2A_PEND_Msk              /*!< WPR bank 2 area A end page */
#define FLASH_WRP2AR_UNLOCK_Pos             (31UL)
#define FLASH_WRP2AR_UNLOCK_Msk             (0x1UL << FLASH_WRP2AR_UNLOCK_Pos)       /*!< 0x80000000 */
#define FLASH_WRP2AR_UNLOCK                 FLASH_WRP2AR_UNLOCK_Msk                  /*!< WPR bank 2 area A unlock */

/******************  Bits definition for FLASH_WRP2BR register  ***************/
#define FLASH_WRP2BR_WRP2B_PSTRT_Pos        (0UL)
#define FLASH_WRP2BR_WRP2B_PSTRT_Msk        (0x7FUL << FLASH_WRP2BR_WRP2B_PSTRT_Pos) /*!< 0x0000007F */
#define FLASH_WRP2BR_WRP2B_PSTRT            FLASH_WRP2BR_WRP2B_PSTRT_Msk             /*!< WPR bank 2 area B start page */
#define FLASH_WRP2BR_WRP2B_PEND_Pos         (16UL)
#define FLASH_WRP2BR_WRP2B_PEND_Msk         (0x7FUL << FLASH_WRP2BR_WRP2B_PEND_Pos)  /*!< 0x007F0000 */
#define FLASH_WRP2BR_WRP2B_PEND             FLASH_WRP2BR_WRP2B_PEND_Msk              /*!< WPR bank 2 area B end page */
#define FLASH_WRP2BR_UNLOCK_Pos             (31UL)
#define FLASH_WRP2BR_UNLOCK_Msk             (0x1UL << FLASH_WRP2BR_UNLOCK_Pos)       /*!< 0x80000000 */
#define FLASH_WRP2BR_UNLOCK                 FLASH_WRP2BR_UNLOCK_Msk                  /*!< WPR bank 2 area B unlock */

/******************  Bits definition for FLASH_OEM1KEYR1 register  *****************/
#define FLASH_OEM1KEYR1_OEM1KEY_Pos         (0UL)
#define FLASH_OEM1KEYR1_OEM1KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM1KEYR1_OEM1KEY_Pos)  /*!< 0xFFFFFFFFF */
#define FLASH_OEM1KEYR1_OEM1KEY             FLASH_OEM1KEYR1_OEM1KEY_Msk                    /*!< OEM1 least significant bytes key */

/******************  Bits definition for FLASH_OEM1KEYR2 register  *****************/
#define FLASH_OEM1KEYR2_OEM1KEY_Pos         (0UL)
#define FLASH_OEM1KEYR2_OEM1KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM1KEYR2_OEM1KEY_Pos)  /*!< 0xFFFFFFFFF */
#define FLASH_OEM1KEYR2_OEM1KEY             FLASH_OEM1KEYR2_OEM1KEY_Msk                    /*!< OEM1 most significant bytes key */

/******************  Bits definition for FLASH_OEM2KEYR1 register  *****************/
#define FLASH_OEM2KEYR1_OEM2KEY_Pos         (0UL)
#define FLASH_OEM2KEYR1_OEM2KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM2KEYR1_OEM2KEY_Pos)  /*!< 0xFFFFFFFFF */
#define FLASH_OEM2KEYR1_OEM2KEY             FLASH_OEM2KEYR1_OEM2KEY_Msk                    /*!< OEM2 least significant bytes key */

/******************  Bits definition for FLASH_OEM2KEYR2 register  *****************/
#define FLASH_OEM2KEYR2_OEM2KEY_Pos         (0UL)
#define FLASH_OEM2KEYR2_OEM2KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM2KEYR2_OEM2KEY_Pos)  /*!< 0xFFFFFFFFF */
#define FLASH_OEM2KEYR2_OEM2KEY             FLASH_OEM2KEYR2_OEM2KEY_Msk                    /*!< OEM2 most significant bytes key */

/*******************  Bit definition for FLASH_SECBB1R1 register  ******************/
#define FLASH_SECBB1R1_SECBB0_Pos                   (0UL)
#define FLASH_SECBB1R1_SECBB0_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB1R1_SECBB0                       FLASH_SECBB1R1_SECBB0_Msk                       /*!< Page 0 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB1_Pos                   (1UL)
#define FLASH_SECBB1R1_SECBB1_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB1R1_SECBB1                       FLASH_SECBB1R1_SECBB1_Msk                       /*!< Page 1 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB2_Pos                   (2UL)
#define FLASH_SECBB1R1_SECBB2_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB1R1_SECBB2                       FLASH_SECBB1R1_SECBB2_Msk                       /*!< Page 2 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB3_Pos                   (3UL)
#define FLASH_SECBB1R1_SECBB3_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB1R1_SECBB3                       FLASH_SECBB1R1_SECBB3_Msk                       /*!< Page 3 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB4_Pos                   (4UL)
#define FLASH_SECBB1R1_SECBB4_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB1R1_SECBB4                       FLASH_SECBB1R1_SECBB4_Msk                       /*!< Page 4 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB5_Pos                   (5UL)
#define FLASH_SECBB1R1_SECBB5_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB1R1_SECBB5                       FLASH_SECBB1R1_SECBB5_Msk                       /*!< Page 5 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB6_Pos                   (6UL)
#define FLASH_SECBB1R1_SECBB6_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB1R1_SECBB6                       FLASH_SECBB1R1_SECBB6_Msk                       /*!< Page 6 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB7_Pos                   (7UL)
#define FLASH_SECBB1R1_SECBB7_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB1R1_SECBB7                       FLASH_SECBB1R1_SECBB7_Msk                       /*!< Page 7 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB8_Pos                   (8UL)
#define FLASH_SECBB1R1_SECBB8_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB1R1_SECBB8                       FLASH_SECBB1R1_SECBB8_Msk                       /*!< Page 8 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB9_Pos                   (9UL)
#define FLASH_SECBB1R1_SECBB9_Msk                   (0x1UL << FLASH_SECBB1R1_SECBB9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB1R1_SECBB9                       FLASH_SECBB1R1_SECBB9_Msk                       /*!< Page 9 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB10_Pos                  (10UL)
#define FLASH_SECBB1R1_SECBB10_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB1R1_SECBB10                      FLASH_SECBB1R1_SECBB10_Msk                      /*!< Page 10 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB11_Pos                  (11UL)
#define FLASH_SECBB1R1_SECBB11_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB1R1_SECBB11                      FLASH_SECBB1R1_SECBB11_Msk                      /*!< Page 11 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB12_Pos                  (12UL)
#define FLASH_SECBB1R1_SECBB12_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB1R1_SECBB12                      FLASH_SECBB1R1_SECBB12_Msk                      /*!< Page 12 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB13_Pos                  (13UL)
#define FLASH_SECBB1R1_SECBB13_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB1R1_SECBB13                      FLASH_SECBB1R1_SECBB13_Msk                      /*!< Page 13 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB14_Pos                  (14UL)
#define FLASH_SECBB1R1_SECBB14_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB1R1_SECBB14                      FLASH_SECBB1R1_SECBB14_Msk                      /*!< Page 14 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB15_Pos                  (15UL)
#define FLASH_SECBB1R1_SECBB15_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB1R1_SECBB15                      FLASH_SECBB1R1_SECBB15_Msk                      /*!< Page 15 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB16_Pos                  (16UL)
#define FLASH_SECBB1R1_SECBB16_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB1R1_SECBB16                      FLASH_SECBB1R1_SECBB16_Msk                      /*!< Page 16 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB17_Pos                  (17UL)
#define FLASH_SECBB1R1_SECBB17_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB1R1_SECBB17                      FLASH_SECBB1R1_SECBB17_Msk                      /*!< Page 17 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB18_Pos                  (18UL)
#define FLASH_SECBB1R1_SECBB18_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB1R1_SECBB18                      FLASH_SECBB1R1_SECBB18_Msk                      /*!< Page 18 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB19_Pos                  (19UL)
#define FLASH_SECBB1R1_SECBB19_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB1R1_SECBB19                      FLASH_SECBB1R1_SECBB19_Msk                      /*!< Page 19 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB20_Pos                  (20UL)
#define FLASH_SECBB1R1_SECBB20_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB1R1_SECBB20                      FLASH_SECBB1R1_SECBB20_Msk                      /*!< Page 20 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB21_Pos                  (21UL)
#define FLASH_SECBB1R1_SECBB21_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB1R1_SECBB21                      FLASH_SECBB1R1_SECBB21_Msk                      /*!< Page 21 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB22_Pos                  (22UL)
#define FLASH_SECBB1R1_SECBB22_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB1R1_SECBB22                      FLASH_SECBB1R1_SECBB22_Msk                      /*!< Page 22 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB23_Pos                  (23UL)
#define FLASH_SECBB1R1_SECBB23_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB1R1_SECBB23                      FLASH_SECBB1R1_SECBB23_Msk                      /*!< Page 23 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB24_Pos                  (24UL)
#define FLASH_SECBB1R1_SECBB24_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB1R1_SECBB24                      FLASH_SECBB1R1_SECBB24_Msk                      /*!< Page 24 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB25_Pos                  (25UL)
#define FLASH_SECBB1R1_SECBB25_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB1R1_SECBB25                      FLASH_SECBB1R1_SECBB25_Msk                      /*!< Page 25 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB26_Pos                  (26UL)
#define FLASH_SECBB1R1_SECBB26_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB1R1_SECBB26                      FLASH_SECBB1R1_SECBB26_Msk                      /*!< Page 26 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB27_Pos                  (27UL)
#define FLASH_SECBB1R1_SECBB27_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB1R1_SECBB27                      FLASH_SECBB1R1_SECBB27_Msk                      /*!< Page 27 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB28_Pos                  (28UL)
#define FLASH_SECBB1R1_SECBB28_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB1R1_SECBB28                      FLASH_SECBB1R1_SECBB28_Msk                      /*!< Page 28 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB29_Pos                  (29UL)
#define FLASH_SECBB1R1_SECBB29_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB1R1_SECBB29                      FLASH_SECBB1R1_SECBB29_Msk                      /*!< Page 29 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB30_Pos                  (30UL)
#define FLASH_SECBB1R1_SECBB30_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB1R1_SECBB30                      FLASH_SECBB1R1_SECBB30_Msk                      /*!< Page 30 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R1_SECBB31_Pos                  (31UL)
#define FLASH_SECBB1R1_SECBB31_Msk                  (0x1UL << FLASH_SECBB1R1_SECBB31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB1R1_SECBB31                      FLASH_SECBB1R1_SECBB31_Msk                      /*!< Page 31 in Flash bank 1 block-based secure */

/*******************  Bit definition for FLASH_SECBB1R2 register  ******************/
#define FLASH_SECBB1R2_SECBB0_Pos                   (0UL)
#define FLASH_SECBB1R2_SECBB0_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB1R2_SECBB0                       FLASH_SECBB1R2_SECBB0_Msk                       /*!< Page 32 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB1_Pos                   (1UL)
#define FLASH_SECBB1R2_SECBB1_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB1R2_SECBB1                       FLASH_SECBB1R2_SECBB1_Msk                       /*!< Page 33 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB2_Pos                   (2UL)
#define FLASH_SECBB1R2_SECBB2_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB1R2_SECBB2                       FLASH_SECBB1R2_SECBB2_Msk                       /*!< Page 34 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB3_Pos                   (3UL)
#define FLASH_SECBB1R2_SECBB3_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB1R2_SECBB3                       FLASH_SECBB1R2_SECBB3_Msk                       /*!< Page 35 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB4_Pos                   (4UL)
#define FLASH_SECBB1R2_SECBB4_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB1R2_SECBB4                       FLASH_SECBB1R2_SECBB4_Msk                       /*!< Page 36 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB5_Pos                   (5UL)
#define FLASH_SECBB1R2_SECBB5_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB1R2_SECBB5                       FLASH_SECBB1R2_SECBB5_Msk                       /*!< Page 37 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB6_Pos                   (6UL)
#define FLASH_SECBB1R2_SECBB6_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB1R2_SECBB6                       FLASH_SECBB1R2_SECBB6_Msk                       /*!< Page 38 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB7_Pos                   (7UL)
#define FLASH_SECBB1R2_SECBB7_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB1R2_SECBB7                       FLASH_SECBB1R2_SECBB7_Msk                       /*!< Page 39 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB8_Pos                   (8UL)
#define FLASH_SECBB1R2_SECBB8_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB1R2_SECBB8                       FLASH_SECBB1R2_SECBB8_Msk                       /*!< Page 40 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB9_Pos                   (9UL)
#define FLASH_SECBB1R2_SECBB9_Msk                   (0x1UL << FLASH_SECBB1R2_SECBB9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB1R2_SECBB9                       FLASH_SECBB1R2_SECBB9_Msk                       /*!< Page 41 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB10_Pos                  (10UL)
#define FLASH_SECBB1R2_SECBB10_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB1R2_SECBB10                      FLASH_SECBB1R2_SECBB10_Msk                      /*!< Page 42 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB11_Pos                  (11UL)
#define FLASH_SECBB1R2_SECBB11_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB1R2_SECBB11                      FLASH_SECBB1R2_SECBB11_Msk                      /*!< Page 43 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB12_Pos                  (12UL)
#define FLASH_SECBB1R2_SECBB12_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB1R2_SECBB12                      FLASH_SECBB1R2_SECBB12_Msk                      /*!< Page 44 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB13_Pos                  (13UL)
#define FLASH_SECBB1R2_SECBB13_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB1R2_SECBB13                      FLASH_SECBB1R2_SECBB13_Msk                      /*!< Page 45 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB14_Pos                  (14UL)
#define FLASH_SECBB1R2_SECBB14_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB1R2_SECBB14                      FLASH_SECBB1R2_SECBB14_Msk                      /*!< Page 46 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB15_Pos                  (15UL)
#define FLASH_SECBB1R2_SECBB15_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB1R2_SECBB15                      FLASH_SECBB1R2_SECBB15_Msk                      /*!< Page 47 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB16_Pos                  (16UL)
#define FLASH_SECBB1R2_SECBB16_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB1R2_SECBB16                      FLASH_SECBB1R2_SECBB16_Msk                      /*!< Page 48 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB17_Pos                  (17UL)
#define FLASH_SECBB1R2_SECBB17_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB1R2_SECBB17                      FLASH_SECBB1R2_SECBB17_Msk                      /*!< Page 49 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB18_Pos                  (18UL)
#define FLASH_SECBB1R2_SECBB18_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB1R2_SECBB18                      FLASH_SECBB1R2_SECBB18_Msk                      /*!< Page 50 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB19_Pos                  (19UL)
#define FLASH_SECBB1R2_SECBB19_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB1R2_SECBB19                      FLASH_SECBB1R2_SECBB19_Msk                      /*!< Page 51 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB20_Pos                  (20UL)
#define FLASH_SECBB1R2_SECBB20_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB1R2_SECBB20                      FLASH_SECBB1R2_SECBB20_Msk                      /*!< Page 52 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB21_Pos                  (21UL)
#define FLASH_SECBB1R2_SECBB21_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB1R2_SECBB21                      FLASH_SECBB1R2_SECBB21_Msk                      /*!< Page 53 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB22_Pos                  (22UL)
#define FLASH_SECBB1R2_SECBB22_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB1R2_SECBB22                      FLASH_SECBB1R2_SECBB22_Msk                      /*!< Page 54 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB23_Pos                  (23UL)
#define FLASH_SECBB1R2_SECBB23_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB1R2_SECBB23                      FLASH_SECBB1R2_SECBB23_Msk                      /*!< Page 55 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB24_Pos                  (24UL)
#define FLASH_SECBB1R2_SECBB24_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB1R2_SECBB24                      FLASH_SECBB1R2_SECBB24_Msk                      /*!< Page 56 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB25_Pos                  (25UL)
#define FLASH_SECBB1R2_SECBB25_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB1R2_SECBB25                      FLASH_SECBB1R2_SECBB25_Msk                      /*!< Page 57 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB26_Pos                  (26UL)
#define FLASH_SECBB1R2_SECBB26_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB1R2_SECBB26                      FLASH_SECBB1R2_SECBB26_Msk                      /*!< Page 58 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB27_Pos                  (27UL)
#define FLASH_SECBB1R2_SECBB27_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB1R2_SECBB27                      FLASH_SECBB1R2_SECBB27_Msk                      /*!< Page 59 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB28_Pos                  (28UL)
#define FLASH_SECBB1R2_SECBB28_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB1R2_SECBB28                      FLASH_SECBB1R2_SECBB28_Msk                      /*!< Page 60 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB29_Pos                  (29UL)
#define FLASH_SECBB1R2_SECBB29_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB1R2_SECBB29                      FLASH_SECBB1R2_SECBB29_Msk                      /*!< Page 61 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB30_Pos                  (30UL)
#define FLASH_SECBB1R2_SECBB30_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB1R2_SECBB30                      FLASH_SECBB1R2_SECBB30_Msk                      /*!< Page 62 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R2_SECBB31_Pos                  (31UL)
#define FLASH_SECBB1R2_SECBB31_Msk                  (0x1UL << FLASH_SECBB1R2_SECBB31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB1R2_SECBB31                      FLASH_SECBB1R2_SECBB31_Msk                      /*!< Page 63 in Flash bank 1 block-based secure */

/*******************  Bit definition for FLASH_SECBB1R3 register  ******************/
#define FLASH_SECBB1R3_SECBB0_Pos                   (0UL)
#define FLASH_SECBB1R3_SECBB0_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB1R3_SECBB0                       FLASH_SECBB1R3_SECBB0_Msk                       /*!< Page 64 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB1_Pos                   (1UL)
#define FLASH_SECBB1R3_SECBB1_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB1R3_SECBB1                       FLASH_SECBB1R3_SECBB1_Msk                       /*!< Page 65 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB2_Pos                   (2UL)
#define FLASH_SECBB1R3_SECBB2_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB1R3_SECBB2                       FLASH_SECBB1R3_SECBB2_Msk                       /*!< Page 66 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB3_Pos                   (3UL)
#define FLASH_SECBB1R3_SECBB3_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB1R3_SECBB3                       FLASH_SECBB1R3_SECBB3_Msk                       /*!< Page 67 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB4_Pos                   (4UL)
#define FLASH_SECBB1R3_SECBB4_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB1R3_SECBB4                       FLASH_SECBB1R3_SECBB4_Msk                       /*!< Page 68 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB5_Pos                   (5UL)
#define FLASH_SECBB1R3_SECBB5_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB1R3_SECBB5                       FLASH_SECBB1R3_SECBB5_Msk                       /*!< Page 69 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB6_Pos                   (6UL)
#define FLASH_SECBB1R3_SECBB6_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB1R3_SECBB6                       FLASH_SECBB1R3_SECBB6_Msk                       /*!< Page 70 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB7_Pos                   (7UL)
#define FLASH_SECBB1R3_SECBB7_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB1R3_SECBB7                       FLASH_SECBB1R3_SECBB7_Msk                       /*!< Page 71 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB8_Pos                   (8UL)
#define FLASH_SECBB1R3_SECBB8_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB1R3_SECBB8                       FLASH_SECBB1R3_SECBB8_Msk                       /*!< Page 72 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB9_Pos                   (9UL)
#define FLASH_SECBB1R3_SECBB9_Msk                   (0x1UL << FLASH_SECBB1R3_SECBB9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB1R3_SECBB9                       FLASH_SECBB1R3_SECBB9_Msk                       /*!< Page 73 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB10_Pos                  (10UL)
#define FLASH_SECBB1R3_SECBB10_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB1R3_SECBB10                      FLASH_SECBB1R3_SECBB10_Msk                      /*!< Page 74 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB11_Pos                  (11UL)
#define FLASH_SECBB1R3_SECBB11_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB1R3_SECBB11                      FLASH_SECBB1R3_SECBB11_Msk                      /*!< Page 75 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB12_Pos                  (12UL)
#define FLASH_SECBB1R3_SECBB12_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB1R3_SECBB12                      FLASH_SECBB1R3_SECBB12_Msk                      /*!< Page 76 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB13_Pos                  (13UL)
#define FLASH_SECBB1R3_SECBB13_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB1R3_SECBB13                      FLASH_SECBB1R3_SECBB13_Msk                      /*!< Page 77 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB14_Pos                  (14UL)
#define FLASH_SECBB1R3_SECBB14_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB1R3_SECBB14                      FLASH_SECBB1R3_SECBB14_Msk                      /*!< Page 78 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB15_Pos                  (15UL)
#define FLASH_SECBB1R3_SECBB15_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB1R3_SECBB15                      FLASH_SECBB1R3_SECBB15_Msk                      /*!< Page 79 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB16_Pos                  (16UL)
#define FLASH_SECBB1R3_SECBB16_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB1R3_SECBB16                      FLASH_SECBB1R3_SECBB16_Msk                      /*!< Page 80 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB17_Pos                  (17UL)
#define FLASH_SECBB1R3_SECBB17_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB1R3_SECBB17                      FLASH_SECBB1R3_SECBB17_Msk                      /*!< Page 81 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB18_Pos                  (18UL)
#define FLASH_SECBB1R3_SECBB18_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB1R3_SECBB18                      FLASH_SECBB1R3_SECBB18_Msk                      /*!< Page 82 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB19_Pos                  (19UL)
#define FLASH_SECBB1R3_SECBB19_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB1R3_SECBB19                      FLASH_SECBB1R3_SECBB19_Msk                      /*!< Page 83 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB20_Pos                  (20UL)
#define FLASH_SECBB1R3_SECBB20_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB1R3_SECBB20                      FLASH_SECBB1R3_SECBB20_Msk                      /*!< Page 84 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB21_Pos                  (21UL)
#define FLASH_SECBB1R3_SECBB21_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB1R3_SECBB21                      FLASH_SECBB1R3_SECBB21_Msk                      /*!< Page 85 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB22_Pos                  (22UL)
#define FLASH_SECBB1R3_SECBB22_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB1R3_SECBB22                      FLASH_SECBB1R3_SECBB22_Msk                      /*!< Page 86 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB23_Pos                  (23UL)
#define FLASH_SECBB1R3_SECBB23_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB1R3_SECBB23                      FLASH_SECBB1R3_SECBB23_Msk                      /*!< Page 87 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB24_Pos                  (24UL)
#define FLASH_SECBB1R3_SECBB24_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB1R3_SECBB24                      FLASH_SECBB1R3_SECBB24_Msk                      /*!< Page 88 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB25_Pos                  (25UL)
#define FLASH_SECBB1R3_SECBB25_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB1R3_SECBB25                      FLASH_SECBB1R3_SECBB25_Msk                      /*!< Page 89 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB26_Pos                  (26UL)
#define FLASH_SECBB1R3_SECBB26_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB1R3_SECBB26                      FLASH_SECBB1R3_SECBB26_Msk                      /*!< Page 90 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB27_Pos                  (27UL)
#define FLASH_SECBB1R3_SECBB27_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB1R3_SECBB27                      FLASH_SECBB1R3_SECBB27_Msk                      /*!< Page 91 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB28_Pos                  (28UL)
#define FLASH_SECBB1R3_SECBB28_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB1R3_SECBB28                      FLASH_SECBB1R3_SECBB28_Msk                      /*!< Page 92 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB29_Pos                  (29UL)
#define FLASH_SECBB1R3_SECBB29_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB1R3_SECBB29                      FLASH_SECBB1R3_SECBB29_Msk                      /*!< Page 93 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB30_Pos                  (30UL)
#define FLASH_SECBB1R3_SECBB30_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB1R3_SECBB30                      FLASH_SECBB1R3_SECBB30_Msk                      /*!< Page 94 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R3_SECBB31_Pos                  (31UL)
#define FLASH_SECBB1R3_SECBB31_Msk                  (0x1UL << FLASH_SECBB1R3_SECBB31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB1R3_SECBB31                      FLASH_SECBB1R3_SECBB31_Msk                      /*!< Page 95 in Flash bank 1 block-based secure */

/*******************  Bit definition for FLASH_SECBB1R4 register  ******************/
#define FLASH_SECBB1R4_SECBB0_Pos                   (0UL)
#define FLASH_SECBB1R4_SECBB0_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB1R4_SECBB0                       FLASH_SECBB1R4_SECBB0_Msk                       /*!< Page 96 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB1_Pos                   (1UL)
#define FLASH_SECBB1R4_SECBB1_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB1R4_SECBB1                       FLASH_SECBB1R4_SECBB1_Msk                       /*!< Page 97 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB2_Pos                   (2UL)
#define FLASH_SECBB1R4_SECBB2_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB1R4_SECBB2                       FLASH_SECBB1R4_SECBB2_Msk                       /*!< Page 98 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB3_Pos                   (3UL)
#define FLASH_SECBB1R4_SECBB3_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB1R4_SECBB3                       FLASH_SECBB1R4_SECBB3_Msk                       /*!< Page 99 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB4_Pos                   (4UL)
#define FLASH_SECBB1R4_SECBB4_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB1R4_SECBB4                       FLASH_SECBB1R4_SECBB4_Msk                       /*!< Page 100 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB5_Pos                   (5UL)
#define FLASH_SECBB1R4_SECBB5_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB1R4_SECBB5                       FLASH_SECBB1R4_SECBB5_Msk                       /*!< Page 101 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB6_Pos                   (6UL)
#define FLASH_SECBB1R4_SECBB6_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB1R4_SECBB6                       FLASH_SECBB1R4_SECBB6_Msk                       /*!< Page 102 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB7_Pos                   (7UL)
#define FLASH_SECBB1R4_SECBB7_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB1R4_SECBB7                       FLASH_SECBB1R4_SECBB7_Msk                       /*!< Page 103 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB8_Pos                   (8UL)
#define FLASH_SECBB1R4_SECBB8_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB1R4_SECBB8                       FLASH_SECBB1R4_SECBB8_Msk                       /*!< Page 104 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB9_Pos                   (9UL)
#define FLASH_SECBB1R4_SECBB9_Msk                   (0x1UL << FLASH_SECBB1R4_SECBB9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB1R4_SECBB9                       FLASH_SECBB1R4_SECBB9_Msk                       /*!< Page 105 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB10_Pos                  (10UL)
#define FLASH_SECBB1R4_SECBB10_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB1R4_SECBB10                      FLASH_SECBB1R4_SECBB10_Msk                      /*!< Page 106 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB11_Pos                  (11UL)
#define FLASH_SECBB1R4_SECBB11_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB1R4_SECBB11                      FLASH_SECBB1R4_SECBB11_Msk                      /*!< Page 107 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB12_Pos                  (12UL)
#define FLASH_SECBB1R4_SECBB12_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB1R4_SECBB12                      FLASH_SECBB1R4_SECBB12_Msk                      /*!< Page 108 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB13_Pos                  (13UL)
#define FLASH_SECBB1R4_SECBB13_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB1R4_SECBB13                      FLASH_SECBB1R4_SECBB13_Msk                      /*!< Page 109 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB14_Pos                  (14UL)
#define FLASH_SECBB1R4_SECBB14_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB1R4_SECBB14                      FLASH_SECBB1R4_SECBB14_Msk                      /*!< Page 110 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB15_Pos                  (15UL)
#define FLASH_SECBB1R4_SECBB15_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB1R4_SECBB15                      FLASH_SECBB1R4_SECBB15_Msk                      /*!< Page 111 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB16_Pos                  (16UL)
#define FLASH_SECBB1R4_SECBB16_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB1R4_SECBB16                      FLASH_SECBB1R4_SECBB16_Msk                      /*!< Page 112 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB17_Pos                  (17UL)
#define FLASH_SECBB1R4_SECBB17_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB1R4_SECBB17                      FLASH_SECBB1R4_SECBB17_Msk                      /*!< Page 113 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB18_Pos                  (18UL)
#define FLASH_SECBB1R4_SECBB18_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB1R4_SECBB18                      FLASH_SECBB1R4_SECBB18_Msk                      /*!< Page 114 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB19_Pos                  (19UL)
#define FLASH_SECBB1R4_SECBB19_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB1R4_SECBB19                      FLASH_SECBB1R4_SECBB19_Msk                      /*!< Page 115 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB20_Pos                  (20UL)
#define FLASH_SECBB1R4_SECBB20_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB1R4_SECBB20                      FLASH_SECBB1R4_SECBB20_Msk                      /*!< Page 116 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB21_Pos                  (21UL)
#define FLASH_SECBB1R4_SECBB21_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB1R4_SECBB21                      FLASH_SECBB1R4_SECBB21_Msk                      /*!< Page 117 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB22_Pos                  (22UL)
#define FLASH_SECBB1R4_SECBB22_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB1R4_SECBB22                      FLASH_SECBB1R4_SECBB22_Msk                      /*!< Page 118 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB23_Pos                  (23UL)
#define FLASH_SECBB1R4_SECBB23_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB1R4_SECBB23                      FLASH_SECBB1R4_SECBB23_Msk                      /*!< Page 119 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB24_Pos                  (24UL)
#define FLASH_SECBB1R4_SECBB24_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB1R4_SECBB24                      FLASH_SECBB1R4_SECBB24_Msk                      /*!< Page 120 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB25_Pos                  (25UL)
#define FLASH_SECBB1R4_SECBB25_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB1R4_SECBB25                      FLASH_SECBB1R4_SECBB25_Msk                      /*!< Page 121 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB26_Pos                  (26UL)
#define FLASH_SECBB1R4_SECBB26_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB1R4_SECBB26                      FLASH_SECBB1R4_SECBB26_Msk                      /*!< Page 122 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB27_Pos                  (27UL)
#define FLASH_SECBB1R4_SECBB27_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB1R4_SECBB27                      FLASH_SECBB1R4_SECBB27_Msk                      /*!< Page 123 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB28_Pos                  (28UL)
#define FLASH_SECBB1R4_SECBB28_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB1R4_SECBB28                      FLASH_SECBB1R4_SECBB28_Msk                      /*!< Page 124 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB29_Pos                  (29UL)
#define FLASH_SECBB1R4_SECBB29_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB1R4_SECBB29                      FLASH_SECBB1R4_SECBB29_Msk                      /*!< Page 125 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB30_Pos                  (30UL)
#define FLASH_SECBB1R4_SECBB30_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB1R4_SECBB30                      FLASH_SECBB1R4_SECBB30_Msk                      /*!< Page 126 in Flash bank 1 block-based secure */
#define FLASH_SECBB1R4_SECBB31_Pos                  (31UL)
#define FLASH_SECBB1R4_SECBB31_Msk                  (0x1UL << FLASH_SECBB1R4_SECBB31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB1R4_SECBB31                      FLASH_SECBB1R4_SECBB31_Msk                      /*!< Page 127 in Flash bank 1 block-based secure */

/*******************  Bit definition for FLASH_SECBB2R1 register  ******************/
#define FLASH_SECBB2R1_SECBB0_Pos                   (0UL)
#define FLASH_SECBB2R1_SECBB0_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB2R1_SECBB0                       FLASH_SECBB2R1_SECBB0_Msk                       /*!< Page 0 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB1_Pos                   (1UL)
#define FLASH_SECBB2R1_SECBB1_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB2R1_SECBB1                       FLASH_SECBB2R1_SECBB1_Msk                       /*!< Page 1 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB2_Pos                   (2UL)
#define FLASH_SECBB2R1_SECBB2_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB2R1_SECBB2                       FLASH_SECBB2R1_SECBB2_Msk                       /*!< Page 2 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB3_Pos                   (3UL)
#define FLASH_SECBB2R1_SECBB3_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB2R1_SECBB3                       FLASH_SECBB2R1_SECBB3_Msk                       /*!< Page 3 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB4_Pos                   (4UL)
#define FLASH_SECBB2R1_SECBB4_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB2R1_SECBB4                       FLASH_SECBB2R1_SECBB4_Msk                       /*!< Page 4 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB5_Pos                   (5UL)
#define FLASH_SECBB2R1_SECBB5_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB2R1_SECBB5                       FLASH_SECBB2R1_SECBB5_Msk                       /*!< Page 5 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB6_Pos                   (6UL)
#define FLASH_SECBB2R1_SECBB6_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB2R1_SECBB6                       FLASH_SECBB2R1_SECBB6_Msk                       /*!< Page 6 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB7_Pos                   (7UL)
#define FLASH_SECBB2R1_SECBB7_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB2R1_SECBB7                       FLASH_SECBB2R1_SECBB7_Msk                       /*!< Page 7 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB8_Pos                   (8UL)
#define FLASH_SECBB2R1_SECBB8_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB2R1_SECBB8                       FLASH_SECBB2R1_SECBB8_Msk                       /*!< Page 8 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB9_Pos                   (9UL)
#define FLASH_SECBB2R1_SECBB9_Msk                   (0x1UL << FLASH_SECBB2R1_SECBB9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB2R1_SECBB9                       FLASH_SECBB2R1_SECBB9_Msk                       /*!< Page 9 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB10_Pos                  (10UL)
#define FLASH_SECBB2R1_SECBB10_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB2R1_SECBB10                      FLASH_SECBB2R1_SECBB10_Msk                      /*!< Page 10 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB11_Pos                  (11UL)
#define FLASH_SECBB2R1_SECBB11_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB2R1_SECBB11                      FLASH_SECBB2R1_SECBB11_Msk                      /*!< Page 11 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB12_Pos                  (12UL)
#define FLASH_SECBB2R1_SECBB12_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB2R1_SECBB12                      FLASH_SECBB2R1_SECBB12_Msk                      /*!< Page 12 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB13_Pos                  (13UL)
#define FLASH_SECBB2R1_SECBB13_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB2R1_SECBB13                      FLASH_SECBB2R1_SECBB13_Msk                      /*!< Page 13 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB14_Pos                  (14UL)
#define FLASH_SECBB2R1_SECBB14_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB2R1_SECBB14                      FLASH_SECBB2R1_SECBB14_Msk                      /*!< Page 14 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB15_Pos                  (15UL)
#define FLASH_SECBB2R1_SECBB15_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB2R1_SECBB15                      FLASH_SECBB2R1_SECBB15_Msk                      /*!< Page 15 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB16_Pos                  (16UL)
#define FLASH_SECBB2R1_SECBB16_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB2R1_SECBB16                      FLASH_SECBB2R1_SECBB16_Msk                      /*!< Page 16 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB17_Pos                  (17UL)
#define FLASH_SECBB2R1_SECBB17_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB2R1_SECBB17                      FLASH_SECBB2R1_SECBB17_Msk                      /*!< Page 17 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB18_Pos                  (18UL)
#define FLASH_SECBB2R1_SECBB18_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB2R1_SECBB18                      FLASH_SECBB2R1_SECBB18_Msk                      /*!< Page 18 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB19_Pos                  (19UL)
#define FLASH_SECBB2R1_SECBB19_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB2R1_SECBB19                      FLASH_SECBB2R1_SECBB19_Msk                      /*!< Page 19 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB20_Pos                  (20UL)
#define FLASH_SECBB2R1_SECBB20_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB2R1_SECBB20                      FLASH_SECBB2R1_SECBB20_Msk                      /*!< Page 20 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB21_Pos                  (21UL)
#define FLASH_SECBB2R1_SECBB21_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB2R1_SECBB21                      FLASH_SECBB2R1_SECBB21_Msk                      /*!< Page 21 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB22_Pos                  (22UL)
#define FLASH_SECBB2R1_SECBB22_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB2R1_SECBB22                      FLASH_SECBB2R1_SECBB22_Msk                      /*!< Page 22 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB23_Pos                  (23UL)
#define FLASH_SECBB2R1_SECBB23_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB2R1_SECBB23                      FLASH_SECBB2R1_SECBB23_Msk                      /*!< Page 23 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB24_Pos                  (24UL)
#define FLASH_SECBB2R1_SECBB24_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB2R1_SECBB24                      FLASH_SECBB2R1_SECBB24_Msk                      /*!< Page 24 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB25_Pos                  (25UL)
#define FLASH_SECBB2R1_SECBB25_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB2R1_SECBB25                      FLASH_SECBB2R1_SECBB25_Msk                      /*!< Page 25 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB26_Pos                  (26UL)
#define FLASH_SECBB2R1_SECBB26_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB2R1_SECBB26                      FLASH_SECBB2R1_SECBB26_Msk                      /*!< Page 26 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB27_Pos                  (27UL)
#define FLASH_SECBB2R1_SECBB27_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB2R1_SECBB27                      FLASH_SECBB2R1_SECBB27_Msk                      /*!< Page 27 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB28_Pos                  (28UL)
#define FLASH_SECBB2R1_SECBB28_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB2R1_SECBB28                      FLASH_SECBB2R1_SECBB28_Msk                      /*!< Page 28 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB29_Pos                  (29UL)
#define FLASH_SECBB2R1_SECBB29_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB2R1_SECBB29                      FLASH_SECBB2R1_SECBB29_Msk                      /*!< Page 29 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB30_Pos                  (30UL)
#define FLASH_SECBB2R1_SECBB30_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB2R1_SECBB30                      FLASH_SECBB2R1_SECBB30_Msk                      /*!< Page 30 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R1_SECBB31_Pos                  (31UL)
#define FLASH_SECBB2R1_SECBB31_Msk                  (0x1UL << FLASH_SECBB2R1_SECBB31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB2R1_SECBB31                      FLASH_SECBB2R1_SECBB31_Msk                      /*!< Page 31 in Flash bank 2 block-based secure */

/*******************  Bit definition for FLASH_SECBB2R2 register  ******************/
#define FLASH_SECBB2R2_SECBB0_Pos                   (0UL)
#define FLASH_SECBB2R2_SECBB0_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB2R2_SECBB0                       FLASH_SECBB2R2_SECBB0_Msk                       /*!< Page 32 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB1_Pos                   (1UL)
#define FLASH_SECBB2R2_SECBB1_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB2R2_SECBB1                       FLASH_SECBB2R2_SECBB1_Msk                       /*!< Page 33 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB2_Pos                   (2UL)
#define FLASH_SECBB2R2_SECBB2_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB2R2_SECBB2                       FLASH_SECBB2R2_SECBB2_Msk                       /*!< Page 34 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB3_Pos                   (3UL)
#define FLASH_SECBB2R2_SECBB3_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB2R2_SECBB3                       FLASH_SECBB2R2_SECBB3_Msk                       /*!< Page 35 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB4_Pos                   (4UL)
#define FLASH_SECBB2R2_SECBB4_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB2R2_SECBB4                       FLASH_SECBB2R2_SECBB4_Msk                       /*!< Page 36 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB5_Pos                   (5UL)
#define FLASH_SECBB2R2_SECBB5_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB2R2_SECBB5                       FLASH_SECBB2R2_SECBB5_Msk                       /*!< Page 37 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB6_Pos                   (6UL)
#define FLASH_SECBB2R2_SECBB6_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB2R2_SECBB6                       FLASH_SECBB2R2_SECBB6_Msk                       /*!< Page 38 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB7_Pos                   (7UL)
#define FLASH_SECBB2R2_SECBB7_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB2R2_SECBB7                       FLASH_SECBB2R2_SECBB7_Msk                       /*!< Page 39 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB8_Pos                   (8UL)
#define FLASH_SECBB2R2_SECBB8_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB2R2_SECBB8                       FLASH_SECBB2R2_SECBB8_Msk                       /*!< Page 40 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB9_Pos                   (9UL)
#define FLASH_SECBB2R2_SECBB9_Msk                   (0x1UL << FLASH_SECBB2R2_SECBB9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB2R2_SECBB9                       FLASH_SECBB2R2_SECBB9_Msk                       /*!< Page 41 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB10_Pos                  (10UL)
#define FLASH_SECBB2R2_SECBB10_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB2R2_SECBB10                      FLASH_SECBB2R2_SECBB10_Msk                      /*!< Page 42 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB11_Pos                  (11UL)
#define FLASH_SECBB2R2_SECBB11_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB2R2_SECBB11                      FLASH_SECBB2R2_SECBB11_Msk                      /*!< Page 43 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB12_Pos                  (12UL)
#define FLASH_SECBB2R2_SECBB12_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB2R2_SECBB12                      FLASH_SECBB2R2_SECBB12_Msk                      /*!< Page 44 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB13_Pos                  (13UL)
#define FLASH_SECBB2R2_SECBB13_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB2R2_SECBB13                      FLASH_SECBB2R2_SECBB13_Msk                      /*!< Page 45 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB14_Pos                  (14UL)
#define FLASH_SECBB2R2_SECBB14_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB2R2_SECBB14                      FLASH_SECBB2R2_SECBB14_Msk                      /*!< Page 46 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB15_Pos                  (15UL)
#define FLASH_SECBB2R2_SECBB15_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB2R2_SECBB15                      FLASH_SECBB2R2_SECBB15_Msk                      /*!< Page 47 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB16_Pos                  (16UL)
#define FLASH_SECBB2R2_SECBB16_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB2R2_SECBB16                      FLASH_SECBB2R2_SECBB16_Msk                      /*!< Page 48 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB17_Pos                  (17UL)
#define FLASH_SECBB2R2_SECBB17_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB2R2_SECBB17                      FLASH_SECBB2R2_SECBB17_Msk                      /*!< Page 49 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB18_Pos                  (18UL)
#define FLASH_SECBB2R2_SECBB18_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB2R2_SECBB18                      FLASH_SECBB2R2_SECBB18_Msk                      /*!< Page 50 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB19_Pos                  (19UL)
#define FLASH_SECBB2R2_SECBB19_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB2R2_SECBB19                      FLASH_SECBB2R2_SECBB19_Msk                      /*!< Page 51 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB20_Pos                  (20UL)
#define FLASH_SECBB2R2_SECBB20_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB2R2_SECBB20                      FLASH_SECBB2R2_SECBB20_Msk                      /*!< Page 52 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB21_Pos                  (21UL)
#define FLASH_SECBB2R2_SECBB21_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB2R2_SECBB21                      FLASH_SECBB2R2_SECBB21_Msk                      /*!< Page 53 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB22_Pos                  (22UL)
#define FLASH_SECBB2R2_SECBB22_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB2R2_SECBB22                      FLASH_SECBB2R2_SECBB22_Msk                      /*!< Page 54 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB23_Pos                  (23UL)
#define FLASH_SECBB2R2_SECBB23_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB2R2_SECBB23                      FLASH_SECBB2R2_SECBB23_Msk                      /*!< Page 55 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB24_Pos                  (24UL)
#define FLASH_SECBB2R2_SECBB24_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB2R2_SECBB24                      FLASH_SECBB2R2_SECBB24_Msk                      /*!< Page 56 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB25_Pos                  (25UL)
#define FLASH_SECBB2R2_SECBB25_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB2R2_SECBB25                      FLASH_SECBB2R2_SECBB25_Msk                      /*!< Page 57 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB26_Pos                  (26UL)
#define FLASH_SECBB2R2_SECBB26_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB2R2_SECBB26                      FLASH_SECBB2R2_SECBB26_Msk                      /*!< Page 58 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB27_Pos                  (27UL)
#define FLASH_SECBB2R2_SECBB27_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB2R2_SECBB27                      FLASH_SECBB2R2_SECBB27_Msk                      /*!< Page 59 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB28_Pos                  (28UL)
#define FLASH_SECBB2R2_SECBB28_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB2R2_SECBB28                      FLASH_SECBB2R2_SECBB28_Msk                      /*!< Page 60 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB29_Pos                  (29UL)
#define FLASH_SECBB2R2_SECBB29_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB2R2_SECBB29                      FLASH_SECBB2R2_SECBB29_Msk                      /*!< Page 61 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB30_Pos                  (30UL)
#define FLASH_SECBB2R2_SECBB30_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB2R2_SECBB30                      FLASH_SECBB2R2_SECBB30_Msk                      /*!< Page 62 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R2_SECBB31_Pos                  (31UL)
#define FLASH_SECBB2R2_SECBB31_Msk                  (0x1UL << FLASH_SECBB2R2_SECBB31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB2R2_SECBB31                      FLASH_SECBB2R2_SECBB31_Msk                      /*!< Page 63 in Flash bank 2 block-based secure */

/*******************  Bit definition for FLASH_SECBB2R3 register  ******************/
#define FLASH_SECBB2R3_SECBB0_Pos                   (0UL)
#define FLASH_SECBB2R3_SECBB0_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB2R3_SECBB0                       FLASH_SECBB2R3_SECBB0_Msk                       /*!< Page 64 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB1_Pos                   (1UL)
#define FLASH_SECBB2R3_SECBB1_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB2R3_SECBB1                       FLASH_SECBB2R3_SECBB1_Msk                       /*!< Page 65 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB2_Pos                   (2UL)
#define FLASH_SECBB2R3_SECBB2_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB2R3_SECBB2                       FLASH_SECBB2R3_SECBB2_Msk                       /*!< Page 66 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB3_Pos                   (3UL)
#define FLASH_SECBB2R3_SECBB3_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB2R3_SECBB3                       FLASH_SECBB2R3_SECBB3_Msk                       /*!< Page 67 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB4_Pos                   (4UL)
#define FLASH_SECBB2R3_SECBB4_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB2R3_SECBB4                       FLASH_SECBB2R3_SECBB4_Msk                       /*!< Page 68 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB5_Pos                   (5UL)
#define FLASH_SECBB2R3_SECBB5_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB2R3_SECBB5                       FLASH_SECBB2R3_SECBB5_Msk                       /*!< Page 69 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB6_Pos                   (6UL)
#define FLASH_SECBB2R3_SECBB6_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB2R3_SECBB6                       FLASH_SECBB2R3_SECBB6_Msk                       /*!< Page 70 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB7_Pos                   (7UL)
#define FLASH_SECBB2R3_SECBB7_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB2R3_SECBB7                       FLASH_SECBB2R3_SECBB7_Msk                       /*!< Page 71 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB8_Pos                   (8UL)
#define FLASH_SECBB2R3_SECBB8_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB2R3_SECBB8                       FLASH_SECBB2R3_SECBB8_Msk                       /*!< Page 72 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB9_Pos                   (9UL)
#define FLASH_SECBB2R3_SECBB9_Msk                   (0x1UL << FLASH_SECBB2R3_SECBB9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB2R3_SECBB9                       FLASH_SECBB2R3_SECBB9_Msk                       /*!< Page 73 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB10_Pos                  (10UL)
#define FLASH_SECBB2R3_SECBB10_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB2R3_SECBB10                      FLASH_SECBB2R3_SECBB10_Msk                      /*!< Page 74 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB11_Pos                  (11UL)
#define FLASH_SECBB2R3_SECBB11_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB2R3_SECBB11                      FLASH_SECBB2R3_SECBB11_Msk                      /*!< Page 75 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB12_Pos                  (12UL)
#define FLASH_SECBB2R3_SECBB12_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB2R3_SECBB12                      FLASH_SECBB2R3_SECBB12_Msk                      /*!< Page 76 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB13_Pos                  (13UL)
#define FLASH_SECBB2R3_SECBB13_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB2R3_SECBB13                      FLASH_SECBB2R3_SECBB13_Msk                      /*!< Page 77 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB14_Pos                  (14UL)
#define FLASH_SECBB2R3_SECBB14_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB2R3_SECBB14                      FLASH_SECBB2R3_SECBB14_Msk                      /*!< Page 78 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB15_Pos                  (15UL)
#define FLASH_SECBB2R3_SECBB15_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB2R3_SECBB15                      FLASH_SECBB2R3_SECBB15_Msk                      /*!< Page 79 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB16_Pos                  (16UL)
#define FLASH_SECBB2R3_SECBB16_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB2R3_SECBB16                      FLASH_SECBB2R3_SECBB16_Msk                      /*!< Page 80 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB17_Pos                  (17UL)
#define FLASH_SECBB2R3_SECBB17_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB2R3_SECBB17                      FLASH_SECBB2R3_SECBB17_Msk                      /*!< Page 81 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB18_Pos                  (18UL)
#define FLASH_SECBB2R3_SECBB18_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB2R3_SECBB18                      FLASH_SECBB2R3_SECBB18_Msk                      /*!< Page 82 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB19_Pos                  (19UL)
#define FLASH_SECBB2R3_SECBB19_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB2R3_SECBB19                      FLASH_SECBB2R3_SECBB19_Msk                      /*!< Page 83 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB20_Pos                  (20UL)
#define FLASH_SECBB2R3_SECBB20_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB2R3_SECBB20                      FLASH_SECBB2R3_SECBB20_Msk                      /*!< Page 84 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB21_Pos                  (21UL)
#define FLASH_SECBB2R3_SECBB21_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB2R3_SECBB21                      FLASH_SECBB2R3_SECBB21_Msk                      /*!< Page 85 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB22_Pos                  (22UL)
#define FLASH_SECBB2R3_SECBB22_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB2R3_SECBB22                      FLASH_SECBB2R3_SECBB22_Msk                      /*!< Page 86 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB23_Pos                  (23UL)
#define FLASH_SECBB2R3_SECBB23_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB2R3_SECBB23                      FLASH_SECBB2R3_SECBB23_Msk                      /*!< Page 87 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB24_Pos                  (24UL)
#define FLASH_SECBB2R3_SECBB24_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB2R3_SECBB24                      FLASH_SECBB2R3_SECBB24_Msk                      /*!< Page 88 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB25_Pos                  (25UL)
#define FLASH_SECBB2R3_SECBB25_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB2R3_SECBB25                      FLASH_SECBB2R3_SECBB25_Msk                      /*!< Page 89 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB26_Pos                  (26UL)
#define FLASH_SECBB2R3_SECBB26_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB2R3_SECBB26                      FLASH_SECBB2R3_SECBB26_Msk                      /*!< Page 90 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB27_Pos                  (27UL)
#define FLASH_SECBB2R3_SECBB27_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB2R3_SECBB27                      FLASH_SECBB2R3_SECBB27_Msk                      /*!< Page 91 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB28_Pos                  (28UL)
#define FLASH_SECBB2R3_SECBB28_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB2R3_SECBB28                      FLASH_SECBB2R3_SECBB28_Msk                      /*!< Page 92 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB29_Pos                  (29UL)
#define FLASH_SECBB2R3_SECBB29_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB2R3_SECBB29                      FLASH_SECBB2R3_SECBB29_Msk                      /*!< Page 93 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB30_Pos                  (30UL)
#define FLASH_SECBB2R3_SECBB30_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB2R3_SECBB30                      FLASH_SECBB2R3_SECBB30_Msk                      /*!< Page 94 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R3_SECBB31_Pos                  (31UL)
#define FLASH_SECBB2R3_SECBB31_Msk                  (0x1UL << FLASH_SECBB2R3_SECBB31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB2R3_SECBB31                      FLASH_SECBB2R3_SECBB31_Msk                      /*!< Page 95 in Flash bank 2 block-based secure */

/*******************  Bit definition for FLASH_SECBB2R4 register  ******************/
#define FLASH_SECBB2R4_SECBB0_Pos                   (0UL)
#define FLASH_SECBB2R4_SECBB0_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB2R4_SECBB0                       FLASH_SECBB2R4_SECBB0_Msk                       /*!< Page 96 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB1_Pos                   (1UL)
#define FLASH_SECBB2R4_SECBB1_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB2R4_SECBB1                       FLASH_SECBB2R4_SECBB1_Msk                       /*!< Page 97 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB2_Pos                   (2UL)
#define FLASH_SECBB2R4_SECBB2_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB2R4_SECBB2                       FLASH_SECBB2R4_SECBB2_Msk                       /*!< Page 98 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB3_Pos                   (3UL)
#define FLASH_SECBB2R4_SECBB3_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB2R4_SECBB3                       FLASH_SECBB2R4_SECBB3_Msk                       /*!< Page 99 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB4_Pos                   (4UL)
#define FLASH_SECBB2R4_SECBB4_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB2R4_SECBB4                       FLASH_SECBB2R4_SECBB4_Msk                       /*!< Page 100 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB5_Pos                   (5UL)
#define FLASH_SECBB2R4_SECBB5_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB2R4_SECBB5                       FLASH_SECBB2R4_SECBB5_Msk                       /*!< Page 101 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB6_Pos                   (6UL)
#define FLASH_SECBB2R4_SECBB6_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB2R4_SECBB6                       FLASH_SECBB2R4_SECBB6_Msk                       /*!< Page 102 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB7_Pos                   (7UL)
#define FLASH_SECBB2R4_SECBB7_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB2R4_SECBB7                       FLASH_SECBB2R4_SECBB7_Msk                       /*!< Page 103 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB8_Pos                   (8UL)
#define FLASH_SECBB2R4_SECBB8_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB2R4_SECBB8                       FLASH_SECBB2R4_SECBB8_Msk                       /*!< Page 104 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB9_Pos                   (9UL)
#define FLASH_SECBB2R4_SECBB9_Msk                   (0x1UL << FLASH_SECBB2R4_SECBB9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB2R4_SECBB9                       FLASH_SECBB2R4_SECBB9_Msk                       /*!< Page 105 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB10_Pos                  (10UL)
#define FLASH_SECBB2R4_SECBB10_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB2R4_SECBB10                      FLASH_SECBB2R4_SECBB10_Msk                      /*!< Page 106 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB11_Pos                  (11UL)
#define FLASH_SECBB2R4_SECBB11_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB2R4_SECBB11                      FLASH_SECBB2R4_SECBB11_Msk                      /*!< Page 107 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB12_Pos                  (12UL)
#define FLASH_SECBB2R4_SECBB12_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB2R4_SECBB12                      FLASH_SECBB2R4_SECBB12_Msk                      /*!< Page 108 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB13_Pos                  (13UL)
#define FLASH_SECBB2R4_SECBB13_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB2R4_SECBB13                      FLASH_SECBB2R4_SECBB13_Msk                      /*!< Page 109 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB14_Pos                  (14UL)
#define FLASH_SECBB2R4_SECBB14_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB2R4_SECBB14                      FLASH_SECBB2R4_SECBB14_Msk                      /*!< Page 110 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB15_Pos                  (15UL)
#define FLASH_SECBB2R4_SECBB15_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB2R4_SECBB15                      FLASH_SECBB2R4_SECBB15_Msk                      /*!< Page 111 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB16_Pos                  (16UL)
#define FLASH_SECBB2R4_SECBB16_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB2R4_SECBB16                      FLASH_SECBB2R4_SECBB16_Msk                      /*!< Page 112 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB17_Pos                  (17UL)
#define FLASH_SECBB2R4_SECBB17_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB2R4_SECBB17                      FLASH_SECBB2R4_SECBB17_Msk                      /*!< Page 113 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB18_Pos                  (18UL)
#define FLASH_SECBB2R4_SECBB18_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB2R4_SECBB18                      FLASH_SECBB2R4_SECBB18_Msk                      /*!< Page 114 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB19_Pos                  (19UL)
#define FLASH_SECBB2R4_SECBB19_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB2R4_SECBB19                      FLASH_SECBB2R4_SECBB19_Msk                      /*!< Page 115 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB20_Pos                  (20UL)
#define FLASH_SECBB2R4_SECBB20_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB2R4_SECBB20                      FLASH_SECBB2R4_SECBB20_Msk                      /*!< Page 116 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB21_Pos                  (21UL)
#define FLASH_SECBB2R4_SECBB21_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB2R4_SECBB21                      FLASH_SECBB2R4_SECBB21_Msk                      /*!< Page 117 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB22_Pos                  (22UL)
#define FLASH_SECBB2R4_SECBB22_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB2R4_SECBB22                      FLASH_SECBB2R4_SECBB22_Msk                      /*!< Page 118 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB23_Pos                  (23UL)
#define FLASH_SECBB2R4_SECBB23_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB2R4_SECBB23                      FLASH_SECBB2R4_SECBB23_Msk                      /*!< Page 119 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB24_Pos                  (24UL)
#define FLASH_SECBB2R4_SECBB24_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB2R4_SECBB24                      FLASH_SECBB2R4_SECBB24_Msk                      /*!< Page 120 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB25_Pos                  (25UL)
#define FLASH_SECBB2R4_SECBB25_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB2R4_SECBB25                      FLASH_SECBB2R4_SECBB25_Msk                      /*!< Page 121 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB26_Pos                  (26UL)
#define FLASH_SECBB2R4_SECBB26_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB2R4_SECBB26                      FLASH_SECBB2R4_SECBB26_Msk                      /*!< Page 122 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB27_Pos                  (27UL)
#define FLASH_SECBB2R4_SECBB27_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB2R4_SECBB27                      FLASH_SECBB2R4_SECBB27_Msk                      /*!< Page 123 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB28_Pos                  (28UL)
#define FLASH_SECBB2R4_SECBB28_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB2R4_SECBB28                      FLASH_SECBB2R4_SECBB28_Msk                      /*!< Page 124 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB29_Pos                  (29UL)
#define FLASH_SECBB2R4_SECBB29_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB2R4_SECBB29                      FLASH_SECBB2R4_SECBB29_Msk                      /*!< Page 125 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB30_Pos                  (30UL)
#define FLASH_SECBB2R4_SECBB30_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB2R4_SECBB30                      FLASH_SECBB2R4_SECBB30_Msk                      /*!< Page 126 in Flash bank 2 block-based secure */
#define FLASH_SECBB2R4_SECBB31_Pos                  (31UL)
#define FLASH_SECBB2R4_SECBB31_Msk                  (0x1UL << FLASH_SECBB2R4_SECBB31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB2R4_SECBB31                      FLASH_SECBB2R4_SECBB31_Msk                      /*!< Page 127 in Flash bank 2 block-based secure */

/******************  Bits definition for FLASH_SECHDPCR register  ***********/
#define FLASH_SECHDPCR_HDP1_ACCDIS_Pos     (0UL)
#define FLASH_SECHDPCR_HDP1_ACCDIS_Msk     (0x1UL << FLASH_SECHDPCR_HDP1_ACCDIS_Pos) /*!< 0x00000001 */
#define FLASH_SECHDPCR_HDP1_ACCDIS         FLASH_SECHDPCR_HDP1_ACCDIS_Msk            /*!< Bank 1 secure HDP area access disable */
#define FLASH_SECHDPCR_HDP2_ACCDIS_Pos     (1UL)
#define FLASH_SECHDPCR_HDP2_ACCDIS_Msk     (0x1UL << FLASH_SECHDPCR_HDP2_ACCDIS_Pos) /*!< 0x00000002 */
#define FLASH_SECHDPCR_HDP2_ACCDIS         FLASH_SECHDPCR_HDP2_ACCDIS_Msk            /*!< Bank 2 secure HDP area access disable */

/******************  Bits definition for FLASH_PRIVCFGR register  ***********/
#define FLASH_PRIVCFGR_SPRIV_Pos            (0UL)
#define FLASH_PRIVCFGR_SPRIV_Msk            (0x1UL << FLASH_PRIVCFGR_SPRIV_Pos)     /*!< 0x00000001 */
#define FLASH_PRIVCFGR_SPRIV                FLASH_PRIVCFGR_SPRIV_Msk                /*!< Privilege protection for secure registers */
#define FLASH_PRIVCFGR_NSPRIV_Pos           (1UL)
#define FLASH_PRIVCFGR_NSPRIV_Msk           (0x1UL << FLASH_PRIVCFGR_NSPRIV_Pos)    /*!< 0x00000002 */
#define FLASH_PRIVCFGR_NSPRIV               FLASH_PRIVCFGR_NSPRIV_Msk               /*!< Privilege protection for non-secure registers */

/*******************  Bit definition for FLASH_PRIVBB1R1 register  ******************/
#define FLASH_PRIVBB1R1_PRIVBB0_Pos                   (0UL)
#define FLASH_PRIVBB1R1_PRIVBB0_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB1R1_PRIVBB0                       FLASH_PRIVBB1R1_PRIVBB0_Msk                       /*!< Page 0 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB1_Pos                   (1UL)
#define FLASH_PRIVBB1R1_PRIVBB1_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB1R1_PRIVBB1                       FLASH_PRIVBB1R1_PRIVBB1_Msk                       /*!< Page 1 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB2_Pos                   (2UL)
#define FLASH_PRIVBB1R1_PRIVBB2_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB1R1_PRIVBB2                       FLASH_PRIVBB1R1_PRIVBB2_Msk                       /*!< Page 2 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB3_Pos                   (3UL)
#define FLASH_PRIVBB1R1_PRIVBB3_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB1R1_PRIVBB3                       FLASH_PRIVBB1R1_PRIVBB3_Msk                       /*!< Page 3 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB4_Pos                   (4UL)
#define FLASH_PRIVBB1R1_PRIVBB4_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB1R1_PRIVBB4                       FLASH_PRIVBB1R1_PRIVBB4_Msk                       /*!< Page 4 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB5_Pos                   (5UL)
#define FLASH_PRIVBB1R1_PRIVBB5_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB1R1_PRIVBB5                       FLASH_PRIVBB1R1_PRIVBB5_Msk                       /*!< Page 5 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB6_Pos                   (6UL)
#define FLASH_PRIVBB1R1_PRIVBB6_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB1R1_PRIVBB6                       FLASH_PRIVBB1R1_PRIVBB6_Msk                       /*!< Page 6 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB7_Pos                   (7UL)
#define FLASH_PRIVBB1R1_PRIVBB7_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB1R1_PRIVBB7                       FLASH_PRIVBB1R1_PRIVBB7_Msk                       /*!< Page 7 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB8_Pos                   (8UL)
#define FLASH_PRIVBB1R1_PRIVBB8_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB1R1_PRIVBB8                       FLASH_PRIVBB1R1_PRIVBB8_Msk                       /*!< Page 8 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB9_Pos                   (9UL)
#define FLASH_PRIVBB1R1_PRIVBB9_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIVBB9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB1R1_PRIVBB9                       FLASH_PRIVBB1R1_PRIVBB9_Msk                       /*!< Page 9 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB10_Pos                  (10UL)
#define FLASH_PRIVBB1R1_PRIVBB10_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB1R1_PRIVBB10                      FLASH_PRIVBB1R1_PRIVBB10_Msk                      /*!< Page 10 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB11_Pos                  (11UL)
#define FLASH_PRIVBB1R1_PRIVBB11_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB1R1_PRIVBB11                      FLASH_PRIVBB1R1_PRIVBB11_Msk                      /*!< Page 11 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB12_Pos                  (12UL)
#define FLASH_PRIVBB1R1_PRIVBB12_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB1R1_PRIVBB12                      FLASH_PRIVBB1R1_PRIVBB12_Msk                      /*!< Page 12 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB13_Pos                  (13UL)
#define FLASH_PRIVBB1R1_PRIVBB13_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB1R1_PRIVBB13                      FLASH_PRIVBB1R1_PRIVBB13_Msk                      /*!< Page 13 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB14_Pos                  (14UL)
#define FLASH_PRIVBB1R1_PRIVBB14_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB1R1_PRIVBB14                      FLASH_PRIVBB1R1_PRIVBB14_Msk                      /*!< Page 14 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB15_Pos                  (15UL)
#define FLASH_PRIVBB1R1_PRIVBB15_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB1R1_PRIVBB15                      FLASH_PRIVBB1R1_PRIVBB15_Msk                      /*!< Page 15 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB16_Pos                  (16UL)
#define FLASH_PRIVBB1R1_PRIVBB16_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB1R1_PRIVBB16                      FLASH_PRIVBB1R1_PRIVBB16_Msk                      /*!< Page 16 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB17_Pos                  (17UL)
#define FLASH_PRIVBB1R1_PRIVBB17_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB1R1_PRIVBB17                      FLASH_PRIVBB1R1_PRIVBB17_Msk                      /*!< Page 17 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB18_Pos                  (18UL)
#define FLASH_PRIVBB1R1_PRIVBB18_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB1R1_PRIVBB18                      FLASH_PRIVBB1R1_PRIVBB18_Msk                      /*!< Page 18 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB19_Pos                  (19UL)
#define FLASH_PRIVBB1R1_PRIVBB19_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB1R1_PRIVBB19                      FLASH_PRIVBB1R1_PRIVBB19_Msk                      /*!< Page 19 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB20_Pos                  (20UL)
#define FLASH_PRIVBB1R1_PRIVBB20_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB1R1_PRIVBB20                      FLASH_PRIVBB1R1_PRIVBB20_Msk                      /*!< Page 20 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB21_Pos                  (21UL)
#define FLASH_PRIVBB1R1_PRIVBB21_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB1R1_PRIVBB21                      FLASH_PRIVBB1R1_PRIVBB21_Msk                      /*!< Page 21 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB22_Pos                  (22UL)
#define FLASH_PRIVBB1R1_PRIVBB22_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB1R1_PRIVBB22                      FLASH_PRIVBB1R1_PRIVBB22_Msk                      /*!< Page 22 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB23_Pos                  (23UL)
#define FLASH_PRIVBB1R1_PRIVBB23_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB1R1_PRIVBB23                      FLASH_PRIVBB1R1_PRIVBB23_Msk                      /*!< Page 23 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB24_Pos                  (24UL)
#define FLASH_PRIVBB1R1_PRIVBB24_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB1R1_PRIVBB24                      FLASH_PRIVBB1R1_PRIVBB24_Msk                      /*!< Page 24 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB25_Pos                  (25UL)
#define FLASH_PRIVBB1R1_PRIVBB25_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB1R1_PRIVBB25                      FLASH_PRIVBB1R1_PRIVBB25_Msk                      /*!< Page 25 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB26_Pos                  (26UL)
#define FLASH_PRIVBB1R1_PRIVBB26_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB1R1_PRIVBB26                      FLASH_PRIVBB1R1_PRIVBB26_Msk                      /*!< Page 26 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB27_Pos                  (27UL)
#define FLASH_PRIVBB1R1_PRIVBB27_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB1R1_PRIVBB27                      FLASH_PRIVBB1R1_PRIVBB27_Msk                      /*!< Page 27 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB28_Pos                  (28UL)
#define FLASH_PRIVBB1R1_PRIVBB28_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB1R1_PRIVBB28                      FLASH_PRIVBB1R1_PRIVBB28_Msk                      /*!< Page 28 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB29_Pos                  (29UL)
#define FLASH_PRIVBB1R1_PRIVBB29_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB1R1_PRIVBB29                      FLASH_PRIVBB1R1_PRIVBB29_Msk                      /*!< Page 29 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB30_Pos                  (30UL)
#define FLASH_PRIVBB1R1_PRIVBB30_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB1R1_PRIVBB30                      FLASH_PRIVBB1R1_PRIVBB30_Msk                      /*!< Page 30 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R1_PRIVBB31_Pos                  (31UL)
#define FLASH_PRIVBB1R1_PRIVBB31_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIVBB31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB1R1_PRIVBB31                      FLASH_PRIVBB1R1_PRIVBB31_Msk                      /*!< Page 31 in Flash bank 1 only accessible by privileged access */

/*******************  Bit definition for FLASH_PRIVBB1R2 register  ******************/
#define FLASH_PRIVBB1R2_PRIVBB0_Pos                   (0UL)
#define FLASH_PRIVBB1R2_PRIVBB0_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB1R2_PRIVBB0                       FLASH_PRIVBB1R2_PRIVBB0_Msk                       /*!< Page 32 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB1_Pos                   (1UL)
#define FLASH_PRIVBB1R2_PRIVBB1_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB1R2_PRIVBB1                       FLASH_PRIVBB1R2_PRIVBB1_Msk                       /*!< Page 33 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB2_Pos                   (2UL)
#define FLASH_PRIVBB1R2_PRIVBB2_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB1R2_PRIVBB2                       FLASH_PRIVBB1R2_PRIVBB2_Msk                       /*!< Page 34 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB3_Pos                   (3UL)
#define FLASH_PRIVBB1R2_PRIVBB3_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB1R2_PRIVBB3                       FLASH_PRIVBB1R2_PRIVBB3_Msk                       /*!< Page 35 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB4_Pos                   (4UL)
#define FLASH_PRIVBB1R2_PRIVBB4_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB1R2_PRIVBB4                       FLASH_PRIVBB1R2_PRIVBB4_Msk                       /*!< Page 36 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB5_Pos                   (5UL)
#define FLASH_PRIVBB1R2_PRIVBB5_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB1R2_PRIVBB5                       FLASH_PRIVBB1R2_PRIVBB5_Msk                       /*!< Page 37 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB6_Pos                   (6UL)
#define FLASH_PRIVBB1R2_PRIVBB6_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB1R2_PRIVBB6                       FLASH_PRIVBB1R2_PRIVBB6_Msk                       /*!< Page 38 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB7_Pos                   (7UL)
#define FLASH_PRIVBB1R2_PRIVBB7_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB1R2_PRIVBB7                       FLASH_PRIVBB1R2_PRIVBB7_Msk                       /*!< Page 39 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB8_Pos                   (8UL)
#define FLASH_PRIVBB1R2_PRIVBB8_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB1R2_PRIVBB8                       FLASH_PRIVBB1R2_PRIVBB8_Msk                       /*!< Page 40 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB9_Pos                   (9UL)
#define FLASH_PRIVBB1R2_PRIVBB9_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIVBB9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB1R2_PRIVBB9                       FLASH_PRIVBB1R2_PRIVBB9_Msk                       /*!< Page 41 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB10_Pos                  (10UL)
#define FLASH_PRIVBB1R2_PRIVBB10_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB1R2_PRIVBB10                      FLASH_PRIVBB1R2_PRIVBB10_Msk                      /*!< Page 42 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB11_Pos                  (11UL)
#define FLASH_PRIVBB1R2_PRIVBB11_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB1R2_PRIVBB11                      FLASH_PRIVBB1R2_PRIVBB11_Msk                      /*!< Page 43 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB12_Pos                  (12UL)
#define FLASH_PRIVBB1R2_PRIVBB12_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB1R2_PRIVBB12                      FLASH_PRIVBB1R2_PRIVBB12_Msk                      /*!< Page 44 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB13_Pos                  (13UL)
#define FLASH_PRIVBB1R2_PRIVBB13_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB1R2_PRIVBB13                      FLASH_PRIVBB1R2_PRIVBB13_Msk                      /*!< Page 45 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB14_Pos                  (14UL)
#define FLASH_PRIVBB1R2_PRIVBB14_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB1R2_PRIVBB14                      FLASH_PRIVBB1R2_PRIVBB14_Msk                      /*!< Page 46 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB15_Pos                  (15UL)
#define FLASH_PRIVBB1R2_PRIVBB15_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB1R2_PRIVBB15                      FLASH_PRIVBB1R2_PRIVBB15_Msk                      /*!< Page 47 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB16_Pos                  (16UL)
#define FLASH_PRIVBB1R2_PRIVBB16_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB1R2_PRIVBB16                      FLASH_PRIVBB1R2_PRIVBB16_Msk                      /*!< Page 48 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB17_Pos                  (17UL)
#define FLASH_PRIVBB1R2_PRIVBB17_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB1R2_PRIVBB17                      FLASH_PRIVBB1R2_PRIVBB17_Msk                      /*!< Page 49 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB18_Pos                  (18UL)
#define FLASH_PRIVBB1R2_PRIVBB18_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB1R2_PRIVBB18                      FLASH_PRIVBB1R2_PRIVBB18_Msk                      /*!< Page 50 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB19_Pos                  (19UL)
#define FLASH_PRIVBB1R2_PRIVBB19_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB1R2_PRIVBB19                      FLASH_PRIVBB1R2_PRIVBB19_Msk                      /*!< Page 51 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB20_Pos                  (20UL)
#define FLASH_PRIVBB1R2_PRIVBB20_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB1R2_PRIVBB20                      FLASH_PRIVBB1R2_PRIVBB20_Msk                      /*!< Page 52 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB21_Pos                  (21UL)
#define FLASH_PRIVBB1R2_PRIVBB21_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB1R2_PRIVBB21                      FLASH_PRIVBB1R2_PRIVBB21_Msk                      /*!< Page 53 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB22_Pos                  (22UL)
#define FLASH_PRIVBB1R2_PRIVBB22_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB1R2_PRIVBB22                      FLASH_PRIVBB1R2_PRIVBB22_Msk                      /*!< Page 54 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB23_Pos                  (23UL)
#define FLASH_PRIVBB1R2_PRIVBB23_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB1R2_PRIVBB23                      FLASH_PRIVBB1R2_PRIVBB23_Msk                      /*!< Page 55 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB24_Pos                  (24UL)
#define FLASH_PRIVBB1R2_PRIVBB24_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB1R2_PRIVBB24                      FLASH_PRIVBB1R2_PRIVBB24_Msk                      /*!< Page 56 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB25_Pos                  (25UL)
#define FLASH_PRIVBB1R2_PRIVBB25_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB1R2_PRIVBB25                      FLASH_PRIVBB1R2_PRIVBB25_Msk                      /*!< Page 57 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB26_Pos                  (26UL)
#define FLASH_PRIVBB1R2_PRIVBB26_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB1R2_PRIVBB26                      FLASH_PRIVBB1R2_PRIVBB26_Msk                      /*!< Page 58 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB27_Pos                  (27UL)
#define FLASH_PRIVBB1R2_PRIVBB27_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB1R2_PRIVBB27                      FLASH_PRIVBB1R2_PRIVBB27_Msk                      /*!< Page 59 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB28_Pos                  (28UL)
#define FLASH_PRIVBB1R2_PRIVBB28_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB1R2_PRIVBB28                      FLASH_PRIVBB1R2_PRIVBB28_Msk                      /*!< Page 60 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB29_Pos                  (29UL)
#define FLASH_PRIVBB1R2_PRIVBB29_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB1R2_PRIVBB29                      FLASH_PRIVBB1R2_PRIVBB29_Msk                      /*!< Page 61 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB30_Pos                  (30UL)
#define FLASH_PRIVBB1R2_PRIVBB30_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB1R2_PRIVBB30                      FLASH_PRIVBB1R2_PRIVBB30_Msk                      /*!< Page 62 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R2_PRIVBB31_Pos                  (31UL)
#define FLASH_PRIVBB1R2_PRIVBB31_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIVBB31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB1R2_PRIVBB31                      FLASH_PRIVBB1R2_PRIVBB31_Msk                      /*!< Page 63 in Flash bank 1 only accessible by privileged access */

/*******************  Bit definition for FLASH_PRIVBB1R3 register  ******************/
#define FLASH_PRIVBB1R3_PRIVBB0_Pos                   (0UL)
#define FLASH_PRIVBB1R3_PRIVBB0_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB1R3_PRIVBB0                       FLASH_PRIVBB1R3_PRIVBB0_Msk                       /*!< Page 64 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB1_Pos                   (1UL)
#define FLASH_PRIVBB1R3_PRIVBB1_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB1R3_PRIVBB1                       FLASH_PRIVBB1R3_PRIVBB1_Msk                       /*!< Page 65 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB2_Pos                   (2UL)
#define FLASH_PRIVBB1R3_PRIVBB2_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB1R3_PRIVBB2                       FLASH_PRIVBB1R3_PRIVBB2_Msk                       /*!< Page 66 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB3_Pos                   (3UL)
#define FLASH_PRIVBB1R3_PRIVBB3_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB1R3_PRIVBB3                       FLASH_PRIVBB1R3_PRIVBB3_Msk                       /*!< Page 67 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB4_Pos                   (4UL)
#define FLASH_PRIVBB1R3_PRIVBB4_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB1R3_PRIVBB4                       FLASH_PRIVBB1R3_PRIVBB4_Msk                       /*!< Page 68 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB5_Pos                   (5UL)
#define FLASH_PRIVBB1R3_PRIVBB5_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB1R3_PRIVBB5                       FLASH_PRIVBB1R3_PRIVBB5_Msk                       /*!< Page 69 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB6_Pos                   (6UL)
#define FLASH_PRIVBB1R3_PRIVBB6_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB1R3_PRIVBB6                       FLASH_PRIVBB1R3_PRIVBB6_Msk                       /*!< Page 70 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB7_Pos                   (7UL)
#define FLASH_PRIVBB1R3_PRIVBB7_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB1R3_PRIVBB7                       FLASH_PRIVBB1R3_PRIVBB7_Msk                       /*!< Page 71 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB8_Pos                   (8UL)
#define FLASH_PRIVBB1R3_PRIVBB8_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB1R3_PRIVBB8                       FLASH_PRIVBB1R3_PRIVBB8_Msk                       /*!< Page 72 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB9_Pos                   (9UL)
#define FLASH_PRIVBB1R3_PRIVBB9_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIVBB9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB1R3_PRIVBB9                       FLASH_PRIVBB1R3_PRIVBB9_Msk                       /*!< Page 73 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB10_Pos                  (10UL)
#define FLASH_PRIVBB1R3_PRIVBB10_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB1R3_PRIVBB10                      FLASH_PRIVBB1R3_PRIVBB10_Msk                      /*!< Page 74 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB11_Pos                  (11UL)
#define FLASH_PRIVBB1R3_PRIVBB11_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB1R3_PRIVBB11                      FLASH_PRIVBB1R3_PRIVBB11_Msk                      /*!< Page 75 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB12_Pos                  (12UL)
#define FLASH_PRIVBB1R3_PRIVBB12_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB1R3_PRIVBB12                      FLASH_PRIVBB1R3_PRIVBB12_Msk                      /*!< Page 76 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB13_Pos                  (13UL)
#define FLASH_PRIVBB1R3_PRIVBB13_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB1R3_PRIVBB13                      FLASH_PRIVBB1R3_PRIVBB13_Msk                      /*!< Page 77 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB14_Pos                  (14UL)
#define FLASH_PRIVBB1R3_PRIVBB14_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB1R3_PRIVBB14                      FLASH_PRIVBB1R3_PRIVBB14_Msk                      /*!< Page 78 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB15_Pos                  (15UL)
#define FLASH_PRIVBB1R3_PRIVBB15_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB1R3_PRIVBB15                      FLASH_PRIVBB1R3_PRIVBB15_Msk                      /*!< Page 79 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB16_Pos                  (16UL)
#define FLASH_PRIVBB1R3_PRIVBB16_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB1R3_PRIVBB16                      FLASH_PRIVBB1R3_PRIVBB16_Msk                      /*!< Page 80 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB17_Pos                  (17UL)
#define FLASH_PRIVBB1R3_PRIVBB17_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB1R3_PRIVBB17                      FLASH_PRIVBB1R3_PRIVBB17_Msk                      /*!< Page 81 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB18_Pos                  (18UL)
#define FLASH_PRIVBB1R3_PRIVBB18_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB1R3_PRIVBB18                      FLASH_PRIVBB1R3_PRIVBB18_Msk                      /*!< Page 82 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB19_Pos                  (19UL)
#define FLASH_PRIVBB1R3_PRIVBB19_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB1R3_PRIVBB19                      FLASH_PRIVBB1R3_PRIVBB19_Msk                      /*!< Page 83 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB20_Pos                  (20UL)
#define FLASH_PRIVBB1R3_PRIVBB20_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB1R3_PRIVBB20                      FLASH_PRIVBB1R3_PRIVBB20_Msk                      /*!< Page 84 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB21_Pos                  (21UL)
#define FLASH_PRIVBB1R3_PRIVBB21_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB1R3_PRIVBB21                      FLASH_PRIVBB1R3_PRIVBB21_Msk                      /*!< Page 85 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB22_Pos                  (22UL)
#define FLASH_PRIVBB1R3_PRIVBB22_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB1R3_PRIVBB22                      FLASH_PRIVBB1R3_PRIVBB22_Msk                      /*!< Page 86 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB23_Pos                  (23UL)
#define FLASH_PRIVBB1R3_PRIVBB23_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB1R3_PRIVBB23                      FLASH_PRIVBB1R3_PRIVBB23_Msk                      /*!< Page 87 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB24_Pos                  (24UL)
#define FLASH_PRIVBB1R3_PRIVBB24_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB1R3_PRIVBB24                      FLASH_PRIVBB1R3_PRIVBB24_Msk                      /*!< Page 88 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB25_Pos                  (25UL)
#define FLASH_PRIVBB1R3_PRIVBB25_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB1R3_PRIVBB25                      FLASH_PRIVBB1R3_PRIVBB25_Msk                      /*!< Page 89 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB26_Pos                  (26UL)
#define FLASH_PRIVBB1R3_PRIVBB26_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB1R3_PRIVBB26                      FLASH_PRIVBB1R3_PRIVBB26_Msk                      /*!< Page 90 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB27_Pos                  (27UL)
#define FLASH_PRIVBB1R3_PRIVBB27_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB1R3_PRIVBB27                      FLASH_PRIVBB1R3_PRIVBB27_Msk                      /*!< Page 91 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB28_Pos                  (28UL)
#define FLASH_PRIVBB1R3_PRIVBB28_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB1R3_PRIVBB28                      FLASH_PRIVBB1R3_PRIVBB28_Msk                      /*!< Page 92 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB29_Pos                  (29UL)
#define FLASH_PRIVBB1R3_PRIVBB29_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB1R3_PRIVBB29                      FLASH_PRIVBB1R3_PRIVBB29_Msk                      /*!< Page 93 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB30_Pos                  (30UL)
#define FLASH_PRIVBB1R3_PRIVBB30_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB1R3_PRIVBB30                      FLASH_PRIVBB1R3_PRIVBB30_Msk                      /*!< Page 94 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R3_PRIVBB31_Pos                  (31UL)
#define FLASH_PRIVBB1R3_PRIVBB31_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIVBB31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB1R3_PRIVBB31                      FLASH_PRIVBB1R3_PRIVBB31_Msk                      /*!< Page 95 in Flash bank 1 only accessible by privileged access */

/*******************  Bit definition for FLASH_PRIVBB1R4 register  ******************/
#define FLASH_PRIVBB1R4_PRIVBB0_Pos                   (0UL)
#define FLASH_PRIVBB1R4_PRIVBB0_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB1R4_PRIVBB0                       FLASH_PRIVBB1R4_PRIVBB0_Msk                       /*!< Page 96 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB1_Pos                   (1UL)
#define FLASH_PRIVBB1R4_PRIVBB1_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB1R4_PRIVBB1                       FLASH_PRIVBB1R4_PRIVBB1_Msk                       /*!< Page 97 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB2_Pos                   (2UL)
#define FLASH_PRIVBB1R4_PRIVBB2_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB1R4_PRIVBB2                       FLASH_PRIVBB1R4_PRIVBB2_Msk                       /*!< Page 98 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB3_Pos                   (3UL)
#define FLASH_PRIVBB1R4_PRIVBB3_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB1R4_PRIVBB3                       FLASH_PRIVBB1R4_PRIVBB3_Msk                       /*!< Page 99 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB4_Pos                   (4UL)
#define FLASH_PRIVBB1R4_PRIVBB4_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB1R4_PRIVBB4                       FLASH_PRIVBB1R4_PRIVBB4_Msk                       /*!< Page 100 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB5_Pos                   (5UL)
#define FLASH_PRIVBB1R4_PRIVBB5_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB1R4_PRIVBB5                       FLASH_PRIVBB1R4_PRIVBB5_Msk                       /*!< Page 101 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB6_Pos                   (6UL)
#define FLASH_PRIVBB1R4_PRIVBB6_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB1R4_PRIVBB6                       FLASH_PRIVBB1R4_PRIVBB6_Msk                       /*!< Page 102 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB7_Pos                   (7UL)
#define FLASH_PRIVBB1R4_PRIVBB7_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB1R4_PRIVBB7                       FLASH_PRIVBB1R4_PRIVBB7_Msk                       /*!< Page 103 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB8_Pos                   (8UL)
#define FLASH_PRIVBB1R4_PRIVBB8_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB1R4_PRIVBB8                       FLASH_PRIVBB1R4_PRIVBB8_Msk                       /*!< Page 104 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB9_Pos                   (9UL)
#define FLASH_PRIVBB1R4_PRIVBB9_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIVBB9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB1R4_PRIVBB9                       FLASH_PRIVBB1R4_PRIVBB9_Msk                       /*!< Page 105 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB10_Pos                  (10UL)
#define FLASH_PRIVBB1R4_PRIVBB10_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB1R4_PRIVBB10                      FLASH_PRIVBB1R4_PRIVBB10_Msk                      /*!< Page 106 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB11_Pos                  (11UL)
#define FLASH_PRIVBB1R4_PRIVBB11_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB1R4_PRIVBB11                      FLASH_PRIVBB1R4_PRIVBB11_Msk                      /*!< Page 107 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB12_Pos                  (12UL)
#define FLASH_PRIVBB1R4_PRIVBB12_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB1R4_PRIVBB12                      FLASH_PRIVBB1R4_PRIVBB12_Msk                      /*!< Page 108 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB13_Pos                  (13UL)
#define FLASH_PRIVBB1R4_PRIVBB13_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB1R4_PRIVBB13                      FLASH_PRIVBB1R4_PRIVBB13_Msk                      /*!< Page 109 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB14_Pos                  (14UL)
#define FLASH_PRIVBB1R4_PRIVBB14_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB1R4_PRIVBB14                      FLASH_PRIVBB1R4_PRIVBB14_Msk                      /*!< Page 110 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB15_Pos                  (15UL)
#define FLASH_PRIVBB1R4_PRIVBB15_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB1R4_PRIVBB15                      FLASH_PRIVBB1R4_PRIVBB15_Msk                      /*!< Page 111 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB16_Pos                  (16UL)
#define FLASH_PRIVBB1R4_PRIVBB16_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB1R4_PRIVBB16                      FLASH_PRIVBB1R4_PRIVBB16_Msk                      /*!< Page 112 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB17_Pos                  (17UL)
#define FLASH_PRIVBB1R4_PRIVBB17_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB1R4_PRIVBB17                      FLASH_PRIVBB1R4_PRIVBB17_Msk                      /*!< Page 113 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB18_Pos                  (18UL)
#define FLASH_PRIVBB1R4_PRIVBB18_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB1R4_PRIVBB18                      FLASH_PRIVBB1R4_PRIVBB18_Msk                      /*!< Page 114 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB19_Pos                  (19UL)
#define FLASH_PRIVBB1R4_PRIVBB19_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB1R4_PRIVBB19                      FLASH_PRIVBB1R4_PRIVBB19_Msk                      /*!< Page 115 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB20_Pos                  (20UL)
#define FLASH_PRIVBB1R4_PRIVBB20_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB1R4_PRIVBB20                      FLASH_PRIVBB1R4_PRIVBB20_Msk                      /*!< Page 116 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB21_Pos                  (21UL)
#define FLASH_PRIVBB1R4_PRIVBB21_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB1R4_PRIVBB21                      FLASH_PRIVBB1R4_PRIVBB21_Msk                      /*!< Page 117 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB22_Pos                  (22UL)
#define FLASH_PRIVBB1R4_PRIVBB22_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB1R4_PRIVBB22                      FLASH_PRIVBB1R4_PRIVBB22_Msk                      /*!< Page 118 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB23_Pos                  (23UL)
#define FLASH_PRIVBB1R4_PRIVBB23_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB1R4_PRIVBB23                      FLASH_PRIVBB1R4_PRIVBB23_Msk                      /*!< Page 119 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB24_Pos                  (24UL)
#define FLASH_PRIVBB1R4_PRIVBB24_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB1R4_PRIVBB24                      FLASH_PRIVBB1R4_PRIVBB24_Msk                      /*!< Page 120 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB25_Pos                  (25UL)
#define FLASH_PRIVBB1R4_PRIVBB25_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB1R4_PRIVBB25                      FLASH_PRIVBB1R4_PRIVBB25_Msk                      /*!< Page 121 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB26_Pos                  (26UL)
#define FLASH_PRIVBB1R4_PRIVBB26_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB1R4_PRIVBB26                      FLASH_PRIVBB1R4_PRIVBB26_Msk                      /*!< Page 122 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB27_Pos                  (27UL)
#define FLASH_PRIVBB1R4_PRIVBB27_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB1R4_PRIVBB27                      FLASH_PRIVBB1R4_PRIVBB27_Msk                      /*!< Page 123 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB28_Pos                  (28UL)
#define FLASH_PRIVBB1R4_PRIVBB28_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB1R4_PRIVBB28                      FLASH_PRIVBB1R4_PRIVBB28_Msk                      /*!< Page 124 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB29_Pos                  (29UL)
#define FLASH_PRIVBB1R4_PRIVBB29_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB1R4_PRIVBB29                      FLASH_PRIVBB1R4_PRIVBB29_Msk                      /*!< Page 125 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB30_Pos                  (30UL)
#define FLASH_PRIVBB1R4_PRIVBB30_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB1R4_PRIVBB30                      FLASH_PRIVBB1R4_PRIVBB30_Msk                      /*!< Page 126 in Flash bank 1 only accessible by privileged access */
#define FLASH_PRIVBB1R4_PRIVBB31_Pos                  (31UL)
#define FLASH_PRIVBB1R4_PRIVBB31_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIVBB31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB1R4_PRIVBB31                      FLASH_PRIVBB1R4_PRIVBB31_Msk                      /*!< Page 127 in Flash bank 1 only accessible by privileged access */

/*******************  Bit definition for FLASH_PRIVBB2R1 register  ******************/
#define FLASH_PRIVBB2R1_PRIVBB0_Pos                   (0UL)
#define FLASH_PRIVBB2R1_PRIVBB0_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB2R1_PRIVBB0                       FLASH_PRIVBB2R1_PRIVBB0_Msk                       /*!< Page 0 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB1_Pos                   (1UL)
#define FLASH_PRIVBB2R1_PRIVBB1_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB2R1_PRIVBB1                       FLASH_PRIVBB2R1_PRIVBB1_Msk                       /*!< Page 1 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB2_Pos                   (2UL)
#define FLASH_PRIVBB2R1_PRIVBB2_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB2R1_PRIVBB2                       FLASH_PRIVBB2R1_PRIVBB2_Msk                       /*!< Page 2 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB3_Pos                   (3UL)
#define FLASH_PRIVBB2R1_PRIVBB3_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB2R1_PRIVBB3                       FLASH_PRIVBB2R1_PRIVBB3_Msk                       /*!< Page 3 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB4_Pos                   (4UL)
#define FLASH_PRIVBB2R1_PRIVBB4_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB2R1_PRIVBB4                       FLASH_PRIVBB2R1_PRIVBB4_Msk                       /*!< Page 4 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB5_Pos                   (5UL)
#define FLASH_PRIVBB2R1_PRIVBB5_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB2R1_PRIVBB5                       FLASH_PRIVBB2R1_PRIVBB5_Msk                       /*!< Page 5 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB6_Pos                   (6UL)
#define FLASH_PRIVBB2R1_PRIVBB6_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB2R1_PRIVBB6                       FLASH_PRIVBB2R1_PRIVBB6_Msk                       /*!< Page 6 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB7_Pos                   (7UL)
#define FLASH_PRIVBB2R1_PRIVBB7_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB2R1_PRIVBB7                       FLASH_PRIVBB2R1_PRIVBB7_Msk                       /*!< Page 7 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB8_Pos                   (8UL)
#define FLASH_PRIVBB2R1_PRIVBB8_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB2R1_PRIVBB8                       FLASH_PRIVBB2R1_PRIVBB8_Msk                       /*!< Page 8 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB9_Pos                   (9UL)
#define FLASH_PRIVBB2R1_PRIVBB9_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIVBB9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB2R1_PRIVBB9                       FLASH_PRIVBB2R1_PRIVBB9_Msk                       /*!< Page 9 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB10_Pos                  (10UL)
#define FLASH_PRIVBB2R1_PRIVBB10_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB2R1_PRIVBB10                      FLASH_PRIVBB2R1_PRIVBB10_Msk                      /*!< Page 10 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB11_Pos                  (11UL)
#define FLASH_PRIVBB2R1_PRIVBB11_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB2R1_PRIVBB11                      FLASH_PRIVBB2R1_PRIVBB11_Msk                      /*!< Page 11 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB12_Pos                  (12UL)
#define FLASH_PRIVBB2R1_PRIVBB12_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB2R1_PRIVBB12                      FLASH_PRIVBB2R1_PRIVBB12_Msk                      /*!< Page 12 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB13_Pos                  (13UL)
#define FLASH_PRIVBB2R1_PRIVBB13_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB2R1_PRIVBB13                      FLASH_PRIVBB2R1_PRIVBB13_Msk                      /*!< Page 13 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB14_Pos                  (14UL)
#define FLASH_PRIVBB2R1_PRIVBB14_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB2R1_PRIVBB14                      FLASH_PRIVBB2R1_PRIVBB14_Msk                      /*!< Page 14 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB15_Pos                  (15UL)
#define FLASH_PRIVBB2R1_PRIVBB15_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB2R1_PRIVBB15                      FLASH_PRIVBB2R1_PRIVBB15_Msk                      /*!< Page 15 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB16_Pos                  (16UL)
#define FLASH_PRIVBB2R1_PRIVBB16_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB2R1_PRIVBB16                      FLASH_PRIVBB2R1_PRIVBB16_Msk                      /*!< Page 16 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB17_Pos                  (17UL)
#define FLASH_PRIVBB2R1_PRIVBB17_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB2R1_PRIVBB17                      FLASH_PRIVBB2R1_PRIVBB17_Msk                      /*!< Page 17 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB18_Pos                  (18UL)
#define FLASH_PRIVBB2R1_PRIVBB18_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB2R1_PRIVBB18                      FLASH_PRIVBB2R1_PRIVBB18_Msk                      /*!< Page 18 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB19_Pos                  (19UL)
#define FLASH_PRIVBB2R1_PRIVBB19_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB2R1_PRIVBB19                      FLASH_PRIVBB2R1_PRIVBB19_Msk                      /*!< Page 19 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB20_Pos                  (20UL)
#define FLASH_PRIVBB2R1_PRIVBB20_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB2R1_PRIVBB20                      FLASH_PRIVBB2R1_PRIVBB20_Msk                      /*!< Page 20 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB21_Pos                  (21UL)
#define FLASH_PRIVBB2R1_PRIVBB21_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB2R1_PRIVBB21                      FLASH_PRIVBB2R1_PRIVBB21_Msk                      /*!< Page 21 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB22_Pos                  (22UL)
#define FLASH_PRIVBB2R1_PRIVBB22_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB2R1_PRIVBB22                      FLASH_PRIVBB2R1_PRIVBB22_Msk                      /*!< Page 22 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB23_Pos                  (23UL)
#define FLASH_PRIVBB2R1_PRIVBB23_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB2R1_PRIVBB23                      FLASH_PRIVBB2R1_PRIVBB23_Msk                      /*!< Page 23 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB24_Pos                  (24UL)
#define FLASH_PRIVBB2R1_PRIVBB24_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB2R1_PRIVBB24                      FLASH_PRIVBB2R1_PRIVBB24_Msk                      /*!< Page 24 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB25_Pos                  (25UL)
#define FLASH_PRIVBB2R1_PRIVBB25_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB2R1_PRIVBB25                      FLASH_PRIVBB2R1_PRIVBB25_Msk                      /*!< Page 25 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB26_Pos                  (26UL)
#define FLASH_PRIVBB2R1_PRIVBB26_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB2R1_PRIVBB26                      FLASH_PRIVBB2R1_PRIVBB26_Msk                      /*!< Page 26 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB27_Pos                  (27UL)
#define FLASH_PRIVBB2R1_PRIVBB27_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB2R1_PRIVBB27                      FLASH_PRIVBB2R1_PRIVBB27_Msk                      /*!< Page 27 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB28_Pos                  (28UL)
#define FLASH_PRIVBB2R1_PRIVBB28_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB2R1_PRIVBB28                      FLASH_PRIVBB2R1_PRIVBB28_Msk                      /*!< Page 28 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB29_Pos                  (29UL)
#define FLASH_PRIVBB2R1_PRIVBB29_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB2R1_PRIVBB29                      FLASH_PRIVBB2R1_PRIVBB29_Msk                      /*!< Page 29 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB30_Pos                  (30UL)
#define FLASH_PRIVBB2R1_PRIVBB30_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB2R1_PRIVBB30                      FLASH_PRIVBB2R1_PRIVBB30_Msk                      /*!< Page 30 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R1_PRIVBB31_Pos                  (31UL)
#define FLASH_PRIVBB2R1_PRIVBB31_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIVBB31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB2R1_PRIVBB31                      FLASH_PRIVBB2R1_PRIVBB31_Msk                      /*!< Page 31 in Flash bank 2 only accessible by privileged access */

/*******************  Bit definition for FLASH_PRIVBB2R2 register  ******************/
#define FLASH_PRIVBB2R2_PRIVBB0_Pos                   (0UL)
#define FLASH_PRIVBB2R2_PRIVBB0_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB2R2_PRIVBB0                       FLASH_PRIVBB2R2_PRIVBB0_Msk                       /*!< Page 32 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB1_Pos                   (1UL)
#define FLASH_PRIVBB2R2_PRIVBB1_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB2R2_PRIVBB1                       FLASH_PRIVBB2R2_PRIVBB1_Msk                       /*!< Page 33 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB2_Pos                   (2UL)
#define FLASH_PRIVBB2R2_PRIVBB2_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB2R2_PRIVBB2                       FLASH_PRIVBB2R2_PRIVBB2_Msk                       /*!< Page 34 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB3_Pos                   (3UL)
#define FLASH_PRIVBB2R2_PRIVBB3_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB2R2_PRIVBB3                       FLASH_PRIVBB2R2_PRIVBB3_Msk                       /*!< Page 35 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB4_Pos                   (4UL)
#define FLASH_PRIVBB2R2_PRIVBB4_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB2R2_PRIVBB4                       FLASH_PRIVBB2R2_PRIVBB4_Msk                       /*!< Page 36 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB5_Pos                   (5UL)
#define FLASH_PRIVBB2R2_PRIVBB5_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB2R2_PRIVBB5                       FLASH_PRIVBB2R2_PRIVBB5_Msk                       /*!< Page 37 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB6_Pos                   (6UL)
#define FLASH_PRIVBB2R2_PRIVBB6_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB2R2_PRIVBB6                       FLASH_PRIVBB2R2_PRIVBB6_Msk                       /*!< Page 38 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB7_Pos                   (7UL)
#define FLASH_PRIVBB2R2_PRIVBB7_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB2R2_PRIVBB7                       FLASH_PRIVBB2R2_PRIVBB7_Msk                       /*!< Page 39 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB8_Pos                   (8UL)
#define FLASH_PRIVBB2R2_PRIVBB8_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB2R2_PRIVBB8                       FLASH_PRIVBB2R2_PRIVBB8_Msk                       /*!< Page 40 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB9_Pos                   (9UL)
#define FLASH_PRIVBB2R2_PRIVBB9_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIVBB9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB2R2_PRIVBB9                       FLASH_PRIVBB2R2_PRIVBB9_Msk                       /*!< Page 41 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB10_Pos                  (10UL)
#define FLASH_PRIVBB2R2_PRIVBB10_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB2R2_PRIVBB10                      FLASH_PRIVBB2R2_PRIVBB10_Msk                      /*!< Page 42 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB11_Pos                  (11UL)
#define FLASH_PRIVBB2R2_PRIVBB11_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB2R2_PRIVBB11                      FLASH_PRIVBB2R2_PRIVBB11_Msk                      /*!< Page 43 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB12_Pos                  (12UL)
#define FLASH_PRIVBB2R2_PRIVBB12_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB2R2_PRIVBB12                      FLASH_PRIVBB2R2_PRIVBB12_Msk                      /*!< Page 44 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB13_Pos                  (13UL)
#define FLASH_PRIVBB2R2_PRIVBB13_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB2R2_PRIVBB13                      FLASH_PRIVBB2R2_PRIVBB13_Msk                      /*!< Page 45 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB14_Pos                  (14UL)
#define FLASH_PRIVBB2R2_PRIVBB14_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB2R2_PRIVBB14                      FLASH_PRIVBB2R2_PRIVBB14_Msk                      /*!< Page 46 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB15_Pos                  (15UL)
#define FLASH_PRIVBB2R2_PRIVBB15_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB2R2_PRIVBB15                      FLASH_PRIVBB2R2_PRIVBB15_Msk                      /*!< Page 47 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB16_Pos                  (16UL)
#define FLASH_PRIVBB2R2_PRIVBB16_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB2R2_PRIVBB16                      FLASH_PRIVBB2R2_PRIVBB16_Msk                      /*!< Page 48 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB17_Pos                  (17UL)
#define FLASH_PRIVBB2R2_PRIVBB17_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB2R2_PRIVBB17                      FLASH_PRIVBB2R2_PRIVBB17_Msk                      /*!< Page 49 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB18_Pos                  (18UL)
#define FLASH_PRIVBB2R2_PRIVBB18_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB2R2_PRIVBB18                      FLASH_PRIVBB2R2_PRIVBB18_Msk                      /*!< Page 50 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB19_Pos                  (19UL)
#define FLASH_PRIVBB2R2_PRIVBB19_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB2R2_PRIVBB19                      FLASH_PRIVBB2R2_PRIVBB19_Msk                      /*!< Page 51 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB20_Pos                  (20UL)
#define FLASH_PRIVBB2R2_PRIVBB20_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB2R2_PRIVBB20                      FLASH_PRIVBB2R2_PRIVBB20_Msk                      /*!< Page 52 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB21_Pos                  (21UL)
#define FLASH_PRIVBB2R2_PRIVBB21_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB2R2_PRIVBB21                      FLASH_PRIVBB2R2_PRIVBB21_Msk                      /*!< Page 53 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB22_Pos                  (22UL)
#define FLASH_PRIVBB2R2_PRIVBB22_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB2R2_PRIVBB22                      FLASH_PRIVBB2R2_PRIVBB22_Msk                      /*!< Page 54 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB23_Pos                  (23UL)
#define FLASH_PRIVBB2R2_PRIVBB23_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB2R2_PRIVBB23                      FLASH_PRIVBB2R2_PRIVBB23_Msk                      /*!< Page 55 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB24_Pos                  (24UL)
#define FLASH_PRIVBB2R2_PRIVBB24_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB2R2_PRIVBB24                      FLASH_PRIVBB2R2_PRIVBB24_Msk                      /*!< Page 56 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB25_Pos                  (25UL)
#define FLASH_PRIVBB2R2_PRIVBB25_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB2R2_PRIVBB25                      FLASH_PRIVBB2R2_PRIVBB25_Msk                      /*!< Page 57 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB26_Pos                  (26UL)
#define FLASH_PRIVBB2R2_PRIVBB26_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB2R2_PRIVBB26                      FLASH_PRIVBB2R2_PRIVBB26_Msk                      /*!< Page 58 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB27_Pos                  (27UL)
#define FLASH_PRIVBB2R2_PRIVBB27_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB2R2_PRIVBB27                      FLASH_PRIVBB2R2_PRIVBB27_Msk                      /*!< Page 59 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB28_Pos                  (28UL)
#define FLASH_PRIVBB2R2_PRIVBB28_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB2R2_PRIVBB28                      FLASH_PRIVBB2R2_PRIVBB28_Msk                      /*!< Page 60 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB29_Pos                  (29UL)
#define FLASH_PRIVBB2R2_PRIVBB29_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB2R2_PRIVBB29                      FLASH_PRIVBB2R2_PRIVBB29_Msk                      /*!< Page 61 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB30_Pos                  (30UL)
#define FLASH_PRIVBB2R2_PRIVBB30_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB2R2_PRIVBB30                      FLASH_PRIVBB2R2_PRIVBB30_Msk                      /*!< Page 62 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R2_PRIVBB31_Pos                  (31UL)
#define FLASH_PRIVBB2R2_PRIVBB31_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIVBB31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB2R2_PRIVBB31                      FLASH_PRIVBB2R2_PRIVBB31_Msk                      /*!< Page 63 in Flash bank 2 only accessible by privileged access */

/*******************  Bit definition for FLASH_PRIVBB2R3 register  ******************/
#define FLASH_PRIVBB2R3_PRIVBB0_Pos                   (0UL)
#define FLASH_PRIVBB2R3_PRIVBB0_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB2R3_PRIVBB0                       FLASH_PRIVBB2R3_PRIVBB0_Msk                       /*!< Page 64 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB1_Pos                   (1UL)
#define FLASH_PRIVBB2R3_PRIVBB1_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB2R3_PRIVBB1                       FLASH_PRIVBB2R3_PRIVBB1_Msk                       /*!< Page 65 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB2_Pos                   (2UL)
#define FLASH_PRIVBB2R3_PRIVBB2_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB2R3_PRIVBB2                       FLASH_PRIVBB2R3_PRIVBB2_Msk                       /*!< Page 66 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB3_Pos                   (3UL)
#define FLASH_PRIVBB2R3_PRIVBB3_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB2R3_PRIVBB3                       FLASH_PRIVBB2R3_PRIVBB3_Msk                       /*!< Page 67 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB4_Pos                   (4UL)
#define FLASH_PRIVBB2R3_PRIVBB4_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB2R3_PRIVBB4                       FLASH_PRIVBB2R3_PRIVBB4_Msk                       /*!< Page 68 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB5_Pos                   (5UL)
#define FLASH_PRIVBB2R3_PRIVBB5_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB2R3_PRIVBB5                       FLASH_PRIVBB2R3_PRIVBB5_Msk                       /*!< Page 69 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB6_Pos                   (6UL)
#define FLASH_PRIVBB2R3_PRIVBB6_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB2R3_PRIVBB6                       FLASH_PRIVBB2R3_PRIVBB6_Msk                       /*!< Page 70 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB7_Pos                   (7UL)
#define FLASH_PRIVBB2R3_PRIVBB7_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB2R3_PRIVBB7                       FLASH_PRIVBB2R3_PRIVBB7_Msk                       /*!< Page 71 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB8_Pos                   (8UL)
#define FLASH_PRIVBB2R3_PRIVBB8_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB2R3_PRIVBB8                       FLASH_PRIVBB2R3_PRIVBB8_Msk                       /*!< Page 72 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB9_Pos                   (9UL)
#define FLASH_PRIVBB2R3_PRIVBB9_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIVBB9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB2R3_PRIVBB9                       FLASH_PRIVBB2R3_PRIVBB9_Msk                       /*!< Page 73 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB10_Pos                  (10UL)
#define FLASH_PRIVBB2R3_PRIVBB10_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB2R3_PRIVBB10                      FLASH_PRIVBB2R3_PRIVBB10_Msk                      /*!< Page 74 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB11_Pos                  (11UL)
#define FLASH_PRIVBB2R3_PRIVBB11_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB2R3_PRIVBB11                      FLASH_PRIVBB2R3_PRIVBB11_Msk                      /*!< Page 75 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB12_Pos                  (12UL)
#define FLASH_PRIVBB2R3_PRIVBB12_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB2R3_PRIVBB12                      FLASH_PRIVBB2R3_PRIVBB12_Msk                      /*!< Page 76 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB13_Pos                  (13UL)
#define FLASH_PRIVBB2R3_PRIVBB13_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB2R3_PRIVBB13                      FLASH_PRIVBB2R3_PRIVBB13_Msk                      /*!< Page 77 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB14_Pos                  (14UL)
#define FLASH_PRIVBB2R3_PRIVBB14_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB2R3_PRIVBB14                      FLASH_PRIVBB2R3_PRIVBB14_Msk                      /*!< Page 78 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB15_Pos                  (15UL)
#define FLASH_PRIVBB2R3_PRIVBB15_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB2R3_PRIVBB15                      FLASH_PRIVBB2R3_PRIVBB15_Msk                      /*!< Page 79 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB16_Pos                  (16UL)
#define FLASH_PRIVBB2R3_PRIVBB16_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB2R3_PRIVBB16                      FLASH_PRIVBB2R3_PRIVBB16_Msk                      /*!< Page 80 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB17_Pos                  (17UL)
#define FLASH_PRIVBB2R3_PRIVBB17_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB2R3_PRIVBB17                      FLASH_PRIVBB2R3_PRIVBB17_Msk                      /*!< Page 81 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB18_Pos                  (18UL)
#define FLASH_PRIVBB2R3_PRIVBB18_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB2R3_PRIVBB18                      FLASH_PRIVBB2R3_PRIVBB18_Msk                      /*!< Page 82 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB19_Pos                  (19UL)
#define FLASH_PRIVBB2R3_PRIVBB19_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB2R3_PRIVBB19                      FLASH_PRIVBB2R3_PRIVBB19_Msk                      /*!< Page 83 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB20_Pos                  (20UL)
#define FLASH_PRIVBB2R3_PRIVBB20_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB2R3_PRIVBB20                      FLASH_PRIVBB2R3_PRIVBB20_Msk                      /*!< Page 84 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB21_Pos                  (21UL)
#define FLASH_PRIVBB2R3_PRIVBB21_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB2R3_PRIVBB21                      FLASH_PRIVBB2R3_PRIVBB21_Msk                      /*!< Page 85 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB22_Pos                  (22UL)
#define FLASH_PRIVBB2R3_PRIVBB22_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB2R3_PRIVBB22                      FLASH_PRIVBB2R3_PRIVBB22_Msk                      /*!< Page 86 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB23_Pos                  (23UL)
#define FLASH_PRIVBB2R3_PRIVBB23_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB2R3_PRIVBB23                      FLASH_PRIVBB2R3_PRIVBB23_Msk                      /*!< Page 87 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB24_Pos                  (24UL)
#define FLASH_PRIVBB2R3_PRIVBB24_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB2R3_PRIVBB24                      FLASH_PRIVBB2R3_PRIVBB24_Msk                      /*!< Page 88 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB25_Pos                  (25UL)
#define FLASH_PRIVBB2R3_PRIVBB25_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB2R3_PRIVBB25                      FLASH_PRIVBB2R3_PRIVBB25_Msk                      /*!< Page 89 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB26_Pos                  (26UL)
#define FLASH_PRIVBB2R3_PRIVBB26_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB2R3_PRIVBB26                      FLASH_PRIVBB2R3_PRIVBB26_Msk                      /*!< Page 90 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB27_Pos                  (27UL)
#define FLASH_PRIVBB2R3_PRIVBB27_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB2R3_PRIVBB27                      FLASH_PRIVBB2R3_PRIVBB27_Msk                      /*!< Page 91 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB28_Pos                  (28UL)
#define FLASH_PRIVBB2R3_PRIVBB28_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB2R3_PRIVBB28                      FLASH_PRIVBB2R3_PRIVBB28_Msk                      /*!< Page 92 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB29_Pos                  (29UL)
#define FLASH_PRIVBB2R3_PRIVBB29_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB2R3_PRIVBB29                      FLASH_PRIVBB2R3_PRIVBB29_Msk                      /*!< Page 93 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB30_Pos                  (30UL)
#define FLASH_PRIVBB2R3_PRIVBB30_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB2R3_PRIVBB30                      FLASH_PRIVBB2R3_PRIVBB30_Msk                      /*!< Page 94 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R3_PRIVBB31_Pos                  (31UL)
#define FLASH_PRIVBB2R3_PRIVBB31_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIVBB31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB2R3_PRIVBB31                      FLASH_PRIVBB2R3_PRIVBB31_Msk                      /*!< Page 95 in Flash bank 2 only accessible by privileged access */

/*******************  Bit definition for FLASH_PRIVBB2R4 register  ******************/
#define FLASH_PRIVBB2R4_PRIVBB0_Pos                   (0UL)
#define FLASH_PRIVBB2R4_PRIVBB0_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB2R4_PRIVBB0                       FLASH_PRIVBB2R4_PRIVBB0_Msk                       /*!< Page 96 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB1_Pos                   (1UL)
#define FLASH_PRIVBB2R4_PRIVBB1_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB2R4_PRIVBB1                       FLASH_PRIVBB2R4_PRIVBB1_Msk                       /*!< Page 97 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB2_Pos                   (2UL)
#define FLASH_PRIVBB2R4_PRIVBB2_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB2R4_PRIVBB2                       FLASH_PRIVBB2R4_PRIVBB2_Msk                       /*!< Page 98 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB3_Pos                   (3UL)
#define FLASH_PRIVBB2R4_PRIVBB3_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB2R4_PRIVBB3                       FLASH_PRIVBB2R4_PRIVBB3_Msk                       /*!< Page 99 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB4_Pos                   (4UL)
#define FLASH_PRIVBB2R4_PRIVBB4_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB2R4_PRIVBB4                       FLASH_PRIVBB2R4_PRIVBB4_Msk                       /*!< Page 100 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB5_Pos                   (5UL)
#define FLASH_PRIVBB2R4_PRIVBB5_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB2R4_PRIVBB5                       FLASH_PRIVBB2R4_PRIVBB5_Msk                       /*!< Page 101 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB6_Pos                   (6UL)
#define FLASH_PRIVBB2R4_PRIVBB6_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB2R4_PRIVBB6                       FLASH_PRIVBB2R4_PRIVBB6_Msk                       /*!< Page 102 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB7_Pos                   (7UL)
#define FLASH_PRIVBB2R4_PRIVBB7_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB2R4_PRIVBB7                       FLASH_PRIVBB2R4_PRIVBB7_Msk                       /*!< Page 103 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB8_Pos                   (8UL)
#define FLASH_PRIVBB2R4_PRIVBB8_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB2R4_PRIVBB8                       FLASH_PRIVBB2R4_PRIVBB8_Msk                       /*!< Page 104 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB9_Pos                   (9UL)
#define FLASH_PRIVBB2R4_PRIVBB9_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIVBB9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB2R4_PRIVBB9                       FLASH_PRIVBB2R4_PRIVBB9_Msk                       /*!< Page 105 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB10_Pos                  (10UL)
#define FLASH_PRIVBB2R4_PRIVBB10_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB2R4_PRIVBB10                      FLASH_PRIVBB2R4_PRIVBB10_Msk                      /*!< Page 106 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB11_Pos                  (11UL)
#define FLASH_PRIVBB2R4_PRIVBB11_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB2R4_PRIVBB11                      FLASH_PRIVBB2R4_PRIVBB11_Msk                      /*!< Page 107 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB12_Pos                  (12UL)
#define FLASH_PRIVBB2R4_PRIVBB12_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB2R4_PRIVBB12                      FLASH_PRIVBB2R4_PRIVBB12_Msk                      /*!< Page 108 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB13_Pos                  (13UL)
#define FLASH_PRIVBB2R4_PRIVBB13_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB2R4_PRIVBB13                      FLASH_PRIVBB2R4_PRIVBB13_Msk                      /*!< Page 109 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB14_Pos                  (14UL)
#define FLASH_PRIVBB2R4_PRIVBB14_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB2R4_PRIVBB14                      FLASH_PRIVBB2R4_PRIVBB14_Msk                      /*!< Page 110 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB15_Pos                  (15UL)
#define FLASH_PRIVBB2R4_PRIVBB15_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB2R4_PRIVBB15                      FLASH_PRIVBB2R4_PRIVBB15_Msk                      /*!< Page 111 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB16_Pos                  (16UL)
#define FLASH_PRIVBB2R4_PRIVBB16_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB2R4_PRIVBB16                      FLASH_PRIVBB2R4_PRIVBB16_Msk                      /*!< Page 112 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB17_Pos                  (17UL)
#define FLASH_PRIVBB2R4_PRIVBB17_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB2R4_PRIVBB17                      FLASH_PRIVBB2R4_PRIVBB17_Msk                      /*!< Page 113 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB18_Pos                  (18UL)
#define FLASH_PRIVBB2R4_PRIVBB18_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB2R4_PRIVBB18                      FLASH_PRIVBB2R4_PRIVBB18_Msk                      /*!< Page 114 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB19_Pos                  (19UL)
#define FLASH_PRIVBB2R4_PRIVBB19_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB2R4_PRIVBB19                      FLASH_PRIVBB2R4_PRIVBB19_Msk                      /*!< Page 115 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB20_Pos                  (20UL)
#define FLASH_PRIVBB2R4_PRIVBB20_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB2R4_PRIVBB20                      FLASH_PRIVBB2R4_PRIVBB20_Msk                      /*!< Page 116 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB21_Pos                  (21UL)
#define FLASH_PRIVBB2R4_PRIVBB21_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB2R4_PRIVBB21                      FLASH_PRIVBB2R4_PRIVBB21_Msk                      /*!< Page 117 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB22_Pos                  (22UL)
#define FLASH_PRIVBB2R4_PRIVBB22_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB2R4_PRIVBB22                      FLASH_PRIVBB2R4_PRIVBB22_Msk                      /*!< Page 118 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB23_Pos                  (23UL)
#define FLASH_PRIVBB2R4_PRIVBB23_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB2R4_PRIVBB23                      FLASH_PRIVBB2R4_PRIVBB23_Msk                      /*!< Page 119 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB24_Pos                  (24UL)
#define FLASH_PRIVBB2R4_PRIVBB24_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB2R4_PRIVBB24                      FLASH_PRIVBB2R4_PRIVBB24_Msk                      /*!< Page 120 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB25_Pos                  (25UL)
#define FLASH_PRIVBB2R4_PRIVBB25_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB2R4_PRIVBB25                      FLASH_PRIVBB2R4_PRIVBB25_Msk                      /*!< Page 121 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB26_Pos                  (26UL)
#define FLASH_PRIVBB2R4_PRIVBB26_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB2R4_PRIVBB26                      FLASH_PRIVBB2R4_PRIVBB26_Msk                      /*!< Page 122 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB27_Pos                  (27UL)
#define FLASH_PRIVBB2R4_PRIVBB27_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB2R4_PRIVBB27                      FLASH_PRIVBB2R4_PRIVBB27_Msk                      /*!< Page 123 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB28_Pos                  (28UL)
#define FLASH_PRIVBB2R4_PRIVBB28_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB2R4_PRIVBB28                      FLASH_PRIVBB2R4_PRIVBB28_Msk                      /*!< Page 124 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB29_Pos                  (29UL)
#define FLASH_PRIVBB2R4_PRIVBB29_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB2R4_PRIVBB29                      FLASH_PRIVBB2R4_PRIVBB29_Msk                      /*!< Page 125 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB30_Pos                  (30UL)
#define FLASH_PRIVBB2R4_PRIVBB30_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB2R4_PRIVBB30                      FLASH_PRIVBB2R4_PRIVBB30_Msk                      /*!< Page 126 in Flash bank 2 only accessible by privileged access */
#define FLASH_PRIVBB2R4_PRIVBB31_Pos                  (31UL)
#define FLASH_PRIVBB2R4_PRIVBB31_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIVBB31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB2R4_PRIVBB31                      FLASH_PRIVBB2R4_PRIVBB31_Msk                      /*!< Page 127 in Flash bank 2 only accessible by privileged access */

/******************************************************************************/
/*                                                                            */
/*                       General Purpose IOs (GPIO)                           */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GPIO_MODER register  *****************/
#define GPIO_MODER_MODE0_Pos                (0UL)
#define GPIO_MODER_MODE0_Msk                (0x3UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000003 */
#define GPIO_MODER_MODE0                    GPIO_MODER_MODE0_Msk
#define GPIO_MODER_MODE0_0                  (0x1UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000001 */
#define GPIO_MODER_MODE0_1                  (0x2UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000002 */
#define GPIO_MODER_MODE1_Pos                (2UL)
#define GPIO_MODER_MODE1_Msk                (0x3UL << GPIO_MODER_MODE1_Pos)         /*!< 0x0000000C */
#define GPIO_MODER_MODE1                    GPIO_MODER_MODE1_Msk
#define GPIO_MODER_MODE1_0                  (0x1UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000004 */
#define GPIO_MODER_MODE1_1                  (0x2UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000008 */
#define GPIO_MODER_MODE2_Pos                (4UL)
#define GPIO_MODER_MODE2_Msk                (0x3UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000030 */
#define GPIO_MODER_MODE2                    GPIO_MODER_MODE2_Msk
#define GPIO_MODER_MODE2_0                  (0x1UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000010 */
#define GPIO_MODER_MODE2_1                  (0x2UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000020 */
#define GPIO_MODER_MODE3_Pos                (6UL)
#define GPIO_MODER_MODE3_Msk                (0x3UL << GPIO_MODER_MODE3_Pos)         /*!< 0x000000C0 */
#define GPIO_MODER_MODE3                    GPIO_MODER_MODE3_Msk
#define GPIO_MODER_MODE3_0                  (0x1UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000040 */
#define GPIO_MODER_MODE3_1                  (0x2UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000080 */
#define GPIO_MODER_MODE4_Pos                (8UL)
#define GPIO_MODER_MODE4_Msk                (0x3UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000300 */
#define GPIO_MODER_MODE4                    GPIO_MODER_MODE4_Msk
#define GPIO_MODER_MODE4_0                  (0x1UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000100 */
#define GPIO_MODER_MODE4_1                  (0x2UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000200 */
#define GPIO_MODER_MODE5_Pos                (10UL)
#define GPIO_MODER_MODE5_Msk                (0x3UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000C00 */
#define GPIO_MODER_MODE5                    GPIO_MODER_MODE5_Msk
#define GPIO_MODER_MODE5_0                  (0x1UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000400 */
#define GPIO_MODER_MODE5_1                  (0x2UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000800 */
#define GPIO_MODER_MODE6_Pos                (12UL)
#define GPIO_MODER_MODE6_Msk                (0x3UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00003000 */
#define GPIO_MODER_MODE6                    GPIO_MODER_MODE6_Msk
#define GPIO_MODER_MODE6_0                  (0x1UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00001000 */
#define GPIO_MODER_MODE6_1                  (0x2UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00002000 */
#define GPIO_MODER_MODE7_Pos                (14UL)
#define GPIO_MODER_MODE7_Msk                (0x3UL << GPIO_MODER_MODE7_Pos)         /*!< 0x0000C000 */
#define GPIO_MODER_MODE7                    GPIO_MODER_MODE7_Msk
#define GPIO_MODER_MODE7_0                  (0x1UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00004000 */
#define GPIO_MODER_MODE7_1                  (0x2UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00008000 */
#define GPIO_MODER_MODE8_Pos                (16UL)
#define GPIO_MODER_MODE8_Msk                (0x3UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00030000 */
#define GPIO_MODER_MODE8                    GPIO_MODER_MODE8_Msk
#define GPIO_MODER_MODE8_0                  (0x1UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00010000 */
#define GPIO_MODER_MODE8_1                  (0x2UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00020000 */
#define GPIO_MODER_MODE9_Pos                (18UL)
#define GPIO_MODER_MODE9_Msk                (0x3UL << GPIO_MODER_MODE9_Pos)         /*!< 0x000C0000 */
#define GPIO_MODER_MODE9                    GPIO_MODER_MODE9_Msk
#define GPIO_MODER_MODE9_0                  (0x1UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00040000 */
#define GPIO_MODER_MODE9_1                  (0x2UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00080000 */
#define GPIO_MODER_MODE10_Pos               (20UL)
#define GPIO_MODER_MODE10_Msk               (0x3UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00300000 */
#define GPIO_MODER_MODE10                   GPIO_MODER_MODE10_Msk
#define GPIO_MODER_MODE10_0                 (0x1UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00100000 */
#define GPIO_MODER_MODE10_1                 (0x2UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00200000 */
#define GPIO_MODER_MODE11_Pos               (22UL)
#define GPIO_MODER_MODE11_Msk               (0x3UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00C00000 */
#define GPIO_MODER_MODE11                   GPIO_MODER_MODE11_Msk
#define GPIO_MODER_MODE11_0                 (0x1UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00400000 */
#define GPIO_MODER_MODE11_1                 (0x2UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00800000 */
#define GPIO_MODER_MODE12_Pos               (24UL)
#define GPIO_MODER_MODE12_Msk               (0x3UL << GPIO_MODER_MODE12_Pos)        /*!< 0x03000000 */
#define GPIO_MODER_MODE12                   GPIO_MODER_MODE12_Msk
#define GPIO_MODER_MODE12_0                 (0x1UL << GPIO_MODER_MODE12_Pos)        /*!< 0x01000000 */
#define GPIO_MODER_MODE12_1                 (0x2UL << GPIO_MODER_MODE12_Pos)        /*!< 0x02000000 */
#define GPIO_MODER_MODE13_Pos               (26UL)
#define GPIO_MODER_MODE13_Msk               (0x3UL << GPIO_MODER_MODE13_Pos)        /*!< 0x0C000000 */
#define GPIO_MODER_MODE13                   GPIO_MODER_MODE13_Msk
#define GPIO_MODER_MODE13_0                 (0x1UL << GPIO_MODER_MODE13_Pos)        /*!< 0x04000000 */
#define GPIO_MODER_MODE13_1                 (0x2UL << GPIO_MODER_MODE13_Pos)        /*!< 0x08000000 */
#define GPIO_MODER_MODE14_Pos               (28UL)
#define GPIO_MODER_MODE14_Msk               (0x3UL << GPIO_MODER_MODE14_Pos)        /*!< 0x30000000 */
#define GPIO_MODER_MODE14                   GPIO_MODER_MODE14_Msk
#define GPIO_MODER_MODE14_0                 (0x1UL << GPIO_MODER_MODE14_Pos)        /*!< 0x10000000 */
#define GPIO_MODER_MODE14_1                 (0x2UL << GPIO_MODER_MODE14_Pos)        /*!< 0x20000000 */
#define GPIO_MODER_MODE15_Pos               (30UL)
#define GPIO_MODER_MODE15_Msk               (0x3UL << GPIO_MODER_MODE15_Pos)        /*!< 0xC0000000 */
#define GPIO_MODER_MODE15                   GPIO_MODER_MODE15_Msk
#define GPIO_MODER_MODE15_0                 (0x1UL << GPIO_MODER_MODE15_Pos)        /*!< 0x40000000 */
#define GPIO_MODER_MODE15_1                 (0x2UL << GPIO_MODER_MODE15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_OTYPER register  ****************/
#define GPIO_OTYPER_OT0_Pos                 (0UL)
#define GPIO_OTYPER_OT0_Msk                 (0x1UL << GPIO_OTYPER_OT0_Pos)          /*!< 0x00000001 */
#define GPIO_OTYPER_OT0                     GPIO_OTYPER_OT0_Msk
#define GPIO_OTYPER_OT1_Pos                 (1UL)
#define GPIO_OTYPER_OT1_Msk                 (0x1UL << GPIO_OTYPER_OT1_Pos)          /*!< 0x00000002 */
#define GPIO_OTYPER_OT1                     GPIO_OTYPER_OT1_Msk
#define GPIO_OTYPER_OT2_Pos                 (2UL)
#define GPIO_OTYPER_OT2_Msk                 (0x1UL << GPIO_OTYPER_OT2_Pos)          /*!< 0x00000004 */
#define GPIO_OTYPER_OT2                     GPIO_OTYPER_OT2_Msk
#define GPIO_OTYPER_OT3_Pos                 (3UL)
#define GPIO_OTYPER_OT3_Msk                 (0x1UL << GPIO_OTYPER_OT3_Pos)          /*!< 0x00000008 */
#define GPIO_OTYPER_OT3                     GPIO_OTYPER_OT3_Msk
#define GPIO_OTYPER_OT4_Pos                 (4UL)
#define GPIO_OTYPER_OT4_Msk                 (0x1UL << GPIO_OTYPER_OT4_Pos)          /*!< 0x00000010 */
#define GPIO_OTYPER_OT4                     GPIO_OTYPER_OT4_Msk
#define GPIO_OTYPER_OT5_Pos                 (5UL)
#define GPIO_OTYPER_OT5_Msk                 (0x1UL << GPIO_OTYPER_OT5_Pos)          /*!< 0x00000020 */
#define GPIO_OTYPER_OT5                     GPIO_OTYPER_OT5_Msk
#define GPIO_OTYPER_OT6_Pos                 (6UL)
#define GPIO_OTYPER_OT6_Msk                 (0x1UL << GPIO_OTYPER_OT6_Pos)          /*!< 0x00000040 */
#define GPIO_OTYPER_OT6                     GPIO_OTYPER_OT6_Msk
#define GPIO_OTYPER_OT7_Pos                 (7UL)
#define GPIO_OTYPER_OT7_Msk                 (0x1UL << GPIO_OTYPER_OT7_Pos)          /*!< 0x00000080 */
#define GPIO_OTYPER_OT7                     GPIO_OTYPER_OT7_Msk
#define GPIO_OTYPER_OT8_Pos                 (8UL)
#define GPIO_OTYPER_OT8_Msk                 (0x1UL << GPIO_OTYPER_OT8_Pos)          /*!< 0x00000100 */
#define GPIO_OTYPER_OT8                     GPIO_OTYPER_OT8_Msk
#define GPIO_OTYPER_OT9_Pos                 (9UL)
#define GPIO_OTYPER_OT9_Msk                 (0x1UL << GPIO_OTYPER_OT9_Pos)          /*!< 0x00000200 */
#define GPIO_OTYPER_OT9                     GPIO_OTYPER_OT9_Msk
#define GPIO_OTYPER_OT10_Pos                (10UL)
#define GPIO_OTYPER_OT10_Msk                (0x1UL << GPIO_OTYPER_OT10_Pos)         /*!< 0x00000400 */
#define GPIO_OTYPER_OT10                    GPIO_OTYPER_OT10_Msk
#define GPIO_OTYPER_OT11_Pos                (11UL)
#define GPIO_OTYPER_OT11_Msk                (0x1UL << GPIO_OTYPER_OT11_Pos)         /*!< 0x00000800 */
#define GPIO_OTYPER_OT11                    GPIO_OTYPER_OT11_Msk
#define GPIO_OTYPER_OT12_Pos                (12UL)
#define GPIO_OTYPER_OT12_Msk                (0x1UL << GPIO_OTYPER_OT12_Pos)         /*!< 0x00001000 */
#define GPIO_OTYPER_OT12                    GPIO_OTYPER_OT12_Msk
#define GPIO_OTYPER_OT13_Pos                (13UL)
#define GPIO_OTYPER_OT13_Msk                (0x1UL << GPIO_OTYPER_OT13_Pos)         /*!< 0x00002000 */
#define GPIO_OTYPER_OT13                    GPIO_OTYPER_OT13_Msk
#define GPIO_OTYPER_OT14_Pos                (14UL)
#define GPIO_OTYPER_OT14_Msk                (0x1UL << GPIO_OTYPER_OT14_Pos)         /*!< 0x00004000 */
#define GPIO_OTYPER_OT14                    GPIO_OTYPER_OT14_Msk
#define GPIO_OTYPER_OT15_Pos                (15UL)
#define GPIO_OTYPER_OT15_Msk                (0x1UL << GPIO_OTYPER_OT15_Pos)         /*!< 0x00008000 */
#define GPIO_OTYPER_OT15                    GPIO_OTYPER_OT15_Msk

/******************  Bits definition for GPIO_OSPEEDR register  ***************/
#define GPIO_OSPEEDR_OSPEED0_Pos            (0UL)
#define GPIO_OSPEEDR_OSPEED0_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000003 */
#define GPIO_OSPEEDR_OSPEED0                GPIO_OSPEEDR_OSPEED0_Msk
#define GPIO_OSPEEDR_OSPEED0_0              (0x1UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000001 */
#define GPIO_OSPEEDR_OSPEED0_1              (0x2UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000002 */
#define GPIO_OSPEEDR_OSPEED1_Pos            (2UL)
#define GPIO_OSPEEDR_OSPEED1_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x0000000C */
#define GPIO_OSPEEDR_OSPEED1                GPIO_OSPEEDR_OSPEED1_Msk
#define GPIO_OSPEEDR_OSPEED1_0              (0x1UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000004 */
#define GPIO_OSPEEDR_OSPEED1_1              (0x2UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000008 */
#define GPIO_OSPEEDR_OSPEED2_Pos            (4UL)
#define GPIO_OSPEEDR_OSPEED2_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000030 */
#define GPIO_OSPEEDR_OSPEED2                GPIO_OSPEEDR_OSPEED2_Msk
#define GPIO_OSPEEDR_OSPEED2_0              (0x1UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000010 */
#define GPIO_OSPEEDR_OSPEED2_1              (0x2UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000020 */
#define GPIO_OSPEEDR_OSPEED3_Pos            (6UL)
#define GPIO_OSPEEDR_OSPEED3_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x000000C0 */
#define GPIO_OSPEEDR_OSPEED3                GPIO_OSPEEDR_OSPEED3_Msk
#define GPIO_OSPEEDR_OSPEED3_0              (0x1UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000040 */
#define GPIO_OSPEEDR_OSPEED3_1              (0x2UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000080 */
#define GPIO_OSPEEDR_OSPEED4_Pos            (8UL)
#define GPIO_OSPEEDR_OSPEED4_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000300 */
#define GPIO_OSPEEDR_OSPEED4                GPIO_OSPEEDR_OSPEED4_Msk
#define GPIO_OSPEEDR_OSPEED4_0              (0x1UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000100 */
#define GPIO_OSPEEDR_OSPEED4_1              (0x2UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000200 */
#define GPIO_OSPEEDR_OSPEED5_Pos            (10UL)
#define GPIO_OSPEEDR_OSPEED5_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000C00 */
#define GPIO_OSPEEDR_OSPEED5                GPIO_OSPEEDR_OSPEED5_Msk
#define GPIO_OSPEEDR_OSPEED5_0              (0x1UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000400 */
#define GPIO_OSPEEDR_OSPEED5_1              (0x2UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000800 */
#define GPIO_OSPEEDR_OSPEED6_Pos            (12UL)
#define GPIO_OSPEEDR_OSPEED6_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00003000 */
#define GPIO_OSPEEDR_OSPEED6                GPIO_OSPEEDR_OSPEED6_Msk
#define GPIO_OSPEEDR_OSPEED6_0              (0x1UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00001000 */
#define GPIO_OSPEEDR_OSPEED6_1              (0x2UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00002000 */
#define GPIO_OSPEEDR_OSPEED7_Pos            (14UL)
#define GPIO_OSPEEDR_OSPEED7_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x0000C000 */
#define GPIO_OSPEEDR_OSPEED7                GPIO_OSPEEDR_OSPEED7_Msk
#define GPIO_OSPEEDR_OSPEED7_0              (0x1UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00004000 */
#define GPIO_OSPEEDR_OSPEED7_1              (0x2UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00008000 */
#define GPIO_OSPEEDR_OSPEED8_Pos            (16UL)
#define GPIO_OSPEEDR_OSPEED8_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00030000 */
#define GPIO_OSPEEDR_OSPEED8                GPIO_OSPEEDR_OSPEED8_Msk
#define GPIO_OSPEEDR_OSPEED8_0              (0x1UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00010000 */
#define GPIO_OSPEEDR_OSPEED8_1              (0x2UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00020000 */
#define GPIO_OSPEEDR_OSPEED9_Pos            (18UL)
#define GPIO_OSPEEDR_OSPEED9_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x000C0000 */
#define GPIO_OSPEEDR_OSPEED9                GPIO_OSPEEDR_OSPEED9_Msk
#define GPIO_OSPEEDR_OSPEED9_0              (0x1UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00040000 */
#define GPIO_OSPEEDR_OSPEED9_1              (0x2UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00080000 */
#define GPIO_OSPEEDR_OSPEED10_Pos           (20UL)
#define GPIO_OSPEEDR_OSPEED10_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00300000 */
#define GPIO_OSPEEDR_OSPEED10               GPIO_OSPEEDR_OSPEED10_Msk
#define GPIO_OSPEEDR_OSPEED10_0             (0x1UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00100000 */
#define GPIO_OSPEEDR_OSPEED10_1             (0x2UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00200000 */
#define GPIO_OSPEEDR_OSPEED11_Pos           (22UL)
#define GPIO_OSPEEDR_OSPEED11_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00C00000 */
#define GPIO_OSPEEDR_OSPEED11               GPIO_OSPEEDR_OSPEED11_Msk
#define GPIO_OSPEEDR_OSPEED11_0             (0x1UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00400000 */
#define GPIO_OSPEEDR_OSPEED11_1             (0x2UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00800000 */
#define GPIO_OSPEEDR_OSPEED12_Pos           (24UL)
#define GPIO_OSPEEDR_OSPEED12_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x03000000 */
#define GPIO_OSPEEDR_OSPEED12               GPIO_OSPEEDR_OSPEED12_Msk
#define GPIO_OSPEEDR_OSPEED12_0             (0x1UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x01000000 */
#define GPIO_OSPEEDR_OSPEED12_1             (0x2UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x02000000 */
#define GPIO_OSPEEDR_OSPEED13_Pos           (26UL)
#define GPIO_OSPEEDR_OSPEED13_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x0C000000 */
#define GPIO_OSPEEDR_OSPEED13               GPIO_OSPEEDR_OSPEED13_Msk
#define GPIO_OSPEEDR_OSPEED13_0             (0x1UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x04000000 */
#define GPIO_OSPEEDR_OSPEED13_1             (0x2UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x08000000 */
#define GPIO_OSPEEDR_OSPEED14_Pos           (28UL)
#define GPIO_OSPEEDR_OSPEED14_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x30000000 */
#define GPIO_OSPEEDR_OSPEED14               GPIO_OSPEEDR_OSPEED14_Msk
#define GPIO_OSPEEDR_OSPEED14_0             (0x1UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x10000000 */
#define GPIO_OSPEEDR_OSPEED14_1             (0x2UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x20000000 */
#define GPIO_OSPEEDR_OSPEED15_Pos           (30UL)
#define GPIO_OSPEEDR_OSPEED15_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0xC0000000 */
#define GPIO_OSPEEDR_OSPEED15               GPIO_OSPEEDR_OSPEED15_Msk
#define GPIO_OSPEEDR_OSPEED15_0             (0x1UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x40000000 */
#define GPIO_OSPEEDR_OSPEED15_1             (0x2UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x80000000 */

/******************  Bits definition for GPIO_PUPDR register  *****************/
#define GPIO_PUPDR_PUPD0_Pos                (0UL)
#define GPIO_PUPDR_PUPD0_Msk                (0x3UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000003 */
#define GPIO_PUPDR_PUPD0                    GPIO_PUPDR_PUPD0_Msk
#define GPIO_PUPDR_PUPD0_0                  (0x1UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000001 */
#define GPIO_PUPDR_PUPD0_1                  (0x2UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000002 */
#define GPIO_PUPDR_PUPD1_Pos                (2UL)
#define GPIO_PUPDR_PUPD1_Msk                (0x3UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x0000000C */
#define GPIO_PUPDR_PUPD1                    GPIO_PUPDR_PUPD1_Msk
#define GPIO_PUPDR_PUPD1_0                  (0x1UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000004 */
#define GPIO_PUPDR_PUPD1_1                  (0x2UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000008 */
#define GPIO_PUPDR_PUPD2_Pos                (4UL)
#define GPIO_PUPDR_PUPD2_Msk                (0x3UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000030 */
#define GPIO_PUPDR_PUPD2                    GPIO_PUPDR_PUPD2_Msk
#define GPIO_PUPDR_PUPD2_0                  (0x1UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000010 */
#define GPIO_PUPDR_PUPD2_1                  (0x2UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000020 */
#define GPIO_PUPDR_PUPD3_Pos                (6UL)
#define GPIO_PUPDR_PUPD3_Msk                (0x3UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x000000C0 */
#define GPIO_PUPDR_PUPD3                    GPIO_PUPDR_PUPD3_Msk
#define GPIO_PUPDR_PUPD3_0                  (0x1UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000040 */
#define GPIO_PUPDR_PUPD3_1                  (0x2UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000080 */
#define GPIO_PUPDR_PUPD4_Pos                (8UL)
#define GPIO_PUPDR_PUPD4_Msk                (0x3UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000300 */
#define GPIO_PUPDR_PUPD4                    GPIO_PUPDR_PUPD4_Msk
#define GPIO_PUPDR_PUPD4_0                  (0x1UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000100 */
#define GPIO_PUPDR_PUPD4_1                  (0x2UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000200 */
#define GPIO_PUPDR_PUPD5_Pos                (10UL)
#define GPIO_PUPDR_PUPD5_Msk                (0x3UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000C00 */
#define GPIO_PUPDR_PUPD5                    GPIO_PUPDR_PUPD5_Msk
#define GPIO_PUPDR_PUPD5_0                  (0x1UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000400 */
#define GPIO_PUPDR_PUPD5_1                  (0x2UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000800 */
#define GPIO_PUPDR_PUPD6_Pos                (12UL)
#define GPIO_PUPDR_PUPD6_Msk                (0x3UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00003000 */
#define GPIO_PUPDR_PUPD6                    GPIO_PUPDR_PUPD6_Msk
#define GPIO_PUPDR_PUPD6_0                  (0x1UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00001000 */
#define GPIO_PUPDR_PUPD6_1                  (0x2UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00002000 */
#define GPIO_PUPDR_PUPD7_Pos                (14UL)
#define GPIO_PUPDR_PUPD7_Msk                (0x3UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x0000C000 */
#define GPIO_PUPDR_PUPD7                    GPIO_PUPDR_PUPD7_Msk
#define GPIO_PUPDR_PUPD7_0                  (0x1UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00004000 */
#define GPIO_PUPDR_PUPD7_1                  (0x2UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00008000 */
#define GPIO_PUPDR_PUPD8_Pos                (16UL)
#define GPIO_PUPDR_PUPD8_Msk                (0x3UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00030000 */
#define GPIO_PUPDR_PUPD8                    GPIO_PUPDR_PUPD8_Msk
#define GPIO_PUPDR_PUPD8_0                  (0x1UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00010000 */
#define GPIO_PUPDR_PUPD8_1                  (0x2UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00020000 */
#define GPIO_PUPDR_PUPD9_Pos                (18UL)
#define GPIO_PUPDR_PUPD9_Msk                (0x3UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x000C0000 */
#define GPIO_PUPDR_PUPD9                    GPIO_PUPDR_PUPD9_Msk
#define GPIO_PUPDR_PUPD9_0                  (0x1UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00040000 */
#define GPIO_PUPDR_PUPD9_1                  (0x2UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00080000 */
#define GPIO_PUPDR_PUPD10_Pos               (20UL)
#define GPIO_PUPDR_PUPD10_Msk               (0x3UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00300000 */
#define GPIO_PUPDR_PUPD10                   GPIO_PUPDR_PUPD10_Msk
#define GPIO_PUPDR_PUPD10_0                 (0x1UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00100000 */
#define GPIO_PUPDR_PUPD10_1                 (0x2UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00200000 */
#define GPIO_PUPDR_PUPD11_Pos               (22UL)
#define GPIO_PUPDR_PUPD11_Msk               (0x3UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00C00000 */
#define GPIO_PUPDR_PUPD11                   GPIO_PUPDR_PUPD11_Msk
#define GPIO_PUPDR_PUPD11_0                 (0x1UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00400000 */
#define GPIO_PUPDR_PUPD11_1                 (0x2UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00800000 */
#define GPIO_PUPDR_PUPD12_Pos               (24UL)
#define GPIO_PUPDR_PUPD12_Msk               (0x3UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x03000000 */
#define GPIO_PUPDR_PUPD12                   GPIO_PUPDR_PUPD12_Msk
#define GPIO_PUPDR_PUPD12_0                 (0x1UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x01000000 */
#define GPIO_PUPDR_PUPD12_1                 (0x2UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x02000000 */
#define GPIO_PUPDR_PUPD13_Pos               (26UL)
#define GPIO_PUPDR_PUPD13_Msk               (0x3UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x0C000000 */
#define GPIO_PUPDR_PUPD13                   GPIO_PUPDR_PUPD13_Msk
#define GPIO_PUPDR_PUPD13_0                 (0x1UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x04000000 */
#define GPIO_PUPDR_PUPD13_1                 (0x2UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x08000000 */
#define GPIO_PUPDR_PUPD14_Pos               (28UL)
#define GPIO_PUPDR_PUPD14_Msk               (0x3UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x30000000 */
#define GPIO_PUPDR_PUPD14                   GPIO_PUPDR_PUPD14_Msk
#define GPIO_PUPDR_PUPD14_0                 (0x1UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x10000000 */
#define GPIO_PUPDR_PUPD14_1                 (0x2UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x20000000 */
#define GPIO_PUPDR_PUPD15_Pos               (30UL)
#define GPIO_PUPDR_PUPD15_Msk               (0x3UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0xC0000000 */
#define GPIO_PUPDR_PUPD15                   GPIO_PUPDR_PUPD15_Msk
#define GPIO_PUPDR_PUPD15_0                 (0x1UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x40000000 */
#define GPIO_PUPDR_PUPD15_1                 (0x2UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_IDR register  *******************/
#define GPIO_IDR_ID0_Pos                    (0UL)
#define GPIO_IDR_ID0_Msk                    (0x1UL << GPIO_IDR_ID0_Pos)             /*!< 0x00000001 */
#define GPIO_IDR_ID0                        GPIO_IDR_ID0_Msk
#define GPIO_IDR_ID1_Pos                    (1UL)
#define GPIO_IDR_ID1_Msk                    (0x1UL << GPIO_IDR_ID1_Pos)             /*!< 0x00000002 */
#define GPIO_IDR_ID1                        GPIO_IDR_ID1_Msk
#define GPIO_IDR_ID2_Pos                    (2UL)
#define GPIO_IDR_ID2_Msk                    (0x1UL << GPIO_IDR_ID2_Pos)             /*!< 0x00000004 */
#define GPIO_IDR_ID2                        GPIO_IDR_ID2_Msk
#define GPIO_IDR_ID3_Pos                    (3UL)
#define GPIO_IDR_ID3_Msk                    (0x1UL << GPIO_IDR_ID3_Pos)             /*!< 0x00000008 */
#define GPIO_IDR_ID3                        GPIO_IDR_ID3_Msk
#define GPIO_IDR_ID4_Pos                    (4UL)
#define GPIO_IDR_ID4_Msk                    (0x1UL << GPIO_IDR_ID4_Pos)             /*!< 0x00000010 */
#define GPIO_IDR_ID4                        GPIO_IDR_ID4_Msk
#define GPIO_IDR_ID5_Pos                    (5UL)
#define GPIO_IDR_ID5_Msk                    (0x1UL << GPIO_IDR_ID5_Pos)             /*!< 0x00000020 */
#define GPIO_IDR_ID5                        GPIO_IDR_ID5_Msk
#define GPIO_IDR_ID6_Pos                    (6UL)
#define GPIO_IDR_ID6_Msk                    (0x1UL << GPIO_IDR_ID6_Pos)             /*!< 0x00000040 */
#define GPIO_IDR_ID6                        GPIO_IDR_ID6_Msk
#define GPIO_IDR_ID7_Pos                    (7UL)
#define GPIO_IDR_ID7_Msk                    (0x1UL << GPIO_IDR_ID7_Pos)             /*!< 0x00000080 */
#define GPIO_IDR_ID7                        GPIO_IDR_ID7_Msk
#define GPIO_IDR_ID8_Pos                    (8UL)
#define GPIO_IDR_ID8_Msk                    (0x1UL << GPIO_IDR_ID8_Pos)             /*!< 0x00000100 */
#define GPIO_IDR_ID8                        GPIO_IDR_ID8_Msk
#define GPIO_IDR_ID9_Pos                    (9UL)
#define GPIO_IDR_ID9_Msk                    (0x1UL << GPIO_IDR_ID9_Pos)             /*!< 0x00000200 */
#define GPIO_IDR_ID9                        GPIO_IDR_ID9_Msk
#define GPIO_IDR_ID10_Pos                   (10UL)
#define GPIO_IDR_ID10_Msk                   (0x1UL << GPIO_IDR_ID10_Pos)            /*!< 0x00000400 */
#define GPIO_IDR_ID10                       GPIO_IDR_ID10_Msk
#define GPIO_IDR_ID11_Pos                   (11UL)
#define GPIO_IDR_ID11_Msk                   (0x1UL << GPIO_IDR_ID11_Pos)            /*!< 0x00000800 */
#define GPIO_IDR_ID11                       GPIO_IDR_ID11_Msk
#define GPIO_IDR_ID12_Pos                   (12UL)
#define GPIO_IDR_ID12_Msk                   (0x1UL << GPIO_IDR_ID12_Pos)            /*!< 0x00001000 */
#define GPIO_IDR_ID12                       GPIO_IDR_ID12_Msk
#define GPIO_IDR_ID13_Pos                   (13UL)
#define GPIO_IDR_ID13_Msk                   (0x1UL << GPIO_IDR_ID13_Pos)            /*!< 0x00002000 */
#define GPIO_IDR_ID13                       GPIO_IDR_ID13_Msk
#define GPIO_IDR_ID14_Pos                   (14UL)
#define GPIO_IDR_ID14_Msk                   (0x1UL << GPIO_IDR_ID14_Pos)            /*!< 0x00004000 */
#define GPIO_IDR_ID14                       GPIO_IDR_ID14_Msk
#define GPIO_IDR_ID15_Pos                   (15UL)
#define GPIO_IDR_ID15_Msk                   (0x1UL << GPIO_IDR_ID15_Pos)            /*!< 0x00008000 */
#define GPIO_IDR_ID15                       GPIO_IDR_ID15_Msk

/******************  Bits definition for GPIO_ODR register  *******************/
#define GPIO_ODR_OD0_Pos                    (0UL)
#define GPIO_ODR_OD0_Msk                    (0x1UL << GPIO_ODR_OD0_Pos)             /*!< 0x00000001 */
#define GPIO_ODR_OD0                        GPIO_ODR_OD0_Msk
#define GPIO_ODR_OD1_Pos                    (1UL)
#define GPIO_ODR_OD1_Msk                    (0x1UL << GPIO_ODR_OD1_Pos)             /*!< 0x00000002 */
#define GPIO_ODR_OD1                        GPIO_ODR_OD1_Msk
#define GPIO_ODR_OD2_Pos                    (2UL)
#define GPIO_ODR_OD2_Msk                    (0x1UL << GPIO_ODR_OD2_Pos)             /*!< 0x00000004 */
#define GPIO_ODR_OD2                        GPIO_ODR_OD2_Msk
#define GPIO_ODR_OD3_Pos                    (3UL)
#define GPIO_ODR_OD3_Msk                    (0x1UL << GPIO_ODR_OD3_Pos)             /*!< 0x00000008 */
#define GPIO_ODR_OD3                        GPIO_ODR_OD3_Msk
#define GPIO_ODR_OD4_Pos                    (4UL)
#define GPIO_ODR_OD4_Msk                    (0x1UL << GPIO_ODR_OD4_Pos)             /*!< 0x00000010 */
#define GPIO_ODR_OD4                        GPIO_ODR_OD4_Msk
#define GPIO_ODR_OD5_Pos                    (5UL)
#define GPIO_ODR_OD5_Msk                    (0x1UL << GPIO_ODR_OD5_Pos)             /*!< 0x00000020 */
#define GPIO_ODR_OD5                        GPIO_ODR_OD5_Msk
#define GPIO_ODR_OD6_Pos                    (6UL)
#define GPIO_ODR_OD6_Msk                    (0x1UL << GPIO_ODR_OD6_Pos)             /*!< 0x00000040 */
#define GPIO_ODR_OD6                        GPIO_ODR_OD6_Msk
#define GPIO_ODR_OD7_Pos                    (7UL)
#define GPIO_ODR_OD7_Msk                    (0x1UL << GPIO_ODR_OD7_Pos)             /*!< 0x00000080 */
#define GPIO_ODR_OD7                        GPIO_ODR_OD7_Msk
#define GPIO_ODR_OD8_Pos                    (8UL)
#define GPIO_ODR_OD8_Msk                    (0x1UL << GPIO_ODR_OD8_Pos)             /*!< 0x00000100 */
#define GPIO_ODR_OD8                        GPIO_ODR_OD8_Msk
#define GPIO_ODR_OD9_Pos                    (9UL)
#define GPIO_ODR_OD9_Msk                    (0x1UL << GPIO_ODR_OD9_Pos)             /*!< 0x00000200 */
#define GPIO_ODR_OD9                        GPIO_ODR_OD9_Msk
#define GPIO_ODR_OD10_Pos                   (10UL)
#define GPIO_ODR_OD10_Msk                   (0x1UL << GPIO_ODR_OD10_Pos)            /*!< 0x00000400 */
#define GPIO_ODR_OD10                       GPIO_ODR_OD10_Msk
#define GPIO_ODR_OD11_Pos                   (11UL)
#define GPIO_ODR_OD11_Msk                   (0x1UL << GPIO_ODR_OD11_Pos)            /*!< 0x00000800 */
#define GPIO_ODR_OD11                       GPIO_ODR_OD11_Msk
#define GPIO_ODR_OD12_Pos                   (12UL)
#define GPIO_ODR_OD12_Msk                   (0x1UL << GPIO_ODR_OD12_Pos)            /*!< 0x00001000 */
#define GPIO_ODR_OD12                       GPIO_ODR_OD12_Msk
#define GPIO_ODR_OD13_Pos                   (13UL)
#define GPIO_ODR_OD13_Msk                   (0x1UL << GPIO_ODR_OD13_Pos)            /*!< 0x00002000 */
#define GPIO_ODR_OD13                       GPIO_ODR_OD13_Msk
#define GPIO_ODR_OD14_Pos                   (14UL)
#define GPIO_ODR_OD14_Msk                   (0x1UL << GPIO_ODR_OD14_Pos)            /*!< 0x00004000 */
#define GPIO_ODR_OD14                       GPIO_ODR_OD14_Msk
#define GPIO_ODR_OD15_Pos                   (15UL)
#define GPIO_ODR_OD15_Msk                   (0x1UL << GPIO_ODR_OD15_Pos)            /*!< 0x00008000 */
#define GPIO_ODR_OD15                       GPIO_ODR_OD15_Msk

/******************  Bits definition for GPIO_BSRR register  ******************/
#define GPIO_BSRR_BS0_Pos                   (0UL)
#define GPIO_BSRR_BS0_Msk                   (0x1UL << GPIO_BSRR_BS0_Pos)            /*!< 0x00000001 */
#define GPIO_BSRR_BS0                       GPIO_BSRR_BS0_Msk
#define GPIO_BSRR_BS1_Pos                   (1UL)
#define GPIO_BSRR_BS1_Msk                   (0x1UL << GPIO_BSRR_BS1_Pos)            /*!< 0x00000002 */
#define GPIO_BSRR_BS1                       GPIO_BSRR_BS1_Msk
#define GPIO_BSRR_BS2_Pos                   (2UL)
#define GPIO_BSRR_BS2_Msk                   (0x1UL << GPIO_BSRR_BS2_Pos)            /*!< 0x00000004 */
#define GPIO_BSRR_BS2                       GPIO_BSRR_BS2_Msk
#define GPIO_BSRR_BS3_Pos                   (3UL)
#define GPIO_BSRR_BS3_Msk                   (0x1UL << GPIO_BSRR_BS3_Pos)            /*!< 0x00000008 */
#define GPIO_BSRR_BS3                       GPIO_BSRR_BS3_Msk
#define GPIO_BSRR_BS4_Pos                   (4UL)
#define GPIO_BSRR_BS4_Msk                   (0x1UL << GPIO_BSRR_BS4_Pos)            /*!< 0x00000010 */
#define GPIO_BSRR_BS4                       GPIO_BSRR_BS4_Msk
#define GPIO_BSRR_BS5_Pos                   (5UL)
#define GPIO_BSRR_BS5_Msk                   (0x1UL << GPIO_BSRR_BS5_Pos)            /*!< 0x00000020 */
#define GPIO_BSRR_BS5                       GPIO_BSRR_BS5_Msk
#define GPIO_BSRR_BS6_Pos                   (6UL)
#define GPIO_BSRR_BS6_Msk                   (0x1UL << GPIO_BSRR_BS6_Pos)            /*!< 0x00000040 */
#define GPIO_BSRR_BS6                       GPIO_BSRR_BS6_Msk
#define GPIO_BSRR_BS7_Pos                   (7UL)
#define GPIO_BSRR_BS7_Msk                   (0x1UL << GPIO_BSRR_BS7_Pos)            /*!< 0x00000080 */
#define GPIO_BSRR_BS7                       GPIO_BSRR_BS7_Msk
#define GPIO_BSRR_BS8_Pos                   (8UL)
#define GPIO_BSRR_BS8_Msk                   (0x1UL << GPIO_BSRR_BS8_Pos)            /*!< 0x00000100 */
#define GPIO_BSRR_BS8                       GPIO_BSRR_BS8_Msk
#define GPIO_BSRR_BS9_Pos                   (9UL)
#define GPIO_BSRR_BS9_Msk                   (0x1UL << GPIO_BSRR_BS9_Pos)            /*!< 0x00000200 */
#define GPIO_BSRR_BS9                       GPIO_BSRR_BS9_Msk
#define GPIO_BSRR_BS10_Pos                  (10UL)
#define GPIO_BSRR_BS10_Msk                  (0x1UL << GPIO_BSRR_BS10_Pos)           /*!< 0x00000400 */
#define GPIO_BSRR_BS10                      GPIO_BSRR_BS10_Msk
#define GPIO_BSRR_BS11_Pos                  (11UL)
#define GPIO_BSRR_BS11_Msk                  (0x1UL << GPIO_BSRR_BS11_Pos)           /*!< 0x00000800 */
#define GPIO_BSRR_BS11                      GPIO_BSRR_BS11_Msk
#define GPIO_BSRR_BS12_Pos                  (12UL)
#define GPIO_BSRR_BS12_Msk                  (0x1UL << GPIO_BSRR_BS12_Pos)           /*!< 0x00001000 */
#define GPIO_BSRR_BS12                      GPIO_BSRR_BS12_Msk
#define GPIO_BSRR_BS13_Pos                  (13UL)
#define GPIO_BSRR_BS13_Msk                  (0x1UL << GPIO_BSRR_BS13_Pos)           /*!< 0x00002000 */
#define GPIO_BSRR_BS13                      GPIO_BSRR_BS13_Msk
#define GPIO_BSRR_BS14_Pos                  (14UL)
#define GPIO_BSRR_BS14_Msk                  (0x1UL << GPIO_BSRR_BS14_Pos)           /*!< 0x00004000 */
#define GPIO_BSRR_BS14                      GPIO_BSRR_BS14_Msk
#define GPIO_BSRR_BS15_Pos                  (15UL)
#define GPIO_BSRR_BS15_Msk                  (0x1UL << GPIO_BSRR_BS15_Pos)           /*!< 0x00008000 */
#define GPIO_BSRR_BS15                      GPIO_BSRR_BS15_Msk
#define GPIO_BSRR_BR0_Pos                   (16UL)
#define GPIO_BSRR_BR0_Msk                   (0x1UL << GPIO_BSRR_BR0_Pos)            /*!< 0x00010000 */
#define GPIO_BSRR_BR0                       GPIO_BSRR_BR0_Msk
#define GPIO_BSRR_BR1_Pos                   (17UL)
#define GPIO_BSRR_BR1_Msk                   (0x1UL << GPIO_BSRR_BR1_Pos)            /*!< 0x00020000 */
#define GPIO_BSRR_BR1                       GPIO_BSRR_BR1_Msk
#define GPIO_BSRR_BR2_Pos                   (18UL)
#define GPIO_BSRR_BR2_Msk                   (0x1UL << GPIO_BSRR_BR2_Pos)            /*!< 0x00040000 */
#define GPIO_BSRR_BR2                       GPIO_BSRR_BR2_Msk
#define GPIO_BSRR_BR3_Pos                   (19UL)
#define GPIO_BSRR_BR3_Msk                   (0x1UL << GPIO_BSRR_BR3_Pos)            /*!< 0x00080000 */
#define GPIO_BSRR_BR3                       GPIO_BSRR_BR3_Msk
#define GPIO_BSRR_BR4_Pos                   (20UL)
#define GPIO_BSRR_BR4_Msk                   (0x1UL << GPIO_BSRR_BR4_Pos)            /*!< 0x00100000 */
#define GPIO_BSRR_BR4                       GPIO_BSRR_BR4_Msk
#define GPIO_BSRR_BR5_Pos                   (21UL)
#define GPIO_BSRR_BR5_Msk                   (0x1UL << GPIO_BSRR_BR5_Pos)            /*!< 0x00200000 */
#define GPIO_BSRR_BR5                       GPIO_BSRR_BR5_Msk
#define GPIO_BSRR_BR6_Pos                   (22UL)
#define GPIO_BSRR_BR6_Msk                   (0x1UL << GPIO_BSRR_BR6_Pos)            /*!< 0x00400000 */
#define GPIO_BSRR_BR6                       GPIO_BSRR_BR6_Msk
#define GPIO_BSRR_BR7_Pos                   (23UL)
#define GPIO_BSRR_BR7_Msk                   (0x1UL << GPIO_BSRR_BR7_Pos)            /*!< 0x00800000 */
#define GPIO_BSRR_BR7                       GPIO_BSRR_BR7_Msk
#define GPIO_BSRR_BR8_Pos                   (24UL)
#define GPIO_BSRR_BR8_Msk                   (0x1UL << GPIO_BSRR_BR8_Pos)            /*!< 0x01000000 */
#define GPIO_BSRR_BR8                       GPIO_BSRR_BR8_Msk
#define GPIO_BSRR_BR9_Pos                   (25UL)
#define GPIO_BSRR_BR9_Msk                   (0x1UL << GPIO_BSRR_BR9_Pos)            /*!< 0x02000000 */
#define GPIO_BSRR_BR9                       GPIO_BSRR_BR9_Msk
#define GPIO_BSRR_BR10_Pos                  (26UL)
#define GPIO_BSRR_BR10_Msk                  (0x1UL << GPIO_BSRR_BR10_Pos)           /*!< 0x04000000 */
#define GPIO_BSRR_BR10                      GPIO_BSRR_BR10_Msk
#define GPIO_BSRR_BR11_Pos                  (27UL)
#define GPIO_BSRR_BR11_Msk                  (0x1UL << GPIO_BSRR_BR11_Pos)           /*!< 0x08000000 */
#define GPIO_BSRR_BR11                      GPIO_BSRR_BR11_Msk
#define GPIO_BSRR_BR12_Pos                  (28UL)
#define GPIO_BSRR_BR12_Msk                  (0x1UL << GPIO_BSRR_BR12_Pos)           /*!< 0x10000000 */
#define GPIO_BSRR_BR12                      GPIO_BSRR_BR12_Msk
#define GPIO_BSRR_BR13_Pos                  (29UL)
#define GPIO_BSRR_BR13_Msk                  (0x1UL << GPIO_BSRR_BR13_Pos)           /*!< 0x20000000 */
#define GPIO_BSRR_BR13                      GPIO_BSRR_BR13_Msk
#define GPIO_BSRR_BR14_Pos                  (30UL)
#define GPIO_BSRR_BR14_Msk                  (0x1UL << GPIO_BSRR_BR14_Pos)           /*!< 0x40000000 */
#define GPIO_BSRR_BR14                      GPIO_BSRR_BR14_Msk
#define GPIO_BSRR_BR15_Pos                  (31UL)
#define GPIO_BSRR_BR15_Msk                  (0x1UL << GPIO_BSRR_BR15_Pos)           /*!< 0x80000000 */
#define GPIO_BSRR_BR15                      GPIO_BSRR_BR15_Msk

/****************** Bit definition for GPIO_LCKR register *********************/
#define GPIO_LCKR_LCK0_Pos                  (0UL)
#define GPIO_LCKR_LCK0_Msk                  (0x1UL << GPIO_LCKR_LCK0_Pos)           /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                      GPIO_LCKR_LCK0_Msk
#define GPIO_LCKR_LCK1_Pos                  (1UL)
#define GPIO_LCKR_LCK1_Msk                  (0x1UL << GPIO_LCKR_LCK1_Pos)           /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                      GPIO_LCKR_LCK1_Msk
#define GPIO_LCKR_LCK2_Pos                  (2UL)
#define GPIO_LCKR_LCK2_Msk                  (0x1UL << GPIO_LCKR_LCK2_Pos)           /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                      GPIO_LCKR_LCK2_Msk
#define GPIO_LCKR_LCK3_Pos                  (3UL)
#define GPIO_LCKR_LCK3_Msk                  (0x1UL << GPIO_LCKR_LCK3_Pos)           /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                      GPIO_LCKR_LCK3_Msk
#define GPIO_LCKR_LCK4_Pos                  (4UL)
#define GPIO_LCKR_LCK4_Msk                  (0x1UL << GPIO_LCKR_LCK4_Pos)           /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                      GPIO_LCKR_LCK4_Msk
#define GPIO_LCKR_LCK5_Pos                  (5UL)
#define GPIO_LCKR_LCK5_Msk                  (0x1UL << GPIO_LCKR_LCK5_Pos)           /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                      GPIO_LCKR_LCK5_Msk
#define GPIO_LCKR_LCK6_Pos                  (6UL)
#define GPIO_LCKR_LCK6_Msk                  (0x1UL << GPIO_LCKR_LCK6_Pos)           /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                      GPIO_LCKR_LCK6_Msk
#define GPIO_LCKR_LCK7_Pos                  (7UL)
#define GPIO_LCKR_LCK7_Msk                  (0x1UL << GPIO_LCKR_LCK7_Pos)           /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                      GPIO_LCKR_LCK7_Msk
#define GPIO_LCKR_LCK8_Pos                  (8UL)
#define GPIO_LCKR_LCK8_Msk                  (0x1UL << GPIO_LCKR_LCK8_Pos)           /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                      GPIO_LCKR_LCK8_Msk
#define GPIO_LCKR_LCK9_Pos                  (9UL)
#define GPIO_LCKR_LCK9_Msk                  (0x1UL << GPIO_LCKR_LCK9_Pos)           /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                      GPIO_LCKR_LCK9_Msk
#define GPIO_LCKR_LCK10_Pos                 (10UL)
#define GPIO_LCKR_LCK10_Msk                 (0x1UL << GPIO_LCKR_LCK10_Pos)          /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                     GPIO_LCKR_LCK10_Msk
#define GPIO_LCKR_LCK11_Pos                 (11UL)
#define GPIO_LCKR_LCK11_Msk                 (0x1UL << GPIO_LCKR_LCK11_Pos)          /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                     GPIO_LCKR_LCK11_Msk
#define GPIO_LCKR_LCK12_Pos                 (12UL)
#define GPIO_LCKR_LCK12_Msk                 (0x1UL << GPIO_LCKR_LCK12_Pos)          /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                     GPIO_LCKR_LCK12_Msk
#define GPIO_LCKR_LCK13_Pos                 (13UL)
#define GPIO_LCKR_LCK13_Msk                 (0x1UL << GPIO_LCKR_LCK13_Pos)          /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                     GPIO_LCKR_LCK13_Msk
#define GPIO_LCKR_LCK14_Pos                 (14UL)
#define GPIO_LCKR_LCK14_Msk                 (0x1UL << GPIO_LCKR_LCK14_Pos)          /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                     GPIO_LCKR_LCK14_Msk
#define GPIO_LCKR_LCK15_Pos                 (15UL)
#define GPIO_LCKR_LCK15_Msk                 (0x1UL << GPIO_LCKR_LCK15_Pos)          /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                     GPIO_LCKR_LCK15_Msk
#define GPIO_LCKR_LCKK_Pos                  (16UL)
#define GPIO_LCKR_LCKK_Msk                  (0x1UL << GPIO_LCKR_LCKK_Pos)           /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                      GPIO_LCKR_LCKK_Msk

/****************** Bit definition for GPIO_AFRL register *********************/
#define GPIO_AFRL_AFSEL0_Pos                (0UL)
#define GPIO_AFRL_AFSEL0_Msk                (0xFUL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x0000000F */
#define GPIO_AFRL_AFSEL0                    GPIO_AFRL_AFSEL0_Msk
#define GPIO_AFRL_AFSEL0_0                  (0x1UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000001 */
#define GPIO_AFRL_AFSEL0_1                  (0x2UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000002 */
#define GPIO_AFRL_AFSEL0_2                  (0x4UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000004 */
#define GPIO_AFRL_AFSEL0_3                  (0x8UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000008 */
#define GPIO_AFRL_AFSEL1_Pos                (4UL)
#define GPIO_AFRL_AFSEL1_Msk                (0xFUL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRL_AFSEL1                    GPIO_AFRL_AFSEL1_Msk
#define GPIO_AFRL_AFSEL1_0                  (0x1UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000010 */
#define GPIO_AFRL_AFSEL1_1                  (0x2UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000020 */
#define GPIO_AFRL_AFSEL1_2                  (0x4UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000040 */
#define GPIO_AFRL_AFSEL1_3                  (0x8UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000080 */
#define GPIO_AFRL_AFSEL2_Pos                (8UL)
#define GPIO_AFRL_AFSEL2_Msk                (0xFUL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRL_AFSEL2                    GPIO_AFRL_AFSEL2_Msk
#define GPIO_AFRL_AFSEL2_0                  (0x1UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000100 */
#define GPIO_AFRL_AFSEL2_1                  (0x2UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000200 */
#define GPIO_AFRL_AFSEL2_2                  (0x4UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000400 */
#define GPIO_AFRL_AFSEL2_3                  (0x8UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000800 */
#define GPIO_AFRL_AFSEL3_Pos                (12UL)
#define GPIO_AFRL_AFSEL3_Msk                (0xFUL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRL_AFSEL3                    GPIO_AFRL_AFSEL3_Msk
#define GPIO_AFRL_AFSEL3_0                  (0x1UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00001000 */
#define GPIO_AFRL_AFSEL3_1                  (0x2UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00002000 */
#define GPIO_AFRL_AFSEL3_2                  (0x4UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00004000 */
#define GPIO_AFRL_AFSEL3_3                  (0x8UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00008000 */
#define GPIO_AFRL_AFSEL4_Pos                (16UL)
#define GPIO_AFRL_AFSEL4_Msk                (0xFUL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRL_AFSEL4                    GPIO_AFRL_AFSEL4_Msk
#define GPIO_AFRL_AFSEL4_0                  (0x1UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00010000 */
#define GPIO_AFRL_AFSEL4_1                  (0x2UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00020000 */
#define GPIO_AFRL_AFSEL4_2                  (0x4UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00040000 */
#define GPIO_AFRL_AFSEL4_3                  (0x8UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00080000 */
#define GPIO_AFRL_AFSEL5_Pos                (20UL)
#define GPIO_AFRL_AFSEL5_Msk                (0xFUL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRL_AFSEL5                    GPIO_AFRL_AFSEL5_Msk
#define GPIO_AFRL_AFSEL5_0                  (0x1UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00100000 */
#define GPIO_AFRL_AFSEL5_1                  (0x2UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00200000 */
#define GPIO_AFRL_AFSEL5_2                  (0x4UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00400000 */
#define GPIO_AFRL_AFSEL5_3                  (0x8UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00800000 */
#define GPIO_AFRL_AFSEL6_Pos                (24UL)
#define GPIO_AFRL_AFSEL6_Msk                (0xFUL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRL_AFSEL6                    GPIO_AFRL_AFSEL6_Msk
#define GPIO_AFRL_AFSEL6_0                  (0x1UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x01000000 */
#define GPIO_AFRL_AFSEL6_1                  (0x2UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x02000000 */
#define GPIO_AFRL_AFSEL6_2                  (0x4UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x04000000 */
#define GPIO_AFRL_AFSEL6_3                  (0x8UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x08000000 */
#define GPIO_AFRL_AFSEL7_Pos                (28UL)
#define GPIO_AFRL_AFSEL7_Msk                (0xFUL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRL_AFSEL7                    GPIO_AFRL_AFSEL7_Msk
#define GPIO_AFRL_AFSEL7_0                  (0x1UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x10000000 */
#define GPIO_AFRL_AFSEL7_1                  (0x2UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x20000000 */
#define GPIO_AFRL_AFSEL7_2                  (0x4UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x40000000 */
#define GPIO_AFRL_AFSEL7_3                  (0x8UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x80000000 */

/****************** Bit definition for GPIO_AFRH register *********************/
#define GPIO_AFRH_AFSEL8_Pos                (0UL)
#define GPIO_AFRH_AFSEL8_Msk                (0xFUL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x0000000F */
#define GPIO_AFRH_AFSEL8                    GPIO_AFRH_AFSEL8_Msk
#define GPIO_AFRH_AFSEL8_0                  (0x1UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000001 */
#define GPIO_AFRH_AFSEL8_1                  (0x2UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000002 */
#define GPIO_AFRH_AFSEL8_2                  (0x4UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000004 */
#define GPIO_AFRH_AFSEL8_3                  (0x8UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000008 */
#define GPIO_AFRH_AFSEL9_Pos                (4UL)
#define GPIO_AFRH_AFSEL9_Msk                (0xFUL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRH_AFSEL9                    GPIO_AFRH_AFSEL9_Msk
#define GPIO_AFRH_AFSEL9_0                  (0x1UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000010 */
#define GPIO_AFRH_AFSEL9_1                  (0x2UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000020 */
#define GPIO_AFRH_AFSEL9_2                  (0x4UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000040 */
#define GPIO_AFRH_AFSEL9_3                  (0x8UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000080 */
#define GPIO_AFRH_AFSEL10_Pos               (8UL)
#define GPIO_AFRH_AFSEL10_Msk               (0xFUL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000F00 */
#define GPIO_AFRH_AFSEL10                   GPIO_AFRH_AFSEL10_Msk
#define GPIO_AFRH_AFSEL10_0                 (0x1UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000100 */
#define GPIO_AFRH_AFSEL10_1                 (0x2UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000200 */
#define GPIO_AFRH_AFSEL10_2                 (0x4UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000400 */
#define GPIO_AFRH_AFSEL10_3                 (0x8UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000800 */
#define GPIO_AFRH_AFSEL11_Pos               (12UL)
#define GPIO_AFRH_AFSEL11_Msk               (0xFUL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x0000F000 */
#define GPIO_AFRH_AFSEL11                   GPIO_AFRH_AFSEL11_Msk
#define GPIO_AFRH_AFSEL11_0                 (0x1UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00001000 */
#define GPIO_AFRH_AFSEL11_1                 (0x2UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00002000 */
#define GPIO_AFRH_AFSEL11_2                 (0x4UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00004000 */
#define GPIO_AFRH_AFSEL11_3                 (0x8UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00008000 */
#define GPIO_AFRH_AFSEL12_Pos               (16UL)
#define GPIO_AFRH_AFSEL12_Msk               (0xFUL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x000F0000 */
#define GPIO_AFRH_AFSEL12                   GPIO_AFRH_AFSEL12_Msk
#define GPIO_AFRH_AFSEL12_0                 (0x1UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00010000 */
#define GPIO_AFRH_AFSEL12_1                 (0x2UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00020000 */
#define GPIO_AFRH_AFSEL12_2                 (0x4UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00040000 */
#define GPIO_AFRH_AFSEL12_3                 (0x8UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00080000 */
#define GPIO_AFRH_AFSEL13_Pos               (20UL)
#define GPIO_AFRH_AFSEL13_Msk               (0xFUL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00F00000 */
#define GPIO_AFRH_AFSEL13                   GPIO_AFRH_AFSEL13_Msk
#define GPIO_AFRH_AFSEL13_0                 (0x1UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00100000 */
#define GPIO_AFRH_AFSEL13_1                 (0x2UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00200000 */
#define GPIO_AFRH_AFSEL13_2                 (0x4UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00400000 */
#define GPIO_AFRH_AFSEL13_3                 (0x8UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00800000 */
#define GPIO_AFRH_AFSEL14_Pos               (24UL)
#define GPIO_AFRH_AFSEL14_Msk               (0xFUL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x0F000000 */
#define GPIO_AFRH_AFSEL14                   GPIO_AFRH_AFSEL14_Msk
#define GPIO_AFRH_AFSEL14_0                 (0x1UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x01000000 */
#define GPIO_AFRH_AFSEL14_1                 (0x2UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x02000000 */
#define GPIO_AFRH_AFSEL14_2                 (0x4UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x04000000 */
#define GPIO_AFRH_AFSEL14_3                 (0x8UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x08000000 */
#define GPIO_AFRH_AFSEL15_Pos               (28UL)
#define GPIO_AFRH_AFSEL15_Msk               (0xFUL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0xF0000000 */
#define GPIO_AFRH_AFSEL15                   GPIO_AFRH_AFSEL15_Msk
#define GPIO_AFRH_AFSEL15_0                 (0x1UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x10000000 */
#define GPIO_AFRH_AFSEL15_1                 (0x2UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x20000000 */
#define GPIO_AFRH_AFSEL15_2                 (0x4UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x40000000 */
#define GPIO_AFRH_AFSEL15_3                 (0x8UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_BRR register  ******************/
#define GPIO_BRR_BR0_Pos                    (0UL)
#define GPIO_BRR_BR0_Msk                    (0x1UL << GPIO_BRR_BR0_Pos)             /*!< 0x00000001 */
#define GPIO_BRR_BR0                        GPIO_BRR_BR0_Msk
#define GPIO_BRR_BR1_Pos                    (1UL)
#define GPIO_BRR_BR1_Msk                    (0x1UL << GPIO_BRR_BR1_Pos)             /*!< 0x00000002 */
#define GPIO_BRR_BR1                        GPIO_BRR_BR1_Msk
#define GPIO_BRR_BR2_Pos                    (2UL)
#define GPIO_BRR_BR2_Msk                    (0x1UL << GPIO_BRR_BR2_Pos)             /*!< 0x00000004 */
#define GPIO_BRR_BR2                        GPIO_BRR_BR2_Msk
#define GPIO_BRR_BR3_Pos                    (3UL)
#define GPIO_BRR_BR3_Msk                    (0x1UL << GPIO_BRR_BR3_Pos)             /*!< 0x00000008 */
#define GPIO_BRR_BR3                        GPIO_BRR_BR3_Msk
#define GPIO_BRR_BR4_Pos                    (4UL)
#define GPIO_BRR_BR4_Msk                    (0x1UL << GPIO_BRR_BR4_Pos)             /*!< 0x00000010 */
#define GPIO_BRR_BR4                        GPIO_BRR_BR4_Msk
#define GPIO_BRR_BR5_Pos                    (5UL)
#define GPIO_BRR_BR5_Msk                    (0x1UL << GPIO_BRR_BR5_Pos)             /*!< 0x00000020 */
#define GPIO_BRR_BR5                        GPIO_BRR_BR5_Msk
#define GPIO_BRR_BR6_Pos                    (6UL)
#define GPIO_BRR_BR6_Msk                    (0x1UL << GPIO_BRR_BR6_Pos)             /*!< 0x00000040 */
#define GPIO_BRR_BR6                        GPIO_BRR_BR6_Msk
#define GPIO_BRR_BR7_Pos                    (7UL)
#define GPIO_BRR_BR7_Msk                    (0x1UL << GPIO_BRR_BR7_Pos)             /*!< 0x00000080 */
#define GPIO_BRR_BR7                        GPIO_BRR_BR7_Msk
#define GPIO_BRR_BR8_Pos                    (8UL)
#define GPIO_BRR_BR8_Msk                    (0x1UL << GPIO_BRR_BR8_Pos)             /*!< 0x00000100 */
#define GPIO_BRR_BR8                        GPIO_BRR_BR8_Msk
#define GPIO_BRR_BR9_Pos                    (9UL)
#define GPIO_BRR_BR9_Msk                    (0x1UL << GPIO_BRR_BR9_Pos)             /*!< 0x00000200 */
#define GPIO_BRR_BR9                        GPIO_BRR_BR9_Msk
#define GPIO_BRR_BR10_Pos                   (10UL)
#define GPIO_BRR_BR10_Msk                   (0x1UL << GPIO_BRR_BR10_Pos)            /*!< 0x00000400 */
#define GPIO_BRR_BR10                       GPIO_BRR_BR10_Msk
#define GPIO_BRR_BR11_Pos                   (11UL)
#define GPIO_BRR_BR11_Msk                   (0x1UL << GPIO_BRR_BR11_Pos)            /*!< 0x00000800 */
#define GPIO_BRR_BR11                       GPIO_BRR_BR11_Msk
#define GPIO_BRR_BR12_Pos                   (12UL)
#define GPIO_BRR_BR12_Msk                   (0x1UL << GPIO_BRR_BR12_Pos)            /*!< 0x00001000 */
#define GPIO_BRR_BR12                       GPIO_BRR_BR12_Msk
#define GPIO_BRR_BR13_Pos                   (13UL)
#define GPIO_BRR_BR13_Msk                   (0x1UL << GPIO_BRR_BR13_Pos)            /*!< 0x00002000 */
#define GPIO_BRR_BR13                       GPIO_BRR_BR13_Msk
#define GPIO_BRR_BR14_Pos                   (14UL)
#define GPIO_BRR_BR14_Msk                   (0x1UL << GPIO_BRR_BR14_Pos)            /*!< 0x00004000 */
#define GPIO_BRR_BR14                       GPIO_BRR_BR14_Msk
#define GPIO_BRR_BR15_Pos                   (15UL)
#define GPIO_BRR_BR15_Msk                   (0x1UL << GPIO_BRR_BR15_Pos)            /*!< 0x00008000 */
#define GPIO_BRR_BR15                       GPIO_BRR_BR15_Msk

/******************  Bits definition for GPIO_HSLVR register  ******************/
#define GPIO_HSLVR_HSLV0_Pos                (0UL)
#define GPIO_HSLVR_HSLV0_Msk                (0x1UL << GPIO_HSLVR_HSLV0_Pos)         /*!< 0x00000001 */
#define GPIO_HSLVR_HSLV0                    GPIO_HSLVR_HSLV0_Msk
#define GPIO_HSLVR_HSLV1_Pos                (1UL)
#define GPIO_HSLVR_HSLV1_Msk                (0x1UL << GPIO_HSLVR_HSLV1_Pos)         /*!< 0x00000002 */
#define GPIO_HSLVR_HSLV1                    GPIO_HSLVR_HSLV1_Msk
#define GPIO_HSLVR_HSLV2_Pos                (2UL)
#define GPIO_HSLVR_HSLV2_Msk                (0x1UL << GPIO_HSLVR_HSLV2_Pos)         /*!< 0x00000004 */
#define GPIO_HSLVR_HSLV2                    GPIO_HSLVR_HSLV2_Msk
#define GPIO_HSLVR_HSLV3_Pos                (3UL)
#define GPIO_HSLVR_HSLV3_Msk                (0x1UL << GPIO_HSLVR_HSLV3_Pos)         /*!< 0x00000008 */
#define GPIO_HSLVR_HSLV3                    GPIO_HSLVR_HSLV3_Msk
#define GPIO_HSLVR_HSLV4_Pos                (4UL)
#define GPIO_HSLVR_HSLV4_Msk                (0x1UL << GPIO_HSLVR_HSLV4_Pos)         /*!< 0x00000010 */
#define GPIO_HSLVR_HSLV4                    GPIO_HSLVR_HSLV4_Msk
#define GPIO_HSLVR_HSLV5_Pos                (5UL)
#define GPIO_HSLVR_HSLV5_Msk                (0x1UL << GPIO_HSLVR_HSLV5_Pos)         /*!< 0x00000020 */
#define GPIO_HSLVR_HSLV5                    GPIO_HSLVR_HSLV5_Msk
#define GPIO_HSLVR_HSLV6_Pos                (6UL)
#define GPIO_HSLVR_HSLV6_Msk                (0x1UL << GPIO_HSLVR_HSLV6_Pos)         /*!< 0x00000040 */
#define GPIO_HSLVR_HSLV6                    GPIO_HSLVR_HSLV6_Msk
#define GPIO_HSLVR_HSLV7_Pos                (7UL)
#define GPIO_HSLVR_HSLV7_Msk                (0x1UL << GPIO_HSLVR_HSLV7_Pos)         /*!< 0x00000080 */
#define GPIO_HSLVR_HSLV7                    GPIO_HSLVR_HSLV7_Msk
#define GPIO_HSLVR_HSLV8_Pos                (8UL)
#define GPIO_HSLVR_HSLV8_Msk                (0x1UL << GPIO_HSLVR_HSLV8_Pos)         /*!< 0x00000100 */
#define GPIO_HSLVR_HSLV8                    GPIO_HSLVR_HSLV8_Msk
#define GPIO_HSLVR_HSLV9_Pos                (9UL)
#define GPIO_HSLVR_HSLV9_Msk                (0x1UL << GPIO_HSLVR_HSLV9_Pos)         /*!< 0x00000200 */
#define GPIO_HSLVR_HSLV9                    GPIO_HSLVR_HSLV9_Msk
#define GPIO_HSLVR_HSLV10_Pos               (10UL)
#define GPIO_HSLVR_HSLV10_Msk               (0x1UL << GPIO_HSLVR_HSLV10_Pos)        /*!< 0x00000400 */
#define GPIO_HSLVR_HSLV10                   GPIO_HSLVR_HSLV10_Msk
#define GPIO_HSLVR_HSLV11_Pos               (11UL)
#define GPIO_HSLVR_HSLV11_Msk               (x1UL << GPIO_HSLVR_HSLV11_Pos)         /*!< 0x00000800 */
#define GPIO_HSLVR_HSLV11                   GPIO_HSLVR_HSLV11_Msk
#define GPIO_HSLVR_HSLV12_Pos               (12UL)
#define GPIO_HSLVR_HSLV12_Msk               (0x1UL << GPIO_HSLVR_HSLV12_Pos)        /*!< 0x00001000 */
#define GPIO_HSLVR_HSLV12                   GPIO_HSLVR_HSLV12_Msk
#define GPIO_HSLVR_HSLV13_Pos               (13UL)
#define GPIO_HSLVR_HSLV13_Msk               (0x1UL << GPIO_HSLVR_HSLV13_Pos)        /*!< 0x00002000 */
#define GPIO_HSLVR_HSLV13                   GPIO_HSLVR_HSLV13_Msk
#define GPIO_HSLVR_HSLV14_Pos               (14UL)
#define GPIO_HSLVR_HSLV14_Msk               (0x1UL << GPIO_HSLVR_HSLV14_Pos)        /*!< 0x00004000 */
#define GPIO_HSLVR_HSLV14                   GPIO_HSLVR_HSLV14_Msk
#define GPIO_HSLVR_HSLV15_Pos               (15UL)
#define GPIO_HSLVR_HSLV15_Msk               (0x1UL << GPIO_HSLVR_HSLV15_Pos)        /*!< 0x00008000 */
#define GPIO_HSLVR_HSLV15                   GPIO_HSLVR_HSLV15_Msk

/******************  Bits definition for GPIO_SECCFGR register  ******************/
#define GPIO_SECCFGR_SEC0_Pos               (0UL)
#define GPIO_SECCFGR_SEC0_Msk               (0x1UL << GPIO_SECCFGR_SEC0_Pos)        /*!< 0x00000001 */
#define GPIO_SECCFGR_SEC0                   GPIO_SECCFGR_SEC0_Msk
#define GPIO_SECCFGR_SEC1_Pos               (1UL)
#define GPIO_SECCFGR_SEC1_Msk               (0x1UL << GPIO_SECCFGR_SEC1_Pos)        /*!< 0x00000002 */
#define GPIO_SECCFGR_SEC1                   GPIO_SECCFGR_SEC1_Msk
#define GPIO_SECCFGR_SEC2_Pos               (2UL)
#define GPIO_SECCFGR_SEC2_Msk               (0x1UL << GPIO_SECCFGR_SEC2_Pos)        /*!< 0x00000004 */
#define GPIO_SECCFGR_SEC2                   GPIO_SECCFGR_SEC2_Msk
#define GPIO_SECCFGR_SEC3_Pos               (3UL)
#define GPIO_SECCFGR_SEC3_Msk               (0x1UL << GPIO_SECCFGR_SEC3_Pos)        /*!< 0x00000008 */
#define GPIO_SECCFGR_SEC3                   GPIO_SECCFGR_SEC3_Msk
#define GPIO_SECCFGR_SEC4_Pos               (4UL)
#define GPIO_SECCFGR_SEC4_Msk               (0x1UL << GPIO_SECCFGR_SEC4_Pos)        /*!< 0x00000010 */
#define GPIO_SECCFGR_SEC4                   GPIO_SECCFGR_SEC4_Msk
#define GPIO_SECCFGR_SEC5_Pos               (5UL)
#define GPIO_SECCFGR_SEC5_Msk               (0x1UL << GPIO_SECCFGR_SEC5_Pos)        /*!< 0x00000020 */
#define GPIO_SECCFGR_SEC5                   GPIO_SECCFGR_SEC5_Msk
#define GPIO_SECCFGR_SEC6_Pos               (6UL)
#define GPIO_SECCFGR_SEC6_Msk               (0x1UL << GPIO_SECCFGR_SEC6_Pos)        /*!< 0x00000040 */
#define GPIO_SECCFGR_SEC6                   GPIO_SECCFGR_SEC6_Msk
#define GPIO_SECCFGR_SEC7_Pos               (7UL)
#define GPIO_SECCFGR_SEC7_Msk               (0x1UL << GPIO_SECCFGR_SEC7_Pos)        /*!< 0x00000080 */
#define GPIO_SECCFGR_SEC7                   GPIO_SECCFGR_SEC7_Msk
#define GPIO_SECCFGR_SEC8_Pos               (8UL)
#define GPIO_SECCFGR_SEC8_Msk               (0x1UL << GPIO_SECCFGR_SEC8_Pos)        /*!< 0x00000100 */
#define GPIO_SECCFGR_SEC8                   GPIO_SECCFGR_SEC8_Msk
#define GPIO_SECCFGR_SEC9_Pos               (9UL)
#define GPIO_SECCFGR_SEC9_Msk               (0x1UL << GPIO_SECCFGR_SEC9_Pos)        /*!< 0x00000200 */
#define GPIO_SECCFGR_SEC9                   GPIO_SECCFGR_SEC9_Msk
#define GPIO_SECCFGR_SEC10_Pos              (10UL)
#define GPIO_SECCFGR_SEC10_Msk              (0x1UL << GPIO_SECCFGR_SEC10_Pos)       /*!< 0x00000400 */
#define GPIO_SECCFGR_SEC10                  GPIO_SECCFGR_SEC10_Msk
#define GPIO_SECCFGR_SEC11_Pos              (11UL)
#define GPIO_SECCFGR_SEC11_Msk              (x1UL << GPIO_SECCFGR_SEC11_Pos)        /*!< 0x00000800 */
#define GPIO_SECCFGR_SEC11                  GPIO_SECCFGR_SEC11_Msk
#define GPIO_SECCFGR_SEC12_Pos              (12UL)
#define GPIO_SECCFGR_SEC12_Msk              (0x1UL << GPIO_SECCFGR_SEC12_Pos)       /*!< 0x00001000 */
#define GPIO_SECCFGR_SEC12                  GPIO_SECCFGR_SEC12_Msk
#define GPIO_SECCFGR_SEC13_Pos              (13UL)
#define GPIO_SECCFGR_SEC13_Msk              (0x1UL << GPIO_SECCFGR_SEC13_Pos)       /*!< 0x00002000 */
#define GPIO_SECCFGR_SEC13                  GPIO_SECCFGR_SEC13_Msk
#define GPIO_SECCFGR_SEC14_Pos              (14UL)
#define GPIO_SECCFGR_SEC14_Msk              (0x1UL << GPIO_SECCFGR_SEC14_Pos)       /*!< 0x00004000 */
#define GPIO_SECCFGR_SEC14                  GPIO_SECCFGR_SEC14_Msk
#define GPIO_SECCFGR_SEC15_Pos              (15UL)
#define GPIO_SECCFGR_SEC15_Msk              (0x1UL << GPIO_SECCFGR_SEC15_Pos)       /*!< 0x00008000 */
#define GPIO_SECCFGR_SEC15                  GPIO_SECCFGR_SEC15_Msk


/*****************************************************************************/
/*                                                                           */
/*                        Global TrustZone Control                           */
/*                                                                           */
/*****************************************************************************/
/*******************  Bits definition for GTZC_TZSC_CR register  ******************/
#define GTZC_TZSC_CR_LCK_Pos                (0UL)
#define GTZC_TZSC_CR_LCK_Msk                (0x01UL << GTZC_TZSC_CR_LCK_Pos)        /*!< 0x00000001 */
#define GTZC_TZSC_CR_LCK                    GTZC_TZSC_CR_LCK_Msk                    /*!< GTZC Secure and privilege configurations lock */

/*******  Bits definition for GTZC_TZSC_SECCFGRx/_PRIVCFGRx registers  *****/
/*******  Bits definition for GTZC_TZIC_IERx/_SRx/_IFCRx registers  ********/

/*******************  Bits definition for GTZC_TZSC_SECCFGR1 register  ***************/
#define GTZC_CFGR1_TIM2_Pos                 GTZC_TZSC_SECCFGR1_TIM2SEC_Pos
#define GTZC_CFGR1_TIM2_Msk                 (0x01UL << GTZC_CFGR1_TIM2_Pos)
#define GTZC_CFGR1_TIM3_Pos                 GTZC_TZSC_SECCFGR1_TIM3SEC_Pos
#define GTZC_CFGR1_TIM3_Msk                 (0x01UL << GTZC_CFGR1_TIM3_Pos)
#define GTZC_CFGR1_TIM4_Pos                 GTZC_TZSC_SECCFGR1_TIM4SEC_Pos
#define GTZC_CFGR1_TIM4_Msk                 (0x01UL << GTZC_CFGR1_TIM4_Pos)
#define GTZC_CFGR1_WWDG_Pos                 GTZC_TZSC_SECCFGR1_WWDGSEC_Pos
#define GTZC_CFGR1_WWDG_Msk                 (0x01UL << GTZC_CFGR1_WWDG_Pos)
#define GTZC_CFGR1_IWDG_Pos                 GTZC_TZSC_SECCFGR1_IWDGSEC_Pos
#define GTZC_CFGR1_IWDG_Msk                 (0x01UL << GTZC_CFGR1_IWDG_Pos)
#define GTZC_CFGR1_SPI2_Pos                 GTZC_TZSC_SECCFGR1_SPI2SEC_Pos
#define GTZC_CFGR1_SPI2_Msk                 (0x01UL << GTZC_CFGR1_SPI2_Pos)
#define GTZC_CFGR1_USART2_Pos               GTZC_TZSC_SECCFGR1_USART2SEC_Pos
#define GTZC_CFGR1_USART2_Msk               (0x01UL << GTZC_CFGR1_USART2_Pos)
#define GTZC_CFGR1_USART3_Pos               GTZC_TZSC_SECCFGR1_USART3SEC_Pos
#define GTZC_CFGR1_USART3_Msk               (0x01UL << GTZC_CFGR1_USART3_Pos)
#define GTZC_CFGR1_I2C1_Pos                 GTZC_TZSC_SECCFGR1_I2C1SEC_Pos
#define GTZC_CFGR1_I2C1_Msk                 (0x01UL << GTZC_CFGR1_I2C1_Pos)
#define GTZC_CFGR1_I2C2_Pos                 GTZC_TZSC_SECCFGR1_I2C2SEC_Pos
#define GTZC_CFGR1_I2C2_Msk                 (0x01UL << GTZC_CFGR1_I2C2_Pos)
#define GTZC_CFGR1_I2C4_Pos                 GTZC_TZSC_SECCFGR1_I2C4SEC_Pos
#define GTZC_CFGR1_I2C4_Msk                 (0x01UL << GTZC_CFGR1_I2C4_Pos)
#define GTZC_CFGR1_LPTIM2_Pos               GTZC_TZSC_SECCFGR1_LPTIM2SEC_Pos
#define GTZC_CFGR1_LPTIM2_Msk               (0x01UL << GTZC_CFGR1_LPTIM2_Pos)

/*******************  Bits definition for GTZC_TZSC_SECCFGR2 register  ***************/
#define GTZC_CFGR2_TIM1_Pos                 GTZC_TZSC_SECCFGR2_TIM1SEC_Pos
#define GTZC_CFGR2_TIM1_Msk                 (0x01UL << GTZC_CFGR2_TIM1_Pos)
#define GTZC_CFGR2_SPI1_Pos                 GTZC_TZSC_SECCFGR2_SPI1SEC_Pos
#define GTZC_CFGR2_SPI1_Msk                 (0x01UL << GTZC_CFGR2_SPI1_Pos)
#define GTZC_CFGR2_USART1_Pos               GTZC_TZSC_SECCFGR2_USART1SEC_Pos
#define GTZC_CFGR2_USART1_Msk               (0x01UL << GTZC_CFGR2_USART1_Pos)
#define GTZC_CFGR2_TIM16_Pos                GTZC_TZSC_SECCFGR2_TIM16SEC_Pos
#define GTZC_CFGR2_TIM16_Msk                (0x01UL << GTZC_CFGR2_TIM16_Pos)
#define GTZC_CFGR2_TIM17_Pos                GTZC_TZSC_SECCFGR2_TIM17SEC_Pos
#define GTZC_CFGR2_TIM17_Msk                (0x01UL << GTZC_CFGR2_TIM17_Pos)
#define GTZC_CFGR2_SAI1_Pos                 GTZC_TZSC_SECCFGR2_SAI1SEC_Pos
#define GTZC_CFGR2_SAI1_Msk                 (0x01UL << GTZC_CFGR2_SAI1_Pos)
#define GTZC_CFGR2_SPI3_Pos                 GTZC_TZSC_SECCFGR2_SPI3SEC_Pos
#define GTZC_CFGR2_SPI3_Msk                 (0x01UL << GTZC_CFGR2_SPI3_Pos)
#define GTZC_CFGR2_LPUART1_Pos              GTZC_TZSC_SECCFGR2_LPUART1SEC_Pos
#define GTZC_CFGR2_LPUART1_Msk              (0x01UL << GTZC_CFGR2_LPUART1_Pos)
#define GTZC_CFGR2_I2C3_Pos                 GTZC_TZSC_SECCFGR2_I2C3SEC_Pos
#define GTZC_CFGR2_I2C3_Msk                 (0x01UL << GTZC_CFGR2_I2C3_Pos)
#define GTZC_CFGR2_LPTIM1_Pos               GTZC_TZSC_SECCFGR2_LPTIM1SEC_Pos
#define GTZC_CFGR2_LPTIM1_Msk               (0x01UL << GTZC_CFGR2_LPTIM1_Pos)
#define GTZC_CFGR2_COMP_Pos                 GTZC_TZSC_SECCFGR2_COMPSEC_Pos
#define GTZC_CFGR2_COMP_Msk                 (0x01UL << GTZC_CFGR2_COMP_Pos)
#define GTZC_CFGR2_ADC4_Pos                 GTZC_TZSC_SECCFGR2_ADC4SEC_Pos
#define GTZC_CFGR2_ADC4_Msk                 (0x01UL << GTZC_CFGR2_ADC4_Pos)
#define GTZC_CFGR2_VREFBUF_Pos              GTZC_TZSC_SECCFGR2_VREFBUFSEC_Pos
#define GTZC_CFGR2_VREFBUF_Msk              (0x01UL << GTZC_CFGR2_VREFBUFSEC_Pos)

/*******************  Bits definition for GTZC_TZSC_SECCFGR3 register  ***************/
#define GTZC_CFGR3_CRC_Pos                  GTZC_TZSC_SECCFGR3_CRCSEC_Pos
#define GTZC_CFGR3_CRC_Msk                  (0x01UL << GTZC_CFGR3_CRC_Pos)
#define GTZC_CFGR3_TSC_Pos                  GTZC_TZSC_SECCFGR3_TSCSEC_Pos
#define GTZC_CFGR3_TSC_Msk                  (0x01UL << GTZC_CFGR3_TSC_Pos)
#define GTZC_CFGR3_ICACHE_REG_Pos           GTZC_TZSC_SECCFGR3_ICACHE_REGSEC_Pos
#define GTZC_CFGR3_ICACHE_REG_Msk           (0x01UL << GTZC_CFGR3_ICACHE_REG_Pos)
#define GTZC_CFGR3_OTG_Pos                  GTZC_TZSC_SECCFGR3_OTGSEC_Pos
#define GTZC_CFGR3_OTG_Msk                  (0x01UL << GTZC_CFGR3_OTG_Pos)
#define GTZC_CFGR3_AES_Pos                  GTZC_TZSC_SECCFGR3_AESSEC_Pos
#define GTZC_CFGR3_AES_Msk                  (0x01UL << GTZC_CFGR3_AES_Pos)
#define GTZC_CFGR3_HASH_Pos                 GTZC_TZSC_SECCFGR3_HASHSEC_Pos
#define GTZC_CFGR3_HASH_Msk                 (0x01UL << GTZC_CFGR3_HASH_Pos)
#define GTZC_CFGR3_RNG_Pos                  GTZC_TZSC_SECCFGR3_RNGSEC_Pos
#define GTZC_CFGR3_RNG_Msk                  (0x01UL << GTZC_CFGR3_RNG_Pos)
#define GTZC_CFGR3_SAES_Pos                 GTZC_TZSC_SECCFGR3_SAESSEC_Pos
#define GTZC_CFGR3_SAES_Msk                 (0x01UL << GTZC_CFGR3_SAES_Pos)
#define GTZC_CFGR3_HSEM_Pos                 GTZC_TZIC_IER3_HSEMIE_Pos
#define GTZC_CFGR3_HSEM_Msk                 (0x01UL << GTZC_CFGR3_HSEM_Pos)
#define GTZC_CFGR3_PKA_Pos                  GTZC_TZSC_SECCFGR3_PKASEC_Pos
#define GTZC_CFGR3_PKA_Msk                  (0x01UL << GTZC_CFGR3_PKA_Pos)
#define GTZC_CFGR3_RAMCFG_Pos               GTZC_TZSC_SECCFGR3_RAMCFGSEC_Pos
#define GTZC_CFGR3_RAMCFG_Msk               (0x01UL << GTZC_CFGR3_RAMCFG_Pos)
#define GTZC_CFGR3_RADIO_Pos                GTZC_TZSC_SECCFGR3_RADIOSEC_Pos
#define GTZC_CFGR3_RADIO_Msk                (0x01UL << GTZC_CFGR3_RADIO_Pos)
#define GTZC_CFGR3_PTACONV_Pos              GTZC_TZSC_SECCFGR3_PTACONVSEC_Pos
#define GTZC_CFGR3_PTACONV_Msk              (0x01UL << GTZC_CFGR3_PTACONV_Pos)

/*******************  Bits definition for GTZC_TZIC_IER4 register  ***************/
#define GTZC_CFGR4_GPDMA1_Pos               GTZC_TZIC_IER4_GPDMA1IE_Pos
#define GTZC_CFGR4_GPDMA1_Msk               (0x01UL << GTZC_CFGR4_GPDMA1_Pos)
#define GTZC_CFGR4_FLASH_Pos                GTZC_TZIC_IER4_FLASHIE_Pos
#define GTZC_CFGR4_FLASH_Msk                (0x01UL << GTZC_CFGR4_FLASH_Pos)
#define GTZC_CFGR4_FLASH_REG_Pos            GTZC_TZIC_IER4_FLASH_REGIE_Pos
#define GTZC_CFGR4_FLASH_REG_Msk            (0x01UL << GTZC_CFGR4_FLASH_REG_Pos)
#define GTZC_CFGR4_TZSC_Pos                 GTZC_TZIC_IER4_TZSCIE_Pos
#define GTZC_CFGR4_TZSC_Msk                 (0x01UL << GTZC_CFGR4_TZSC_Pos)
#define GTZC_CFGR4_TZIC_Pos                 GTZC_TZIC_IER4_TZICIE_Pos
#define GTZC_CFGR4_TZIC_Msk                 (0x01UL << GTZC_CFGR4_TZIC_Pos)
#define GTZC_CFGR4_SYSCFG_Pos               GTZC_TZIC_IER4_SYSCFGIE_Pos
#define GTZC_CFGR4_SYSCFG_Msk               (0x01UL << GTZC_CFGR4_SYSCFG_Pos)
#define GTZC_CFGR4_RTC_Pos                  GTZC_TZIC_IER4_RTCIE_Pos
#define GTZC_CFGR4_RTC_Msk                  (0x01UL << GTZC_CFGR4_RTC_Pos)
#define GTZC_CFGR4_TAMP_Pos                 GTZC_TZIC_IER4_TAMPIE_Pos
#define GTZC_CFGR4_TAMP_Msk                 (0x01UL << GTZC_CFGR4_TAMP_Pos)
#define GTZC_CFGR4_PWR_Pos                  GTZC_TZIC_IER4_PWRIE_Pos
#define GTZC_CFGR4_PWR_Msk                  (0x01UL << GTZC_CFGR4_PWR_Pos)
#define GTZC_CFGR4_RCC_Pos                  GTZC_TZIC_IER4_RCCIE_Pos
#define GTZC_CFGR4_RCC_sk                   (0x01UL << GTZC_CFGR4_RCC_Pos)
#define GTZC_CFGR4_EXTI_Pos                 GTZC_TZIC_IER4_EXTIIE_Pos
#define GTZC_CFGR4_EXTI_Msk                 (0x01UL << GTZC_CFGR4_EXTI_Pos)
#define GTZC_CFGR4_SRAM1_Pos                GTZC_TZIC_IER4_SRAM1IE_Pos
#define GTZC_CFGR4_SRAM1_Msk                (0x01UL << GTZC_CFGR4_SRAM1_Pos)
#define GTZC_CFGR4_MPCBB1_REG_Pos           GTZC_TZIC_IER4_MPCBB1IE_Pos
#define GTZC_CFGR4_MPCBB1_REG_Msk           (0x01UL << GTZC_CFGR4_MPCBB1_REG_Pos)
#define GTZC_CFGR4_SRAM2_Pos                GTZC_TZIC_IER4_SRAM2IE_Pos
#define GTZC_CFGR4_SRAM2_Msk                (0x01UL << GTZC_CFGR4_SRAM2_Pos)
#define GTZC_CFGR4_MPCBB2_REG_Pos           GTZC_TZIC_IER4_MPCBB2IE_Pos
#define GTZC_CFGR4_MPCBB2_REG_Msk           (0x01UL << GTZC_CFGR4_MPCBB2_REG_Pos)
#define GTZC_CFGR4_SRAM6_Pos                GTZC_TZIC_IER4_SRAM6IE_Pos
#define GTZC_CFGR4_SRAM6_Msk                (0x01UL << GTZC_CFGR4_SRAM6_Pos)
#define GTZC_CFGR4_MPCBB6_REG_Pos           GTZC_TZIC_IER4_MPCBB6IE_Pos
#define GTZC_CFGR4_MPCBB6_REG_Msk           (0x01UL << GTZC_CFGR4_MPCBB6_REG_Pos)

/***************  Bits definition for register x=1 (GTZC_TZSC_SECCFGR1) *************/
#define GTZC_TZSC_SECCFGR1_TIM2SEC_Pos              (0UL)
#define GTZC_TZSC_SECCFGR1_TIM2SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_TIM2SEC_Pos)
#define GTZC_TZSC_SECCFGR1_TIM2SEC                  GTZC_TZSC_SECCFGR1_TIM2SEC_Msk               /*!<  secure access mode for TIM2 */
#define GTZC_TZSC_SECCFGR1_TIM3SEC_Pos              (1UL)
#define GTZC_TZSC_SECCFGR1_TIM3SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_TIM3SEC_Pos)
#define GTZC_TZSC_SECCFGR1_TIM3SEC                  GTZC_TZSC_SECCFGR1_TIM3SEC_Msk               /*!<  secure access mode for TIM3 */
#define GTZC_TZSC_SECCFGR1_TIM4SEC_Pos              (2UL)
#define GTZC_TZSC_SECCFGR1_TIM4SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_TIM4SEC_Pos)
#define GTZC_TZSC_SECCFGR1_TIM4SEC                  GTZC_TZSC_SECCFGR1_TIM4SEC_Msk               /*!<  secure access mode for TIM4 */
#define GTZC_TZSC_SECCFGR1_WWDGSEC_Pos              (6UL)
#define GTZC_TZSC_SECCFGR1_WWDGSEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_WWDGSEC_Pos)
#define GTZC_TZSC_SECCFGR1_WWDGSEC                  GTZC_TZSC_SECCFGR1_WWDGSEC_Msk               /*!<  secure access mode for WWDG */
#define GTZC_TZSC_SECCFGR1_IWDGSEC_Pos              (7UL)
#define GTZC_TZSC_SECCFGR1_IWDGSEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_IWDGSEC_Pos)
#define GTZC_TZSC_SECCFGR1_IWDGSEC                  GTZC_TZSC_SECCFGR1_IWDGSEC_Msk               /*!<  secure access mode for IWDG */
#define GTZC_TZSC_SECCFGR1_SPI2SEC_Pos              (8UL)
#define GTZC_TZSC_SECCFGR1_SPI2SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_SPI2SEC_Pos)
#define GTZC_TZSC_SECCFGR1_SPI2SEC                  GTZC_TZSC_SECCFGR1_SPI2SEC_Msk               /*!<  secure access mode for IWDG */
#define GTZC_TZSC_SECCFGR1_USART2SEC_Pos            (9UL)
#define GTZC_TZSC_SECCFGR1_USART2SEC_Msk            (0x01UL << GTZC_TZSC_SECCFGR1_USART2SEC_Pos)
#define GTZC_TZSC_SECCFGR1_USART2SEC                GTZC_TZSC_SECCFGR1_USART2SEC_Msk             /*!<  secure access mode for USART2 */
#define GTZC_TZSC_SECCFGR1_USART3SEC_Pos            (10UL)
#define GTZC_TZSC_SECCFGR1_USART3SEC_Msk            (0x01UL << GTZC_TZSC_SECCFGR1_USART3SEC_Pos)
#define GTZC_TZSC_SECCFGR1_USART3SEC                GTZC_TZSC_SECCFGR1_USART3SEC_Msk             /*!<  secure access mode for USART3 */
#define GTZC_TZSC_SECCFGR1_I2C1SEC_Pos              (13UL)
#define GTZC_TZSC_SECCFGR1_I2C1SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_I2C1SEC_Pos)
#define GTZC_TZSC_SECCFGR1_I2C1SEC                  GTZC_TZSC_SECCFGR1_I2C1SEC_Msk               /*!<  secure access mode for I2C1 */
#define GTZC_TZSC_SECCFGR1_I2C2SEC_Pos              (14UL)
#define GTZC_TZSC_SECCFGR1_I2C2SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_I2C2SEC_Pos)
#define GTZC_TZSC_SECCFGR1_I2C2SEC                  GTZC_TZSC_SECCFGR1_I2C2SEC_Msk               /*!<  secure access mode for I2C2 */
#define GTZC_TZSC_SECCFGR1_I2C4SEC_Pos              (16UL)
#define GTZC_TZSC_SECCFGR1_I2C4SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR1_I2C4SEC_Pos)
#define GTZC_TZSC_SECCFGR1_I2C4SEC                  GTZC_TZSC_SECCFGR1_I2C4SEC_Msk               /*!<  secure access mode for I2C4 */
#define GTZC_TZSC_SECCFGR1_LPTIM2SEC_Pos            (17UL)
#define GTZC_TZSC_SECCFGR1_LPTIM2SEC_Msk            (0x01UL << GTZC_TZSC_SECCFGR1_LPTIM2SEC_Pos)
#define GTZC_TZSC_SECCFGR1_LPTIM2SEC                GTZC_TZSC_SECCFGR1_LPTIM2SEC_Msk             /*!<  secure access mode for LPTIM2 */

/***************  Bits definition for register x=2 (GTZC_TZSC_SECCFGR2) *************/
#define GTZC_TZSC_SECCFGR2_TIM1SEC_Pos              (0UL)
#define GTZC_TZSC_SECCFGR2_TIM1SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR2_TIM1SEC_Pos)
#define GTZC_TZSC_SECCFGR2_TIM1SEC                  GTZC_TZSC_SECCFGR2_TIM1SEC_Msk               /*!<  secure access mode for TIM1 */
#define GTZC_TZSC_SECCFGR2_SPI1SEC_Pos              (1UL)
#define GTZC_TZSC_SECCFGR2_SPI1SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR2_SPI1SEC_Pos)
#define GTZC_TZSC_SECCFGR2_SPI1SEC                  GTZC_TZSC_SECCFGR2_SPI1SEC_Msk               /*!<  secure access mode for SPI1 */
#define GTZC_TZSC_SECCFGR2_USART1SEC_Pos            (3UL)
#define GTZC_TZSC_SECCFGR2_USART1SEC_Msk            (0x01UL << GTZC_TZSC_SECCFGR2_USART1SEC_Pos)
#define GTZC_TZSC_SECCFGR2_USART1SEC                GTZC_TZSC_SECCFGR2_USART1SEC_Msk             /*!<  secure access mode for USART1 */
#define GTZC_TZSC_SECCFGR2_TIM16SEC_Pos             (5UL)
#define GTZC_TZSC_SECCFGR2_TIM16SEC_Msk             (0x01UL << GTZC_TZSC_SECCFGR2_TIM16SEC_Pos)
#define GTZC_TZSC_SECCFGR2_TIM16SEC                 GTZC_TZSC_SECCFGR2_TIM16SEC_Msk              /*!<  secure access mode for TIM16 */
#define GTZC_TZSC_SECCFGR2_TIM17SEC_Pos             (6UL)
#define GTZC_TZSC_SECCFGR2_TIM17SEC_Msk             (0x01UL << GTZC_TZSC_SECCFGR2_TIM17SEC_Pos)
#define GTZC_TZSC_SECCFGR2_TIM17SEC                 GTZC_TZSC_SECCFGR2_TIM17SEC_Msk              /*!<  secure access mode for TIM17 */
#define GTZC_TZSC_SECCFGR2_SAI1SEC_Pos              (7UL)
#define GTZC_TZSC_SECCFGR2_SAI1SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR2_SAI1SEC_Pos)
#define GTZC_TZSC_SECCFGR2_SAI1SEC                  GTZC_TZSC_SECCFGR2_SAI1SEC_Msk               /*!<  secure access mode for SAI1 */
#define GTZC_TZSC_SECCFGR2_SPI3SEC_Pos              (16UL)
#define GTZC_TZSC_SECCFGR2_SPI3SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR2_SPI3SEC_Pos)
#define GTZC_TZSC_SECCFGR2_SPI3SEC                  GTZC_TZSC_SECCFGR2_SPI3SEC_Msk               /*!<  secure access mode for SPI3 */
#define GTZC_TZSC_SECCFGR2_LPUART1SEC_Pos           (17UL)
#define GTZC_TZSC_SECCFGR2_LPUART1SEC_Msk           (0x01UL << GTZC_TZSC_SECCFGR2_LPUART1SEC_Pos)
#define GTZC_TZSC_SECCFGR2_LPUART1SEC               GTZC_TZSC_SECCFGR2_LPUART1SEC_Msk            /*!<  secure access mode for LPUART1 */
#define GTZC_TZSC_SECCFGR2_I2C3SEC_Pos              (18UL)
#define GTZC_TZSC_SECCFGR2_I2C3SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR2_I2C3SEC_Pos)
#define GTZC_TZSC_SECCFGR2_I2C3SEC                  GTZC_TZSC_SECCFGR2_I2C3SEC_Msk               /*!<  secure access mode for I2C3 */
#define GTZC_TZSC_SECCFGR2_LPTIM1SEC_Pos            (19UL)
#define GTZC_TZSC_SECCFGR2_LPTIM1SEC_Msk            (0x01UL << GTZC_TZSC_SECCFGR2_LPTIM1SEC_Pos)
#define GTZC_TZSC_SECCFGR2_LPTIM1SEC                GTZC_TZSC_SECCFGR2_LPTIM1SEC_Msk             /*!<  secure access mode for LPTIM1 */
#define GTZC_TZSC_SECCFGR2_COMPSEC_Pos              (23UL)
#define GTZC_TZSC_SECCFGR2_COMPSEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR2_COMPSEC_Pos)
#define GTZC_TZSC_SECCFGR2_COMPSEC                  GTZC_TZSC_SECCFGR2_COMPSEC_Msk               /*!<  secure access mode for COMP */
#define GTZC_TZSC_SECCFGR2_ADC4SEC_Pos              (24UL)
#define GTZC_TZSC_SECCFGR2_ADC4SEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR2_ADC4SEC_Pos)
#define GTZC_TZSC_SECCFGR2_ADC4SEC                  GTZC_TZSC_SECCFGR2_ADC4SEC_Msk               /*!<  secure access mode for ADC4 */
#define GTZC_TZSC_SECCFGR2_VREFBUFSEC_Pos           (25UL)
#define GTZC_TZSC_SECCFGR2_VREFBUFSEC_Msk           (0x01UL << GTZC_TZSC_SECCFGR2_VREFBUFSEC_Pos)
#define GTZC_TZSC_SECCFGR2_VREFBUFSEC               GTZC_TZSC_SECCFGR2_VREFBUFSEC_Msk            /*!<  secure access mode for VREFBUF */

/***************  Bits definition for register x=3 (GTZC_TZSC_SECCFGR3) *************/
#define GTZC_TZSC_SECCFGR3_CRCSEC_Pos               (3UL)
#define GTZC_TZSC_SECCFGR3_CRCSEC_Msk               (0x01UL << GTZC_TZSC_SECCFGR3_CRCSEC_Pos)
#define GTZC_TZSC_SECCFGR3_CRCSEC                   GTZC_TZSC_SECCFGR3_CRCSEC_Msk                /*!<  secure access mode for CRC */
#define GTZC_TZSC_SECCFGR3_TSCSEC_Pos               (4UL)
#define GTZC_TZSC_SECCFGR3_TSCSEC_Msk               (0x01UL << GTZC_TZSC_SECCFGR3_TSCSEC_Pos)
#define GTZC_TZSC_SECCFGR3_TSCSEC                   GTZC_TZSC_SECCFGR3_TSCSEC_Msk                /*!<  secure access mode for TSC */
#define GTZC_TZSC_SECCFGR3_ICACHE_REGSEC_Pos        (6UL)
#define GTZC_TZSC_SECCFGR3_ICACHE_REGSEC_Msk        (0x01UL << GTZC_TZSC_SECCFGR3_ICACHE_REGSEC_Pos)
#define GTZC_TZSC_SECCFGR3_ICACHE_REGSEC            GTZC_TZSC_SECCFGR3_ICACHE_REGSEC_Msk         /*!<  secure access mode for ICACHE_REG */
#define GTZC_TZSC_SECCFGR3_OTGSEC_Pos               (10UL)
#define GTZC_TZSC_SECCFGR3_OTGSEC_Msk               (0x01UL << GTZC_TZSC_SECCFGR3_OTGSEC_Pos)
#define GTZC_TZSC_SECCFGR3_OTGSEC                   GTZC_TZSC_SECCFGR3_OTGSEC_Msk                /*!<  secure access mode for OTG */
#define GTZC_TZSC_SECCFGR3_AESSEC_Pos               (11UL)
#define GTZC_TZSC_SECCFGR3_AESSEC_Msk               (0x01UL << GTZC_TZSC_SECCFGR3_AESSEC_Pos)
#define GTZC_TZSC_SECCFGR3_AESSEC                   GTZC_TZSC_SECCFGR3_AESSEC_Msk                /*!<  secure access mode for AES */
#define GTZC_TZSC_SECCFGR3_HASHSEC_Pos              (12UL)
#define GTZC_TZSC_SECCFGR3_HASHSEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR3_HASHSEC_Pos)
#define GTZC_TZSC_SECCFGR3_HASHSEC                  GTZC_TZSC_SECCFGR3_HASHSEC_Msk               /*!<  secure access mode for HASH */
#define GTZC_TZSC_SECCFGR3_RNGSEC_Pos               (13UL)
#define GTZC_TZSC_SECCFGR3_RNGSEC_Msk               (0x01UL << GTZC_TZSC_SECCFGR3_RNGSEC_Pos)
#define GTZC_TZSC_SECCFGR3_RNGSEC                   GTZC_TZSC_SECCFGR3_RNGSEC_Msk                /*!<  secure access mode for RNG */
#define GTZC_TZSC_SECCFGR3_SAESSEC_Pos              (14UL)
#define GTZC_TZSC_SECCFGR3_SAESSEC_Msk              (0x01UL << GTZC_TZSC_SECCFGR3_SAESSEC_Pos)
#define GTZC_TZSC_SECCFGR3_SAESSEC                  GTZC_TZSC_SECCFGR3_SAESSEC_Msk               /*!<  secure access mode for SAES */
#define GTZC_TZSC_SECCFGR3_PKASEC_Pos               (16UL)
#define GTZC_TZSC_SECCFGR3_PKASEC_Msk               (0x01UL << GTZC_TZSC_SECCFGR3_PKASEC_Pos)
#define GTZC_TZSC_SECCFGR3_PKASEC                   GTZC_TZSC_SECCFGR3_PKASEC_Msk                /*!<  secure access mode for PKA */
#define GTZC_TZSC_SECCFGR3_RAMCFGSEC_Pos            (22UL)
#define GTZC_TZSC_SECCFGR3_RAMCFGSEC_Msk            (0x01UL << GTZC_TZSC_SECCFGR3_RAMCFGSEC_Pos)
#define GTZC_TZSC_SECCFGR3_RAMCFGSEC                GTZC_TZSC_SECCFGR3_RAMCFGSEC_Msk             /*!<  secure access mode for RAMCFG */
#define GTZC_TZSC_SECCFGR3_RADIOSEC_Pos             (23UL)
#define GTZC_TZSC_SECCFGR3_RADIOSEC_Msk             (0x01UL << GTZC_TZSC_SECCFGR3_RADIOSEC_Pos)
#define GTZC_TZSC_SECCFGR3_RADIOSEC                 GTZC_TZSC_SECCFGR3_RADIOSEC_Msk              /*!<  secure access mode for 2.4 GHz RADIO */
#define GTZC_TZSC_SECCFGR3_PTACONVSEC_Pos           (24UL)
#define GTZC_TZSC_SECCFGR3_PTACONVSEC_Msk           (0x01UL << GTZC_TZSC_SECCFGR3_PTACONVSEC_Pos)
#define GTZC_TZSC_SECCFGR3_PTACONVSEC               GTZC_TZSC_SECCFGR3_PTACONVSEC_Msk            /*!<  secure access mode for PTACONV */

/*******************  Bits definition for GTZC_TZSC_PRIVCFGR1 register  ***************/
#define GTZC_TZSC_PRIVCFGR1_TIM2PRIV_Pos           (0UL)
#define GTZC_TZSC_PRIVCFGR1_TIM2PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_TIM2PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_TIM2PRIV               GTZC_TZSC_PRIVCFGR1_TIM2PRIV_Msk               /*!<  privileged access mode for TIM2 */
#define GTZC_TZSC_PRIVCFGR1_TIM3PRIV_Pos           (1UL)
#define GTZC_TZSC_PRIVCFGR1_TIM3PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_TIM3PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_TIM3PRIV               GTZC_TZSC_PRIVCFGR1_TIM3PRIV_Msk               /*!<  privileged access mode for TIM3 */
#define GTZC_TZSC_PRIVCFGR1_TIM4PRIV_Pos           (2UL)
#define GTZC_TZSC_PRIVCFGR1_TIM4PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_TIM4PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_TIM4PRIV               GTZC_TZSC_PRIVCFGR1_TIM4PRIV_Msk               /*!<  privileged access mode for TIM4 */
#define GTZC_TZSC_PRIVCFGR1_WWDGPRIV_Pos           (6UL)
#define GTZC_TZSC_PRIVCFGR1_WWDGPRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_WWDGPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_WWDGPRIV               GTZC_TZSC_PRIVCFGR1_WWDGPRIV_Msk               /*!<  privileged access mode for WWDG */
#define GTZC_TZSC_PRIVCFGR1_IWDGPRIV_Pos           (7UL)
#define GTZC_TZSC_PRIVCFGR1_IWDGPRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_IWDGPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_IWDGPRIV               GTZC_TZSC_PRIVCFGR1_IWDGPRIV_Msk               /*!<  privileged access mode for IWDG */
#define GTZC_TZSC_PRIVCFGR1_SPI2PRIV_Pos           (8UL)
#define GTZC_TZSC_PRIVCFGR1_SPI2PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_SPI2PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_SPI2PRIV               GTZC_TZSC_PRIVCFGR1_SPI2PRIV_Msk               /*!<  privileged access mode for IWDG */
#define GTZC_TZSC_PRIVCFGR1_USART2PRIV_Pos         (9UL)
#define GTZC_TZSC_PRIVCFGR1_USART2PRIV_Msk         (0x01UL << GTZC_TZSC_PRIVCFGR1_USART2PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_USART2PRIV             GTZC_TZSC_PRIVCFGR1_USART2PRIV_Msk             /*!<  privileged access mode for USART2 */
#define GTZC_TZSC_PRIVCFGR1_USART3PRIV_Pos         (10UL)
#define GTZC_TZSC_PRIVCFGR1_USART3PRIV_Msk         (0x01UL << GTZC_TZSC_PRIVCFGR1_USART3PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_USART3PRIV             GTZC_TZSC_PRIVCFGR1_USART3PRIV_Msk             /*!<  privileged access mode for USART3 */
#define GTZC_TZSC_PRIVCFGR1_I2C1PRIV_Pos           (13UL)
#define GTZC_TZSC_PRIVCFGR1_I2C1PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_I2C1PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_I2C1PRIV               GTZC_TZSC_PRIVCFGR1_I2C1PRIV_Msk               /*!<  privileged access mode for I2C1 */
#define GTZC_TZSC_PRIVCFGR1_I2C2PRIV_Pos           (14UL)
#define GTZC_TZSC_PRIVCFGR1_I2C2PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_I2C2PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_I2C2PRIV               GTZC_TZSC_PRIVCFGR1_I2C2PRIV_Msk               /*!<  privileged access mode for I2C2 */
#define GTZC_TZSC_PRIVCFGR1_I2C4PRIV_Pos           (16UL)
#define GTZC_TZSC_PRIVCFGR1_I2C4PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR1_I2C4PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_I2C4PRIV               GTZC_TZSC_PRIVCFGR1_I2C4PRIV_Msk               /*!<  privileged access mode for I2C4 */
#define GTZC_TZSC_PRIVCFGR1_LPTIM2PRIV_Pos         (17UL)
#define GTZC_TZSC_PRIVCFGR1_LPTIM2PRIV_Msk         (0x01UL << GTZC_TZSC_PRIVCFGR1_LPTIM2PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR1_LPTIM2PRIV             GTZC_TZSC_PRIVCFGR1_LPTIM2PRIV_Msk             /*!<  privileged access mode for LPTIM2 */

/*******************  Bits definition for GTZC_TZSC_PRIVCFGR2 register  ***************/
#define GTZC_TZSC_PRIVCFGR2_TIM1PRIV_Pos           (0UL)
#define GTZC_TZSC_PRIVCFGR2_TIM1PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR2_TIM1PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_TIM1PRIV               GTZC_TZSC_PRIVCFGR2_TIM1PRIV_Msk               /*!<  privileged access mode for TIM1 */
#define GTZC_TZSC_PRIVCFGR2_SPI1PRIV_Pos           (1UL)
#define GTZC_TZSC_PRIVCFGR2_SPI1PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR2_SPI1PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_SPI1PRIV               GTZC_TZSC_PRIVCFGR2_SPI1PRIV_Msk               /*!<  privileged access mode for SPI1 */
#define GTZC_TZSC_PRIVCFGR2_USART1PRIV_Pos         (3UL)
#define GTZC_TZSC_PRIVCFGR2_USART1PRIV_Msk         (0x01UL << GTZC_TZSC_PRIVCFGR2_USART1PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_USART1PRIV             GTZC_TZSC_PRIVCFGR2_USART1PRIV_Msk             /*!<  privileged access mode for USART1 */
#define GTZC_TZSC_PRIVCFGR2_TIM16PRIV_Pos          (5UL)
#define GTZC_TZSC_PRIVCFGR2_TIM16PRIV_Msk          (0x01UL << GTZC_TZSC_PRIVCFGR2_TIM16PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_TIM16PRIV              GTZC_TZSC_PRIVCFGR2_TIM16PRIV_Msk              /*!<  privileged access mode for TIM16 */
#define GTZC_TZSC_PRIVCFGR2_TIM17PRIV_Pos          (6UL)
#define GTZC_TZSC_PRIVCFGR2_TIM17PRIV_Msk          (0x01UL << GTZC_TZSC_PRIVCFGR2_TIM17PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_TIM17PRIV              GTZC_TZSC_PRIVCFGR2_TIM17PRIV_Msk              /*!<  privileged access mode for TIM17 */
#define GTZC_TZSC_PRIVCFGR2_SAI1PRIV_Pos           (7UL)
#define GTZC_TZSC_PRIVCFGR2_SAI1PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR2_SAI1PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_SAI1PRIV               GTZC_TZSC_PRIVCFGR2_SAI1PRIV_Msk               /*!<  privileged access mode for SAI1 */
#define GTZC_TZSC_PRIVCFGR2_SPI3PRIV_Pos           (16UL)
#define GTZC_TZSC_PRIVCFGR2_SPI3PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR2_SPI3PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_SPI3PRIV               GTZC_TZSC_PRIVCFGR2_SPI3PRIV_Msk               /*!<  privileged access mode for SPI3 */
#define GTZC_TZSC_PRIVCFGR2_LPUART1PRIV_Pos        (17UL)
#define GTZC_TZSC_PRIVCFGR2_LPUART1PRIV_Msk        (0x01UL << GTZC_TZSC_PRIVCFGR2_LPUART1PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_LPUART1PRIV            GTZC_TZSC_PRIVCFGR2_LPUART1PRIV_Msk            /*!<  privileged access mode for LPUART1 */
#define GTZC_TZSC_PRIVCFGR2_I2C3PRIV_Pos           (18UL)
#define GTZC_TZSC_PRIVCFGR2_I2C3PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR2_I2C3PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_I2C3PRIV               GTZC_TZSC_PRIVCFGR2_I2C3PRIV_Msk               /*!<  privileged access mode for I2C3 */
#define GTZC_TZSC_PRIVCFGR2_LPTIM1PRIV_Pos         (19UL)
#define GTZC_TZSC_PRIVCFGR2_LPTIM1PRIV_Msk         (0x01UL << GTZC_TZSC_PRIVCFGR2_LPTIM1PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_LPTIM1PRIV             GTZC_TZSC_PRIVCFGR2_LPTIM1PRIV_Msk             /*!<  privileged access mode for LPTIM1 */
#define GTZC_TZSC_PRIVCFGR2_COMPPRIV_Pos           (23UL)
#define GTZC_TZSC_PRIVCFGR2_COMPPRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR2_COMPPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_COMPPRIV               GTZC_TZSC_PRIVCFGR2_COMPPRIV_Msk               /*!<  privileged access mode for COMP */
#define GTZC_TZSC_PRIVCFGR2_ADC4PRIV_Pos           (24UL)
#define GTZC_TZSC_PRIVCFGR2_ADC4PRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR2_ADC4PRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_ADC4PRIV               GTZC_TZSC_PRIVCFGR2_ADC4PRIV_Msk               /*!<  privileged access mode for ADC4 */
#define GTZC_TZSC_PRIVCFGR2_VREFBUFPRIV_Pos        (25UL)
#define GTZC_TZSC_PRIVCFGR2_VREFBUFPRIV_Msk        (0x01UL << GTZC_TZSC_PRIVCFGR2_VREFBUFPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR2_VREFBUFPRIV            GTZC_TZSC_PRIVCFGR2_VREFBUFPRIV_Msk            /*!<  privileged access mode for VREFBUF */

/*******************  Bits definition for GTZC_TZSC_PRIVCFGR3 register  ***************/
#define GTZC_TZSC_PRIVCFGR3_CRCPRIV_Pos            (3UL)
#define GTZC_TZSC_PRIVCFGR3_CRCPRIV_Msk            (0x01UL << GTZC_TZSC_PRIVCFGR3_CRCPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_CRCPRIV                GTZC_TZSC_PRIVCFGR3_CRCPRIV_Msk                /*!<  privileged access mode for CRC */
#define GTZC_TZSC_PRIVCFGR3_TSCPRIV_Pos            (4UL)
#define GTZC_TZSC_PRIVCFGR3_TSCPRIV_Msk            (0x01UL << GTZC_TZSC_PRIVCFGR3_TSCPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_TSCPRIV                GTZC_TZSC_PRIVCFGR3_TSCPRIV_Msk                /*!<  privileged access mode for TSC */
#define GTZC_TZSC_PRIVCFGR3_ICACHE_REGPRIV_Pos     (6UL)
#define GTZC_TZSC_PRIVCFGR3_ICACHE_REGPRIV_Msk     (0x01UL << GTZC_TZSC_PRIVCFGR3_ICACHE_REGPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_ICACHE_REGPRIV         GTZC_TZSC_PRIVCFGR3_ICACHE_REGPRIV_Msk         /*!<  privileged access mode for ICACHE_REG */
#define GTZC_TZSC_PRIVCFGR3_OTGPRIV_Pos            (10UL)
#define GTZC_TZSC_PRIVCFGR3_OTGPRIV_Msk            (0x01UL << GTZC_TZSC_PRIVCFGR3_OTGPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_OTGPRIV                GTZC_TZSC_PRIVCFGR3_OTGPRIV_Msk                /*!<  privileged access mode for OTG */
#define GTZC_TZSC_PRIVCFGR3_AESPRIV_Pos            (11UL)
#define GTZC_TZSC_PRIVCFGR3_AESPRIV_Msk            (0x01UL << GTZC_TZSC_PRIVCFGR3_AESPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_AESPRIV                GTZC_TZSC_PRIVCFGR3_AESPRIV_Msk                /*!<  privileged access mode for AES */
#define GTZC_TZSC_PRIVCFGR3_HASHPRIV_Pos           (12UL)
#define GTZC_TZSC_PRIVCFGR3_HASHPRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR3_HASHPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_HASHPRIV               GTZC_TZSC_PRIVCFGR3_HASHPRIV_Msk               /*!<  privileged access mode for HASH */
#define GTZC_TZSC_PRIVCFGR3_RNGPRIV_Pos            (13UL)
#define GTZC_TZSC_PRIVCFGR3_RNGPRIV_Msk            (0x01UL << GTZC_TZSC_PRIVCFGR3_RNGPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_RNGPRIV                GTZC_TZSC_PRIVCFGR3_RNGPRIV_Msk                /*!<  privileged access mode for RNG */
#define GTZC_TZSC_PRIVCFGR3_SAESPRIV_Pos           (14UL)
#define GTZC_TZSC_PRIVCFGR3_SAESPRIV_Msk           (0x01UL << GTZC_TZSC_PRIVCFGR3_SAESPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_SAESPRIV               GTZC_TZSC_PRIVCFGR3_SAESPRIV_Msk               /*!<  privileged access mode for SAES */
#define GTZC_TZSC_PRIVCFGR3_PKAPRIV_Pos            (16UL)
#define GTZC_TZSC_PRIVCFGR3_PKAPRIV_Msk            (0x01UL << GTZC_TZSC_PRIVCFGR3_PKAPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_PKAPRIV                GTZC_TZSC_PRIVCFGR3_PKAPRIV_Msk                /*!<  privileged access mode for PKA */
#define GTZC_TZSC_PRIVCFGR3_RAMCFGPRIV_Pos         (22UL)
#define GTZC_TZSC_PRIVCFGR3_RAMCFGPRIV_Msk         (0x01UL << GTZC_TZSC_PRIVCFGR3_RAMCFGPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_RAMCFGPRIV             GTZC_TZSC_PRIVCFGR3_RAMCFGPRIV_Msk             /*!<  privileged access mode for RAMCFG */
#define GTZC_TZSC_PRIVCFGR3_RADIOPRIV_Pos          (23UL)
#define GTZC_TZSC_PRIVCFGR3_RADIOPRIV_Msk          (0x01UL << GTZC_TZSC_PRIVCFGR3_RADIOPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_RADIOPRIV              GTZC_TZSC_PRIVCFGR3_RADIOPRIV_Msk              /*!<  privileged access mode for 2.4 GHz RADIO */
#define GTZC_TZSC_PRIVCFGR3_PTACONVPRIV_Pos        (24UL)
#define GTZC_TZSC_PRIVCFGR3_PTACONVPRIV_Msk        (0x01UL << GTZC_TZSC_PRIVCFGR3_PTACONVPRIV_Pos)
#define GTZC_TZSC_PRIVCFGR3_PTACONVPRIV            GTZC_TZSC_PRIVCFGR3_PTACONVPRIV_Msk            /*!<  privileged access mode for PTACONV */

/*******************  Bits definition for GTZC_TZIC_IER1 register  ***************/
#define GTZC_TZIC_IER1_TIM2IE_Pos           (0UL)
#define GTZC_TZIC_IER1_TIM2IE_Msk           (0x01UL << GTZC_TZIC_IER1_TIM2IE_Pos)
#define GTZC_TZIC_IER1_TIM2IE               GTZC_TZIC_IER1_TIM2IE_Msk               /*!<   illegal access interrupt enable for TIM2 */
#define GTZC_TZIC_IER1_TIM3IE_Pos           (1UL)
#define GTZC_TZIC_IER1_TIM3IE_Msk           (0x01UL << GTZC_TZIC_IER1_TIM3IE_Pos)
#define GTZC_TZIC_IER1_TIM3IE               GTZC_TZIC_IER1_TIM3IE_Msk               /*!<   illegal access interrupt enable for TIM3 */
#define GTZC_TZIC_IER1_TIM4IE_Pos           (2UL)
#define GTZC_TZIC_IER1_TIM4IE_Msk           (0x01UL << GTZC_TZIC_IER1_TIM4IE_Pos)
#define GTZC_TZIC_IER1_TIM4IE               GTZC_TZIC_IER1_TIM4IE_Msk               /*!<   illegal access interrupt enable for TIM4 */
#define GTZC_TZIC_IER1_WWDGIE_Pos           (6UL)
#define GTZC_TZIC_IER1_WWDGIE_Msk           (0x01UL << GTZC_TZIC_IER1_WWDGIE_Pos)
#define GTZC_TZIC_IER1_WWDGIE               GTZC_TZIC_IER1_WWDGIE_Msk               /*!<   illegal access interrupt enable for WWDG */
#define GTZC_TZIC_IER1_IWDGIE_Pos           (7UL)
#define GTZC_TZIC_IER1_IWDGIE_Msk           (0x01UL << GTZC_TZIC_IER1_IWDGIE_Pos)
#define GTZC_TZIC_IER1_IWDGIE               GTZC_TZIC_IER1_IWDGIE_Msk               /*!<   illegal access interrupt enable for IWDG */
#define GTZC_TZIC_IER1_SPI2IE_Pos           (8UL)
#define GTZC_TZIC_IER1_SPI2IE_Msk           (0x01UL << GTZC_TZIC_IER1_SPI2IE_Pos)
#define GTZC_TZIC_IER1_SPI2IE               GTZC_TZIC_IER1_SPI2IE_Msk               /*!<   illegal access interrupt enable for IWDG */
#define GTZC_TZIC_IER1_USART2IE_Pos         (9UL)
#define GTZC_TZIC_IER1_USART2IE_Msk         (0x01UL << GTZC_TZIC_IER1_USART2IE_Pos)
#define GTZC_TZIC_IER1_USART2IE             GTZC_TZIC_IER1_USART2IE_Msk             /*!<   illegal access interrupt enable for USART2 */
#define GTZC_TZIC_IER1_USART3IE_Pos         (10UL)
#define GTZC_TZIC_IER1_USART3IE_Msk         (0x01UL << GTZC_TZIC_IER1_USART3IE_Pos)
#define GTZC_TZIC_IER1_USART3IE             GTZC_TZIC_IER1_USART3IE_Msk             /*!<   illegal access interrupt enable for USART3 */
#define GTZC_TZIC_IER1_I2C1IE_Pos           (13UL)
#define GTZC_TZIC_IER1_I2C1IE_Msk           (0x01UL << GTZC_TZIC_IER1_I2C1IE_Pos)
#define GTZC_TZIC_IER1_I2C1IE               GTZC_TZIC_IER1_I2C1IE_Msk               /*!<   illegal access interrupt enable for I2C1 */
#define GTZC_TZIC_IER1_I2C2IE_Pos           (14UL)
#define GTZC_TZIC_IER1_I2C2IE_Msk           (0x01UL << GTZC_TZIC_IER1_I2C2IE_Pos)
#define GTZC_TZIC_IER1_I2C2IE               GTZC_TZIC_IER1_I2C2IE_Msk               /*!<   illegal access interrupt enable for I2C2 */
#define GTZC_TZIC_IER1_I2C4IE_Pos           (16UL)
#define GTZC_TZIC_IER1_I2C4IE_Msk           (0x01UL << GTZC_TZIC_IER1_I2C4IE_Pos)
#define GTZC_TZIC_IER1_I2C4IE               GTZC_TZIC_IER1_I2C4IE_Msk               /*!<   illegal access interrupt enable for I2C4 */
#define GTZC_TZIC_IER1_LPTIM2IE_Pos         (17UL)
#define GTZC_TZIC_IER1_LPTIM2IE_Msk         (0x01UL << GTZC_TZIC_IER1_LPTIM2IE_Pos)
#define GTZC_TZIC_IER1_LPTIM2IE             GTZC_TZIC_IER1_LPTIM2IE_Msk             /*!<   illegal access interrupt enable for LPTIM2 */

/*******************  Bits definition for GTZC_TZIC_IER2 register  ***************/
#define GTZC_TZIC_IER2_TIM1IE_Pos           (0UL)
#define GTZC_TZIC_IER2_TIM1IE_Msk           (0x01UL << GTZC_TZIC_IER2_TIM1IE_Pos)
#define GTZC_TZIC_IER2_TIM1IE               GTZC_TZIC_IER2_TIM1IE_Msk               /*!<  illegal access interrupt enable for TIM1 */
#define GTZC_TZIC_IER2_SPI1IE_Pos           (1UL)
#define GTZC_TZIC_IER2_SPI1IE_Msk           (0x01UL << GTZC_TZIC_IER2_SPI1IE_Pos)
#define GTZC_TZIC_IER2_SPI1IE               GTZC_TZIC_IER2_SPI1IE_Msk               /*!<  illegal access interrupt enable for SPI1 */
#define GTZC_TZIC_IER2_USART1IE_Pos         (3UL)
#define GTZC_TZIC_IER2_USART1IE_Msk         (0x01UL << GTZC_TZIC_IER2_USART1IE_Pos)
#define GTZC_TZIC_IER2_USART1IE             GTZC_TZIC_IER2_USART1IE_Msk             /*!<  illegal access interrupt enable for USART1 */
#define GTZC_TZIC_IER2_TIM16IE_Pos          (5UL)
#define GTZC_TZIC_IER2_TIM16IE_Msk          (0x01UL << GTZC_TZIC_IER2_TIM16IE_Pos)
#define GTZC_TZIC_IER2_TIM16IE              GTZC_TZIC_IER2_TIM16IE_Msk              /*!<  illegal access interrupt enable for TIM16 */
#define GTZC_TZIC_IER2_TIM17IE_Pos          (6UL)
#define GTZC_TZIC_IER2_TIM17IE_Msk          (0x01UL << GTZC_TZIC_IER2_TIM17IE_Pos)
#define GTZC_TZIC_IER2_TIM17IE              GTZC_TZIC_IER2_TIM17IE_Msk              /*!<  illegal access interrupt enable for TIM17 */
#define GTZC_TZIC_IER2_SAI1IE_Pos           (7UL)
#define GTZC_TZIC_IER2_SAI1IE_Msk           (0x01UL << GTZC_TZIC_IER2_SAI1IE_Pos)
#define GTZC_TZIC_IER2_SAI1IE               GTZC_TZIC_IER2_SAI1IE_Msk               /*!<  illegal access interrupt enable for SAI1 */
#define GTZC_TZIC_IER2_SPI3IE_Pos           (16UL)
#define GTZC_TZIC_IER2_SPI3IE_Msk           (0x01UL << GTZC_TZIC_IER2_SPI3IE_Pos)
#define GTZC_TZIC_IER2_SPI3IE               GTZC_TZIC_IER2_SPI3IE_Msk               /*!<  illegal access interrupt enable for SPI3 */
#define GTZC_TZIC_IER2_LPUART1IE_Pos        (17UL)
#define GTZC_TZIC_IER2_LPUART1IE_Msk        (0x01UL << GTZC_TZIC_IER2_LPUART1IE_Pos)
#define GTZC_TZIC_IER2_LPUART1IE            GTZC_TZIC_IER2_LPUART1IE_Msk            /*!<  illegal access interrupt enable for LPUART1 */
#define GTZC_TZIC_IER2_I2C3IE_Pos           (18UL)
#define GTZC_TZIC_IER2_I2C3IE_Msk           (0x01UL << GTZC_TZIC_IER2_I2C3IE_Pos)
#define GTZC_TZIC_IER2_I2C3IE               GTZC_TZIC_IER2_I2C3IE_Msk               /*!<  illegal access interrupt enable for I2C3 */
#define GTZC_TZIC_IER2_LPTIM1IE_Pos         (19UL)
#define GTZC_TZIC_IER2_LPTIM1IE_Msk         (0x01UL << GTZC_TZIC_IER2_LPTIM1IE_Pos)
#define GTZC_TZIC_IER2_LPTIM1IE             GTZC_TZIC_IER2_LPTIM1IE_Msk             /*!<  illegal access interrupt enable for LPTIM1 */
#define GTZC_TZIC_IER2_COMPIE_Pos           (23UL)
#define GTZC_TZIC_IER2_COMPIE_Msk           (0x01UL << GTZC_TZIC_IER2_COMPIE_Pos)
#define GTZC_TZIC_IER2_COMPIE               GTZC_TZIC_IER2_COMPIE_Msk               /*!<  illegal access interrupt enable for COMP */
#define GTZC_TZIC_IER2_ADC4IE_Pos           (24UL)
#define GTZC_TZIC_IER2_ADC4IE_Msk           (0x01UL << GTZC_TZIC_IER2_ADC4IE_Pos)
#define GTZC_TZIC_IER2_ADC4IE               GTZC_TZIC_IER2_ADC4IE_Msk               /*!<  illegal access interrupt enable for ADC4 */
#define GTZC_IER2_VREFBUFIE_Pos             (25UL)
#define GTZC_IER2_VREFBUFIE_Msk             (0x01UL << GTZC_IER2_VREFBUFPRIV_Pos)
#define GTZC_IER2_VREFBUFIE                 GTZC_IER2_VREFBUFPRIV_Msk               /*!<  illegal access interrupt enable for VREFBUF */

/*******************  Bits definition for GTZC_TZIC_IER3 register  ***************/
#define GTZC_TZIC_IER3_CRCIE_Pos            (3UL)
#define GTZC_TZIC_IER3_CRCIE_Msk            (0x01UL << GTZC_TZIC_IER3_CRCIE_Pos)
#define GTZC_TZIC_IER3_CRCIE                GTZC_TZIC_IER3_CRCIE_Msk                /*!<  illegal access interrupt enable for CRC */
#define GTZC_TZIC_IER3_TSCIE_Pos            (4UL)
#define GTZC_TZIC_IER3_TSCIE_Msk            (0x01UL << GTZC_TZIC_IER3_TSCIE_Pos)
#define GTZC_TZIC_IER3_TSCIE                GTZC_TZIC_IER3_TSCIE_Msk                /*!<  illegal access interrupt enable for TSC */
#define GTZC_TZIC_IER3_ICACHE_REGIE_Pos     (6UL)
#define GTZC_TZIC_IER3_ICACHE_REGIE_Msk     (0x01UL << GTZC_TZIC_IER3_ICACHE_REGIE_Pos)
#define GTZC_TZIC_IER3_ICACHE_REGIE         GTZC_TZIC_IER3_ICACHE_REGIE_Msk         /*!<  illegal access interrupt enable for ICACHE_REG */
#define GTZC_TZIC_IER3_OTGIE_Pos            (10UL)
#define GTZC_TZIC_IER3_OTGIE_Msk            (0x01UL << GTZC_TZIC_IER3_OTGIE_Pos)
#define GTZC_TZIC_IER3_OTGIE                GTZC_TZIC_IER3_OTGIE_Msk                /*!<  illegal access interrupt enable for OTG */
#define GTZC_TZIC_IER3_AESIE_Pos            (11UL)
#define GTZC_TZIC_IER3_AESIE_Msk            (0x01UL << GTZC_TZIC_IER3_AESIE_Pos)
#define GTZC_TZIC_IER3_AESIE                GTZC_TZIC_IER3_AESIE_Msk                /*!<  illegal access interrupt enable for AES */
#define GTZC_TZIC_IER3_HASHIE_Pos           (12UL)
#define GTZC_TZIC_IER3_HASHIE_Msk           (0x01UL << GTZC_TZIC_IER3_HASHIE_Pos)
#define GTZC_TZIC_IER3_HASHIE               GTZC_TZIC_IER3_HASHIE_Msk               /*!<  illegal access interrupt enable for HASH */
#define GTZC_TZIC_IER3_RNGIE_Pos            (13UL)
#define GTZC_TZIC_IER3_RNGIE_Msk            (0x01UL << GTZC_TZIC_IER3_RNGIE_Pos)
#define GTZC_TZIC_IER3_RNGIE                GTZC_TZIC_IER3_RNGIE_Msk                /*!<  illegal access interrupt enable for RNG */
#define GTZC_TZIC_IER3_SAESIE_Pos           (14UL)
#define GTZC_TZIC_IER3_SAESIE_Msk           (0x01UL << GTZC_TZIC_IER3_SAESIE_Pos)
#define GTZC_TZIC_IER3_SAESIE               GTZC_TZIC_IER3_SAESIE_Msk               /*!<  illegal access interrupt enable for SAES */
#define GTZC_TZIC_IER3_HSEMIE_Pos           (15UL)
#define GTZC_TZIC_IER3_HSEMIE_Msk           (0x01UL << GTZC_TZIC_IER3_HSEMIE_Pos)
#define GTZC_TZIC_IER3_HSEMIE               GTZC_TZIC_IER3_HSEMIE_Msk               /*!<  illegal access interrupt enable for HSEM */
#define GTZC_TZIC_IER3_PKAIE_Pos            (16UL)
#define GTZC_TZIC_IER3_PKAIE_Msk            (0x01UL << GTZC_TZIC_IER3_PKAIE_Pos)
#define GTZC_TZIC_IER3_PKAIE                GTZC_TZIC_IER3_PKAIE_Msk                /*!<  illegal access interrupt enable for PKA */
#define GTZC_TZIC_IER3_RAMCFGIE_Pos         (22UL)
#define GTZC_TZIC_IER3_RAMCFGIE_Msk         (0x01UL << GTZC_TZIC_IER3_RAMCFGIE_Pos)
#define GTZC_TZIC_IER3_RAMCFGIE             GTZC_TZIC_IER3_RAMCFGIE_Msk             /*!<  illegal access interrupt enable for RAMCFG */
#define GTZC_TZIC_IER3_RADIOIE_Pos          (23UL)
#define GTZC_TZIC_IER3_RADIOIE_Msk          (0x01UL << GTZC_TZIC_IER3_RADIOIE_Pos)
#define GTZC_TZIC_IER3_RADIOIE              GTZC_TZIC_IER3_RADIOIE_Msk              /*!<  illegal access interrupt enable for 2.4 GHz RADIO */
#define GTZC_TZIC_IER3_PTACONVIE_Pos        (24UL)
#define GTZC_TZIC_IER3_PTACONVIE_Msk        (0x01UL << GTZC_TZIC_IER3_PTACONVIE_Pos)
#define GTZC_TZIC_IER3_PTACONVIE            GTZC_TZIC_IER3_PTACONVIE_Msk            /*!<  illegal access interrupt enable for PTACONV */

/*******************  Bits definition for GTZC_TZIC_IER4 register  ***************/
#define GTZC_TZIC_IER4_GPDMA1IE_Pos         (0UL)
#define GTZC_TZIC_IER4_GPDMA1IE_Msk         (0x01UL << GTZC_TZIC_IER4_GPDMA1IE_Pos)
#define GTZC_TZIC_IER4_GPDMA1IE             GTZC_TZIC_IER4_GPDMA1IE_Msk             /*!<  illegal access interrupt enable for GPDMA1 */
#define GTZC_TZIC_IER4_FLASHIE_Pos          (1UL)
#define GTZC_TZIC_IER4_FLASHIE_Msk          (0x01UL << GTZC_TZIC_IER4_FLASHIE_Pos)
#define GTZC_TZIC_IER4_FLASHIE              GTZC_TZIC_IER4_FLASHIE_Msk              /*!<  illegal access interrupt enable for FLASH memory */
#define GTZC_TZIC_IER4_FLASH_REGIE_Pos      (2UL)
#define GTZC_TZIC_IER4_FLASH_REGIE_Msk      (0x01UL << GTZC_TZIC_IER4_FLASH_REGIE_Pos)
#define GTZC_TZIC_IER4_FLASH_REGIE          GTZC_TZIC_IER4_FLASH_REGIE_Msk          /*!<  illegal access interrupt enable for FLASH interface */
#define GTZC_TZIC_IER4_SYSCFGIE_Pos         (7UL)
#define GTZC_TZIC_IER4_SYSCFGIE_Msk         (0x01UL << GTZC_TZIC_IER4_SYSCFGIE_Pos)
#define GTZC_TZIC_IER4_SYSCFGIE             GTZC_TZIC_IER4_SYSCFGIE_Msk             /*!<  illegal access interrupt enable for SYSCFG interface */
#define GTZC_TZIC_IER4_RTCIE_Pos            (8UL)
#define GTZC_TZIC_IER4_RTCIE_Msk            (0x01UL << GTZC_TZIC_IER4_RTCIE_Pos)
#define GTZC_TZIC_IER4_RTCIE                GTZC_TZIC_IER4_RTCIE_Msk                /*!<  illegal access interrupt enable for RTC interface */
#define GTZC_TZIC_IER4_TAMPIE_Pos           (9UL)
#define GTZC_TZIC_IER4_TAMPIE_Msk           (0x01UL << GTZC_TZIC_IER4_TAMPIE_Pos)
#define GTZC_TZIC_IER4_TAMPIE               GTZC_TZIC_IER4_TAMPIE_Msk               /*!<  illegal access interrupt enable for TAMP interface */
#define GTZC_TZIC_IER4_PWRIE_Pos            (10UL)
#define GTZC_TZIC_IER4_PWRIE_Msk            (0x01UL << GTZC_TZIC_IER4_PWRIE_Pos)
#define GTZC_TZIC_IER4_PWRIE                GTZC_TZIC_IER4_PWRIE_Msk                /*!<  illegal access interrupt enable for PWR interface */
#define GTZC_TZIC_IER4_RCCIE_Pos            (11UL)
#define GTZC_TZIC_IER4_RCCIE_Msk            (0x01UL << GTZC_TZIC_IER4_RCCIE_Pos)
#define GTZC_TZIC_IER4_RCCIE                GTZC_TZIC_IER4_RCCIE_Msk                /*!<  illegal access interrupt enable for RCC interface */
#define GTZC_TZIC_IER4_EXTIIE_Pos           (13UL)
#define GTZC_TZIC_IER4_EXTIIE_Msk           (0x01UL << GTZC_TZIC_IER4_EXTIIE_Pos)
#define GTZC_TZIC_IER4_EXTIIE               GTZC_TZIC_IER4_EXTIIE_Msk               /*!<  illegal access interrupt enable for EXTI interface */
#define GTZC_TZIC_IER4_TZSCIE_Pos           (14UL)
#define GTZC_TZIC_IER4_TZSCIE_Msk           (0x01UL << GTZC_TZIC_IER4_TZSCIE_Pos)
#define GTZC_TZIC_IER4_TZSCIE               GTZC_TZIC_IER4_TZSCIE_Msk               /*!<  illegal access interrupt enable for GTZC TZSC */
#define GTZC_TZIC_IER4_TZICIE_Pos           (15UL)
#define GTZC_TZIC_IER4_TZICIE_Msk           (0x01UL << GTZC_TZIC_IER4_TZICIE_Pos)
#define GTZC_TZIC_IER4_TZICIE               GTZC_TZIC_IER4_TZICIE_Msk               /*!<  illegal access interrupt enable for GTZC TZIC */
#define GTZC_TZIC_IER4_SRAM1IE_Pos          (22UL)
#define GTZC_TZIC_IER4_SRAM1IE_Msk          (0x01UL << GTZC_TZIC_IER4_SRAM1IE_Pos)
#define GTZC_TZIC_IER4_SRAM1IE              GTZC_TZIC_IER4_SRAM1IE_Msk              /*!<  illegal access interrupt enable for SRAM1 memory */
#define GTZC_TZIC_IER4_MPCBB1IE_Pos         (23UL)
#define GTZC_TZIC_IER4_MPCBB1IE_Msk         (0x01UL << GTZC_TZIC_IER4_MPCBB1IE_Pos)
#define GTZC_TZIC_IER4_MPCBB1IE             GTZC_TZIC_IER4_MPCBB1IE_Msk             /*!<  illegal access interrupt enable for MPCBB1 */
#define GTZC_TZIC_IER4_SRAM2IE_Pos          (24UL)
#define GTZC_TZIC_IER4_SRAM2IE_Msk          (0x01UL << GTZC_TZIC_IER4_SRAM2IE_Pos)
#define GTZC_TZIC_IER4_SRAM2IE              GTZC_TZIC_IER4_SRAM2IE_Msk              /*!<  illegal access interrupt enable for SRAM2 memory */
#define GTZC_TZIC_IER4_MPCBB2IE_Pos         (25UL)
#define GTZC_TZIC_IER4_MPCBB2IE_Msk         (0x01UL << GTZC_TZIC_IER4_MPCBB2IE_Pos)
#define GTZC_TZIC_IER4_MPCBB2IE              GTZC_TZIC_IER4_MPCBB2IE_Msk            /*!<  illegal access interrupt enable for MPCBB2 */
#define GTZC_TZIC_IER4_SRAM6IE_Pos          (30UL)
#define GTZC_TZIC_IER4_SRAM6IE_Msk          (0x01UL << GTZC_TZIC_IER4_SRAM6IE_Pos)
#define GTZC_TZIC_IER4_SRAM6IE              GTZC_TZIC_IER4_SRAM6IE_Msk              /*!<  illegal access interrupt enable for 2.4GHz TXRX SRAM memory */
#define GTZC_TZIC_IER4_MPCBB6IE_Pos         (31UL)
#define GTZC_TZIC_IER4_MPCBB6IE_Msk         (0x01UL << GTZC_TZIC_IER4_MPCBB6IE_Pos)
#define GTZC_TZIC_IER4_MPCBB6IE             GTZC_TZIC_IER4_MPCBB6IE_Msk             /*!<  illegal access interrupt enable for MPCBB6 */

/*******************  Bits definition for GTZC_TZIC_SR1 register  **************/
#define GTZC_TZIC_SR1_TIM2F_Pos             (0UL)
#define GTZC_TZIC_SR1_TIM2F_Msk             (0x01UL << GTZC_TZIC_SR1_TIM2F_Pos)
#define GTZC_TZIC_SR1_TIM2F                 GTZC_TZIC_SR1_TIM2F_Msk               /*!<  illegal access flag for TIM2 */
#define GTZC_TZIC_SR1_TIM3F_Pos             (1UL)
#define GTZC_TZIC_SR1_TIM3F_Msk             (0x01UL << GTZC_TZIC_SR1_TIM3F_Pos)
#define GTZC_TZIC_SR1_TIM3F                 GTZC_TZIC_SR1_TIM3F_Msk               /*!<  illegal access flag for TIM3 */
#define GTZC_TZIC_SR1_TIM4F_Pos             (2UL)
#define GTZC_TZIC_SR1_TIM4F_Msk             (0x01UL << GTZC_TZIC_SR1_TIM4F_Pos)
#define GTZC_TZIC_SR1_TIM4F                 GTZC_TZIC_SR1_TIM4F_Msk               /*!<  illegal access flag for TIM4 */
#define GTZC_TZIC_SR1_WWDGF_Pos             (6UL)
#define GTZC_TZIC_SR1_WWDGF_Msk             (0x01UL << GTZC_TZIC_SR1_WWDGF_Pos)
#define GTZC_TZIC_SR1_WWDGF                 GTZC_TZIC_SR1_WWDGF_Msk               /*!<  illegal access flag for WWDG */
#define GTZC_TZIC_SR1_IWDGF_Pos             (7UL)
#define GTZC_TZIC_SR1_IWDGF_Msk             (0x01UL << GTZC_TZIC_SR1_IWDGF_Pos)
#define GTZC_TZIC_SR1_IWDGF                 GTZC_TZIC_SR1_IWDGF_Msk               /*!<  illegal access flag for IWDG */
#define GTZC_TZIC_SR1_SPI2F_Pos             (8UL)
#define GTZC_TZIC_SR1_SPI2F_Msk             (0x01UL << GTZC_TZIC_SR1_SPI2F_Pos)
#define GTZC_TZIC_SR1_SPI2F                 GTZC_TZIC_SR1_SPI2F_Msk               /*!<  illegal access flag for IWDG */
#define GTZC_TZIC_SR1_USART2F_Pos           (9UL)
#define GTZC_TZIC_SR1_USART2F_Msk           (0x01UL << GTZC_TZIC_SR1_USART2F_Pos)
#define GTZC_TZIC_SR1_USART2F               GTZC_TZIC_SR1_USART2F_Msk             /*!<  illegal access flag for USART2 */
#define GTZC_TZIC_SR1_USART3F_Pos           (10UL)
#define GTZC_TZIC_SR1_USART3F_Msk           (0x01UL << GTZC_TZIC_SR1_USART3F_Pos)
#define GTZC_TZIC_SR1_USART3F               GTZC_TZIC_SR1_USART3F_Msk             /*!<  illegal access flag for USART3 */
#define GTZC_TZIC_SR1_I2C1F_Pos             (13UL)
#define GTZC_TZIC_SR1_I2C1F_Msk             (0x01UL << GTZC_TZIC_SR1_I2C1F_Pos)
#define GTZC_TZIC_SR1_I2C1F                 GTZC_TZIC_SR1_I2C1F_Msk               /*!<  illegal access flag for I2C1 */
#define GTZC_TZIC_SR1_I2C2F_Pos             (14UL)
#define GTZC_TZIC_SR1_I2C2F_Msk             (0x01UL << GTZC_TZIC_SR1_I2C2F_Pos)
#define GTZC_TZIC_SR1_I2C2F                 GTZC_TZIC_SR1_I2C2F_Msk               /*!<  illegal access flag for I2C2 */
#define GTZC_TZIC_SR1_I2C4F_Pos             (16UL)
#define GTZC_TZIC_SR1_I2C4F_Msk             (0x01UL << GTZC_TZIC_SR1_I2C4F_Pos)
#define GTZC_TZIC_SR1_I2C4F                 GTZC_TZIC_SR1_I2C4F_Msk               /*!<  illegal access flag for I2C4 */
#define GTZC_TZIC_SR1_LPTIM2F_Pos           (17UL)
#define GTZC_TZIC_SR1_LPTIM2F_Msk           (0x01UL << GTZC_TZIC_SR1_LPTIM2F_Pos)
#define GTZC_TZIC_SR1_LPTIM2F               GTZC_TZIC_SR1_LPTIM2F_Msk             /*!<  illegal access flag for LPTIM2 */

/*******************  Bits definition for GTZC_TZIC_SR2 register  **************/
#define GTZC_TZIC_SR2_TIM1F_Pos           (0UL)
#define GTZC_TZIC_SR2_TIM1F_Msk           (0x01UL << GTZC_TZIC_SR2_TIM1F_Pos)
#define GTZC_TZIC_SR2_TIM1F               GTZC_TZIC_SR2_TIM1F_Msk                 /*!<  illegal access flag for TIM1 */
#define GTZC_TZIC_SR2_SPI1F_Pos           (1UL)
#define GTZC_TZIC_SR2_SPI1F_Msk           (0x01UL << GTZC_TZIC_SR2_SPI1F_Pos)
#define GTZC_TZIC_SR2_SPI1F               GTZC_TZIC_SR2_SPI1F_Msk                 /*!<  illegal access flag for SPI1 */
#define GTZC_TZIC_SR2_USART1F_Pos         (3UL)
#define GTZC_TZIC_SR2_USART1F_Msk         (0x01UL << GTZC_TZIC_SR2_USART1F_Pos)
#define GTZC_TZIC_SR2_USART1F             GTZC_TZIC_SR2_USART1F_Msk               /*!<  illegal access flag for USART1 */
#define GTZC_TZIC_SR2_TIM16F_Pos          (5UL)
#define GTZC_TZIC_SR2_TIM16F_Msk          (0x01UL << GTZC_TZIC_SR2_TIM16F_Pos)
#define GTZC_TZIC_SR2_TIM16F              GTZC_TZIC_SR2_TIM16F_Msk                /*!<  illegal access flag for TIM16 */
#define GTZC_TZIC_SR2_TIM17F_Pos          (6UL)
#define GTZC_TZIC_SR2_TIM17F_Msk          (0x01UL << GTZC_TZIC_SR2_TIM17F_Pos)
#define GTZC_TZIC_SR2_TIM17F              GTZC_TZIC_SR2_TIM17F_Msk                /*!<  illegal access flag for TIM17 */
#define GTZC_TZIC_SR2_SAI1F_Pos           (7UL)
#define GTZC_TZIC_SR2_SAI1F_Msk           (0x01UL << GTZC_TZIC_SR2_SAI1F_Pos)
#define GTZC_TZIC_SR2_SAI1F               GTZC_TZIC_SR2_SAI1F_Msk                 /*!<  illegal access flag for SAI1 */
#define GTZC_TZIC_SR2_SPI3F_Pos           (16UL)
#define GTZC_TZIC_SR2_SPI3F_Msk           (0x01UL << GTZC_TZIC_SR2_SPI3F_Pos)
#define GTZC_TZIC_SR2_SPI3F               GTZC_TZIC_SR2_SPI3F_Msk                 /*!<  illegal access flag for SPI3 */
#define GTZC_TZIC_SR2_LPUART1F_Pos        (17UL)
#define GTZC_TZIC_SR2_LPUART1F_Msk        (0x01UL << GTZC_TZIC_SR2_LPUART1F_Pos)
#define GTZC_TZIC_SR2_LPUART1F            GTZC_TZIC_SR2_LPUART1F_Msk              /*!<  illegal access flag for LPUART1 */
#define GTZC_TZIC_SR2_I2C3F_Pos           (18UL)
#define GTZC_TZIC_SR2_I2C3F_Msk           (0x01UL << GTZC_TZIC_SR2_I2C3F_Pos)
#define GTZC_TZIC_SR2_I2C3F               GTZC_TZIC_SR2_I2C3F_Msk                 /*!<  illegal access flag for I2C3 */
#define GTZC_TZIC_SR2_LPTIM1F_Pos         (19UL)
#define GTZC_TZIC_SR2_LPTIM1F_Msk         (0x01UL << GTZC_TZIC_SR2_LPTIM1F_Pos)
#define GTZC_TZIC_SR2_LPTIM1F             GTZC_TZIC_SR2_LPTIM1F_Msk               /*!<  illegal access flag for LPTIM1 */
#define GTZC_TZIC_SR2_COMPF_Pos           (23UL)
#define GTZC_TZIC_SR2_COMPF_Msk           (0x01UL << GTZC_TZIC_SR2_COMPF_Pos)
#define GTZC_TZIC_SR2_COMPF               GTZC_TZIC_SR2_COMPF_Msk                 /*!<  illegal access flag for COMP */
#define GTZC_TZIC_SR2_ADC4F_Pos           (24UL)
#define GTZC_TZIC_SR2_ADC4F_Msk           (0x01UL << GTZC_TZIC_SR2_ADC4F_Pos)
#define GTZC_TZIC_SR2_ADC4F               GTZC_TZIC_SR2_ADC4F_Msk                 /*!<  illegal access flag for ADC4 */
#define GTZC_TZIC_SR2_VREFBUFF_Pos        (25UL)
#define GTZC_TZIC_SR2_VREFBUFF_Msk        (0x01UL << GTZC_TZIC_SR2_VREFBUFPRIV_Pos)
#define GTZC_TZIC_SR2_VREFBUFF            GTZC_TZIC_SR2_VREFBUFPRIV_Msk           /*!<  illegal access flag for VREFBUF */

/*******************  Bits definition for GTZC_TZIC_SR3 register  **************/
#define GTZC_TZIC_SR3_CRCF_Pos            (3UL)
#define GTZC_TZIC_SR3_CRCF_Msk            (0x01UL << GTZC_TZIC_SR3_CRCF_Pos)
#define GTZC_TZIC_SR3_CRCF                GTZC_TZIC_SR3_CRCF_Msk                  /*!<  illegal access flag for CRC */
#define GTZC_TZIC_SR3_TSCF_Pos            (4UL)
#define GTZC_TZIC_SR3_TSCF_Msk            (0x01UL << GTZC_TZIC_SR3_TSCF_Pos)
#define GTZC_TZIC_SR3_TSCF                GTZC_TZIC_SR3_TSCF_Msk                  /*!<  illegal access flag for TSC */
#define GTZC_TZIC_SR3_ICACHE_REGF_Pos     (6UL)
#define GTZC_TZIC_SR3_ICACHE_REGF_Msk     (0x01UL << GTZC_TZIC_SR3_ICACHE_REGF_Pos)
#define GTZC_TZIC_SR3_ICACHE_REGF         GTZC_TZIC_SR3_ICACHE_REGF_Msk           /*!<  illegal access flag for ICACHE_REG */
#define GTZC_TZIC_SR3_OTGF_Pos            (10UL)
#define GTZC_TZIC_SR3_OTGF_Msk            (0x01UL << GTZC_TZIC_SR3_OTGF_Pos)
#define GTZC_TZIC_SR3_OTGF                GTZC_TZIC_SR3_OTGF_Msk                  /*!<  illegal access flag for OTG */
#define GTZC_TZIC_SR3_AESF_Pos            (11UL)
#define GTZC_TZIC_SR3_AESF_Msk            (0x01UL << GTZC_TZIC_SR3_AESF_Pos)
#define GTZC_TZIC_SR3_AESF                GTZC_TZIC_SR3_AESF_Msk                  /*!<  illegal access flag for AES */
#define GTZC_TZIC_SR3_HASHF_Pos           (12UL)
#define GTZC_TZIC_SR3_HASHF_Msk           (0x01UL << GTZC_TZIC_SR3_HASHF_Pos)
#define GTZC_TZIC_SR3_HASHF               GTZC_TZIC_SR3_HASHF_Msk                 /*!<  illegal access flag for HASH */
#define GTZC_TZIC_SR3_RNGF_Pos            (13UL)
#define GTZC_TZIC_SR3_RNGF_Msk            (0x01UL << GTZC_TZIC_SR3_RNGF_Pos)
#define GTZC_TZIC_SR3_RNGF                GTZC_TZIC_SR3_RNGF_Msk                  /*!<  illegal access flag for RNG */
#define GTZC_TZIC_SR3_SAESF_Pos           (14UL)
#define GTZC_TZIC_SR3_SAESF_Msk           (0x01UL << GTZC_TZIC_SR3_SAESF_Pos)
#define GTZC_TZIC_SR3_SAESF               GTZC_TZIC_SR3_SAESF_Msk                 /*!<  illegal access flag for SAES */
#define GTZC_TZIC_SR3_HSEMF_Pos           (15UL)
#define GTZC_TZIC_SR3_HSEMF_Msk           (0x01UL << GTZC_TZIC_SR3_HSEMF_Pos)
#define GTZC_TZIC_SR3_HSEMF               GTZC_TZIC_SR3_HSEMF_Msk                 /*!<  illegal access flag for HSEM */
#define GTZC_TZIC_SR3_PKAF_Pos            (16UL)
#define GTZC_TZIC_SR3_PKAF_Msk            (0x01UL << GTZC_TZIC_SR3_PKAF_Pos)
#define GTZC_TZIC_SR3_PKAF                GTZC_TZIC_SR3_PKAF_Msk                  /*!<  illegal access flag for PKA */
#define GTZC_TZIC_SR3_RAMCFGF_Pos         (22UL)
#define GTZC_TZIC_SR3_RAMCFGF_Msk         (0x01UL << GTZC_TZIC_SR3_RAMCFGF_Pos)
#define GTZC_TZIC_SR3_RAMCFGF             GTZC_TZIC_SR3_RAMCFGF_Msk               /*!<  illegal access flag for RAMCFG */
#define GTZC_TZIC_SR3_RADIOF_Pos          (23UL)
#define GTZC_TZIC_SR3_RADIOF_Msk          (0x01UL << GTZC_TZIC_SR3_RADIOF_Pos)
#define GTZC_TZIC_SR3_RADIOF              GTZC_TZIC_SR3_RADIOF_Msk                /*!<  illegal access flag for 2.4 GHz RADIO */
#define GTZC_TZIC_SR3_PTACONVF_Pos        (24UL)
#define GTZC_TZIC_SR3_PTACONVF_Msk        (0x01UL << GTZC_TZIC_SR3_PTACONVF_Pos)
#define GTZC_TZIC_SR3_PTACONVF            GTZC_TZIC_SR3_PTACONVF_Msk              /*!<  illegal access flag for PTACONV */

/*******************  Bits definition for GTZC_TZIC_SR4 register  ***************/
#define GTZC_TZIC_SR4_GPDMA1F_Pos         (0UL)
#define GTZC_TZIC_SR4_GPDMA1F_Msk         (0x01UL << GTZC_TZIC_SR4_GPDMA1F_Pos)
#define GTZC_TZIC_SR4_GPDMA1F             GTZC_TZIC_SR4_GPDMA1F_Msk               /*!<  illegal access flag for GPDMA1 */
#define GTZC_TZIC_SR4_FLASHF_Pos          (1UL)
#define GTZC_TZIC_SR4_FLASHF_Msk          (0x01UL << GTZC_TZIC_SR4_FLASHF_Pos)
#define GTZC_TZIC_SR4_FLASHF              GTZC_TZIC_SR4_FLASHF_Msk                /*!<  illegal access flag for FLASH memory */
#define GTZC_TZIC_SR4_FLASH_REGF_Pos      (2UL)
#define GTZC_TZIC_SR4_FLASH_REGF_Msk      (0x01UL << GTZC_TZIC_SR4_FLASH_REGF_Pos)
#define GTZC_TZIC_SR4_FLASH_REGF          GTZC_TZIC_SR4_FLASH_REGF_Msk            /*!<  illegal access flag for FLASH interface */
#define GTZC_TZIC_SR4_SYSCFGF_Pos         (7UL)
#define GTZC_TZIC_SR4_SYSCFGF_Msk         (0x01UL << GTZC_TZIC_SR4_SYSCFGF_Pos)
#define GTZC_TZIC_SR4_SYSCFGF             GTZC_TZIC_SR4_SYSCFGF_Msk               /*!<  illegal access flag for SYSCFG interface */
#define GTZC_TZIC_SR4_RTCF_Pos            (8UL)
#define GTZC_TZIC_SR4_RTCF_Msk            (0x01UL << GTZC_TZIC_SR4_RTCF_Pos)
#define GTZC_TZIC_SR4_RTCF                GTZC_TZIC_SR4_RTCF_Msk                  /*!<  illegal access flag for RTC interface */
#define GTZC_TZIC_SR4_TAMPF_Pos           (9UL)
#define GTZC_TZIC_SR4_TAMPF_Msk           (0x01UL << GTZC_TZIC_SR4_TAMPF_Pos)
#define GTZC_TZIC_SR4_TAMPF               GTZC_TZIC_SR4_TAMPF_Msk                 /*!<  illegal access flag for TAMP interface */
#define GTZC_TZIC_SR4_PWRF_Pos            (10UL)
#define GTZC_TZIC_SR4_PWRF_Msk            (0x01UL << GTZC_TZIC_SR4_PWRF_Pos)
#define GTZC_TZIC_SR4_PWRF                GTZC_TZIC_SR4_PWRF_Msk                  /*!<  illegal access flag for PWR interface */
#define GTZC_TZIC_SR4_RCCF_Pos            (11UL)
#define GTZC_TZIC_SR4_RCCF_Msk            (0x01UL << GTZC_TZIC_SR4_RCCF_Pos)
#define GTZC_TZIC_SR4_RCCF                GTZC_TZIC_SR4_RCCF_Msk                  /*!<  illegal access flag for RCC interface */
#define GTZC_TZIC_SR4_EXTIF_Pos           (13UL)
#define GTZC_TZIC_SR4_EXTIF_Msk           (0x01UL << GTZC_TZIC_SR4_EXTIF_Pos)
#define GTZC_TZIC_SR4_EXTIF               GTZC_TZIC_SR4_EXTIF_Msk                 /*!<  illegal access flag for EXTI interface */
#define GTZC_TZIC_SR4_TZSCF_Pos           (14UL)
#define GTZC_TZIC_SR4_TZSCF_Msk           (0x01UL << GTZC_TZIC_SR4_TZSCF_Pos)
#define GTZC_TZIC_SR4_TZSCF               GTZC_TZIC_SR4_TZSCF_Msk                 /*!<  illegal access flag for GTZC TZSC */
#define GTZC_TZIC_SR4_TZICF_Pos           (15UL)
#define GTZC_TZIC_SR4_TZICF_Msk           (0x01UL << GTZC_TZIC_SR4_TZICF_Pos)
#define GTZC_TZIC_SR4_TZICF               GTZC_TZIC_SR4_TZICF_Msk                 /*!<  illegal access flag for GTZC TZIC */
#define GTZC_TZIC_SR4_SRAM1F_Pos          (22UL)
#define GTZC_TZIC_SR4_SRAM1F_Msk          (0x01UL << GTZC_TZIC_SR4_SRAM1F_Pos)
#define GTZC_TZIC_SR4_SRAM1F              GTZC_TZIC_SR4_SRAM1F_Msk                /*!<  illegal access flag for SRAM1 memory */
#define GTZC_TZIC_SR4_MPCBB1F_Pos         (23UL)
#define GTZC_TZIC_SR4_MPCBB1F_Msk         (0x01UL << GTZC_TZIC_SR4_MPCBB1F_Pos)
#define GTZC_TZIC_SR4_MPCBB1F             GTZC_TZIC_SR4_MPCBB1F_Msk               /*!<  illegal access flag for MPCBB1 */
#define GTZC_TZIC_SR4_SRAM2F_Pos          (24UL)
#define GTZC_TZIC_SR4_SRAM2F_Msk          (0x01UL << GTZC_TZIC_SR4_SRAM2F_Pos)
#define GTZC_TZIC_SR4_SRAM2F              GTZC_TZIC_SR4_SRAM2F_Msk                /*!<  illegal access flag for SRAM2 memory */
#define GTZC_TZIC_SR4_MPCBB2F_Pos         (25UL)
#define GTZC_TZIC_SR4_MPCBB2F_Msk         (0x01UL << GTZC_TZIC_SR4_MPCBB2F_Pos)
#define GTZC_TZIC_SR4_MPCBB2F              GTZC_TZIC_SR4_MPCBB2F_Msk              /*!<  illegal access flag for MPCBB2 */
#define GTZC_TZIC_SR4_SRAM6F_Pos          (30UL)
#define GTZC_TZIC_SR4_SRAM6F_Msk          (0x01UL << GTZC_TZIC_SR4_SRAM6F_Pos)
#define GTZC_TZIC_SR4_SRAM6F              GTZC_TZIC_SR4_SRAM6F_Msk                /*!<  illegal access flag for 2.4GHz TXRX SRAM memory */
#define GTZC_TZIC_SR4_MPCBB6F_Pos         (31UL)
#define GTZC_TZIC_SR4_MPCBB6F_Msk         (0x01UL << GTZC_TZIC_SR4_MPCBB6F_Pos)
#define GTZC_TZIC_SR4_MPCBB6F             GTZC_TZIC_SR4_MPCBB6F_Msk               /*!<  illegal access flag for MPCBB6 */

/******************  Bits definition for GTZC_TZIC_FCR1 register  ****************/
#define GTZC_TZIC_FCR1_CTIM2F_Pos         (0UL)
#define GTZC_TZIC_FCR1_CTIM2F_Msk         (0x01UL << GTZC_TZIC_FCR1_CTIM2F_Pos)
#define GTZC_TZIC_FCR1_CTIM2F             GTZC_TZIC_FCR1_CTIM2F_Msk                 /*!<  clear the illegal access flag for TIM2 */
#define GTZC_TZIC_FCR1_CTIM3F_Pos         (1UL)
#define GTZC_TZIC_FCR1_CTIM3F_Msk         (0x01UL << GTZC_TZIC_FCR1_CTIM3F_Pos)
#define GTZC_TZIC_FCR1_CTIM3F             GTZC_TZIC_FCR1_CTIM3F_Msk                 /*!<  clear the illegal access flag for TIM3 */
#define GTZC_TZIC_FCR1_CTIM4F_Pos         (2UL)
#define GTZC_TZIC_FCR1_CTIM4F_Msk         (0x01UL << GTZC_TZIC_FCR1_CTIM4F_Pos)
#define GTZC_TZIC_FCR1_CTIM4F             GTZC_TZIC_FCR1_CTIM4F_Msk                 /*!<  clear the illegal access flag for TIM4 */
#define GTZC_TZIC_FCR1_CWWDGF_Pos         (6UL)
#define GTZC_TZIC_FCR1_CWWDGF_Msk         (0x01UL << GTZC_TZIC_FCR1_CWWDGF_Pos)
#define GTZC_TZIC_FCR1_CWWDGF             GTZC_TZIC_FCR1_CWWDGF_Msk                 /*!<  clear the illegal access flag for WWDG */
#define GTZC_TZIC_FCR1_CIWDGF_Pos         (7UL)
#define GTZC_TZIC_FCR1_CIWDGF_Msk         (0x01UL << GTZC_TZIC_FCR1_CIWDGF_Pos)
#define GTZC_TZIC_FCR1_CIWDGF             GTZC_TZIC_FCR1_CIWDGF_Msk                 /*!<  clear the illegal access flag for IWDG */
#define GTZC_TZIC_FCR1_CSPI2F_Pos         (8UL)
#define GTZC_TZIC_FCR1_CSPI2F_Msk         (0x01UL << GTZC_TZIC_FCR1_CSPI2F_Pos)
#define GTZC_TZIC_FCR1_CSPI2F             GTZC_TZIC_FCR1_CSPI2F_Msk                 /*!<  clear the illegal access flag for IWDG */
#define GTZC_TZIC_FCR1_CUSART2F_Pos       (9UL)
#define GTZC_TZIC_FCR1_CUSART2F_Msk       (0x01UL << GTZC_TZIC_FCR1_CUSART2F_Pos)
#define GTZC_TZIC_FCR1_CUSART2F           GTZC_TZIC_FCR1_CUSART2F_Msk               /*!<  clear the illegal access flag for USART2 */
#define GTZC_TZIC_FCR1_CUSART3F_Pos       (10UL)
#define GTZC_TZIC_FCR1_CUSART3F_Msk       (0x01UL << GTZC_TZIC_FCR1_CUSART3F_Pos)
#define GTZC_TZIC_FCR1_CUSART3F           GTZC_TZIC_FCR1_CUSART3F_Msk               /*!<  clear the illegal access flag for USART3 */
#define GTZC_TZIC_FCR1_CI2C1F_Pos         (13UL)
#define GTZC_TZIC_FCR1_CI2C1F_Msk         (0x01UL << GTZC_TZIC_FCR1_CI2C1F_Pos)
#define GTZC_TZIC_FCR1_CI2C1F             GTZC_TZIC_FCR1_CI2C1F_Msk                 /*!<  clear the illegal access flag for I2C1 */
#define GTZC_TZIC_FCR1_CI2C2F_Pos         (14UL)
#define GTZC_TZIC_FCR1_CI2C2F_Msk         (0x01UL << GTZC_TZIC_FCR1_CI2C2F_Pos)
#define GTZC_TZIC_FCR1_CI2C2F             GTZC_TZIC_FCR1_CI2C2F_Msk                 /*!<  clear the illegal access flag for I2C2 */
#define GTZC_TZIC_FCR1_CI2C4F_Pos         (16UL)
#define GTZC_TZIC_FCR1_CI2C4F_Msk         (0x01UL << GTZC_TZIC_FCR1_CI2C4F_Pos)
#define GTZC_TZIC_FCR1_CI2C4F             GTZC_TZIC_FCR1_CI2C4F_Msk                 /*!<  clear the illegal access flag for I2C4 */
#define GTZC_TZIC_FCR1_CLPTIM2F_Pos       (17UL)
#define GTZC_TZIC_FCR1_CLPTIM2F_Msk       (0x01UL << GTZC_TZIC_FCR1_CLPTIM2F_Pos)
#define GTZC_TZIC_FCR1_CLPTIM2F           GTZC_TZIC_FCR1_CLPTIM2F_Msk               /*!<  clear the illegal access flag for LPTIM2 */

/******************  Bits definition for GTZC_TZIC_FCR2 register  ****************/
#define GTZC_TZIC_FCR2_CTIM1F_Pos         (0UL)
#define GTZC_TZIC_FCR2_CTIM1F_Msk         (0x01UL << GTZC_TZIC_FCR2_CTIM1F_Pos)
#define GTZC_TZIC_FCR2_CTIM1F             GTZC_TZIC_FCR2_CTIM1F_Msk                 /*!<  clear the illegal access flag for TIM1 */
#define GTZC_TZIC_FCR2_CSPI1F_Pos         (1UL)
#define GTZC_TZIC_FCR2_CSPI1F_Msk         (0x01UL << GTZC_TZIC_FCR2_CSPI1F_Pos)
#define GTZC_TZIC_FCR2_CSPI1F             GTZC_TZIC_FCR2_CSPI1F_Msk                 /*!<  clear the illegal access flag for SPI1 */
#define GTZC_TZIC_FCR2_CUSART1F_Pos       (3UL)
#define GTZC_TZIC_FCR2_CUSART1F_Msk       (0x01UL << GTZC_TZIC_FCR2_CUSART1F_Pos)
#define GTZC_TZIC_FCR2_CUSART1F           GTZC_TZIC_FCR2_CUSART1F_Msk               /*!<  clear the illegal access flag for USART1 */
#define GTZC_TZIC_FCR2_CTIM16F_Pos        (5UL)
#define GTZC_TZIC_FCR2_CTIM16F_Msk        (0x01UL << GTZC_TZIC_FCR2_CTIM16F_Pos)
#define GTZC_TZIC_FCR2_CTIM16F            GTZC_TZIC_FCR2_CTIM16F_Msk                /*!<  clear the illegal access flag for TIM16 */
#define GTZC_TZIC_FCR2_CTIM17F_Pos        (6UL)
#define GTZC_TZIC_FCR2_CTIM17F_Msk        (0x01UL << GTZC_TZIC_FCR2_CTIM17F_Pos)
#define GTZC_TZIC_FCR2_CTIM17F            GTZC_TZIC_FCR2_CTIM17F_Msk                /*!<  clear the illegal access flag for TIM17 */
#define GTZC_TZIC_FCR2_CSAI1F_Pos         (7UL)
#define GTZC_TZIC_FCR2_CSAI1F_Msk         (0x01UL << GTZC_TZIC_FCR2_CSAI1F_Pos)
#define GTZC_TZIC_FCR2_CSAI1F             GTZC_TZIC_FCR2_CSAI1F_Msk                 /*!<  clear the illegal access flag for SAI1 */
#define GTZC_TZIC_FCR2_CSPI3F_Pos         (16UL)
#define GTZC_TZIC_FCR2_CSPI3F_Msk         (0x01UL << GTZC_TZIC_FCR2_CSPI3F_Pos)
#define GTZC_TZIC_FCR2_CSPI3F             GTZC_TZIC_FCR2_CSPI3F_Msk                 /*!<  clear the illegal access flag for SPI3 */
#define GTZC_TZIC_FCR2_CLPUART1F_Pos      (17UL)
#define GTZC_TZIC_FCR2_CLPUART1F_Msk      (0x01UL << GTZC_TZIC_FCR2_CLPUART1F_Pos)
#define GTZC_TZIC_FCR2_CLPUART1F          GTZC_TZIC_FCR2_CLPUART1F_Msk              /*!<  clear the illegal access flag for LPUART1 */
#define GTZC_TZIC_FCR2_CI2C3F_Pos         (18UL)
#define GTZC_TZIC_FCR2_CI2C3F_Msk         (0x01UL << GTZC_TZIC_FCR2_CI2C3F_Pos)
#define GTZC_TZIC_FCR2_CI2C3F             GTZC_TZIC_FCR2_CI2C3F_Msk                 /*!<  clear the illegal access flag for I2C3 */
#define GTZC_TZIC_FCR2_CLPTIM1F_Pos       (19UL)
#define GTZC_TZIC_FCR2_CLPTIM1F_Msk       (0x01UL << GTZC_TZIC_FCR2_CLPTIM1F_Pos)
#define GTZC_TZIC_FCR2_CLPTIM1F           GTZC_TZIC_FCR2_CLPTIM1F_Msk               /*!<  clear the illegal access flag for LPTIM1 */
#define GTZC_TZIC_FCR2_CCOMPF_Pos         (23UL)
#define GTZC_TZIC_FCR2_CCOMPF_Msk         (0x01UL << GTZC_TZIC_FCR2_CCOMPF_Pos)
#define GTZC_TZIC_FCR2_CCOMPF             GTZC_TZIC_FCR2_CCOMPF_Msk                 /*!<  clear the illegal access flag for COMP */
#define GTZC_TZIC_FCR2_CADC4F_Pos         (24UL)
#define GTZC_TZIC_FCR2_CADC4F_Msk         (0x01UL << GTZC_TZIC_FCR2_CADC4F_Pos)
#define GTZC_TZIC_FCR2_CADC4F             GTZC_TZIC_FCR2_CADC4F_Msk                 /*!<  clear the illegal access flag for ADC4 */
#define GTZC_TZIC_FCR2_CVREFBUFF_Pos      (25UL)
#define GTZC_TZIC_FCR2_CVREFBUFF_Msk      (0x01UL << GTZC_FCR2_CVREFBUFF_Pos)
#define GTZC_TZIC_FCR2_CVREFBUFF          GTZC_TZIC_FCR2_CVREFBUFF_Msk              /*!<  clear the illegal access flag for VREFBUF */

/******************  Bits definition for GTZC_TZIC_FCR3 register  ****************/
#define GTZC_TZIC_FCR3_CCRCF_Pos          (3UL)
#define GTZC_TZIC_FCR3_CCRCF_Msk          (0x01UL << GTZC_TZIC_FCR3_CCRCF_Pos)
#define GTZC_TZIC_FCR3_CCRCF              GTZC_TZIC_FCR3_CCRCF_Msk                  /*!<  clear the illegal access flag enable for CRC */
#define GTZC_TZIC_FCR3_CTSCF_Pos          (4UL)
#define GTZC_TZIC_FCR3_CTSCF_Msk          (0x01UL << GTZC_TZIC_FCR3_CTSCF_Pos)
#define GTZC_TZIC_FCR3_CTSCF              GTZC_TZIC_FCR3_CTSCF_Msk                  /*!<  clear the illegal access flag enable for TSC */
#define GTZC_TZIC_FCR3_CICACHE_REGF_Pos   (6UL)
#define GTZC_TZIC_FCR3_CICACHE_REGF_Msk   (0x01UL << GTZC_TZIC_FCR3_CICACHE_REGF_Pos)
#define GTZC_TZIC_FCR3_CICACHE_REGF       GTZC_TZIC_FCR3_CICACHE_REGF_Msk           /*!<  clear the illegal access flag enable for ICACHE_REG */
#define GTZC_TZIC_FCR3_COTGF_Pos          (10UL)
#define GTZC_TZIC_FCR3_COTGF_Msk          (0x01UL << GTZC_TZIC_FCR3_COTGF_Pos)
#define GTZC_TZIC_FCR3_COTGF              GTZC_TZIC_FCR3_COTGF_Msk                  /*!<  clear the illegal access flag for OTG */
#define GTZC_TZIC_FCR3_CAESF_Pos          (11UL)
#define GTZC_TZIC_FCR3_CAESF_Msk          (0x01UL << GTZC_TZIC_FCR3_CAESF_Pos)
#define GTZC_TZIC_FCR3_CAESF              GTZC_TZIC_FCR3_CAESF_Msk                  /*!<  clear the illegal access flag enable for AES */
#define GTZC_TZIC_FCR3_CHASHF_Pos         (12UL)
#define GTZC_TZIC_FCR3_CHASHF_Msk         (0x01UL << GTZC_TZIC_FCR3_CHASHF_Pos)
#define GTZC_TZIC_FCR3_CHASHF             GTZC_TZIC_FCR3_CHASHF_Msk                 /*!<  clear the illegal access flag enable for HASH */
#define GTZC_TZIC_FCR3_CRNGF_Pos          (13UL)
#define GTZC_TZIC_FCR3_CRNGF_Msk          (0x01UL << GTZC_TZIC_FCR3_CRNGF_Pos)
#define GTZC_TZIC_FCR3_CRNGF              GTZC_TZIC_FCR3_CRNGF_Msk                  /*!<  clear the illegal access flag enable for RNG */
#define GTZC_TZIC_FCR3_CSAESF_Pos         (14UL)
#define GTZC_TZIC_FCR3_CSAESF_Msk         (0x01UL << GTZC_TZIC_FCR3_CSAESF_Pos)
#define GTZC_TZIC_FCR3_CSAESF             GTZC_TZIC_FCR3_CSAESF_Msk                 /*!<  clear the illegal access flag enable for SAES */
#define GTZC_TZIC_FCR3_CHSEMF_Pos         (15UL)
#define GTZC_TZIC_FCR3_CHSEMF_Msk         (0x01UL << GTZC_TZIC_FCR3_CHSEMF_Pos)
#define GTZC_TZIC_FCR3_CHSEMF             GTZC_TZIC_FCR3_CHSEMF_Msk                 /*!<  clear the illegal access flag enable for HSEM */
#define GTZC_TZIC_FCR3_CPKAF_Pos          (16UL)
#define GTZC_TZIC_FCR3_CPKAF_Msk          (0x01UL << GTZC_TZIC_FCR3_CPKAF_Pos)
#define GTZC_TZIC_FCR3_CPKAF              GTZC_TZIC_FCR3_CPKAF_Msk                  /*!<  clear the illegal access flag enable for PKA */
#define GTZC_TZIC_FCR3_CRAMCFGF_Pos       (22UL)
#define GTZC_TZIC_FCR3_CRAMCFGF_Msk       (0x01UL << GTZC_TZIC_FCR3_CRAMCFGF_Pos)
#define GTZC_TZIC_FCR3_CRAMCFGF           GTZC_TZIC_FCR3_CRAMCFGF_Msk               /*!<  clear the illegal access flag enable for RAMCFG */
#define GTZC_TZIC_FCR3_CRADIOF_Pos        (23UL)
#define GTZC_TZIC_FCR3_CRADIOF_Msk        (0x01UL << GTZC_TZIC_FCR3_CRADIOF_Pos)
#define GTZC_TZIC_FCR3_CRADIOF            GTZC_TZIC_FCR3_CRADIOF_Msk                /*!<  clear the illegal access flag enable for 2.4 GHz RADIO */
#define GTZC_TZIC_FCR3_CPTACONVF_Pos      (24UL)
#define GTZC_TZIC_FCR3_CPTACONVF_Msk      (0x01UL << GTZC_TZIC_FCR3_CPTACONVF_Pos)
#define GTZC_TZIC_FCR3_CPTACONVF          GTZC_TZIC_FCR3_CPTACONVF_Msk              /*!<  clear the illegal access flag enable for PTACONV */

/******************  Bits definition for GTZC_TZIC_FCR4 register  ****************/
#define GTZC_TZIC_FCR4_CGPDMA1F_Pos       (0UL)
#define GTZC_TZIC_FCR4_CGPDMA1F_Msk       (0x01UL << GTZC_TZIC_FCR4_CGPDMA1F_Pos)
#define GTZC_TZIC_FCR4_CGPDMA1F           GTZC_TZIC_FCR4_CGPDMA1F_Msk               /*!<  clear the illegal access flag enable for GPDMA1 */
#define GTZC_TZIC_FCR4_CFLASHF_Pos        (1UL)
#define GTZC_TZIC_FCR4_CFLASHF_Msk        (0x01UL << GTZC_TZIC_FCR4_CFLASHF_Pos)
#define GTZC_TZIC_FCR4_CFLASHF            GTZC_TZIC_FCR4_CFLASHF_Msk                /*!<  clear the illegal access flag enable for FLASH memory */
#define GTZC_TZIC_FCR4_CFLASH_REGF_Pos    (2UL)
#define GTZC_TZIC_FCR4_CFLASH_REGF_Msk    (0x01UL << GTZC_TZIC_FCR4_CFLASH_REGF_Pos)
#define GTZC_TZIC_FCR4_CFLASH_REGF        GTZC_TZIC_FCR4_CFLASH_REGF_Msk            /*!<  clear the illegal access flag enable for FLASH interface */
#define GTZC_TZIC_FCR4_CSYSCFGF_Pos       (7UL)
#define GTZC_TZIC_FCR4_CSYSCFGF_Msk       (0x01UL << GTZC_TZIC_FCR4_CSYSCFGF_Pos)
#define GTZC_TZIC_FCR4_CSYSCFGF           GTZC_TZIC_FCR4_CSYSCFGF_Msk               /*!<  clear the illegal access flag enable for SYSCFG interface */
#define GTZC_TZIC_FCR4_CRTCF_Pos          (8UL)
#define GTZC_TZIC_FCR4_CRTCF_Msk          (0x01UL << GTZC_TZIC_FCR4_CRTCF_Pos)
#define GTZC_TZIC_FCR4_CRTCF              GTZC_TZIC_FCR4_CRTCF_Msk                  /*!<  clear the illegal access flag enable for RTC interface */
#define GTZC_TZIC_FCR4_CTAMPF_Pos         (9UL)
#define GTZC_TZIC_FCR4_CTAMPF_Msk         (0x01UL << GTZC_TZIC_FCR4_CTAMPF_Pos)
#define GTZC_TZIC_FCR4_CTAMPF             GTZC_TZIC_FCR4_CTAMPF_Msk                 /*!<  clear the illegal access flag enable for TAMP interface */
#define GTZC_TZIC_FCR4_CPWRF_Pos          (10UL)
#define GTZC_TZIC_FCR4_CPWRF_Msk          (0x01UL << GTZC_TZIC_FCR4_CPWRF_Pos)
#define GTZC_TZIC_FCR4_CPWRF              GTZC_TZIC_FCR4_CPWRF_Msk                  /*!<  clear the illegal access flag enable for PWR interface */
#define GTZC_TZIC_FCR4_CRCCF_Pos          (11UL)
#define GTZC_TZIC_FCR4_CRCCF_Msk          (0x01UL << GTZC_TZIC_FCR4_CRCCF_Pos)
#define GTZC_TZIC_FCR4_CRCCF              GTZC_TZIC_FCR4_CRCCF_Msk                  /*!<  clear the illegal access flag enable for RCC interface */
#define GTZC_TZIC_FCR4_CEXTIF_Pos         (13UL)
#define GTZC_TZIC_FCR4_CEXTIF_Msk         (0x01UL << GTZC_TZIC_FCR4_CEXTIF_Pos)
#define GTZC_TZIC_FCR4_CEXTIF             GTZC_TZIC_FCR4_CEXTIF_Msk                 /*!<  clear the illegal access flag enable for EXTI interface */
#define GTZC_TZIC_FCR4_CTZSCF_Pos         (14UL)
#define GTZC_TZIC_FCR4_CTZSCF_Msk         (0x01UL << GTZC_TZIC_FCR4_CTZSCF_Pos)
#define GTZC_TZIC_FCR4_CTZSCF             GTZC_TZIC_FCR4_CTZSCF_Msk                 /*!<  clear the illegal access flag enable for GTZC TZSC */
#define GTZC_TZIC_FCR4_CTZICF_Pos         (15UL)
#define GTZC_TZIC_FCR4_CTZICF_Msk         (0x01UL << GTZC_TZIC_FCR4_CTZICF_Pos)
#define GTZC_TZIC_FCR4_CTZICF             GTZC_TZIC_FCR4_CTZICF_Msk                 /*!<  clear the illegal access flag enable for GTZC TZIC */
#define GTZC_TZIC_FCR4_CSRAM1F_Pos        (22UL)
#define GTZC_TZIC_FCR4_CSRAM1F_Msk        (0x01UL << GTZC_TZIC_FCR4_CSRAM1F_Pos)
#define GTZC_TZIC_FCR4_CSRAM1F            GTZC_TZIC_FCR4_CSRAM1F_Msk                /*!<  clear the illegal access flag enable for SRAM1 memory */
#define GTZC_TZIC_FCR4_CMPCBB1F_Pos       (23UL)
#define GTZC_TZIC_FCR4_CMPCBB1F_Msk       (0x01UL << GTZC_TZIC_FCR4_CMPCBB1F_Pos)
#define GTZC_TZIC_FCR4_CMPCBB1F           GTZC_TZIC_FCR4_CMPCBB1F_Msk               /*!<  clear the illegal access flag enable for MPCBB1 */
#define GTZC_TZIC_FCR4_CSRAM2F_Pos        (24UL)
#define GTZC_TZIC_FCR4_CSRAM2F_Msk        (0x01UL << GTZC_TZIC_FCR4_CSRAM2F_Pos)
#define GTZC_TZIC_FCR4_CSRAM2F            GTZC_TZIC_FCR4_CSRAM2F_Msk                /*!<  clear the illegal access flag enable for SRAM2 memory */
#define GTZC_TZIC_FCR4_CMPCBB2F_Pos       (25UL)
#define GTZC_TZIC_FCR4_CMPCBB2F_Msk       (0x01UL << GTZC_TZIC_FCR4_CMPCBB2F_Pos)
#define GTZC_TZIC_FCR4_CMPCBB2F            GTZC_TZIC_FCR4_CMPCBB2F_Msk              /*!<  clear the illegal access flag enable for MPCBB2 */
#define GTZC_TZIC_FCR4_CSRAM6F_Pos        (30UL)
#define GTZC_TZIC_FCR4_CSRAM6F_Msk        (0x01UL << GTZC_TZIC_FCR4_CSRAM6F_Pos)
#define GTZC_TZIC_FCR4_CSRAM6F            GTZC_TZIC_FCR4_CSRAM6F_Msk                /*!<  clear the illegal access flag enable for 2.4GHz TXRX SRAM memory */
#define GTZC_TZIC_FCR4_CMPCBB6F_Pos       (31UL)
#define GTZC_TZIC_FCR4_CMPCBB6F_Msk       (0x01UL << GTZC_TZIC_FCR4_CMPCBB6F_Pos)
#define GTZC_TZIC_FCR4_CMPCBB6F           GTZC_TZIC_FCR4_CMPCBB6F_Msk               /*!<  clear the illegal access flag enable for MPCBB6 */

/*******************  Bits definition for GTZC_MPCBB_CR register  *****************/
#define GTZC_MPCBB_CR_GLOCK_Pos           (0UL)
#define GTZC_MPCBB_CR_GLOCK_Msk           (0x01UL << GTZC_MPCBB_CR_GLOCK_Pos)         /*!< 0x00000001 */
#define GTZC_MPCBB_CR_GLOCK               GTZC_MPCBB_CR_GLOCK_Msk                     /*!< lock the control register of the MPCBB until next reset */
#define GTZC_MPCBB_CR_INVSECSTATE_Pos     (30UL)
#define GTZC_MPCBB_CR_INVSECSTATE_Msk     (0x01UL << GTZC_MPCBB_CR_INVSECSTATE_Pos)   /*!< 0x40000000 */
#define GTZC_MPCBB_CR_INVSECSTATE         GTZC_MPCBB_CR_INVSECSTATE_Msk               /*!< SRAM clocks security state */
#define GTZC_MPCBB_CR_SRWILADIS_Pos       (31UL)
#define GTZC_MPCBB_CR_SRWILADIS_Msk       (0x01UL << GTZC_MPCBB_CR_SRWILADIS_Pos)     /*!< 0x80000000 */
#define GTZC_MPCBB_CR_SRWILADIS           GTZC_MPCBB_CR_SRWILADIS_Msk                 /*!< secure read/write illegal access disable */

/*******************  Bits definition for GTZC_MPCBB_CFGLOCK register  ************/
#define GTZC_MPCBB_CFGLOCK_SPLCK0_Pos       (0UL)
#define GTZC_MPCBB_CFGLOCK_SPLCK0_Msk       (0x01UL << GTZC_MPCBB_CFGLOCK_SPLCK0_Pos) /*!< 0x00000001 */
#define GTZC_MPCBB_CFGLOCK_SPLCK0           GTZC_MPCBB_CFGLOCK_SPLCK0_Msk             /*!< Security/privilege configuration lock super-block 0  */
#define GTZC_MPCBB_CFGLOCK_SPLCK1_Pos       (1UL)
#define GTZC_MPCBB_CFGLOCK_SPLCK1_Msk       (0x01UL << GTZC_MPCBB_CFGLOCK_SPLCK1_Pos) /*!< 0x00000002 */
#define GTZC_MPCBB_CFGLOCK_SPLCK1           GTZC_MPCBB_CFGLOCK_SPLCK1_Msk             /*!< Security/privilege configuration lock super-block 1  */
#define GTZC_MPCBB_CFGLOCK_SPLCK2_Pos       (2UL)
#define GTZC_MPCBB_CFGLOCK_SPLCK2_Msk       (0x01UL << GTZC_MPCBB_CFGLOCK_SPLCK2_Pos) /*!< 0x00000004 */
#define GTZC_MPCBB_CFGLOCK_SPLCK2           GTZC_MPCBB_CFGLOCK_SPLCK2_Msk             /*!< Security/privilege configuration lock super-block 2  */
#define GTZC_MPCBB_CFGLOCK_SPLCK3_Pos       (3UL)
#define GTZC_MPCBB_CFGLOCK_SPLCK3_Msk       (0x01UL << GTZC_MPCBB_CFGLOCK_SPLCK3_Pos) /*!< 0x00000008 */
#define GTZC_MPCBB_CFGLOCK_SPLCK3           GTZC_MPCBB_CFGLOCK_SPLCK3_Msk             /*!< Security/privilege configuration lock super-block 3  */

/*******************  Bits definition for GTZC_MPCBB_SECCFGR0 register  ************/
#define GTZC_MPCBB_SECCFGR0_SEC0_Pos       (0UL)
#define GTZC_MPCBB_SECCFGR0_SEC0_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC0_Pos)  /*!< 0x00000001 */
#define GTZC_MPCBB_SECCFGR0_SEC0           GTZC_MPCBB_SECCFGR0_SEC0_Msk              /*!< Security configuration for block 0 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC1_Pos       (1UL)
#define GTZC_MPCBB_SECCFGR0_SEC1_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC1_Pos)  /*!< 0x00000002 */
#define GTZC_MPCBB_SECCFGR0_SEC1           GTZC_MPCBB_SECCFGR0_SEC1_Msk              /*!< Security configuration for block 1 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC2_Pos       (2UL)
#define GTZC_MPCBB_SECCFGR0_SEC2_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC2_Pos)  /*!< 0x00000004 */
#define GTZC_MPCBB_SECCFGR0_SEC2           GTZC_MPCBB_SECCFGR0_SEC2_Msk              /*!< Security configuration for block 2 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC3_Pos       (3UL)
#define GTZC_MPCBB_SECCFGR0_SEC3_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC3_Pos)  /*!< 0x00000008 */
#define GTZC_MPCBB_SECCFGR0_SEC3           GTZC_MPCBB_SECCFGR0_SEC3_Msk              /*!< Security configuration for block 3 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC4_Pos       (4UL)
#define GTZC_MPCBB_SECCFGR0_SEC4_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC4_Pos)  /*!< 0x00000010 */
#define GTZC_MPCBB_SECCFGR0_SEC4           GTZC_MPCBB_SECCFGR0_SEC4_Msk              /*!< Security configuration for block 4 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC5_Pos       (5UL)
#define GTZC_MPCBB_SECCFGR0_SEC5_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC5_Pos)  /*!< 0x00000020 */
#define GTZC_MPCBB_SECCFGR0_SEC5           GTZC_MPCBB_SECCFGR0_SEC5_Msk              /*!< Security configuration for block 5 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC6_Pos       (6UL)
#define GTZC_MPCBB_SECCFGR0_SEC6_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC6_Pos)  /*!< 0x00000040 */
#define GTZC_MPCBB_SECCFGR0_SEC6           GTZC_MPCBB_SECCFGR0_SEC6_Msk              /*!< Security configuration for block 6 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC7_Pos       (7UL)
#define GTZC_MPCBB_SECCFGR0_SEC7_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC7_Pos)  /*!< 0x00000080 */
#define GTZC_MPCBB_SECCFGR0_SEC7           GTZC_MPCBB_SECCFGR0_SEC7_Msk              /*!< Security configuration for block 7 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC8_Pos       (8UL)
#define GTZC_MPCBB_SECCFGR0_SEC8_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC8_Pos)  /*!< 0x00000100 */
#define GTZC_MPCBB_SECCFGR0_SEC8           GTZC_MPCBB_SECCFGR0_SEC8_Msk              /*!< Security configuration for block 8 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC9_Pos       (9UL)
#define GTZC_MPCBB_SECCFGR0_SEC9_Msk       (0x01UL << GTZC_MPCBB_SECCFGR0_SEC9_Pos)  /*!< 0x00000200 */
#define GTZC_MPCBB_SECCFGR0_SEC9           GTZC_MPCBB_SECCFGR0_SEC9_Msk              /*!< Security configuration for block 9 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC10_Pos      (10UL)
#define GTZC_MPCBB_SECCFGR0_SEC10_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_SECCFGR0_SEC10          GTZC_MPCBB_SECCFGR0_SEC10_Msk             /*!< Security configuration for block 10 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC11_Pos      (11UL)
#define GTZC_MPCBB_SECCFGR0_SEC11_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_SECCFGR0_SEC11          GTZC_MPCBB_SECCFGR0_SEC11_Msk             /*!< Security configuration for block 11 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC12_Pos      (12UL)
#define GTZC_MPCBB_SECCFGR0_SEC12_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_SECCFGR0_SEC12          GTZC_MPCBB_SECCFGR0_SEC12_Msk             /*!< Security configuration for block 12 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC13_Pos      (13UL)
#define GTZC_MPCBB_SECCFGR0_SEC13_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_SECCFGR0_SEC13          GTZC_MPCBB_SECCFGR0_SEC13_Msk             /*!< Security configuration for block 13 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC14_Pos      (14UL)
#define GTZC_MPCBB_SECCFGR0_SEC14_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_SECCFGR0_SEC14          GTZC_MPCBB_SECCFGR0_SEC14_Msk             /*!< Security configuration for block 14 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC15_Pos      (15UL)
#define GTZC_MPCBB_SECCFGR0_SEC15_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_SECCFGR0_SEC15          GTZC_MPCBB_SECCFGR0_SEC15_Msk             /*!< Security configuration for block 15 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC16_Pos      (16UL)
#define GTZC_MPCBB_SECCFGR0_SEC16_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_SECCFGR0_SEC16          GTZC_MPCBB_SECCFGR0_SEC16_Msk             /*!< Security configuration for block 16 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC17_Pos      (17UL)
#define GTZC_MPCBB_SECCFGR0_SEC17_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_SECCFGR0_SEC17          GTZC_MPCBB_SECCFGR0_SEC17_Msk             /*!< Security configuration for block 17 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC18_Pos      (18UL)
#define GTZC_MPCBB_SECCFGR0_SEC18_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_SECCFGR0_SEC18          GTZC_MPCBB_SECCFGR0_SEC18_Msk             /*!< Security configuration for block 18 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC19_Pos      (19UL)
#define GTZC_MPCBB_SECCFGR0_SEC19_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_SECCFGR0_SEC19          GTZC_MPCBB_SECCFGR0_SEC19_Msk             /*!< Security configuration for block 19 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC20_Pos      (20UL)
#define GTZC_MPCBB_SECCFGR0_SEC20_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_SECCFGR0_SEC20          GTZC_MPCBB_SECCFGR0_SEC20_Msk             /*!< Security configuration for block 20 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC21_Pos      (21UL)
#define GTZC_MPCBB_SECCFGR0_SEC21_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_SECCFGR0_SEC21          GTZC_MPCBB_SECCFGR0_SEC21_Msk             /*!< Security configuration for block 21 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC22_Pos      (22UL)
#define GTZC_MPCBB_SECCFGR0_SEC22_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_SECCFGR0_SEC22          GTZC_MPCBB_SECCFGR0_SEC22_Msk             /*!< Security configuration for block 22 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC23_Pos      (23UL)
#define GTZC_MPCBB_SECCFGR0_SEC23_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_SECCFGR0_SEC23          GTZC_MPCBB_SECCFGR0_SEC23_Msk             /*!< Security configuration for block 23 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC24_Pos      (24UL)
#define GTZC_MPCBB_SECCFGR0_SEC24_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_SECCFGR0_SEC24          GTZC_MPCBB_SECCFGR0_SEC24_Msk             /*!< Security configuration for block 24 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC25_Pos      (25UL)
#define GTZC_MPCBB_SECCFGR0_SEC25_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_SECCFGR0_SEC25          GTZC_MPCBB_SECCFGR0_SEC25_Msk             /*!< Security configuration for block 25 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC26_Pos      (26UL)
#define GTZC_MPCBB_SECCFGR0_SEC26_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_SECCFGR0_SEC26          GTZC_MPCBB_SECCFGR0_SEC26_Msk             /*!< Security configuration for block 26 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC27_Pos      (27UL)
#define GTZC_MPCBB_SECCFGR0_SEC27_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_SECCFGR0_SEC27          GTZC_MPCBB_SECCFGR0_SEC27_Msk             /*!< Security configuration for block 27 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC28_Pos      (28UL)
#define GTZC_MPCBB_SECCFGR0_SEC28_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_SECCFGR0_SEC28          GTZC_MPCBB_SECCFGR0_SEC28_Msk             /*!< Security configuration for block 28 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC29_Pos      (29UL)
#define GTZC_MPCBB_SECCFGR0_SEC29_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_SECCFGR0_SEC29          GTZC_MPCBB_SECCFGR0_SEC29_Msk             /*!< Security configuration for block 29 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC30_Pos      (30UL)
#define GTZC_MPCBB_SECCFGR0_SEC30_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_SECCFGR0_SEC30          GTZC_MPCBB_SECCFGR0_SEC31_Msk             /*!< Security configuration for block 30 in super block 0  */
#define GTZC_MPCBB_SECCFGR0_SEC31_Pos      (31UL)
#define GTZC_MPCBB_SECCFGR0_SEC31_Msk      (0x01UL << GTZC_MPCBB_SECCFGR0_SEC31_Pos) /*!< 0x80000000 */
#define GTZC_MPCBB_SECCFGR0_SEC31          GTZC_MPCBB_SECCFGR0_SEC31_Msk             /*!< Security configuration for block 31 in super block 0  */

/*******************  Bits definition for GTZC_MPCBB_SECCFGR1 register  ************/
#define GTZC_MPCBB_SECCFGR1_SEC0_Pos       (0UL)
#define GTZC_MPCBB_SECCFGR1_SEC0_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC0_Pos)  /*!< 0x00000001 */
#define GTZC_MPCBB_SECCFGR1_SEC0           GTZC_MPCBB_SECCFGR1_SEC0_Msk              /*!< Security configuration for block 0 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC1_Pos       (1UL)
#define GTZC_MPCBB_SECCFGR1_SEC1_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC1_Pos)  /*!< 0x00000002 */
#define GTZC_MPCBB_SECCFGR1_SEC1           GTZC_MPCBB_SECCFGR1_SEC1_Msk              /*!< Security configuration for block 1 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC2_Pos       (2UL)
#define GTZC_MPCBB_SECCFGR1_SEC2_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC2_Pos)  /*!< 0x00000004 */
#define GTZC_MPCBB_SECCFGR1_SEC2           GTZC_MPCBB_SECCFGR1_SEC2_Msk              /*!< Security configuration for block 2 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC3_Pos       (3UL)
#define GTZC_MPCBB_SECCFGR1_SEC3_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC3_Pos)  /*!< 0x00000008 */
#define GTZC_MPCBB_SECCFGR1_SEC3           GTZC_MPCBB_SECCFGR1_SEC3_Msk              /*!< Security configuration for block 3 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC4_Pos       (4UL)
#define GTZC_MPCBB_SECCFGR1_SEC4_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC4_Pos)  /*!< 0x00000010 */
#define GTZC_MPCBB_SECCFGR1_SEC4           GTZC_MPCBB_SECCFGR1_SEC4_Msk              /*!< Security configuration for block 4 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC5_Pos       (5UL)
#define GTZC_MPCBB_SECCFGR1_SEC5_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC5_Pos)  /*!< 0x00000020 */
#define GTZC_MPCBB_SECCFGR1_SEC5           GTZC_MPCBB_SECCFGR1_SEC5_Msk              /*!< Security configuration for block 5 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC6_Pos       (6UL)
#define GTZC_MPCBB_SECCFGR1_SEC6_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC6_Pos)  /*!< 0x00000040 */
#define GTZC_MPCBB_SECCFGR1_SEC6           GTZC_MPCBB_SECCFGR1_SEC6_Msk              /*!< Security configuration for block 6 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC7_Pos       (7UL)
#define GTZC_MPCBB_SECCFGR1_SEC7_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC7_Pos)  /*!< 0x00000080 */
#define GTZC_MPCBB_SECCFGR1_SEC7           GTZC_MPCBB_SECCFGR1_SEC7_Msk              /*!< Security configuration for block 7 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC8_Pos       (8UL)
#define GTZC_MPCBB_SECCFGR1_SEC8_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC8_Pos)  /*!< 0x00000100 */
#define GTZC_MPCBB_SECCFGR1_SEC8           GTZC_MPCBB_SECCFGR1_SEC8_Msk              /*!< Security configuration for block 8 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC9_Pos       (9UL)
#define GTZC_MPCBB_SECCFGR1_SEC9_Msk       (0x01UL << GTZC_MPCBB_SECCFGR1_SEC9_Pos)  /*!< 0x00000200 */
#define GTZC_MPCBB_SECCFGR1_SEC9           GTZC_MPCBB_SECCFGR1_SEC9_Msk              /*!< Security configuration for block 9 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC10_Pos      (10UL)
#define GTZC_MPCBB_SECCFGR1_SEC10_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_SECCFGR1_SEC10          GTZC_MPCBB_SECCFGR1_SEC10_Msk             /*!< Security configuration for block 10 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC11_Pos      (11UL)
#define GTZC_MPCBB_SECCFGR1_SEC11_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_SECCFGR1_SEC11          GTZC_MPCBB_SECCFGR1_SEC11_Msk             /*!< Security configuration for block 11 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC12_Pos      (12UL)
#define GTZC_MPCBB_SECCFGR1_SEC12_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_SECCFGR1_SEC12          GTZC_MPCBB_SECCFGR1_SEC12_Msk             /*!< Security configuration for block 12 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC13_Pos      (13UL)
#define GTZC_MPCBB_SECCFGR1_SEC13_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_SECCFGR1_SEC13          GTZC_MPCBB_SECCFGR1_SEC13_Msk             /*!< Security configuration for block 13 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC14_Pos      (14UL)
#define GTZC_MPCBB_SECCFGR1_SEC14_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_SECCFGR1_SEC14          GTZC_MPCBB_SECCFGR1_SEC14_Msk             /*!< Security configuration for block 14 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC15_Pos      (15UL)
#define GTZC_MPCBB_SECCFGR1_SEC15_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_SECCFGR1_SEC15          GTZC_MPCBB_SECCFGR1_SEC15_Msk             /*!< Security configuration for block 15 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC16_Pos      (16UL)
#define GTZC_MPCBB_SECCFGR1_SEC16_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_SECCFGR1_SEC16          GTZC_MPCBB_SECCFGR1_SEC16_Msk             /*!< Security configuration for block 16 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC17_Pos      (17UL)
#define GTZC_MPCBB_SECCFGR1_SEC17_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_SECCFGR1_SEC17          GTZC_MPCBB_SECCFGR1_SEC17_Msk             /*!< Security configuration for block 17 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC18_Pos      (18UL)
#define GTZC_MPCBB_SECCFGR1_SEC18_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_SECCFGR1_SEC18          GTZC_MPCBB_SECCFGR1_SEC18_Msk             /*!< Security configuration for block 18 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC19_Pos      (19UL)
#define GTZC_MPCBB_SECCFGR1_SEC19_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_SECCFGR1_SEC19          GTZC_MPCBB_SECCFGR1_SEC19_Msk             /*!< Security configuration for block 19 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC20_Pos      (20UL)
#define GTZC_MPCBB_SECCFGR1_SEC20_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_SECCFGR1_SEC20          GTZC_MPCBB_SECCFGR1_SEC20_Msk             /*!< Security configuration for block 20 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC21_Pos      (21UL)
#define GTZC_MPCBB_SECCFGR1_SEC21_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_SECCFGR1_SEC21          GTZC_MPCBB_SECCFGR1_SEC21_Msk             /*!< Security configuration for block 21 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC22_Pos      (22UL)
#define GTZC_MPCBB_SECCFGR1_SEC22_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_SECCFGR1_SEC22          GTZC_MPCBB_SECCFGR1_SEC22_Msk             /*!< Security configuration for block 22 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC23_Pos      (23UL)
#define GTZC_MPCBB_SECCFGR1_SEC23_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_SECCFGR1_SEC23          GTZC_MPCBB_SECCFGR1_SEC23_Msk             /*!< Security configuration for block 23 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC24_Pos      (24UL)
#define GTZC_MPCBB_SECCFGR1_SEC24_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_SECCFGR1_SEC24          GTZC_MPCBB_SECCFGR1_SEC24_Msk             /*!< Security configuration for block 24 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC25_Pos      (25UL)
#define GTZC_MPCBB_SECCFGR1_SEC25_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_SECCFGR1_SEC25          GTZC_MPCBB_SECCFGR1_SEC25_Msk             /*!< Security configuration for block 25 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC26_Pos      (26UL)
#define GTZC_MPCBB_SECCFGR1_SEC26_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_SECCFGR1_SEC26          GTZC_MPCBB_SECCFGR1_SEC26_Msk             /*!< Security configuration for block 26 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC27_Pos      (27UL)
#define GTZC_MPCBB_SECCFGR1_SEC27_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_SECCFGR1_SEC27          GTZC_MPCBB_SECCFGR1_SEC27_Msk             /*!< Security configuration for block 27 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC28_Pos      (28UL)
#define GTZC_MPCBB_SECCFGR1_SEC28_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_SECCFGR1_SEC28          GTZC_MPCBB_SECCFGR1_SEC28_Msk             /*!< Security configuration for block 28 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC29_Pos      (29UL)
#define GTZC_MPCBB_SECCFGR1_SEC29_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_SECCFGR1_SEC29          GTZC_MPCBB_SECCFGR1_SEC29_Msk             /*!< Security configuration for block 29 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC30_Pos      (30UL)
#define GTZC_MPCBB_SECCFGR1_SEC30_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_SECCFGR1_SEC30          GTZC_MPCBB_SECCFGR1_SEC31_Msk             /*!< Security configuration for block 30 in super block 1  */
#define GTZC_MPCBB_SECCFGR1_SEC31_Pos      (31UL)
#define GTZC_MPCBB_SECCFGR1_SEC31_Msk      (0x01UL << GTZC_MPCBB_SECCFGR1_SEC31_Pos) /*!< 0x80000000 */
#define GTZC_MPCBB_SECCFGR1_SEC31          GTZC_MPCBB_SECCFGR1_SEC31_Msk             /*!< Security configuration for block 31 in super block 1  */

/*******************  Bits definition for GTZC_MPCBB_SECCFGR2 register  ************/
#define GTZC_MPCBB_SECCFGR2_SEC0_Pos       (0UL)
#define GTZC_MPCBB_SECCFGR2_SEC0_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC0_Pos)  /*!< 0x00000001 */
#define GTZC_MPCBB_SECCFGR2_SEC0           GTZC_MPCBB_SECCFGR2_SEC0_Msk              /*!< Security configuration for block 0 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC1_Pos       (1UL)
#define GTZC_MPCBB_SECCFGR2_SEC1_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC1_Pos)  /*!< 0x00000002 */
#define GTZC_MPCBB_SECCFGR2_SEC1           GTZC_MPCBB_SECCFGR2_SEC1_Msk              /*!< Security configuration for block 1 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC2_Pos       (2UL)
#define GTZC_MPCBB_SECCFGR2_SEC2_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC2_Pos)  /*!< 0x00000004 */
#define GTZC_MPCBB_SECCFGR2_SEC2           GTZC_MPCBB_SECCFGR2_SEC2_Msk              /*!< Security configuration for block 2 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC3_Pos       (3UL)
#define GTZC_MPCBB_SECCFGR2_SEC3_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC3_Pos)  /*!< 0x00000008 */
#define GTZC_MPCBB_SECCFGR2_SEC3           GTZC_MPCBB_SECCFGR2_SEC3_Msk              /*!< Security configuration for block 3 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC4_Pos       (4UL)
#define GTZC_MPCBB_SECCFGR2_SEC4_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC4_Pos)  /*!< 0x00000010 */
#define GTZC_MPCBB_SECCFGR2_SEC4           GTZC_MPCBB_SECCFGR2_SEC4_Msk              /*!< Security configuration for block 4 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC5_Pos       (5UL)
#define GTZC_MPCBB_SECCFGR2_SEC5_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC5_Pos)  /*!< 0x00000020 */
#define GTZC_MPCBB_SECCFGR2_SEC5           GTZC_MPCBB_SECCFGR2_SEC5_Msk              /*!< Security configuration for block 5 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC6_Pos       (6UL)
#define GTZC_MPCBB_SECCFGR2_SEC6_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC6_Pos)  /*!< 0x00000040 */
#define GTZC_MPCBB_SECCFGR2_SEC6           GTZC_MPCBB_SECCFGR2_SEC6_Msk              /*!< Security configuration for block 6 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC7_Pos       (7UL)
#define GTZC_MPCBB_SECCFGR2_SEC7_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC7_Pos)  /*!< 0x00000080 */
#define GTZC_MPCBB_SECCFGR2_SEC7           GTZC_MPCBB_SECCFGR2_SEC7_Msk              /*!< Security configuration for block 7 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC8_Pos       (8UL)
#define GTZC_MPCBB_SECCFGR2_SEC8_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC8_Pos)  /*!< 0x00000100 */
#define GTZC_MPCBB_SECCFGR2_SEC8           GTZC_MPCBB_SECCFGR2_SEC8_Msk              /*!< Security configuration for block 8 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC9_Pos       (9UL)
#define GTZC_MPCBB_SECCFGR2_SEC9_Msk       (0x01UL << GTZC_MPCBB_SECCFGR2_SEC9_Pos)  /*!< 0x00000200 */
#define GTZC_MPCBB_SECCFGR2_SEC9           GTZC_MPCBB_SECCFGR2_SEC9_Msk              /*!< Security configuration for block 9 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC10_Pos      (10UL)
#define GTZC_MPCBB_SECCFGR2_SEC10_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_SECCFGR2_SEC10          GTZC_MPCBB_SECCFGR2_SEC10_Msk             /*!< Security configuration for block 10 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC11_Pos      (11UL)
#define GTZC_MPCBB_SECCFGR2_SEC11_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_SECCFGR2_SEC11          GTZC_MPCBB_SECCFGR2_SEC11_Msk             /*!< Security configuration for block 11 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC12_Pos      (12UL)
#define GTZC_MPCBB_SECCFGR2_SEC12_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_SECCFGR2_SEC12          GTZC_MPCBB_SECCFGR2_SEC12_Msk             /*!< Security configuration for block 12 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC13_Pos      (13UL)
#define GTZC_MPCBB_SECCFGR2_SEC13_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_SECCFGR2_SEC13          GTZC_MPCBB_SECCFGR2_SEC13_Msk             /*!< Security configuration for block 13 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC14_Pos      (14UL)
#define GTZC_MPCBB_SECCFGR2_SEC14_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_SECCFGR2_SEC14          GTZC_MPCBB_SECCFGR2_SEC14_Msk             /*!< Security configuration for block 14 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC15_Pos      (15UL)
#define GTZC_MPCBB_SECCFGR2_SEC15_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_SECCFGR2_SEC15          GTZC_MPCBB_SECCFGR2_SEC15_Msk             /*!< Security configuration for block 15 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC16_Pos      (16UL)
#define GTZC_MPCBB_SECCFGR2_SEC16_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_SECCFGR2_SEC16          GTZC_MPCBB_SECCFGR2_SEC16_Msk             /*!< Security configuration for block 16 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC17_Pos      (17UL)
#define GTZC_MPCBB_SECCFGR2_SEC17_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_SECCFGR2_SEC17          GTZC_MPCBB_SECCFGR2_SEC17_Msk             /*!< Security configuration for block 17 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC18_Pos      (18UL)
#define GTZC_MPCBB_SECCFGR2_SEC18_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_SECCFGR2_SEC18          GTZC_MPCBB_SECCFGR2_SEC18_Msk             /*!< Security configuration for block 18 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC19_Pos      (19UL)
#define GTZC_MPCBB_SECCFGR2_SEC19_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_SECCFGR2_SEC19          GTZC_MPCBB_SECCFGR2_SEC19_Msk             /*!< Security configuration for block 19 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC20_Pos      (20UL)
#define GTZC_MPCBB_SECCFGR2_SEC20_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_SECCFGR2_SEC20          GTZC_MPCBB_SECCFGR2_SEC20_Msk             /*!< Security configuration for block 20 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC21_Pos      (21UL)
#define GTZC_MPCBB_SECCFGR2_SEC21_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_SECCFGR2_SEC21          GTZC_MPCBB_SECCFGR2_SEC21_Msk             /*!< Security configuration for block 21 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC22_Pos      (22UL)
#define GTZC_MPCBB_SECCFGR2_SEC22_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_SECCFGR2_SEC22          GTZC_MPCBB_SECCFGR2_SEC22_Msk             /*!< Security configuration for block 22 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC23_Pos      (23UL)
#define GTZC_MPCBB_SECCFGR2_SEC23_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_SECCFGR2_SEC23          GTZC_MPCBB_SECCFGR2_SEC23_Msk             /*!< Security configuration for block 23 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC24_Pos      (24UL)
#define GTZC_MPCBB_SECCFGR2_SEC24_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_SECCFGR2_SEC24          GTZC_MPCBB_SECCFGR2_SEC24_Msk             /*!< Security configuration for block 24 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC25_Pos      (25UL)
#define GTZC_MPCBB_SECCFGR2_SEC25_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_SECCFGR2_SEC25          GTZC_MPCBB_SECCFGR2_SEC25_Msk             /*!< Security configuration for block 25 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC26_Pos      (26UL)
#define GTZC_MPCBB_SECCFGR2_SEC26_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_SECCFGR2_SEC26          GTZC_MPCBB_SECCFGR2_SEC26_Msk             /*!< Security configuration for block 26 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC27_Pos      (27UL)
#define GTZC_MPCBB_SECCFGR2_SEC27_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_SECCFGR2_SEC27          GTZC_MPCBB_SECCFGR2_SEC27_Msk             /*!< Security configuration for block 27 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC28_Pos      (28UL)
#define GTZC_MPCBB_SECCFGR2_SEC28_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_SECCFGR2_SEC28          GTZC_MPCBB_SECCFGR2_SEC28_Msk             /*!< Security configuration for block 28 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC29_Pos      (29UL)
#define GTZC_MPCBB_SECCFGR2_SEC29_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_SECCFGR2_SEC29          GTZC_MPCBB_SECCFGR2_SEC29_Msk             /*!< Security configuration for block 29 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC30_Pos      (30UL)
#define GTZC_MPCBB_SECCFGR2_SEC30_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_SECCFGR2_SEC30          GTZC_MPCBB_SECCFGR2_SEC31_Msk             /*!< Security configuration for block 30 in super block 2  */
#define GTZC_MPCBB_SECCFGR2_SEC31_Pos      (31UL)
#define GTZC_MPCBB_SECCFGR2_SEC31_Msk      (0x01UL << GTZC_MPCBB_SECCFGR2_SEC31_Pos) /*!< 0x80000000 */
#define GTZC_MPCBB_SECCFGR2_SEC31          GTZC_MPCBB_SECCFGR2_SEC31_Msk             /*!< Security configuration for block 31 in super block 2  */

/*******************  Bits definition for GTZC_MPCBB_SECCFGR3 register  ************/
#define GTZC_MPCBB_SECCFGR3_SEC0_Pos       (0UL)
#define GTZC_MPCBB_SECCFGR3_SEC0_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC0_Pos)  /*!< 0x00000001 */
#define GTZC_MPCBB_SECCFGR3_SEC0           GTZC_MPCBB_SECCFGR3_SEC0_Msk              /*!< Security configuration for block 0 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC1_Pos       (1UL)
#define GTZC_MPCBB_SECCFGR3_SEC1_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC1_Pos)  /*!< 0x00000002 */
#define GTZC_MPCBB_SECCFGR3_SEC1           GTZC_MPCBB_SECCFGR3_SEC1_Msk              /*!< Security configuration for block 1 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC2_Pos       (2UL)
#define GTZC_MPCBB_SECCFGR3_SEC2_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC2_Pos)  /*!< 0x00000004 */
#define GTZC_MPCBB_SECCFGR3_SEC2           GTZC_MPCBB_SECCFGR3_SEC2_Msk              /*!< Security configuration for block 2 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC3_Pos       (3UL)
#define GTZC_MPCBB_SECCFGR3_SEC3_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC3_Pos)  /*!< 0x00000008 */
#define GTZC_MPCBB_SECCFGR3_SEC3           GTZC_MPCBB_SECCFGR3_SEC3_Msk              /*!< Security configuration for block 3 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC4_Pos       (4UL)
#define GTZC_MPCBB_SECCFGR3_SEC4_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC4_Pos)  /*!< 0x00000010 */
#define GTZC_MPCBB_SECCFGR3_SEC4           GTZC_MPCBB_SECCFGR3_SEC4_Msk              /*!< Security configuration for block 4 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC5_Pos       (5UL)
#define GTZC_MPCBB_SECCFGR3_SEC5_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC5_Pos)  /*!< 0x00000020 */
#define GTZC_MPCBB_SECCFGR3_SEC5           GTZC_MPCBB_SECCFGR3_SEC5_Msk              /*!< Security configuration for block 5 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC6_Pos       (6UL)
#define GTZC_MPCBB_SECCFGR3_SEC6_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC6_Pos)  /*!< 0x00000040 */
#define GTZC_MPCBB_SECCFGR3_SEC6           GTZC_MPCBB_SECCFGR3_SEC6_Msk              /*!< Security configuration for block 6 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC7_Pos       (7UL)
#define GTZC_MPCBB_SECCFGR3_SEC7_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC7_Pos)  /*!< 0x00000080 */
#define GTZC_MPCBB_SECCFGR3_SEC7           GTZC_MPCBB_SECCFGR3_SEC7_Msk              /*!< Security configuration for block 7 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC8_Pos       (8UL)
#define GTZC_MPCBB_SECCFGR3_SEC8_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC8_Pos)  /*!< 0x00000100 */
#define GTZC_MPCBB_SECCFGR3_SEC8           GTZC_MPCBB_SECCFGR3_SEC8_Msk              /*!< Security configuration for block 8 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC9_Pos       (9UL)
#define GTZC_MPCBB_SECCFGR3_SEC9_Msk       (0x01UL << GTZC_MPCBB_SECCFGR3_SEC9_Pos)  /*!< 0x00000200 */
#define GTZC_MPCBB_SECCFGR3_SEC9           GTZC_MPCBB_SECCFGR3_SEC9_Msk              /*!< Security configuration for block 9 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC10_Pos      (10UL)
#define GTZC_MPCBB_SECCFGR3_SEC10_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_SECCFGR3_SEC10          GTZC_MPCBB_SECCFGR3_SEC10_Msk             /*!< Security configuration for block 10 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC11_Pos      (11UL)
#define GTZC_MPCBB_SECCFGR3_SEC11_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_SECCFGR3_SEC11          GTZC_MPCBB_SECCFGR3_SEC11_Msk             /*!< Security configuration for block 11 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC12_Pos      (12UL)
#define GTZC_MPCBB_SECCFGR3_SEC12_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_SECCFGR3_SEC12          GTZC_MPCBB_SECCFGR3_SEC12_Msk             /*!< Security configuration for block 12 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC13_Pos      (13UL)
#define GTZC_MPCBB_SECCFGR3_SEC13_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_SECCFGR3_SEC13          GTZC_MPCBB_SECCFGR3_SEC13_Msk             /*!< Security configuration for block 13 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC14_Pos      (14UL)
#define GTZC_MPCBB_SECCFGR3_SEC14_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_SECCFGR3_SEC14          GTZC_MPCBB_SECCFGR3_SEC14_Msk             /*!< Security configuration for block 14 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC15_Pos      (15UL)
#define GTZC_MPCBB_SECCFGR3_SEC15_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_SECCFGR3_SEC15          GTZC_MPCBB_SECCFGR3_SEC15_Msk             /*!< Security configuration for block 15 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC16_Pos      (16UL)
#define GTZC_MPCBB_SECCFGR3_SEC16_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_SECCFGR3_SEC16          GTZC_MPCBB_SECCFGR3_SEC16_Msk             /*!< Security configuration for block 16 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC17_Pos      (17UL)
#define GTZC_MPCBB_SECCFGR3_SEC17_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_SECCFGR3_SEC17          GTZC_MPCBB_SECCFGR3_SEC17_Msk             /*!< Security configuration for block 17 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC18_Pos      (18UL)
#define GTZC_MPCBB_SECCFGR3_SEC18_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_SECCFGR3_SEC18          GTZC_MPCBB_SECCFGR3_SEC18_Msk             /*!< Security configuration for block 18 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC19_Pos      (19UL)
#define GTZC_MPCBB_SECCFGR3_SEC19_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_SECCFGR3_SEC19          GTZC_MPCBB_SECCFGR3_SEC19_Msk             /*!< Security configuration for block 19 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC20_Pos      (20UL)
#define GTZC_MPCBB_SECCFGR3_SEC20_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_SECCFGR3_SEC20          GTZC_MPCBB_SECCFGR3_SEC20_Msk             /*!< Security configuration for block 20 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC21_Pos      (21UL)
#define GTZC_MPCBB_SECCFGR3_SEC21_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_SECCFGR3_SEC21          GTZC_MPCBB_SECCFGR3_SEC21_Msk             /*!< Security configuration for block 21 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC22_Pos      (22UL)
#define GTZC_MPCBB_SECCFGR3_SEC22_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_SECCFGR3_SEC22          GTZC_MPCBB_SECCFGR3_SEC22_Msk             /*!< Security configuration for block 22 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC23_Pos      (23UL)
#define GTZC_MPCBB_SECCFGR3_SEC23_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_SECCFGR3_SEC23          GTZC_MPCBB_SECCFGR3_SEC23_Msk             /*!< Security configuration for block 23 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC24_Pos      (24UL)
#define GTZC_MPCBB_SECCFGR3_SEC24_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_SECCFGR3_SEC24          GTZC_MPCBB_SECCFGR3_SEC24_Msk             /*!< Security configuration for block 24 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC25_Pos      (25UL)
#define GTZC_MPCBB_SECCFGR3_SEC25_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_SECCFGR3_SEC25          GTZC_MPCBB_SECCFGR3_SEC25_Msk             /*!< Security configuration for block 25 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC26_Pos      (26UL)
#define GTZC_MPCBB_SECCFGR3_SEC26_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_SECCFGR3_SEC26          GTZC_MPCBB_SECCFGR3_SEC26_Msk             /*!< Security configuration for block 26 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC27_Pos      (27UL)
#define GTZC_MPCBB_SECCFGR3_SEC27_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_SECCFGR3_SEC27          GTZC_MPCBB_SECCFGR3_SEC27_Msk             /*!< Security configuration for block 27 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC28_Pos      (28UL)
#define GTZC_MPCBB_SECCFGR3_SEC28_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_SECCFGR3_SEC28          GTZC_MPCBB_SECCFGR3_SEC28_Msk             /*!< Security configuration for block 28 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC29_Pos      (29UL)
#define GTZC_MPCBB_SECCFGR3_SEC29_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_SECCFGR3_SEC29          GTZC_MPCBB_SECCFGR3_SEC29_Msk             /*!< Security configuration for block 29 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC30_Pos      (30UL)
#define GTZC_MPCBB_SECCFGR3_SEC30_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_SECCFGR3_SEC30          GTZC_MPCBB_SECCFGR3_SEC31_Msk             /*!< Security configuration for block 30 in super block 3  */
#define GTZC_MPCBB_SECCFGR3_SEC31_Pos      (31UL)
#define GTZC_MPCBB_SECCFGR3_SEC31_Msk      (0x01UL << GTZC_MPCBB_SECCFGR3_SEC31_Pos) /*!< 0x80000000 */
#define GTZC_MPCBB_SECCFGR3_SEC31          GTZC_MPCBB_SECCFGR3_SEC31_Msk             /*!< Security configuration for block 31 in super block 3  */

/*******************  Bits definition for GTZC_MPCBB_PRIVCFGR0 register ************/
#define GTZC_MPCBB_PRIVCFGR0_PRIV0_Pos       (0UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV0_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV0_Pos)  /*!< 0x00000001 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV0           GTZC_MPCBB_PRIVCFGR0_PRIV0_Msk              /*!< Privileged configuration for block 0 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV1_Pos       (1UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV1_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV1_Pos)  /*!< 0x00000002 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV1           GTZC_MPCBB_PRIVCFGR0_PRIV1_Msk              /*!< Privileged configuration for block 1 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV2_Pos       (2UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV2_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV2_Pos)  /*!< 0x00000004 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV2           GTZC_MPCBB_PRIVCFGR0_PRIV2_Msk              /*!< Privileged configuration for block 2 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV3_Pos       (3UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV3_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV3_Pos)  /*!< 0x00000008 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV3           GTZC_MPCBB_PRIVCFGR0_PRIV3_Msk              /*!< Privileged configuration for block 3 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV4_Pos       (4UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV4_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV4_Pos)  /*!< 0x00000010 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV4           GTZC_MPCBB_PRIVCFGR0_PRIV4_Msk              /*!< Privileged configuration for block 4 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV5_Pos       (5UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV5_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV5_Pos)  /*!< 0x00000020 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV5           GTZC_MPCBB_PRIVCFGR0_PRIV5_Msk              /*!< Privileged configuration for block 5 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV6_Pos       (6UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV6_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV6_Pos)  /*!< 0x00000040 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV6           GTZC_MPCBB_PRIVCFGR0_PRIV6_Msk              /*!< Privileged configuration for block 6 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV7_Pos       (7UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV7_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV7_Pos)  /*!< 0x00000080 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV7           GTZC_MPCBB_PRIVCFGR0_PRIV7_Msk              /*!< Privileged configuration for block 7 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV8_Pos       (8UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV8_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV8_Pos)  /*!< 0x00000100 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV8           GTZC_MPCBB_PRIVCFGR0_PRIV8_Msk              /*!< Privileged configuration for block 8 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV9_Pos       (9UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV9_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV9_Pos)  /*!< 0x00000200 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV9           GTZC_MPCBB_PRIVCFGR0_PRIV9_Msk              /*!< Privileged configuration for block 9 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV10_Pos      (10UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV10_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV10          GTZC_MPCBB_PRIVCFGR0_PRIV10_Msk             /*!< Privileged configuration for block 10 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV11_Pos      (11UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV11_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV11          GTZC_MPCBB_PRIVCFGR0_PRIV11_Msk             /*!< Privileged configuration for block 11 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV12_Pos      (12UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV12_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV12          GTZC_MPCBB_PRIVCFGR0_PRIV12_Msk             /*!< Privileged configuration for block 12 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV13_Pos      (13UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV13_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV13          GTZC_MPCBB_PRIVCFGR0_PRIV13_Msk             /*!< Privileged configuration for block 13 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV14_Pos      (14UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV14_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV14          GTZC_MPCBB_PRIVCFGR0_PRIV14_Msk             /*!< Privileged configuration for block 14 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV15_Pos      (15UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV15_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV15          GTZC_MPCBB_PRIVCFGR0_PRIV15_Msk             /*!< Privileged configuration for block 15 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV16_Pos      (16UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV16_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV16          GTZC_MPCBB_PRIVCFGR0_PRIV16_Msk             /*!< Privileged configuration for block 16 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV17_Pos      (17UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV17_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV17          GTZC_MPCBB_PRIVCFGR0_PRIV17_Msk             /*!< Privileged configuration for block 17 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV18_Pos      (18UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV18_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV18          GTZC_MPCBB_PRIVCFGR0_PRIV18_Msk             /*!< Privileged configuration for block 18 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV19_Pos      (19UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV19_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV19          GTZC_MPCBB_PRIVCFGR0_PRIV19_Msk             /*!< Privileged configuration for block 19 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV20_Pos      (20UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV20_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV20          GTZC_MPCBB_PRIVCFGR0_PRIV20_Msk             /*!< Privileged configuration for block 20 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV21_Pos      (21UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV21_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV21          GTZC_MPCBB_PRIVCFGR0_PRIV21_Msk             /*!< Privileged configuration for block 21 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV22_Pos      (22UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV22_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV22          GTZC_MPCBB_PRIVCFGR0_PRIV22_Msk             /*!< Privileged configuration for block 22 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV23_Pos      (23UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV23_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV23          GTZC_MPCBB_PRIVCFGR0_PRIV23_Msk             /*!< Privileged configuration for block 23 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV24_Pos      (24UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV24_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV24          GTZC_MPCBB_PRIVCFGR0_PRIV24_Msk             /*!< Privileged configuration for block 24 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV25_Pos      (25UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV25_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV25          GTZC_MPCBB_PRIVCFGR0_PRIV25_Msk             /*!< Privileged configuration for block 25 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV26_Pos      (26UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV26_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV26          GTZC_MPCBB_PRIVCFGR0_PRIV26_Msk             /*!< Privileged configuration for block 26 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV27_Pos      (27UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV27_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV27          GTZC_MPCBB_PRIVCFGR0_PRIV27_Msk             /*!< Privileged configuration for block 27 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV28_Pos      (28UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV28_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV28          GTZC_MPCBB_PRIVCFGR0_PRIV28_Msk             /*!< Privileged configuration for block 28 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV29_Pos      (29UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV29_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV29          GTZC_MPCBB_PRIVCFGR0_PRIV29_Msk             /*!< Privileged configuration for block 29 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV30_Pos      (30UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV30_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV30          GTZC_MPCBB_PRIVCFGR0_PRIV31_Msk             /*!< Privileged configuration for block 30 in super block 0  */
#define GTZC_MPCBB_PRIVCFGR0_PRIV31_Pos      (31UL)
#define GTZC_MPCBB_PRIVCFGR0_PRIV31_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR0_PRIV31_Pos) /*!< 0x80000000 */
#define GTZC_MPCBB_PRIVCFGR0_PRIV31          GTZC_MPCBB_PRIVCFGR0_PRIV31_Msk             /*!< Privileged configuration for block 31 in super block 0  */

/*******************  Bits definition for GTZC_MPCBB_PRIVCFGR1 register ************/
#define GTZC_MPCBB_PRIVCFGR1_PRIV0_Pos       (0UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV0_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV0_Pos)  /*!< 0x00000001 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV0           GTZC_MPCBB_PRIVCFGR1_PRIV0_Msk              /*!< Privileged configuration for block 0 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV1_Pos       (1UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV1_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV1_Pos)  /*!< 0x00000002 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV1           GTZC_MPCBB_PRIVCFGR1_PRIV1_Msk              /*!< Privileged configuration for block 1 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV2_Pos       (2UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV2_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV2_Pos)  /*!< 0x00000004 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV2           GTZC_MPCBB_PRIVCFGR1_PRIV2_Msk              /*!< Privileged configuration for block 2 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV3_Pos       (3UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV3_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV3_Pos)  /*!< 0x00000008 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV3           GTZC_MPCBB_PRIVCFGR1_PRIV3_Msk              /*!< Privileged configuration for block 3 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV4_Pos       (4UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV4_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV4_Pos)  /*!< 0x00000010 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV4           GTZC_MPCBB_PRIVCFGR1_PRIV4_Msk              /*!< Privileged configuration for block 4 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV5_Pos       (5UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV5_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV5_Pos)  /*!< 0x00000020 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV5           GTZC_MPCBB_PRIVCFGR1_PRIV5_Msk              /*!< Privileged configuration for block 5 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV6_Pos       (6UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV6_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV6_Pos)  /*!< 0x00000040 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV6           GTZC_MPCBB_PRIVCFGR1_PRIV6_Msk              /*!< Privileged configuration for block 6 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV7_Pos       (7UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV7_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV7_Pos)  /*!< 0x00000080 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV7           GTZC_MPCBB_PRIVCFGR1_PRIV7_Msk              /*!< Privileged configuration for block 7 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV8_Pos       (8UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV8_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV8_Pos)  /*!< 0x00000100 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV8           GTZC_MPCBB_PRIVCFGR1_PRIV8_Msk              /*!< Privileged configuration for block 8 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV9_Pos       (9UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV9_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV9_Pos)  /*!< 0x00000200 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV9           GTZC_MPCBB_PRIVCFGR1_PRIV9_Msk              /*!< Privileged configuration for block 9 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV10_Pos      (10UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV10_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV10          GTZC_MPCBB_PRIVCFGR1_PRIV10_Msk             /*!< Privileged configuration for block 10 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV11_Pos      (11UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV11_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV11          GTZC_MPCBB_PRIVCFGR1_PRIV11_Msk             /*!< Privileged configuration for block 11 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV12_Pos      (12UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV12_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV12          GTZC_MPCBB_PRIVCFGR1_PRIV12_Msk             /*!< Privileged configuration for block 12 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV13_Pos      (13UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV13_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV13          GTZC_MPCBB_PRIVCFGR1_PRIV13_Msk             /*!< Privileged configuration for block 13 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV14_Pos      (14UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV14_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV14          GTZC_MPCBB_PRIVCFGR1_PRIV14_Msk             /*!< Privileged configuration for block 14 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV15_Pos      (15UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV15_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV15          GTZC_MPCBB_PRIVCFGR1_PRIV15_Msk             /*!< Privileged configuration for block 15 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV16_Pos      (16UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV16_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV16          GTZC_MPCBB_PRIVCFGR1_PRIV16_Msk             /*!< Privileged configuration for block 16 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV17_Pos      (17UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV17_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV17          GTZC_MPCBB_PRIVCFGR1_PRIV17_Msk             /*!< Privileged configuration for block 17 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV18_Pos      (18UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV18_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV18          GTZC_MPCBB_PRIVCFGR1_PRIV18_Msk             /*!< Privileged configuration for block 18 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV19_Pos      (19UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV19_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV19          GTZC_MPCBB_PRIVCFGR1_PRIV19_Msk             /*!< Privileged configuration for block 19 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV20_Pos      (20UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV20_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV20          GTZC_MPCBB_PRIVCFGR1_PRIV20_Msk             /*!< Privileged configuration for block 20 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV21_Pos      (21UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV21_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV21          GTZC_MPCBB_PRIVCFGR1_PRIV21_Msk             /*!< Privileged configuration for block 21 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV22_Pos      (22UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV22_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV22          GTZC_MPCBB_PRIVCFGR1_PRIV22_Msk             /*!< Privileged configuration for block 22 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV23_Pos      (23UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV23_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV23          GTZC_MPCBB_PRIVCFGR1_PRIV23_Msk             /*!< Privileged configuration for block 23 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV24_Pos      (24UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV24_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV24          GTZC_MPCBB_PRIVCFGR1_PRIV24_Msk             /*!< Privileged configuration for block 24 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV25_Pos      (25UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV25_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV25          GTZC_MPCBB_PRIVCFGR1_PRIV25_Msk             /*!< Privileged configuration for block 25 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV26_Pos      (26UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV26_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV26          GTZC_MPCBB_PRIVCFGR1_PRIV26_Msk             /*!< Privileged configuration for block 26 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV27_Pos      (27UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV27_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV27          GTZC_MPCBB_PRIVCFGR1_PRIV27_Msk             /*!< Privileged configuration for block 27 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV28_Pos      (28UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV28_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV28          GTZC_MPCBB_PRIVCFGR1_PRIV28_Msk             /*!< Privileged configuration for block 28 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV29_Pos      (29UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV29_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV29          GTZC_MPCBB_PRIVCFGR1_PRIV29_Msk             /*!< Privileged configuration for block 29 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV30_Pos      (30UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV30_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV30          GTZC_MPCBB_PRIVCFGR1_PRIV31_Msk             /*!< Privileged configuration for block 30 in super block 1  */
#define GTZC_MPCBB_PRIVCFGR1_PRIV31_Pos      (31UL)
#define GTZC_MPCBB_PRIVCFGR1_PRIV31_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR1_PRIV31_Pos) /*!< 0x80000000 */
#define GTZC_MPCBB_PRIVCFGR1_PRIV31          GTZC_MPCBB_PRIVCFGR1_PRIV31_Msk             /*!< Privileged configuration for block 31 in super block 1  */

/*******************  Bits definition for GTZC_MPCBB_PRIVCFGR2 register ************/
#define GTZC_MPCBB_PRIVCFGR2_PRIV0_Pos       (0UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV0_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV0_Pos)  /*!< 0x00000001 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV0           GTZC_MPCBB_PRIVCFGR2_PRIV0_Msk              /*!< Privileged configuration for block 0 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV1_Pos       (1UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV1_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV1_Pos)  /*!< 0x00000002 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV1           GTZC_MPCBB_PRIVCFGR2_PRIV1_Msk              /*!< Privileged configuration for block 1 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV2_Pos       (2UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV2_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV2_Pos)  /*!< 0x00000004 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV2           GTZC_MPCBB_PRIVCFGR2_PRIV2_Msk              /*!< Privileged configuration for block 2 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV3_Pos       (3UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV3_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV3_Pos)  /*!< 0x00000008 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV3           GTZC_MPCBB_PRIVCFGR2_PRIV3_Msk              /*!< Privileged configuration for block 3 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV4_Pos       (4UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV4_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV4_Pos)  /*!< 0x00000010 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV4           GTZC_MPCBB_PRIVCFGR2_PRIV4_Msk              /*!< Privileged configuration for block 4 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV5_Pos       (5UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV5_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV5_Pos)  /*!< 0x00000020 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV5           GTZC_MPCBB_PRIVCFGR2_PRIV5_Msk              /*!< Privileged configuration for block 5 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV6_Pos       (6UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV6_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV6_Pos)  /*!< 0x00000040 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV6           GTZC_MPCBB_PRIVCFGR2_PRIV6_Msk              /*!< Privileged configuration for block 6 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV7_Pos       (7UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV7_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV7_Pos)  /*!< 0x00000080 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV7           GTZC_MPCBB_PRIVCFGR2_PRIV7_Msk              /*!< Privileged configuration for block 7 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV8_Pos       (8UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV8_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV8_Pos)  /*!< 0x00000100 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV8           GTZC_MPCBB_PRIVCFGR2_PRIV8_Msk              /*!< Privileged configuration for block 8 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV9_Pos       (9UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV9_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV9_Pos)  /*!< 0x00000200 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV9           GTZC_MPCBB_PRIVCFGR2_PRIV9_Msk              /*!< Privileged configuration for block 9 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV10_Pos      (10UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV10_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV10          GTZC_MPCBB_PRIVCFGR2_PRIV10_Msk             /*!< Privileged configuration for block 10 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV11_Pos      (11UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV11_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV11          GTZC_MPCBB_PRIVCFGR2_PRIV11_Msk             /*!< Privileged configuration for block 11 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV12_Pos      (12UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV12_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV12          GTZC_MPCBB_PRIVCFGR2_PRIV12_Msk             /*!< Privileged configuration for block 12 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV13_Pos      (13UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV13_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV13          GTZC_MPCBB_PRIVCFGR2_PRIV13_Msk             /*!< Privileged configuration for block 13 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV14_Pos      (14UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV14_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV14          GTZC_MPCBB_PRIVCFGR2_PRIV14_Msk             /*!< Privileged configuration for block 14 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV15_Pos      (15UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV15_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV15          GTZC_MPCBB_PRIVCFGR2_PRIV15_Msk             /*!< Privileged configuration for block 15 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV16_Pos      (16UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV16_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV16          GTZC_MPCBB_PRIVCFGR2_PRIV16_Msk             /*!< Privileged configuration for block 16 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV17_Pos      (17UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV17_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV17          GTZC_MPCBB_PRIVCFGR2_PRIV17_Msk             /*!< Privileged configuration for block 17 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV18_Pos      (18UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV18_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV18          GTZC_MPCBB_PRIVCFGR2_PRIV18_Msk             /*!< Privileged configuration for block 18 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV19_Pos      (19UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV19_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV19          GTZC_MPCBB_PRIVCFGR2_PRIV19_Msk             /*!< Privileged configuration for block 19 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV20_Pos      (20UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV20_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV20          GTZC_MPCBB_PRIVCFGR2_PRIV20_Msk             /*!< Privileged configuration for block 20 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV21_Pos      (21UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV21_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV21          GTZC_MPCBB_PRIVCFGR2_PRIV21_Msk             /*!< Privileged configuration for block 21 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV22_Pos      (22UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV22_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV22          GTZC_MPCBB_PRIVCFGR2_PRIV22_Msk             /*!< Privileged configuration for block 22 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV23_Pos      (23UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV23_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV23          GTZC_MPCBB_PRIVCFGR2_PRIV23_Msk             /*!< Privileged configuration for block 23 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV24_Pos      (24UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV24_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV24          GTZC_MPCBB_PRIVCFGR2_PRIV24_Msk             /*!< Privileged configuration for block 24 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV25_Pos      (25UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV25_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV25          GTZC_MPCBB_PRIVCFGR2_PRIV25_Msk             /*!< Privileged configuration for block 25 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV26_Pos      (26UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV26_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV26          GTZC_MPCBB_PRIVCFGR2_PRIV26_Msk             /*!< Privileged configuration for block 26 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV27_Pos      (27UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV27_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV27          GTZC_MPCBB_PRIVCFGR2_PRIV27_Msk             /*!< Privileged configuration for block 27 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV28_Pos      (28UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV28_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV28          GTZC_MPCBB_PRIVCFGR2_PRIV28_Msk             /*!< Privileged configuration for block 28 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV29_Pos      (29UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV29_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV29          GTZC_MPCBB_PRIVCFGR2_PRIV29_Msk             /*!< Privileged configuration for block 29 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV30_Pos      (30UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV30_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV30          GTZC_MPCBB_PRIVCFGR2_PRIV31_Msk             /*!< Privileged configuration for block 30 in super block 2  */
#define GTZC_MPCBB_PRIVCFGR2_PRIV31_Pos      (31UL)
#define GTZC_MPCBB_PRIVCFGR2_PRIV31_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR2_PRIV31_Pos) /*!< 0x80000000 */
#define GTZC_MPCBB_PRIVCFGR2_PRIV31          GTZC_MPCBB_PRIVCFGR2_PRIV31_Msk             /*!< Privileged configuration for block 31 in super block 2  */

/*******************  Bits definition for GTZC_MPCBB_PRIVCFGR3 register ************/
#define GTZC_MPCBB_PRIVCFGR3_PRIV0_Pos       (0UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV0_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV0_Pos)  /*!< 0x00000001 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV0           GTZC_MPCBB_PRIVCFGR3_PRIV0_Msk              /*!< Privileged configuration for block 0 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV1_Pos       (1UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV1_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV1_Pos)  /*!< 0x00000002 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV1           GTZC_MPCBB_PRIVCFGR3_PRIV1_Msk              /*!< Privileged configuration for block 1 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV2_Pos       (2UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV2_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV2_Pos)  /*!< 0x00000004 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV2           GTZC_MPCBB_PRIVCFGR3_PRIV2_Msk              /*!< Privileged configuration for block 2 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV3_Pos       (3UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV3_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV3_Pos)  /*!< 0x00000008 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV3           GTZC_MPCBB_PRIVCFGR3_PRIV3_Msk              /*!< Privileged configuration for block 3 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV4_Pos       (4UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV4_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV4_Pos)  /*!< 0x00000010 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV4           GTZC_MPCBB_PRIVCFGR3_PRIV4_Msk              /*!< Privileged configuration for block 4 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV5_Pos       (5UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV5_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV5_Pos)  /*!< 0x00000020 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV5           GTZC_MPCBB_PRIVCFGR3_PRIV5_Msk              /*!< Privileged configuration for block 5 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV6_Pos       (6UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV6_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV6_Pos)  /*!< 0x00000040 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV6           GTZC_MPCBB_PRIVCFGR3_PRIV6_Msk              /*!< Privileged configuration for block 6 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV7_Pos       (7UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV7_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV7_Pos)  /*!< 0x00000080 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV7           GTZC_MPCBB_PRIVCFGR3_PRIV7_Msk              /*!< Privileged configuration for block 7 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV8_Pos       (8UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV8_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV8_Pos)  /*!< 0x00000100 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV8           GTZC_MPCBB_PRIVCFGR3_PRIV8_Msk              /*!< Privileged configuration for block 8 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV9_Pos       (9UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV9_Msk       (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV9_Pos)  /*!< 0x00000200 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV9           GTZC_MPCBB_PRIVCFGR3_PRIV9_Msk              /*!< Privileged configuration for block 9 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV10_Pos      (10UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV10_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV10          GTZC_MPCBB_PRIVCFGR3_PRIV10_Msk             /*!< Privileged configuration for block 10 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV11_Pos      (11UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV11_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV11          GTZC_MPCBB_PRIVCFGR3_PRIV11_Msk             /*!< Privileged configuration for block 11 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV12_Pos      (12UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV12_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV12          GTZC_MPCBB_PRIVCFGR3_PRIV12_Msk             /*!< Privileged configuration for block 12 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV13_Pos      (13UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV13_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV13          GTZC_MPCBB_PRIVCFGR3_PRIV13_Msk             /*!< Privileged configuration for block 13 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV14_Pos      (14UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV14_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV14          GTZC_MPCBB_PRIVCFGR3_PRIV14_Msk             /*!< Privileged configuration for block 14 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV15_Pos      (15UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV15_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV15          GTZC_MPCBB_PRIVCFGR3_PRIV15_Msk             /*!< Privileged configuration for block 15 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV16_Pos      (16UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV16_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV16          GTZC_MPCBB_PRIVCFGR3_PRIV16_Msk             /*!< Privileged configuration for block 16 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV17_Pos      (17UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV17_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV17          GTZC_MPCBB_PRIVCFGR3_PRIV17_Msk             /*!< Privileged configuration for block 17 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV18_Pos      (18UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV18_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV18          GTZC_MPCBB_PRIVCFGR3_PRIV18_Msk             /*!< Privileged configuration for block 18 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV19_Pos      (19UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV19_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV19          GTZC_MPCBB_PRIVCFGR3_PRIV19_Msk             /*!< Privileged configuration for block 19 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV20_Pos      (20UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV20_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV20          GTZC_MPCBB_PRIVCFGR3_PRIV20_Msk             /*!< Privileged configuration for block 20 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV21_Pos      (21UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV21_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV21          GTZC_MPCBB_PRIVCFGR3_PRIV21_Msk             /*!< Privileged configuration for block 21 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV22_Pos      (22UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV22_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV22          GTZC_MPCBB_PRIVCFGR3_PRIV22_Msk             /*!< Privileged configuration for block 22 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV23_Pos      (23UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV23_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV23          GTZC_MPCBB_PRIVCFGR3_PRIV23_Msk             /*!< Privileged configuration for block 23 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV24_Pos      (24UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV24_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV24          GTZC_MPCBB_PRIVCFGR3_PRIV24_Msk             /*!< Privileged configuration for block 24 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV25_Pos      (25UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV25_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV25          GTZC_MPCBB_PRIVCFGR3_PRIV25_Msk             /*!< Privileged configuration for block 25 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV26_Pos      (26UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV26_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV26          GTZC_MPCBB_PRIVCFGR3_PRIV26_Msk             /*!< Privileged configuration for block 26 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV27_Pos      (27UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV27_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV27          GTZC_MPCBB_PRIVCFGR3_PRIV27_Msk             /*!< Privileged configuration for block 27 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV28_Pos      (28UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV28_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV28          GTZC_MPCBB_PRIVCFGR3_PRIV28_Msk             /*!< Privileged configuration for block 28 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV29_Pos      (29UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV29_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV29          GTZC_MPCBB_PRIVCFGR3_PRIV29_Msk             /*!< Privileged configuration for block 29 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV30_Pos      (30UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV30_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV30          GTZC_MPCBB_PRIVCFGR3_PRIV31_Msk             /*!< Privileged configuration for block 30 in super block 3  */
#define GTZC_MPCBB_PRIVCFGR3_PRIV31_Pos      (31UL)
#define GTZC_MPCBB_PRIVCFGR3_PRIV31_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR3_PRIV31_Pos) /*!< 0x80000000 */
#define GTZC_MPCBB_PRIVCFGR3_PRIV31          GTZC_MPCBB_PRIVCFGR3_PRIV31_Msk             /*!< Privileged configuration for block 31 in super block 3  */


/******************************************************************************/
/*                                                                            */
/*                                    HASH                                    */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for HASH_CR register  ********************/
#define HASH_CR_INIT_Pos                    (2UL)
#define HASH_CR_INIT_Msk                    (0x1UL << HASH_CR_INIT_Pos)             /*!< 0x00000004 */
#define HASH_CR_INIT                        HASH_CR_INIT_Msk
#define HASH_CR_DMAE_Pos                    (3UL)
#define HASH_CR_DMAE_Msk                    (0x1UL << HASH_CR_DMAE_Pos)             /*!< 0x00000008 */
#define HASH_CR_DMAE                        HASH_CR_DMAE_Msk
#define HASH_CR_DATATYPE_Pos                (4UL)
#define HASH_CR_DATATYPE_Msk                (0x3UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000030 */
#define HASH_CR_DATATYPE                    HASH_CR_DATATYPE_Msk
#define HASH_CR_DATATYPE_0                  (0x1UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000010 */
#define HASH_CR_DATATYPE_1                  (0x2UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000020 */
#define HASH_CR_MODE_Pos                    (6UL)
#define HASH_CR_MODE_Msk                    (0x1UL << HASH_CR_MODE_Pos)             /*!< 0x00000040 */
#define HASH_CR_MODE                        HASH_CR_MODE_Msk
#define HASH_CR_NBW_Pos                     (8UL)
#define HASH_CR_NBW_Msk                     (0xFUL << HASH_CR_NBW_Pos)              /*!< 0x00000F00 */
#define HASH_CR_NBW                         HASH_CR_NBW_Msk
#define HASH_CR_NBW_0                       (0x1UL << HASH_CR_NBW_Pos)              /*!< 0x00000100 */
#define HASH_CR_NBW_1                       (0x2UL << HASH_CR_NBW_Pos)              /*!< 0x00000200 */
#define HASH_CR_NBW_2                       (0x4UL << HASH_CR_NBW_Pos)              /*!< 0x00000400 */
#define HASH_CR_NBW_3                       (0x8UL << HASH_CR_NBW_Pos)              /*!< 0x00000800 */
#define HASH_CR_DINNE_Pos                   (12UL)
#define HASH_CR_DINNE_Msk                   (0x1UL << HASH_CR_DINNE_Pos)            /*!< 0x00001000 */
#define HASH_CR_DINNE                       HASH_CR_DINNE_Msk
#define HASH_CR_MDMAT_Pos                   (13UL)
#define HASH_CR_MDMAT_Msk                   (0x1UL << HASH_CR_MDMAT_Pos)            /*!< 0x00002000 */
#define HASH_CR_MDMAT                       HASH_CR_MDMAT_Msk
#define HASH_CR_LKEY_Pos                    (16UL)
#define HASH_CR_LKEY_Msk                    (0x1UL << HASH_CR_LKEY_Pos)             /*!< 0x00010000 */
#define HASH_CR_LKEY                        HASH_CR_LKEY_Msk
#define HASH_CR_ALGO_Pos                    (17UL)
#define HASH_CR_ALGO_Msk                    (0x3UL << HASH_CR_ALGO_Pos)             /*!< 0x00040080 */
#define HASH_CR_ALGO                        HASH_CR_ALGO_Msk
#define HASH_CR_ALGO_0                      (0x1UL << HASH_CR_ALGO_Pos)             /*!< 0x00000080 */
#define HASH_CR_ALGO_1                      (0x2UL << HASH_CR_ALGO_Pos)             /*!< 0x00040000 */

/******************  Bits definition for HASH_STR register  *******************/
#define HASH_STR_NBLW_Pos                   (0UL)
#define HASH_STR_NBLW_Msk                   (0x1FUL << HASH_STR_NBLW_Pos)           /*!< 0x0000001F */
#define HASH_STR_NBLW                       HASH_STR_NBLW_Msk
#define HASH_STR_NBLW_0                     (0x01UL << HASH_STR_NBLW_Pos)           /*!< 0x00000001 */
#define HASH_STR_NBLW_1                     (0x02UL << HASH_STR_NBLW_Pos)           /*!< 0x00000002 */
#define HASH_STR_NBLW_2                     (0x04UL << HASH_STR_NBLW_Pos)           /*!< 0x00000004 */
#define HASH_STR_NBLW_3                     (0x08UL << HASH_STR_NBLW_Pos)           /*!< 0x00000008 */
#define HASH_STR_NBLW_4                     (0x10UL << HASH_STR_NBLW_Pos)           /*!< 0x00000010 */
#define HASH_STR_DCAL_Pos                   (8UL)
#define HASH_STR_DCAL_Msk                   (0x1UL << HASH_STR_DCAL_Pos)            /*!< 0x00000100 */
#define HASH_STR_DCAL                       HASH_STR_DCAL_Msk

/******************  Bits definition for HASH_IMR register  *******************/
#define HASH_IMR_DINIE_Pos                  (0UL)
#define HASH_IMR_DINIE_Msk                  (0x1UL << HASH_IMR_DINIE_Pos)           /*!< 0x00000001 */
#define HASH_IMR_DINIE                      HASH_IMR_DINIE_Msk
#define HASH_IMR_DCIE_Pos                   (1UL)
#define HASH_IMR_DCIE_Msk                   (0x1UL << HASH_IMR_DCIE_Pos)            /*!< 0x00000002 */
#define HASH_IMR_DCIE                       HASH_IMR_DCIE_Msk

/******************  Bits definition for HASH_SR register  ********************/
#define HASH_SR_DINIS_Pos                   (0UL)
#define HASH_SR_DINIS_Msk                   (0x1UL << HASH_SR_DINIS_Pos)            /*!< 0x00000001 */
#define HASH_SR_DINIS                       HASH_SR_DINIS_Msk
#define HASH_SR_DCIS_Pos                    (1UL)
#define HASH_SR_DCIS_Msk                    (0x1UL << HASH_SR_DCIS_Pos)             /*!< 0x00000002 */
#define HASH_SR_DCIS                        HASH_SR_DCIS_Msk
#define HASH_SR_DMAS_Pos                    (2UL)
#define HASH_SR_DMAS_Msk                    (0x1UL << HASH_SR_DMAS_Pos)             /*!< 0x00000004 */
#define HASH_SR_DMAS                        HASH_SR_DMAS_Msk
#define HASH_SR_BUSY_Pos                    (3UL)
#define HASH_SR_BUSY_Msk                    (0x1UL << HASH_SR_BUSY_Pos)             /*!< 0x00000008 */
#define HASH_SR_BUSY                        HASH_SR_BUSY_Msk
#define HASH_SR_NBWE_Pos                    (16UL)
#define HASH_SR_NBWE_Msk                    (0xFUL << HASH_SR_NBWE_Pos)             /*!< 0x000F0000 */
#define HASH_SR_NBWE                        HASH_SR_NBWE_Msk
#define HASH_SR_NBWE_0                      (0x01UL << HASH_SR_NBWE_Pos)            /*!< 0x00010000 */
#define HASH_SR_NBWE_1                      (0x02UL << HASH_SR_NBWE_Pos)            /*!< 0x00020000 */
#define HASH_SR_NBWE_2                      (0x04UL << HASH_SR_NBWE_Pos)            /*!< 0x00040000 */
#define HASH_SR_NBWE_3                      (0x08UL << HASH_SR_NBWE_Pos)            /*!< 0x00080000 */
#define HASH_SR_DINNE_Pos                   (15UL)
#define HASH_SR_DINNE_Msk                   (0x1UL << HASH_SR_DINNE_Pos)            /*!< 0x00008000 */
#define HASH_SR_DINNE                       HASH_SR_DINNE_Msk
#define HASH_SR_NBWP_Pos                    (9UL)
#define HASH_SR_NBWP_Msk                    (0xFUL << HASH_SR_NBWP_Pos)             /*!< 0x000F0000 */
#define HASH_SR_NBWP                        HASH_SR_NBWP_Msk
#define HASH_SR_NBWP_0                      (0x01UL << HASH_SR_NBWP_Pos)            /*!< 0x000O0200 */
#define HASH_SR_NBWP_1                      (0x02UL << HASH_SR_NBWP_Pos)            /*!< 0x00000400 */
#define HASH_SR_NBWP_2                      (0x04UL << HASH_SR_NBWP_Pos)            /*!< 0x00000800 */
#define HASH_SR_NBWP_3                      (0x08UL << HASH_SR_NBWP_Pos)            /*!< 0x00001000 */


/******************************************************************************/
/*                                                                            */
/*                        HSEM HW Semaphore                                   */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for HSEM_R register  ********************/
#define HSEM_R_PROCID_Pos        (0UL)
#define HSEM_R_PROCID_Msk        (0xFFUL << HSEM_R_PROCID_Pos)                 /*!< 0x000000FF */
#define HSEM_R_PROCID            HSEM_R_PROCID_Msk                             /*!<Semaphore ProcessID */
#define HSEM_R_LOCKID_Pos        (8UL)
#define HSEM_R_LOCKID_Msk        (0xFUL << HSEM_R_LOCKID_Pos)                  /*!< 0x00000F00 */
#define HSEM_R_LOCKID            HSEM_R_LOCKID_Msk                             /*!<Semaphore LockID. */
#define HSEM_R_SEC_Pos           (12UL)
#define HSEM_R_SEC_Msk           (0x1UL << HSEM_R_SEC_Pos)                     /*!< 0x00001000 */
#define HSEM_R_SEC               HSEM_R_SEC_Msk                                /*!<Semaphore secure bit. */
#define HSEM_R_PRIV_Pos          (13UL)
#define HSEM_R_PRIV_Msk          (0x1UL << HSEM_R_PRIV_Pos)                     /*!< 0x00002000 */
#define HSEM_R_PRIV              HSEM_R_PRIV_Msk                                /*!<Semaphore privilege bit. */
#define HSEM_R_LOCK_Pos          (31UL)
#define HSEM_R_LOCK_Msk          (0x1UL << HSEM_R_LOCK_Pos)                    /*!< 0x80000000 */
#define HSEM_R_LOCK              HSEM_R_LOCK_Msk                               /*!<Lock indication. */

/********************  Bit definition for HSEM_RLR register  ******************/
#define HSEM_RLR_PROCID_Pos      (0UL)
#define HSEM_RLR_PROCID_Msk      (0xFFUL << HSEM_RLR_PROCID_Pos)               /*!< 0x000000FF */
#define HSEM_RLR_PROCID          HSEM_RLR_PROCID_Msk                           /*!<Semaphore ProcessID */
#define HSEM_RLR_LOCKID_Pos      (8UL)
#define HSEM_RLR_LOCKID_Msk      (0xFUL << HSEM_RLR_COREID_Pos)                /*!< 0x00000F00 */
#define HSEM_RLR_LOCKID          HSEM_RLR_COREID_Msk                           /*!<Semaphore CoreID. */
#define HSEM_RLR_SEC_Pos         (12UL)
#define HSEM_RLR_SEC_Msk         (0x1UL << HSEM_RLR_SEC_Pos)                   /*!< 0x00001000 */
#define HSEM_RLR_SEC             HSEM_RLR_SEC_Msk                              /*!<Semaphore secure bit. */
#define HSEM_RLR_PRIV_Pos        (13UL)
#define HSEM_RLR_PRIV_Msk        (0x1UL << HSEM_RLR_PRIV_Pos)                   /*!< 0x00002000 */
#define HSEM_RLR_PRIV            HSEM_RLR_PRIV_Msk                              /*!<Semaphore privilege bit. */
#define HSEM_RLR_LOCK_Pos        (31UL)
#define HSEM_RLR_LOCK_Msk        (0x1UL << HSEM_RLR_LOCK_Pos)                  /*!< 0x80000000 */
#define HSEM_RLR_LOCK            HSEM_RLR_LOCK_Msk                             /*!<Lock indication. */

/********************  Bit definition for HSEM_IER register  ****************/
#define HSEM_IER_ISE0_Pos      (0UL)
#define HSEM_IER_ISE0_Msk      (0x1UL << HSEM_IER_ISE0_Pos)                /*!< 0x00000001 */
#define HSEM_IER_ISE0          HSEM_IER_ISE0_Msk                           /*!<semaphore 0 interrupt enable bit.  */
#define HSEM_IER_ISE1_Pos      (1UL)
#define HSEM_IER_ISE1_Msk      (0x1UL << HSEM_IER_ISE1_Pos)                /*!< 0x00000002 */
#define HSEM_IER_ISE1          HSEM_IER_ISE1_Msk                           /*!<semaphore 1 interrupt enable bit.  */
#define HSEM_IER_ISE2_Pos      (2UL)
#define HSEM_IER_ISE2_Msk      (0x1UL << HSEM_IER_ISE2_Pos)                /*!< 0x00000004 */
#define HSEM_IER_ISE2          HSEM_IER_ISE2_Msk                           /*!<semaphore 2 interrupt enable bit.  */
#define HSEM_IER_ISE3_Pos      (3UL)
#define HSEM_IER_ISE3_Msk      (0x1UL << HSEM_IER_ISE3_Pos)                /*!< 0x00000008 */
#define HSEM_IER_ISE3          HSEM_IER_ISE3_Msk                           /*!<semaphore 3 interrupt enable bit.  */
#define HSEM_IER_ISE4_Pos      (4UL)
#define HSEM_IER_ISE4_Msk      (0x1UL << HSEM_IER_ISE4_Pos)                /*!< 0x00000010 */
#define HSEM_IER_ISE4          HSEM_IER_ISE4_Msk                           /*!<semaphore 4 interrupt enable bit.  */
#define HSEM_IER_ISE5_Pos      (5UL)
#define HSEM_IER_ISE5_Msk      (0x1UL << HSEM_IER_ISE5_Pos)                /*!< 0x00000020 */
#define HSEM_IER_ISE5          HSEM_IER_ISE5_Msk                           /*!<semaphore 5 interrupt enable bit.  */
#define HSEM_IER_ISE6_Pos      (6UL)
#define HSEM_IER_ISE6_Msk      (0x1UL << HSEM_IER_ISE6_Pos)                /*!< 0x00000040 */
#define HSEM_IER_ISE6          HSEM_IER_ISE6_Msk                           /*!<semaphore 6 interrupt enable bit.  */
#define HSEM_IER_ISE7_Pos      (7UL)
#define HSEM_IER_ISE7_Msk      (0x1UL << HSEM_IER_ISE7_Pos)                /*!< 0x00000080 */
#define HSEM_IER_ISE7          HSEM_IER_ISE7_Msk                           /*!<semaphore 7 interrupt enable bit.  */
#define HSEM_IER_ISE8_Pos      (8UL)
#define HSEM_IER_ISE8_Msk      (0x1UL << HSEM_IER_ISE8_Pos)                /*!< 0x00000100 */
#define HSEM_IER_ISE8          HSEM_IER_ISE8_Msk                           /*!<semaphore 8 interrupt enable bit.  */
#define HSEM_IER_ISE9_Pos      (9UL)
#define HSEM_IER_ISE9_Msk      (0x1UL << HSEM_IER_ISE9_Pos)                /*!< 0x00000200 */
#define HSEM_IER_ISE9          HSEM_IER_ISE9_Msk                           /*!<semaphore 9 interrupt enable bit.  */
#define HSEM_IER_ISE10_Pos     (10UL)
#define HSEM_IER_ISE10_Msk     (0x1UL << HSEM_IER_ISE10_Pos)               /*!< 0x00000400 */
#define HSEM_IER_ISE10         HSEM_IER_ISE10_Msk                          /*!<semaphore 10 interrupt enable bit. */
#define HSEM_IER_ISE11_Pos     (11UL)
#define HSEM_IER_ISE11_Msk     (0x1UL << HSEM_IER_ISE11_Pos)               /*!< 0x00000800 */
#define HSEM_IER_ISE11         HSEM_IER_ISE11_Msk                          /*!<semaphore 11 interrupt enable bit. */
#define HSEM_IER_ISE12_Pos     (12UL)
#define HSEM_IER_ISE12_Msk     (0x1UL << HSEM_IER_ISE12_Pos)               /*!< 0x00001000 */
#define HSEM_IER_ISE12         HSEM_IER_ISE12_Msk                          /*!<semaphore 12 interrupt enable bit. */
#define HSEM_IER_ISE13_Pos     (13UL)
#define HSEM_IER_ISE13_Msk     (0x1UL << HSEM_IER_ISE13_Pos)               /*!< 0x00002000 */
#define HSEM_IER_ISE13         HSEM_IER_ISE13_Msk                          /*!<semaphore 13 interrupt enable bit. */
#define HSEM_IER_ISE14_Pos     (14UL)
#define HSEM_IER_ISE14_Msk     (0x1UL << HSEM_IER_ISE14_Pos)               /*!< 0x00004000 */
#define HSEM_IER_ISE14         HSEM_IER_ISE14_Msk                          /*!<semaphore 14 interrupt enable bit. */
#define HSEM_IER_ISE15_Pos     (15UL)
#define HSEM_IER_ISE15_Msk     (0x1UL << HSEM_IER_ISE15_Pos)               /*!< 0x00008000 */
#define HSEM_IER_ISE15         HSEM_IER_ISE15_Msk                          /*!<semaphore 15 interrupt enable bit. */

/********************  Bit definition for HSEM_ICR register  *****************/
#define HSEM_ICR_ISC0_Pos      (0UL)
#define HSEM_ICR_ISC0_Msk      (0x1UL << HSEM_ICR_ISC0_Pos)                /*!< 0x00000001 */
#define HSEM_ICR_ISC0          HSEM_ICR_ISC0_Msk                           /*!<semaphore 0 interrupt clear bit.  */
#define HSEM_ICR_ISC1_Pos      (1UL)
#define HSEM_ICR_ISC1_Msk      (0x1UL << HSEM_ICR_ISC1_Pos)                /*!< 0x00000002 */
#define HSEM_ICR_ISC1          HSEM_ICR_ISC1_Msk                           /*!<semaphore 1 interrupt clear bit.  */
#define HSEM_ICR_ISC2_Pos      (2UL)
#define HSEM_ICR_ISC2_Msk      (0x1UL << HSEM_ICR_ISC2_Pos)                /*!< 0x00000004 */
#define HSEM_ICR_ISC2          HSEM_ICR_ISC2_Msk                           /*!<semaphore 2 interrupt clear bit.  */
#define HSEM_ICR_ISC3_Pos      (3UL)
#define HSEM_ICR_ISC3_Msk      (0x1UL << HSEM_ICR_ISC3_Pos)                /*!< 0x00000008 */
#define HSEM_ICR_ISC3          HSEM_ICR_ISC3_Msk                           /*!<semaphore 3 interrupt clear bit.  */
#define HSEM_ICR_ISC4_Pos      (4UL)
#define HSEM_ICR_ISC4_Msk      (0x1UL << HSEM_ICR_ISC4_Pos)                /*!< 0x00000010 */
#define HSEM_ICR_ISC4          HSEM_ICR_ISC4_Msk                           /*!<semaphore 4 interrupt clear bit.  */
#define HSEM_ICR_ISC5_Pos      (5UL)
#define HSEM_ICR_ISC5_Msk      (0x1UL << HSEM_ICR_ISC5_Pos)                /*!< 0x00000020 */
#define HSEM_ICR_ISC5          HSEM_ICR_ISC5_Msk                           /*!<semaphore 5 interrupt clear bit.  */
#define HSEM_ICR_ISC6_Pos      (6UL)
#define HSEM_ICR_ISC6_Msk      (0x1UL << HSEM_ICR_ISC6_Pos)                /*!< 0x00000040 */
#define HSEM_ICR_ISC6          HSEM_ICR_ISC6_Msk                           /*!<semaphore 6 interrupt clear bit.  */
#define HSEM_ICR_ISC7_Pos      (7UL)
#define HSEM_ICR_ISC7_Msk      (0x1UL << HSEM_ICR_ISC7_Pos)                /*!< 0x00000080 */
#define HSEM_ICR_ISC7          HSEM_ICR_ISC7_Msk                           /*!<semaphore 7 interrupt clear bit.  */
#define HSEM_ICR_ISC8_Pos      (8UL)
#define HSEM_ICR_ISC8_Msk      (0x1UL << HSEM_ICR_ISC8_Pos)                /*!< 0x00000100 */
#define HSEM_ICR_ISC8          HSEM_ICR_ISC8_Msk                           /*!<semaphore 8 interrupt clear bit.  */
#define HSEM_ICR_ISC9_Pos      (9UL)
#define HSEM_ICR_ISC9_Msk      (0x1UL << HSEM_ICR_ISC9_Pos)                /*!< 0x00000200 */
#define HSEM_ICR_ISC9          HSEM_ICR_ISC9_Msk                           /*!<semaphore 9 interrupt clear bit.  */
#define HSEM_ICR_ISC10_Pos     (10UL)
#define HSEM_ICR_ISC10_Msk     (0x1UL << HSEM_ICR_ISC10_Pos)               /*!< 0x00000400 */
#define HSEM_ICR_ISC10         HSEM_ICR_ISC10_Msk                          /*!<semaphore 10 interrupt clear bit. */
#define HSEM_ICR_ISC11_Pos     (11UL)
#define HSEM_ICR_ISC11_Msk     (0x1UL << HSEM_ICR_ISC11_Pos)               /*!< 0x00000800 */
#define HSEM_ICR_ISC11         HSEM_ICR_ISC11_Msk                          /*!<semaphore 11 interrupt clear bit. */
#define HSEM_ICR_ISC12_Pos     (12UL)
#define HSEM_ICR_ISC12_Msk     (0x1UL << HSEM_ICR_ISC12_Pos)               /*!< 0x00001000 */
#define HSEM_ICR_ISC12         HSEM_ICR_ISC12_Msk                          /*!<semaphore 12 interrupt clear bit. */
#define HSEM_ICR_ISC13_Pos     (13UL)
#define HSEM_ICR_ISC13_Msk     (0x1UL << HSEM_ICR_ISC13_Pos)               /*!< 0x00002000 */
#define HSEM_ICR_ISC13         HSEM_ICR_ISC13_Msk                          /*!<semaphore 13 interrupt clear bit. */
#define HSEM_ICR_ISC14_Pos     (14UL)
#define HSEM_ICR_ISC14_Msk     (0x1UL << HSEM_ICR_ISC14_Pos)               /*!< 0x00004000 */
#define HSEM_ICR_ISC14         HSEM_ICR_ISC14_Msk                          /*!<semaphore 14 interrupt clear bit. */
#define HSEM_ICR_ISC15_Pos     (15UL)
#define HSEM_ICR_ISC15_Msk     (0x1UL << HSEM_ICR_ISC15_Pos)               /*!< 0x00008000 */
#define HSEM_ICR_ISC15         HSEM_ICR_ISC15_Msk                          /*!<semaphore 15 interrupt clear bit. */

/********************  Bit definition for HSEM_ISR register  *****************/
#define HSEM_ISR_ISF0_Pos      (0UL)
#define HSEM_ISR_ISF0_Msk      (0x1UL << HSEM_ISR_ISF0_Pos)                /*!< 0x00000001 */
#define HSEM_ISR_ISF0          HSEM_ISR_ISF0_Msk                           /*!<semaphore 0 interrupt status bit.  */
#define HSEM_ISR_ISF1_Pos      (1UL)
#define HSEM_ISR_ISF1_Msk      (0x1UL << HSEM_ISR_ISF1_Pos)                /*!< 0x00000002 */
#define HSEM_ISR_ISF1          HSEM_ISR_ISF1_Msk                           /*!<semaphore 1 interrupt status bit.  */
#define HSEM_ISR_ISF2_Pos      (2UL)
#define HSEM_ISR_ISF2_Msk      (0x1UL << HSEM_ISR_ISF2_Pos)                /*!< 0x00000004 */
#define HSEM_ISR_ISF2          HSEM_ISR_ISF2_Msk                           /*!<semaphore 2 interrupt status bit.  */
#define HSEM_ISR_ISF3_Pos      (3UL)
#define HSEM_ISR_ISF3_Msk      (0x1UL << HSEM_ISR_ISF3_Pos)                /*!< 0x00000008 */
#define HSEM_ISR_ISF3          HSEM_ISR_ISF3_Msk                           /*!<semaphore 3 interrupt status bit.  */
#define HSEM_ISR_ISF4_Pos      (4UL)
#define HSEM_ISR_ISF4_Msk      (0x1UL << HSEM_ISR_ISF4_Pos)                /*!< 0x00000010 */
#define HSEM_ISR_ISF4          HSEM_ISR_ISF4_Msk                           /*!<semaphore 4 interrupt status bit.  */
#define HSEM_ISR_ISF5_Pos      (5UL)
#define HSEM_ISR_ISF5_Msk      (0x1UL << HSEM_ISR_ISF5_Pos)                /*!< 0x00000020 */
#define HSEM_ISR_ISF5          HSEM_ISR_ISF5_Msk                           /*!<semaphore 5 interrupt status bit.  */
#define HSEM_ISR_ISF6_Pos      (6UL)
#define HSEM_ISR_ISF6_Msk      (0x1UL << HSEM_ISR_ISF6_Pos)                /*!< 0x00000040 */
#define HSEM_ISR_ISF6          HSEM_ISR_ISF6_Msk                           /*!<semaphore 6 interrupt status bit.  */
#define HSEM_ISR_ISF7_Pos      (7UL)
#define HSEM_ISR_ISF7_Msk      (0x1UL << HSEM_ISR_ISF7_Pos)                /*!< 0x00000080 */
#define HSEM_ISR_ISF7          HSEM_ISR_ISF7_Msk                           /*!<semaphore 7 interrupt status bit.  */
#define HSEM_ISR_ISF8_Pos      (8UL)
#define HSEM_ISR_ISF8_Msk      (0x1UL << HSEM_ISR_ISF8_Pos)                /*!< 0x00000100 */
#define HSEM_ISR_ISF8          HSEM_ISR_ISF8_Msk                           /*!<semaphore 8 interrupt status bit.  */
#define HSEM_ISR_ISF9_Pos      (9UL)
#define HSEM_ISR_ISF9_Msk      (0x1UL << HSEM_ISR_ISF9_Pos)                /*!< 0x00000200 */
#define HSEM_ISR_ISF9          HSEM_ISR_ISF9_Msk                           /*!<semaphore 9 interrupt status bit.  */
#define HSEM_ISR_ISF10_Pos     (10UL)
#define HSEM_ISR_ISF10_Msk     (0x1UL << HSEM_ISR_ISF10_Pos)               /*!< 0x00000400 */
#define HSEM_ISR_ISF10         HSEM_ISR_ISF10_Msk                          /*!<semaphore 10 interrupt status bit. */
#define HSEM_ISR_ISF11_Pos     (11UL)
#define HSEM_ISR_ISF11_Msk     (0x1UL << HSEM_ISR_ISF11_Pos)               /*!< 0x00000800 */
#define HSEM_ISR_ISF11         HSEM_ISR_ISF11_Msk                          /*!<semaphore 11 interrupt status bit. */
#define HSEM_ISR_ISF12_Pos     (12UL)
#define HSEM_ISR_ISF12_Msk     (0x1UL << HSEM_ISR_ISF12_Pos)               /*!< 0x00001000 */
#define HSEM_ISR_ISF12         HSEM_ISR_ISF12_Msk                          /*!<semaphore 12 interrupt status bit. */
#define HSEM_ISR_ISF13_Pos     (13UL)
#define HSEM_ISR_ISF13_Msk     (0x1UL << HSEM_ISR_ISF13_Pos)               /*!< 0x00002000 */
#define HSEM_ISR_ISF13         HSEM_ISR_ISF13_Msk                          /*!<semaphore 13 interrupt status bit. */
#define HSEM_ISR_ISF14_Pos     (14UL)
#define HSEM_ISR_ISF14_Msk     (0x1UL << HSEM_ISR_ISF14_Pos)               /*!< 0x00004000 */
#define HSEM_ISR_ISF14         HSEM_ISR_ISF14_Msk                          /*!<semaphore 14 interrupt status bit. */
#define HSEM_ISR_ISF15_Pos     (15UL)
#define HSEM_ISR_ISF15_Msk     (0x1UL << HSEM_ISR_ISF15_Pos)               /*!< 0x00008000 */
#define HSEM_ISR_ISF15         HSEM_ISR_ISF15_Msk                          /*!<semaphore 15 interrupt status bit. */

/********************  Bit definition for HSEM_MISR register  *****************/
#define HSEM_MISR_MISF0_Pos     (0UL)
#define HSEM_MISR_MISF0_Msk     (0x1UL << HSEM_MISR_MISF0_Pos)               /*!< 0x00000001 */
#define HSEM_MISR_MISF0         HSEM_MISR_MISF0_Msk                          /*!<semaphore 0 interrupt masked status bit.  */
#define HSEM_MISR_MISF1_Pos     (1UL)
#define HSEM_MISR_MISF1_Msk     (0x1UL << HSEM_MISR_MISF1_Pos)               /*!< 0x00000002 */
#define HSEM_MISR_MISF1         HSEM_MISR_MISF1_Msk                          /*!<semaphore 1 interrupt masked status bit.  */
#define HSEM_MISR_MISF2_Pos     (2UL)
#define HSEM_MISR_MISF2_Msk     (0x1UL << HSEM_MISR_MISF2_Pos)               /*!< 0x00000004 */
#define HSEM_MISR_MISF2         HSEM_MISR_MISF2_Msk                          /*!<semaphore 2 interrupt masked status bit.  */
#define HSEM_MISR_MISF3_Pos     (3UL)
#define HSEM_MISR_MISF3_Msk     (0x1UL << HSEM_MISR_MISF3_Pos)               /*!< 0x00000008 */
#define HSEM_MISR_MISF3         HSEM_MISR_MISF3_Msk                          /*!<semaphore 3 interrupt masked status bit.  */
#define HSEM_MISR_MISF4_Pos     (4UL)
#define HSEM_MISR_MISF4_Msk     (0x1UL << HSEM_MISR_MISF4_Pos)               /*!< 0x00000010 */
#define HSEM_MISR_MISF4         HSEM_MISR_MISF4_Msk                          /*!<semaphore 4 interrupt masked status bit.  */
#define HSEM_MISR_MISF5_Pos     (5UL)
#define HSEM_MISR_MISF5_Msk     (0x1UL << HSEM_MISR_MISF5_Pos)               /*!< 0x00000020 */
#define HSEM_MISR_MISF5         HSEM_MISR_MISF5_Msk                          /*!<semaphore 5 interrupt masked status bit.  */
#define HSEM_MISR_MISF6_Pos     (6UL)
#define HSEM_MISR_MISF6_Msk     (0x1UL << HSEM_MISR_MISF6_Pos)               /*!< 0x00000040 */
#define HSEM_MISR_MISF6         HSEM_MISR_MISF6_Msk                          /*!<semaphore 6 interrupt masked status bit.  */
#define HSEM_MISR_MISF7_Pos     (7UL)
#define HSEM_MISR_MISF7_Msk     (0x1UL << HSEM_MISR_MISF7_Pos)               /*!< 0x00000080 */
#define HSEM_MISR_MISF7         HSEM_MISR_MISF7_Msk                          /*!<semaphore 7 interrupt masked status bit.  */
#define HSEM_MISR_MISF8_Pos     (8UL)
#define HSEM_MISR_MISF8_Msk     (0x1UL << HSEM_MISR_MISF8_Pos)               /*!< 0x00000100 */
#define HSEM_MISR_MISF8         HSEM_MISR_MISF8_Msk                          /*!<semaphore 8 interrupt masked status bit.  */
#define HSEM_MISR_MISF9_Pos     (9UL)
#define HSEM_MISR_MISF9_Msk     (0x1UL << HSEM_MISR_MISF9_Pos)               /*!< 0x00000200 */
#define HSEM_MISR_MISF9         HSEM_MISR_MISF9_Msk                          /*!<semaphore 9 interrupt masked status bit.  */
#define HSEM_MISR_MISF10_Pos    (10UL)
#define HSEM_MISR_MISF10_Msk    (0x1UL << HSEM_MISR_MISF10_Pos)              /*!< 0x00000400 */
#define HSEM_MISR_MISF10        HSEM_MISR_MISF10_Msk                         /*!<semaphore 10 interrupt masked status bit. */
#define HSEM_MISR_MISF11_Pos    (11UL)
#define HSEM_MISR_MISF11_Msk    (0x1UL << HSEM_MISR_MISF11_Pos)              /*!< 0x00000800 */
#define HSEM_MISR_MISF11        HSEM_MISR_MISF11_Msk                         /*!<semaphore 11 interrupt masked status bit. */
#define HSEM_MISR_MISF12_Pos    (12UL)
#define HSEM_MISR_MISF12_Msk    (0x1UL << HSEM_MISR_MISF12_Pos)              /*!< 0x00001000 */
#define HSEM_MISR_MISF12        HSEM_MISR_MISF12_Msk                         /*!<semaphore 12 interrupt masked status bit. */
#define HSEM_MISR_MISF13_Pos    (13UL)
#define HSEM_MISR_MISF13_Msk    (0x1UL << HSEM_MISR_MISF13_Pos)              /*!< 0x00002000 */
#define HSEM_MISR_MISF13        HSEM_MISR_MISF13_Msk                         /*!<semaphore 13 interrupt masked status bit. */
#define HSEM_MISR_MISF14_Pos    (14UL)
#define HSEM_MISR_MISF14_Msk    (0x1UL << HSEM_MISR_MISF14_Pos)              /*!< 0x00004000 */
#define HSEM_MISR_MISF14        HSEM_MISR_MISF14_Msk                         /*!<semaphore 14 interrupt masked status bit. */
#define HSEM_MISR_MISF15_Pos    (15UL)
#define HSEM_MISR_MISF15_Msk    (0x1UL << HSEM_MISR_MISF15_Pos)              /*!< 0x00008000 */
#define HSEM_MISR_MISF15        HSEM_MISR_MISF15_Msk                         /*!<semaphore 15 interrupt masked status bit. */

/********************  Bit definition for HSEM_SIER register  ****************/
#define HSEM_SIER_ISE0_Pos      (0UL)
#define HSEM_SIER_ISE0_Msk      (0x1UL << HSEM_SIER_ISE0_Pos)                /*!< 0x00000001 */
#define HSEM_SIER_ISE0          HSEM_SIER_ISE0_Msk                           /*!<semaphore 0 secure interrupt enable bit.  */
#define HSEM_SIER_ISE1_Pos      (1UL)
#define HSEM_SIER_ISE1_Msk      (0x1UL << HSEM_SIER_ISE1_Pos)                /*!< 0x00000002 */
#define HSEM_SIER_ISE1          HSEM_SIER_ISE1_Msk                           /*!<semaphore 1 secure interrupt enable bit.  */
#define HSEM_SIER_ISE2_Pos      (2UL)
#define HSEM_SIER_ISE2_Msk      (0x1UL << HSEM_SIER_ISE2_Pos)                /*!< 0x00000004 */
#define HSEM_SIER_ISE2          HSEM_SIER_ISE2_Msk                           /*!<semaphore 2 secure interrupt enable bit.  */
#define HSEM_SIER_ISE3_Pos      (3UL)
#define HSEM_SIER_ISE3_Msk      (0x1UL << HSEM_SIER_ISE3_Pos)                /*!< 0x00000008 */
#define HSEM_SIER_ISE3          HSEM_SIER_ISE3_Msk                           /*!<semaphore 3 secure interrupt enable bit.  */
#define HSEM_SIER_ISE4_Pos      (4UL)
#define HSEM_SIER_ISE4_Msk      (0x1UL << HSEM_SIER_ISE4_Pos)                /*!< 0x00000010 */
#define HSEM_SIER_ISE4          HSEM_SIER_ISE4_Msk                           /*!<semaphore 4 secure interrupt enable bit.  */
#define HSEM_SIER_ISE5_Pos      (5UL)
#define HSEM_SIER_ISE5_Msk      (0x1UL << HSEM_SIER_ISE5_Pos)                /*!< 0x00000020 */
#define HSEM_SIER_ISE5          HSEM_SIER_ISE5_Msk                           /*!<semaphore 5 secure interrupt enable bit.  */
#define HSEM_SIER_ISE6_Pos      (6UL)
#define HSEM_SIER_ISE6_Msk      (0x1UL << HSEM_SIER_ISE6_Pos)                /*!< 0x00000040 */
#define HSEM_SIER_ISE6          HSEM_SIER_ISE6_Msk                           /*!<semaphore 6 secure interrupt enable bit.  */
#define HSEM_SIER_ISE7_Pos      (7UL)
#define HSEM_SIER_ISE7_Msk      (0x1UL << HSEM_SIER_ISE7_Pos)                /*!< 0x00000080 */
#define HSEM_SIER_ISE7          HSEM_SIER_ISE7_Msk                           /*!<semaphore 7 secure interrupt enable bit.  */
#define HSEM_SIER_ISE8_Pos      (8UL)
#define HSEM_SIER_ISE8_Msk      (0x1UL << HSEM_SIER_ISE8_Pos)                /*!< 0x00000100 */
#define HSEM_SIER_ISE8          HSEM_SIER_ISE8_Msk                           /*!<semaphore 8 secure interrupt enable bit.  */
#define HSEM_SIER_ISE9_Pos      (9UL)
#define HSEM_SIER_ISE9_Msk      (0x1UL << HSEM_SIER_ISE9_Pos)                /*!< 0x00000200 */
#define HSEM_SIER_ISE9          HSEM_SIER_ISE9_Msk                           /*!<semaphore 9 secure interrupt enable bit.  */
#define HSEM_SIER_ISE10_Pos     (10UL)
#define HSEM_SIER_ISE10_Msk     (0x1UL << HSEM_SIER_ISE10_Pos)               /*!< 0x00000400 */
#define HSEM_SIER_ISE10         HSEM_SIER_ISE10_Msk                          /*!<semaphore 10 secure interrupt enable bit. */
#define HSEM_SIER_ISE11_Pos     (11UL)
#define HSEM_SIER_ISE11_Msk     (0x1UL << HSEM_SIER_ISE11_Pos)               /*!< 0x00000800 */
#define HSEM_SIER_ISE11         HSEM_SIER_ISE11_Msk                          /*!<semaphore 11 secure interrupt enable bit. */
#define HSEM_SIER_ISE12_Pos     (12UL)
#define HSEM_SIER_ISE12_Msk     (0x1UL << HSEM_SIER_ISE12_Pos)               /*!< 0x00001000 */
#define HSEM_SIER_ISE12         HSEM_SIER_ISE12_Msk                          /*!<semaphore 12 secure interrupt enable bit. */
#define HSEM_SIER_ISE13_Pos     (13UL)
#define HSEM_SIER_ISE13_Msk     (0x1UL << HSEM_SIER_ISE13_Pos)               /*!< 0x00002000 */
#define HSEM_SIER_ISE13         HSEM_SIER_ISE13_Msk                          /*!<semaphore 13 secure interrupt enable bit. */
#define HSEM_SIER_ISE14_Pos     (14UL)
#define HSEM_SIER_ISE14_Msk     (0x1UL << HSEM_SIER_ISE14_Pos)               /*!< 0x00004000 */
#define HSEM_SIER_ISE14         HSEM_SIER_ISE14_Msk                          /*!<semaphore 14 secure interrupt enable bit. */
#define HSEM_SIER_ISE15_Pos     (15UL)
#define HSEM_SIER_ISE15_Msk     (0x1UL << HSEM_SIER_ISE15_Pos)               /*!< 0x00008000 */
#define HSEM_SIER_ISE15         HSEM_SIER_ISE15_Msk                          /*!<semaphore 15 secure interrupt enable bit. */

/********************  Bit definition for HSEM_SICR register  *****************/
#define HSEM_SICR_ISC0_Pos      (0UL)
#define HSEM_SICR_ISC0_Msk      (0x1UL << HSEM_SICR_ISC0_Pos)                /*!< 0x00000001 */
#define HSEM_SICR_ISC0          HSEM_SICR_ISC0_Msk                           /*!<semaphore 0 secure interrupt clear bit.  */
#define HSEM_SICR_ISC1_Pos      (1UL)
#define HSEM_SICR_ISC1_Msk      (0x1UL << HSEM_SICR_ISC1_Pos)                /*!< 0x00000002 */
#define HSEM_SICR_ISC1          HSEM_SICR_ISC1_Msk                           /*!<semaphore 1 secure interrupt clear bit.  */
#define HSEM_SICR_ISC2_Pos      (2UL)
#define HSEM_SICR_ISC2_Msk      (0x1UL << HSEM_SICR_ISC2_Pos)                /*!< 0x00000004 */
#define HSEM_SICR_ISC2          HSEM_SICR_ISC2_Msk                           /*!<semaphore 2 secure interrupt clear bit.  */
#define HSEM_SICR_ISC3_Pos      (3UL)
#define HSEM_SICR_ISC3_Msk      (0x1UL << HSEM_SICR_ISC3_Pos)                /*!< 0x00000008 */
#define HSEM_SICR_ISC3          HSEM_SICR_ISC3_Msk                           /*!<semaphore 3 secure interrupt clear bit.  */
#define HSEM_SICR_ISC4_Pos      (4UL)
#define HSEM_SICR_ISC4_Msk      (0x1UL << HSEM_SICR_ISC4_Pos)                /*!< 0x00000010 */
#define HSEM_SICR_ISC4          HSEM_SICR_ISC4_Msk                           /*!<semaphore 4 secure interrupt clear bit.  */
#define HSEM_SICR_ISC5_Pos      (5UL)
#define HSEM_SICR_ISC5_Msk      (0x1UL << HSEM_SICR_ISC5_Pos)                /*!< 0x00000020 */
#define HSEM_SICR_ISC5          HSEM_SICR_ISC5_Msk                           /*!<semaphore 5 secure interrupt clear bit.  */
#define HSEM_SICR_ISC6_Pos      (6UL)
#define HSEM_SICR_ISC6_Msk      (0x1UL << HSEM_SICR_ISC6_Pos)                /*!< 0x00000040 */
#define HSEM_SICR_ISC6          HSEM_SICR_ISC6_Msk                           /*!<semaphore 6 secure interrupt clear bit.  */
#define HSEM_SICR_ISC7_Pos      (7UL)
#define HSEM_SICR_ISC7_Msk      (0x1UL << HSEM_SICR_ISC7_Pos)                /*!< 0x00000080 */
#define HSEM_SICR_ISC7          HSEM_SICR_ISC7_Msk                           /*!<semaphore 7 secure interrupt clear bit.  */
#define HSEM_SICR_ISC8_Pos      (8UL)
#define HSEM_SICR_ISC8_Msk      (0x1UL << HSEM_SICR_ISC8_Pos)                /*!< 0x00000100 */
#define HSEM_SICR_ISC8          HSEM_SICR_ISC8_Msk                           /*!<semaphore 8 secure interrupt clear bit.  */
#define HSEM_SICR_ISC9_Pos      (9UL)
#define HSEM_SICR_ISC9_Msk      (0x1UL << HSEM_SICR_ISC9_Pos)                /*!< 0x00000200 */
#define HSEM_SICR_ISC9          HSEM_SICR_ISC9_Msk                           /*!<semaphore 9 secure interrupt clear bit.  */
#define HSEM_SICR_ISC10_Pos     (10UL)
#define HSEM_SICR_ISC10_Msk     (0x1UL << HSEM_SICR_ISC10_Pos)               /*!< 0x00000400 */
#define HSEM_SICR_ISC10         HSEM_SICR_ISC10_Msk                          /*!<semaphore 10 secure interrupt clear bit. */
#define HSEM_SICR_ISC11_Pos     (11UL)
#define HSEM_SICR_ISC11_Msk     (0x1UL << HSEM_SICR_ISC11_Pos)               /*!< 0x00000800 */
#define HSEM_SICR_ISC11         HSEM_SICR_ISC11_Msk                          /*!<semaphore 11 secure interrupt clear bit. */
#define HSEM_SICR_ISC12_Pos     (12UL)
#define HSEM_SICR_ISC12_Msk     (0x1UL << HSEM_SICR_ISC12_Pos)               /*!< 0x00001000 */
#define HSEM_SICR_ISC12         HSEM_SICR_ISC12_Msk                          /*!<semaphore 12 secure interrupt clear bit. */
#define HSEM_SICR_ISC13_Pos     (13UL)
#define HSEM_SICR_ISC13_Msk     (0x1UL << HSEM_SICR_ISC13_Pos)               /*!< 0x00002000 */
#define HSEM_SICR_ISC13         HSEM_SICR_ISC13_Msk                          /*!<semaphore 13 secure interrupt clear bit. */
#define HSEM_SICR_ISC14_Pos     (14UL)
#define HSEM_SICR_ISC14_Msk     (0x1UL << HSEM_SICR_ISC14_Pos)               /*!< 0x00004000 */
#define HSEM_SICR_ISC14         HSEM_SICR_ISC14_Msk                          /*!<semaphore 14 secure interrupt clear bit. */
#define HSEM_SICR_ISC15_Pos     (15UL)
#define HSEM_SICR_ISC15_Msk     (0x1UL << HSEM_SICR_ISC15_Pos)               /*!< 0x00008000 */
#define HSEM_SICR_ISC15         HSEM_SICR_ISC15_Msk                          /*!<semaphore 15 secure interrupt clear bit. */

/********************  Bit definition for HSEM_SISR register  *****************/
#define HSEM_SISR_ISF0_Pos      (0UL)
#define HSEM_SISR_ISF0_Msk      (0x1UL << HSEM_SISR_ISF0_Pos)                /*!< 0x00000001 */
#define HSEM_SISR_ISF0          HSEM_SISR_ISF0_Msk                           /*!<semaphore 0 secure interrupt status bit.  */
#define HSEM_SISR_ISF1_Pos      (1UL)
#define HSEM_SISR_ISF1_Msk      (0x1UL << HSEM_SISR_ISF1_Pos)                /*!< 0x00000002 */
#define HSEM_SISR_ISF1          HSEM_SISR_ISF1_Msk                           /*!<semaphore 1 secure interrupt status bit.  */
#define HSEM_SISR_ISF2_Pos      (2UL)
#define HSEM_SISR_ISF2_Msk      (0x1UL << HSEM_SISR_ISF2_Pos)                /*!< 0x00000004 */
#define HSEM_SISR_ISF2          HSEM_SISR_ISF2_Msk                           /*!<semaphore 2 secure interrupt status bit.  */
#define HSEM_SISR_ISF3_Pos      (3UL)
#define HSEM_SISR_ISF3_Msk      (0x1UL << HSEM_SISR_ISF3_Pos)                /*!< 0x00000008 */
#define HSEM_SISR_ISF3          HSEM_SISR_ISF3_Msk                           /*!<semaphore 3 secure interrupt status bit.  */
#define HSEM_SISR_ISF4_Pos      (4UL)
#define HSEM_SISR_ISF4_Msk      (0x1UL << HSEM_SISR_ISF4_Pos)                /*!< 0x00000010 */
#define HSEM_SISR_ISF4          HSEM_SISR_ISF4_Msk                           /*!<semaphore 4 secure interrupt status bit.  */
#define HSEM_SISR_ISF5_Pos      (5UL)
#define HSEM_SISR_ISF5_Msk      (0x1UL << HSEM_SISR_ISF5_Pos)                /*!< 0x00000020 */
#define HSEM_SISR_ISF5          HSEM_SISR_ISF5_Msk                           /*!<semaphore 5 secure interrupt status bit.  */
#define HSEM_SISR_ISF6_Pos      (6UL)
#define HSEM_SISR_ISF6_Msk      (0x1UL << HSEM_SISR_ISF6_Pos)                /*!< 0x00000040 */
#define HSEM_SISR_ISF6          HSEM_SISR_ISF6_Msk                           /*!<semaphore 6 secure interrupt status bit.  */
#define HSEM_SISR_ISF7_Pos      (7UL)
#define HSEM_SISR_ISF7_Msk      (0x1UL << HSEM_SISR_ISF7_Pos)                /*!< 0x00000080 */
#define HSEM_SISR_ISF7          HSEM_SISR_ISF7_Msk                           /*!<semaphore 7 secure interrupt status bit.  */
#define HSEM_SISR_ISF8_Pos      (8UL)
#define HSEM_SISR_ISF8_Msk      (0x1UL << HSEM_SISR_ISF8_Pos)                /*!< 0x00000100 */
#define HSEM_SISR_ISF8          HSEM_SISR_ISF8_Msk                           /*!<semaphore 8 secure interrupt status bit.  */
#define HSEM_SISR_ISF9_Pos      (9UL)
#define HSEM_SISR_ISF9_Msk      (0x1UL << HSEM_SISR_ISF9_Pos)                /*!< 0x00000200 */
#define HSEM_SISR_ISF9          HSEM_SISR_ISF9_Msk                           /*!<semaphore 9 secure interrupt status bit.  */
#define HSEM_SISR_ISF10_Pos     (10UL)
#define HSEM_SISR_ISF10_Msk     (0x1UL << HSEM_SISR_ISF10_Pos)               /*!< 0x00000400 */
#define HSEM_SISR_ISF10         HSEM_SISR_ISF10_Msk                          /*!<semaphore 10 secure interrupt status bit. */
#define HSEM_SISR_ISF11_Pos     (11UL)
#define HSEM_SISR_ISF11_Msk     (0x1UL << HSEM_SISR_ISF11_Pos)               /*!< 0x00000800 */
#define HSEM_SISR_ISF11         HSEM_SISR_ISF11_Msk                          /*!<semaphore 11 secure interrupt status bit. */
#define HSEM_SISR_ISF12_Pos     (12UL)
#define HSEM_SISR_ISF12_Msk     (0x1UL << HSEM_SISR_ISF12_Pos)               /*!< 0x00001000 */
#define HSEM_SISR_ISF12         HSEM_SISR_ISF12_Msk                          /*!<semaphore 12 secure interrupt status bit. */
#define HSEM_SISR_ISF13_Pos     (13UL)
#define HSEM_SISR_ISF13_Msk     (0x1UL << HSEM_SISR_ISF13_Pos)               /*!< 0x00002000 */
#define HSEM_SISR_ISF13         HSEM_SISR_ISF13_Msk                          /*!<semaphore 13 secure interrupt status bit. */
#define HSEM_SISR_ISF14_Pos     (14UL)
#define HSEM_SISR_ISF14_Msk     (0x1UL << HSEM_SISR_ISF14_Pos)               /*!< 0x00004000 */
#define HSEM_SISR_ISF14         HSEM_SISR_ISF14_Msk                          /*!<semaphore 14 secure interrupt status bit. */
#define HSEM_SISR_ISF15_Pos     (15UL)
#define HSEM_SISR_ISF15_Msk     (0x1UL << HSEM_SISR_ISF15_Pos)               /*!< 0x00008000 */
#define HSEM_SISR_ISF15         HSEM_SISR_ISF15_Msk                          /*!<semaphore 15 secure interrupt status bit. */

/********************  Bit definition for HSEM_SMISR register  *****************/
#define HSEM_SMISR_MISF0_Pos    (0UL)
#define HSEM_SMISR_MISF0_Msk    (0x1UL << HSEM_SMISR_MISF0_Pos)              /*!< 0x00000001 */
#define HSEM_SMISR_MISF0        HSEM_SMISR_MISF0_Msk                         /*!<semaphore 0 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF1_Pos    (1UL)
#define HSEM_SMISR_MISF1_Msk    (0x1UL << HSEM_SMISR_MISF1_Pos)              /*!< 0x00000002 */
#define HSEM_SMISR_MISF1        HSEM_SMISR_MISF1_Msk                         /*!<semaphore 1 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF2_Pos    (2UL)
#define HSEM_SMISR_MISF2_Msk    (0x1UL << HSEM_SMISR_MISF2_Pos)              /*!< 0x00000004 */
#define HSEM_SMISR_MISF2        HSEM_SMISR_MISF2_Msk                         /*!<semaphore 2 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF3_Pos    (3UL)
#define HSEM_SMISR_MISF3_Msk    (0x1UL << HSEM_SMISR_MISF3_Pos)              /*!< 0x00000008 */
#define HSEM_SMISR_MISF3        HSEM_SMISR_MISF3_Msk                         /*!<semaphore 3 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF4_Pos    (4UL)
#define HSEM_SMISR_MISF4_Msk    (0x1UL << HSEM_SMISR_MISF4_Pos)              /*!< 0x00000010 */
#define HSEM_SMISR_MISF4        HSEM_SMISR_MISF4_Msk                         /*!<semaphore 4 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF5_Pos    (5UL)
#define HSEM_SMISR_MISF5_Msk    (0x1UL << HSEM_SMISR_MISF5_Pos)              /*!< 0x00000020 */
#define HSEM_SMISR_MISF5        HSEM_SMISR_MISF5_Msk                         /*!<semaphore 5 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF6_Pos    (6UL)
#define HSEM_SMISR_MISF6_Msk    (0x1UL << HSEM_SMISR_MISF6_Pos)              /*!< 0x00000040 */
#define HSEM_SMISR_MISF6        HSEM_SMISR_MISF6_Msk                         /*!<semaphore 6 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF7_Pos    (7UL)
#define HSEM_SMISR_MISF7_Msk    (0x1UL << HSEM_SMISR_MISF7_Pos)              /*!< 0x00000080 */
#define HSEM_SMISR_MISF7        HSEM_SMISR_MISF7_Msk                         /*!<semaphore 7 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF8_Pos    (8UL)
#define HSEM_SMISR_MISF8_Msk    (0x1UL << HSEM_SMISR_MISF8_Pos)              /*!< 0x00000100 */
#define HSEM_SMISR_MISF8        HSEM_SMISR_MISF8_Msk                         /*!<semaphore 8 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF9_Pos    (9UL)
#define HSEM_SMISR_MISF9_Msk    (0x1UL << HSEM_SMISR_MISF9_Pos)              /*!< 0x00000200 */
#define HSEM_SMISR_MISF9        HSEM_SMISR_MISF9_Msk                         /*!<semaphore 9 secure interrupt masked status bit.  */
#define HSEM_SMISR_MISF10_Pos   (10UL)
#define HSEM_SMISR_MISF10_Msk   (0x1UL << HSEM_SMISR_MISF10_Pos)             /*!< 0x00000400 */
#define HSEM_SMISR_MISF10       HSEM_SMISR_MISF10_Msk                        /*!<semaphore 10 secure interrupt masked status bit. */
#define HSEM_SMISR_MISF11_Pos   (11UL)
#define HSEM_SMISR_MISF11_Msk   (0x1UL << HSEM_SMISR_MISF11_Pos)             /*!< 0x00000800 */
#define HSEM_SMISR_MISF11       HSEM_SMISR_MISF11_Msk                        /*!<semaphore 11 secure interrupt masked status bit. */
#define HSEM_SMISR_MISF12_Pos   (12UL)
#define HSEM_SMISR_MISF12_Msk   (0x1UL << HSEM_SMISR_MISF12_Pos)             /*!< 0x00001000 */
#define HSEM_SMISR_MISF12       HSEM_SMISR_MISF12_Msk                        /*!<semaphore 12 secure interrupt masked status bit. */
#define HSEM_SMISR_MISF13_Pos   (13UL)
#define HSEM_SMISR_MISF13_Msk   (0x1UL << HSEM_SMISR_MISF13_Pos)             /*!< 0x00002000 */
#define HSEM_SMISR_MISF13       HSEM_SMISR_MISF13_Msk                        /*!<semaphore 13 secure interrupt masked status bit. */
#define HSEM_SMISR_MISF14_Pos   (14UL)
#define HSEM_SMISR_MISF14_Msk   (0x1UL << HSEM_SMISR_MISF14_Pos)             /*!< 0x00004000 */
#define HSEM_SMISR_MISF14       HSEM_SMISR_MISF14_Msk                        /*!<semaphore 14 secure interrupt masked status bit. */
#define HSEM_SMISR_MISF15_Pos   (15UL)
#define HSEM_SMISR_MISF15_Msk   (0x1UL << HSEM_SMISR_MISF15_Pos)             /*!< 0x00008000 */
#define HSEM_SMISR_MISF15       HSEM_SMISR_MISF15_Msk                        /*!<semaphore 15 secure interrupt masked status bit. */

/********************  Bit definition for HSEM_SECCFGR register  *****************/
#define HSEM_SECCFGR_SEC0_Pos     (0UL)
#define HSEM_SECCFGR_SEC0_Msk     (0x1UL << HSEM_SECCFGR_SEC0_Pos)            /*!< 0x00000001 */
#define HSEM_SECCFGR_SEC0         HSEM_SECCFGR_SEC0_Msk                       /*!<semaphore 0 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC1_Pos     (1UL)
#define HSEM_SECCFGR_SEC1_Msk     (0x1UL << HSEM_SECCFGR_SEC1_Pos)            /*!< 0x00000002 */
#define HSEM_SECCFGR_SEC1         HSEM_SECCFGR_SEC1_Msk                       /*!<semaphore 1 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC2_Pos     (2UL)
#define HSEM_SECCFGR_SEC2_Msk     (0x1UL << HSEM_SECCFGR_SEC2_Pos)            /*!< 0x00000004 */
#define HSEM_SECCFGR_SEC2         HSEM_SECCFGR_SEC2_Msk                       /*!<semaphore 2 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC3_Pos     (3UL)
#define HSEM_SECCFGR_SEC3_Msk     (0x1UL << HSEM_SECCFGR_SEC3_Pos)            /*!< 0x00000008 */
#define HSEM_SECCFGR_SEC3         HSEM_SECCFGR_SEC3_Msk                       /*!<semaphore 3 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC4_Pos     (4UL)
#define HSEM_SECCFGR_SEC4_Msk     (0x1UL << HSEM_SECCFGR_SEC4_Pos)            /*!< 0x00000010 */
#define HSEM_SECCFGR_SEC4         HSEM_SECCFGR_SEC4_Msk                       /*!<semaphore 4 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC5_Pos     (5UL)
#define HSEM_SECCFGR_SEC5_Msk     (0x1UL << HSEM_SECCFGR_SEC5_Pos)            /*!< 0x00000020 */
#define HSEM_SECCFGR_SEC5         HSEM_SECCFGR_SEC5_Msk                       /*!<semaphore 5 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC6_Pos     (6UL)
#define HSEM_SECCFGR_SEC6_Msk     (0x1UL << HSEM_SECCFGR_SEC6_Pos)            /*!< 0x00000040 */
#define HSEM_SECCFGR_SEC6         HSEM_SECCFGR_SEC6_Msk                       /*!<semaphore 6 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC7_Pos     (7UL)
#define HSEM_SECCFGR_SEC7_Msk     (0x1UL << HSEM_SECCFGR_SEC7_Pos)            /*!< 0x00000080 */
#define HSEM_SECCFGR_SEC7         HSEM_SECCFGR_SEC7_Msk                       /*!<semaphore 7 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC8_Pos     (8UL)
#define HSEM_SECCFGR_SEC8_Msk     (0x1UL << HSEM_SECCFGR_SEC8_Pos)            /*!< 0x00000100 */
#define HSEM_SECCFGR_SEC8         HSEM_SECCFGR_SEC8_Msk                       /*!<semaphore 8 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC9_Pos     (9UL)
#define HSEM_SECCFGR_SEC9_Msk     (0x1UL << HSEM_SECCFGR_SEC9_Pos)            /*!< 0x00000200 */
#define HSEM_SECCFGR_SEC9         HSEM_SECCFGR_SEC9_Msk                       /*!<semaphore 9 secure attribute status bit.  */
#define HSEM_SECCFGR_SEC10_Pos    (10UL)
#define HSEM_SECCFGR_SEC10_Msk    (0x1UL << HSEM_SECCFGR_SEC10_Pos)           /*!< 0x00000400 */
#define HSEM_SECCFGR_SEC10        HSEM_SECCFGR_SEC10_Msk                      /*!<semaphore 10 secure attribute status bit. */
#define HSEM_SECCFGR_SEC11_Pos    (11UL)
#define HSEM_SECCFGR_SEC11_Msk    (0x1UL << HSEM_SECCFGR_SEC11_Pos)           /*!< 0x00000800 */
#define HSEM_SECCFGR_SEC11        HSEM_SECCFGR_SEC11_Msk                      /*!<semaphore 11 secure attribute status bit. */
#define HSEM_SECCFGR_SEC12_Pos    (12UL)
#define HSEM_SECCFGR_SEC12_Msk    (0x1UL << HSEM_SECCFGR_SEC12_Pos)           /*!< 0x00001000 */
#define HSEM_SECCFGR_SEC12        HSEM_SECCFGR_SEC12_Msk                      /*!<semaphore 12 secure attribute status bit. */
#define HSEM_SECCFGR_SEC13_Pos    (13UL)
#define HSEM_SECCFGR_SEC13_Msk    (0x1UL << HSEM_SECCFGR_SEC13_Pos)           /*!< 0x00002000 */
#define HSEM_SECCFGR_SEC13        HSEM_SECCFGR_SEC13_Msk                      /*!<semaphore 13 secure attribute status bit. */
#define HSEM_SECCFGR_SEC14_Pos    (14UL)
#define HSEM_SECCFGR_SEC14_Msk    (0x1UL << HSEM_SECCFGR_SEC14_Pos)           /*!< 0x00004000 */
#define HSEM_SECCFGR_SEC14        HSEM_SECCFGR_SEC14_Msk                      /*!<semaphore 14 secure attribute status bit. */
#define HSEM_SECCFGR_SEC15_Pos    (15UL)
#define HSEM_SECCFGR_SEC15_Msk    (0x1UL << HSEM_SECCFGR_SEC15_Pos)           /*!< 0x00008000 */
#define HSEM_SECCFGR_SEC15        HSEM_SECCFGR_SEC15_Msk                      /*!<semaphore 15 secure attribute status bit. */

/********************  Bit definition for HSEM_PRIVCFGR register  *****************/
#define HSEM_PRIVCFGR_PRIV0_Pos     (0UL)
#define HSEM_PRIVCFGR_PRIV0_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV0_Pos)            /*!< 0x00000001 */
#define HSEM_PRIVCFGR_PRIV0         HSEM_PRIVCFGR_PRIV0_Msk                       /*!<semaphore 0 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV1_Pos     (1UL)
#define HSEM_PRIVCFGR_PRIV1_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV1_Pos)            /*!< 0x00000002 */
#define HSEM_PRIVCFGR_PRIV1         HSEM_PRIVCFGR_PRIV1_Msk                       /*!<semaphore 1 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV2_Pos     (2UL)
#define HSEM_PRIVCFGR_PRIV2_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV2_Pos)            /*!< 0x00000004 */
#define HSEM_PRIVCFGR_PRIV2         HSEM_PRIVCFGR_PRIV2_Msk                       /*!<semaphore 2 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV3_Pos     (3UL)
#define HSEM_PRIVCFGR_PRIV3_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV3_Pos)            /*!< 0x00000008 */
#define HSEM_PRIVCFGR_PRIV3         HSEM_PRIVCFGR_PRIV3_Msk                       /*!<semaphore 3 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV4_Pos     (4UL)
#define HSEM_PRIVCFGR_PRIV4_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV4_Pos)            /*!< 0x00000010 */
#define HSEM_PRIVCFGR_PRIV4         HSEM_PRIVCFGR_PRIV4_Msk                       /*!<semaphore 4 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV5_Pos     (5UL)
#define HSEM_PRIVCFGR_PRIV5_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV5_Pos)            /*!< 0x00000020 */
#define HSEM_PRIVCFGR_PRIV5         HSEM_PRIVCFGR_PRIV5_Msk                       /*!<semaphore 5 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV6_Pos     (6UL)
#define HSEM_PRIVCFGR_PRIV6_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV6_Pos)            /*!< 0x00000040 */
#define HSEM_PRIVCFGR_PRIV6         HSEM_PRIVCFGR_PRIV6_Msk                       /*!<semaphore 6 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV7_Pos     (7UL)
#define HSEM_PRIVCFGR_PRIV7_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV7_Pos)            /*!< 0x00000080 */
#define HSEM_PRIVCFGR_PRIV7         HSEM_PRIVCFGR_PRIV7_Msk                       /*!<semaphore 7 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV8_Pos     (8UL)
#define HSEM_PRIVCFGR_PRIV8_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV8_Pos)            /*!< 0x00000100 */
#define HSEM_PRIVCFGR_PRIV8         HSEM_PRIVCFGR_PRIV8_Msk                       /*!<semaphore 8 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV9_Pos     (9UL)
#define HSEM_PRIVCFGR_PRIV9_Msk     (0x1UL << HSEM_PRIVCFGR_PRIV9_Pos)            /*!< 0x00000200 */
#define HSEM_PRIVCFGR_PRIV9         HSEM_PRIVCFGR_PRIV9_Msk                       /*!<semaphore 9 privilege attribute status bit.  */
#define HSEM_PRIVCFGR_PRIV10_Pos    (10UL)
#define HSEM_PRIVCFGR_PRIV10_Msk    (0x1UL << HSEM_PRIVCFGR_PRIV10_Pos)           /*!< 0x00000400 */
#define HSEM_PRIVCFGR_PRIV10        HSEM_PRIVCFGR_PRIV10_Msk                      /*!<semaphore 10 privilege attribute status bit. */
#define HSEM_PRIVCFGR_PRIV11_Pos    (11UL)
#define HSEM_PRIVCFGR_PRIV11_Msk    (0x1UL << HSEM_PRIVCFGR_PRIV11_Pos)           /*!< 0x00000800 */
#define HSEM_PRIVCFGR_PRIV11        HSEM_PRIVCFGR_PRIV11_Msk                      /*!<semaphore 11 privilege attribute status bit. */
#define HSEM_PRIVCFGR_PRIV12_Pos    (12UL)
#define HSEM_PRIVCFGR_PRIV12_Msk    (0x1UL << HSEM_PRIVCFGR_PRIV12_Pos)           /*!< 0x00001000 */
#define HSEM_PRIVCFGR_PRIV12        HSEM_PRIVCFGR_PRIV12_Msk                      /*!<semaphore 12 privilege attribute status bit. */
#define HSEM_PRIVCFGR_PRIV13_Pos    (13UL)
#define HSEM_PRIVCFGR_PRIV13_Msk    (0x1UL << HSEM_PRIVCFGR_PRIV13_Pos)           /*!< 0x00002000 */
#define HSEM_PRIVCFGR_PRIV13        HSEM_PRIVCFGR_PRIV13_Msk                      /*!<semaphore 13 privilege attribute status bit. */
#define HSEM_PRIVCFGR_PRIV14_Pos    (14UL)
#define HSEM_PRIVCFGR_PRIV14_Msk    (0x1UL << HSEM_PRIVCFGR_PRIV14_Pos)           /*!< 0x00004000 */
#define HSEM_PRIVCFGR_PRIV14        HSEM_PRIVCFGR_PRIV14_Msk                      /*!<semaphore 14 privilege attribute status bit. */
#define HSEM_PRIVCFGR_PRIV15_Pos    (15UL)
#define HSEM_PRIVCFGR_PRIV15_Msk    (0x1UL << HSEM_PRIVCFGR_PRIV15_Pos)           /*!< 0x00008000 */
#define HSEM_PRIVCFGR_PRIV15        HSEM_PRIVCFGR_PRIV15_Msk                      /*!<semaphore 15 privilege attribute status bit. */

/********************  Bit definition for HSEM_CR register  *****************/
#define HSEM_CR_LOCKID_Pos       (8UL)
#define HSEM_CR_LOCKID_Msk       (0xFUL << HSEM_CR_LOCKID_Pos)                 /*!< 0x00000F00 */
#define HSEM_CR_LOCKID           HSEM_CR_LOCKID_Msk                            /*!<LOCKID of semaphores to be cleared. */
#define HSEM_CR_LOCKID_CPU1      (0x2UL << HSEM_CR_LOCKID_Pos)
#define HSEM_CR_LOCKID_CURRENT   HSEM_CR_LOCKID_CPU1
#define HSEM_CR_SEC_Pos          (12UL)
#define HSEM_CR_SEC_Msk          (0x1UL << HSEM_CR_SEC_Pos)                    /*!< 0x00001000 */
#define HSEM_CR_SEC_             HSEM_CR_SEC_Msk                               /*!<SEC value of semaphores to be cleared. */
#define HSEM_CR_PRIV_Pos         (13UL)
#define HSEM_CR_PRIV_Msk         (0x1UL << HSEM_CR_PRIV_Pos)                   /*!< 0x00000F00 */
#define HSEM_CR_PRIV             HSEM_CR_PRIV_Msk                              /*!<PRIV value of semaphores to be cleared. */
#define HSEM_CR_KEY_Pos          (16UL)
#define HSEM_CR_KEY_Msk          (0xFFFFUL << HSEM_CR_KEY_Pos)                 /*!< 0xFFFF0000 */
#define HSEM_CR_KEY              HSEM_CR_KEY_Msk                               /*!<semaphores clear key. */

/********************  Bit definition for HSEM_KEYR register  *****************/
#define HSEM_KEYR_KEY_Pos        (16UL)
#define HSEM_KEYR_KEY_Msk        (0xFFFFUL << HSEM_KEYR_KEY_Pos)               /*!< 0xFFFF0000 */
#define HSEM_KEYR_KEY            HSEM_KEYR_KEY_Msk                             /*!<semaphores clear key. */


/******************************************************************************/
/*                                                                            */
/*                      Inter-integrated Circuit Interface (I2C)              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for I2C_CR1 register  *******************/
#define I2C_CR1_PE_Pos                      (0UL)
#define I2C_CR1_PE_Msk                      (0x1UL << I2C_CR1_PE_Pos)               /*!< 0x00000001 */
#define I2C_CR1_PE                          I2C_CR1_PE_Msk                          /*!< Peripheral enable */
#define I2C_CR1_TXIE_Pos                    (1UL)
#define I2C_CR1_TXIE_Msk                    (0x1UL << I2C_CR1_TXIE_Pos)             /*!< 0x00000002 */
#define I2C_CR1_TXIE                        I2C_CR1_TXIE_Msk                        /*!< TX interrupt enable */
#define I2C_CR1_RXIE_Pos                    (2UL)
#define I2C_CR1_RXIE_Msk                    (0x1UL << I2C_CR1_RXIE_Pos)             /*!< 0x00000004 */
#define I2C_CR1_RXIE                        I2C_CR1_RXIE_Msk                        /*!< RX interrupt enable */
#define I2C_CR1_ADDRIE_Pos                  (3UL)
#define I2C_CR1_ADDRIE_Msk                  (0x1UL << I2C_CR1_ADDRIE_Pos)           /*!< 0x00000008 */
#define I2C_CR1_ADDRIE                      I2C_CR1_ADDRIE_Msk                      /*!< Address match interrupt enable */
#define I2C_CR1_NACKIE_Pos                  (4UL)
#define I2C_CR1_NACKIE_Msk                  (0x1UL << I2C_CR1_NACKIE_Pos)           /*!< 0x00000010 */
#define I2C_CR1_NACKIE                      I2C_CR1_NACKIE_Msk                      /*!< NACK received interrupt enable */
#define I2C_CR1_STOPIE_Pos                  (5UL)
#define I2C_CR1_STOPIE_Msk                  (0x1UL << I2C_CR1_STOPIE_Pos)           /*!< 0x00000020 */
#define I2C_CR1_STOPIE                      I2C_CR1_STOPIE_Msk                      /*!< STOP detection interrupt enable */
#define I2C_CR1_TCIE_Pos                    (6UL)
#define I2C_CR1_TCIE_Msk                    (0x1UL << I2C_CR1_TCIE_Pos)             /*!< 0x00000040 */
#define I2C_CR1_TCIE                        I2C_CR1_TCIE_Msk                        /*!< Transfer complete interrupt enable */
#define I2C_CR1_ERRIE_Pos                   (7UL)
#define I2C_CR1_ERRIE_Msk                   (0x1UL << I2C_CR1_ERRIE_Pos)            /*!< 0x00000080 */
#define I2C_CR1_ERRIE                       I2C_CR1_ERRIE_Msk                       /*!< Errors interrupt enable */
#define I2C_CR1_DNF_Pos                     (8UL)
#define I2C_CR1_DNF_Msk                     (0xFUL << I2C_CR1_DNF_Pos)              /*!< 0x00000F00 */
#define I2C_CR1_DNF                         I2C_CR1_DNF_Msk                         /*!< Digital noise filter */
#define I2C_CR1_ANFOFF_Pos                  (12UL)
#define I2C_CR1_ANFOFF_Msk                  (0x1UL << I2C_CR1_ANFOFF_Pos)           /*!< 0x00001000 */
#define I2C_CR1_ANFOFF                      I2C_CR1_ANFOFF_Msk                      /*!< Analog noise filter OFF */
#define I2C_CR1_TXDMAEN_Pos                 (14UL)
#define I2C_CR1_TXDMAEN_Msk                 (0x1UL << I2C_CR1_TXDMAEN_Pos)          /*!< 0x00004000 */
#define I2C_CR1_TXDMAEN                     I2C_CR1_TXDMAEN_Msk                     /*!< DMA transmission requests enable */
#define I2C_CR1_RXDMAEN_Pos                 (15UL)
#define I2C_CR1_RXDMAEN_Msk                 (0x1UL << I2C_CR1_RXDMAEN_Pos)          /*!< 0x00008000 */
#define I2C_CR1_RXDMAEN                     I2C_CR1_RXDMAEN_Msk                     /*!< DMA reception requests enable */
#define I2C_CR1_SBC_Pos                     (16UL)
#define I2C_CR1_SBC_Msk                     (0x1UL << I2C_CR1_SBC_Pos)              /*!< 0x00010000 */
#define I2C_CR1_SBC                         I2C_CR1_SBC_Msk                         /*!< Slave byte control */
#define I2C_CR1_NOSTRETCH_Pos               (17UL)
#define I2C_CR1_NOSTRETCH_Msk               (0x1UL << I2C_CR1_NOSTRETCH_Pos)        /*!< 0x00020000 */
#define I2C_CR1_NOSTRETCH                   I2C_CR1_NOSTRETCH_Msk                   /*!< Clock stretching disable */
#define I2C_CR1_WUPEN_Pos                   (18UL)
#define I2C_CR1_WUPEN_Msk                   (0x1UL << I2C_CR1_WUPEN_Pos)            /*!< 0x00040000 */
#define I2C_CR1_WUPEN                       I2C_CR1_WUPEN_Msk                       /*!< Wakeup from STOP enable */
#define I2C_CR1_GCEN_Pos                    (19UL)
#define I2C_CR1_GCEN_Msk                    (0x1UL << I2C_CR1_GCEN_Pos)             /*!< 0x00080000 */
#define I2C_CR1_GCEN                        I2C_CR1_GCEN_Msk                        /*!< General call enable */
#define I2C_CR1_SMBHEN_Pos                  (20UL)
#define I2C_CR1_SMBHEN_Msk                  (0x1UL << I2C_CR1_SMBHEN_Pos)           /*!< 0x00100000 */
#define I2C_CR1_SMBHEN                      I2C_CR1_SMBHEN_Msk                      /*!< SMBus host address enable */
#define I2C_CR1_SMBDEN_Pos                  (21UL)
#define I2C_CR1_SMBDEN_Msk                  (0x1UL << I2C_CR1_SMBDEN_Pos)           /*!< 0x00200000 */
#define I2C_CR1_SMBDEN                      I2C_CR1_SMBDEN_Msk                      /*!< SMBus device default address enable */
#define I2C_CR1_ALERTEN_Pos                 (22UL)
#define I2C_CR1_ALERTEN_Msk                 (0x1UL << I2C_CR1_ALERTEN_Pos)          /*!< 0x00400000 */
#define I2C_CR1_ALERTEN                     I2C_CR1_ALERTEN_Msk                     /*!< SMBus alert enable */
#define I2C_CR1_PECEN_Pos                   (23UL)
#define I2C_CR1_PECEN_Msk                   (0x1UL << I2C_CR1_PECEN_Pos)            /*!< 0x00800000 */
#define I2C_CR1_PECEN                       I2C_CR1_PECEN_Msk                       /*!< PEC enable */
#define I2C_CR1_FMP_Pos                     (24UL)
#define I2C_CR1_FMP_Msk                     (0x1UL << I2C_CR1_FMP_Pos)              /*!< 0x01000000 */
#define I2C_CR1_FMP                         I2C_CR1_FMP_Msk                         /*!< Fast-mode Plus 20 mA drive enable */
#define I2C_CR1_ADDRACLR_Pos                (30UL)
#define I2C_CR1_ADDRACLR_Msk                (0x1UL << I2C_CR1_ADDRACLR_Pos)         /*!< 0x40000000 */
#define I2C_CR1_ADDRACLR                    I2C_CR1_ADDRACLR_Msk                    /*!< ADDRACLR enable */
#define I2C_CR1_STOPFACLR_Pos               (31UL)
#define I2C_CR1_STOPFACLR_Msk               (0x1UL << I2C_CR1_STOPFACLR_Pos)        /*!< 0x80000000 */
#define I2C_CR1_STOPFACLR                   I2C_CR1_STOPFACLR_Msk                   /*!< STOPFACLR enable */

/******************  Bit definition for I2C_CR2 register  ********************/
#define I2C_CR2_SADD_Pos                    (0UL)
#define I2C_CR2_SADD_Msk                    (0x3FFUL << I2C_CR2_SADD_Pos)           /*!< 0x000003FF */
#define I2C_CR2_SADD                        I2C_CR2_SADD_Msk                        /*!< Slave address (master mode) */
#define I2C_CR2_RD_WRN_Pos                  (10UL)
#define I2C_CR2_RD_WRN_Msk                  (0x1UL << I2C_CR2_RD_WRN_Pos)           /*!< 0x00000400 */
#define I2C_CR2_RD_WRN                      I2C_CR2_RD_WRN_Msk                      /*!< Transfer direction (master mode) */
#define I2C_CR2_ADD10_Pos                   (11UL)
#define I2C_CR2_ADD10_Msk                   (0x1UL << I2C_CR2_ADD10_Pos)            /*!< 0x00000800 */
#define I2C_CR2_ADD10                       I2C_CR2_ADD10_Msk                       /*!< 10-bit addressing mode (master mode) */
#define I2C_CR2_HEAD10R_Pos                 (12UL)
#define I2C_CR2_HEAD10R_Msk                 (0x1UL << I2C_CR2_HEAD10R_Pos)          /*!< 0x00001000 */
#define I2C_CR2_HEAD10R                     I2C_CR2_HEAD10R_Msk                     /*!< 10-bit address header only read direction (master mode) */
#define I2C_CR2_START_Pos                   (13UL)
#define I2C_CR2_START_Msk                   (0x1UL << I2C_CR2_START_Pos)            /*!< 0x00002000 */
#define I2C_CR2_START                       I2C_CR2_START_Msk                       /*!< START generation */
#define I2C_CR2_STOP_Pos                    (14UL)
#define I2C_CR2_STOP_Msk                    (0x1UL << I2C_CR2_STOP_Pos)             /*!< 0x00004000 */
#define I2C_CR2_STOP                        I2C_CR2_STOP_Msk                        /*!< STOP generation (master mode) */
#define I2C_CR2_NACK_Pos                    (15UL)
#define I2C_CR2_NACK_Msk                    (0x1UL << I2C_CR2_NACK_Pos)             /*!< 0x00008000 */
#define I2C_CR2_NACK                        I2C_CR2_NACK_Msk                        /*!< NACK generation (slave mode) */
#define I2C_CR2_NBYTES_Pos                  (16UL)
#define I2C_CR2_NBYTES_Msk                  (0xFFUL << I2C_CR2_NBYTES_Pos)          /*!< 0x00FF0000 */
#define I2C_CR2_NBYTES                      I2C_CR2_NBYTES_Msk                      /*!< Number of bytes */
#define I2C_CR2_RELOAD_Pos                  (24UL)
#define I2C_CR2_RELOAD_Msk                  (0x1UL << I2C_CR2_RELOAD_Pos)           /*!< 0x01000000 */
#define I2C_CR2_RELOAD                      I2C_CR2_RELOAD_Msk                      /*!< NBYTES reload mode */
#define I2C_CR2_AUTOEND_Pos                 (25UL)
#define I2C_CR2_AUTOEND_Msk                 (0x1UL << I2C_CR2_AUTOEND_Pos)          /*!< 0x02000000 */
#define I2C_CR2_AUTOEND                     I2C_CR2_AUTOEND_Msk                     /*!< Automatic end mode (master mode) */
#define I2C_CR2_PECBYTE_Pos                 (26UL)
#define I2C_CR2_PECBYTE_Msk                 (0x1UL << I2C_CR2_PECBYTE_Pos)          /*!< 0x04000000 */
#define I2C_CR2_PECBYTE                     I2C_CR2_PECBYTE_Msk                     /*!< Packet error checking byte */

/*******************  Bit definition for I2C_OAR1 register  ******************/
#define I2C_OAR1_OA1_Pos                    (0UL)
#define I2C_OAR1_OA1_Msk                    (0x3FFUL << I2C_OAR1_OA1_Pos)           /*!< 0x000003FF */
#define I2C_OAR1_OA1                        I2C_OAR1_OA1_Msk                        /*!< Interface own address 1 */
#define I2C_OAR1_OA1MODE_Pos                (10UL)
#define I2C_OAR1_OA1MODE_Msk                (0x1UL << I2C_OAR1_OA1MODE_Pos)         /*!< 0x00000400 */
#define I2C_OAR1_OA1MODE                    I2C_OAR1_OA1MODE_Msk                    /*!< Own address 1 10-bit mode */
#define I2C_OAR1_OA1EN_Pos                  (15UL)
#define I2C_OAR1_OA1EN_Msk                  (0x1UL << I2C_OAR1_OA1EN_Pos)           /*!< 0x00008000 */
#define I2C_OAR1_OA1EN                      I2C_OAR1_OA1EN_Msk                      /*!< Own address 1 enable */

/*******************  Bit definition for I2C_OAR2 register  ******************/
#define I2C_OAR2_OA2_Pos                    (1UL)
#define I2C_OAR2_OA2_Msk                    (0x7FUL << I2C_OAR2_OA2_Pos)            /*!< 0x000000FE */
#define I2C_OAR2_OA2                        I2C_OAR2_OA2_Msk                        /*!< Interface own address 2 */
#define I2C_OAR2_OA2MSK_Pos                 (8UL)
#define I2C_OAR2_OA2MSK_Msk                 (0x7UL << I2C_OAR2_OA2MSK_Pos)          /*!< 0x00000700 */
#define I2C_OAR2_OA2MSK                     I2C_OAR2_OA2MSK_Msk                     /*!< Own address 2 masks */
#define I2C_OAR2_OA2NOMASK                  (0x00000000UL)                          /*!< No mask                                        */
#define I2C_OAR2_OA2MASK01_Pos              (8UL)
#define I2C_OAR2_OA2MASK01_Msk              (0x1UL << I2C_OAR2_OA2MASK01_Pos)       /*!< 0x00000100 */
#define I2C_OAR2_OA2MASK01                  I2C_OAR2_OA2MASK01_Msk                  /*!< OA2[1] is masked, Only OA2[7:2] are compared   */
#define I2C_OAR2_OA2MASK02_Pos              (9UL)
#define I2C_OAR2_OA2MASK02_Msk              (0x1UL << I2C_OAR2_OA2MASK02_Pos)       /*!< 0x00000200 */
#define I2C_OAR2_OA2MASK02                  I2C_OAR2_OA2MASK02_Msk                  /*!< OA2[2:1] is masked, Only OA2[7:3] are compared */
#define I2C_OAR2_OA2MASK03_Pos              (8UL)
#define I2C_OAR2_OA2MASK03_Msk              (0x3UL << I2C_OAR2_OA2MASK03_Pos)       /*!< 0x00000300 */
#define I2C_OAR2_OA2MASK03                  I2C_OAR2_OA2MASK03_Msk                  /*!< OA2[3:1] is masked, Only OA2[7:4] are compared */
#define I2C_OAR2_OA2MASK04_Pos              (10UL)
#define I2C_OAR2_OA2MASK04_Msk              (0x1UL << I2C_OAR2_OA2MASK04_Pos)       /*!< 0x00000400 */
#define I2C_OAR2_OA2MASK04                  I2C_OAR2_OA2MASK04_Msk                  /*!< OA2[4:1] is masked, Only OA2[7:5] are compared */
#define I2C_OAR2_OA2MASK05_Pos              (8UL)
#define I2C_OAR2_OA2MASK05_Msk              (0x5UL << I2C_OAR2_OA2MASK05_Pos)       /*!< 0x00000500 */
#define I2C_OAR2_OA2MASK05                  I2C_OAR2_OA2MASK05_Msk                  /*!< OA2[5:1] is masked, Only OA2[7:6] are compared */
#define I2C_OAR2_OA2MASK06_Pos              (9UL)
#define I2C_OAR2_OA2MASK06_Msk              (0x3UL << I2C_OAR2_OA2MASK06_Pos)       /*!< 0x00000600 */
#define I2C_OAR2_OA2MASK06                  I2C_OAR2_OA2MASK06_Msk                  /*!< OA2[6:1] is masked, Only OA2[7] are compared   */
#define I2C_OAR2_OA2MASK07_Pos              (8UL)
#define I2C_OAR2_OA2MASK07_Msk              (0x7UL << I2C_OAR2_OA2MASK07_Pos)       /*!< 0x00000700 */
#define I2C_OAR2_OA2MASK07                  I2C_OAR2_OA2MASK07_Msk                  /*!< OA2[7:1] is masked, No comparison is done      */
#define I2C_OAR2_OA2EN_Pos                  (15UL)
#define I2C_OAR2_OA2EN_Msk                  (0x1UL << I2C_OAR2_OA2EN_Pos)           /*!< 0x00008000 */
#define I2C_OAR2_OA2EN                      I2C_OAR2_OA2EN_Msk                      /*!< Own address 2 enable */

/*******************  Bit definition for I2C_TIMINGR register *******************/
#define I2C_TIMINGR_SCLL_Pos                (0UL)
#define I2C_TIMINGR_SCLL_Msk                (0xFFUL << I2C_TIMINGR_SCLL_Pos)        /*!< 0x000000FF */
#define I2C_TIMINGR_SCLL                    I2C_TIMINGR_SCLL_Msk                    /*!< SCL low period (master mode) */
#define I2C_TIMINGR_SCLH_Pos                (8UL)
#define I2C_TIMINGR_SCLH_Msk                (0xFFUL << I2C_TIMINGR_SCLH_Pos)        /*!< 0x0000FF00 */
#define I2C_TIMINGR_SCLH                    I2C_TIMINGR_SCLH_Msk                    /*!< SCL high period (master mode) */
#define I2C_TIMINGR_SDADEL_Pos              (16UL)
#define I2C_TIMINGR_SDADEL_Msk              (0xFUL << I2C_TIMINGR_SDADEL_Pos)       /*!< 0x000F0000 */
#define I2C_TIMINGR_SDADEL                  I2C_TIMINGR_SDADEL_Msk                  /*!< Data hold time */
#define I2C_TIMINGR_SCLDEL_Pos              (20UL)
#define I2C_TIMINGR_SCLDEL_Msk              (0xFUL << I2C_TIMINGR_SCLDEL_Pos)       /*!< 0x00F00000 */
#define I2C_TIMINGR_SCLDEL                  I2C_TIMINGR_SCLDEL_Msk                  /*!< Data setup time */
#define I2C_TIMINGR_PRESC_Pos               (28UL)
#define I2C_TIMINGR_PRESC_Msk               (0xFUL << I2C_TIMINGR_PRESC_Pos)        /*!< 0xF0000000 */
#define I2C_TIMINGR_PRESC                   I2C_TIMINGR_PRESC_Msk                   /*!< Timings prescaler */

/******************* Bit definition for I2C_TIMEOUTR register *******************/
#define I2C_TIMEOUTR_TIMEOUTA_Pos           (0UL)
#define I2C_TIMEOUTR_TIMEOUTA_Msk           (0xFFFUL << I2C_TIMEOUTR_TIMEOUTA_Pos)  /*!< 0x00000FFF */
#define I2C_TIMEOUTR_TIMEOUTA               I2C_TIMEOUTR_TIMEOUTA_Msk               /*!< Bus timeout A */
#define I2C_TIMEOUTR_TIDLE_Pos              (12UL)
#define I2C_TIMEOUTR_TIDLE_Msk              (0x1UL << I2C_TIMEOUTR_TIDLE_Pos)       /*!< 0x00001000 */
#define I2C_TIMEOUTR_TIDLE                  I2C_TIMEOUTR_TIDLE_Msk                  /*!< Idle clock timeout detection */
#define I2C_TIMEOUTR_TIMOUTEN_Pos           (15UL)
#define I2C_TIMEOUTR_TIMOUTEN_Msk           (0x1UL << I2C_TIMEOUTR_TIMOUTEN_Pos)    /*!< 0x00008000 */
#define I2C_TIMEOUTR_TIMOUTEN               I2C_TIMEOUTR_TIMOUTEN_Msk               /*!< Clock timeout enable */
#define I2C_TIMEOUTR_TIMEOUTB_Pos           (16UL)
#define I2C_TIMEOUTR_TIMEOUTB_Msk           (0xFFFUL << I2C_TIMEOUTR_TIMEOUTB_Pos)  /*!< 0x0FFF0000 */
#define I2C_TIMEOUTR_TIMEOUTB               I2C_TIMEOUTR_TIMEOUTB_Msk               /*!< Bus timeout B*/
#define I2C_TIMEOUTR_TEXTEN_Pos             (31UL)
#define I2C_TIMEOUTR_TEXTEN_Msk             (0x1UL << I2C_TIMEOUTR_TEXTEN_Pos)      /*!< 0x80000000 */
#define I2C_TIMEOUTR_TEXTEN                 I2C_TIMEOUTR_TEXTEN_Msk                 /*!< Extended clock timeout enable */

/******************  Bit definition for I2C_ISR register  *********************/
#define I2C_ISR_TXE_Pos                     (0UL)
#define I2C_ISR_TXE_Msk                     (0x1UL << I2C_ISR_TXE_Pos)              /*!< 0x00000001 */
#define I2C_ISR_TXE                         I2C_ISR_TXE_Msk                         /*!< Transmit data register empty */
#define I2C_ISR_TXIS_Pos                    (1UL)
#define I2C_ISR_TXIS_Msk                    (0x1UL << I2C_ISR_TXIS_Pos)             /*!< 0x00000002 */
#define I2C_ISR_TXIS                        I2C_ISR_TXIS_Msk                        /*!< Transmit interrupt status */
#define I2C_ISR_RXNE_Pos                    (2UL)
#define I2C_ISR_RXNE_Msk                    (0x1UL << I2C_ISR_RXNE_Pos)             /*!< 0x00000004 */
#define I2C_ISR_RXNE                        I2C_ISR_RXNE_Msk                        /*!< Receive data register not empty */
#define I2C_ISR_ADDR_Pos                    (3UL)
#define I2C_ISR_ADDR_Msk                    (0x1UL << I2C_ISR_ADDR_Pos)             /*!< 0x00000008 */
#define I2C_ISR_ADDR                        I2C_ISR_ADDR_Msk                        /*!< Address matched (slave mode)*/
#define I2C_ISR_NACKF_Pos                   (4UL)
#define I2C_ISR_NACKF_Msk                   (0x1UL << I2C_ISR_NACKF_Pos)            /*!< 0x00000010 */
#define I2C_ISR_NACKF                       I2C_ISR_NACKF_Msk                       /*!< NACK received flag */
#define I2C_ISR_STOPF_Pos                   (5UL)
#define I2C_ISR_STOPF_Msk                   (0x1UL << I2C_ISR_STOPF_Pos)            /*!< 0x00000020 */
#define I2C_ISR_STOPF                       I2C_ISR_STOPF_Msk                       /*!< STOP detection flag */
#define I2C_ISR_TC_Pos                      (6UL)
#define I2C_ISR_TC_Msk                      (0x1UL << I2C_ISR_TC_Pos)               /*!< 0x00000040 */
#define I2C_ISR_TC                          I2C_ISR_TC_Msk                          /*!< Transfer complete (master mode) */
#define I2C_ISR_TCR_Pos                     (7UL)
#define I2C_ISR_TCR_Msk                     (0x1UL << I2C_ISR_TCR_Pos)              /*!< 0x00000080 */
#define I2C_ISR_TCR                         I2C_ISR_TCR_Msk                         /*!< Transfer complete reload */
#define I2C_ISR_BERR_Pos                    (8UL)
#define I2C_ISR_BERR_Msk                    (0x1UL << I2C_ISR_BERR_Pos)             /*!< 0x00000100 */
#define I2C_ISR_BERR                        I2C_ISR_BERR_Msk                        /*!< Bus error */
#define I2C_ISR_ARLO_Pos                    (9UL)
#define I2C_ISR_ARLO_Msk                    (0x1UL << I2C_ISR_ARLO_Pos)             /*!< 0x00000200 */
#define I2C_ISR_ARLO                        I2C_ISR_ARLO_Msk                        /*!< Arbitration lost */
#define I2C_ISR_OVR_Pos                     (10UL)
#define I2C_ISR_OVR_Msk                     (0x1UL << I2C_ISR_OVR_Pos)              /*!< 0x00000400 */
#define I2C_ISR_OVR                         I2C_ISR_OVR_Msk                         /*!< Overrun/Underrun */
#define I2C_ISR_PECERR_Pos                  (11UL)
#define I2C_ISR_PECERR_Msk                  (0x1UL << I2C_ISR_PECERR_Pos)           /*!< 0x00000800 */
#define I2C_ISR_PECERR                      I2C_ISR_PECERR_Msk                      /*!< PEC error in reception */
#define I2C_ISR_TIMEOUT_Pos                 (12UL)
#define I2C_ISR_TIMEOUT_Msk                 (0x1UL << I2C_ISR_TIMEOUT_Pos)          /*!< 0x00001000 */
#define I2C_ISR_TIMEOUT                     I2C_ISR_TIMEOUT_Msk                     /*!< Timeout or Tlow detection flag */
#define I2C_ISR_ALERT_Pos                   (13UL)
#define I2C_ISR_ALERT_Msk                   (0x1UL << I2C_ISR_ALERT_Pos)            /*!< 0x00002000 */
#define I2C_ISR_ALERT                       I2C_ISR_ALERT_Msk                       /*!< SMBus alert */
#define I2C_ISR_BUSY_Pos                    (15UL)
#define I2C_ISR_BUSY_Msk                    (0x1UL << I2C_ISR_BUSY_Pos)             /*!< 0x00008000 */
#define I2C_ISR_BUSY                        I2C_ISR_BUSY_Msk                        /*!< Bus busy */
#define I2C_ISR_DIR_Pos                     (16UL)
#define I2C_ISR_DIR_Msk                     (0x1UL << I2C_ISR_DIR_Pos)              /*!< 0x00010000 */
#define I2C_ISR_DIR                         I2C_ISR_DIR_Msk                         /*!< Transfer direction (slave mode) */
#define I2C_ISR_ADDCODE_Pos                 (17UL)
#define I2C_ISR_ADDCODE_Msk                 (0x7FUL << I2C_ISR_ADDCODE_Pos)         /*!< 0x00FE0000 */
#define I2C_ISR_ADDCODE                     I2C_ISR_ADDCODE_Msk                     /*!< Address match code (slave mode) */

/******************  Bit definition for I2C_ICR register  *********************/
#define I2C_ICR_ADDRCF_Pos                  (3UL)
#define I2C_ICR_ADDRCF_Msk                  (0x1UL << I2C_ICR_ADDRCF_Pos)           /*!< 0x00000008 */
#define I2C_ICR_ADDRCF                      I2C_ICR_ADDRCF_Msk                      /*!< Address matched clear flag */
#define I2C_ICR_NACKCF_Pos                  (4UL)
#define I2C_ICR_NACKCF_Msk                  (0x1UL << I2C_ICR_NACKCF_Pos)           /*!< 0x00000010 */
#define I2C_ICR_NACKCF                      I2C_ICR_NACKCF_Msk                      /*!< NACK clear flag */
#define I2C_ICR_STOPCF_Pos                  (5UL)
#define I2C_ICR_STOPCF_Msk                  (0x1UL << I2C_ICR_STOPCF_Pos)           /*!< 0x00000020 */
#define I2C_ICR_STOPCF                      I2C_ICR_STOPCF_Msk                      /*!< STOP detection clear flag */
#define I2C_ICR_BERRCF_Pos                  (8UL)
#define I2C_ICR_BERRCF_Msk                  (0x1UL << I2C_ICR_BERRCF_Pos)           /*!< 0x00000100 */
#define I2C_ICR_BERRCF                      I2C_ICR_BERRCF_Msk                      /*!< Bus error clear flag */
#define I2C_ICR_ARLOCF_Pos                  (9UL)
#define I2C_ICR_ARLOCF_Msk                  (0x1UL << I2C_ICR_ARLOCF_Pos)           /*!< 0x00000200 */
#define I2C_ICR_ARLOCF                      I2C_ICR_ARLOCF_Msk                      /*!< Arbitration lost clear flag */
#define I2C_ICR_OVRCF_Pos                   (10UL)
#define I2C_ICR_OVRCF_Msk                   (0x1UL << I2C_ICR_OVRCF_Pos)            /*!< 0x00000400 */
#define I2C_ICR_OVRCF                       I2C_ICR_OVRCF_Msk                       /*!< Overrun/Underrun clear flag */
#define I2C_ICR_PECCF_Pos                   (11UL)
#define I2C_ICR_PECCF_Msk                   (0x1UL << I2C_ICR_PECCF_Pos)            /*!< 0x00000800 */
#define I2C_ICR_PECCF                       I2C_ICR_PECCF_Msk                       /*!< PAC error clear flag */
#define I2C_ICR_TIMOUTCF_Pos                (12UL)
#define I2C_ICR_TIMOUTCF_Msk                (0x1UL << I2C_ICR_TIMOUTCF_Pos)         /*!< 0x00001000 */
#define I2C_ICR_TIMOUTCF                    I2C_ICR_TIMOUTCF_Msk                    /*!< Timeout clear flag */
#define I2C_ICR_ALERTCF_Pos                 (13UL)
#define I2C_ICR_ALERTCF_Msk                 (0x1UL << I2C_ICR_ALERTCF_Pos)          /*!< 0x00002000 */
#define I2C_ICR_ALERTCF                     I2C_ICR_ALERTCF_Msk                     /*!< Alert clear flag */

/******************  Bit definition for I2C_PECR register  *********************/
#define I2C_PECR_PEC_Pos                    (0UL)
#define I2C_PECR_PEC_Msk                    (0xFFUL << I2C_PECR_PEC_Pos)            /*!< 0x000000FF */
#define I2C_PECR_PEC                        I2C_PECR_PEC_Msk                        /*!< PEC register */

/******************  Bit definition for I2C_RXDR register  *********************/
#define I2C_RXDR_RXDATA_Pos                 (0UL)
#define I2C_RXDR_RXDATA_Msk                 (0xFFUL << I2C_RXDR_RXDATA_Pos)         /*!< 0x000000FF */
#define I2C_RXDR_RXDATA                     I2C_RXDR_RXDATA_Msk                     /*!< 8-bit receive data */

/******************  Bit definition for I2C_TXDR register  *********************/
#define I2C_TXDR_TXDATA_Pos                 (0UL)
#define I2C_TXDR_TXDATA_Msk                 (0xFFUL << I2C_TXDR_TXDATA_Pos)         /*!< 0x000000FF */
#define I2C_TXDR_TXDATA                     I2C_TXDR_TXDATA_Msk                     /*!< 8-bit transmit data */

/******************  Bit definition for I2C_AUTOCR register  ********************/
#define I2C_AUTOCR_TCDMAEN_Pos              (6UL)
#define I2C_AUTOCR_TCDMAEN_Msk              (0x1UL << I2C_AUTOCR_TCDMAEN_Pos)       /*!< 0x00000040 */
#define I2C_AUTOCR_TCDMAEN                  I2C_AUTOCR_TCDMAEN_Msk                  /*!< DMA request enable on Transfer Complete event */
#define I2C_AUTOCR_TCRDMAEN_Pos             (7UL)
#define I2C_AUTOCR_TCRDMAEN_Msk             (0x1UL << I2C_AUTOCR_TCRDMAEN_Pos)      /*!< 0x00000080 */
#define I2C_AUTOCR_TCRDMAEN                 I2C_AUTOCR_TCRDMAEN_Msk                 /*!< DMA request enable on Transfer Complete Reload event */
#define I2C_AUTOCR_TRIGSEL_Pos              (16UL)
#define I2C_AUTOCR_TRIGSEL_Msk              (0xFUL << I2C_AUTOCR_TRIGSEL_Pos)       /*!< 0x000F0000 */
#define I2C_AUTOCR_TRIGSEL                  I2C_AUTOCR_TRIGSEL_Msk                  /*!< Trigger selection */
#define I2C_AUTOCR_TRIGPOL_Pos              (20UL)
#define I2C_AUTOCR_TRIGPOL_Msk              (0x1UL << I2C_AUTOCR_TRIGPOL_Pos)       /*!< 0x000100000 */
#define I2C_AUTOCR_TRIGPOL                  I2C_AUTOCR_TRIGPOL_Msk                  /*!< Trigger polarity */
#define I2C_AUTOCR_TRIGEN_Pos               (21UL)
#define I2C_AUTOCR_TRIGEN_Msk               (0x1UL << I2C_AUTOCR_TRIGEN_Pos)        /*!< 0x000200000 */
#define I2C_AUTOCR_TRIGEN                   I2C_AUTOCR_TRIGEN_Msk                   /*!< Trigger enable */


/******************************************************************************/
/*                                                                            */
/*                                 ICACHE                                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for ICACHE_CR register  *******************/
#define ICACHE_CR_EN_Pos                    (0UL)
#define ICACHE_CR_EN_Msk                    (0x1UL << ICACHE_CR_EN_Pos)             /*!< 0x00000001 */
#define ICACHE_CR_EN                        ICACHE_CR_EN_Msk                        /*!< Enable */
#define ICACHE_CR_CACHEINV_Pos              (1UL)
#define ICACHE_CR_CACHEINV_Msk              (0x1UL << ICACHE_CR_CACHEINV_Pos)       /*!< 0x00000002 */
#define ICACHE_CR_CACHEINV                  ICACHE_CR_CACHEINV_Msk                  /*!< Cache invalidation */
#define ICACHE_CR_WAYSEL_Pos                (2UL)
#define ICACHE_CR_WAYSEL_Msk                (0x1UL << ICACHE_CR_WAYSEL_Pos)         /*!< 0x00000004 */
#define ICACHE_CR_WAYSEL                    ICACHE_CR_WAYSEL_Msk                    /*!< Ways selection */
#define ICACHE_CR_HITMEN_Pos                (16UL)
#define ICACHE_CR_HITMEN_Msk                (0x1UL << ICACHE_CR_HITMEN_Pos)         /*!< 0x00010000 */
#define ICACHE_CR_HITMEN                    ICACHE_CR_HITMEN_Msk                    /*!< Hit monitor enable */
#define ICACHE_CR_MISSMEN_Pos               (17UL)
#define ICACHE_CR_MISSMEN_Msk               (0x1UL << ICACHE_CR_MISSMEN_Pos)        /*!< 0x00020000 */
#define ICACHE_CR_MISSMEN                   ICACHE_CR_MISSMEN_Msk                   /*!< Miss monitor enable */
#define ICACHE_CR_HITMRST_Pos               (18UL)
#define ICACHE_CR_HITMRST_Msk               (0x1UL << ICACHE_CR_HITMRST_Pos)        /*!< 0x00040000 */
#define ICACHE_CR_HITMRST                   ICACHE_CR_HITMRST_Msk                   /*!< Hit monitor reset */
#define ICACHE_CR_MISSMRST_Pos              (19UL)
#define ICACHE_CR_MISSMRST_Msk              (0x1UL << ICACHE_CR_MISSMRST_Pos)       /*!< 0x00080000 */
#define ICACHE_CR_MISSMRST                  ICACHE_CR_MISSMRST_Msk                  /*!< Miss monitor reset */

/******************  Bit definition for ICACHE_SR register  *******************/
#define ICACHE_SR_BUSYF_Pos                 (0UL)
#define ICACHE_SR_BUSYF_Msk                 (0x1UL << ICACHE_SR_BUSYF_Pos)          /*!< 0x00000001 */
#define ICACHE_SR_BUSYF                     ICACHE_SR_BUSYF_Msk                     /*!< Busy flag */
#define ICACHE_SR_BSYENDF_Pos               (1UL)
#define ICACHE_SR_BSYENDF_Msk               (0x1UL << ICACHE_SR_BSYENDF_Pos)        /*!< 0x00000002 */
#define ICACHE_SR_BSYENDF                   ICACHE_SR_BSYENDF_Msk                   /*!< Busy end flag */
#define ICACHE_SR_ERRF_Pos                  (2UL)
#define ICACHE_SR_ERRF_Msk                  (0x1UL << ICACHE_SR_ERRF_Pos)           /*!< 0x00000004 */
#define ICACHE_SR_ERRF                      ICACHE_SR_ERRF_Msk                      /*!< Cache error flag */

/******************  Bit definition for ICACHE_IER register  ******************/
#define ICACHE_IER_BSYENDIE_Pos             (1UL)
#define ICACHE_IER_BSYENDIE_Msk             (0x1UL << ICACHE_IER_BSYENDIE_Pos)      /*!< 0x00000002 */
#define ICACHE_IER_BSYENDIE                 ICACHE_IER_BSYENDIE_Msk                 /*!< Busy end interrupt enable */
#define ICACHE_IER_ERRIE_Pos                (2UL)
#define ICACHE_IER_ERRIE_Msk                (0x1UL << ICACHE_IER_ERRIE_Pos)         /*!< 0x00000004 */
#define ICACHE_IER_ERRIE                    ICACHE_IER_ERRIE_Msk                    /*!< Cache error interrupt enable */

/******************  Bit definition for ICACHE_FCR register  ******************/
#define ICACHE_FCR_CBSYENDF_Pos             (1UL)
#define ICACHE_FCR_CBSYENDF_Msk             (0x1UL << ICACHE_FCR_CBSYENDF_Pos)      /*!< 0x00000002 */
#define ICACHE_FCR_CBSYENDF                 ICACHE_FCR_CBSYENDF_Msk                 /*!< Busy end flag clear */
#define ICACHE_FCR_CERRF_Pos                (2UL)
#define ICACHE_FCR_CERRF_Msk                (0x1UL << ICACHE_FCR_CERRF_Pos)         /*!< 0x00000004 */
#define ICACHE_FCR_CERRF                    ICACHE_FCR_CERRF_Msk                    /*!< Cache error flag clear */

/******************  Bit definition for ICACHE_HMONR register  ****************/
#define ICACHE_HMONR_HITMON_Pos             (0UL)
#define ICACHE_HMONR_HITMON_Msk             (0xFFFFFFFFUL << ICACHE_HMONR_HITMON_Pos) /*!< 0xFFFFFFFF */
#define ICACHE_HMONR_HITMON                 ICACHE_HMONR_HITMON_Msk                 /*!< Cache hit monitor register */

/******************  Bit definition for ICACHE_MMONR register  ****************/
#define ICACHE_MMONR_MISSMON_Pos            (0UL)
#define ICACHE_MMONR_MISSMON_Msk            (0xFFFFUL << ICACHE_MMONR_MISSMON_Pos)  /*!< 0x0000FFFF */
#define ICACHE_MMONR_MISSMON                ICACHE_MMONR_MISSMON_Msk                /*!< Cache miss monitor register */

/******************  Bit definition for ICACHE_CRRx register  *****************/
#define ICACHE_CRRx_BASEADDR_Pos            (0UL)
#define ICACHE_CRRx_BASEADDR_Msk            (0xFFUL << ICACHE_CRRx_BASEADDR_Pos)    /*!< 0x000000FF */
#define ICACHE_CRRx_BASEADDR                ICACHE_CRRx_BASEADDR_Msk                /*!< Base address of region X to remap */
#define ICACHE_CRRx_RSIZE_Pos               (9UL)
#define ICACHE_CRRx_RSIZE_Msk               (0x7UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000E00 */
#define ICACHE_CRRx_RSIZE                   ICACHE_CRRx_RSIZE_Msk                   /*!< Region X size */
#define ICACHE_CRRx_RSIZE_0                 (0x1UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000200 */
#define ICACHE_CRRx_RSIZE_1                 (0x2UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000400 */
#define ICACHE_CRRx_RSIZE_2                 (0x4UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000800 */
#define ICACHE_CRRx_REN_Pos                 (15UL)
#define ICACHE_CRRx_REN_Msk                 (0x1UL << ICACHE_CRRx_REN_Pos)          /*!< 0x00008000 */
#define ICACHE_CRRx_REN                     ICACHE_CRRx_REN_Msk                     /*!< Region X enable */
#define ICACHE_CRRx_REMAPADDR_Pos           (16UL)
#define ICACHE_CRRx_REMAPADDR_Msk           (0x7FFUL << ICACHE_CRRx_REMAPADDR_Pos)  /*!< 0x07FF0000 */
#define ICACHE_CRRx_REMAPADDR               ICACHE_CRRx_REMAPADDR_Msk               /*!< Remap address of Region X to be remapped */
#define ICACHE_CRRx_MSTSEL_Pos              (28UL)
#define ICACHE_CRRx_MSTSEL_Msk              (0x1UL << ICACHE_CRRx_MSTSEL_Pos)       /*!< 0x10000000 */
#define ICACHE_CRRx_MSTSEL                  ICACHE_CRRx_MSTSEL_Msk                  /*!< Region X AHB cache master selection */
#define ICACHE_CRRx_HBURST_Pos              (31UL)
#define ICACHE_CRRx_HBURST_Msk              (0x1UL << ICACHE_CRRx_HBURST_Pos)       /*!< 0x80000000 */
#define ICACHE_CRRx_HBURST                  ICACHE_CRRx_HBURST_Msk                  /*!< Region X output burst type */


/******************************************************************************/
/*                                                                            */
/*                           Independent WATCHDOG                             */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for IWDG_KR register  ********************/
#define IWDG_KR_KEY_Pos                     (0UL)
#define IWDG_KR_KEY_Msk                     (0xFFFFUL << IWDG_KR_KEY_Pos)           /*!< 0x0000FFFF */
#define IWDG_KR_KEY                         IWDG_KR_KEY_Msk                         /*!<Key value (write only, read 0000h)  */

/*******************  Bit definition for IWDG_PR register  ********************/
#define IWDG_PR_PR_Pos                      (0UL)
#define IWDG_PR_PR_Msk                      (0xFUL << IWDG_PR_PR_Pos)               /*!< 0x0000000F */
#define IWDG_PR_PR                          IWDG_PR_PR_Msk                          /*!<PR[3:0] (Prescaler divider)         */
#define IWDG_PR_PR_0                        (0x1UL << IWDG_PR_PR_Pos)               /*!< 0x00000001 */
#define IWDG_PR_PR_1                        (0x2UL << IWDG_PR_PR_Pos)               /*!< 0x00000002 */
#define IWDG_PR_PR_2                        (0x4UL << IWDG_PR_PR_Pos)               /*!< 0x00000004 */
#define IWDG_PR_PR_3                        (0x8UL << IWDG_PR_PR_Pos)               /*!< 0x00000008 */

/*******************  Bit definition for IWDG_RLR register  *******************/
#define IWDG_RLR_RL_Pos                     (0UL)
#define IWDG_RLR_RL_Msk                     (0xFFFUL << IWDG_RLR_RL_Pos)            /*!< 0x00000FFF */
#define IWDG_RLR_RL                         IWDG_RLR_RL_Msk                         /*!<Watchdog counter reload value        */

/*******************  Bit definition for IWDG_SR register  ********************/
#define IWDG_SR_PVU_Pos                     (0UL)
#define IWDG_SR_PVU_Msk                     (0x1UL << IWDG_SR_PVU_Pos)              /*!< 0x00000001 */
#define IWDG_SR_PVU                         IWDG_SR_PVU_Msk                         /*!< Watchdog prescaler value update */
#define IWDG_SR_RVU_Pos                     (1UL)
#define IWDG_SR_RVU_Msk                     (0x1UL << IWDG_SR_RVU_Pos)              /*!< 0x00000002 */
#define IWDG_SR_RVU                         IWDG_SR_RVU_Msk                         /*!< Watchdog counter reload value update */
#define IWDG_SR_WVU_Pos                     (2UL)
#define IWDG_SR_WVU_Msk                     (0x1UL << IWDG_SR_WVU_Pos)              /*!< 0x00000004 */
#define IWDG_SR_WVU                         IWDG_SR_WVU_Msk                         /*!< Watchdog counter window value update */
#define IWDG_SR_EWU_Pos                     (3UL)
#define IWDG_SR_EWU_Msk                     (0x1UL << IWDG_SR_EWU_Pos)              /*!< 0x00000008 */
#define IWDG_SR_EWU                         IWDG_SR_EWU_Msk                         /*!< Watchdog interrupt comparator value update */
#define IWDG_SR_ONF_Pos                     (8UL)
#define IWDG_SR_ONF_Msk                     (0x1UL << IWDG_SR_ONF_Pos)              /*!< 0x000001000 */
#define IWDG_SR_ONF                         IWDG_SR_ONF_Msk                         /*!< Watchdog enable status bit */
#define IWDG_SR_EWIF_Pos                    (14UL)
#define IWDG_SR_EWIF_Msk                    (0x1UL << IWDG_SR_EWIF_Pos)             /*!< 0x00000100 */
#define IWDG_SR_EWIF                        IWDG_SR_EWIF_Msk                        /*!< Watchdog early interrupt flag */

/******************  Bit definition for IWDG_WINR register  *******************/
#define IWDG_WINR_WIN_Pos                   (0UL)
#define IWDG_WINR_WIN_Msk                   (0xFFFUL << IWDG_WINR_WIN_Pos)          /*!< 0x00000FFF */
#define IWDG_WINR_WIN                       IWDG_WINR_WIN_Msk                       /*!< Watchdog counter window value */

/******************  Bit definition for IWDG_EWCR register  *******************/
#define IWDG_EWCR_EWIT_Pos                  (0UL)
#define IWDG_EWCR_EWIT_Msk                  (0xFFFUL << IWDG_EWCR_EWIT_Pos)         /*!< 0x00000FFF */
#define IWDG_EWCR_EWIT                      IWDG_EWCR_EWIT_Msk                      /*!< Watchdog early wakeup comparator value */
#define IWDG_EWCR_EWIC_Pos                  (14UL)
#define IWDG_EWCR_EWIC_Msk                  (0x1UL << IWDG_EWCR_EWIC_Pos)           /*!< 0x00000FFF */
#define IWDG_EWCR_EWIC                      IWDG_EWCR_EWIC_Msk                      /*!< Watchdog early wakeup comparator value */
#define IWDG_EWCR_EWIE_Pos                  (15UL)
#define IWDG_EWCR_EWIE_Msk                  (0x1UL << IWDG_EWCR_EWIE_Pos)           /*!< 0x00000FFF */
#define IWDG_EWCR_EWIE                      IWDG_EWCR_EWIE_Msk                      /*!< Watchdog early wakeup comparator value */


/******************************************************************************/
/*                                                                            */
/*                         Low Power Timer (LPTIM)                            */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for LPTIM_ISR register  *******************/
#define LPTIM_ISR_CC1IF_Pos                 (0UL)
#define LPTIM_ISR_CC1IF_Msk                 (0x1UL << LPTIM_ISR_CC1IF_Pos)          /*!< 0x00000001 */
#define LPTIM_ISR_CC1IF                     LPTIM_ISR_CC1IF_Msk                     /*!< Capture/Compare 1 interrupt flag */
#define LPTIM_ISR_ARRM_Pos                  (1UL)
#define LPTIM_ISR_ARRM_Msk                  (0x1UL << LPTIM_ISR_ARRM_Pos)           /*!< 0x00000002 */
#define LPTIM_ISR_ARRM                      LPTIM_ISR_ARRM_Msk                      /*!< Autoreload match */
#define LPTIM_ISR_EXTTRIG_Pos               (2UL)
#define LPTIM_ISR_EXTTRIG_Msk               (0x1UL << LPTIM_ISR_EXTTRIG_Pos)        /*!< 0x00000004 */
#define LPTIM_ISR_EXTTRIG                   LPTIM_ISR_EXTTRIG_Msk                   /*!< External trigger edge event */
#define LPTIM_ISR_CMP1OK_Pos                (3UL)
#define LPTIM_ISR_CMP1OK_Msk                (0x1UL << LPTIM_ISR_CMP1OK_Pos)         /*!< 0x00000008 */
#define LPTIM_ISR_CMP1OK                    LPTIM_ISR_CMP1OK_Msk                    /*!< Compare register 1 update OK */
#define LPTIM_ISR_ARROK_Pos                 (4UL)
#define LPTIM_ISR_ARROK_Msk                 (0x1UL << LPTIM_ISR_ARROK_Pos)          /*!< 0x00000010 */
#define LPTIM_ISR_ARROK                     LPTIM_ISR_ARROK_Msk                     /*!< Autoreload register update OK */
#define LPTIM_ISR_UP_Pos                    (5UL)
#define LPTIM_ISR_UP_Msk                    (0x1UL << LPTIM_ISR_UP_Pos)             /*!< 0x00000020 */
#define LPTIM_ISR_UP                        LPTIM_ISR_UP_Msk                        /*!< Counter direction change down to up */
#define LPTIM_ISR_DOWN_Pos                  (6UL)
#define LPTIM_ISR_DOWN_Msk                  (0x1UL << LPTIM_ISR_DOWN_Pos)           /*!< 0x00000040 */
#define LPTIM_ISR_DOWN                      LPTIM_ISR_DOWN_Msk                      /*!< Counter direction change up to down */
#define LPTIM_ISR_UE_Pos                    (7UL)
#define LPTIM_ISR_UE_Msk                    (0x1UL << LPTIM_ISR_UE_Pos)             /*!< 0x00000080 */
#define LPTIM_ISR_UE                        LPTIM_ISR_UE_Msk                        /*!< Update event */
#define LPTIM_ISR_REPOK_Pos                 (8UL)
#define LPTIM_ISR_REPOK_Msk                 (0x1UL << LPTIM_ISR_REPOK_Pos)          /*!< 0x00000100 */
#define LPTIM_ISR_REPOK                     LPTIM_ISR_REPOK_Msk                     /*!< Repetition register update OK */
#define LPTIM_ISR_CC2IF_Pos                 (9UL)
#define LPTIM_ISR_CC2IF_Msk                 (0x1UL << LPTIM_ISR_CC2IF_Pos)          /*!< 0x00000200 */
#define LPTIM_ISR_CC2IF                     LPTIM_ISR_CC2IF_Msk                     /*!< Capture/Compare 2 interrupt flag */
#define LPTIM_ISR_CC1OF_Pos                 (12UL)
#define LPTIM_ISR_CC1OF_Msk                 (0x1UL << LPTIM_ISR_CC1OF_Pos)          /*!< 0x00001000 */
#define LPTIM_ISR_CC1OF                     LPTIM_ISR_CC1OF_Msk                     /*!< Capture/Compare 1 over-capture flag */
#define LPTIM_ISR_CC2OF_Pos                 (13UL)
#define LPTIM_ISR_CC2OF_Msk                 (0x1UL << LPTIM_ISR_CC2OF_Pos)          /*!< 0x00002000 */
#define LPTIM_ISR_CC2OF                     LPTIM_ISR_CC2OF_Msk                     /*!< Capture/Compare 2 over-capture flag */
#define LPTIM_ISR_CMP2OK_Pos                (19UL)
#define LPTIM_ISR_CMP2OK_Msk                (0x1UL << LPTIM_ISR_CMP2OK_Pos)         /*!< 0x00080000 */
#define LPTIM_ISR_CMP2OK                    LPTIM_ISR_CMP2OK_Msk                    /*!< Compare register 2 update OK */
#define LPTIM_ISR_DIEROK_Pos                (24UL)
#define LPTIM_ISR_DIEROK_Msk                (0x1UL << LPTIM_ISR_DIEROK_Pos)         /*!< 0x01000000 */
#define LPTIM_ISR_DIEROK                    LPTIM_ISR_DIEROK_Msk                    /*!< DMA & interrupt enable update OK */

/******************  Bit definition for LPTIM_ICR register  *******************/
#define LPTIM_ICR_CC1CF_Pos                 (0UL)
#define LPTIM_ICR_CC1CF_Msk                 (0x1UL << LPTIM_ICR_CC1CF_Pos)          /*!< 0x00000001 */
#define LPTIM_ICR_CC1CF                     LPTIM_ICR_CC1CF_Msk                     /*!< Capture/Compare 1 clear flag  */
#define LPTIM_ICR_ARRMCF_Pos                (1UL)
#define LPTIM_ICR_ARRMCF_Msk                (0x1UL << LPTIM_ICR_ARRMCF_Pos)         /*!< 0x00000002 */
#define LPTIM_ICR_ARRMCF                    LPTIM_ICR_ARRMCF_Msk                    /*!< Autoreload match clear flag */
#define LPTIM_ICR_EXTTRIGCF_Pos             (2UL)
#define LPTIM_ICR_EXTTRIGCF_Msk             (0x1UL << LPTIM_ICR_EXTTRIGCF_Pos)      /*!< 0x00000004 */
#define LPTIM_ICR_EXTTRIGCF                 LPTIM_ICR_EXTTRIGCF_Msk                 /*!< External trigger edge event clear flag */
#define LPTIM_ICR_CMP1OKCF_Pos              (3UL)
#define LPTIM_ICR_CMP1OKCF_Msk              (0x1UL << LPTIM_ICR_CMP1OKCF_Pos)       /*!< 0x00000008 */
#define LPTIM_ICR_CMP1OKCF                  LPTIM_ICR_CMP1OKCF_Msk                  /*!< Compare register 1 update OK clear flag */
#define LPTIM_ICR_ARROKCF_Pos               (4UL)
#define LPTIM_ICR_ARROKCF_Msk               (0x1UL << LPTIM_ICR_ARROKCF_Pos)        /*!< 0x00000010 */
#define LPTIM_ICR_ARROKCF                   LPTIM_ICR_ARROKCF_Msk                   /*!< Autoreload register update OK clear flag */
#define LPTIM_ICR_UPCF_Pos                  (5UL)
#define LPTIM_ICR_UPCF_Msk                  (0x1UL << LPTIM_ICR_UPCF_Pos)           /*!< 0x00000020 */
#define LPTIM_ICR_UPCF                      LPTIM_ICR_UPCF_Msk                      /*!< Counter direction change down to up clear flag */
#define LPTIM_ICR_DOWNCF_Pos                (6UL)
#define LPTIM_ICR_DOWNCF_Msk                (0x1UL << LPTIM_ICR_DOWNCF_Pos)         /*!< 0x00000040 */
#define LPTIM_ICR_DOWNCF                    LPTIM_ICR_DOWNCF_Msk                    /*!< Counter direction change up to down clear flag */
#define LPTIM_ICR_UECF_Pos                  (7UL)
#define LPTIM_ICR_UECF_Msk                  (0x1UL << LPTIM_ICR_UECF_Pos)           /*!< 0x00000080 */
#define LPTIM_ICR_UECF                      LPTIM_ICR_UECF_Msk                      /*!< Update event clear flag */
#define LPTIM_ICR_REPOKCF_Pos               (8UL)
#define LPTIM_ICR_REPOKCF_Msk               (0x1UL << LPTIM_ICR_REPOKCF_Pos)        /*!< 0x00000100 */
#define LPTIM_ICR_REPOKCF                   LPTIM_ICR_REPOKCF_Msk                   /*!< Repetition register update OK clear flag */
#define LPTIM_ICR_CC2CF_Pos                 (9UL)
#define LPTIM_ICR_CC2CF_Msk                 (0x1UL << LPTIM_ICR_CC2CF_Pos)          /*!< 0x00000200 */
#define LPTIM_ICR_CC2CF                     LPTIM_ICR_CC2CF_Msk                     /*!< Capture/Compare 2 clear flag  */
#define LPTIM_ICR_CC1OCF_Pos                (12UL)
#define LPTIM_ICR_CC1OCF_Msk                (0x1UL << LPTIM_ICR_CC1OCF_Pos)         /*!< 0x00001000 */
#define LPTIM_ICR_CC1OCF                    LPTIM_ICR_CC1OCF_Msk                    /*!< Capture/Compare 1 over-capture clear flag */
#define LPTIM_ICR_CC2OCF_Pos                (13UL)
#define LPTIM_ICR_CC2OCF_Msk                (0x1UL << LPTIM_ICR_CC2OCF_Pos)         /*!< 0x00002000 */
#define LPTIM_ICR_CC2OCF                    LPTIM_ICR_CC2OCF_Msk                    /*!< Capture/Compare 2 over-capture clear flag */
#define LPTIM_ICR_CMP2OKCF_Pos              (19UL)
#define LPTIM_ICR_CMP2OKCF_Msk              (0x1UL << LPTIM_ICR_CMP2OKCF_Pos)       /*!< 0x00080000 */
#define LPTIM_ICR_CMP2OKCF                  LPTIM_ICR_CMP2OKCF_Msk                  /*!< Compare register 2 update OK clear flag */
#define LPTIM_ICR_DIEROKCF_Pos              (24UL)
#define LPTIM_ICR_DIEROKCF_Msk              (0x1UL << LPTIM_ICR_DIEROKCF_Pos)       /*!< 0x01000000 */
#define LPTIM_ICR_DIEROKCF                  LPTIM_ICR_DIEROKCF_Msk                  /*!< DMA & interrupt enable update OK clear flag */

/******************  Bit definition for LPTIM_DIER register *******************/
#define LPTIM_DIER_CC1IE_Pos                (0UL)
#define LPTIM_DIER_CC1IE_Msk                (0x1UL << LPTIM_DIER_CC1IE_Pos)         /*!< 0x00000001 */
#define LPTIM_DIER_CC1IE                    LPTIM_DIER_CC1IE_Msk                    /*!< Compare/Compare interrupt enable */
#define LPTIM_DIER_ARRMIE_Pos               (1UL)
#define LPTIM_DIER_ARRMIE_Msk               (0x1UL << LPTIM_DIER_ARRMIE_Pos)        /*!< 0x00000002 */
#define LPTIM_DIER_ARRMIE                   LPTIM_DIER_ARRMIE_Msk                   /*!< Autoreload match interrupt enable */
#define LPTIM_DIER_EXTTRIGIE_Pos            (2UL)
#define LPTIM_DIER_EXTTRIGIE_Msk            (0x1UL << LPTIM_DIER_EXTTRIGIE_Pos)     /*!< 0x00000004 */
#define LPTIM_DIER_EXTTRIGIE                LPTIM_DIER_EXTTRIGIE_Msk                /*!< External trigger edge event interrupt enable */
#define LPTIM_DIER_CMP1OKIE_Pos             (3UL)
#define LPTIM_DIER_CMP1OKIE_Msk             (0x1UL << LPTIM_DIER_CMP1OKIE_Pos)      /*!< 0x00000008 */
#define LPTIM_DIER_CMP1OKIE                 LPTIM_DIER_CMP1OKIE_Msk                 /*!< Compare register 1 update OK interrupt enable */
#define LPTIM_DIER_ARROKIE_Pos              (4UL)
#define LPTIM_DIER_ARROKIE_Msk              (0x1UL << LPTIM_DIER_ARROKIE_Pos)       /*!< 0x00000010 */
#define LPTIM_DIER_ARROKIE                  LPTIM_DIER_ARROKIE_Msk                  /*!< Autoreload register update OK interrupt enable */
#define LPTIM_DIER_UPIE_Pos                 (5UL)
#define LPTIM_DIER_UPIE_Msk                 (0x1UL << LPTIM_DIER_UPIE_Pos)          /*!< 0x00000020 */
#define LPTIM_DIER_UPIE                     LPTIM_DIER_UPIE_Msk                     /*!< Counter direction change down to up interrupt enable */
#define LPTIM_DIER_DOWNIE_Pos               (6UL)
#define LPTIM_DIER_DOWNIE_Msk               (0x1UL << LPTIM_DIER_DOWNIE_Pos)        /*!< 0x00000040 */
#define LPTIM_DIER_DOWNIE                   LPTIM_DIER_DOWNIE_Msk                   /*!< Counter direction change up to down interrupt enable */
#define LPTIM_DIER_UEIE_Pos                 (7UL)
#define LPTIM_DIER_UEIE_Msk                 (0x1UL << LPTIM_DIER_UEIE_Pos)          /*!< 0x00000080 */
#define LPTIM_DIER_UEIE                     LPTIM_DIER_UEIE_Msk                     /*!< Update event interrupt enable */
#define LPTIM_DIER_REPOKIE_Pos              (8UL)
#define LPTIM_DIER_REPOKIE_Msk              (0x1UL << LPTIM_DIER_REPOKIE_Pos)       /*!< 0x00000100 */
#define LPTIM_DIER_REPOKIE                  LPTIM_DIER_REPOKIE_Msk                  /*!< Repetition register update OK interrupt enable */
#define LPTIM_DIER_CC2IE_Pos                (9UL)
#define LPTIM_DIER_CC2IE_Msk                (0x1UL << LPTIM_DIER_CC2IE_Pos)         /*!< 0x00000200 */
#define LPTIM_DIER_CC2IE                    LPTIM_DIER_CC2IE_Msk                    /*!< Capture/Compare 2 interrupt interrupt enable */
#define LPTIM_DIER_CC1OIE_Pos               (12UL)
#define LPTIM_DIER_CC1OIE_Msk               (0x1UL << LPTIM_DIER_CC1OIE_Pos)        /*!< 0x00001000 */
#define LPTIM_DIER_CC1OIE                   LPTIM_DIER_CC1OIE_Msk                   /*!< Capture/Compare 1 over-capture interrupt enable */
#define LPTIM_DIER_CC2OIE_Pos               (13UL)
#define LPTIM_DIER_CC2OIE_Msk               (0x1UL << LPTIM_DIER_CC2OIE_Pos)        /*!< 0x00002000 */
#define LPTIM_DIER_CC2OIE                   LPTIM_DIER_CC2OIE_Msk                   /*!< Capture/Compare 2 over-capture interrupt enable */
#define LPTIM_DIER_CC1DE_Pos                (16UL)
#define LPTIM_DIER_CC1DE_Msk                (0x1UL << LPTIM_DIER_CC1DE_Pos)         /*!< 0x00010000 */
#define LPTIM_DIER_CC1DE                    LPTIM_DIER_CC1DE_Msk                    /*!< Capture/Compare 1 DMA request enable */
#define LPTIM_DIER_CMP2OKIE_Pos             (19UL)
#define LPTIM_DIER_CMP2OKIE_Msk             (0x1UL << LPTIM_DIER_CMP2OKIE_Pos)      /*!< 0x00080000 */
#define LPTIM_DIER_CMP2OKIE                 LPTIM_DIER_CMP2OKIE_Msk                 /*!< Compare register 2 update OK interrupt enable */
#define LPTIM_DIER_UEDE_Pos                 (23UL)
#define LPTIM_DIER_UEDE_Msk                 (0x1UL << LPTIM_DIER_UEDE_Pos)          /*!< 0x00800000 */
#define LPTIM_DIER_UEDE                     LPTIM_DIER_UEDE_Msk                     /*!< Update event DMA request enable */
#define LPTIM_DIER_CC2DE_Pos                (25UL)
#define LPTIM_DIER_CC2DE_Msk                (0x1UL << LPTIM_DIER_CC2DE_Pos)         /*!< 0x02000000 */
#define LPTIM_DIER_CC2DE                    LPTIM_DIER_CC2DE_Msk                    /*!< Capture/Compare 2 DMA request enable */

/******************  Bit definition for LPTIM_CFGR register *******************/
#define LPTIM_CFGR_CKSEL_Pos                (0UL)
#define LPTIM_CFGR_CKSEL_Msk                (0x1UL << LPTIM_CFGR_CKSEL_Pos)         /*!< 0x00000001 */
#define LPTIM_CFGR_CKSEL                    LPTIM_CFGR_CKSEL_Msk                    /*!< Clock selector */
#define LPTIM_CFGR_CKPOL_Pos                (1UL)
#define LPTIM_CFGR_CKPOL_Msk                (0x3UL << LPTIM_CFGR_CKPOL_Pos)         /*!< 0x00000006 */
#define LPTIM_CFGR_CKPOL                    LPTIM_CFGR_CKPOL_Msk                    /*!< CKPOL[1:0] bits (Clock polarity) */
#define LPTIM_CFGR_CKPOL_0                  (0x1UL << LPTIM_CFGR_CKPOL_Pos)         /*!< 0x00000002 */
#define LPTIM_CFGR_CKPOL_1                  (0x2UL << LPTIM_CFGR_CKPOL_Pos)         /*!< 0x00000004 */
#define LPTIM_CFGR_CKFLT_Pos                (3UL)
#define LPTIM_CFGR_CKFLT_Msk                (0x3UL << LPTIM_CFGR_CKFLT_Pos)         /*!< 0x00000018 */
#define LPTIM_CFGR_CKFLT                    LPTIM_CFGR_CKFLT_Msk                    /*!< CKFLT[1:0] bits (Configurable digital filter for external clock) */
#define LPTIM_CFGR_CKFLT_0                  (0x1UL << LPTIM_CFGR_CKFLT_Pos)         /*!< 0x00000008 */
#define LPTIM_CFGR_CKFLT_1                  (0x2UL << LPTIM_CFGR_CKFLT_Pos)         /*!< 0x00000010 */
#define LPTIM_CFGR_TRGFLT_Pos               (6UL)
#define LPTIM_CFGR_TRGFLT_Msk               (0x3UL << LPTIM_CFGR_TRGFLT_Pos)        /*!< 0x000000C0 */
#define LPTIM_CFGR_TRGFLT                   LPTIM_CFGR_TRGFLT_Msk                   /*!< TRGFLT[1:0] bits (Configurable digital filter for trigger) */
#define LPTIM_CFGR_TRGFLT_0                 (0x1UL << LPTIM_CFGR_TRGFLT_Pos)        /*!< 0x00000040 */
#define LPTIM_CFGR_TRGFLT_1                 (0x2UL << LPTIM_CFGR_TRGFLT_Pos)        /*!< 0x00000080 */
#define LPTIM_CFGR_PRESC_Pos                (9UL)
#define LPTIM_CFGR_PRESC_Msk                (0x7UL << LPTIM_CFGR_PRESC_Pos)         /*!< 0x00000E00 */
#define LPTIM_CFGR_PRESC                    LPTIM_CFGR_PRESC_Msk                    /*!< PRESC[2:0] bits (Clock prescaler) */
#define LPTIM_CFGR_PRESC_0                  (0x1UL << LPTIM_CFGR_PRESC_Pos)         /*!< 0x00000200 */
#define LPTIM_CFGR_PRESC_1                  (0x2UL << LPTIM_CFGR_PRESC_Pos)         /*!< 0x00000400 */
#define LPTIM_CFGR_PRESC_2                  (0x4UL << LPTIM_CFGR_PRESC_Pos)         /*!< 0x00000800 */
#define LPTIM_CFGR_TRIGSEL_Pos              (13UL)
#define LPTIM_CFGR_TRIGSEL_Msk              (0x7UL << LPTIM_CFGR_TRIGSEL_Pos)       /*!< 0x0000E000 */
#define LPTIM_CFGR_TRIGSEL                  LPTIM_CFGR_TRIGSEL_Msk                  /*!< TRIGSEL[2:0]] bits (Trigger selector) */
#define LPTIM_CFGR_TRIGSEL_0                (0x1UL << LPTIM_CFGR_TRIGSEL_Pos)       /*!< 0x00002000 */
#define LPTIM_CFGR_TRIGSEL_1                (0x2UL << LPTIM_CFGR_TRIGSEL_Pos)       /*!< 0x00004000 */
#define LPTIM_CFGR_TRIGSEL_2                (0x4UL << LPTIM_CFGR_TRIGSEL_Pos)       /*!< 0x00008000 */
#define LPTIM_CFGR_TRIGEN_Pos               (17UL)
#define LPTIM_CFGR_TRIGEN_Msk               (0x3UL << LPTIM_CFGR_TRIGEN_Pos)        /*!< 0x00060000 */
#define LPTIM_CFGR_TRIGEN                   LPTIM_CFGR_TRIGEN_Msk                   /*!< TRIGEN[1:0] bits (Trigger enable and polarity) */
#define LPTIM_CFGR_TRIGEN_0                 (0x1UL << LPTIM_CFGR_TRIGEN_Pos)        /*!< 0x00020000 */
#define LPTIM_CFGR_TRIGEN_1                 (0x2UL << LPTIM_CFGR_TRIGEN_Pos)        /*!< 0x00040000 */
#define LPTIM_CFGR_TIMOUT_Pos               (19UL)
#define LPTIM_CFGR_TIMOUT_Msk               (0x1UL << LPTIM_CFGR_TIMOUT_Pos)        /*!< 0x00080000 */
#define LPTIM_CFGR_TIMOUT                   LPTIM_CFGR_TIMOUT_Msk                   /*!< Timout enable */
#define LPTIM_CFGR_WAVE_Pos                 (20UL)
#define LPTIM_CFGR_WAVE_Msk                 (0x1UL << LPTIM_CFGR_WAVE_Pos)          /*!< 0x00100000 */
#define LPTIM_CFGR_WAVE                     LPTIM_CFGR_WAVE_Msk                     /*!< Waveform shape */
#define LPTIM_CFGR_PRELOAD_Pos              (22UL)
#define LPTIM_CFGR_PRELOAD_Msk              (0x1UL << LPTIM_CFGR_PRELOAD_Pos)       /*!< 0x00400000 */
#define LPTIM_CFGR_PRELOAD                  LPTIM_CFGR_PRELOAD_Msk                  /*!< Reg update mode */
#define LPTIM_CFGR_COUNTMODE_Pos            (23UL)
#define LPTIM_CFGR_COUNTMODE_Msk            (0x1UL << LPTIM_CFGR_COUNTMODE_Pos)     /*!< 0x00800000 */
#define LPTIM_CFGR_COUNTMODE                LPTIM_CFGR_COUNTMODE_Msk                /*!< Counter mode enable */
#define LPTIM_CFGR_ENC_Pos                  (24UL)
#define LPTIM_CFGR_ENC_Msk                  (0x1UL << LPTIM_CFGR_ENC_Pos)           /*!< 0x01000000 */
#define LPTIM_CFGR_ENC                      LPTIM_CFGR_ENC_Msk                      /*!< Encoder mode enable */

/******************  Bit definition for LPTIM_CR register  ********************/
#define LPTIM_CR_ENABLE_Pos                 (0UL)
#define LPTIM_CR_ENABLE_Msk                 (0x1UL << LPTIM_CR_ENABLE_Pos)          /*!< 0x00000001 */
#define LPTIM_CR_ENABLE                     LPTIM_CR_ENABLE_Msk                     /*!< LPTIMer enable */
#define LPTIM_CR_SNGSTRT_Pos                (1UL)
#define LPTIM_CR_SNGSTRT_Msk                (0x1UL << LPTIM_CR_SNGSTRT_Pos)         /*!< 0x00000002 */
#define LPTIM_CR_SNGSTRT                    LPTIM_CR_SNGSTRT_Msk                    /*!< Timer start in single mode */
#define LPTIM_CR_CNTSTRT_Pos                (2UL)
#define LPTIM_CR_CNTSTRT_Msk                (0x1UL << LPTIM_CR_CNTSTRT_Pos)         /*!< 0x00000004 */
#define LPTIM_CR_CNTSTRT                    LPTIM_CR_CNTSTRT_Msk                    /*!< Timer start in continuous mode */
#define LPTIM_CR_COUNTRST_Pos               (3UL)
#define LPTIM_CR_COUNTRST_Msk               (0x1UL << LPTIM_CR_COUNTRST_Pos)        /*!< 0x00000008 */
#define LPTIM_CR_COUNTRST                   LPTIM_CR_COUNTRST_Msk                   /*!< Timer Counter reset in synchronous mode*/
#define LPTIM_CR_RSTARE_Pos                 (4UL)
#define LPTIM_CR_RSTARE_Msk                 (0x1UL << LPTIM_CR_RSTARE_Pos)          /*!< 0x00000010 */
#define LPTIM_CR_RSTARE                     LPTIM_CR_RSTARE_Msk                     /*!< Timer Counter reset after read enable (asynchronously)*/


/******************  Bit definition for LPTIM_CCR1 register  ******************/
#define LPTIM_CCR1_CCR1_Pos                 (0UL)
#define LPTIM_CCR1_CCR1_Msk                 (0xFFFFUL << LPTIM_CCR1_CCR1_Pos)       /*!< 0x0000FFFF */
#define LPTIM_CCR1_CCR1                     LPTIM_CCR1_CCR1_Msk                     /*!< Compare register 1 */

/******************  Bit definition for LPTIM_ARR register  *******************/
#define LPTIM_ARR_ARR_Pos                   (0UL)
#define LPTIM_ARR_ARR_Msk                   (0xFFFFUL << LPTIM_ARR_ARR_Pos)         /*!< 0x0000FFFF */
#define LPTIM_ARR_ARR                       LPTIM_ARR_ARR_Msk                       /*!< Auto reload register */

/******************  Bit definition for LPTIM_CNT register  *******************/
#define LPTIM_CNT_CNT_Pos                   (0UL)
#define LPTIM_CNT_CNT_Msk                   (0xFFFFUL << LPTIM_CNT_CNT_Pos)         /*!< 0x0000FFFF */
#define LPTIM_CNT_CNT                       LPTIM_CNT_CNT_Msk                       /*!< Counter register */

/******************  Bit definition for LPTIM_CFGR2 register  *****************/
#define LPTIM_CFGR2_IN1SEL_Pos              (0UL)
#define LPTIM_CFGR2_IN1SEL_Msk              (0x3UL << LPTIM_CFGR2_IN1SEL_Pos)       /*!< 0x00000003 */
#define LPTIM_CFGR2_IN1SEL                  LPTIM_CFGR2_IN1SEL_Msk                  /*!< IN1SEL[1:0] bits (Remap selection) */
#define LPTIM_CFGR2_IN1SEL_0                (0x1UL << LPTIM_CFGR2_IN1SEL_Pos)       /*!< 0x00000001 */
#define LPTIM_CFGR2_IN1SEL_1                (0x2UL << LPTIM_CFGR2_IN1SEL_Pos)       /*!< 0x00000002 */
#define LPTIM_CFGR2_IN2SEL_Pos              (4UL)
#define LPTIM_CFGR2_IN2SEL_Msk              (0x3UL << LPTIM_CFGR2_IN2SEL_Pos)       /*!< 0x00000030 */
#define LPTIM_CFGR2_IN2SEL                  LPTIM_CFGR2_IN2SEL_Msk                  /*!< IN2SEL[5:4] bits (Remap selection) */
#define LPTIM_CFGR2_IN2SEL_0                (0x1UL << LPTIM_CFGR2_IN2SEL_Pos)       /*!< 0x00000010 */
#define LPTIM_CFGR2_IN2SEL_1                (0x2UL << LPTIM_CFGR2_IN2SEL_Pos)       /*!< 0x00000020 */
#define LPTIM_CFGR2_IC1SEL_Pos              (16UL)
#define LPTIM_CFGR2_IC1SEL_Msk              (0x3UL << LPTIM_CFGR2_IC1SEL_Pos)       /*!< 0x00000003 */
#define LPTIM_CFGR2_IC1SEL                  LPTIM_CFGR2_IC1SEL_Msk                  /*!< IC1SEL[17:16] bits */
#define LPTIM_CFGR2_IC1SEL_0                (0x1UL << LPTIM_CFGR2_IC1SEL_Pos)       /*!< 0x00010000 */
#define LPTIM_CFGR2_IC1SEL_1                (0x2UL << LPTIM_CFGR2_IC1SEL_Pos)       /*!< 0x00020000 */
#define LPTIM_CFGR2_IC2SEL_Pos              (20UL)
#define LPTIM_CFGR2_IC2SEL_Msk              (0x3UL << LPTIM_CFGR2_IC2SEL_Pos)       /*!< 0x00000030 */
#define LPTIM_CFGR2_IC2SEL                  LPTIM_CFGR2_IC2SEL_Msk                  /*!< IC2SEL[21:20] bits */
#define LPTIM_CFGR2_IC2SEL_0                (0x1UL << LPTIM_CFGR2_IC2SEL_Pos)       /*!< 0x00100000 */
#define LPTIM_CFGR2_IC2SEL_1                (0x2UL << LPTIM_CFGR2_IC2SEL_Pos)       /*!< 0x00200000 */

/******************  Bit definition for LPTIM_RCR register  *******************/
#define LPTIM_RCR_REP_Pos                   (0UL)
#define LPTIM_RCR_REP_Msk                   (0xFFUL << LPTIM_RCR_REP_Pos)           /*!< 0x000000FF */
#define LPTIM_RCR_REP                       LPTIM_RCR_REP_Msk                       /*!< Repetition register value */

/*****************  Bit definition for LPTIM_CCMR1 register  ******************/
#define LPTIM_CCMR1_CC1SEL_Pos              (0UL)
#define LPTIM_CCMR1_CC1SEL_Msk              (0x1UL << LPTIM_CCMR1_CC1SEL_Pos)       /*!< 0x00000001 */
#define LPTIM_CCMR1_CC1SEL                  LPTIM_CCMR1_CC1SEL_Msk                  /*!< Capture/Compare 1 selection */
#define LPTIM_CCMR1_CC1E_Pos                (1UL)
#define LPTIM_CCMR1_CC1E_Msk                (0x1UL << LPTIM_CCMR1_CC1E_Pos)         /*!< 0x00000002 */
#define LPTIM_CCMR1_CC1E                    LPTIM_CCMR1_CC1E_Msk                    /*!< Capture/Compare 1 output enable */
#define LPTIM_CCMR1_CC1P_Pos                (2UL)
#define LPTIM_CCMR1_CC1P_Msk                (0x3UL << LPTIM_CCMR1_CC1P_Pos)         /*!< 0x0000000C */
#define LPTIM_CCMR1_CC1P                    LPTIM_CCMR1_CC1P_Msk                    /*!< Capture/Compare 1 output polarity */
#define LPTIM_CCMR1_CC1P_0                  (0x1UL << LPTIM_CCMR1_CC1P_Pos)         /*!< 0x00000004 */
#define LPTIM_CCMR1_CC1P_1                  (0x2UL << LPTIM_CCMR1_CC1P_Pos)         /*!< 0x00000008 */
#define LPTIM_CCMR1_IC1PSC_Pos              (8UL)
#define LPTIM_CCMR1_IC1PSC_Msk              (0x3UL << LPTIM_CCMR1_IC1PSC_Pos)       /*!< 0x00000300 */
#define LPTIM_CCMR1_IC1PSC                  LPTIM_CCMR1_IC1PSC_Msk                  /*!< Input capture 1 prescaler */
#define LPTIM_CCMR1_IC1PSC_0                (0x1UL << LPTIM_CCMR1_IC1PSC_Pos)       /*!< 0x00000100 */
#define LPTIM_CCMR1_IC1PSC_1                (0x2UL << LPTIM_CCMR1_IC1PSC_Pos)       /*!< 0x00000200 */
#define LPTIM_CCMR1_IC1F_Pos                (12UL)
#define LPTIM_CCMR1_IC1F_Msk                (0x3UL << LPTIM_CCMR1_IC1F_Pos)         /*!< 0x00003000 */
#define LPTIM_CCMR1_IC1F                    LPTIM_CCMR1_IC1F_Msk                    /*!< Input capture 1 filter */
#define LPTIM_CCMR1_IC1F_0                  (0x1UL << LPTIM_CCMR1_IC1F_Pos)         /*!< 0x00001000 */
#define LPTIM_CCMR1_IC1F_1                  (0x2UL << LPTIM_CCMR1_IC1F_Pos)         /*!< 0x00002000 */
#define LPTIM_CCMR1_CC2SEL_Pos              (16UL)
#define LPTIM_CCMR1_CC2SEL_Msk              (0x1UL << LPTIM_CCMR1_CC2SEL_Pos)       /*!< 0x00010000 */
#define LPTIM_CCMR1_CC2SEL                  LPTIM_CCMR1_CC2SEL_Msk                  /*!< Capture/Compare 2 selection */
#define LPTIM_CCMR1_CC2E_Pos                (17UL)
#define LPTIM_CCMR1_CC2E_Msk                (0x1UL << LPTIM_CCMR1_CC2E_Pos)         /*!< 0x00020000 */
#define LPTIM_CCMR1_CC2E                    LPTIM_CCMR1_CC2E_Msk                    /*!< Capture/Compare 2 output enable */
#define LPTIM_CCMR1_CC2P_Pos                (18UL)
#define LPTIM_CCMR1_CC2P_Msk                (0x3UL << LPTIM_CCMR1_CC2P_Pos)         /*!< 0x000C0000 */
#define LPTIM_CCMR1_CC2P                    LPTIM_CCMR1_CC2P_Msk                    /*!< Capture/Compare 2 output polarity */
#define LPTIM_CCMR1_CC2P_0                  (0x1UL << LPTIM_CCMR1_CC2P_Pos)         /*!< 0x00040000 */
#define LPTIM_CCMR1_CC2P_1                  (0x2UL << LPTIM_CCMR1_CC2P_Pos)         /*!< 0x00080000 */
#define LPTIM_CCMR1_IC2PSC_Pos              (24UL)
#define LPTIM_CCMR1_IC2PSC_Msk              (0x3UL << LPTIM_CCMR1_IC2PSC_Pos)       /*!< 0x03000000 */
#define LPTIM_CCMR1_IC2PSC                  LPTIM_CCMR1_IC2PSC_Msk                  /*!< Input capture 2 prescaler */
#define LPTIM_CCMR1_IC2PSC_0                (0x1UL << LPTIM_CCMR1_IC2PSC_Pos)       /*!< 0x01000000 */
#define LPTIM_CCMR1_IC2PSC_1                (0x2UL << LPTIM_CCMR1_IC2PSC_Pos)       /*!< 0x02000000 */
#define LPTIM_CCMR1_IC2F_Pos                (28UL)
#define LPTIM_CCMR1_IC2F_Msk                (0x3UL << LPTIM_CCMR1_IC2F_Pos)         /*!< 0x30000000 */
#define LPTIM_CCMR1_IC2F                    LPTIM_CCMR1_IC2F_Msk                    /*!< Input capture 2 filter */
#define LPTIM_CCMR1_IC2F_0                  (0x1UL << LPTIM_CCMR1_IC2F_Pos)         /*!< 0x10000000 */
#define LPTIM_CCMR1_IC2F_1                  (0x2UL << LPTIM_CCMR1_IC2F_Pos)         /*!< 0x20000000 */

/******************  Bit definition for LPTIM_CCR2 register  ******************/
#define LPTIM_CCR2_CCR2_Pos                 (0UL)
#define LPTIM_CCR2_CCR2_Msk                 (0xFFFFUL << LPTIM_CCR2_CCR2_Pos)       /*!< 0x0000FFFF */
#define LPTIM_CCR2_CCR2                     LPTIM_CCR2_CCR2_Msk                     /*!< Compare register 2 */

/******************************************************************************/
/*                                                                            */
/*                       Public Key Accelerator (PKA)                         */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for PKA_CR register  *********************/
#define PKA_CR_EN_Pos                       (0UL)
#define PKA_CR_EN_Msk                       (0x1UL << PKA_CR_EN_Pos)                /*!< 0x00000001 */
#define PKA_CR_EN                           PKA_CR_EN_Msk                           /*!< PKA enable */
#define PKA_CR_START_Pos                    (1UL)
#define PKA_CR_START_Msk                    (0x1UL << PKA_CR_START_Pos)             /*!< 0x00000002 */
#define PKA_CR_START                        PKA_CR_START_Msk                        /*!< Start operation */
#define PKA_CR_MODE_Pos                     (8UL)
#define PKA_CR_MODE_Msk                     (0x3FUL << PKA_CR_MODE_Pos)             /*!< 0x00003F00 */
#define PKA_CR_MODE                         PKA_CR_MODE_Msk                         /*!< MODE[5:0] PKA operation code */
#define PKA_CR_MODE_0                       (0x01UL << PKA_CR_MODE_Pos)             /*!< 0x00000100 */
#define PKA_CR_MODE_1                       (0x02UL << PKA_CR_MODE_Pos)             /*!< 0x00000200 */
#define PKA_CR_MODE_2                       (0x04UL << PKA_CR_MODE_Pos)             /*!< 0x00000400 */
#define PKA_CR_MODE_3                       (0x08UL << PKA_CR_MODE_Pos)             /*!< 0x00000800 */
#define PKA_CR_MODE_4                       (0x10UL << PKA_CR_MODE_Pos)             /*!< 0x00001000 */
#define PKA_CR_MODE_5                       (0x20UL << PKA_CR_MODE_Pos)             /*!< 0x00002000 */
#define PKA_CR_PROCENDIE_Pos                (17UL)
#define PKA_CR_PROCENDIE_Msk                (0x1UL << PKA_CR_PROCENDIE_Pos)         /*!< 0x00020000 */
#define PKA_CR_PROCENDIE                    PKA_CR_PROCENDIE_Msk                    /*!< End of operation interrupt enable */
#define PKA_CR_RAMERRIE_Pos                 (19UL)
#define PKA_CR_RAMERRIE_Msk                 (0x1UL << PKA_CR_RAMERRIE_Pos)          /*!< 0x00080000 */
#define PKA_CR_RAMERRIE                     PKA_CR_RAMERRIE_Msk                     /*!< RAM error interrupt enable */
#define PKA_CR_ADDRERRIE_Pos                (20UL)
#define PKA_CR_ADDRERRIE_Msk                (0x1UL << PKA_CR_ADDRERRIE_Pos)         /*!< 0x00100000 */
#define PKA_CR_ADDRERRIE                    PKA_CR_ADDRERRIE_Msk                    /*!< Address error interrupt enable */
#define PKA_CR_OPERRIE_Pos                  (21UL)
#define PKA_CR_OPERRIE_Msk                  (0x1UL << PKA_CR_OPERRIE_Pos)           /*!< 0x00200000 */
#define PKA_CR_OPERRIE                      PKA_CR_OPERRIE_Msk                      /*!< Operation Error interrupt enable */

/*******************  Bit definition for PKA_SR register  *********************/
#define PKA_SR_INITOK_Pos                   (0UL)
#define PKA_SR_INITOK_Msk                   (0x1UL << PKA_SR_INITOK_Pos)            /*!< 0x00000001 */
#define PKA_SR_INITOK                       PKA_SR_INITOK_Msk                       /*!< PKA initialisation flag */
#define PKA_SR_BUSY_Pos                     (16UL)
#define PKA_SR_BUSY_Msk                     (0x1UL << PKA_SR_BUSY_Pos)              /*!< 0x00010000 */
#define PKA_SR_BUSY                         PKA_SR_BUSY_Msk                         /*!< PKA operation is in progress */
#define PKA_SR_PROCENDF_Pos                 (17UL)
#define PKA_SR_PROCENDF_Msk                 (0x1UL << PKA_SR_PROCENDF_Pos)          /*!< 0x00020000 */
#define PKA_SR_PROCENDF                     PKA_SR_PROCENDF_Msk                     /*!< PKA end of operation flag */
#define PKA_SR_RAMERRF_Pos                  (19UL)
#define PKA_SR_RAMERRF_Msk                  (0x1UL << PKA_SR_RAMERRF_Pos)           /*!< 0x00080000 */
#define PKA_SR_RAMERRF                      PKA_SR_RAMERRF_Msk                      /*!< PKA RAM error flag */
#define PKA_SR_ADDRERRF_Pos                 (20UL)
#define PKA_SR_ADDRERRF_Msk                 (0x1UL << PKA_SR_ADDRERRF_Pos)          /*!< 0x00100000 */
#define PKA_SR_ADDRERRF                     PKA_SR_ADDRERRF_Msk                     /*!< Address error flag */
#define PKA_SR_OPERRF_Pos                   (21UL)
#define PKA_SR_OPERRF_Msk                   (0x1UL << PKA_SR_OPERRF_Pos)            /*!< 0x00200000 */
#define PKA_SR_OPERRF                       PKA_SR_OPERRF_Msk                       /*!< PKA operation Error flag*/

/*******************  Bit definition for PKA_CLRFR register  ******************/
#define PKA_CLRFR_PROCENDFC_Pos             (17UL)
#define PKA_CLRFR_PROCENDFC_Msk             (0x1UL << PKA_CLRFR_PROCENDFC_Pos)      /*!< 0x00020000 */
#define PKA_CLRFR_PROCENDFC                 PKA_CLRFR_PROCENDFC_Msk                 /*!< Clear PKA end of operation flag */
#define PKA_CLRFR_RAMERRFC_Pos              (19UL)
#define PKA_CLRFR_RAMERRFC_Msk              (0x1UL << PKA_CLRFR_RAMERRFC_Pos)       /*!< 0x00080000 */
#define PKA_CLRFR_RAMERRFC                  PKA_CLRFR_RAMERRFC_Msk                  /*!< Clear PKA RAM error flag */
#define PKA_CLRFR_ADDRERRFC_Pos             (20UL)
#define PKA_CLRFR_ADDRERRFC_Msk             (0x1UL << PKA_CLRFR_ADDRERRFC_Pos)      /*!< 0x00100000 */
#define PKA_CLRFR_ADDRERRFC                 PKA_CLRFR_ADDRERRFC_Msk                 /*!< Clear address error flag */
#define PKA_CLRFR_OPERRFC_Pos               (21UL)
#define PKA_CLRFR_OPERRFC_Msk               (0x1UL << PKA_CLRFR_OPERRFC_Pos)        /*!< 0x00200000 */
#define PKA_CLRFR_OPERRFC                   PKA_CLRFR_OPERRFC_Msk                   /*!< Clear PKA operation Error flag*/

/*******************  Bits definition for PKA RAM  *************************/
#define PKA_RAM_OFFSET                                 (0x0400UL)                          /*!< PKA RAM address offset */

/* Compute Montgomery parameter input data */
#define PKA_MONTGOMERY_PARAM_IN_MOD_NB_BITS            ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus number of bits */
#define PKA_MONTGOMERY_PARAM_IN_MODULUS                ((0x1088UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus */

/* Compute Montgomery parameter output data */
#define PKA_MONTGOMERY_PARAM_OUT_PARAMETER             ((0x0620UL - PKA_RAM_OFFSET)>>2)    /*!< Output Montgomery parameter */

/* Compute modular exponentiation input data */
#define PKA_MODULAR_EXP_IN_EXP_NB_BITS                 ((0x0400UL - PKA_RAM_OFFSET)>>2)    /*!< Input exponent number of bits */
#define PKA_MODULAR_EXP_IN_OP_NB_BITS                  ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_MODULAR_EXP_IN_MONTGOMERY_PARAM            ((0x0620UL - PKA_RAM_OFFSET)>>2)    /*!< Input storage area for Montgomery parameter */
#define PKA_MODULAR_EXP_IN_EXPONENT_BASE               ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input base of the exponentiation */
#define PKA_MODULAR_EXP_IN_EXPONENT                    ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Input exponent to process */
#define PKA_MODULAR_EXP_IN_MODULUS                     ((0x1088UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus */
#define PKA_MODULAR_EXP_PROTECT_IN_EXPONENT_BASE       ((0x16C8UL - PKA_RAM_OFFSET)>>2)    /*!< Input base of the protected exponentiation */
#define PKA_MODULAR_EXP_PROTECT_IN_EXPONENT            ((0x14B8UL - PKA_RAM_OFFSET)>>2)    /*!< Input exponent to process protected exponentiation*/
#define PKA_MODULAR_EXP_PROTECT_IN_MODULUS             ((0x0838UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus to process protected exponentiation */
#define PKA_MODULAR_EXP_PROTECT_IN_PHI                 ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input phi to process protected exponentiation */

/* Compute modular exponentiation output data */
#define PKA_MODULAR_EXP_OUT_RESULT                     ((0x0838UL - PKA_RAM_OFFSET)>>2)    /*!< Output result of the exponentiation */
#define PKA_MODULAR_EXP_OUT_ERROR                      ((0x1298UL - PKA_RAM_OFFSET)>>2)    /*!< Output error of the exponentiation */
#define PKA_MODULAR_EXP_OUT_MONTGOMERY_PARAM           ((0x0620UL - PKA_RAM_OFFSET)>>2)    /*!< Output storage area for Montgomery parameter */
#define PKA_MODULAR_EXP_OUT_EXPONENT_BASE              ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Output base of the exponentiation */

/* Compute ECC scalar multiplication input data */
#define PKA_ECC_SCALAR_MUL_IN_EXP_NB_BITS              ((0x0400UL - PKA_RAM_OFFSET)>>2)    /*!< Input curve prime order n number of bits */
#define PKA_ECC_SCALAR_MUL_IN_OP_NB_BITS               ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus number of bits */
#define PKA_ECC_SCALAR_MUL_IN_A_COEFF_SIGN             ((0x0410UL - PKA_RAM_OFFSET)>>2)    /*!< Input sign of the 'a' coefficient */
#define PKA_ECC_SCALAR_MUL_IN_A_COEFF                  ((0x0418UL - PKA_RAM_OFFSET)>>2)    /*!< Input ECC curve 'a' coefficient */
#define PKA_ECC_SCALAR_MUL_IN_B_COEFF                  ((0x0520UL - PKA_RAM_OFFSET)>>2)    /*!< Input ECC curve 'b' coefficient */
#define PKA_ECC_SCALAR_MUL_IN_MOD_GF                   ((0x1088UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus GF(p) */
#define PKA_ECC_SCALAR_MUL_IN_K                        ((0x12A0UL - PKA_RAM_OFFSET)>>2)    /*!< Input 'k' of KP */
#define PKA_ECC_SCALAR_MUL_IN_INITIAL_POINT_X          ((0x0578UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P X coordinate */
#define PKA_ECC_SCALAR_MUL_IN_INITIAL_POINT_Y          ((0x0470UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P Y coordinate */
#define PKA_ECC_SCALAR_MUL_IN_N_PRIME_ORDER            ((0x0F88UL - PKA_RAM_OFFSET)>>2)    /*!< Input prime order n */

/* Compute ECC scalar multiplication output data */
#define PKA_ECC_SCALAR_MUL_OUT_RESULT_X                ((0x0578UL - PKA_RAM_OFFSET)>>2)    /*!< Output result X coordinate */
#define PKA_ECC_SCALAR_MUL_OUT_RESULT_Y                ((0x05D0UL - PKA_RAM_OFFSET)>>2)    /*!< Output result Y coordinate */
#define PKA_ECC_SCALAR_MUL_OUT_ERROR                   ((0x0680UL - PKA_RAM_OFFSET)>>2)    /*!< Output result error */

/* Point check input data */
#define PKA_POINT_CHECK_IN_MOD_NB_BITS                 ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus number of bits */
#define PKA_POINT_CHECK_IN_A_COEFF_SIGN                ((0x0410UL - PKA_RAM_OFFSET)>>2)    /*!< Input sign of the 'a' coefficient */
#define PKA_POINT_CHECK_IN_A_COEFF                     ((0x0418UL - PKA_RAM_OFFSET)>>2)    /*!< Input ECC curve 'a' coefficient */
#define PKA_POINT_CHECK_IN_B_COEFF                     ((0x0520UL - PKA_RAM_OFFSET)>>2)    /*!< Input ECC curve 'b' coefficient */
#define PKA_POINT_CHECK_IN_MOD_GF                      ((0x0470UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus GF(p) */
#define PKA_POINT_CHECK_IN_INITIAL_POINT_X             ((0x0578UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P X coordinate */
#define PKA_POINT_CHECK_IN_INITIAL_POINT_Y             ((0x05D0UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P Y coordinate */
#define PKA_POINT_CHECK_IN_MONTGOMERY_PARAM            ((0x04C8UL - PKA_RAM_OFFSET)>>2)    /*!< Input storage area for Montgomery parameter */

/* Point check output data */
#define PKA_POINT_CHECK_OUT_ERROR                      ((0x0680UL - PKA_RAM_OFFSET)>>2)    /*!< Output error */

/* ECDSA signature input data */
#define PKA_ECDSA_SIGN_IN_ORDER_NB_BITS                ((0x0400UL - PKA_RAM_OFFSET)>>2)    /*!< Input order number of bits */
#define PKA_ECDSA_SIGN_IN_MOD_NB_BITS                  ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus number of bits */
#define PKA_ECDSA_SIGN_IN_A_COEFF_SIGN                 ((0x0410UL - PKA_RAM_OFFSET)>>2)    /*!< Input sign of the 'a' coefficient */
#define PKA_ECDSA_SIGN_IN_A_COEFF                      ((0x0418UL - PKA_RAM_OFFSET)>>2)    /*!< Input ECC curve 'a' coefficient */
#define PKA_ECDSA_SIGN_IN_B_COEFF                      ((0x0520UL - PKA_RAM_OFFSET)>>2)    /*!< Input ECC curve 'b' coefficient */
#define PKA_ECDSA_SIGN_IN_MOD_GF                       ((0x1088UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus GF(p) */
#define PKA_ECDSA_SIGN_IN_K                            ((0x12A0UL - PKA_RAM_OFFSET)>>2)    /*!< Input k value of the ECDSA */
#define PKA_ECDSA_SIGN_IN_INITIAL_POINT_X              ((0x0578UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P X coordinate */
#define PKA_ECDSA_SIGN_IN_INITIAL_POINT_Y              ((0x0470UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P Y coordinate */
#define PKA_ECDSA_SIGN_IN_HASH_E                       ((0x0FE8UL - PKA_RAM_OFFSET)>>2)    /*!< Input e, hash of the message */
#define PKA_ECDSA_SIGN_IN_PRIVATE_KEY_D                ((0x0F28UL - PKA_RAM_OFFSET)>>2)    /*!< Input d, private key */
#define PKA_ECDSA_SIGN_IN_ORDER_N                      ((0x0F88UL - PKA_RAM_OFFSET)>>2)    /*!< Input n, order of the curve */

/* ECDSA signature output data */
#define PKA_ECDSA_SIGN_OUT_ERROR                       ((0x0FE0UL - PKA_RAM_OFFSET)>>2)    /*!< Output error */
#define PKA_ECDSA_SIGN_OUT_SIGNATURE_R                 ((0x0730UL - PKA_RAM_OFFSET)>>2)    /*!< Output signature r */
#define PKA_ECDSA_SIGN_OUT_SIGNATURE_S                 ((0x0788UL - PKA_RAM_OFFSET)>>2)    /*!< Output signature s */
#define PKA_ECDSA_SIGN_OUT_FINAL_POINT_X               ((0x1400UL - PKA_RAM_OFFSET)>>2)    /*!< Extended output result point X coordinate */
#define PKA_ECDSA_SIGN_OUT_FINAL_POINT_Y               ((0x1458UL - PKA_RAM_OFFSET)>>2)    /*!< Extended output result point Y coordinate */


/* ECDSA verification input data */
#define PKA_ECDSA_VERIF_IN_ORDER_NB_BITS               ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input order number of bits */
#define PKA_ECDSA_VERIF_IN_MOD_NB_BITS                 ((0x04C8UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus number of bits */
#define PKA_ECDSA_VERIF_IN_A_COEFF_SIGN                ((0x0468UL - PKA_RAM_OFFSET)>>2)    /*!< Input sign of the 'a' coefficient */
#define PKA_ECDSA_VERIF_IN_A_COEFF                     ((0x0470UL - PKA_RAM_OFFSET)>>2)    /*!< Input ECC curve 'a' coefficient */
#define PKA_ECDSA_VERIF_IN_MOD_GF                      ((0x04D0UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus GF(p) */
#define PKA_ECDSA_VERIF_IN_INITIAL_POINT_X             ((0x0678UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P X coordinate */
#define PKA_ECDSA_VERIF_IN_INITIAL_POINT_Y             ((0x06D0UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P Y coordinate */
#define PKA_ECDSA_VERIF_IN_PUBLIC_KEY_POINT_X          ((0x12F8UL - PKA_RAM_OFFSET)>>2)    /*!< Input public key point X coordinate */
#define PKA_ECDSA_VERIF_IN_PUBLIC_KEY_POINT_Y          ((0x1350UL - PKA_RAM_OFFSET)>>2)    /*!< Input public key point Y coordinate */
#define PKA_ECDSA_VERIF_IN_SIGNATURE_R                 ((0x10E0UL - PKA_RAM_OFFSET)>>2)    /*!< Input r, part of the signature */
#define PKA_ECDSA_VERIF_IN_SIGNATURE_S                 ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input s, part of the signature */
#define PKA_ECDSA_VERIF_IN_HASH_E                      ((0x13A8UL - PKA_RAM_OFFSET)>>2)    /*!< Input e, hash of the message */
#define PKA_ECDSA_VERIF_IN_ORDER_N                     ((0x1088UL - PKA_RAM_OFFSET)>>2)    /*!< Input n, order of the curve */

/* ECDSA verification output data */
#define PKA_ECDSA_VERIF_OUT_RESULT                     ((0x05D0UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* RSA CRT exponentiation input data */
#define PKA_RSA_CRT_EXP_IN_MOD_NB_BITS                 ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operands number of bits */
#define PKA_RSA_CRT_EXP_IN_DP_CRT                      ((0x0730UL - PKA_RAM_OFFSET)>>2)    /*!< Input Dp CRT parameter */
#define PKA_RSA_CRT_EXP_IN_DQ_CRT                      ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Input Dq CRT parameter */
#define PKA_RSA_CRT_EXP_IN_QINV_CRT                    ((0x0948UL - PKA_RAM_OFFSET)>>2)    /*!< Input qInv CRT parameter */
#define PKA_RSA_CRT_EXP_IN_PRIME_P                     ((0x0B60UL - PKA_RAM_OFFSET)>>2)    /*!< Input Prime p */
#define PKA_RSA_CRT_EXP_IN_PRIME_Q                     ((0x1088UL - PKA_RAM_OFFSET)>>2)    /*!< Input Prime q */
#define PKA_RSA_CRT_EXP_IN_EXPONENT_BASE               ((0x12A0UL - PKA_RAM_OFFSET)>>2)    /*!< Input base of the exponentiation */

/* RSA CRT exponentiation output data */
#define PKA_RSA_CRT_EXP_OUT_RESULT                     ((0x0838UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Modular reduction input data */
#define PKA_MODULAR_REDUC_IN_OP_LENGTH                 ((0x0400UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand length */
#define PKA_MODULAR_REDUC_IN_MOD_LENGTH                ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus length */
#define PKA_MODULAR_REDUC_IN_OPERAND                   ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand */
#define PKA_MODULAR_REDUC_IN_MODULUS                   ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus */

/* Modular reduction output data */
#define PKA_MODULAR_REDUC_OUT_RESULT                   ((0xE78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Arithmetic addition input data */
#define PKA_ARITHMETIC_ADD_IN_OP_NB_BITS               ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_ARITHMETIC_ADD_IN_OP1                      ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_ARITHMETIC_ADD_IN_OP2                      ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op2 */

/* Arithmetic addition output data */
#define PKA_ARITHMETIC_ADD_OUT_RESULT                  ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Arithmetic subtraction input data */
#define PKA_ARITHMETIC_SUB_IN_OP_NB_BITS               ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_ARITHMETIC_SUB_IN_OP1                      ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_ARITHMETIC_SUB_IN_OP2                      ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op2 */

/* Arithmetic subtraction output data */
#define PKA_ARITHMETIC_SUB_OUT_RESULT                  ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Arithmetic multiplication input data */
#define PKA_ARITHMETIC_MUL_NB_BITS                     ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_ARITHMETIC_MUL_IN_OP1                      ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_ARITHMETIC_MUL_IN_OP2                      ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op2 */

/* Arithmetic multiplication output data */
#define PKA_ARITHMETIC_MUL_OUT_RESULT                  ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Comparison input data */
#define PKA_COMPARISON_IN_OP_NB_BITS                   ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_COMPARISON_IN_OP1                          ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_COMPARISON_IN_OP2                          ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op2 */

/* Comparison output data */
#define PKA_COMPARISON_OUT_RESULT                      ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Modular addition input data */
#define PKA_MODULAR_ADD_NB_BITS                        ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_MODULAR_ADD_IN_OP1                         ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_MODULAR_ADD_IN_OP2                         ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op2 */
#define PKA_MODULAR_ADD_IN_OP3_MOD                     ((0x1088UL - PKA_RAM_OFFSET)>>2)   /*!< Input operand op3 (modulus) */

/* Modular addition output data */
#define PKA_MODULAR_ADD_OUT_RESULT                     ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Modular inversion input data */
#define PKA_MODULAR_INV_NB_BITS                        ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_MODULAR_INV_IN_OP1                         ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_MODULAR_INV_IN_OP2_MOD                     ((0x0C68UL - PKA_RAM_OFFSET)>>2)   /*!< Input operand op2 (modulus) */

/* Modular inversion output data */
#define PKA_MODULAR_INV_OUT_RESULT                     ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Modular subtraction input data */
#define PKA_MODULAR_SUB_IN_OP_NB_BITS                  ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_MODULAR_SUB_IN_OP1                         ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_MODULAR_SUB_IN_OP2                         ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op2 */
#define PKA_MODULAR_SUB_IN_OP3_MOD                     ((0x1088UL - PKA_RAM_OFFSET)>>2)   /*!< Input operand op3 */

/* Modular subtraction output data */
#define PKA_MODULAR_SUB_OUT_RESULT                     ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Montgomery multiplication input data */
#define PKA_MONTGOMERY_MUL_IN_OP_NB_BITS               ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_MONTGOMERY_MUL_IN_OP1                      ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_MONTGOMERY_MUL_IN_OP2                      ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op2 */
#define PKA_MONTGOMERY_MUL_IN_OP3_MOD                  ((0x1088UL - PKA_RAM_OFFSET)>>2)   /*!< Input modulus */

/* Montgomery multiplication output data */
#define PKA_MONTGOMERY_MUL_OUT_RESULT                  ((0x0E78UL - PKA_RAM_OFFSET)>>2)    /*!< Output result */

/* Generic Arithmetic input data */
#define PKA_ARITHMETIC_ALL_OPS_NB_BITS                 ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand number of bits */
#define PKA_ARITHMETIC_ALL_OPS_IN_OP1                  ((0x0A50UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op1 */
#define PKA_ARITHMETIC_ALL_OPS_IN_OP2                  ((0x0C68UL - PKA_RAM_OFFSET)>>2)    /*!< Input operand op2 */
#define PKA_ARITHMETIC_ALL_OPS_IN_OP3                  ((0x1088UL - PKA_RAM_OFFSET)>>2)   /*!< Input operand op2 */

/* Generic Arithmetic output data */
#define PKA_ARITHMETIC_ALL_OPS_OUT_RESULT              ((0x0E78UL - PKA_RAM_OFFSET)>>2)   /*!< Output result for arithmetic operations */

/* Compute ECC complete addition input data */
#define PKA_ECC_COMPLETE_ADD_IN_MOD_NB_BITS            ((0x0408UL - PKA_RAM_OFFSET)>>2)   /*!< Input Modulus number of bits */
#define PKA_ECC_COMPLETE_ADD_IN_A_COEFF_SIGN           ((0x0410UL - PKA_RAM_OFFSET)>>2)   /*!< Input sign of the 'a' coefficient */
#define PKA_ECC_COMPLETE_ADD_IN_A_COEFF                ((0x0418UL - PKA_RAM_OFFSET)>>2)   /*!< Input ECC curve '|a|' coefficient */
#define PKA_ECC_COMPLETE_ADD_IN_MOD_P                  ((0x0470UL - PKA_RAM_OFFSET)>>2)   /*!< Input modulus GF(p) */
#define PKA_ECC_COMPLETE_ADD_IN_POINT1_X               ((0x0628UL - PKA_RAM_OFFSET)>>2)   /*!< Input initial point P X coordinate */
#define PKA_ECC_COMPLETE_ADD_IN_POINT1_Y               ((0x0680UL - PKA_RAM_OFFSET)>>2)   /*!< Input initial point P Y coordinate */
#define PKA_ECC_COMPLETE_ADD_IN_POINT1_Z               ((0x06D8UL - PKA_RAM_OFFSET)>>2)   /*!< Input initial point P Z coordinate */
#define PKA_ECC_COMPLETE_ADD_IN_POINT2_X               ((0x0730UL - PKA_RAM_OFFSET)>>2)   /*!< Input initial point Q X coordinate */
#define PKA_ECC_COMPLETE_ADD_IN_POINT2_Y               ((0x0788UL - PKA_RAM_OFFSET)>>2)   /*!< Input initial point Q Y coordinate */
#define PKA_ECC_COMPLETE_ADD_IN_POINT2_Z               ((0x07E0UL - PKA_RAM_OFFSET)>>2)   /*!< Input initial point Q Z coordinate */

/* Compute ECC complete addition output data */
#define PKA_ECC_COMPLETE_ADD_OUT_RESULT_X              ((0x0D60UL - PKA_RAM_OFFSET)>>2)   /*!< Output result X coordinate */
#define PKA_ECC_COMPLETE_ADD_OUT_RESULT_Y              ((0x0DB8UL - PKA_RAM_OFFSET)>>2)   /*!< Output result Y coordinate */
#define PKA_ECC_COMPLETE_ADD_OUT_RESULT_Z              ((0x0E10UL - PKA_RAM_OFFSET)>>2)   /*!< Output result Z coordinate */

/* Compute ECC double base ladder input data */
#define PKA_ECC_DOUBLE_LADDER_IN_PRIME_ORDER_NB_BITS   ((0x0400UL - PKA_RAM_OFFSET)>>2)    /*!< Input n, order of the curve */
#define PKA_ECC_DOUBLE_LADDER_IN_MOD_NB_BITS           ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input Modulus number of bits */
#define PKA_ECC_DOUBLE_LADDER_IN_A_COEFF_SIGN          ((0x0410UL - PKA_RAM_OFFSET)>>2)    /*!< Input sign of the 'a' coefficient */
#define PKA_ECC_DOUBLE_LADDER_IN_A_COEFF               ((0x0418UL - PKA_RAM_OFFSET)>>2)    /*!< Input ECC curve '|a|' coefficient */
#define PKA_ECC_DOUBLE_LADDER_IN_MOD_P                 ((0x0470UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus GF(p) */
#define PKA_ECC_DOUBLE_LADDER_IN_K_INTEGER             ((0x0520UL - PKA_RAM_OFFSET)>>2)    /*!< Input 'k' integer coefficient */
#define PKA_ECC_DOUBLE_LADDER_IN_M_INTEGER             ((0x0578UL - PKA_RAM_OFFSET)>>2)    /*!< Input 'm' integer coefficient */
#define PKA_ECC_DOUBLE_LADDER_IN_POINT1_X              ((0x0628UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P X coordinate */
#define PKA_ECC_DOUBLE_LADDER_IN_POINT1_Y              ((0x0680UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P Y coordinate */
#define PKA_ECC_DOUBLE_LADDER_IN_POINT1_Z              ((0x06D8UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point P Z coordinate */
#define PKA_ECC_DOUBLE_LADDER_IN_POINT2_X              ((0x0730UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point Q X coordinate */
#define PKA_ECC_DOUBLE_LADDER_IN_POINT2_Y              ((0x0788UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point Q Y coordinate */
#define PKA_ECC_DOUBLE_LADDER_IN_POINT2_Z              ((0x07E0UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial point Q Z coordinate */

/* Compute ECC double base ladder output data */
#define PKA_ECC_DOUBLE_LADDER_OUT_RESULT_X             ((0x0578UL - PKA_RAM_OFFSET)>>2)    /*!< Output result X coordinate (affine coordinate) */
#define PKA_ECC_DOUBLE_LADDER_OUT_RESULT_Y             ((0x05D0UL - PKA_RAM_OFFSET)>>2)    /*!< Output result Y coordinate (affine coordinate) */
#define PKA_ECC_DOUBLE_LADDER_OUT_ERROR                ((0x0520UL - PKA_RAM_OFFSET)>>2)    /*!< Output result error */

/* Compute ECC projective to affine conversion input data */
#define PKA_ECC_PROJECTIVE_AFF_IN_MOD_NB_BITS          ((0x0408UL - PKA_RAM_OFFSET)>>2)    /*!< Input Modulus number of bits */
#define PKA_ECC_PROJECTIVE_AFF_IN_MOD_P                ((0x0470UL - PKA_RAM_OFFSET)>>2)    /*!< Input modulus GF(p) */
#define PKA_ECC_PROJECTIVE_AFF_IN_POINT_X              ((0x0D60UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial projective point P X coordinate */
#define PKA_ECC_PROJECTIVE_AFF_IN_POINT_Y              ((0x0DB8UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial projective point P Y coordinate */
#define PKA_ECC_PROJECTIVE_AFF_IN_POINT_Z              ((0x0E10UL - PKA_RAM_OFFSET)>>2)    /*!< Input initial projective point P Z coordinate */
#define PKA_ECC_PROJECTIVE_AFF_IN_MONTGOMERY_PARAM_R2  ((0x04C8UL - PKA_RAM_OFFSET)>>2)    /*!< Input storage area for Montgomery parameter */

/* Compute ECC projective to affine conversion output data */
#define PKA_ECC_PROJECTIVE_AFF_OUT_RESULT_X            ((0x0578UL - PKA_RAM_OFFSET)>>2)    /*!< Output result x affine coordinate */
#define PKA_ECC_PROJECTIVE_AFF_OUT_RESULT_Y            ((0x05D0UL - PKA_RAM_OFFSET)>>2)    /*!< Output result y affine coordinate */
#define PKA_ECC_PROJECTIVE_AFF_OUT_ERROR               ((0x0680UL - PKA_RAM_OFFSET)>>2)    /*!< Output result error */


/******************************************************************************/
/*                                                                            */
/*                             PTA Converter                                  */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for PTACONV_ACTCR register  ***************/
#define PTACONV_ACTCR_TACTIVE_Pos           (0UL)
#define PTACONV_ACTCR_TACTIVE_Msk           (0xFFUL << PTACONV_ACTCR_TACTIVE_Pos)   /*!< 0x000000FF */
#define PTACONV_ACTCR_TACTIVE               PTACONV_ACTCR_TACTIVE_Msk               /*!< PTA_ACTIVE setup time in us */
#define PTACONV_ACTCR_ACTPOL_Pos            (15UL)
#define PTACONV_ACTCR_ACTPOL_Msk            (0x1UL << PTACONV_ACTCR_ACTPOL_Pos)     /*!< 0x00008000 */
#define PTACONV_ACTCR_ACTPOL                PTACONV_ACTCR_ACTPOL_Msk                /*!< PTA_ACTIVE polarity */
#define PTACONV_ACTCR_TABORT_Pos            (16UL)
#define PTACONV_ACTCR_TABORT_Msk            (0xFUL << PTACONV_ACTCR_TABORT_Pos)     /*!< 0x000F0000 */
#define PTACONV_ACTCR_TABORT                PTACONV_ACTCR_TABORT_Msk                /*!< PTA_ACTIVE delay to cease an ongoing transmission in us */
#define PTACONV_ACTCR_ABORTDIS_Pos          (20UL)
#define PTACONV_ACTCR_ABORTDIS_Msk          (0x1UL << PTACONV_ACTCR_ABORTDIS_Pos)   /*!< 0x00100000 */
#define PTACONV_ACTCR_ABORTDIS              PTACONV_ACTCR_ABORTDIS_Msk              /*!< Disable PTA_ACTIVE deny to abort an ongoing transmission */

/******************  Bit definition for PTACONV_PRICR register  ***************/
#define PTACONV_PRICR_TPRIORITY_Pos         (0UL)
#define PTACONV_PRICR_TPRIORITY_Msk         (0x1FUL << PTACONV_PRICR_TPRIORITY_Pos) /*!< 0x0000001F */
#define PTACONV_PRICR_TPRIORITY             PTACONV_PRICR_TPRIORITY_Msk             /*!< Priority valid time in us */
#define PTACONV_PRICR_PRIPOL_Pos            (15UL)
#define PTACONV_PRICR_PRIPOL_Msk            (0x1UL << PTACONV_PRICR_PRIPOL_Pos)     /*!< 0x00008000 */
#define PTACONV_PRICR_PRIPOL                PTACONV_PRICR_PRIPOL_Msk                /*!< Priority polarity */

/******************  Bit definition for PTACONV_CR register  ******************/
#define PTACONV_CR_TXRXPOL_Pos              (15UL)
#define PTACONV_CR_TXRXPOL_Msk              (0x1UL << PTACONV_CR_TXRXPOL_Pos)      /*!< 0x00008000 */
#define PTACONV_CR_TXRXPOL                  PTACONV_CR_TXRXPOL_Msk                  /*!< PTA_STATUS transmit and receive polarity */
#define PTACONV_CR_GRANTPOL_Pos             (31UL)
#define PTACONV_CR_GRANTPOL_Msk             (0x1UL << PTACONV_CR_GRANTPOL_Pos)      /*!< 0x80000000 */
#define PTACONV_CR_GRANTPOL                 PTACONV_CR_GRANTPOL_Msk                 /*!< PTA_GRANT polarity */


/******************************************************************************/
/*                                                                            */
/*                             Power Control                                  */
/*                                                                            */
/******************************************************************************/
#define PWR_STOP2_SUPPORT
/********************  Bit definition for PWR_CR1 register  *******************/
#define PWR_CR1_LPMS_Pos                    (0UL)
#define PWR_CR1_LPMS_Msk                    (0x7UL << PWR_CR1_LPMS_Pos)             /*!< 0x00000007 */
#define PWR_CR1_LPMS                        PWR_CR1_LPMS_Msk                        /*!< LPMS[2:0] Low-power mode selection field */
#define PWR_CR1_LPMS_0                      (0x1UL << PWR_CR1_LPMS_Pos)             /*!< 0x00000001 */
#define PWR_CR1_LPMS_1                      (0x2UL << PWR_CR1_LPMS_Pos)             /*!< 0x00000002 */
#define PWR_CR1_LPMS_2                      (0x4UL << PWR_CR1_LPMS_Pos)             /*!< 0x00000004 */
#define PWR_CR1_R2RSB1_Pos                  (5UL)
#define PWR_CR1_R2RSB1_Msk                  (0x1UL << PWR_CR1_R2RSB1_Pos)           /*!< 0x00000020 */
#define PWR_CR1_R2RSB1                      PWR_CR1_R2RSB1_Msk                      /*!< SRAM2 Retention in Standby */
#define PWR_CR1_ULPMEN_Pos                  (7UL)
#define PWR_CR1_ULPMEN_Msk                  (0x1UL << PWR_CR1_ULPMEN_Pos)           /*!< 0x00000080 */
#define PWR_CR1_ULPMEN                      PWR_CR1_ULPMEN_Msk                      /*!< BOR ultra-low power mode in Standby/Shutdown */
#define PWR_CR1_RADIORSB_Pos                (9UL)
#define PWR_CR1_RADIORSB_Msk                (0x1UL << PWR_CR1_RADIORSB_Pos)         /*!< 0x00000200 */
#define PWR_CR1_RADIORSB                    PWR_CR1_RADIORSB_Msk                    /*!< 2.4GHz RADIO SRAMs (TXRX and Sequence) and Sleep clock retention in Standby mode */
#define PWR_CR1_R1RSB567_Pos                (11UL)
#define PWR_CR1_R1RSB567_Msk                (0x1UL << PWR_CR1_R1RSB567_Pos)       /*!< 0x00000800 */
#define PWR_CR1_R1RSB567                    PWR_CR1_R1RSB567_Msk                  /*!< SRAM1 Pages 5-6-7 Retention in Standby */
#define PWR_CR1_R1RSB1_Pos                  (12UL)
#define PWR_CR1_R1RSB1_Msk                  (0x1UL << PWR_CR1_R1RSB1_Pos)            /*!< 0x00001000 */
#define PWR_CR1_R1RSB1                      PWR_CR1_R1RSB1_Msk                       /*!< SRAM1 Page 1 Retention in Standby */
#define PWR_CR1_R1RSB2_Pos                  (13UL)
#define PWR_CR1_R1RSB2_Msk                  (0x1UL << PWR_CR1_R1RSB2_Pos)            /*!< 0x00002000 */
#define PWR_CR1_R1RSB2                      PWR_CR1_R1RSB2_Msk                       /*!< SRAM1 Page 2 Retention in Standby */
#define PWR_CR1_R1RSB3_Pos                  (14UL)
#define PWR_CR1_R1RSB3_Msk                  (0x1UL << PWR_CR1_R1RSB3_Pos)            /*!< 0x00004000 */
#define PWR_CR1_R1RSB3                      PWR_CR1_R1RSB3_Msk                       /*!< SRAM1 Page 3 Retention in Standby */
#define PWR_CR1_R1RSB4_Pos                  (15UL)
#define PWR_CR1_R1RSB4_Msk                  (0x1UL << PWR_CR1_R1RSB4_Pos)            /*!< 0x00008000 */
#define PWR_CR1_R1RSB4                      PWR_CR1_R1RSB4_Msk                       /*!< SRAM1 Page 4 Retention in Standby */

/********************  Bit definition for PWR_CR2 register  *******************/
#define PWR_CR2_SRAM1PDS1_Pos               (0UL)
#define PWR_CR2_SRAM1PDS1_Msk               (0x1UL << PWR_CR2_SRAM1PDS1_Pos)        /*!< 0x00000001 */
#define PWR_CR2_SRAM1PDS1                   PWR_CR2_SRAM1PDS1_Msk                   /*!< SRAM1 Page 1 power-down in Stop modes */
#define PWR_CR2_SRAM1PDS2_Pos               (1UL)
#define PWR_CR2_SRAM1PDS2_Msk               (0x1UL << PWR_CR2_SRAM1PDS2_Pos)        /*!< 0x00000002 */
#define PWR_CR2_SRAM1PDS2                   PWR_CR2_SRAM1PDS2_Msk                   /*!< SRAM1 Page 2 power-down in Stop modes */
#define PWR_CR2_SRAM1PDS3_Pos               (2UL)
#define PWR_CR2_SRAM1PDS3_Msk               (0x1UL << PWR_CR2_SRAM1PDS3_Pos)        /*!< 0x00000004 */
#define PWR_CR2_SRAM1PDS3                   PWR_CR2_SRAM1PDS3_Msk                   /*!< SRAM1 Page 3 power-down in Stop modes */
#define PWR_CR2_SRAM1PDS4_Pos               (3UL)
#define PWR_CR2_SRAM1PDS4_Msk               (0x1UL << PWR_CR2_SRAM1PDS4_Pos)        /*!< 0x00000008 */
#define PWR_CR2_SRAM1PDS4                   PWR_CR2_SRAM1PDS4_Msk                   /*!< SRAM1 Page 4 power-down in Stop modes */
#define PWR_CR2_SRAM2PDS1_Pos               (4UL)
#define PWR_CR2_SRAM2PDS1_Msk               (0x1UL << PWR_CR2_SRAM2PDS1_Pos)        /*!< 0x00000010 */
#define PWR_CR2_SRAM2PDS1                   PWR_CR2_SRAM2PDS1_Msk                   /*!< SRAM2 power-down in Stop modes */
#define PWR_CR2_SRAM1PDS567_Pos             (6UL)
#define PWR_CR2_SRAM1PDS567_Msk             (0x1UL << PWR_CR2_SRAM1PDS567_Pos)      /*!< 0x00000040 */
#define PWR_CR2_SRAM1PDS567                 PWR_CR2_SRAM1PDS567_Msk                 /*!< SRAM1 Page 5-6-7 power-down in Stop modes */
#define PWR_CR2_ICRAMPDS_Pos                (8UL)
#define PWR_CR2_ICRAMPDS_Msk                (0x1UL << PWR_CR2_ICRAMPDS_Pos)         /*!< 0x00000100 */
#define PWR_CR2_ICRAMPDS                    PWR_CR2_ICRAMPDS_Msk                    /*!< ICACHE SRAM power-down in Stop modes */
#define PWR_CR2_PRAMPDS_Pos                 (11UL)
#define PWR_CR2_PRAMPDS_Msk                 (0x1UL << PWR_CR2_PRAMPDS_Pos)          /*!< 0x00000800 */
#define PWR_CR2_PRAMPDS                     PWR_CR2_PRAMPDS_Msk                     /*!< USB OTG_HS SRAM power-down in Stop modes */
#define PWR_CR2_PKARAMPDS_Pos               (12UL)
#define PWR_CR2_PKARAMPDS_Msk               (0x1UL << PWR_CR2_PKARAMPDS_Pos)        /*!< 0x00001000 */
#define PWR_CR2_PKARAMPDS                   PWR_CR2_PKARAMPDS_Msk                   /*!< PKA SRAM power-down in Stop modes */
#define PWR_CR2_FLASHFWU_Pos                (14UL)
#define PWR_CR2_FLASHFWU_Msk                (0x1UL << PWR_CR2_FLASHFWU_Pos)         /*!< 0x00004000 */
#define PWR_CR2_FLASHFWU                    PWR_CR2_FLASHFWU_Msk                    /*!< Flash low-power mode in Stop modes */
#define PWR_CR2_FPWM_Pos                    (30UL)
#define PWR_CR2_FPWM_Msk                    (0x1UL << PWR_CR2_FPWM_Pos)             /*!< 0x40000000 */
#define PWR_CR2_FPWM                        PWR_CR2_FPWM_Msk                        /*!< SMPS PWM mode */

/********************  Bit definition for PWR_CR3 register  *******************/
#define PWR_CR3_REGSEL_Pos                  (1UL)
#define PWR_CR3_REGSEL_Msk                  (0x1UL << PWR_CR3_REGSEL_Pos)           /*!< 0x00000002 */
#define PWR_CR3_REGSEL                      PWR_CR3_REGSEL_Msk                      /*!< Regulator selection */
#define PWR_CR3_FSTEN_Pos                   (2UL)
#define PWR_CR3_FSTEN_Msk                   (0x1UL << PWR_CR3_FSTEN_Pos)            /*!< 0x00000004 */
#define PWR_CR3_FSTEN                       PWR_CR3_FSTEN_Msk                       /*!< Fast soft start */

/*******************  Bit definition for PWR_VOSR register  *******************/
#define PWR_VOSR_VDD11USBRDY_Pos            (12UL)
#define PWR_VOSR_VDD11USBRDY_Msk            (0x1UL << PWR_VOSR_VDD11USBRDY_Pos)     /*!< 0x00001000 */
#define PWR_VOSR_VDD11USBRDY                PWR_VOSR_VDD11USBRDY_Msk                /*!< USB OTG_HS VDD11 ready */
#define PWR_VOSR_USBBOOSTRDY_Pos            (13UL)
#define PWR_VOSR_USBBOOSTRDY_Msk            (0x1UL << PWR_VOSR_USBBOOSTRDY_Pos)     /*!< 0x00002000 */
#define PWR_VOSR_USBBOOSTRDY                PWR_VOSR_USBBOOSTRDY_Msk                /*!< USB OTG_HS booster ready */
#define PWR_VOSR_VOSRDY_Pos                 (15UL)
#define PWR_VOSR_VOSRDY_Msk                 (0x1UL << PWR_VOSR_VOSRDY_Pos)          /*!< 0x00008000 */
#define PWR_VOSR_VOSRDY                     PWR_VOSR_VOSRDY_Msk                     /*!< Ready bit for VCORE voltage scaling output selection */
#define PWR_VOSR_VOS_Pos                    (16UL)
#define PWR_VOSR_VOS_Msk                    (0x1UL << PWR_VOSR_VOS_Pos)             /*!< 0x00010000 */
#define PWR_VOSR_VOS                        PWR_VOSR_VOS_Msk                        /*!< Voltage scaling range selection */
#define PWR_VOSR_USBPWREN_Pos               (19UL)
#define PWR_VOSR_USBPWREN_Msk               (0x1UL << PWR_VOSR_USBPWREN_Pos)        /*!< 0x00080000 */
#define PWR_VOSR_USBPWREN                   PWR_VOSR_USBPWREN_Msk                   /*!< USB OTG_HS power enable */
#define PWR_VOSR_USBBOOSTEN_Pos             (20UL)
#define PWR_VOSR_USBBOOSTEN_Msk             (0x1UL << PWR_VOSR_USBBOOSTEN_Pos)      /*!< 0x00100000 */
#define PWR_VOSR_USBBOOSTEN                 PWR_VOSR_USBBOOSTEN_Msk                 /*!< USB OTG_HS booster enable */
#define PWR_VOSR_VDD11USBDIS_Pos            (21UL)
#define PWR_VOSR_VDD11USBDIS_Msk            (0x1UL << PWR_VOSR_VDD11USBDIS_Pos)     /*!< 0x00200000 */
#define PWR_VOSR_VDD11USBDIS                PWR_VOSR_VDD11USBDIS_Msk                /*!< USB OTG_HS VDD11USB disable */
#define PWR_VOSR_VDD11USBSWDLY_Pos          (22UL)
#define PWR_VOSR_VDD11USBSWDLY_Msk          (0x3FFUL << PWR_VOSR_VDD11USBSWDLY_Pos) /*!< 0xFFC00000 */
#define PWR_VOSR_VDD11USBSWDLY              PWR_VOSR_VDD11USBSWDLY_Msk              /*!< VDD11USBSWDLY[9:0] USB OTG_HS VDD11USB switch delay */
#define PWR_VOSR_VDD11USBSWDLY_0            (0x1UL << PWR_VOSR_VDD11USBSWDLY_Pos)   /*!< 0x00400000 */
#define PWR_VOSR_VDD11USBSWDLY_1            (0x2UL << PWR_VOSR_VDD11USBSWDLY_Pos)   /*!< 0x00800000 */
#define PWR_VOSR_VDD11USBSWDLY_2            (0x4UL << PWR_VOSR_VDD11USBSWDLY_Pos)   /*!< 0x01000000 */
#define PWR_VOSR_VDD11USBSWDLY_3            (0x8UL << PWR_VOSR_VDD11USBSWDLY_Pos)   /*!< 0x02000000 */
#define PWR_VOSR_VDD11USBSWDLY_4            (0x10UL << PWR_VOSR_VDD11USBSWDLY_Pos)  /*!< 0x04000000 */
#define PWR_VOSR_VDD11USBSWDLY_5            (0x20UL << PWR_VOSR_VDD11USBSWDLY_Pos)  /*!< 0x08000000 */
#define PWR_VOSR_VDD11USBSWDLY_6            (0x40UL << PWR_VOSR_VDD11USBSWDLY_Pos)  /*!< 0x10000000 */
#define PWR_VOSR_VDD11USBSWDLY_7            (0x80UL << PWR_VOSR_VDD11USBSWDLY_Pos)  /*!< 0x20000000 */
#define PWR_VOSR_VDD11USBSWDLY_8            (0x100UL << PWR_VOSR_VDD11USBSWDLY_Pos) /*!< 0x80000000 */
#define PWR_VOSR_VDD11USBSWDLY_9            (0x200UL << PWR_VOSR_VDD11USBSWDLY_Pos) /*!< 0x80000000 */

/*******************  Bit definition for PWR_SVMCR register  ******************/
#define PWR_SVMCR_PVDE_Pos                  (4UL)
#define PWR_SVMCR_PVDE_Msk                  (0x1UL << PWR_SVMCR_PVDE_Pos)           /*!< 0x00000010 */
#define PWR_SVMCR_PVDE                      PWR_SVMCR_PVDE_Msk                      /*!< Power voltage detector enable */
#define PWR_SVMCR_PVDLS_Pos                 (5UL)
#define PWR_SVMCR_PVDLS_Msk                 (0x7UL << PWR_SVMCR_PVDLS_Pos)          /*!< 0x000000E0 */
#define PWR_SVMCR_PVDLS                     PWR_SVMCR_PVDLS_Msk                     /*!< PVDLS[2:0] Power voltage detector level selection field  */
#define PWR_SVMCR_PVDLS_0                   (0x1UL << PWR_SVMCR_PVDLS_Pos)          /*!< 0x00000020 */
#define PWR_SVMCR_PVDLS_1                   (0x2UL << PWR_SVMCR_PVDLS_Pos)          /*!< 0x00000040 */
#define PWR_SVMCR_PVDLS_2                   (0x4UL << PWR_SVMCR_PVDLS_Pos)          /*!< 0x00000080 */
#define PWR_SVMCR_USV_Pos                   (28UL)
#define PWR_SVMCR_USV_Msk                   (0x1UL << PWR_SVMCR_USV_Pos)            /*!< 0x10000000 */
#define PWR_SVMCR_USV                       PWR_SVMCR_USV_Msk                       /*!< VDDUSB supply valid */
#define PWR_SVMCR_IO2SV_Pos                 (29UL)
#define PWR_SVMCR_IO2SV_Msk                 (0x1UL << PWR_SVMCR_IO2SV_Pos)          /*!< 0x20000000 */
#define PWR_SVMCR_IO2SV                     PWR_SVMCR_IO2SV_Msk                     /*!< VDDIO2 supply valid */

/*******************  Bit definition for PWR_WUCR1 register  ******************/
#define PWR_WUCR1_WUPEN1_Pos                (0UL)
#define PWR_WUCR1_WUPEN1_Msk                (0x1UL << PWR_WUCR1_WUPEN1_Pos)         /*!< 0x00000001 */
#define PWR_WUCR1_WUPEN1                    PWR_WUCR1_WUPEN1_Msk                    /*!< Wakeup pin WKUP1 enable */
#define PWR_WUCR1_WUPEN2_Pos                (1UL)
#define PWR_WUCR1_WUPEN2_Msk                (0x1UL << PWR_WUCR1_WUPEN2_Pos)         /*!< 0x00000002 */
#define PWR_WUCR1_WUPEN2                    PWR_WUCR1_WUPEN2_Msk                    /*!< Wakeup pin WKUP2 enable */
#define PWR_WUCR1_WUPEN3_Pos                (2UL)
#define PWR_WUCR1_WUPEN3_Msk                (0x1UL << PWR_WUCR1_WUPEN3_Pos)         /*!< 0x00000004 */
#define PWR_WUCR1_WUPEN3                    PWR_WUCR1_WUPEN3_Msk                    /*!< Wakeup pin WKUP3 enable */
#define PWR_WUCR1_WUPEN4_Pos                (3UL)
#define PWR_WUCR1_WUPEN4_Msk                (0x1UL << PWR_WUCR1_WUPEN4_Pos)         /*!< 0x00000008 */
#define PWR_WUCR1_WUPEN4                    PWR_WUCR1_WUPEN4_Msk                    /*!< Wakeup pin WKUP4 enable */
#define PWR_WUCR1_WUPEN5_Pos                (4UL)
#define PWR_WUCR1_WUPEN5_Msk                (0x1UL << PWR_WUCR1_WUPEN5_Pos)         /*!< 0x00000010 */
#define PWR_WUCR1_WUPEN5                    PWR_WUCR1_WUPEN5_Msk                    /*!< Wakeup pin WKUP5 enable */
#define PWR_WUCR1_WUPEN6_Pos                (5UL)
#define PWR_WUCR1_WUPEN6_Msk                (0x1UL << PWR_WUCR1_WUPEN6_Pos)         /*!< 0x00000020 */
#define PWR_WUCR1_WUPEN6                    PWR_WUCR1_WUPEN6_Msk                    /*!< Wakeup pin WKUP6 enable */
#define PWR_WUCR1_WUPEN7_Pos                (6UL)
#define PWR_WUCR1_WUPEN7_Msk                (0x1UL << PWR_WUCR1_WUPEN7_Pos)         /*!< 0x00000040 */
#define PWR_WUCR1_WUPEN7                    PWR_WUCR1_WUPEN7_Msk                    /*!< Wakeup pin WKUP7 enable */
#define PWR_WUCR1_WUPEN8_Pos                (7UL)
#define PWR_WUCR1_WUPEN8_Msk                (0x1UL << PWR_WUCR1_WUPEN8_Pos)         /*!< 0x00000080 */
#define PWR_WUCR1_WUPEN8                    PWR_WUCR1_WUPEN8_Msk                    /*!< Wakeup pin WKUP8 enable */

/*******************  Bit definition for PWR_WUCR2 register  ******************/
#define PWR_WUCR2_WUPP1_Pos                 (0UL)
#define PWR_WUCR2_WUPP1_Msk                 (0x1UL << PWR_WUCR2_WUPP1_Pos)          /*!< 0x00000001 */
#define PWR_WUCR2_WUPP1                     PWR_WUCR2_WUPP1_Msk                     /*!< Wakeup pin WKUP1 polarity */
#define PWR_WUCR2_WUPP2_Pos                 (1UL)
#define PWR_WUCR2_WUPP2_Msk                 (0x1UL << PWR_WUCR2_WUPP2_Pos)          /*!< 0x00000002 */
#define PWR_WUCR2_WUPP2                     PWR_WUCR2_WUPP2_Msk                     /*!< Wakeup pin WKUP2 polarity */
#define PWR_WUCR2_WUPP3_Pos                 (2UL)
#define PWR_WUCR2_WUPP3_Msk                 (0x1UL << PWR_WUCR2_WUPP3_Pos)          /*!< 0x00000004 */
#define PWR_WUCR2_WUPP3                     PWR_WUCR2_WUPP3_Msk                     /*!< Wakeup pin WKUP3 polarity */
#define PWR_WUCR2_WUPP4_Pos                 (3UL)
#define PWR_WUCR2_WUPP4_Msk                 (0x1UL << PWR_WUCR2_WUPP4_Pos)          /*!< 0x00000008 */
#define PWR_WUCR2_WUPP4                     PWR_WUCR2_WUPP4_Msk                     /*!< Wakeup pin WKUP4 polarity */
#define PWR_WUCR2_WUPP5_Pos                 (4UL)
#define PWR_WUCR2_WUPP5_Msk                 (0x1UL << PWR_WUCR2_WUPP5_Pos)          /*!< 0x00000010 */
#define PWR_WUCR2_WUPP5                     PWR_WUCR2_WUPP5_Msk                     /*!< Wakeup pin WKUP5 polarity */
#define PWR_WUCR2_WUPP6_Pos                 (5UL)
#define PWR_WUCR2_WUPP6_Msk                 (0x1UL << PWR_WUCR2_WUPP6_Pos)          /*!< 0x00000020 */
#define PWR_WUCR2_WUPP6                     PWR_WUCR2_WUPP6_Msk                     /*!< Wakeup pin WKUP6 polarity */
#define PWR_WUCR2_WUPP7_Pos                 (6UL)
#define PWR_WUCR2_WUPP7_Msk                 (0x1UL << PWR_WUCR2_WUPP7_Pos)          /*!< 0x00000040 */
#define PWR_WUCR2_WUPP7                     PWR_WUCR2_WUPP7_Msk                     /*!< Wakeup pin WKUP7 polarity */
#define PWR_WUCR2_WUPP8_Pos                 (7UL)
#define PWR_WUCR2_WUPP8_Msk                 (0x1UL << PWR_WUCR2_WUPP8_Pos)          /*!< 0x00000080 */
#define PWR_WUCR2_WUPP8                     PWR_WUCR2_WUPP8_Msk                     /*!< Wakeup pin WKUP8 polarity */

/*******************  Bit definition for PWR_WUCR3 register  ******************/
#define PWR_WUCR3_WUSEL1_Pos                (0UL)
#define PWR_WUCR3_WUSEL1_Msk                (0x3UL << PWR_WUCR3_WUSEL1_Pos)         /*!< 0x00000003 */
#define PWR_WUCR3_WUSEL1                    PWR_WUCR3_WUSEL1_Msk                    /*!< Wakeup pin WKUP1 selection field */
#define PWR_WUCR3_WUSEL1_0                  (0x1UL << PWR_WUCR3_WUSEL1_Pos)         /*!< 0x00000001 */
#define PWR_WUCR3_WUSEL1_1                  (0x2UL << PWR_WUCR3_WUSEL1_Pos)         /*!< 0x00000002 */
#define PWR_WUCR3_WUSEL2_Pos                (2UL)
#define PWR_WUCR3_WUSEL2_Msk                (0x3UL << PWR_WUCR3_WUSEL2_Pos)         /*!< 0x0000000C */
#define PWR_WUCR3_WUSEL2                    PWR_WUCR3_WUSEL2_Msk                    /*!< Wakeup pin WKUP2 selection field */
#define PWR_WUCR3_WUSEL2_0                  (0x1UL << PWR_WUCR3_WUSEL2_Pos)         /*!< 0x00000004 */
#define PWR_WUCR3_WUSEL2_1                  (0x2UL << PWR_WUCR3_WUSEL2_Pos)         /*!< 0x00000008 */
#define PWR_WUCR3_WUSEL3_Pos                (4UL)
#define PWR_WUCR3_WUSEL3_Msk                (0x3UL << PWR_WUCR3_WUSEL3_Pos)         /*!< 0x00000030 */
#define PWR_WUCR3_WUSEL3                    PWR_WUCR3_WUSEL3_Msk                    /*!< Wakeup pin WKUP3 selection field */
#define PWR_WUCR3_WUSEL3_0                  (0x1UL << PWR_WUCR3_WUSEL3_Pos)         /*!< 0x00000010 */
#define PWR_WUCR3_WUSEL3_1                  (0x2UL << PWR_WUCR3_WUSEL3_Pos)         /*!< 0x00000020 */
#define PWR_WUCR3_WUSEL4_Pos                (6UL)
#define PWR_WUCR3_WUSEL4_Msk                (0x3UL << PWR_WUCR3_WUSEL4_Pos)         /*!< 0x000000C0 */
#define PWR_WUCR3_WUSEL4                    PWR_WUCR3_WUSEL4_Msk                    /*!< Wakeup pin WKUP4 selection field */
#define PWR_WUCR3_WUSEL4_0                  (0x1UL << PWR_WUCR3_WUSEL4_Pos)         /*!< 0x00000040 */
#define PWR_WUCR3_WUSEL4_1                  (0x2UL << PWR_WUCR3_WUSEL4_Pos)         /*!< 0x00000080 */
#define PWR_WUCR3_WUSEL5_Pos                (8UL)
#define PWR_WUCR3_WUSEL5_Msk                (0x3UL << PWR_WUCR3_WUSEL5_Pos)         /*!< 0x00000300 */
#define PWR_WUCR3_WUSEL5                    PWR_WUCR3_WUSEL5_Msk                    /*!< Wakeup pin WKUP5 selection field */
#define PWR_WUCR3_WUSEL5_0                  (0x1UL << PWR_WUCR3_WUSEL5_Pos)         /*!< 0x00000100 */
#define PWR_WUCR3_WUSEL5_1                  (0x2UL << PWR_WUCR3_WUSEL5_Pos)         /*!< 0x00000200 */
#define PWR_WUCR3_WUSEL6_Pos                (10UL)
#define PWR_WUCR3_WUSEL6_Msk                (0x3UL << PWR_WUCR3_WUSEL6_Pos)         /*!< 0x00000C00 */
#define PWR_WUCR3_WUSEL6                    PWR_WUCR3_WUSEL6_Msk                    /*!< Wakeup pin WKUP6 selection field */
#define PWR_WUCR3_WUSEL6_0                  (0x1UL << PWR_WUCR3_WUSEL6_Pos)         /*!< 0x00000400 */
#define PWR_WUCR3_WUSEL6_1                  (0x2UL << PWR_WUCR3_WUSEL6_Pos)         /*!< 0x00000800 */
#define PWR_WUCR3_WUSEL7_Pos                (12UL)
#define PWR_WUCR3_WUSEL7_Msk                (0x3UL << PWR_WUCR3_WUSEL7_Pos)         /*!< 0x00003000 */
#define PWR_WUCR3_WUSEL7                    PWR_WUCR3_WUSEL7_Msk                    /*!< Wakeup pin WKUP7 selection field */
#define PWR_WUCR3_WUSEL7_0                  (0x1UL << PWR_WUCR3_WUSEL7_Pos)         /*!< 0x00001000 */
#define PWR_WUCR3_WUSEL7_1                  (0x2UL << PWR_WUCR3_WUSEL7_Pos)         /*!< 0x00002000 */
#define PWR_WUCR3_WUSEL8_Pos                (14UL)
#define PWR_WUCR3_WUSEL8_Msk                (0x3UL << PWR_WUCR3_WUSEL8_Pos)         /*!< 0x0000C000 */
#define PWR_WUCR3_WUSEL8                    PWR_WUCR3_WUSEL8_Msk                    /*!< Wakeup pin WKUP8 selection field */
#define PWR_WUCR3_WUSEL8_0                  (0x1UL << PWR_WUCR3_WUSEL8_Pos)         /*!< 0x00004000 */
#define PWR_WUCR3_WUSEL8_1                  (0x2UL << PWR_WUCR3_WUSEL8_Pos)         /*!< 0x00008000 */

/********************  Bit definition for PWR_DBPR register  ******************/
#define PWR_DBPR_DBP_Pos                    (0UL)
#define PWR_DBPR_DBP_Msk                    (0x1UL << PWR_DBPR_DBP_Pos)             /*!< 0x00000001 */
#define PWR_DBPR_DBP                        PWR_DBPR_DBP_Msk                        /*!< Disable backup domain write protection */

/*******************  Bit definition for PWR_SECCFGR register  ****************/
#define PWR_SECCFGR_WUP1SEC_Pos             (0UL)
#define PWR_SECCFGR_WUP1SEC_Msk             (0x1UL << PWR_SECCFGR_WUP1SEC_Pos)      /*!< 0x00000001 */
#define PWR_SECCFGR_WUP1SEC                 PWR_SECCFGR_WUP1SEC_Msk                 /*!< WUP1 secure protection                             */
#define PWR_SECCFGR_WUP2SEC_Pos             (1UL)
#define PWR_SECCFGR_WUP2SEC_Msk             (0x1UL << PWR_SECCFGR_WUP2SEC_Pos)      /*!< 0x00000002 */
#define PWR_SECCFGR_WUP2SEC                 PWR_SECCFGR_WUP2SEC_Msk                 /*!< WUP2 secure protection                             */
#define PWR_SECCFGR_WUP3SEC_Pos             (2UL)
#define PWR_SECCFGR_WUP3SEC_Msk             (0x1UL << PWR_SECCFGR_WUP3SEC_Pos)      /*!< 0x00000004 */
#define PWR_SECCFGR_WUP3SEC                 PWR_SECCFGR_WUP3SEC_Msk                 /*!< WUP3 secure protection                             */
#define PWR_SECCFGR_WUP4SEC_Pos             (3UL)
#define PWR_SECCFGR_WUP4SEC_Msk             (0x1UL << PWR_SECCFGR_WUP4SEC_Pos)      /*!< 0x00000008 */
#define PWR_SECCFGR_WUP4SEC                 PWR_SECCFGR_WUP4SEC_Msk                 /*!< WUP4 secure protection                             */
#define PWR_SECCFGR_WUP5SEC_Pos             (4UL)
#define PWR_SECCFGR_WUP5SEC_Msk             (0x1UL << PWR_SECCFGR_WUP5SEC_Pos)      /*!< 0x00000010 */
#define PWR_SECCFGR_WUP5SEC                 PWR_SECCFGR_WUP5SEC_Msk                 /*!< WUP5 secure protection                             */
#define PWR_SECCFGR_WUP6SEC_Pos             (5UL)
#define PWR_SECCFGR_WUP6SEC_Msk             (0x1UL << PWR_SECCFGR_WUP6SEC_Pos)      /*!< 0x00000020 */
#define PWR_SECCFGR_WUP6SEC                 PWR_SECCFGR_WUP6SEC_Msk                 /*!< WUP6 secure protection                             */
#define PWR_SECCFGR_WUP7SEC_Pos             (6UL)
#define PWR_SECCFGR_WUP7SEC_Msk             (0x1UL << PWR_SECCFGR_WUP7SEC_Pos)      /*!< 0x00000040 */
#define PWR_SECCFGR_WUP7SEC                 PWR_SECCFGR_WUP7SEC_Msk                 /*!< WUP7 secure protection                             */
#define PWR_SECCFGR_WUP8SEC_Pos             (7UL)
#define PWR_SECCFGR_WUP8SEC_Msk             (0x1UL << PWR_SECCFGR_WUP8SEC_Pos)      /*!< 0x00000080 */
#define PWR_SECCFGR_WUP8SEC                 PWR_SECCFGR_WUP8SEC_Msk                 /*!< WUP8 secure protection                             */
#define PWR_SECCFGR_LPMSEC_Pos              (12UL)
#define PWR_SECCFGR_LPMSEC_Msk              (0x1UL << PWR_SECCFGR_LPMSEC_Pos)       /*!< 0x00001000 */
#define PWR_SECCFGR_LPMSEC                  PWR_SECCFGR_LPMSEC_Msk                  /*!< Low-power modes secure protection                  */
#define PWR_SECCFGR_VDMSEC_Pos              (13UL)
#define PWR_SECCFGR_VDMSEC_Msk              (0x1UL << PWR_SECCFGR_VDMSEC_Pos)       /*!< 0x00002000 */
#define PWR_SECCFGR_VDMSEC                  PWR_SECCFGR_VDMSEC_Msk                  /*!< Voltage detection and monitoring secure protection */
#define PWR_SECCFGR_VBSEC_Pos               (14UL)
#define PWR_SECCFGR_VBSEC_Msk               (0x1UL << PWR_SECCFGR_VBSEC_Pos)        /*!< 0x00004000 */
#define PWR_SECCFGR_VBSEC                   PWR_SECCFGR_VBSEC_Msk                   /*!< Backup domain secure protection                    */

/*******************  Bit definition for PWR_PRIVCFGR register  ***************/
#define PWR_PRIVCFGR_SPRIV_Pos              (0UL)
#define PWR_PRIVCFGR_SPRIV_Msk              (0x1UL << PWR_PRIVCFGR_SPRIV_Pos)       /*!< 0x00000001 */
#define PWR_PRIVCFGR_SPRIV                  PWR_PRIVCFGR_SPRIV_Msk                  /*!< RCC secure functions privilege configuration     */
#define PWR_PRIVCFGR_NSPRIV_Pos             (1UL)
#define PWR_PRIVCFGR_NSPRIV_Msk             (0x1UL << PWR_PRIVCFGR_NSPRIV_Pos)      /*!< 0x00000002 */
#define PWR_PRIVCFGR_NSPRIV                 PWR_PRIVCFGR_NSPRIV_Msk                 /*!< RCC non-secure functions privilege configuration */

/**********************  Bit definition for PWR_SR register  ******************/
#define PWR_SR_CSSF_Pos                     (0UL)
#define PWR_SR_CSSF_Msk                     (0x1UL << PWR_SR_CSSF_Pos)              /*!< 0x00000001 */
#define PWR_SR_CSSF                         PWR_SR_CSSF_Msk                         /*!< Clear Stop and Standby/Shutdown flags */
#define PWR_SR_STOPF_Pos                    (1UL)
#define PWR_SR_STOPF_Msk                    (0x1UL << PWR_SR_STOPF_Pos)             /*!< 0x00000002 */
#define PWR_SR_STOPF                        PWR_SR_STOPF_Msk                        /*!< Stop flag                             */
#define PWR_SR_SBF_Pos                      (2UL)
#define PWR_SR_SBF_Msk                      (0x1UL << PWR_SR_SBF_Pos)               /*!< 0x00000004 */
#define PWR_SR_SBF                          PWR_SR_SBF_Msk                          /*!< Standby/Shutdown flag                 */
#define PWR_SR_STOP2F_Pos                   (3UL)
#define PWR_SR_STOP2F_Msk                   (0x1UL << PWR_SR_STOP2F_Pos)            /*!< 0x00000008 */
#define PWR_SR_STOP2F                       PWR_SR_STOP2F_Msk                       /*!< Stop 2 flag                           */

/********************  Bit definition for PWR_SVMSR register  *****************/
#define PWR_SVMSR_REGS_Pos                  (1UL)
#define PWR_SVMSR_REGS_Msk                  (0x1UL << PWR_SVMSR_REGS_Pos)           /*!< 0x00000002 */
#define PWR_SVMSR_REGS                      PWR_SVMSR_REGS_Msk                      /*!< Regulator status                                  */
#define PWR_SVMSR_PVDO_Pos                  (4UL)
#define PWR_SVMSR_PVDO_Msk                  (0x1UL << PWR_SVMSR_PVDO_Pos)           /*!< 0x00000010 */
#define PWR_SVMSR_PVDO                      PWR_SVMSR_PVDO_Msk                      /*!< VDD voltage detector output                       */
#define PWR_SVMSR_ACTVOSRDY_Pos             (15UL)
#define PWR_SVMSR_ACTVOSRDY_Msk             (0x1UL << PWR_SVMSR_ACTVOSRDY_Pos)      /*!< 0x00008000 */
#define PWR_SVMSR_ACTVOSRDY                 PWR_SVMSR_ACTVOSRDY_Msk                 /*!< Voltage level ready for currently used VOS        */
#define PWR_SVMSR_ACTVOS_Pos                (16UL)
#define PWR_SVMSR_ACTVOS_Msk                (0x1UL << PWR_SVMSR_ACTVOS_Pos)         /*!< 0x00010000 */
#define PWR_SVMSR_ACTVOS                    PWR_SVMSR_ACTVOS_Msk                    /*!< Voltage Output Scaling currently applied to VCORE */

/*********************  Bit definition for PWR_WUSR register  *****************/
#define PWR_WUSR_WUF1_Pos                   (0UL)
#define PWR_WUSR_WUF1_Msk                   (0x1UL << PWR_WUSR_WUF1_Pos)            /*!< 0x00000001 */
#define PWR_WUSR_WUF1                       PWR_WUSR_WUF1_Msk                       /*!< Wakeup flag 1   */
#define PWR_WUSR_WUF2_Pos                   (1UL)
#define PWR_WUSR_WUF2_Msk                   (0x1UL << PWR_WUSR_WUF2_Pos)            /*!< 0x00000002 */
#define PWR_WUSR_WUF2                       PWR_WUSR_WUF2_Msk                       /*!< Wakeup flag 2   */
#define PWR_WUSR_WUF3_Pos                   (2UL)
#define PWR_WUSR_WUF3_Msk                   (0x1UL << PWR_WUSR_WUF3_Pos)            /*!< 0x00000004 */
#define PWR_WUSR_WUF3                       PWR_WUSR_WUF3_Msk                       /*!< Wakeup flag 3   */
#define PWR_WUSR_WUF4_Pos                   (3UL)
#define PWR_WUSR_WUF4_Msk                   (0x1UL << PWR_WUSR_WUF4_Pos)            /*!< 0x00000008 */
#define PWR_WUSR_WUF4                       PWR_WUSR_WUF4_Msk                       /*!< Wakeup flag 4   */
#define PWR_WUSR_WUF5_Pos                   (4UL)
#define PWR_WUSR_WUF5_Msk                   (0x1UL << PWR_WUSR_WUF5_Pos)            /*!< 0x00000010 */
#define PWR_WUSR_WUF5                       PWR_WUSR_WUF5_Msk                       /*!< Wakeup flag 5   */
#define PWR_WUSR_WUF6_Pos                   (5UL)
#define PWR_WUSR_WUF6_Msk                   (0x1UL << PWR_WUSR_WUF6_Pos)            /*!< 0x00000020 */
#define PWR_WUSR_WUF6                       PWR_WUSR_WUF6_Msk                       /*!< Wakeup flag 6   */
#define PWR_WUSR_WUF7_Pos                   (6UL)
#define PWR_WUSR_WUF7_Msk                   (0x1UL << PWR_WUSR_WUF7_Pos)            /*!< 0x00000040 */
#define PWR_WUSR_WUF7                       PWR_WUSR_WUF7_Msk                       /*!< Wakeup flag 7   */
#define PWR_WUSR_WUF8_Pos                   (7UL)
#define PWR_WUSR_WUF8_Msk                   (0x1UL << PWR_WUSR_WUF8_Pos)            /*!< 0x00000080 */
#define PWR_WUSR_WUF8                       PWR_WUSR_WUF8_Msk                       /*!< Wakeup flag 8   */
#define PWR_WUSR_WUF_Pos                    (0UL)
#define PWR_WUSR_WUF_Msk                    (0xFFUL << PWR_WUSR_WUF_Pos)            /*!< 0x000000FF */
#define PWR_WUSR_WUF                        PWR_WUSR_WUF_Msk                        /*!< all Wakeup flag */

/*********************  Bit definition for PWR_WUSCR register  ****************/
#define PWR_WUSCR_CWUF1_Pos                 (0UL)
#define PWR_WUSCR_CWUF1_Msk                 (0x1UL << PWR_WUSCR_CWUF1_Pos)          /*!< 0x00000001*/
#define PWR_WUSCR_CWUF1                     PWR_WUSCR_CWUF1_Msk                     /*!< Wakeup clear flag 1   */
#define PWR_WUSCR_CWUF2_Pos                 (1UL)
#define PWR_WUSCR_CWUF2_Msk                 (0x1UL << PWR_WUSCR_CWUF2_Pos)          /*!< 0x00000002 */
#define PWR_WUSCR_CWUF2                     PWR_WUSCR_CWUF2_Msk                     /*!< Wakeup clear flag 2   */
#define PWR_WUSCR_CWUF3_Pos                 (2UL)
#define PWR_WUSCR_CWUF3_Msk                 (0x1UL << PWR_WUSCR_CWUF3_Pos)          /*!< 0x00000004 */
#define PWR_WUSCR_CWUF3                     PWR_WUSCR_CWUF3_Msk                     /*!< Wakeup clear flag 3   */
#define PWR_WUSCR_CWUF4_Pos                 (3UL)
#define PWR_WUSCR_CWUF4_Msk                 (0x1UL << PWR_WUSCR_CWUF4_Pos)          /*!< 0x00000008 */
#define PWR_WUSCR_CWUF4                     PWR_WUSCR_CWUF4_Msk                     /*!< Wakeup clear flag 4   */
#define PWR_WUSCR_CWUF5_Pos                 (4UL)
#define PWR_WUSCR_CWUF5_Msk                 (0x1UL << PWR_WUSCR_CWUF5_Pos)          /*!< 0x00000010 */
#define PWR_WUSCR_CWUF5                     PWR_WUSCR_CWUF5_Msk                     /*!< Wakeup clear flag 5   */
#define PWR_WUSCR_CWUF6_Pos                 (5UL)
#define PWR_WUSCR_CWUF6_Msk                 (0x1UL << PWR_WUSCR_CWUF6_Pos)          /*!< 0x00000020 */
#define PWR_WUSCR_CWUF6                     PWR_WUSCR_CWUF6_Msk                     /*!< Wakeup clear flag 6   */
#define PWR_WUSCR_CWUF7_Pos                 (6UL)
#define PWR_WUSCR_CWUF7_Msk                 (0x1UL << PWR_WUSCR_CWUF7_Pos)          /*!< 0x00000040 */
#define PWR_WUSCR_CWUF7                     PWR_WUSCR_CWUF7_Msk                     /*!< Wakeup clear flag 7   */
#define PWR_WUSCR_CWUF8_Pos                 (7UL)
#define PWR_WUSCR_CWUF8_Msk                 (0x1UL << PWR_WUSCR_CWUF8_Pos)          /*!< 0x00000080 */
#define PWR_WUSCR_CWUF8                     PWR_WUSCR_CWUF8_Msk                     /*!< Wakeup clear flag 8   */
#define PWR_WUSCR_CWUF_Pos                  (0UL)
#define PWR_WUSCR_CWUF_Msk                  (0xFFUL << PWR_WUSCR_CWUF1_Pos)         /*!< 0x000000FF */
#define PWR_WUSCR_CWUF                      PWR_WUSCR_CWUF_Msk                      /*!< all Wakeup clear flag */

/********************  Bit definition for PWR_IORETENRA register  *****************/
#define PWR_IORETENRA_EN0_Pos               (0UL)
#define PWR_IORETENRA_EN0_Msk               (0x1UL << PWR_IORETENRA_EN0_Pos)           /*!< 0x00000001 */
#define PWR_IORETENRA_EN0                   PWR_IORETENRA_EN0_Msk                      /*!< Standby GPIO retention enable for PA0  */
#define PWR_IORETENRA_EN1_Pos               (1UL)
#define PWR_IORETENRA_EN1_Msk               (0x1UL << PWR_IORETENRA_EN1_Pos)           /*!< 0x00000002 */
#define PWR_IORETENRA_EN1                   PWR_IORETENRA_EN1_Msk                      /*!< Standby GPIO retention enable for PA1  */
#define PWR_IORETENRA_EN2_Pos               (2UL)
#define PWR_IORETENRA_EN2_Msk               (0x1UL << PWR_IORETENRA_EN2_Pos)           /*!< 0x00000004 */
#define PWR_IORETENRA_EN2                   PWR_IORETENRA_EN2_Msk                      /*!< Standby GPIO retention enable for PA2  */
#define PWR_IORETENRA_EN3_Pos               (3UL)
#define PWR_IORETENRA_EN3_Msk               (0x1UL << PWR_IORETENRA_EN3_Pos)           /*!< 0x00000008 */
#define PWR_IORETENRA_EN3                   PWR_IORETENRA_EN3_Msk                      /*!< Standby GPIO retention enable for PA3  */
#define PWR_IORETENRA_EN4_Pos               (4UL)
#define PWR_IORETENRA_EN4_Msk               (0x1UL << PWR_IORETENRA_EN4_Pos)           /*!< 0x00000010 */
#define PWR_IORETENRA_EN4                   PWR_IORETENRA_EN4_Msk                      /*!< Standby GPIO retention enable for PA4  */
#define PWR_IORETENRA_EN5_Pos               (5UL)
#define PWR_IORETENRA_EN5_Msk               (0x1UL << PWR_IORETENRA_EN5_Pos)           /*!< 0x00000020 */
#define PWR_IORETENRA_EN5                   PWR_IORETENRA_EN5_Msk                      /*!< Standby GPIO retention enable for PA5  */
#define PWR_IORETENRA_EN6_Pos               (6UL)
#define PWR_IORETENRA_EN6_Msk               (0x1UL << PWR_IORETENRA_EN6_Pos)           /*!< 0x00000040 */
#define PWR_IORETENRA_EN6                   PWR_IORETENRA_EN6_Msk                      /*!< Standby GPIO retention enable for PA6  */
#define PWR_IORETENRA_EN7_Pos               (7UL)
#define PWR_IORETENRA_EN7_Msk               (0x1UL << PWR_IORETENRA_EN7_Pos)           /*!< 0x00000080 */
#define PWR_IORETENRA_EN7                   PWR_IORETENRA_EN7_Msk                      /*!< Standby GPIO retention enable for PA7  */
#define PWR_IORETENRA_EN8_Pos               (8UL)
#define PWR_IORETENRA_EN8_Msk               (0x1UL << PWR_IORETENRA_EN8_Pos)           /*!< 0x00000100 */
#define PWR_IORETENRA_EN8                   PWR_IORETENRA_EN8_Msk                      /*!< Standby GPIO retention enable for PA8  */
#define PWR_IORETENRA_EN9_Pos               (9UL)
#define PWR_IORETENRA_EN9_Msk               (0x1UL << PWR_IORETENRA_EN9_Pos)           /*!< 0x00000200 */
#define PWR_IORETENRA_EN9                   PWR_IORETENRA_EN9_Msk                      /*!< Standby GPIO retention enable for PA9  */
#define PWR_IORETENRA_EN10_Pos              (10UL)
#define PWR_IORETENRA_EN10_Msk              (0x1UL << PWR_IORETENRA_EN10_Pos)          /*!< 0x00000400 */
#define PWR_IORETENRA_EN10                  PWR_IORETENRA_EN10_Msk                     /*!< Standby GPIO retention enable for PA10 */
#define PWR_IORETENRA_EN11_Pos              (11UL)
#define PWR_IORETENRA_EN11_Msk              (0x1UL << PWR_IORETENRA_EN11_Pos)          /*!< 0x00000800 */
#define PWR_IORETENRA_EN11                  PWR_IORETENRA_EN11_Msk                     /*!< Standby GPIO retention enable for PA11 */
#define PWR_IORETENRA_EN12_Pos              (12UL)
#define PWR_IORETENRA_EN12_Msk              (0x1UL << PWR_IORETENRA_EN12_Pos)          /*!< 0x00001000 */
#define PWR_IORETENRA_EN12                  PWR_IORETENRA_EN12_Msk                     /*!< Standby GPIO retention enable for PA12 */
#define PWR_IORETENRA_EN13_Pos              (13UL)
#define PWR_IORETENRA_EN13_Msk              (0x1UL << PWR_IORETENRA_EN13_Pos)          /*!< 0x00002000 */
#define PWR_IORETENRA_EN13                  PWR_IORETENRA_EN13_Msk                     /*!< Standby GPIO retention enable for PA13 */
#define PWR_IORETENRA_EN14_Pos              (14UL)
#define PWR_IORETENRA_EN14_Msk              (0x1UL << PWR_IORETENRA_EN14_Pos)          /*!< 0x00004000 */
#define PWR_IORETENRA_EN14                  PWR_IORETENRA_EN14_Msk                     /*!< Standby GPIO retention enable for PA14 */
#define PWR_IORETENRA_EN15_Pos              (15UL)
#define PWR_IORETENRA_EN15_Msk              (0x1UL << PWR_IORETENRA_EN15_Pos)          /*!< 0x00008000 */
#define PWR_IORETENRA_EN15                  PWR_IORETENRA_EN15_Msk                     /*!< Standby GPIO retention enable for PA15 */

/********************  Bit definition for PWR_IORETRA register  *****************/
#define PWR_IORETRA_RET0_Pos                (0UL)
#define PWR_IORETRA_RET0_Msk                (0x1UL << PWR_IORETRA_RET0_Pos)            /*!< 0x00000001 */
#define PWR_IORETRA_RET0                    PWR_IORETRA_RET0_Msk                       /*!< Standby GPIO retention status for PA0  */
#define PWR_IORETRA_RET1_Pos                (1UL)
#define PWR_IORETRA_RET1_Msk                (0x1UL << PWR_IORETRA_RET1_Pos)            /*!< 0x00000002 */
#define PWR_IORETRA_RET1                    PWR_IORETRA_RET1_Msk                       /*!< Standby GPIO retention status for PA1  */
#define PWR_IORETRA_RET2_Pos                (2UL)
#define PWR_IORETRA_RET2_Msk                (0x1UL << PWR_IORETRA_RET2_Pos)            /*!< 0x00000004 */
#define PWR_IORETRA_RET2                    PWR_IORETRA_RET2_Msk                       /*!< Standby GPIO retention status for PA2  */
#define PWR_IORETRA_RET3_Pos                (3UL)
#define PWR_IORETRA_RET3_Msk                (0x1UL << PWR_IORETRA_RET3_Pos)            /*!< 0x00000008 */
#define PWR_IORETRA_RET3                    PWR_IORETRA_RET3_Msk                       /*!< Standby GPIO retention status for PA3  */
#define PWR_IORETRA_RET4_Pos                (4UL)
#define PWR_IORETRA_RET4_Msk                (0x1UL << PWR_IORETRA_RET4_Pos)            /*!< 0x00000010 */
#define PWR_IORETRA_RET4                    PWR_IORETRA_RET4_Msk                       /*!< Standby GPIO retention status for PA4  */
#define PWR_IORETRA_RET5_Pos                (5UL)
#define PWR_IORETRA_RET5_Msk                (0x1UL << PWR_IORETRA_RET5_Pos)            /*!< 0x00000020 */
#define PWR_IORETRA_RET5                    PWR_IORETRA_RET5_Msk                       /*!< Standby GPIO retention status for PA5  */
#define PWR_IORETRA_RET6_Pos                (6UL)
#define PWR_IORETRA_RET6_Msk                (0x1UL << PWR_IORETRA_RET6_Pos)            /*!< 0x00000040 */
#define PWR_IORETRA_RET6                    PWR_IORETRA_RET6_Msk                       /*!< Standby GPIO retention status for PA6  */
#define PWR_IORETRA_RET7_Pos                (7UL)
#define PWR_IORETRA_RET7_Msk                (0x1UL << PWR_IORETRA_RET7_Pos)            /*!< 0x00000080 */
#define PWR_IORETRA_RET7                    PWR_IORETRA_RET7_Msk                       /*!< Standby GPIO retention status for PA7  */
#define PWR_IORETRA_RET8_Pos                (8UL)
#define PWR_IORETRA_RET8_Msk                (0x1UL << PWR_IORETRA_RET8_Pos)            /*!< 0x00000100 */
#define PWR_IORETRA_RET8                    PWR_IORETRA_RET8_Msk                       /*!< Standby GPIO retention status for PA8  */
#define PWR_IORETRA_RET9_Pos                (9UL)
#define PWR_IORETRA_RET9_Msk                (0x1UL << PWR_IORETRA_RET9_Pos)            /*!< 0x00000200 */
#define PWR_IORETRA_RET9                    PWR_IORETRA_RET9_Msk                       /*!< Standby GPIO retention status for PA9  */
#define PWR_IORETRA_RET10_Pos               (10UL)
#define PWR_IORETRA_RET10_Msk               (0x1UL << PWR_IORETRA_RET10_Pos)           /*!< 0x00000400 */
#define PWR_IORETRA_RET10                   PWR_IORETRA_RET10_Msk                      /*!< Standby GPIO retention status for PA10 */
#define PWR_IORETRA_RET11_Pos               (11UL)
#define PWR_IORETRA_RET11_Msk               (0x1UL << PWR_IORETRA_RET11_Pos)           /*!< 0x00000800 */
#define PWR_IORETRA_RET11                   PWR_IORETRA_RET11_Msk                      /*!< Standby GPIO retention status for PA11 */
#define PWR_IORETRA_RET12_Pos               (12UL)
#define PWR_IORETRA_RET12_Msk               (0x1UL << PWR_IORETRA_RET12_Pos)           /*!< 0x00001000 */
#define PWR_IORETRA_RET12                   PWR_IORETRA_RET12_Msk                      /*!< Standby GPIO retention status for PA12 */
#define PWR_IORETRA_RET13_Pos               (13UL)
#define PWR_IORETRA_RET13_Msk               (0x1UL << PWR_IORETRA_RET13_Pos)           /*!< 0x00002000 */
#define PWR_IORETRA_RET13                   PWR_IORETRA_RET13_Msk                      /*!< Standby GPIO retention status for PA13 */
#define PWR_IORETRA_RET14_Pos               (14UL)
#define PWR_IORETRA_RET14_Msk               (0x1UL << PWR_IORETRA_RET14_Pos)           /*!< 0x00004000 */
#define PWR_IORETRA_RET14                   PWR_IORETRA_RET14_Msk                      /*!< Standby GPIO retention status for PA14 */
#define PWR_IORETRA_RET15_Pos               (15UL)
#define PWR_IORETRA_RET15_Msk               (0x1UL << PWR_IORETRA_RET15_Pos)           /*!< 0x00008000 */
#define PWR_IORETRA_RET15                   PWR_IORETRA_RET15_Msk                      /*!< Standby GPIO retention status for PA15 */

/********************  Bit definition for PWR_IORETENRB register  *****************/
#define PWR_IORETENRB_EN0_Pos               (0UL)
#define PWR_IORETENRB_EN0_Msk               (0x1UL << PWR_IORETENRB_EN0_Pos)           /*!< 0x00000001 */
#define PWR_IORETENRB_EN0                   PWR_IORETENRB_EN0_Msk                      /*!< Standby GPIO retention enable for PB0  */
#define PWR_IORETENRB_EN1_Pos               (1UL)
#define PWR_IORETENRB_EN1_Msk               (0x1UL << PWR_IORETENRB_EN1_Pos)           /*!< 0x00000002 */
#define PWR_IORETENRB_EN1                   PWR_IORETENRB_EN1_Msk                      /*!< Standby GPIO retention enable for PB1  */
#define PWR_IORETENRB_EN2_Pos               (2UL)
#define PWR_IORETENRB_EN2_Msk               (0x1UL << PWR_IORETENRB_EN2_Pos)           /*!< 0x00000004 */
#define PWR_IORETENRB_EN2                   PWR_IORETENRB_EN2_Msk                      /*!< Standby GPIO retention enable for PB2  */
#define PWR_IORETENRB_EN3_Pos               (3UL)
#define PWR_IORETENRB_EN3_Msk               (0x1UL << PWR_IORETENRB_EN3_Pos)           /*!< 0x00000008 */
#define PWR_IORETENRB_EN3                   PWR_IORETENRB_EN3_Msk                      /*!< Standby GPIO retention enable for PB3  */
#define PWR_IORETENRB_EN4_Pos               (4UL)
#define PWR_IORETENRB_EN4_Msk               (0x1UL << PWR_IORETENRB_EN4_Pos)           /*!< 0x00000010 */
#define PWR_IORETENRB_EN4                   PWR_IORETENRB_EN4_Msk                      /*!< Standby GPIO retention enable for PB4  */
#define PWR_IORETENRB_EN5_Pos               (5UL)
#define PWR_IORETENRB_EN5_Msk               (0x1UL << PWR_IORETENRB_EN5_Pos)           /*!< 0x00000020 */
#define PWR_IORETENRB_EN5                   PWR_IORETENRB_EN5_Msk                      /*!< Standby GPIO retention enable for PB5  */
#define PWR_IORETENRB_EN6_Pos               (6UL)
#define PWR_IORETENRB_EN6_Msk               (0x1UL << PWR_IORETENRB_EN6_Pos)           /*!< 0x00000040 */
#define PWR_IORETENRB_EN6                   PWR_IORETENRB_EN6_Msk                      /*!< Standby GPIO retention enable for PB6  */
#define PWR_IORETENRB_EN7_Pos               (7UL)
#define PWR_IORETENRB_EN7_Msk               (0x1UL << PWR_IORETENRB_EN7_Pos)           /*!< 0x00000080 */
#define PWR_IORETENRB_EN7                   PWR_IORETENRB_EN7_Msk                      /*!< Standby GPIO retention enable for PB7  */
#define PWR_IORETENRB_EN8_Pos               (8UL)
#define PWR_IORETENRB_EN8_Msk               (0x1UL << PWR_IORETENRB_EN8_Pos)           /*!< 0x00000100 */
#define PWR_IORETENRB_EN8                   PWR_IORETENRB_EN8_Msk                      /*!< Standby GPIO retention enable for PB8  */
#define PWR_IORETENRB_EN9_Pos               (9UL)
#define PWR_IORETENRB_EN9_Msk               (0x1UL << PWR_IORETENRB_EN9_Pos)           /*!< 0x00000200 */
#define PWR_IORETENRB_EN9                   PWR_IORETENRB_EN9_Msk                      /*!< Standby GPIO retention enable for PB9  */
#define PWR_IORETENRB_EN10_Pos              (10UL)
#define PWR_IORETENRB_EN10_Msk              (0x1UL << PWR_IORETENRB_EN10_Pos)          /*!< 0x00000400 */
#define PWR_IORETENRB_EN10                  PWR_IORETENRB_EN10_Msk                     /*!< Standby GPIO retention enable for PB10 */
#define PWR_IORETENRB_EN11_Pos              (11UL)
#define PWR_IORETENRB_EN11_Msk              (0x1UL << PWR_IORETENRB_EN11_Pos)          /*!< 0x00000800 */
#define PWR_IORETENRB_EN11                  PWR_IORETENRB_EN11_Msk                     /*!< Standby GPIO retention enable for PB11 */
#define PWR_IORETENRB_EN12_Pos              (12UL)
#define PWR_IORETENRB_EN12_Msk              (0x1UL << PWR_IORETENRB_EN12_Pos)          /*!< 0x00001000 */
#define PWR_IORETENRB_EN12                  PWR_IORETENRB_EN12_Msk                     /*!< Standby GPIO retention enable for PB12 */
#define PWR_IORETENRB_EN13_Pos              (13UL)
#define PWR_IORETENRB_EN13_Msk              (0x1UL << PWR_IORETENRB_EN13_Pos)          /*!< 0x00002000 */
#define PWR_IORETENRB_EN13                  PWR_IORETENRB_EN13_Msk                     /*!< Standby GPIO retention enable for PB13 */
#define PWR_IORETENRB_EN14_Pos              (14UL)
#define PWR_IORETENRB_EN14_Msk              (0x1UL << PWR_IORETENRB_EN14_Pos)          /*!< 0x00004000 */
#define PWR_IORETENRB_EN14                  PWR_IORETENRB_EN14_Msk                     /*!< Standby GPIO retention enable for PB14 */
#define PWR_IORETENRB_EN15_Pos              (15UL)
#define PWR_IORETENRB_EN15_Msk              (0x1UL << PWR_IORETENRB_EN15_Pos)          /*!< 0x00008000 */
#define PWR_IORETENRB_EN15                  PWR_IORETENRB_EN15_Msk                     /*!< Standby GPIO retention enable for PB15 */

/********************  Bit definition for PWR_IORETRB register  *****************/
#define PWR_IORETRB_RET0_Pos                (0UL)
#define PWR_IORETRB_RET0_Msk                (0x1UL << PWR_IORETRB_RET0_Pos)            /*!< 0x00000001 */
#define PWR_IORETRB_RET0                    PWR_IORETRB_RET0_Msk                       /*!< Standby GPIO retention status for PB0  */
#define PWR_IORETRB_RET1_Pos                (1UL)
#define PWR_IORETRB_RET1_Msk                (0x1UL << PWR_IORETRB_RET1_Pos)            /*!< 0x00000002 */
#define PWR_IORETRB_RET1                    PWR_IORETRB_RET1_Msk                       /*!< Standby GPIO retention status for PB1  */
#define PWR_IORETRB_RET2_Pos                (2UL)
#define PWR_IORETRB_RET2_Msk                (0x1UL << PWR_IORETRB_RET2_Pos)            /*!< 0x00000004 */
#define PWR_IORETRB_RET2                    PWR_IORETRB_RET2_Msk                       /*!< Standby GPIO retention status for PB2  */
#define PWR_IORETRB_RET3_Pos                (3UL)
#define PWR_IORETRB_RET3_Msk                (0x1UL << PWR_IORETRB_RET3_Pos)            /*!< 0x00000008 */
#define PWR_IORETRB_RET3                    PWR_IORETRB_RET3_Msk                       /*!< Standby GPIO retention status for PB3  */
#define PWR_IORETRB_RET4_Pos                (4UL)
#define PWR_IORETRB_RET4_Msk                (0x1UL << PWR_IORETRB_RET4_Pos)            /*!< 0x00000010 */
#define PWR_IORETRB_RET4                    PWR_IORETRB_RET4_Msk                       /*!< Standby GPIO retention status for PB4  */
#define PWR_IORETRB_RET5_Pos                (5UL)
#define PWR_IORETRB_RET5_Msk                (0x1UL << PWR_IORETRB_RET5_Pos)            /*!< 0x00000020 */
#define PWR_IORETRB_RET5                    PWR_IORETRB_RET5_Msk                       /*!< Standby GPIO retention status for PB5  */
#define PWR_IORETRB_RET6_Pos                (6UL)
#define PWR_IORETRB_RET6_Msk                (0x1UL << PWR_IORETRB_RET6_Pos)            /*!< 0x00000040 */
#define PWR_IORETRB_RET6                    PWR_IORETRB_RET6_Msk                       /*!< Standby GPIO retention status for PB6  */
#define PWR_IORETRB_RET7_Pos                (7UL)
#define PWR_IORETRB_RET7_Msk                (0x1UL << PWR_IORETRB_RET7_Pos)            /*!< 0x00000080 */
#define PWR_IORETRB_RET7                    PWR_IORETRB_RET7_Msk                       /*!< Standby GPIO retention status for PB7  */
#define PWR_IORETRB_RET8_Pos                (8UL)
#define PWR_IORETRB_RET8_Msk                (0x1UL << PWR_IORETRB_RET8_Pos)            /*!< 0x00000100 */
#define PWR_IORETRB_RET8                    PWR_IORETRB_RET8_Msk                       /*!< Standby GPIO retention status for PB8  */
#define PWR_IORETRB_RET9_Pos                (9UL)
#define PWR_IORETRB_RET9_Msk                (0x1UL << PWR_IORETRB_RET9_Pos)            /*!< 0x00000200 */
#define PWR_IORETRB_RET9                    PWR_IORETRB_RET9_Msk                       /*!< Standby GPIO retention status for PB9  */
#define PWR_IORETRB_RET10_Pos               (10UL)
#define PWR_IORETRB_RET10_Msk               (0x1UL << PWR_IORETRB_RET10_Pos)           /*!< 0x00000400 */
#define PWR_IORETRB_RET10                   PWR_IORETRB_RET10_Msk                      /*!< Standby GPIO retention status for PB10 */
#define PWR_IORETRB_RET11_Pos               (11UL)
#define PWR_IORETRB_RET11_Msk               (0x1UL << PWR_IORETRB_RET11_Pos)           /*!< 0x00000800 */
#define PWR_IORETRB_RET11                   PWR_IORETRB_RET11_Msk                      /*!< Standby GPIO retention status for PB11 */
#define PWR_IORETRB_RET12_Pos               (12UL)
#define PWR_IORETRB_RET12_Msk               (0x1UL << PWR_IORETRB_RET12_Pos)           /*!< 0x00001000 */
#define PWR_IORETRB_RET12                   PWR_IORETRB_RET12_Msk                      /*!< Standby GPIO retention status for PB12 */
#define PWR_IORETRB_RET13_Pos               (13UL)
#define PWR_IORETRB_RET13_Msk               (0x1UL << PWR_IORETRB_RET13_Pos)           /*!< 0x00002000 */
#define PWR_IORETRB_RET13                   PWR_IORETRB_RET13_Msk                      /*!< Standby GPIO retention status for PB13 */
#define PWR_IORETRB_RET14_Pos               (14UL)
#define PWR_IORETRB_RET14_Msk               (0x1UL << PWR_IORETRB_RET14_Pos)           /*!< 0x00004000 */
#define PWR_IORETRB_RET14                   PWR_IORETRB_RET14_Msk                      /*!< Standby GPIO retention status for PB14 */
#define PWR_IORETRB_RET15_Pos               (15UL)
#define PWR_IORETRB_RET15_Msk               (0x1UL << PWR_IORETRB_RET15_Pos)           /*!< 0x00008000 */
#define PWR_IORETRB_RET15                   PWR_IORETRB_RET15_Msk                      /*!< Standby GPIO retention status for PB15 */

/********************  Bit definition for PWR_IORETENRC register  *****************/
#define PWR_IORETENRC_EN0_Pos               (0UL)
#define PWR_IORETENRC_EN0_Msk               (0x1UL << PWR_IORETENRC_EN0_Pos)           /*!< 0x00000001 */
#define PWR_IORETENRC_EN0                   PWR_IORETENRC_EN0_Msk                      /*!< Standby GPIO retention enable for PC0 */
#define PWR_IORETENRC_EN1_Pos               (1UL)
#define PWR_IORETENRC_EN1_Msk               (0x1UL << PWR_IORETENRC_EN1_Pos)           /*!< 0x00000002 */
#define PWR_IORETENRC_EN1                   PWR_IORETENRC_EN1_Msk                      /*!< Standby GPIO retention enable for PC1 */
#define PWR_IORETENRC_EN2_Pos               (2UL)
#define PWR_IORETENRC_EN2_Msk               (0x1UL << PWR_IORETENRC_EN2_Pos)           /*!< 0x00000004 */
#define PWR_IORETENRC_EN2                   PWR_IORETENRC_EN2_Msk                      /*!< Standby GPIO retention enable for PC2 */
#define PWR_IORETENRC_EN3_Pos               (3UL)
#define PWR_IORETENRC_EN3_Msk               (0x1UL << PWR_IORETENRC_EN3_Pos)           /*!< 0x00000008 */
#define PWR_IORETENRC_EN3                   PWR_IORETENRC_EN3_Msk                      /*!< Standby GPIO retention enable for PC3 */
#define PWR_IORETENRC_EN4_Pos               (4UL)
#define PWR_IORETENRC_EN4_Msk               (0x1UL << PWR_IORETENRC_EN4_Pos)           /*!< 0x00000010 */
#define PWR_IORETENRC_EN4                   PWR_IORETENRC_EN4_Msk                      /*!< Standby GPIO retention enable for PC4 */
#define PWR_IORETENRC_EN5_Pos               (5UL)
#define PWR_IORETENRC_EN5_Msk               (0x1UL << PWR_IORETENRC_EN5_Pos)           /*!< 0x00000020 */
#define PWR_IORETENRC_EN5                   PWR_IORETENRC_EN5_Msk                      /*!< Standby GPIO retention enable for PC5 */
#define PWR_IORETENRC_EN6_Pos               (6UL)
#define PWR_IORETENRC_EN6_Msk               (0x1UL << PWR_IORETENRC_EN6_Pos)           /*!< 0x00000040 */
#define PWR_IORETENRC_EN6                   PWR_IORETENRC_EN6_Msk                      /*!< Standby GPIO retention enable for PC6 */
#define PWR_IORETENRC_EN7_Pos               (7UL)
#define PWR_IORETENRC_EN7_Msk               (0x1UL << PWR_IORETENRC_EN7_Pos)           /*!< 0x00000080 */
#define PWR_IORETENRC_EN7                   PWR_IORETENRC_EN7_Msk                      /*!< Standby GPIO retention enable for PC7 */
#define PWR_IORETENRC_EN8_Pos               (8UL)
#define PWR_IORETENRC_EN8_Msk               (0x1UL << PWR_IORETENRC_EN8_Pos)           /*!< 0x00000100 */
#define PWR_IORETENRC_EN8                   PWR_IORETENRC_EN8_Msk                      /*!< Standby GPIO retention enable for PC8 */
#define PWR_IORETENRC_EN9_Pos               (9UL)
#define PWR_IORETENRC_EN9_Msk               (0x1UL << PWR_IORETENRC_EN9_Pos)           /*!< 0x00000200 */
#define PWR_IORETENRC_EN9                   PWR_IORETENRC_EN9_Msk                      /*!< Standby GPIO retention enable for PC9 */
#define PWR_IORETENRC_EN10_Pos              (10UL)
#define PWR_IORETENRC_EN10_Msk              (0x1UL << PWR_IORETENRC_EN10_Pos)          /*!< 0x00000400 */
#define PWR_IORETENRC_EN10                  PWR_IORETENRC_EN10_Msk                     /*!< Standby GPIO retention enable for PC10 */
#define PWR_IORETENRC_EN11_Pos              (11UL)
#define PWR_IORETENRC_EN11_Msk              (0x1UL << PWR_IORETENRC_EN11_Pos)          /*!< 0x00000800 */
#define PWR_IORETENRC_EN11                  PWR_IORETENRC_EN11_Msk                     /*!< Standby GPIO retention enable for PC11 */
#define PWR_IORETENRC_EN12_Pos              (12UL)
#define PWR_IORETENRC_EN12_Msk              (0x1UL << PWR_IORETENRC_EN12_Pos)          /*!< 0x00001000 */
#define PWR_IORETENRC_EN12                  PWR_IORETENRC_EN12_Msk                     /*!< Standby GPIO retention enable for PC12 */
#define PWR_IORETENRC_EN13_Pos              (13UL)
#define PWR_IORETENRC_EN13_Msk              (0x1UL << PWR_IORETENRC_EN13_Pos)          /*!< 0x00002000 */
#define PWR_IORETENRC_EN13                  PWR_IORETENRC_EN13_Msk                     /*!< Standby GPIO retention enable for PC13 */
#define PWR_IORETENRC_EN14_Pos              (14UL)
#define PWR_IORETENRC_EN14_Msk              (0x1UL << PWR_IORETENRC_EN14_Pos)          /*!< 0x00004000 */
#define PWR_IORETENRC_EN14                  PWR_IORETENRC_EN14_Msk                     /*!< Standby GPIO retention enable for PC14 */
#define PWR_IORETENRC_EN15_Pos              (15UL)
#define PWR_IORETENRC_EN15_Msk              (0x1UL << PWR_IORETENRC_EN15_Pos)          /*!< 0x00008000 */
#define PWR_IORETENRC_EN15                  PWR_IORETENRC_EN15_Msk                     /*!< Standby GPIO retention enable for PC15 */

/********************  Bit definition for PWR_IORETRC register  *****************/
#define PWR_IORETRC_RET0_Pos                (0UL)
#define PWR_IORETRC_RET0_Msk                (0x1UL << PWR_IORETRC_RET0_Pos)             /*!< 0x00000001 */
#define PWR_IORETRC_RET0                    PWR_IORETRC_RET0_Msk                        /*!< Standby GPIO retention status for PC0 */
#define PWR_IORETRC_RET1_Pos                (1UL)
#define PWR_IORETRC_RET1_Msk                (0x1UL << PWR_IORETRC_RET1_Pos)             /*!< 0x00000002 */
#define PWR_IORETRC_RET1                    PWR_IORETRC_RET1_Msk                        /*!< Standby GPIO retention status for PC1 */
#define PWR_IORETRC_RET2_Pos                (2UL)
#define PWR_IORETRC_RET2_Msk                (0x1UL << PWR_IORETRC_RET2_Pos)             /*!< 0x00000004 */
#define PWR_IORETRC_RET2                    PWR_IORETRC_RET2_Msk                        /*!< Standby GPIO retention status for PC2 */
#define PWR_IORETRC_RET3_Pos                (3UL)
#define PWR_IORETRC_RET3_Msk                (0x1UL << PWR_IORETRC_RET3_Pos)             /*!< 0x00000008 */
#define PWR_IORETRC_RET3                    PWR_IORETRC_RET3_Msk                        /*!< Standby GPIO retention status for PC3 */
#define PWR_IORETRC_RET4_Pos                (4UL)
#define PWR_IORETRC_RET4_Msk                (0x1UL << PWR_IORETRC_RET4_Pos)             /*!< 0x00000010 */
#define PWR_IORETRC_RET4                    PWR_IORETRC_RET4_Msk                        /*!< Standby GPIO retention status for PC4 */
#define PWR_IORETRC_RET5_Pos                (5UL)
#define PWR_IORETRC_RET5_Msk                (0x1UL << PWR_IORETRC_RET5_Pos)             /*!< 0x00000020 */
#define PWR_IORETRC_RET5                    PWR_IORETRC_RET5_Msk                        /*!< Standby GPIO retention status for PC5 */
#define PWR_IORETRC_RET6_Pos                (6UL)
#define PWR_IORETRC_RET6_Msk                (0x1UL << PWR_IORETRC_RET6_Pos)             /*!< 0x00000040 */
#define PWR_IORETRC_RET6                    PWR_IORETRC_RET6_Msk                        /*!< Standby GPIO retention status for PC6 */
#define PWR_IORETRC_RET7_Pos                (7UL)
#define PWR_IORETRC_RET7_Msk                (0x1UL << PWR_IORETRC_RET7_Pos)             /*!< 0x00000080 */
#define PWR_IORETRC_RET7                    PWR_IORETRC_RET7_Msk                        /*!< Standby GPIO retention status for PC7 */
#define PWR_IORETRC_RET8_Pos                (8UL)
#define PWR_IORETRC_RET8_Msk                (0x1UL << PWR_IORETRC_RET8_Pos)             /*!< 0x00000100 */
#define PWR_IORETRC_RET8                    PWR_IORETRC_RET8_Msk                        /*!< Standby GPIO retention status for PC8 */
#define PWR_IORETRC_RET9_Pos                (9UL)
#define PWR_IORETRC_RET9_Msk                (0x1UL << PWR_IORETRC_RET9_Pos)             /*!< 0x00000200 */
#define PWR_IORETRC_RET9                    PWR_IORETRC_RET9_Msk                        /*!< Standby GPIO retention status for PC9 */
#define PWR_IORETRC_RET10_Pos               (10UL)
#define PWR_IORETRC_RET10_Msk               (0x1UL << PWR_IORETRC_RET10_Pos)            /*!< 0x00000400 */
#define PWR_IORETRC_RET10                   PWR_IORETRC_RET10_Msk                       /*!< Standby GPIO retention status for PC10 */
#define PWR_IORETRC_RET11_Pos               (11UL)
#define PWR_IORETRC_RET11_Msk               (0x1UL << PWR_IORETRC_RET11_Pos)            /*!< 0x00000800 */
#define PWR_IORETRC_RET11                   PWR_IORETRC_RET11_Msk                       /*!< Standby GPIO retention status for PC11 */
#define PWR_IORETRC_RET12_Pos               (12UL)
#define PWR_IORETRC_RET12_Msk               (0x1UL << PWR_IORETRC_RET12_Pos)            /*!< 0x00001000 */
#define PWR_IORETRC_RET12                   PWR_IORETRC_RET12_Msk                       /*!< Standby GPIO retention status for PC12 */
#define PWR_IORETRC_RET13_Pos               (13UL)
#define PWR_IORETRC_RET13_Msk               (0x1UL << PWR_IORETRC_RET13_Pos)           /*!< 0x00002000 */
#define PWR_IORETRC_RET13                   PWR_IORETRC_RET13_Msk                      /*!< Standby GPIO retention status for PC13 */
#define PWR_IORETRC_RET14_Pos               (14UL)
#define PWR_IORETRC_RET14_Msk               (0x1UL << PWR_IORETRC_RET14_Pos)           /*!< 0x00004000 */
#define PWR_IORETRC_RET14                   PWR_IORETRC_RET14_Msk                      /*!< Standby GPIO retention status for PC14 */
#define PWR_IORETRC_RET15_Pos               (15UL)
#define PWR_IORETRC_RET15_Msk               (0x1UL << PWR_IORETRC_RET15_Pos)           /*!< 0x00008000 */
#define PWR_IORETRC_RET15                   PWR_IORETRC_RET15_Msk                      /*!< Standby GPIO retention status for PC15 */
/********************  Bit definition for PWR_IORETENRD register  *****************/
#define PWR_IORETENRD_EN0_Pos               (0UL)
#define PWR_IORETENRD_EN0_Msk               (0x1UL << PWR_IORETENRD_EN0_Pos)           /*!< 0x00000001 */
#define PWR_IORETENRD_EN0                   PWR_IORETENRD_EN0_Msk                      /*!< Standby GPIO retention enable for PD0 */
#define PWR_IORETENRD_EN1_Pos               (1UL)
#define PWR_IORETENRD_EN1_Msk               (0x1UL << PWR_IORETENRD_EN1_Pos)           /*!< 0x00000002 */
#define PWR_IORETENRD_EN1                   PWR_IORETENRD_EN1_Msk                      /*!< Standby GPIO retention enable for PD1 */
#define PWR_IORETENRD_EN2_Pos               (2UL)
#define PWR_IORETENRD_EN2_Msk               (0x1UL << PWR_IORETENRD_EN2_Pos)           /*!< 0x00000004 */
#define PWR_IORETENRD_EN2                   PWR_IORETENRD_EN2_Msk                      /*!< Standby GPIO retention enable for PD2 */
#define PWR_IORETENRD_EN3_Pos               (3UL)
#define PWR_IORETENRD_EN3_Msk               (0x1UL << PWR_IORETENRD_EN3_Pos)           /*!< 0x00000008 */
#define PWR_IORETENRD_EN3                   PWR_IORETENRD_EN3_Msk                      /*!< Standby GPIO retention enable for PD3 */
#define PWR_IORETENRD_EN4_Pos               (4UL)
#define PWR_IORETENRD_EN4_Msk               (0x1UL << PWR_IORETENRD_EN4_Pos)           /*!< 0x00000010 */
#define PWR_IORETENRD_EN4                   PWR_IORETENRD_EN4_Msk                      /*!< Standby GPIO retention enable for PD4 */
#define PWR_IORETENRD_EN5_Pos               (5UL)
#define PWR_IORETENRD_EN5_Msk               (0x1UL << PWR_IORETENRD_EN5_Pos)           /*!< 0x00000020 */
#define PWR_IORETENRD_EN5                   PWR_IORETENRD_EN5_Msk                      /*!< Standby GPIO retention enable for PD5 */
#define PWR_IORETENRD_EN6_Pos               (6UL)
#define PWR_IORETENRD_EN6_Msk               (0x1UL << PWR_IORETENRD_EN6_Pos)           /*!< 0x00000040 */
#define PWR_IORETENRD_EN6                   PWR_IORETENRD_EN6_Msk                      /*!< Standby GPIO retention enable for PD6 */
#define PWR_IORETENRD_EN7_Pos               (7UL)
#define PWR_IORETENRD_EN7_Msk               (0x1UL << PWR_IORETENRD_EN7_Pos)           /*!< 0x00000080 */
#define PWR_IORETENRD_EN7                   PWR_IORETENRD_EN7_Msk                      /*!< Standby GPIO retention enable for PD7 */
#define PWR_IORETENRD_EN8_Pos               (8UL)
#define PWR_IORETENRD_EN8_Msk               (0x1UL << PWR_IORETENRD_EN8_Pos)           /*!< 0x00000100 */
#define PWR_IORETENRD_EN8                   PWR_IORETENRD_EN8_Msk                      /*!< Standby GPIO retention enable for PD8 */
#define PWR_IORETENRD_EN9_Pos               (9UL)
#define PWR_IORETENRD_EN9_Msk               (0x1UL << PWR_IORETENRD_EN9_Pos)           /*!< 0x00000200 */
#define PWR_IORETENRD_EN9                   PWR_IORETENRD_EN9_Msk                      /*!< Standby GPIO retention enable for PD9 */
#define PWR_IORETENRD_EN10_Pos              (10UL)
#define PWR_IORETENRD_EN10_Msk              (0x1UL << PWR_IORETENRD_EN10_Pos)          /*!< 0x00000400 */
#define PWR_IORETENRD_EN10                  PWR_IORETENRD_EN10_Msk                     /*!< Standby GPIO retention enable for PD10 */
#define PWR_IORETENRD_EN11_Pos              (11UL)
#define PWR_IORETENRD_EN11_Msk              (0x1UL << PWR_IORETENRD_EN11_Pos)          /*!< 0x00000800 */
#define PWR_IORETENRD_EN11                  PWR_IORETENRD_EN11_Msk                     /*!< Standby GPIO retention enable for PD11 */
#define PWR_IORETENRD_EN12_Pos              (12UL)
#define PWR_IORETENRD_EN12_Msk              (0x1UL << PWR_IORETENRD_EN12_Pos)          /*!< 0x00001000 */
#define PWR_IORETENRD_EN12                  PWR_IORETENRD_EN12_Msk                     /*!< Standby GPIO retention enable for PD12 */
#define PWR_IORETENRD_EN13_Pos              (13UL)
#define PWR_IORETENRD_EN13_Msk              (0x1UL << PWR_IORETENRD_EN13_Pos)          /*!< 0x00002000 */
#define PWR_IORETENRD_EN13                  PWR_IORETENRD_EN13_Msk                     /*!< Standby GPIO retention enable for PD13 */
#define PWR_IORETENRD_EN14_Pos              (14UL)
#define PWR_IORETENRD_EN14_Msk              (0x1UL << PWR_IORETENRD_EN14_Pos)          /*!< 0x00004000 */
#define PWR_IORETENRD_EN14                  PWR_IORETENRD_EN14_Msk                     /*!< Standby GPIO retention enable for PD14 */
#define PWR_IORETENRD_EN15_Pos              (15UL)
#define PWR_IORETENRD_EN15_Msk              (0x1UL << PWR_IORETENRD_EN15_Pos)          /*!< 0x00008000 */
#define PWR_IORETENRD_EN15                  PWR_IORETENRD_EN15_Msk                     /*!< Standby GPIO retention enable for PD14 */

/********************  Bit definition for PWR_IORETRD register  *****************/

#define PWR_IORETRD_RET0_Pos                (0UL)
#define PWR_IORETRD_RET0_Msk                (0x1UL << PWR_IORETRD_RET0_Pos)             /*!< 0x00000001 */
#define PWR_IORETRD_RET0                    PWR_IORETRD_RET0_Msk                        /*!< Standby GPIO retention status for PD0 */
#define PWR_IORETRD_RET1_Pos                (1UL)
#define PWR_IORETRD_RET1_Msk                (0x1UL << PWR_IORETRD_RET1_Pos)             /*!< 0x00000002 */
#define PWR_IORETRD_RET1                    PWR_IORETRD_RET1_Msk                        /*!< Standby GPIO retention status for PD1 */
#define PWR_IORETRD_RET2_Pos                (2UL)
#define PWR_IORETRD_RET2_Msk                (0x1UL << PWR_IORETRD_RET2_Pos)             /*!< 0x00000004 */
#define PWR_IORETRD_RET2                    PWR_IORETRD_RET2_Msk                        /*!< Standby GPIO retention status for PD2 */
#define PWR_IORETRD_RET3_Pos                (3UL)
#define PWR_IORETRD_RET3_Msk                (0x1UL << PWR_IORETRD_RET3_Pos)             /*!< 0x00000008 */
#define PWR_IORETRD_RET3                    PWR_IORETRD_RET3_Msk                        /*!< Standby GPIO retention status for PD3 */
#define PWR_IORETRD_RET4_Pos                (4UL)
#define PWR_IORETRD_RET4_Msk                (0x1UL << PWR_IORETRD_RET4_Pos)             /*!< 0x00000010 */
#define PWR_IORETRD_RET4                    PWR_IORETRD_RET4_Msk                        /*!< Standby GPIO retention status for PD4 */
#define PWR_IORETRD_RET5_Pos                (5UL)
#define PWR_IORETRD_RET5_Msk                (0x1UL << PWR_IORETRD_RET5_Pos)             /*!< 0x00000020 */
#define PWR_IORETRD_RET5                    PWR_IORETRD_RET5_Msk                        /*!< Standby GPIO retention status for PD5 */
#define PWR_IORETRD_RET6_Pos                (6UL)
#define PWR_IORETRD_RET6_Msk                (0x1UL << PWR_IORETRD_RET6_Pos)             /*!< 0x00000040 */
#define PWR_IORETRD_RET6                    PWR_IORETRD_RET6_Msk                        /*!< Standby GPIO retention status for PD6 */
#define PWR_IORETRD_RET7_Pos                (7UL)
#define PWR_IORETRD_RET7_Msk                (0x1UL << PWR_IORETRD_RET7_Pos)             /*!< 0x00000080 */
#define PWR_IORETRD_RET7                    PWR_IORETRD_RET7_Msk                        /*!< Standby GPIO retention status for PD7 */
#define PWR_IORETRD_RET8_Pos                (8UL)
#define PWR_IORETRD_RET8_Msk                (0x1UL << PWR_IORETRD_RET8_Pos)             /*!< 0x00000100 */
#define PWR_IORETRD_RET8                    PWR_IORETRD_RET8_Msk                        /*!< Standby GPIO retention status for PD8 */
#define PWR_IORETRD_RET9_Pos                (9UL)
#define PWR_IORETRD_RET9_Msk                (0x1UL << PWR_IORETRD_RET9_Pos)             /*!< 0x00000200 */
#define PWR_IORETRD_RET9                    PWR_IORETRD_RET9_Msk                        /*!< Standby GPIO retention status for PD9 */
#define PWR_IORETRD_RET10_Pos               (10UL)
#define PWR_IORETRD_RET10_Msk               (0x1UL << PWR_IORETRD_RET10_Pos)           /*!< 0x00000400 */
#define PWR_IORETRD_RET10                   PWR_IORETRD_RET10_Msk                      /*!< Standby GPIO retention status for PD10 */
#define PWR_IORETRD_RET11_Pos               (11UL)
#define PWR_IORETRD_RET11_Msk               (0x1UL << PWR_IORETRD_RET11_Pos)           /*!< 0x00000800 */
#define PWR_IORETRD_RET11                   PWR_IORETRD_RET11_Msk                      /*!< Standby GPIO retention status for PD11 */
#define PWR_IORETRD_RET12_Pos               (12UL)
#define PWR_IORETRD_RET12_Msk               (0x1UL << PWR_IORETRD_RET12_Pos)           /*!< 0x00001000 */
#define PWR_IORETRD_RET12                   PWR_IORETRD_RET12_Msk                      /*!< Standby GPIO retention status for PD12 */
#define PWR_IORETRD_RET13_Pos               (13UL)
#define PWR_IORETRD_RET13_Msk               (0x1UL << PWR_IORETRD_RET13_Pos)           /*!< 0x00002000 */
#define PWR_IORETRD_RET13                   PWR_IORETRD_RET13_Msk                      /*!< Standby GPIO retention status for PD13 */
#define PWR_IORETRD_RET14_Pos               (14UL)
#define PWR_IORETRD_RET14_Msk               (0x1UL << PWR_IORETRD_RET14_Pos)            /*!< 0x00004000 */
#define PWR_IORETRD_RET14                   PWR_IORETRD_RET14_Msk                       /*!< Standby GPIO retention status for PD14 */
#define PWR_IORETRD_RET15_Pos               (15UL)
#define PWR_IORETRD_RET15_Msk               (0x1UL << PWR_IORETRD_RET15_Pos)           /*!< 0x00008000 */
#define PWR_IORETRD_RET15                   PWR_IORETRD_RET15_Msk                      /*!< Standby GPIO retention status for PD15 */
/********************  Bit definition for PWR_IORETENRE register  *****************/
#define PWR_IORETENRE_EN0_Pos               (0UL)
#define PWR_IORETENRE_EN0_Msk               (0x1UL << PWR_IORETENRE_EN0_Pos)           /*!< 0x00000001 */
#define PWR_IORETENRE_EN0                   PWR_IORETENRE_EN0_Msk                      /*!< Standby GPIO retention enable for PE0 */
#define PWR_IORETENRE_EN1_Pos               (1UL)
#define PWR_IORETENRE_EN1_Msk               (0x1UL << PWR_IORETENRE_EN1_Pos)           /*!< 0x00000002 */
#define PWR_IORETENRE_EN1                   PWR_IORETENRE_EN1_Msk                      /*!< Standby GPIO retention enable for PE1 */
#define PWR_IORETENRE_EN2_Pos               (2UL)
#define PWR_IORETENRE_EN2_Msk               (0x1UL << PWR_IORETENRE_EN2_Pos)           /*!< 0x00000004 */
#define PWR_IORETENRE_EN2                   PWR_IORETENRE_EN2_Msk                      /*!< Standby GPIO retention enable for PE2 */
#define PWR_IORETENRE_EN3_Pos               (3UL)
#define PWR_IORETENRE_EN3_Msk               (0x1UL << PWR_IORETENRE_EN3_Pos)           /*!< 0x00000008 */
#define PWR_IORETENRE_EN3                   PWR_IORETENRE_EN3_Msk                      /*!< Standby GPIO retention enable for PE3 */
#define PWR_IORETENRE_EN4_Pos               (4UL)
#define PWR_IORETENRE_EN4_Msk               (0x1UL << PWR_IORETENRE_EN4_Pos)           /*!< 0x00000010 */
#define PWR_IORETENRE_EN4                   PWR_IORETENRE_EN4_Msk                      /*!< Standby GPIO retention enable for PE4 */
#define PWR_IORETENRE_EN5_Pos               (5UL)
#define PWR_IORETENRE_EN5_Msk               (0x1UL << PWR_IORETENRE_EN5_Pos)           /*!< 0x00000020 */
#define PWR_IORETENRE_EN5                   PWR_IORETENRE_EN5_Msk                      /*!< Standby GPIO retention enable for PE5 */
#define PWR_IORETENRE_EN6_Pos               (6UL)
#define PWR_IORETENRE_EN6_Msk               (0x1UL << PWR_IORETENRE_EN6_Pos)           /*!< 0x00000040 */
#define PWR_IORETENRE_EN6                   PWR_IORETENRE_EN6_Msk                      /*!< Standby GPIO retention enable for PE6 */

/********************  Bit definition for PWR_IORETRE register  *****************/
#define PWR_IORETRE_RET0_Pos                (0UL)
#define PWR_IORETRE_RET0_Msk                (0x1UL << PWR_IORETRE_RET0_Pos)            /*!< 0x00000001 */
#define PWR_IORETRE_RET0                    PWR_IORETRE_RET0_Msk                       /*!< Standby GPIO retention status for PE0 */
#define PWR_IORETRE_RET1_Pos                (1UL)
#define PWR_IORETRE_RET1_Msk                (0x1UL << PWR_IORETRE_RET1_Pos)            /*!< 0x00000002 */
#define PWR_IORETRE_RET1                    PWR_IORETRE_RET1_Msk                       /*!< Standby GPIO retention status for PE1 */
#define PWR_IORETRE_RET2_Pos                (2UL)
#define PWR_IORETRE_RET2_Msk                (0x1UL << PWR_IORETRE_RET2_Pos)            /*!< 0x00000004 */
#define PWR_IORETRE_RET2                    PWR_IORETRE_RET2_Msk                       /*!< Standby GPIO retention status for PE2 */
#define PWR_IORETRE_RET3_Pos                (3UL)
#define PWR_IORETRE_RET3_Msk                (0x1UL << PWR_IORETRE_RET3_Pos)            /*!< 0x00000008 */
#define PWR_IORETRE_RET3                    PWR_IORETRE_RET3_Msk                       /*!< Standby GPIO retention status for PE3 */
#define PWR_IORETRE_RET4_Pos                (4UL)
#define PWR_IORETRE_RET4_Msk                (0x1UL << PWR_IORETRE_RET4_Pos)            /*!< 0x00000010 */
#define PWR_IORETRE_RET4                    PWR_IORETRE_RET4_Msk                       /*!< Standby GPIO retention status for PE4 */
#define PWR_IORETRE_RET5_Pos                (5UL)
#define PWR_IORETRE_RET5_Msk                (0x1UL << PWR_IORETRE_RET5_Pos)            /*!< 0x00000020 */
#define PWR_IORETRE_RET5                    PWR_IORETRE_RET5_Msk                       /*!< Standby GPIO retention status for PE5 */
#define PWR_IORETRE_RET6_Pos                (6UL)
#define PWR_IORETRE_RET6_Msk                (0x1UL << PWR_IORETRE_RET6_Pos)            /*!< 0x00000040 */
#define PWR_IORETRE_RET6                    PWR_IORETRE_RET6_Msk                       /*!< Standby GPIO retention status for PE6 */

/********************  Bit definition for PWR_IORETENRG register  *****************/
#define PWR_IORETENRG_EN2_Pos               (2UL)
#define PWR_IORETENRG_EN2_Msk               (0x1UL << PWR_IORETENRG_EN2_Pos)           /*!< 0x00000004 */
#define PWR_IORETENRG_EN2                   PWR_IORETENRG_EN2_Msk                      /*!< Standby GPIO retention enable for PG2 */
#define PWR_IORETENRG_EN3_Pos               (3UL)
#define PWR_IORETENRG_EN3_Msk               (0x1UL << PWR_IORETENRG_EN3_Pos)           /*!< 0x00000008 */
#define PWR_IORETENRG_EN3                   PWR_IORETENRG_EN3_Msk                      /*!< Standby GPIO retention enable for PG3 */
#define PWR_IORETENRG_EN4_Pos               (4UL)
#define PWR_IORETENRG_EN4_Msk               (0x1UL << PWR_IORETENRG_EN4_Pos)           /*!< 0x00000010 */
#define PWR_IORETENRG_EN4                   PWR_IORETENRG_EN4_Msk                      /*!< Standby GPIO retention enable for PG4 */
#define PWR_IORETENRG_EN5_Pos               (5UL)
#define PWR_IORETENRG_EN5_Msk               (0x1UL << PWR_IORETENRG_EN5_Pos)           /*!< 0x00000020 */
#define PWR_IORETENRG_EN5                   PWR_IORETENRG_EN5_Msk                      /*!< Standby GPIO retention enable for PG5 */
#define PWR_IORETENRG_EN6_Pos               (6UL)
#define PWR_IORETENRG_EN6_Msk               (0x1UL << PWR_IORETENRG_EN6_Pos)           /*!< 0x00000040 */
#define PWR_IORETENRG_EN6                   PWR_IORETENRG_EN6_Msk                      /*!< Standby GPIO retention enable for PG6 */
#define PWR_IORETENRG_EN7_Pos               (7UL)
#define PWR_IORETENRG_EN7_Msk               (0x1UL << PWR_IORETENRG_EN7_Pos)           /*!< 0x00000080 */
#define PWR_IORETENRG_EN7                   PWR_IORETENRG_EN7_Msk                      /*!< Standby GPIO retention enable for PG7 */
#define PWR_IORETENRG_EN8_Pos               (8UL)
#define PWR_IORETENRG_EN8_Msk               (0x1UL << PWR_IORETENRG_EN8_Pos)           /*!< 0x00000100 */
#define PWR_IORETENRG_EN8                   PWR_IORETENRG_EN8_Msk                      /*!< Standby GPIO retention enable for PG8 */
#define PWR_IORETENRG_EN9_Pos               (9UL)
#define PWR_IORETENRG_EN9_Msk               (0x1UL << PWR_IORETENRG_EN9_Pos)           /*!< 0x00000200 */
#define PWR_IORETENRG_EN9                   PWR_IORETENRG_EN9_Msk                      /*!< Standby GPIO retention enable for PG9 */
#define PWR_IORETENRG_EN10_Pos              (10UL)
#define PWR_IORETENRG_EN10_Msk              (0x1UL << PWR_IORETENRG_EN10_Pos)          /*!< 0x00000400 */
#define PWR_IORETENRG_EN10                  PWR_IORETENRG_EN10_Msk                     /*!< Standby GPIO retention enable for PG10 */
#define PWR_IORETENRG_EN11_Pos              (11UL)
#define PWR_IORETENRG_EN11_Msk              (0x1UL << PWR_IORETENRG_EN11_Pos)          /*!< 0x00000800 */
#define PWR_IORETENRG_EN11                  PWR_IORETENRG_EN11_Msk                     /*!< Standby GPIO retention enable for PG11 */
#define PWR_IORETENRG_EN12_Pos              (12UL)
#define PWR_IORETENRG_EN12_Msk              (0x1UL << PWR_IORETENRG_EN12_Pos)          /*!< 0x00001000 */
#define PWR_IORETENRG_EN12                  PWR_IORETENRG_EN12_Msk                     /*!< Standby GPIO retention enable for PG12 */
#define PWR_IORETENRG_EN13_Pos              (13UL)
#define PWR_IORETENRG_EN13_Msk              (0x1UL << PWR_IORETENRG_EN13_Pos)          /*!< 0x00002000 */
#define PWR_IORETENRG_EN13                  PWR_IORETENRG_EN13_Msk                     /*!< Standby GPIO retention enable for PG13 */
#define PWR_IORETENRG_EN14_Pos              (14UL)
#define PWR_IORETENRG_EN14_Msk              (0x1UL << PWR_IORETENRG_EN14_Pos)          /*!< 0x00004000 */
#define PWR_IORETENRG_EN14                  PWR_IORETENRG_EN14_Msk                     /*!< Standby GPIO retention enable for PG14 */
#define PWR_IORETENRG_EN15_Pos              (15UL)
#define PWR_IORETENRG_EN15_Msk              (0x1UL << PWR_IORETENRG_EN15_Pos)          /*!< 0x00008000 */
#define PWR_IORETENRG_EN15                  PWR_IORETENRG_EN15_Msk                     /*!< Standby GPIO retention enable for PG15 */

/********************  Bit definition for PWR_IORETRG register  *****************/
#define PWR_IORETRG_EN2_Pos                 (2UL)
#define PWR_IORETRG_EN2_Msk                 (0x1UL << PWR_IORETRG_EN2_Pos)             /*!< 0x00000004 */
#define PWR_IORETRG_EN2                     PWR_IORETRG_EN2_Msk                        /*!< Standby GPIO retention status for PG2 */
#define PWR_IORETRG_EN3_Pos                 (3UL)
#define PWR_IORETRG_EN3_Msk                 (0x1UL << PWR_IORETRG_EN3_Pos)             /*!< 0x00000008 */
#define PWR_IORETRG_EN3                     PWR_IORETRG_EN3_Msk                        /*!< Standby GPIO retention status for PG3 */
#define PWR_IORETRG_EN4_Pos                 (4UL)
#define PWR_IORETRG_EN4_Msk                 (0x1UL << PWR_IORETRG_EN4_Pos)             /*!< 0x00000010 */
#define PWR_IORETRG_EN4                     PWR_IORETRG_EN4_Msk                        /*!< Standby GPIO retention status for PG4 */
#define PWR_IORETRG_EN5_Pos                 (5UL)
#define PWR_IORETRG_EN5_Msk                 (0x1UL << PWR_IORETRG_EN5_Pos)             /*!< 0x00000020 */
#define PWR_IORETRG_EN5                     PWR_IORETRG_EN5_Msk                        /*!< Standby GPIO retention status for PG5 */
#define PWR_IORETRG_EN6_Pos                 (6UL)
#define PWR_IORETRG_EN6_Msk                 (0x1UL << PWR_IORETRG_EN6_Pos)             /*!< 0x00000040 */
#define PWR_IORETRG_EN6                     PWR_IORETRG_EN6_Msk                        /*!< Standby GPIO retention status for PG6 */
#define PWR_IORETRG_EN7_Pos                 (7UL)
#define PWR_IORETRG_EN7_Msk                 (0x1UL << PWR_IORETRG_EN7_Pos)             /*!< 0x00000080 */
#define PWR_IORETRG_EN7                     PWR_IORETRG_EN7_Msk                        /*!< Standby GPIO retention status for PG7 */
#define PWR_IORETRG_EN8_Pos                 (8UL)
#define PWR_IORETRG_EN8_Msk                 (0x1UL << PWR_IORETRG_EN8_Pos)             /*!< 0x00000100 */
#define PWR_IORETRG_EN8                     PWR_IORETRG_EN8_Msk                        /*!< Standby GPIO retention status for PG8 */
#define PWR_IORETRG_EN9_Pos                 (9UL)
#define PWR_IORETRG_EN9_Msk                 (0x1UL << PWR_IORETRG_EN9_Pos)             /*!< 0x00000200 */
#define PWR_IORETRG_EN9                     PWR_IORETRG_EN9_Msk                        /*!< Standby GPIO retention status for PG9 */
#define PWR_IORETRG_EN10_Pos                (10UL)
#define PWR_IORETRG_EN10_Msk                (0x1UL << PWR_IORETRG_EN10_Pos)            /*!< 0x00000400 */
#define PWR_IORETRG_EN10                    PWR_IORETRG_EN10_Msk                       /*!< Standby GPIO retention status for PG10 */
#define PWR_IORETRG_EN11_Pos                (11UL)
#define PWR_IORETRG_EN11_Msk                (0x1UL << PWR_IORETRG_EN11_Pos)            /*!< 0x00000800 */
#define PWR_IORETRG_EN11                    PWR_IORETRG_EN11_Msk                       /*!< Standby GPIO retention status for PG11 */
#define PWR_IORETRG_EN12_Pos                (12UL)
#define PWR_IORETRG_EN12_Msk                (0x1UL << PWR_IORETRG_EN12_Pos)            /*!< 0x00001000 */
#define PWR_IORETRG_EN12                    PWR_IORETRG_EN12_Msk                       /*!< Standby GPIO retention status for PG12 */
#define PWR_IORETRG_EN13_Pos                (13UL)
#define PWR_IORETRG_EN13_Msk                (0x1UL << PWR_IORETRG_EN13_Pos)            /*!< 0x00002000 */
#define PWR_IORETRG_EN13                    PWR_IORETRG_EN13_Msk                       /*!< Standby GPIO retention status for PG13 */
#define PWR_IORETRG_EN14_Pos                (14UL)
#define PWR_IORETRG_EN14_Msk                (0x1UL << PWR_IORETRG_EN14_Pos)            /*!< 0x00004000 */
#define PWR_IORETRG_EN14                    PWR_IORETRG_EN14_Msk                       /*!< Standby GPIO retention status for PG14 */
#define PWR_IORETRG_EN15_Pos                (15UL)
#define PWR_IORETRG_EN15_Msk                (0x1UL << PWR_IORETRG_EN15_Pos)            /*!< 0x00008000 */
#define PWR_IORETRG_EN15                    PWR_IORETRG_EN15_Msk                       /*!< Standby GPIO retention status for PG15 */

/********************  Bit definition for PWR_IORETENRH register  *****************/
#define PWR_IORETENRH_EN3_Pos               (3UL)
#define PWR_IORETENRH_EN3_Msk               (0x1UL << PWR_IORETENRH_EN3_Pos)           /*!< 0x00000008 */
#define PWR_IORETENRH_EN3                   PWR_IORETENRH_EN3_Msk                      /*!< Standby GPIO retention enable for PH3 */

/********************  Bit definition for PWR_IORETRH register  *****************/
#define PWR_IORETRH_RET3_Pos                (3UL)
#define PWR_IORETRH_RET3_Msk                (0x1UL << PWR_IORETRH_RET3_Pos)            /*!< 0x00000008 */
#define PWR_IORETRH_RET3                    PWR_IORETRH_RET3_Msk                       /*!< Standby GPIO retention status for PH3 */

/********************  Bit definition for PWR_RADIOSCR register  *****************/
#define PWR_RADIOSCR_MODE_Pos               (0UL)
#define PWR_RADIOSCR_MODE_Msk               (0x3UL << PWR_RADIOSCR_MODE_Pos)            /*!< 0x00000003 */
#define PWR_RADIOSCR_MODE                   PWR_RADIOSCR_MODE_Msk                       /*!< 2.4 GHz RADIO operating mode */
#define PWR_RADIOSCR_MODE_0                 (0x1UL << PWR_RADIOSCR_MODE_Pos)            /*!< 0x00000001 */
#define PWR_RADIOSCR_MODE_1                 (0x2UL << PWR_RADIOSCR_MODE_Pos)            /*!< 0x00000002 */
#define PWR_RADIOSCR_PHYMODE_Pos            (2UL)
#define PWR_RADIOSCR_PHYMODE_Msk            (0x1UL << PWR_RADIOSCR_PHYMODE_Pos)         /*!< 0x00000004 */
#define PWR_RADIOSCR_PHYMODE                PWR_RADIOSCR_PHYMODE_Msk                    /*!< 2.4 GHz RADIO PHY operating mode */
#define PWR_RADIOSCR_ENCMODE_Pos            (3UL)
#define PWR_RADIOSCR_ENCMODE_Msk            (0x1UL << PWR_RADIOSCR_ENCMODE_Pos)         /*!< 0x00000008 */
#define PWR_RADIOSCR_ENCMODE                PWR_RADIOSCR_ENCMODE_Msk                    /*!< 2.4 GHz RADIO encryption function operating mode */
#define PWR_RADIOSCR_RFVDDHPA_Pos           (8UL)
#define PWR_RADIOSCR_RFVDDHPA_Msk           (0x1FUL << PWR_RADIOSCR_RFVDDHPA_Pos)       /*!< 0x00001F00 */
#define PWR_RADIOSCR_RFVDDHPA               PWR_RADIOSCR_RFVDDHPA_Msk                   /*!< 2.4 GHz RADIO VDDHPA control word */
#define PWR_RADIOSCR_REGPARDYV11_Pos        (14UL)
#define PWR_RADIOSCR_REGPARDYV11_Msk        (0x1UL << PWR_RADIOSCR_REGPARDYV11_Pos)     /*!< 0x00004000 */
#define PWR_RADIOSCR_REGPARDYV11            PWR_RADIOSCR_REGPARDYV11_Msk                /*!< Ready bit for VDDHPA voltage level when selecting VDDRFPA input */
#define PWR_RADIOSCR_REGPARDYVDDRFPA_Pos    (15UL)
#define PWR_RADIOSCR_REGPARDYVDDRFPA_Msk    (0x1UL << PWR_RADIOSCR_REGPARDYVDDRFPA_Pos) /*!< 0x00008000 */
#define PWR_RADIOSCR_REGPARDYVDDRFPA        PWR_RADIOSCR_REGPARDYVDDRFPA_Msk            /*!< Ready bit for VDDHPA voltage level when selecting VDDRFPA input */
#define PWR_RADIOSCR_REGPASEL_Pos           (23UL)
#define PWR_RADIOSCR_REGPASEL_Msk           (0x1UL << PWR_RADIOSCR_REGPASEL_Pos)        /*!< 0x00800000 */
#define PWR_RADIOSCR_REGPASEL               PWR_RADIOSCR_REGPASEL_Msk                   /*!< Regulator REG_VDDHPA input supply selection */
#define PWR_RADIOSCR_REGPABYPEN_Pos         (24UL)
#define PWR_RADIOSCR_REGPABYPEN_Msk         (0x1UL << PWR_RADIOSCR_REGPABYPEN_Pos)      /*!< 0x01000000 */
#define PWR_RADIOSCR_REGPABYPEN             PWR_RADIOSCR_REGPABYPEN_Msk                 /*!< Regulator REG_VDDHPA bypass enable.*/

/********************  Bit definition for PWR_S2RETR register  *****************/
#define PWR_S2RETR_PTASREN_Pos              (0UL)
#define PWR_S2RETR_PTASREN_Msk              (0x1UL << PWR_S2RETR_PTASREN_Pos)           /*!< 0x00000001 */
#define PWR_S2RETR_PTASREN                  PWR_S2RETR_PTASREN_Msk                      /*!< PTA output signals Stop 2 mode retention enable */
#define PWR_S2RETR_PTASR_Pos                (16UL)
#define PWR_S2RETR_PTASR_Msk                (0x1UL << PWR_S2RETR_PTASR_Pos)             /*!< 0x00010000 */
#define PWR_S2RETR_PTASR                    PWR_S2RETR_PTASR_Msk                        /*!< PTA interface output signals state retention in Stop 2 mode active */

/******************************************************************************/
/*                                                                            */
/*                      SRAMs configuration controller                        */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for RAMCFG_MxCR register  ******************/
#define RAMCFG_CR_ALE_Pos                   (4UL)
#define RAMCFG_CR_ALE_Msk                   (0x1UL << RAMCFG_CR_ALE_Pos)              /*!< 0x00000010 */
#define RAMCFG_CR_ALE                       RAMCFG_CR_ALE_Msk                         /*!< Address Latching Enable */
#define RAMCFG_CR_SRAMER_Pos                (8UL)
#define RAMCFG_CR_SRAMER_Msk                (0x1UL << RAMCFG_CR_SRAMER_Pos)           /*!< 0x00000100 */
#define RAMCFG_CR_SRAMER                    RAMCFG_CR_SRAMER_Msk                      /*!< Start Erase */
#define RAMCFG_CR_WSC_Pos                   (16UL)
#define RAMCFG_CR_WSC_Msk                   (0x7UL << RAMCFG_CR_WSC_Pos)              /*!< 0x00070000 */
#define RAMCFG_CR_WSC                       RAMCFG_CR_WSC_Msk                         /*!< WSC[18:16] Wait State Configuration field */
#define RAMCFG_CR_WSC_0                     (0x1UL << RAMCFG_CR_WSC_Pos)              /*!< 0x00010000 */
#define RAMCFG_CR_WSC_1                     (0x2UL << RAMCFG_CR_WSC_Pos)              /*!< 0x00020000 */
#define RAMCFG_CR_WSC_2                     (0x4UL << RAMCFG_CR_WSC_Pos)              /*!< 0x00040000 */

/*******************  Bit definition for RAMCFG_MxISR register  ******************/
#define RAMCFG_ISR_PED_Pos                  (1UL)
#define RAMCFG_ISR_PED_Msk                  (0x1UL << RAMCFG_ISR_PED_Pos)             /*!< 0x00000002 */
#define RAMCFG_ISR_PED                      RAMCFG_ISR_PED_Msk                        /*!< Parity error detected */
#define RAMCFG_ISR_SRAMBUSY_Pos             (8UL)
#define RAMCFG_ISR_SRAMBUSY_Msk             (0x1UL << RAMCFG_ISR_SRAMBUSY_Pos)        /*!< 0x00000100 */
#define RAMCFG_ISR_SRAMBUSY                 RAMCFG_ISR_SRAMBUSY_Msk                   /*!< SRAM busy with erase operation */

/*****************  Bit definition for RAMCFG_MxERKEYR register  ***************/
#define RAMCFG_ERKEYR_ERASEKEY_Pos          (0UL)
#define RAMCFG_ERKEYR_ERASEKEY_Msk          (0xFFUL << RAMCFG_ERKEYR_ERASEKEY_Pos)    /*!< 0x000000FF */
#define RAMCFG_ERKEYR_ERASEKEY              RAMCFG_ERKEYR_ERASEKEY_Msk                /*!< Erase write protection key */

/*******************  Bit definition for RAMCFG_MxIER register  ******************/
#define RAMCFG_IER_PEIE_Pos                 (1UL)
#define RAMCFG_IER_PEIE_Msk                 (0x1UL << RAMCFG_IER_PEIE_Pos)            /*!< 0x00000001 */
#define RAMCFG_IER_PEIE                     RAMCFG_IER_PEIE_Msk                       /*!< Parity error interrupt enable */
#define RAMCFG_IER_PENMI_Pos                (3UL)
#define RAMCFG_IER_PENMI_Msk                (0x1UL << RAMCFG_IER_PENMI_Pos)           /*!< 0x00000004 */
#define RAMCFG_IER_PENMI                    RAMCFG_IER_PENMI_Msk                      /*!< Parity error NMI */

/*******************  Bit definition for RAMCFG_MxPEAR register  ******************/
#define RAMCFG_PEAR_PEA_Pos                 (0UL)
#define RAMCFG_PEAR_PEA_Msk                 (0xFFFFUL << RAMCFG_PEAR_PEA_Pos)         /*!< 0x0000FFFF */
#define RAMCFG_PEAR_PEA                     RAMCFG_PEAR_PEA_Msk                       /*!< Parity error SRAM word aligned address offset */
#define RAMCFG_PEAR_ID_Pos                  (24UL)
#define RAMCFG_PEAR_ID_Msk                  (0xFUL << RAMCFG_PEAR_ID_Pos)             /*!< 0x0F000000 */
#define RAMCFG_PEAR_ID                      RAMCFG_PEAR_ID_Msk                        /*!< Parity error AHB bus master ID */
#define RAMCFG_PEAR_BYTE_Pos                (28UL)
#define RAMCFG_PEAR_BYTE_Msk                (0xFUL << RAMCFG_PEAR_BYTE_Pos)           /*!< 0xF0000000 */
#define RAMCFG_PEAR_BYTE          