/**
  ******************************************************************************
  * @file    stm32h563xx.h
  * @author  MCD Application Team
  * @brief   CMSIS STM32H563xx Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripheral's registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */

#ifndef STM32H563xx_H
#define STM32H563xx_H

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup ST
  * @{
  */


/** @addtogroup STM32H563xx
  * @{
  */


/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum
{
/* =======================================  ARM Cortex-M33 Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,    /*!< -15 Reset Vector, invoked on Power up and warm reset              */
  NonMaskableInt_IRQn       = -14,    /*!< -14 Non maskable Interrupt, cannot be stopped or preempted        */
  HardFault_IRQn            = -13,    /*!< -13 Hard Fault, all classes of Fault                              */
  MemoryManagement_IRQn     = -12,    /*!< -12 Memory Management, MPU mismatch, including Access Violation
                                               and No Match                                                  */
  BusFault_IRQn             = -11,    /*!< -11 Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                               related Fault                                                 */
  UsageFault_IRQn           = -10,    /*!< -10 Usage Fault, i.e. Undef Instruction, Illegal State Transition */
  SecureFault_IRQn          =  -9,    /*!< -9  Secure Fault                                                  */
  SVCall_IRQn               =  -5,    /*!< -5  System Service Call via SVC instruction                       */
  DebugMonitor_IRQn         =  -4,    /*!< -4  Debug Monitor                                                 */
  PendSV_IRQn               =  -2,    /*!< -2  Pendable request for system service                           */
  SysTick_IRQn              =  -1,    /*!< -1  System Tick Timer                                             */

/* ===========================================  STM32H563xx Specific Interrupt Numbers  ====================================== */
  WWDG_IRQn                 = 0,      /*!< Window WatchDog interrupt                                         */
  PVD_AVD_IRQn              = 1,      /*!< PVD/AVD through EXTI Line detection Interrupt                     */
  RTC_IRQn                  = 2,      /*!< RTC non-secure interrupt                                          */
  RTC_S_IRQn                = 3,      /*!< RTC secure interrupt                                              */
  TAMP_IRQn                 = 4,      /*!< Tamper global interrupt                                           */
  RAMCFG_IRQn               = 5,      /*!< RAMCFG global interrupt                                           */
  FLASH_IRQn                = 6,      /*!< FLASH non-secure global interrupt                                 */
  FLASH_S_IRQn              = 7,      /*!< FLASH secure global interrupt                                     */
  GTZC_IRQn                 = 8,      /*!< Global TrustZone Controller interrupt                             */
  RCC_IRQn                  = 9,      /*!< RCC non secure global interrupt                                   */
  RCC_S_IRQn                = 10,     /*!< RCC secure global interrupt                                       */
  EXTI0_IRQn                = 11,     /*!< EXTI Line0 interrupt                                              */
  EXTI1_IRQn                = 12,     /*!< EXTI Line1 interrupt                                              */
  EXTI2_IRQn                = 13,     /*!< EXTI Line2 interrupt                                              */
  EXTI3_IRQn                = 14,     /*!< EXTI Line3 interrupt                                              */
  EXTI4_IRQn                = 15,     /*!< EXTI Line4 interrupt                                              */
  EXTI5_IRQn                = 16,     /*!< EXTI Line5 interrupt                                              */
  EXTI6_IRQn                = 17,     /*!< EXTI Line6 interrupt                                              */
  EXTI7_IRQn                = 18,     /*!< EXTI Line7 interrupt                                              */
  EXTI8_IRQn                = 19,     /*!< EXTI Line8 interrupt                                              */
  EXTI9_IRQn                = 20,     /*!< EXTI Line9 interrupt                                              */
  EXTI10_IRQn               = 21,     /*!< EXTI Line10 interrupt                                             */
  EXTI11_IRQn               = 22,     /*!< EXTI Line11 interrupt                                             */
  EXTI12_IRQn               = 23,     /*!< EXTI Line12 interrupt                                             */
  EXTI13_IRQn               = 24,     /*!< EXTI Line13 interrupt                                             */
  EXTI14_IRQn               = 25,     /*!< EXTI Line14 interrupt                                             */
  EXTI15_IRQn               = 26,     /*!< EXTI Line15 interrupt                                             */
  GPDMA1_Channel0_IRQn      = 27,     /*!< GPDMA1 Channel 0 global interrupt                                 */
  GPDMA1_Channel1_IRQn      = 28,     /*!< GPDMA1 Channel 1 global interrupt                                 */
  GPDMA1_Channel2_IRQn      = 29,     /*!< GPDMA1 Channel 2 global interrupt                                 */
  GPDMA1_Channel3_IRQn      = 30,     /*!< GPDMA1 Channel 3 global interrupt                                 */
  GPDMA1_Channel4_IRQn      = 31,     /*!< GPDMA1 Channel 4 global interrupt                                 */
  GPDMA1_Channel5_IRQn      = 32,     /*!< GPDMA1 Channel 5 global interrupt                                 */
  GPDMA1_Channel6_IRQn      = 33,     /*!< GPDMA1 Channel 6 global interrupt                                 */
  GPDMA1_Channel7_IRQn      = 34,     /*!< GPDMA1 Channel 7 global interrupt                                 */
  IWDG_IRQn                 = 35,     /*!< IWDG global interrupt                                             */
  ADC1_IRQn                 = 37,     /*!< ADC1 global interrupt                                             */
  DAC1_IRQn                 = 38,     /*!< DAC1 global interrupt                                             */
  FDCAN1_IT0_IRQn           = 39,     /*!< FDCAN1 interrupt 0                                                */
  FDCAN1_IT1_IRQn           = 40,     /*!< FDCAN1 interrupt 1                                                */
  TIM1_BRK_IRQn             = 41,     /*!< TIM1 Break interrupt                                              */
  TIM1_UP_IRQn              = 42,     /*!< TIM1 Update interrupt                                             */
  TIM1_TRG_COM_IRQn         = 43,     /*!< TIM1 Trigger and Commutation interrupt                            */
  TIM1_CC_IRQn              = 44,     /*!< TIM1 Capture Compare interrupt                                    */
  TIM2_IRQn                 = 45,     /*!< TIM2 global interrupt                                             */
  TIM3_IRQn                 = 46,     /*!< TIM3 global interrupt                                             */
  TIM4_IRQn                 = 47,     /*!< TIM4 global interrupt                                             */
  TIM5_IRQn                 = 48,     /*!< TIM5 global interrupt                                             */
  TIM6_IRQn                 = 49,     /*!< TIM6 global interrupt                                             */
  TIM7_IRQn                 = 50,     /*!< TIM7 global interrupt                                             */
  I2C1_EV_IRQn              = 51,     /*!< I2C1 Event interrupt                                              */
  I2C1_ER_IRQn              = 52,     /*!< I2C1 Error interrupt                                              */
  I2C2_EV_IRQn              = 53,     /*!< I2C2 Event interrupt                                              */
  I2C2_ER_IRQn              = 54,     /*!< I2C2 Error interrupt                                              */
  SPI1_IRQn                 = 55,     /*!< SPI1 global interrupt                                             */
  SPI2_IRQn                 = 56,     /*!< SPI2 global interrupt                                             */
  SPI3_IRQn                 = 57,     /*!< SPI3 global interrupt                                             */
  USART1_IRQn               = 58,     /*!< USART1 global interrupt                                           */
  USART2_IRQn               = 59,     /*!< USART2 global interrupt                                           */
  USART3_IRQn               = 60,     /*!< USART3 global interrupt                                           */
  UART4_IRQn                = 61,     /*!< UART4 global interrupt                                            */
  UART5_IRQn                = 62,     /*!< UART5 global interrupt                                            */
  LPUART1_IRQn              = 63,     /*!< LPUART1 global interrupt                                          */
  LPTIM1_IRQn               = 64,     /*!< LPTIM1 global interrupt                                           */
  TIM8_BRK_IRQn             = 65,     /*!< TIM8 Break interrupt                                              */
  TIM8_UP_IRQn              = 66,     /*!< TIM8 Update interrupt                                             */
  TIM8_TRG_COM_IRQn         = 67,     /*!< TIM8 Trigger and Commutation interrupt                            */
  TIM8_CC_IRQn              = 68,     /*!< TIM8 Capture Compare interrupt                                    */
  ADC2_IRQn                 = 69,     /*!< ADC2 global interrupt                                             */
  LPTIM2_IRQn               = 70,     /*!< LPTIM2 global interrupt                                           */
  TIM15_IRQn                = 71,     /*!< TIM15 global interrupt                                            */
  TIM16_IRQn                = 72,     /*!< TIM16 global interrupt                                            */
  TIM17_IRQn                = 73,     /*!< TIM17 global interrupt                                            */
  USB_DRD_FS_IRQn           = 74,     /*!< USB FS global interrupt                                           */
  CRS_IRQn                  = 75,     /*!< CRS global interrupt                                              */
  UCPD1_IRQn                = 76,     /*!< UCPD1 global interrupt                                            */
  FMC_IRQn                  = 77,     /*!< FMC global interrupt                                              */
  OCTOSPI1_IRQn             = 78,     /*!< OctoSPI1 global interrupt                                         */
  SDMMC1_IRQn               = 79,     /*!< SDMMC1 global interrupt                                           */
  I2C3_EV_IRQn              = 80,     /*!< I2C3 event interrupt                                              */
  I2C3_ER_IRQn              = 81,     /*!< I2C3 error interrupt                                              */
  SPI4_IRQn                 = 82,     /*!< SPI4 global interrupt                                             */
  SPI5_IRQn                 = 83,     /*!< SPI5 global interrupt                                             */
  SPI6_IRQn                 = 84,     /*!< SPI6 global interrupt                                             */
  USART6_IRQn               = 85,     /*!< USART6 global interrupt                                           */
  USART10_IRQn              = 86,     /*!< USART10 global interrupt                                          */
  USART11_IRQn              = 87,     /*!< USART11 global interrupt                                          */
  SAI1_IRQn                 = 88,     /*!< Serial Audio Interface 1 global interrupt                         */
  SAI2_IRQn                 = 89,     /*!< Serial Audio Interface 2 global interrupt                         */
  GPDMA2_Channel0_IRQn      = 90,     /*!< GPDMA2 Channel 0 global interrupt                                 */
  GPDMA2_Channel1_IRQn      = 91,     /*!< GPDMA2 Channel 1 global interrupt                                 */
  GPDMA2_Channel2_IRQn      = 92,     /*!< GPDMA2 Channel 2 global interrupt                                 */
  GPDMA2_Channel3_IRQn      = 93,     /*!< GPDMA2 Channel 3 global interrupt                                 */
  GPDMA2_Channel4_IRQn      = 94,     /*!< GPDMA2 Channel 4 global interrupt                                 */
  GPDMA2_Channel5_IRQn      = 95,     /*!< GPDMA2 Channel 5 global interrupt                                 */
  GPDMA2_Channel6_IRQn      = 96,     /*!< GPDMA2 Channel 6 global interrupt                                 */
  GPDMA2_Channel7_IRQn      = 97,     /*!< GPDMA2 Channel 7 global interrupt                                 */
  UART7_IRQn                = 98,     /*!< UART7 global interrupt                                            */
  UART8_IRQn                = 99,     /*!< UART8 global interrupt                                            */
  UART9_IRQn                = 100,    /*!< UART9 global interrupt                                            */
  UART12_IRQn               = 101,    /*!< UART12 global interrupt                                           */
  SDMMC2_IRQn               = 102,    /*!< SDMMC2 global interrupt                                           */
  FPU_IRQn                  = 103,    /*!< FPU global interrupt                                              */
  ICACHE_IRQn               = 104,    /*!< Instruction cache global interrupt                                */
  DCACHE1_IRQn              = 105,    /*!< Data cache global interrupt                                       */
  ETH_IRQn                  = 106,    /*!< Ethernet global interrupt                                         */
  ETH_WKUP_IRQn             = 107,    /*!< Ethernet Wakeup global interrupt                                  */
  DCMI_PSSI_IRQn            = 108,    /*!< DCMI/PSSI global interrupt                                        */
  FDCAN2_IT0_IRQn           = 109,    /*!< FDCAN2 interrupt 0                                                */
  FDCAN2_IT1_IRQn           = 110,    /*!< FDCAN2 interrupt 1                                                */
  CORDIC_IRQn               = 111,    /*!< CORDIC global interrupt                                           */
  FMAC_IRQn                 = 112,    /*!< FMAC global interrupt                                             */
  DTS_IRQn                  = 113,    /*!< DTS global interrupt                                              */
  RNG_IRQn                  = 114,    /*!< RNG global interrupt                                              */
  HASH_IRQn                 = 117,    /*!< HASH global interrupt                                             */
  PKA_IRQn                  = 118,    /*!< PKA global interrupt                                              */
  CEC_IRQn                  = 119,    /*!< CEC-HDMI global interrupt                                         */
  TIM12_IRQn                = 120,    /*!< TIM12 global interrupt                                            */
  TIM13_IRQn                = 121,    /*!< TIM13 global interrupt                                            */
  TIM14_IRQn                = 122,    /*!< TIM14 global interrupt                                            */
  I3C1_EV_IRQn              = 123,    /*!< I3C1 event interrupt                                              */
  I3C1_ER_IRQn              = 124,    /*!< I3C1 error interrupt                                              */
  I2C4_EV_IRQn              = 125,    /*!< I2C4 event interrupt                                              */
  I2C4_ER_IRQn              = 126,    /*!< I2C4 error interrupt                                              */
  LPTIM3_IRQn               = 127,    /*!< LPTIM3 global interrupt                                           */
  LPTIM4_IRQn               = 128,    /*!< LPTIM4 global interrupt                                           */
  LPTIM5_IRQn               = 129,    /*!< LPTIM5 global interrupt                                           */
  LPTIM6_IRQn               = 130,    /*!< LPTIM6 global interrupt                                           */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* -------  Start of section using anonymous unions and disabling warnings  ------- */
#if   defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif

#define SMPS       /*!< Switched mode power supply feature */

/* --------  Configuration of the Cortex-M33 Processor and Core Peripherals  ------ */
#define __CM33_REV                0x0000U   /* Core revision r0p1 */
#define __SAUREGION_PRESENT       1U        /* SAU regions present */
#define __MPU_PRESENT             1U        /* MPU present */
#define __VTOR_PRESENT            1U        /* VTOR present */
#define __NVIC_PRIO_BITS          4U        /* Number of Bits used for Priority Levels */
#define __Vendor_SysTickConfig    0U        /* Set to 1 if different SysTick Config is used */
#define __FPU_PRESENT             1U        /* FPU present */
#define __DSP_PRESENT             1U        /* DSP extension present */

/** @} */ /* End of group Configuration_of_CMSIS */


#include "core_cm33.h"                       /*!< ARM Cortex-M33 processor and core peripherals */
#include "system_stm32h5xx.h"                /*!< STM32H5xx System */


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32H5xx_peripherals
  * @{
  */

/**
  * @brief CRC calculation unit
  */
typedef struct
{
  __IO uint32_t DR;             /*!< CRC Data register,                           Address offset: 0x00 */
  __IO uint32_t IDR;            /*!< CRC Independent data register,               Address offset: 0x04 */
  __IO uint32_t CR;             /*!< CRC Control register,                        Address offset: 0x08 */
       uint32_t RESERVED2;      /*!< Reserved,                                                    0x0C */
  __IO uint32_t INIT;           /*!< Initial CRC value register,                  Address offset: 0x10 */
  __IO uint32_t POL;            /*!< CRC polynomial register,                     Address offset: 0x14 */
} CRC_TypeDef;

/**
  * @brief Inter-integrated Circuit Interface
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< I2C Control register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< I2C Control register 2,            Address offset: 0x04 */
  __IO uint32_t OAR1;        /*!< I2C Own address 1 register,        Address offset: 0x08 */
  __IO uint32_t OAR2;        /*!< I2C Own address 2 register,        Address offset: 0x0C */
  __IO uint32_t TIMINGR;     /*!< I2C Timing register,               Address offset: 0x10 */
  __IO uint32_t TIMEOUTR;    /*!< I2C Timeout register,              Address offset: 0x14 */
  __IO uint32_t ISR;         /*!< I2C Interrupt and status register, Address offset: 0x18 */
  __IO uint32_t ICR;         /*!< I2C Interrupt clear register,      Address offset: 0x1C */
  __IO uint32_t PECR;        /*!< I2C PEC register,                  Address offset: 0x20 */
  __IO uint32_t RXDR;        /*!< I2C Receive data register,         Address offset: 0x24 */
  __IO uint32_t TXDR;        /*!< I2C Transmit data register,        Address offset: 0x28 */
} I2C_TypeDef;

/**
  * @brief Improved Inter-integrated Circuit Interface
  */
typedef struct
{
  __IO uint32_t CR;             /*!< I3C Control register,                      Address offset: 0x00      */
  __IO uint32_t CFGR;           /*!< I3C Controller Configuration register,     Address offset: 0x04      */
  uint32_t      RESERVED1[2];   /*!< Reserved,                                  Address offset: 0x08-0x0C */
  __IO uint32_t RDR;            /*!< I3C Received Data register,                Address offset: 0x10      */
  __IO uint32_t RDWR;           /*!< I3C Received Data Word register,           Address offset: 0x14      */
  __IO uint32_t TDR;            /*!< I3C Transmit Data register,                Address offset: 0x18      */
  __IO uint32_t TDWR;           /*!< I3C Transmit Data Word register,           Address offset: 0x1C      */
  __IO uint32_t IBIDR;          /*!< I3C IBI payload Data register,             Address offset: 0x20      */
  __IO uint32_t TGTTDR;         /*!< I3C Target Transmit register,              Address offset: 0x24      */
  uint32_t      RESERVED2[2];   /*!< Reserved,                                  Address offset: 0x28-0x2C */
  __IO uint32_t SR;             /*!< I3C Status register,                       Address offset: 0x30      */
  __IO uint32_t SER;            /*!< I3C Status Error register,                 Address offset: 0x34      */
  uint32_t      RESERVED3[2];   /*!< Reserved,                                  Address offset: 0x38-0x3C */
  __IO uint32_t RMR;            /*!< I3C Received Message register,             Address offset: 0x40      */
  uint32_t      RESERVED4[3];   /*!< Reserved,                                  Address offset: 0x44-0x4C */
  __IO uint32_t EVR;            /*!< I3C Event register,                        Address offset: 0x50      */
  __IO uint32_t IER;            /*!< I3C Interrupt Enable register,             Address offset: 0x54      */
  __IO uint32_t CEVR;           /*!< I3C Clear Event register,                  Address offset: 0x58      */
  uint32_t RESERVED5;           /*!< Reserved,                                  Address offset: 0x5C      */
  __IO uint32_t DEVR0;          /*!< I3C own Target characteristics register,   Address offset: 0x60      */
  __IO uint32_t DEVRX[4];       /*!< I3C Target x (1<=x<=4) register,           Address offset: 0x64-0x70 */
  uint32_t      RESERVED6[7];   /*!< Reserved,                                  Address offset: 0x74-0x8C */
  __IO uint32_t MAXRLR;         /*!< I3C Maximum Read Length register,          Address offset: 0x90      */
  __IO uint32_t MAXWLR;         /*!< I3C Maximum Write Length register,         Address offset: 0x94      */
  uint32_t      RESERVED7[2];   /*!< Reserved,                                  Address offset: 0x98-0x9C */
  __IO uint32_t TIMINGR0;       /*!< I3C Timing 0 register,                     Address offset: 0xA0      */
  __IO uint32_t TIMINGR1;       /*!< I3C Timing 1 register,                     Address offset: 0xA4      */
  __IO uint32_t TIMINGR2;       /*!< I3C Timing 2 register,                     Address offset: 0xA8      */
  uint32_t      RESERVED9[5];   /*!< Reserved,                                  Address offset: 0xAC-0xBC */
  __IO uint32_t BCR;            /*!< I3C Bus Characteristics register,          Address offset: 0xC0      */
  __IO uint32_t DCR;            /*!< I3C Device Characteristics register,       Address offset: 0xC4      */
  __IO uint32_t GETCAPR;        /*!< I3C GET CAPabilities register,             Address offset: 0xC8      */
  __IO uint32_t CRCAPR;         /*!< I3C Controller CAPabilities register,      Address offset: 0xCC      */
  __IO uint32_t GETMXDSR;       /*!< I3C GET Max Data Speed register,           Address offset: 0xD0      */
  __IO uint32_t EPIDR;          /*!< I3C Extended Provisioned ID register,      Address offset: 0xD4      */
} I3C_TypeDef;

/**
  * @brief DAC
  */
typedef struct
{
  __IO uint32_t CR;       /*!< DAC control register,                                    Address offset: 0x00 */
  __IO uint32_t SWTRIGR;  /*!< DAC software trigger register,                           Address offset: 0x04 */
  __IO uint32_t DHR12R1;  /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x08 */
  __IO uint32_t DHR12L1;  /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x0C */
  __IO uint32_t DHR8R1;   /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x10 */
  __IO uint32_t DHR12R2;  /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x14 */
  __IO uint32_t DHR12L2;  /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x18 */
  __IO uint32_t DHR8R2;   /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x1C */
  __IO uint32_t DHR12RD;  /*!< Dual DAC 12-bit right-aligned data holding register,     Address offset: 0x20 */
  __IO uint32_t DHR12LD;  /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x24 */
  __IO uint32_t DHR8RD;   /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x28 */
  __IO uint32_t DOR1;     /*!< DAC channel1 data output register,                       Address offset: 0x2C */
  __IO uint32_t DOR2;     /*!< DAC channel2 data output register,                       Address offset: 0x30 */
  __IO uint32_t SR;       /*!< DAC status register,                                     Address offset: 0x34 */
  __IO uint32_t CCR;      /*!< DAC calibration control register,                        Address offset: 0x38 */
  __IO uint32_t MCR;      /*!< DAC mode control register,                               Address offset: 0x3C */
  __IO uint32_t SHSR1;    /*!< DAC Sample and Hold sample time register 1,              Address offset: 0x40 */
  __IO uint32_t SHSR2;    /*!< DAC Sample and Hold sample time register 2,              Address offset: 0x44 */
  __IO uint32_t SHHR;     /*!< DAC Sample and Hold hold time register,                  Address offset: 0x48 */
  __IO uint32_t SHRR;     /*!< DAC Sample and Hold refresh time register,               Address offset: 0x4C */
  __IO uint32_t RESERVED[1];
  __IO uint32_t AUTOCR;      /*!< DAC Autonomous mode register,                         Address offset: 0x54 */
} DAC_TypeDef;

/**
  * @brief Clock Recovery System
  */
typedef struct
{
__IO uint32_t CR;            /*!< CRS ccontrol register,              Address offset: 0x00 */
__IO uint32_t CFGR;          /*!< CRS configuration register,         Address offset: 0x04 */
__IO uint32_t ISR;           /*!< CRS interrupt and status register,  Address offset: 0x08 */
__IO uint32_t ICR;           /*!< CRS interrupt flag clear register,  Address offset: 0x0C */
} CRS_TypeDef;


/**
  * @brief HASH
  */
typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
       uint32_t RESERVED[52];     /*!< Reserved, 0x28-0xF4                                         */
  __IO uint32_t CSR[103];         /*!< HASH context swap registers,    Address offset: 0x0F8-0x290 */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */
typedef struct
{
  __IO uint32_t HR[16];     /*!< HASH digest registers,          Address offset: 0x310-0x34C */
} HASH_DIGEST_TypeDef;

/**
  * @brief RNG
  */
typedef struct
{
  __IO uint32_t CR;  /*!< RNG control register, Address offset: 0x00 */
  __IO uint32_t SR;  /*!< RNG status register,  Address offset: 0x04 */
  __IO uint32_t DR;  /*!< RNG data register,    Address offset: 0x08 */
  __IO uint32_t NSCR;  /*!< RNG noise source control register ,     Address offset: 0x0C */
  __IO uint32_t HTCR;  /*!< RNG health test configuration register, Address offset: 0x10 */
} RNG_TypeDef;

/**
  * @brief Debug MCU
  */
typedef struct
{
  __IO uint32_t IDCODE;       /*!< MCU device ID code,                 Address offset: 0x00  */
  __IO uint32_t CR;           /*!< Debug MCU configuration register,   Address offset: 0x04  */
  __IO uint32_t APB1FZR1;     /*!< Debug MCU APB1 freeze register 1,   Address offset: 0x08  */
  __IO uint32_t APB1FZR2;     /*!< Debug MCU APB1 freeze register 2,   Address offset: 0x0C  */
  __IO uint32_t APB2FZR;      /*!< Debug MCU APB2 freeze register,     Address offset: 0x10  */
  __IO uint32_t APB3FZR;      /*!< Debug MCU APB3 freeze register,     Address offset: 0x14  */
       uint32_t RESERVED1[2]; /*!< Reserved,                                    0x18 - 0x1C  */
  __IO uint32_t AHB1FZR;      /*!< Debug MCU AHB1 freeze register,     Address offset: 0x20  */
       uint32_t RESERVED2[54]; /*!< Reserved,                                   0x24 - 0xF8  */
  __IO uint32_t SR;           /*!< Debug MCU SR register,              Address offset: 0xFC  */
  __IO uint32_t DBG_AUTH_HOST; /*!< Debug DBG_AUTH_HOST register,      Address offset: 0x100 */
  __IO uint32_t DBG_AUTH_DEV;  /*!< Debug DBG_AUTH_DEV register,       Address offset: 0x104 */
  __IO uint32_t DBG_AUTH_ACK;  /*!< Debug DBG_AUTH_ACK register,       Address offset: 0x108 */
       uint32_t RESERVED3[945]; /*!< Reserved,                                 0x10C - 0xFCC */
  __IO uint32_t PIDR4;       /*!< Debug MCU Peripheral ID register 4,  Address offset: 0xFD0 */
  __IO uint32_t PIDR5;       /*!< Debug MCU Peripheral ID register 5,  Address offset: 0xFD4 */
  __IO uint32_t PIDR6;       /*!< Debug MCU Peripheral ID register 6,  Address offset: 0xFD8 */
  __IO uint32_t PIDR7;       /*!< Debug MCU Peripheral ID register 7,  Address offset: 0xFDC */
  __IO uint32_t PIDR0;       /*!< Debug MCU Peripheral ID register 0,  Address offset: 0xFE0 */
  __IO uint32_t PIDR1;       /*!< Debug MCU Peripheral ID register 1,  Address offset: 0xFE4 */
  __IO uint32_t PIDR2;       /*!< Debug MCU Peripheral ID register 2,  Address offset: 0xFE8 */
  __IO uint32_t PIDR3;       /*!< Debug MCU Peripheral ID register 3,  Address offset: 0xFEC */
  __IO uint32_t CIDR0;       /*!< Debug MCU Component ID register 0,   Address offset: 0xFF0 */
  __IO uint32_t CIDR1;       /*!< Debug MCU Component ID register 1,   Address offset: 0xFF4 */
  __IO uint32_t CIDR2;       /*!< Debug MCU Component ID register 2,   Address offset: 0xFF8 */
  __IO uint32_t CIDR3;       /*!< Debug MCU Component ID register 3,   Address offset: 0xFFC */
} DBGMCU_TypeDef;

/**
  * @brief DCMI
  */
typedef struct
{
  __IO uint32_t CR;       /*!< DCMI control register 1,                       Address offset: 0x00 */
  __IO uint32_t SR;       /*!< DCMI status register,                          Address offset: 0x04 */
  __IO uint32_t RISR;     /*!< DCMI raw interrupt status register,            Address offset: 0x08 */
  __IO uint32_t IER;      /*!< DCMI interrupt enable register,                Address offset: 0x0C */
  __IO uint32_t MISR;     /*!< DCMI masked interrupt status register,         Address offset: 0x10 */
  __IO uint32_t ICR;      /*!< DCMI interrupt clear register,                 Address offset: 0x14 */
  __IO uint32_t ESCR;     /*!< DCMI embedded synchronization code register,   Address offset: 0x18 */
  __IO uint32_t ESUR;     /*!< DCMI embedded synchronization unmask register, Address offset: 0x1C */
  __IO uint32_t CWSTRTR;  /*!< DCMI crop window start,                        Address offset: 0x20 */
  __IO uint32_t CWSIZER;  /*!< DCMI crop window size,                         Address offset: 0x24 */
  __IO uint32_t DR;       /*!< DCMI data register,                            Address offset: 0x28 */
} DCMI_TypeDef;

/**
  * @brief PSSI
  */
typedef struct
{
  __IO uint32_t CR;             /*!< PSSI control register,                 Address offset: 0x000 */
  __IO uint32_t SR;             /*!< PSSI status register,                  Address offset: 0x004 */
  __IO uint32_t RIS;            /*!< PSSI raw interrupt status register,    Address offset: 0x008 */
  __IO uint32_t IER;            /*!< PSSI interrupt enable register,        Address offset: 0x00C */
  __IO uint32_t MIS;            /*!< PSSI masked interrupt status register, Address offset: 0x010 */
  __IO uint32_t ICR;            /*!< PSSI interrupt clear register,         Address offset: 0x014 */
  __IO uint32_t RESERVED1[4];   /*!< Reserved,                                      0x018 - 0x024 */
  __IO uint32_t DR;             /*!< PSSI data register,                    Address offset: 0x028 */
} PSSI_TypeDef;

/**
  * @brief DMA Controller
  */
typedef struct
{
  __IO uint32_t SECCFGR;     /*!< DMA secure configuration register,               Address offset: 0x00  */
  __IO uint32_t PRIVCFGR;    /*!< DMA privileged configuration register,           Address offset: 0x04  */
  __IO uint32_t RCFGLOCKR;   /*!< DMA lock configuration register,                 Address offset: 0x08  */
  __IO uint32_t MISR;        /*!< DMA non secure masked interrupt status register, Address offset: 0x0C  */
  __IO uint32_t SMISR;       /*!< DMA secure masked interrupt status register,     Address offset: 0x10  */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t CLBAR;        /*!< DMA channel x linked-list base address register, Address offset: 0x50 + (x * 0x80) */
       uint32_t RESERVED1[2]; /*!< Reserved 1,                                      Address offset: 0x54 -- 0x58      */
  __IO uint32_t CFCR;         /*!< DMA channel x flag clear register,               Address offset: 0x5C + (x * 0x80) */
  __IO uint32_t CSR;          /*!< DMA channel x flag status register,              Address offset: 0x60 + (x * 0x80) */
  __IO uint32_t CCR;          /*!< DMA channel x control register,                  Address offset: 0x64 + (x * 0x80) */
       uint32_t RESERVED2[10];/*!< Reserved 2,                                      Address offset: 0x68 -- 0x8C      */
  __IO uint32_t CTR1;         /*!< DMA channel x transfer register 1,               Address offset: 0x90 + (x * 0x80) */
  __IO uint32_t CTR2;         /*!< DMA channel x transfer register 2,               Address offset: 0x94 + (x * 0x80) */
  __IO uint32_t CBR1;         /*!< DMA channel x block register 1,                  Address offset: 0x98 + (x * 0x80) */
  __IO uint32_t CSAR;         /*!< DMA channel x source address register,           Address offset: 0x9C + (x * 0x80) */
  __IO uint32_t CDAR;         /*!< DMA channel x destination address register,      Address offset: 0xA0 + (x * 0x80) */
  __IO uint32_t CTR3;         /*!< DMA channel x transfer register 3,               Address offset: 0xA4 + (x * 0x80) */
  __IO uint32_t CBR2;         /*!< DMA channel x block register 2,                  Address offset: 0xA8 + (x * 0x80) */
       uint32_t RESERVED3[8]; /*!< Reserved 3,                                      Address offset: 0xAC -- 0xC8      */
  __IO uint32_t CLLR;         /*!< DMA channel x linked-list address register,      Address offset: 0xCC + (x * 0x80) */
} DMA_Channel_TypeDef;

/**
  * @brief Ethernet MAC
  */
typedef struct
{
  __IO uint32_t MACCR;
  __IO uint32_t MACECR;
  __IO uint32_t MACPFR;
  __IO uint32_t MACWTR;
  __IO uint32_t MACHT0R;
  __IO uint32_t MACHT1R;
  uint32_t      RESERVED1[14];
  __IO uint32_t MACVTR;
  uint32_t      RESERVED2;
  __IO uint32_t MACVHTR;
  uint32_t      RESERVED3;
  __IO uint32_t MACVIR;
  __IO uint32_t MACIVIR;
  uint32_t      RESERVED4[2];
  __IO uint32_t MACTFCR;
  uint32_t      RESERVED5[7];
  __IO uint32_t MACRFCR;
  uint32_t      RESERVED6[7];
  __IO uint32_t MACISR;
  __IO uint32_t MACIER;
  __IO uint32_t MACRXTXSR;
  uint32_t      RESERVED7;
  __IO uint32_t MACPCSR;
  __IO uint32_t MACRWKPFR;
  uint32_t      RESERVED8[2];
  __IO uint32_t MACLCSR;
  __IO uint32_t MACLTCR;
  __IO uint32_t MACLETR;
  __IO uint32_t MAC1USTCR;
  uint32_t      RESERVED9[12];
  __IO uint32_t MACVR;
  __IO uint32_t MACDR;
  uint32_t      RESERVED10;
  __IO uint32_t MACHWF0R;
  __IO uint32_t MACHWF1R;
  __IO uint32_t MACHWF2R;
  uint32_t      RESERVED11[54];
  __IO uint32_t MACMDIOAR;
  __IO uint32_t MACMDIODR;
  uint32_t      RESERVED12[2];
  __IO uint32_t MACARPAR;
  uint32_t      RESERVED13[59];
  __IO uint32_t MACA0HR;
  __IO uint32_t MACA0LR;
  __IO uint32_t MACA1HR;
  __IO uint32_t MACA1LR;
  __IO uint32_t MACA2HR;
  __IO uint32_t MACA2LR;
  __IO uint32_t MACA3HR;
  __IO uint32_t MACA3LR;
  uint32_t      RESERVED14[248];
  __IO uint32_t MMCCR;
  __IO uint32_t MMCRIR;
  __IO uint32_t MMCTIR;
  __IO uint32_t MMCRIMR;
  __IO uint32_t MMCTIMR;
  uint32_t      RESERVED15[14];
  __IO uint32_t MMCTSCGPR;
  __IO uint32_t MMCTMCGPR;
  uint32_t      RESERVED16[5];
  __IO uint32_t MMCTPCGR;
  uint32_t      RESERVED17[10];
  __IO uint32_t MMCRCRCEPR;
  __IO uint32_t MMCRAEPR;
  uint32_t      RESERVED18[10];
  __IO uint32_t MMCRUPGR;
  uint32_t      RESERVED19[9];
  __IO uint32_t MMCTLPIMSTR;
  __IO uint32_t MMCTLPITCR;
  __IO uint32_t MMCRLPIMSTR;
  __IO uint32_t MMCRLPITCR;
  uint32_t      RESERVED20[65];
  __IO uint32_t MACL3L4C0R;
  __IO uint32_t MACL4A0R;
  uint32_t      RESERVED21[2];
  __IO uint32_t MACL3A0R0R;
  __IO uint32_t MACL3A1R0R;
  __IO uint32_t MACL3A2R0R;
  __IO uint32_t MACL3A3R0R;
  uint32_t      RESERVED22[4];
  __IO uint32_t MACL3L4C1R;
  __IO uint32_t MACL4A1R;
  uint32_t      RESERVED23[2];
  __IO uint32_t MACL3A0R1R;
  __IO uint32_t MACL3A1R1R;
  __IO uint32_t MACL3A2R1R;
  __IO uint32_t MACL3A3R1R;
  uint32_t      RESERVED24[108];
  __IO uint32_t MACTSCR;
  __IO uint32_t MACSSIR;
  __IO uint32_t MACSTSR;
  __IO uint32_t MACSTNR;
  __IO uint32_t MACSTSUR;
  __IO uint32_t MACSTNUR;
  __IO uint32_t MACTSAR;
  uint32_t      RESERVED25;
  __IO uint32_t MACTSSR;
  uint32_t      RESERVED26[3];
  __IO uint32_t MACTTSSNR;
  __IO uint32_t MACTTSSSR;
  uint32_t      RESERVED27[2];
  __IO uint32_t MACACR;
  uint32_t      RESERVED28;
  __IO uint32_t MACATSNR;
  __IO uint32_t MACATSSR;
  __IO uint32_t MACTSIACR;
  __IO uint32_t MACTSEACR;
  __IO uint32_t MACTSICNR;
  __IO uint32_t MACTSECNR;
  uint32_t      RESERVED29[4];
  __IO uint32_t MACPPSCR;
  uint32_t      RESERVED30[3];
  __IO uint32_t MACPPSTTSR;
  __IO uint32_t MACPPSTTNR;
  __IO uint32_t MACPPSIR;
  __IO uint32_t MACPPSWR;
  uint32_t      RESERVED31[12];
  __IO uint32_t MACPOCR;
  __IO uint32_t MACSPI0R;
  __IO uint32_t MACSPI1R;
  __IO uint32_t MACSPI2R;
  __IO uint32_t MACLMIR;
  uint32_t      RESERVED32[11];
  __IO uint32_t MTLOMR;
  uint32_t      RESERVED33[7];
  __IO uint32_t MTLISR;
  uint32_t      RESERVED34[55];
  __IO uint32_t MTLTQOMR;
  __IO uint32_t MTLTQUR;
  __IO uint32_t MTLTQDR;
  uint32_t      RESERVED35[8];
  __IO uint32_t MTLQICSR;
  __IO uint32_t MTLRQOMR;
  __IO uint32_t MTLRQMPOCR;
  __IO uint32_t MTLRQDR;
  uint32_t      RESERVED36[177];
  __IO uint32_t DMAMR;
  __IO uint32_t DMASBMR;
  __IO uint32_t DMAISR;
  __IO uint32_t DMADSR;
  uint32_t      RESERVED37[60];
  __IO uint32_t DMACCR;
  __IO uint32_t DMACTCR;
  __IO uint32_t DMACRCR;
  uint32_t      RESERVED38[2];
  __IO uint32_t DMACTDLAR;
  uint32_t      RESERVED39;
  __IO uint32_t DMACRDLAR;
  __IO uint32_t DMACTDTPR;
  uint32_t      RESERVED40;
  __IO uint32_t DMACRDTPR;
  __IO uint32_t DMACTDRLR;
  __IO uint32_t DMACRDRLR;
  __IO uint32_t DMACIER;
  __IO uint32_t DMACRIWTR;
  __IO uint32_t DMACSFCSR;
  uint32_t      RESERVED41;
  __IO uint32_t DMACCATDR;
  uint32_t      RESERVED42;
  __IO uint32_t DMACCARDR;
  uint32_t      RESERVED43;
  __IO uint32_t DMACCATBR;
  uint32_t      RESERVED44;
  __IO uint32_t DMACCARBR;
  __IO uint32_t DMACSR;
  uint32_t      RESERVED45[2];
  __IO uint32_t DMACMFCR;
}ETH_TypeDef;

/**
  * @brief Asynch Interrupt/Event Controller (EXTI)
  */
typedef struct
{
  __IO uint32_t RTSR1;          /*!< EXTI Rising Trigger Selection Register 1,        Address offset:   0x00 */
  __IO uint32_t FTSR1;          /*!< EXTI Falling Trigger Selection Register 1,       Address offset:   0x04 */
  __IO uint32_t SWIER1;         /*!< EXTI Software Interrupt event Register 1,        Address offset:   0x08 */
  __IO uint32_t RPR1;           /*!< EXTI Rising Pending Register 1,                  Address offset:   0x0C */
  __IO uint32_t FPR1;           /*!< EXTI Falling Pending Register 1,                 Address offset:   0x10 */
  __IO uint32_t SECCFGR1;       /*!< EXTI Security Configuration Register 1,          Address offset:   0x14 */
  __IO uint32_t PRIVCFGR1;      /*!< EXTI Privilege Configuration Register 1,         Address offset:   0x18 */
       uint32_t RESERVED1;      /*!< Reserved 1,                                      Address offset:   0x1C */
  __IO uint32_t RTSR2;          /*!< EXTI Rising Trigger Selection Register 2,        Address offset:   0x20 */
  __IO uint32_t FTSR2;          /*!< EXTI Falling Trigger Selection Register 2,       Address offset:   0x24 */
  __IO uint32_t SWIER2;         /*!< EXTI Software Interrupt event Register 2,        Address offset:   0x28 */
  __IO uint32_t RPR2;           /*!< EXTI Rising Pending Register 2,                  Address offset:   0x2C */
  __IO uint32_t FPR2;           /*!< EXTI Falling Pending Register 2,                 Address offset:   0x30 */
  __IO uint32_t SECCFGR2;       /*!< EXTI Security Configuration Register 2,          Address offset:   0x34 */
  __IO uint32_t PRIVCFGR2;      /*!< EXTI Privilege Configuration Register 2,         Address offset:   0x38 */
       uint32_t RESERVED2[9];   /*!< Reserved 2,                                                 0x3C-- 0x5C */
  __IO uint32_t EXTICR[4];      /*!< EXIT External Interrupt Configuration Register,            0x60 -- 0x6C */
  __IO uint32_t LOCKR;          /*!< EXTI Lock Register,                              Address offset:   0x70 */
       uint32_t RESERVED3[3];   /*!< Reserved 3,                                                0x74 -- 0x7C */
  __IO uint32_t IMR1;           /*!< EXTI Interrupt Mask Register 1,                  Address offset:   0x80 */
  __IO uint32_t EMR1;           /*!< EXTI Event Mask Register 1,                      Address offset:   0x84 */
       uint32_t RESERVED4[2];   /*!< Reserved 4,                                                0x88 -- 0x8C */
  __IO uint32_t IMR2;           /*!< EXTI Interrupt Mask Register 2,                  Address offset:   0x90 */
  __IO uint32_t EMR2;           /*!< EXTI Event Mask Register 2,                      Address offset:   0x94 */
} EXTI_TypeDef;

/**
  * @brief FLASH Registers
  */
typedef struct
{
  __IO uint32_t ACR;             /*!< FLASH access control register,                                     Address offset: 0x00 */
  __IO uint32_t NSKEYR;          /*!< FLASH non-secure key register,                                     Address offset: 0x04 */
  __IO uint32_t SECKEYR;         /*!< FLASH secure key register,                                         Address offset: 0x08 */
  __IO uint32_t OPTKEYR;         /*!< FLASH option key register,                                         Address offset: 0x0C */
  __IO uint32_t NSOBKKEYR;       /*!< FLASH non-secure option bytes keys key register,                   Address offset: 0x10 */
  __IO uint32_t SECOBKKEYR;      /*!< FLASH secure option bytes keys key register,                       Address offset: 0x14 */
  __IO uint32_t OPSR;            /*!< FLASH OPSR register,                                               Address offset: 0x18 */
  __IO uint32_t OPTCR;           /*!< Flash Option Control Register,                                     Address offset: 0x1C */
  __IO uint32_t NSSR;            /*!< FLASH non-secure status register,                                  Address offset: 0x20 */
  __IO uint32_t SECSR;           /*!< FLASH secure status register,                                      Address offset: 0x24 */
  __IO uint32_t NSCR;            /*!< FLASH non-secure control register,                                 Address offset: 0x28 */
  __IO uint32_t SECCR;           /*!< FLASH secure control register,                                     Address offset: 0x2C */
  __IO uint32_t NSCCR;           /*!< FLASH non-secure clear control register,                           Address offset: 0x30 */
  __IO uint32_t SECCCR;          /*!< FLASH secure clear control register,                               Address offset: 0x34 */
       uint32_t RESERVED1;       /*!< Reserved1,                                                         Address offset: 0x38 */
  __IO uint32_t PRIVCFGR;        /*!< FLASH privilege configuration register,                            Address offset: 0x3C */
  __IO uint32_t NSOBKCFGR;       /*!< FLASH non-secure option byte key configuration register,           Address offset: 0x40 */
  __IO uint32_t SECOBKCFGR;      /*!< FLASH secure option byte key configuration register,               Address offset: 0x44 */
  __IO uint32_t HDPEXTR;         /*!< FLASH HDP extension register,                                      Address offset: 0x48 */
       uint32_t RESERVED2;       /*!< Reserved2,                                                         Address offset: 0x4C */
  __IO uint32_t OPTSR_CUR;       /*!< FLASH option status current register,                              Address offset: 0x50 */
  __IO uint32_t OPTSR_PRG;       /*!< FLASH option status to program register,                           Address offset: 0x54 */
       uint32_t RESERVED3[2];    /*!< Reserved3,                                                         Address offset: 0x58-0x5C */
  __IO uint32_t NSEPOCHR_CUR;    /*!< FLASH non-secure epoch current register,                           Address offset: 0x60 */
  __IO uint32_t NSEPOCHR_PRG;    /*!< FLASH non-secure epoch to program register,                        Address offset: 0x64 */
  __IO uint32_t SECEPOCHR_CUR;   /*!< FLASH secure epoch current register,                               Address offset: 0x68 */
  __IO uint32_t SECEPOCHR_PRG;   /*!< FLASH secure epoch to program register,                            Address offset: 0x6C */
  __IO uint32_t OPTSR2_CUR;      /*!< FLASH option status current register 2,                            Address offset: 0x70 */
  __IO uint32_t OPTSR2_PRG;      /*!< FLASH option status to program register 2,                         Address offset: 0x74 */
       uint32_t RESERVED4[2];    /*!< Reserved4,                                                         Address offset: 0x78-0x7C */
  __IO uint32_t NSBOOTR_CUR;     /*!< FLASH non-secure unique boot entry current register,               Address offset: 0x80 */
  __IO uint32_t NSBOOTR_PRG;     /*!< FLASH non-secure unique boot entry to program register,            Address offset: 0x84 */
  __IO uint32_t SECBOOTR_CUR;    /*!< FLASH secure unique boot entry current register,                   Address offset: 0x88 */
  __IO uint32_t SECBOOTR_PRG;    /*!< FLASH secure unique boot entry to program register,                Address offset: 0x8C */
  __IO uint32_t OTPBLR_CUR;      /*!< FLASH OTP block lock current register,                             Address offset: 0x90 */
  __IO uint32_t OTPBLR_PRG;      /*!< FLASH OTP block Lock to program register,                          Address offset: 0x94 */
       uint32_t RESERVED5[2];    /*!< Reserved5,                                                         Address offset: 0x98-0x9C */
  __IO uint32_t SECBB1R1;        /*!< FLASH secure block-based bank 1 register 1,                        Address offset: 0xA0 */
  __IO uint32_t SECBB1R2;        /*!< FLASH secure block-based bank 1 register 2,                        Address offset: 0xA4 */
  __IO uint32_t SECBB1R3;        /*!< FLASH secure block-based bank 1 register 3,                        Address offset: 0xA8 */
  __IO uint32_t SECBB1R4;        /*!< FLASH secure block-based bank 1 register 4,                        Address offset: 0xAC */
       uint32_t RESERVED6[4];    /*!< Reserved6,                                                         Address offset: 0xB0-0xBC */
  __IO uint32_t PRIVBB1R1;       /*!< FLASH privilege block-based bank 1 register 1,                     Address offset: 0xC0 */
  __IO uint32_t PRIVBB1R2;       /*!< FLASH privilege block-based bank 1 register 2,                     Address offset: 0xC4 */
  __IO uint32_t PRIVBB1R3;       /*!< FLASH privilege block-based bank 1 register 3,                     Address offset: 0xC8 */
  __IO uint32_t PRIVBB1R4;       /*!< FLASH privilege block-based bank 1 register 4,                     Address offset: 0xCC */
       uint32_t RESERVED7[4];    /*!< Reserved7,                                                         Address offset: 0xD0-0xDC */
  __IO uint32_t SECWM1R_CUR;     /*!< FLASH secure watermark 1 current register,                         Address offset: 0xE0 */
  __IO uint32_t SECWM1R_PRG;     /*!< FLASH secure watermark 1 to program register,                      Address offset: 0xE4 */
  __IO uint32_t WRP1R_CUR;       /*!< FLASH write sector group protection current register for bank1,    Address offset: 0xE8 */
  __IO uint32_t WRP1R_PRG;       /*!< FLASH write sector group protection to program register for bank1, Address offset: 0xEC */
  __IO uint32_t EDATA1R_CUR;     /*!< FLASH data sectors configuration current register for bank1,       Address offset: 0xF0 */
  __IO uint32_t EDATA1R_PRG;     /*!< FLASH data sectors configuration to program register for bank1,    Address offset: 0xF4 */
  __IO uint32_t HDP1R_CUR;       /*!< FLASH HDP configuration current register for bank1,                Address offset: 0xF8 */
  __IO uint32_t HDP1R_PRG;       /*!< FLASH HDP configuration to program register for bank1,             Address offset: 0xFC */
  __IO uint32_t ECCCORR;         /*!< FLASH ECC correction register,                                     Address offset: 0x100 */
  __IO uint32_t ECCDETR;         /*!< FLASH ECC detection register,                                      Address offset: 0x104 */
  __IO uint32_t ECCDR;           /*!< FLASH ECC data register,                                           Address offset: 0x108 */
       uint32_t RESERVED8[37];   /*!< Reserved8,                                                         Address offset: 0x10C-0x19C */
  __IO uint32_t SECBB2R1;        /*!< FLASH secure block-based bank 2 register 1,                        Address offset: 0x1A0 */
  __IO uint32_t SECBB2R2;        /*!< FLASH secure block-based bank 2 register 2,                        Address offset: 0x1A4 */
  __IO uint32_t SECBB2R3;        /*!< FLASH secure block-based bank 2 register 3,                        Address offset: 0x1A8 */
  __IO uint32_t SECBB2R4;        /*!< FLASH secure block-based bank 2 register 4,                        Address offset: 0x1AC */
       uint32_t RESERVED9[4];    /*!< Reserved9,                                                         Address offset: 0x1B0-0x1BC */
  __IO uint32_t PRIVBB2R1;       /*!< FLASH privilege block-based bank 2 register 1,                     Address offset: 0x1C0 */
  __IO uint32_t PRIVBB2R2;       /*!< FLASH privilege block-based bank 2 register 2,                     Address offset: 0x1C4 */
  __IO uint32_t PRIVBB2R3;       /*!< FLASH privilege block-based bank 2 register 3,                     Address offset: 0x1C8 */
  __IO uint32_t PRIVBB2R4;       /*!< FLASH privilege block-based bank 2 register 4,                     Address offset: 0x1CC */
       uint32_t RESERVED10[4];   /*!< Reserved10,                                                        Address offset: 0x1D0-0x1DC */
  __IO uint32_t SECWM2R_CUR;     /*!< FLASH secure watermark 2 current register,                         Address offset: 0x1E0 */
  __IO uint32_t SECWM2R_PRG;     /*!< FLASH secure watermark 2 to program register,                      Address offset: 0x1E4 */
  __IO uint32_t WRP2R_CUR;       /*!< FLASH write sector group protection current register for bank2,    Address offset: 0x1E8 */
  __IO uint32_t WRP2R_PRG;       /*!< FLASH write sector group protection to program register for bank2, Address offset: 0x1EC */
  __IO uint32_t EDATA2R_CUR;     /*!< FLASH data sectors configuration current register for bank2,       Address offset: 0x1F0 */
  __IO uint32_t EDATA2R_PRG;     /*!< FLASH data sectors configuration to program register for bank2,    Address offset: 0x1F4 */
  __IO uint32_t HDP2R_CUR;       /*!< FLASH HDP configuration current register for bank2,                Address offset: 0x1F8 */
  __IO uint32_t HDP2R_PRG;       /*!< FLASH HDP configuration to program register for bank2,             Address offset: 0x1FC */
} FLASH_TypeDef;

/**
  * @brief FMAC
  */
typedef struct
{
  __IO uint32_t X1BUFCFG;        /*!< FMAC X1 Buffer Configuration register, Address offset: 0x00          */
  __IO uint32_t X2BUFCFG;        /*!< FMAC X2 Buffer Configuration register, Address offset: 0x04          */
  __IO uint32_t YBUFCFG;         /*!< FMAC Y Buffer Configuration register,  Address offset: 0x08          */
  __IO uint32_t PARAM;           /*!< FMAC Parameter register,               Address offset: 0x0C          */
  __IO uint32_t CR;              /*!< FMAC Control register,                 Address offset: 0x10          */
  __IO uint32_t SR;              /*!< FMAC Status register,                  Address offset: 0x14          */
  __IO uint32_t WDATA;           /*!< FMAC Write Data register,              Address offset: 0x18          */
  __IO uint32_t RDATA;           /*!< FMAC Read Data register,               Address offset: 0x1C          */
} FMAC_TypeDef;

/**
  * @brief General Purpose I/O
  */
typedef struct
{
  __IO uint32_t MODER;       /*!< GPIO port mode register,               Address offset: 0x00      */
  __IO uint32_t OTYPER;      /*!< GPIO port output type register,        Address offset: 0x04      */
  __IO uint32_t OSPEEDR;     /*!< GPIO port output speed register,       Address offset: 0x08      */
  __IO uint32_t PUPDR;       /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
  __IO uint32_t IDR;         /*!< GPIO port input data register,         Address offset: 0x10      */
  __IO uint32_t ODR;         /*!< GPIO port output data register,        Address offset: 0x14      */
  __IO uint32_t BSRR;        /*!< GPIO port bit set/reset  register,     Address offset: 0x18      */
  __IO uint32_t LCKR;        /*!< GPIO port configuration lock register, Address offset: 0x1C      */
  __IO uint32_t AFR[2];      /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
  __IO uint32_t BRR;         /*!< GPIO Bit Reset register,               Address offset: 0x28      */
  __IO uint32_t HSLVR;       /*!< GPIO high-speed low voltage register,  Address offset: 0x2C      */
  __IO uint32_t SECCFGR;     /*!< GPIO secure configuration register,    Address offset: 0x30      */
} GPIO_TypeDef;

/**
  * @brief Global TrustZone Controller
  */
typedef struct
{
  __IO uint32_t CR;             /*!< TZSC control register,                                                Address offset: 0x00      */
       uint32_t RESERVED1[3];   /*!< Reserved1,                                                            Address offset: 0x04-0x0C */
  __IO uint32_t SECCFGR1;       /*!< TZSC secure configuration register 1,                                 Address offset: 0x10      */
  __IO uint32_t SECCFGR2;       /*!< TZSC secure configuration register 2,                                 Address offset: 0x14      */
  __IO uint32_t SECCFGR3;       /*!< TZSC secure configuration register 3,                                 Address offset: 0x18      */
       uint32_t RESERVED2;      /*!< Reserved2,                                                            Address offset: 0x1C      */
  __IO uint32_t PRIVCFGR1;      /*!< TZSC privilege configuration register 1,                              Address offset: 0x20      */
  __IO uint32_t PRIVCFGR2;      /*!< TZSC privilege configuration register 2,                              Address offset: 0x24      */
  __IO uint32_t PRIVCFGR3;      /*!< TZSC privilege configuration register 3,                              Address offset: 0x28      */
       uint32_t RESERVED3[5];   /*!< Reserved3,                                                            Address offset: 0x2C-0x3C */
  __IO uint32_t MPCWM1ACFGR;    /*!< TZSC memory 1 sub-region A watermark configuration register,          Address offset: 0x40      */
  __IO uint32_t MPCWM1AR;       /*!< TZSC memory 1 sub-region A watermark register,                        Address offset: 0x44      */
  __IO uint32_t MPCWM1BCFGR;    /*!< TZSC memory 1 sub-region B watermark configuration register,          Address offset: 0x48      */
  __IO uint32_t MPCWM1BR;       /*!< TZSC memory 1 sub-region B watermark register,                        Address offset: 0x4C      */
  __IO uint32_t MPCWM2ACFGR;    /*!< TZSC memory 2 sub-region A watermark configuration register,          Address offset: 0x50      */
  __IO uint32_t MPCWM2AR;       /*!< TZSC memory 2 sub-region A watermark register,                        Address offset: 0x54      */
  __IO uint32_t MPCWM2BCFGR;    /*!< TZSC memory 2 sub-region B watermark configuration register,          Address offset: 0x58      */
  __IO uint32_t MPCWM2BR;       /*!< TZSC memory 2 sub-region B watermark register,                        Address offset: 0x5C      */
  __IO uint32_t MPCWM3ACFGR;    /*!< TZSC memory 3 sub-region A watermark configuration register,          Address offset: 0x60      */
  __IO uint32_t MPCWM3AR;       /*!< TZSC memory 3 sub-region A watermark register,                        Address offset: 0x64      */
  __IO uint32_t MPCWM3BCFGR;    /*!< TZSC memory 3 sub-region B watermark configuration register,          Address offset: 0x68      */
  __IO uint32_t MPCWM3BR;       /*!< TZSC memory 3 sub-region B watermark register,                        Address offset: 0x6C      */
  __IO uint32_t MPCWM4ACFGR;    /*!< TZSC memory 4 sub-region A watermark configuration register,          Address offset: 0x70      */
  __IO uint32_t MPCWM4AR;       /*!< TZSC memory 4 sub-region A watermark register,                        Address offset: 0x74      */
  __IO uint32_t MPCWM4BCFGR;    /*!< TZSC memory 4 sub-region B watermark configuration register,          Address offset: 0x78      */
  __IO uint32_t MPCWM4BR;       /*!< TZSC memory 4 sub-region B watermark register,                        Address offset: 0x7c      */
} GTZC_TZSC_TypeDef;

typedef struct
{
  __IO uint32_t CR;             /*!< MPCBBx control register,                  Address offset: 0x00        */
  uint32_t RESERVED1[3];        /*!< Reserved1,                                Address offset: 0x04-0x0C   */
  __IO uint32_t CFGLOCKR1;      /*!< MPCBBx lock register,                     Address offset: 0x10        */
  uint32_t RESERVED2[59];       /*!< Reserved2,                                Address offset: 0x14-0xFC   */
  __IO uint32_t SECCFGR[32];    /*!< MPCBBx security configuration registers,  Address offset: 0x100-0x17C */
  uint32_t RESERVED3[32];       /*!< Reserved3,                                Address offset: 0x180-0x1FC */
  __IO uint32_t PRIVCFGR[32];   /*!< MPCBBx privilege configuration registers, Address offset: 0x200-0x280 */
} GTZC_MPCBB_TypeDef;

typedef struct
{
  __IO uint32_t IER1;           /*!< TZIC interrupt enable register 1, Address offset: 0x00 */
  __IO uint32_t IER2;           /*!< TZIC interrupt enable register 2, Address offset: 0x04 */
  __IO uint32_t IER3;           /*!< TZIC interrupt enable register 3, Address offset: 0x08 */
  __IO uint32_t IER4;           /*!< TZIC interrupt enable register 4, Address offset: 0x0C */
  __IO uint32_t SR1;            /*!< TZIC status register 1,           Address offset: 0x10 */
  __IO uint32_t SR2;            /*!< TZIC status register 2,           Address offset: 0x14 */
  __IO uint32_t SR3;            /*!< TZIC status register 3,           Address offset: 0x18 */
  __IO uint32_t SR4;            /*!< TZIC status register 4,           Address offset: 0x1C */
  __IO uint32_t FCR1;           /*!< TZIC flag clear register 1,       Address offset: 0x20 */
  __IO uint32_t FCR2;           /*!< TZIC flag clear register 2,       Address offset: 0x24 */
  __IO uint32_t FCR3;           /*!< TZIC flag clear register 3,       Address offset: 0x28 */
  __IO uint32_t FCR4;           /*!< TZIC flag clear register 3,       Address offset: 0x2C */
} GTZC_TZIC_TypeDef;

/**
  * @brief Instruction Cache
  */
typedef struct
{
  __IO uint32_t CR;             /*!< ICACHE control register,                Address offset: 0x00 */
  __IO uint32_t SR;             /*!< ICACHE status register,                 Address offset: 0x04 */
  __IO uint32_t IER;            /*!< ICACHE interrupt enable register,       Address offset: 0x08 */
  __IO uint32_t FCR;            /*!< ICACHE Flag clear register,             Address offset: 0x0C */
  __IO uint32_t HMONR;          /*!< ICACHE hit monitor register,            Address offset: 0x10 */
  __IO uint32_t MMONR;          /*!< ICACHE miss monitor register,           Address offset: 0x14 */
       uint32_t RESERVED1[2];   /*!< Reserved,                               Address offset: 0x018-0x01C */
  __IO uint32_t CRR0;           /*!< ICACHE region 0 configuration register, Address offset: 0x20 */
  __IO uint32_t CRR1;           /*!< ICACHE region 1 configuration register, Address offset: 0x24 */
  __IO uint32_t CRR2;           /*!< ICACHE region 2 configuration register, Address offset: 0x28 */
  __IO uint32_t CRR3;           /*!< ICACHE region 3 configuration register, Address offset: 0x2C */
} ICACHE_TypeDef;

/**
  * @brief Data Cache
  */
typedef struct
{
  __IO uint32_t CR;             /*!< DCACHE control register,               Address offset: 0x00 */
  __IO uint32_t SR;             /*!< DCACHE status register,                Address offset: 0x04 */
  __IO uint32_t IER;            /*!< DCACHE interrupt enable register,      Address offset: 0x08 */
  __IO uint32_t FCR;            /*!< DCACHE Flag clear register,            Address offset: 0x0C */
  __IO uint32_t RHMONR;         /*!< DCACHE Read hit monitor register,      Address offset: 0x10 */
  __IO uint32_t RMMONR;         /*!< DCACHE Read miss monitor register,     Address offset: 0x14 */
       uint32_t RESERVED1[2];   /*!< Reserved,                              Address offset: 0x18-0x1C */
  __IO uint32_t WHMONR;         /*!< DCACHE Write hit monitor register,     Address offset: 0x20 */
  __IO uint32_t WMMONR;         /*!< DCACHE Write miss monitor register,    Address offset: 0x24 */
  __IO uint32_t CMDRSADDRR;     /*!< DCACHE Command Start Address register, Address offset: 0x28 */
  __IO uint32_t CMDREADDRR;     /*!< DCACHE Command End Address register,   Address offset: 0x2C */
} DCACHE_TypeDef;

/**
  * @brief TIM
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< TIM control register 1,                   Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TIM control register 2,                   Address offset: 0x04 */
  __IO uint32_t SMCR;        /*!< TIM slave mode control register,          Address offset: 0x08 */
  __IO uint32_t DIER;        /*!< TIM DMA/interrupt enable register,        Address offset: 0x0C */
  __IO uint32_t SR;          /*!< TIM status register,                      Address offset: 0x10 */
  __IO uint32_t EGR;         /*!< TIM event generation register,            Address offset: 0x14 */
  __IO uint32_t CCMR1;       /*!< TIM capture/compare mode register 1,      Address offset: 0x18 */
  __IO uint32_t CCMR2;       /*!< TIM capture/compare mode register 2,      Address offset: 0x1C */
  __IO uint32_t CCER;        /*!< TIM capture/compare enable register,      Address offset: 0x20 */
  __IO uint32_t CNT;         /*!< TIM counter register,                     Address offset: 0x24 */
  __IO uint32_t PSC;         /*!< TIM prescaler,                            Address offset: 0x28 */
  __IO uint32_t ARR;         /*!< TIM auto-reload register,                 Address offset: 0x2C */
  __IO uint32_t RCR;         /*!< TIM repetition counter register,          Address offset: 0x30 */
  __IO uint32_t CCR1;        /*!< TIM capture/compare register 1,           Address offset: 0x34 */
  __IO uint32_t CCR2;        /*!< TIM capture/compare register 2,           Address offset: 0x38 */
  __IO uint32_t CCR3;        /*!< TIM capture/compare register 3,           Address offset: 0x3C */
  __IO uint32_t CCR4;        /*!< TIM capture/compare register 4,           Address offset: 0x40 */
  __IO uint32_t BDTR;        /*!< TIM break and dead-time register,         Address offset: 0x44 */
  __IO uint32_t CCR5;        /*!< TIM capture/compare register 5,           Address offset: 0x48 */
  __IO uint32_t CCR6;        /*!< TIM capture/compare register 6,           Address offset: 0x4C */
  __IO uint32_t CCMR3;       /*!< TIM capture/compare mode register 3,      Address offset: 0x50 */
  __IO uint32_t DTR2;        /*!< TIM deadtime register 2,                  Address offset: 0x54 */
  __IO uint32_t ECR;         /*!< TIM encoder control register,             Address offset: 0x58 */
  __IO uint32_t TISEL;       /*!< TIM Input Selection register,             Address offset: 0x5C */
  __IO uint32_t AF1;         /*!< TIM alternate function option register 1, Address offset: 0x60 */
  __IO uint32_t AF2;         /*!< TIM alternate function option register 2, Address offset: 0x64 */
  __IO uint32_t OR1 ;        /*!< TIM option register,                      Address offset: 0x68 */
       uint32_t RESERVED0[220];/*!< Reserved,                               Address offset: 0x6C */
  __IO uint32_t DCR;         /*!< TIM DMA control register,                 Address offset: 0x3DC */
  __IO uint32_t DMAR;        /*!< TIM DMA address for full transfer,        Address offset: 0x3E0 */
} TIM_TypeDef;

/**
  * @brief LPTIMER
  */
typedef struct
{
  __IO uint32_t ISR;            /*!< LPTIM Interrupt and Status register,    Address offset: 0x00 */
  __IO uint32_t ICR;            /*!< LPTIM Interrupt Clear register,         Address offset: 0x04 */
  __IO uint32_t DIER;           /*!< LPTIM Interrupt Enable register,        Address offset: 0x08 */
  __IO uint32_t CFGR;           /*!< LPTIM Configuration register,           Address offset: 0x0C */
  __IO uint32_t CR;             /*!< LPTIM Control register,                 Address offset: 0x10 */
  __IO uint32_t CCR1;           /*!< LPTIM Capture/Compare register 1,       Address offset: 0x14 */
  __IO uint32_t ARR;            /*!< LPTIM Autoreload register,              Address offset: 0x18 */
  __IO uint32_t CNT;            /*!< LPTIM Counter register,                 Address offset: 0x1C */
  __IO uint32_t RESERVED0;      /*!< Reserved,                               Address offset: 0x20 */
  __IO uint32_t CFGR2;          /*!< LPTIM Configuration register 2,         Address offset: 0x24 */
  __IO uint32_t RCR;            /*!< LPTIM Repetition register,              Address offset: 0x28 */
  __IO uint32_t CCMR1;          /*!< LPTIM Capture/Compare mode register,    Address offset: 0x2C */
  __IO uint32_t RESERVED1;      /*!< Reserved,                               Address offset: 0x30 */
  __IO uint32_t CCR2;           /*!< LPTIM Capture/Compare register 2,       Address offset: 0x34 */
} LPTIM_TypeDef;

/**
  * @brief OCTO Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR;          /*!< OCTOSPI Control register,                            Address offset: 0x000 */
  uint32_t RESERVED;         /*!< Reserved,                                            Address offset: 0x004 */
  __IO uint32_t DCR1;        /*!< OCTOSPI Device Configuration register 1,             Address offset: 0x008 */
  __IO uint32_t DCR2;        /*!< OCTOSPI Device Configuration register 2,             Address offset: 0x00C */
  __IO uint32_t DCR3;        /*!< OCTOSPI Device Configuration register 3,             Address offset: 0x010 */
  __IO uint32_t DCR4;        /*!< OCTOSPI Device Configuration register 4,             Address offset: 0x014 */
  uint32_t RESERVED1[2];     /*!< Reserved,                                            Address offset: 0x018-0x01C */
  __IO uint32_t SR;          /*!< OCTOSPI Status register,                             Address offset: 0x020 */
  __IO uint32_t FCR;         /*!< OCTOSPI Flag Clear register,                         Address offset: 0x024 */
  uint32_t RESERVED2[6];     /*!< Reserved,                                            Address offset: 0x028-0x03C */
  __IO uint32_t DLR;         /*!< OCTOSPI Data Length register,                        Address offset: 0x040 */
  uint32_t RESERVED3;        /*!< Reserved,                                            Address offset: 0x044 */
  __IO uint32_t AR;          /*!< OCTOSPI Address register,                            Address offset: 0x048 */
  uint32_t RESERVED4;        /*!< Reserved,                                            Address offset: 0x04C */
  __IO uint32_t DR;          /*!< OCTOSPI Data register,                               Address offset: 0x050 */
  uint32_t RESERVED5[11];    /*!< Reserved,                                            Address offset: 0x054-0x07C */
  __IO uint32_t PSMKR;       /*!< OCTOSPI Polling Status Mask register,                Address offset: 0x080 */
  uint32_t RESERVED6;        /*!< Reserved,                                            Address offset: 0x084 */
  __IO uint32_t PSMAR;       /*!< OCTOSPI Polling Status Match register,               Address offset: 0x088 */
  uint32_t RESERVED7;        /*!< Reserved,                                            Address offset: 0x08C */
  __IO uint32_t PIR;         /*!< OCTOSPI Polling Interval register,                   Address offset: 0x090 */
  uint32_t RESERVED8[27];    /*!< Reserved,                                            Address offset: 0x094-0x0FC */
  __IO uint32_t CCR;         /*!< OCTOSPI Communication Configuration register,        Address offset: 0x100 */
  uint32_t RESERVED9;        /*!< Reserved,                                            Address offset: 0x104 */
  __IO uint32_t TCR;         /*!< OCTOSPI Timing Configuration register,               Address offset: 0x108 */
  uint32_t RESERVED10;       /*!< Reserved,                                            Address offset: 0x10C */
  __IO uint32_t IR;          /*!< OCTOSPI Instruction register,                        Address offset: 0x110 */
  uint32_t RESERVED11[3];    /*!< Reserved,                                            Address offset: 0x114-0x11C */
  __IO uint32_t ABR;         /*!< OCTOSPI Alternate Bytes register,                    Address offset: 0x120 */
  uint32_t RESERVED12[3];    /*!< Reserved,                                            Address offset: 0x124-0x12C */
  __IO uint32_t LPTR;        /*!< OCTOSPI Low Power Timeout register,                  Address offset: 0x130 */
  uint32_t RESERVED13[3];    /*!< Reserved,                                            Address offset: 0x134-0x13C */
  __IO uint32_t WPCCR;       /*!< OCTOSPI Wrap Communication Configuration register,   Address offset: 0x140 */
  uint32_t RESERVED14;       /*!< Reserved,                                            Address offset: 0x144 */
  __IO uint32_t WPTCR;       /*!< OCTOSPI Wrap Timing Configuration register,          Address offset: 0x148 */
  uint32_t RESERVED15;       /*!< Reserved,                                            Address offset: 0x14C */
  __IO uint32_t WPIR;        /*!< OCTOSPI Wrap Instruction register,                   Address offset: 0x150 */
  uint32_t RESERVED16[3];    /*!< Reserved,                                            Address offset: 0x154-0x15C */
  __IO uint32_t WPABR;       /*!< OCTOSPI Wrap Alternate Bytes register,               Address offset: 0x160 */
  uint32_t RESERVED17[7];    /*!< Reserved,                                            Address offset: 0x164-0x17C */
  __IO uint32_t WCCR;        /*!< OCTOSPI Write Communication Configuration register,  Address offset: 0x180 */
  uint32_t RESERVED18;       /*!< Reserved,                                            Address offset: 0x184 */
  __IO uint32_t WTCR;        /*!< OCTOSPI Write Timing Configuration register,         Address offset: 0x188 */
  uint32_t RESERVED19;       /*!< Reserved,                                            Address offset: 0x18C */
  __IO uint32_t WIR;         /*!< OCTOSPI Write Instruction register,                  Address offset: 0x190 */
  uint32_t RESERVED20[3];    /*!< Reserved,                                            Address offset: 0x194-0x19C */
  __IO uint32_t WABR;        /*!< OCTOSPI Write Alternate Bytes register,              Address offset: 0x1A0 */
  uint32_t RESERVED21[23];   /*!< Reserved,                                            Address offset: 0x1A4-0x1FC */
  __IO uint32_t HLCR;        /*!< OCTOSPI Hyperbus Latency Configuration register,     Address offset: 0x200 */
} XSPI_TypeDef;

typedef  XSPI_TypeDef OCTOSPI_TypeDef;



/**
  * @brief Power Control
  */
typedef struct
{
  __IO uint32_t PMCR;         /*!< Power mode control register ,          Address offset: 0x00      */
  __IO uint32_t PMSR;         /*!< Power mode status register ,           Address offset: 0x04      */
       uint32_t RESERVED1[2]; /*!< Reserved,                              Address offset: 0x08-0x0C */
  __IO uint32_t VOSCR;        /*!< Voltage scaling control register ,     Address offset: 0x10      */
  __IO uint32_t VOSSR;        /*!< Voltage sacling status register ,      Address offset: 0x14      */
       uint32_t RESERVED2[2]; /*!< Reserved,                              Address offset: 0x18-0x1C */
  __IO uint32_t BDCR;         /*!< BacKup domain control register ,       Address offset: 0x20      */
  __IO uint32_t DBPCR;        /*!< DBP control register,                  Address offset: 0x24      */
  __IO uint32_t BDSR;         /*!< BacKup domain status register,         Address offset: 0x28      */
  __IO uint32_t UCPDR;        /*!< Usb typeC and Power Delivery Register, Address offset: 0x2C      */
  __IO uint32_t SCCR;         /*!< Supply configuration control register, Address offset: 0x30      */
  __IO uint32_t VMCR;         /*!< Voltage Monitor Control Register,      Address offset: 0x34      */
  __IO uint32_t USBSCR;       /*!< USB Supply Control Register            Address offset: 0x38      */
  __IO uint32_t VMSR;         /*!< Status Register Voltage Monitoring,    Address offset: 0x3C      */
  __IO uint32_t WUSCR;        /*!< WakeUP status clear register,          Address offset: 0x40      */
  __IO uint32_t WUSR;         /*!< WakeUP status Register,                Address offset: 0x44      */
  __IO uint32_t WUCR;         /*!< WakeUP configuration register,         Address offset: 0x48      */
       uint32_t RESERVED3;    /*!< Reserved,                              Address offset: 0x4C      */
  __IO uint32_t IORETR;       /*!< IO RETention Register,                 Address offset: 0x50      */
       uint32_t RESERVED4[43];/*!< Reserved,                              Address offset: 0x54-0xFC */
  __IO uint32_t SECCFGR;      /*!< Security configuration register,       Address offset: 0x100     */
  __IO uint32_t PRIVCFGR;     /*!< Privilege configuration register,     Address offset: 0x104      */
}PWR_TypeDef;

/**
  * @brief SRAMs configuration controller
  */
typedef struct
{
  __IO uint32_t CR;       /*!< Control Register,                  Address offset: 0x00 */
  __IO uint32_t IER;      /*!< Interrupt Enable Register,         Address offset: 0x04 */
  __IO uint32_t ISR;      /*!< Interrupt Status Register,         Address offset: 0x08 */
  __IO uint32_t SEAR;     /*!< ECC Single Error Address Register, Address offset: 0x0C */
  __IO uint32_t DEAR;     /*!< ECC Double Error Address Register, Address offset: 0x10 */
  __IO uint32_t ICR;      /*!< Interrupt Clear Register,          Address offset: 0x14 */
  __IO uint32_t WPR1;     /*!< SRAM Write Protection Register 1,  Address offset: 0x18 */
  __IO uint32_t WPR2;     /*!< SRAM Write Protection Register 2,  Address offset: 0x1C */
  uint32_t      RESERVED; /*!< Reserved,                          Address offset: 0x20 */
  __IO uint32_t ECCKEY;   /*!< SRAM ECC Key Register,             Address offset: 0x24 */
  __IO uint32_t ERKEYR;   /*!< SRAM Erase Key Register,           Address offset: 0x28 */
}RAMCFG_TypeDef;

/**
  * @brief Reset and Clock Control
  */
typedef struct
{
  __IO uint32_t CR;            /*!< RCC clock control register                                               Address offset: 0x00 */
  uint32_t      RESERVED1[3];  /*!< Reserved,                                                                Address offset: 0x04 */
  __IO uint32_t HSICFGR;       /*!< RCC HSI Clock Calibration Register,                                      Address offset: 0x10 */
  __IO uint32_t CRRCR;         /*!< RCC Clock Recovery RC Register,                                          Address offset: 0x14 */
  __IO uint32_t CSICFGR;       /*!< RCC CSI Clock Calibration Register,                                      Address offset: 0x18 */
  __IO uint32_t CFGR1;         /*!< RCC clock configuration register 1                                       Address offset: 0x1C */
  __IO uint32_t CFGR2;         /*!< RCC clock configuration register 2                                       Address offset: 0x20 */
  uint32_t      RESERVED2;     /*!< Reserved,                                                                Address offset: 0x24 */
  __IO uint32_t PLL1CFGR;      /*!< RCC PLL1 Configuration Register                                          Address offset: 0x28 */
  __IO uint32_t PLL2CFGR;      /*!< RCC PLL2 Configuration Register                                          Address offset: 0x2C */
  __IO uint32_t PLL3CFGR;      /*!< RCC PLL3 Configuration Register                                          Address offset: 0x30 */
  __IO uint32_t PLL1DIVR;      /*!< RCC PLL1 Dividers Configuration Register                                 Address offset: 0x34 */
  __IO uint32_t PLL1FRACR;     /*!< RCC PLL1 Fractional Divider Configuration Register                       Address offset: 0x38 */
  __IO uint32_t PLL2DIVR;      /*!< RCC PLL2 Dividers Configuration Register                                 Address offset: 0x3C */
  __IO uint32_t PLL2FRACR;     /*!< RCC PLL2 Fractional Divider Configuration Register                       Address offset: 0x40 */
  __IO uint32_t PLL3DIVR;      /*!< RCC PLL3 Dividers Configuration Register                                 Address offset: 0x44 */
  __IO uint32_t PLL3FRACR;     /*!< RCC PLL3 Fractional Divider Configuration Register                       Address offset: 0x48 */
  uint32_t      RESERVED5;     /*!< Reserved                                                                 Address offset: 0x4C */
  __IO uint32_t CIER;          /*!< RCC Clock Interrupt Enable Register                                      Address offset: 0x50 */
  __IO uint32_t CIFR;          /*!< RCC Clock Interrupt Flag Register                                        Address offset: 0x54 */
  __IO uint32_t CICR;          /*!< RCC Clock Interrupt Clear Register                                       Address offset: 0x58 */
  uint32_t      RESERVED6;     /*!< Reserved                                                                 Address offset: 0x5C */
  __IO uint32_t AHB1RSTR;      /*!< RCC AHB1 Peripherals Reset Register                                      Address offset: 0x60 */
  __IO uint32_t AHB2RSTR;      /*!< RCC AHB2 Peripherals Reset Register                                      Address offset: 0x64 */
  uint32_t      RESERVED7;     /*!< Reserved                                                                 Address offset: 0x68 */
  __IO uint32_t AHB4RSTR;      /*!< RCC AHB4 Peripherals Reset Register                                      Address offset: 0x6C */
  uint32_t      RESERVED9;     /*!< Reserved                                                                 Address offset: 0x70 */
  __IO uint32_t APB1LRSTR;     /*!< RCC APB1 Peripherals reset Low Word register                             Address offset: 0x74 */
  __IO uint32_t APB1HRSTR;     /*!< RCC APB1 Peripherals reset High Word register                            Address offset: 0x78 */
  __IO uint32_t APB2RSTR;      /*!< RCC APB2 Peripherals Reset Register                                      Address offset: 0x7C */
  __IO uint32_t APB3RSTR;      /*!< RCC APB3 Peripherals Reset Register                                      Address offset: 0x80 */
  uint32_t      RESERVED10;    /*!< Reserved                                                                 Address offset: 0x84 */
  __IO uint32_t AHB1ENR;       /*!< RCC AHB1 Peripherals Clock Enable Register                               Address offset: 0x88 */
  __IO uint32_t AHB2ENR;       /*!< RCC AHB2 Peripherals Clock Enable Register                               Address offset: 0x8C */
  uint32_t      RESERVED11;    /*!< Reserved                                                                 Address offset: 0x90 */
  __IO uint32_t AHB4ENR;       /*!< RCC AHB4 Peripherals Clock Enable Register                               Address offset: 0x94 */
  uint32_t      RESERVED13;    /*!< Reserved                                                                 Address offset: 0x98 */
  __IO uint32_t APB1LENR;      /*!< RCC APB1 Peripherals clock Enable Low Word register                      Address offset: 0x9C */
  __IO uint32_t APB1HENR;      /*!< RCC APB1 Peripherals clock Enable High Word register                     Address offset: 0xA0 */
  __IO uint32_t APB2ENR;       /*!< RCC APB2 Peripherals Clock Enable Register                               Address offset: 0xA4 */
  __IO uint32_t APB3ENR;       /*!< RCC APB3 Peripherals Clock Enable Register                               Address offset: 0xA8 */
  uint32_t      RESERVED14;    /*!< Reserved                                                                 Address offset: 0xAC */
  __IO uint32_t AHB1LPENR;     /*!< RCC AHB1 Peripheral sleep clock Register                                 Address offset: 0xB0 */
  __IO uint32_t AHB2LPENR;     /*!< RCC AHB2 Peripheral sleep clock Register                                 Address offset: 0xB4 */
  uint32_t      RESERVED15;    /*!< Reserved                                                                 Address offset: 0xB8 */
  __IO uint32_t AHB4LPENR;     /*!< RCC AHB4 Peripherals sleep clock Register                                Address offset: 0xBC */
  uint32_t      RESERVED17;    /*!< Reserved                                                                 Address offset: 0xC0 */
  __IO uint32_t APB1LLPENR;    /*!< RCC APB1 Peripherals sleep clock Low Word Register                       Address offset: 0xC4 */
  __IO uint32_t APB1HLPENR;    /*!< RCC APB1 Peripherals sleep clock High Word Register                      Address offset: 0xC8 */
  __IO uint32_t APB2LPENR;     /*!< RCC APB2 Peripherals sleep clock Register                                Address offset: 0xCC */
  __IO uint32_t APB3LPENR;     /*!< RCC APB3 Peripherals Clock Low Power Enable Register                     Address offset: 0xD0 */
  uint32_t      RESERVED18;    /*!< Reserved                                                                 Address offset: 0xD4 */
  __IO uint32_t CCIPR1;        /*!< RCC IPs Clocks Configuration Register 1                                  Address offset: 0xD8 */
  __IO uint32_t CCIPR2;        /*!< RCC IPs Clocks Configuration Register 2                                  Address offset: 0xDC */
  __IO uint32_t CCIPR3;        /*!< RCC IPs Clocks Configuration Register 3                                  Address offset: 0xE0 */
  __IO uint32_t CCIPR4;        /*!< RCC IPs Clocks Configuration Register 4                                  Address offset: 0xE4 */
  __IO uint32_t CCIPR5;        /*!< RCC IPs Clocks Configuration Register 5                                  Address offset: 0xE8 */
  uint32_t      RESERVED19;    /*!< Reserved,                                                                Address offset: 0xEC */
  __IO uint32_t BDCR;          /*!< RCC VSW Backup Domain & V33 Domain Control Register                      Address offset: 0xF0 */
  __IO uint32_t RSR;           /*!< RCC Reset status Register                                                Address offset: 0xF4 */
  uint32_t      RESERVED20[6]; /*!< Reserved                                                                 Address offset: 0xF8 */
  __IO uint32_t SECCFGR;       /*!< RCC Secure mode configuration register                                   Address offset: 0x110 */
  __IO uint32_t PRIVCFGR;      /*!< RCC Privilege configuration register                                     Address offset: 0x114 */
} RCC_TypeDef;

/**
  * @brief PKA
  */
typedef struct
{
  __IO uint32_t CR;            /*!< PKA control register,             Address offset: 0x00 */
  __IO uint32_t SR;            /*!< PKA status register,              Address offset: 0x04 */
  __IO uint32_t CLRFR;         /*!< PKA clear flag register,          Address offset: 0x08 */
  uint32_t Reserved[253];      /*!< Reserved memory area              Address offset: 0x0C  -> 0x03FC */
  __IO uint32_t RAM[1334];     /*!< PKA RAM                           Address offset: 0x400 -> 0x18D4 */
} PKA_TypeDef;

/*
* @brief RTC Specific device feature definitions
*/
#define RTC_BKP_NB         32U
#define RTC_TAMP_NB        8U

/**
  * @brief Real-Time Clock
  */
typedef struct
{
  __IO uint32_t TR;          /*!< RTC time register,                              Address offset: 0x00 */
  __IO uint32_t DR;          /*!< RTC date register,                              Address offset: 0x04 */
  __IO uint32_t SSR;         /*!< RTC sub second register,                        Address offset: 0x08 */
  __IO uint32_t ICSR;        /*!< RTC initialization control and status register, Address offset: 0x0C */
  __IO uint32_t PRER;        /*!< RTC prescaler register,                         Address offset: 0x10 */
  __IO uint32_t WUTR;        /*!< RTC wakeup timer register,                      Address offset: 0x14 */
  __IO uint32_t CR;          /*!< RTC control register,                           Address offset: 0x18 */
  __IO uint32_t PRIVCFGR;    /*!< RTC privilege mode control register,            Address offset: 0x1C */
  __IO uint32_t SECCFGR;     /*!< RTC secure mode control register,               Address offset: 0x20 */
  __IO uint32_t WPR;         /*!< RTC write protection register,                  Address offset: 0x24 */
  __IO uint32_t CALR;        /*!< RTC calibration register,                       Address offset: 0x28 */
  __IO uint32_t SHIFTR;      /*!< RTC shift control register,                     Address offset: 0x2C */
  __IO uint32_t TSTR;        /*!< RTC time stamp time register,                   Address offset: 0x30 */
  __IO uint32_t TSDR;        /*!< RTC time stamp date register,                   Address offset: 0x34 */
  __IO uint32_t TSSSR;       /*!< RTC time-stamp sub second register,             Address offset: 0x38 */
       uint32_t RESERVED0;   /*!< Reserved,                                       Address offset: 0x3C */
  __IO uint32_t ALRMAR;      /*!< RTC alarm A register,                           Address offset: 0x40 */
  __IO uint32_t ALRMASSR;    /*!< RTC alarm A sub second register,                Address offset: 0x44 */
  __IO uint32_t ALRMBR;      /*!< RTC alarm B register,                           Address offset: 0x48 */
  __IO uint32_t ALRMBSSR;    /*!< RTC alarm B sub second register,                Address offset: 0x4C */
  __IO uint32_t SR;          /*!< RTC Status register,                            Address offset: 0x50 */
  __IO uint32_t MISR;        /*!< RTC masked interrupt status register,           Address offset: 0x54 */
  __IO uint32_t SMISR;       /*!< RTC secure masked interrupt status register,    Address offset: 0x58 */
  __IO uint32_t SCR;         /*!< RTC status Clear register,                      Address offset: 0x5C */
  __IO uint32_t OR;          /*!< RTC option register,                            Address offset: 0x60 */
       uint32_t RESERVED1[3];/*!< Reserved,                                       Address offset: 0x64 */
  __IO uint32_t ALRABINR;    /*!< RTC alarm A binary mode register,               Address offset: 0x70 */
  __IO uint32_t ALRBBINR;    /*!< RTC alarm B binary mode register,               Address offset: 0x74 */
} RTC_TypeDef;

/**
  * @brief Tamper and backup registers
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< TAMP control register 1,                  Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TAMP control register 2,                  Address offset: 0x04 */
  __IO uint32_t CR3;         /*!< TAMP control register 3,                  Address offset: 0x08 */
  __IO uint32_t FLTCR;       /*!< TAMP filter control register,             Address offset: 0x0C */
  __IO uint32_t ATCR1;       /*!< TAMP filter control register 1            Address offset: 0x10 */
  __IO uint32_t ATSEEDR;     /*!< TAMP active tamper seed register,         Address offset: 0x14 */
  __IO uint32_t ATOR;        /*!< TAMP active tamper output register,       Address offset: 0x18 */
  __IO uint32_t ATCR2;       /*!< TAMP filter control register 2,           Address offset: 0x1C */
  __IO uint32_t SECCFGR;     /*!< TAMP secure mode control register,        Address offset: 0x20 */
  __IO uint32_t PRIVCFGR;    /*!< TAMP privilege mode control register,     Address offset: 0x24 */
       uint32_t RESERVED0;   /*!< Reserved,                                 Address offset: 0x28 */
  __IO uint32_t IER;         /*!< TAMP interrupt enable register,           Address offset: 0x2C */
  __IO uint32_t SR;          /*!< TAMP status register,                     Address offset: 0x30 */
  __IO uint32_t MISR;        /*!< TAMP masked interrupt status register,    Address offset: 0x34 */
  __IO uint32_t SMISR;       /*!< TAMP secure masked interrupt status register, Address offset: 0x38 */
  __IO uint32_t SCR;         /*!< TAMP status clear register,               Address offset: 0x3C */
  __IO uint32_t COUNT1R;     /*!< TAMP monotonic counter register,          Address offset: 0x40 */
       uint32_t RESERVED1[3];/*!< Reserved,                                 Address offset: 0x44 -- 0x4C */
  __IO uint32_t OR;          /*!< TAMP option register,                     Address offset: 0x50 */
  __IO uint32_t ERCFGR;      /*!< TAMP erase configuration register,        Address offset: 0x54 */
       uint32_t RESERVED2[42];/*!< Reserved,                                Address offset: 0x58 -- 0xFC */
  __IO uint32_t BKP0R;       /*!< TAMP backup register 0,                   Address offset: 0x100 */
  __IO uint32_t BKP1R;       /*!< TAMP backup register 1,                   Address offset: 0x104 */
  __IO uint32_t BKP2R;       /*!< TAMP backup register 2,                   Address offset: 0x108 */
  __IO uint32_t BKP3R;       /*!< TAMP backup register 3,                   Address offset: 0x10C */
  __IO uint32_t BKP4R;       /*!< TAMP backup register 4,                   Address offset: 0x110 */
  __IO uint32_t BKP5R;       /*!< TAMP backup register 5,                   Address offset: 0x114 */
  __IO uint32_t BKP6R;       /*!< TAMP backup register 6,                   Address offset: 0x118 */
  __IO uint32_t BKP7R;       /*!< TAMP backup register 7,                   Address offset: 0x11C */
  __IO uint32_t BKP8R;       /*!< TAMP backup register 8,                   Address offset: 0x120 */
  __IO uint32_t BKP9R;       /*!< TAMP backup register 9,                   Address offset: 0x124 */
  __IO uint32_t BKP10R;      /*!< TAMP backup register 10,                  Address offset: 0x128 */
  __IO uint32_t BKP11R;      /*!< TAMP backup register 11,                  Address offset: 0x12C */
  __IO uint32_t BKP12R;      /*!< TAMP backup register 12,                  Address offset: 0x130 */
  __IO uint32_t BKP13R;      /*!< TAMP backup register 13,                  Address offset: 0x134 */
  __IO uint32_t BKP14R;      /*!< TAMP backup register 14,                  Address offset: 0x138 */
  __IO uint32_t BKP15R;      /*!< TAMP backup register 15,                  Address offset: 0x13C */
  __IO uint32_t BKP16R;      /*!< TAMP backup register 16,                  Address offset: 0x140 */
  __IO uint32_t BKP17R;      /*!< TAMP backup register 17,                  Address offset: 0x144 */
  __IO uint32_t BKP18R;      /*!< TAMP backup register 18,                  Address offset: 0x148 */
  __IO uint32_t BKP19R;      /*!< TAMP backup register 19,                  Address offset: 0x14C */
  __IO uint32_t BKP20R;      /*!< TAMP backup register 20,                  Address offset: 0x150 */
  __IO uint32_t BKP21R;      /*!< TAMP backup register 21,                  Address offset: 0x154 */
  __IO uint32_t BKP22R;      /*!< TAMP backup register 22,                  Address offset: 0x158 */
  __IO uint32_t BKP23R;      /*!< TAMP backup register 23,                  Address offset: 0x15C */
  __IO uint32_t BKP24R;      /*!< TAMP backup register 24,                  Address offset: 0x160 */
  __IO uint32_t BKP25R;      /*!< TAMP backup register 25,                  Address offset: 0x164 */
  __IO uint32_t BKP26R;      /*!< TAMP backup register 26,                  Address offset: 0x168 */
  __IO uint32_t BKP27R;      /*!< TAMP backup register 27,                  Address offset: 0x16C */
  __IO uint32_t BKP28R;      /*!< TAMP backup register 28,                  Address offset: 0x170 */
  __IO uint32_t BKP29R;      /*!< TAMP backup register 29,                  Address offset: 0x174 */
  __IO uint32_t BKP30R;      /*!< TAMP backup register 30,                  Address offset: 0x178 */
  __IO uint32_t BKP31R;      /*!< TAMP backup register 31,                  Address offset: 0x17C */
} TAMP_TypeDef;

/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< USART Control register 1,                 Address offset: 0x00  */
  __IO uint32_t CR2;         /*!< USART Control register 2,                 Address offset: 0x04  */
  __IO uint32_t CR3;         /*!< USART Control register 3,                 Address offset: 0x08  */
  __IO uint32_t BRR;         /*!< USART Baud rate register,                 Address offset: 0x0C  */
  __IO uint32_t GTPR;        /*!< USART Guard time and prescaler register,  Address offset: 0x10  */
  __IO uint32_t RTOR;        /*!< USART Receiver Time Out register,         Address offset: 0x14  */
  __IO uint32_t RQR;         /*!< USART Request register,                   Address offset: 0x18  */
  __IO uint32_t ISR;         /*!< USART Interrupt and status register,      Address offset: 0x1C  */
  __IO uint32_t ICR;         /*!< USART Interrupt flag Clear register,      Address offset: 0x20  */
  __IO uint32_t RDR;         /*!< USART Receive Data register,              Address offset: 0x24  */
  __IO uint32_t TDR;         /*!< USART Transmit Data register,             Address offset: 0x28  */
  __IO uint32_t PRESC;       /*!< USART Prescaler register,                 Address offset: 0x2C  */
} USART_TypeDef;

/**
  * @brief Serial Audio Interface
  */
typedef struct
{
  __IO uint32_t GCR;          /*!< SAI global configuration register,        Address offset: 0x00 */
  uint32_t      RESERVED[16]; /*!< Reserved,                         Address offset: 0x04 to 0x40 */
  __IO uint32_t PDMCR;        /*!< SAI PDM control register,                 Address offset: 0x44 */
  __IO uint32_t PDMDLY;       /*!< SAI PDM delay register,                   Address offset: 0x48 */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;         /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;         /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;        /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;       /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;         /*!< SAI block x interrupt mask register,      Address offset: 0x14 */
  __IO uint32_t SR;          /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;       /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;          /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;
/**
  * @brief System configuration, Boot and Security
  */
typedef struct
{
       uint32_t RESERVED1[4];   /*!< RESERVED1,                                       Address offset: 0x00 - 0x0C */
  __IO uint32_t HDPLCR;         /*!< SBS HDPL Control Register,                       Address offset: 0x10 */
  __IO uint32_t HDPLSR;         /*!< SBS HDPL Status Register,                        Address offset: 0x14 */
  __IO uint32_t NEXTHDPLCR;     /*!< NEXT HDPL Control Register,                      Address offset: 0x18 */
  __IO uint32_t RESERVED2;      /*!< RESERVED2,                                       Address offset: 0x1C */
  __IO uint32_t DBGCR;          /*!< SBS Debug Control Register,                      Address offset: 0x20 */
  __IO uint32_t DBGLOCKR;       /*!< SBS Debug Lock Register,                         Address offset: 0x24 */
       uint32_t RESERVED3[3];   /*!< RESERVED3,                                       Address offset: 0x28 - 0x30 */
  __IO uint32_t RSSCMDR;        /*!< SBS RSS Command Register,                        Address offset: 0x34 */
       uint32_t RESERVED4[26];  /*!< RESERVED4,                                       Address offset: 0x38 - 0x9C */
  __IO uint32_t EPOCHSELCR;     /*!< EPOCH Selection Register,                        Address offset: 0xA0 */
       uint32_t RESERVED5[7];   /*!< RESERVED5,                                       Address offset: 0xA4 - 0xBC */
  __IO uint32_t SECCFGR;        /*!< SBS Security Mode Configuration,                 Address offset: 0xC0 */
       uint32_t RESERVED6[15];  /*!< RESERVED6,                                       Address offset: 0xC4 - 0xFC */
  __IO uint32_t PMCR;           /*!< SBS Product Mode & Config Register,              Address offset: 0x100 */
  __IO uint32_t FPUIMR;         /*!< SBS FPU Interrupt Mask Register,                 Address offset: 0x104 */
  __IO uint32_t MESR;           /*!< SBS Memory Erase Status Register,                Address offset: 0x108 */
       uint32_t RESERVED7;      /*!< RESERVED7,                                       Address offset: 0x10C */
  __IO uint32_t CCCSR;          /*!< SBS Compensation Cell Control & Status Register, Address offset: 0x110 */
  __IO uint32_t CCVALR;         /*!< SBS Compensation Cell Value Register,            Address offset: 0x114 */
  __IO uint32_t CCSWCR;         /*!< SBS Compensation Cell for I/Os sw code Register, Address offset: 0x118 */
  __IO uint32_t RESERVED8;      /*!< RESERVED8,                                       Address offset: 0x11C */
  __IO uint32_t CFGR2;          /*!< SBS Class B Register,                            Address offset: 0x120 */
       uint32_t RESERVED9[8];   /*!< RESERVED9,                                       Address offset: 0x124 - 0x140 */
  __IO uint32_t CNSLCKR;        /*!< SBS CPU Non-secure Lock Register,                Address offset: 0x144 */
  __IO uint32_t CSLCKR;         /*!< SBS CPU Secure Lock Register,                    Address offset: 0x148 */
  __IO uint32_t ECCNMIR;        /*!< SBS FLITF ECC NMI MASK Register,                 Address offset: 0x14C */
} SBS_TypeDef;

/**
  * @brief Secure digital input/output Interface
  */
typedef struct
{
  __IO uint32_t POWER;          /*!< SDMMC power control register,             Address offset: 0x00  */
  __IO uint32_t CLKCR;          /*!< SDMMC clock control register,             Address offset: 0x04  */
  __IO uint32_t ARG;            /*!< SDMMC argument register,                  Address offset: 0x08  */
  __IO uint32_t CMD;            /*!< SDMMC command register,                   Address offset: 0x0C  */
  __I uint32_t  RESPCMD;        /*!< SDMMC command response register,          Address offset: 0x10  */
  __I uint32_t  RESP1;          /*!< SDMMC response 1 register,                Address offset: 0x14  */
  __I uint32_t  RESP2;          /*!< SDMMC response 2 register,                Address offset: 0x18  */
  __I uint32_t  RESP3;          /*!< SDMMC response 3 register,                Address offset: 0x1C  */
  __I uint32_t  RESP4;          /*!< SDMMC response 4 register,                Address offset: 0x20  */
  __IO uint32_t DTIMER;         /*!< SDMMC data timer register,                Address offset: 0x24  */
  __IO uint32_t DLEN;           /*!< SDMMC data length register,               Address offset: 0x28  */
  __IO uint32_t DCTRL;          /*!< SDMMC data control register,              Address offset: 0x2C  */
  __I uint32_t  DCOUNT;         /*!< SDMMC data counter register,              Address offset: 0x30  */
  __I uint32_t  STA;            /*!< SDMMC status register,                    Address offset: 0x34  */
  __IO uint32_t ICR;            /*!< SDMMC interrupt clear register,           Address offset: 0x38  */
  __IO uint32_t MASK;           /*!< SDMMC mask register,                      Address offset: 0x3C  */
  __IO uint32_t ACKTIME;        /*!< SDMMC Acknowledgement timer register,     Address offset: 0x40  */
  uint32_t      RESERVED0[3];   /*!< Reserved, 0x44 - 0x4C - 0x4C                                    */
  __IO uint32_t IDMACTRL;       /*!< SDMMC DMA control register,               Address offset: 0x50  */
  __IO uint32_t IDMABSIZE;      /*!< SDMMC DMA buffer size register,           Address offset: 0x54  */
  __IO uint32_t IDMABASER;      /*!< SDMMC DMA buffer base address register,   Address offset: 0x58  */
  uint32_t      RESERVED1[2];   /*!< Reserved, 0x60                                             */
  __IO uint32_t IDMALAR;        /*!< SDMMC DMA linked list address register,   Address offset: 0x64  */
  __IO uint32_t IDMABAR;        /*!< SDMMC DMA linked list memory base register,Address offset: 0x68 */
  uint32_t      RESERVED2[5];   /*!< Reserved, 0x6C-0x7C                                             */
  __IO uint32_t FIFO;           /*!< SDMMC data FIFO register,                 Address offset: 0x80  */
} SDMMC_TypeDef;



/**
  * @brief Delay Block DLYB
  */

typedef struct
{
  __IO uint32_t CR;          /*!< DELAY BLOCK control register,  Address offset: 0x00 */
  __IO uint32_t CFGR;        /*!< DELAY BLOCK configuration register,  Address offset: 0x04 */
} DLYB_TypeDef;

/**
  * @brief UCPD
  */
typedef struct
{
  __IO uint32_t CFG1;         /*!< UCPD configuration register 1,             Address offset: 0x00 */
  __IO uint32_t CFG2;         /*!< UCPD configuration register 2,             Address offset: 0x04 */
  __IO uint32_t CFG3;         /*!< UCPD configuration register 3,             Address offset: 0x08 */
  __IO uint32_t CR;           /*!< UCPD control register,                     Address offset: 0x0C */
  __IO uint32_t IMR;          /*!< UCPD interrupt mask register,              Address offset: 0x10 */
  __IO uint32_t SR;           /*!< UCPD status register,                      Address offset: 0x14 */
  __IO uint32_t ICR;          /*!< UCPD interrupt flag clear register         Address offset: 0x18 */
  __IO uint32_t TX_ORDSET;    /*!< UCPD Tx ordered set type register,         Address offset: 0x1C */
  __IO uint32_t TX_PAYSZ;     /*!< UCPD Tx payload size register,             Address offset: 0x20 */
  __IO uint32_t TXDR;         /*!< UCPD Tx data register,                     Address offset: 0x24 */
  __IO uint32_t RX_ORDSET;    /*!< UCPD Rx ordered set type register,         Address offset: 0x28 */
  __IO uint32_t RX_PAYSZ;     /*!< UCPD Rx payload size register,             Address offset: 0x2C */
  __IO uint32_t RXDR;         /*!< UCPD Rx data register,                     Address offset: 0x30 */
  __IO uint32_t RX_ORDEXT1;   /*!< UCPD Rx ordered set extension 1 register,  Address offset: 0x34 */
  __IO uint32_t RX_ORDEXT2;   /*!< UCPD Rx ordered set extension 2 register,  Address offset: 0x38 */
       uint32_t RESERVED[949];/*!< Reserved,                                  Address offset: 0x3C -- 0x3F0 */
  __IO uint32_t IPVER;        /*!< UCPD IP version register,                  Address offset: 0x3F4 */
  __IO uint32_t IPID;         /*!< UCPD IP Identification register,           Address offset: 0x3F8 */
  __IO uint32_t MID;          /*!< UCPD Magic Identification register,        Address offset: 0x3FC */
} UCPD_TypeDef;

/**
  * @brief Universal Serial Bus Full Speed Dual Role Device
  */
typedef struct
{
  __IO uint32_t CHEP0R;          /*!< USB Channel/Endpoint 0 register,      Address offset: 0x00 */
  __IO uint32_t CHEP1R;          /*!< USB Channel/Endpoint 1 register,      Address offset: 0x04 */
  __IO uint32_t CHEP2R;          /*!< USB Channel/Endpoint 2 register,      Address offset: 0x08 */
  __IO uint32_t CHEP3R;          /*!< USB Channel/Endpoint 3 register,      Address offset: 0x0C */
  __IO uint32_t CHEP4R;          /*!< USB Channel/Endpoint 4 register,      Address offset: 0x10 */
  __IO uint32_t CHEP5R;          /*!< USB Channel/Endpoint 5 register,      Address offset: 0x14 */
  __IO uint32_t CHEP6R;          /*!< USB Channel/Endpoint 6 register,      Address offset: 0x18 */
  __IO uint32_t CHEP7R;          /*!< USB Channel/Endpoint 7 register,      Address offset: 0x1C */
  __IO uint32_t RESERVED0[8];    /*!< Reserved,                                                  */
  __IO uint32_t CNTR;            /*!< Control register,                     Address offset: 0x40 */
  __IO uint32_t ISTR;            /*!< Interrupt status register,            Address offset: 0x44 */
  __IO uint32_t FNR;             /*!< Frame number register,                Address offset: 0x48 */
  __IO uint32_t DADDR;           /*!< Device address register,              Address offset: 0x4C */
  __IO uint32_t RESERVED1;       /*!< Reserved */
  __IO uint32_t LPMCSR;          /*!< LPM Control and Status register,      Address offset: 0x54 */
  __IO uint32_t BCDR;            /*!< Battery Charging detector register,   Address offset: 0x58 */
} USB_DRD_TypeDef;

/**
  * @brief Universal Serial Bus PacketMemoryArea Buffer Descriptor Table
  */
typedef struct
{
  __IO uint32_t TXBD;             /*!<Transmission buffer address*/
  __IO uint32_t RXBD;             /*!<Reception buffer address */
} USB_DRD_PMABuffDescTypeDef;

/**
  * @brief FD Controller Area Network
  */
typedef struct
{
  __IO uint32_t CREL;         /*!< FDCAN Core Release register,                                     Address offset: 0x000 */
  __IO uint32_t ENDN;         /*!< FDCAN Endian register,                                           Address offset: 0x004 */
       uint32_t RESERVED1;    /*!< Reserved,                                                                        0x008 */
  __IO uint32_t DBTP;         /*!< FDCAN Data Bit Timing & Prescaler register,                      Address offset: 0x00C */
  __IO uint32_t TEST;         /*!< FDCAN Test register,                                             Address offset: 0x010 */
  __IO uint32_t RWD;          /*!< FDCAN RAM Watchdog register,                                     Address offset: 0x014 */
  __IO uint32_t CCCR;         /*!< FDCAN CC Control register,                                       Address offset: 0x018 */
  __IO uint32_t NBTP;         /*!< FDCAN Nominal Bit Timing & Prescaler register,                   Address offset: 0x01C */
  __IO uint32_t TSCC;         /*!< FDCAN Timestamp Counter Configuration register,                  Address offset: 0x020 */
  __IO uint32_t TSCV;         /*!< FDCAN Timestamp Counter Value register,                          Address offset: 0x024 */
  __IO uint32_t TOCC;         /*!< FDCAN Timeout Counter Configuration register,                    Address offset: 0x028 */
  __IO uint32_t TOCV;         /*!< FDCAN Timeout Counter Value register,                            Address offset: 0x02C */
       uint32_t RESERVED2[4]; /*!< Reserved,                                                                0x030 - 0x03C */
  __IO uint32_t ECR;          /*!< FDCAN Error Counter register,                                    Address offset: 0x040 */
  __IO uint32_t PSR;          /*!< FDCAN Protocol Status register,                                  Address offset: 0x044 */
  __IO uint32_t TDCR;         /*!< FDCAN Transmitter Delay Compensation register,                   Address offset: 0x048 */
       uint32_t RESERVED3;    /*!< Reserved,                                                                        0x04C */
  __IO uint32_t IR;           /*!< FDCAN Interrupt register,                                        Address offset: 0x050 */
  __IO uint32_t IE;           /*!< FDCAN Interrupt Enable register,                                 Address offset: 0x054 */
  __IO uint32_t ILS;          /*!< FDCAN Interrupt Line Select register,                            Address offset: 0x058 */
  __IO uint32_t ILE;          /*!< FDCAN Interrupt Line Enable register,                            Address offset: 0x05C */
       uint32_t RESERVED4[8]; /*!< Reserved,                                                                0x060 - 0x07C */
  __IO uint32_t RXGFC;        /*!< FDCAN Global Filter Configuration register,                      Address offset: 0x080 */
  __IO uint32_t XIDAM;        /*!< FDCAN Extended ID AND Mask register,                             Address offset: 0x084 */
  __IO uint32_t HPMS;         /*!< FDCAN High Priority Message Status register,                     Address offset: 0x088 */
       uint32_t RESERVED5;    /*!< Reserved,                                                                        0x08C */
  __IO uint32_t RXF0S;        /*!< FDCAN Rx FIFO 0 Status register,                                 Address offset: 0x090 */
  __IO uint32_t RXF0A;        /*!< FDCAN Rx FIFO 0 Acknowledge register,                            Address offset: 0x094 */
  __IO uint32_t RXF1S;        /*!< FDCAN Rx FIFO 1 Status register,                                 Address offset: 0x098 */
  __IO uint32_t RXF1A;        /*!< FDCAN Rx FIFO 1 Acknowledge register,                            Address offset: 0x09C */
       uint32_t RESERVED6[8]; /*!< Reserved,                                                                0x0A0 - 0x0BC */
  __IO uint32_t TXBC;         /*!< FDCAN Tx Buffer Configuration register,                          Address offset: 0x0C0 */
  __IO uint32_t TXFQS;        /*!< FDCAN Tx FIFO/Queue Status register,                             Address offset: 0x0C4 */
  __IO uint32_t TXBRP;        /*!< FDCAN Tx Buffer Request Pending register,                        Address offset: 0x0C8 */
  __IO uint32_t TXBAR;        /*!< FDCAN Tx Buffer Add Request register,                            Address offset: 0x0CC */
  __IO uint32_t TXBCR;        /*!< FDCAN Tx Buffer Cancellation Request register,                   Address offset: 0x0D0 */
  __IO uint32_t TXBTO;        /*!< FDCAN Tx Buffer Transmission Occurred register,                  Address offset: 0x0D4 */
  __IO uint32_t TXBCF;        /*!< FDCAN Tx Buffer Cancellation Finished register,                  Address offset: 0x0D8 */
  __IO uint32_t TXBTIE;       /*!< FDCAN Tx Buffer Transmission Interrupt Enable register,          Address offset: 0x0DC */
  __IO uint32_t TXBCIE;       /*!< FDCAN Tx Buffer Cancellation Finished Interrupt Enable register, Address offset: 0x0E0 */
  __IO uint32_t TXEFS;        /*!< FDCAN Tx Event FIFO Status register,                             Address offset: 0x0E4 */
  __IO uint32_t TXEFA;        /*!< FDCAN Tx Event FIFO Acknowledge register,                        Address offset: 0x0E8 */
} FDCAN_GlobalTypeDef;

/**
  * @brief FD Controller Area Network Configuration
  */
typedef struct
{
  __IO uint32_t CKDIV;        /*!< FDCAN clock divider register,                            Address offset: 0x100 + 0x000 */
       uint32_t RESERVED1[128];/*!< Reserved,                                               0x100 + 0x004 - 0x100 + 0x200 */
  __IO uint32_t OPTR;         /*!< FDCAN option register,                                   Address offset: 0x100 + 0x204 */
       uint32_t RESERVED2[58];/*!< Reserved,                                                0x100 + 0x208 - 0x100 + 0x2EC */
  __IO uint32_t HWCFG;        /*!< FDCAN hardware configuration register,                   Address offset: 0x100 + 0x2F0 */
  __IO uint32_t VERR;         /*!< FDCAN IP version register,                               Address offset: 0x100 + 0x2F4 */
  __IO uint32_t IPIDR;        /*!< FDCAN IP ID register,                                    Address offset: 0x100 + 0x2F8 */
  __IO uint32_t SIDR;         /*!< FDCAN size ID register,                                  Address offset: 0x100 + 0x2FC */
} FDCAN_Config_TypeDef;

/**
  * @brief Consumer Electronics Control
  */
typedef struct
{
  __IO uint32_t CR;           /*!< CEC control register,                                              Address offset:0x00 */
  __IO uint32_t CFGR;         /*!< CEC configuration register,                                        Address offset:0x04 */
  __IO uint32_t TXDR;         /*!< CEC Tx data register ,                                             Address offset:0x08 */
  __IO uint32_t RXDR;         /*!< CEC Rx Data Register,                                              Address offset:0x0C */
  __IO uint32_t ISR;          /*!< CEC Interrupt and Status Register,                                 Address offset:0x10 */
  __IO uint32_t IER;          /*!< CEC interrupt enable register,                                     Address offset:0x14 */
}CEC_TypeDef;

/**
  * @brief Flexible Memory Controller
  */
typedef struct
{
  __IO uint32_t BTCR[8];     /*!< NOR/PSRAM chip-select control register(BCR) and chip-select timing register(BTR), Address offset: 0x00-1C */
  __IO uint32_t PCSCNTR;     /*!< PSRAM chip-select counter register,                                               Address offset:    0x20 */
} FMC_Bank1_TypeDef;

/**
  * @brief Flexible Memory Controller Bank1E
  */
typedef struct
{
  __IO uint32_t BWTR[7];     /*!< NOR/PSRAM write timing registers, Address offset: 0x104-0x11C */
} FMC_Bank1E_TypeDef;

/**
  * @brief Flexible Memory Controller Bank3
  */
typedef struct
{
  __IO uint32_t PCR;        /*!< NAND Flash control register,                       Address offset: 0x80 */
  __IO uint32_t SR;         /*!< NAND Flash FIFO status and interrupt register,     Address offset: 0x84 */
  __IO uint32_t PMEM;       /*!< NAND Flash Common memory space timing register,    Address offset: 0x88 */
  __IO uint32_t PATT;       /*!< NAND Flash Attribute memory space timing register, Address offset: 0x8C */
  uint32_t      RESERVED0;  /*!< Reserved, 0x90                                                          */
  __IO uint32_t ECCR;       /*!< NAND Flash ECC result registers,                   Address offset: 0x94 */
} FMC_Bank3_TypeDef;

/**
  * @brief Flexible Memory Controller Bank5 and 6
  */
typedef struct
{
  __IO uint32_t SDCR[2];     /*!< SDRAM Control registers ,       Address offset: 0x140-0x144  */
  __IO uint32_t SDTR[2];     /*!< SDRAM Timing registers ,        Address offset: 0x148-0x14C  */
  __IO uint32_t SDCMR;       /*!< SDRAM Command Mode register,    Address offset: 0x150        */
  __IO uint32_t SDRTR;       /*!< SDRAM Refresh Timer register,   Address offset: 0x154        */
  __IO uint32_t SDSR;        /*!< SDRAM Status register,          Address offset: 0x158        */
} FMC_Bank5_6_TypeDef;

/**
  * @brief VREFBUF
  */
typedef struct
{
  __IO uint32_t CSR;         /*!< VREFBUF control and status register,         Address offset: 0x00 */
  __IO uint32_t CCR;         /*!< VREFBUF calibration and control register,    Address offset: 0x04 */
} VREFBUF_TypeDef;

/**
  * @brief ADC
  */
typedef struct
{
  __IO uint32_t ISR;          /*!< ADC interrupt and status register,             Address offset: 0x00 */
  __IO uint32_t IER;          /*!< ADC interrupt enable register,                 Address offset: 0x04 */
  __IO uint32_t CR;           /*!< ADC control register,                          Address offset: 0x08 */
  __IO uint32_t CFGR;         /*!< ADC configuration register 1,                  Address offset: 0x0C */
  __IO uint32_t CFGR2;        /*!< ADC configuration register 2,                  Address offset: 0x10 */
  __IO uint32_t SMPR1;        /*!< ADC sampling time register 1,                  Address offset: 0x14 */
  __IO uint32_t SMPR2;        /*!< ADC sampling time register 2,                  Address offset: 0x18 */
       uint32_t RESERVED1;    /*!< Reserved,                                                      0x1C */
  __IO uint32_t TR1;          /*!< ADC analog watchdog 1 threshold register,      Address offset: 0x20 */
  __IO uint32_t TR2;          /*!< ADC analog watchdog 2 threshold register,      Address offset: 0x24 */
  __IO uint32_t TR3;          /*!< ADC analog watchdog 3 threshold register,      Address offset: 0x28 */
       uint32_t RESERVED2;    /*!< Reserved,                                                      0x2C */
  __IO uint32_t SQR1;         /*!< ADC group regular sequencer register 1,        Address offset: 0x30 */
  __IO uint32_t SQR2;         /*!< ADC group regular sequencer register 2,        Address offset: 0x34 */
  __IO uint32_t SQR3;         /*!< ADC group regular sequencer register 3,        Address offset: 0x38 */
  __IO uint32_t SQR4;         /*!< ADC group regular sequencer register 4,        Address offset: 0x3C */
  __IO uint32_t DR;           /*!< ADC group regular data register,               Address offset: 0x40 */
       uint32_t RESERVED3;    /*!< Reserved,                                                      0x44 */
       uint32_t RESERVED4;    /*!< Reserved,                                                      0x48 */
  __IO uint32_t JSQR;         /*!< ADC group injected sequencer register,         Address offset: 0x4C */
       uint32_t RESERVED5[4]; /*!< Reserved,                                               0x50 - 0x5C */
  __IO uint32_t OFR1;         /*!< ADC offset register 1,                         Address offset: 0x60 */
  __IO uint32_t OFR2;         /*!< ADC offset register 2,                         Address offset: 0x64 */
  __IO uint32_t OFR3;         /*!< ADC offset register 3,                         Address offset: 0x68 */
  __IO uint32_t OFR4;         /*!< ADC offset register 4,                         Address offset: 0x6C */
       uint32_t RESERVED6[4]; /*!< Reserved,                                               0x70 - 0x7C */
  __IO uint32_t JDR1;         /*!< ADC group injected rank 1 data register,       Address offset: 0x80 */
  __IO uint32_t JDR2;         /*!< ADC group injected rank 2 data register,       Address offset: 0x84 */
  __IO uint32_t JDR3;         /*!< ADC group injected rank 3 data register,       Address offset: 0x88 */
  __IO uint32_t JDR4;         /*!< ADC group injected rank 4 data register,       Address offset: 0x8C */
       uint32_t RESERVED7[4]; /*!< Reserved,                                             0x090 - 0x09C */
  __IO uint32_t AWD2CR;       /*!< ADC analog watchdog 2 configuration register,  Address offset: 0xA0 */
  __IO uint32_t AWD3CR;       /*!< ADC analog watchdog 3 Configuration Register,  Address offset: 0xA4 */
       uint32_t RESERVED8;    /*!< Reserved,                                                     0x0A8 */
       uint32_t RESERVED9;    /*!< Reserved,                                                     0x0AC */
  __IO uint32_t DIFSEL;       /*!< ADC differential mode selection register,      Address offset: 0xB0 */
  __IO uint32_t CALFACT;      /*!< ADC calibration factors,                       Address offset: 0xB4 */
       uint32_t RESERVED10[4];/*!< Reserved,                                             0x0B8 - 0x0C4 */
  __IO uint32_t OR;           /*!< ADC option register,                           Address offset: 0xC8 */
} ADC_TypeDef;

typedef struct
{
  __IO uint32_t CSR;          /*!< ADC common status register,            Address offset: 0x300 + 0x00 */
  uint32_t      RESERVED1;    /*!< Reserved,                              Address offset: 0x300 + 0x04 */
  __IO uint32_t CCR;          /*!< ADC common configuration register,     Address offset: 0x300 + 0x08 */
  __IO uint32_t CDR;          /*!< ADC common group regular data register Address offset: 0x300 + 0x0C */
} ADC_Common_TypeDef;

/**
  * @brief CORDIC
  */
typedef struct
{
  __IO uint32_t CSR;           /*!< CORDIC control and status register,        Address offset: 0x00 */
  __IO uint32_t WDATA;         /*!< CORDIC argument register,                  Address offset: 0x04 */
  __IO uint32_t RDATA;         /*!< CORDIC result register,                    Address offset: 0x08 */
} CORDIC_TypeDef;

/**
  * @brief IWDG
  */
typedef struct
{
  __IO uint32_t KR;            /*!< IWDG Key register,          Address offset: 0x00 */
  __IO uint32_t PR;            /*!< IWDG Prescaler register,    Address offset: 0x04 */
  __IO uint32_t RLR;           /*!< IWDG Reload register,       Address offset: 0x08 */
  __IO uint32_t SR;            /*!< IWDG Status register,       Address offset: 0x0C */
  __IO uint32_t WINR;          /*!< IWDG Window register,       Address offset: 0x10 */
  __IO uint32_t EWCR;          /*!< IWDG Early Wakeup register, Address offset: 0x14 */
} IWDG_TypeDef;

/**
  * @brief SPI
  */
typedef struct
{
  __IO uint32_t CR1;           /*!< SPI/I2S Control register 1,                      Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< SPI Control register 2,                          Address offset: 0x04 */
  __IO uint32_t CFG1;          /*!< SPI Configuration register 1,                    Address offset: 0x08 */
  __IO uint32_t CFG2;          /*!< SPI Configuration register 2,                    Address offset: 0x0C */
  __IO uint32_t IER;           /*!< SPI/I2S Interrupt Enable register,               Address offset: 0x10 */
  __IO uint32_t SR;            /*!< SPI/I2S Status register,                         Address offset: 0x14 */
  __IO uint32_t IFCR;          /*!< SPI/I2S Interrupt/Status flags clear register,   Address offset: 0x18 */
  uint32_t      RESERVED0;     /*!< Reserved, 0x1C                                                        */
  __IO uint32_t TXDR;          /*!< SPI/I2S Transmit data register,                  Address offset: 0x20 */
  uint32_t      RESERVED1[3];  /*!< Reserved, 0x24-0x2C                                                   */
  __IO uint32_t RXDR;          /*!< SPI/I2S Receive data register,                   Address offset: 0x30 */
  uint32_t      RESERVED2[3];  /*!< Reserved, 0x34-0x3C                                                   */
  __IO uint32_t CRCPOLY;       /*!< SPI CRC Polynomial register,                     Address offset: 0x40 */
  __IO uint32_t TXCRC;         /*!< SPI Transmitter CRC register,                    Address offset: 0x44 */
  __IO uint32_t RXCRC;         /*!< SPI Receiver CRC register,                       Address offset: 0x48 */
  __IO uint32_t UDRDR;         /*!< SPI Underrun data register,                      Address offset: 0x4C */
  __IO uint32_t I2SCFGR;       /*!< I2S Configuration register,                      Address offset: 0x50 */
} SPI_TypeDef;

/**
  * @brief DTS
  */
typedef struct
{
  __IO uint32_t CFGR1;         /*!< DTS configuration register,                Address offset: 0x00 */
  uint32_t RESERVED0;          /*!< Reserved,                                  Address offset: 0x04 */
  __IO uint32_t T0VALR1;       /*!< DTS T0 Value register,                     Address offset: 0x08 */
  uint32_t RESERVED1;          /*!< Reserved,                                  Address offset: 0x0C */
  __IO uint32_t RAMPVALR;      /*!< DTS Ramp value register,                   Address offset: 0x10 */
  __IO uint32_t ITR1;          /*!< DTS Interrupt threshold register,          Address offset: 0x14 */
  uint32_t RESERVED2;          /*!< Reserved,                                  Address offset: 0x18 */
  __IO uint32_t DR;            /*!< DTS data register,                         Address offset: 0x1C */
  __IO uint32_t SR;            /*!< DTS status register                        Address offset: 0x20 */
  __IO uint32_t ITENR;         /*!< DTS Interrupt enable register,             Address offset: 0x24 */
  __IO uint32_t ICIFR;         /*!< DTS Clear Interrupt flag register,         Address offset: 0x28 */
  __IO uint32_t OR;            /*!< DTS option register 1,                     Address offset: 0x2C */
}
DTS_TypeDef;

/**
  * @brief WWDG
  */
typedef struct
{
  __IO uint32_t CR;          /*!< WWDG Control register,       Address offset: 0x00 */
  __IO uint32_t CFR;         /*!< WWDG Configuration register, Address offset: 0x04 */
  __IO uint32_t SR;          /*!< WWDG Status register,        Address offset: 0x08 */
} WWDG_TypeDef;

/*@}*/ /* end of group STM32H563xx_Peripherals */


/* --------  End of section using anonymous unions and disabling warnings  -------- */
#if   defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32H5xx_Peripheral_peripheralAddr
  * @{
  */

/* Internal SRAMs size */
#define SRAM1_SIZE               (0x40000UL)    /*!< SRAM1=256k */
#define SRAM2_SIZE               (0x10000UL)    /*!< SRAM2=64k  */
#define SRAM3_SIZE               (0x50000UL)    /*!< SRAM3=320k */
#define BKPSRAM_SIZE             (0x01000UL)    /*!< BKPSRAM=4k */

/* Flash, Peripheral and internal SRAMs base addresses - Non secure */
#define FLASH_BASE_NS            (0x08000000UL) /*!< FLASH (up to 2 MB) non-secure base address         */
#define SRAM1_BASE_NS            (0x20000000UL) /*!< SRAM1 (256 KB) non-secure base address             */
#define SRAM2_BASE_NS            (0x20040000UL) /*!< SRAM2 (64 KB) non-secure base address              */
#define SRAM3_BASE_NS            (0x20050000UL) /*!< SRAM3 (320 KB) non-secure base address             */
#define PERIPH_BASE_NS           (0x40000000UL) /*!< Peripheral non-secure base address                 */

/* External memories base addresses - Not aliased */
#define FMC_BASE                 (0x60000000UL) /*!< FMC base address                                   */
#define OCTOSPI1_BASE            (0x90000000UL) /*!< OCTOSPI1 memories accessible over AHB base address */

#define FMC_BANK1                FMC_BASE
#define FMC_BANK1_1              FMC_BANK1
#define FMC_BANK1_2              (FMC_BANK1 + 0x04000000UL)  /*!< FMC Memory Bank1 for SRAM, NOR and PSRAM */
#define FMC_BANK1_3              (FMC_BANK1 + 0x08000000UL)
#define FMC_BANK1_4              (FMC_BANK1 + 0x0C000000UL)
#define FMC_BANK3                (FMC_BASE  + 0x20000000UL)  /*!< FMC Memory Bank3 for NAND */
#define FMC_SDRAM_BANK_1         (FMC_BASE +  0x60000000UL)  /*!< FMC Memory SDRAM Bank1 */
#define FMC_SDRAM_BANK_2         (FMC_BASE +  0x70000000UL)  /*!< FMC Memory SDRAM Bank2 */


/* Peripheral memory map - Non secure */
#define APB1PERIPH_BASE_NS       PERIPH_BASE_NS
#define APB2PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x00010000UL)
#define AHB1PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x00020000UL)
#define AHB2PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x02020000UL)
#define APB3PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x04000000UL)
#define AHB3PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x04020000UL)
#define AHB4PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x06000000UL)

/*!< APB1 Non secure peripherals */
#define TIM2_BASE_NS             (APB1PERIPH_BASE_NS + 0x0000UL)
#define TIM3_BASE_NS             (APB1PERIPH_BASE_NS + 0x0400UL)
#define TIM4_BASE_NS             (APB1PERIPH_BASE_NS + 0x0800UL)
#define TIM5_BASE_NS             (APB1PERIPH_BASE_NS + 0x0C00UL)
#define TIM6_BASE_NS             (APB1PERIPH_BASE_NS + 0x1000UL)
#define TIM7_BASE_NS             (APB1PERIPH_BASE_NS + 0x1400UL)
#define TIM12_BASE_NS            (APB1PERIPH_BASE_NS + 0x1800UL)
#define TIM13_BASE_NS            (APB1PERIPH_BASE_NS + 0x1C00UL)
#define TIM14_BASE_NS            (APB1PERIPH_BASE_NS + 0x2000UL)
#define WWDG_BASE_NS             (APB1PERIPH_BASE_NS + 0x2C00UL)
#define IWDG_BASE_NS             (APB1PERIPH_BASE_NS + 0x3000UL)
#define SPI2_BASE_NS             (APB1PERIPH_BASE_NS + 0x3800UL)
#define SPI3_BASE_NS             (APB1PERIPH_BASE_NS + 0x3C00UL)
#define USART2_BASE_NS           (APB1PERIPH_BASE_NS + 0x4400UL)
#define USART3_BASE_NS           (APB1PERIPH_BASE_NS + 0x4800UL)
#define UART4_BASE_NS            (APB1PERIPH_BASE_NS + 0x4C00UL)
#define UART5_BASE_NS            (APB1PERIPH_BASE_NS + 0x5000UL)
#define I2C1_BASE_NS             (APB1PERIPH_BASE_NS + 0x5400UL)
#define I2C2_BASE_NS             (APB1PERIPH_BASE_NS + 0x5800UL)
#define I3C1_BASE_NS             (APB1PERIPH_BASE_NS + 0x5C00UL)
#define CRS_BASE_NS              (APB1PERIPH_BASE_NS + 0x6000UL)
#define USART6_BASE_NS           (APB1PERIPH_BASE_NS + 0x6400UL)
#define USART10_BASE_NS          (APB1PERIPH_BASE_NS + 0x6800UL)
#define USART11_BASE_NS          (APB1PERIPH_BASE_NS + 0x6C00UL)
#define CEC_BASE_NS              (APB1PERIPH_BASE_NS + 0x7000UL)
#define UART7_BASE_NS            (APB1PERIPH_BASE_NS + 0x7800UL)
#define UART8_BASE_NS            (APB1PERIPH_BASE_NS + 0x7C00UL)
#define UART9_BASE_NS            (APB1PERIPH_BASE_NS + 0x8000UL)
#define UART12_BASE_NS           (APB1PERIPH_BASE_NS + 0x8400UL)
#define DTS_BASE_NS              (APB1PERIPH_BASE_NS + 0x8C00UL)
#define LPTIM2_BASE_NS           (APB1PERIPH_BASE_NS + 0x9400UL)
#define FDCAN1_BASE_NS           (APB1PERIPH_BASE_NS + 0xA400UL)
#define FDCAN_CONFIG_BASE_NS     (APB1PERIPH_BASE_NS + 0xA500UL)
#define SRAMCAN_BASE_NS          (APB1PERIPH_BASE_NS + 0xAC00UL)
#define FDCAN2_BASE_NS           (APB1PERIPH_BASE_NS + 0xA800UL)
#define UCPD1_BASE_NS            (APB1PERIPH_BASE_NS + 0xDC00UL)

/*!< APB2 Non secure peripherals */
#define TIM1_BASE_NS             (APB2PERIPH_BASE_NS + 0x2C00UL)
#define SPI1_BASE_NS             (APB2PERIPH_BASE_NS + 0x3000UL)
#define TIM8_BASE_NS             (APB2PERIPH_BASE_NS + 0x3400UL)
#define USART1_BASE_NS           (APB2PERIPH_BASE_NS + 0x3800UL)
#define TIM15_BASE_NS            (APB2PERIPH_BASE_NS + 0x4000UL)
#define TIM16_BASE_NS            (APB2PERIPH_BASE_NS + 0x4400UL)
#define TIM17_BASE_NS            (APB2PERIPH_BASE_NS + 0x4800UL)
#define SPI4_BASE_NS             (APB2PERIPH_BASE_NS + 0x4C00UL)
#define SPI6_BASE_NS             (APB2PERIPH_BASE_NS + 0x5000UL)
#define SAI1_BASE_NS             (APB2PERIPH_BASE_NS + 0x5400UL)
#define SAI1_Block_A_BASE_NS     (SAI1_BASE_NS + 0x004UL)
#define SAI1_Block_B_BASE_NS     (SAI1_BASE_NS + 0x024UL)
#define SAI2_BASE_NS             (APB2PERIPH_BASE_NS + 0x5800UL)
#define SAI2_Block_A_BASE_NS     (SAI2_BASE_NS + 0x004UL)
#define SAI2_Block_B_BASE_NS     (SAI2_BASE_NS + 0x024UL)
#define USB_DRD_BASE_NS          (APB2PERIPH_BASE_NS + 0x6000UL)
#define USB_DRD_PMAADDR_NS       (APB2PERIPH_BASE_NS + 0x6400UL)

/*!< AHB1 Non secure peripherals */
#define GPDMA1_BASE_NS           AHB1PERIPH_BASE_NS
#define GPDMA2_BASE_NS           (AHB1PERIPH_BASE_NS + 0x01000UL)
#define FLASH_R_BASE_NS          (AHB1PERIPH_BASE_NS + 0x02000UL)
#define CRC_BASE_NS              (AHB1PERIPH_BASE_NS + 0x03000UL)
#define CORDIC_BASE_NS           (AHB1PERIPH_BASE_NS + 0x03800UL)
#define FMAC_BASE_NS             (AHB1PERIPH_BASE_NS + 0x03C00UL)
#define RAMCFG_BASE_NS           (AHB1PERIPH_BASE_NS + 0x06000UL)
#define ETH_BASE_NS              (AHB1PERIPH_BASE_NS + 0x8000UL)
#define ETH_MAC_BASE_NS          (ETH_BASE)
#define ICACHE_BASE_NS           (AHB1PERIPH_BASE_NS + 0x10400UL)
#define DCACHE1_BASE_NS          (AHB1PERIPH_BASE_NS + 0x11400UL)
#define GTZC_TZSC1_BASE_NS       (AHB1PERIPH_BASE_NS + 0x12400UL)
#define GTZC_TZIC1_BASE_NS       (AHB1PERIPH_BASE_NS + 0x12800UL)
#define GTZC_MPCBB1_BASE_NS      (AHB1PERIPH_BASE_NS + 0x12C00UL)
#define GTZC_MPCBB2_BASE_NS      (AHB1PERIPH_BASE_NS + 0x13000UL)
#define GTZC_MPCBB3_BASE_NS      (AHB1PERIPH_BASE_NS + 0x13400UL)
#define BKPSRAM_BASE_NS          (AHB1PERIPH_BASE_NS + 0x16400UL)

#define GPDMA1_Channel0_BASE_NS   (GPDMA1_BASE_NS + 0x0050UL)
#define GPDMA1_Channel1_BASE_NS   (GPDMA1_BASE_NS + 0x00D0UL)
#define GPDMA1_Channel2_BASE_NS   (GPDMA1_BASE_NS + 0x0150UL)
#define GPDMA1_Channel3_BASE_NS   (GPDMA1_BASE_NS + 0x01D0UL)
#define GPDMA1_Channel4_BASE_NS   (GPDMA1_BASE_NS + 0x0250UL)
#define GPDMA1_Channel5_BASE_NS   (GPDMA1_BASE_NS + 0x02D0UL)
#define GPDMA1_Channel6_BASE_NS   (GPDMA1_BASE_NS + 0x0350UL)
#define GPDMA1_Channel7_BASE_NS   (GPDMA1_BASE_NS + 0x03D0UL)
#define GPDMA2_Channel0_BASE_NS   (GPDMA2_BASE_NS + 0x0050UL)
#define GPDMA2_Channel1_BASE_NS   (GPDMA2_BASE_NS + 0x00D0UL)
#define GPDMA2_Channel2_BASE_NS   (GPDMA2_BASE_NS + 0x0150UL)
#define GPDMA2_Channel3_BASE_NS   (GPDMA2_BASE_NS + 0x01D0UL)
#define GPDMA2_Channel4_BASE_NS   (GPDMA2_BASE_NS + 0x0250UL)
#define GPDMA2_Channel5_BASE_NS   (GPDMA2_BASE_NS + 0x02D0UL)
#define GPDMA2_Channel6_BASE_NS   (GPDMA2_BASE_NS + 0x0350UL)
#define GPDMA2_Channel7_BASE_NS   (GPDMA2_BASE_NS + 0x03D0UL)

#define RAMCFG_SRAM1_BASE_NS     (RAMCFG_BASE_NS)
#define RAMCFG_SRAM2_BASE_NS     (RAMCFG_BASE_NS + 0x0040UL)
#define RAMCFG_SRAM3_BASE_NS     (RAMCFG_BASE_NS + 0x0080UL)
#define RAMCFG_BKPRAM_BASE_NS    (RAMCFG_BASE_NS + 0x0100UL)

/*!< AHB2 Non secure peripherals */
#define GPIOA_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00000UL)
#define GPIOB_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00400UL)
#define GPIOC_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00800UL)
#define GPIOD_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00C00UL)
#define GPIOE_BASE_NS            (AHB2PERIPH_BASE_NS + 0x01000UL)
#define GPIOF_BASE_NS            (AHB2PERIPH_BASE_NS + 0x01400UL)
#define GPIOG_BASE_NS            (AHB2PERIPH_BASE_NS + 0x01800UL)
#define GPIOH_BASE_NS            (AHB2PERIPH_BASE_NS + 0x01C00UL)
#define GPIOI_BASE_NS            (AHB2PERIPH_BASE_NS + 0x02000UL)
#define ADC1_BASE_NS             (AHB2PERIPH_BASE_NS + 0x08000UL)
#define ADC2_BASE_NS             (AHB2PERIPH_BASE_NS + 0x08100UL)
#define ADC12_COMMON_BASE_NS     (AHB2PERIPH_BASE_NS + 0x08300UL)
#define DAC1_BASE_NS             (AHB2PERIPH_BASE_NS + 0x08400UL)
#define DCMI_BASE_NS             (AHB2PERIPH_BASE_NS + 0x0C000UL)
#define PSSI_BASE_NS             (AHB2PERIPH_BASE_NS + 0x0C400UL)
#define HASH_BASE_NS             (AHB2PERIPH_BASE_NS + 0xA0400UL)
#define HASH_DIGEST_BASE_NS      (AHB2PERIPH_BASE_NS + 0xA0710UL)
#define RNG_BASE_NS              (AHB2PERIPH_BASE_NS + 0xA0800UL)
#define PKA_BASE_NS              (AHB2PERIPH_BASE_NS + 0xA2000UL)
#define PKA_RAM_BASE_NS          (AHB2PERIPH_BASE_NS + 0xA2400UL)

/*!< APB3 Non secure peripherals */
#define SBS_BASE_NS              (APB3PERIPH_BASE_NS + 0x0400UL)
#define SPI5_BASE_NS             (APB3PERIPH_BASE_NS + 0x2000UL)
#define LPUART1_BASE_NS          (APB3PERIPH_BASE_NS + 0x2400UL)
#define I2C3_BASE_NS             (APB3PERIPH_BASE_NS + 0x2800UL)
#define I2C4_BASE_NS             (APB3PERIPH_BASE_NS + 0x2C00UL)
#define LPTIM1_BASE_NS           (APB3PERIPH_BASE_NS + 0x4400UL)
#define LPTIM3_BASE_NS           (APB3PERIPH_BASE_NS + 0x4800UL)
#define LPTIM4_BASE_NS           (APB3PERIPH_BASE_NS + 0x4C00UL)
#define LPTIM5_BASE_NS           (APB3PERIPH_BASE_NS + 0x5000UL)
#define LPTIM6_BASE_NS           (APB3PERIPH_BASE_NS + 0x5400UL)
#define VREFBUF_BASE_NS          (APB3PERIPH_BASE_NS + 0x7400UL)
#define RTC_BASE_NS              (APB3PERIPH_BASE_NS + 0x7800UL)
#define TAMP_BASE_NS             (APB3PERIPH_BASE_NS + 0x7C00UL)

/*!< AHB3 Non secure peripherals */
#define PWR_BASE_NS              (AHB3PERIPH_BASE_NS + 0x0800UL)
#define RCC_BASE_NS              (AHB3PERIPH_BASE_NS + 0x0C00UL)
#define EXTI_BASE_NS             (AHB3PERIPH_BASE_NS + 0x2000UL)
#define DEBUG_BASE_NS            (AHB3PERIPH_BASE_NS + 0x4000UL)

/*!< AHB4 Non secure peripherals */
#define SDMMC1_BASE_NS           (AHB4PERIPH_BASE_NS + 0x8000UL)
#define DLYB_SDMMC1_BASE_NS      (AHB4PERIPH_BASE_NS + 0x8400UL)
#define SDMMC2_BASE_NS           (AHB4PERIPH_BASE_NS + 0x8C00UL)
#define DLYB_SDMMC2_BASE_NS      (AHB4PERIPH_BASE_NS + 0x8800UL)
#define FMC_R_BASE_NS            (AHB4PERIPH_BASE_NS + 0x1000400UL) /*!< FMC control registers base address              */
#define OCTOSPI1_R_BASE_NS       (AHB4PERIPH_BASE_NS + 0x1001400UL) /*!< OCTOSPI1 control registers base address         */
#define DLYB_OCTOSPI1_BASE_NS    (AHB4PERIPH_BASE_NS + 0x0F000UL)

/*!< FMC Banks Non secure registers base address */
#define FMC_Bank1_R_BASE_NS      (FMC_R_BASE_NS + 0x0000UL)
#define FMC_Bank1E_R_BASE_NS     (FMC_R_BASE_NS + 0x0104UL)
#define FMC_Bank3_R_BASE_NS      (FMC_R_BASE_NS + 0x0080UL)
#define FMC_Bank5_6_R_BASE_NS    (FMC_R_BASE_NS + 0x0140UL)

/* Flash, Peripheral and internal SRAMs base addresses - Secure */
#define FLASH_BASE_S            (0x0C000000UL) /*!< FLASH (up to 2 MB) secure base address */
#define SRAM1_BASE_S            (0x30000000UL) /*!< SRAM1 (256 KB) secure base address     */
#define SRAM2_BASE_S            (0x30040000UL) /*!< SRAM2 (64 KB) secure base address      */
#define SRAM3_BASE_S            (0x30050000UL) /*!< SRAM3 (320 KB) secure base address     */
#define PERIPH_BASE_S           (0x50000000UL) /*!< Peripheral secure base address         */

/* Peripheral memory map - Secure */
#define APB1PERIPH_BASE_S       PERIPH_BASE_S
#define APB2PERIPH_BASE_S       (PERIPH_BASE_S + 0x00010000UL)
#define AHB1PERIPH_BASE_S       (PERIPH_BASE_S + 0x00020000UL)
#define AHB2PERIPH_BASE_S       (PERIPH_BASE_S + 0x02020000UL)
#define APB3PERIPH_BASE_S       (PERIPH_BASE_S + 0x04000000UL)
#define AHB3PERIPH_BASE_S       (PERIPH_BASE_S + 0x04020000UL)
#define AHB4PERIPH_BASE_S       (PERIPH_BASE_S + 0x06000000UL)

/*!< APB1 secure peripherals */
#define TIM2_BASE_S             (APB1PERIPH_BASE_S + 0x0000UL)
#define TIM3_BASE_S             (APB1PERIPH_BASE_S + 0x0400UL)
#define TIM4_BASE_S             (APB1PERIPH_BASE_S + 0x0800UL)
#define TIM5_BASE_S             (APB1PERIPH_BASE_S + 0x0C00UL)
#define TIM6_BASE_S             (APB1PERIPH_BASE_S + 0x1000UL)
#define TIM7_BASE_S             (APB1PERIPH_BASE_S + 0x1400UL)
#define TIM12_BASE_S            (APB1PERIPH_BASE_S + 0x1800UL)
#define TIM13_BASE_S            (APB1PERIPH_BASE_S + 0x1C00UL)
#define TIM14_BASE_S            (APB1PERIPH_BASE_S + 0x2000UL)
#define WWDG_BASE_S             (APB1PERIPH_BASE_S + 0x2C00UL)
#define IWDG_BASE_S             (APB1PERIPH_BASE_S + 0x3000UL)
#define SPI2_BASE_S             (APB1PERIPH_BASE_S + 0x3800UL)
#define SPI3_BASE_S             (APB1PERIPH_BASE_S + 0x3C00UL)
#define USART2_BASE_S           (APB1PERIPH_BASE_S + 0x4400UL)
#define USART3_BASE_S           (APB1PERIPH_BASE_S + 0x4800UL)
#define UART4_BASE_S            (APB1PERIPH_BASE_S + 0x4C00UL)
#define UART5_BASE_S            (APB1PERIPH_BASE_S + 0x5000UL)
#define I2C1_BASE_S             (APB1PERIPH_BASE_S + 0x5400UL)
#define I2C2_BASE_S             (APB1PERIPH_BASE_S + 0x5800UL)
#define I3C1_BASE_S             (APB1PERIPH_BASE_S + 0x5C00UL)
#define CRS_BASE_S              (APB1PERIPH_BASE_S + 0x6000UL)
#define USART6_BASE_S           (APB1PERIPH_BASE_S + 0x6400UL)
#define USART10_BASE_S          (APB1PERIPH_BASE_S + 0x6800UL)
#define USART11_BASE_S          (APB1PERIPH_BASE_S + 0x6C00UL)
#define CEC_BASE_S              (APB1PERIPH_BASE_S + 0x7000UL)
#define UART7_BASE_S            (APB1PERIPH_BASE_S + 0x7800UL)
#define UART8_BASE_S            (APB1PERIPH_BASE_S + 0x7C00UL)
#define UART9_BASE_S            (APB1PERIPH_BASE_S + 0x8000UL)
#define UART12_BASE_S           (APB1PERIPH_BASE_S + 0x8400UL)
#define DTS_BASE_S              (APB1PERIPH_BASE_S + 0x8C00UL)
#define LPTIM2_BASE_S           (APB1PERIPH_BASE_S + 0x9400UL)
#define FDCAN1_BASE_S           (APB1PERIPH_BASE_S + 0xA400UL)
#define FDCAN_CONFIG_BASE_S     (APB1PERIPH_BASE_S + 0xA500UL)
#define SRAMCAN_BASE_S          (APB1PERIPH_BASE_S + 0xAC00UL)
#define FDCAN2_BASE_S           (APB1PERIPH_BASE_S + 0xA800UL)
#define UCPD1_BASE_S            (APB1PERIPH_BASE_S + 0xDC00UL)

/*!< APB2 Secure peripherals */
#define TIM1_BASE_S             (APB2PERIPH_BASE_S + 0x2C00UL)
#define SPI1_BASE_S             (APB2PERIPH_BASE_S + 0x3000UL)
#define TIM8_BASE_S             (APB2PERIPH_BASE_S + 0x3400UL)
#define USART1_BASE_S           (APB2PERIPH_BASE_S + 0x3800UL)
#define TIM15_BASE_S            (APB2PERIPH_BASE_S + 0x4000UL)
#define TIM16_BASE_S            (APB2PERIPH_BASE_S + 0x4400UL)
#define TIM17_BASE_S            (APB2PERIPH_BASE_S + 0x4800UL)
#define SPI4_BASE_S             (APB2PERIPH_BASE_S + 0x4C00UL)
#define SPI6_BASE_S             (APB2PERIPH_BASE_S + 0x5000UL)
#define SAI1_BASE_S             (APB2PERIPH_BASE_S + 0x5400UL)
#define SAI1_Block_A_BASE_S     (SAI1_BASE_S + 0x004UL)
#define SAI1_Block_B_BASE_S     (SAI1_BASE_S + 0x024UL)
#define SAI2_BASE_S             (APB2PERIPH_BASE_S + 0x5800UL)
#define SAI2_Block_A_BASE_S     (SAI2_BASE_S + 0x004UL)
#define SAI2_Block_B_BASE_S     (SAI2_BASE_S + 0x024UL)
#define USB_DRD_BASE_S          (APB2PERIPH_BASE_S + 0x6000UL)
#define USB_DRD_PMAADDR_S       (APB2PERIPH_BASE_S + 0x6400UL)

/*!< AHB1 secure peripherals */
#define GPDMA1_BASE_S           AHB1PERIPH_BASE_S
#define GPDMA2_BASE_S           (AHB1PERIPH_BASE_S + 0x01000UL)
#define FLASH_R_BASE_S          (AHB1PERIPH_BASE_S + 0x02000UL)
#define CRC_BASE_S              (AHB1PERIPH_BASE_S + 0x03000UL)
#define CORDIC_BASE_S           (AHB1PERIPH_BASE_S + 0x03800UL)
#define FMAC_BASE_S             (AHB1PERIPH_BASE_S + 0x03C00UL)
#define RAMCFG_BASE_S           (AHB1PERIPH_BASE_S + 0x06000UL)
#define ETH_BASE_S              (AHB1PERIPH_BASE_S + 0x8000UL)
#define ETH_MAC_BASE_S          (ETH_BASE_S)
#define ICACHE_BASE_S           (AHB1PERIPH_BASE_S + 0x10400UL)
#define DCACHE1_BASE_S          (AHB1PERIPH_BASE_S + 0x11400UL)
#define GTZC_TZSC1_BASE_S       (AHB1PERIPH_BASE_S + 0x12400UL)
#define GTZC_TZIC1_BASE_S       (AHB1PERIPH_BASE_S + 0x12800UL)
#define GTZC_MPCBB1_BASE_S      (AHB1PERIPH_BASE_S + 0x12C00UL)
#define GTZC_MPCBB2_BASE_S      (AHB1PERIPH_BASE_S + 0x13000UL)
#define GTZC_MPCBB3_BASE_S      (AHB1PERIPH_BASE_S + 0x13400UL)
#define BKPSRAM_BASE_S          (AHB1PERIPH_BASE_S + 0x16400UL)
#define GPDMA1_Channel0_BASE_S   (GPDMA1_BASE_S + 0x0050UL)
#define GPDMA1_Channel1_BASE_S   (GPDMA1_BASE_S + 0x00D0UL)
#define GPDMA1_Channel2_BASE_S   (GPDMA1_BASE_S + 0x0150UL)
#define GPDMA1_Channel3_BASE_S   (GPDMA1_BASE_S + 0x01D0UL)
#define GPDMA1_Channel4_BASE_S   (GPDMA1_BASE_S + 0x0250UL)
#define GPDMA1_Channel5_BASE_S   (GPDMA1_BASE_S + 0x02D0UL)
#define GPDMA1_Channel6_BASE_S   (GPDMA1_BASE_S + 0x0350UL)
#define GPDMA1_Channel7_BASE_S   (GPDMA1_BASE_S + 0x03D0UL)
#define GPDMA2_Channel0_BASE_S   (GPDMA2_BASE_S + 0x0050UL)
#define GPDMA2_Channel1_BASE_S   (GPDMA2_BASE_S + 0x00D0UL)
#define GPDMA2_Channel2_BASE_S   (GPDMA2_BASE_S + 0x0150UL)
#define GPDMA2_Channel3_BASE_S   (GPDMA2_BASE_S + 0x01D0UL)
#define GPDMA2_Channel4_BASE_S   (GPDMA2_BASE_S + 0x0250UL)
#define GPDMA2_Channel5_BASE_S   (GPDMA2_BASE_S + 0x02D0UL)
#define GPDMA2_Channel6_BASE_S   (GPDMA2_BASE_S + 0x0350UL)
#define GPDMA2_Channel7_BASE_S   (GPDMA2_BASE_S + 0x03D0UL)
#define RAMCFG_SRAM1_BASE_S     (RAMCFG_BASE_S)
#define RAMCFG_SRAM2_BASE_S     (RAMCFG_BASE_S + 0x0040UL)
#define RAMCFG_SRAM3_BASE_S     (RAMCFG_BASE_S + 0x0080UL)
#define RAMCFG_BKPRAM_BASE_S    (RAMCFG_BASE_S + 0x0100UL)

/*!< AHB2 secure peripherals */
#define GPIOA_BASE_S            (AHB2PERIPH_BASE_S + 0x00000UL)
#define GPIOB_BASE_S            (AHB2PERIPH_BASE_S + 0x00400UL)
#define GPIOC_BASE_S            (AHB2PERIPH_BASE_S + 0x00800UL)
#define GPIOD_BASE_S            (AHB2PERIPH_BASE_S + 0x00C00UL)
#define GPIOE_BASE_S            (AHB2PERIPH_BASE_S + 0x01000UL)
#define GPIOF_BASE_S            (AHB2PERIPH_BASE_S + 0x01400UL)
#define GPIOG_BASE_S            (AHB2PERIPH_BASE_S + 0x01800UL)
#define GPIOH_BASE_S            (AHB2PERIPH_BASE_S + 0x01C00UL)
#define GPIOI_BASE_S            (AHB2PERIPH_BASE_S + 0x02000UL)
#define ADC1_BASE_S             (AHB2PERIPH_BASE_S + 0x08000UL)
#define ADC2_BASE_S             (AHB2PERIPH_BASE_S + 0x08100UL)
#define ADC12_COMMON_BASE_S     (AHB2PERIPH_BASE_S + 0x08300UL)
#define DAC1_BASE_S             (AHB2PERIPH_BASE_S + 0x08400UL)
#define DCMI_BASE_S             (AHB2PERIPH_BASE_S + 0x0C000UL)
#define PSSI_BASE_S             (AHB2PERIPH_BASE_S + 0x0C400UL)
#define HASH_BASE_S             (AHB2PERIPH_BASE_S + 0xA0400UL)
#define HASH_DIGEST_BASE_S      (AHB2PERIPH_BASE_S + 0xA0710UL)
#define RNG_BASE_S              (AHB2PERIPH_BASE_S + 0xA0800UL)
#define PKA_BASE_S              (AHB2PERIPH_BASE_S + 0xA2000UL)
#define PKA_RAM_BASE_S          (AHB2PERIPH_BASE_S + 0xA2400UL)

/*!< APB3 secure peripherals */
#define SBS_BASE_S              (APB3PERIPH_BASE_S + 0x0400UL)
#define SPI5_BASE_S             (APB3PERIPH_BASE_S + 0x2000UL)
#define LPUART1_BASE_S          (APB3PERIPH_BASE_S + 0x2400UL)
#define I2C3_BASE_S             (APB3PERIPH_BASE_S + 0x2800UL)
#define I2C4_BASE_S             (APB3PERIPH_BASE_S + 0x2C00UL)
#define LPTIM1_BASE_S           (APB3PERIPH_BASE_S + 0x4400UL)
#define LPTIM3_BASE_S           (APB3PERIPH_BASE_S + 0x4800UL)
#define LPTIM4_BASE_S           (APB3PERIPH_BASE_S + 0x4C00UL)
#define LPTIM5_BASE_S           (APB3PERIPH_BASE_S + 0x5000UL)
#define LPTIM6_BASE_S           (APB3PERIPH_BASE_S + 0x5400UL)
#define VREFBUF_BASE_S          (APB3PERIPH_BASE_S + 0x7400UL)
#define RTC_BASE_S              (APB3PERIPH_BASE_S + 0x7800UL)
#define TAMP_BASE_S             (APB3PERIPH_BASE_S + 0x7C00UL)

/*!< AHB3 secure peripherals */
#define PWR_BASE_S              (AHB3PERIPH_BASE_S + 0x0800UL)
#define RCC_BASE_S              (AHB3PERIPH_BASE_S + 0x0C00UL)
#define EXTI_BASE_S             (AHB3PERIPH_BASE_S + 0x2000UL)
#define DEBUG_BASE_S            (AHB3PERIPH_BASE_S + 0x4000UL)

/*!< AHB4 secure peripherals */
#define SDMMC1_BASE_S           (AHB4PERIPH_BASE_S + 0x8000UL)
#define DLYB_SDMMC1_BASE_S      (AHB4PERIPH_BASE_S + 0x8400UL)
#define SDMMC2_BASE_S           (AHB4PERIPH_BASE_S + 0x8C00UL)
#define DLYB_SDMMC2_BASE_S      (AHB4PERIPH_BASE_S + 0x8800UL)
#define FMC_R_BASE_S            (AHB4PERIPH_BASE_S + 0x1000400UL) /*!< FMC control registers base address              */
#define OCTOSPI1_R_BASE_S       (AHB4PERIPH_BASE_S + 0x1001400UL) /*!< OCTOSPI1 control registers base address         */
#define DLYB_OCTOSPI1_BASE_S    (AHB4PERIPH_BASE_S + 0x0F000UL)

/*!< FMC Banks Non secure registers base address */
#define FMC_Bank1_R_BASE_S      (FMC_R_BASE_S + 0x0000UL)
#define FMC_Bank1E_R_BASE_S     (FMC_R_BASE_S + 0x0104UL)
#define FMC_Bank3_R_BASE_S      (FMC_R_BASE_S + 0x0080UL)
#define FMC_Bank5_6_R_BASE_S    (FMC_R_BASE_S + 0x0140UL)

/* Debug MCU registers base address */
#define DBGMCU_BASE             (0x44024000UL)
#define PACKAGE_BASE            (0x08FFF80EUL) /*!< Package data register base address     */
#define UID_BASE                (0x08FFF800UL) /*!< Unique device ID register base address */
#define FLASHSIZE_BASE          (0x08FFF80CUL) /*!< Flash size data register base address  */

/* Internal Flash OTP Area */
#define FLASH_OTP_BASE          (0x08FFF000UL) /*!< FLASH OTP (one-time programmable) base address */
#define FLASH_OTP_SIZE          (0x800U)       /*!< 2048 bytes OTP (one-time programmable)         */

/* Flash system Area */
#define FLASH_SYSTEM_BASE_NS    (0x0BF80000UL) /*!< FLASH System non-secure base address  */
#define FLASH_SYSTEM_BASE_S     (0x0FF80000UL) /*!< FLASH System secure base address      */
#define FLASH_SYSTEM_SIZE       (0x10000U)     /*!< 64 Kbytes system Flash */

/* Internal Flash EDATA Area */
#define FLASH_EDATA_BASE_NS     (0x09000000UL) /*!< FLASH high-cycle data non-secure base address */
#define FLASH_EDATA_BASE_S      (0x0D000000UL) /*!< FLASH high-cycle data secure base address     */
#define FLASH_EDATA_SIZE        (0x18000U)     /*!< 96 KB of Flash high-cycle data                */

/* Internal Flash OBK Area */
#define FLASH_OBK_BASE_NS       (0x0BFD0000UL)  /*!< FLASH OBK (option byte keys) non-secure base address */
#define FLASH_OBK_BASE_S        (0x0FFD0000UL)  /*!< FLASH OBK (option byte keys) secure base address     */
#define FLASH_OBK_SIZE          (0x2000U)       /*!< 8 KB of option byte keys                             */
#define FLASH_OBK_HDPL0_SIZE    (0x100U)        /*!< 256 Bytes of HDPL1 option byte keys                  */

#define FLASH_OBK_HDPL1_BASE_NS (FLASH_OBK_BASE_NS + FLASH_OBK_HDPL0_SIZE)         /*!< FLASH OBK HDPL1 non-secure base address         */
#define FLASH_OBK_HDPL1_BASE_S  (FLASH_OBK_BASE_S + FLASH_OBK_HDPL0_SIZE)          /*!< FLASH OBK HDPL1 secure base address             */
#define FLASH_OBK_HDPL1_SIZE    (0x800U)                                           /*!< 2 KB of HDPL1 option byte keys                  */

#define FLASH_OBK_HDPL2_BASE_NS (FLASH_OBK_HDPL1_BASE_NS + FLASH_OBK_HDPL1_SIZE)   /*!< FLASH OBK HDPL2 non-secure base address         */
#define FLASH_OBK_HDPL2_BASE_S  (FLASH_OBK_HDPL1_BASE_S + FLASH_OBK_HDPL1_SIZE)    /*!< FLASH OBK HDPL2 secure base address             */
#define FLASH_OBK_HDPL2_SIZE    (0x300U)                                           /*!< 768 Bytes of HDPL2 option byte keys             */

#define FLASH_OBK_HDPL3_BASE_NS (FLASH_OBK_HDPL2_BASE_NS + FLASH_OBK_HDPL2_SIZE)   /*!< FLASH OBK HDPL3 non-secure base address         */
#define FLASH_OBK_HDPL3_BASE_S  (FLASH_OBK_HDPL2_BASE_S + FLASH_OBK_HDPL2_SIZE)    /*!< FLASH OBK HDPL3 secure base address             */
#define FLASH_OBK_HDPL3_SIZE    (0x13F0U)                                          /*!< 5104 Bytes HDPL3 option byte keys */

#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)
#define FLASH_OBK_HDPL3S_BASE_NS (FLASH_OBK_HDPL3_BASE_NS)                          /*!< FLASH OBK HDPL3 non-secure base address         */
#define FLASH_OBK_HDPL3S_BASE_S  (FLASH_OBK_HDPL3_BASE_S)                           /*!< FLASH OBK HDPL3 secure base address             */
#define FLASH_OBK_HDPL3S_SIZE    (0x0C00U)                                          /*!< 3072 Bytes of secure HDPL3 option byte keys     */

#define FLASH_OBK_HDPL3NS_BASE_NS (FLASH_OBK_HDPL3_BASE_NS + FLASH_OBK_HDPL3S_SIZE) /*!< FLASH OBK HDPL3 non-secure base address         */
#define FLASH_OBK_HDPL3NS_BASE_S  (FLASH_OBK_HDPL3_BASE_S + FLASH_OBK_HDPL3S_SIZE)  /*!< FLASH OBK HDPL3 secure base address             */
#define FLASH_OBK_HDPL3NS_SIZE    (FLASH_OBK_HDPL3_SIZE - FLASH_OBK_HDPL3S_SIZE)    /*!< 2032 Bytes of non-secure HDPL3 option byte keys */
#endif /* CMSE */

/*!< Root Secure Service Library */
/************ RSSLIB SAU system Flash region definition constants *************/
#define RSSLIB_SYS_FLASH_NS_PFUNC_START   (0xBF9FB68UL)
#define RSSLIB_SYS_FLASH_NS_PFUNC_END     (0xBF9FB84UL)

/************ RSSLIB function return constants ********************************/
#define RSSLIB_ERROR   (0xF5F5F5F5UL)
#define RSSLIB_SUCCESS (0xEAEAEAEAUL)

/*!< RSSLIB  pointer function structure address definition */
#define RSSLIB_PFUNC_BASE (0xBF9FB68UL)
#define RSSLIB_PFUNC      ((RSSLIB_pFunc_TypeDef *)RSSLIB_PFUNC_BASE)

/**
  * @brief  Prototype of RSSLIB Jump to HDP level2 Function
  * @detail This function increments HDP level up to HDP level 2
  *         Then it enables the MPU region corresponding the MPU index
  *         provided as input parameter. The Vector Table shall be located
  *         within this MPU region.
  *         Then it jumps to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @param  MPU region index containing the vector table
  *         jumps to.
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t (*RSSLIB_S_JumpHDPlvl2_TypeDef)(uint32_t VectorTableAddr, uint32_t MPUIndex);

/**
  * @brief  Prototype of RSSLIB Jump to HDP level3 Function
  * @detail This function increments HDP level up to HDP level 3
  *         Then it enables the MPU region corresponding the MPU index
  *         provided as input parameter. The Vector Table shall be located
  *         within this MPU region.
  *         Then it jumps to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @param  MPU region index containing the vector table
  *         jumps to.
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t (*RSSLIB_S_JumpHDPlvl3_TypeDef)(uint32_t VectorTableAddr, uint32_t MPUIndex);

/**
  * @brief  Prototype of RSSLIB Jump to HDP level3 Function
  * @detail This function increments HDP level up to HDP level 3
  *         Then it jumps to the non-secure reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t (*RSSLIB_S_JumpHDPlvl3NS_TypeDef)(uint32_t VectorTableAddr);

/**
  * @brief Input parameter definition of RSSLIB_DataProvisioning
  */
typedef struct
{
  uint32_t *pSource;        /*!< Address of the Data to be provisioned, shall be in SRAM3 */
  uint32_t *pDestination;   /*!< Address in OBKeys sections where to provision Data */
  uint32_t Size;            /*!< Size in bytes of the Data to be provisioned*/
  uint32_t DoEncryption;    /*!< Notifies RSSLIB_DataProvisioning to encrypt or not Data*/
  uint32_t Crc;             /*!< CRC over full Data buffer and previous field in the structure*/
} RSSLIB_DataProvisioningConf_t;

/**
  * @brief  Prototype of RSSLIB Data Provisioning Function
  * @detail This function write Data within OBKeys sections.
  * @param  pointer on the structure defining Data to be provisioned and where to
  * provision them within OBKeys sections.
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t (*RSSLIB_NSC_DataProvisioning_TypeDef)(RSSLIB_DataProvisioningConf_t *pConfig);


/**
  * @brief RSSLib secure callable function pointer structure
  */
typedef struct
{
  __IM RSSLIB_S_JumpHDPlvl2_TypeDef JumpHDPLvl2;
  __IM RSSLIB_S_JumpHDPlvl3_TypeDef JumpHDPLvl3;
  __IM RSSLIB_S_JumpHDPlvl3NS_TypeDef JumpHDPLvl3NS;
} S_pFuncTypeDef;

/**
  * @brief RSSLib Non-secure callable function pointer structure
  */
typedef struct
{
  __IM RSSLIB_NSC_DataProvisioning_TypeDef DataProvisioning;
} NSC_pFuncTypeDef;

/**
  * @brief RSSLib function pointer structure
  */
typedef struct
{
  NSC_pFuncTypeDef NSC;
  uint32_t RESERVED1[3];
  S_pFuncTypeDef S;
}RSSLIB_pFunc_TypeDef;

/*!< Non Secure Service Library */
/************ RSSLIB SAU system Flash region definition constants *************/
#define NSSLIB_SYS_FLASH_NS_PFUNC_START   (0xBF9FB6CUL)
#define NSSLIB_SYS_FLASH_NS_PFUNC_END     (0xBF9FB74UL)

/************ RSSLIB function return constants ********************************/
#define NSSLIB_ERROR   (0xF5F5F5F5UL)
#define NSSLIB_SUCCESS (0xEAEAEAEAUL)

/*!< RSSLIB  pointer function structure address definition */
#define NSSLIB_PFUNC_BASE (0xBF9FB6CUL)
#define NSSLIB_PFUNC      ((NSSLIB_pFunc_TypeDef *)NSSLIB_PFUNC_BASE)

/**
  * @brief  Prototype of RSSLIB Jump to HDP level2 Function
  * @detail This function increments HDP level up to HDP level 2
  *         Then it enables the MPU region corresponding the MPU index
  *         provided as input parameter. The Vector Table shall be located
  *         within this MPU region.
  *         Then it jumps to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @param  MPU region index containing the vector table
  *         jumps to.
  * @retval NSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t (*NSSLIB_S_JumpHDPlvl2_TypeDef)(uint32_t VectorTableAddr, uint32_t MPUIndex);

/**
  * @brief  Prototype of RSSLIB Jump to HDP level3 Function
  * @detail This function increments HDP level up to HDP level 3
  *         Then it enables the MPU region corresponding the MPU index
  *         provided as input parameter. The Vector Table shall be located
  *         within this MPU region.
  *         Then it jumps to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @param  MPU region index containing the vector table
  *         jumps to.
  * @retval NSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t (*NSSLIB_S_JumpHDPlvl3_TypeDef)(uint32_t VectorTableAddr, uint32_t MPUIndex);

/**
  * @brief RSSLib secure callable function pointer structure
  */
typedef struct
{
  __IM NSSLIB_S_JumpHDPlvl2_TypeDef JumpHDPLvl2;
  __IM NSSLIB_S_JumpHDPlvl3_TypeDef JumpHDPLvl3;
} NSSLIB_pFunc_TypeDef;


/** @} */ /* End of group STM32H5xx_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32H5xx_Peripheral_declaration
  * @{
  */

/*!< APB1 Non secure peripherals */
#define TIM2_NS                ((TIM_TypeDef *)TIM2_BASE_NS)
#define TIM3_NS                ((TIM_TypeDef *)TIM3_BASE_NS)
#define TIM4_NS                ((TIM_TypeDef *)TIM4_BASE_NS)
#define TIM5_NS                ((TIM_TypeDef *)TIM5_BASE_NS)
#define TIM6_NS                ((TIM_TypeDef *)TIM6_BASE_NS)
#define TIM7_NS                ((TIM_TypeDef *)TIM7_BASE_NS)
#define TIM12_NS               ((TIM_TypeDef *)TIM12_BASE_NS)
#define TIM13_NS               ((TIM_TypeDef *)TIM13_BASE_NS)
#define TIM14_NS               ((TIM_TypeDef *)TIM14_BASE_NS)
#define WWDG_NS                ((WWDG_TypeDef *)WWDG_BASE_NS)
#define IWDG_NS                ((IWDG_TypeDef *)IWDG_BASE_NS)
#define SPI2_NS                ((SPI_TypeDef *)SPI2_BASE_NS)
#define SPI3_NS                ((SPI_TypeDef *)SPI3_BASE_NS)
#define USART2_NS              ((USART_TypeDef *)USART2_BASE_NS)
#define USART3_NS              ((USART_TypeDef *)USART3_BASE_NS)
#define UART4_NS               ((USART_TypeDef *)UART4_BASE_NS)
#define UART5_NS               ((USART_TypeDef *)UART5_BASE_NS)
#define I2C1_NS                ((I2C_TypeDef *)I2C1_BASE_NS)
#define I2C2_NS                ((I2C_TypeDef *)I2C2_BASE_NS)
#define I3C1_NS                ((I3C_TypeDef *)I3C1_BASE_NS)
#define CRS_NS                 ((CRS_TypeDef *)CRS_BASE_NS)
#define USART6_NS              ((USART_TypeDef *)USART6_BASE_NS)
#define USART10_NS             ((USART_TypeDef *)USART10_BASE_NS)
#define USART11_NS             ((USART_TypeDef *)USART11_BASE_NS)
#define CEC_NS                 ((CEC_TypeDef *)CEC_BASE_NS)
#define UART7_NS               ((USART_TypeDef *)UART7_BASE_NS)
#define UART8_NS               ((USART_TypeDef *)UART8_BASE_NS)
#define UART9_NS               ((USART_TypeDef *)UART9_BASE_NS)
#define UART12_NS              ((USART_TypeDef *)UART12_BASE_NS)
#define DTS_NS                 ((DTS_TypeDef *)DTS_BASE_NS)
#define LPTIM2_NS              ((LPTIM_TypeDef *)LPTIM2_BASE_NS)
#define FDCAN1_NS              ((FDCAN_GlobalTypeDef *)FDCAN1_BASE_NS)
#define FDCAN_CONFIG_NS        ((FDCAN_Config_TypeDef *)FDCAN_CONFIG_BASE_NS)
#define FDCAN2_NS              ((FDCAN_GlobalTypeDef *)FDCAN2_BASE_NS)
#define UCPD1_NS               ((UCPD_TypeDef *)UCPD1_BASE_NS)

/*!< APB2 Non secure peripherals */
#define TIM1_NS                ((TIM_TypeDef *) TIM1_BASE_NS)
#define SPI1_NS                ((SPI_TypeDef *) SPI1_BASE_NS)
#define TIM8_NS                ((TIM_TypeDef *) TIM8_BASE_NS)
#define USART1_NS              ((USART_TypeDef *) USART1_BASE_NS)
#define TIM15_NS               ((TIM_TypeDef *) TIM15_BASE_NS)
#define TIM16_NS               ((TIM_TypeDef *) TIM16_BASE_NS)
#define TIM17_NS               ((TIM_TypeDef *) TIM17_BASE_NS)
#define SPI4_NS                ((SPI_TypeDef *) SPI4_BASE_NS)
#define SPI6_NS                ((SPI_TypeDef *) SPI6_BASE_NS)
#define SAI1_NS                ((SAI_TypeDef *) SAI1_BASE_NS)
#define SAI1_Block_A_NS        ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_NS)
#define SAI1_Block_B_NS        ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_NS)
#define SAI2_NS                ((SAI_TypeDef *) SAI2_BASE_NS)
#define SAI2_Block_A_NS        ((SAI_Block_TypeDef *)SAI2_Block_A_BASE_NS)
#define SAI2_Block_B_NS        ((SAI_Block_TypeDef *)SAI2_Block_B_BASE_NS)
#define USB_DRD_FS_NS          ((USB_DRD_TypeDef *) USB_DRD_BASE_NS)
#define USB_DRD_PMA_BUFF_NS    ((USB_DRD_PMABuffDescTypeDef *) USB_DRD_PMAADDR_NS)

/*!< AHB1 Non secure peripherals */
#define GPDMA1_NS              ((DMA_TypeDef *) GPDMA1_BASE_NS)
#define GPDMA2_NS              ((DMA_TypeDef *) GPDMA2_BASE_NS)
#define FLASH_NS               ((FLASH_TypeDef *) FLASH_R_BASE_NS)
#define CRC_NS                 ((CRC_TypeDef *) CRC_BASE_NS)
#define CORDIC_NS              ((CORDIC_TypeDef *) CORDIC_BASE_NS)
#define FMAC_NS                ((FMAC_TypeDef *) FMAC_BASE_NS)
#define RAMCFG_SRAM1_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM1_BASE_NS)
#define RAMCFG_SRAM2_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM2_BASE_NS)
#define RAMCFG_SRAM3_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM3_BASE_NS)
#define RAMCFG_BKPRAM_NS       ((RAMCFG_TypeDef *) RAMCFG_BKPRAM_BASE_NS)
#define ETH_NS                 ((ETH_TypeDef *) ETH_BASE_NS)
#define ETH_MAC_NS             ((ETH_TypeDef *) ETH_MAC_BASE_NS)
#define ICACHE_NS              ((ICACHE_TypeDef *) ICACHE_BASE_NS)
#define DCACHE1_NS             ((DCACHE_TypeDef *) DCACHE1_BASE_NS)
#define GTZC_TZSC1_NS          ((GTZC_TZSC_TypeDef *) GTZC_TZSC1_BASE_NS)
#define GTZC_TZIC1_NS          ((GTZC_TZIC_TypeDef *) GTZC_TZIC1_BASE_NS)
#define GTZC_MPCBB1_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_NS)
#define GTZC_MPCBB2_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_NS)
#define GTZC_MPCBB3_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB3_BASE_NS)
#define GPDMA1_Channel0_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_NS)
#define GPDMA1_Channel1_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_NS)
#define GPDMA1_Channel2_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_NS)
#define GPDMA1_Channel3_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_NS)
#define GPDMA1_Channel4_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_NS)
#define GPDMA1_Channel5_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_NS)
#define GPDMA1_Channel6_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_NS)
#define GPDMA1_Channel7_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_NS)
#define GPDMA2_Channel0_NS     ((DMA_Channel_TypeDef *) GPDMA2_Channel0_BASE_NS)
#define GPDMA2_Channel1_NS     ((DMA_Channel_TypeDef *) GPDMA2_Channel1_BASE_NS)
#define GPDMA2_Channel2_NS     ((DMA_Channel_TypeDef *) GPDMA2_Channel2_BASE_NS)
#define GPDMA2_Channel3_NS     ((DMA_Channel_TypeDef *) GPDMA2_Channel3_BASE_NS)
#define GPDMA2_Channel4_NS     ((DMA_Channel_TypeDef *) GPDMA2_Channel4_BASE_NS)
#define GPDMA2_Channel5_NS     ((DMA_Channel_TypeDef *) GPDMA2_Channel5_BASE_NS)
#define GPDMA2_Channel6_NS     ((DMA_Channel_TypeDef *) GPDMA2_Channel6_BASE_NS)
#define GPDMA2_Channel7_NS     ((DMA_Channel_TypeDef *) GPDMA2_Channel7_BASE_NS)

/*!< AHB2 Non secure peripherals */
#define GPIOA_NS               ((GPIO_TypeDef *) GPIOA_BASE_NS)
#define GPIOB_NS               ((GPIO_TypeDef *) GPIOB_BASE_NS)
#define GPIOC_NS               ((GPIO_TypeDef *) GPIOC_BASE_NS)
#define GPIOD_NS               ((GPIO_TypeDef *) GPIOD_BASE_NS)
#define GPIOE_NS               ((GPIO_TypeDef *) GPIOE_BASE_NS)
#define GPIOF_NS               ((GPIO_TypeDef *) GPIOF_BASE_NS)
#define GPIOG_NS               ((GPIO_TypeDef *) GPIOG_BASE_NS)
#define GPIOH_NS               ((GPIO_TypeDef *) GPIOH_BASE_NS)
#define GPIOI_NS               ((GPIO_TypeDef *) GPIOI_BASE_NS)
#define ADC1_NS                ((ADC_TypeDef *) ADC1_BASE_NS)
#define ADC2_NS                ((ADC_TypeDef *) ADC2_BASE_NS)
#define ADC12_COMMON_NS        ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_NS)
#define DAC1_NS                ((DAC_TypeDef *) DAC1_BASE_NS)
#define DCMI_NS                ((DCMI_TypeDef *) DCMI_BASE_NS)
#define PSSI_NS                ((PSSI_TypeDef *) PSSI_BASE_NS)
#define HASH_NS                ((HASH_TypeDef *) HASH_BASE_NS)
#define HASH_DIGEST_NS         ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_NS)
#define RNG_NS                 ((RNG_TypeDef *) RNG_BASE_NS)
#define PKA_NS                 ((PKA_TypeDef *) PKA_BASE_NS)


/*!< APB3 Non secure peripherals */
#define SBS_NS                 ((SBS_TypeDef *) SBS_BASE_NS)
#define SPI5_NS                ((SPI_TypeDef *) SPI5_BASE_NS)
#define LPUART1_NS             ((USART_TypeDef *) LPUART1_BASE_NS)
#define I2C3_NS                ((I2C_TypeDef *) I2C3_BASE_NS)
#define I2C4_NS                ((I2C_TypeDef *) I2C4_BASE_NS)
#define LPTIM1_NS              ((LPTIM_TypeDef *) LPTIM1_BASE_NS)
#define LPTIM3_NS              ((LPTIM_TypeDef *) LPTIM3_BASE_NS)
#define LPTIM4_NS              ((LPTIM_TypeDef *) LPTIM4_BASE_NS)
#define LPTIM5_NS              ((LPTIM_TypeDef *) LPTIM5_BASE_NS)
#define LPTIM6_NS              ((LPTIM_TypeDef *) LPTIM6_BASE_NS)
#define VREFBUF_NS             ((VREFBUF_TypeDef *) VREFBUF_BASE_NS)
#define RTC_NS                 ((RTC_TypeDef *) RTC_BASE_NS)
#define TAMP_NS                ((TAMP_TypeDef *) TAMP_BASE_NS)

/*!< AHB3 Non secure peripherals */
#define PWR_NS                 ((PWR_TypeDef *) PWR_BASE_NS)
#define RCC_NS                 ((RCC_TypeDef *) RCC_BASE_NS)
#define EXTI_NS                ((EXTI_TypeDef *) EXTI_BASE_NS)

/*!< AHB4 Non secure peripherals */
#define SDMMC1_NS              ((SDMMC_TypeDef *) SDMMC1_BASE_NS)
#define DLYB_SDMMC1_NS         ((DLYB_TypeDef *) DLYB_SDMMC1_BASE_NS)
#define SDMMC2_NS              ((SDMMC_TypeDef *) SDMMC2_BASE_NS)
#define DLYB_SDMMC2_NS         ((DLYB_TypeDef *) DLYB_SDMMC2_BASE_NS)

#define OCTOSPI1_NS            ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE_NS)
#define DLYB_OCTOSPI1_NS       ((DLYB_TypeDef *) DLYB_OCTOSPI1_BASE_NS)

/*!< FMC Banks Non secure registers base address */
#define FMC_Bank1_R_NS         ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE_NS)
#define FMC_Bank1E_R_NS        ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE_NS)
#define FMC_Bank3_R_NS         ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE_NS)
#define FMC_Bank5_6_R_NS       ((FMC_Bank5_6_TypeDef *) FMC_Bank5_6_R_BASE_NS)

/*!< APB1 Secure peripherals */
#define TIM2_S                 ((TIM_TypeDef *)TIM2_BASE_S)
#define TIM3_S                 ((TIM_TypeDef *)TIM3_BASE_S)
#define TIM4_S                 ((TIM_TypeDef *)TIM4_BASE_S)
#define TIM5_S                 ((TIM_TypeDef *)TIM5_BASE_S)
#define TIM6_S                 ((TIM_TypeDef *)TIM6_BASE_S)
#define TIM7_S                 ((TIM_TypeDef *)TIM7_BASE_S)
#define TIM12_S                ((TIM_TypeDef *)TIM12_BASE_S)
#define TIM13_S                ((TIM_TypeDef *)TIM13_BASE_S)
#define TIM14_S                ((TIM_TypeDef *)TIM14_BASE_S)
#define WWDG_S                 ((WWDG_TypeDef *)WWDG_BASE_S)
#define IWDG_S                 ((IWDG_TypeDef *)IWDG_BASE_S)
#define SPI2_S                 ((SPI_TypeDef *)SPI2_BASE_S)
#define SPI3_S                 ((SPI_TypeDef *)SPI3_BASE_S)
#define USART2_S               ((USART_TypeDef *)USART2_BASE_S)
#define USART3_S               ((USART_TypeDef *)USART3_BASE_S)
#define UART4_S                ((USART_TypeDef *)UART4_BASE_S)
#define UART5_S                ((USART_TypeDef *)UART5_BASE_S)
#define I2C1_S                 ((I2C_TypeDef *)I2C1_BASE_S)
#define I2C2_S                 ((I2C_TypeDef *)I2C2_BASE_S)
#define I3C1_S                 ((I3C_TypeDef *)I3C1_BASE_S)
#define CRS_S                  ((CRS_TypeDef *)CRS_BASE_S)
#define USART6_S               ((USART_TypeDef *)USART6_BASE_S)
#define USART10_S              ((USART_TypeDef *)USART10_BASE_S)
#define USART11_S              ((USART_TypeDef *)USART11_BASE_S)
#define CEC_S                  ((CEC_TypeDef *)CEC_BASE_S)
#define UART7_S                ((USART_TypeDef *)UART7_BASE_S)
#define UART8_S                ((USART_TypeDef *)UART8_BASE_S)
#define UART9_S                ((USART_TypeDef *)UART9_BASE_S)
#define UART12_S               ((USART_TypeDef *)UART12_BASE_S)
#define DTS_S                  ((DTS_TypeDef *)DTS_BASE_S)
#define LPTIM2_S               ((LPTIM_TypeDef *)LPTIM2_BASE_S)
#define FDCAN1_S               ((FDCAN_GlobalTypeDef *)FDCAN1_BASE_S)
#define FDCAN_CONFIG_S         ((FDCAN_Config_TypeDef *)FDCAN_CONFIG_BASE_S)
#define FDCAN2_S               ((FDCAN_GlobalTypeDef *)FDCAN2_BASE_S)
#define UCPD1_S                ((UCPD_TypeDef *)UCPD1_BASE_S)

/*!< APB2 secure peripherals */
#define TIM1_S                 ((TIM_TypeDef *) TIM1_BASE_S)
#define SPI1_S                 ((SPI_TypeDef *) SPI1_BASE_S)
#define TIM8_S                 ((TIM_TypeDef *) TIM8_BASE_S)
#define USART1_S               ((USART_TypeDef *) USART1_BASE_S)
#define TIM15_S                ((TIM_TypeDef *) TIM15_BASE_S)
#define TIM16_S                ((TIM_TypeDef *) TIM16_BASE_S)
#define TIM17_S                ((TIM_TypeDef *) TIM17_BASE_S)
#define SPI4_S                 ((SPI_TypeDef *) SPI4_BASE_S)
#define SPI6_S                 ((SPI_TypeDef *) SPI6_BASE_S)
#define SAI1_S                 ((SAI_TypeDef *) SAI1_BASE_S)
#define SAI1_Block_A_S         ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_S)
#define SAI1_Block_B_S         ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_S)
#define SAI2_S                 ((SAI_TypeDef *) SAI2_BASE_S)
#define SAI2_Block_A_S         ((SAI_Block_TypeDef *)SAI2_Block_A_BASE_S)
#define SAI2_Block_B_S         ((SAI_Block_TypeDef *)SAI2_Block_B_BASE_S)
#define USB_DRD_FS_S           ((USB_DRD_TypeDef *)USB_DRD_BASE_S)
#define USB_DRD_PMA_BUFF_S     ((USB_DRD_PMABuffDescTypeDef *) USB_DRD_PMAADDR_S)

/*!< AHB1 secure peripherals */
#define GPDMA1_S               ((DMA_TypeDef *) GPDMA1_BASE_S)
#define GPDMA2_S               ((DMA_TypeDef *) GPDMA2_BASE_S)
#define FLASH_S                ((FLASH_TypeDef *) FLASH_R_BASE_S)
#define CRC_S                  ((CRC_TypeDef *) CRC_BASE_S)
#define CORDIC_S               ((CORDIC_TypeDef *) CORDIC_BASE_S)
#define FMAC_S                 ((FMAC_TypeDef *) FMAC_BASE_S)
#define RAMCFG_SRAM1_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM1_BASE_S)
#define RAMCFG_SRAM2_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM2_BASE_S)
#define RAMCFG_SRAM3_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM3_BASE_S)
#define RAMCFG_BKPRAM_S        ((RAMCFG_TypeDef *) RAMCFG_BKPRAM_BASE_S)
#define ETH_S                  ((ETH_TypeDef *) ETH_BASE_S)
#define ETH_MAC_S              ((ETH_TypeDef *) ETH_MAC_BASE_S)
#define ICACHE_S               ((ICACHE_TypeDef *) ICACHE_BASE_S)
#define DCACHE1_S              ((DCACHE_TypeDef *) DCACHE1_BASE_S)
#define GTZC_TZSC1_S           ((GTZC_TZSC_TypeDef *) GTZC_TZSC1_BASE_S)
#define GTZC_TZIC1_S           ((GTZC_TZIC_TypeDef *) GTZC_TZIC1_BASE_S)
#define GTZC_MPCBB1_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_S)
#define GTZC_MPCBB2_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_S)
#define GTZC_MPCBB3_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB3_BASE_S)
#define GPDMA1_Channel0_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_S)
#define GPDMA1_Channel1_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_S)
#define GPDMA1_Channel2_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_S)
#define GPDMA1_Channel3_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_S)
#define GPDMA1_Channel4_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_S)
#define GPDMA1_Channel5_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_S)
#define GPDMA1_Channel6_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_S)
#define GPDMA1_Channel7_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_S)
#define GPDMA2_Channel0_S      ((DMA_Channel_TypeDef *) GPDMA2_Channel0_BASE_S)
#define GPDMA2_Channel1_S      ((DMA_Channel_TypeDef *) GPDMA2_Channel1_BASE_S)
#define GPDMA2_Channel2_S      ((DMA_Channel_TypeDef *) GPDMA2_Channel2_BASE_S)
#define GPDMA2_Channel3_S      ((DMA_Channel_TypeDef *) GPDMA2_Channel3_BASE_S)
#define GPDMA2_Channel4_S      ((DMA_Channel_TypeDef *) GPDMA2_Channel4_BASE_S)
#define GPDMA2_Channel5_S      ((DMA_Channel_TypeDef *) GPDMA2_Channel5_BASE_S)
#define GPDMA2_Channel6_S      ((DMA_Channel_TypeDef *) GPDMA2_Channel6_BASE_S)
#define GPDMA2_Channel7_S      ((DMA_Channel_TypeDef *) GPDMA2_Channel7_BASE_S)


/*!< AHB2 secure peripherals */
#define GPIOA_S                ((GPIO_TypeDef *) GPIOA_BASE_S)
#define GPIOB_S                ((GPIO_TypeDef *) GPIOB_BASE_S)
#define GPIOC_S                ((GPIO_TypeDef *) GPIOC_BASE_S)
#define GPIOD_S                ((GPIO_TypeDef *) GPIOD_BASE_S)
#define GPIOE_S                ((GPIO_TypeDef *) GPIOE_BASE_S)
#define GPIOF_S                ((GPIO_TypeDef *) GPIOF_BASE_S)
#define GPIOG_S                ((GPIO_TypeDef *) GPIOG_BASE_S)
#define GPIOH_S                ((GPIO_TypeDef *) GPIOH_BASE_S)
#define GPIOI_S                ((GPIO_TypeDef *) GPIOI_BASE_S)
#define ADC1_S                 ((ADC_TypeDef *) ADC1_BASE_S)
#define ADC2_S                 ((ADC_TypeDef *) ADC2_BASE_S)
#define ADC12_COMMON_S         ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_S)
#define DAC1_S                 ((DAC_TypeDef *) DAC1_BASE_S)
#define DCMI_S                 ((DCMI_TypeDef *) DCMI_BASE_S)
#define PSSI_S                 ((PSSI_TypeDef *) PSSI_BASE_S)
#define HASH_S                 ((HASH_TypeDef *) HASH_BASE_S)
#define HASH_DIGEST_S          ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_S)
#define RNG_S                  ((RNG_TypeDef *) RNG_BASE_S)
#define PKA_S                  ((PKA_TypeDef *) PKA_BASE_S)

/*!< APB3 secure peripherals */
#define SBS_S                  ((SBS_TypeDef *) SBS_BASE_S)
#define SPI5_S                 ((SPI_TypeDef *) SPI5_BASE_S)
#define LPUART1_S              ((USART_TypeDef *) LPUART1_BASE_S)
#define I2C3_S                 ((I2C_TypeDef *) I2C3_BASE_S)
#define I2C4_S                 ((I2C_TypeDef *) I2C4_BASE_S)
#define LPTIM1_S               ((LPTIM_TypeDef *) LPTIM1_BASE_S)
#define LPTIM3_S               ((LPTIM_TypeDef *) LPTIM3_BASE_S)
#define LPTIM4_S               ((LPTIM_TypeDef *) LPTIM4_BASE_S)
#define LPTIM5_S               ((LPTIM_TypeDef *) LPTIM5_BASE_S)
#define LPTIM6_S               ((LPTIM_TypeDef *) LPTIM6_BASE_S)
#define VREFBUF_S              ((VREFBUF_TypeDef *) VREFBUF_BASE_S)
#define RTC_S                  ((RTC_TypeDef *) RTC_BASE_S)
#define TAMP_S                 ((TAMP_TypeDef *) TAMP_BASE_S)

/*!< AHB3 Secure peripherals */
#define PWR_S                  ((PWR_TypeDef *) PWR_BASE_S)
#define RCC_S                  ((RCC_TypeDef *) RCC_BASE_S)
#define EXTI_S                 ((EXTI_TypeDef *) EXTI_BASE_S)

/*!< AHB4 secure peripherals */
#define SDMMC1_S               ((SDMMC_TypeDef *) SDMMC1_BASE_S)
#define DLYB_SDMMC1_S          ((DLYB_TypeDef *) DLYB_SDMMC1_BASE_S)
#define SDMMC2_S               ((SDMMC_TypeDef *) SDMMC2_BASE_S)
#define DLYB_SDMMC2_S          ((DLYB_TypeDef *) DLYB_SDMMC2_BASE_S)

#define FMC_Bank1_R_S          ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE_S)
#define FMC_Bank1E_R_S         ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE_S)
#define FMC_Bank3_R_S          ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE_S)
#define FMC_Bank5_6_R_S        ((FMC_Bank5_6_TypeDef *) FMC_Bank5_6_R_BASE_S)

#define OCTOSPI1_S             ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE_S)
#define DLYB_OCTOSPI1_S        ((DLYB_TypeDef *) DLYB_OCTOSPI1_BASE_S)

#define DBGMCU                 ((DBGMCU_TypeDef *) DBGMCU_BASE)

/*!< Memory & Instance aliases and base addresses for Non-Secure/Secure peripherals */

#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)

/*!< Memory base addresses for Secure peripherals */
#define FLASH_BASE                     FLASH_BASE_S
#define FLASH_OBK_BASE                 FLASH_OBK_BASE_S
#define FLASH_EDATA_BASE               FLASH_EDATA_BASE_S
#define FLASH_SYSTEM_BASE              FLASH_SYSTEM_BASE_S
#define SRAM1_BASE                     SRAM1_BASE_S
#define SRAM2_BASE                     SRAM2_BASE_S
#define SRAM3_BASE                     SRAM3_BASE_S
#define BKPSRAM_BASE                   BKPSRAM_BASE_S
#define PERIPH_BASE                    PERIPH_BASE_S
#define APB1PERIPH_BASE                APB1PERIPH_BASE_S
#define APB2PERIPH_BASE                APB2PERIPH_BASE_S
#define APB3PERIPH_BASE                APB3PERIPH_BASE_S
#define AHB1PERIPH_BASE                AHB1PERIPH_BASE_S
#define AHB2PERIPH_BASE                AHB2PERIPH_BASE_S
#define AHB3PERIPH_BASE                AHB3PERIPH_BASE_S
#define AHB4PERIPH_BASE                AHB4PERIPH_BASE_S

/*!< Instance aliases and base addresses for Secure peripherals */
#define CORDIC                         CORDIC_S
#define CORDIC_BASE                    CORDIC_BASE_S

#define RCC                            RCC_S
#define RCC_BASE                       RCC_BASE_S

#define DCMI                           DCMI_S
#define DCMI_BASE                      DCMI_BASE_S

#define PSSI                           PSSI_S
#define PSSI_BASE                      PSSI_BASE_S

#define DTS                            DTS_S
#define DTS_BASE                       DTS_BASE_S

#define FLASH                          FLASH_S
#define FLASH_R_BASE                   FLASH_R_BASE_S

#define FMAC                           FMAC_S
#define FMAC_BASE                      FMAC_BASE_S

#define GPDMA1                         GPDMA1_S
#define GPDMA1_BASE                    GPDMA1_BASE_S

#define GPDMA1_Channel0                GPDMA1_Channel0_S
#define GPDMA1_Channel0_BASE           GPDMA1_Channel0_BASE_S

#define GPDMA1_Channel1                GPDMA1_Channel1_S
#define GPDMA1_Channel1_BASE           GPDMA1_Channel1_BASE_S

#define GPDMA1_Channel2                GPDMA1_Channel2_S
#define GPDMA1_Channel2_BASE           GPDMA1_Channel2_BASE_S

#define GPDMA1_Channel3                GPDMA1_Channel3_S
#define GPDMA1_Channel3_BASE           GPDMA1_Channel3_BASE_S

#define GPDMA1_Channel4                GPDMA1_Channel4_S
#define GPDMA1_Channel4_BASE           GPDMA1_Channel4_BASE_S

#define GPDMA1_Channel5                GPDMA1_Channel5_S
#define GPDMA1_Channel5_BASE           GPDMA1_Channel5_BASE_S

#define GPDMA1_Channel6                GPDMA1_Channel6_S
#define GPDMA1_Channel6_BASE           GPDMA1_Channel6_BASE_S

#define GPDMA1_Channel7                GPDMA1_Channel7_S
#define GPDMA1_Channel7_BASE           GPDMA1_Channel7_BASE_S

#define GPDMA2                         GPDMA2_S
#define GPDMA2_BASE                    GPDMA2_BASE_S

#define GPDMA2_Channel0                GPDMA2_Channel0_S
#define GPDMA2_Channel0_BASE           GPDMA2_Channel0_BASE_S

#define GPDMA2_Channel1                GPDMA2_Channel1_S
#define GPDMA2_Channel1_BASE           GPDMA2_Channel1_BASE_S

#define GPDMA2_Channel2                GPDMA2_Channel2_S
#define GPDMA2_Channel2_BASE           GPDMA2_Channel2_BASE_S

#define GPDMA2_Channel3                GPDMA2_Channel3_S
#define GPDMA2_Channel3_BASE           GPDMA2_Channel3_BASE_S

#define GPDMA2_Channel4                GPDMA2_Channel4_S
#define GPDMA2_Channel4_BASE           GPDMA2_Channel4_BASE_S

#define GPDMA2_Channel5                GPDMA2_Channel5_S
#define GPDMA2_Channel5_BASE           GPDMA2_Channel5_BASE_S

#define GPDMA2_Channel6                GPDMA2_Channel6_S
#define GPDMA2_Channel6_BASE           GPDMA2_Channel6_BASE_S

#define GPDMA2_Channel7                GPDMA2_Channel7_S
#define GPDMA2_Channel7_BASE           GPDMA2_Channel7_BASE_S

#define GPIOA                          GPIOA_S
#define GPIOA_BASE                     GPIOA_BASE_S

#define GPIOB                          GPIOB_S
#define GPIOB_BASE                     GPIOB_BASE_S

#define GPIOC                          GPIOC_S
#define GPIOC_BASE                     GPIOC_BASE_S

#define GPIOD                          GPIOD_S
#define GPIOD_BASE                     GPIOD_BASE_S

#define GPIOE                          GPIOE_S
#define GPIOE_BASE                     GPIOE_BASE_S

#define GPIOF                          GPIOF_S
#define GPIOF_BASE                     GPIOF_BASE_S

#define GPIOG                          GPIOG_S
#define GPIOG_BASE                     GPIOG_BASE_S

#define GPIOH                          GPIOH_S
#define GPIOH_BASE                     GPIOH_BASE_S

#define GPIOI                          GPIOI_S
#define GPIOI_BASE                     GPIOI_BASE_S

#define PWR                            PWR_S
#define PWR_BASE                       PWR_BASE_S

#define RAMCFG_SRAM1                   RAMCFG_SRAM1_S
#define RAMCFG_SRAM1_BASE              RAMCFG_SRAM1_BASE_S

#define RAMCFG_SRAM2                   RAMCFG_SRAM2_S
#define RAMCFG_SRAM2_BASE              RAMCFG_SRAM2_BASE_S

#define RAMCFG_SRAM3                   RAMCFG_SRAM3_S
#define RAMCFG_SRAM3_BASE              RAMCFG_SRAM3_BASE_S

#define RAMCFG_BKPRAM                  RAMCFG_BKPRAM_S
#define RAMCFG_BKPRAM_BASE             RAMCFG_BKPRAM_BASE_S

#define EXTI                           EXTI_S
#define EXTI_BASE                      EXTI_BASE_S

#define ICACHE                         ICACHE_S
#define ICACHE_BASE                    ICACHE_BASE_S

#define DCACHE1                        DCACHE1_S
#define DCACHE1_BASE                   DCACHE1_BASE_S

#define GTZC_TZSC1                     GTZC_TZSC1_S
#define GTZC_TZSC1_BASE                GTZC_TZSC1_BASE_S

#define GTZC_TZIC1                     GTZC_TZIC1_S
#define GTZC_TZIC1_BASE                GTZC_TZIC1_BASE_S

#define GTZC_MPCBB1                    GTZC_MPCBB1_S
#define GTZC_MPCBB1_BASE               GTZC_MPCBB1_BASE_S

#define GTZC_MPCBB2                    GTZC_MPCBB2_S
#define GTZC_MPCBB2_BASE               GTZC_MPCBB2_BASE_S

#define GTZC_MPCBB3                    GTZC_MPCBB3_S
#define GTZC_MPCBB3_BASE               GTZC_MPCBB3_BASE_S

#define RTC                            RTC_S
#define RTC_BASE                       RTC_BASE_S

#define TAMP                           TAMP_S
#define TAMP_BASE                      TAMP_BASE_S

#define TIM1                           TIM1_S
#define TIM1_BASE                      TIM1_BASE_S

#define TIM2                           TIM2_S
#define TIM2_BASE                      TIM2_BASE_S

#define TIM3                           TIM3_S
#define TIM3_BASE                      TIM3_BASE_S

#define TIM4                           TIM4_S
#define TIM4_BASE                      TIM4_BASE_S

#define TIM5                           TIM5_S
#define TIM5_BASE                      TIM5_BASE_S

#define TIM6                           TIM6_S
#define TIM6_BASE                      TIM6_BASE_S

#define TIM7                           TIM7_S
#define TIM7_BASE                      TIM7_BASE_S

#define TIM8                           TIM8_S
#define TIM8_BASE                      TIM8_BASE_S

#define TIM15                          TIM15_S
#define TIM15_BASE                     TIM15_BASE_S

#define TIM12                          TIM12_S
#define TIM12_BASE                     TIM12_BASE_S

#define TIM13                          TIM13_S
#define TIM13_BASE                     TIM13_BASE_S

#define TIM14                          TIM14_S
#define TIM14_BASE                     TIM14_BASE_S

#define TIM16                          TIM16_S
#define TIM16_BASE                     TIM16_BASE_S

#define TIM17                          TIM17_S
#define TIM17_BASE                     TIM17_BASE_S

#define WWDG                           WWDG_S
#define WWDG_BASE                      WWDG_BASE_S

#define IWDG                           IWDG_S
#define IWDG_BASE                      IWDG_BASE_S

#define SPI1                           SPI1_S
#define SPI1_BASE                      SPI1_BASE_S

#define SPI2                           SPI2_S
#define SPI2_BASE                      SPI2_BASE_S

#define SPI3                           SPI3_S
#define SPI3_BASE                      SPI3_BASE_S

#define SPI4                           SPI4_S
#define SPI4_BASE                      SPI4_BASE_S

#define SPI5                           SPI5_S
#define SPI5_BASE                      SPI5_BASE_S

#define SPI6                           SPI6_S
#define SPI6_BASE                      SPI6_BASE_S

#define USART1                         USART1_S
#define USART1_BASE                    USART1_BASE_S

#define USART2                         USART2_S
#define USART2_BASE                    USART2_BASE_S

#define USART3                         USART3_S
#define USART3_BASE                    USART3_BASE_S

#define UART4                          UART4_S
#define UART4_BASE                     UART4_BASE_S

#define UART5                          UART5_S
#define UART5_BASE                     UART5_BASE_S

#define USART6                         USART6_S
#define USART6_BASE                    USART6_BASE_S

#define UART7                          UART7_S
#define UART7_BASE                     UART7_BASE_S

#define UART8                          UART8_S
#define UART8_BASE                     UART8_BASE_S

#define UART9                          UART9_S
#define UART9_BASE                     UART9_BASE_S

#define USART10                        USART10_S
#define USART10_BASE                   USART10_BASE_S

#define USART11                        USART11_S
#define USART11_BASE                   USART11_BASE_S

#define UART12                         UART12_S
#define UART12_BASE                    UART12_BASE_S

#define CEC                            CEC_S
#define CEC_BASE                       CEC_BASE_S

#define I2C1                           I2C1_S
#define I2C1_BASE                      I2C1_BASE_S

#define I2C2                           I2C2_S
#define I2C2_BASE                      I2C2_BASE_S

#define I2C3                           I2C3_S
#define I2C3_BASE                      I2C3_BASE_S

#define I2C4                           I2C4_S
#define I2C4_BASE                      I2C4_BASE_S

#define I3C1                           I3C1_S
#define I3C1_BASE                      I3C1_BASE_S

#define CRS                            CRS_S
#define CRS_BASE                       CRS_BASE_S

#define FDCAN1                         FDCAN1_S
#define FDCAN1_BASE                    FDCAN1_BASE_S

#define FDCAN_CONFIG                   FDCAN_CONFIG_S
#define FDCAN_CONFIG_BASE              FDCAN_CONFIG_BASE_S
#define SRAMCAN_BASE                   SRAMCAN_BASE_S

#define FDCAN2                         FDCAN2_S
#define FDCAN2_BASE                    FDCAN2_BASE_S

#define DAC1                           DAC1_S
#define DAC1_BASE                      DAC1_BASE_S

#define LPTIM1                         LPTIM1_S
#define LPTIM1_BASE                    LPTIM1_BASE_S

#define LPTIM2                         LPTIM2_S
#define LPTIM2_BASE                    LPTIM2_BASE_S

#define LPTIM3                         LPTIM3_S
#define LPTIM3_BASE                    LPTIM3_BASE_S

#define LPTIM4                         LPTIM4_S
#define LPTIM4_BASE                    LPTIM4_BASE_S

#define LPTIM5                         LPTIM5_S
#define LPTIM5_BASE                    LPTIM5_BASE_S

#define LPTIM6                         LPTIM6_S
#define LPTIM6_BASE                    LPTIM6_BASE_S

#define LPUART1                        LPUART1_S
#define LPUART1_BASE                   LPUART1_BASE_S

#define UCPD1                          UCPD1_S
#define UCPD1_BASE                     UCPD1_BASE_S

#define SBS                            SBS_S
#define SBS_BASE                       SBS_BASE_S

#define VREFBUF                        VREFBUF_S
#define VREFBUF_BASE                   VREFBUF_BASE_S

#define SAI1                           SAI1_S
#define SAI1_BASE                      SAI1_BASE_S

#define SAI1_Block_A                   SAI1_Block_A_S
#define SAI1_Block_A_BASE              SAI1_Block_A_BASE_S

#define SAI1_Block_B                   SAI1_Block_B_S
#define SAI1_Block_B_BASE              SAI1_Block_B_BASE_S

#define SAI2                           SAI2_S
#define SAI2_BASE                      SAI2_BASE_S

#define SAI2_Block_A                   SAI2_Block_A_S
#define SAI2_Block_A_BASE              SAI2_Block_A_BASE_S

#define SAI2_Block_B                   SAI2_Block_B_S
#define SAI2_Block_B_BASE              SAI2_Block_B_BASE_S

#define USB_DRD_FS                     USB_DRD_FS_S
#define USB_DRD_BASE                   USB_DRD_BASE_S
#define USB_DRD_PMAADDR                USB_DRD_PMAADDR_S
#define USB_DRD_PMA_BUFF               USB_DRD_PMA_BUFF_S

#define CRC                            CRC_S
#define CRC_BASE                       CRC_BASE_S

#define ADC1                           ADC1_S
#define ADC1_BASE                      ADC1_BASE_S

#define ADC2                           ADC2_S
#define ADC2_BASE                      ADC2_BASE_S

#define ADC12_COMMON                   ADC12_COMMON_S
#define ADC12_COMMON_BASE              ADC12_COMMON_BASE_S

#define HASH                           HASH_S
#define HASH_BASE                      HASH_BASE_S

#define HASH_DIGEST                    HASH_DIGEST_S
#define HASH_DIGEST_BASE               HASH_DIGEST_BASE_S

#define RNG                            RNG_S
#define RNG_BASE                       RNG_BASE_S

#define PKA                            PKA_S
#define PKA_BASE                       PKA_BASE_S
#define PKA_RAM_BASE                   PKA_RAM_BASE_S

#define ETH                            ETH_S
#define ETH_BASE                       ETH_BASE_S
#define ETH_MAC                        ETH_MAC_S
#define ETH_MAC_BASE                   ETH_MAC_BASE_S

#define SDMMC1                         SDMMC1_S
#define SDMMC1_BASE                    SDMMC1_BASE_S

#define SDMMC2                         SDMMC2_S
#define SDMMC2_BASE                    SDMMC2_BASE_S

#define FMC_Bank1_R                    FMC_Bank1_R_S
#define FMC_Bank1_R_BASE               FMC_Bank1_R_BASE_S

#define FMC_Bank1E_R                   FMC_Bank1E_R_S
#define FMC_Bank1E_R_BASE              FMC_Bank1E_R_BASE_S

#define FMC_Bank3_R                    FMC_Bank3_R_S
#define FMC_Bank3_R_BASE               FMC_Bank3_R_BASE_S

#define FMC_Bank5_6_R                  FMC_Bank5_6_R_S
#define FMC_Bank5_6_R_BASE             FMC_Bank5_6_R_BASE_S

#define OCTOSPI1                       OCTOSPI1_S
#define OCTOSPI1_R_BASE                OCTOSPI1_R_BASE_S

#define DLYB_SDMMC1                    DLYB_SDMMC1_S
#define DLYB_SDMMC1_BASE               DLYB_SDMMC1_BASE_S

#define DLYB_SDMMC2                    DLYB_SDMMC2_S
#define DLYB_SDMMC2_BASE               DLYB_SDMMC2_BASE_S

#define DLYB_OCTOSPI1                  DLYB_OCTOSPI1_S
#define DLYB_OCTOSPI1_BASE             DLYB_OCTOSPI1_BASE_S

#else

/*!< Memory base addresses for Non secure peripherals */
#define FLASH_BASE                     FLASH_BASE_NS
#define FLASH_OBK_BASE                 FLASH_OBK_BASE_NS
#define FLASH_EDATA_BASE               FLASH_EDATA_BASE_NS
#define FLASH_SYSTEM_BASE              FLASH_SYSTEM_BASE_NS

#define SRAM1_BASE                     SRAM1_BASE_NS
#define SRAM2_BASE                     SRAM2_BASE_NS

#define SRAM3_BASE                     SRAM3_BASE_NS
#define BKPSRAM_BASE                   BKPSRAM_BASE_NS

#define PERIPH_BASE                    PERIPH_BASE_NS
#define APB1PERIPH_BASE                APB1PERIPH_BASE_NS
#define APB2PERIPH_BASE                APB2PERIPH_BASE_NS
#define APB3PERIPH_BASE                APB3PERIPH_BASE_NS
#define AHB1PERIPH_BASE                AHB1PERIPH_BASE_NS
#define AHB2PERIPH_BASE                AHB2PERIPH_BASE_NS
#define AHB3PERIPH_BASE                AHB3PERIPH_BASE_NS
#define AHB4PERIPH_BASE                AHB4PERIPH_BASE_NS

/*!< Instance aliases and base addresses for Non secure peripherals */
#define CORDIC                         CORDIC_NS
#define CORDIC_BASE                    CORDIC_BASE_NS

#define RCC                            RCC_NS
#define RCC_BASE                       RCC_BASE_NS

#define DCMI                           DCMI_NS
#define DCMI_BASE                      DCMI_BASE_NS

#define PSSI                           PSSI_NS
#define PSSI_BASE                      PSSI_BASE_NS

#define DTS                            DTS_NS
#define DTS_BASE                       DTS_BASE_NS

#define FLASH                          FLASH_NS
#define FLASH_R_BASE                   FLASH_R_BASE_NS

#define FMAC                           FMAC_NS
#define FMAC_BASE                      FMAC_BASE_NS

#define GPDMA1                         GPDMA1_NS
#define GPDMA1_BASE                    GPDMA1_BASE_NS

#define GPDMA1_Channel0                GPDMA1_Channel0_NS
#define GPDMA1_Channel0_BASE           GPDMA1_Channel0_BASE_NS

#define GPDMA1_Channel1                GPDMA1_Channel1_NS
#define GPDMA1_Channel1_BASE           GPDMA1_Channel1_BASE_NS

#define GPDMA1_Channel2                GPDMA1_Channel2_NS
#define GPDMA1_Channel2_BASE           GPDMA1_Channel2_BASE_NS

#define GPDMA1_Channel3                GPDMA1_Channel3_NS
#define GPDMA1_Channel3_BASE           GPDMA1_Channel3_BASE_NS

#define GPDMA1_Channel4                GPDMA1_Channel4_NS
#define GPDMA1_Channel4_BASE           GPDMA1_Channel4_BASE_NS

#define GPDMA1_Channel5                GPDMA1_Channel5_NS
#define GPDMA1_Channel5_BASE           GPDMA1_Channel5_BASE_NS

#define GPDMA1_Channel6                GPDMA1_Channel6_NS
#define GPDMA1_Channel6_BASE           GPDMA1_Channel6_BASE_NS

#define GPDMA1_Channel7                GPDMA1_Channel7_NS
#define GPDMA1_Channel7_BASE           GPDMA1_Channel7_BASE_NS

#define GPDMA2                         GPDMA2_NS
#define GPDMA2_BASE                    GPDMA2_BASE_NS

#define GPDMA2_Channel0                GPDMA2_Channel0_NS
#define GPDMA2_Channel0_BASE           GPDMA2_Channel0_BASE_NS

#define GPDMA2_Channel1                GPDMA2_Channel1_NS
#define GPDMA2_Channel1_BASE           GPDMA2_Channel1_BASE_NS

#define GPDMA2_Channel2                GPDMA2_Channel2_NS
#define GPDMA2_Channel2_BASE           GPDMA2_Channel2_BASE_NS

#define GPDMA2_Channel3                GPDMA2_Channel3_NS
#define GPDMA2_Channel3_BASE           GPDMA2_Channel3_BASE_NS

#define GPDMA2_Channel4                GPDMA2_Channel4_NS
#define GPDMA2_Channel4_BASE           GPDMA2_Channel4_BASE_NS

#define GPDMA2_Channel5                GPDMA2_Channel5_NS
#define GPDMA2_Channel5_BASE           GPDMA2_Channel5_BASE_NS

#define GPDMA2_Channel6                GPDMA2_Channel6_NS
#define GPDMA2_Channel6_BASE           GPDMA2_Channel6_BASE_NS

#define GPDMA2_Channel7                GPDMA2_Channel7_NS
#define GPDMA2_Channel7_BASE           GPDMA2_Channel7_BASE_NS

#define GPIOA                          GPIOA_NS
#define GPIOA_BASE                     GPIOA_BASE_NS

#define GPIOB                          GPIOB_NS
#define GPIOB_BASE                     GPIOB_BASE_NS

#define GPIOC                          GPIOC_NS
#define GPIOC_BASE                     GPIOC_BASE_NS

#define GPIOD                          GPIOD_NS
#define GPIOD_BASE                     GPIOD_BASE_NS

#define GPIOE                          GPIOE_NS
#define GPIOE_BASE                     GPIOE_BASE_NS

#define GPIOF                          GPIOF_NS
#define GPIOF_BASE                     GPIOF_BASE_NS

#define GPIOG                          GPIOG_NS
#define GPIOG_BASE                     GPIOG_BASE_NS

#define GPIOH                          GPIOH_NS
#define GPIOH_BASE                     GPIOH_BASE_NS

#define GPIOI                          GPIOI_NS
#define GPIOI_BASE                     GPIOI_BASE_NS

#define PWR                            PWR_NS
#define PWR_BASE                       PWR_BASE_NS

#define RAMCFG_SRAM1                   RAMCFG_SRAM1_NS
#define RAMCFG_SRAM1_BASE              RAMCFG_SRAM1_BASE_NS

#define RAMCFG_SRAM2                   RAMCFG_SRAM2_NS
#define RAMCFG_SRAM2_BASE              RAMCFG_SRAM2_BASE_NS

#define RAMCFG_SRAM3                   RAMCFG_SRAM3_NS
#define RAMCFG_SRAM3_BASE              RAMCFG_SRAM3_BASE_NS

#define RAMCFG_BKPRAM                  RAMCFG_BKPRAM_NS
#define RAMCFG_BKPRAM_BASE             RAMCFG_BKPRAM_BASE_NS

#define EXTI                           EXTI_NS
#define EXTI_BASE                      EXTI_BASE_NS

#define ICACHE                         ICACHE_NS
#define ICACHE_BASE                    ICACHE_BASE_NS

#define DCACHE1                        DCACHE1_NS
#define DCACHE1_BASE                   DCACHE1_BASE_NS

#define GTZC_TZSC1                     GTZC_TZSC1_NS
#define GTZC_TZSC1_BASE                GTZC_TZSC1_BASE_NS

#define GTZC_TZIC1                     GTZC_TZIC1_NS
#define GTZC_TZIC1_BASE                GTZC_TZIC1_BASE_NS

#define GTZC_MPCBB1                    GTZC_MPCBB1_NS
#define GTZC_MPCBB1_BASE               GTZC_MPCBB1_BASE_NS

#define GTZC_MPCBB2                    GTZC_MPCBB2_NS
#define GTZC_MPCBB2_BASE               GTZC_MPCBB2_BASE_NS

#define GTZC_MPCBB3                    GTZC_MPCBB3_NS
#define GTZC_MPCBB3_BASE               GTZC_MPCBB3_BASE_NS

#define RTC                            RTC_NS
#define RTC_BASE                       RTC_BASE_NS

#define TAMP                           TAMP_NS
#define TAMP_BASE                      TAMP_BASE_NS

#define TIM1                           TIM1_NS
#define TIM1_BASE                      TIM1_BASE_NS

#define TIM2                           TIM2_NS
#define TIM2_BASE                      TIM2_BASE_NS

#define TIM3                           TIM3_NS
#define TIM3_BASE                      TIM3_BASE_NS

#define TIM4                           TIM4_NS
#define TIM4_BASE                      TIM4_BASE_NS

#define TIM5                           TIM5_NS
#define TIM5_BASE                      TIM5_BASE_NS

#define TIM6                           TIM6_NS
#define TIM6_BASE                      TIM6_BASE_NS

#define TIM7                           TIM7_NS
#define TIM7_BASE                      TIM7_BASE_NS

#define TIM8                           TIM8_NS
#define TIM8_BASE                      TIM8_BASE_NS

#define TIM12                          TIM12_NS
#define TIM12_BASE                     TIM12_BASE_NS

#define TIM13                          TIM13_NS
#define TIM13_BASE                     TIM13_BASE_NS

#define TIM14                          TIM14_NS
#define TIM14_BASE                     TIM14_BASE_NS

#define TIM15                          TIM15_NS
#define TIM15_BASE                     TIM15_BASE_NS

#define TIM16                          TIM16_NS
#define TIM16_BASE                     TIM16_BASE_NS

#define TIM17                          TIM17_NS
#define TIM17_BASE                     TIM17_BASE_NS

#define WWDG                           WWDG_NS
#define WWDG_BASE                      WWDG_BASE_NS

#define IWDG                           IWDG_NS
#define IWDG_BASE                      IWDG_BASE_NS

#define SPI1                           SPI1_NS
#define SPI1_BASE                      SPI1_BASE_NS

#define SPI2                           SPI2_NS
#define SPI2_BASE                      SPI2_BASE_NS

#define SPI3                           SPI3_NS
#define SPI3_BASE                      SPI3_BASE_NS

#define SPI4                           SPI4_NS
#define SPI4_BASE                      SPI4_BASE_NS

#define SPI5                           SPI5_NS
#define SPI5_BASE                      SPI5_BASE_NS

#define SPI6                           SPI6_NS
#define SPI6_BASE                      SPI6_BASE_NS

#define USART1                         USART1_NS
#define USART1_BASE                    USART1_BASE_NS

#define USART2                         USART2_NS
#define USART2_BASE                    USART2_BASE_NS

#define USART3                         USART3_NS
#define USART3_BASE                    USART3_BASE_NS

#define UART4                          UART4_NS
#define UART4_BASE                     UART4_BASE_NS

#define UART5                          UART5_NS
#define UART5_BASE                     UART5_BASE_NS

#define USART6                         USART6_NS
#define USART6_BASE                    USART6_BASE_NS

#define UART7                          UART7_NS
#define UART7_BASE                     UART7_BASE_NS

#define UART8                          UART8_NS
#define UART8_BASE                     UART8_BASE_NS

#define UART9                          UART9_NS
#define UART9_BASE                     UART9_BASE_NS

#define USART10                        USART10_NS
#define USART10_BASE                   USART10_BASE_NS

#define USART11                        USART11_NS
#define USART11_BASE                   USART11_BASE_NS

#define UART12                         UART12_NS
#define UART12_BASE                    UART12_BASE_NS

#define CEC                            CEC_NS
#define CEC_BASE                       CEC_BASE_NS

#define I2C1                           I2C1_NS
#define I2C1_BASE                      I2C1_BASE_NS

#define I2C2                           I2C2_NS
#define I2C2_BASE                      I2C2_BASE_NS

#define I2C3                           I2C3_NS
#define I2C3_BASE                      I2C3_BASE_NS

#define I2C4                           I2C4_NS
#define I2C4_BASE                      I2C4_BASE_NS

#define I3C1                           I3C1_NS
#define I3C1_BASE                      I3C1_BASE_NS

#define CRS                            CRS_NS
#define CRS_BASE                       CRS_BASE_NS

#define FDCAN1                         FDCAN1_NS
#define FDCAN1_BASE                    FDCAN1_BASE_NS

#define FDCAN_CONFIG                   FDCAN_CONFIG_NS
#define FDCAN_CONFIG_BASE              FDCAN_CONFIG_BASE_NS
#define SRAMCAN_BASE                   SRAMCAN_BASE_NS

#define FDCAN2                         FDCAN2_NS
#define FDCAN2_BASE                    FDCAN2_BASE_NS

#define DAC1                           DAC1_NS
#define DAC1_BASE                      DAC1_BASE_NS

#define LPTIM1                         LPTIM1_NS
#define LPTIM1_BASE                    LPTIM1_BASE_NS

#define LPTIM2                         LPTIM2_NS
#define LPTIM2_BASE                    LPTIM2_BASE_NS

#define LPTIM3                         LPTIM3_NS
#define LPTIM3_BASE                    LPTIM3_BASE_NS

#define LPTIM4                         LPTIM4_NS
#define LPTIM4_BASE                    LPTIM4_BASE_NS

#define LPTIM5                         LPTIM5_NS
#define LPTIM5_BASE                    LPTIM5_BASE_NS

#define LPTIM6                         LPTIM6_NS
#define LPTIM6_BASE                    LPTIM6_BASE_NS

#define LPUART1                        LPUART1_NS
#define LPUART1_BASE                   LPUART1_BASE_NS

#define UCPD1                          UCPD1_NS
#define UCPD1_BASE                     UCPD1_BASE_NS

#define SBS                            SBS_NS
#define SBS_BASE                       SBS_BASE_NS

#define VREFBUF                        VREFBUF_NS
#define VREFBUF_BASE                   VREFBUF_BASE_NS

#define SAI1                           SAI1_NS
#define SAI1_BASE                      SAI1_BASE_NS

#define SAI1_Block_A                   SAI1_Block_A_NS
#define SAI1_Block_A_BASE              SAI1_Block_A_BASE_NS

#define SAI1_Block_B                   SAI1_Block_B_NS
#define SAI1_Block_B_BASE              SAI1_Block_B_BASE_NS

#define SAI2                           SAI2_NS
#define SAI2_BASE                      SAI2_BASE_NS

#define SAI2_Block_A                   SAI2_Block_A_NS
#define SAI2_Block_A_BASE              SAI2_Block_A_BASE_NS

#define SAI2_Block_B                   SAI2_Block_B_NS
#define SAI2_Block_B_BASE              SAI2_Block_B_BASE_NS

#define USB_DRD_FS                     USB_DRD_FS_NS
#define USB_DRD_BASE                   USB_DRD_BASE_NS
#define USB_DRD_PMAADDR                USB_DRD_PMAADDR_NS
#define USB_DRD_PMA_BUFF               USB_DRD_PMA_BUFF_NS

#define CRC                            CRC_NS
#define CRC_BASE                       CRC_BASE_NS

#define ADC1                           ADC1_NS
#define ADC1_BASE                      ADC1_BASE_NS

#define ADC2                           ADC2_NS
#define ADC2_BASE                      ADC2_BASE_NS

#define ADC12_COMMON                   ADC12_COMMON_NS
#define ADC12_COMMON_BASE              ADC12_COMMON_BASE_NS

#define HASH                           HASH_NS
#define HASH_BASE                      HASH_BASE_NS

#define HASH_DIGEST                    HASH_DIGEST_NS
#define HASH_DIGEST_BASE               HASH_DIGEST_BASE_NS

#define RNG                            RNG_NS
#define RNG_BASE                       RNG_BASE_NS

#define PKA                            PKA_NS
#define PKA_BASE                       PKA_BASE_NS
#define PKA_RAM_BASE                   PKA_RAM_BASE_NS


#define ETH                            ETH_NS
#define ETH_BASE                       ETH_BASE_NS
#define ETH_MAC                        ETH_MAC_NS
#define ETH_MAC_BASE                   ETH_MAC_BASE_NS

#define SDMMC1                         SDMMC1_NS
#define SDMMC1_BASE                    SDMMC1_BASE_NS

#define SDMMC2                         SDMMC2_NS
#define SDMMC2_BASE                    SDMMC2_BASE_NS

#define FMC_Bank1_R                    FMC_Bank1_R_NS
#define FMC_Bank1_R_BASE               FMC_Bank1_R_BASE_NS

#define FMC_Bank1E_R                   FMC_Bank1E_R_NS
#define FMC_Bank1E_R_BASE              FMC_Bank1E_R_BASE_NS

#define FMC_Bank3_R                    FMC_Bank3_R_NS
#define FMC_Bank3_R_BASE               FMC_Bank3_R_BASE_NS

#define FMC_Bank5_6_R                  FMC_Bank5_6_R_NS
#define FMC_Bank5_6_R_BASE             FMC_Bank5_6_R_BASE_NS

#define OCTOSPI1                       OCTOSPI1_NS
#define OCTOSPI1_R_BASE                OCTOSPI1_R_BASE_NS

#define DLYB_SDMMC1                    DLYB_SDMMC1_NS
#define DLYB_SDMMC1_BASE               DLYB_SDMMC1_BASE_NS

#define DLYB_SDMMC2                    DLYB_SDMMC2_NS
#define DLYB_SDMMC2_BASE               DLYB_SDMMC2_BASE_NS

#define DLYB_OCTOSPI1                  DLYB_OCTOSPI1_NS
#define DLYB_OCTOSPI1_BASE             DLYB_OCTOSPI1_BASE_NS

#endif


/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter                         */
/*                                                                            */
/******************************************************************************/
#define ADC_MULTIMODE_SUPPORT                          /*!< ADC feature available only on specific devices: multimode available on devices with several ADC instances */
/********************  Bit definition for ADC_ISR register  *******************/
#define ADC_ISR_ADRDY_Pos              (0U)
#define ADC_ISR_ADRDY_Msk              (0x1UL << ADC_ISR_ADRDY_Pos)            /*!< 0x00000001 */
#define ADC_ISR_ADRDY                  ADC_ISR_ADRDY_Msk                       /*!< ADC ready flag */
#define ADC_ISR_EOSMP_Pos              (1U)
#define ADC_ISR_EOSMP_Msk              (0x1UL << ADC_ISR_EOSMP_Pos)            /*!< 0x00000002 */
#define ADC_ISR_EOSMP                  ADC_ISR_EOSMP_Msk                       /*!< ADC group regular end of sampling flag */
#define ADC_ISR_EOC_Pos                (2U)
#define ADC_ISR_EOC_Msk                (0x1UL << ADC_ISR_EOC_Pos)              /*!< 0x00000004 */
#define ADC_ISR_EOC                    ADC_ISR_EOC_Msk                         /*!< ADC group regular end of unitary conversion flag */
#define ADC_ISR_EOS_Pos                (3U)
#define ADC_ISR_EOS_Msk                (0x1UL << ADC_ISR_EOS_Pos)              /*!< 0x00000008 */
#define ADC_ISR_EOS                    ADC_ISR_EOS_Msk                         /*!< ADC group regular end of sequence conversions flag */
#define ADC_ISR_OVR_Pos                (4U)
#define ADC_ISR_OVR_Msk                (0x1UL << ADC_ISR_OVR_Pos)              /*!< 0x00000010 */
#define ADC_ISR_OVR                    ADC_ISR_OVR_Msk                         /*!< ADC group regular overrun flag */
#define ADC_ISR_JEOC_Pos               (5U)
#define ADC_ISR_JEOC_Msk               (0x1UL << ADC_ISR_JEOC_Pos)             /*!< 0x00000020 */
#define ADC_ISR_JEOC                   ADC_ISR_JEOC_Msk                        /*!< ADC group injected end of unitary conversion flag */
#define ADC_ISR_JEOS_Pos               (6U)
#define ADC_ISR_JEOS_Msk               (0x1UL << ADC_ISR_JEOS_Pos)             /*!< 0x00000040 */
#define ADC_ISR_JEOS                   ADC_ISR_JEOS_Msk                        /*!< ADC group injected end of sequence conversions flag */
#define ADC_ISR_AWD1_Pos               (7U)
#define ADC_ISR_AWD1_Msk               (0x1UL << ADC_ISR_AWD1_Pos)             /*!< 0x00000080 */
#define ADC_ISR_AWD1                   ADC_ISR_AWD1_Msk                        /*!< ADC analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos               (8U)
#define ADC_ISR_AWD2_Msk               (0x1UL << ADC_ISR_AWD2_Pos)             /*!< 0x00000100 */
#define ADC_ISR_AWD2                   ADC_ISR_AWD2_Msk                        /*!< ADC analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos               (9U)
#define ADC_ISR_AWD3_Msk               (0x1UL << ADC_ISR_AWD3_Pos)             /*!< 0x00000200 */
#define ADC_ISR_AWD3                   ADC_ISR_AWD3_Msk                        /*!< ADC analog watchdog 3 flag */
#define ADC_ISR_JQOVF_Pos              (10U)
#define ADC_ISR_JQOVF_Msk              (0x1UL << ADC_ISR_JQOVF_Pos)            /*!< 0x00000400 */
#define ADC_ISR_JQOVF                  ADC_ISR_JQOVF_Msk                       /*!< ADC group injected contexts queue overflow flag */

/********************  Bit definition for ADC_IER register  *******************/
#define ADC_IER_ADRDYIE_Pos            (0U)
#define ADC_IER_ADRDYIE_Msk            (0x1UL << ADC_IER_ADRDYIE_Pos)          /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                ADC_IER_ADRDYIE_Msk                     /*!< ADC ready interrupt */
#define ADC_IER_EOSMPIE_Pos            (1U)
#define ADC_IER_EOSMPIE_Msk            (0x1UL << ADC_IER_EOSMPIE_Pos)          /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                ADC_IER_EOSMPIE_Msk                     /*!< ADC group regular end of sampling interrupt */
#define ADC_IER_EOCIE_Pos              (2U)
#define ADC_IER_EOCIE_Msk              (0x1UL << ADC_IER_EOCIE_Pos)            /*!< 0x00000004 */
#define ADC_IER_EOCIE                  ADC_IER_EOCIE_Msk                       /*!< ADC group regular end of unitary conversion interrupt */
#define ADC_IER_EOSIE_Pos              (3U)
#define ADC_IER_EOSIE_Msk              (0x1UL << ADC_IER_EOSIE_Pos)            /*!< 0x00000008 */
#define ADC_IER_EOSIE                  ADC_IER_EOSIE_Msk                       /*!< ADC group regular end of sequence conversions interrupt */
#define ADC_IER_OVRIE_Pos              (4U)
#define ADC_IER_OVRIE_Msk              (0x1UL << ADC_IER_OVRIE_Pos)            /*!< 0x00000010 */
#define ADC_IER_OVRIE                  ADC_IER_OVRIE_Msk                       /*!< ADC group regular overrun interrupt */
#define ADC_IER_JEOCIE_Pos             (5U)
#define ADC_IER_JEOCIE_Msk             (0x1UL << ADC_IER_JEOCIE_Pos)           /*!< 0x00000020 */
#define ADC_IER_JEOCIE                 ADC_IER_JEOCIE_Msk                      /*!< ADC group injected end of unitary conversion interrupt */
#define ADC_IER_JEOSIE_Pos             (6U)
#define ADC_IER_JEOSIE_Msk             (0x1UL << ADC_IER_JEOSIE_Pos)           /*!< 0x00000040 */
#define ADC_IER_JEOSIE                 ADC_IER_JEOSIE_Msk                      /*!< ADC group injected end of sequence conversions interrupt */
#define ADC_IER_AWD1IE_Pos             (7U)
#define ADC_IER_AWD1IE_Msk             (0x1UL << ADC_IER_AWD1IE_Pos)           /*!< 0x00000080 */
#define ADC_IER_AWD1IE                 ADC_IER_AWD1IE_Msk                      /*!< ADC analog watchdog 1 interrupt */
#define ADC_IER_AWD2IE_Pos             (8U)
#define ADC_IER_AWD2IE_Msk             (0x1UL << ADC_IER_AWD2IE_Pos)           /*!< 0x00000100 */
#define ADC_IER_AWD2IE                 ADC_IER_AWD2IE_Msk                      /*!< ADC analog watchdog 2 interrupt */
#define ADC_IER_AWD3IE_Pos             (9U)
#define ADC_IER_AWD3IE_Msk             (0x1UL << ADC_IER_AWD3IE_Pos)           /*!< 0x00000200 */
#define ADC_IER_AWD3IE                 ADC_IER_AWD3IE_Msk                      /*!< ADC analog watchdog 3 interrupt */
#define ADC_IER_JQOVFIE_Pos            (10U)
#define ADC_IER_JQOVFIE_Msk            (0x1UL << ADC_IER_JQOVFIE_Pos)          /*!< 0x00000400 */
#define ADC_IER_JQOVFIE                ADC_IER_JQOVFIE_Msk                     /*!< ADC group injected contexts queue overflow interrupt */

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                (0U)
#define ADC_CR_ADEN_Msk                (0x1UL << ADC_CR_ADEN_Pos)              /*!< 0x00000001 */
#define ADC_CR_ADEN                    ADC_CR_ADEN_Msk                         /*!< ADC enable */
#define ADC_CR_ADDIS_Pos               (1U)
#define ADC_CR_ADDIS_Msk               (0x1UL << ADC_CR_ADDIS_Pos)             /*!< 0x00000002 */
#define ADC_CR_ADDIS                   ADC_CR_ADDIS_Msk                        /*!< ADC disable */
#define ADC_CR_ADSTART_Pos             (2U)
#define ADC_CR_ADSTART_Msk             (0x1UL << ADC_CR_ADSTART_Pos)           /*!< 0x00000004 */
#define ADC_CR_ADSTART                 ADC_CR_ADSTART_Msk                      /*!< ADC group regular conversion start */
#define ADC_CR_JADSTART_Pos            (3U)
#define ADC_CR_JADSTART_Msk            (0x1UL << ADC_CR_JADSTART_Pos)          /*!< 0x00000008 */
#define ADC_CR_JADSTART                ADC_CR_JADSTART_Msk                     /*!< ADC group injected conversion start */
#define ADC_CR_ADSTP_Pos               (4U)
#define ADC_CR_ADSTP_Msk               (0x1UL << ADC_CR_ADSTP_Pos)             /*!< 0x00000010 */
#define ADC_CR_ADSTP                   ADC_CR_ADSTP_Msk                        /*!< ADC group regular conversion stop */
#define ADC_CR_JADSTP_Pos              (5U)
#define ADC_CR_JADSTP_Msk              (0x1UL << ADC_CR_JADSTP_Pos)            /*!< 0x00000020 */
#define ADC_CR_JADSTP                  ADC_CR_JADSTP_Msk                       /*!< ADC group injected conversion stop */
#define ADC_CR_ADVREGEN_Pos            (28U)
#define ADC_CR_ADVREGEN_Msk            (0x1UL << ADC_CR_ADVREGEN_Pos)          /*!< 0x10000000 */
#define ADC_CR_ADVREGEN                ADC_CR_ADVREGEN_Msk                     /*!< ADC voltage regulator enable */
#define ADC_CR_DEEPPWD_Pos             (29U)
#define ADC_CR_DEEPPWD_Msk             (0x1UL << ADC_CR_DEEPPWD_Pos)           /*!< 0x20000000 */
#define ADC_CR_DEEPPWD                 ADC_CR_DEEPPWD_Msk                      /*!< ADC deep power down enable */
#define ADC_CR_ADCALDIF_Pos            (30U)
#define ADC_CR_ADCALDIF_Msk            (0x1UL << ADC_CR_ADCALDIF_Pos)          /*!< 0x40000000 */
#define ADC_CR_ADCALDIF                ADC_CR_ADCALDIF_Msk                     /*!< ADC differential mode for calibration */
#define ADC_CR_ADCAL_Pos               (31U)
#define ADC_CR_ADCAL_Msk               (0x1UL << ADC_CR_ADCAL_Pos)             /*!< 0x80000000 */
#define ADC_CR_ADCAL                   ADC_CR_ADCAL_Msk                        /*!< ADC calibration */

/********************  Bit definition for ADC_CFGR register  ******************/
#define ADC_CFGR_DMAEN_Pos             (0U)
#define ADC_CFGR_DMAEN_Msk             (0x1UL << ADC_CFGR_DMAEN_Pos)           /*!< 0x00000001 */
#define ADC_CFGR_DMAEN                 ADC_CFGR_DMAEN_Msk                      /*!< ADC DMA transfer enable */
#define ADC_CFGR_DMACFG_Pos            (1U)
#define ADC_CFGR_DMACFG_Msk            (0x1UL << ADC_CFGR_DMACFG_Pos)          /*!< 0x00000002 */
#define ADC_CFGR_DMACFG                ADC_CFGR_DMACFG_Msk                     /*!< ADC DMA transfer configuration */

#define ADC_CFGR_RES_Pos               (3U)
#define ADC_CFGR_RES_Msk               (0x3UL << ADC_CFGR_RES_Pos)             /*!< 0x00000018 */
#define ADC_CFGR_RES                   ADC_CFGR_RES_Msk                        /*!< ADC data resolution */
#define ADC_CFGR_RES_0                 (0x1UL << ADC_CFGR_RES_Pos)             /*!< 0x00000008 */
#define ADC_CFGR_RES_1                 (0x2UL << ADC_CFGR_RES_Pos)             /*!< 0x00000010 */

#define ADC_CFGR_EXTSEL_Pos            (5U)
#define ADC_CFGR_EXTSEL_Msk            (0x1FUL << ADC_CFGR_EXTSEL_Pos)         /*!< 0x000003E0 */
#define ADC_CFGR_EXTSEL                ADC_CFGR_EXTSEL_Msk                     /*!< ADC group regular external trigger source */
#define ADC_CFGR_EXTSEL_0              (0x1UL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x00000020 */
#define ADC_CFGR_EXTSEL_1              (0x2UL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x00000040 */
#define ADC_CFGR_EXTSEL_2              (0x4UL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x00000080 */
#define ADC_CFGR_EXTSEL_3              (0x8UL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x00000100 */
#define ADC_CFGR_EXTSEL_4              (0x10UL << ADC_CFGR_EXTSEL_Pos)         /*!< 0x00000200 */

#define ADC_CFGR_EXTEN_Pos             (10U)
#define ADC_CFGR_EXTEN_Msk             (0x3UL << ADC_CFGR_EXTEN_Pos)           /*!< 0x00000C00 */
#define ADC_CFGR_EXTEN                 ADC_CFGR_EXTEN_Msk                      /*!< ADC group regular external trigger polarity */
#define ADC_CFGR_EXTEN_0               (0x1UL << ADC_CFGR_EXTEN_Pos)           /*!< 0x00000400 */
#define ADC_CFGR_EXTEN_1               (0x2UL << ADC_CFGR_EXTEN_Pos)           /*!< 0x00000800 */

#define ADC_CFGR_OVRMOD_Pos            (12U)
#define ADC_CFGR_OVRMOD_Msk            (0x1UL << ADC_CFGR_OVRMOD_Pos)          /*!< 0x00001000 */
#define ADC_CFGR_OVRMOD                ADC_CFGR_OVRMOD_Msk                     /*!< ADC group regular overrun configuration */
#define ADC_CFGR_CONT_Pos              (13U)
#define ADC_CFGR_CONT_Msk              (0x1UL << ADC_CFGR_CONT_Pos)            /*!< 0x00002000 */
#define ADC_CFGR_CONT                  ADC_CFGR_CONT_Msk                       /*!< ADC group regular continuous conversion mode */
#define ADC_CFGR_AUTDLY_Pos            (14U)
#define ADC_CFGR_AUTDLY_Msk            (0x1UL << ADC_CFGR_AUTDLY_Pos)          /*!< 0x00004000 */
#define ADC_CFGR_AUTDLY                ADC_CFGR_AUTDLY_Msk                     /*!< ADC low power auto wait */
#define ADC_CFGR_ALIGN_Pos             (15U)
#define ADC_CFGR_ALIGN_Msk             (0x1UL << ADC_CFGR_ALIGN_Pos)           /*!< 0x00008000 */
#define ADC_CFGR_ALIGN                 ADC_CFGR_ALIGN_Msk                      /*!< ADC data alignment */
#define ADC_CFGR_DISCEN_Pos            (16U)
#define ADC_CFGR_DISCEN_Msk            (0x1UL << ADC_CFGR_DISCEN_Pos)          /*!< 0x00010000 */
#define ADC_CFGR_DISCEN                ADC_CFGR_DISCEN_Msk                     /*!< ADC group regular sequencer discontinuous mode */

#define ADC_CFGR_DISCNUM_Pos           (17U)
#define ADC_CFGR_DISCNUM_Msk           (0x7UL << ADC_CFGR_DISCNUM_Pos)         /*!< 0x000E0000 */
#define ADC_CFGR_DISCNUM               ADC_CFGR_DISCNUM_Msk                    /*!< ADC group regular sequencer discontinuous number of ranks */
#define ADC_CFGR_DISCNUM_0             (0x1UL << ADC_CFGR_DISCNUM_Pos)         /*!< 0x00020000 */
#define ADC_CFGR_DISCNUM_1             (0x2UL << ADC_CFGR_DISCNUM_Pos)         /*!< 0x00040000 */
#define ADC_CFGR_DISCNUM_2             (0x4UL << ADC_CFGR_DISCNUM_Pos)         /*!< 0x00080000 */

#define ADC_CFGR_JDISCEN_Pos           (20U)
#define ADC_CFGR_JDISCEN_Msk           (0x1UL << ADC_CFGR_JDISCEN_Pos)         /*!< 0x00100000 */
#define ADC_CFGR_JDISCEN               ADC_CFGR_JDISCEN_Msk                    /*!< ADC group injected sequencer discontinuous mode */
#define ADC_CFGR_JQM_Pos               (21U)
#define ADC_CFGR_JQM_Msk               (0x1UL << ADC_CFGR_JQM_Pos)             /*!< 0x00200000 */
#define ADC_CFGR_JQM                   ADC_CFGR_JQM_Msk                        /*!< ADC group injected contexts queue mode */
#define ADC_CFGR_AWD1SGL_Pos           (22U)
#define ADC_CFGR_AWD1SGL_Msk           (0x1UL << ADC_CFGR_AWD1SGL_Pos)         /*!< 0x00400000 */
#define ADC_CFGR_AWD1SGL               ADC_CFGR_AWD1SGL_Msk                    /*!< ADC analog watchdog 1 monitoring a single channel or all channels */
#define ADC_CFGR_AWD1EN_Pos            (23U)
#define ADC_CFGR_AWD1EN_Msk            (0x1UL << ADC_CFGR_AWD1EN_Pos)          /*!< 0x00800000 */
#define ADC_CFGR_AWD1EN                ADC_CFGR_AWD1EN_Msk                     /*!< ADC analog watchdog 1 enable on scope ADC group regular */
#define ADC_CFGR_JAWD1EN_Pos           (24U)
#define ADC_CFGR_JAWD1EN_Msk           (0x1UL << ADC_CFGR_JAWD1EN_Pos)         /*!< 0x01000000 */
#define ADC_CFGR_JAWD1EN               ADC_CFGR_JAWD1EN_Msk                    /*!< ADC analog watchdog 1 enable on scope ADC group injected */
#define ADC_CFGR_JAUTO_Pos             (25U)
#define ADC_CFGR_JAUTO_Msk             (0x1UL << ADC_CFGR_JAUTO_Pos)           /*!< 0x02000000 */
#define ADC_CFGR_JAUTO                 ADC_CFGR_JAUTO_Msk                      /*!< ADC group injected automatic trigger mode */

#define ADC_CFGR_AWD1CH_Pos            (26U)
#define ADC_CFGR_AWD1CH_Msk            (0x1FUL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x7C000000 */
#define ADC_CFGR_AWD1CH                ADC_CFGR_AWD1CH_Msk                     /*!< ADC analog watchdog 1 monitored channel selection */
#define ADC_CFGR_AWD1CH_0              (0x01UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x04000000 */
#define ADC_CFGR_AWD1CH_1              (0x02UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x08000000 */
#define ADC_CFGR_AWD1CH_2              (0x04UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x10000000 */
#define ADC_CFGR_AWD1CH_3              (0x08UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x20000000 */
#define ADC_CFGR_AWD1CH_4              (0x10UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x40000000 */

#define ADC_CFGR_JQDIS_Pos             (31U)
#define ADC_CFGR_JQDIS_Msk             (0x1UL << ADC_CFGR_JQDIS_Pos)           /*!< 0x80000000 */
#define ADC_CFGR_JQDIS                 ADC_CFGR_JQDIS_Msk                      /*!< ADC group injected contexts queue disable */

/********************  Bit definition for ADC_CFGR2 register  *****************/
#define ADC_CFGR2_ROVSE_Pos            (0U)
#define ADC_CFGR2_ROVSE_Msk            (0x1UL << ADC_CFGR2_ROVSE_Pos)          /*!< 0x00000001 */
#define ADC_CFGR2_ROVSE                ADC_CFGR2_ROVSE_Msk                     /*!< ADC oversampler enable on scope ADC group regular */
#define ADC_CFGR2_JOVSE_Pos            (1U)
#define ADC_CFGR2_JOVSE_Msk            (0x1UL << ADC_CFGR2_JOVSE_Pos)          /*!< 0x00000002 */
#define ADC_CFGR2_JOVSE                ADC_CFGR2_JOVSE_Msk                     /*!< ADC oversampler enable on scope ADC group injected */

#define ADC_CFGR2_OVSR_Pos             (2U)
#define ADC_CFGR2_OVSR_Msk             (0x7UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x0000001C */
#define ADC_CFGR2_OVSR                 ADC_CFGR2_OVSR_Msk                      /*!< ADC oversampling ratio */
#define ADC_CFGR2_OVSR_0               (0x1UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000004 */
#define ADC_CFGR2_OVSR_1               (0x2UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000008 */
#define ADC_CFGR2_OVSR_2               (0x4UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000010 */

#define ADC_CFGR2_OVSS_Pos             (5U)
#define ADC_CFGR2_OVSS_Msk             (0xFUL << ADC_CFGR2_OVSS_Pos)           /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                 ADC_CFGR2_OVSS_Msk                      /*!< ADC oversampling shift */
#define ADC_CFGR2_OVSS_0               (0x1UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1               (0x2UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2               (0x4UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3               (0x8UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000100 */

#define ADC_CFGR2_TROVS_Pos            (9U)
#define ADC_CFGR2_TROVS_Msk            (0x1UL << ADC_CFGR2_TROVS_Pos)          /*!< 0x00000200 */
#define ADC_CFGR2_TROVS                ADC_CFGR2_TROVS_Msk                     /*!< ADC oversampling discontinuous mode (triggered mode) for ADC group regular */
#define ADC_CFGR2_ROVSM_Pos            (10U)
#define ADC_CFGR2_ROVSM_Msk            (0x1UL << ADC_CFGR2_ROVSM_Pos)          /*!< 0x00000400 */
#define ADC_CFGR2_ROVSM                ADC_CFGR2_ROVSM_Msk                     /*!< ADC oversampling mode managing interlaced conversions of ADC group regular and group injected */

#define ADC_CFGR2_GCOMP_Pos            (16U)
#define ADC_CFGR2_GCOMP_Msk            (0x1UL << ADC_CFGR2_GCOMP_Pos)          /*!< 0x00010000 */
#define ADC_CFGR2_GCOMP                ADC_CFGR2_GCOMP_Msk                     /*!< ADC Gain Compensation mode */

#define ADC_CFGR2_SWTRIG_Pos           (25U)
#define ADC_CFGR2_SWTRIG_Msk           (0x1UL << ADC_CFGR2_SWTRIG_Pos)         /*!< 0x02000000 */
#define ADC_CFGR2_SWTRIG               ADC_CFGR2_SWTRIG_Msk                    /*!< ADC Software Trigger Bit for Sample time control trigger mode */
#define ADC_CFGR2_BULB_Pos             (26U)
#define ADC_CFGR2_BULB_Msk             (0x1UL << ADC_CFGR2_BULB_Pos)           /*!< 0x04000000 */
#define ADC_CFGR2_BULB                 ADC_CFGR2_BULB_Msk                      /*!< ADC Bulb sampling mode */
#define ADC_CFGR2_SMPTRIG_Pos          (27U)
#define ADC_CFGR2_SMPTRIG_Msk          (0x1UL << ADC_CFGR2_SMPTRIG_Pos)        /*!< 0x08000000 */
#define ADC_CFGR2_SMPTRIG              ADC_CFGR2_SMPTRIG_Msk                   /*!< ADC Sample Time Control Trigger mode */

#define ADC_CFGR2_LFTRIG_Pos           (29U)
#define ADC_CFGR2_LFTRIG_Msk           (0x1UL << ADC_CFGR2_LFTRIG_Pos)         /*!< 0x20000000 */
#define ADC_CFGR2_LFTRIG               ADC_CFGR2_LFTRIG_Msk                    /*!< ADC Low Frequency Trigger */

/********************  Bit definition for ADC_SMPR1 register  *****************/
#define ADC_SMPR1_SMP0_Pos             (0U)
#define ADC_SMPR1_SMP0_Msk             (0x7UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                 ADC_SMPR1_SMP0_Msk                      /*!< ADC channel 0 sampling time selection  */
#define ADC_SMPR1_SMP0_0               (0x1UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1               (0x2UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2               (0x4UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos             (3U)
#define ADC_SMPR1_SMP1_Msk             (0x7UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                 ADC_SMPR1_SMP1_Msk                      /*!< ADC channel 1 sampling time selection  */
#define ADC_SMPR1_SMP1_0               (0x1UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1               (0x2UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2               (0x4UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos             (6U)
#define ADC_SMPR1_SMP2_Msk             (0x7UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                 ADC_SMPR1_SMP2_Msk                      /*!< ADC channel 2 sampling time selection  */
#define ADC_SMPR1_SMP2_0               (0x1UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1               (0x2UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2               (0x4UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos             (9U)
#define ADC_SMPR1_SMP3_Msk             (0x7UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                 ADC_SMPR1_SMP3_Msk                      /*!< ADC channel 3 sampling time selection  */
#define ADC_SMPR1_SMP3_0               (0x1UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1               (0x2UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2               (0x4UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos             (12U)
#define ADC_SMPR1_SMP4_Msk             (0x7UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                 ADC_SMPR1_SMP4_Msk                      /*!< ADC channel 4 sampling time selection  */
#define ADC_SMPR1_SMP4_0               (0x1UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1               (0x2UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2               (0x4UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos             (15U)
#define ADC_SMPR1_SMP5_Msk             (0x7UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                 ADC_SMPR1_SMP5_Msk                      /*!< ADC channel 5 sampling time selection  */
#define ADC_SMPR1_SMP5_0               (0x1UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1               (0x2UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2               (0x4UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos             (18U)
#define ADC_SMPR1_SMP6_Msk             (0x7UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                 ADC_SMPR1_SMP6_Msk                      /*!< ADC channel 6 sampling time selection  */
#define ADC_SMPR1_SMP6_0               (0x1UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1               (0x2UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2               (0x4UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos             (21U)
#define ADC_SMPR1_SMP7_Msk             (0x7UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                 ADC_SMPR1_SMP7_Msk                      /*!< ADC channel 7 sampling time selection  */
#define ADC_SMPR1_SMP7_0               (0x1UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1               (0x2UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2               (0x4UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos             (24U)
#define ADC_SMPR1_SMP8_Msk             (0x7UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                 ADC_SMPR1_SMP8_Msk                      /*!< ADC channel 8 sampling time selection  */
#define ADC_SMPR1_SMP8_0               (0x1UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1               (0x2UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2               (0x4UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos             (27U)
#define ADC_SMPR1_SMP9_Msk             (0x7UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                 ADC_SMPR1_SMP9_Msk                      /*!< ADC channel 9 sampling time selection  */
#define ADC_SMPR1_SMP9_0               (0x1UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1               (0x2UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2               (0x4UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x20000000 */

#define ADC_SMPR1_SMPPLUS_Pos          (31U)
#define ADC_SMPR1_SMPPLUS_Msk          (0x1UL << ADC_SMPR1_SMPPLUS_Pos)        /*!< 0x80000000 */
#define ADC_SMPR1_SMPPLUS              ADC_SMPR1_SMPPLUS_Msk                   /*!< ADC channels sampling time additional setting */

/********************  Bit definition for ADC_SMPR2 register  *****************/
#define ADC_SMPR2_SMP10_Pos            (0U)
#define ADC_SMPR2_SMP10_Msk            (0x7UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                ADC_SMPR2_SMP10_Msk                     /*!< ADC channel 10 sampling time selection  */
#define ADC_SMPR2_SMP10_0              (0x1UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1              (0x2UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2              (0x4UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos            (3U)
#define ADC_SMPR2_SMP11_Msk            (0x7UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                ADC_SMPR2_SMP11_Msk                     /*!< ADC channel 11 sampling time selection  */
#define ADC_SMPR2_SMP11_0              (0x1UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1              (0x2UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2              (0x4UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos            (6U)
#define ADC_SMPR2_SMP12_Msk            (0x7UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                ADC_SMPR2_SMP12_Msk                     /*!< ADC channel 12 sampling time selection  */
#define ADC_SMPR2_SMP12_0              (0x1UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1              (0x2UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2              (0x4UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos            (9U)
#define ADC_SMPR2_SMP13_Msk            (0x7UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                ADC_SMPR2_SMP13_Msk                     /*!< ADC channel 13 sampling time selection  */
#define ADC_SMPR2_SMP13_0              (0x1UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1              (0x2UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2              (0x4UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos            (12U)
#define ADC_SMPR2_SMP14_Msk            (0x7UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                ADC_SMPR2_SMP14_Msk                     /*!< ADC channel 14 sampling time selection  */
#define ADC_SMPR2_SMP14_0              (0x1UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1              (0x2UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2              (0x4UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos            (15U)
#define ADC_SMPR2_SMP15_Msk            (0x7UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                ADC_SMPR2_SMP15_Msk                     /*!< ADC channel 15 sampling time selection  */
#define ADC_SMPR2_SMP15_0              (0x1UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1              (0x2UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2              (0x4UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos            (18U)
#define ADC_SMPR2_SMP16_Msk            (0x7UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                ADC_SMPR2_SMP16_Msk                     /*!< ADC channel 16 sampling time selection  */
#define ADC_SMPR2_SMP16_0              (0x1UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1              (0x2UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2              (0x4UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos            (21U)
#define ADC_SMPR2_SMP17_Msk            (0x7UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                ADC_SMPR2_SMP17_Msk                     /*!< ADC channel 17 sampling time selection  */
#define ADC_SMPR2_SMP17_0              (0x1UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1              (0x2UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2              (0x4UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos            (24U)
#define ADC_SMPR2_SMP18_Msk            (0x7UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                ADC_SMPR2_SMP18_Msk                     /*!< ADC channel 18 sampling time selection  */
#define ADC_SMPR2_SMP18_0              (0x1UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1              (0x2UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2              (0x4UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x04000000 */

/********************  Bit definition for ADC_TR1 register  *******************/
#define ADC_TR1_LT1_Pos                (0U)
#define ADC_TR1_LT1_Msk                (0xFFFUL << ADC_TR1_LT1_Pos)            /*!< 0x00000FFF */
#define ADC_TR1_LT1                    ADC_TR1_LT1_Msk                         /*!< ADC analog watchdog 1 threshold low */

#define ADC_TR1_AWDFILT_Pos            (12U)
#define ADC_TR1_AWDFILT_Msk            (0x7UL << ADC_TR1_AWDFILT_Pos)          /*!< 0x00007000 */
#define ADC_TR1_AWDFILT                ADC_TR1_AWDFILT_Msk                     /*!< ADC analog watchdog filtering parameter  */
#define ADC_TR1_AWDFILT_0              (0x1UL << ADC_TR1_AWDFILT_Pos)          /*!< 0x00001000 */
#define ADC_TR1_AWDFILT_1              (0x2UL << ADC_TR1_AWDFILT_Pos)          /*!< 0x00002000 */
#define ADC_TR1_AWDFILT_2              (0x4UL << ADC_TR1_AWDFILT_Pos)          /*!< 0x00004000 */

#define ADC_TR1_HT1_Pos                (16U)
#define ADC_TR1_HT1_Msk                (0xFFFUL << ADC_TR1_HT1_Pos)            /*!< 0x0FFF0000 */
#define ADC_TR1_HT1                    ADC_TR1_HT1_Msk                         /*!< ADC analog watchdog 1 threshold high */

/********************  Bit definition for ADC_TR2 register  *******************/
#define ADC_TR2_LT2_Pos                (0U)
#define ADC_TR2_LT2_Msk                (0xFFUL << ADC_TR2_LT2_Pos)             /*!< 0x000000FF */
#define ADC_TR2_LT2                    ADC_TR2_LT2_Msk                         /*!< ADC analog watchdog 2 threshold low */

#define ADC_TR2_HT2_Pos                (16U)
#define ADC_TR2_HT2_Msk                (0xFFUL << ADC_TR2_HT2_Pos)             /*!< 0x00FF0000 */
#define ADC_TR2_HT2                    ADC_TR2_HT2_Msk                         /*!< ADC analog watchdog 2 threshold high */

/********************  Bit definition for ADC_TR3 register  *******************/
#define ADC_TR3_LT3_Pos                (0U)
#define ADC_TR3_LT3_Msk                (0xFFUL << ADC_TR3_LT3_Pos)             /*!< 0x000000FF */
#define ADC_TR3_LT3                    ADC_TR3_LT3_Msk                         /*!< ADC analog watchdog 3 threshold low */

#define ADC_TR3_HT3_Pos                (16U)
#define ADC_TR3_HT3_Msk                (0xFFUL << ADC_TR3_HT3_Pos)             /*!< 0x00FF0000 */
#define ADC_TR3_HT3                    ADC_TR3_HT3_Msk                         /*!< ADC analog watchdog 3 threshold high */

/********************  Bit definition for ADC_SQR1 register  ******************/
#define ADC_SQR1_L_Pos                 (0U)
#define ADC_SQR1_L_Msk                 (0xFUL << ADC_SQR1_L_Pos)               /*!< 0x0000000F */
#define ADC_SQR1_L                     ADC_SQR1_L_Msk                          /*!< ADC group regular sequencer scan length */
#define ADC_SQR1_L_0                   (0x1UL << ADC_SQR1_L_Pos)               /*!< 0x00000001 */
#define ADC_SQR1_L_1                   (0x2UL << ADC_SQR1_L_Pos)               /*!< 0x00000002 */
#define ADC_SQR1_L_2                   (0x4UL << ADC_SQR1_L_Pos)               /*!< 0x00000004 */
#define ADC_SQR1_L_3                   (0x8UL << ADC_SQR1_L_Pos)               /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos               (6U)
#define ADC_SQR1_SQ1_Msk               (0x1FUL << ADC_SQR1_SQ1_Pos)            /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                   ADC_SQR1_SQ1_Msk                        /*!< ADC group regular sequencer rank 1 */
#define ADC_SQR1_SQ1_0                 (0x01UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                 (0x02UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                 (0x04UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                 (0x08UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                 (0x10UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos               (12U)
#define ADC_SQR1_SQ2_Msk               (0x1FUL << ADC_SQR1_SQ2_Pos)            /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                   ADC_SQR1_SQ2_Msk                        /*!< ADC group regular sequencer rank 2 */
#define ADC_SQR1_SQ2_0                 (0x01UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                 (0x02UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                 (0x04UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                 (0x08UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                 (0x10UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos               (18U)
#define ADC_SQR1_SQ3_Msk               (0x1FUL << ADC_SQR1_SQ3_Pos)            /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                   ADC_SQR1_SQ3_Msk                        /*!< ADC group regular sequencer rank 3 */
#define ADC_SQR1_SQ3_0                 (0x01UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                 (0x02UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                 (0x04UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                 (0x08UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                 (0x10UL<< ADC_SQR1_SQ3_Pos)             /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos               (24U)
#define ADC_SQR1_SQ4_Msk               (0x1FUL << ADC_SQR1_SQ4_Pos)            /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                   ADC_SQR1_SQ4_Msk                        /*!< ADC group regular sequencer rank 4 */
#define ADC_SQR1_SQ4_0                 (0x01UL << ADC_SQR1_SQ4_Pos)            /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                 (0x02UL << ADC_SQR1_SQ4_Pos)            /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                 (0x04UL << ADC_SQR1_SQ4_Pos)            /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                 (0x08UL << ADC_SQR1_SQ4_Pos)            /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                 (0x10UL << ADC_SQR1_SQ4_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ******************/
#define ADC_SQR2_SQ5_Pos               (0U)
#define ADC_SQR2_SQ5_Msk               (0x1FUL << ADC_SQR2_SQ5_Pos)            /*!< 0x0000001F */
#define ADC_SQR2_SQ5                   ADC_SQR2_SQ5_Msk                        /*!< ADC group regular sequencer rank 5 */
#define ADC_SQR2_SQ5_0                 (0x01UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                 (0x02UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                 (0x04UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                 (0x08UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                 (0x10UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos               (6U)
#define ADC_SQR2_SQ6_Msk               (0x1FUL << ADC_SQR2_SQ6_Pos)            /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                   ADC_SQR2_SQ6_Msk                        /*!< ADC group regular sequencer rank 6 */
#define ADC_SQR2_SQ6_0                 (0x01UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                 (0x02UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                 (0x04UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                 (0x08UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                 (0x10UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos               (12U)
#define ADC_SQR2_SQ7_Msk               (0x1FUL << ADC_SQR2_SQ7_Pos)            /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                   ADC_SQR2_SQ7_Msk                        /*!< ADC group regular sequencer rank 7 */
#define ADC_SQR2_SQ7_0                 (0x01UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                 (0x02UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                 (0x04UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                 (0x08UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                 (0x10UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos               (18U)
#define ADC_SQR2_SQ8_Msk               (0x1FUL << ADC_SQR2_SQ8_Pos)            /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                   ADC_SQR2_SQ8_Msk                        /*!< ADC group regular sequencer rank 8 */
#define ADC_SQR2_SQ8_0                 (0x01UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                 (0x02UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                 (0x04UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                 (0x08UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                 (0x10UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos               (24U)
#define ADC_SQR2_SQ9_Msk               (0x1FUL << ADC_SQR2_SQ9_Pos)            /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                   ADC_SQR2_SQ9_Msk                        /*!< ADC group regular sequencer rank 9 */
#define ADC_SQR2_SQ9_0                 (0x01UL << ADC_SQR2_SQ9_Pos)            /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                 (0x02UL << ADC_SQR2_SQ9_Pos)            /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                 (0x04UL << ADC_SQR2_SQ9_Pos)            /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                 (0x08UL << ADC_SQR2_SQ9_Pos)            /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                 (0x10UL << ADC_SQR2_SQ9_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ******************/
#define ADC_SQR3_SQ10_Pos              (0U)
#define ADC_SQR3_SQ10_Msk              (0x1FUL << ADC_SQR3_SQ10_Pos)           /*!< 0x0000001F */
#define ADC_SQR3_SQ10                  ADC_SQR3_SQ10_Msk                       /*!< ADC group regular sequencer rank 10 */
#define ADC_SQR3_SQ10_0                (0x01UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                (0x02UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                (0x04UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                (0x08UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                (0x10UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos              (6U)
#define ADC_SQR3_SQ11_Msk              (0x1FUL << ADC_SQR3_SQ11_Pos)           /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                  ADC_SQR3_SQ11_Msk                       /*!< ADC group regular sequencer rank 11 */
#define ADC_SQR3_SQ11_0                (0x01UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                (0x02UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                (0x04UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                (0x08UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                (0x10UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos              (12U)
#define ADC_SQR3_SQ12_Msk              (0x1FUL << ADC_SQR3_SQ12_Pos)           /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                  ADC_SQR3_SQ12_Msk                       /*!< ADC group regular sequencer rank 12 */
#define ADC_SQR3_SQ12_0                (0x01UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                (0x02UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                (0x04UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                (0x08UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                (0x10UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos              (18U)
#define ADC_SQR3_SQ13_Msk              (0x1FUL << ADC_SQR3_SQ13_Pos)           /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                  ADC_SQR3_SQ13_Msk                       /*!< ADC group regular sequencer rank 13 */
#define ADC_SQR3_SQ13_0                (0x01UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                (0x02UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                (0x04UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                (0x08UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                (0x10UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos              (24U)
#define ADC_SQR3_SQ14_Msk              (0x1FUL << ADC_SQR3_SQ14_Pos)           /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                  ADC_SQR3_SQ14_Msk                       /*!< ADC group regular sequencer rank 14 */
#define ADC_SQR3_SQ14_0                (0x01UL << ADC_SQR3_SQ14_Pos)           /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                (0x02UL << ADC_SQR3_SQ14_Pos)           /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                (0x04UL << ADC_SQR3_SQ14_Pos)           /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                (0x08UL << ADC_SQR3_SQ14_Pos)           /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                (0x10UL << ADC_SQR3_SQ14_Pos)           /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ******************/
#define ADC_SQR4_SQ15_Pos              (0U)
#define ADC_SQR4_SQ15_Msk              (0x1FUL << ADC_SQR4_SQ15_Pos)           /*!< 0x0000001F */
#define ADC_SQR4_SQ15                  ADC_SQR4_SQ15_Msk                       /*!< ADC group regular sequencer rank 15 */
#define ADC_SQR4_SQ15_0                (0x01UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                (0x02UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                (0x04UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                (0x08UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                (0x10UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos              (6U)
#define ADC_SQR4_SQ16_Msk              (0x1FUL << ADC_SQR4_SQ16_Pos)           /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                  ADC_SQR4_SQ16_Msk                       /*!< ADC group regular sequencer rank 16 */
#define ADC_SQR4_SQ16_0                (0x01UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                (0x02UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                (0x04UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                (0x08UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                (0x10UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000400 */

/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos               (0U)
#define ADC_DR_RDATA_Msk               (0xFFFFUL << ADC_DR_RDATA_Pos)          /*!< 0x0000FFFF */
#define ADC_DR_RDATA                   ADC_DR_RDATA_Msk                        /*!< ADC group regular conversion data */

/********************  Bit definition for ADC_JSQR register  ******************/
#define ADC_JSQR_JL_Pos                (0U)
#define ADC_JSQR_JL_Msk                (0x3UL << ADC_JSQR_JL_Pos)              /*!< 0x00000003 */
#define ADC_JSQR_JL                    ADC_JSQR_JL_Msk                         /*!< ADC group injected sequencer scan length */
#define ADC_JSQR_JL_0                  (0x1UL << ADC_JSQR_JL_Pos)              /*!< 0x00000001 */
#define ADC_JSQR_JL_1                  (0x2UL << ADC_JSQR_JL_Pos)              /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos           (2U)
#define ADC_JSQR_JEXTSEL_Msk           (0x1FUL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x0000007C */
#define ADC_JSQR_JEXTSEL               ADC_JSQR_JEXTSEL_Msk                    /*!< ADC group injected external trigger source */
#define ADC_JSQR_JEXTSEL_0             (0x1UL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1             (0x2UL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2             (0x4UL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3             (0x8UL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x00000020 */
#define ADC_JSQR_JEXTSEL_4             (0x10UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000040 */

#define ADC_JSQR_JEXTEN_Pos            (7U)
#define ADC_JSQR_JEXTEN_Msk            (0x3UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000180 */
#define ADC_JSQR_JEXTEN                ADC_JSQR_JEXTEN_Msk                     /*!< ADC group injected external trigger polarity */
#define ADC_JSQR_JEXTEN_0              (0x1UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000080 */
#define ADC_JSQR_JEXTEN_1              (0x2UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000100 */

#define ADC_JSQR_JSQ1_Pos              (9U)
#define ADC_JSQR_JSQ1_Msk              (0x1FUL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00003E00 */
#define ADC_JSQR_JSQ1                  ADC_JSQR_JSQ1_Msk                       /*!< ADC group injected sequencer rank 1 */
#define ADC_JSQR_JSQ1_0                (0x01UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_1                (0x02UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_2                (0x04UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_3                (0x08UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00001000 */
#define ADC_JSQR_JSQ1_4                (0x10UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00002000 */

#define ADC_JSQR_JSQ2_Pos              (15U)
#define ADC_JSQR_JSQ2_Msk              (0x1FUL << ADC_JSQR_JSQ2_Pos)           /*!< 0x0007C000 */
#define ADC_JSQR_JSQ2                  ADC_JSQR_JSQ2_Msk                       /*!< ADC group injected sequencer rank 2 */
#define ADC_JSQR_JSQ2_0                (0x01UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00004000 */
#define ADC_JSQR_JSQ2_1                (0x02UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_2                (0x04UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_3                (0x08UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_4                (0x10UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00040000 */

#define ADC_JSQR_JSQ3_Pos              (21U)
#define ADC_JSQR_JSQ3_Msk              (0x1FUL << ADC_JSQR_JSQ3_Pos)           /*!< 0x03E00000 */
#define ADC_JSQR_JSQ3                  ADC_JSQR_JSQ3_Msk                       /*!< ADC group injected sequencer rank 3 */
#define ADC_JSQR_JSQ3_0                (0x01UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_1                (0x02UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_2                (0x04UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_3                (0x08UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x01000000 */
#define ADC_JSQR_JSQ3_4                (0x10UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x02000000 */

#define ADC_JSQR_JSQ4_Pos              (27U)
#define ADC_JSQR_JSQ4_Msk              (0x1FUL << ADC_JSQR_JSQ4_Pos)           /*!< 0xF8000000 */
#define ADC_JSQR_JSQ4                  ADC_JSQR_JSQ4_Msk                       /*!< ADC group injected sequencer rank 4 */
#define ADC_JSQR_JSQ4_0                (0x01UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_1                (0x02UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_2                (0x04UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_3                (0x08UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x40000000 */
#define ADC_JSQR_JSQ4_4                (0x10UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x80000000 */

/********************  Bit definition for ADC_OFR1 register  ******************/
#define ADC_OFR1_OFFSET1_Pos           (0U)
#define ADC_OFR1_OFFSET1_Msk           (0xFFFUL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000FFF */
#define ADC_OFR1_OFFSET1               ADC_OFR1_OFFSET1_Msk                    /*!< ADC offset number 1 offset level */

#define ADC_OFR1_OFFSETPOS_Pos         (24U)
#define ADC_OFR1_OFFSETPOS_Msk         (0x1UL << ADC_OFR1_OFFSETPOS_Pos)       /*!< 0x01000000 */
#define ADC_OFR1_OFFSETPOS             ADC_OFR1_OFFSETPOS_Msk                  /*!< ADC offset number 1 positive */
#define ADC_OFR1_SATEN_Pos             (25U)
#define ADC_OFR1_SATEN_Msk             (0x1UL << ADC_OFR1_SATEN_Pos)           /*!< 0x02000000 */
#define ADC_OFR1_SATEN                 ADC_OFR1_SATEN_Msk                      /*!< ADC offset number 1 saturation enable */

#define ADC_OFR1_OFFSET1_CH_Pos        (26U)
#define ADC_OFR1_OFFSET1_CH_Msk        (0x1FUL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x7C000000 */
#define ADC_OFR1_OFFSET1_CH            ADC_OFR1_OFFSET1_CH_Msk                 /*!< ADC offset number 1 channel selection */
#define ADC_OFR1_OFFSET1_CH_0          (0x01UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x04000000 */
#define ADC_OFR1_OFFSET1_CH_1          (0x02UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x08000000 */
#define ADC_OFR1_OFFSET1_CH_2          (0x04UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x10000000 */
#define ADC_OFR1_OFFSET1_CH_3          (0x08UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x20000000 */
#define ADC_OFR1_OFFSET1_CH_4          (0x10UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x40000000 */

#define ADC_OFR1_OFFSET1_EN_Pos        (31U)
#define ADC_OFR1_OFFSET1_EN_Msk        (0x1UL << ADC_OFR1_OFFSET1_EN_Pos)      /*!< 0x80000000 */
#define ADC_OFR1_OFFSET1_EN            ADC_OFR1_OFFSET1_EN_Msk                 /*!< ADC offset number 1 enable */

/********************  Bit definition for ADC_OFR2 register  ******************/
#define ADC_OFR2_OFFSET2_Pos           (0U)
#define ADC_OFR2_OFFSET2_Msk           (0xFFFUL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000FFF */
#define ADC_OFR2_OFFSET2               ADC_OFR2_OFFSET2_Msk                    /*!< ADC offset number 2 offset level */

#define ADC_OFR2_OFFSETPOS_Pos         (24U)
#define ADC_OFR2_OFFSETPOS_Msk         (0x1UL << ADC_OFR2_OFFSETPOS_Pos)       /*!< 0x01000000 */
#define ADC_OFR2_OFFSETPOS             ADC_OFR2_OFFSETPOS_Msk                  /*!< ADC offset number 2 positive */
#define ADC_OFR2_SATEN_Pos             (25U)
#define ADC_OFR2_SATEN_Msk             (0x1UL << ADC_OFR2_SATEN_Pos)           /*!< 0x02000000 */
#define ADC_OFR2_SATEN                 ADC_OFR2_SATEN_Msk                      /*!< ADC offset number 2 saturation enable */

#define ADC_OFR2_OFFSET2_CH_Pos        (26U)
#define ADC_OFR2_OFFSET2_CH_Msk        (0x1FUL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x7C000000 */
#define ADC_OFR2_OFFSET2_CH            ADC_OFR2_OFFSET2_CH_Msk                 /*!< ADC offset number 2 channel selection */
#define ADC_OFR2_OFFSET2_CH_0          (0x01UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x04000000 */
#define ADC_OFR2_OFFSET2_CH_1          (0x02UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x08000000 */
#define ADC_OFR2_OFFSET2_CH_2          (0x04UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x10000000 */
#define ADC_OFR2_OFFSET2_CH_3          (0x08UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x20000000 */
#define ADC_OFR2_OFFSET2_CH_4          (0x10UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x40000000 */

#define ADC_OFR2_OFFSET2_EN_Pos        (31U)
#define ADC_OFR2_OFFSET2_EN_Msk        (0x1UL << ADC_OFR2_OFFSET2_EN_Pos)      /*!< 0x80000000 */
#define ADC_OFR2_OFFSET2_EN            ADC_OFR2_OFFSET2_EN_Msk                 /*!< ADC offset number 2 enable */

/********************  Bit definition for ADC_OFR3 register  ******************/
#define ADC_OFR3_OFFSET3_Pos           (0U)
#define ADC_OFR3_OFFSET3_Msk           (0xFFFUL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000FFF */
#define ADC_OFR3_OFFSET3               ADC_OFR3_OFFSET3_Msk                    /*!< ADC offset number 3 offset level */

#define ADC_OFR3_OFFSETPOS_Pos         (24U)
#define ADC_OFR3_OFFSETPOS_Msk         (0x1UL << ADC_OFR3_OFFSETPOS_Pos)       /*!< 0x01000000 */
#define ADC_OFR3_OFFSETPOS             ADC_OFR3_OFFSETPOS_Msk                  /*!< ADC offset number 3 positive */
#define ADC_OFR3_SATEN_Pos             (25U)
#define ADC_OFR3_SATEN_Msk             (0x1UL << ADC_OFR3_SATEN_Pos)           /*!< 0x02000000 */
#define ADC_OFR3_SATEN                 ADC_OFR3_SATEN_Msk                      /*!< ADC offset number 3 saturation enable */

#define ADC_OFR3_OFFSET3_CH_Pos        (26U)
#define ADC_OFR3_OFFSET3_CH_Msk        (0x1FUL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x7C000000 */
#define ADC_OFR3_OFFSET3_CH            ADC_OFR3_OFFSET3_CH_Msk                 /*!< ADC offset number 3 channel selection */
#define ADC_OFR3_OFFSET3_CH_0          (0x01UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x04000000 */
#define ADC_OFR3_OFFSET3_CH_1          (0x02UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x08000000 */
#define ADC_OFR3_OFFSET3_CH_2          (0x04UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x10000000 */
#define ADC_OFR3_OFFSET3_CH_3          (0x08UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x20000000 */
#define ADC_OFR3_OFFSET3_CH_4          (0x10UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x40000000 */

#define ADC_OFR3_OFFSET3_EN_Pos        (31U)
#define ADC_OFR3_OFFSET3_EN_Msk        (0x1UL << ADC_OFR3_OFFSET3_EN_Pos)      /*!< 0x80000000 */
#define ADC_OFR3_OFFSET3_EN            ADC_OFR3_OFFSET3_EN_Msk                 /*!< ADC offset number 3 enable */

/********************  Bit definition for ADC_OFR4 register  ******************/
#define ADC_OFR4_OFFSET4_Pos           (0U)
#define ADC_OFR4_OFFSET4_Msk           (0xFFFUL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000FFF */
#define ADC_OFR4_OFFSET4               ADC_OFR4_OFFSET4_Msk                    /*!< ADC offset number 4 offset level */

#define ADC_OFR4_OFFSETPOS_Pos         (24U)
#define ADC_OFR4_OFFSETPOS_Msk         (0x1UL << ADC_OFR4_OFFSETPOS_Pos)       /*!< 0x01000000 */
#define ADC_OFR4_OFFSETPOS             ADC_OFR4_OFFSETPOS_Msk                  /*!< ADC offset number 4 positive */
#define ADC_OFR4_SATEN_Pos             (25U)
#define ADC_OFR4_SATEN_Msk             (0x1UL << ADC_OFR4_SATEN_Pos)           /*!< 0x02000000 */
#define ADC_OFR4_SATEN                 ADC_OFR4_SATEN_Msk                      /*!< ADC offset number 4 saturation enable */

#define ADC_OFR4_OFFSET4_CH_Pos        (26U)
#define ADC_OFR4_OFFSET4_CH_Msk        (0x1FUL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x7C000000 */
#define ADC_OFR4_OFFSET4_CH            ADC_OFR4_OFFSET4_CH_Msk                 /*!< ADC offset number 4 channel selection */
#define ADC_OFR4_OFFSET4_CH_0          (0x01UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x04000000 */
#define ADC_OFR4_OFFSET4_CH_1          (0x02UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x08000000 */
#define ADC_OFR4_OFFSET4_CH_2          (0x04UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x10000000 */
#define ADC_OFR4_OFFSET4_CH_3          (0x08UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x20000000 */
#define ADC_OFR4_OFFSET4_CH_4          (0x10UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x40000000 */

#define ADC_OFR4_OFFSET4_EN_Pos        (31U)
#define ADC_OFR4_OFFSET4_EN_Msk        (0x1UL << ADC_OFR4_OFFSET4_EN_Pos)      /*!< 0x80000000 */
#define ADC_OFR4_OFFSET4_EN            ADC_OFR4_OFFSET4_EN_Msk                 /*!< ADC offset number 4 enable */

/********************  Bit definition for ADC_JDR1 register  ******************/
#define ADC_JDR1_JDATA_Pos             (0U)
#define ADC_JDR1_JDATA_Msk             (0xFFFFUL << ADC_JDR1_JDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_JDR1_JDATA                 ADC_JDR1_JDATA_Msk                      /*!< ADC group injected sequencer rank 1 conversion data */

/********************  Bit definition for ADC_JDR2 register  ******************/
#define ADC_JDR2_JDATA_Pos             (0U)
#define ADC_JDR2_JDATA_Msk             (0xFFFFUL << ADC_JDR2_JDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_JDR2_JDATA                 ADC_JDR2_JDATA_Msk                      /*!< ADC group injected sequencer rank 2 conversion data */

/********************  Bit definition for ADC_JDR3 register  ******************/
#define ADC_JDR3_JDATA_Pos             (0U)
#define ADC_JDR3_JDATA_Msk             (0xFFFFUL << ADC_JDR3_JDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_JDR3_JDATA                 ADC_JDR3_JDATA_Msk                      /*!< ADC group injected sequencer rank 3 conversion data */

/********************  Bit definition for ADC_JDR4 register  ******************/
#define ADC_JDR4_JDATA_Pos             (0U)
#define ADC_JDR4_JDATA_Msk             (0xFFFFUL << ADC_JDR4_JDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_JDR4_JDATA                 ADC_JDR4_JDATA_Msk                      /*!< ADC group injected sequencer rank 4 conversion data */

/********************  Bit definition for ADC_AWD2CR register  ****************/
#define ADC_AWD2CR_AWD2CH_Pos          (0U)
#define ADC_AWD2CR_AWD2CH_Msk          (0xFFFFFUL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x0007FFFF */
#define ADC_AWD2CR_AWD2CH              ADC_AWD2CR_AWD2CH_Msk                   /*!< ADC analog watchdog 2 monitored channel selection */
#define ADC_AWD2CR_AWD2CH_0            (0x00001UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1            (0x00002UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2            (0x00004UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3            (0x00008UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4            (0x00010UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5            (0x00020UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6            (0x00040UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7            (0x00080UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8            (0x00100UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9            (0x00200UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10           (0x00400UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11           (0x00800UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12           (0x01000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13           (0x02000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14           (0x04000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15           (0x08000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16           (0x10000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17           (0x20000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18           (0x40000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00040000 */
#define ADC_AWD2CR_AWD2CH_19           (0x80000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_AWD3CR register  ****************/
#define ADC_AWD3CR_AWD3CH_Pos          (0U)
#define ADC_AWD3CR_AWD3CH_Msk          (0xFFFFFUL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x0007FFFF */
#define ADC_AWD3CR_AWD3CH              ADC_AWD3CR_AWD3CH_Msk                   /*!< ADC analog watchdog 3 monitored channel selection */
#define ADC_AWD3CR_AWD3CH_0            (0x00001UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1            (0x00002UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2            (0x00004UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3            (0x00008UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4            (0x00010UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5            (0x00020UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6            (0x00040UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7            (0x00080UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8            (0x00100UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9            (0x00200UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10           (0x00400UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11           (0x00800UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12           (0x01000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13           (0x02000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14           (0x04000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15           (0x08000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16           (0x10000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17           (0x20000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18           (0x40000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00040000 */
#define ADC_AWD3CR_AWD3CH_19           (0x80000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_DIFSEL register  ****************/
#define ADC_DIFSEL_DIFSEL_Pos          (0U)
#define ADC_DIFSEL_DIFSEL_Msk          (0xFFFFFUL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x0007FFFF */
#define ADC_DIFSEL_DIFSEL              ADC_DIFSEL_DIFSEL_Msk                   /*!< ADC channel differential or single-ended mode */
#define ADC_DIFSEL_DIFSEL_0            (0x00001UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1            (0x00002UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2            (0x00004UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3            (0x00008UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4            (0x00010UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5            (0x00020UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6            (0x00040UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7            (0x00080UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8            (0x00100UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9            (0x00200UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10           (0x00400UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11           (0x00800UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12           (0x01000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13           (0x02000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14           (0x04000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15           (0x08000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16           (0x10000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17           (0x20000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18           (0x40000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00040000 */
#define ADC_DIFSEL_DIFSEL_19           (0x80000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_CALFACT register  ***************/
#define ADC_CALFACT_CALFACT_S_Pos      (0U)
#define ADC_CALFACT_CALFACT_S_Msk      (0x7FUL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x0000007F */
#define ADC_CALFACT_CALFACT_S          ADC_CALFACT_CALFACT_S_Msk               /*!< ADC calibration factor in single-ended mode */
#define ADC_CALFACT_CALFACT_S_0        (0x01UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_S_1        (0x02UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_S_2        (0x04UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_S_3        (0x08UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_S_4        (0x10UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_S_5        (0x20UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_S_6        (0x40UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000030 */

#define ADC_CALFACT_CALFACT_D_Pos      (16U)
#define ADC_CALFACT_CALFACT_D_Msk      (0x7FUL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x007F0000 */
#define ADC_CALFACT_CALFACT_D          ADC_CALFACT_CALFACT_D_Msk               /*!< ADC calibration factor in differential mode */
#define ADC_CALFACT_CALFACT_D_0        (0x01UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00010000 */
#define ADC_CALFACT_CALFACT_D_1        (0x02UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00020000 */
#define ADC_CALFACT_CALFACT_D_2        (0x04UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00040000 */
#define ADC_CALFACT_CALFACT_D_3        (0x08UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00080000 */
#define ADC_CALFACT_CALFACT_D_4        (0x10UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00100000 */
#define ADC_CALFACT_CALFACT_D_5        (0x20UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00200000 */
#define ADC_CALFACT_CALFACT_D_6        (0x40UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00300000 */

/********************  Bit definition for ADC_OR register  *****************/
#define ADC_OR_OP0_Pos       (0U)
#define ADC_OR_OP0_Msk       (0x01UL << ADC_OR_OP0_Pos)                        /*!< 0x00000001 */
#define ADC_OR_OP0           ADC_OR_OP0_Msk                                    /*!< ADC Option bit 0 */
#define ADC_OR_OP1_Pos       (1U)
#define ADC_OR_OP1_Msk       (0x01UL << ADC_OR_OP1_Pos)                        /*!< 0x00000001 */
#define ADC_OR_OP1           ADC_OR_OP1_Msk                                    /*!< ADC Option bit 1 */

/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CSR register  *******************/
#define ADC_CSR_ADRDY_MST_Pos          (0U)
#define ADC_CSR_ADRDY_MST_Msk          (0x1UL << ADC_CSR_ADRDY_MST_Pos)        /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST              ADC_CSR_ADRDY_MST_Msk                   /*!< ADC multimode master ready flag */
#define ADC_CSR_EOSMP_MST_Pos          (1U)
#define ADC_CSR_EOSMP_MST_Msk          (0x1UL << ADC_CSR_EOSMP_MST_Pos)        /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST              ADC_CSR_EOSMP_MST_Msk                   /*!< ADC multimode master group regular end of sampling flag */
#define ADC_CSR_EOC_MST_Pos            (2U)
#define ADC_CSR_EOC_MST_Msk            (0x1UL << ADC_CSR_EOC_MST_Pos)          /*!< 0x00000004 */
#define ADC_CSR_EOC_MST                ADC_CSR_EOC_MST_Msk                     /*!< ADC multimode master group regular end of unitary conversion flag */
#define ADC_CSR_EOS_MST_Pos            (3U)
#define ADC_CSR_EOS_MST_Msk            (0x1UL << ADC_CSR_EOS_MST_Pos)          /*!< 0x00000008 */
#define ADC_CSR_EOS_MST                ADC_CSR_EOS_MST_Msk                     /*!< ADC multimode master group regular end of sequence conversions flag */
#define ADC_CSR_OVR_MST_Pos            (4U)
#define ADC_CSR_OVR_MST_Msk            (0x1UL << ADC_CSR_OVR_MST_Pos)          /*!< 0x00000010 */
#define ADC_CSR_OVR_MST                ADC_CSR_OVR_MST_Msk                     /*!< ADC multimode master group regular overrun flag */
#define ADC_CSR_JEOC_MST_Pos           (5U)
#define ADC_CSR_JEOC_MST_Msk           (0x1UL << ADC_CSR_JEOC_MST_Pos)         /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST               ADC_CSR_JEOC_MST_Msk                    /*!< ADC multimode master group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_MST_Pos           (6U)
#define ADC_CSR_JEOS_MST_Msk           (0x1UL << ADC_CSR_JEOS_MST_Pos)         /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST               ADC_CSR_JEOS_MST_Msk                    /*!< ADC multimode master group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_MST_Pos           (7U)
#define ADC_CSR_AWD1_MST_Msk           (0x1UL << ADC_CSR_AWD1_MST_Pos)         /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST               ADC_CSR_AWD1_MST_Msk                    /*!< ADC multimode master analog watchdog 1 flag */
#define ADC_CSR_AWD2_MST_Pos           (8U)
#define ADC_CSR_AWD2_MST_Msk           (0x1UL << ADC_CSR_AWD2_MST_Pos)         /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST               ADC_CSR_AWD2_MST_Msk                    /*!< ADC multimode master analog watchdog 2 flag */
#define ADC_CSR_AWD3_MST_Pos           (9U)
#define ADC_CSR_AWD3_MST_Msk           (0x1UL << ADC_CSR_AWD3_MST_Pos)         /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST               ADC_CSR_AWD3_MST_Msk                    /*!< ADC multimode master analog watchdog 3 flag */
#define ADC_CSR_JQOVF_MST_Pos          (10U)
#define ADC_CSR_JQOVF_MST_Msk          (0x1UL << ADC_CSR_JQOVF_MST_Pos)        /*!< 0x00000400 */
#define ADC_CSR_JQOVF_MST              ADC_CSR_JQOVF_MST_Msk                   /*!< ADC multimode master group injected contexts queue overflow flag */

#define ADC_CSR_ADRDY_SLV_Pos          (16U)
#define ADC_CSR_ADRDY_SLV_Msk          (0x1UL << ADC_CSR_ADRDY_SLV_Pos)        /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV              ADC_CSR_ADRDY_SLV_Msk                   /*!< ADC multimode slave ready flag */
#define ADC_CSR_EOSMP_SLV_Pos          (17U)
#define ADC_CSR_EOSMP_SLV_Msk          (0x1UL << ADC_CSR_EOSMP_SLV_Pos)        /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV              ADC_CSR_EOSMP_SLV_Msk                   /*!< ADC multimode slave group regular end of sampling flag */
#define ADC_CSR_EOC_SLV_Pos            (18U)
#define ADC_CSR_EOC_SLV_Msk            (0x1UL << ADC_CSR_EOC_SLV_Pos)          /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV                ADC_CSR_EOC_SLV_Msk                     /*!< ADC multimode slave group regular end of unitary conversion flag */
#define ADC_CSR_EOS_SLV_Pos            (19U)
#define ADC_CSR_EOS_SLV_Msk            (0x1UL << ADC_CSR_EOS_SLV_Pos)          /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV                ADC_CSR_EOS_SLV_Msk                     /*!< ADC multimode slave group regular end of sequence conversions flag */
#define ADC_CSR_OVR_SLV_Pos            (20U)
#define ADC_CSR_OVR_SLV_Msk            (0x1UL << ADC_CSR_OVR_SLV_Pos)          /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV                ADC_CSR_OVR_SLV_Msk                     /*!< ADC multimode slave group regular overrun flag */
#define ADC_CSR_JEOC_SLV_Pos           (21U)
#define ADC_CSR_JEOC_SLV_Msk           (0x1UL << ADC_CSR_JEOC_SLV_Pos)         /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV               ADC_CSR_JEOC_SLV_Msk                    /*!< ADC multimode slave group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_SLV_Pos           (22U)
#define ADC_CSR_JEOS_SLV_Msk           (0x1UL << ADC_CSR_JEOS_SLV_Pos)         /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV               ADC_CSR_JEOS_SLV_Msk                    /*!< ADC multimode slave group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_SLV_Pos           (23U)
#define ADC_CSR_AWD1_SLV_Msk           (0x1UL << ADC_CSR_AWD1_SLV_Pos)         /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV               ADC_CSR_AWD1_SLV_Msk                    /*!< ADC multimode slave analog watchdog 1 flag */
#define ADC_CSR_AWD2_SLV_Pos           (24U)
#define ADC_CSR_AWD2_SLV_Msk           (0x1UL << ADC_CSR_AWD2_SLV_Pos)         /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV               ADC_CSR_AWD2_SLV_Msk                    /*!< ADC multimode slave analog watchdog 2 flag */
#define ADC_CSR_AWD3_SLV_Pos           (25U)
#define ADC_CSR_AWD3_SLV_Msk           (0x1UL << ADC_CSR_AWD3_SLV_Pos)         /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV               ADC_CSR_AWD3_SLV_Msk                    /*!< ADC multimode slave analog watchdog 3 flag */
#define ADC_CSR_JQOVF_SLV_Pos          (26U)
#define ADC_CSR_JQOVF_SLV_Msk          (0x1UL << ADC_CSR_JQOVF_SLV_Pos)        /*!< 0x04000000 */
#define ADC_CSR_JQOVF_SLV              ADC_CSR_JQOVF_SLV_Msk                   /*!< ADC multimode slave group injected contexts queue overflow flag */

/********************  Bit definition for ADC_CCR register  *******************/
#define ADC_CCR_DUAL_Pos               (0U)
#define ADC_CCR_DUAL_Msk               (0x1FUL << ADC_CCR_DUAL_Pos)            /*!< 0x0000001F */
#define ADC_CCR_DUAL                   ADC_CCR_DUAL_Msk                        /*!< ADC multimode mode selection */
#define ADC_CCR_DUAL_0                 (0x01UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                 (0x02UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                 (0x04UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                 (0x08UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                 (0x10UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos              (8U)
#define ADC_CCR_DELAY_Msk              (0xFUL << ADC_CCR_DELAY_Pos)            /*!< 0x00000F00 */
#define ADC_CCR_DELAY                  ADC_CCR_DELAY_Msk                       /*!< ADC multimode delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                (0x1UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                (0x2UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                (0x4UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                (0x8UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000800 */

#define ADC_CCR_DMACFG_Pos             (13U)
#define ADC_CCR_DMACFG_Msk             (0x1UL << ADC_CCR_DMACFG_Pos)           /*!< 0x00002000 */
#define ADC_CCR_DMACFG                 ADC_CCR_DMACFG_Msk                      /*!< ADC multimode DMA transfer configuration */

#define ADC_CCR_MDMA_Pos               (14U)
#define ADC_CCR_MDMA_Msk               (0x3UL << ADC_CCR_MDMA_Pos)             /*!< 0x0000C000 */
#define ADC_CCR_MDMA                   ADC_CCR_MDMA_Msk                        /*!< ADC multimode DMA transfer enable */
#define ADC_CCR_MDMA_0                 (0x1UL << ADC_CCR_MDMA_Pos)             /*!< 0x00004000 */
#define ADC_CCR_MDMA_1                 (0x2UL << ADC_CCR_MDMA_Pos)             /*!< 0x00008000 */

#define ADC_CCR_CKMODE_Pos             (16U)
#define ADC_CCR_CKMODE_Msk             (0x3UL << ADC_CCR_CKMODE_Pos)           /*!< 0x00030000 */
#define ADC_CCR_CKMODE                 ADC_CCR_CKMODE_Msk                      /*!< ADC common clock source and prescaler (prescaler only for clock source synchronous) */
#define ADC_CCR_CKMODE_0               (0x1UL << ADC_CCR_CKMODE_Pos)           /*!< 0x00010000 */
#define ADC_CCR_CKMODE_1               (0x2UL << ADC_CCR_CKMODE_Pos)           /*!< 0x00020000 */

#define ADC_CCR_PRESC_Pos              (18U)
#define ADC_CCR_PRESC_Msk              (0xFUL << ADC_CCR_PRESC_Pos)            /*!< 0x003C0000 */
#define ADC_CCR_PRESC                  ADC_CCR_PRESC_Msk                       /*!< ADC common clock prescaler, only for clock source asynchronous */
#define ADC_CCR_PRESC_0                (0x1UL << ADC_CCR_PRESC_Pos)            /*!< 0x00040000 */
#define ADC_CCR_PRESC_1                (0x2UL << ADC_CCR_PRESC_Pos)            /*!< 0x00080000 */
#define ADC_CCR_PRESC_2                (0x4UL << ADC_CCR_PRESC_Pos)            /*!< 0x00100000 */
#define ADC_CCR_PRESC_3                (0x8UL << ADC_CCR_PRESC_Pos)            /*!< 0x00200000 */

#define ADC_CCR_VREFEN_Pos             (22U)
#define ADC_CCR_VREFEN_Msk             (0x1UL << ADC_CCR_VREFEN_Pos)           /*!< 0x00400000 */
#define ADC_CCR_VREFEN                 ADC_CCR_VREFEN_Msk                      /*!< ADC internal path to VrefInt enable */
#define ADC_CCR_TSEN_Pos               (23U)
#define ADC_CCR_TSEN_Msk               (0x1UL << ADC_CCR_TSEN_Pos)             /*!< 0x00800000 */
#define ADC_CCR_TSEN                   ADC_CCR_TSEN_Msk                        /*!< ADC internal path to temperature sensor enable */
#define ADC_CCR_VBATEN_Pos             (24U)
#define ADC_CCR_VBATEN_Msk             (0x1UL << ADC_CCR_VBATEN_Pos)           /*!< 0x01000000 */
#define ADC_CCR_VBATEN                 ADC_CCR_VBATEN_Msk                      /*!< ADC internal path to battery voltage enable */

/********************  Bit definition for ADC_CDR register  *******************/
#define ADC_CDR_RDATA_MST_Pos          (0U)
#define ADC_CDR_RDATA_MST_Msk          (0xFFFFUL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST              ADC_CDR_RDATA_MST_Msk                   /*!< ADC multimode master group regular conversion data */

#define ADC_CDR_RDATA_SLV_Pos          (16U)
#define ADC_CDR_RDATA_SLV_Msk          (0xFFFFUL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV              ADC_CDR_RDATA_SLV_Msk                   /*!< ADC multimode slave group regular conversion data */

/******************************************************************************/
/*                                                                            */
/*                          CORDIC calculation unit                           */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CORDIC_CSR register  *****************/
#define CORDIC_CSR_FUNC_Pos                 (0U)
#define CORDIC_CSR_FUNC_Msk                 (0xFUL << CORDIC_CSR_FUNC_Pos)          /*!< 0x0000000F */
#define CORDIC_CSR_FUNC                     CORDIC_CSR_FUNC_Msk                     /*!< Function */
#define CORDIC_CSR_FUNC_0                   (0x1UL << CORDIC_CSR_FUNC_Pos)          /*!< 0x00000001 */
#define CORDIC_CSR_FUNC_1                   (0x2UL << CORDIC_CSR_FUNC_Pos)          /*!< 0x00000002 */
#define CORDIC_CSR_FUNC_2                   (0x4UL << CORDIC_CSR_FUNC_Pos)          /*!< 0x00000004 */
#define CORDIC_CSR_FUNC_3                   (0x8UL << CORDIC_CSR_FUNC_Pos)          /*!< 0x00000008 */
#define CORDIC_CSR_PRECISION_Pos            (4U)
#define CORDIC_CSR_PRECISION_Msk            (0xFUL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x000000F0 */
#define CORDIC_CSR_PRECISION                CORDIC_CSR_PRECISION_Msk                /*!< Precision */
#define CORDIC_CSR_PRECISION_0              (0x1UL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x00000010 */
#define CORDIC_CSR_PRECISION_1              (0x2UL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x00000020 */
#define CORDIC_CSR_PRECISION_2              (0x4UL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x00000040 */
#define CORDIC_CSR_PRECISION_3              (0x8UL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x00000080 */
#define CORDIC_CSR_SCALE_Pos                (8U)
#define CORDIC_CSR_SCALE_Msk                (0x7UL << CORDIC_CSR_SCALE_Pos)         /*!< 0x00000700 */
#define CORDIC_CSR_SCALE                    CORDIC_CSR_SCALE_Msk                    /*!< Scaling factor */
#define CORDIC_CSR_SCALE_0                  (0x1UL << CORDIC_CSR_SCALE_Pos)         /*!< 0x00000100 */
#define CORDIC_CSR_SCALE_1                  (0x2UL << CORDIC_CSR_SCALE_Pos)         /*!< 0x00000200 */
#define CORDIC_CSR_SCALE_2                  (0x4UL << CORDIC_CSR_SCALE_Pos)         /*!< 0x00000400 */
#define CORDIC_CSR_IEN_Pos                  (16U)
#define CORDIC_CSR_IEN_Msk                  (0x1UL << CORDIC_CSR_IEN_Pos)           /*!< 0x00010000 */
#define CORDIC_CSR_IEN                      CORDIC_CSR_IEN_Msk                      /*!< Interrupt Enable */
#define CORDIC_CSR_DMAREN_Pos               (17U)
#define CORDIC_CSR_DMAREN_Msk               (0x1UL << CORDIC_CSR_DMAREN_Pos)        /*!< 0x00020000 */
#define CORDIC_CSR_DMAREN                   CORDIC_CSR_DMAREN_Msk                   /*!< DMA Read channel Enable */
#define CORDIC_CSR_DMAWEN_Pos               (18U)
#define CORDIC_CSR_DMAWEN_Msk               (0x1UL << CORDIC_CSR_DMAWEN_Pos)        /*!< 0x00040000 */
#define CORDIC_CSR_DMAWEN                   CORDIC_CSR_DMAWEN_Msk                   /*!< DMA Write channel Enable */
#define CORDIC_CSR_NRES_Pos                 (19U)
#define CORDIC_CSR_NRES_Msk                 (0x1UL << CORDIC_CSR_NRES_Pos)          /*!< 0x00080000 */
#define CORDIC_CSR_NRES                     CORDIC_CSR_NRES_Msk                     /*!< Number of results in WDATA register */
#define CORDIC_CSR_NARGS_Pos                (20U)
#define CORDIC_CSR_NARGS_Msk                (0x1UL << CORDIC_CSR_NARGS_Pos)         /*!< 0x00100000 */
#define CORDIC_CSR_NARGS                    CORDIC_CSR_NARGS_Msk                    /*!< Number of arguments in RDATA register */
#define CORDIC_CSR_RESSIZE_Pos              (21U)
#define CORDIC_CSR_RESSIZE_Msk              (0x1UL << CORDIC_CSR_RESSIZE_Pos)       /*!< 0x00200000 */
#define CORDIC_CSR_RESSIZE                  CORDIC_CSR_RESSIZE_Msk                  /*!< Width of output data */
#define CORDIC_CSR_ARGSIZE_Pos              (22U)
#define CORDIC_CSR_ARGSIZE_Msk              (0x1UL << CORDIC_CSR_ARGSIZE_Pos)       /*!< 0x00400000 */
#define CORDIC_CSR_ARGSIZE                  CORDIC_CSR_ARGSIZE_Msk                  /*!< Width of input data */
#define CORDIC_CSR_RRDY_Pos                 (31U)
#define CORDIC_CSR_RRDY_Msk                 (0x1UL << CORDIC_CSR_RRDY_Pos)          /*!< 0x80000000 */
#define CORDIC_CSR_RRDY                     CORDIC_CSR_RRDY_Msk                     /*!< Result Ready Flag */

/*******************  Bit definition for CORDIC_WDATA register  ***************/
#define CORDIC_WDATA_ARG_Pos                (0U)
#define CORDIC_WDATA_ARG_Msk                (0xFFFFFFFFUL << CORDIC_WDATA_ARG_Pos)  /*!< 0xFFFFFFFF */
#define CORDIC_WDATA_ARG                    CORDIC_WDATA_ARG_Msk                    /*!< Input Argument */

/*******************  Bit definition for CORDIC_RDATA register  ***************/
#define CORDIC_RDATA_RES_Pos                (0U)
#define CORDIC_RDATA_RES_Msk                (0xFFFFFFFFUL << CORDIC_RDATA_RES_Pos)  /*!< 0xFFFFFFFF */
#define CORDIC_RDATA_RES                    CORDIC_RDATA_RES_Msk                    /*!< Output Result */

/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos                       (0U)
#define CRC_DR_DR_Msk                       (0xFFFFFFFFUL << CRC_DR_DR_Pos)         /*!< 0xFFFFFFFF */
#define CRC_DR_DR                           CRC_DR_DR_Msk                           /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos                     (0U)
#define CRC_IDR_IDR_Msk                     (0xFFFFFFFFUL << CRC_IDR_IDR_Pos)       /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR                         CRC_IDR_IDR_Msk                         /*!< General-purpose 32-bits data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos                    (0U)
#define CRC_CR_RESET_Msk                    (0x1UL << CRC_CR_RESET_Pos)             /*!< 0x00000001 */
#define CRC_CR_RESET                        CRC_CR_RESET_Msk                        /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos                 (3U)
#define CRC_CR_POLYSIZE_Msk                 (0x3UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000018 */
#define CRC_CR_POLYSIZE                     CRC_CR_POLYSIZE_Msk                     /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0                   (0x1UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1                   (0x2UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos                   (5U)
#define CRC_CR_REV_IN_Msk                   (0x3UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000060 */
#define CRC_CR_REV_IN                       CRC_CR_REV_IN_Msk                       /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0                     (0x1UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000020 */
#define CRC_CR_REV_IN_1                     (0x2UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos                  (7U)
#define CRC_CR_REV_OUT_Msk                  (0x1UL << CRC_CR_REV_OUT_Pos)           /*!< 0x00000080 */
#define CRC_CR_REV_OUT                      CRC_CR_REV_OUT_Msk                      /*!< REV_OUT Reverse Output Data bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos                   (0U)
#define CRC_INIT_INIT_Msk                   (0xFFFFFFFFUL << CRC_INIT_INIT_Pos)     /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT                       CRC_INIT_INIT_Msk                       /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos                     (0U)
#define CRC_POL_POL_Msk                     (0xFFFFFFFFUL << CRC_POL_POL_Pos)       /*!< 0xFFFFFFFF */
#define CRC_POL_POL                         CRC_POL_POL_Msk                         /*!< Coefficients of the polynomial */


/******************************************************************************/
/*                                                                            */
/*                          CRS Clock Recovery System                         */
/******************************************************************************/
/*******************  Bit definition for CRS_CR register  *********************/
#define CRS_CR_SYNCOKIE_Pos                 (0U)
#define CRS_CR_SYNCOKIE_Msk                 (0x1UL << CRS_CR_SYNCOKIE_Pos)          /*!< 0x00000001 */
#define CRS_CR_SYNCOKIE                     CRS_CR_SYNCOKIE_Msk                     /*!< SYNC event OK interrupt enable */
#define CRS_CR_SYNCWARNIE_Pos               (1U)
#define CRS_CR_SYNCWARNIE_Msk               (0x1UL << CRS_CR_SYNCWARNIE_Pos)        /*!< 0x00000002 */
#define CRS_CR_SYNCWARNIE                   CRS_CR_SYNCWARNIE_Msk                   /*!< SYNC warning interrupt enable */
#define CRS_CR_ERRIE_Pos                    (2U)
#define CRS_CR_ERRIE_Msk                    (0x1UL << CRS_CR_ERRIE_Pos)             /*!< 0x00000004 */
#define CRS_CR_ERRIE                        CRS_CR_ERRIE_Msk                        /*!< SYNC error or trimming error interrupt enable */
#define CRS_CR_ESYNCIE_Pos                  (3U)
#define CRS_CR_ESYNCIE_Msk                  (0x1UL << CRS_CR_ESYNCIE_Pos)           /*!< 0x00000008 */
#define CRS_CR_ESYNCIE                      CRS_CR_ESYNCIE_Msk                      /*!< Expected SYNC interrupt enable */
#define CRS_CR_CEN_Pos                      (5U)
#define CRS_CR_CEN_Msk                      (0x1UL << CRS_CR_CEN_Pos)               /*!< 0x00000020 */
#define CRS_CR_CEN                          CRS_CR_CEN_Msk                          /*!< Frequency error counter enable */
#define CRS_CR_AUTOTRIMEN_Pos               (6U)
#define CRS_CR_AUTOTRIMEN_Msk               (0x1UL << CRS_CR_AUTOTRIMEN_Pos)        /*!< 0x00000040 */
#define CRS_CR_AUTOTRIMEN                   CRS_CR_AUTOTRIMEN_Msk                   /*!< Automatic trimming enable */
#define CRS_CR_SWSYNC_Pos                   (7U)
#define CRS_CR_SWSYNC_Msk                   (0x1UL << CRS_CR_SWSYNC_Pos)            /*!< 0x00000080 */
#define CRS_CR_SWSYNC                       CRS_CR_SWSYNC_Msk                       /*!< Generate software SYNC event */
#define CRS_CR_TRIM_Pos                     (8U)
#define CRS_CR_TRIM_Msk                     (0x3FUL << CRS_CR_TRIM_Pos)             /*!< 0x00003F00 */
#define CRS_CR_TRIM                         CRS_CR_TRIM_Msk                         /*!< HSI48 oscillator smooth trimming */

/*******************  Bit definition for CRS_CFGR register  *********************/
#define CRS_CFGR_RELOAD_Pos                 (0U)
#define CRS_CFGR_RELOAD_Msk                 (0xFFFFUL << CRS_CFGR_RELOAD_Pos)       /*!< 0x0000FFFF */
#define CRS_CFGR_RELOAD                     CRS_CFGR_RELOAD_Msk                     /*!< Counter reload value */
#define CRS_CFGR_FELIM_Pos                  (16U)
#define CRS_CFGR_FELIM_Msk                  (0xFFUL << CRS_CFGR_FELIM_Pos)          /*!< 0x00FF0000 */
#define CRS_CFGR_FELIM                      CRS_CFGR_FELIM_Msk                      /*!< Frequency error limit */
#define CRS_CFGR_SYNCDIV_Pos                (24U)
#define CRS_CFGR_SYNCDIV_Msk                (0x7UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x07000000 */
#define CRS_CFGR_SYNCDIV                    CRS_CFGR_SYNCDIV_Msk                    /*!< SYNC divider */
#define CRS_CFGR_SYNCDIV_0                  (0x1UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x01000000 */
#define CRS_CFGR_SYNCDIV_1                  (0x2UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x02000000 */
#define CRS_CFGR_SYNCDIV_2                  (0x4UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x04000000 */
#define CRS_CFGR_SYNCSRC_Pos                (28U)
#define CRS_CFGR_SYNCSRC_Msk                (0x3UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x30000000 */
#define CRS_CFGR_SYNCSRC                    CRS_CFGR_SYNCSRC_Msk                    /*!< SYNC signal source selection */
#define CRS_CFGR_SYNCSRC_0                  (0x1UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x10000000 */
#define CRS_CFGR_SYNCSRC_1                  (0x2UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x20000000 */
#define CRS_CFGR_SYNCPOL_Pos                (31U)
#define CRS_CFGR_SYNCPOL_Msk                (0x1UL << CRS_CFGR_SYNCPOL_Pos)         /*!< 0x80000000 */
#define CRS_CFGR_SYNCPOL                    CRS_CFGR_SYNCPOL_Msk                    /*!< SYNC polarity selection */

/*******************  Bit definition for CRS_ISR register  *********************/
#define CRS_ISR_SYNCOKF_Pos                 (0U)
#define CRS_ISR_SYNCOKF_Msk                 (0x1UL << CRS_ISR_SYNCOKF_Pos)          /*!< 0x00000001 */
#define CRS_ISR_SYNCOKF                     CRS_ISR_SYNCOKF_Msk                     /*!< SYNC event OK flag */
#define CRS_ISR_SYNCWARNF_Pos               (1U)
#define CRS_ISR_SYNCWARNF_Msk               (0x1UL << CRS_ISR_SYNCWARNF_Pos)        /*!< 0x00000002 */
#define CRS_ISR_SYNCWARNF                   CRS_ISR_SYNCWARNF_Msk                   /*!< SYNC warning flag */
#define CRS_ISR_ERRF_Pos                    (2U)
#define CRS_ISR_ERRF_Msk                    (0x1UL << CRS_ISR_ERRF_Pos)             /*!< 0x00000004 */
#define CRS_ISR_ERRF                        CRS_ISR_ERRF_Msk                        /*!< Error flag */
#define CRS_ISR_ESYNCF_Pos                  (3U)
#define CRS_ISR_ESYNCF_Msk                  (0x1UL << CRS_ISR_ESYNCF_Pos)           /*!< 0x00000008 */
#define CRS_ISR_ESYNCF                      CRS_ISR_ESYNCF_Msk                      /*!< Expected SYNC flag */
#define CRS_ISR_SYNCERR_Pos                 (8U)
#define CRS_ISR_SYNCERR_Msk                 (0x1UL << CRS_ISR_SYNCERR_Pos)          /*!< 0x00000100 */
#define CRS_ISR_SYNCERR                     CRS_ISR_SYNCERR_Msk                     /*!< SYNC error */
#define CRS_ISR_SYNCMISS_Pos                (9U)
#define CRS_ISR_SYNCMISS_Msk                (0x1UL << CRS_ISR_SYNCMISS_Pos)         /*!< 0x00000200 */
#define CRS_ISR_SYNCMISS                    CRS_ISR_SYNCMISS_Msk                    /*!< SYNC missed */
#define CRS_ISR_TRIMOVF_Pos                 (10U)
#define CRS_ISR_TRIMOVF_Msk                 (0x1UL << CRS_ISR_TRIMOVF_Pos)          /*!< 0x00000400 */
#define CRS_ISR_TRIMOVF                     CRS_ISR_TRIMOVF_Msk                     /*!< Trimming overflow or underflow */
#define CRS_ISR_FEDIR_Pos                   (15U)
#define CRS_ISR_FEDIR_Msk                   (0x1UL << CRS_ISR_FEDIR_Pos)            /*!< 0x00008000 */
#define CRS_ISR_FEDIR                       CRS_ISR_FEDIR_Msk                       /*!< Frequency error direction */
#define CRS_ISR_FECAP_Pos                   (16U)
#define CRS_ISR_FECAP_Msk                   (0xFFFFUL << CRS_ISR_FECAP_Pos)         /*!< 0xFFFF0000 */
#define CRS_ISR_FECAP                       CRS_ISR_FECAP_Msk                       /*!< Frequency error capture */

/*******************  Bit definition for CRS_ICR register  *********************/
#define CRS_ICR_SYNCOKC_Pos                 (0U)
#define CRS_ICR_SYNCOKC_Msk                 (0x1UL << CRS_ICR_SYNCOKC_Pos)          /*!< 0x00000001 */
#define CRS_ICR_SYNCOKC                     CRS_ICR_SYNCOKC_Msk                     /*!< SYNC event OK clear flag */
#define CRS_ICR_SYNCWARNC_Pos               (1U)
#define CRS_ICR_SYNCWARNC_Msk               (0x1UL << CRS_ICR_SYNCWARNC_Pos)        /*!< 0x00000002 */
#define CRS_ICR_SYNCWARNC                   CRS_ICR_SYNCWARNC_Msk                   /*!< SYNC warning clear flag */
#define CRS_ICR_ERRC_Pos                    (2U)
#define CRS_ICR_ERRC_Msk                    (0x1UL << CRS_ICR_ERRC_Pos)             /*!< 0x00000004 */
#define CRS_ICR_ERRC                        CRS_ICR_ERRC_Msk                        /*!< Error clear flag */
#define CRS_ICR_ESYNCC_Pos                  (3U)
#define CRS_ICR_ESYNCC_Msk                  (0x1UL << CRS_ICR_ESYNCC_Pos)           /*!< 0x00000008 */
#define CRS_ICR_ESYNCC                      CRS_ICR_ESYNCC_Msk                      /*!< Expected SYNC clear flag */


/******************************************************************************/
/*                                                                            */
/*                                    RNG                                     */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for RNG_CR register  *******************/
#define RNG_CR_RNGEN_Pos                    (2U)
#define RNG_CR_RNGEN_Msk                    (0x1UL << RNG_CR_RNGEN_Pos)             /*!< 0x00000004 */
#define RNG_CR_RNGEN                        RNG_CR_RNGEN_Msk
#define RNG_CR_IE_Pos                       (3U)
#define RNG_CR_IE_Msk                       (0x1UL << RNG_CR_IE_Pos)                /*!< 0x00000008 */
#define RNG_CR_IE                           RNG_CR_IE_Msk
#define RNG_CR_CED_Pos                      (5U)
#define RNG_CR_CED_Msk                      (0x1UL << RNG_CR_CED_Pos)               /*!< 0x00000020 */
#define RNG_CR_CED                          RNG_CR_CED_Msk
#define RNG_CR_ARDIS_Pos                    (7U)
#define RNG_CR_ARDIS_Msk                    (0x1UL << RNG_CR_ARDIS_Pos)
#define RNG_CR_ARDIS                        RNG_CR_ARDIS_Msk
#define RNG_CR_RNG_CONFIG3_Pos              (8U)
#define RNG_CR_RNG_CONFIG3_Msk              (0xFUL << RNG_CR_RNG_CONFIG3_Pos)
#define RNG_CR_RNG_CONFIG3                  RNG_CR_RNG_CONFIG3_Msk
#define RNG_CR_NISTC_Pos                    (12U)
#define RNG_CR_NISTC_Msk                    (0x1UL << RNG_CR_NISTC_Pos)
#define RNG_CR_NISTC                        RNG_CR_NISTC_Msk
#define RNG_CR_RNG_CONFIG2_Pos              (13U)
#define RNG_CR_RNG_CONFIG2_Msk              (0x7UL << RNG_CR_RNG_CONFIG2_Pos)
#define RNG_CR_RNG_CONFIG2                  RNG_CR_RNG_CONFIG2_Msk
#define RNG_CR_CLKDIV_Pos                   (16U)
#define RNG_CR_CLKDIV_Msk                   (0xFUL << RNG_CR_CLKDIV_Pos)
#define RNG_CR_CLKDIV                       RNG_CR_CLKDIV_Msk
#define RNG_CR_CLKDIV_0                     (0x1UL << RNG_CR_CLKDIV_Pos)            /*!< 0x00010000 */
#define RNG_CR_CLKDIV_1                     (0x2UL << RNG_CR_CLKDIV_Pos)            /*!< 0x00020000 */
#define RNG_CR_CLKDIV_2                     (0x4UL << RNG_CR_CLKDIV_Pos)            /*!< 0x00040000 */
#define RNG_CR_CLKDIV_3                     (0x8UL << RNG_CR_CLKDIV_Pos)            /*!< 0x00080000 */
#define RNG_CR_RNG_CONFIG1_Pos              (20U)
#define RNG_CR_RNG_CONFIG1_Msk              (0x3FUL << RNG_CR_RNG_CONFIG1_Pos)
#define RNG_CR_RNG_CONFIG1                  RNG_CR_RNG_CONFIG1_Msk
#define RNG_CR_CONDRST_Pos                  (30U)
#define RNG_CR_CONDRST_Msk                  (0x1UL << RNG_CR_CONDRST_Pos)
#define RNG_CR_CONDRST                      RNG_CR_CONDRST_Msk
#define RNG_CR_CONFIGLOCK_Pos               (31U)
#define RNG_CR_CONFIGLOCK_Msk               (0x1UL << RNG_CR_CONFIGLOCK_Pos)
#define RNG_CR_CONFIGLOCK                   RNG_CR_CONFIGLOCK_Msk

/********************  Bits definition for RNG_SR register  *******************/
#define RNG_SR_DRDY_Pos                     (0U)
#define RNG_SR_DRDY_Msk                     (0x1UL << RNG_SR_DRDY_Pos)              /*!< 0x00000001 */
#define RNG_SR_DRDY                         RNG_SR_DRDY_Msk
#define RNG_SR_CECS_Pos                     (1U)
#define RNG_SR_CECS_Msk                     (0x1UL << RNG_SR_CECS_Pos)              /*!< 0x00000002 */
#define RNG_SR_CECS                         RNG_SR_CECS_Msk
#define RNG_SR_SECS_Pos                     (2U)
#define RNG_SR_SECS_Msk                     (0x1UL << RNG_SR_SECS_Pos)              /*!< 0x00000004 */
#define RNG_SR_SECS                         RNG_SR_SECS_Msk
#define RNG_SR_CEIS_Pos                     (5U)
#define RNG_SR_CEIS_Msk                     (0x1UL << RNG_SR_CEIS_Pos)              /*!< 0x00000020 */
#define RNG_SR_CEIS                         RNG_SR_CEIS_Msk
#define RNG_SR_SEIS_Pos                     (6U)
#define RNG_SR_SEIS_Msk                     (0x1UL << RNG_SR_SEIS_Pos)              /*!< 0x00000040 */
#define RNG_SR_SEIS                         RNG_SR_SEIS_Msk

/********************  Bits definition for RNG_NSCR register  *******************/
#define RNG_NSCR_EN_OSC1_Pos                (0U)
#define RNG_NSCR_EN_OSC1_Msk                (0x7UL << RNG_NSCR_EN_OSC1_Pos)         /*!< 0x00000007 */
#define RNG_NSCR_EN_OSC1                    RNG_NSCR_EN_OSC1_Msk
#define RNG_NSCR_EN_OSC2_Pos                (3U)
#define RNG_NSCR_EN_OSC2_Msk                (0x7UL << RNG_NSCR_EN_OSC2_Pos)         /*!< 0x00000038 */
#define RNG_NSCR_EN_OSC2                    RNG_NSCR_EN_OSC2_Msk
#define RNG_NSCR_EN_OSC3_Pos                (6U)
#define RNG_NSCR_EN_OSC3_Msk                (0x7UL << RNG_NSCR_EN_OSC3_Pos)         /*!< 0x000001C0 */
#define RNG_NSCR_EN_OSC3                    RNG_NSCR_EN_OSC3_Msk
#define RNG_NSCR_EN_OSC4_Pos                (9U)
#define RNG_NSCR_EN_OSC4_Msk                (0x7UL << RNG_NSCR_EN_OSC4_Pos)         /*!< 0x00000E00 */
#define RNG_NSCR_EN_OSC4                    RNG_NSCR_EN_OSC4_Msk
#define RNG_NSCR_EN_OSC5_Pos                (12U)
#define RNG_NSCR_EN_OSC5_Msk                (0x7UL << RNG_NSCR_EN_OSC5_Pos)         /*!< 0x00007000 */
#define RNG_NSCR_EN_OSC5                    RNG_NSCR_EN_OSC5_Msk
#define RNG_NSCR_EN_OSC6_Pos                (15U)
#define RNG_NSCR_EN_OSC6_Msk                (0x7UL << RNG_NSCR_EN_OSC6_Pos)         /*!< 0x00038000 */
#define RNG_NSCR_EN_OSC6                    RNG_NSCR_EN_OSC6_Msk

/********************  Bits definition for RNG_HTCR register  *******************/
#define RNG_HTCR_HTCFG_Pos                  (0U)
#define RNG_HTCR_HTCFG_Msk                  (0xFFFFFFFFUL << RNG_HTCR_HTCFG_Pos)    /*!< 0xFFFFFFFF */
#define RNG_HTCR_HTCFG                      RNG_HTCR_HTCFG_Msk

/********************  RNG Nist Compliance Values  ******************************/
#define RNG_CR_NIST_VALUE                   (0x00F00E00U)
#define RNG_HTCR_NIST_VALUE                 (0x6A91U)
#define RNG_NSCR_NIST_VALUE                 (0x3AF66U)

/******************************************************************************/
/*                                                                            */
/*                      Digital to Analog Converter                           */
/*                                                                            */
/******************************************************************************/
#define DAC_CHANNEL2_SUPPORT                                                        /*!< DAC feature available only on specific devices: DAC channel 2 available */

/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos                      (0U)
#define DAC_CR_EN1_Msk                      (0x1UL << DAC_CR_EN1_Pos)               /*!< 0x00000001 */
#define DAC_CR_EN1                          DAC_CR_EN1_Msk                          /*!<DAC channel1 enable */
#define DAC_CR_TEN1_Pos                     (1U)
#define DAC_CR_TEN1_Msk                     (0x1UL << DAC_CR_TEN1_Pos)              /*!< 0x00000002 */
#define DAC_CR_TEN1                         DAC_CR_TEN1_Msk                         /*!<DAC channel1 Trigger enable */
#define DAC_CR_TSEL1_Pos                    (2U)
#define DAC_CR_TSEL1_Msk                    (0xFUL << DAC_CR_TSEL1_Pos)             /*!< 0x0000003C */
#define DAC_CR_TSEL1                        DAC_CR_TSEL1_Msk                        /*!<TSEL1[3:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0                      (0x1UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000004 */
#define DAC_CR_TSEL1_1                      (0x2UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000008 */
#define DAC_CR_TSEL1_2                      (0x4UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000010 */
#define DAC_CR_TSEL1_3                      (0x8UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000020 */
#define DAC_CR_WAVE1_Pos                    (6U)
#define DAC_CR_WAVE1_Msk                    (0x3UL << DAC_CR_WAVE1_Pos)             /*!< 0x000000C0 */
#define DAC_CR_WAVE1                        DAC_CR_WAVE1_Msk                        /*!<WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0                      (0x1UL << DAC_CR_WAVE1_Pos)             /*!< 0x00000040 */
#define DAC_CR_WAVE1_1                      (0x2UL << DAC_CR_WAVE1_Pos)             /*!< 0x00000080 */
#define DAC_CR_MAMP1_Pos                    (8U)
#define DAC_CR_MAMP1_Msk                    (0xFUL << DAC_CR_MAMP1_Pos)             /*!< 0x00000F00 */
#define DAC_CR_MAMP1                        DAC_CR_MAMP1_Msk                        /*!<MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0                      (0x1UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000100 */
#define DAC_CR_MAMP1_1                      (0x2UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000200 */
#define DAC_CR_MAMP1_2                      (0x4UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000400 */
#define DAC_CR_MAMP1_3                      (0x8UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000800 */
#define DAC_CR_DMAEN1_Pos                   (12U)
#define DAC_CR_DMAEN1_Msk                   (0x1UL << DAC_CR_DMAEN1_Pos)            /*!< 0x00001000 */
#define DAC_CR_DMAEN1                       DAC_CR_DMAEN1_Msk                       /*!<DAC channel1 DMA enable */
#define DAC_CR_DMAUDRIE1_Pos                (13U)
#define DAC_CR_DMAUDRIE1_Msk                (0x1UL << DAC_CR_DMAUDRIE1_Pos)         /*!< 0x00002000 */
#define DAC_CR_DMAUDRIE1                    DAC_CR_DMAUDRIE1_Msk                    /*!<DAC channel 1 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN1_Pos                     (14U)
#define DAC_CR_CEN1_Msk                     (0x1UL << DAC_CR_CEN1_Pos)              /*!< 0x00004000 */
#define DAC_CR_CEN1                         DAC_CR_CEN1_Msk                         /*!<DAC channel 1 calibration enable >*/
#define DAC_CR_EN2_Pos                      (16U)
#define DAC_CR_EN2_Msk                      (0x1UL << DAC_CR_EN2_Pos)               /*!< 0x00010000 */
#define DAC_CR_EN2                          DAC_CR_EN2_Msk                          /*!<DAC channel2 enable */
#define DAC_CR_TEN2_Pos                     (17U)
#define DAC_CR_TEN2_Msk                     (0x1UL << DAC_CR_TEN2_Pos)              /*!< 0x00020000 */
#define DAC_CR_TEN2                         DAC_CR_TEN2_Msk                         /*!<DAC channel2 Trigger enable */
#define DAC_CR_TSEL2_Pos                    (18U)
#define DAC_CR_TSEL2_Msk                    (0xFUL << DAC_CR_TSEL2_Pos)             /*!< 0x003C0000 */
#define DAC_CR_TSEL2                        DAC_CR_TSEL2_Msk                        /*!<TSEL2[3:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0                      (0x1UL << DAC_CR_TSEL2_Pos)             /*!< 0x00040000 */
#define DAC_CR_TSEL2_1                      (0x2UL << DAC_CR_TSEL2_Pos)             /*!< 0x00080000 */
#define DAC_CR_TSEL2_2                      (0x4UL << DAC_CR_TSEL2_Pos)             /*!< 0x00100000 */
#define DAC_CR_TSEL2_3                      (0x8UL << DAC_CR_TSEL2_Pos)             /*!< 0x00200000 */
#define DAC_CR_WAVE2_Pos                    (22U)
#define DAC_CR_WAVE2_Msk                    (0x3UL << DAC_CR_WAVE2_Pos)             /*!< 0x00C00000 */
#define DAC_CR_WAVE2                        DAC_CR_WAVE2_Msk                        /*!<WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0                      (0x1UL << DAC_CR_WAVE2_Pos)             /*!< 0x00400000 */
#define DAC_CR_WAVE2_1                      (0x2UL << DAC_CR_WAVE2_Pos)             /*!< 0x00800000 */
#define DAC_CR_MAMP2_Pos                    (24U)
#define DAC_CR_MAMP2_Msk                    (0xFUL << DAC_CR_MAMP2_Pos)             /*!< 0x0F000000 */
#define DAC_CR_MAMP2                        DAC_CR_MAMP2_Msk                        /*!<MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0                      (0x1UL << DAC_CR_MAMP2_Pos)             /*!< 0x01000000 */
#define DAC_CR_MAMP2_1                      (0x2UL << DAC_CR_MAMP2_Pos)             /*!< 0x02000000 */
#define DAC_CR_MAMP2_2                      (0x4UL << DAC_CR_MAMP2_Pos)             /*!< 0x04000000 */
#define DAC_CR_MAMP2_3                      (0x8UL << DAC_CR_MAMP2_Pos)             /*!< 0x08000000 */
#define DAC_CR_DMAEN2_Pos                   (28U)
#define DAC_CR_DMAEN2_Msk                   (0x1UL << DAC_CR_DMAEN2_Pos)            /*!< 0x10000000 */
#define DAC_CR_DMAEN2                       DAC_CR_DMAEN2_Msk                       /*!<DAC channel2 DMA enabled */
#define DAC_CR_DMAUDRIE2_Pos                (29U)
#define DAC_CR_DMAUDRIE2_Msk                (0x1UL << DAC_CR_DMAUDRIE2_Pos)         /*!< 0x20000000 */
#define DAC_CR_DMAUDRIE2                    DAC_CR_DMAUDRIE2_Msk                    /*!<DAC channel2 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN2_Pos                     (30U)
#define DAC_CR_CEN2_Msk                     (0x1UL << DAC_CR_CEN2_Pos)              /*!< 0x40000000 */
#define DAC_CR_CEN2                         DAC_CR_CEN2_Msk                         /*!<DAC channel2 calibration enable >*/

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1_Pos             (0U)
#define DAC_SWTRIGR_SWTRIG1_Msk             (0x1UL << DAC_SWTRIGR_SWTRIG1_Pos)      /*!< 0x00000001 */
#define DAC_SWTRIGR_SWTRIG1                 DAC_SWTRIGR_SWTRIG1_Msk                 /*!<DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2_Pos             (1U)
#define DAC_SWTRIGR_SWTRIG2_Msk             (0x1UL << DAC_SWTRIGR_SWTRIG2_Pos)      /*!< 0x00000002 */
#define DAC_SWTRIGR_SWTRIG2                 DAC_SWTRIGR_SWTRIG2_Msk                 /*!<DAC channel2 software trigger */
#define DAC_SWTRIGR_SWTRIGB1_Pos            (16U)
#define DAC_SWTRIGR_SWTRIGB1_Msk            (0x1UL << DAC_SWTRIGR_SWTRIGB1_Pos)     /*!< 0x00010000 */
#define DAC_SWTRIGR_SWTRIGB1                DAC_SWTRIGR_SWTRIGB1_Msk                /*!<DAC channel1 software trigger B */
#define DAC_SWTRIGR_SWTRIGB2_Pos            (17U)
#define DAC_SWTRIGR_SWTRIGB2_Msk            (0x1UL << DAC_SWTRIGR_SWTRIGB2_Pos)     /*!< 0x00020000 */
#define DAC_SWTRIGR_SWTRIGB2                DAC_SWTRIGR_SWTRIGB2_Msk                /*!<DAC channel2 software trigger B */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR_Pos            (0U)
#define DAC_DHR12R1_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12R1_DACC1DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12R1_DACC1DHR                DAC_DHR12R1_DACC1DHR_Msk                /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12R1_DACC1DHRB_Pos           (16U)
#define DAC_DHR12R1_DACC1DHRB_Msk           (0xFFFUL << DAC_DHR12R1_DACC1DHRB_Pos)  /*!< 0x0FFF0000 */
#define DAC_DHR12R1_DACC1DHRB               DAC_DHR12R1_DACC1DHRB_Msk               /*!<DAC channel1 12-bit Right-aligned data B */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR_Pos            (4U)
#define DAC_DHR12L1_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12L1_DACC1DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12L1_DACC1DHR                DAC_DHR12L1_DACC1DHR_Msk                /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12L1_DACC1DHRB_Pos           (20U)
#define DAC_DHR12L1_DACC1DHRB_Msk           (0xFFFUL << DAC_DHR12L1_DACC1DHRB_Pos)  /*!< 0xFFF00000 */
#define DAC_DHR12L1_DACC1DHRB               DAC_DHR12L1_DACC1DHRB_Msk               /*!<DAC channel1 12-bit Left aligned data B */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR_Pos             (0U)
#define DAC_DHR8R1_DACC1DHR_Msk             (0xFFUL << DAC_DHR8R1_DACC1DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8R1_DACC1DHR                 DAC_DHR8R1_DACC1DHR_Msk                 /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8R1_DACC1DHRB_Pos            (8U)
#define DAC_DHR8R1_DACC1DHRB_Msk            (0xFFUL << DAC_DHR8R1_DACC1DHRB_Pos)    /*!< 0x0000FF00 */
#define DAC_DHR8R1_DACC1DHRB                DAC_DHR8R1_DACC1DHRB_Msk                /*!<DAC channel1 8-bit Right aligned data B */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR_Pos            (0U)
#define DAC_DHR12R2_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12R2_DACC2DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12R2_DACC2DHR                DAC_DHR12R2_DACC2DHR_Msk                /*!<DAC channel2 12-bit Right aligned data */
#define DAC_DHR12R2_DACC2DHRB_Pos           (16U)
#define DAC_DHR12R2_DACC2DHRB_Msk           (0xFFFUL << DAC_DHR12R2_DACC2DHRB_Pos)  /*!< 0x0FFF0000 */
#define DAC_DHR12R2_DACC2DHRB               DAC_DHR12R2_DACC2DHRB_Msk               /*!<DAC channel2 12-bit Right-aligned data B */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR_Pos            (4U)
#define DAC_DHR12L2_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12L2_DACC2DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12L2_DACC2DHR                DAC_DHR12L2_DACC2DHR_Msk                /*!<DAC channel2 12-bit Left aligned data */
#define DAC_DHR12L2_DACC2DHRB_Pos           (20U)
#define DAC_DHR12L2_DACC2DHRB_Msk           (0xFFFUL << DAC_DHR12L2_DACC2DHRB_Pos)  /*!< 0xFFF00000 */
#define DAC_DHR12L2_DACC2DHRB               DAC_DHR12L2_DACC2DHRB_Msk               /*!<DAC channel2 12-bit Left aligned data B */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR_Pos             (0U)
#define DAC_DHR8R2_DACC2DHR_Msk             (0xFFUL << DAC_DHR8R2_DACC2DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8R2_DACC2DHR                 DAC_DHR8R2_DACC2DHR_Msk                 /*!<DAC channel2 8-bit Right aligned data */
#define DAC_DHR8R2_DACC2DHRB_Pos            (8U)
#define DAC_DHR8R2_DACC2DHRB_Msk            (0xFFUL << DAC_DHR8R2_DACC2DHRB_Pos)    /*!< 0x0000FF00 */
#define DAC_DHR8R2_DACC2DHRB                DAC_DHR8R2_DACC2DHRB_Msk                /*!<DAC channel2 8-bit Right aligned data B */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos            (0U)
#define DAC_DHR12RD_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12RD_DACC1DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR                DAC_DHR12RD_DACC1DHR_Msk                /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos            (16U)
#define DAC_DHR12RD_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12RD_DACC2DHR_Pos)   /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR                DAC_DHR12RD_DACC2DHR_Msk                /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos            (4U)
#define DAC_DHR12LD_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12LD_DACC1DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR                DAC_DHR12LD_DACC1DHR_Msk                /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos            (20U)
#define DAC_DHR12LD_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12LD_DACC2DHR_Pos)   /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR                DAC_DHR12LD_DACC2DHR_Msk                /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR_Pos             (0U)
#define DAC_DHR8RD_DACC1DHR_Msk             (0xFFUL << DAC_DHR8RD_DACC1DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8RD_DACC1DHR                 DAC_DHR8RD_DACC1DHR_Msk                 /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR_Pos             (8U)
#define DAC_DHR8RD_DACC2DHR_Msk             (0xFFUL << DAC_DHR8RD_DACC2DHR_Pos)     /*!< 0x0000FF00 */
#define DAC_DHR8RD_DACC2DHR                 DAC_DHR8RD_DACC2DHR_Msk                 /*!<DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR_Pos               (0U)
#define DAC_DOR1_DACC1DOR_Msk               (0xFFFUL << DAC_DOR1_DACC1DOR_Pos)      /*!< 0x00000FFF */
#define DAC_DOR1_DACC1DOR                   DAC_DOR1_DACC1DOR_Msk                   /*!<DAC channel1 data output */
#define DAC_DOR1_DACC1DORB_Pos              (16U)
#define DAC_DOR1_DACC1DORB_Msk              (0xFFFUL << DAC_DOR1_DACC1DORB_Pos)     /*!< 0x0FFF0000 */
#define DAC_DOR1_DACC1DORB                  DAC_DOR1_DACC1DORB_Msk                  /*!<DAC channel1 data output B */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR_Pos               (0U)
#define DAC_DOR2_DACC2DOR_Msk               (0xFFFUL << DAC_DOR2_DACC2DOR_Pos)      /*!< 0x00000FFF */
#define DAC_DOR2_DACC2DOR                   DAC_DOR2_DACC2DOR_Msk                   /*!<DAC channel2 data output */
#define DAC_DOR2_DACC2DORB_Pos              (16U)
#define DAC_DOR2_DACC2DORB_Msk              (0xFFFUL << DAC_DOR2_DACC2DORB_Pos)     /*!< 0x0FFF0000 */
#define DAC_DOR2_DACC2DORB                  DAC_DOR2_DACC2DORB_Msk                  /*!<DAC channel2 data output B */

/********************  Bit definition for DAC_SR register  ********************/
#define DAC_SR_DAC1RDY_Pos                  (11U)
#define DAC_SR_DAC1RDY_Msk                  (0x1UL << DAC_SR_DAC1RDY_Pos)           /*!< 0x00000800 */
#define DAC_SR_DAC1RDY                      DAC_SR_DAC1RDY_Msk                      /*!<DAC channel 1 ready status bit */
#define DAC_SR_DORSTAT1_Pos                 (12U)
#define DAC_SR_DORSTAT1_Msk                 (0x1UL << DAC_SR_DORSTAT1_Pos)          /*!< 0x00001000 */
#define DAC_SR_DORSTAT1                     DAC_SR_DORSTAT1_Msk                     /*!<DAC channel 1 output register status bit */
#define DAC_SR_DMAUDR1_Pos                  (13U)
#define DAC_SR_DMAUDR1_Msk                  (0x1UL << DAC_SR_DMAUDR1_Pos)           /*!< 0x00002000 */
#define DAC_SR_DMAUDR1                      DAC_SR_DMAUDR1_Msk                      /*!<DAC channel1 DMA underrun flag */
#define DAC_SR_CAL_FLAG1_Pos                (14U)
#define DAC_SR_CAL_FLAG1_Msk                (0x1UL << DAC_SR_CAL_FLAG1_Pos)         /*!< 0x00004000 */
#define DAC_SR_CAL_FLAG1                    DAC_SR_CAL_FLAG1_Msk                    /*!<DAC channel1 calibration offset status */
#define DAC_SR_BWST1_Pos                    (15U)
#define DAC_SR_BWST1_Msk                    (0x1UL << DAC_SR_BWST1_Pos)             /*!< 0x00008000 */
#define DAC_SR_BWST1                        DAC_SR_BWST1_Msk                        /*!<DAC channel1 busy writing sample time flag */

#define DAC_SR_DAC2RDY_Pos                  (27U)
#define DAC_SR_DAC2RDY_Msk                  (0x1UL << DAC_SR_DAC2RDY_Pos)           /*!< 0x08000000 */
#define DAC_SR_DAC2RDY                      DAC_SR_DAC2RDY_Msk                      /*!<DAC channel 2 ready status bit */
#define DAC_SR_DORSTAT2_Pos                 (28U)
#define DAC_SR_DORSTAT2_Msk                 (0x1UL << DAC_SR_DORSTAT2_Pos)          /*!< 0x10000000 */
#define DAC_SR_DORSTAT2                     DAC_SR_DORSTAT2_Msk                     /*!<DAC channel 2 output register status bit */
#define DAC_SR_DMAUDR2_Pos                  (29U)
#define DAC_SR_DMAUDR2_Msk                  (0x1UL << DAC_SR_DMAUDR2_Pos)           /*!< 0x20000000 */
#define DAC_SR_DMAUDR2                      DAC_SR_DMAUDR2_Msk                      /*!<DAC channel2 DMA underrun flag */
#define DAC_SR_CAL_FLAG2_Pos                (30U)
#define DAC_SR_CAL_FLAG2_Msk                (0x1UL << DAC_SR_CAL_FLAG2_Pos)         /*!< 0x40000000 */
#define DAC_SR_CAL_FLAG2                    DAC_SR_CAL_FLAG2_Msk                    /*!<DAC channel2 calibration offset status */
#define DAC_SR_BWST2_Pos                    (31U)
#define DAC_SR_BWST2_Msk                    (0x1UL << DAC_SR_BWST2_Pos)             /*!< 0x80000000 */
#define DAC_SR_BWST2                        DAC_SR_BWST2_Msk                        /*!<DAC channel2 busy writing sample time flag */

/*******************  Bit definition for DAC_CCR register  ********************/
#define DAC_CCR_OTRIM1_Pos                  (0U)
#define DAC_CCR_OTRIM1_Msk                  (0x1FUL << DAC_CCR_OTRIM1_Pos)          /*!< 0x0000001F */
#define DAC_CCR_OTRIM1                      DAC_CCR_OTRIM1_Msk                      /*!<DAC channel1 offset trimming value */
#define DAC_CCR_OTRIM2_Pos                  (16U)
#define DAC_CCR_OTRIM2_Msk                  (0x1FUL << DAC_CCR_OTRIM2_Pos)          /*!< 0x001F0000 */
#define DAC_CCR_OTRIM2                      DAC_CCR_OTRIM2_Msk                      /*!<DAC channel2 offset trimming value */

/*******************  Bit definition for DAC_MCR register  *******************/
#define DAC_MCR_MODE1_Pos                   (0U)
#define DAC_MCR_MODE1_Msk                   (0x7UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000007 */
#define DAC_MCR_MODE1                       DAC_MCR_MODE1_Msk                       /*!<MODE1[2:0] (DAC channel1 mode) */
#define DAC_MCR_MODE1_0                     (0x1UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000001 */
#define DAC_MCR_MODE1_1                     (0x2UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000002 */
#define DAC_MCR_MODE1_2                     (0x4UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000004 */
#define DAC_MCR_DMADOUBLE1_Pos              (8U)
#define DAC_MCR_DMADOUBLE1_Msk              (0x1UL << DAC_MCR_DMADOUBLE1_Pos)       /*!< 0x00000100 */
#define DAC_MCR_DMADOUBLE1                  DAC_MCR_DMADOUBLE1_Msk                  /*!<DAC Channel 1 DMA double data mode */
#define DAC_MCR_SINFORMAT1_Pos              (9U)
#define DAC_MCR_SINFORMAT1_Msk              (0x1UL << DAC_MCR_SINFORMAT1_Pos)       /*!< 0x00000200 */
#define DAC_MCR_SINFORMAT1                  DAC_MCR_SINFORMAT1_Msk                  /*!<DAC Channel 1 enable signed format */
#define DAC_MCR_HFSEL_Pos                   (14U)
#define DAC_MCR_HFSEL_Msk                   (0x3UL << DAC_MCR_HFSEL_Pos)            /*!< 0x0000C000 */
#define DAC_MCR_HFSEL                       DAC_MCR_HFSEL_Msk                       /*!<HFSEL[1:0] (High Frequency interface mode selection) */
#define DAC_MCR_HFSEL_0                     (0x1UL << DAC_MCR_HFSEL_Pos)            /*!< 0x00004000 */
#define DAC_MCR_HFSEL_1                     (0x2UL << DAC_MCR_HFSEL_Pos)            /*!< 0x00008000 */
#define DAC_MCR_MODE2_Pos                   (16U)
#define DAC_MCR_MODE2_Msk                   (0x7UL << DAC_MCR_MODE2_Pos)            /*!< 0x00070000 */
#define DAC_MCR_MODE2                       DAC_MCR_MODE2_Msk                       /*!<MODE2[2:0] (DAC channel2 mode) */
#define DAC_MCR_MODE2_0                     (0x1UL << DAC_MCR_MODE2_Pos)            /*!< 0x00010000 */
#define DAC_MCR_MODE2_1                     (0x2UL << DAC_MCR_MODE2_Pos)            /*!< 0x00020000 */
#define DAC_MCR_MODE2_2                     (0x4UL << DAC_MCR_MODE2_Pos)            /*!< 0x00040000 */
#define DAC_MCR_DMADOUBLE2_Pos              (24U)
#define DAC_MCR_DMADOUBLE2_Msk              (0x1UL << DAC_MCR_DMADOUBLE2_Pos)       /*!< 0x01000000 */
#define DAC_MCR_DMADOUBLE2                  DAC_MCR_DMADOUBLE2_Msk                  /*!<DAC Channel 2 DMA double data mode */
#define DAC_MCR_SINFORMAT2_Pos              (25U)
#define DAC_MCR_SINFORMAT2_Msk              (0x1UL << DAC_MCR_SINFORMAT2_Pos)       /*!< 0x02000000 */
#define DAC_MCR_SINFORMAT2                  DAC_MCR_SINFORMAT2_Msk                  /*!<DAC Channel 2 enable signed format */

/******************  Bit definition for DAC_SHSR1 register  ******************/
#define DAC_SHSR1_TSAMPLE1_Pos              (0U)
#define DAC_SHSR1_TSAMPLE1_Msk              (0x3FFUL << DAC_SHSR1_TSAMPLE1_Pos)     /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE1                  DAC_SHSR1_TSAMPLE1_Msk                  /*!<DAC channel1 sample time */

/******************  Bit definition for DAC_SHSR2 register  ******************/
#define DAC_SHSR2_TSAMPLE2_Pos              (0U)
#define DAC_SHSR2_TSAMPLE2_Msk              (0x3FFUL << DAC_SHSR2_TSAMPLE2_Pos)     /*!< 0x000003FF */
#define DAC_SHSR2_TSAMPLE2                  DAC_SHSR2_TSAMPLE2_Msk                  /*!<DAC channel2 sample time */

/******************  Bit definition for DAC_SHHR register  ******************/
#define DAC_SHHR_THOLD1_Pos                 (0U)
#define DAC_SHHR_THOLD1_Msk                 (0x3FFUL << DAC_SHHR_THOLD1_Pos)        /*!< 0x000003FF */
#define DAC_SHHR_THOLD1                     DAC_SHHR_THOLD1_Msk                     /*!<DAC channel1 hold time */
#define DAC_SHHR_THOLD2_Pos                 (16U)
#define DAC_SHHR_THOLD2_Msk                 (0x3FFUL << DAC_SHHR_THOLD2_Pos)        /*!< 0x03FF0000 */
#define DAC_SHHR_THOLD2                     DAC_SHHR_THOLD2_Msk                     /*!<DAC channel2 hold time */

/******************  Bit definition for DAC_SHRR register  ******************/
#define DAC_SHRR_TREFRESH1_Pos              (0U)
#define DAC_SHRR_TREFRESH1_Msk              (0xFFUL << DAC_SHRR_TREFRESH1_Pos)      /*!< 0x000000FF */
#define DAC_SHRR_TREFRESH1                  DAC_SHRR_TREFRESH1_Msk                  /*!<DAC channel1 refresh time */
#define DAC_SHRR_TREFRESH2_Pos              (16U)
#define DAC_SHRR_TREFRESH2_Msk              (0xFFUL << DAC_SHRR_TREFRESH2_Pos)      /*!< 0x00FF0000 */
#define DAC_SHRR_TREFRESH2                  DAC_SHRR_TREFRESH2_Msk                  /*!<DAC channel2 refresh time */

/******************  Bit definition for DAC_AUTOCR register  ******************/
#define DAC_AUTOCR_AUTOMODE_Pos             (22U)
#define DAC_AUTOCR_AUTOMODE_Msk             (0x1UL << DAC_AUTOCR_AUTOMODE_Pos)      /*!< 0x00400000 */
#define DAC_AUTOCR_AUTOMODE                 DAC_AUTOCR_AUTOMODE_Msk                 /*!< AUTOCR Enable */


/******************************************************************************/
/*                                                                            */
/*                                    HASH                                    */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for HASH_CR register  ********************/
#define HASH_CR_INIT_Pos                    (2U)
#define HASH_CR_INIT_Msk                    (0x1UL << HASH_CR_INIT_Pos)             /*!< 0x00000004 */
#define HASH_CR_INIT                        HASH_CR_INIT_Msk
#define HASH_CR_DMAE_Pos                    (3U)
#define HASH_CR_DMAE_Msk                    (0x1UL << HASH_CR_DMAE_Pos)             /*!< 0x00000008 */
#define HASH_CR_DMAE                        HASH_CR_DMAE_Msk
#define HASH_CR_DATATYPE_Pos                (4U)
#define HASH_CR_DATATYPE_Msk                (0x3UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000030 */
#define HASH_CR_DATATYPE                    HASH_CR_DATATYPE_Msk
#define HASH_CR_DATATYPE_0                  (0x1UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000010 */
#define HASH_CR_DATATYPE_1                  (0x2UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000020 */
#define HASH_CR_MODE_Pos                    (6U)
#define HASH_CR_MODE_Msk                    (0x1UL << HASH_CR_MODE_Pos)             /*!< 0x00000040 */
#define HASH_CR_MODE                        HASH_CR_MODE_Msk
#define HASH_CR_NBW_Pos                     (8U)
#define HASH_CR_NBW_Msk                     (0xFUL << HASH_CR_NBW_Pos)              /*!< 0x00000F00 */
#define HASH_CR_NBW                         HASH_CR_NBW_Msk
#define HASH_CR_NBW_0                       (0x1UL << HASH_CR_NBW_Pos)              /*!< 0x00000100 */
#define HASH_CR_NBW_1                       (0x2UL << HASH_CR_NBW_Pos)              /*!< 0x00000200 */
#define HASH_CR_NBW_2                       (0x4UL << HASH_CR_NBW_Pos)              /*!< 0x00000400 */
#define HASH_CR_NBW_3                       (0x8UL << HASH_CR_NBW_Pos)              /*!< 0x00000800 */
#define HASH_CR_DINNE_Pos                   (12U)
#define HASH_CR_DINNE_Msk                   (0x1UL << HASH_CR_DINNE_Pos)            /*!< 0x00001000 */
#define HASH_CR_DINNE                       HASH_CR_DINNE_Msk
#define HASH_CR_MDMAT_Pos                   (13U)
#define HASH_CR_MDMAT_Msk                   (0x1UL << HASH_CR_MDMAT_Pos)            /*!< 0x00002000 */
#define HASH_CR_MDMAT                       HASH_CR_MDMAT_Msk
#define HASH_CR_LKEY_Pos                    (16U)
#define HASH_CR_LKEY_Msk                    (0x1UL << HASH_CR_LKEY_Pos)             /*!< 0x00010000 */
#define HASH_CR_LKEY                        HASH_CR_LKEY_Msk
#define HASH_CR_ALGO_Pos                    (17U)
#define HASH_CR_ALGO_Msk                    (0xFUL << HASH_CR_ALGO_Pos)             /*!< 0x001E0000 */
#define HASH_CR_ALGO                        HASH_CR_ALGO_Msk
#define HASH_CR_ALGO_0                      (0x1UL << HASH_CR_ALGO_Pos)             /*!< 0x00020000 */
#define HASH_CR_ALGO_1                      (0x2UL << HASH_CR_ALGO_Pos)             /*!< 0x00040000 */
#define HASH_CR_ALGO_2                      (0x4UL << HASH_CR_ALGO_Pos)             /*!< 0x00080000 */
#define HASH_CR_ALGO_3                      (0x8UL << HASH_CR_ALGO_Pos)             /*!< 0x00100000 */

/******************  Bits definition for HASH_STR register  *******************/
#define HASH_STR_NBLW_Pos                   (0U)
#define HASH_STR_NBLW_Msk                   (0x1FUL << HASH_STR_NBLW_Pos)           /*!< 0x0000001F */
#define HASH_STR_NBLW                       HASH_STR_NBLW_Msk
#define HASH_STR_NBLW_0                     (0x01UL << HASH_STR_NBLW_Pos)           /*!< 0x00000001 */
#define HASH_STR_NBLW_1                     (0x02UL << HASH_STR_NBLW_Pos)           /*!< 0x00000002 */
#define HASH_STR_NBLW_2                     (0x04UL << HASH_STR_NBLW_Pos)           /*!< 0x00000004 */
#define HASH_STR_NBLW_3                     (0x08UL << HASH_STR_NBLW_Pos)           /*!< 0x00000008 */
#define HASH_STR_NBLW_4                     (0x10UL << HASH_STR_NBLW_Pos)           /*!< 0x00000010 */
#define HASH_STR_DCAL_Pos                   (8U)
#define HASH_STR_DCAL_Msk                   (0x1UL << HASH_STR_DCAL_Pos)            /*!< 0x00000100 */
#define HASH_STR_DCAL                       HASH_STR_DCAL_Msk

/******************  Bits definition for HASH_IMR register  *******************/
#define HASH_IMR_DINIE_Pos                  (0U)
#define HASH_IMR_DINIE_Msk                  (0x1UL << HASH_IMR_DINIE_Pos)           /*!< 0x00000001 */
#define HASH_IMR_DINIE                      HASH_IMR_DINIE_Msk
#define HASH_IMR_DCIE_Pos                   (1U)
#define HASH_IMR_DCIE_Msk                   (0x1UL << HASH_IMR_DCIE_Pos)            /*!< 0x00000002 */
#define HASH_IMR_DCIE                       HASH_IMR_DCIE_Msk

/******************  Bits definition for HASH_SR register  ********************/
#define HASH_SR_DINIS_Pos                   (0U)
#define HASH_SR_DINIS_Msk                   (0x1UL << HASH_SR_DINIS_Pos)            /*!< 0x00000001 */
#define HASH_SR_DINIS                       HASH_SR_DINIS_Msk
#define HASH_SR_DCIS_Pos                    (1U)
#define HASH_SR_DCIS_Msk                    (0x1UL << HASH_SR_DCIS_Pos)             /*!< 0x00000002 */
#define HASH_SR_DCIS                        HASH_SR_DCIS_Msk
#define HASH_SR_DMAS_Pos                    (2U)
#define HASH_SR_DMAS_Msk                    (0x1UL << HASH_SR_DMAS_Pos)             /*!< 0x00000004 */
#define HASH_SR_DMAS                        HASH_SR_DMAS_Msk
#define HASH_SR_BUSY_Pos                    (3U)
#define HASH_SR_BUSY_Msk                    (0x1UL << HASH_SR_BUSY_Pos)             /*!< 0x00000008 */
#define HASH_SR_BUSY                        HASH_SR_BUSY_Msk
#define HASH_SR_NBWE_Pos                    (16U)
#define HASH_SR_NBWE_Msk                    (0xFUL << HASH_SR_NBWE_Pos)             /*!< 0x000F0000 */
#define HASH_SR_NBWE                        HASH_SR_NBWE_Msk
#define HASH_SR_NBWE_0                      (0x01UL << HASH_SR_NBWE_Pos)            /*!< 0x00010000 */
#define HASH_SR_NBWE_1                      (0x02UL << HASH_SR_NBWE_Pos)            /*!< 0x00020000 */
#define HASH_SR_NBWE_2                      (0x04UL << HASH_SR_NBWE_Pos)            /*!< 0x00040000 */
#define HASH_SR_NBWE_3                      (0x08UL << HASH_SR_NBWE_Pos)            /*!< 0x00080000 */
#define HASH_SR_DINNE_Pos                   (15U)
#define HASH_SR_DINNE_Msk                   (0x1UL << HASH_SR_DINNE_Pos)            /*!< 0x00008000 */
#define HASH_SR_DINNE                       HASH_SR_DINNE_Msk
#define HASH_SR_NBWP_Pos                    (9U)
#define HASH_SR_NBWP_Msk                    (0xFUL << HASH_SR_NBWP_Pos)             /*!< 0x000F0000 */
#define HASH_SR_NBWP                        HASH_SR_NBWP_Msk
#define HASH_SR_NBWP_0                      (0x01UL << HASH_SR_NBWP_Pos)            /*!< 0x000O0200 */
#define HASH_SR_NBWP_1                      (0x02UL << HASH_SR_NBWP_Pos)            /*!< 0x00000400 */
#define HASH_SR_NBWP_2                      (0x04UL << HASH_SR_NBWP_Pos)            /*!< 0x00000800 */
#define HASH_SR_NBWP_3                      (0x08UL << HASH_SR_NBWP_Pos)            /*!< 0x00001000 */


/******************************************************************************/
/*                                                                            */
/*                                 Debug MCU                                  */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DBGMCU_IDCODE register  *************/
#define DBGMCU_IDCODE_DEV_ID_Pos            (0U)
#define DBGMCU_IDCODE_DEV_ID_Msk            (0xFFFUL << DBGMCU_IDCODE_DEV_ID_Pos)   /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                DBGMCU_IDCODE_DEV_ID_Msk
#define DBGMCU_IDCODE_REV_ID_Pos            (16U)
#define DBGMCU_IDCODE_REV_ID_Msk            (0xFFFFUL << DBGMCU_IDCODE_REV_ID_Pos)  /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                DBGMCU_IDCODE_REV_ID_Msk

/********************  Bit definition for DBGMCU_CR register  *****************/
#define DBGMCU_CR_DBG_STOP_Pos              (1U)
#define DBGMCU_CR_DBG_STOP_Msk              (0x1UL << DBGMCU_CR_DBG_STOP_Pos)       /*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                  DBGMCU_CR_DBG_STOP_Msk
#define DBGMCU_CR_DBG_STANDBY_Pos           (2U)
#define DBGMCU_CR_DBG_STANDBY_Msk           (0x1UL << DBGMCU_CR_DBG_STANDBY_Pos)    /*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY               DBGMCU_CR_DBG_STANDBY_Msk
#define DBGMCU_CR_TRACE_IOEN_Pos            (4U)
#define DBGMCU_CR_TRACE_IOEN_Msk            (0x1UL << DBGMCU_CR_TRACE_IOEN_Pos)     /*!< 0x00000010 */
#define DBGMCU_CR_TRACE_IOEN                DBGMCU_CR_TRACE_IOEN_Msk
#define DBGMCU_CR_TRACE_CLKEN_Pos           (5U)
#define DBGMCU_CR_TRACE_CLKEN_Msk           (0x1UL << DBGMCU_CR_TRACE_CLKEN_Pos)    /*!< 0x00000020 */
#define DBGMCU_CR_TRACE_CLKEN               DBGMCU_CR_TRACE_CLKEN_Msk
#define DBGMCU_CR_TRACE_MODE_Pos            (6U)
#define DBGMCU_CR_TRACE_MODE_Msk            (0x3UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x000000C0 */
#define DBGMCU_CR_TRACE_MODE                DBGMCU_CR_TRACE_MODE_Msk
#define DBGMCU_CR_TRACE_MODE_0              (0x1UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x00000040 */
#define DBGMCU_CR_TRACE_MODE_1              (0x2UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x00000080 */
#define DBGMCU_CR_DCRT_Pos                  (16U)
#define DBGMCU_CR_DCRT_Msk                  (0x1UL << DBGMCU_CR_DCRT_Pos)           /*!< 0x00010000 */
#define DBGMCU_CR_DCRT                      DBGMCU_CR_DCRT_Msk

/********************  Bit definition for DBGMCU_APB1FZR1 register  ***********/
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP_Pos   (0U)
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM2_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP       DBGMCU_APB1FZR1_DBG_TIM2_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP_Pos   (1U)
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM3_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP       DBGMCU_APB1FZR1_DBG_TIM3_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP_Pos   (2U)
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM4_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP       DBGMCU_APB1FZR1_DBG_TIM4_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP_Pos   (3U)
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM5_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP       DBGMCU_APB1FZR1_DBG_TIM5_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP_Pos   (4U)
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM6_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP       DBGMCU_APB1FZR1_DBG_TIM6_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP_Pos   (5U)
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM7_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP       DBGMCU_APB1FZR1_DBG_TIM7_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM12_STOP_Pos  (6U)
#define DBGMCU_APB1FZR1_DBG_TIM12_STOP_Msk  (0x1UL << DBGMCU_APB1FZR1_DBG_TIM12_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM12_STOP      DBGMCU_APB1FZR1_DBG_TIM12_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM13_STOP_Pos  (7U)
#define DBGMCU_APB1FZR1_DBG_TIM13_STOP_Msk  (0x1UL << DBGMCU_APB1FZR1_DBG_TIM13_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM13_STOP      DBGMCU_APB1FZR1_DBG_TIM13_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM14_STOP_Pos  (8U)
#define DBGMCU_APB1FZR1_DBG_TIM14_STOP_Msk  (0x1UL << DBGMCU_APB1FZR1_DBG_TIM14_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM14_STOP      DBGMCU_APB1FZR1_DBG_TIM14_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos   (11U)
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP       DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos   (12U)
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP       DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos   (21U)
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP       DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP_Pos   (22U)
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_I2C2_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP       DBGMCU_APB1FZR1_DBG_I2C2_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I3C1_STOP_Pos   (23U)
#define DBGMCU_APB1FZR1_DBG_I3C1_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_I3C1_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_I3C1_STOP       DBGMCU_APB1FZR1_DBG_I3C1_STOP_Msk

/********************  Bit definition for DBGMCU_APB1FZR2 register  ***********/
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos (5U)
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk (0x1UL << DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos)
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP     DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk

/********************  Bit definition for DBGMCU_APB2FZR register  ***********/
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos    (11U)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk    (0x1UL << DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP        DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM8_STOP_Pos    (13U)
#define DBGMCU_APB2FZR_DBG_TIM8_STOP_Msk    (0x1UL << DBGMCU_APB2FZR_DBG_TIM8_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM8_STOP        DBGMCU_APB2FZR_DBG_TIM8_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM15_STOP_Pos   (16U)
#define DBGMCU_APB2FZR_DBG_TIM15_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM15_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM15_STOP       DBGMCU_APB2FZR_DBG_TIM15_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos   (17U)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP       DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos   (18U)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP       DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk

/********************  Bit definition for DBGMCU_APB3FZR register  ***********/
#define DBGMCU_APB3FZR_DBG_I2C3_STOP_Pos    (10U)
#define DBGMCU_APB3FZR_DBG_I2C3_STOP_Msk    (0x1UL << DBGMCU_APB3FZR_DBG_I2C3_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_I2C3_STOP        DBGMCU_APB3FZR_DBG_I2C3_STOP_Msk
#define DBGMCU_APB3FZR_DBG_I2C4_STOP_Pos    (11U)
#define DBGMCU_APB3FZR_DBG_I2C4_STOP_Msk    (0x1UL << DBGMCU_APB3FZR_DBG_I2C4_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_I2C4_STOP        DBGMCU_APB3FZR_DBG_I2C4_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Pos  (17U)
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP      DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Pos  (18U)
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP      DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Pos  (19U)
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP      DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM5_STOP_Pos  (20U)
#define DBGMCU_APB3FZR_DBG_LPTIM5_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM5_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM5_STOP      DBGMCU_APB3FZR_DBG_LPTIM5_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM6_STOP_Pos  (21U)
#define DBGMCU_APB3FZR_DBG_LPTIM6_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM6_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM6_STOP      DBGMCU_APB3FZR_DBG_LPTIM6_STOP_Msk
#define DBGMCU_APB3FZR_DBG_RTC_STOP_Pos     (30U)
#define DBGMCU_APB3FZR_DBG_RTC_STOP_Msk     (0x1UL << DBGMCU_APB3FZR_DBG_RTC_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_RTC_STOP         DBGMCU_APB3FZR_DBG_RTC_STOP_Msk

/********************  Bit definition for DBGMCU_AHB1FZR register  ***********/
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP_Pos  (0U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH0_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP_Pos  (1U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH1_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP_Pos  (2U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH2_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP_Pos  (3U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH3_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP_Pos  (4U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH4_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP_Pos  (5U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH5_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP_Pos  (6U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH6_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP_Pos  (7U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH7_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH8_STOP_Pos  (8U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH8_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH8_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH8_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH8_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH9_STOP_Pos  (9U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH9_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH9_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH9_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_CH9_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH10_STOP_Pos (10U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH10_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH10_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH10_STOP     DBGMCU_AHB1FZR_DBG_GPDMA1_CH10_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH11_STOP_Pos (11U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH11_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH11_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH11_STOP     DBGMCU_AHB1FZR_DBG_GPDMA1_CH11_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH12_STOP_Pos (12U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH12_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH12_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH12_STOP     DBGMCU_AHB1FZR_DBG_GPDMA1_CH12_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH13_STOP_Pos (13U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH13_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH13_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH13_STOP     DBGMCU_AHB1FZR_DBG_GPDMA1_CH13_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH14_STOP_Pos (14U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH14_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH14_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH14_STOP     DBGMCU_AHB1FZR_DBG_GPDMA1_CH14_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH15_STOP_Pos (15U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH15_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_CH15_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_CH15_STOP     DBGMCU_AHB1FZR_DBG_GPDMA1_CH15_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH0_STOP_Pos  (16U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH0_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH0_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH0_STOP      DBGMCU_AHB1FZR_DBG_GPDMA2_CH0_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH1_STOP_Pos (17U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH1_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH1_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH1_STOP      DBGMCU_AHB1FZR_DBG_GPDMA2_CH1_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH2_STOP_Pos (18U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH2_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH2_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH2_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH2_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH3_STOP_Pos (19U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH3_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH3_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH3_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH3_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH4_STOP_Pos (20U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH4_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH4_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH4_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH4_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH5_STOP_Pos (21U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH5_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH5_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH5_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH5_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH6_STOP_Pos (22U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH6_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH6_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH6_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH6_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH7_STOP_Pos (23U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH7_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH7_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH7_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH7_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH8_STOP_Pos (24U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH8_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH8_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH8_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH8_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH9_STOP_Pos (25U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH9_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH9_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH9_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH9_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH10_STOP_Pos (26U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH10_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH10_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH10_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH10_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH11_STOP_Pos (27U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH11_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH11_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH11_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH11_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH12_STOP_Pos (28U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH12_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH12_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH12_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH12_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH13_STOP_Pos (29U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH13_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH13_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH13_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH13_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH14_STOP_Pos (30U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH14_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH14_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH14_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH14_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH15_STOP_Pos (31U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH15_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_CH15_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_CH15_STOP     DBGMCU_AHB1FZR_DBG_GPDMA2_CH15_STOP_Msk

/********************  Bit definition for DBGMCU_SR register  ***********/
#define DBGMCU_SR_ACC_PORT_PRES_Pos          (0U)
#define DBGMCU_SR_ACC_PORT_PRES_Msk          (0xFFFFUL << DBGMCU_SR_ACC_PORT_PRES_Pos)   /*!< 0x0000FFFF */
#define DBGMCU_SR_ACC_PORT_PRES              DBGMCU_SR_ACC_PORT_PRES_Msk
#define DBGMCU_SR_ACC_PORT_ENBL_Pos          (16U)
#define DBGMCU_SR_ACC_PORT_ENBL_Msk          (0xFFFFUL << DBGMCU_SR_ACC_PORT_ENBL_Pos)   /*!< 0xFFFF0000 */
#define DBGMCU_SR_ACC_PORT_ENBL              DBGMCU_SR_ACC_PORT_ENBL_Msk

/********************  Bit definition for DBGMCU_DBG_AUTH_HOST register  ***********/
#define DBGMCU_DBG_AUTH_HOST_Pos             (0U)
#define DBGMCU_DBG_AUTH_HOST_Msk             (0xFFFFFFFFUL << DBGMCU_DBG_AUTH_HOST_Pos)  /*!< 0xFFFFFFFF */
#define DBGMCU_DBG_AUTH_HOST                 DBGMCU_DBG_AUTH_HOST_Msk

/********************  Bit definition for DBGMCU_DBG_AUTH_DEV register  ***********/
#define DBGMCU_DBG_AUTH_DEV_Pos              (0U)
#define DBGMCU_DBG_AUTH_DEV_Msk              (0xFFFFFFFFUL << DBGMCU_DBG_AUTH_DEV_Pos)   /*!< 0xFFFFFFFF */
#define DBGMCU_DBG_AUTH_DEV                  DBGMCU_DBG_AUTH_DEV_Msk

/********************  Bit definition for DBGMCU_DBG_AUTH_ACK register  ***********/
#define DBGMCU_DBG_AUTH_ACK_HOST_Pos         (0U)
#define DBGMCU_DBG_AUTH_ACK_HOST_Msk         (0x1UL << DBGMCU_DBG_AUTH_ACK_HOST_Pos)     /*!< 0x00000001 */
#define DBGMCU_DBG_AUTH_ACK_HOST             DBGMCU_DBG_AUTH_ACK_HOST_Msk
#define DBGMCU_DBG_AUTH_ACK_DEV_Pos          (1U)
#define DBGMCU_DBG_AUTH_ACK_DEV_Msk          (0x1UL << DBGMCU_DBG_AUTH_ACK_DEV_Pos)      /*!< 0x00000002 */
#define DBGMCU_DBG_AUTH_ACK_DEV              DBGMCU_DBG_AUTH_ACK_DEV_Msk

/********************  Bit definition for DBGMCU_PIDR4 register  ************/
#define DBGMCU_PIDR4_JEP106CON_Pos           (0U)
#define DBGMCU_PIDR4_JEP106CON_Msk           (0xFUL << DBGMCU_PIDR4_JEP106CON_Pos)    /*!< 0x0000000F */
#define DBGMCU_PIDR4_JEP106CON               DBGMCU_PIDR4_JEP106CON_Msk
#define DBGMCU_PIDR4_4KCOUNT_Pos             (4U)
#define DBGMCU_PIDR4_4KCOUNT_Msk             (0xFUL << DBGMCU_PIDR4_4KCOUNT_Pos)      /*!< 0x000000F0 */
#define DBGMCU_PIDR4_4KCOUNT                 DBGMCU_PIDR4_4KCOUNT_Msk

/********************  Bit definition for DBGMCU_PIDR0 register  ************/
#define DBGMCU_PIDR0_PARTNUM_Pos             (0U)
#define DBGMCU_PIDR0_PARTNUM_Msk             (0xFFUL << DBGMCU_PIDR0_PARTNUM_Pos)     /*!< 0x000000FF */
#define DBGMCU_PIDR0_PARTNUM                 DBGMCU_PIDR0_PARTNUM_Msk

/********************  Bit definition for DBGMCU_PIDR1 register  ************/
#define DBGMCU_PIDR1_PARTNUM_Pos             (0U)
#define DBGMCU_PIDR1_PARTNUM_Msk             (0xFUL << DBGMCU_PIDR1_PARTNUM_Pos)      /*!< 0x0000000F */
#define DBGMCU_PIDR1_PARTNUM                 DBGMCU_PIDR1_PARTNUM_Msk
#define DBGMCU_PIDR1_JEP106ID_Pos            (4U)
#define DBGMCU_PIDR1_JEP106ID_Msk            (0xFUL << DBGMCU_PIDR1_JEP106ID_Pos)     /*!< 0x000000F0 */
#define DBGMCU_PIDR1_JEP106ID                DBGMCU_PIDR1_JEP106ID_Msk

/********************  Bit definition for DBGMCU_PIDR2 register  ************/
#define DBGMCU_PIDR2_JEP106ID_Pos            (0U)
#define DBGMCU_PIDR2_JEP106ID_Msk            (0x7UL << DBGMCU_PIDR2_JEP106ID_Pos)     /*!< 0x00000007 */
#define DBGMCU_PIDR2_JEP106ID                DBGMCU_PIDR2_JEP106ID_Msk
#define DBGMCU_PIDR2_JEDEC_Pos               (3U)
#define DBGMCU_PIDR2_JEDEC_Msk               (0x1UL << DBGMCU_PIDR2_JEDEC_Pos)        /*!< 0x00000008 */
#define DBGMCU_PIDR2_JEDEC                   DBGMCU_PIDR2_JEDEC_Msk
#define DBGMCU_PIDR2_REVISION_Pos            (4U)
#define DBGMCU_PIDR2_REVISION_Msk            (0xFUL << DBGMCU_PIDR2_REVISION_Pos)     /*!< 0x000000F0 */
#define DBGMCU_PIDR2_REVISION                DBGMCU_PIDR2_REVISION_Msk

/********************  Bit definition for DBGMCU_PIDR3 register  ************/
#define DBGMCU_PIDR3_CMOD_Pos                (0U)
#define DBGMCU_PIDR3_CMOD_Msk                (0xFUL << DBGMCU_PIDR3_CMOD_Pos)         /*!< 0x0000000F */
#define DBGMCU_PIDR3_CMOD                    DBGMCU_PIDR3_CMOD_Msk
#define DBGMCU_PIDR3_REVAND_Pos              (4U)
#define DBGMCU_PIDR3_REVAND_Msk              (0xFUL << DBGMCU_PIDR3_REVAND_Pos)       /*!< 0x000000F0 */
#define DBGMCU_PIDR3_REVAND                  DBGMCU_PIDR3_REVAND_Msk

/********************  Bit definition for DBGMCU_CIDR0 register  ************/
#define DBGMCU_CIDR0_PREAMBLE_Pos            (0U)
#define DBGMCU_CIDR0_PREAMBLE_Msk            (0xFFUL << DBGMCU_CIDR0_PREAMBLE_Pos)    /*!< 0x000000FF */
#define DBGMCU_CIDR0_PREAMBLE                DBGMCU_CIDR0_PREAMBLE_Msk

/********************  Bit definition for DBGMCU_CIDR1 register  ************/
#define DBGMCU_CIDR1_PREAMBLE_Pos            (0U)
#define DBGMCU_CIDR1_PREAMBLE_Msk            (0xFUL << DBGMCU_CIDR1_PREAMBLE_Pos)     /*!< 0x0000000F */
#define DBGMCU_CIDR1_PREAMBLE                DBGMCU_CIDR1_PREAMBLE_Msk
#define DBGMCU_CIDR1_CLASS_Pos               (4U)
#define DBGMCU_CIDR1_CLASS_Msk               (0xFUL << DBGMCU_CIDR1_CLASS_Pos)        /*!< 0x000000F0 */
#define DBGMCU_CIDR1_CLASS                   DBGMCU_CIDR1_CLASS_Msk

/********************  Bit definition for DBGMCU_CIDR2 register  ************/
#define DBGMCU_CIDR2_PREAMBLE_Pos            (0U)
#define DBGMCU_CIDR2_PREAMBLE_Msk            (0xFFUL << DBGMCU_CIDR2_PREAMBLE_Pos)    /*!< 0x000000FF */
#define DBGMCU_CIDR2_PREAMBLE                DBGMCU_CIDR2_PREAMBLE_Msk

/********************  Bit definition for DBGMCU_CIDR3 register  ************/
#define DBGMCU_CIDR3_PREAMBLE_Pos            (0U)
#define DBGMCU_CIDR3_PREAMBLE_Msk            (0xFFUL << DBGMCU_CIDR3_PREAMBLE_Pos)    /*!< 0x000000FF */
#define DBGMCU_CIDR3_PREAMBLE                DBGMCU_CIDR3_PREAMBLE_Msk
/******************************************************************************/
/*                                                                            */
/*                                    DCMI                                    */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DCMI_CR register  ******************/
#define DCMI_CR_CAPTURE_Pos                 (0U)
#define DCMI_CR_CAPTURE_Msk                 (0x1UL << DCMI_CR_CAPTURE_Pos)          /*!< 0x00000001 */
#define DCMI_CR_CAPTURE                     DCMI_CR_CAPTURE_Msk
#define DCMI_CR_CM_Pos                      (1U)
#define DCMI_CR_CM_Msk                      (0x1UL << DCMI_CR_CM_Pos)               /*!< 0x00000002 */
#define DCMI_CR_CM                          DCMI_CR_CM_Msk
#define DCMI_CR_CROP_Pos                    (2U)
#define DCMI_CR_CROP_Msk                    (0x1UL << DCMI_CR_CROP_Pos)             /*!< 0x00000004 */
#define DCMI_CR_CROP                        DCMI_CR_CROP_Msk
#define DCMI_CR_JPEG_Pos                    (3U)
#define DCMI_CR_JPEG_Msk                    (0x1UL << DCMI_CR_JPEG_Pos)             /*!< 0x00000008 */
#define DCMI_CR_JPEG                        DCMI_CR_JPEG_Msk
#define DCMI_CR_ESS_Pos                     (4U)
#define DCMI_CR_ESS_Msk                     (0x1UL << DCMI_CR_ESS_Pos)              /*!< 0x00000010 */
#define DCMI_CR_ESS                         DCMI_CR_ESS_Msk
#define DCMI_CR_PCKPOL_Pos                  (5U)
#define DCMI_CR_PCKPOL_Msk                  (0x1UL << DCMI_CR_PCKPOL_Pos)           /*!< 0x00000020 */
#define DCMI_CR_PCKPOL                      DCMI_CR_PCKPOL_Msk
#define DCMI_CR_HSPOL_Pos                   (6U)
#define DCMI_CR_HSPOL_Msk                   (0x1UL << DCMI_CR_HSPOL_Pos)            /*!< 0x00000040 */
#define DCMI_CR_HSPOL                       DCMI_CR_HSPOL_Msk
#define DCMI_CR_VSPOL_Pos                   (7U)
#define DCMI_CR_VSPOL_Msk                   (0x1UL << DCMI_CR_VSPOL_Pos)            /*!< 0x00000080 */
#define DCMI_CR_VSPOL                       DCMI_CR_VSPOL_Msk
#define DCMI_CR_FCRC_Pos                    (8U)
#define DCMI_CR_FCRC_Msk                    (0x3UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000300 */
#define DCMI_CR_FCRC                        DCMI_CR_FCRC_Msk                        /*!< DCMI Frame capture rate control FCRC[1:0] */
#define DCMI_CR_FCRC_0                      (0x1UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000100 */
#define DCMI_CR_FCRC_1                      (0x2UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000200 */
#define DCMI_CR_EDM_Pos                     (10U)
#define DCMI_CR_EDM_Msk                     (0x3UL << DCMI_CR_EDM_Pos)              /*!< 0x00000C00 */
#define DCMI_CR_EDM                         DCMI_CR_EDM_Msk                         /*!< DCMI Extended data mode EDM[1:0] */
#define DCMI_CR_EDM_0                       (0x1UL << DCMI_CR_EDM_Pos)              /*!< 0x00000400 */
#define DCMI_CR_EDM_1                       (0x2UL << DCMI_CR_EDM_Pos)              /*!< 0x00000800 */
#define DCMI_CR_ENABLE_Pos                  (14U)
#define DCMI_CR_ENABLE_Msk                  (0x1UL << DCMI_CR_ENABLE_Pos)           /*!< 0x00004000 */
#define DCMI_CR_ENABLE                      DCMI_CR_ENABLE_Msk
#define DCMI_CR_BSM_Pos                     (16U)
#define DCMI_CR_BSM_Msk                     (0x3UL << DCMI_CR_BSM_Pos)              /*!< 0x00030000 */
#define DCMI_CR_BSM                         DCMI_CR_BSM_Msk
#define DCMI_CR_BSM_0                       (0x1UL << DCMI_CR_BSM_Pos)              /*!< 0x00010000 */
#define DCMI_CR_BSM_1                       (0x2UL << DCMI_CR_BSM_Pos)              /*!< 0x00020000 */
#define DCMI_CR_OEBS_Pos                    (18U)
#define DCMI_CR_OEBS_Msk                    (0x1UL << DCMI_CR_OEBS_Pos)             /*!< 0x00040000 */
#define DCMI_CR_OEBS                        DCMI_CR_OEBS_Msk
#define DCMI_CR_LSM_Pos                     (19U)
#define DCMI_CR_LSM_Msk                     (0x1UL << DCMI_CR_LSM_Pos)              /*!< 0x00080000 */
#define DCMI_CR_LSM                         DCMI_CR_LSM_Msk
#define DCMI_CR_OELS_Pos                    (20U)
#define DCMI_CR_OELS_Msk                    (0x1UL << DCMI_CR_OELS_Pos)             /*!< 0x00100000 */
#define DCMI_CR_OELS                        DCMI_CR_OELS_Msk
#define DCMI_CR_PSDM_Pos                    (31U)
#define DCMI_CR_PSDM_Msk                    (0x0UL << DCMI_CR_PSDM_Pos)             /*!< 0x00000000 */
#define DCMI_CR_PSDM                        DCMI_CR_PSDM_Msk                        /*PSDM: Parallel Synchronous raw Data Mode (PSDM = 0)*/

/********************  Bits definition for DCMI_SR register  ******************/
#define DCMI_SR_HSYNC_Pos                   (0U)
#define DCMI_SR_HSYNC_Msk                   (0x1UL << DCMI_SR_HSYNC_Pos)            /*!< 0x00000001 */
#define DCMI_SR_HSYNC                       DCMI_SR_HSYNC_Msk
#define DCMI_SR_VSYNC_Pos                   (1U)
#define DCMI_SR_VSYNC_Msk                   (0x1UL << DCMI_SR_VSYNC_Pos)            /*!< 0x00000002 */
#define DCMI_SR_VSYNC                       DCMI_SR_VSYNC_Msk
#define DCMI_SR_FNE_Pos                     (2U)
#define DCMI_SR_FNE_Msk                     (0x1UL << DCMI_SR_FNE_Pos)              /*!< 0x00000004 */
#define DCMI_SR_FNE                         DCMI_SR_FNE_Msk

/********************  Bits definition for DCMI_RIS register   ****************/
#define DCMI_RIS_FRAME_RIS_Pos              (0U)
#define DCMI_RIS_FRAME_RIS_Msk              (0x1UL << DCMI_RIS_FRAME_RIS_Pos)       /*!< 0x00000001 */
#define DCMI_RIS_FRAME_RIS                  DCMI_RIS_FRAME_RIS_Msk
#define DCMI_RIS_OVR_RIS_Pos                (1U)
#define DCMI_RIS_OVR_RIS_Msk                (0x1UL << DCMI_RIS_OVR_RIS_Pos)         /*!< 0x00000002 */
#define DCMI_RIS_OVR_RIS                    DCMI_RIS_OVR_RIS_Msk
#define DCMI_RIS_ERR_RIS_Pos                (2U)
#define DCMI_RIS_ERR_RIS_Msk                (0x1UL << DCMI_RIS_ERR_RIS_Pos)         /*!< 0x00000004 */
#define DCMI_RIS_ERR_RIS                    DCMI_RIS_ERR_RIS_Msk
#define DCMI_RIS_VSYNC_RIS_Pos              (3U)
#define DCMI_RIS_VSYNC_RIS_Msk              (0x1UL << DCMI_RIS_VSYNC_RIS_Pos)       /*!< 0x00000008 */
#define DCMI_RIS_VSYNC_RIS                  DCMI_RIS_VSYNC_RIS_Msk
#define DCMI_RIS_LINE_RIS_Pos               (4U)
#define DCMI_RIS_LINE_RIS_Msk               (0x1UL << DCMI_RIS_LINE_RIS_Pos)        /*!< 0x00000010 */
#define DCMI_RIS_LINE_RIS                   DCMI_RIS_LINE_RIS_Msk

/********************  Bits definition for DCMI_IER register  *****************/
#define DCMI_IER_FRAME_IE_Pos               (0U)
#define DCMI_IER_FRAME_IE_Msk               (0x1UL << DCMI_IER_FRAME_IE_Pos)        /*!< 0x00000001 */
#define DCMI_IER_FRAME_IE                   DCMI_IER_FRAME_IE_Msk
#define DCMI_IER_OVR_IE_Pos                 (1U)
#define DCMI_IER_OVR_IE_Msk                 (0x1UL << DCMI_IER_OVR_IE_Pos)          /*!< 0x00000002 */
#define DCMI_IER_OVR_IE                     DCMI_IER_OVR_IE_Msk
#define DCMI_IER_ERR_IE_Pos                 (2U)
#define DCMI_IER_ERR_IE_Msk                 (0x1UL << DCMI_IER_ERR_IE_Pos)          /*!< 0x00000004 */
#define DCMI_IER_ERR_IE                     DCMI_IER_ERR_IE_Msk
#define DCMI_IER_VSYNC_IE_Pos               (3U)
#define DCMI_IER_VSYNC_IE_Msk               (0x1UL << DCMI_IER_VSYNC_IE_Pos)        /*!< 0x00000008 */
#define DCMI_IER_VSYNC_IE                   DCMI_IER_VSYNC_IE_Msk
#define DCMI_IER_LINE_IE_Pos                (4U)
#define DCMI_IER_LINE_IE_Msk                (0x1UL << DCMI_IER_LINE_IE_Pos)         /*!< 0x00000010 */
#define DCMI_IER_LINE_IE                    DCMI_IER_LINE_IE_Msk


/********************  Bits definition for DCMI_MIS register  *****************/
#define DCMI_MIS_FRAME_MIS_Pos              (0U)
#define DCMI_MIS_FRAME_MIS_Msk              (0x1UL << DCMI_MIS_FRAME_MIS_Pos)       /*!< 0x00000001 */
#define DCMI_MIS_FRAME_MIS                  DCMI_MIS_FRAME_MIS_Msk
#define DCMI_MIS_OVR_MIS_Pos                (1U)
#define DCMI_MIS_OVR_MIS_Msk                (0x1UL << DCMI_MIS_OVR_MIS_Pos)         /*!< 0x00000002 */
#define DCMI_MIS_OVR_MIS                    DCMI_MIS_OVR_MIS_Msk
#define DCMI_MIS_ERR_MIS_Pos                (2U)
#define DCMI_MIS_ERR_MIS_Msk                (0x1UL << DCMI_MIS_ERR_MIS_Pos)         /*!< 0x00000004 */
#define DCMI_MIS_ERR_MIS                    DCMI_MIS_ERR_MIS_Msk
#define DCMI_MIS_VSYNC_MIS_Pos              (3U)
#define DCMI_MIS_VSYNC_MIS_Msk              (0x1UL << DCMI_MIS_VSYNC_MIS_Pos)       /*!< 0x00000008 */
#define DCMI_MIS_VSYNC_MIS                  DCMI_MIS_VSYNC_MIS_Msk
#define DCMI_MIS_LINE_MIS_Pos               (4U)
#define DCMI_MIS_LINE_MIS_Msk               (0x1UL << DCMI_MIS_LINE_MIS_Pos)        /*!< 0x00000010 */
#define DCMI_MIS_LINE_MIS                   DCMI_MIS_LINE_MIS_Msk


/********************  Bits definition for DCMI_ICR register  *****************/
#define DCMI_ICR_FRAME_ISC_Pos              (0U)
#define DCMI_ICR_FRAME_ISC_Msk              (0x1UL << DCMI_ICR_FRAME_ISC_Pos)       /*!< 0x00000001 */
#define DCMI_ICR_FRAME_ISC                  DCMI_ICR_FRAME_ISC_Msk
#define DCMI_ICR_OVR_ISC_Pos                (1U)
#define DCMI_ICR_OVR_ISC_Msk                (0x1UL << DCMI_ICR_OVR_ISC_Pos)         /*!< 0x00000002 */
#define DCMI_ICR_OVR_ISC                    DCMI_ICR_OVR_ISC_Msk
#define DCMI_ICR_ERR_ISC_Pos                (2U)
#define DCMI_ICR_ERR_ISC_Msk                (0x1UL << DCMI_ICR_ERR_ISC_Pos)         /*!< 0x00000004 */
#define DCMI_ICR_ERR_ISC                    DCMI_ICR_ERR_ISC_Msk
#define DCMI_ICR_VSYNC_ISC_Pos              (3U)
#define DCMI_ICR_VSYNC_ISC_Msk              (0x1UL << DCMI_ICR_VSYNC_ISC_Pos)       /*!< 0x00000008 */
#define DCMI_ICR_VSYNC_ISC                  DCMI_ICR_VSYNC_ISC_Msk
#define DCMI_ICR_LINE_ISC_Pos               (4U)
#define DCMI_ICR_LINE_ISC_Msk               (0x1UL << DCMI_ICR_LINE_ISC_Pos)        /*!< 0x00000010 */
#define DCMI_ICR_LINE_ISC                   DCMI_ICR_LINE_ISC_Msk


/********************  Bits definition for DCMI_ESCR register  ******************/
#define DCMI_ESCR_FSC_Pos                   (0U)
#define DCMI_ESCR_FSC_Msk                   (0xFFUL << DCMI_ESCR_FSC_Pos)           /*!< 0x000000FF */
#define DCMI_ESCR_FSC                       DCMI_ESCR_FSC_Msk
#define DCMI_ESCR_LSC_Pos                   (8U)
#define DCMI_ESCR_LSC_Msk                   (0xFFUL << DCMI_ESCR_LSC_Pos)           /*!< 0x0000FF00 */
#define DCMI_ESCR_LSC                       DCMI_ESCR_LSC_Msk
#define DCMI_ESCR_LEC_Pos                   (16U)
#define DCMI_ESCR_LEC_Msk                   (0xFFUL << DCMI_ESCR_LEC_Pos)           /*!< 0x00FF0000 */
#define DCMI_ESCR_LEC                       DCMI_ESCR_LEC_Msk
#define DCMI_ESCR_FEC_Pos                   (24U)
#define DCMI_ESCR_FEC_Msk                   (0xFFUL << DCMI_ESCR_FEC_Pos)           /*!< 0xFF000000 */
#define DCMI_ESCR_FEC                       DCMI_ESCR_FEC_Msk

/********************  Bits definition for DCMI_ESUR register  ******************/
#define DCMI_ESUR_FSU_Pos                   (0U)
#define DCMI_ESUR_FSU_Msk                   (0xFFUL << DCMI_ESUR_FSU_Pos)           /*!< 0x000000FF */
#define DCMI_ESUR_FSU                       DCMI_ESUR_FSU_Msk
#define DCMI_ESUR_LSU_Pos                   (8U)
#define DCMI_ESUR_LSU_Msk                   (0xFFUL << DCMI_ESUR_LSU_Pos)           /*!< 0x0000FF00 */
#define DCMI_ESUR_LSU                       DCMI_ESUR_LSU_Msk
#define DCMI_ESUR_LEU_Pos                   (16U)
#define DCMI_ESUR_LEU_Msk                   (0xFFUL << DCMI_ESUR_LEU_Pos)           /*!< 0x00FF0000 */
#define DCMI_ESUR_LEU                       DCMI_ESUR_LEU_Msk
#define DCMI_ESUR_FEU_Pos                   (24U)
#define DCMI_ESUR_FEU_Msk                   (0xFFUL << DCMI_ESUR_FEU_Pos)           /*!< 0xFF000000 */
#define DCMI_ESUR_FEU                       DCMI_ESUR_FEU_Msk

/********************  Bits definition for DCMI_CWSTRT register  ******************/
#define DCMI_CWSTRT_HOFFCNT_Pos             (0U)
#define DCMI_CWSTRT_HOFFCNT_Msk             (0x3FFFUL << DCMI_CWSTRT_HOFFCNT_Pos)   /*!< 0x00003FFF */
#define DCMI_CWSTRT_HOFFCNT                 DCMI_CWSTRT_HOFFCNT_Msk
#define DCMI_CWSTRT_VST_Pos                 (16U)
#define DCMI_CWSTRT_VST_Msk                 (0x1FFFUL << DCMI_CWSTRT_VST_Pos)       /*!< 0x1FFF0000 */
#define DCMI_CWSTRT_VST                     DCMI_CWSTRT_VST_Msk

/********************  Bits definition for DCMI_CWSIZE register  ******************/
#define DCMI_CWSIZE_CAPCNT_Pos              (0U)
#define DCMI_CWSIZE_CAPCNT_Msk              (0x3FFFUL << DCMI_CWSIZE_CAPCNT_Pos)    /*!< 0x00003FFF */
#define DCMI_CWSIZE_CAPCNT                  DCMI_CWSIZE_CAPCNT_Msk
#define DCMI_CWSIZE_VLINE_Pos               (16U)
#define DCMI_CWSIZE_VLINE_Msk               (0x3FFFUL << DCMI_CWSIZE_VLINE_Pos)     /*!< 0x3FFF0000 */
#define DCMI_CWSIZE_VLINE                   DCMI_CWSIZE_VLINE_Msk

/********************  Bits definition for DCMI_DR register  ******************/
#define DCMI_DR_BYTE0_Pos                   (0U)
#define DCMI_DR_BYTE0_Msk                   (0xFFUL << DCMI_DR_BYTE0_Pos)           /*!< 0x000000FF */
#define DCMI_DR_BYTE0                       DCMI_DR_BYTE0_Msk
#define DCMI_DR_BYTE1_Pos                   (8U)
#define DCMI_DR_BYTE1_Msk                   (0xFFUL << DCMI_DR_BYTE1_Pos)           /*!< 0x0000FF00 */
#define DCMI_DR_BYTE1                       DCMI_DR_BYTE1_Msk
#define DCMI_DR_BYTE2_Pos                   (16U)
#define DCMI_DR_BYTE2_Msk                   (0xFFUL << DCMI_DR_BYTE2_Pos)           /*!< 0x00FF0000 */
#define DCMI_DR_BYTE2                       DCMI_DR_BYTE2_Msk
#define DCMI_DR_BYTE3_Pos                   (24U)
#define DCMI_DR_BYTE3_Msk                   (0xFFUL << DCMI_DR_BYTE3_Pos)           /*!< 0xFF000000 */
#define DCMI_DR_BYTE3                       DCMI_DR_BYTE3_Msk
/******************************************************************************/
/*                                                                            */
/*                Ethernet MAC Registers bits definitions                     */
/*                                                                            */
/******************************************************************************/
/* Bit definition for Ethernet MAC Configuration Register register */
#define ETH_MACCR_ARP_Pos                             (31U)
#define ETH_MACCR_ARP_Msk                             (0x1UL << ETH_MACCR_ARP_Pos) /*!< 0x80000000 */
#define ETH_MACCR_ARP                                 ETH_MACCR_ARP_Msk        /* ARP Offload Enable */
#define ETH_MACCR_SARC_Pos                            (28U)
#define ETH_MACCR_SARC_Msk                            (0x7UL << ETH_MACCR_SARC_Pos) /*!< 0x70000000 */
#define ETH_MACCR_SARC                                ETH_MACCR_SARC_Msk       /* Source Address Insertion or Replacement Control */
#define ETH_MACCR_SARC_MTIATI                         ((uint32_t)0x00000000)   /* The mti_sa_ctrl_i and ati_sa_ctrl_i input signals control the SA field generation. */
#define ETH_MACCR_SARC_INSADDR0_Pos                   (29U)
#define ETH_MACCR_SARC_INSADDR0_Msk                   (0x1UL << ETH_MACCR_SARC_INSADDR0_Pos) /*!< 0x20000000 */
#define ETH_MACCR_SARC_INSADDR0                       ETH_MACCR_SARC_INSADDR0_Msk /* Insert MAC Address0 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_INSADDR1_Pos                   (29U)
#define ETH_MACCR_SARC_INSADDR1_Msk                   (0x3UL << ETH_MACCR_SARC_INSADDR1_Pos) /*!< 0x60000000 */
#define ETH_MACCR_SARC_INSADDR1                       ETH_MACCR_SARC_INSADDR1_Msk /* Insert MAC Address1 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_REPADDR0_Pos                   (28U)
#define ETH_MACCR_SARC_REPADDR0_Msk                   (0x3UL << ETH_MACCR_SARC_REPADDR0_Pos) /*!< 0x30000000 */
#define ETH_MACCR_SARC_REPADDR0                       ETH_MACCR_SARC_REPADDR0_Msk /* Replace MAC Address0 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_REPADDR1_Pos                   (28U)
#define ETH_MACCR_SARC_REPADDR1_Msk                   (0x7UL << ETH_MACCR_SARC_REPADDR1_Pos) /*!< 0x70000000 */
#define ETH_MACCR_SARC_REPADDR1                       ETH_MACCR_SARC_REPADDR1_Msk /* Replace MAC Address1 in the SA field of all transmitted packets. */
#define ETH_MACCR_IPC_Pos                             (27U)
#define ETH_MACCR_IPC_Msk                             (0x1UL << ETH_MACCR_IPC_Pos) /*!< 0x08000000 */
#define ETH_MACCR_IPC                                 ETH_MACCR_IPC_Msk        /* Checksum Offload */
#define ETH_MACCR_IPG_Pos                             (24U)
#define ETH_MACCR_IPG_Msk                             (0x7UL << ETH_MACCR_IPG_Pos) /*!< 0x07000000 */
#define ETH_MACCR_IPG                                 ETH_MACCR_IPG_Msk        /* Inter-Packet Gap */
#define ETH_MACCR_IPG_96BIT                           ((uint32_t)0x00000000)   /* Minimum IFG between Packets during transmission is 96Bit */
#define ETH_MACCR_IPG_88BIT                           ((uint32_t)0x01000000)   /* Minimum IFG between Packets during transmission is 88Bit */
#define ETH_MACCR_IPG_80BIT                           ((uint32_t)0x02000000)   /* Minimum IFG between Packets during transmission is 80Bit */
#define ETH_MACCR_IPG_72BIT                           ((uint32_t)0x03000000)   /* Minimum IFG between Packets during transmission is 72Bit */
#define ETH_MACCR_IPG_64BIT                           ((uint32_t)0x04000000)   /* Minimum IFG between Packets during transmission is 64Bit */
#define ETH_MACCR_IPG_56BIT                           ((uint32_t)0x05000000)   /* Minimum IFG between Packets during transmission is 56Bit */
#define ETH_MACCR_IPG_48BIT                           ((uint32_t)0x06000000)   /* Minimum IFG between Packets during transmission is 48Bit */
#define ETH_MACCR_IPG_40BIT                           ((uint32_t)0x07000000)   /* Minimum IFG between Packets during transmission is 40Bit */
#define ETH_MACCR_GPSLCE_Pos                          (23U)
#define ETH_MACCR_GPSLCE_Msk                          (0x1UL << ETH_MACCR_GPSLCE_Pos) /*!< 0x00800000 */
#define ETH_MACCR_GPSLCE                              ETH_MACCR_GPSLCE_Msk     /* Giant Packet Size Limit Control Enable */
#define ETH_MACCR_S2KP_Pos                            (22U)
#define ETH_MACCR_S2KP_Msk                            (0x1UL << ETH_MACCR_S2KP_Pos) /*!< 0x00400000 */
#define ETH_MACCR_S2KP                                ETH_MACCR_S2KP_Msk       /* IEEE 802.3as Support for 2K Packets */
#define ETH_MACCR_CST_Pos                             (21U)
#define ETH_MACCR_CST_Msk                             (0x1UL << ETH_MACCR_CST_Pos) /*!< 0x00200000 */
#define ETH_MACCR_CST                                 ETH_MACCR_CST_Msk        /* CRC stripping for Type packets */
#define ETH_MACCR_ACS_Pos                             (20U)
#define ETH_MACCR_ACS_Msk                             (0x1UL << ETH_MACCR_ACS_Pos) /*!< 0x00100000 */
#define ETH_MACCR_ACS                                 ETH_MACCR_ACS_Msk        /* Automatic Pad or CRC Stripping */
#define ETH_MACCR_WD_Pos                              (19U)
#define ETH_MACCR_WD_Msk                              (0x1UL << ETH_MACCR_WD_Pos) /*!< 0x00080000 */
#define ETH_MACCR_WD                                  ETH_MACCR_WD_Msk         /* Watchdog disable */
#define ETH_MACCR_JD_Pos                              (17U)
#define ETH_MACCR_JD_Msk                              (0x1UL << ETH_MACCR_JD_Pos) /*!< 0x00020000 */
#define ETH_MACCR_JD                                  ETH_MACCR_JD_Msk         /* Jabber disable */
#define ETH_MACCR_JE_Pos                              (16U)
#define ETH_MACCR_JE_Msk                              (0x1UL << ETH_MACCR_JE_Pos) /*!< 0x00010000 */
#define ETH_MACCR_JE                                  ETH_MACCR_JE_Msk         /* Jumbo Packet Enable */
#define ETH_MACCR_FES_Pos                             (14U)
#define ETH_MACCR_FES_Msk                             (0x1UL << ETH_MACCR_FES_Pos) /*!< 0x00004000 */
#define ETH_MACCR_FES                                 ETH_MACCR_FES_Msk        /* Fast ethernet speed */
#define ETH_MACCR_DM_Pos                              (13U)
#define ETH_MACCR_DM_Msk                              (0x1UL << ETH_MACCR_DM_Pos) /*!< 0x00002000 */
#define ETH_MACCR_DM                                  ETH_MACCR_DM_Msk         /* Duplex mode */
#define ETH_MACCR_LM_Pos                              (12U)
#define ETH_MACCR_LM_Msk                              (0x1UL << ETH_MACCR_LM_Pos) /*!< 0x00001000 */
#define ETH_MACCR_LM                                  ETH_MACCR_LM_Msk         /* loopback mode */
#define ETH_MACCR_ECRSFD_Pos                          (11U)
#define ETH_MACCR_ECRSFD_Msk                          (0x1UL << ETH_MACCR_ECRSFD_Pos) /*!< 0x00000800 */
#define ETH_MACCR_ECRSFD                              ETH_MACCR_ECRSFD_Msk     /* Enable Carrier Sense Before Transmission in Full-Duplex Mode */
#define ETH_MACCR_DO_Pos                              (10U)
#define ETH_MACCR_DO_Msk                              (0x1UL << ETH_MACCR_DO_Pos) /*!< 0x00000400 */
#define ETH_MACCR_DO                                  ETH_MACCR_DO_Msk         /* Disable Receive own  */
#define ETH_MACCR_DCRS_Pos                            (9U)
#define ETH_MACCR_DCRS_Msk                            (0x1UL << ETH_MACCR_DCRS_Pos) /*!< 0x00000200 */
#define ETH_MACCR_DCRS                                ETH_MACCR_DCRS_Msk       /* Disable Carrier Sense During Transmission */
#define ETH_MACCR_DR_Pos                              (8U)
#define ETH_MACCR_DR_Msk                              (0x1UL << ETH_MACCR_DR_Pos) /*!< 0x00000100 */
#define ETH_MACCR_DR                                  ETH_MACCR_DR_Msk         /* Disable Retry */
#define ETH_MACCR_BL_Pos                              (5U)
#define ETH_MACCR_BL_Msk                              (0x3UL << ETH_MACCR_BL_Pos) /*!< 0x00000060 */
#define ETH_MACCR_BL                                  ETH_MACCR_BL_Msk         /* Back-off limit mask */
#define ETH_MACCR_BL_10                               (0x0UL << ETH_MACCR_BL_Pos) /*!< 0x00000000 */
#define ETH_MACCR_BL_8                                (0x1UL << ETH_MACCR_BL_Pos) /*!< 0x00000020 */
#define ETH_MACCR_BL_4                                (0x2UL << ETH_MACCR_BL_Pos) /*!< 0x00000040 */
#define ETH_MACCR_BL_1                                (0x3UL << ETH_MACCR_BL_Pos) /*!< 0x00000060 */
#define ETH_MACCR_DC_Pos                              (4U)
#define ETH_MACCR_DC_Msk                              (0x1UL << ETH_MACCR_DC_Pos) /*!< 0x00000010 */
#define ETH_MACCR_DC                                  ETH_MACCR_DC_Msk         /* Defferal check */
#define ETH_MACCR_PRELEN_Pos                          (2U)
#define ETH_MACCR_PRELEN_Msk                          (0x3UL << ETH_MACCR_PRELEN_Pos) /*!< 0x0000000C */
#define ETH_MACCR_PRELEN                              ETH_MACCR_PRELEN_Msk     /* Preamble Length for Transmit packets */
#define ETH_MACCR_PRELEN_7                            (0x0UL << ETH_MACCR_PRELEN_Pos) /*!< 0x00000000 */
#define ETH_MACCR_PRELEN_5                            (0x1UL << ETH_MACCR_PRELEN_Pos) /*!< 0x00000004 */
#define ETH_MACCR_PRELEN_3                            (0x2UL << ETH_MACCR_PRELEN_Pos) /*!< 0x00000008 */
#define ETH_MACCR_TE_Pos                              (1U)
#define ETH_MACCR_TE_Msk                              (0x1UL << ETH_MACCR_TE_Pos) /*!< 0x00000002 */
#define ETH_MACCR_TE                                  ETH_MACCR_TE_Msk         /* Transmitter enable */
#define ETH_MACCR_RE_Pos                              (0U)
#define ETH_MACCR_RE_Msk                              (0x1UL << ETH_MACCR_RE_Pos) /*!< 0x00000001 */
#define ETH_MACCR_RE                                  ETH_MACCR_RE_Msk         /* Receiver enable */

/* Bit definition for Ethernet MAC Extended Configuration Register register */
#define ETH_MACECR_EIPG_Pos                           (25U)
#define ETH_MACECR_EIPG_Msk                           (0x1FUL << ETH_MACECR_EIPG_Pos) /*!< 0x3E000000 */
#define ETH_MACECR_EIPG                               ETH_MACECR_EIPG_Msk      /* Extended Inter-Packet Gap */
#define ETH_MACECR_EIPGEN_Pos                         (24U)
#define ETH_MACECR_EIPGEN_Msk                         (0x1UL << ETH_MACECR_EIPGEN_Pos) /*!< 0x01000000 */
#define ETH_MACECR_EIPGEN                             ETH_MACECR_EIPGEN_Msk    /* Extended Inter-Packet Gap Enable */
#define ETH_MACECR_USP_Pos                            (18U)
#define ETH_MACECR_USP_Msk                            (0x1UL << ETH_MACECR_USP_Pos) /*!< 0x00040000 */
#define ETH_MACECR_USP                                ETH_MACECR_USP_Msk       /* Unicast Slow Protocol Packet Detect */
#define ETH_MACECR_SPEN_Pos                           (17U)
#define ETH_MACECR_SPEN_Msk                           (0x1UL << ETH_MACECR_SPEN_Pos) /*!< 0x00020000 */
#define ETH_MACECR_SPEN                               ETH_MACECR_SPEN_Msk      /* Slow Protocol Detection Enable */
#define ETH_MACECR_DCRCC_Pos                          (16U)
#define ETH_MACECR_DCRCC_Msk                          (0x1UL << ETH_MACECR_DCRCC_Pos) /*!< 0x00010000 */
#define ETH_MACECR_DCRCC                              ETH_MACECR_DCRCC_Msk     /* Disable CRC Checking for Received Packets */
#define ETH_MACECR_GPSL_Pos                           (0U)
#define ETH_MACECR_GPSL_Msk                           (0x3FFFUL << ETH_MACECR_GPSL_Pos) /*!< 0x00003FFF */
#define ETH_MACECR_GPSL                               ETH_MACECR_GPSL_Msk      /* Giant Packet Size Limit */

/* Bit definition for Ethernet MAC Packet Filter Register */
#define ETH_MACPFR_RA_Pos                             (31U)
#define ETH_MACPFR_RA_Msk                             (0x1UL << ETH_MACPFR_RA_Pos) /*!< 0x80000000 */
#define ETH_MACPFR_RA                                 ETH_MACPFR_RA_Msk        /* Receive all */
#define ETH_MACPFR_DNTU_Pos                           (21U)
#define ETH_MACPFR_DNTU_Msk                           (0x1UL << ETH_MACPFR_DNTU_Pos) /*!< 0x00200000 */
#define ETH_MACPFR_DNTU                               ETH_MACPFR_DNTU_Msk      /* Drop Non-TCP/UDP over IP Packets */
#define ETH_MACPFR_IPFE_Pos                           (20U)
#define ETH_MACPFR_IPFE_Msk                           (0x1UL << ETH_MACPFR_IPFE_Pos) /*!< 0x00100000 */
#define ETH_MACPFR_IPFE                               ETH_MACPFR_IPFE_Msk      /* Layer 3 and Layer 4 Filter Enable */
#define ETH_MACPFR_VTFE_Pos                           (16U)
#define ETH_MACPFR_VTFE_Msk                           (0x1UL << ETH_MACPFR_VTFE_Pos) /*!< 0x00010000 */
#define ETH_MACPFR_VTFE                               ETH_MACPFR_VTFE_Msk      /* VLAN Tag Filter Enable */
#define ETH_MACPFR_HPF_Pos                            (10U)
#define ETH_MACPFR_HPF_Msk                            (0x1UL << ETH_MACPFR_HPF_Pos) /*!< 0x00000400 */
#define ETH_MACPFR_HPF                                ETH_MACPFR_HPF_Msk       /* Hash or perfect filter */
#define ETH_MACPFR_SAF_Pos                            (9U)
#define ETH_MACPFR_SAF_Msk                            (0x1UL << ETH_MACPFR_SAF_Pos) /*!< 0x00000200 */
#define ETH_MACPFR_SAF                                ETH_MACPFR_SAF_Msk       /* Source address filter enable */
#define ETH_MACPFR_SAIF_Pos                           (8U)
#define ETH_MACPFR_SAIF_Msk                           (0x1UL << ETH_MACPFR_SAIF_Pos) /*!< 0x00000100 */
#define ETH_MACPFR_SAIF                               ETH_MACPFR_SAIF_Msk      /* SA inverse filtering */
#define ETH_MACPFR_PCF_Pos                            (6U)
#define ETH_MACPFR_PCF_Msk                            (0x3UL << ETH_MACPFR_PCF_Pos) /*!< 0x000000C0 */
#define ETH_MACPFR_PCF                                ETH_MACPFR_PCF_Msk       /* Pass control frames: 4 cases */
#define ETH_MACPFR_PCF_BLOCKALL                       ((uint32_t)0x00000000)   /* MAC filters all control frames from reaching the application */
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Pos         (6U)
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Msk         (0x1UL << ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Pos) /*!< 0x00000040 */
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA             ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Msk /* MAC forwards all control frames except Pause packets to application even if they fail the Address Filter */
#define ETH_MACPFR_PCF_FORWARDALL_Pos                 (7U)
#define ETH_MACPFR_PCF_FORWARDALL_Msk                 (0x1UL << ETH_MACPFR_PCF_FORWARDALL_Pos) /*!< 0x00000080 */
#define ETH_MACPFR_PCF_FORWARDALL                     ETH_MACPFR_PCF_FORWARDALL_Msk /* MAC forwards all control frames to application even if they fail the Address Filter */
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Pos    (6U)
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Msk    (0x3UL << ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Pos) /*!< 0x000000C0 */
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER        ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Msk /* MAC forwards control frames that pass the Address Filter. */
#define ETH_MACPFR_DBF_Pos                            (5U)
#define ETH_MACPFR_DBF_Msk                            (0x1UL << ETH_MACPFR_DBF_Pos) /*!< 0x00000020 */
#define ETH_MACPFR_DBF                                ETH_MACPFR_DBF_Msk       /* Disable Broadcast Packets */
#define ETH_MACPFR_PM_Pos                             (4U)
#define ETH_MACPFR_PM_Msk                             (0x1UL << ETH_MACPFR_PM_Pos) /*!< 0x00000010 */
#define ETH_MACPFR_PM                                 ETH_MACPFR_PM_Msk        /* Pass all mutlicast */
#define ETH_MACPFR_DAIF_Pos                           (3U)
#define ETH_MACPFR_DAIF_Msk                           (0x1UL << ETH_MACPFR_DAIF_Pos) /*!< 0x00000008 */
#define ETH_MACPFR_DAIF                               ETH_MACPFR_DAIF_Msk      /* DA Inverse filtering */
#define ETH_MACPFR_HMC_Pos                            (2U)
#define ETH_MACPFR_HMC_Msk                            (0x1UL << ETH_MACPFR_HMC_Pos) /*!< 0x00000004 */
#define ETH_MACPFR_HMC                                ETH_MACPFR_HMC_Msk       /* Hash multicast */
#define ETH_MACPFR_HUC_Pos                            (1U)
#define ETH_MACPFR_HUC_Msk                            (0x1UL << ETH_MACPFR_HUC_Pos) /*!< 0x00000002 */
#define ETH_MACPFR_HUC                                ETH_MACPFR_HUC_Msk       /* Hash unicast */
#define ETH_MACPFR_PR_Pos                             (0U)
#define ETH_MACPFR_PR_Msk                             (0x1UL << ETH_MACPFR_PR_Pos) /*!< 0x00000001 */
#define ETH_MACPFR_PR                                 ETH_MACPFR_PR_Msk        /* Promiscuous mode */

/* Bit definition for Ethernet MAC Watchdog Timeout Register */
#define ETH_MACWTR_PWE_Pos                            (8U)
#define ETH_MACWTR_PWE_Msk                            (0x1UL << ETH_MACWTR_PWE_Pos) /*!< 0x00000100 */
#define ETH_MACWTR_PWE                                ETH_MACWTR_PWE_Msk       /* Programmable Watchdog Enable */
#define ETH_MACWTR_WTO_Pos                            (0U)
#define ETH_MACWTR_WTO_Msk                            (0xFUL << ETH_MACWTR_WTO_Pos) /*!< 0x0000000F */
#define ETH_MACWTR_WTO                                ETH_MACWTR_WTO_Msk       /* Watchdog Timeout */
#define ETH_MACWTR_WTO_2KB                            ((uint32_t)0x00000000)   /* Maximum received packet length 2KB*/
#define ETH_MACWTR_WTO_3KB                            ((uint32_t)0x00000001)   /* Maximum received packet length 3KB */
#define ETH_MACWTR_WTO_4KB                            ((uint32_t)0x00000002)   /* Maximum received packet length 4KB */
#define ETH_MACWTR_WTO_5KB                            ((uint32_t)0x00000003)   /* Maximum received packet length 5KB */
#define ETH_MACWTR_WTO_6KB                            ((uint32_t)0x00000004)   /* Maximum received packet length 6KB */
#define ETH_MACWTR_WTO_7KB                            ((uint32_t)0x00000005)   /* Maximum received packet length 7KB */
#define ETH_MACWTR_WTO_8KB                            ((uint32_t)0x00000006)   /* Maximum received packet length 8KB */
#define ETH_MACWTR_WTO_9KB                            ((uint32_t)0x00000007)   /* Maximum received packet length 9KB */
#define ETH_MACWTR_WTO_10KB                           ((uint32_t)0x00000008)   /* Maximum received packet length 10KB */
#define ETH_MACWTR_WTO_11KB                           ((uint32_t)0x00000009)   /* Maximum received packet length 11KB */
#define ETH_MACWTR_WTO_12KB                           ((uint32_t)0x0000000A)   /* Maximum received packet length 12KB */
#define ETH_MACWTR_WTO_13KB                           ((uint32_t)0x0000000B)   /* Maximum received packet length 13KB */
#define ETH_MACWTR_WTO_14KB                           ((uint32_t)0x0000000C)   /* Maximum received packet length 14KB */
#define ETH_MACWTR_WTO_15KB                           ((uint32_t)0x0000000D)   /* Maximum received packet length 15KB */
#define ETH_MACWTR_WTO_16KB                           ((uint32_t)0x0000000E)   /* Maximum received packet length 16KB */

/* Bit definition for Ethernet MAC Hash Table High Register */
#define ETH_MACHTHR_HTH_Pos                           (0U)
#define ETH_MACHTHR_HTH_Msk                           (0xFFFFFFFFUL << ETH_MACHTHR_HTH_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACHTHR_HTH                               ETH_MACHTHR_HTH_Msk      /* Hash table high */

/* Bit definition for Ethernet MAC Hash Table Low Register */
#define ETH_MACHTLR_HTL_Pos                           (0U)
#define ETH_MACHTLR_HTL_Msk                           (0xFFFFFFFFUL << ETH_MACHTLR_HTL_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACHTLR_HTL                               ETH_MACHTLR_HTL_Msk      /* Hash table low */

/* Bit definition for Ethernet MAC VLAN Tag Register */
#define ETH_MACVTR_EIVLRXS_Pos                        (31U)
#define ETH_MACVTR_EIVLRXS_Msk                        (0x1UL << ETH_MACVTR_EIVLRXS_Pos) /*!< 0x80000000 */
#define ETH_MACVTR_EIVLRXS                            ETH_MACVTR_EIVLRXS_Msk   /* Enable Inner VLAN Tag in Rx Status */
#define ETH_MACVTR_EIVLS_Pos                          (28U)
#define ETH_MACVTR_EIVLS_Msk                          (0x3UL << ETH_MACVTR_EIVLS_Pos) /*!< 0x30000000 */
#define ETH_MACVTR_EIVLS                              ETH_MACVTR_EIVLS_Msk     /* Enable Inner VLAN Tag Stripping on Receive */
#define ETH_MACVTR_EIVLS_DONOTSTRIP                   ((uint32_t)0x00000000)   /* Do not strip */
#define ETH_MACVTR_EIVLS_STRIPIFPASS_Pos              (28U)
#define ETH_MACVTR_EIVLS_STRIPIFPASS_Msk              (0x1UL << ETH_MACVTR_EIVLS_STRIPIFPASS_Pos) /*!< 0x10000000 */
#define ETH_MACVTR_EIVLS_STRIPIFPASS                  ETH_MACVTR_EIVLS_STRIPIFPASS_Msk /* Strip if VLAN filter passes */
#define ETH_MACVTR_EIVLS_STRIPIFFAILS_Pos             (29U)
#define ETH_MACVTR_EIVLS_STRIPIFFAILS_Msk             (0x1UL << ETH_MACVTR_EIVLS_STRIPIFFAILS_Pos) /*!< 0x20000000 */
#define ETH_MACVTR_EIVLS_STRIPIFFAILS                 ETH_MACVTR_EIVLS_STRIPIFFAILS_Msk /* Strip if VLAN filter fails */
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP_Pos              (28U)
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP_Msk              (0x3UL << ETH_MACVTR_EIVLS_ALWAYSSTRIP_Pos) /*!< 0x30000000 */
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP                  ETH_MACVTR_EIVLS_ALWAYSSTRIP_Msk /* Always strip */
#define ETH_MACVTR_ERIVLT_Pos                         (27U)
#define ETH_MACVTR_ERIVLT_Msk                         (0x1UL << ETH_MACVTR_ERIVLT_Pos) /*!< 0x08000000 */
#define ETH_MACVTR_ERIVLT                             ETH_MACVTR_ERIVLT_Msk    /* Enable Inner VLAN Tag */
#define ETH_MACVTR_EDVLP_Pos                          (26U)
#define ETH_MACVTR_EDVLP_Msk                          (0x1UL << ETH_MACVTR_EDVLP_Pos) /*!< 0x04000000 */
#define ETH_MACVTR_EDVLP                              ETH_MACVTR_EDVLP_Msk     /* Enable Double VLAN Processing */
#define ETH_MACVTR_VTHM_Pos                           (25U)
#define ETH_MACVTR_VTHM_Msk                           (0x1UL << ETH_MACVTR_VTHM_Pos) /*!< 0x02000000 */
#define ETH_MACVTR_VTHM                               ETH_MACVTR_VTHM_Msk      /* VLAN Tag Hash Table Match Enable */
#define ETH_MACVTR_EVLRXS_Pos                         (24U)
#define ETH_MACVTR_EVLRXS_Msk                         (0x1UL << ETH_MACVTR_EVLRXS_Pos) /*!< 0x01000000 */
#define ETH_MACVTR_EVLRXS                             ETH_MACVTR_EVLRXS_Msk    /* Enable VLAN Tag in Rx status */
#define ETH_MACVTR_EVLS_Pos                           (21U)
#define ETH_MACVTR_EVLS_Msk                           (0x3UL << ETH_MACVTR_EVLS_Pos) /*!< 0x00600000 */
#define ETH_MACVTR_EVLS                               ETH_MACVTR_EVLS_Msk      /* Enable VLAN Tag Stripping on Receive */
#define ETH_MACVTR_EVLS_DONOTSTRIP                    ((uint32_t)0x00000000)   /* Do not strip */
#define ETH_MACVTR_EVLS_STRIPIFPASS_Pos               (21U)
#define ETH_MACVTR_EVLS_STRIPIFPASS_Msk               (0x1UL << ETH_MACVTR_EVLS_STRIPIFPASS_Pos) /*!< 0x00200000 */
#define ETH_MACVTR_EVLS_STRIPIFPASS                   ETH_MACVTR_EVLS_STRIPIFPASS_Msk /* Strip if VLAN filter passes */
#define ETH_MACVTR_EVLS_STRIPIFFAILS_Pos              (22U)
#define ETH_MACVTR_EVLS_STRIPIFFAILS_Msk              (0x1UL << ETH_MACVTR_EVLS_STRIPIFFAILS_Pos) /*!< 0x00400000 */
#define ETH_MACVTR_EVLS_STRIPIFFAILS                  ETH_MACVTR_EVLS_STRIPIFFAILS_Msk /* Strip if VLAN filter fails */
#define ETH_MACVTR_EVLS_ALWAYSSTRIP_Pos               (21U)
#define ETH_MACVTR_EVLS_ALWAYSSTRIP_Msk               (0x3UL << ETH_MACVTR_EVLS_ALWAYSSTRIP_Pos) /*!< 0x00600000 */
#define ETH_MACVTR_EVLS_ALWAYSSTRIP                   ETH_MACVTR_EVLS_ALWAYSSTRIP_Msk /* Always strip */
#define ETH_MACVTR_DOVLTC_Pos                         (20U)
#define ETH_MACVTR_DOVLTC_Msk                         (0x1UL << ETH_MACVTR_DOVLTC_Pos) /*!< 0x00100000 */
#define ETH_MACVTR_DOVLTC                             ETH_MACVTR_DOVLTC_Msk    /* Disable VLAN Type Check */
#define ETH_MACVTR_ERSVLM_Pos                         (19U)
#define ETH_MACVTR_ERSVLM_Msk                         (0x1UL << ETH_MACVTR_ERSVLM_Pos) /*!< 0x00080000 */
#define ETH_MACVTR_ERSVLM                             ETH_MACVTR_ERSVLM_Msk    /* Enable Receive S-VLAN Match */
#define ETH_MACVTR_ESVL_Pos                           (18U)
#define ETH_MACVTR_ESVL_Msk                           (0x1UL << ETH_MACVTR_ESVL_Pos) /*!< 0x00040000 */
#define ETH_MACVTR_ESVL                               ETH_MACVTR_ESVL_Msk      /* Enable S-VLAN */
#define ETH_MACVTR_VTIM_Pos                           (17U)
#define ETH_MACVTR_VTIM_Msk                           (0x1UL << ETH_MACVTR_VTIM_Pos) /*!< 0x00020000 */
#define ETH_MACVTR_VTIM                               ETH_MACVTR_VTIM_Msk      /* VLAN Tag Inverse Match Enable */
#define ETH_MACVTR_ETV_Pos                            (16U)
#define ETH_MACVTR_ETV_Msk                            (0x1UL << ETH_MACVTR_ETV_Pos) /*!< 0x00010000 */
#define ETH_MACVTR_ETV                                ETH_MACVTR_ETV_Msk       /* Enable 12-Bit VLAN Tag Comparison */
#define ETH_MACVTR_VL_Pos                             (0U)
#define ETH_MACVTR_VL_Msk                             (0xFFFFUL << ETH_MACVTR_VL_Pos) /*!< 0x0000FFFF */
#define ETH_MACVTR_VL                                 ETH_MACVTR_VL_Msk        /* VLAN Tag Identifier for Receive Packets */
#define ETH_MACVTR_VL_UP_Pos                          (13U)
#define ETH_MACVTR_VL_UP_Msk                          (0x7UL << ETH_MACVTR_VL_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACVTR_VL_UP                              ETH_MACVTR_VL_UP_Msk     /* User Priority */
#define ETH_MACVTR_VL_CFIDEI_Pos                      (12U)
#define ETH_MACVTR_VL_CFIDEI_Msk                      (0x1UL << ETH_MACVTR_VL_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACVTR_VL_CFIDEI                          ETH_MACVTR_VL_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACVTR_VL_VID_Pos                         (0U)
#define ETH_MACVTR_VL_VID_Msk                         (0xFFFUL << ETH_MACVTR_VL_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACVTR_VL_VID                             ETH_MACVTR_VL_VID_Msk    /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC VLAN Hash Table Register */
#define ETH_MACVHTR_VLHT_Pos                          (0U)
#define ETH_MACVHTR_VLHT_Msk                          (0xFFFFUL << ETH_MACVHTR_VLHT_Pos) /*!< 0x0000FFFF */
#define ETH_MACVHTR_VLHT                              ETH_MACVHTR_VLHT_Msk     /* VLAN Hash Table */

/* Bit definition for Ethernet MAC VLAN Incl Register */
#define ETH_MACVIR_VLTI_Pos                           (20U)
#define ETH_MACVIR_VLTI_Msk                           (0x1UL << ETH_MACVIR_VLTI_Pos) /*!< 0x00100000 */
#define ETH_MACVIR_VLTI                               ETH_MACVIR_VLTI_Msk      /* VLAN Tag Input */
#define ETH_MACVIR_CSVL_Pos                           (19U)
#define ETH_MACVIR_CSVL_Msk                           (0x1UL << ETH_MACVIR_CSVL_Pos) /*!< 0x00080000 */
#define ETH_MACVIR_CSVL                               ETH_MACVIR_CSVL_Msk      /* C-VLAN or S-VLAN */
#define ETH_MACVIR_VLP_Pos                            (18U)
#define ETH_MACVIR_VLP_Msk                            (0x1UL << ETH_MACVIR_VLP_Pos) /*!< 0x00040000 */
#define ETH_MACVIR_VLP                                ETH_MACVIR_VLP_Msk       /* VLAN Priority Control */
#define ETH_MACVIR_VLC_Pos                            (16U)
#define ETH_MACVIR_VLC_Msk                            (0x3UL << ETH_MACVIR_VLC_Pos) /*!< 0x00030000 */
#define ETH_MACVIR_VLC                                ETH_MACVIR_VLC_Msk       /* VLAN Tag Control in Transmit Packets */
#define ETH_MACVIR_VLC_NOVLANTAG                      ((uint32_t)0x00000000)   /* No VLAN tag deletion, insertion, or replacement */
#define ETH_MACVIR_VLC_VLANTAGDELETE_Pos              (16U)
#define ETH_MACVIR_VLC_VLANTAGDELETE_Msk              (0x1UL << ETH_MACVIR_VLC_VLANTAGDELETE_Pos) /*!< 0x00010000 */
#define ETH_MACVIR_VLC_VLANTAGDELETE                  ETH_MACVIR_VLC_VLANTAGDELETE_Msk /* VLAN tag deletion */
#define ETH_MACVIR_VLC_VLANTAGINSERT_Pos              (17U)
#define ETH_MACVIR_VLC_VLANTAGINSERT_Msk              (0x1UL << ETH_MACVIR_VLC_VLANTAGINSERT_Pos) /*!< 0x00020000 */
#define ETH_MACVIR_VLC_VLANTAGINSERT                  ETH_MACVIR_VLC_VLANTAGINSERT_Msk /* VLAN tag insertion */
#define ETH_MACVIR_VLC_VLANTAGREPLACE_Pos             (16U)
#define ETH_MACVIR_VLC_VLANTAGREPLACE_Msk             (0x3UL << ETH_MACVIR_VLC_VLANTAGREPLACE_Pos) /*!< 0x00030000 */
#define ETH_MACVIR_VLC_VLANTAGREPLACE                 ETH_MACVIR_VLC_VLANTAGREPLACE_Msk /* VLAN tag replacement */
#define ETH_MACVIR_VLT_Pos                            (0U)
#define ETH_MACVIR_VLT_Msk                            (0xFFFFUL << ETH_MACVIR_VLT_Pos) /*!< 0x0000FFFF */
#define ETH_MACVIR_VLT                                ETH_MACVIR_VLT_Msk       /* VLAN Tag for Transmit Packets */
#define ETH_MACVIR_VLT_UP_Pos                         (13U)
#define ETH_MACVIR_VLT_UP_Msk                         (0x7UL << ETH_MACVIR_VLT_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACVIR_VLT_UP                             ETH_MACVIR_VLT_UP_Msk    /* User Priority */
#define ETH_MACVIR_VLT_CFIDEI_Pos                     (12U)
#define ETH_MACVIR_VLT_CFIDEI_Msk                     (0x1UL << ETH_MACVIR_VLT_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACVIR_VLT_CFIDEI                         ETH_MACVIR_VLT_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACVIR_VLT_VID_Pos                        (0U)
#define ETH_MACVIR_VLT_VID_Msk                        (0xFFFUL << ETH_MACVIR_VLT_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACVIR_VLT_VID                            ETH_MACVIR_VLT_VID_Msk   /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC Inner_VLAN Incl Register */
#define ETH_MACIVIR_VLTI_Pos                          (20U)
#define ETH_MACIVIR_VLTI_Msk                          (0x1UL << ETH_MACIVIR_VLTI_Pos) /*!< 0x00100000 */
#define ETH_MACIVIR_VLTI                              ETH_MACIVIR_VLTI_Msk     /* VLAN Tag Input */
#define ETH_MACIVIR_CSVL_Pos                          (19U)
#define ETH_MACIVIR_CSVL_Msk                          (0x1UL << ETH_MACIVIR_CSVL_Pos) /*!< 0x00080000 */
#define ETH_MACIVIR_CSVL                              ETH_MACIVIR_CSVL_Msk     /* C-VLAN or S-VLAN */
#define ETH_MACIVIR_VLP_Pos                           (18U)
#define ETH_MACIVIR_VLP_Msk                           (0x1UL << ETH_MACIVIR_VLP_Pos) /*!< 0x00040000 */
#define ETH_MACIVIR_VLP                               ETH_MACIVIR_VLP_Msk      /* VLAN Priority Control */
#define ETH_MACIVIR_VLC_Pos                           (16U)
#define ETH_MACIVIR_VLC_Msk                           (0x3UL << ETH_MACIVIR_VLC_Pos) /*!< 0x00030000 */
#define ETH_MACIVIR_VLC                               ETH_MACIVIR_VLC_Msk      /* VLAN Tag Control in Transmit Packets */
#define ETH_MACIVIR_VLC_NOVLANTAG                     ((uint32_t)0x00000000)   /* No VLAN tag deletion, insertion, or replacement */
#define ETH_MACIVIR_VLC_VLANTAGDELETE_Pos             (16U)
#define ETH_MACIVIR_VLC_VLANTAGDELETE_Msk             (0x1UL << ETH_MACIVIR_VLC_VLANTAGDELETE_Pos) /*!< 0x00010000 */
#define ETH_MACIVIR_VLC_VLANTAGDELETE                 ETH_MACIVIR_VLC_VLANTAGDELETE_Msk /* VLAN tag deletion */
#define ETH_MACIVIR_VLC_VLANTAGINSERT_Pos             (17U)
#define ETH_MACIVIR_VLC_VLANTAGINSERT_Msk             (0x1UL << ETH_MACIVIR_VLC_VLANTAGINSERT_Pos) /*!< 0x00020000 */
#define ETH_MACIVIR_VLC_VLANTAGINSERT                 ETH_MACIVIR_VLC_VLANTAGINSERT_Msk /* VLAN tag insertion */
#define ETH_MACIVIR_VLC_VLANTAGREPLACE_Pos            (16U)
#define ETH_MACIVIR_VLC_VLANTAGREPLACE_Msk            (0x3UL << ETH_MACIVIR_VLC_VLANTAGREPLACE_Pos) /*!< 0x00030000 */
#define ETH_MACIVIR_VLC_VLANTAGREPLACE                ETH_MACIVIR_VLC_VLANTAGREPLACE_Msk /* VLAN tag replacement */
#define ETH_MACIVIR_VLT_Pos                           (0U)
#define ETH_MACIVIR_VLT_Msk                           (0xFFFFUL << ETH_MACIVIR_VLT_Pos) /*!< 0x0000FFFF */
#define ETH_MACIVIR_VLT                               ETH_MACIVIR_VLT_Msk      /* VLAN Tag for Transmit Packets */
#define ETH_MACIVIR_VLT_UP_Pos                        (13U)
#define ETH_MACIVIR_VLT_UP_Msk                        (0x7UL << ETH_MACIVIR_VLT_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACIVIR_VLT_UP                            ETH_MACIVIR_VLT_UP_Msk   /* User Priority */
#define ETH_MACIVIR_VLT_CFIDEI_Pos                    (12U)
#define ETH_MACIVIR_VLT_CFIDEI_Msk                    (0x1UL << ETH_MACIVIR_VLT_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACIVIR_VLT_CFIDEI                        ETH_MACIVIR_VLT_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACIVIR_VLT_VID_Pos                       (0U)
#define ETH_MACIVIR_VLT_VID_Msk                       (0xFFFUL << ETH_MACIVIR_VLT_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACIVIR_VLT_VID                           ETH_MACIVIR_VLT_VID_Msk  /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC Tx Flow Ctrl Register */
#define ETH_MACTFCR_PT_Pos                            (16U)
#define ETH_MACTFCR_PT_Msk                            (0xFFFFUL << ETH_MACTFCR_PT_Pos) /*!< 0xFFFF0000 */
#define ETH_MACTFCR_PT                                ETH_MACTFCR_PT_Msk       /* Pause Time */
#define ETH_MACTFCR_DZPQ_Pos                          (7U)
#define ETH_MACTFCR_DZPQ_Msk                          (0x1UL << ETH_MACTFCR_DZPQ_Pos) /*!< 0x00000080 */
#define ETH_MACTFCR_DZPQ                              ETH_MACTFCR_DZPQ_Msk     /* Disable Zero-Quanta Pause */
#define ETH_MACTFCR_PLT_Pos                           (4U)
#define ETH_MACTFCR_PLT_Msk                           (0x7UL << ETH_MACTFCR_PLT_Pos) /*!< 0x00000070 */
#define ETH_MACTFCR_PLT                               ETH_MACTFCR_PLT_Msk      /* Pause Low Threshold */
#define ETH_MACTFCR_PLT_MINUS4                        ((uint32_t)0x00000000)   /* Pause time minus 4 slot times */
#define ETH_MACTFCR_PLT_MINUS28_Pos                   (4U)
#define ETH_MACTFCR_PLT_MINUS28_Msk                   (0x1UL << ETH_MACTFCR_PLT_MINUS28_Pos) /*!< 0x00000010 */
#define ETH_MACTFCR_PLT_MINUS28                       ETH_MACTFCR_PLT_MINUS28_Msk /* Pause time minus 28 slot times */
#define ETH_MACTFCR_PLT_MINUS36_Pos                   (5U)
#define ETH_MACTFCR_PLT_MINUS36_Msk                   (0x1UL << ETH_MACTFCR_PLT_MINUS36_Pos) /*!< 0x00000020 */
#define ETH_MACTFCR_PLT_MINUS36                       ETH_MACTFCR_PLT_MINUS36_Msk /* Pause time minus 36 slot times */
#define ETH_MACTFCR_PLT_MINUS144_Pos                  (4U)
#define ETH_MACTFCR_PLT_MINUS144_Msk                  (0x3UL << ETH_MACTFCR_PLT_MINUS144_Pos) /*!< 0x00000030 */
#define ETH_MACTFCR_PLT_MINUS144                      ETH_MACTFCR_PLT_MINUS144_Msk /* Pause time minus 144 slot times */
#define ETH_MACTFCR_PLT_MINUS256_Pos                  (6U)
#define ETH_MACTFCR_PLT_MINUS256_Msk                  (0x1UL << ETH_MACTFCR_PLT_MINUS256_Pos) /*!< 0x00000040 */
#define ETH_MACTFCR_PLT_MINUS256                      ETH_MACTFCR_PLT_MINUS256_Msk /* Pause time minus 256 slot times */
#define ETH_MACTFCR_PLT_MINUS512_Pos                  (4U)
#define ETH_MACTFCR_PLT_MINUS512_Msk                  (0x5UL << ETH_MACTFCR_PLT_MINUS512_Pos) /*!< 0x00000050 */
#define ETH_MACTFCR_PLT_MINUS512                      ETH_MACTFCR_PLT_MINUS512_Msk /* Pause time minus 512 slot times */
#define ETH_MACTFCR_TFE_Pos                           (1U)
#define ETH_MACTFCR_TFE_Msk                           (0x1UL << ETH_MACTFCR_TFE_Pos) /*!< 0x00000002 */
#define ETH_MACTFCR_TFE                               ETH_MACTFCR_TFE_Msk      /* Transmit Flow Control Enable */
#define ETH_MACTFCR_FCB_Pos                           (0U)
#define ETH_MACTFCR_FCB_Msk                           (0x1UL << ETH_MACTFCR_FCB_Pos) /*!< 0x00000001 */
#define ETH_MACTFCR_FCB                               ETH_MACTFCR_FCB_Msk      /* Flow Control Busy or Backpressure Activate */

/* Bit definition for Ethernet MAC Rx Flow Ctrl Register */
#define ETH_MACRFCR_UP_Pos                            (1U)
#define ETH_MACRFCR_UP_Msk                            (0x1UL << ETH_MACRFCR_UP_Pos) /*!< 0x00000002 */
#define ETH_MACRFCR_UP                                ETH_MACRFCR_UP_Msk       /* Unicast Pause Packet Detect */
#define ETH_MACRFCR_RFE_Pos                           (0U)
#define ETH_MACRFCR_RFE_Msk                           (0x1UL << ETH_MACRFCR_RFE_Pos) /*!< 0x00000001 */
#define ETH_MACRFCR_RFE                               ETH_MACRFCR_RFE_Msk      /* Receive Flow Control Enable */

/* Bit definition for Ethernet MAC Interrupt Status Register */
#define ETH_MACISR_RXSTSIS_Pos                        (14U)
#define ETH_MACISR_RXSTSIS_Msk                        (0x1UL << ETH_MACISR_RXSTSIS_Pos) /*!< 0x00004000 */
#define ETH_MACISR_RXSTSIS                            ETH_MACISR_RXSTSIS_Msk   /* Receive Status Interrupt */
#define ETH_MACISR_TXSTSIS_Pos                        (13U)
#define ETH_MACISR_TXSTSIS_Msk                        (0x1UL << ETH_MACISR_TXSTSIS_Pos) /*!< 0x00002000 */
#define ETH_MACISR_TXSTSIS                            ETH_MACISR_TXSTSIS_Msk   /* Transmit Status Interrupt */
#define ETH_MACISR_TSIS_Pos                           (12U)
#define ETH_MACISR_TSIS_Msk                           (0x1UL << ETH_MACISR_TSIS_Pos) /*!< 0x00001000 */
#define ETH_MACISR_TSIS                               ETH_MACISR_TSIS_Msk      /* Timestamp Interrupt Status */
#define ETH_MACISR_MMCTXIS_Pos                        (10U)
#define ETH_MACISR_MMCTXIS_Msk                        (0x1UL << ETH_MACISR_MMCTXIS_Pos) /*!< 0x00000400 */
#define ETH_MACISR_MMCTXIS                            ETH_MACISR_MMCTXIS_Msk   /* MMC Transmit Interrupt Status */
#define ETH_MACISR_MMCRXIS_Pos                        (9U)
#define ETH_MACISR_MMCRXIS_Msk                        (0x1UL << ETH_MACISR_MMCRXIS_Pos) /*!< 0x00000200 */
#define ETH_MACISR_MMCRXIS                            ETH_MACISR_MMCRXIS_Msk   /* MMC Receive Interrupt Status */
#define ETH_MACISR_MMCIS_Pos                          (8U)
#define ETH_MACISR_MMCIS_Msk                          (0x1UL << ETH_MACISR_MMCIS_Pos) /*!< 0x00000100 */
#define ETH_MACISR_MMCIS                              ETH_MACISR_MMCIS_Msk     /* MMC Interrupt Status */
#define ETH_MACISR_LPIIS_Pos                          (5U)
#define ETH_MACISR_LPIIS_Msk                          (0x1UL << ETH_MACISR_LPIIS_Pos) /*!< 0x00000020 */
#define ETH_MACISR_LPIIS                              ETH_MACISR_LPIIS_Msk     /* LPI Interrupt Status */
#define ETH_MACISR_PMTIS_Pos                          (4U)
#define ETH_MACISR_PMTIS_Msk                          (0x1UL << ETH_MACISR_PMTIS_Pos) /*!< 0x00000010 */
#define ETH_MACISR_PMTIS                              ETH_MACISR_PMTIS_Msk     /* PMT Interrupt Status */
#define ETH_MACISR_PHYIS_Pos                          (3U)
#define ETH_MACISR_PHYIS_Msk                          (0x1UL << ETH_MACISR_PHYIS_Pos) /*!< 0x00000008 */
#define ETH_MACISR_PHYIS                              ETH_MACISR_PHYIS_Msk     /* PHY Interrupt */

/* Bit definition for Ethernet MAC Interrupt Enable Register */
#define ETH_MACIER_RXSTSIE_Pos                        (14U)
#define ETH_MACIER_RXSTSIE_Msk                        (0x1UL << ETH_MACIER_RXSTSIE_Pos) /*!< 0x00004000 */
#define ETH_MACIER_RXSTSIE                            ETH_MACIER_RXSTSIE_Msk   /* Receive Status Interrupt Enable */
#define ETH_MACIER_TXSTSIE_Pos                        (13U)
#define ETH_MACIER_TXSTSIE_Msk                        (0x1UL << ETH_MACIER_TXSTSIE_Pos) /*!< 0x00002000 */
#define ETH_MACIER_TXSTSIE                            ETH_MACIER_TXSTSIE_Msk   /* Transmit Status Interrupt Enable */
#define ETH_MACIER_TSIE_Pos                           (12U)
#define ETH_MACIER_TSIE_Msk                           (0x1UL << ETH_MACIER_TSIE_Pos) /*!< 0x00001000 */
#define ETH_MACIER_TSIE                               ETH_MACIER_TSIE_Msk      /* Timestamp Interrupt Enable */
#define ETH_MACIER_LPIIE_Pos                          (5U)
#define ETH_MACIER_LPIIE_Msk                          (0x1UL << ETH_MACIER_LPIIE_Pos) /*!< 0x00000020 */
#define ETH_MACIER_LPIIE                              ETH_MACIER_LPIIE_Msk     /* LPI Interrupt Enable */
#define ETH_MACIER_PMTIE_Pos                          (4U)
#define ETH_MACIER_PMTIE_Msk                          (0x1UL << ETH_MACIER_PMTIE_Pos) /*!< 0x00000010 */
#define ETH_MACIER_PMTIE                              ETH_MACIER_PMTIE_Msk     /* PMT Interrupt Enable */
#define ETH_MACIER_PHYIE_Pos                          (3U)
#define ETH_MACIER_PHYIE_Msk                          (0x1UL << ETH_MACIER_PHYIE_Pos) /*!< 0x00000008 */
#define ETH_MACIER_PHYIE                              ETH_MACIER_PHYIE_Msk     /* PHY Interrupt Enable */

/* Bit definition for Ethernet MAC Rx Tx Status Register */
#define ETH_MACRXTXSR_RWT_Pos                         (8U)
#define ETH_MACRXTXSR_RWT_Msk                         (0x1UL << ETH_MACRXTXSR_RWT_Pos) /*!< 0x00000100 */
#define ETH_MACRXTXSR_RWT                             ETH_MACRXTXSR_RWT_Msk    /* Receive Watchdog Timeout */
#define ETH_MACRXTXSR_EXCOL_Pos                       (5U)
#define ETH_MACRXTXSR_EXCOL_Msk                       (0x1UL << ETH_MACRXTXSR_EXCOL_Pos) /*!< 0x00000020 */
#define ETH_MACRXTXSR_EXCOL                           ETH_MACRXTXSR_EXCOL_Msk  /* Excessive Collisions */
#define ETH_MACRXTXSR_LCOL_Pos                        (4U)
#define ETH_MACRXTXSR_LCOL_Msk                        (0x1UL << ETH_MACRXTXSR_LCOL_Pos) /*!< 0x00000010 */
#define ETH_MACRXTXSR_LCOL                            ETH_MACRXTXSR_LCOL_Msk   /* Late Collision */
#define ETH_MACRXTXSR_EXDEF_Pos                       (3U)
#define ETH_MACRXTXSR_EXDEF_Msk                       (0x1UL << ETH_MACRXTXSR_EXDEF_Pos) /*!< 0x00000008 */
#define ETH_MACRXTXSR_EXDEF                           ETH_MACRXTXSR_EXDEF_Msk  /* Excessive Deferral */
#define ETH_MACRXTXSR_LCARR_Pos                       (2U)
#define ETH_MACRXTXSR_LCARR_Msk                       (0x1UL << ETH_MACRXTXSR_LCARR_Pos) /*!< 0x00000004 */
#define ETH_MACRXTXSR_LCARR                           ETH_MACRXTXSR_LCARR_Msk  /* Loss of Carrier */
#define ETH_MACRXTXSR_NCARR_Pos                       (1U)
#define ETH_MACRXTXSR_NCARR_Msk                       (0x1UL << ETH_MACRXTXSR_NCARR_Pos) /*!< 0x00000002 */
#define ETH_MACRXTXSR_NCARR                           ETH_MACRXTXSR_NCARR_Msk  /* No Carrier */
#define ETH_MACRXTXSR_TJT_Pos                         (0U)
#define ETH_MACRXTXSR_TJT_Msk                         (0x1UL << ETH_MACRXTXSR_TJT_Pos) /*!< 0x00000001 */
#define ETH_MACRXTXSR_TJT                             ETH_MACRXTXSR_TJT_Msk    /* Transmit Jabber Timeout */

/* Bit definition for Ethernet MAC PMT Control Status Register */
#define ETH_MACPCSR_RWKFILTRST_Pos                    (31U)
#define ETH_MACPCSR_RWKFILTRST_Msk                    (0x1UL << ETH_MACPCSR_RWKFILTRST_Pos) /*!< 0x80000000 */
#define ETH_MACPCSR_RWKFILTRST                        ETH_MACPCSR_RWKFILTRST_Msk /* Remote Wake-Up Packet Filter Register Pointer Reset */
#define ETH_MACPCSR_RWKPTR_Pos                        (24U)
#define ETH_MACPCSR_RWKPTR_Msk                        (0x1FUL << ETH_MACPCSR_RWKPTR_Pos) /*!< 0x1F000000 */
#define ETH_MACPCSR_RWKPTR                            ETH_MACPCSR_RWKPTR_Msk   /* Remote Wake-up FIFO Pointer */
#define ETH_MACPCSR_RWKPFE_Pos                        (10U)
#define ETH_MACPCSR_RWKPFE_Msk                        (0x1UL << ETH_MACPCSR_RWKPFE_Pos) /*!< 0x00000400 */
#define ETH_MACPCSR_RWKPFE                            ETH_MACPCSR_RWKPFE_Msk   /* Remote Wake-up Packet Forwarding Enable */
#define ETH_MACPCSR_GLBLUCAST_Pos                     (9U)
#define ETH_MACPCSR_GLBLUCAST_Msk                     (0x1UL << ETH_MACPCSR_GLBLUCAST_Pos) /*!< 0x00000200 */
#define ETH_MACPCSR_GLBLUCAST                         ETH_MACPCSR_GLBLUCAST_Msk /* Global Unicast */
#define ETH_MACPCSR_RWKPRCVD_Pos                      (6U)
#define ETH_MACPCSR_RWKPRCVD_Msk                      (0x1UL << ETH_MACPCSR_RWKPRCVD_Pos) /*!< 0x00000040 */
#define ETH_MACPCSR_RWKPRCVD                          ETH_MACPCSR_RWKPRCVD_Msk /* Remote Wake-Up Packet Received */
#define ETH_MACPCSR_MGKPRCVD_Pos                      (5U)
#define ETH_MACPCSR_MGKPRCVD_Msk                      (0x1UL << ETH_MACPCSR_MGKPRCVD_Pos) /*!< 0x00000020 */
#define ETH_MACPCSR_MGKPRCVD                          ETH_MACPCSR_MGKPRCVD_Msk /* Magic Packet Received */
#define ETH_MACPCSR_RWKPKTEN_Pos                      (2U)
#define ETH_MACPCSR_RWKPKTEN_Msk                      (0x1UL << ETH_MACPCSR_RWKPKTEN_Pos) /*!< 0x00000004 */
#define ETH_MACPCSR_RWKPKTEN                          ETH_MACPCSR_RWKPKTEN_Msk /* Remote Wake-Up Packet Enable */
#define ETH_MACPCSR_MGKPKTEN_Pos                      (1U)
#define ETH_MACPCSR_MGKPKTEN_Msk                      (0x1UL << ETH_MACPCSR_MGKPKTEN_Pos) /*!< 0x00000002 */
#define ETH_MACPCSR_MGKPKTEN                          ETH_MACPCSR_MGKPKTEN_Msk /* Magic Packet Enable */
#define ETH_MACPCSR_PWRDWN_Pos                        (0U)
#define ETH_MACPCSR_PWRDWN_Msk                        (0x1UL << ETH_MACPCSR_PWRDWN_Pos) /*!< 0x00000001 */
#define ETH_MACPCSR_PWRDWN                            ETH_MACPCSR_PWRDWN_Msk   /* Power Down */

/* Bit definition for Ethernet MAC Remote Wake-Up Packet Filter Register */
#define ETH_MACRWUPFR_D_Pos                           (0U)
#define ETH_MACRWUPFR_D_Msk                           (0xFFFFFFFFUL << ETH_MACRWUPFR_D_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACRWUPFR_D                               ETH_MACRWUPFR_D_Msk      /* Wake-up Packet filter register data */

/* Bit definition for Ethernet MAC LPI Control Status Register */
#define ETH_MACLCSR_LPITCSE_Pos                       (21U)
#define ETH_MACLCSR_LPITCSE_Msk                       (0x1UL << ETH_MACLCSR_LPITCSE_Pos) /*!< 0x00200000 */
#define ETH_MACLCSR_LPITCSE                           ETH_MACLCSR_LPITCSE_Msk  /* LPI Tx Clock Stop Enable */
#define ETH_MACLCSR_LPITE_Pos                         (20U)
#define ETH_MACLCSR_LPITE_Msk                         (0x1UL << ETH_MACLCSR_LPITE_Pos) /*!< 0x00100000 */
#define ETH_MACLCSR_LPITE                             ETH_MACLCSR_LPITE_Msk    /* LPI Timer Enable */
#define ETH_MACLCSR_LPITXA_Pos                        (19U)
#define ETH_MACLCSR_LPITXA_Msk                        (0x1UL << ETH_MACLCSR_LPITXA_Pos) /*!< 0x00080000 */
#define ETH_MACLCSR_LPITXA                            ETH_MACLCSR_LPITXA_Msk   /* LPI Tx Automate */
#define ETH_MACLCSR_PLS_Pos                           (17U)
#define ETH_MACLCSR_PLS_Msk                           (0x1UL << ETH_MACLCSR_PLS_Pos) /*!< 0x00020000 */
#define ETH_MACLCSR_PLS                               ETH_MACLCSR_PLS_Msk      /* PHY Link Status */
#define ETH_MACLCSR_LPIEN_Pos                         (16U)
#define ETH_MACLCSR_LPIEN_Msk                         (0x1UL << ETH_MACLCSR_LPIEN_Pos) /*!< 0x00010000 */
#define ETH_MACLCSR_LPIEN                             ETH_MACLCSR_LPIEN_Msk    /* LPI Enable */
#define ETH_MACLCSR_RLPIST_Pos                        (9U)
#define ETH_MACLCSR_RLPIST_Msk                        (0x1UL << ETH_MACLCSR_RLPIST_Pos) /*!< 0x00000200 */
#define ETH_MACLCSR_RLPIST                            ETH_MACLCSR_RLPIST_Msk   /* Receive LPI State */
#define ETH_MACLCSR_TLPIST_Pos                        (8U)
#define ETH_MACLCSR_TLPIST_Msk                        (0x1UL << ETH_MACLCSR_TLPIST_Pos) /*!< 0x00000100 */
#define ETH_MACLCSR_TLPIST                            ETH_MACLCSR_TLPIST_Msk   /* Transmit LPI State */
#define ETH_MACLCSR_RLPIEX_Pos                        (3U)
#define ETH_MACLCSR_RLPIEX_Msk                        (0x1UL << ETH_MACLCSR_RLPIEX_Pos) /*!< 0x00000008 */
#define ETH_MACLCSR_RLPIEX                            ETH_MACLCSR_RLPIEX_Msk   /* Receive LPI Exit */
#define ETH_MACLCSR_RLPIEN_Pos                        (2U)
#define ETH_MACLCSR_RLPIEN_Msk                        (0x1UL << ETH_MACLCSR_RLPIEN_Pos) /*!< 0x00000004 */
#define ETH_MACLCSR_RLPIEN                            ETH_MACLCSR_RLPIEN_Msk   /* Receive LPI Entry */
#define ETH_MACLCSR_TLPIEX_Pos                        (1U)
#define ETH_MACLCSR_TLPIEX_Msk                        (0x1UL << ETH_MACLCSR_TLPIEX_Pos) /*!< 0x00000002 */
#define ETH_MACLCSR_TLPIEX                            ETH_MACLCSR_TLPIEX_Msk   /* Transmit LPI Exit */
#define ETH_MACLCSR_TLPIEN_Pos                        (0U)
#define ETH_MACLCSR_TLPIEN_Msk                        (0x1UL << ETH_MACLCSR_TLPIEN_Pos) /*!< 0x00000001 */
#define ETH_MACLCSR_TLPIEN                            ETH_MACLCSR_TLPIEN_Msk   /* Transmit LPI Entry */

/* Bit definition for Ethernet MAC LPI Timers Control Register */
#define ETH_MACLTCR_LST_Pos                           (16U)
#define ETH_MACLTCR_LST_Msk                           (0x3FFUL << ETH_MACLTCR_LST_Pos) /*!< 0x03FF0000 */
#define ETH_MACLTCR_LST                               ETH_MACLTCR_LST_Msk      /* LPI LS TIMER */
#define ETH_MACLTCR_TWT_Pos                           (0U)
#define ETH_MACLTCR_TWT_Msk                           (0xFFFFUL << ETH_MACLTCR_TWT_Pos) /*!< 0x0000FFFF */
#define ETH_MACLTCR_TWT                               ETH_MACLTCR_TWT_Msk      /* LPI TW TIMER */

/* Bit definition for Ethernet MAC LPI Entry Timer Register */
#define ETH_MACLETR_LPIET_Pos                         (0U)
#define ETH_MACLETR_LPIET_Msk                         (0xFFFFFUL << ETH_MACLETR_LPIET_Pos) /*!< 0x000FFFFF */
#define ETH_MACLETR_LPIET                             ETH_MACLETR_LPIET_Msk    /* LPI Entry Timer */

/* Bit definition for Ethernet MAC 1US Tic Counter Register */
#define ETH_MAC1USTCR_TIC1USCNTR_Pos                  (0U)
#define ETH_MAC1USTCR_TIC1USCNTR_Msk                  (0xFFFUL << ETH_MAC1USTCR_TIC1USCNTR_Pos) /*!< 0x00000FFF */
#define ETH_MAC1USTCR_TIC1USCNTR                      ETH_MAC1USTCR_TIC1USCNTR_Msk /* 1US TIC Counter */

/* Bit definition for Ethernet MAC Version Register */
#define ETH_MACVR_USERVER_Pos                         (8U)
#define ETH_MACVR_USERVER_Msk                         (0xFFUL << ETH_MACVR_USERVER_Pos) /*!< 0x0000FF00 */
#define ETH_MACVR_USERVER                             ETH_MACVR_USERVER_Msk    /* User-defined Version */
#define ETH_MACVR_SNPSVER_Pos                         (0U)
#define ETH_MACVR_SNPSVER_Msk                         (0xFFUL << ETH_MACVR_SNPSVER_Pos) /*!< 0x000000FF */
#define ETH_MACVR_SNPSVER                             ETH_MACVR_SNPSVER_Msk    /* Synopsys-defined Version */

/* Bit definition for Ethernet MAC Debug Register */
#define ETH_MACDR_TFCSTS_Pos                          (17U)
#define ETH_MACDR_TFCSTS_Msk                          (0x3UL << ETH_MACDR_TFCSTS_Pos) /*!< 0x00060000 */
#define ETH_MACDR_TFCSTS                              ETH_MACDR_TFCSTS_Msk     /* MAC Transmit Packet Controller Status */
#define ETH_MACDR_TFCSTS_IDLE                         ((uint32_t)0x00000000)   /* Idle state */
#define ETH_MACDR_TFCSTS_WAIT_Pos                     (17U)
#define ETH_MACDR_TFCSTS_WAIT_Msk                     (0x1UL << ETH_MACDR_TFCSTS_WAIT_Pos) /*!< 0x00020000 */
#define ETH_MACDR_TFCSTS_WAIT                         ETH_MACDR_TFCSTS_WAIT_Msk /* Waiting for status of the previous packet, IPG or backoff period to be over */
#define ETH_MACDR_TFCSTS_GENERATEPCP_Pos              (18U)
#define ETH_MACDR_TFCSTS_GENERATEPCP_Msk              (0x1UL << ETH_MACDR_TFCSTS_GENERATEPCP_Pos) /*!< 0x00040000 */
#define ETH_MACDR_TFCSTS_GENERATEPCP                  ETH_MACDR_TFCSTS_GENERATEPCP_Msk /* Generating and transmitting a Pause control packet */
#define ETH_MACDR_TFCSTS_TRASFERIP_Pos                (17U)
#define ETH_MACDR_TFCSTS_TRASFERIP_Msk                (0x3UL << ETH_MACDR_TFCSTS_TRASFERIP_Pos) /*!< 0x00060000 */
#define ETH_MACDR_TFCSTS_TRASFERIP                    ETH_MACDR_TFCSTS_TRASFERIP_Msk /* Transferring input packet for transmission */
#define ETH_MACDR_TPESTS_Pos                          (16U)
#define ETH_MACDR_TPESTS_Msk                          (0x1UL << ETH_MACDR_TPESTS_Pos) /*!< 0x00010000 */
#define ETH_MACDR_TPESTS                              ETH_MACDR_TPESTS_Msk     /* MAC Receive Packet Controller FIFO Status */
#define ETH_MACDR_RFCFCSTS_Pos                        (1U)
#define ETH_MACDR_RFCFCSTS_Msk                        (0x3UL << ETH_MACDR_RFCFCSTS_Pos) /*!< 0x00000006 */
#define ETH_MACDR_RFCFCSTS                            ETH_MACDR_RFCFCSTS_Msk   /* MAC MII Transmit Protocol Engine Status */
#define ETH_MACDR_RPESTS_Pos                          (0U)
#define ETH_MACDR_RPESTS_Msk                          (0x1UL << ETH_MACDR_RPESTS_Pos) /*!< 0x00000001 */
#define ETH_MACDR_RPESTS                              ETH_MACDR_RPESTS_Msk     /* MAC MII Receive Protocol Engine Status */

/* Bit definition for Ethernet MAC HW Feature0 Register */
#define ETH_MACHWF0R_ACTPHYSEL_Pos                    (28U)
#define ETH_MACHWF0R_ACTPHYSEL_Msk                    (0x7UL << ETH_MACHWF0R_ACTPHYSEL_Pos) /*!< 0x70000000 */
#define ETH_MACHWF0R_ACTPHYSEL                        ETH_MACHWF0R_ACTPHYSEL_Msk /* Active PHY Selected */
#define ETH_MACHWF0R_ACTPHYSEL_MII                    ((uint32_t)0x00000000)   /* MII */
#define ETH_MACHWF0R_ACTPHYSEL_RMII_Pos               (30U)
#define ETH_MACHWF0R_ACTPHYSEL_RMII_Msk               (0x1UL << ETH_MACHWF0R_ACTPHYSEL_RMII_Pos) /*!< 0x40000000 */
#define ETH_MACHWF0R_ACTPHYSEL_RMII                   ETH_MACHWF0R_ACTPHYSEL_RMII_Msk /* RMII */
#define ETH_MACHWF0R_ACTPHYSEL_REVMII_Pos             (28U)
#define ETH_MACHWF0R_ACTPHYSEL_REVMII_Msk             (0x7UL << ETH_MACHWF0R_ACTPHYSEL_REVMII_Pos) /*!< 0x70000000 */
#define ETH_MACHWF0R_ACTPHYSEL_REVMII                 ETH_MACHWF0R_ACTPHYSEL_REVMII_Msk /* RevMII */
#define ETH_MACHWF0R_SAVLANINS_Pos                    (27U)
#define ETH_MACHWF0R_SAVLANINS_Msk                    (0x1UL << ETH_MACHWF0R_SAVLANINS_Pos) /*!< 0x08000000 */
#define ETH_MACHWF0R_SAVLANINS                        ETH_MACHWF0R_SAVLANINS_Msk /* Source Address or VLAN Insertion Enable */
#define ETH_MACHWF0R_TSSTSSEL_Pos                     (25U)
#define ETH_MACHWF0R_TSSTSSEL_Msk                     (0x3UL << ETH_MACHWF0R_TSSTSSEL_Pos) /*!< 0x06000000 */
#define ETH_MACHWF0R_TSSTSSEL                         ETH_MACHWF0R_TSSTSSEL_Msk /* Timestamp System Time Source */
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL_Pos            (25U)
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL_Msk            (0x1UL << ETH_MACHWF0R_TSSTSSEL_INTERNAL_Pos) /*!< 0x02000000 */
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL                ETH_MACHWF0R_TSSTSSEL_INTERNAL_Msk /* Timestamp System Time Source: Internal */
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Pos            (26U)
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Msk            (0x1UL << ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Pos) /*!< 0x04000000 */
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL                ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Msk /* Timestamp System Time Source: External */
#define ETH_MACHWF0R_TSSTSSEL_BOTH_Pos                (25U)
#define ETH_MACHWF0R_TSSTSSEL_BOTH_Msk                (0x3UL << ETH_MACHWF0R_TSSTSSEL_BOTH_Pos) /*!< 0x06000000 */
#define ETH_MACHWF0R_TSSTSSEL_BOTH                    ETH_MACHWF0R_TSSTSSEL_BOTH_Msk /* Timestamp System Time Source: Internal & External */
#define ETH_MACHWF0R_MACADR64SEL_Pos                  (24U)
#define ETH_MACHWF0R_MACADR64SEL_Msk                  (0x1UL << ETH_MACHWF0R_MACADR64SEL_Pos) /*!< 0x01000000 */
#define ETH_MACHWF0R_MACADR64SEL                      ETH_MACHWF0R_MACADR64SEL_Msk /* MAC Addresses 64-127 Selected */
#define ETH_MACHWF0R_MACADR32SEL_Pos                  (23U)
#define ETH_MACHWF0R_MACADR32SEL_Msk                  (0x1UL << ETH_MACHWF0R_MACADR32SEL_Pos) /*!< 0x00800000 */
#define ETH_MACHWF0R_MACADR32SEL                      ETH_MACHWF0R_MACADR32SEL_Msk /* MAC Addresses 32-63 Selected */
#define ETH_MACHWF0R_ADDMACADRSEL_Pos                 (18U)
#define ETH_MACHWF0R_ADDMACADRSEL_Msk                 (0x1FUL << ETH_MACHWF0R_ADDMACADRSEL_Pos) /*!< 0x007C0000 */
#define ETH_MACHWF0R_ADDMACADRSEL                     ETH_MACHWF0R_ADDMACADRSEL_Msk /* MAC Addresses 1- 31 Selected */
#define ETH_MACHWF0R_RXCOESEL_Pos                     (16U)
#define ETH_MACHWF0R_RXCOESEL_Msk                     (0x1UL << ETH_MACHWF0R_RXCOESEL_Pos) /*!< 0x00010000 */
#define ETH_MACHWF0R_RXCOESEL                         ETH_MACHWF0R_RXCOESEL_Msk /* Receive Checksum Offload Enabled */
#define ETH_MACHWF0R_TXCOESEL_Pos                     (14U)
#define ETH_MACHWF0R_TXCOESEL_Msk                     (0x1UL << ETH_MACHWF0R_TXCOESEL_Pos) /*!< 0x00004000 */
#define ETH_MACHWF0R_TXCOESEL                         ETH_MACHWF0R_TXCOESEL_Msk /* Transmit Checksum Offload Enabled */
#define ETH_MACHWF0R_EEESEL_Pos                       (13U)
#define ETH_MACHWF0R_EEESEL_Msk                       (0x1UL << ETH_MACHWF0R_EEESEL_Pos) /*!< 0x00002000 */
#define ETH_MACHWF0R_EEESEL                           ETH_MACHWF0R_EEESEL_Msk  /* Energy Efficient Ethernet Enabled */
#define ETH_MACHWF0R_TSSEL_Pos                        (12U)
#define ETH_MACHWF0R_TSSEL_Msk                        (0x1UL << ETH_MACHWF0R_TSSEL_Pos) /*!< 0x00001000 */
#define ETH_MACHWF0R_TSSEL                            ETH_MACHWF0R_TSSEL_Msk   /* IEEE 1588-2008 Timestamp Enabled */
#define ETH_MACHWF0R_ARPOFFSEL_Pos                    (9U)
#define ETH_MACHWF0R_ARPOFFSEL_Msk                    (0x1UL << ETH_MACHWF0R_ARPOFFSEL_Pos) /*!< 0x00000200 */
#define ETH_MACHWF0R_ARPOFFSEL                        ETH_MACHWF0R_ARPOFFSEL_Msk /* ARP Offload Enabled */
#define ETH_MACHWF0R_MMCSEL_Pos                       (8U)
#define ETH_MACHWF0R_MMCSEL_Msk                       (0x1UL << ETH_MACHWF0R_MMCSEL_Pos) /*!< 0x00000100 */
#define ETH_MACHWF0R_MMCSEL                           ETH_MACHWF0R_MMCSEL_Msk  /* RMON Module Enable */
#define ETH_MACHWF0R_MGKSEL_Pos                       (7U)
#define ETH_MACHWF0R_MGKSEL_Msk                       (0x1UL << ETH_MACHWF0R_MGKSEL_Pos) /*!< 0x00000080 */
#define ETH_MACHWF0R_MGKSEL                           ETH_MACHWF0R_MGKSEL_Msk  /* PMT Magic Packet Enable */
#define ETH_MACHWF0R_RWKSEL_Pos                       (6U)
#define ETH_MACHWF0R_RWKSEL_Msk                       (0x1UL << ETH_MACHWF0R_RWKSEL_Pos) /*!< 0x00000040 */
#define ETH_MACHWF0R_RWKSEL                           ETH_MACHWF0R_RWKSEL_Msk  /* PMT Remote Wake-up Packet Enable */
#define ETH_MACHWF0R_SMASEL_Pos                       (5U)
#define ETH_MACHWF0R_SMASEL_Msk                       (0x1UL << ETH_MACHWF0R_SMASEL_Pos) /*!< 0x00000020 */
#define ETH_MACHWF0R_SMASEL                           ETH_MACHWF0R_SMASEL_Msk  /* SMA (MDIO) Interface */
#define ETH_MACHWF0R_VLHASH_Pos                       (4U)
#define ETH_MACHWF0R_VLHASH_Msk                       (0x1UL << ETH_MACHWF0R_VLHASH_Pos) /*!< 0x00000010 */
#define ETH_MACHWF0R_VLHASH                           ETH_MACHWF0R_VLHASH_Msk  /* VLAN Hash Filter Selected */
#define ETH_MACHWF0R_PCSSEL_Pos                       (3U)
#define ETH_MACHWF0R_PCSSEL_Msk                       (0x1UL << ETH_MACHWF0R_PCSSEL_Pos) /*!< 0x00000008 */
#define ETH_MACHWF0R_PCSSEL                           ETH_MACHWF0R_PCSSEL_Msk  /* PCS Registers (TBI, SGMII, or RTBI PHY interface) */
#define ETH_MACHWF0R_HDSEL_Pos                        (2U)
#define ETH_MACHWF0R_HDSEL_Msk                        (0x1UL << ETH_MACHWF0R_HDSEL_Pos) /*!< 0x00000004 */
#define ETH_MACHWF0R_HDSEL                            ETH_MACHWF0R_HDSEL_Msk   /* Half-duplex Support */
#define ETH_MACHWF0R_GMIISEL_Pos                      (1U)
#define ETH_MACHWF0R_GMIISEL_Msk                      (0x1UL << ETH_MACHWF0R_GMIISEL_Pos) /*!< 0x00000002 */
#define ETH_MACHWF0R_GMIISEL                          ETH_MACHWF0R_GMIISEL_Msk /* 1000 Mbps Support */
#define ETH_MACHWF0R_MIISEL_Pos                       (0U)
#define ETH_MACHWF0R_MIISEL_Msk                       (0x1UL << ETH_MACHWF0R_MIISEL_Pos) /*!< 0x00000001 */
#define ETH_MACHWF0R_MIISEL                           ETH_MACHWF0R_MIISEL_Msk  /* 10 or 100 Mbps Support */

/* Bit definition for Ethernet MAC HW Feature1 Register */
#define ETH_MACHWF1R_L3L4FNUM_Pos                     (27U)
#define ETH_MACHWF1R_L3L4FNUM_Msk                     (0xFUL << ETH_MACHWF1R_L3L4FNUM_Pos) /*!< 0x78000000 */
#define ETH_MACHWF1R_L3L4FNUM                         ETH_MACHWF1R_L3L4FNUM_Msk /* Total number of L3 or L4 Filters */
#define ETH_MACHWF1R_HASHTBLSZ_Pos                    (24U)
#define ETH_MACHWF1R_HASHTBLSZ_Msk                    (0x3UL << ETH_MACHWF1R_HASHTBLSZ_Pos) /*!< 0x03000000 */
#define ETH_MACHWF1R_HASHTBLSZ                        ETH_MACHWF1R_HASHTBLSZ_Msk /* Hash Table Size */
#define ETH_MACHWF1R_AVSEL_Pos                        (20U)
#define ETH_MACHWF1R_AVSEL_Msk                        (0x1UL << ETH_MACHWF1R_AVSEL_Pos) /*!< 0x00100000 */
#define ETH_MACHWF1R_AVSEL                            ETH_MACHWF1R_AVSEL_Msk   /* AV Feature Enabled */
#define ETH_MACHWF1R_DBGMEMA_Pos                      (19U)
#define ETH_MACHWF1R_DBGMEMA_Msk                      (0x1UL << ETH_MACHWF1R_DBGMEMA_Pos) /*!< 0x00080000 */
#define ETH_MACHWF1R_DBGMEMA                          ETH_MACHWF1R_DBGMEMA_Msk /* Debug Memory Interface Enabled */
#define ETH_MACHWF1R_TSOEN_Pos                        (18U)
#define ETH_MACHWF1R_TSOEN_Msk                        (0x1UL << ETH_MACHWF1R_TSOEN_Pos) /*!< 0x00040000 */
#define ETH_MACHWF1R_TSOEN                            ETH_MACHWF1R_TSOEN_Msk   /* TCP Segmentation Offload Enable */
#define ETH_MACHWF1R_SPHEN_Pos                        (17U)
#define ETH_MACHWF1R_SPHEN_Msk                        (0x1UL << ETH_MACHWF1R_SPHEN_Pos) /*!< 0x00020000 */
#define ETH_MACHWF1R_SPHEN                            ETH_MACHWF1R_SPHEN_Msk   /* Split Header Feature Enable */
#define ETH_MACHWF1R_DCBEN_Pos                        (16U)
#define ETH_MACHWF1R_DCBEN_Msk                        (0x1UL << ETH_MACHWF1R_DCBEN_Pos) /*!< 0x00010000 */
#define ETH_MACHWF1R_DCBEN                            ETH_MACHWF1R_DCBEN_Msk   /* DCB Feature Enable */
#define ETH_MACHWF1R_ADDR64_Pos                       (14U)
#define ETH_MACHWF1R_ADDR64_Msk                       (0x3UL << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x0000C000 */
#define ETH_MACHWF1R_ADDR64                           ETH_MACHWF1R_ADDR64_Msk  /* Address Width */
#define ETH_MACHWF1R_ADDR64_32                        (0x0UL << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00000000 */
#define ETH_MACHWF1R_ADDR64_40                        (0x1UL << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00004000 */
#define ETH_MACHWF1R_ADDR64_48                        (0x2UL << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00008000 */
#define ETH_MACHWF1R_ADVTHWORD_Pos                    (13U)
#define ETH_MACHWF1R_ADVTHWORD_Msk                    (0x1UL << ETH_MACHWF1R_ADVTHWORD_Pos) /*!< 0x00002000 */
#define ETH_MACHWF1R_ADVTHWORD                        ETH_MACHWF1R_ADVTHWORD_Msk /* IEEE 1588 High Word Register Enable */
#define ETH_MACHWF1R_PTOEN_Pos                        (12U)
#define ETH_MACHWF1R_PTOEN_Msk                        (0x1UL << ETH_MACHWF1R_PTOEN_Pos) /*!< 0x00001000 */
#define ETH_MACHWF1R_PTOEN                            ETH_MACHWF1R_PTOEN_Msk   /* PTP Offload Enable */
#define ETH_MACHWF1R_OSTEN_Pos                        (11U)
#define ETH_MACHWF1R_OSTEN_Msk                        (0x1UL << ETH_MACHWF1R_OSTEN_Pos) /*!< 0x00000800 */
#define ETH_MACHWF1R_OSTEN                            ETH_MACHWF1R_OSTEN_Msk   /* One-Step Timestamping Enable */
#define ETH_MACHWF1R_TXFIFOSIZE_Pos                   (6U)
#define ETH_MACHWF1R_TXFIFOSIZE_Msk                   (0x1FUL << ETH_MACHWF1R_TXFIFOSIZE_Pos) /*!< 0x000007C0 */
#define ETH_MACHWF1R_TXFIFOSIZE                       ETH_MACHWF1R_TXFIFOSIZE_Msk /* MTL Transmit FIFO Size */
#define ETH_MACHWF1R_RXFIFOSIZE_Pos                   (0U)
#define ETH_MACHWF1R_RXFIFOSIZE_Msk                   (0x1FUL << ETH_MACHWF1R_RXFIFOSIZE_Pos) /*!< 0x0000001F */
#define ETH_MACHWF1R_RXFIFOSIZE                       ETH_MACHWF1R_RXFIFOSIZE_Msk /* MTL Receive FIFO Size */

/* Bit definition for Ethernet MAC HW Feature2 Register */
#define ETH_MACHWF2R_AUXSNAPNUM_Pos                   (28U)
#define ETH_MACHWF2R_AUXSNAPNUM_Msk                   (0x7UL << ETH_MACHWF2R_AUXSNAPNUM_Pos) /*!< 0x70000000 */
#define ETH_MACHWF2R_AUXSNAPNUM                       ETH_MACHWF2R_AUXSNAPNUM_Msk /* Number of Auxiliary Snapshot Inputs */
#define ETH_MACHWF2R_PPSOUTNUM_Pos                    (24U)
#define ETH_MACHWF2R_PPSOUTNUM_Msk                    (0x7UL << ETH_MACHWF2R_PPSOUTNUM_Pos) /*!< 0x07000000 */
#define ETH_MACHWF2R_PPSOUTNUM                        ETH_MACHWF2R_PPSOUTNUM_Msk /*  Number of PPS Outputs */
#define ETH_MACHWF2R_TXCHCNT_Pos                      (18U)
#define ETH_MACHWF2R_TXCHCNT_Msk                      (0xFUL << ETH_MACHWF2R_TXCHCNT_Pos) /*!< 0x003C0000 */
#define ETH_MACHWF2R_TXCHCNT                          ETH_MACHWF2R_TXCHCNT_Msk /* Number of DMA Transmit Channels */
#define ETH_MACHWF2R_RXCHCNT_Pos                      (13U)
#define ETH_MACHWF2R_RXCHCNT_Msk                      (0x7UL << ETH_MACHWF2R_RXCHCNT_Pos) /*!< 0x0000E000 */
#define ETH_MACHWF2R_RXCHCNT                          ETH_MACHWF2R_RXCHCNT_Msk /* Number of DMA Receive Channels */
#define ETH_MACHWF2R_TXQCNT_Pos                       (6U)
#define ETH_MACHWF2R_TXQCNT_Msk                       (0xFUL << ETH_MACHWF2R_TXQCNT_Pos) /*!< 0x000003C0 */
#define ETH_MACHWF2R_TXQCNT                           ETH_MACHWF2R_TXQCNT_Msk  /* Number of MTL Transmit Queues */
#define ETH_MACHWF2R_RXQCNT_Pos                       (0U)
#define ETH_MACHWF2R_RXQCNT_Msk                       (0xFUL << ETH_MACHWF2R_RXQCNT_Pos) /*!< 0x0000000F */
#define ETH_MACHWF2R_RXQCNT                           ETH_MACHWF2R_RXQCNT_Msk  /* Number of MTL Receive Queues */

/* Bit definition for Ethernet MAC MDIO Address Register */
#define ETH_MACMDIOAR_PSE_Pos                         (27U)
#define ETH_MACMDIOAR_PSE_Msk                         (0x1UL << ETH_MACMDIOAR_PSE_Pos) /*!< 0x08000000 */
#define ETH_MACMDIOAR_PSE                             ETH_MACMDIOAR_PSE_Msk    /* Preamble Suppression Enable */
#define ETH_MACMDIOAR_BTB_Pos                         (26U)
#define ETH_MACMDIOAR_BTB_Msk                         (0x1UL << ETH_MACMDIOAR_BTB_Pos) /*!< 0x04000000 */
#define ETH_MACMDIOAR_BTB                             ETH_MACMDIOAR_BTB_Msk    /* Back to Back transactions */
#define ETH_MACMDIOAR_PA_Pos                          (21U)
#define ETH_MACMDIOAR_PA_Msk                          (0x1FUL << ETH_MACMDIOAR_PA_Pos) /*!< 0x03E00000 */
#define ETH_MACMDIOAR_PA                              ETH_MACMDIOAR_PA_Msk     /* Physical Layer Address */
#define ETH_MACMDIOAR_RDA_Pos                         (16U)
#define ETH_MACMDIOAR_RDA_Msk                         (0x1FUL << ETH_MACMDIOAR_RDA_Pos) /*!< 0x001F0000 */
#define ETH_MACMDIOAR_RDA                             ETH_MACMDIOAR_RDA_Msk    /* Register/Device Address */
#define ETH_MACMDIOAR_NTC_Pos                         (12U)
#define ETH_MACMDIOAR_NTC_Msk                         (0x7UL << ETH_MACMDIOAR_NTC_Pos) /*!< 0x00007000 */
#define ETH_MACMDIOAR_NTC                             ETH_MACMDIOAR_NTC_Msk    /* Number of Trailing Clocks */
#define ETH_MACMDIOAR_CR_Pos                          (8U)
#define ETH_MACMDIOAR_CR_Msk                          (0xFUL << ETH_MACMDIOAR_CR_Pos) /*!< 0x00000F00 */
#define ETH_MACMDIOAR_CR                              ETH_MACMDIOAR_CR_Msk     /* CSR Clock Range */
#define ETH_MACMDIOAR_CR_DIV42                        ((uint32_t)0x00000000)   /* CSR clock/42 */
#define ETH_MACMDIOAR_CR_DIV62_Pos                    (8U)
#define ETH_MACMDIOAR_CR_DIV62_Msk                    (0x1UL << ETH_MACMDIOAR_CR_DIV62_Pos) /*!< 0x00000100 */
#define ETH_MACMDIOAR_CR_DIV62                        ETH_MACMDIOAR_CR_DIV62_Msk /* CSR clock/62 */
#define ETH_MACMDIOAR_CR_DIV16_Pos                    (9U)
#define ETH_MACMDIOAR_CR_DIV16_Msk                    (0x1UL << ETH_MACMDIOAR_CR_DIV16_Pos) /*!< 0x00000200 */
#define ETH_MACMDIOAR_CR_DIV16                        ETH_MACMDIOAR_CR_DIV16_Msk /* CSR clock/16 */
#define ETH_MACMDIOAR_CR_DIV26_Pos                    (8U)
#define ETH_MACMDIOAR_CR_DIV26_Msk                    (0x3UL << ETH_MACMDIOAR_CR_DIV26_Pos) /*!< 0x00000300 */
#define ETH_MACMDIOAR_CR_DIV26                        ETH_MACMDIOAR_CR_DIV26_Msk /* CSR clock/26 */
#define ETH_MACMDIOAR_CR_DIV102_Pos                   (10U)
#define ETH_MACMDIOAR_CR_DIV102_Msk                   (0x1UL << ETH_MACMDIOAR_CR_DIV102_Pos) /*!< 0x00000400 */
#define ETH_MACMDIOAR_CR_DIV102                       ETH_MACMDIOAR_CR_DIV102_Msk /* CSR clock/102 */
#define ETH_MACMDIOAR_CR_DIV124_Pos                   (8U)
#define ETH_MACMDIOAR_CR_DIV124_Msk                   (0x5UL << ETH_MACMDIOAR_CR_DIV124_Pos) /*!< 0x00000500 */
#define ETH_MACMDIOAR_CR_DIV124                       ETH_MACMDIOAR_CR_DIV124_Msk /* CSR clock/124 */
#define ETH_MACMDIOAR_CR_DIV4AR_Pos                   (11U)
#define ETH_MACMDIOAR_CR_DIV4AR_Msk                   (0x1UL << ETH_MACMDIOAR_CR_DIV4AR_Pos) /*!< 0x00000800 */
#define ETH_MACMDIOAR_CR_DIV4AR                       ETH_MACMDIOAR_CR_DIV4AR_Msk /* CSR clock/4: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV6AR_Pos                   (8U)
#define ETH_MACMDIOAR_CR_DIV6AR_Msk                   (0x9UL << ETH_MACMDIOAR_CR_DIV6AR_Pos) /*!< 0x00000900 */
#define ETH_MACMDIOAR_CR_DIV6AR                       ETH_MACMDIOAR_CR_DIV6AR_Msk /* CSR clock/6: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV8AR_Pos                   (9U)
#define ETH_MACMDIOAR_CR_DIV8AR_Msk                   (0x5UL << ETH_MACMDIOAR_CR_DIV8AR_Pos) /*!< 0x00000A00 */
#define ETH_MACMDIOAR_CR_DIV8AR                       ETH_MACMDIOAR_CR_DIV8AR_Msk /* CSR clock/8: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV10AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV10AR_Msk                  (0xBUL << ETH_MACMDIOAR_CR_DIV10AR_Pos) /*!< 0x00000B00 */
#define ETH_MACMDIOAR_CR_DIV10AR                      ETH_MACMDIOAR_CR_DIV10AR_Msk /* CSR clock/10: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV12AR_Pos                  (10U)
#define ETH_MACMDIOAR_CR_DIV12AR_Msk                  (0x3UL << ETH_MACMDIOAR_CR_DIV12AR_Pos) /*!< 0x00000C00 */
#define ETH_MACMDIOAR_CR_DIV12AR                      ETH_MACMDIOAR_CR_DIV12AR_Msk /* CSR clock/12: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV14AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV14AR_Msk                  (0xDUL << ETH_MACMDIOAR_CR_DIV14AR_Pos) /*!< 0x00000D00 */
#define ETH_MACMDIOAR_CR_DIV14AR                      ETH_MACMDIOAR_CR_DIV14AR_Msk /* CSR clock/14: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV16AR_Pos                  (9U)
#define ETH_MACMDIOAR_CR_DIV16AR_Msk                  (0x7UL << ETH_MACMDIOAR_CR_DIV16AR_Pos) /*!< 0x00000E00 */
#define ETH_MACMDIOAR_CR_DIV16AR                      ETH_MACMDIOAR_CR_DIV16AR_Msk /* CSR clock/16: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV18AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV18AR_Msk                  (0xFUL << ETH_MACMDIOAR_CR_DIV18AR_Pos) /*!< 0x00000F00 */
#define ETH_MACMDIOAR_CR_DIV18AR                      ETH_MACMDIOAR_CR_DIV18AR_Msk /* CSR clock/18: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_SKAP_Pos                        (4U)
#define ETH_MACMDIOAR_SKAP_Msk                        (0x1UL << ETH_MACMDIOAR_SKAP_Pos) /*!< 0x00000010 */
#define ETH_MACMDIOAR_SKAP                            ETH_MACMDIOAR_SKAP_Msk   /* Skip Address Packet */
#define ETH_MACMDIOAR_MOC_Pos                         (2U)
#define ETH_MACMDIOAR_MOC_Msk                         (0x3UL << ETH_MACMDIOAR_MOC_Pos) /*!< 0x0000000C */
#define ETH_MACMDIOAR_MOC                             ETH_MACMDIOAR_MOC_Msk    /* MII Operation Command */
#define ETH_MACMDIOAR_MOC_WR_Pos                      (2U)
#define ETH_MACMDIOAR_MOC_WR_Msk                      (0x1UL << ETH_MACMDIOAR_MOC_WR_Pos) /*!< 0x00000004 */
#define ETH_MACMDIOAR_MOC_WR                          ETH_MACMDIOAR_MOC_WR_Msk /* Write */
#define ETH_MACMDIOAR_MOC_PRDIA_Pos                   (3U)
#define ETH_MACMDIOAR_MOC_PRDIA_Msk                   (0x1UL << ETH_MACMDIOAR_MOC_PRDIA_Pos) /*!< 0x00000008 */
#define ETH_MACMDIOAR_MOC_PRDIA                       ETH_MACMDIOAR_MOC_PRDIA_Msk /* Post Read Increment Address for Clause 45 PHY */
#define ETH_MACMDIOAR_MOC_RD_Pos                      (2U)
#define ETH_MACMDIOAR_MOC_RD_Msk                      (0x3UL << ETH_MACMDIOAR_MOC_RD_Pos) /*!< 0x0000000C */
#define ETH_MACMDIOAR_MOC_RD                          ETH_MACMDIOAR_MOC_RD_Msk /* Read */
#define ETH_MACMDIOAR_C45E_Pos                        (1U)
#define ETH_MACMDIOAR_C45E_Msk                        (0x1UL << ETH_MACMDIOAR_C45E_Pos) /*!< 0x00000002 */
#define ETH_MACMDIOAR_C45E                            ETH_MACMDIOAR_C45E_Msk   /* Clause 45 PHY Enable */
#define ETH_MACMDIOAR_MB_Pos                          (0U)
#define ETH_MACMDIOAR_MB_Msk                          (0x1UL << ETH_MACMDIOAR_MB_Pos) /*!< 0x00000001 */
#define ETH_MACMDIOAR_MB                              ETH_MACMDIOAR_MB_Msk     /* MII Busy */

/* Bit definition for Ethernet MAC MDIO Data Register */
#define ETH_MACMDIODR_RA_Pos                          (16U)
#define ETH_MACMDIODR_RA_Msk                          (0xFFFFUL << ETH_MACMDIODR_RA_Pos) /*!< 0xFFFF0000 */
#define ETH_MACMDIODR_RA                              ETH_MACMDIODR_RA_Msk     /* Register Address */
#define ETH_MACMDIODR_MD_Pos                          (0U)
#define ETH_MACMDIODR_MD_Msk                          (0xFFFFUL << ETH_MACMDIODR_MD_Pos) /*!< 0x0000FFFF */
#define ETH_MACMDIODR_MD                              ETH_MACMDIODR_MD_Msk     /* MII Data */

/* Bit definition for Ethernet ARP Address Register */
#define ETH_MACARPAR_ARPPA_Pos                         (0U)
#define ETH_MACARPAR_ARPPA_Msk                         (0xFFFFFFFFUL << ETH_MACARPAR_ARPPA_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACARPAR_ARPPA                             ETH_MACARPAR_ARPPA_Msk     /* ARP Protocol Address */

/* Bit definition for Ethernet MAC Address 0 High Register */
#define ETH_MACA0HR_AE_Pos                            (31U)
#define ETH_MACA0HR_AE_Msk                            (0x1UL << ETH_MACA0HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA0HR_AE                                ETH_MACA0HR_AE_Msk /* Address Enable*/
#define ETH_MACA0HR_ADDRHI_Pos                        (0U)
#define ETH_MACA0HR_ADDRHI_Msk                        (0xFFFFUL << ETH_MACA0HR_ADDRHI_Pos) /*!< 0x0000FFFF */
#define ETH_MACA0HR_ADDRHI                            ETH_MACA0HR_ADDRHI_Msk   /* MAC Address 0*/

/* Bit definition for Ethernet MAC Address 0 Low Register */
#define ETH_MACA0LR_ADDRLO_Pos                        (0U)
#define ETH_MACA0LR_ADDRLO_Msk                        (0xFFFFFFFFUL << ETH_MACA0LR_ADDRLO_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA0LR_ADDRLO                            ETH_MACA0LR_ADDRLO_Msk   /* MAC Address 0*/

/* Bit definition for Ethernet MAC Address 1 High Register */
#define ETH_MACA1HR_AE_Pos                            (31U)
#define ETH_MACA1HR_AE_Msk                            (0x1UL << ETH_MACA1HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA1HR_AE                                ETH_MACA1HR_AE_Msk /* Address Enable*/
#define ETH_MACA1HR_SA_Pos                            (30U)
#define ETH_MACA1HR_SA_Msk                            (0x1UL << ETH_MACA1HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA1HR_SA                                ETH_MACA1HR_SA_Msk /* Source Address */
#define ETH_MACA1HR_MBC_Pos                           (24U)
#define ETH_MACA1HR_MBC_Msk                           (0x3FUL << ETH_MACA1HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA1HR_MBC                               ETH_MACA1HR_MBC_Msk /* Mask Byte Control */
#define ETH_MACA1HR_ADDRHI_Pos                        (0U)
#define ETH_MACA1HR_ADDRHI_Msk                        (0xFFFFUL << ETH_MACA1HR_ADDRHI_Pos) /*!< 0x0000FFFF */
#define ETH_MACA1HR_ADDRHI                            ETH_MACA1HR_ADDRHI_Msk   /* MAC Address 1*/

/* Bit definition for Ethernet MAC Address 1 Low Register */
#define ETH_MACA1LR_ADDRLO_Pos                        (0U)
#define ETH_MACA1LR_ADDRLO_Msk                        (0xFFFFFFFFUL << ETH_MACA1LR_ADDRLO_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA1LR_ADDRLO                            ETH_MACA1LR_ADDRLO_Msk   /* MAC Address 1*/

/* Bit definition for Ethernet MAC Address 2 High Register */
#define ETH_MACA2HR_AE_Pos                            (31U)
#define ETH_MACA2HR_AE_Msk                            (0x1UL << ETH_MACA2HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA2HR_AE                                ETH_MACA2HR_AE_Msk /* Address Enable*/
#define ETH_MACA2HR_SA_Pos                            (30U)
#define ETH_MACA2HR_SA_Msk                            (0x1UL << ETH_MACA2HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA2HR_SA                                ETH_MACA2HR_SA_Msk /* Source Address */
#define ETH_MACA2HR_MBC_Pos                           (24U)
#define ETH_MACA2HR_MBC_Msk                           (0x3FUL << ETH_MACA2HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA2HR_MBC                               ETH_MACA2HR_MBC_Msk /* Mask Byte Control */
#define ETH_MACA2HR_ADDRHI_Pos                        (0U)
#define ETH_MACA2HR_ADDRHI_Msk                        (0xFFFFUL << ETH_MACA2HR_ADDRHI_Pos) /*!< 0x0000FFFF */
#define ETH_MACA2HR_ADDRHI                            ETH_MACA2HR_ADDRHI_Msk   /* MAC Address 1*/

/* Bit definition for Ethernet MAC Address 2 Low Register */
#define ETH_MACA2LR_ADDRLO_Pos                        (0U)
#define ETH_MACA2LR_ADDRLO_Msk                        (0xFFFFFFFFUL << ETH_MACA2LR_ADDRLO_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA2LR_ADDRLO                            ETH_MACA2LR_ADDRLO_Msk   /* MAC Address 2*/

/* Bit definition for Ethernet MAC Address 3 High Register */
#define ETH_MACA3HR_AE_Pos                            (31U)
#define ETH_MACA3HR_AE_Msk                            (0x1UL << ETH_MACA3HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA3HR_AE                                ETH_MACA3HR_AE_Msk /* Address Enable*/
#define ETH_MACA3HR_SA_Pos                            (30U)
#define ETH_MACA3HR_SA_Msk                            (0x1UL << ETH_MACA3HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA3HR_SA                                ETH_MACA3HR_SA_Msk /* Source Address */
#define ETH_MACA3HR_MBC_Pos                           (24U)
#define ETH_MACA3HR_MBC_Msk                           (0x3FUL << ETH_MACA3HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA3HR_MBC                               ETH_MACA3HR_MBC_Msk /* Mask Byte Control */
#define ETH_MACA3HR_ADDRHI_Pos                        (0U)
#define ETH_MACA3HR_ADDRHI_Msk                        (0xFFFFUL << ETH_MACA3HR_ADDRHI_Pos) /*!< 0x0000FFFF */
#define ETH_MACA3HR_ADDRHI                            ETH_MACA3HR_ADDRHI_Msk   /* MAC Address 1*/

/* Bit definition for Ethernet MAC Address 3 Low Register */
#define ETH_MACA3LR_ADDRLO_Pos                        (0U)
#define ETH_MACA3LR_ADDRLO_Msk                        (0xFFFFFFFFUL << ETH_MACA3LR_ADDRLO_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA3LR_ADDRLO                            ETH_MACA3LR_ADDRLO_Msk   /* MAC Address 3*/

/* Bit definition for Ethernet MAC Address High Register */
#define ETH_MACAHR_AE_Pos                             (31U)
#define ETH_MACAHR_AE_Msk                             (0x1UL << ETH_MACAHR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACAHR_AE                                 ETH_MACAHR_AE_Msk        /* Address enable */
#define ETH_MACAHR_SA_Pos                             (30U)
#define ETH_MACAHR_SA_Msk                             (0x1UL << ETH_MACAHR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACAHR_SA                                 ETH_MACAHR_SA_Msk        /* Source address */
#define ETH_MACAHR_MBC_Pos                            (24U)
#define ETH_MACAHR_MBC_Msk                            (0x3FUL << ETH_MACAHR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACAHR_MBC                                ETH_MACAHR_MBC_Msk       /* Mask byte control: bits to mask for comparison of the MAC Address bytes */
#define ETH_MACAHR_MBC_HBITS15_8                      ((uint32_t)0x20000000)   /* Mask MAC Address high reg bits [15:8] */
#define ETH_MACAHR_MBC_HBITS7_0                       ((uint32_t)0x10000000)   /* Mask MAC Address high reg bits [7:0] */
#define ETH_MACAHR_MBC_LBITS31_24                     ((uint32_t)0x08000000)   /* Mask MAC Address low reg bits [31:24] */
#define ETH_MACAHR_MBC_LBITS23_16                     ((uint32_t)0x04000000)   /* Mask MAC Address low reg bits [23:16] */
#define ETH_MACAHR_MBC_LBITS15_8                      ((uint32_t)0x02000000)   /* Mask MAC Address low reg bits [15:8] */
#define ETH_MACAHR_MBC_LBITS7_0                       ((uint32_t)0x01000000)   /* Mask MAC Address low reg bits [7:0] */
#define ETH_MACAHR_MACAH_Pos                          (0U)
#define ETH_MACAHR_MACAH_Msk                          (0xFFFFUL << ETH_MACAHR_MACAH_Pos) /*!< 0x0000FFFF */
#define ETH_MACAHR_MACAH                              ETH_MACAHR_MACAH_Msk     /* MAC address high */

/* Bit definition for Ethernet MAC Address Low Register */
#define ETH_MACALR_MACAL_Pos                          (0U)
#define ETH_MACALR_MACAL_Msk                          (0xFFFFFFFFUL << ETH_MACALR_MACAL_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACALR_MACAL                              ETH_MACALR_MACAL_Msk     /* MAC address low */

/* Bit definition for Ethernet MMC Control Register */
#define ETH_MMCCR_UCDBC_Pos                           (8U)
#define ETH_MMCCR_UCDBC_Msk                           (0x1UL << ETH_MMCCR_UCDBC_Pos) /*!< 0x00000100 */
#define ETH_MMCCR_UCDBC                               ETH_MMCCR_UCDBC_Msk  /* Update MMC Counters for Dropped Broadcast Packets */
#define ETH_MMCCR_CNTPRSTLVL_Pos                      (5U)
#define ETH_MMCCR_CNTPRSTLVL_Msk                      (0x1UL << ETH_MMCCR_CNTPRSTLVL_Pos) /*!< 0x00000020 */
#define ETH_MMCCR_CNTPRSTLVL                          ETH_MMCCR_CNTPRSTLVL_Msk  /* Full-Half Preset */
#define ETH_MMCCR_CNTPRST_Pos                         (4U)
#define ETH_MMCCR_CNTPRST_Msk                         (0x1UL << ETH_MMCCR_CNTPRST_Pos) /*!< 0x00000010 */
#define ETH_MMCCR_CNTPRST                             ETH_MMCCR_CNTPRST_Msk  /* Counters Reset */
#define ETH_MMCCR_CNTFREEZ_Pos                        (3U)
#define ETH_MMCCR_CNTFREEZ_Msk                        (0x1UL << ETH_MMCCR_CNTFREEZ_Pos) /*!< 0x00000008 */
#define ETH_MMCCR_CNTFREEZ                            ETH_MMCCR_CNTFREEZ_Msk  /* MMC Counter Freeze */
#define ETH_MMCCR_RSTONRD_Pos                         (2U)
#define ETH_MMCCR_RSTONRD_Msk                         (0x1UL << ETH_MMCCR_RSTONRD_Pos) /*!< 0x00000004 */
#define ETH_MMCCR_RSTONRD                             ETH_MMCCR_RSTONRD_Msk  /* Reset On Read */
#define ETH_MMCCR_CNTSTOPRO_Pos                       (1U)
#define ETH_MMCCR_CNTSTOPRO_Msk                       (0x1UL << ETH_MMCCR_CNTSTOPRO_Pos) /*!< 0x00000002 */
#define ETH_MMCCR_CNTSTOPRO                           ETH_MMCCR_CNTSTOPRO_Msk  /* Counter Stop Rollover */
#define ETH_MMCCR_CNTRST_Pos                          (0U)
#define ETH_MMCCR_CNTRST_Msk                          (0x1UL << ETH_MMCCR_CNTRST_Pos) /*!< 0x00000001 */
#define ETH_MMCCR_CNTRST                              ETH_MMCCR_CNTRST_Msk  /* Counters Reset */

/* Bit definition for Ethernet MMC Rx Interrupt Register */
#define ETH_MMCRIR_RXLPITRCIS_Pos                     (27U)
#define ETH_MMCRIR_RXLPITRCIS_Msk                     (0x1UL << ETH_MMCRIR_RXLPITRCIS_Pos) /*!< 0x08000000 */
#define ETH_MMCRIR_RXLPITRCIS                         ETH_MMCRIR_RXLPITRCIS_Msk  /* MMC Receive LPI transition counter interrupt status */
#define ETH_MMCRIR_RXLPIUSCIS_Pos                     (26U)
#define ETH_MMCRIR_RXLPIUSCIS_Msk                     (0x1UL << ETH_MMCRIR_RXLPIUSCIS_Pos) /*!< 0x04000000 */
#define ETH_MMCRIR_RXLPIUSCIS                         ETH_MMCRIR_RXLPIUSCIS_Msk  /* MMC Receive LPI microsecond counter interrupt status */
#define ETH_MMCRIR_RXUCGPIS_Pos                       (17U)
#define ETH_MMCRIR_RXUCGPIS_Msk                       (0x1UL << ETH_MMCRIR_RXUCGPIS_Pos) /*!< 0x00020000 */
#define ETH_MMCRIR_RXUCGPIS                           ETH_MMCRIR_RXUCGPIS_Msk  /* MMC Receive Unicast Good Packet Counter Interrupt Status */
#define ETH_MMCRIR_RXALGNERPIS_Pos                    (6U)
#define ETH_MMCRIR_RXALGNERPIS_Msk                    (0x1UL << ETH_MMCRIR_RXALGNERPIS_Pos) /*!< 0x00000040 */
#define ETH_MMCRIR_RXALGNERPIS                        ETH_MMCRIR_RXALGNERPIS_Msk  /* MMC Receive Alignment Error Packet Counter Interrupt Status */
#define ETH_MMCRIR_RXCRCERPIS_Pos                     (5U)
#define ETH_MMCRIR_RXCRCERPIS_Msk                     (0x1UL << ETH_MMCRIR_RXCRCERPIS_Pos) /*!< 0x00000020 */
#define ETH_MMCRIR_RXCRCERPIS                         ETH_MMCRIR_RXCRCERPIS_Msk  /* MMC Receive CRC Error Packet Counter Interrupt Status */

/* Bit definition for Ethernet MMC Tx Interrupt Register */
#define ETH_MMCTIR_TXLPITRCIS_Pos                     (27U)
#define ETH_MMCTIR_TXLPITRCIS_Msk                     (0x1UL << ETH_MMCTIR_TXLPITRCIS_Pos) /*!< 0x08000000 */
#define ETH_MMCTIR_TXLPITRCIS                         ETH_MMCTIR_TXLPITRCIS_Msk  /* MMC Transmit LPI transition counter interrupt status */
#define ETH_MMCTIR_TXLPIUSCIS_Pos                     (26U)
#define ETH_MMCTIR_TXLPIUSCIS_Msk                     (0x1UL << ETH_MMCTIR_TXLPIUSCIS_Pos) /*!< 0x04000000 */
#define ETH_MMCTIR_TXLPIUSCIS                         ETH_MMCTIR_TXLPIUSCIS_Msk  /* MMC Transmit LPI microsecond counter interrupt status */
#define ETH_MMCTIR_TXGPKTIS_Pos                       (21U)
#define ETH_MMCTIR_TXGPKTIS_Msk                       (0x1UL << ETH_MMCTIR_TXGPKTIS_Pos) /*!< 0x00200000 */
#define ETH_MMCTIR_TXGPKTIS                           ETH_MMCTIR_TXGPKTIS_Msk  /* MMC Transmit Good Packet Counter Interrupt Status */
#define ETH_MMCTIR_TXMCOLGPIS_Pos                     (15U)
#define ETH_MMCTIR_TXMCOLGPIS_Msk                     (0x1UL << ETH_MMCTIR_TXMCOLGPIS_Pos) /*!< 0x00008000 */
#define ETH_MMCTIR_TXMCOLGPIS                         ETH_MMCTIR_TXMCOLGPIS_Msk  /* MMC Transmit Multiple Collision Good Packet Counter Interrupt Status */
#define ETH_MMCTIR_TXSCOLGPIS_Pos                     (14U)
#define ETH_MMCTIR_TXSCOLGPIS_Msk                     (0x1UL << ETH_MMCTIR_TXSCOLGPIS_Pos) /*!< 0x00004000 */
#define ETH_MMCTIR_TXSCOLGPIS                         ETH_MMCTIR_TXSCOLGPIS_Msk  /* MMC Transmit Single Collision Good Packet Counter Interrupt Status */

/* Bit definition for Ethernet MMC Rx interrupt Mask register */
#define ETH_MMCRIMR_RXLPITRCIM_Pos                    (27U)
#define ETH_MMCRIMR_RXLPITRCIM_Msk                    (0x1UL << ETH_MMCRIMR_RXLPITRCIM_Pos) /*!< 0x08000000 */
#define ETH_MMCRIMR_RXLPITRCIM                        ETH_MMCRIMR_RXLPITRCIM_Msk  /* MMC Receive LPI transition counter interrupt Mask */
#define ETH_MMCRIMR_RXLPIUSCIM_Pos                    (26U)
#define ETH_MMCRIMR_RXLPIUSCIM_Msk                    (0x1UL << ETH_MMCRIMR_RXLPIUSCIM_Pos) /*!< 0x04000000 */
#define ETH_MMCRIMR_RXLPIUSCIM                        ETH_MMCRIMR_RXLPIUSCIM_Msk  /* MMC Receive LPI microsecond counter interrupt Mask */
#define ETH_MMCRIMR_RXUCGPIM_Pos                      (17U)
#define ETH_MMCRIMR_RXUCGPIM_Msk                      (0x1UL << ETH_MMCRIMR_RXUCGPIM_Pos) /*!< 0x00020000 */
#define ETH_MMCRIMR_RXUCGPIM                          ETH_MMCRIMR_RXUCGPIM_Msk  /* MMC Receive Unicast Good Packet Counter Interrupt Mask */
#define ETH_MMCRIMR_RXALGNERPIM_Pos                   (6U)
#define ETH_MMCRIMR_RXALGNERPIM_Msk                   (0x1UL << ETH_MMCRIMR_RXALGNERPIM_Pos) /*!< 0x00000040 */
#define ETH_MMCRIMR_RXALGNERPIM                       ETH_MMCRIMR_RXALGNERPIM_Msk  /* MMC Receive Alignment Error Packet Counter Interrupt Mask */
#define ETH_MMCRIMR_RXCRCERPIM_Pos                    (5U)
#define ETH_MMCRIMR_RXCRCERPIM_Msk                    (0x1UL << ETH_MMCRIMR_RXCRCERPIM_Pos) /*!< 0x00000020 */
#define ETH_MMCRIMR_RXCRCERPIM                        ETH_MMCRIMR_RXCRCERPIM_Msk  /* MMC Receive CRC Error Packet Counter Interrupt Mask */

/* Bit definition for Ethernet MMC Tx Interrupt Mask Register */
#define ETH_MMCTIMR_TXLPITRCIM_Pos                    (27U)
#define ETH_MMCTIMR_TXLPITRCIM_Msk                    (0x1UL << ETH_MMCTIMR_TXLPITRCIM_Pos) /*!< 0x08000000 */
#define ETH_MMCTIMR_TXLPITRCIM                        ETH_MMCTIMR_TXLPITRCIM_Msk  /* MMC Transmit LPI transition counter interrupt Mask*/
#define ETH_MMCTIMR_TXLPIUSCIM_Pos                    (26U)
#define ETH_MMCTIMR_TXLPIUSCIM_Msk                    (0x1UL << ETH_MMCTIMR_TXLPIUSCIM_Pos) /*!< 0x04000000 */
#define ETH_MMCTIMR_TXLPIUSCIM                        ETH_MMCTIMR_TXLPIUSCIM_Msk  /* MMC Transmit LPI microsecond counter interrupt Mask*/
#define ETH_MMCTIMR_TXGPKTIM_Pos                      (21U)
#define ETH_MMCTIMR_TXGPKTIM_Msk                      (0x1UL << ETH_MMCTIMR_TXGPKTIM_Pos) /*!< 0x00200000 */
#define ETH_MMCTIMR_TXGPKTIM                          ETH_MMCTIMR_TXGPKTIM_Msk  /* MMC Transmit Good Packet Counter Interrupt Mask*/
#define ETH_MMCTIMR_TXMCOLGPIM_Pos                    (15U)
#define ETH_MMCTIMR_TXMCOLGPIM_Msk                    (0x1UL << ETH_MMCTIMR_TXMCOLGPIM_Pos) /*!< 0x00008000 */
#define ETH_MMCTIMR_TXMCOLGPIM                        ETH_MMCTIMR_TXMCOLGPIM_Msk  /* MMC Transmit Multiple Collision Good Packet Counter Interrupt Mask */
#define ETH_MMCTIMR_TXSCOLGPIM_Pos                    (14U)
#define ETH_MMCTIMR_TXSCOLGPIM_Msk                    (0x1UL << ETH_MMCTIMR_TXSCOLGPIM_Pos) /*!< 0x00004000 */
#define ETH_MMCTIMR_TXSCOLGPIM                        ETH_MMCTIMR_TXSCOLGPIM_Msk  /* MMC Transmit Single Collision Good Packet Counter Interrupt Mask */

/* Bit definition for Ethernet MMC Tx Single Collision Good Packets Register */
#define ETH_MMCTSCGPR_TXSNGLCOLG_Pos                  (0U)
#define ETH_MMCTSCGPR_TXSNGLCOLG_msk                  (0xFFFFFFFFUL <<  ETH_MMCTSCGPR_TXSNGLCOLG_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTSCGPR_TXSNGLCOLG                      ETH_MMCTSCGPR_TXSNGLCOLG_msk /* Tx Single Collision Good Packets */

/* Bit definition for Ethernet MMC Tx Multiple Collision Good Packets Register */
#define ETH_MMCTMCGPR_TXMULTCOLG_Pos                  (0U)
#define ETH_MMCTMCGPR_TXMULTCOLG_msk                  (0xFFFFFFFFUL <<  ETH_MMCTMCGPR_TXMULTCOLG_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTMCGPR_TXMULTCOLG                      ETH_MMCTMCGPR_TXMULTCOLG_msk /* Tx Multiple Collision Good Packets */

/* Bit definition for Ethernet MMC Tx Packet Count Good Register */
#define ETH_MMCTPCGR_TXPKTG_Pos                       (0U)
#define ETH_MMCTPCGR_TXPKTG_msk                       (0xFFFFFFFFUL <<  ETH_MMCTPCGR_TXPKTG_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTPCGR_TXPKTG                           ETH_MMCTPCGR_TXPKTG_msk /* Tx Packet Count Good */

/* Bit definition for Ethernet MMC Rx CRC Error Packets Register */
#define ETH_MMCRCRCEPR_RXCRCERR_Pos                   (0U)
#define ETH_MMCRCRCEPR_RXCRCERR_msk                   (0xFFFFFFFFUL <<  ETH_MMCRCRCEPR_RXCRCERR_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRCRCEPR_RXCRCERR                       ETH_MMCRCRCEPR_RXCRCERR_msk /* Rx CRC Error Packets */

/* Bit definition for Ethernet MMC Rx alignment error packets register */
#define ETH_MMCRAEPR_RXALGNERR_Pos                    (0U)
#define ETH_MMCRAEPR_RXALGNERR_msk                    (0xFFFFFFFFUL <<  ETH_MMCRAEPR_RXALGNERR_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRAEPR_RXALGNERR                        ETH_MMCRAEPR_RXALGNERR_msk /* Rx Alignment Error Packets */

/* Bit definition for Ethernet MMC Rx Unicast Packets Good Register */
#define ETH_MMCRUPGR_RXUCASTG_Pos                     (0U)
#define ETH_MMCRUPGR_RXUCASTG_msk                     (0xFFFFFFFFUL <<  ETH_MMCRUPGR_RXUCASTG_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRUPGR_RXUCASTG                         ETH_MMCRUPGR_RXUCASTG_msk /* Rx Unicast Packets Good */

/* Bit definition for Ethernet MMC Tx LPI Microsecond Timer Register */
#define ETH_MMCTLPIMSTR_TXLPIUSC_Pos                  (0U)
#define ETH_MMCTLPIMSTR_TXLPIUSC_msk                  (0xFFFFFFFFUL <<  ETH_MMCTLPIMSTR_TXLPIUSC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTLPIMSTR_TXLPIUSC                      ETH_MMCTLPIMSTR_TXLPIUSC_msk /* Tx LPI Microseconds Counter */

/* Bit definition for Ethernet MMC Tx LPI Transition Counter Register */
#define ETH_MMCTLPITCR_TXLPITRC_Pos                   (0U)
#define ETH_MMCTLPITCR_TXLPITRC_msk                   (0xFFFFFFFFUL <<  ETH_MMCTLPITCR_TXLPITRC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTLPITCR_TXLPITRC                       ETH_MMCTLPITCR_TXLPITRC_msk /* Tx LPI Transition counter */

/* Bit definition for Ethernet MMC Rx LPI Microsecond Counter Register */
#define ETH_MMCRLPIMSTR_RXLPIUSC_Pos                  (0U)
#define ETH_MMCRLPIMSTR_RXLPIUSC_msk                  (0xFFFFFFFFUL <<  ETH_MMCRLPIMSTR_RXLPIUSC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRLPIMSTR_RXLPIUSC                      ETH_MMCRLPIMSTR_RXLPIUSC_msk /* Rx LPI Microseconds Counter */

/* Bit definition for Ethernet MMC Rx LPI Transition Counter Register */
#define ETH_MMCRLPITCR_RXLPITRC_Pos                   (0U)
#define ETH_MMCRLPITCR_RXLPITRC_msk                   (0xFFFFFFFFUL <<  ETH_MMCRLPITCR_RXLPITRC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRLPITCR_RXLPITRC                       ETH_MMCRLPITCR_RXLPITRC_msk /* Rx LPI Transition counter */

/* Bit definition for Ethernet MAC L3 L4 Control Register */
#define ETH_MACL3L4CR_L4DPIM_Pos                      (21U)
#define ETH_MACL3L4CR_L4DPIM_Msk                      (0x1UL << ETH_MACL3L4CR_L4DPIM_Pos) /*!< 0x00200000 */
#define ETH_MACL3L4CR_L4DPIM                          ETH_MACL3L4CR_L4DPIM_Msk /* Layer 4 Destination Port Inverse Match Enable */
#define ETH_MACL3L4CR_L4DPM_Pos                       (20U)
#define ETH_MACL3L4CR_L4DPM_Msk                       (0x1UL << ETH_MACL3L4CR_L4DPM_Pos) /*!< 0x00100000 */
#define ETH_MACL3L4CR_L4DPM                           ETH_MACL3L4CR_L4DPM_Msk  /* Layer 4 Destination Port Match Enable */
#define ETH_MACL3L4CR_L4SPIM_Pos                      (19U)
#define ETH_MACL3L4CR_L4SPIM_Msk                      (0x1UL << ETH_MACL3L4CR_L4SPIM_Pos) /*!< 0x00080000 */
#define ETH_MACL3L4CR_L4SPIM                          ETH_MACL3L4CR_L4SPIM_Msk /* Layer 4 Source Port Inverse Match Enable */
#define ETH_MACL3L4CR_L4SPM_Pos                       (18U)
#define ETH_MACL3L4CR_L4SPM_Msk                       (0x1UL << ETH_MACL3L4CR_L4SPM_Pos) /*!< 0x00040000 */
#define ETH_MACL3L4CR_L4SPM                           ETH_MACL3L4CR_L4SPM_Msk  /* Layer 4 Source Port Match Enable */
#define ETH_MACL3L4CR_L4PEN_Pos                       (16U)
#define ETH_MACL3L4CR_L4PEN_Msk                       (0x1UL << ETH_MACL3L4CR_L4PEN_Pos) /*!< 0x00010000 */
#define ETH_MACL3L4CR_L4PEN                           ETH_MACL3L4CR_L4PEN_Msk  /* Layer 4 Protocol Enable */
#define ETH_MACL3L4CR_L3HDBM_Pos                      (11U)
#define ETH_MACL3L4CR_L3HDBM_Msk                      (0x1FUL << ETH_MACL3L4CR_L3HDBM_Pos) /*!< 0x0000F800 */
#define ETH_MACL3L4CR_L3HDBM                          ETH_MACL3L4CR_L3HDBM_Msk /* Layer 3 IP DA Higher Bits Match */
#define ETH_MACL3L4CR_L3HSBM_Pos                      (6U)
#define ETH_MACL3L4CR_L3HSBM_Msk                      (0x1FUL << ETH_MACL3L4CR_L3HSBM_Pos) /*!< 0x000007C0 */
#define ETH_MACL3L4CR_L3HSBM                          ETH_MACL3L4CR_L3HSBM_Msk /* Layer 3 IP SA Higher Bits Match */
#define ETH_MACL3L4CR_L3DAIM_Pos                      (5U)
#define ETH_MACL3L4CR_L3DAIM_Msk                      (0x1UL << ETH_MACL3L4CR_L3DAIM_Pos) /*!< 0x00000020 */
#define ETH_MACL3L4CR_L3DAIM                          ETH_MACL3L4CR_L3DAIM_Msk /* Layer 3 IP DA Inverse Match Enable */
#define ETH_MACL3L4CR_L3DAM_Pos                       (4U)
#define ETH_MACL3L4CR_L3DAM_Msk                       (0x1UL << ETH_MACL3L4CR_L3DAM_Pos) /*!< 0x00000010 */
#define ETH_MACL3L4CR_L3DAM                           ETH_MACL3L4CR_L3DAM_Msk  /* Layer 3 IP DA Match Enable */
#define ETH_MACL3L4CR_L3SAIM_Pos                      (3U)
#define ETH_MACL3L4CR_L3SAIM_Msk                      (0x1UL << ETH_MACL3L4CR_L3SAIM_Pos) /*!< 0x00000008 */
#define ETH_MACL3L4CR_L3SAIM                          ETH_MACL3L4CR_L3SAIM_Msk /* Layer 3 IP SA Inverse Match Enable */
#define ETH_MACL3L4CR_L3SAM_Pos                       (2U)
#define ETH_MACL3L4CR_L3SAM_Msk                       (0x1UL << ETH_MACL3L4CR_L3SAM_Pos) /*!< 0x00000004 */
#define ETH_MACL3L4CR_L3SAM                           ETH_MACL3L4CR_L3SAM_Msk  /* Layer 3 IP SA Match Enable*/
#define ETH_MACL3L4CR_L3PEN_Pos                       (0U)
#define ETH_MACL3L4CR_L3PEN_Msk                       (0x1UL << ETH_MACL3L4CR_L3PEN_Pos) /*!< 0x00000001 */
#define ETH_MACL3L4CR_L3PEN                           ETH_MACL3L4CR_L3PEN_Msk  /* Layer 3 Protocol Enable */

/* Bit definition for Ethernet MAC L4 Address Register */
#define ETH_MACL4AR_L4DP_Pos                          (16U)
#define ETH_MACL4AR_L4DP_Msk                          (0xFFFFUL << ETH_MACL4AR_L4DP_Pos) /*!< 0xFFFF0000 */
#define ETH_MACL4AR_L4DP                              ETH_MACL4AR_L4DP_Msk     /* Layer 4 Destination Port Number Field */
#define ETH_MACL4AR_L4SP_Pos                          (0U)
#define ETH_MACL4AR_L4SP_Msk                          (0xFFFFUL << ETH_MACL4AR_L4SP_Pos) /*!< 0x0000FFFF */
#define ETH_MACL4AR_L4SP                              ETH_MACL4AR_L4SP_Msk     /* Layer 4 Source Port Number Field */

/* Bit definition for Ethernet MAC L3 Address0 Register */
#define ETH_MACL3A0R_L3A0_Pos                         (0U)
#define ETH_MACL3A0R_L3A0_Msk                         (0xFFFFFFFFUL << ETH_MACL3A0R_L3A0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A0R_L3A0                             ETH_MACL3A0R_L3A0_Msk    /* Layer 3 Address 0 Field */

/* Bit definition for Ethernet MAC L4 Address1 Register */
#define ETH_MACL3A1R_L3A1_Pos                         (0U)
#define ETH_MACL3A1R_L3A1_Msk                         (0xFFFFFFFFUL << ETH_MACL3A1R_L3A1_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A1R_L3A1                             ETH_MACL3A1R_L3A1_Msk    /* Layer 3 Address 1 Field */

/* Bit definition for Ethernet MAC L4 Address2 Register */
#define ETH_MACL3A2R_L3A2_Pos                         (0U)
#define ETH_MACL3A2R_L3A2_Msk                         (0xFFFFFFFFUL << ETH_MACL3A2R_L3A2_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A2R_L3A2                             ETH_MACL3A2R_L3A2_Msk    /* Layer 3 Address 2 Field */

/* Bit definition for Ethernet MAC L4 Address3 Register */
#define ETH_MACL3A3R_L3A3_Pos                         (0U)
#define ETH_MACL3A3R_L3A3_Msk                         (0xFFFFFFFFUL << ETH_MACL3A3R_L3A3_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A3R_L3A3                             ETH_MACL3A3R_L3A3_Msk    /* Layer 3 Address 3 Field */

/* Bit definition for Ethernet MAC Timestamp Control Register */
#define ETH_MACTSCR_TXTSSTSM_Pos                      (24U)
#define ETH_MACTSCR_TXTSSTSM_Msk                      (0x1UL << ETH_MACTSCR_TXTSSTSM_Pos) /*!< 0x01000000 */
#define ETH_MACTSCR_TXTSSTSM                          ETH_MACTSCR_TXTSSTSM_Msk  /* Transmit Timestamp Status Mode */
#define ETH_MACTSCR_CSC_Pos                           (19U)
#define ETH_MACTSCR_CSC_Msk                           (0x1UL << ETH_MACTSCR_CSC_Pos) /*!< 0x00080000 */
#define ETH_MACTSCR_CSC                               ETH_MACTSCR_CSC_Msk  /* Enable checksum correction during OST for PTP over UDP/IPv4 packets */
#define ETH_MACTSCR_TSENMACADDR_Pos                   (18U)
#define ETH_MACTSCR_TSENMACADDR_Msk                   (0x1UL << ETH_MACTSCR_TSENMACADDR_Pos) /*!< 0x00040000 */
#define ETH_MACTSCR_TSENMACADDR                       ETH_MACTSCR_TSENMACADDR_Msk  /* Enable MAC Address for PTP Packet Filtering */
#define ETH_MACTSCR_SNAPTYPSEL_Pos                    (16U)
#define ETH_MACTSCR_SNAPTYPSEL_Msk                    (0x3UL << ETH_MACTSCR_SNAPTYPSEL_Pos) /*!< 0x00030000 */
#define ETH_MACTSCR_SNAPTYPSEL                        ETH_MACTSCR_SNAPTYPSEL_Msk  /* Select PTP packets for Taking Snapshots */
#define ETH_MACTSCR_TSMSTRENA_Pos                     (15U)
#define ETH_MACTSCR_TSMSTRENA_Msk                     (0x1UL << ETH_MACTSCR_TSMSTRENA_Pos) /*!< 0x00008000 */
#define ETH_MACTSCR_TSMSTRENA                         ETH_MACTSCR_TSMSTRENA_Msk  /* Enable Snapshot for Messages Relevant to Master */
#define ETH_MACTSCR_TSEVNTENA_Pos                     (14U)
#define ETH_MACTSCR_TSEVNTENA_Msk                     (0x1UL << ETH_MACTSCR_TSEVNTENA_Pos) /*!< 0x00004000 */
#define ETH_MACTSCR_TSEVNTENA                         ETH_MACTSCR_TSEVNTENA_Msk  /* Enable Timestamp Snapshot for Event Messages */
#define ETH_MACTSCR_TSIPV4ENA_Pos                     (13U)
#define ETH_MACTSCR_TSIPV4ENA_Msk                     (0x1UL << ETH_MACTSCR_TSIPV4ENA_Pos) /*!< 0x00002000 */
#define ETH_MACTSCR_TSIPV4ENA                         ETH_MACTSCR_TSIPV4ENA_Msk  /* Enable Processing of PTP Packets Sent over IPv4-UDP */
#define ETH_MACTSCR_TSIPV6ENA_Pos                     (12U)
#define ETH_MACTSCR_TSIPV6ENA_Msk                     (0x1UL << ETH_MACTSCR_TSIPV6ENA_Pos) /*!< 0x00001000 */
#define ETH_MACTSCR_TSIPV6ENA                         ETH_MACTSCR_TSIPV6ENA_Msk  /* Enable Processing of PTP Packets Sent over IPv6-UDP */
#define ETH_MACTSCR_TSIPENA_Pos                       (11U)
#define ETH_MACTSCR_TSIPENA_Msk                       (0x1UL << ETH_MACTSCR_TSIPENA_Pos) /*!< 0x00000800 */
#define ETH_MACTSCR_TSIPENA                           ETH_MACTSCR_TSIPENA_Msk  /* Enable Processing of PTP over Ethernet Packets */
#define ETH_MACTSCR_TSVER2ENA_Pos                     (10U)
#define ETH_MACTSCR_TSVER2ENA_Msk                     (0x1UL << ETH_MACTSCR_TSVER2ENA_Pos) /*!< 0x00000400 */
#define ETH_MACTSCR_TSVER2ENA                         ETH_MACTSCR_TSVER2ENA_Msk  /* Enable PTP Packet Processing for Version 2 Format */
#define ETH_MACTSCR_TSCTRLSSR_Pos                     (9U)
#define ETH_MACTSCR_TSCTRLSSR_Msk                     (0x1UL << ETH_MACTSCR_TSCTRLSSR_Pos) /*!< 0x00000200 */
#define ETH_MACTSCR_TSCTRLSSR                         ETH_MACTSCR_TSCTRLSSR_Msk  /* Timestamp Digital or Binary Rollover Control */
#define ETH_MACTSCR_TSENALL_Pos                       (8U)
#define ETH_MACTSCR_TSENALL_Msk                       (0x1UL << ETH_MACTSCR_TSENALL_Pos) /*!< 0x00000100 */
#define ETH_MACTSCR_TSENALL                           ETH_MACTSCR_TSENALL_Msk  /* Enable Timestamp for All Packets */
#define ETH_MACTSCR_TSADDREG_Pos                      (5U)
#define ETH_MACTSCR_TSADDREG_Msk                      (0x1UL << ETH_MACTSCR_TSADDREG_Pos) /*!< 0x00000020 */
#define ETH_MACTSCR_TSADDREG                          ETH_MACTSCR_TSADDREG_Msk  /* Update Addend Register */
#define ETH_MACTSCR_TSUPDT_Pos                        (3U)
#define ETH_MACTSCR_TSUPDT_Msk                        (0x1UL << ETH_MACTSCR_TSUPDT_Pos) /*!< 0x00000008 */
#define ETH_MACTSCR_TSUPDT                            ETH_MACTSCR_TSUPDT_Msk  /* Update Timestamp */
#define ETH_MACTSCR_TSINIT_Pos                        (2U)
#define ETH_MACTSCR_TSINIT_Msk                        (0x1UL << ETH_MACTSCR_TSINIT_Pos) /*!< 0x00000004 */
#define ETH_MACTSCR_TSINIT                             ETH_MACTSCR_TSINIT_Msk  /* Initialize Timestamp */
#define ETH_MACTSCR_TSCFUPDT_Pos                      (1U)
#define ETH_MACTSCR_TSCFUPDT_Msk                      (0x1UL << ETH_MACTSCR_TSCFUPDT_Pos) /*!< 0x00000002 */
#define ETH_MACTSCR_TSCFUPDT                          ETH_MACTSCR_TSCFUPDT_Msk  /* Fine or Coarse Timestamp Update*/
#define ETH_MACTSCR_TSENA_Pos                         (0U)
#define ETH_MACTSCR_TSENA_Msk                         (0x1UL << ETH_MACTSCR_TSENA_Pos) /*!< 0x00000001 */
#define ETH_MACTSCR_TSENA                             ETH_MACTSCR_TSENA_Msk  /* Enable Timestamp */

/* Bit definition for Ethernet MAC Sub-second Increment Register */
#define ETH_MACMACSSIR_SSINC_Pos                      (16U)
#define ETH_MACMACSSIR_SSINC_Msk                      (0xFFUL << ETH_MACMACSSIR_SSINC_Pos) /*!< 0x0000FF00 */
#define ETH_MACMACSSIR_SSINC                          ETH_MACMACSSIR_SSINC_Msk  /* Sub-second Increment Value */
#define ETH_MACMACSSIR_SNSINC_Pos                     (8U)
#define ETH_MACMACSSIR_SNSINC_Msk                     (0xFFUL << ETH_MACMACSSIR_SNSINC_Pos) /*!< 0x000000FF */
#define ETH_MACMACSSIR_SNSINC                         ETH_MACMACSSIR_SNSINC_Msk  /* Sub-nanosecond Increment Value */

/* Bit definition for Ethernet MAC System Time Seconds Register */
#define ETH_MACSTSR_TSS_Pos                           (0U)
#define ETH_MACSTSR_TSS_Msk                           (0xFFFFFFFFUL << ETH_MACSTSR_TSS_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACSTSR_TSS                               ETH_MACSTSR_TSS_Msk  /* Timestamp Second */

/* Bit definition for Ethernet MAC System Time Nanoseconds Register */
#define ETH_MACSTNR_TSSS_Pos                          (0U)
#define ETH_MACSTNR_TSSS_Msk                          (0x7FFFFFFFUL << ETH_MACSTNR_TSSS_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACSTNR_TSSS                              ETH_MACSTNR_TSSS_Msk  /* Timestamp Sub-seconds */

/* Bit definition for Ethernet MAC System Time Seconds Update Register */
#define ETH_MACSTSUR_TSS_Pos                          (0U)
#define ETH_MACSTSUR_TSS_Msk                          (0xFFFFFFFFUL << ETH_MACSTSUR_TSS_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACSTSUR_TSS                              ETH_MACSTSUR_TSS_Msk  /* Timestamp Seconds */

/* Bit definition for Ethernet MAC System Time Nanoseconds Update Register */
#define ETH_MACSTNUR_ADDSUB_Pos                       (31U)
#define ETH_MACSTNUR_ADDSUB_Msk                       (0x1UL << ETH_MACSTNUR_ADDSUB_Pos) /*!< 0x80000000 */
#define ETH_MACSTNUR_ADDSUB                           ETH_MACSTNUR_ADDSUB_Msk  /* Add or Subtract Time */
#define ETH_MACSTNUR_TSSS_Pos                         (0U)
#define ETH_MACSTNUR_TSSS_Msk                         (0x7FFFFFFFUL << ETH_MACSTNUR_TSSS_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACSTNUR_TSSS                             ETH_MACSTNUR_TSSS_Msk  /* Timestamp Sub-seconds */

/* Bit definition for Ethernet MAC Timestamp Addend Register */
#define ETH_MACTSAR_TSAR_Pos                          (0U)
#define ETH_MACTSAR_TSAR_Msk                          (0xFFFFFFFFUL << ETH_MACTSAR_TSAR_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSAR_TSAR                              ETH_MACTSAR_TSAR_Msk  /* Timestamp Addend Register */

/* Bit definition for Ethernet MAC Timestamp Status Register */
#define ETH_MACTSSR_ATSNS_Pos                         (25U)
#define ETH_MACTSSR_ATSNS_Msk                         (0x1FUL << ETH_MACTSSR_ATSNS_Pos) /*!< 0x3E000000 */
#define ETH_MACTSSR_ATSNS                             ETH_MACTSSR_ATSNS_Msk  /* Number of Auxiliary Timestamp Snapshots */
#define ETH_MACTSSR_ATSSTM_Pos                        (24U)
#define ETH_MACTSSR_ATSSTM_Msk                        (0x1UL << ETH_MACTSSR_ATSSTM_Pos) /*!< 0x01000000 */
#define ETH_MACTSSR_ATSSTM                            ETH_MACTSSR_ATSSTM_Msk  /* Auxiliary Timestamp Snapshot Trigger Missed */
#define ETH_MACTSSR_ATSSTN_Pos                        (16U)
#define ETH_MACTSSR_ATSSTN_Msk                        (0xFUL << ETH_MACTSSR_ATSSTN_Pos) /*!< 0x000F0000 */
#define ETH_MACTSSR_ATSSTN                            ETH_MACTSSR_ATSSTN_Msk  /* Auxiliary Timestamp Snapshot Trigger Identifier */
#define ETH_MACTSSR_TXTSSIS_Pos                       (15U)
#define ETH_MACTSSR_TXTSSIS_Msk                       (0x1UL << ETH_MACTSSR_TXTSSIS_Pos) /*!< 0x00008000 */
#define ETH_MACTSSR_TXTSSIS                           ETH_MACTSSR_TXTSSIS_Msk  /* Tx Timestamp Status Interrupt Status */
#define ETH_MACTSSR_TSTRGTERR0_Pos                    (3U)
#define ETH_MACTSSR_TSTRGTERR0_Msk                    (0x1UL << ETH_MACTSSR_TSTRGTERR0_Pos) /*!< 0x00000008 */
#define ETH_MACTSSR_TSTRGTERR0                        ETH_MACTSSR_TSTRGTERR0_Msk  /* Timestamp Target Time Error */
#define ETH_MACTSSR_AUXTSTRIG_Pos                     (2U)
#define ETH_MACTSSR_AUXTSTRIG_Msk                     (0x1UL << ETH_MACTSSR_AUXTSTRIG_Pos) /*!< 0x00000004 */
#define ETH_MACTSSR_AUXTSTRIG                         ETH_MACTSSR_AUXTSTRIG_Msk  /* Auxiliary Timestamp Trigger Snapshot*/
#define ETH_MACTSSR_TSTARGT0_Pos                      (1U)
#define ETH_MACTSSR_TSTARGT0_Msk                      (0x1UL << ETH_MACTSSR_TSTARGT0_Pos) /*!< 0x00000002 */
#define ETH_MACTSSR_TSTARGT0                          ETH_MACTSSR_TSTARGT0_Msk  /* Timestamp Target Time Reached */
#define ETH_MACTSSR_TSSOVF_Pos                        (0U)
#define ETH_MACTSSR_TSSOVF_Msk                        (0x1UL << ETH_MACTSSR_TSSOVF_Pos) /*!< 0x00000001 */
#define ETH_MACTSSR_TSSOVF                            ETH_MACTSSR_TSSOVF_Msk  /* Timestamp Seconds Overflow */

/* Bit definition for Ethernet MAC Tx Timestamp Status Nanoseconds Register */
#define ETH_MACTTSSNR_TXTSSMIS_Pos                    (31U)
#define ETH_MACTTSSNR_TXTSSMIS_Msk                    (0x1UL << ETH_MACTTSSNR_TXTSSMIS_Pos) /*!< 0x80000000 */
#define ETH_MACTTSSNR_TXTSSMIS                        ETH_MACTTSSNR_TXTSSMIS_Msk  /* Transmit Timestamp Status Missed */
#define ETH_MACTTSSNR_TXTSSLO_Pos                     (0U)
#define ETH_MACTTSSNR_TXTSSLO_Msk                     (0x7FFFFFFFUL << ETH_MACTTSSNR_TXTSSLO_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACTTSSNR_TXTSSLO                         ETH_MACTTSSNR_TXTSSLO_Msk  /* Transmit Timestamp Status Low */

/* Bit definition for Ethernet MAC Tx Timestamp Status Seconds Register */
#define ETH_MACTTSSSR_TXTSSHI_Pos                     (0U)
#define ETH_MACTTSSSR_TXTSSHI_Msk                     (0xFFFFFFFFUL << ETH_MACTTSSSR_TXTSSHI_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTTSSSR_TXTSSHI                         ETH_MACTTSSSR_TXTSSHI_Msk  /* Transmit Timestamp Status High */

/* Bit definition for Ethernet MAC Auxiliary Control Register*/
#define ETH_MACACR_ATSEN3_Pos                         (7U)
#define ETH_MACACR_ATSEN3_Msk                         (0x1UL << ETH_MACACR_ATSEN3_Pos) /*!< 0x00000080 */
#define ETH_MACACR_ATSEN3                             ETH_MACACR_ATSEN3_Msk  /* Auxiliary Snapshot 3 Enable */
#define ETH_MACACR_ATSEN2_Pos                         (6U)
#define ETH_MACACR_ATSEN2_Msk                         (0x1UL << ETH_MACACR_ATSEN2_Pos) /*!< 0x00000040 */
#define ETH_MACACR_ATSEN2                             ETH_MACACR_ATSEN2_Msk  /* Auxiliary Snapshot 2 Enable */
#define ETH_MACACR_ATSEN1_Pos                         (5U)
#define ETH_MACACR_ATSEN1_Msk                         (0x1UL << ETH_MACACR_ATSEN1_Pos) /*!< 0x00000020 */
#define ETH_MACACR_ATSEN1                             ETH_MACACR_ATSEN1_Msk  /* Auxiliary Snapshot 1 Enable */
#define ETH_MACACR_ATSEN0_Pos                         (4U)
#define ETH_MACACR_ATSEN0_Msk                         (0x1UL << ETH_MACACR_ATSEN0_Pos) /*!< 0x00000010 */
#define ETH_MACACR_ATSEN0                             ETH_MACACR_ATSEN0_Msk  /* Auxiliary Snapshot 0 Enable */
#define ETH_MACACR_ATSFC_Pos                          (0U)
#define ETH_MACACR_ATSFC_Msk                          (0x1UL << ETH_MACACR_ATSFC_Pos) /*!< 0x00000001 */
#define ETH_MACACR_ATSFC                              ETH_MACACR_ATSFC_Msk  /* Auxiliary Snapshot FIFO Clear */

/* Bit definition for Ethernet MAC Auxiliary Timestamp Nanoseconds Register */
#define ETH_MACATSNR_AUXTSLO_Pos                      (0U)
#define ETH_MACATSNR_AUXTSLO_Msk                      (0x7FFFFFFFUL << ETH_MACATSNR_AUXTSLO_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACATSNR_AUXTSLO                          ETH_MACATSNR_AUXTSLO_Msk  /* Auxiliary Timestamp */

/* Bit definition for Ethernet MAC Auxiliary Timestamp Seconds Register */
#define ETH_MACATSSR_AUXTSHI_Pos                      (0U)
#define ETH_MACATSSR_AUXTSHI_Msk                      (0xFFFFFFFFUL << ETH_MACATSSR_AUXTSHI_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACATSSR_AUXTSHI                          ETH_MACATSSR_AUXTSHI_Msk  /* Auxiliary Timestamp */

/* Bit definition for Ethernet MAC Timestamp Ingress Asymmetric Correction Register */
#define ETH_MACTSIACR_OSTIAC_Pos                      (0U)
#define ETH_MACTSIACR_OSTIAC_Msk                      (0xFFFFFFFFUL << ETH_MACTSIACR_OSTIAC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSIACR_OSTIAC                          ETH_MACTSIACR_OSTIAC_Msk  /* One-Step Timestamp Ingress Asymmetry Correction */

/* Bit definition for Ethernet MAC Timestamp Egress Asymmetric Correction Register */
#define ETH_MACTSEACR_OSTEAC_Pos                      (0U)
#define ETH_MACTSEACR_OSTEAC_Msk                      (0xFFFFFFFFUL << ETH_MACTSEACR_OSTEAC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSEACR_OSTEAC                          ETH_MACTSEACR_OSTEAC_Msk  /* One-Step Timestamp Egress Asymmetry Correction */

/* Bit definition for Ethernet MAC Timestamp Ingress Correction Nanosecond Register */
#define ETH_MACTSICNR_TSIC_Pos                        (0U)
#define ETH_MACTSICNR_TSIC_Msk                        (0xFFFFFFFFUL << ETH_MACTSICNR_TSIC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSICNR_TSIC                            ETH_MACTSICNR_TSIC_Msk  /* Timestamp Ingress Correction */

/* Bit definition for Ethernet MAC Timestamp Egress correction Nanosecond Register */
#define ETH_MACTSECNR_TSEC_Pos                        (0U)
#define ETH_MACTSECNR_TSEC_Msk                        (0xFFFFFFFFUL << ETH_MACTSECNR_TSEC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSECNR_TSEC                            ETH_MACTSECNR_TSEC_Msk  /* Timestamp Egress Correction */

/* Bit definition for Ethernet MAC PPS Control Register */
#define ETH_MACPPSCR_TRGTMODSEL0_Pos                  (5U)
#define ETH_MACPPSCR_TRGTMODSEL0_Msk                  (0x3UL << ETH_MACPPSCR_TRGTMODSEL0_Pos) /*!< 0x00000060 */
#define ETH_MACPPSCR_TRGTMODSEL0                      ETH_MACPPSCR_TRGTMODSEL0_Msk  /* Target Time Register Mode for PPS Output */
#define ETH_MACPPSCR_PPSEN0_Pos                       (4U)
#define ETH_MACPPSCR_PPSEN0_Msk                       (0x1UL << ETH_MACPPSCR_PPSEN0_Pos) /*!< 0x00000010 */
#define ETH_MACPPSCR_PPSEN0                           ETH_MACPPSCR_PPSEN0_Msk  /* Flexible PPS Output Mode Enable */
#define ETH_MACPPSCR_PPSCTRL_Pos                      (0U)
#define ETH_MACPPSCR_PPSCTRL_Msk                      (0xFUL << ETH_MACPPSCR_PPSCTRL_Pos) /*!< 0x0000000F */
#define ETH_MACPPSCR_PPSCTRL                          ETH_MACPPSCR_PPSCTRL_Msk  /* PPS Output Frequency Control */

/* Bit definition for Ethernet MAC PPS Target Time Seconds Register */
#define ETH_MACPPSTTSR_TSTRH0_Pos                     (0U)
#define ETH_MACPPSTTSR_TSTRH0_Msk                     (0xFFFFFFFFUL << ETH_MACPPSTTSR_TSTRH0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACPPSTTSR_TSTRH0                         ETH_MACPPSTTSR_TSTRH0_Msk  /* PPS Target Time Seconds Register */

/* Bit definition for Ethernet MAC PPS Target Time Nanoseconds Register */
#define ETH_MACPPSTTNR_TRGTBUSY0_Pos                  (31U)
#define ETH_MACPPSTTNR_TRGTBUSY0_Msk                  (0x1UL << ETH_MACPPSTTNR_TRGTBUSY0_Pos) /*!< 0x80000000 */
#define ETH_MACPPSTTNR_TRGTBUSY0                      ETH_MACPPSTTNR_TRGTBUSY0_Msk  /* PPS Target Time Register Busy */
#define ETH_MACPPSTTNR_TTSL0_Pos                      (0U)
#define ETH_MACPPSTTNR_TTSL0_Msk                      (0x7FFFFFFFUL << ETH_MACPPSTTNR_TTSL0_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACPPSTTNR_TTSL0                          ETH_MACPPSTTNR_TTSL0_Msk  /* Target Time Low for PPS Register */

/* Bit definition for Ethernet MAC PPS Interval Register */
#define ETH_MACPPSIR_PPSINT0_Pos                      (0U)
#define ETH_MACPPSIR_PPSINT0_Msk                      (0xFFFFFFFFUL << ETH_MACPPSIR_PPSINT0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACPPSIR_PPSINT0                          ETH_MACPPSIR_PPSINT0_Msk  /* PPS Output Signal Interval */

/* Bit definition for Ethernet MAC PPS Width Register */
#define ETH_MACPPSWR_PPSWIDTH0_Pos                    (0U)
#define ETH_MACPPSWR_PPSWIDTH0_Msk                    (0xFFFFFFFFUL << ETH_MACPPSWR_PPSWIDTH0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACPPSWR_PPSWIDTH0                        ETH_MACPPSWR_PPSWIDTH0_Msk  /* PPS Output Signal Width */

/* Bit definition for Ethernet MAC PTP Offload Control Register */
#define ETH_MACPOCR_DN_Pos                            (8U)
#define ETH_MACPOCR_DN_Msk                            (0xFFUL << ETH_MACPOCR_DN_Pos) /*!< 0x0000FF00 */
#define ETH_MACPOCR_DN                                ETH_MACPOCR_DN_Msk  /* Domain Number */
#define ETH_MACPOCR_DRRDIS_Pos                        (6U)
#define ETH_MACPOCR_DRRDIS_Msk                        (0x1UL << ETH_MACPOCR_DRRDIS_Pos) /*!< 0x00000040 */
#define ETH_MACPOCR_DRRDIS                            ETH_MACPOCR_DRRDIS_Msk  /* Disable PTO Delay Request/Response response generation */
#define ETH_MACPOCR_APDREQTRIG_Pos                    (5U)
#define ETH_MACPOCR_APDREQTRIG_Msk                    (0x1UL << ETH_MACPOCR_APDREQTRIG_Pos) /*!< 0x00000020 */
#define ETH_MACPOCR_APDREQTRIG                        ETH_MACPOCR_APDREQTRIG_Msk  /* Automatic PTP Pdelay_Req message Trigger */
#define ETH_MACPOCR_ASYNCTRIG_Pos                     (4U)
#define ETH_MACPOCR_ASYNCTRIG_Msk                     (0x1UL << ETH_MACPOCR_ASYNCTRIG_Pos) /*!< 0x00000010 */
#define ETH_MACPOCR_ASYNCTRIG                         ETH_MACPOCR_ASYNCTRIG_Msk  /* Automatic PTP SYNC message Trigger */
#define ETH_MACPOCR_APDREQEN_Pos                      (2U)
#define ETH_MACPOCR_APDREQEN_Msk                      (0x1UL << ETH_MACPOCR_APDREQEN_Pos) /*!< 0x00000004 */
#define ETH_MACPOCR_APDREQEN                          ETH_MACPOCR_APDREQEN_Msk  /* Automatic PTP Pdelay_Req message Enable */
#define ETH_MACPOCR_ASYNCEN_Pos                       (1U)
#define ETH_MACPOCR_ASYNCEN_Msk                       (0x1UL << ETH_MACPOCR_ASYNCEN_Pos) /*!< 0x00000002 */
#define ETH_MACPOCR_ASYNCEN                           ETH_MACPOCR_ASYNCEN_Msk  /* Automatic PTP SYNC message Enable */
#define ETH_MACPOCR_PTOEN_Pos                         (0U)
#define ETH_MACPOCR_PTOEN_Msk                         (0x1UL << ETH_MACPOCR_PTOEN_Pos) /*!< 0x00000001 */
#define ETH_MACPOCR_PTOEN                             ETH_MACPOCR_PTOEN_Msk  /* PTP Offload Enable */

/* Bit definition for Ethernet MAC PTP Source Port Identity 0 Register */
#define ETH_MACSPI0R_SPI0_Pos                         (0U)
#define ETH_MACSPI0R_SPI0_Msk                         (0xFFFFFFFFUL << ETH_MACSPI0R_SPI0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACSPI0R_SPI0                             ETH_MACSPI0R_SPI0_Msk  /* Source Port Identity 0 */

/* Bit definition for Ethernet MAC PTP Source Port Identity 1 Register */
#define ETH_MACSPI1R_SPI1_Pos                         (0U)
#define ETH_MACSPI1R_SPI1_Msk                         (0xFFFFFFFFUL << ETH_MACSPI1R_SPI1_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACSPI1R_SPI1                             ETH_MACSPI1R_SPI1_Msk  /* Source Port Identity 1 */

/* Bit definition for Ethernet MAC PTP Source Port Identity 2 Register */
#define ETH_MACSPI2R_SPI2_Pos                         (0U)
#define ETH_MACSPI2R_SPI2_Msk                         (0xFFFFUL << ETH_MACSPI2R_SPI2_Pos) /*!< 0x0000FFFF */
#define ETH_MACSPI2R_SPI2                             ETH_MACSPI2R_SPI2_Msk  /* Source Port Identity 2 */

/* Bit definition for Ethernet MAC Log Message Interval Register */
#define ETH_MACLMIR_LMPDRI_Pos                        (24U)
#define ETH_MACLMIR_LMPDRI_Msk                        (0xFFUL << ETH_MACLMIR_LMPDRI_Pos) /*!< 0xFF000000 */
#define ETH_MACLMIR_LMPDRI                             ETH_MACLMIR_LMPDRI_Msk  /* Log Min Pdelay_Req Interval */
#define ETH_MACLMIR_DRSYNCR_Pos                       (8U)
#define ETH_MACLMIR_DRSYNCR_Msk                       (0x7UL << ETH_MACLMIR_DRSYNCR_Pos) /*!< 0x00000700 */
#define ETH_MACLMIR_DRSYNCR                           ETH_MACLMIR_DRSYNCR_Msk  /* Delay_Req to SYNC Ratio */
#define ETH_MACLMIR_LSI_Pos                           (0U)
#define ETH_MACLMIR_LSI_Msk                           (0xFFUL << ETH_MACLMIR_LSI_Pos) /*!< 0x000000FF */
#define ETH_MACLMIR_LSI                               ETH_MACLMIR_LSI_Msk  /* Log Sync Interval */

/* Bit definition for Ethernet MTL Operation Mode Register */
#define ETH_MTLOMR_CNTCLR_Pos                         (9U)
#define ETH_MTLOMR_CNTCLR_Msk                         (0x1UL << ETH_MTLOMR_CNTCLR_Pos) /*!< 0x00000200 */
#define ETH_MTLOMR_CNTCLR                             ETH_MTLOMR_CNTCLR_Msk    /* Counters Reset */
#define ETH_MTLOMR_CNTPRST_Pos                        (8U)
#define ETH_MTLOMR_CNTPRST_Msk                        (0x1UL << ETH_MTLOMR_CNTPRST_Pos) /*!< 0x00000100 */
#define ETH_MTLOMR_CNTPRST                            ETH_MTLOMR_CNTPRST_Msk   /* Counters Preset */
#define ETH_MTLOMR_DTXSTS_Pos                         (1U)
#define ETH_MTLOMR_DTXSTS_Msk                         (0x1UL << ETH_MTLOMR_DTXSTS_Pos) /*!< 0x00000002 */
#define ETH_MTLOMR_DTXSTS                             ETH_MTLOMR_DTXSTS_Msk  /* Drop Transmit Status */

/* Bit definition for Ethernet MTL Interrupt Status Register */
#define ETH_MTLISR_MACIS_Pos                          (16U)
#define ETH_MTLISR_MACIS_Msk                          (0x1UL << ETH_MTLISR_MACIS_Pos) /*!< 0x00010000 */
#define ETH_MTLISR_MACIS                              ETH_MTLISR_MACIS_Msk     /* MAC Interrupt Status */
#define ETH_MTLISR_QIS_Pos                            (0U)
#define ETH_MTLISR_QIS_Msk                            (0x1UL << ETH_MTLISR_QIS_Pos) /*!< 0x00000001 */
#define ETH_MTLISR_QIS                                ETH_MTLISR_QIS_Msk       /* Queue Interrupt status */

/* Bit definition for Ethernet MTL Tx Queue Operation Mode Register */
#define ETH_MTLTQOMR_TTC_Pos                          (4U)
#define ETH_MTLTQOMR_TTC_Msk                          (0x7UL << ETH_MTLTQOMR_TTC_Pos) /*!< 0x00000070 */
#define ETH_MTLTQOMR_TTC                              ETH_MTLTQOMR_TTC_Msk     /* Transmit Threshold Control */
#define ETH_MTLTQOMR_TTC_32BITS                       ((uint32_t)0x00000000)   /* 32 bits Threshold */
#define ETH_MTLTQOMR_TTC_64BITS                       ((uint32_t)0x00000010)   /* 64  bits Threshold */
#define ETH_MTLTQOMR_TTC_96BITS                       ((uint32_t)0x00000020)   /* 96 bits Threshold */
#define ETH_MTLTQOMR_TTC_128BITS                      ((uint32_t)0x00000030)   /* 128 bits Threshold */
#define ETH_MTLTQOMR_TTC_192BITS                      ((uint32_t)0x00000040)   /* 192 bits Threshold */
#define ETH_MTLTQOMR_TTC_256BITS                      ((uint32_t)0x00000050)   /* 256 bits Threshold */
#define ETH_MTLTQOMR_TTC_384BITS                      ((uint32_t)0x00000060)   /* 384 bits Threshold */
#define ETH_MTLTQOMR_TTC_512BITS                      ((uint32_t)0x00000070)   /* 512 bits Threshold */
#define ETH_MTLTQOMR_TSF_Pos                          (1U)
#define ETH_MTLTQOMR_TSF_Msk                          (0x1UL << ETH_MTLTQOMR_TSF_Pos) /*!< 0x00000002 */
#define ETH_MTLTQOMR_TSF                              ETH_MTLTQOMR_TSF_Msk     /* Transmit Store and Forward */
#define ETH_MTLTQOMR_FTQ_Pos                          (0U)
#define ETH_MTLTQOMR_FTQ_Msk                          (0x1UL << ETH_MTLTQOMR_FTQ_Pos) /*!< 0x00000001 */
#define ETH_MTLTQOMR_FTQ                              ETH_MTLTQOMR_FTQ_Msk     /* Flush Transmit Queue */

/* Bit definition for Ethernet MTL Tx Queue Underflow Register */
#define ETH_MTLTQUR_UFCNTOVF_Pos                      (11U)
#define ETH_MTLTQUR_UFCNTOVF_Msk                      (0x1UL << ETH_MTLTQUR_UFCNTOVF_Pos) /*!< 0x00000800 */
#define ETH_MTLTQUR_UFCNTOVF                          ETH_MTLTQUR_UFCNTOVF_Msk /* Overflow Bit for Underflow Packet Counter */
#define ETH_MTLTQUR_UFPKTCNT_Pos                      (0U)
#define ETH_MTLTQUR_UFPKTCNT_Msk                      (0x7FFUL << ETH_MTLTQUR_UFPKTCNT_Pos) /*!< 0x000007FF */
#define ETH_MTLTQUR_UFPKTCNT                          ETH_MTLTQUR_UFPKTCNT_Msk /* Underflow Packet Counter */

/* Bit definition for Ethernet MTL Tx Queue Debug Register */
#define ETH_MTLTQDR_STXSTSF_Pos                       (20U)
#define ETH_MTLTQDR_STXSTSF_Msk                       (0x7UL << ETH_MTLTQDR_STXSTSF_Pos) /*!< 0x00700000 */
#define ETH_MTLTQDR_STXSTSF                           ETH_MTLTQDR_STXSTSF_Msk  /* Number of Status Words in the Tx Status FIFO of Queue */
#define ETH_MTLTQDR_PTXQ_Pos                          (16U)
#define ETH_MTLTQDR_PTXQ_Msk                          (0x7UL << ETH_MTLTQDR_PTXQ_Pos) /*!< 0x00070000 */
#define ETH_MTLTQDR_PTXQ                              ETH_MTLTQDR_PTXQ_Msk     /* Number of Packets in the Transmit Queue */
#define ETH_MTLTQDR_TXSTSFSTS_Pos                     (5U)
#define ETH_MTLTQDR_TXSTSFSTS_Msk                     (0x1UL << ETH_MTLTQDR_TXSTSFSTS_Pos) /*!< 0x00000020 */
#define ETH_MTLTQDR_TXSTSFSTS                         ETH_MTLTQDR_TXSTSFSTS_Msk /* MTL Tx Status FIFO Full Status */
#define ETH_MTLTQDR_TXQSTS_Pos                        (4U)
#define ETH_MTLTQDR_TXQSTS_Msk                        (0x1UL << ETH_MTLTQDR_TXQSTS_Pos) /*!< 0x00000010 */
#define ETH_MTLTQDR_TXQSTS                            ETH_MTLTQDR_TXQSTS_Msk   /* MTL Tx Queue Not Empty Status */
#define ETH_MTLTQDR_TWCSTS_Pos                        (3U)
#define ETH_MTLTQDR_TWCSTS_Msk                        (0x1UL << ETH_MTLTQDR_TWCSTS_Pos) /*!< 0x00000008 */
#define ETH_MTLTQDR_TWCSTS                            ETH_MTLTQDR_TWCSTS_Msk   /* MTL Tx Queue Write Controller Status */
#define ETH_MTLTQDR_TRCSTS_Pos                        (1U)
#define ETH_MTLTQDR_TRCSTS_Msk                        (0x3UL << ETH_MTLTQDR_TRCSTS_Pos) /*!< 0x00000006 */
#define ETH_MTLTQDR_TRCSTS                            ETH_MTLTQDR_TRCSTS_Msk  /* MTL Tx Queue Read Controller Status */
#define ETH_MTLTQDR_TRCSTS_IDLE                       ((uint32_t)0x00000000)  /* Idle state */
#define ETH_MTLTQDR_TRCSTS_READ                       ((uint32_t)0x00000002)  /* Read state (transferring data to the MAC transmitter) */
#define ETH_MTLTQDR_TRCSTS_WAITING                    ((uint32_t)0x00000004)  /* Waiting for pending Tx Status from the MAC transmitter */
#define ETH_MTLTQDR_TRCSTS_FLUSHING                   ((uint32_t)0x00000006)  /* Flushing the Tx queue because of the Packet Abort request from the MAC */
#define ETH_MTLTQDR_TXQPAUSED_Pos                     (0U)
#define ETH_MTLTQDR_TXQPAUSED_Msk                     (0x1UL << ETH_MTLTQDR_TXQPAUSED_Pos) /*!< 0x00000001 */
#define ETH_MTLTQDR_TXQPAUSED                         ETH_MTLTQDR_TXQPAUSED_Msk /* Transmit Queue in Pause */

/* Bit definition for Ethernet MTL Queue Interrupt Control Status Register */
#define ETH_MTLQICSR_RXOIE_Pos                        (24U)
#define ETH_MTLQICSR_RXOIE_Msk                        (0x1UL << ETH_MTLQICSR_RXOIE_Pos) /*!< 0x01000000 */
#define ETH_MTLQICSR_RXOIE                            ETH_MTLQICSR_RXOIE_Msk   /* Receive Queue Overflow Interrupt Enable */
#define ETH_MTLQICSR_RXOVFIS_Pos                      (16U)
#define ETH_MTLQICSR_RXOVFIS_Msk                      (0x1UL << ETH_MTLQICSR_RXOVFIS_Pos) /*!< 0x00010000 */
#define ETH_MTLQICSR_RXOVFIS                          ETH_MTLQICSR_RXOVFIS_Msk /* Receive Queue Overflow Interrupt Status */
#define ETH_MTLQICSR_TXUIE_Pos                        (8U)
#define ETH_MTLQICSR_TXUIE_Msk                        (0x1UL << ETH_MTLQICSR_TXUIE_Pos) /*!< 0x00000100 */
#define ETH_MTLQICSR_TXUIE                            ETH_MTLQICSR_TXUIE_Msk   /* Transmit Queue Underflow Interrupt Enable */
#define ETH_MTLQICSR_TXUNFIS_Pos                      (0U)
#define ETH_MTLQICSR_TXUNFIS_Msk                      (0x1UL << ETH_MTLQICSR_TXUNFIS_Pos) /*!< 0x00000001 */
#define ETH_MTLQICSR_TXUNFIS                          ETH_MTLQICSR_TXUNFIS_Msk /* Transmit Queue Underflow Interrupt Status */

/* Bit definition for Ethernet MTL Rx Queue Operation Mode Register */
#define ETH_MTLRQOMR_RQS_Pos                          (20U)
#define ETH_MTLRQOMR_RQS_Msk                          (0x7UL << ETH_MTLRQOMR_RQS_Pos) /*!< 0x00700000 */
#define ETH_MTLRQOMR_RQS                              ETH_MTLRQOMR_RQS_Msk /* Receive Queue Size */
#define ETH_MTLRQOMR_RFD_Pos                          (14U)
#define ETH_MTLRQOMR_RFD_Msk                          (0x7UL << ETH_MTLRQOMR_RFD_Pos) /*!< 0x0001C000 */
#define ETH_MTLRQOMR_RFD                              ETH_MTLRQOMR_RFD_Msk /* Threshold for Deactivating Flow Control (in half-duplex and full-duplex modes) */
#define ETH_MTLRQOMR_RFA_Pos                          (8U)
#define ETH_MTLRQOMR_RFA_Msk                          (0x7UL << ETH_MTLRQOMR_RFA_Pos) /*!< 0x00000700 */
#define ETH_MTLRQOMR_RFA                              ETH_MTLRQOMR_RFA_Msk /* Threshold for Activating Flow Control (in half-duplex and full-duplex */
#define ETH_MTLRQOMR_EHFC_Pos                         (7U)
#define ETH_MTLRQOMR_EHFC_Msk                         (0x1UL << ETH_MTLRQOMR_EHFC_Pos) /*!< 0x00000080 */
#define ETH_MTLRQOMR_EHFC                             ETH_MTLRQOMR_EHFC_Msk /* DEnable Hardware Flow Control */
#define ETH_MTLRQOMR_DISTCPEF_Pos                     (6U)
#define ETH_MTLRQOMR_DISTCPEF_Msk                     (0x1UL << ETH_MTLRQOMR_DISTCPEF_Pos) /*!< 0x00000040 */
#define ETH_MTLRQOMR_DISTCPEF                         ETH_MTLRQOMR_DISTCPEF_Msk /* Disable Dropping of TCP/IP Checksum Error Packets */
#define ETH_MTLRQOMR_RSF_Pos                          (5U)
#define ETH_MTLRQOMR_RSF_Msk                          (0x1UL << ETH_MTLRQOMR_RSF_Pos) /*!< 0x00000020 */
#define ETH_MTLRQOMR_RSF                              ETH_MTLRQOMR_RSF_Msk     /* Receive Queue Store and Forward */
#define ETH_MTLRQOMR_FEP_Pos                          (4U)
#define ETH_MTLRQOMR_FEP_Msk                          (0x1UL << ETH_MTLRQOMR_FEP_Pos) /*!< 0x00000010 */
#define ETH_MTLRQOMR_FEP                              ETH_MTLRQOMR_FEP_Msk     /* Forward Error Packets */
#define ETH_MTLRQOMR_FUP_Pos                          (3U)
#define ETH_MTLRQOMR_FUP_Msk                          (0x1UL << ETH_MTLRQOMR_FUP_Pos) /*!< 0x00000008 */
#define ETH_MTLRQOMR_FUP                              ETH_MTLRQOMR_FUP_Msk     /* Forward Undersized Good Packets */
#define ETH_MTLRQOMR_RTC_Pos                          (0U)
#define ETH_MTLRQOMR_RTC_Msk                          (0x3UL << ETH_MTLRQOMR_RTC_Pos) /*!< 0x00000003 */
#define ETH_MTLRQOMR_RTC                              ETH_MTLRQOMR_RTC_Msk     /* Receive Queue Threshold Control */
#define ETH_MTLRQOMR_RTC_64BITS                       ((uint32_t)0x00000000)   /* 64 bits Threshold */
#define ETH_MTLRQOMR_RTC_32BITS                       ((uint32_t)0x00000001)   /* 32 bits Threshold */
#define ETH_MTLRQOMR_RTC_96BITS                       ((uint32_t)0x00000002)   /* 96 bits Threshold */
#define ETH_MTLRQOMR_RTC_128BITS                      ((uint32_t)0x00000003)   /* 128 bits Threshold */

/* Bit definition for Ethernet MTL Rx Queue Missed Packet Overflow Cnt Register */
#define ETH_MTLRQMPOCR_MISCNTOVF_Pos                  (27U)
#define ETH_MTLRQMPOCR_MISCNTOVF_Msk                  (0x1UL << ETH_MTLRQMPOCR_MISCNTOVF_Pos) /*!< 0x08000000 */
#define ETH_MTLRQMPOCR_MISCNTOVF                      ETH_MTLRQMPOCR_MISCNTOVF_Msk /* Missed Packet Counter Overflow Bit */
#define ETH_MTLRQMPOCR_MISPKTCNT_Pos                  (16U)
#define ETH_MTLRQMPOCR_MISPKTCNT_Msk                  (0x7FFUL << ETH_MTLRQMPOCR_MISPKTCNT_Pos) /*!< 0x07FF0000 */
#define ETH_MTLRQMPOCR_MISPKTCNT                      ETH_MTLRQMPOCR_MISPKTCNT_Msk /* Missed Packet Counter */
#define ETH_MTLRQMPOCR_OVFCNTOVF_Pos                  (11U)
#define ETH_MTLRQMPOCR_OVFCNTOVF_Msk                  (0x1UL << ETH_MTLRQMPOCR_OVFCNTOVF_Pos) /*!< 0x00000800 */
#define ETH_MTLRQMPOCR_OVFCNTOVF                      ETH_MTLRQMPOCR_OVFCNTOVF_Msk /* Overflow Counter Overflow Bit */
#define ETH_MTLRQMPOCR_OVFPKTCNT_Pos                  (0U)
#define ETH_MTLRQMPOCR_OVFPKTCNT_Msk                  (0x7FFUL << ETH_MTLRQMPOCR_OVFPKTCNT_Pos) /*!< 0x000007FF */
#define ETH_MTLRQMPOCR_OVFPKTCNT                      ETH_MTLRQMPOCR_OVFPKTCNT_Msk /* Overflow Packet Counter */

/* Bit definition for Ethernet MTL Rx Queue Debug Register */
#define ETH_MTLRQDR_PRXQ_Pos                          (16U)
#define ETH_MTLRQDR_PRXQ_Msk                          (0x3FFFUL << ETH_MTLRQDR_PRXQ_Pos) /*!< 0x3FFF0000 */
#define ETH_MTLRQDR_PRXQ                              ETH_MTLRQDR_PRXQ_Msk     /* Number of Packets in Receive Queue */
#define ETH_MTLRQDR_RXQSTS_Pos                        (4U)
#define ETH_MTLRQDR_RXQSTS_Msk                        (0x3UL << ETH_MTLRQDR_RXQSTS_Pos) /*!< 0x00000030 */
#define ETH_MTLRQDR_RXQSTS                            ETH_MTLRQDR_RXQSTS_Msk   /* MTL Rx Queue Fill-Level Status */
#define ETH_MTLRQDR_RXQSTS_EMPTY                      ((uint32_t)0x00000000)   /* Rx Queue empty */
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Pos         (4U)
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Msk         (0x1UL << ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Pos) /*!< 0x00000010 */
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD             ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Msk /* Rx Queue fill-level below flow-control deactivate threshold */
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Pos         (5U)
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Msk         (0x1UL << ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Pos) /*!< 0x00000020 */
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD             ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Msk /* Rx Queue fill-level above flow-control activate threshold */
#define ETH_MTLRQDR_RXQSTS_FULL_Pos                   (4U)
#define ETH_MTLRQDR_RXQSTS_FULL_Msk                   (0x3UL << ETH_MTLRQDR_RXQSTS_FULL_Pos) /*!< 0x00000030 */
#define ETH_MTLRQDR_RXQSTS_FULL                       ETH_MTLRQDR_RXQSTS_FULL_Msk /* Rx Queue full */
#define ETH_MTLRQDR_RRCSTS_Pos                        (1U)
#define ETH_MTLRQDR_RRCSTS_Msk                        (0x3UL << ETH_MTLRQDR_RRCSTS_Pos) /*!< 0x00000006 */
#define ETH_MTLRQDR_RRCSTS                            ETH_MTLRQDR_RRCSTS_Msk   /* MTL Rx Queue Read Controller State */
#define ETH_MTLRQDR_RRCSTS_IDLE                       ((uint32_t)0x00000000)   /* Idle state */
#define ETH_MTLRQDR_RRCSTS_READINGDATA_Pos            (1U)
#define ETH_MTLRQDR_RRCSTS_READINGDATA_Msk            (0x1UL << ETH_MTLRQDR_RRCSTS_READINGDATA_Pos) /*!< 0x00000002 */
#define ETH_MTLRQDR_RRCSTS_READINGDATA                ETH_MTLRQDR_RRCSTS_READINGDATA_Msk /* Reading packet data */
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS_Pos          (2U)
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS_Msk          (0x1UL << ETH_MTLRQDR_RRCSTS_READINGSTATUS_Pos) /*!< 0x00000004 */
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS              ETH_MTLRQDR_RRCSTS_READINGSTATUS_Msk /* Reading packet status (or timestamp) */
#define ETH_MTLRQDR_RRCSTS_FLUSHING_Pos               (1U)
#define ETH_MTLRQDR_RRCSTS_FLUSHING_Msk               (0x3UL << ETH_MTLRQDR_RRCSTS_FLUSHING_Pos) /*!< 0x00000006 */
#define ETH_MTLRQDR_RRCSTS_FLUSHING                   ETH_MTLRQDR_RRCSTS_FLUSHING_Msk /* Flushing the packet data and status */
#define ETH_MTLRQDR_RWCSTS_Pos                        (0U)
#define ETH_MTLRQDR_RWCSTS_Msk                        (0x1UL << ETH_MTLRQDR_RWCSTS_Pos) /*!< 0x00000001 */
#define ETH_MTLRQDR_RWCSTS                            ETH_MTLRQDR_RWCSTS_Msk   /* MTL Rx Queue Write Controller Active Status */

/* Bit definition for Ethernet MTL Rx Queue Control Register */
#define ETH_MTLRQCR_RQPA_Pos                          (3U)
#define ETH_MTLRQCR_RQPA_Msk                          (0x1UL << ETH_MTLRQCR_RQPA_Pos) /*!< 0x00000008 */
#define ETH_MTLRQCR_RQPA                              ETH_MTLRQCR_RQPA_Msk     /* Receive Queue Packet Arbitration */
#define ETH_MTLRQCR_RQW_Pos                           (0U)
#define ETH_MTLRQCR_RQW_Msk                           (0x7UL << ETH_MTLRQCR_RQW_Pos) /*!< 0x00000007 */
#define ETH_MTLRQCR_RQW                               ETH_MTLRQCR_RQW_Msk      /* Receive Queue Weight */

/* Bit definition for Ethernet DMA Mode Register */
#define ETH_DMAMR_INTM_Pos                            (16U)
#define ETH_DMAMR_INTM_Msk                            (0x3UL << ETH_DMAMR_INTM_Pos) /*!< 0x00030000 */
#define ETH_DMAMR_INTM                                ETH_DMAMR_INTM_Msk       /* This field defines the interrupt mode */
#define ETH_DMAMR_INTM_0                              (0x0UL << ETH_DMAMR_INTM_Pos) /*!< 0x00000000 */
#define ETH_DMAMR_INTM_1                              (0x1UL << ETH_DMAMR_INTM_Pos) /*!< 0x00010000 */
#define ETH_DMAMR_INTM_2                              (0x2UL << ETH_DMAMR_INTM_Pos) /*!< 0x00020000 */
#define ETH_DMAMR_PR_Pos                              (12U)
#define ETH_DMAMR_PR_Msk                              (0x7UL << ETH_DMAMR_PR_Pos) /*!< 0x00007000 */
#define ETH_DMAMR_PR                                  ETH_DMAMR_PR_Msk         /* Priority Ratio */
#define ETH_DMAMR_PR_1_1                              ((uint32_t)0x00000000)   /* The priority ratio is 1:1 */
#define ETH_DMAMR_PR_2_1                              ((uint32_t)0x00001000)   /* The priority ratio is 2:1 */
#define ETH_DMAMR_PR_3_1                              ((uint32_t)0x00002000)   /* The priority ratio is 3:1 */
#define ETH_DMAMR_PR_4_1                              ((uint32_t)0x00003000)   /* The priority ratio is 4:1 */
#define ETH_DMAMR_PR_5_1                              ((uint32_t)0x00004000)   /* The priority ratio is 5:1 */
#define ETH_DMAMR_PR_6_1                              ((uint32_t)0x00005000)   /* The priority ratio is 6:1 */
#define ETH_DMAMR_PR_7_1                              ((uint32_t)0x00006000)   /* The priority ratio is 7:1 */
#define ETH_DMAMR_PR_8_1                              ((uint32_t)0x00007000)   /* The priority ratio is 8:1 */
#define ETH_DMAMR_TXPR_Pos                            (11U)
#define ETH_DMAMR_TXPR_Msk                            (0x1UL << ETH_DMAMR_TXPR_Pos) /*!< 0x00000800 */
#define ETH_DMAMR_TXPR                                ETH_DMAMR_TXPR_Msk       /* Transmit Priority */
#define ETH_DMAMR_DA_Pos                              (1U)
#define ETH_DMAMR_DA_Msk                              (0x1UL << ETH_DMAMR_DA_Pos) /*!< 0x00000002 */
#define ETH_DMAMR_DA                                  ETH_DMAMR_DA_Msk         /* DMA Tx or Rx Arbitration Scheme */
#define ETH_DMAMR_SWR_Pos                             (0U)
#define ETH_DMAMR_SWR_Msk                             (0x1UL << ETH_DMAMR_SWR_Pos) /*!< 0x00000001 */
#define ETH_DMAMR_SWR                                 ETH_DMAMR_SWR_Msk        /* Software Reset */

/* Bit definition for Ethernet DMA SysBus Mode Register */
#define ETH_DMASBMR_RB_Pos                            (15U)
#define ETH_DMASBMR_RB_Msk                            (0x1UL << ETH_DMASBMR_RB_Pos) /*!< 0x00008000 */
#define ETH_DMASBMR_RB                                ETH_DMASBMR_RB_Msk       /* Rebuild INCRx Burst */
#define ETH_DMASBMR_MB_Pos                            (14U)
#define ETH_DMASBMR_MB_Msk                            (0x1UL << ETH_DMASBMR_MB_Pos) /*!< 0x00004000 */
#define ETH_DMASBMR_MB                                ETH_DMASBMR_MB_Msk       /* Mixed Burst */
#define ETH_DMASBMR_AAL_Pos                           (12U)
#define ETH_DMASBMR_AAL_Msk                           (0x1UL << ETH_DMASBMR_AAL_Pos) /*!< 0x00001000 */
#define ETH_DMASBMR_AAL                               ETH_DMASBMR_AAL_Msk      /* Address-Aligned Beats */
#define ETH_DMASBMR_FB_Pos                            (0U)
#define ETH_DMASBMR_FB_Msk                            (0x1UL << ETH_DMASBMR_FB_Pos) /*!< 0x00000001 */
#define ETH_DMASBMR_FB                                ETH_DMASBMR_FB_Msk       /* Fixed Burst Length */

/* Bit definition for Ethernet DMA Interrupt Status Register */
#define ETH_DMAISR_MACIS_Pos                          (17U)
#define ETH_DMAISR_MACIS_Msk                          (0x1UL << ETH_DMAISR_MACIS_Pos) /*!< 0x00020000 */
#define ETH_DMAISR_MACIS                              ETH_DMAISR_MACIS_Msk     /* MAC Interrupt Status */
#define ETH_DMAISR_MTLIS_Pos                          (16U)
#define ETH_DMAISR_MTLIS_Msk                          (0x1UL << ETH_DMAISR_MTLIS_Pos) /*!< 0x00010000 */
#define ETH_DMAISR_MTLIS                              ETH_DMAISR_MTLIS_Msk     /* MAC Interrupt Status */
#define ETH_DMAISR_DMACIS_Pos                         (0U)
#define ETH_DMAISR_DMACIS_Msk                         (0x1UL << ETH_DMAISR_DMACIS_Pos) /*!< 0x00000001 */
#define ETH_DMAISR_DMACIS                             ETH_DMAISR_DMACIS_Msk    /* DMA Channel Interrupt Status */

/* Bit definition for Ethernet DMA Debug Status Register */
#define ETH_DMADSR_TPS_Pos                            (12U)
#define ETH_DMADSR_TPS_Msk                            (0xFUL << ETH_DMADSR_TPS_Pos) /*!< 0x0000F000 */
#define ETH_DMADSR_TPS                                ETH_DMADSR_TPS_Msk       /* DMA Channel Transmit Process State */
#define ETH_DMADSR_TPS_STOPPED                        ((uint32_t)0x00000000)   /* Stopped (Reset or Stop Transmit Command issued) */
#define ETH_DMADSR_TPS_FETCHING_Pos                   (12U)
#define ETH_DMADSR_TPS_FETCHING_Msk                   (0x1UL << ETH_DMADSR_TPS_FETCHING_Pos) /*!< 0x00001000 */
#define ETH_DMADSR_TPS_FETCHING                       ETH_DMADSR_TPS_FETCHING_Msk /* Running (Fetching Tx Transfer Descriptor) */
#define ETH_DMADSR_TPS_WAITING_Pos                    (13U)
#define ETH_DMADSR_TPS_WAITING_Msk                    (0x1UL << ETH_DMADSR_TPS_WAITING_Pos) /*!< 0x00002000 */
#define ETH_DMADSR_TPS_WAITING                        ETH_DMADSR_TPS_WAITING_Msk /* Running (Waiting for status) */
#define ETH_DMADSR_TPS_READING_Pos                    (12U)
#define ETH_DMADSR_TPS_READING_Msk                    (0x3UL << ETH_DMADSR_TPS_READING_Pos) /*!< 0x00003000 */
#define ETH_DMADSR_TPS_READING                        ETH_DMADSR_TPS_READING_Msk /* Running (Reading Data from system memory buffer and queuing it to the Tx buffer (Tx FIFO)) */
#define ETH_DMADSR_TPS_TIMESTAMP_WR_Pos               (14U)
#define ETH_DMADSR_TPS_TIMESTAMP_WR_Msk               (0x1UL << ETH_DMADSR_TPS_TIMESTAMP_WR_Pos) /*!< 0x00004000 */
#define ETH_DMADSR_TPS_TIMESTAMP_WR                   ETH_DMADSR_TPS_TIMESTAMP_WR_Msk /* Timestamp write state */
#define ETH_DMADSR_TPS_SUSPENDED_Pos                  (13U)
#define ETH_DMADSR_TPS_SUSPENDED_Msk                  (0x3UL << ETH_DMADSR_TPS_SUSPENDED_Pos) /*!< 0x00006000 */
#define ETH_DMADSR_TPS_SUSPENDED                      ETH_DMADSR_TPS_SUSPENDED_Msk /* Suspended (Tx Descriptor Unavailable or Tx Buffer Underflow) */
#define ETH_DMADSR_TPS_CLOSING_Pos                    (12U)
#define ETH_DMADSR_TPS_CLOSING_Msk                    (0x7UL << ETH_DMADSR_TPS_CLOSING_Pos) /*!< 0x00007000 */
#define ETH_DMADSR_TPS_CLOSING                        ETH_DMADSR_TPS_CLOSING_Msk /* Running (Closing Tx Descriptor) */
#define ETH_DMADSR_RPS_Pos                            (8U)
#define ETH_DMADSR_RPS_Msk                            (0xFUL << ETH_DMADSR_RPS_Pos) /*!< 0x00000F00 */
#define ETH_DMADSR_RPS                                ETH_DMADSR_RPS_Msk       /* DMA Channel Receive Process State */
#define ETH_DMADSR_RPS_STOPPED                        ((uint32_t)0x00000000)   /* Stopped (Reset or Stop Receive Command issued) */
#define ETH_DMADSR_RPS_FETCHING_Pos                   (12U)
#define ETH_DMADSR_RPS_FETCHING_Msk                   (0x1UL << ETH_DMADSR_RPS_FETCHING_Pos) /*!< 0x00001000 */
#define ETH_DMADSR_RPS_FETCHING                       ETH_DMADSR_RPS_FETCHING_Msk /* Running (Fetching Rx Transfer Descriptor) */
#define ETH_DMADSR_RPS_WAITING_Pos                    (12U)
#define ETH_DMADSR_RPS_WAITING_Msk                    (0x3UL << ETH_DMADSR_RPS_WAITING_Pos) /*!< 0x00003000 */
#define ETH_DMADSR_RPS_WAITING                        ETH_DMADSR_RPS_WAITING_Msk /* Running (Waiting for status) */
#define ETH_DMADSR_RPS_SUSPENDED_Pos                  (14U)
#define ETH_DMADSR_RPS_SUSPENDED_Msk                  (0x1UL << ETH_DMADSR_RPS_SUSPENDED_Pos) /*!< 0x00004000 */
#define ETH_DMADSR_RPS_SUSPENDED                      ETH_DMADSR_RPS_SUSPENDED_Msk /* Suspended (Rx Descriptor Unavailable) */
#define ETH_DMADSR_RPS_CLOSING_Pos                    (12U)
#define ETH_DMADSR_RPS_CLOSING_Msk                    (0x5UL << ETH_DMADSR_RPS_CLOSING_Pos) /*!< 0x00005000 */
#define ETH_DMADSR_RPS_CLOSING                        ETH_DMADSR_RPS_CLOSING_Msk /* Running (Closing the Rx Descriptor) */
#define ETH_DMADSR_RPS_TIMESTAMP_WR_Pos               (13U)
#define ETH_DMADSR_RPS_TIMESTAMP_WR_Msk               (0x3UL << ETH_DMADSR_RPS_TIMESTAMP_WR_Pos) /*!< 0x00006000 */
#define ETH_DMADSR_RPS_TIMESTAMP_WR                   ETH_DMADSR_RPS_TIMESTAMP_WR_Msk /* Timestamp write state */
#define ETH_DMADSR_RPS_TRANSFERRING_Pos               (12U)
#define ETH_DMADSR_RPS_TRANSFERRING_Msk               (0x7UL << ETH_DMADSR_RPS_TRANSFERRING_Pos) /*!< 0x00007000 */
#define ETH_DMADSR_RPS_TRANSFERRING                   ETH_DMADSR_RPS_TRANSFERRING_Msk /* Running (Transferring the received packet data from the Rx buffer to the system memory) */

/* Bit definition for Ethernet DMA Channel Control Register */
#define ETH_DMACCR_DSL_Pos                            (18U)
#define ETH_DMACCR_DSL_Msk                            (0x7UL << ETH_DMACCR_DSL_Pos) /*!< 0x001C0000 */
#define ETH_DMACCR_DSL                                ETH_DMACCR_DSL_Msk       /* Descriptor Skip Length */
#define ETH_DMACCR_DSL_0BIT                           ((uint32_t)0x00000000)
#define ETH_DMACCR_DSL_32BIT                          ((uint32_t)0x00040000)
#define ETH_DMACCR_DSL_64BIT                          ((uint32_t)0x00080000)
#define ETH_DMACCR_DSL_128BIT                         ((uint32_t)0x00100000)
#define ETH_DMACCR_8PBL                               ((uint32_t)0x00010000)   /* 8xPBL mode */
#define ETH_DMACCR_MSS_Pos                            (0U)
#define ETH_DMACCR_MSS_Msk                            (0x3FFFUL << ETH_DMACCR_MSS_Pos) /*!< 0x00003FFF */
#define ETH_DMACCR_MSS                                ETH_DMACCR_MSS_Msk       /* Maximum Segment Size */

/* Bit definition for Ethernet DMA Channel Tx Control Register */
#define ETH_DMACTCR_TPBL_Pos                          (16U)
#define ETH_DMACTCR_TPBL_Msk                          (0x3FUL << ETH_DMACTCR_TPBL_Pos) /*!< 0x003F0000 */
#define ETH_DMACTCR_TPBL                              ETH_DMACTCR_TPBL_Msk     /* Transmit Programmable Burst Length */
#define ETH_DMACTCR_TPBL_1PBL                         ((uint32_t)0x00010000)   /* Transmit Programmable Burst Length 1 */
#define ETH_DMACTCR_TPBL_2PBL                         ((uint32_t)0x00020000)   /* Transmit Programmable Burst Length 2 */
#define ETH_DMACTCR_TPBL_4PBL                         ((uint32_t)0x00040000)   /* Transmit Programmable Burst Length 4 */
#define ETH_DMACTCR_TPBL_8PBL                         ((uint32_t)0x00080000)   /* Transmit Programmable Burst Length 8 */
#define ETH_DMACTCR_TPBL_16PBL                        ((uint32_t)0x00100000)   /* Transmit Programmable Burst Length 16 */
#define ETH_DMACTCR_TPBL_32PBL                        ((uint32_t)0x00200000)   /* Transmit Programmable Burst Length 32 */
#define ETH_DMACTCR_TSE_Pos                           (12U)
#define ETH_DMACTCR_TSE_Msk                           (0x1UL << ETH_DMACTCR_TSE_Pos) /*!< 0x00001000 */
#define ETH_DMACTCR_TSE                               ETH_DMACTCR_TSE_Msk      /* TCP Segmentation Enabled */
#define ETH_DMACTCR_OSP_Pos                           (4U)
#define ETH_DMACTCR_OSP_Msk                           (0x1UL << ETH_DMACTCR_OSP_Pos) /*!< 0x00000010 */
#define ETH_DMACTCR_OSP                               ETH_DMACTCR_OSP_Msk      /* Operate on Second Packet */
#define ETH_DMACTCR_ST_Pos                            (0U)
#define ETH_DMACTCR_ST_Msk                            (0x1UL << ETH_DMACTCR_ST_Pos) /*!< 0x00000001 */
#define ETH_DMACTCR_ST                                ETH_DMACTCR_ST_Msk       /* Start or Stop Transmission Command */

/* Bit definition for Ethernet DMA Channel Rx Control Register */
#define ETH_DMACRCR_RPF_Pos                           (31U)
#define ETH_DMACRCR_RPF_Msk                           (0x1UL << ETH_DMACRCR_RPF_Pos) /*!< 0x80000000 */
#define ETH_DMACRCR_RPF                               ETH_DMACRCR_RPF_Msk      /* Rx Packet Flush */
#define ETH_DMACRCR_RPBL_Pos                          (16U)
#define ETH_DMACRCR_RPBL_Msk                          (0x3FUL << ETH_DMACRCR_RPBL_Pos) /*!< 0x003F0000 */
#define ETH_DMACRCR_RPBL                              ETH_DMACRCR_RPBL_Msk     /* Receive Programmable Burst Length */
#define ETH_DMACRCR_RPBL_1PBL                         ((uint32_t)0x00010000)   /* Receive Programmable Burst Length 1 */
#define ETH_DMACRCR_RPBL_2PBL                         ((uint32_t)0x00020000)   /* Receive Programmable Burst Length 2 */
#define ETH_DMACRCR_RPBL_4PBL                         ((uint32_t)0x00040000)   /* Receive Programmable Burst Length 4 */
#define ETH_DMACRCR_RPBL_8PBL                         ((uint32_t)0x00080000)   /* Receive Programmable Burst Length 8 */
#define ETH_DMACRCR_RPBL_16PBL                        ((uint32_t)0x00100000)   /* Receive Programmable Burst Length 16 */
#define ETH_DMACRCR_RPBL_32PBL                        ((uint32_t)0x00200000)   /* Receive Programmable Burst Length 32 */
#define ETH_DMACRCR_RBSZ_Pos                          (1U)
#define ETH_DMACRCR_RBSZ_Msk                          (0x3FFFUL << ETH_DMACRCR_RBSZ_Pos) /*!< 0x00007FFE */
#define ETH_DMACRCR_RBSZ                              ETH_DMACRCR_RBSZ_Msk     /* Receive Buffer size */
#define ETH_DMACRCR_SR_Pos                            (0U)
#define ETH_DMACRCR_SR_Msk                            (0x1UL << ETH_DMACRCR_SR_Pos) /*!< 0x00000001 */
#define ETH_DMACRCR_SR                                ETH_DMACRCR_SR_Msk       /* Start or Stop Receive */

/* Bit definition for Ethernet DMA CH Tx Desc List Address Register */
#define ETH_DMACTDLAR_TDESLA_Pos                      (2U)
#define ETH_DMACTDLAR_TDESLA_Msk                      (0x3FFFFFFFUL << ETH_DMACTDLAR_TDESLA_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACTDLAR_TDESLA                          ETH_DMACTDLAR_TDESLA_Msk /* Start of Transmit List */

/* Bit definition for Ethernet DMA CH Rx Desc List Address Register */
#define ETH_DMACRDLAR_RDESLA_Pos                      (2U)
#define ETH_DMACRDLAR_RDESLA_Msk                      (0x3FFFFFFFUL << ETH_DMACRDLAR_RDESLA_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACRDLAR_RDESLA                          ETH_DMACRDLAR_RDESLA_Msk /* Start of Receive List */

/* Bit definition for Ethernet DMA CH Tx Desc Tail Pointer Register */
#define ETH_DMACTDTPR_TDT_Pos                         (2U)
#define ETH_DMACTDTPR_TDT_Msk                         (0x3FFFFFFFUL << ETH_DMACTDTPR_TDT_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACTDTPR_TDT                             ETH_DMACTDTPR_TDT_Msk    /* Transmit Descriptor Tail Pointer */

/* Bit definition for Ethernet DMA CH Rx Desc Tail Pointer Register */
#define ETH_DMACRDTPR_RDT_Pos                         (2U)
#define ETH_DMACRDTPR_RDT_Msk                         (0x3FFFFFFFUL << ETH_DMACRDTPR_RDT_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACRDTPR_RDT                             ETH_DMACRDTPR_RDT_Msk    /* Receive Descriptor Tail Pointer */

/* Bit definition for Ethernet DMA CH Tx Desc Ring Length Register */
#define ETH_DMACTDRLR_TDRL_Pos                        (0U)
#define ETH_DMACTDRLR_TDRL_Msk                        (0x3FFUL << ETH_DMACTDRLR_TDRL_Pos) /*!< 0x000003FF */
#define ETH_DMACTDRLR_TDRL                            ETH_DMACTDRLR_TDRL_Msk   /* Transmit Descriptor Ring Length */

/* Bit definition for Ethernet DMA CH Rx Desc Ring Length Register */
#define ETH_DMACRDRLR_RDRL_Pos                        (0U)
#define ETH_DMACRDRLR_RDRL_Msk                        (0x3FFUL << ETH_DMACRDRLR_RDRL_Pos) /*!< 0x000003FF */
#define ETH_DMACRDRLR_RDRL                            ETH_DMACRDRLR_RDRL_Msk   /* Receive Descriptor Ring Length */

/* Bit definition for Ethernet DMA Channel Interrupt Enable Register */
#define ETH_DMACIER_NIE_Pos                           (15U)
#define ETH_DMACIER_NIE_Msk                           (0x1UL << ETH_DMACIER_NIE_Pos) /*!< 0x00008000 */
#define ETH_DMACIER_NIE                               ETH_DMACIER_NIE_Msk      /* Normal Interrupt Summary Enable */
#define ETH_DMACIER_AIE_Pos                           (14U)
#define ETH_DMACIER_AIE_Msk                           (0x1UL << ETH_DMACIER_AIE_Pos) /*!< 0x00004000 */
#define ETH_DMACIER_AIE                               ETH_DMACIER_AIE_Msk      /* Abnormal Interrupt Summary Enable */
#define ETH_DMACIER_CDEE_Pos                          (13U)
#define ETH_DMACIER_CDEE_Msk                          (0x1UL << ETH_DMACIER_CDEE_Pos) /*!< 0x00002000 */
#define ETH_DMACIER_CDEE                              ETH_DMACIER_CDEE_Msk     /* Context Descriptor Error Enable */
#define ETH_DMACIER_FBEE_Pos                          (12U)
#define ETH_DMACIER_FBEE_Msk                          (0x1UL << ETH_DMACIER_FBEE_Pos) /*!< 0x00001000 */
#define ETH_DMACIER_FBEE                              ETH_DMACIER_FBEE_Msk     /* Fatal Bus Error Enable */
#define ETH_DMACIER_ERIE_Pos                          (11U)
#define ETH_DMACIER_ERIE_Msk                          (0x1UL << ETH_DMACIER_ERIE_Pos) /*!< 0x00000800 */
#define ETH_DMACIER_ERIE                              ETH_DMACIER_ERIE_Msk     /* Early Receive Interrupt Enable */
#define ETH_DMACIER_ETIE_Pos                          (10U)
#define ETH_DMACIER_ETIE_Msk                          (0x1UL << ETH_DMACIER_ETIE_Pos) /*!< 0x00000400 */
#define ETH_DMACIER_ETIE                              ETH_DMACIER_ETIE_Msk     /* Early Transmit Interrupt Enable */
#define ETH_DMACIER_RWTE_Pos                          (9U)
#define ETH_DMACIER_RWTE_Msk                          (0x1UL << ETH_DMACIER_RWTE_Pos) /*!< 0x00000200 */
#define ETH_DMACIER_RWTE                              ETH_DMACIER_RWTE_Msk     /* Receive Watchdog Timeout Enable */
#define ETH_DMACIER_RSE_Pos                           (8U)
#define ETH_DMACIER_RSE_Msk                           (0x1UL << ETH_DMACIER_RSE_Pos) /*!< 0x00000100 */
#define ETH_DMACIER_RSE                               ETH_DMACIER_RSE_Msk      /* Receive Stopped Enable */
#define ETH_DMACIER_RBUE_Pos                          (7U)
#define ETH_DMACIER_RBUE_Msk                          (0x1UL << ETH_DMACIER_RBUE_Pos) /*!< 0x00000080 */
#define ETH_DMACIER_RBUE                              ETH_DMACIER_RBUE_Msk     /* Receive Buffer Unavailable Enable */
#define ETH_DMACIER_RIE_Pos                           (6U)
#define ETH_DMACIER_RIE_Msk                           (0x1UL << ETH_DMACIER_RIE_Pos) /*!< 0x00000040 */
#define ETH_DMACIER_RIE                               ETH_DMACIER_RIE_Msk      /* Receive Interrupt Enable */
#define ETH_DMACIER_TBUE_Pos                          (2U)
#define ETH_DMACIER_TBUE_Msk                          (0x1UL << ETH_DMACIER_TBUE_Pos) /*!< 0x00000004 */
#define ETH_DMACIER_TBUE                              ETH_DMACIER_TBUE_Msk     /* Transmit Buffer Unavailable Enable */
#define ETH_DMACIER_TXSE_Pos                          (1U)
#define ETH_DMACIER_TXSE_Msk                          (0x1UL << ETH_DMACIER_TXSE_Pos) /*!< 0x00000002 */
#define ETH_DMACIER_TXSE                              ETH_DMACIER_TXSE_Msk     /* Transmit Stopped Enable */
#define ETH_DMACIER_TIE_Pos                           (0U)
#define ETH_DMACIER_TIE_Msk                           (0x1UL << ETH_DMACIER_TIE_Pos) /*!< 0x00000001 */
#define ETH_DMACIER_TIE                               ETH_DMACIER_TIE_Msk      /* Transmit Interrupt Enable */

/* Bit definition for Ethernet DMA Channel Rx Interrupt Watchdog Timer Register */
#define ETH_DMACRIWTR_RWT_Pos                         (0U)
#define ETH_DMACRIWTR_RWT_Msk                         (0xFFUL << ETH_DMACRIWTR_RWT_Pos) /*!< 0x000000FF */
#define ETH_DMACRIWTR_RWT                             ETH_DMACRIWTR_RWT_Msk    /* Receive Interrupt Watchdog Timer Count */

/* Bit definition for Ethernet DMA Channel Current App Tx Desc Register */
#define ETH_DMACCATDR_CURTDESAPTR_Pos                 (0U)
#define ETH_DMACCATDR_CURTDESAPTR_Msk                 (0xFFFFFFFFUL << ETH_DMACCATDR_CURTDESAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCATDR_CURTDESAPTR                     ETH_DMACCATDR_CURTDESAPTR_Msk /* Application Transmit Descriptor Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Rx Desc Register */
#define ETH_DMACCARDR_CURRDESAPTR_Pos                 (0U)
#define ETH_DMACCARDR_CURRDESAPTR_Msk                 (0xFFFFFFFFUL << ETH_DMACCARDR_CURRDESAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCARDR_CURRDESAPTR                     ETH_DMACCARDR_CURRDESAPTR_Msk /* Application Receive Descriptor Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Tx Buffer Register */
#define ETH_DMACCATBR_CURTBUFAPTR_Pos                 (0U)
#define ETH_DMACCATBR_CURTBUFAPTR_Msk                 (0xFFFFFFFFUL << ETH_DMACCATBR_CURTBUFAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCATBR_CURTBUFAPTR                     ETH_DMACCATBR_CURTBUFAPTR_Msk /* Application Transmit Buffer Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Rx Buffer Register */
#define ETH_DMACCARBR_CURRBUFAPTR_Pos                 (0U)
#define ETH_DMACCARBR_CURRBUFAPTR_Msk                 (0xFFFFFFFFUL << ETH_DMACCARBR_CURRBUFAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCARBR_CURRBUFAPTR                     ETH_DMACCARBR_CURRBUFAPTR_Msk /* Application Receive Buffer Address Pointer */

/* Bit definition for Ethernet DMA Channel Status Register */
#define ETH_DMACSR_REB_Pos                            (19U)
#define ETH_DMACSR_REB_Msk                            (0x7UL << ETH_DMACSR_REB_Pos) /*!< 0x00380000 */
#define ETH_DMACSR_REB                                ETH_DMACSR_REB_Msk       /* Rx DMA Error Bits */
#define ETH_DMACSR_TEB_Pos                            (16U)
#define ETH_DMACSR_TEB_Msk                            (0x7UL << ETH_DMACSR_TEB_Pos) /*!< 0x00070000 */
#define ETH_DMACSR_TEB                                ETH_DMACSR_TEB_Msk       /* Tx DMA Error Bits */
#define ETH_DMACSR_NIS_Pos                            (15U)
#define ETH_DMACSR_NIS_Msk                            (0x1UL << ETH_DMACSR_NIS_Pos) /*!< 0x00008000 */
#define ETH_DMACSR_NIS                                ETH_DMACSR_NIS_Msk       /* Normal Interrupt Summary */
#define ETH_DMACSR_AIS_Pos                            (14U)
#define ETH_DMACSR_AIS_Msk                            (0x1UL << ETH_DMACSR_AIS_Pos) /*!< 0x00004000 */
#define ETH_DMACSR_AIS                                ETH_DMACSR_AIS_Msk       /* Abnormal Interrupt Summary */
#define ETH_DMACSR_CDE_Pos                            (13U)
#define ETH_DMACSR_CDE_Msk                            (0x1UL << ETH_DMACSR_CDE_Pos) /*!< 0x00002000 */
#define ETH_DMACSR_CDE                                ETH_DMACSR_CDE_Msk       /* Context Descriptor Error */
#define ETH_DMACSR_FBE_Pos                            (12U)
#define ETH_DMACSR_FBE_Msk                            (0x1UL << ETH_DMACSR_FBE_Pos) /*!< 0x00001000 */
#define ETH_DMACSR_FBE                                ETH_DMACSR_FBE_Msk       /* Fatal Bus Error */
#define ETH_DMACSR_ERI_Pos                            (11U)
#define ETH_DMACSR_ERI_Msk                            (0x1UL << ETH_DMACSR_ERI_Pos) /*!< 0x00000800 */
#define ETH_DMACSR_ERI                                ETH_DMACSR_ERI_Msk       /* Early Receive Interrupt */
#define ETH_DMACSR_ETI_Pos                            (10U)
#define ETH_DMACSR_ETI_Msk                            (0x1UL << ETH_DMACSR_ETI_Pos) /*!< 0x00000400 */
#define ETH_DMACSR_ETI                                ETH_DMACSR_ETI_Msk       /* Early Transmit Interrupt */
#define ETH_DMACSR_RWT_Pos                            (9U)
#define ETH_DMACSR_RWT_Msk                            (0x1UL << ETH_DMACSR_RWT_Pos) /*!< 0x00000200 */
#define ETH_DMACSR_RWT                                ETH_DMACSR_RWT_Msk       /* Receive Watchdog Timeout */
#define ETH_DMACSR_RPS_Pos                            (8U)
#define ETH_DMACSR_RPS_Msk                            (0x1UL << ETH_DMACSR_RPS_Pos) /*!< 0x00000100 */
#define ETH_DMACSR_RPS                                ETH_DMACSR_RPS_Msk       /* Receive Process Stopped */
#define ETH_DMACSR_RBU_Pos                            (7U)
#define ETH_DMACSR_RBU_Msk                            (0x1UL << ETH_DMACSR_RBU_Pos) /*!< 0x00000080 */
#define ETH_DMACSR_RBU                                ETH_DMACSR_RBU_Msk       /* Receive Buffer Unavailable */
#define ETH_DMACSR_RI_Pos                             (6U)
#define ETH_DMACSR_RI_Msk                             (0x1UL << ETH_DMACSR_RI_Pos) /*!< 0x00000040 */
#define ETH_DMACSR_RI                                 ETH_DMACSR_RI_Msk        /* Receive Interrupt */
#define ETH_DMACSR_TBU_Pos                            (2U)
#define ETH_DMACSR_TBU_Msk                            (0x1UL << ETH_DMACSR_TBU_Pos) /*!< 0x00000004 */
#define ETH_DMACSR_TBU                                ETH_DMACSR_TBU_Msk       /* Transmit Buffer Unavailable */
#define ETH_DMACSR_TPS_Pos                            (1U)
#define ETH_DMACSR_TPS_Msk                            (0x1UL << ETH_DMACSR_TPS_Pos) /*!< 0x00000002 */
#define ETH_DMACSR_TPS                                ETH_DMACSR_TPS_Msk       /* Transmit Process Stopped */
#define ETH_DMACSR_TI_Pos                             (0U)
#define ETH_DMACSR_TI_Msk                             (0x1UL << ETH_DMACSR_TI_Pos) /*!< 0x00000001 */
#define ETH_DMACSR_TI                                 ETH_DMACSR_TI_Msk        /* Transmit Interrupt */

/* Bit definition for Ethernet DMA Channel missed frame count register */
#define ETH_DMACMFCR_MFCO_Pos                         (15U)
#define ETH_DMACMFCR_MFCO_Msk                         (0x1UL << ETH_DMACMFCR_MFCO_Pos) /*!< 0x00008000 */
#define ETH_DMACMFCR_MFCO                             ETH_DMACMFCR_MFCO_Msk    /* Overflow status of the MFC Counter */
#define ETH_DMACMFCR_MFC_Pos                          (0U)
#define ETH_DMACMFCR_MFC_Msk                          (0x7FFUL << ETH_DMACMFCR_MFC_Pos) /*!< 0x000007FF */
#define ETH_DMACMFCR_MFC                              ETH_DMACMFCR_MFC_Msk     /* The number of packet counters dropped by the DMA */
/******************************************************************************/
/*                                                                            */
/*                           DMA Controller (DMA)                             */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for DMA_SECCFGR register  ****************/
#define DMA_SECCFGR_SEC0_Pos                (0U)
#define DMA_SECCFGR_SEC0_Msk                (0x1UL << DMA_SECCFGR_SEC0_Pos)         /*!< 0x00000001 */
#define DMA_SECCFGR_SEC0                    DMA_SECCFGR_SEC0_Msk                    /*!< Secure State of Channel 0  */
#define DMA_SECCFGR_SEC1_Pos                (1U)
#define DMA_SECCFGR_SEC1_Msk                (0x1UL << DMA_SECCFGR_SEC1_Pos)         /*!< 0x00000002 */
#define DMA_SECCFGR_SEC1                    DMA_SECCFGR_SEC1_Msk                    /*!< Secure State of Channel 1  */
#define DMA_SECCFGR_SEC2_Pos                (2U)
#define DMA_SECCFGR_SEC2_Msk                (0x1UL << DMA_SECCFGR_SEC2_Pos)         /*!< 0x00000004 */
#define DMA_SECCFGR_SEC2                    DMA_SECCFGR_SEC2_Msk                    /*!< Secure State of Channel 2  */
#define DMA_SECCFGR_SEC3_Pos                (3U)
#define DMA_SECCFGR_SEC3_Msk                (0x1UL << DMA_SECCFGR_SEC3_Pos)         /*!< 0x00000008 */
#define DMA_SECCFGR_SEC3                    DMA_SECCFGR_SEC3_Msk                    /*!< Secure State of Channel 3  */
#define DMA_SECCFGR_SEC4_Pos                (4U)
#define DMA_SECCFGR_SEC4_Msk                (0x1UL << DMA_SECCFGR_SEC4_Pos)         /*!< 0x00000010 */
#define DMA_SECCFGR_SEC4                    DMA_SECCFGR_SEC4_Msk                    /*!< Secure State of Channel 4  */
#define DMA_SECCFGR_SEC5_Pos                (5U)
#define DMA_SECCFGR_SEC5_Msk                (0x1UL << DMA_SECCFGR_SEC5_Pos)         /*!< 0x00000020 */
#define DMA_SECCFGR_SEC5                    DMA_SECCFGR_SEC5_Msk                    /*!< Secure State of Channel 5  */
#define DMA_SECCFGR_SEC6_Pos                (6U)
#define DMA_SECCFGR_SEC6_Msk                (0x1UL << DMA_SECCFGR_SEC6_Pos)         /*!< 0x00000040 */
#define DMA_SECCFGR_SEC6                    DMA_SECCFGR_SEC6_Msk                    /*!< Secure State of Channel 6  */
#define DMA_SECCFGR_SEC7_Pos                (7U)
#define DMA_SECCFGR_SEC7_Msk                (0x1UL << DMA_SECCFGR_SEC7_Pos)         /*!< 0x00000080 */
#define DMA_SECCFGR_SEC7                    DMA_SECCFGR_SEC7_Msk                    /*!< Secure State of Channel 7  */

/*******************  Bit definition for DMA_PRIVCFGR register  ****************/
#define DMA_PRIVCFGR_PRIV0_Pos              (0U)
#define DMA_PRIVCFGR_PRIV0_Msk              (0x1UL << DMA_PRIVCFGR_PRIV0_Pos)       /*!< 0x00000001 */
#define DMA_PRIVCFGR_PRIV0                  DMA_PRIVCFGR_PRIV0_Msk                  /*!< Privileged State of Channel 0  */
#define DMA_PRIVCFGR_PRIV1_Pos              (1U)
#define DMA_PRIVCFGR_PRIV1_Msk              (0x1UL << DMA_PRIVCFGR_PRIV1_Pos)       /*!< 0x00000002 */
#define DMA_PRIVCFGR_PRIV1                  DMA_PRIVCFGR_PRIV1_Msk                  /*!< Privileged State of Channel 1  */
#define DMA_PRIVCFGR_PRIV2_Pos              (2U)
#define DMA_PRIVCFGR_PRIV2_Msk              (0x1UL << DMA_PRIVCFGR_PRIV2_Pos)       /*!< 0x00000004 */
#define DMA_PRIVCFGR_PRIV2                  DMA_PRIVCFGR_PRIV2_Msk                  /*!< Privileged State of Channel 2  */
#define DMA_PRIVCFGR_PRIV3_Pos              (3U)
#define DMA_PRIVCFGR_PRIV3_Msk              (0x1UL << DMA_PRIVCFGR_PRIV3_Pos)       /*!< 0x00000008 */
#define DMA_PRIVCFGR_PRIV3                  DMA_PRIVCFGR_PRIV3_Msk                  /*!< Privileged State of Channel 3  */
#define DMA_PRIVCFGR_PRIV4_Pos              (4U)
#define DMA_PRIVCFGR_PRIV4_Msk              (0x1UL << DMA_PRIVCFGR_PRIV4_Pos)       /*!< 0x00000010 */
#define DMA_PRIVCFGR_PRIV4                  DMA_PRIVCFGR_PRIV4_Msk                  /*!< Privileged State of Channel 4  */
#define DMA_PRIVCFGR_PRIV5_Pos              (5U)
#define DMA_PRIVCFGR_PRIV5_Msk              (0x1UL << DMA_PRIVCFGR_PRIV5_Pos)       /*!< 0x00000020 */
#define DMA_PRIVCFGR_PRIV5                  DMA_PRIVCFGR_PRIV5_Msk                  /*!< Privileged State of Channel 5  */
#define DMA_PRIVCFGR_PRIV6_Pos              (6U)
#define DMA_PRIVCFGR_PRIV6_Msk              (0x1UL << DMA_PRIVCFGR_PRIV6_Pos)       /*!< 0x00000040 */
#define DMA_PRIVCFGR_PRIV6                  DMA_PRIVCFGR_PRIV6_Msk                  /*!< Privileged State of Channel 6  */
#define DMA_PRIVCFGR_PRIV7_Pos              (7U)
#define DMA_PRIVCFGR_PRIV7_Msk              (0x1UL << DMA_PRIVCFGR_PRIV7_Pos)       /*!< 0x00000080 */
#define DMA_PRIVCFGR_PRIV7                  DMA_PRIVCFGR_PRIV7_Msk                  /*!< Privileged State of Channel 7  */

/*******************  Bit definition for DMA_RCFGLOCKR register  ****************/
#define DMA_RCFGLOCKR_LOCK0_Pos              (0U)
#define DMA_RCFGLOCKR_LOCK0_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK0_Pos)       /*!< 0x00000001 */
#define DMA_RCFGLOCKR_LOCK0                  DMA_RCFGLOCKR_LOCK0_Msk                  /*!< Lock the configuration of Channel 0  */
#define DMA_RCFGLOCKR_LOCK1_Pos              (1U)
#define DMA_RCFGLOCKR_LOCK1_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK1_Pos)       /*!< 0x00000002 */
#define DMA_RCFGLOCKR_LOCK1                  DMA_RCFGLOCKR_LOCK1_Msk                  /*!< Lock the configuration of Channel 1  */
#define DMA_RCFGLOCKR_LOCK2_Pos              (2U)
#define DMA_RCFGLOCKR_LOCK2_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK2_Pos)       /*!< 0x00000004 */
#define DMA_RCFGLOCKR_LOCK2                  DMA_RCFGLOCKR_LOCK2_Msk                  /*!< Lock the configuration of Channel 2  */
#define DMA_RCFGLOCKR_LOCK3_Pos              (3U)
#define DMA_RCFGLOCKR_LOCK3_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK3_Pos)       /*!< 0x00000008 */
#define DMA_RCFGLOCKR_LOCK3                  DMA_RCFGLOCKR_LOCK3_Msk                  /*!< Lock the configuration of Channel 3  */
#define DMA_RCFGLOCKR_LOCK4_Pos              (4U)
#define DMA_RCFGLOCKR_LOCK4_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK4_Pos)       /*!< 0x00000010 */
#define DMA_RCFGLOCKR_LOCK4                  DMA_RCFGLOCKR_LOCK4_Msk                  /*!< Lock the configuration of Channel 4  */
#define DMA_RCFGLOCKR_LOCK5_Pos              (5U)
#define DMA_RCFGLOCKR_LOCK5_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK5_Pos)       /*!< 0x00000020 */
#define DMA_RCFGLOCKR_LOCK5                  DMA_RCFGLOCKR_LOCK5_Msk                  /*!< Lock the configuration of Channel 5  */
#define DMA_RCFGLOCKR_LOCK6_Pos              (6U)
#define DMA_RCFGLOCKR_LOCK6_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK6_Pos)       /*!< 0x00000040 */
#define DMA_RCFGLOCKR_LOCK6                  DMA_RCFGLOCKR_LOCK6_Msk                  /*!< Lock the configuration of Channel 6  */
#define DMA_RCFGLOCKR_LOCK7_Pos              (7U)
#define DMA_RCFGLOCKR_LOCK7_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK7_Pos)       /*!< 0x00000080 */
#define DMA_RCFGLOCKR_LOCK7                  DMA_RCFGLOCKR_LOCK7_Msk                  /*!< Lock the configuration of Channel 7  */

/*******************  Bit definition for DMA_MISR register  ****************/
#define DMA_MISR_MIS0_Pos                   (0U)
#define DMA_MISR_MIS0_Msk                   (0x1UL << DMA_MISR_MIS0_Pos)            /*!< 0x00000001 */
#define DMA_MISR_MIS0                       DMA_MISR_MIS0_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 0  */
#define DMA_MISR_MIS1_Pos                   (1U)
#define DMA_MISR_MIS1_Msk                   (0x1UL << DMA_MISR_MIS1_Pos)            /*!< 0x00000002 */
#define DMA_MISR_MIS1                       DMA_MISR_MIS1_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 1  */
#define DMA_MISR_MIS2_Pos                   (2U)
#define DMA_MISR_MIS2_Msk                   (0x1UL << DMA_MISR_MIS2_Pos)            /*!< 0x00000004 */
#define DMA_MISR_MIS2                       DMA_MISR_MIS2_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 2  */
#define DMA_MISR_MIS3_Pos                   (3U)
#define DMA_MISR_MIS3_Msk                   (0x1UL << DMA_MISR_MIS3_Pos)            /*!< 0x00000008 */
#define DMA_MISR_MIS3                       DMA_MISR_MIS3_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 3  */
#define DMA_MISR_MIS4_Pos                   (4U)
#define DMA_MISR_MIS4_Msk                   (0x1UL << DMA_MISR_MIS4_Pos)            /*!< 0x00000010 */
#define DMA_MISR_MIS4                       DMA_MISR_MIS4_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 4  */
#define DMA_MISR_MIS5_Pos                   (5U)
#define DMA_MISR_MIS5_Msk                   (0x1UL << DMA_MISR_MIS5_Pos)            /*!< 0x00000020 */
#define DMA_MISR_MIS5                       DMA_MISR_MIS5_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 5  */
#define DMA_MISR_MIS6_Pos                   (6U)
#define DMA_MISR_MIS6_Msk                   (0x1UL << DMA_MISR_MIS6_Pos)            /*!< 0x00000040 */
#define DMA_MISR_MIS6                       DMA_MISR_MIS6_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 6  */
#define DMA_MISR_MIS7_Pos                   (7U)
#define DMA_MISR_MIS7_Msk                   (0x1UL << DMA_MISR_MIS7_Pos)            /*!< 0x00000080 */
#define DMA_MISR_MIS7                       DMA_MISR_MIS7_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 7  */

/*******************  Bit definition for DMA_SMISR register  ****************/
#define DMA_SMISR_MIS0_Pos                  (0U)
#define DMA_SMISR_MIS0_Msk                  (0x1UL << DMA_SMISR_MIS0_Pos)           /*!< 0x00000001 */
#define DMA_SMISR_MIS0                      DMA_SMISR_MIS0_Msk                      /*!< Masked Interrupt State of Secure Channel 0  */
#define DMA_SMISR_MIS1_Pos                  (1U)
#define DMA_SMISR_MIS1_Msk                  (0x1UL << DMA_SMISR_MIS1_Pos)           /*!< 0x00000002 */
#define DMA_SMISR_MIS1                      DMA_SMISR_MIS1_Msk                      /*!< Masked Interrupt State of Secure Channel 1  */
#define DMA_SMISR_MIS2_Pos                  (2U)
#define DMA_SMISR_MIS2_Msk                  (0x1UL << DMA_SMISR_MIS2_Pos)           /*!< 0x00000004 */
#define DMA_SMISR_MIS2                      DMA_SMISR_MIS2_Msk                      /*!< Masked Interrupt State of Secure Channel 2  */
#define DMA_SMISR_MIS3_Pos                  (3U)
#define DMA_SMISR_MIS3_Msk                  (0x1UL << DMA_SMISR_MIS3_Pos)           /*!< 0x00000008 */
#define DMA_SMISR_MIS3                      DMA_SMISR_MIS3_Msk                      /*!< Masked Interrupt State of Secure Channel 3  */
#define DMA_SMISR_MIS4_Pos                  (4U)
#define DMA_SMISR_MIS4_Msk                  (0x1UL << DMA_SMISR_MIS4_Pos)           /*!< 0x00000010 */
#define DMA_SMISR_MIS4                      DMA_SMISR_MIS4_Msk                      /*!< Masked Interrupt State of Secure Channel 4  */
#define DMA_SMISR_MIS5_Pos                  (5U)
#define DMA_SMISR_MIS5_Msk                  (0x1UL << DMA_SMISR_MIS5_Pos)           /*!< 0x00000020 */
#define DMA_SMISR_MIS5                      DMA_SMISR_MIS5_Msk                      /*!< Masked Interrupt State of Secure Channel 5  */
#define DMA_SMISR_MIS6_Pos                  (6U)
#define DMA_SMISR_MIS6_Msk                  (0x1UL << DMA_SMISR_MIS6_Pos)           /*!< 0x00000040 */
#define DMA_SMISR_MIS6                      DMA_SMISR_MIS6_Msk                      /*!< Masked Interrupt State of Secure Channel 6  */
#define DMA_SMISR_MIS7_Pos                  (7U)
#define DMA_SMISR_MIS7_Msk                  (0x1UL << DMA_SMISR_MIS7_Pos)           /*!< 0x00000080 */
#define DMA_SMISR_MIS7                      DMA_SMISR_MIS7_Msk                      /*!< Masked Interrupt State of Secure Channel 7  */

/*******************  Bit definition for DMA_CLBAR register  ****************/
#define DMA_CLBAR_LBA_Pos                   (16U)
#define DMA_CLBAR_LBA_Msk                   (0xFFFFUL << DMA_CLBAR_LBA_Pos)         /*!< 0xFFFF0000 */
#define DMA_CLBAR_LBA                       DMA_CLBAR_LBA_Msk                       /*!< Linked-list Base Address of DMA channel x */

/*******************  Bit definition for DMA_CFCR register  *******************/
#define DMA_CFCR_TCF_Pos                    (8U)
#define DMA_CFCR_TCF_Msk                    (0x1UL << DMA_CFCR_TCF_Pos)             /*!< 0x00000100 */
#define DMA_CFCR_TCF                        DMA_CFCR_TCF_Msk                        /*!< Transfer complete flag clear             */
#define DMA_CFCR_HTF_Pos                    (9U)
#define DMA_CFCR_HTF_Msk                    (0x1UL << DMA_CFCR_HTF_Pos)             /*!< 0x00000200 */
#define DMA_CFCR_HTF                        DMA_CFCR_HTF_Msk                        /*!< Half transfer complete flag clear        */
#define DMA_CFCR_DTEF_Pos                   (10U)
#define DMA_CFCR_DTEF_Msk                   (0x1UL << DMA_CFCR_DTEF_Pos)            /*!< 0x00000400 */
#define DMA_CFCR_DTEF                       DMA_CFCR_DTEF_Msk                       /*!< Data transfer error flag clear           */
#define DMA_CFCR_ULEF_Pos                   (11U)
#define DMA_CFCR_ULEF_Msk                   (0x1UL << DMA_CFCR_ULEF_Pos)            /*!< 0x00000800 */
#define DMA_CFCR_ULEF                       DMA_CFCR_ULEF_Msk                       /*!< Update linked-list item error flag clear */
#define DMA_CFCR_USEF_Pos                   (12U)
#define DMA_CFCR_USEF_Msk                   (0x1UL << DMA_CFCR_USEF_Pos)            /*!< 0x00001000 */
#define DMA_CFCR_USEF                       DMA_CFCR_USEF_Msk                       /*!< User setting error flag clear            */
#define DMA_CFCR_SUSPF_Pos                  (13U)
#define DMA_CFCR_SUSPF_Msk                  (0x1UL << DMA_CFCR_SUSPF_Pos)           /*!< 0x00002000 */
#define DMA_CFCR_SUSPF                      DMA_CFCR_SUSPF_Msk                      /*!< Completed suspension flag clear          */
#define DMA_CFCR_TOF_Pos                    (14U)
#define DMA_CFCR_TOF_Msk                    (0x1UL << DMA_CFCR_TOF_Pos)             /*!< 0x00004000 */
#define DMA_CFCR_TOF                        DMA_CFCR_TOF_Msk                        /*!< Trigger overrun flag clear               */

/*******************  Bit definition for DMA_CSR register  *******************/
#define DMA_CSR_IDLEF_Pos                   (0U)
#define DMA_CSR_IDLEF_Msk                   (0x1UL << DMA_CSR_IDLEF_Pos)            /*!< 0x00000001 */
#define DMA_CSR_IDLEF                       DMA_CSR_IDLEF_Msk                       /*!< Idle flag                          */
#define DMA_CSR_TCF_Pos                     (8U)
#define DMA_CSR_TCF_Msk                     (0x1UL << DMA_CSR_TCF_Pos)              /*!< 0x00000100 */
#define DMA_CSR_TCF                         DMA_CSR_TCF_Msk                         /*!< Transfer complete flag             */
#define DMA_CSR_HTF_Pos                     (9U)
#define DMA_CSR_HTF_Msk                     (0x1UL << DMA_CSR_HTF_Pos)              /*!< 0x00000200 */
#define DMA_CSR_HTF                         DMA_CSR_HTF_Msk                         /*!< Half transfer complete flag        */
#define DMA_CSR_DTEF_Pos                    (10U)
#define DMA_CSR_DTEF_Msk                    (0x1UL << DMA_CSR_DTEF_Pos)             /*!< 0x00000400 */
#define DMA_CSR_DTEF                        DMA_CSR_DTEF_Msk                        /*!< Data transfer error flag           */
#define DMA_CSR_ULEF_Pos                    (11U)
#define DMA_CSR_ULEF_Msk                    (0x1UL << DMA_CSR_ULEF_Pos)             /*!< 0x00000800 */
#define DMA_CSR_ULEF                        DMA_CSR_ULEF_Msk                        /*!< Update linked-list item error flag */
#define DMA_CSR_USEF_Pos                    (12U)
#define DMA_CSR_USEF_Msk                    (0x1UL << DMA_CSR_USEF_Pos)             /*!< 0x00001000 */
#define DMA_CSR_USEF                        DMA_CSR_USEF_Msk                        /*!< User setting error flag            */
#define DMA_CSR_SUSPF_Pos                   (13U)
#define DMA_CSR_SUSPF_Msk                   (0x1UL << DMA_CSR_SUSPF_Pos)            /*!< 0x00002000 */
#define DMA_CSR_SUSPF                       DMA_CSR_SUSPF_Msk                       /*!< User setting error flag            */
#define DMA_CSR_TOF_Pos                     (14U)
#define DMA_CSR_TOF_Msk                     (0x1UL << DMA_CSR_TOF_Pos)              /*!< 0x00004000 */
#define DMA_CSR_TOF                         DMA_CSR_TOF_Msk                         /*!< Trigger overrun flag               */
#define DMA_CSR_FIFOL_Pos                   (16U)
#define DMA_CSR_FIFOL_Msk                   (0xFFUL << DMA_CSR_FIFOL_Pos)           /*!< 0x00FF0000 */
#define DMA_CSR_FIFOL                       DMA_CSR_FIFOL_Msk                       /*!< Monitored FIFO level in bytes      */

/*******************  Bit definition for DMA_CCR register  ********************/
#define DMA_CCR_EN_Pos                      (0U)
#define DMA_CCR_EN_Msk                      (0x1UL << DMA_CCR_EN_Pos)               /*!< 0x00000001 */
#define DMA_CCR_EN                          DMA_CCR_EN_Msk                          /*!< Channel enable                                 */
#define DMA_CCR_RESET_Pos                   (1U)
#define DMA_CCR_RESET_Msk                   (0x1UL << DMA_CCR_RESET_Pos)            /*!< 0x00000002 */
#define DMA_CCR_RESET                       DMA_CCR_RESET_Msk                       /*!< Channel reset                                  */
#define DMA_CCR_SUSP_Pos                    (2U)
#define DMA_CCR_SUSP_Msk                    (0x1UL << DMA_CCR_SUSP_Pos)             /*!< 0x00000004 */
#define DMA_CCR_SUSP                        DMA_CCR_SUSP_Msk                        /*!< Channel suspend                                */
#define DMA_CCR_TCIE_Pos                    (8U)
#define DMA_CCR_TCIE_Msk                    (0x1UL << DMA_CCR_TCIE_Pos)             /*!< 0x00000100 */
#define DMA_CCR_TCIE                        DMA_CCR_TCIE_Msk                        /*!< Transfer complete interrupt enable             */
#define DMA_CCR_HTIE_Pos                    (9U)
#define DMA_CCR_HTIE_Msk                    (0x1UL << DMA_CCR_HTIE_Pos)             /*!< 0x00000200 */
#define DMA_CCR_HTIE                        DMA_CCR_HTIE_Msk                        /*!< Half transfer complete interrupt enable        */
#define DMA_CCR_DTEIE_Pos                   (10U)
#define DMA_CCR_DTEIE_Msk                   (0x1UL << DMA_CCR_DTEIE_Pos)            /*!< 0x00000400 */
#define DMA_CCR_DTEIE                       DMA_CCR_DTEIE_Msk                       /*!< Data transfer error interrupt enable           */
#define DMA_CCR_ULEIE_Pos                   (11U)
#define DMA_CCR_ULEIE_Msk                   (0x1UL << DMA_CCR_ULEIE_Pos)            /*!< 0x00000800 */
#define DMA_CCR_ULEIE                       DMA_CCR_ULEIE_Msk                       /*!< Update linked-list item error interrupt enable */
#define DMA_CCR_USEIE_Pos                   (12U)
#define DMA_CCR_USEIE_Msk                   (0x1UL << DMA_CCR_USEIE_Pos)            /*!< 0x00001000 */
#define DMA_CCR_USEIE                       DMA_CCR_USEIE_Msk                       /*!< User setting error interrupt enable            */
#define DMA_CCR_SUSPIE_Pos                  (13U)
#define DMA_CCR_SUSPIE_Msk                  (0x1UL << DMA_CCR_SUSPIE_Pos)           /*!< 0x00002000 */
#define DMA_CCR_SUSPIE                      DMA_CCR_SUSPIE_Msk                      /*!< Completed suspension interrupt enable          */
#define DMA_CCR_TOIE_Pos                    (14U)
#define DMA_CCR_TOIE_Msk                    (0x1UL << DMA_CCR_TOIE_Pos)             /*!< 0x00004000 */
#define DMA_CCR_TOIE                        DMA_CCR_TOIE_Msk                        /*!< Trigger overrun interrupt enable               */
#define DMA_CCR_LSM_Pos                     (16U)
#define DMA_CCR_LSM_Msk                     (0x1UL << DMA_CCR_LSM_Pos)              /*!< 0x00010000 */
#define DMA_CCR_LSM                         DMA_CCR_LSM_Msk                         /*!< Link step mode                                 */
#define DMA_CCR_LAP_Pos                     (17U)
#define DMA_CCR_LAP_Msk                     (0x1UL << DMA_CCR_LAP_Pos)              /*!< 0x00020000 */
#define DMA_CCR_LAP                         DMA_CCR_LAP_Msk                         /*!< Linked-list allocated port                     */
#define DMA_CCR_PRIO_Pos                    (22U)
#define DMA_CCR_PRIO_Msk                    (0x3UL << DMA_CCR_PRIO_Pos)             /*!< 0x00C00000 */
#define DMA_CCR_PRIO                        DMA_CCR_PRIO_Msk                        /*!< Priority level                                 */
#define DMA_CCR_PRIO_0                      (0x1UL << DMA_CCR_PRIO_Pos)             /*!< 0x00400000 */
#define DMA_CCR_PRIO_1                      (0x2UL << DMA_CCR_PRIO_Pos)             /*!< 0x00800000 */

/*******************  Bit definition for DMA_CTR1 register  *******************/
#define DMA_CTR1_SDW_LOG2_Pos               (0U)
#define DMA_CTR1_SDW_LOG2_Msk               (0x3UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< 0x00000003 */
#define DMA_CTR1_SDW_LOG2                   DMA_CTR1_SDW_LOG2_Msk                   /*!< Binary logarithm of the source data width of a burst                    */
#define DMA_CTR1_SDW_LOG2_0                 (0x1UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_SDW_LOG2_1                 (0x2UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_SINC_Pos                   (3U)
#define DMA_CTR1_SINC_Msk                   (0x1UL << DMA_CTR1_SINC_Pos)            /*!< 0x00000008 */
#define DMA_CTR1_SINC                       DMA_CTR1_SINC_Msk                       /*!< Source incrementing burst                                               */
#define DMA_CTR1_SBL_1_Pos                  (4U)
#define DMA_CTR1_SBL_1_Msk                  (0x3FUL << DMA_CTR1_SBL_1_Pos)          /*!< 0x000003F0 */
#define DMA_CTR1_SBL_1                      DMA_CTR1_SBL_1_Msk                      /*!< Source burst length minus 1                                             */
#define DMA_CTR1_PAM_Pos                    (11U)
#define DMA_CTR1_PAM_Msk                    (0x3UL << DMA_CTR1_PAM_Pos)             /*!< 0x0001800 */
#define DMA_CTR1_PAM                        DMA_CTR1_PAM_Msk                        /*!< Padding / alignment mode                                                */
#define DMA_CTR1_PAM_0                      (0x1UL << DMA_CTR1_PAM_Pos)             /*!< Bit 0 */
#define DMA_CTR1_PAM_1                      (0x2UL << DMA_CTR1_PAM_Pos)             /*!< Bit 1 */
#define DMA_CTR1_SBX_Pos                    (13U)
#define DMA_CTR1_SBX_Msk                    (0x1UL << DMA_CTR1_SBX_Pos)             /*!< 0x00002000 */
#define DMA_CTR1_SBX                        DMA_CTR1_SBX_Msk                        /*!< Source byte exchange within the unaligned half-word of each source word */
#define DMA_CTR1_SAP_Pos                    (14U)
#define DMA_CTR1_SAP_Msk                    (0x1UL << DMA_CTR1_SAP_Pos)             /*!< 0x00004000 */
#define DMA_CTR1_SAP                        DMA_CTR1_SAP_Msk                        /*!< Source allocated port                                                   */
#define DMA_CTR1_SSEC_Pos                   (15U)
#define DMA_CTR1_SSEC_Msk                   (0x1UL << DMA_CTR1_SSEC_Pos)            /*!< 0x00008000 */
#define DMA_CTR1_SSEC                       DMA_CTR1_SSEC_Msk                       /*!< Security attribute of the DMA transfer from the source                  */
#define DMA_CTR1_DDW_LOG2_Pos               (16U)
#define DMA_CTR1_DDW_LOG2_Msk               (0x3UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< 0x00030000 */
#define DMA_CTR1_DDW_LOG2                   DMA_CTR1_DDW_LOG2_Msk                   /*!< Binary logarithm of the destination data width of a burst               */
#define DMA_CTR1_DDW_LOG2_0                 (0x1UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_DDW_LOG2_1                 (0x2UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_DINC_Pos                   (19U)
#define DMA_CTR1_DINC_Msk                   (0x1UL << DMA_CTR1_DINC_Pos)            /*!< 0x00080000 */
#define DMA_CTR1_DINC                       DMA_CTR1_DINC_Msk                       /*!< Destination incrementing burst                                          */
#define DMA_CTR1_DBL_1_Pos                  (20U)
#define DMA_CTR1_DBL_1_Msk                  (0x3FUL << DMA_CTR1_DBL_1_Pos)          /*!< 0x03F00000 */
#define DMA_CTR1_DBL_1                      DMA_CTR1_DBL_1_Msk                      /*!< Destination burst length minus 1                                        */
#define DMA_CTR1_DBX_Pos                    (26U)
#define DMA_CTR1_DBX_Msk                    (0x1UL << DMA_CTR1_DBX_Pos)             /*!< 0x04000000 */
#define DMA_CTR1_DBX                        DMA_CTR1_DBX_Msk                        /*!< Destination byte exchange                                               */
#define DMA_CTR1_DHX_Pos                    (27U)
#define DMA_CTR1_DHX_Msk                    (0x1UL << DMA_CTR1_DHX_Pos)             /*!< 0x08000000 */
#define DMA_CTR1_DHX                        DMA_CTR1_DHX_Msk                        /*!< Destination half-word exchange                                          */
#define DMA_CTR1_DAP_Pos                    (30U)
#define DMA_CTR1_DAP_Msk                    (0x1UL << DMA_CTR1_DAP_Pos)             /*!< 0x40000000 */
#define DMA_CTR1_DAP                        DMA_CTR1_DAP_Msk                        /*!< Destination allocated port                                              */
#define DMA_CTR1_DSEC_Pos                   (31U)
#define DMA_CTR1_DSEC_Msk                   (0x1UL << DMA_CTR1_DSEC_Pos)            /*!< 0x80000000 */
#define DMA_CTR1_DSEC                       DMA_CTR1_DSEC_Msk                       /*!< Security attribute of the DMA transfer from the destination             */

/******************  Bit definition for DMA_CTR2 register  *******************/
#define DMA_CTR2_REQSEL_Pos                 (0U)
#define DMA_CTR2_REQSEL_Msk                 (0xFFUL << DMA_CTR2_REQSEL_Pos)         /*!< 0x000000FF */
#define DMA_CTR2_REQSEL                     DMA_CTR2_REQSEL_Msk                     /*!< DMA hardware request selection */
#define DMA_CTR2_SWREQ_Pos                  (9U)
#define DMA_CTR2_SWREQ_Msk                  (0x1UL << DMA_CTR2_SWREQ_Pos)           /*!< 0x00000200 */
#define DMA_CTR2_SWREQ                      DMA_CTR2_SWREQ_Msk                      /*!< Software request               */
#define DMA_CTR2_DREQ_Pos                   (10U)
#define DMA_CTR2_DREQ_Msk                   (0x1UL << DMA_CTR2_DREQ_Pos)            /*!< 0x00000400 */
#define DMA_CTR2_DREQ                       DMA_CTR2_DREQ_Msk                       /*!< Destination hardware request   */
#define DMA_CTR2_BREQ_Pos                   (11U)
#define DMA_CTR2_BREQ_Msk                   (0x1UL << DMA_CTR2_BREQ_Pos)            /*!< 0x00000800 */
#define DMA_CTR2_BREQ                       DMA_CTR2_BREQ_Msk                       /*!< Block hardware request         */
#define DMA_CTR2_PFREQ_Pos                  (12U)
#define DMA_CTR2_PFREQ_Msk                  (0x1U << DMA_CTR2_PFREQ_Pos)            /*!< 0x00001000 */
#define DMA_CTR2_PFREQ                      DMA_CTR2_PFREQ_Msk                      /*!< Block hardware request */
#define DMA_CTR2_TRIGM_Pos                  (14U)
#define DMA_CTR2_TRIGM_Msk                  (0x3UL << DMA_CTR2_TRIGM_Pos)           /*!< 0x0000C000 */
#define DMA_CTR2_TRIGM                      DMA_CTR2_TRIGM_Msk                      /*!< Trigger mode                   */
#define DMA_CTR2_TRIGM_0                    (0x1UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 0 */
#define DMA_CTR2_TRIGM_1                    (0x2UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 1 */
#define DMA_CTR2_TRIGSEL_Pos                (16U)
#define DMA_CTR2_TRIGSEL_Msk                (0x3FUL << DMA_CTR2_TRIGSEL_Pos)        /*!< 0x003F0000 */
#define DMA_CTR2_TRIGSEL                    DMA_CTR2_TRIGSEL_Msk                    /*!< Trigger event input selection  */
#define DMA_CTR2_TRIGPOL_Pos                (24U)
#define DMA_CTR2_TRIGPOL_Msk                (0x3UL << DMA_CTR2_TRIGPOL_Pos)         /*!< 0x03000000 */
#define DMA_CTR2_TRIGPOL                    DMA_CTR2_TRIGPOL_Msk                    /*!< Trigger event polarity         */
#define DMA_CTR2_TRIGPOL_0                  (0x1UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 0 */
#define DMA_CTR2_TRIGPOL_1                  (0x2UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 1 */
#define DMA_CTR2_TCEM_Pos                   (30U)
#define DMA_CTR2_TCEM_Msk                   (0x3UL << DMA_CTR2_TCEM_Pos)            /*!< 0xC0000000 */
#define DMA_CTR2_TCEM                       DMA_CTR2_TCEM_Msk                       /*!< Transfer complete event mode   */
#define DMA_CTR2_TCEM_0                     (0x1UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 0 */
#define DMA_CTR2_TCEM_1                     (0x2UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 1 */

/******************  Bit definition for DMA_CBR1 register  *******************/
#define DMA_CBR1_BNDT_Pos                   (0U)
#define DMA_CBR1_BNDT_Msk                   (0xFFFFUL << DMA_CBR1_BNDT_Pos)         /*!< 0x0000FFFF */
#define DMA_CBR1_BNDT                       DMA_CBR1_BNDT_Msk                       /*!< Block number of data bytes to transfer from the source */
#define DMA_CBR1_BRC_Pos                    (16U)
#define DMA_CBR1_BRC_Msk                    (0x7FFUL << DMA_CBR1_BRC_Pos)           /*!< 0x07FF0000 */
#define DMA_CBR1_BRC                        DMA_CBR1_BRC_Msk                        /*!< Block repeat counter                                   */
#define DMA_CBR1_SDEC_Pos                   (28U)
#define DMA_CBR1_SDEC_Msk                   (0x1UL << DMA_CBR1_SDEC_Pos)            /*!< 0x10000000 */
#define DMA_CBR1_SDEC                       DMA_CBR1_SDEC_Msk                       /*!< Source address decrement                               */
#define DMA_CBR1_DDEC_Pos                   (29U)
#define DMA_CBR1_DDEC_Msk                   (0x1UL << DMA_CBR1_DDEC_Pos)            /*!< 0x20000000 */
#define DMA_CBR1_DDEC                       DMA_CBR1_DDEC_Msk                       /*!< Destination address decrement                          */
#define DMA_CBR1_BRSDEC_Pos                 (30U)
#define DMA_CBR1_BRSDEC_Msk                 (0x1UL << DMA_CBR1_BRSDEC_Pos)          /*!< 0x40000000 */
#define DMA_CBR1_BRSDEC                     DMA_CBR1_BRSDEC_Msk                     /*!< Block repeat source address decrement                  */
#define DMA_CBR1_BRDDEC_Pos                 (31U)
#define DMA_CBR1_BRDDEC_Msk                 (0x1UL << DMA_CBR1_BRDDEC_Pos)          /*!< 0x80000000 */
#define DMA_CBR1_BRDDEC                     DMA_CBR1_BRDDEC_Msk                     /*!< Block repeat destination address decrement             */

/******************  Bit definition for DMA_CSAR register  ********************/
#define DMA_CSAR_SA_Pos                     (0U)
#define DMA_CSAR_SA_Msk                     (0xFFFFFFFFUL << DMA_CSAR_SA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CSAR_SA                         DMA_CSAR_SA_Msk                         /*!< Source Address */

/******************  Bit definition for DMA_CDAR register  *******************/
#define DMA_CDAR_DA_Pos                     (0U)
#define DMA_CDAR_DA_Msk                     (0xFFFFFFFFUL << DMA_CDAR_DA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CDAR_DA                         DMA_CDAR_DA_Msk                         /*!< Destination address */

/******************  Bit definition for DMA_CTR3 register  *******************/
#define DMA_CTR3_SAO_Pos                    (0U)
#define DMA_CTR3_SAO_Msk                    (0x1FFFUL << DMA_CTR3_SAO_Pos)          /*!< 0x00001FFF */
#define DMA_CTR3_SAO                        DMA_CTR3_SAO_Msk                        /*!< Source address offset increment      */
#define DMA_CTR3_DAO_Pos                    (16U)
#define DMA_CTR3_DAO_Msk                    (0x1FFFUL << DMA_CTR3_DAO_Pos)          /*!< 0x1FFF0000 */
#define DMA_CTR3_DAO                        DMA_CTR3_DAO_Msk                        /*!< Destination address offset increment */

/******************  Bit definition for DMA_CBR2 register  *******************/
#define DMA_CBR2_BRSAO_Pos                  (0U)
#define DMA_CBR2_BRSAO_Msk                  (0xFFFFUL << DMA_CBR2_BRSAO_Pos)        /*!< 0x0000FFFF */
#define DMA_CBR2_BRSAO                      DMA_CBR2_BRSAO_Msk                      /*!< Block repeated source address offset      */
#define DMA_CBR2_BRDAO_Pos                  (16U)
#define DMA_CBR2_BRDAO_Msk                  (0xFFFFUL << DMA_CBR2_BRDAO_Pos)        /*!< 0xFFFF0000 */
#define DMA_CBR2_BRDAO                      DMA_CBR2_BRDAO_Msk                      /*!< Block repeated destination address offset */

/******************  Bit definition for DMA_CLLR register  *******************/
#define DMA_CLLR_LA_Pos                     (2U)
#define DMA_CLLR_LA_Msk                     (0x3FFFUL << DMA_CLLR_LA_Pos)           /*!< 0x0000FFFC */
#define DMA_CLLR_LA                         DMA_CLLR_LA_Msk                         /*!< Pointer to the next linked-list data structure */
#define DMA_CLLR_ULL_Pos                    (16U)
#define DMA_CLLR_ULL_Msk                    (0x1UL << DMA_CLLR_ULL_Pos)             /*!< 0x00010000 */
#define DMA_CLLR_ULL                        DMA_CLLR_ULL_Msk                        /*!< Update link address register from memory       */
#define DMA_CLLR_UB2_Pos                    (25U)
#define DMA_CLLR_UB2_Msk                    (0x1UL << DMA_CLLR_UB2_Pos)             /*!< 0x02000000 */
#define DMA_CLLR_UB2                        DMA_CLLR_UB2_Msk                        /*!< Update block register 2 from memory            */
#define DMA_CLLR_UT3_Pos                    (26U)
#define DMA_CLLR_UT3_Msk                    (0x1UL << DMA_CLLR_UT3_Pos)             /*!< 0x04000000 */
#define DMA_CLLR_UT3                        DMA_CLLR_UT3_Msk                        /*!< Update transfer register 3 from SRAM           */
#define DMA_CLLR_UDA_Pos                    (27U)
#define DMA_CLLR_UDA_Msk                    (0x1UL << DMA_CLLR_UDA_Pos)             /*!< 0x08000000 */
#define DMA_CLLR_UDA                        DMA_CLLR_UDA_Msk                        /*!< Update destination address register from SRAM  */
#define DMA_CLLR_USA_Pos                    (28U)
#define DMA_CLLR_USA_Msk                    (0x1UL << DMA_CLLR_USA_Pos)             /*!< 0x10000000 */
#define DMA_CLLR_USA                        DMA_CLLR_USA_Msk                        /*!< Update source address register from SRAM       */
#define DMA_CLLR_UB1_Pos                    (29U)
#define DMA_CLLR_UB1_Msk                    (0x1UL << DMA_CLLR_UB1_Pos)             /*!< 0x20000000 */
#define DMA_CLLR_UB1                        DMA_CLLR_UB1_Msk                        /*!< Update block register 1 from SRAM              */
#define DMA_CLLR_UT2_Pos                    (30U)
#define DMA_CLLR_UT2_Msk                    (0x1UL << DMA_CLLR_UT2_Pos)             /*!< 0x40000000 */
#define DMA_CLLR_UT2                        DMA_CLLR_UT2_Msk                        /*!< Update transfer register 2 from SRAM           */
#define DMA_CLLR_UT1_Pos                    (31U)
#define DMA_CLLR_UT1_Msk                    (0x1UL << DMA_CLLR_UT1_Pos)             /*!< 0x80000000 */
#define DMA_CLLR_UT1                        DMA_CLLR_UT1_Msk                        /*!< Update transfer register 1 from SRAM           */

/******************************************************************************/
/*                                                                            */
/*                    External Interrupt/Event Controller                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for EXTI_RTSR1 register  ******************/
#define EXTI_RTSR1_RT0_Pos                  (0U)
#define EXTI_RTSR1_RT0_Msk                  (0x1UL << EXTI_RTSR1_RT0_Pos)           /*!< 0x00000001 */
#define EXTI_RTSR1_RT0                      EXTI_RTSR1_RT0_Msk                      /*!< Rising trigger configuration for input line 0 */
#define EXTI_RTSR1_RT1_Pos                  (1U)
#define EXTI_RTSR1_RT1_Msk                  (0x1UL << EXTI_RTSR1_RT1_Pos)           /*!< 0x00000002 */
#define EXTI_RTSR1_RT1                      EXTI_RTSR1_RT1_Msk                      /*!< Rising trigger configuration for input line 1 */
#define EXTI_RTSR1_RT2_Pos                  (2U)
#define EXTI_RTSR1_RT2_Msk                  (0x1UL << EXTI_RTSR1_RT2_Pos)           /*!< 0x00000004 */
#define EXTI_RTSR1_RT2                      EXTI_RTSR1_RT2_Msk                      /*!< Rising trigger configuration for input line 2 */
#define EXTI_RTSR1_RT3_Pos                  (3U)
#define EXTI_RTSR1_RT3_Msk                  (0x1UL << EXTI_RTSR1_RT3_Pos)           /*!< 0x00000008 */
#define EXTI_RTSR1_RT3                      EXTI_RTSR1_RT3_Msk                      /*!< Rising trigger configuration for input line 3 */
#define EXTI_RTSR1_RT4_Pos                  (4U)
#define EXTI_RTSR1_RT4_Msk                  (0x1UL << EXTI_RTSR1_RT4_Pos)           /*!< 0x00000010 */
#define EXTI_RTSR1_RT4                      EXTI_RTSR1_RT4_Msk                      /*!< Rising trigger configuration for input line 4 */
#define EXTI_RTSR1_RT5_Pos                  (5U)
#define EXTI_RTSR1_RT5_Msk                  (0x1UL << EXTI_RTSR1_RT5_Pos)           /*!< 0x00000020 */
#define EXTI_RTSR1_RT5                      EXTI_RTSR1_RT5_Msk                      /*!< Rising trigger configuration for input line 5 */
#define EXTI_RTSR1_RT6_Pos                  (6U)
#define EXTI_RTSR1_RT6_Msk                  (0x1UL << EXTI_RTSR1_RT6_Pos)           /*!< 0x00000040 */
#define EXTI_RTSR1_RT6                      EXTI_RTSR1_RT6_Msk                      /*!< Rising trigger configuration for input line 6 */
#define EXTI_RTSR1_RT7_Pos                  (7U)
#define EXTI_RTSR1_RT7_Msk                  (0x1UL << EXTI_RTSR1_RT7_Pos)           /*!< 0x00000080 */
#define EXTI_RTSR1_RT7                      EXTI_RTSR1_RT7_Msk                      /*!< Rising trigger configuration for input line 7 */
#define EXTI_RTSR1_RT8_Pos                  (8U)
#define EXTI_RTSR1_RT8_Msk                  (0x1UL << EXTI_RTSR1_RT8_Pos)           /*!< 0x00000100 */
#define EXTI_RTSR1_RT8                      EXTI_RTSR1_RT8_Msk                      /*!< Rising trigger configuration for input line 8 */
#define EXTI_RTSR1_RT9_Pos                  (9U)
#define EXTI_RTSR1_RT9_Msk                  (0x1UL << EXTI_RTSR1_RT9_Pos)           /*!< 0x00000200 */
#define EXTI_RTSR1_RT9                      EXTI_RTSR1_RT9_Msk                      /*!< Rising trigger configuration for input line 9 */
#define EXTI_RTSR1_RT10_Pos                 (10U)
#define EXTI_RTSR1_RT10_Msk                 (0x1UL << EXTI_RTSR1_RT10_Pos)          /*!< 0x00000400 */
#define EXTI_RTSR1_RT10                     EXTI_RTSR1_RT10_Msk                     /*!< Rising trigger configuration for input line 10 */
#define EXTI_RTSR1_RT11_Pos                 (11U)
#define EXTI_RTSR1_RT11_Msk                 (0x1UL << EXTI_RTSR1_RT11_Pos)          /*!< 0x00000800 */
#define EXTI_RTSR1_RT11                     EXTI_RTSR1_RT11_Msk                     /*!< Rising trigger configuration for input line 11 */
#define EXTI_RTSR1_RT12_Pos                 (12U)
#define EXTI_RTSR1_RT12_Msk                 (0x1UL << EXTI_RTSR1_RT12_Pos)          /*!< 0x00001000 */
#define EXTI_RTSR1_RT12                     EXTI_RTSR1_RT12_Msk                     /*!< Rising trigger configuration for input line 12 */
#define EXTI_RTSR1_RT13_Pos                 (13U)
#define EXTI_RTSR1_RT13_Msk                 (0x1UL << EXTI_RTSR1_RT13_Pos)          /*!< 0x00002000 */
#define EXTI_RTSR1_RT13                     EXTI_RTSR1_RT13_Msk                     /*!< Rising trigger configuration for input line 13 */
#define EXTI_RTSR1_RT14_Pos                 (14U)
#define EXTI_RTSR1_RT14_Msk                 (0x1UL << EXTI_RTSR1_RT14_Pos)          /*!< 0x00004000 */
#define EXTI_RTSR1_RT14                     EXTI_RTSR1_RT14_Msk                     /*!< Rising trigger configuration for input line 14 */
#define EXTI_RTSR1_RT15_Pos                 (15U)
#define EXTI_RTSR1_RT15_Msk                 (0x1UL << EXTI_RTSR1_RT15_Pos)          /*!< 0x00008000 */
#define EXTI_RTSR1_RT15                     EXTI_RTSR1_RT15_Msk                     /*!< Rising trigger configuration for input line 15 */
#define EXTI_RTSR1_RT16_Pos                 (16U)
#define EXTI_RTSR1_RT16_Msk                 (0x1UL << EXTI_RTSR1_RT16_Pos)          /*!< 0x00010000 */
#define EXTI_RTSR1_RT16                     EXTI_RTSR1_RT16_Msk                     /*!< Rising trigger configuration for input line 16 */

/******************  Bit definition for EXTI_FTSR1 register  ******************/
#define EXTI_FTSR1_FT0_Pos                  (0U)
#define EXTI_FTSR1_FT0_Msk                  (0x1UL << EXTI_FTSR1_FT0_Pos)           /*!< 0x00000001 */
#define EXTI_FTSR1_FT0                      EXTI_FTSR1_FT0_Msk                      /*!< Falling trigger configuration for input line 0 */
#define EXTI_FTSR1_FT1_Pos                  (1U)
#define EXTI_FTSR1_FT1_Msk                  (0x1UL << EXTI_FTSR1_FT1_Pos)           /*!< 0x00000002 */
#define EXTI_FTSR1_FT1                      EXTI_FTSR1_FT1_Msk                      /*!< Falling trigger configuration for input line 1 */
#define EXTI_FTSR1_FT2_Pos                  (2U)
#define EXTI_FTSR1_FT2_Msk                  (0x1UL << EXTI_FTSR1_FT2_Pos)           /*!< 0x00000004 */
#define EXTI_FTSR1_FT2                      EXTI_FTSR1_FT2_Msk                      /*!< Falling trigger configuration for input line 2 */
#define EXTI_FTSR1_FT3_Pos                  (3U)
#define EXTI_FTSR1_FT3_Msk                  (0x1UL << EXTI_FTSR1_FT3_Pos)           /*!< 0x00000008 */
#define EXTI_FTSR1_FT3                      EXTI_FTSR1_FT3_Msk                      /*!< Falling trigger configuration for input line 3 */
#define EXTI_FTSR1_FT4_Pos                  (4U)
#define EXTI_FTSR1_FT4_Msk                  (0x1UL << EXTI_FTSR1_FT4_Pos)           /*!< 0x00000010 */
#define EXTI_FTSR1_FT4                      EXTI_FTSR1_FT4_Msk                      /*!< Falling trigger configuration for input line 4 */
#define EXTI_FTSR1_FT5_Pos                  (5U)
#define EXTI_FTSR1_FT5_Msk                  (0x1UL << EXTI_FTSR1_FT5_Pos)           /*!< 0x00000020 */
#define EXTI_FTSR1_FT5                      EXTI_FTSR1_FT5_Msk                      /*!< Falling trigger configuration for input line 5 */
#define EXTI_FTSR1_FT6_Pos                  (6U)
#define EXTI_FTSR1_FT6_Msk                  (0x1UL << EXTI_FTSR1_FT6_Pos)           /*!< 0x00000040 */
#define EXTI_FTSR1_FT6                      EXTI_FTSR1_FT6_Msk                      /*!< Falling trigger configuration for input line 6 */
#define EXTI_FTSR1_FT7_Pos                  (7U)
#define EXTI_FTSR1_FT7_Msk                  (0x1UL << EXTI_FTSR1_FT7_Pos)           /*!< 0x00000080 */
#define EXTI_FTSR1_FT7                      EXTI_FTSR1_FT7_Msk                      /*!< Falling trigger configuration for input line 7 */
#define EXTI_FTSR1_FT8_Pos                  (8U)
#define EXTI_FTSR1_FT8_Msk                  (0x1UL << EXTI_FTSR1_FT8_Pos)           /*!< 0x00000100 */
#define EXTI_FTSR1_FT8                      EXTI_FTSR1_FT8_Msk                      /*!< Falling trigger configuration for input line 8 */
#define EXTI_FTSR1_FT9_Pos                  (9U)
#define EXTI_FTSR1_FT9_Msk                  (0x1UL << EXTI_FTSR1_FT9_Pos)           /*!< 0x00000200 */
#define EXTI_FTSR1_FT9                      EXTI_FTSR1_FT9_Msk                      /*!< Falling trigger configuration for input line 9 */
#define EXTI_FTSR1_FT10_Pos                 (10U)
#define EXTI_FTSR1_FT10_Msk                 (0x1UL << EXTI_FTSR1_FT10_Pos)          /*!< 0x00000400 */
#define EXTI_FTSR1_FT10                     EXTI_FTSR1_FT10_Msk                     /*!< Falling trigger configuration for input line 10 */
#define EXTI_FTSR1_FT11_Pos                 (11U)
#define EXTI_FTSR1_FT11_Msk                 (0x1UL << EXTI_FTSR1_FT11_Pos)          /*!< 0x00000800 */
#define EXTI_FTSR1_FT11                     EXTI_FTSR1_FT11_Msk                     /*!< Falling trigger configuration for input line 11 */
#define EXTI_FTSR1_FT12_Pos                 (12U)
#define EXTI_FTSR1_FT12_Msk                 (0x1UL << EXTI_FTSR1_FT12_Pos)          /*!< 0x00001000 */
#define EXTI_FTSR1_FT12                     EXTI_FTSR1_FT12_Msk                     /*!< Falling trigger configuration for input line 12 */
#define EXTI_FTSR1_FT13_Pos                 (13U)
#define EXTI_FTSR1_FT13_Msk                 (0x1UL << EXTI_FTSR1_FT13_Pos)          /*!< 0x00002000 */
#define EXTI_FTSR1_FT13                     EXTI_FTSR1_FT13_Msk                     /*!< Falling trigger configuration for input line 13 */
#define EXTI_FTSR1_FT14_Pos                 (14U)
#define EXTI_FTSR1_FT14_Msk                 (0x1UL << EXTI_FTSR1_FT14_Pos)          /*!< 0x00004000 */
#define EXTI_FTSR1_FT14                     EXTI_FTSR1_FT14_Msk                     /*!< Falling trigger configuration for input line 14 */
#define EXTI_FTSR1_FT15_Pos                 (15U)
#define EXTI_FTSR1_FT15_Msk                 (0x1UL << EXTI_FTSR1_FT15_Pos)          /*!< 0x00008000 */
#define EXTI_FTSR1_FT15                     EXTI_FTSR1_FT15_Msk                     /*!< Falling trigger configuration for input line 15 */
#define EXTI_FTSR1_FT16_Pos                 (16U)
#define EXTI_FTSR1_FT16_Msk                 (0x1UL << EXTI_FTSR1_FT16_Pos)          /*!< 0x00010000 */
#define EXTI_FTSR1_FT16                     EXTI_FTSR1_FT16_Msk                     /*!< Falling trigger configuration for input line 16 */

/******************  Bit definition for EXTI_SWIER1 register  *****************/
#define EXTI_SWIER1_SWI0_Pos                (0U)
#define EXTI_SWIER1_SWI0_Msk                (0x1UL << EXTI_SWIER1_SWI0_Pos)         /*!< 0x00000001 */
#define EXTI_SWIER1_SWI0                    EXTI_SWIER1_SWI0_Msk                    /*!< Software Interrupt on line 0 */
#define EXTI_SWIER1_SWI1_Pos                (1U)
#define EXTI_SWIER1_SWI1_Msk                (0x1UL << EXTI_SWIER1_SWI1_Pos)         /*!< 0x00000002 */
#define EXTI_SWIER1_SWI1                    EXTI_SWIER1_SWI1_Msk                    /*!< Software Interrupt on line 1 */
#define EXTI_SWIER1_SWI2_Pos                (2U)
#define EXTI_SWIER1_SWI2_Msk                (0x1UL << EXTI_SWIER1_SWI2_Pos)         /*!< 0x00000004 */
#define EXTI_SWIER1_SWI2                    EXTI_SWIER1_SWI2_Msk                    /*!< Software Interrupt on line 2 */
#define EXTI_SWIER1_SWI3_Pos                (3U)
#define EXTI_SWIER1_SWI3_Msk                (0x1UL << EXTI_SWIER1_SWI3_Pos)         /*!< 0x00000008 */
#define EXTI_SWIER1_SWI3                    EXTI_SWIER1_SWI3_Msk                    /*!< Software Interrupt on line 3 */
#define EXTI_SWIER1_SWI4_Pos                (4U)
#define EXTI_SWIER1_SWI4_Msk                (0x1UL << EXTI_SWIER1_SWI4_Pos)         /*!< 0x00000010 */
#define EXTI_SWIER1_SWI4                    EXTI_SWIER1_SWI4_Msk                    /*!< Software Interrupt on line 4 */
#define EXTI_SWIER1_SWI5_Pos                (5U)
#define EXTI_SWIER1_SWI5_Msk                (0x1UL << EXTI_SWIER1_SWI5_Pos)         /*!< 0x00000020 */
#define EXTI_SWIER1_SWI5                    EXTI_SWIER1_SWI5_Msk                    /*!< Software Interrupt on line 5 */
#define EXTI_SWIER1_SWI6_Pos                (6U)
#define EXTI_SWIER1_SWI6_Msk                (0x1UL << EXTI_SWIER1_SWI6_Pos)         /*!< 0x00000040 */
#define EXTI_SWIER1_SWI6                    EXTI_SWIER1_SWI6_Msk                    /*!< Software Interrupt on line 6 */
#define EXTI_SWIER1_SWI7_Pos                (7U)
#define EXTI_SWIER1_SWI7_Msk                (0x1UL << EXTI_SWIER1_SWI7_Pos)         /*!< 0x00000080 */
#define EXTI_SWIER1_SWI7                    EXTI_SWIER1_SWI7_Msk                    /*!< Software Interrupt on line 7 */
#define EXTI_SWIER1_SWI8_Pos                (8U)
#define EXTI_SWIER1_SWI8_Msk                (0x1UL << EXTI_SWIER1_SWI8_Pos)         /*!< 0x00000100 */
#define EXTI_SWIER1_SWI8                    EXTI_SWIER1_SWI8_Msk                    /*!< Software Interrupt on line 8 */
#define EXTI_SWIER1_SWI9_Pos                (9U)
#define EXTI_SWIER1_SWI9_Msk                (0x1UL << EXTI_SWIER1_SWI9_Pos)         /*!< 0x00000200 */
#define EXTI_SWIER1_SWI9                    EXTI_SWIER1_SWI9_Msk                    /*!< Software Interrupt on line 9 */
#define EXTI_SWIER1_SWI10_Pos               (10U)
#define EXTI_SWIER1_SWI10_Msk               (0x1UL << EXTI_SWIER1_SWI10_Pos)        /*!< 0x00000400 */
#define EXTI_SWIER1_SWI10                   EXTI_SWIER1_SWI10_Msk                   /*!< Software Interrupt on line 10 */
#define EXTI_SWIER1_SWI11_Pos               (11U)
#define EXTI_SWIER1_SWI11_Msk               (0x1UL << EXTI_SWIER1_SWI11_Pos)        /*!< 0x00000800 */
#define EXTI_SWIER1_SWI11                   EXTI_SWIER1_SWI11_Msk                   /*!< Software Interrupt on line 11 */
#define EXTI_SWIER1_SWI12_Pos               (12U)
#define EXTI_SWIER1_SWI12_Msk               (0x1UL << EXTI_SWIER1_SWI12_Pos)        /*!< 0x00001000 */
#define EXTI_SWIER1_SWI12                   EXTI_SWIER1_SWI12_Msk                   /*!< Software Interrupt on line 12 */
#define EXTI_SWIER1_SWI13_Pos               (13U)
#define EXTI_SWIER1_SWI13_Msk               (0x1UL << EXTI_SWIER1_SWI13_Pos)        /*!< 0x00002000 */
#define EXTI_SWIER1_SWI13                   EXTI_SWIER1_SWI13_Msk                   /*!< Software Interrupt on line 13 */
#define EXTI_SWIER1_SWI14_Pos               (14U)
#define EXTI_SWIER1_SWI14_Msk               (0x1UL << EXTI_SWIER1_SWI14_Pos)        /*!< 0x00004000 */
#define EXTI_SWIER1_SWI14                   EXTI_SWIER1_SWI14_Msk                   /*!< Software Interrupt on line 14 */
#define EXTI_SWIER1_SWI15_Pos               (15U)
#define EXTI_SWIER1_SWI15_Msk               (0x1UL << EXTI_SWIER1_SWI15_Pos)        /*!< 0x00008000 */
#define EXTI_SWIER1_SWI15                   EXTI_SWIER1_SWI15_Msk                   /*!< Software Interrupt on line 15 */
#define EXTI_SWIER1_SWI16_Pos               (16U)
#define EXTI_SWIER1_SWI16_Msk               (0x1UL << EXTI_SWIER1_SWI16_Pos)        /*!< 0x00010000 */
#define EXTI_SWIER1_SWI16                   EXTI_SWIER1_SWI16_Msk                   /*!< Software Interrupt on line 16 */


/*******************  Bit definition for EXTI_RPR1 register  ******************/
#define EXTI_RPR1_RPIF0_Pos                 (0U)
#define EXTI_RPR1_RPIF0_Msk                 (0x1UL << EXTI_RPR1_RPIF0_Pos)          /*!< 0x00000001 */
#define EXTI_RPR1_RPIF0                     EXTI_RPR1_RPIF0_Msk                     /*!< Rising Pending Interrupt Flag on line 0 */
#define EXTI_RPR1_RPIF1_Pos                 (1U)
#define EXTI_RPR1_RPIF1_Msk                 (0x1UL << EXTI_RPR1_RPIF1_Pos)          /*!< 0x00000002 */
#define EXTI_RPR1_RPIF1                     EXTI_RPR1_RPIF1_Msk                     /*!< Rising Pending Interrupt Flag on line 1 */
#define EXTI_RPR1_RPIF2_Pos                 (2U)
#define EXTI_RPR1_RPIF2_Msk                 (0x1UL << EXTI_RPR1_RPIF2_Pos)          /*!< 0x00000004 */
#define EXTI_RPR1_RPIF2                     EXTI_RPR1_RPIF2_Msk                     /*!< Rising Pending Interrupt Flag on line 2 */
#define EXTI_RPR1_RPIF3_Pos                 (3U)
#define EXTI_RPR1_RPIF3_Msk                 (0x1UL << EXTI_RPR1_RPIF3_Pos)          /*!< 0x00000008 */
#define EXTI_RPR1_RPIF3                     EXTI_RPR1_RPIF3_Msk                     /*!< Rising Pending Interrupt Flag on line 3 */
#define EXTI_RPR1_RPIF4_Pos                 (4U)
#define EXTI_RPR1_RPIF4_Msk                 (0x1UL << EXTI_RPR1_RPIF4_Pos)          /*!< 0x00000010 */
#define EXTI_RPR1_RPIF4                     EXTI_RPR1_RPIF4_Msk                     /*!< Rising Pending Interrupt Flag on line 4 */
#define EXTI_RPR1_RPIF5_Pos                 (5U)
#define EXTI_RPR1_RPIF5_Msk                 (0x1UL << EXTI_RPR1_RPIF5_Pos)          /*!< 0x00000020 */
#define EXTI_RPR1_RPIF5                     EXTI_RPR1_RPIF5_Msk                     /*!< Rising Pending Interrupt Flag on line 5 */
#define EXTI_RPR1_RPIF6_Pos                 (6U)
#define EXTI_RPR1_RPIF6_Msk                 (0x1UL << EXTI_RPR1_RPIF6_Pos)          /*!< 0x00000040 */
#define EXTI_RPR1_RPIF6                     EXTI_RPR1_RPIF6_Msk                     /*!< Rising Pending Interrupt Flag on line 6 */
#define EXTI_RPR1_RPIF7_Pos                 (7U)
#define EXTI_RPR1_RPIF7_Msk                 (0x1UL << EXTI_RPR1_RPIF7_Pos)          /*!< 0x00000080 */
#define EXTI_RPR1_RPIF7                     EXTI_RPR1_RPIF7_Msk                     /*!< Rising Pending Interrupt Flag on line 7 */
#define EXTI_RPR1_RPIF8_Pos                 (8U)
#define EXTI_RPR1_RPIF8_Msk                 (0x1UL << EXTI_RPR1_RPIF8_Pos)          /*!< 0x00000100 */
#define EXTI_RPR1_RPIF8                     EXTI_RPR1_RPIF8_Msk                     /*!< Rising Pending Interrupt Flag on line 8 */
#define EXTI_RPR1_RPIF9_Pos                 (9U)
#define EXTI_RPR1_RPIF9_Msk                 (0x1UL << EXTI_RPR1_RPIF9_Pos)          /*!< 0x00000200 */
#define EXTI_RPR1_RPIF9                     EXTI_RPR1_RPIF9_Msk                     /*!< Rising Pending Interrupt Flag on line 9 */
#define EXTI_RPR1_RPIF10_Pos                (10U)
#define EXTI_RPR1_RPIF10_Msk                (0x1UL << EXTI_RPR1_RPIF10_Pos)         /*!< 0x00000400 */
#define EXTI_RPR1_RPIF10                    EXTI_RPR1_RPIF10_Msk                    /*!< Rising Pending Interrupt Flag on line 10 */
#define EXTI_RPR1_RPIF11_Pos                (11U)
#define EXTI_RPR1_RPIF11_Msk                (0x1UL << EXTI_RPR1_RPIF11_Pos)         /*!< 0x00000800 */
#define EXTI_RPR1_RPIF11                    EXTI_RPR1_RPIF11_Msk                    /*!< Rising Pending Interrupt Flag on line 11 */
#define EXTI_RPR1_RPIF12_Pos                (12U)
#define EXTI_RPR1_RPIF12_Msk                (0x1UL << EXTI_RPR1_RPIF12_Pos)         /*!< 0x00001000 */
#define EXTI_RPR1_RPIF12                    EXTI_RPR1_RPIF12_Msk                    /*!< Rising Pending Interrupt Flag on line 12 */
#define EXTI_RPR1_RPIF13_Pos                (13U)
#define EXTI_RPR1_RPIF13_Msk                (0x1UL << EXTI_RPR1_RPIF13_Pos)         /*!< 0x00002000 */
#define EXTI_RPR1_RPIF13                    EXTI_RPR1_RPIF13_Msk                    /*!< Rising Pending Interrupt Flag on line 13 */
#define EXTI_RPR1_RPIF14_Pos                (14U)
#define EXTI_RPR1_RPIF14_Msk                (0x1UL << EXTI_RPR1_RPIF14_Pos)         /*!< 0x00004000 */
#define EXTI_RPR1_RPIF14                    EXTI_RPR1_RPIF14_Msk                    /*!< Rising Pending Interrupt Flag on line 14 */
#define EXTI_RPR1_RPIF15_Pos                (15U)
#define EXTI_RPR1_RPIF15_Msk                (0x1UL << EXTI_RPR1_RPIF15_Pos)         /*!< 0x00008000 */
#define EXTI_RPR1_RPIF15                    EXTI_RPR1_RPIF15_Msk                    /*!< Rising Pending Interrupt Flag on line 15 */
#define EXTI_RPR1_RPIF16_Pos                (16U)
#define EXTI_RPR1_RPIF16_Msk                (0x1UL << EXTI_RPR1_RPIF16_Pos)         /*!< 0x00010000 */
#define EXTI_RPR1_RPIF16                    EXTI_RPR1_RPIF16_Msk                    /*!< Rising Pending Interrupt Flag on line 16 */

/*******************  Bit definition for EXTI_FPR1 register  ******************/
#define EXTI_FPR1_FPIF0_Pos                 (0U)
#define EXTI_FPR1_FPIF0_Msk                 (0x1UL << EXTI_FPR1_FPIF0_Pos)          /*!< 0x00000001 */
#define EXTI_FPR1_FPIF0                     EXTI_FPR1_FPIF0_Msk                     /*!< Falling Pending Interrupt Flag on line 0 */
#define EXTI_FPR1_FPIF1_Pos                 (1U)
#define EXTI_FPR1_FPIF1_Msk                 (0x1UL << EXTI_FPR1_FPIF1_Pos)          /*!< 0x00000002 */
#define EXTI_FPR1_FPIF1                     EXTI_FPR1_FPIF1_Msk                     /*!< Falling Pending Interrupt Flag on line 1 */
#define EXTI_FPR1_FPIF2_Pos                 (2U)
#define EXTI_FPR1_FPIF2_Msk                 (0x1UL << EXTI_FPR1_FPIF2_Pos)          /*!< 0x00000004 */
#define EXTI_FPR1_FPIF2                     EXTI_FPR1_FPIF2_Msk                     /*!< Falling Pending Interrupt Flag on line 2 */
#define EXTI_FPR1_FPIF3_Pos                 (3U)
#define EXTI_FPR1_FPIF3_Msk                 (0x1UL << EXTI_FPR1_FPIF3_Pos)          /*!< 0x00000008 */
#define EXTI_FPR1_FPIF3                     EXTI_FPR1_FPIF3_Msk                     /*!< Falling Pending Interrupt Flag on line 3 */
#define EXTI_FPR1_FPIF4_Pos                 (4U)
#define EXTI_FPR1_FPIF4_Msk                 (0x1UL << EXTI_FPR1_FPIF4_Pos)          /*!< 0x00000010 */
#define EXTI_FPR1_FPIF4                     EXTI_FPR1_FPIF4_Msk                     /*!< Falling Pending Interrupt Flag on line 4 */
#define EXTI_FPR1_FPIF5_Pos                 (5U)
#define EXTI_FPR1_FPIF5_Msk                 (0x1UL << EXTI_FPR1_FPIF5_Pos)          /*!< 0x00000020 */
#define EXTI_FPR1_FPIF5                     EXTI_FPR1_FPIF5_Msk                     /*!< Falling Pending Interrupt Flag on line 5 */
#define EXTI_FPR1_FPIF6_Pos                 (6U)
#define EXTI_FPR1_FPIF6_Msk                 (0x1UL << EXTI_FPR1_FPIF6_Pos)          /*!< 0x00000040 */
#define EXTI_FPR1_FPIF6                     EXTI_FPR1_FPIF6_Msk                     /*!< Falling Pending Interrupt Flag on line 6 */
#define EXTI_FPR1_FPIF7_Pos                 (7U)
#define EXTI_FPR1_FPIF7_Msk                 (0x1UL << EXTI_FPR1_FPIF7_Pos)          /*!< 0x00000080 */
#define EXTI_FPR1_FPIF7                     EXTI_FPR1_FPIF7_Msk                     /*!< Falling Pending Interrupt Flag on line 7 */
#define EXTI_FPR1_FPIF8_Pos                 (8U)
#define EXTI_FPR1_FPIF8_Msk                 (0x1UL << EXTI_FPR1_FPIF8_Pos)          /*!< 0x00000100 */
#define EXTI_FPR1_FPIF8                     EXTI_FPR1_FPIF8_Msk                     /*!< Falling Pending Interrupt Flag on line 8 */
#define EXTI_FPR1_FPIF9_Pos                 (9U)
#define EXTI_FPR1_FPIF9_Msk                 (0x1UL << EXTI_FPR1_FPIF9_Pos)          /*!< 0x00000200 */
#define EXTI_FPR1_FPIF9                     EXTI_FPR1_FPIF9_Msk                     /*!< Falling Pending Interrupt Flag on line 9 */
#define EXTI_FPR1_FPIF10_Pos                (10U)
#define EXTI_FPR1_FPIF10_Msk                (0x1UL << EXTI_FPR1_FPIF10_Pos)         /*!< 0x00000400 */
#define EXTI_FPR1_FPIF10                    EXTI_FPR1_FPIF10_Msk                    /*!< Falling Pending Interrupt Flag on line 10 */
#define EXTI_FPR1_FPIF11_Pos                (11U)
#define EXTI_FPR1_FPIF11_Msk                (0x1UL << EXTI_FPR1_FPIF11_Pos)         /*!< 0x00000800 */
#define EXTI_FPR1_FPIF11                    EXTI_FPR1_FPIF11_Msk                    /*!< Falling Pending Interrupt Flag on line 11 */
#define EXTI_FPR1_FPIF12_Pos                (12U)
#define EXTI_FPR1_FPIF12_Msk                (0x1UL << EXTI_FPR1_FPIF12_Pos)         /*!< 0x00001000 */
#define EXTI_FPR1_FPIF12                    EXTI_FPR1_FPIF12_Msk                    /*!< Falling Pending Interrupt Flag on line 12 */
#define EXTI_FPR1_FPIF13_Pos                (13U)
#define EXTI_FPR1_FPIF13_Msk                (0x1UL << EXTI_FPR1_FPIF13_Pos)         /*!< 0x00002000 */
#define EXTI_FPR1_FPIF13                    EXTI_FPR1_FPIF13_Msk                    /*!< Falling Pending Interrupt Flag on line 13 */
#define EXTI_FPR1_FPIF14_Pos                (14U)
#define EXTI_FPR1_FPIF14_Msk                (0x1UL << EXTI_FPR1_FPIF14_Pos)         /*!< 0x00004000 */
#define EXTI_FPR1_FPIF14                    EXTI_FPR1_FPIF14_Msk                    /*!< Falling Pending Interrupt Flag on line 14 */
#define EXTI_FPR1_FPIF15_Pos                (15U)
#define EXTI_FPR1_FPIF15_Msk                (0x1UL << EXTI_FPR1_FPIF15_Pos)         /*!< 0x00008000 */
#define EXTI_FPR1_FPIF15                    EXTI_FPR1_FPIF15_Msk                    /*!< Falling Pending Interrupt Flag on line 15 */
#define EXTI_FPR1_FPIF16_Pos                (16U)
#define EXTI_FPR1_FPIF16_Msk                (0x1UL << EXTI_FPR1_FPIF16_Pos)         /*!< 0x00010000 */
#define EXTI_FPR1_FPIF16                    EXTI_FPR1_FPIF16_Msk                    /*!< Falling Pending Interrupt Flag on line 16 */

/*******************  Bit definition for EXTI_SECENR1 register  ******************/
#define EXTI_SECENR1_SEC0_Pos              (0U)
#define EXTI_SECENR1_SEC0_Msk              (0x1UL << EXTI_SECENR1_SEC0_Pos)       /*!< 0x00000001 */
#define EXTI_SECENR1_SEC0                  EXTI_SECENR1_SEC0_Msk                  /*!< Security enable on line 0 */
#define EXTI_SECENR1_SEC1_Pos              (1U)
#define EXTI_SECENR1_SEC1_Msk              (0x1UL << EXTI_SECENR1_SEC1_Pos)       /*!< 0x00000002 */
#define EXTI_SECENR1_SEC1                  EXTI_SECENR1_SEC1_Msk                  /*!< Security enable on line 1 */
#define EXTI_SECENR1_SEC2_Pos              (2U)
#define EXTI_SECENR1_SEC2_Msk              (0x1UL << EXTI_SECENR1_SEC2_Pos)       /*!< 0x00000004 */
#define EXTI_SECENR1_SEC2                  EXTI_SECENR1_SEC2_Msk                  /*!< Security enable on line 2 */
#define EXTI_SECENR1_SEC3_Pos              (3U)
#define EXTI_SECENR1_SEC3_Msk              (0x1UL << EXTI_SECENR1_SEC3_Pos)       /*!< 0x00000008 */
#define EXTI_SECENR1_SEC3                  EXTI_SECENR1_SEC3_Msk                  /*!< Security enable on line 3 */
#define EXTI_SECENR1_SEC4_Pos              (4U)
#define EXTI_SECENR1_SEC4_Msk              (0x1UL << EXTI_SECENR1_SEC4_Pos)       /*!< 0x00000010 */
#define EXTI_SECENR1_SEC4                  EXTI_SECENR1_SEC4_Msk                  /*!< Security enable on line 4 */
#define EXTI_SECENR1_SEC5_Pos              (5U)
#define EXTI_SECENR1_SEC5_Msk              (0x1UL << EXTI_SECENR1_SEC5_Pos)       /*!< 0x00000020 */
#define EXTI_SECENR1_SEC5                  EXTI_SECENR1_SEC5_Msk                  /*!< Security enable on line 5 */
#define EXTI_SECENR1_SEC6_Pos              (6U)
#define EXTI_SECENR1_SEC6_Msk              (0x1UL << EXTI_SECENR1_SEC6_Pos)       /*!< 0x00000040 */
#define EXTI_SECENR1_SEC6                  EXTI_SECENR1_SEC6_Msk                  /*!< Security enable on line 6 */
#define EXTI_SECENR1_SEC7_Pos              (7U)
#define EXTI_SECENR1_SEC7_Msk              (0x1UL << EXTI_SECENR1_SEC7_Pos)       /*!< 0x00000080 */
#define EXTI_SECENR1_SEC7                  EXTI_SECENR1_SEC7_Msk                  /*!< Security enable on line 7 */
#define EXTI_SECENR1_SEC8_Pos              (8U)
#define EXTI_SECENR1_SEC8_Msk              (0x1UL << EXTI_SECENR1_SEC8_Pos)       /*!< 0x00000100 */
#define EXTI_SECENR1_SEC8                  EXTI_SECENR1_SEC8_Msk                  /*!< Security enable on line 8 */
#define EXTI_SECENR1_SEC9_Pos              (9U)
#define EXTI_SECENR1_SEC9_Msk              (0x1UL << EXTI_SECENR1_SEC9_Pos)       /*!< 0x00000200 */
#define EXTI_SECENR1_SEC9                  EXTI_SECENR1_SEC9_Msk                  /*!< Security enable on line 9 */
#define EXTI_SECENR1_SEC10_Pos             (10U)
#define EXTI_SECENR1_SEC10_Msk             (0x1UL << EXTI_SECENR1_SEC10_Pos)      /*!< 0x00000400 */
#define EXTI_SECENR1_SEC10                 EXTI_SECENR1_SEC10_Msk                 /*!< Security enable on line 10 */
#define EXTI_SECENR1_SEC11_Pos             (11U)
#define EXTI_SECENR1_SEC11_Msk             (0x1UL << EXTI_SECENR1_SEC11_Pos)      /*!< 0x00000800 */
#define EXTI_SECENR1_SEC11                 EXTI_SECENR1_SEC11_Msk                 /*!< Security enable on line 11 */
#define EXTI_SECENR1_SEC12_Pos             (12U)
#define EXTI_SECENR1_SEC12_Msk             (0x1UL << EXTI_SECENR1_SEC12_Pos)      /*!< 0x00001000 */
#define EXTI_SECENR1_SEC12                 EXTI_SECENR1_SEC12_Msk                 /*!< Security enable on line 12 */
#define EXTI_SECENR1_SEC13_Pos             (13U)
#define EXTI_SECENR1_SEC13_Msk             (0x1UL << EXTI_SECENR1_SEC13_Pos)      /*!< 0x00002000 */
#define EXTI_SECENR1_SEC13                 EXTI_SECENR1_SEC13_Msk                 /*!< Security enable on line 13 */
#define EXTI_SECENR1_SEC14_Pos             (14U)
#define EXTI_SECENR1_SEC14_Msk             (0x1UL << EXTI_SECENR1_SEC14_Pos)      /*!< 0x00004000 */
#define EXTI_SECENR1_SEC14                 EXTI_SECENR1_SEC14_Msk                 /*!< Security enable on line 14 */
#define EXTI_SECENR1_SEC15_Pos             (15U)
#define EXTI_SECENR1_SEC15_Msk             (0x1UL << EXTI_SECENR1_SEC15_Pos)      /*!< 0x00008000 */
#define EXTI_SECENR1_SEC15                 EXTI_SECENR1_SEC15_Msk                 /*!< Security enable on line 15 */
#define EXTI_SECENR1_SEC16_Pos             (16U)
#define EXTI_SECENR1_SEC16_Msk             (0x1UL << EXTI_SECENR1_SEC16_Pos)      /*!< 0x00010000 */
#define EXTI_SECENR1_SEC16                 EXTI_SECENR1_SEC16_Msk                 /*!< Security enable on line 16 */
#define EXTI_SECENR1_SEC17_Pos             (17U)
#define EXTI_SECENR1_SEC17_Msk             (0x1UL << EXTI_SECENR1_SEC17_Pos)      /*!< 0x00020000 */
#define EXTI_SECENR1_SEC17                 EXTI_SECENR1_SEC17_Msk                 /*!< Security enable on line 17 */
#define EXTI_SECENR1_SEC18_Pos             (18U)
#define EXTI_SECENR1_SEC18_Msk             (0x1UL << EXTI_SECENR1_SEC18_Pos)      /*!< 0x00040000 */
#define EXTI_SECENR1_SEC18                 EXTI_SECENR1_SEC18_Msk                 /*!< Security enable on line 18 */
#define EXTI_SECENR1_SEC19_Pos             (19U)
#define EXTI_SECENR1_SEC19_Msk             (0x1UL << EXTI_SECENR1_SEC19_Pos)      /*!< 0x00080000 */
#define EXTI_SECENR1_SEC19                 EXTI_SECENR1_SEC19_Msk                 /*!< Security enable on line 19 */
#define EXTI_SECENR1_SEC20_Pos             (20U)
#define EXTI_SECENR1_SEC20_Msk             (0x1UL << EXTI_SECENR1_SEC20_Pos)      /*!< 0x00100000 */
#define EXTI_SECENR1_SEC20                 EXTI_SECENR1_SEC20_Msk                 /*!< Security enable on line 20 */
#define EXTI_SECENR1_SEC21_Pos             (21U)
#define EXTI_SECENR1_SEC21_Msk             (0x1UL << EXTI_SECENR1_SEC21_Pos)      /*!< 0x00200000 */
#define EXTI_SECENR1_SEC21                 EXTI_SECENR1_SEC21_Msk                 /*!< Security enable on line 21 */
#define EXTI_SECENR1_SEC22_Pos             (22U)
#define EXTI_SECENR1_SEC22_Msk             (0x1UL << EXTI_SECENR1_SEC22_Pos)      /*!< 0x00400000 */
#define EXTI_SECENR1_SEC22                 EXTI_SECENR1_SEC22_Msk                 /*!< Security enable on line 22 */
#define EXTI_SECENR1_SEC23_Pos             (23U)
#define EXTI_SECENR1_SEC23_Msk             (0x1UL << EXTI_SECENR1_SEC23_Pos)      /*!< 0x00800000 */
#define EXTI_SECENR1_SEC23                 EXTI_SECENR1_SEC23_Msk                 /*!< Security enable on line 23 */
#define EXTI_SECENR1_SEC24_Pos             (24U)
#define EXTI_SECENR1_SEC24_Msk             (0x1UL << EXTI_SECENR1_SEC24_Pos)      /*!< 0x01000000 */
#define EXTI_SECENR1_SEC24                 EXTI_SECENR1_SEC24_Msk                 /*!< Security enable on line 24 */
#define EXTI_SECENR1_SEC25_Pos             (25U)
#define EXTI_SECENR1_SEC25_Msk             (0x1UL << EXTI_SECENR1_SEC25_Pos)      /*!< 0x02000000 */
#define EXTI_SECENR1_SEC25                 EXTI_SECENR1_SEC25_Msk                 /*!< Security enable on line 25 */
#define EXTI_SECENR1_SEC26_Pos             (26U)
#define EXTI_SECENR1_SEC26_Msk             (0x1UL << EXTI_SECENR1_SEC26_Pos)      /*!< 0x04000000 */
#define EXTI_SECENR1_SEC26                 EXTI_SECENR1_SEC26_Msk                 /*!< Security enable on line 26 */
#define EXTI_SECENR1_SEC27_Pos             (27U)
#define EXTI_SECENR1_SEC27_Msk             (0x1UL << EXTI_SECENR1_SEC27_Pos)      /*!< 0x08000000 */
#define EXTI_SECENR1_SEC27                 EXTI_SECENR1_SEC27_Msk                 /*!< Security enable on line 27 */
#define EXTI_SECENR1_SEC28_Pos             (28U)
#define EXTI_SECENR1_SEC28_Msk             (0x1UL << EXTI_SECENR1_SEC28_Pos)      /*!< 0x10000000 */
#define EXTI_SECENR1_SEC28                 EXTI_SECENR1_SEC28_Msk                 /*!< Security enable on line 28 */
#define EXTI_SECENR1_SEC29_Pos             (29U)
#define EXTI_SECENR1_SEC29_Msk             (0x1UL << EXTI_SECENR1_SEC29_Pos)      /*!< 0x20000000 */
#define EXTI_SECENR1_SEC29                 EXTI_SECENR1_SEC29_Msk                 /*!< Security enable on line 29 */
#define EXTI_SECENR1_SEC30_Pos             (30U)
#define EXTI_SECENR1_SEC30_Msk             (0x1UL << EXTI_SECENR1_SEC30_Pos)      /*!< 0x40000000 */
#define EXTI_SECENR1_SEC30                 EXTI_SECENR1_SEC30_Msk                 /*!< Security enable on line 30 */
#define EXTI_SECENR1_SEC31_Pos             (31U)
#define EXTI_SECENR1_SEC31_Msk             (0x1UL << EXTI_SECENR1_SEC31_Pos)      /*!< 0x80000000 */
#define EXTI_SECENR1_SEC31                 EXTI_SECENR1_SEC31_Msk                 /*!< Security enable on line 31 */


/*******************  Bit definition for EXTI_PRIVENR1 register  ******************/
#define EXTI_PRIVENR1_PRIV0_Pos             (0U)
#define EXTI_PRIVENR1_PRIV0_Msk             (0x1UL << EXTI_PRIVENR1_PRIV0_Pos)      /*!< 0x00000001 */
#define EXTI_PRIVENR1_PRIV0                 EXTI_PRIVENR1_PRIV0_Msk                 /*!< Privilege enable on line 0 */
#define EXTI_PRIVENR1_PRIV1_Pos             (1U)
#define EXTI_PRIVENR1_PRIV1_Msk             (0x1UL << EXTI_PRIVENR1_PRIV1_Pos)      /*!< 0x00000002 */
#define EXTI_PRIVENR1_PRIV1                 EXTI_PRIVENR1_PRIV1_Msk                 /*!< Privilege enable on line 1 */
#define EXTI_PRIVENR1_PRIV2_Pos             (2U)
#define EXTI_PRIVENR1_PRIV2_Msk             (0x1UL << EXTI_PRIVENR1_PRIV2_Pos)      /*!< 0x00000004 */
#define EXTI_PRIVENR1_PRIV2                 EXTI_PRIVENR1_PRIV2_Msk                 /*!< Privilege enable on line 2 */
#define EXTI_PRIVENR1_PRIV3_Pos             (3U)
#define EXTI_PRIVENR1_PRIV3_Msk             (0x1UL << EXTI_PRIVENR1_PRIV3_Pos)      /*!< 0x00000008 */
#define EXTI_PRIVENR1_PRIV3                 EXTI_PRIVENR1_PRIV3_Msk                 /*!< Privilege enable on line 3 */
#define EXTI_PRIVENR1_PRIV4_Pos             (4U)
#define EXTI_PRIVENR1_PRIV4_Msk             (0x1UL << EXTI_PRIVENR1_PRIV4_Pos)      /*!< 0x00000010 */
#define EXTI_PRIVENR1_PRIV4                 EXTI_PRIVENR1_PRIV4_Msk                 /*!< Privilege enable on line 4 */
#define EXTI_PRIVENR1_PRIV5_Pos             (5U)
#define EXTI_PRIVENR1_PRIV5_Msk             (0x1UL << EXTI_PRIVENR1_PRIV5_Pos)      /*!< 0x00000020 */
#define EXTI_PRIVENR1_PRIV5                 EXTI_PRIVENR1_PRIV5_Msk                 /*!< Privilege enable on line 5 */
#define EXTI_PRIVENR1_PRIV6_Pos             (6U)
#define EXTI_PRIVENR1_PRIV6_Msk             (0x1UL << EXTI_PRIVENR1_PRIV6_Pos)      /*!< 0x00000040 */
#define EXTI_PRIVENR1_PRIV6                 EXTI_PRIVENR1_PRIV6_Msk                 /*!< Privilege enable on line 6 */
#define EXTI_PRIVENR1_PRIV7_Pos             (7U)
#define EXTI_PRIVENR1_PRIV7_Msk             (0x1UL << EXTI_PRIVENR1_PRIV7_Pos)      /*!< 0x00000080 */
#define EXTI_PRIVENR1_PRIV7                 EXTI_PRIVENR1_PRIV7_Msk                 /*!< Privilege enable on line 7 */
#define EXTI_PRIVENR1_PRIV8_Pos             (8U)
#define EXTI_PRIVENR1_PRIV8_Msk             (0x1UL << EXTI_PRIVENR1_PRIV8_Pos)      /*!< 0x00000100 */
#define EXTI_PRIVENR1_PRIV8                 EXTI_PRIVENR1_PRIV8_Msk                 /*!< Privilege enable on line 8 */
#define EXTI_PRIVENR1_PRIV9_Pos             (9U)
#define EXTI_PRIVENR1_PRIV9_Msk             (0x1UL << EXTI_PRIVENR1_PRIV9_Pos)      /*!< 0x00000200 */
#define EXTI_PRIVENR1_PRIV9                 EXTI_PRIVENR1_PRIV9_Msk                 /*!< Privilege enable on line 9 */
#define EXTI_PRIVENR1_PRIV10_Pos            (10U)
#define EXTI_PRIVENR1_PRIV10_Msk            (0x1UL << EXTI_PRIVENR1_PRIV10_Pos)     /*!< 0x00000400 */
#define EXTI_PRIVENR1_PRIV10                EXTI_PRIVENR1_PRIV10_Msk                /*!< Privilege enable on line 10 */
#define EXTI_PRIVENR1_PRIV11_Pos            (11U)
#define EXTI_PRIVENR1_PRIV11_Msk            (0x1UL << EXTI_PRIVENR1_PRIV11_Pos)     /*!< 0x00000800 */
#define EXTI_PRIVENR1_PRIV11                EXTI_PRIVENR1_PRIV11_Msk                /*!< Privilege enable on line 11 */
#define EXTI_PRIVENR1_PRIV12_Pos            (12U)
#define EXTI_PRIVENR1_PRIV12_Msk            (0x1UL << EXTI_PRIVENR1_PRIV12_Pos)     /*!< 0x00001000 */
#define EXTI_PRIVENR1_PRIV12                EXTI_PRIVENR1_PRIV12_Msk                /*!< Privilege enable on line 12 */
#define EXTI_PRIVENR1_PRIV13_Pos            (13U)
#define EXTI_PRIVENR1_PRIV13_Msk            (0x1UL << EXTI_PRIVENR1_PRIV13_Pos)     /*!< 0x00002000 */
#define EXTI_PRIVENR1_PRIV13                EXTI_PRIVENR1_PRIV13_Msk                /*!< Privilege enable on line 13 */
#define EXTI_PRIVENR1_PRIV14_Pos            (14U)
#define EXTI_PRIVENR1_PRIV14_Msk            (0x1UL << EXTI_PRIVENR1_PRIV14_Pos)     /*!< 0x00004000 */
#define EXTI_PRIVENR1_PRIV14                EXTI_PRIVENR1_PRIV14_Msk                /*!< Privilege enable on line 14 */
#define EXTI_PRIVENR1_PRIV15_Pos            (15U)
#define EXTI_PRIVENR1_PRIV15_Msk            (0x1UL << EXTI_PRIVENR1_PRIV15_Pos)     /*!< 0x00008000 */
#define EXTI_PRIVENR1_PRIV15                EXTI_PRIVENR1_PRIV15_Msk                /*!< Privilege enable on line 15 */
#define EXTI_PRIVENR1_PRIV16_Pos            (16U)
#define EXTI_PRIVENR1_PRIV16_Msk            (0x1UL << EXTI_PRIVENR1_PRIV16_Pos)     /*!< 0x00010000 */
#define EXTI_PRIVENR1_PRIV16                EXTI_PRIVENR1_PRIV16_Msk                /*!< Privilege enable on line 16 */
#define EXTI_PRIVENR1_PRIV17_Pos            (17U)
#define EXTI_PRIVENR1_PRIV17_Msk            (0x1UL << EXTI_PRIVENR1_PRIV17_Pos)     /*!< 0x00020000 */
#define EXTI_PRIVENR1_PRIV17                EXTI_PRIVENR1_PRIV17_Msk                /*!< Privilege enable on line 17 */
#define EXTI_PRIVENR1_PRIV18_Pos            (18U)
#define EXTI_PRIVENR1_PRIV18_Msk            (0x1UL << EXTI_PRIVENR1_PRIV18_Pos)     /*!< 0x00040000 */
#define EXTI_PRIVENR1_PRIV18                EXTI_PRIVENR1_PRIV18_Msk                /*!< Privilege enable on line 18 */
#define EXTI_PRIVENR1_PRIV19_Pos            (19U)
#define EXTI_PRIVENR1_PRIV19_Msk            (0x1UL << EXTI_PRIVENR1_PRIV19_Pos)     /*!< 0x00080000 */
#define EXTI_PRIVENR1_PRIV19                EXTI_PRIVENR1_PRIV19_Msk                /*!< Privilege enable on line 19 */
#define EXTI_PRIVENR1_PRIV20_Pos            (20U)
#define EXTI_PRIVENR1_PRIV20_Msk            (0x1UL << EXTI_PRIVENR1_PRIV20_Pos)     /*!< 0x00100000 */
#define EXTI_PRIVENR1_PRIV20                EXTI_PRIVENR1_PRIV20_Msk                /*!< Privilege enable on line 20 */
#define EXTI_PRIVENR1_PRIV21_Pos            (21U)
#define EXTI_PRIVENR1_PRIV21_Msk            (0x1UL << EXTI_PRIVENR1_PRIV21_Pos)     /*!< 0x00200000 */
#define EXTI_PRIVENR1_PRIV21                EXTI_PRIVENR1_PRIV21_Msk                /*!< Privilege enable on line 21 */
#define EXTI_PRIVENR1_PRIV22_Pos            (22U)
#define EXTI_PRIVENR1_PRIV22_Msk            (0x1UL << EXTI_PRIVENR1_PRIV22_Pos)     /*!< 0x00400000 */
#define EXTI_PRIVENR1_PRIV22                EXTI_PRIVENR1_PRIV22_Msk                /*!< Privilege enable on line 22 */
#define EXTI_PRIVENR1_PRIV23_Pos            (23U)
#define EXTI_PRIVENR1_PRIV23_Msk            (0x1UL << EXTI_PRIVENR1_PRIV23_Pos)     /*!< 0x00800000 */
#define EXTI_PRIVENR1_PRIV23                EXTI_PRIVENR1_PRIV23_Msk                /*!< Privilege enable on line 23 */
#define EXTI_PRIVENR1_PRIV24_Pos            (24U)
#define EXTI_PRIVENR1_PRIV24_Msk            (0x1UL << EXTI_PRIVENR1_PRIV24_Pos)     /*!< 0x01000000 */
#define EXTI_PRIVENR1_PRIV24                EXTI_PRIVENR1_PRIV24_Msk                /*!< Privilege enable on line 24 */
#define EXTI_PRIVENR1_PRIV25_Pos            (25U)
#define EXTI_PRIVENR1_PRIV25_Msk            (0x1UL << EXTI_PRIVENR1_PRIV25_Pos)      /*!< 0x02000000 */
#define EXTI_PRIVENR1_PRIV25                EXTI_PRIVENR1_PRIV25_Msk                 /*!< Privilege enable on line 25 */
#define EXTI_PRIVENR1_PRIV26_Pos            (26U)
#define EXTI_PRIVENR1_PRIV26_Msk            (0x1UL << EXTI_PRIVENR1_PRIV26_Pos)      /*!< 0x04000000 */
#define EXTI_PRIVENR1_PRIV26                EXTI_PRIVENR1_PRIV26_Msk                 /*!< Privilege enable on line 26 */
#define EXTI_PRIVENR1_PRIV27_Pos            (27U)
#define EXTI_PRIVENR1_PRIV27_Msk            (0x1UL << EXTI_PRIVENR1_PRIV27_Pos)      /*!< 0x08000000 */
#define EXTI_PRIVENR1_PRIV27                EXTI_PRIVENR1_PRIV27_Msk                 /*!< Privilege enable on line 27 */
#define EXTI_PRIVENR1_PRIV28_Pos            (28U)
#define EXTI_PRIVENR1_PRIV28_Msk            (0x1UL << EXTI_PRIVENR1_PRIV28_Pos)      /*!< 0x10000000 */
#define EXTI_PRIVENR1_PRIV28                EXTI_PRIVENR1_PRIV28_Msk                 /*!< Privilege enable on line 28 */
#define EXTI_PRIVENR1_PRIV29_Pos            (29U)
#define EXTI_PRIVENR1_PRIV29_Msk            (0x1UL << EXTI_PRIVENR1_PRIV29_Pos)      /*!< 0x20000000 */
#define EXTI_PRIVENR1_PRIV29                EXTI_PRIVENR1_PRIV29_Msk                 /*!< Privilege enable on line 29 */
#define EXTI_PRIVENR1_PRIV30_Pos            (30U)
#define EXTI_PRIVENR1_PRIV30_Msk            (0x1UL << EXTI_PRIVENR1_PRIV30_Pos)      /*!< 0x40000000 */
#define EXTI_PRIVENR1_PRIV30                EXTI_PRIVENR1_PRIV30_Msk                 /*!< Privilege enable on line 30 */
#define EXTI_PRIVENR1_PRIV31_Pos            (31U)
#define EXTI_PRIVENR1_PRIV31_Msk            (0x1UL << EXTI_PRIVENR1_PRIV31_Pos)      /*!< 0x80000000 */
#define EXTI_PRIVENR1_PRIV31                EXTI_PRIVENR1_PRIV31_Msk                 /*!< Privilege enable on line 31 */

/******************  Bit definition for EXTI_RTSR2 register  *******************/
#define EXTI_RTSR2_RT_Pos                   (12U)
#define EXTI_RTSR2_RT_Msk                   (0x244UL << EXTI_RTSR2_RT_Pos)              /*!< 0x00244000 */
#define EXTI_RTSR2_RT                       EXTI_RTSR2_RT_Msk                           /*!< Rising trigger event configuration bit */
#define EXTI_RTSR2_RT46_Pos                 (14U)
#define EXTI_RTSR2_RT46_Msk                 (0x1UL << EXTI_RTSR2_RT46_Pos)              /*!< 0x00004000 */
#define EXTI_RTSR2_RT46                     EXTI_RTSR2_RT46_Msk                         /*!< Rising trigger event configuration bit of line 46 */
#define EXTI_RTSR2_RT50_Pos                 (18U)
#define EXTI_RTSR2_RT50_Msk                 (0x1UL << EXTI_RTSR2_RT50_Pos)              /*!< 0x00040000 */
#define EXTI_RTSR2_RT50                     EXTI_RTSR2_RT50_Msk                         /*!< Rising trigger event configuration bit of line 50 */
#define EXTI_RTSR2_RT53_Pos                 (21U)
#define EXTI_RTSR2_RT53_Msk                 (0x1UL << EXTI_RTSR2_RT53_Pos)              /*!< 0x00200000 */
#define EXTI_RTSR2_RT53                     EXTI_RTSR2_RT53_Msk                         /*!< Rising trigger event configuration bit of line 53 */

/******************  Bit definition for EXTI_FTSR2 register  *******************/
#define EXTI_FTSR2_FT_Pos                   (12U)
#define EXTI_FTSR2_FT_Msk                   (0x244 << EXTI_FTSR2_FT_Pos)                /*!< 0x00244000 */
#define EXTI_FTSR2_FT                       EXTI_FTSR2_FT_Msk                           /*!< Falling trigger event configuration bit */
#define EXTI_FTSR2_FT46_Pos                 (14U)
#define EXTI_FTSR2_FT46_Msk                 (0x1UL << EXTI_FTSR2_FT46_Pos)              /*!< 0x00004000 */
#define EXTI_FTSR2_FT46                     EXTI_FTSR2_FT46_Msk                         /*!< Falling trigger event configuration bit of line 46 */
#define EXTI_FTSR2_FT50_Pos                 (18U)
#define EXTI_FTSR2_FT50_Msk                 (0x1UL << EXTI_FTSR2_FT50_Pos)              /*!< 0x00040000 */
#define EXTI_FTSR2_FT50                     EXTI_FTSR2_FT50_Msk                         /*!< Falling trigger event configuration bit of line 50 */
#define EXTI_FTSR2_FT53_Pos                 (21U)
#define EXTI_FTSR2_FT53_Msk                 (0x1UL << EXTI_FTSR2_FT53_Pos)              /*!< 0x00200000 */
#define EXTI_FTSR2_FT53                     EXTI_FTSR2_FT53_Msk                         /*!< Falling trigger event configuration bit of line 53 */

/******************  Bit definition for EXTI_SWIER2 register  ******************/
#define EXTI_SWIER2_SWIER46_Pos            (14U)
#define EXTI_SWIER2_SWIER46_Msk            (0x1UL << EXTI_SWIER2_SWIER46_Pos)          /*!< 0x00004000 */
#define EXTI_SWIER2_SWIER46                EXTI_SWIER2_SWIER46_Msk                     /*!< Software Interrupt on line 46 */
#define EXTI_SWIER2_SWIER50_Pos            (18U)
#define EXTI_SWIER2_SWIER50_Msk            (0x1UL << EXTI_SWIER2_SWIER50_Pos)          /*!< 0x00040000 */
#define EXTI_SWIER2_SWIER50                EXTI_SWIER2_SWIER50_Msk                     /*!< Software Interrupt on line 50 */
#define EXTI_SWIER2_SWIER53_Pos            (21U)
#define EXTI_SWIER2_SWIER53_Msk            (0x1UL << EXTI_SWIER2_SWIER53_Pos)          /*!< 0x00200000 */
#define EXTI_SWIER2_SWIER53                EXTI_SWIER2_SWIER53_Msk                     /*!< Software Interrupt on line 53 */

/******************  Bit definition for EXTI_RPR2 register  *******************/
#define EXTI_RPR2_RPIF_Pos                   (12U)
#define EXTI_RPR2_RPIF_Msk                   (0x244UL << EXTI_RPR2_RPIF_Pos)        /*!< 0x00244000 */
#define EXTI_RPR2_RPIF                       EXTI_RPR2_RPIF_Msk                     /*!< Rising pending edge configuration bits */
#define EXTI_RPR2_RPIF46_Pos                 (14U)
#define EXTI_RPR2_RPIF46_Msk                 (0x1UL << EXTI_RPR2_RPIF46_Pos)        /*!< 0x00004000 */
#define EXTI_RPR2_RPIF46                     EXTI_RPR2_RPIF46_Msk                   /*!< Rising pending edge configuration bit of line 46 */
#define EXTI_RPR2_RPIF50_Pos                 (18U)
#define EXTI_RPR2_RPIF50_Msk                 (0x1UL << EXTI_RPR2_RPIF50_Pos)        /*!< 0x00040000 */
#define EXTI_RPR2_RPIF50                     EXTI_RPR2_RPIF50_Msk                   /*!< Rising pending edge configuration bit of line 50 */
#define EXTI_RPR2_RPIF53_Pos                 (21U)
#define EXTI_RPR2_RPIF53_Msk                 (0x1UL << EXTI_RPR2_RPIF53_Pos)        /*!< 0x00200000 */
#define EXTI_RPR2_RPIF53                     EXTI_RPR2_RPIF53_Msk                   /*!< Rising pending edge configuration bit of line 53 */

/******************  Bit definition for EXTI_FPR2 register  *******************/
#define EXTI_FPR2_FPIF_Pos                   (12U)
#define EXTI_FPR2_FPIF_Msk                   (0x244UL << EXTI_FPR2_FPIF_Pos)        /*!< 0x00244000 */
#define EXTI_FPR2_FPIF                       EXTI_FPR2_FPIF_Msk                     /*!< Rising falling edge configuration bits */
#define EXTI_FPR2_FPIF46_Pos                 (14U)
#define EXTI_FPR2_FPIF46_Msk                 (0x1UL << EXTI_FPR2_FPIF46_Pos)        /*!< 0x00004000 */
#define EXTI_FPR2_FPIF46                     EXTI_FPR2_FPIF46_Msk                   /*!< Rising falling edge configuration bit of line 46 */
#define EXTI_FPR2_FPIF50_Pos                 (18U)
#define EXTI_FPR2_FPIF50_Msk                 (0x1UL << EXTI_FPR2_FPIF50_Pos)        /*!< 0x00040000 */
#define EXTI_FPR2_FPIF50                     EXTI_FPR2_FPIF50_Msk                   /*!< Rising falling edge configuration bit of line 50 */
#define EXTI_FPR2_FPIF53_Pos                 (21U)
#define EXTI_FPR2_FPIF53_Msk                 (0x1UL << EXTI_FPR2_FPIF53_Pos)        /*!< 0x00200000 */
#define EXTI_FPR2_FPIF53                     EXTI_FPR2_FPIF53_Msk                   /*!< Rising falling edge configuration bit of line 53 */

/*******************  Bit definition for EXTI_SECENR2 register  ******************/
#define EXTI_SECENR2_SEC32_Pos              (0U)
#define EXTI_SECENR2_SEC32_Msk              (0x1UL << EXTI_SECENR2_SEC32_Pos)       /*!< 0x00000001 */
#define EXTI_SECENR2_SEC32                  EXTI_SECENR2_SEC32_Msk                  /*!< Security enable on line 32 */
#define EXTI_SECENR2_SEC33_Pos              (1U)
#define EXTI_SECENR2_SEC33_Msk              (0x1UL << EXTI_SECENR2_SEC33_Pos)       /*!< 0x00000002 */
#define EXTI_SECENR2_SEC33                  EXTI_SECENR2_SEC33_Msk                  /*!< Security enable on line 33 */
#define EXTI_SECENR2_SEC34_Pos              (2U)
#define EXTI_SECENR2_SEC34_Msk              (0x1UL << EXTI_SECENR2_SEC34_Pos)       /*!< 0x00000004 */
#define EXTI_SECENR2_SEC34                  EXTI_SECENR2_SEC34_Msk                  /*!< Security enable on line 2 */
#define EXTI_SECENR2_SEC35_Pos              (3U)
#define EXTI_SECENR2_SEC35_Msk              (0x1UL << EXTI_SECENR2_SEC35_Pos)       /*!< 0x00000008 */
#define EXTI_SECENR2_SEC35                  EXTI_SECENR2_SEC35_Msk                  /*!< Security enable on line 3 */
#define EXTI_SECENR2_SEC36_Pos              (4U)
#define EXTI_SECENR2_SEC36_Msk              (0x1UL << EXTI_SECENR2_SEC36_Pos)       /*!< 0x00000010 */
#define EXTI_SECENR2_SEC36                  EXTI_SECENR2_SEC36_Msk                  /*!< Security enable on line 4 */
#define EXTI_SECENR2_SEC37_Pos              (5U)
#define EXTI_SECENR2_SEC37_Msk              (0x1UL << EXTI_SECENR2_SEC37_Pos)       /*!< 0x00000020 */
#define EXTI_SECENR2_SEC37                  EXTI_SECENR2_SEC37_Msk                  /*!< Security enable on line 5 */
#define EXTI_SECENR2_SEC38_Pos              (6U)
#define EXTI_SECENR2_SEC38_Msk              (0x1UL << EXTI_SECENR2_SEC38_Pos)       /*!< 0x00000040 */
#define EXTI_SECENR2_SEC38                  EXTI_SECENR2_SEC38_Msk                  /*!< Security enable on line 6 */
#define EXTI_SECENR2_SEC39_Pos              (7U)
#define EXTI_SECENR2_SEC39_Msk              (0x1UL << EXTI_SECENR2_SEC39_Pos)       /*!< 0x00000080 */
#define EXTI_SECENR2_SEC39                  EXTI_SECENR2_SEC39_Msk                  /*!< Security enable on line 7 */
#define EXTI_SECENR2_SEC40_Pos              (8U)
#define EXTI_SECENR2_SEC40_Msk              (0x1UL << EXTI_SECENR2_SEC40_Pos)       /*!< 0x00000100 */
#define EXTI_SECENR2_SEC40                  EXTI_SECENR2_SEC40_Msk                  /*!< Security enable on line 8 */
#define EXTI_SECENR2_SEC41_Pos              (9U)
#define EXTI_SECENR2_SEC41_Msk              (0x1UL << EXTI_SECENR2_SEC41_Pos)       /*!< 0x00000200 */
#define EXTI_SECENR2_SEC41                  EXTI_SECENR2_SEC41_Msk                  /*!< Security enable on line 9 */
#define EXTI_SECENR2_SEC42_Pos             (10U)
#define EXTI_SECENR2_SEC42_Msk             (0x1UL << EXTI_SECENR2_SEC42_Pos)        /*!< 0x00000400 */
#define EXTI_SECENR2_SEC42                 EXTI_SECENR2_SEC42_Msk                   /*!< Security enable on line 10 */
#define EXTI_SECENR2_SEC43_Pos             (11U)
#define EXTI_SECENR2_SEC43_Msk             (0x1UL << EXTI_SECENR2_SEC43_Pos)        /*!< 0x00000800 */
#define EXTI_SECENR2_SEC43                 EXTI_SECENR2_SEC43_Msk                   /*!< Security enable on line 11 */
#define EXTI_SECENR2_SEC44_Pos             (12U)
#define EXTI_SECENR2_SEC44_Msk             (0x1UL << EXTI_SECENR2_SEC44_Pos)        /*!< 0x00001000 */
#define EXTI_SECENR2_SEC44                 EXTI_SECENR2_SEC44_Msk                   /*!< Security enable on line 12 */
#define EXTI_SECENR2_SEC45_Pos             (13U)
#define EXTI_SECENR2_SEC45_Msk             (0x1UL << EXTI_SECENR2_SEC45_Pos)        /*!< 0x00002000 */
#define EXTI_SECENR2_SEC45                 EXTI_SECENR2_SEC45_Msk                   /*!< Security enable on line 13 */
#define EXTI_SECENR2_SEC46_Pos             (14U)
#define EXTI_SECENR2_SEC46_Msk             (0x1UL << EXTI_SECENR2_SEC46_Pos)        /*!< 0x00004000 */
#define EXTI_SECENR2_SEC46                 EXTI_SECENR2_SEC46_Msk                   /*!< Security enable on line 14 */
#define EXTI_SECENR2_SEC47_Pos             (15U)
#define EXTI_SECENR2_SEC47_Msk             (0x1UL << EXTI_SECENR2_SEC47_Pos)        /*!< 0x00008000 */
#define EXTI_SECENR2_SEC47                 EXTI_SECENR2_SEC47_Msk                   /*!< Security enable on line 15 */
#define EXTI_SECENR2_SEC48_Pos             (16U)
#define EXTI_SECENR2_SEC48_Msk             (0x1UL << EXTI_SECENR2_SEC48_Pos)        /*!< 0x00010000 */
#define EXTI_SECENR2_SEC48                 EXTI_SECENR2_SEC48_Msk                   /*!< Security enable on line 16 */
#define EXTI_SECENR2_SEC49_Pos             (17U)
#define EXTI_SECENR2_SEC49_Msk             (0x1UL << EXTI_SECENR2_SEC49_Pos)        /*!< 0x00020000 */
#define EXTI_SECENR2_SEC49                 EXTI_SECENR2_SEC49_Msk                   /*!< Security enable on line 17 */
#define EXTI_SECENR2_SEC50_Pos             (18U)
#define EXTI_SECENR2_SEC50_Msk             (0x1UL << EXTI_SECENR2_SEC50_Pos)        /*!< 0x00040000 */
#define EXTI_SECENR2_SEC50                 EXTI_SECENR2_SEC50_Msk                   /*!< Security enable on line 18 */
#define EXTI_SECENR2_SEC51_Pos             (19U)
#define EXTI_SECENR2_SEC51_Msk             (0x1UL << EXTI_SECENR2_SEC51_Pos)        /*!< 0x00080000 */
#define EXTI_SECENR2_SEC51                 EXTI_SECENR2_SEC51_Msk                   /*!< Security enable on line 19 */
#define EXTI_SECENR2_SEC52_Pos             (20U)
#define EXTI_SECENR2_SEC52_Msk             (0x1UL << EXTI_SECENR2_SEC52_Pos)        /*!< 0x00100000 */
#define EXTI_SECENR2_SEC52                 EXTI_SECENR2_SEC52_Msk                   /*!< Security enable on line 20 */
#define EXTI_SECENR2_SEC53_Pos             (21U)
#define EXTI_SECENR2_SEC53_Msk             (0x1UL << EXTI_SECENR2_SEC53_Pos)        /*!< 0x00200000 */
#define EXTI_SECENR2_SEC53                 EXTI_SECENR2_SEC53_Msk                   /*!< Security enable on line 21 */
#define EXTI_SECENR2_SEC54_Pos             (22U)
#define EXTI_SECENR2_SEC54_Msk             (0x1UL << EXTI_SECENR2_SEC54_Pos)        /*!< 0x00400000 */
#define EXTI_SECENR2_SEC54                 EXTI_SECENR2_SEC54_Msk                   /*!< Security enable on line 22 */
#define EXTI_SECENR2_SEC55_Pos             (23U)
#define EXTI_SECENR2_SEC55_Msk             (0x1UL << EXTI_SECENR2_SEC55_Pos)        /*!< 0x00800000 */
#define EXTI_SECENR2_SEC55                 EXTI_SECENR2_SEC55_Msk                   /*!< Security enable on line 23 */
#define EXTI_SECENR2_SEC56_Pos             (24U)
#define EXTI_SECENR2_SEC56_Msk             (0x1UL << EXTI_SECENR2_SEC56_Pos)        /*!< 0x01000000 */
#define EXTI_SECENR2_SEC56                 EXTI_SECENR2_SEC56_Msk                   /*!< Security enable on line 24 */
#define EXTI_SECENR2_SEC57_Pos             (25U)
#define EXTI_SECENR2_SEC57_Msk             (0x1UL << EXTI_SECENR2_SEC57_Pos)        /*!< 0x02000000 */
#define EXTI_SECENR2_SEC57                 EXTI_SECENR2_SEC57_Msk                   /*!< Security enable on line 25 */

/*******************  Bit definition for EXTI_PRIVENR2 register  ******************/
#define EXTI_PRIVENR2_PRIV32_Pos              (0U)
#define EXTI_PRIVENR2_PRIV32_Msk              (0x1UL << EXTI_PRIVENR2_PRIV32_Pos)       /*!< 0x00000001 */
#define EXTI_PRIVENR2_PRIV32                  EXTI_PRIVENR2_PRIV32_Msk                  /*!< Security enable on line 32 */
#define EXTI_PRIVENR2_PRIV33_Pos              (1U)
#define EXTI_PRIVENR2_PRIV33_Msk              (0x1UL << EXTI_PRIVENR2_PRIV33_Pos)       /*!< 0x00000002 */
#define EXTI_PRIVENR2_PRIV33                  EXTI_PRIVENR2_PRIV33_Msk                  /*!< Security enable on line 33 */
#define EXTI_PRIVENR2_PRIV34_Pos              (2U)
#define EXTI_PRIVENR2_PRIV34_Msk              (0x1UL << EXTI_PRIVENR2_PRIV34_Pos)       /*!< 0x00000004 */
#define EXTI_PRIVENR2_PRIV34                  EXTI_PRIVENR2_PRIV34_Msk                  /*!< Security enable on line 2 */
#define EXTI_PRIVENR2_PRIV35_Pos              (3U)
#define EXTI_PRIVENR2_PRIV35_Msk              (0x1UL << EXTI_PRIVENR2_PRIV35_Pos)       /*!< 0x00000008 */
#define EXTI_PRIVENR2_PRIV35                  EXTI_PRIVENR2_PRIV35_Msk                  /*!< Security enable on line 3 */
#define EXTI_PRIVENR2_PRIV36_Pos              (4U)
#define EXTI_PRIVENR2_PRIV36_Msk              (0x1UL << EXTI_PRIVENR2_PRIV36_Pos)       /*!< 0x00000010 */
#define EXTI_PRIVENR2_PRIV36                  EXTI_PRIVENR2_PRIV36_Msk                  /*!< Security enable on line 4 */
#define EXTI_PRIVENR2_PRIV37_Pos              (5U)
#define EXTI_PRIVENR2_PRIV37_Msk              (0x1UL << EXTI_PRIVENR2_PRIV37_Pos)       /*!< 0x00000020 */
#define EXTI_PRIVENR2_PRIV37                  EXTI_PRIVENR2_PRIV37_Msk                  /*!< Security enable on line 5 */
#define EXTI_PRIVENR2_PRIV38_Pos              (6U)
#define EXTI_PRIVENR2_PRIV38_Msk              (0x1UL << EXTI_PRIVENR2_PRIV38_Pos)       /*!< 0x00000040 */
#define EXTI_PRIVENR2_PRIV38                  EXTI_PRIVENR2_PRIV38_Msk                  /*!< Security enable on line 6 */
#define EXTI_PRIVENR2_PRIV39_Pos              (7U)
#define EXTI_PRIVENR2_PRIV39_Msk              (0x1UL << EXTI_PRIVENR2_PRIV39_Pos)       /*!< 0x00000080 */
#define EXTI_PRIVENR2_PRIV39                  EXTI_PRIVENR2_PRIV39_Msk                  /*!< Security enable on line 7 */
#define EXTI_PRIVENR2_PRIV40_Pos              (8U)
#define EXTI_PRIVENR2_PRIV40_Msk              (0x1UL << EXTI_PRIVENR2_PRIV40_Pos)       /*!< 0x00000100 */
#define EXTI_PRIVENR2_PRIV40                  EXTI_PRIVENR2_PRIV40_Msk                  /*!< Security enable on line 8 */
#define EXTI_PRIVENR2_PRIV41_Pos              (9U)
#define EXTI_PRIVENR2_PRIV41_Msk              (0x1UL << EXTI_PRIVENR2_PRIV41_Pos)       /*!< 0x00000200 */
#define EXTI_PRIVENR2_PRIV41                  EXTI_PRIVENR2_PRIV41_Msk                  /*!< Security enable on line 9 */
#define EXTI_PRIVENR2_PRIV42_Pos             (10U)
#define EXTI_PRIVENR2_PRIV42_Msk             (0x1UL << EXTI_PRIVENR2_PRIV42_Pos)        /*!< 0x00000400 */
#define EXTI_PRIVENR2_PRIV42                 EXTI_PRIVENR2_PRIV42_Msk                   /*!< Security enable on line 10 */
#define EXTI_PRIVENR2_PRIV43_Pos             (11U)
#define EXTI_PRIVENR2_PRIV43_Msk             (0x1UL << EXTI_PRIVENR2_PRIV43_Pos)        /*!< 0x00000800 */
#define EXTI_PRIVENR2_PRIV43                 EXTI_PRIVENR2_PRIV43_Msk                   /*!< Security enable on line 11 */
#define EXTI_PRIVENR2_PRIV44_Pos             (12U)
#define EXTI_PRIVENR2_PRIV44_Msk             (0x1UL << EXTI_PRIVENR2_PRIV44_Pos)        /*!< 0x00001000 */
#define EXTI_PRIVENR2_PRIV44                 EXTI_PRIVENR2_PRIV44_Msk                   /*!< Security enable on line 12 */
#define EXTI_PRIVENR2_PRIV45_Pos             (13U)
#define EXTI_PRIVENR2_PRIV45_Msk             (0x1UL << EXTI_PRIVENR2_PRIV45_Pos)        /*!< 0x00002000 */
#define EXTI_PRIVENR2_PRIV45                 EXTI_PRIVENR2_PRIV45_Msk                   /*!< Security enable on line 13 */
#define EXTI_PRIVENR2_PRIV46_Pos             (14U)
#define EXTI_PRIVENR2_PRIV46_Msk             (0x1UL << EXTI_PRIVENR2_PRIV46_Pos)        /*!< 0x00004000 */
#define EXTI_PRIVENR2_PRIV46                 EXTI_PRIVENR2_PRIV46_Msk                   /*!< Security enable on line 14 */
#define EXTI_PRIVENR2_PRIV47_Pos             (15U)
#define EXTI_PRIVENR2_PRIV47_Msk             (0x1UL << EXTI_PRIVENR2_PRIV47_Pos)        /*!< 0x00008000 */
#define EXTI_PRIVENR2_PRIV47                 EXTI_PRIVENR2_PRIV47_Msk                   /*!< Security enable on line 15 */
#define EXTI_PRIVENR2_PRIV48_Pos             (16U)
#define EXTI_PRIVENR2_PRIV48_Msk             (0x1UL << EXTI_PRIVENR2_PRIV48_Pos)        /*!< 0x00010000 */
#define EXTI_PRIVENR2_PRIV48                 EXTI_PRIVENR2_PRIV48_Msk                   /*!< Security enable on line 16 */
#define EXTI_PRIVENR2_PRIV49_Pos             (17U)
#define EXTI_PRIVENR2_PRIV49_Msk             (0x1UL << EXTI_PRIVENR2_PRIV49_Pos)        /*!< 0x00020000 */
#define EXTI_PRIVENR2_PRIV49                 EXTI_PRIVENR2_PRIV49_Msk                   /*!< Security enable on line 17 */
#define EXTI_PRIVENR2_PRIV50_Pos             (18U)
#define EXTI_PRIVENR2_PRIV50_Msk             (0x1UL << EXTI_PRIVENR2_PRIV50_Pos)        /*!< 0x00040000 */
#define EXTI_PRIVENR2_PRIV50                 EXTI_PRIVENR2_PRIV50_Msk                   /*!< Security enable on line 18 */
#define EXTI_PRIVENR2_PRIV51_Pos             (19U)
#define EXTI_PRIVENR2_PRIV51_Msk             (0x1UL << EXTI_PRIVENR2_PRIV51_Pos)        /*!< 0x00080000 */
#define EXTI_PRIVENR2_PRIV51                 EXTI_PRIVENR2_PRIV51_Msk                   /*!< Security enable on line 19 */
#define EXTI_PRIVENR2_PRIV52_Pos             (20U)
#define EXTI_PRIVENR2_PRIV52_Msk             (0x1UL << EXTI_PRIVENR2_PRIV52_Pos)        /*!< 0x00100000 */
#define EXTI_PRIVENR2_PRIV52                 EXTI_PRIVENR2_PRIV52_Msk                   /*!< Security enable on line 20 */
#define EXTI_PRIVENR2_PRIV53_Pos             (21U)
#define EXTI_PRIVENR2_PRIV53_Msk             (0x1UL << EXTI_PRIVENR2_PRIV53_Pos)        /*!< 0x00200000 */
#define EXTI_PRIVENR2_PRIV53                 EXTI_PRIVENR2_PRIV53_Msk                   /*!< Security enable on line 21 */
#define EXTI_PRIVENR2_PRIV54_Pos             (22U)
#define EXTI_PRIVENR2_PRIV54_Msk             (0x1UL << EXTI_PRIVENR2_PRIV54_Pos)        /*!< 0x00400000 */
#define EXTI_PRIVENR2_PRIV54                 EXTI_PRIVENR2_PRIV54_Msk                   /*!< Security enable on line 22 */
#define EXTI_PRIVENR2_PRIV55_Pos             (23U)
#define EXTI_PRIVENR2_PRIV55_Msk             (0x1UL << EXTI_PRIVENR2_PRIV55_Pos)        /*!< 0x00800000 */
#define EXTI_PRIVENR2_PRIV55                 EXTI_PRIVENR2_PRIV55_Msk                   /*!< Security enable on line 23 */
#define EXTI_PRIVENR2_PRIV56_Pos             (24U)
#define EXTI_PRIVENR2_PRIV56_Msk             (0x1UL << EXTI_PRIVENR2_PRIV56_Pos)        /*!< 0x01000000 */
#define EXTI_PRIVENR2_PRIV56                 EXTI_PRIVENR2_PRIV56_Msk                   /*!< Security enable on line 24 */
#define EXTI_PRIVENR2_PRIV57_Pos             (25U)
#define EXTI_PRIVENR2_PRIV57_Msk             (0x1UL << EXTI_PRIVENR2_PRIV57_Pos)        /*!< 0x02000000 */
#define EXTI_PRIVENR2_PRIV57                 EXTI_PRIVENR2_PRIV57_Msk                   /*!< Security enable on line 25 */

/*****************  Bit definition for EXTI_EXTICR1 register  **************/
#define EXTI_EXTICR1_EXTI0_Pos              (0U)
#define EXTI_EXTICR1_EXTI0_Msk              (0xFUL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR1_EXTI0                  EXTI_EXTICR1_EXTI0_Msk                  /*!< EXTI 0 configuration */
#define EXTI_EXTICR1_EXTI0_0                (0x1UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR1_EXTI0_1                (0x2UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR1_EXTI0_2                (0x4UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR1_EXTI0_3                (0x8UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR1_EXTI1_Pos              (8U)
#define EXTI_EXTICR1_EXTI1_Msk              (0xFUL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR1_EXTI1                  EXTI_EXTICR1_EXTI1_Msk                  /*!< EXTI 1 configuration */
#define EXTI_EXTICR1_EXTI1_0                (0x1UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR1_EXTI1_1                (0x2UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR1_EXTI1_2                (0x4UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR1_EXTI1_3                (0x8UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR1_EXTI2_Pos              (16U)
#define EXTI_EXTICR1_EXTI2_Msk              (0xFUL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00070000 */
#define EXTI_EXTICR1_EXTI2                  EXTI_EXTICR1_EXTI2_Msk                  /*!< EXTI 2 configuration */
#define EXTI_EXTICR1_EXTI2_0                (0x1UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR1_EXTI2_1                (0x2UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR1_EXTI2_2                (0x4UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR1_EXTI2_3                (0x8UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR1_EXTI3_Pos              (24U)
#define EXTI_EXTICR1_EXTI3_Msk              (0xFUL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x07000000 */
#define EXTI_EXTICR1_EXTI3                  EXTI_EXTICR1_EXTI3_Msk                  /*!< EXTI 3 configuration */
#define EXTI_EXTICR1_EXTI3_0                (0x1UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR1_EXTI3_1                (0x2UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR1_EXTI3_2                (0x4UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR1_EXTI3_3                (0x8UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR2 register  **************/
#define EXTI_EXTICR2_EXTI4_Pos              (0U)
#define EXTI_EXTICR2_EXTI4_Msk              (0xFUL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR2_EXTI4                  EXTI_EXTICR2_EXTI4_Msk                  /*!< EXTI 4 configuration */
#define EXTI_EXTICR2_EXTI4_0                (0x1UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR2_EXTI4_1                (0x2UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR2_EXTI4_2                (0x4UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR2_EXTI4_3                (0x8UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR2_EXTI5_Pos              (8U)
#define EXTI_EXTICR2_EXTI5_Msk              (0xFUL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR2_EXTI5                  EXTI_EXTICR2_EXTI5_Msk                  /*!< EXTI 5 configuration */
#define EXTI_EXTICR2_EXTI5_0                (0x1UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR2_EXTI5_1                (0x2UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR2_EXTI5_2                (0x4UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR2_EXTI5_3                (0x8UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR2_EXTI6_Pos              (16U)
#define EXTI_EXTICR2_EXTI6_Msk              (0xFUL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00070000 */
#define EXTI_EXTICR2_EXTI6                  EXTI_EXTICR2_EXTI6_Msk                  /*!< EXTI 6 configuration */
#define EXTI_EXTICR2_EXTI6_0                (0x1UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR2_EXTI6_1                (0x2UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR2_EXTI6_2                (0x4UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR2_EXTI6_3                (0x8UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR2_EXTI7_Pos              (24U)
#define EXTI_EXTICR2_EXTI7_Msk              (0xFUL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x07000000 */
#define EXTI_EXTICR2_EXTI7                  EXTI_EXTICR2_EXTI7_Msk                  /*!< EXTI 7 configuration */
#define EXTI_EXTICR2_EXTI7_0                (0x1UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR2_EXTI7_1                (0x2UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR2_EXTI7_2                (0x4UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR2_EXTI7_3                (0x8UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR3 register  **************/
#define EXTI_EXTICR3_EXTI8_Pos              (0U)
#define EXTI_EXTICR3_EXTI8_Msk              (0xFUL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR3_EXTI8                  EXTI_EXTICR3_EXTI8_Msk                  /*!< EXTI 8 configuration */
#define EXTI_EXTICR3_EXTI8_0                (0x1UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR3_EXTI8_1                (0x2UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR3_EXTI8_2                (0x4UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR3_EXTI8_3                (0x8UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR3_EXTI9_Pos              (8U)
#define EXTI_EXTICR3_EXTI9_Msk              (0xFUL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR3_EXTI9                  EXTI_EXTICR3_EXTI9_Msk                  /*!< EXTI 9 configuration */
#define EXTI_EXTICR3_EXTI9_0                (0x1UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR3_EXTI9_1                (0x2UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR3_EXTI9_2                (0x4UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR3_EXTI9_3                (0x8UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR3_EXTI10_Pos             (16U)
#define EXTI_EXTICR3_EXTI10_Msk             (0xFUL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00070000 */
#define EXTI_EXTICR3_EXTI10                 EXTI_EXTICR3_EXTI10_Msk                 /*!< EXTI 10 configuration */
#define EXTI_EXTICR3_EXTI10_0               (0x1UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00010000 */
#define EXTI_EXTICR3_EXTI10_1               (0x2UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00020000 */
#define EXTI_EXTICR3_EXTI10_2               (0x4UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00040000 */
#define EXTI_EXTICR3_EXTI10_3               (0x8UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00080000 */
#define EXTI_EXTICR3_EXTI11_Pos             (24U)
#define EXTI_EXTICR3_EXTI11_Msk             (0xFUL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x07000000 */
#define EXTI_EXTICR3_EXTI11                 EXTI_EXTICR3_EXTI11_Msk                 /*!< EXTI 11 configuration */
#define EXTI_EXTICR3_EXTI11_0               (0x1UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x01000000 */
#define EXTI_EXTICR3_EXTI11_1               (0x2UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x02000000 */
#define EXTI_EXTICR3_EXTI11_2               (0x4UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x04000000 */
#define EXTI_EXTICR3_EXTI11_3               (0x8UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR4 register  **************/
#define EXTI_EXTICR4_EXTI12_Pos             (0U)
#define EXTI_EXTICR4_EXTI12_Msk             (0xFUL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000007 */
#define EXTI_EXTICR4_EXTI12                 EXTI_EXTICR4_EXTI12_Msk                 /*!< EXTI 12 configuration */
#define EXTI_EXTICR4_EXTI12_0               (0x1UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000001 */
#define EXTI_EXTICR4_EXTI12_1               (0x2UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000002 */
#define EXTI_EXTICR4_EXTI12_2               (0x4UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000004 */
#define EXTI_EXTICR4_EXTI12_3               (0x8UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000008 */
#define EXTI_EXTICR4_EXTI13_Pos             (8U)
#define EXTI_EXTICR4_EXTI13_Msk             (0xFUL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000700 */
#define EXTI_EXTICR4_EXTI13                 EXTI_EXTICR4_EXTI13_Msk                 /*!< EXTI 13 configuration */
#define EXTI_EXTICR4_EXTI13_0               (0x1UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000100 */
#define EXTI_EXTICR4_EXTI13_1               (0x2UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000200 */
#define EXTI_EXTICR4_EXTI13_2               (0x4UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000400 */
#define EXTI_EXTICR4_EXTI13_3               (0x8UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000800 */
#define EXTI_EXTICR4_EXTI14_Pos             (16U)
#define EXTI_EXTICR4_EXTI14_Msk             (0xFUL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00070000 */
#define EXTI_EXTICR4_EXTI14                 EXTI_EXTICR4_EXTI14_Msk                 /*!< EXTI 14 configuration */
#define EXTI_EXTICR4_EXTI14_0               (0x1UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00010000 */
#define EXTI_EXTICR4_EXTI14_1               (0x2UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00020000 */
#define EXTI_EXTICR4_EXTI14_2               (0x4UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00040000 */
#define EXTI_EXTICR4_EXTI14_3               (0x8UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00080000 */
#define EXTI_EXTICR4_EXTI15_Pos             (24U)
#define EXTI_EXTICR4_EXTI15_Msk             (0xFUL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x07000000 */
#define EXTI_EXTICR4_EXTI15                 EXTI_EXTICR4_EXTI15_Msk                 /*!< EXTI 15 configuration */
#define EXTI_EXTICR4_EXTI15_0               (0x1UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x01000000 */
#define EXTI_EXTICR4_EXTI15_1               (0x2UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x02000000 */
#define EXTI_EXTICR4_EXTI15_2               (0x4UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x04000000 */
#define EXTI_EXTICR4_EXTI15_3               (0x8UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x08000000 */

/*******************  Bit definition for EXTI_LOCKR register  ******************/
#define EXTI_LOCKR_LOCK_Pos                 (0U)
#define EXTI_LOCKR_LOCK_Msk                 (0x1UL << EXTI_LOCKR_LOCK_Pos)          /*!< 0x00000001 */
#define EXTI_LOCKR_LOCK                     EXTI_LOCKR_LOCK_Msk                     /*!< Lock Mask  */

/*******************  Bit definition for EXTI_IMR1 register  ******************/
#define EXTI_IMR1_IM_Pos                    (0U)
#define EXTI_IMR1_IM_Msk                    (0xFFFFFFFFUL << EXTI_IMR1_IM_Pos)      /*!< 0xFFFFFFFF */
#define EXTI_IMR1_IM                        EXTI_IMR1_IM_Msk                        /*!< Interrupt Mask */
#define EXTI_IMR1_IM0_Pos                   (0U)
#define EXTI_IMR1_IM0_Msk                   (0x1UL << EXTI_IMR1_IM0_Pos)            /*!< 0x00000001 */
#define EXTI_IMR1_IM0                       EXTI_IMR1_IM0_Msk                       /*!< Interrupt Mask on line 0 */
#define EXTI_IMR1_IM1_Pos                   (1U)
#define EXTI_IMR1_IM1_Msk                   (0x1UL << EXTI_IMR1_IM1_Pos)            /*!< 0x00000002 */
#define EXTI_IMR1_IM1                       EXTI_IMR1_IM1_Msk                       /*!< Interrupt Mask on line 1 */
#define EXTI_IMR1_IM2_Pos                   (2U)
#define EXTI_IMR1_IM2_Msk                   (0x1UL << EXTI_IMR1_IM2_Pos)            /*!< 0x00000004 */
#define EXTI_IMR1_IM2                       EXTI_IMR1_IM2_Msk                       /*!< Interrupt Mask on line 2 */
#define EXTI_IMR1_IM3_Pos                   (3U)
#define EXTI_IMR1_IM3_Msk                   (0x1UL << EXTI_IMR1_IM3_Pos)            /*!< 0x00000008 */
#define EXTI_IMR1_IM3                       EXTI_IMR1_IM3_Msk                       /*!< Interrupt Mask on line 3 */
#define EXTI_IMR1_IM4_Pos                   (4U)
#define EXTI_IMR1_IM4_Msk                   (0x1UL << EXTI_IMR1_IM4_Pos)            /*!< 0x00000010 */
#define EXTI_IMR1_IM4                       EXTI_IMR1_IM4_Msk                       /*!< Interrupt Mask on line 4 */
#define EXTI_IMR1_IM5_Pos                   (5U)
#define EXTI_IMR1_IM5_Msk                   (0x1UL << EXTI_IMR1_IM5_Pos)            /*!< 0x00000020 */
#define EXTI_IMR1_IM5                       EXTI_IMR1_IM5_Msk                       /*!< Interrupt Mask on line 5 */
#define EXTI_IMR1_IM6_Pos                   (6U)
#define EXTI_IMR1_IM6_Msk                   (0x1UL << EXTI_IMR1_IM6_Pos)            /*!< 0x00000040 */
#define EXTI_IMR1_IM6                       EXTI_IMR1_IM6_Msk                       /*!< Interrupt Mask on line 6 */
#define EXTI_IMR1_IM7_Pos                   (7U)
#define EXTI_IMR1_IM7_Msk                   (0x1UL << EXTI_IMR1_IM7_Pos)            /*!< 0x00000080 */
#define EXTI_IMR1_IM7                       EXTI_IMR1_IM7_Msk                       /*!< Interrupt Mask on line 7 */
#define EXTI_IMR1_IM8_Pos                   (8U)
#define EXTI_IMR1_IM8_Msk                   (0x1UL << EXTI_IMR1_IM8_Pos)            /*!< 0x00000100 */
#define EXTI_IMR1_IM8                       EXTI_IMR1_IM8_Msk                       /*!< Interrupt Mask on line 8 */
#define EXTI_IMR1_IM9_Pos                   (9U)
#define EXTI_IMR1_IM9_Msk                   (0x1UL << EXTI_IMR1_IM9_Pos)            /*!< 0x00000200 */
#define EXTI_IMR1_IM9                       EXTI_IMR1_IM9_Msk                       /*!< Interrupt Mask on line 9 */
#define EXTI_IMR1_IM10_Pos                  (10U)
#define EXTI_IMR1_IM10_Msk                  (0x1UL << EXTI_IMR1_IM10_Pos)           /*!< 0x00000400 */
#define EXTI_IMR1_IM10                      EXTI_IMR1_IM10_Msk                      /*!< Interrupt Mask on line 10 */
#define EXTI_IMR1_IM11_Pos                  (11U)
#define EXTI_IMR1_IM11_Msk                  (0x1UL << EXTI_IMR1_IM11_Pos)           /*!< 0x00000800 */
#define EXTI_IMR1_IM11                      EXTI_IMR1_IM11_Msk                      /*!< Interrupt Mask on line 11 */
#define EXTI_IMR1_IM12_Pos                  (12U)
#define EXTI_IMR1_IM12_Msk                  (0x1UL << EXTI_IMR1_IM12_Pos)           /*!< 0x00001000 */
#define EXTI_IMR1_IM12                      EXTI_IMR1_IM12_Msk                      /*!< Interrupt Mask on line 12 */
#define EXTI_IMR1_IM13_Pos                  (13U)
#define EXTI_IMR1_IM13_Msk                  (0x1UL << EXTI_IMR1_IM13_Pos)           /*!< 0x00002000 */
#define EXTI_IMR1_IM13                      EXTI_IMR1_IM13_Msk                      /*!< Interrupt Mask on line 13 */
#define EXTI_IMR1_IM14_Pos                  (14U)
#define EXTI_IMR1_IM14_Msk                  (0x1UL << EXTI_IMR1_IM14_Pos)           /*!< 0x00004000 */
#define EXTI_IMR1_IM14                      EXTI_IMR1_IM14_Msk                      /*!< Interrupt Mask on line 14 */
#define EXTI_IMR1_IM15_Pos                  (15U)
#define EXTI_IMR1_IM15_Msk                  (0x1UL << EXTI_IMR1_IM15_Pos)           /*!< 0x00008000 */
#define EXTI_IMR1_IM15                      EXTI_IMR1_IM15_Msk                      /*!< Interrupt Mask on line 15 */
#define EXTI_IMR1_IM16_Pos                  (16U)
#define EXTI_IMR1_IM16_Msk                  (0x1UL << EXTI_IMR1_IM16_Pos)           /*!< 0x00010000 */
#define EXTI_IMR1_IM16                      EXTI_IMR1_IM16_Msk                      /*!< Interrupt Mask on line 16 */
#define EXTI_IMR1_IM17_Pos                  (17U)
#define EXTI_IMR1_IM17_Msk                  (0x1UL << EXTI_IMR1_IM17_Pos)           /*!< 0x00020000 */
#define EXTI_IMR1_IM17                      EXTI_IMR1_IM17_Msk                      /*!< Interrupt Mask on line 17 */
#define EXTI_IMR1_IM18_Pos                  (18U)
#define EXTI_IMR1_IM18_Msk                  (0x1UL << EXTI_IMR1_IM18_Pos)           /*!< 0x00040000 */
#define EXTI_IMR1_IM18                      EXTI_IMR1_IM18_Msk                      /*!< Interrupt Mask on line 18 */
#define EXTI_IMR1_IM19_Pos                  (19U)
#define EXTI_IMR1_IM19_Msk                  (0x1UL << EXTI_IMR1_IM19_Pos)           /*!< 0x00080000 */
#define EXTI_IMR1_IM19                      EXTI_IMR1_IM19_Msk                      /*!< Interrupt Mask on line 19 */
#define EXTI_IMR1_IM20_Pos                  (20U)
#define EXTI_IMR1_IM20_Msk                  (0x1UL << EXTI_IMR1_IM20_Pos)           /*!< 0x00100000 */
#define EXTI_IMR1_IM20                      EXTI_IMR1_IM20_Msk                      /*!< Interrupt Mask on line 20 */
#define EXTI_IMR1_IM21_Pos                  (21U)
#define EXTI_IMR1_IM21_Msk                  (0x1UL << EXTI_IMR1_IM21_Pos)           /*!< 0x00200000 */
#define EXTI_IMR1_IM21                      EXTI_IMR1_IM21_Msk                      /*!< Interrupt Mask on line 21 */
#define EXTI_IMR1_IM22_Pos                  (22U)
#define EXTI_IMR1_IM22_Msk                  (0x1UL << EXTI_IMR1_IM22_Pos)           /*!< 0x00400000 */
#define EXTI_IMR1_IM22                      EXTI_IMR1_IM22_Msk                      /*!< Interrupt Mask on line 22 */
#define EXTI_IMR1_IM23_Pos                  (23U)
#define EXTI_IMR1_IM23_Msk                  (0x1UL << EXTI_IMR1_IM23_Pos)           /*!< 0x00800000 */
#define EXTI_IMR1_IM23                      EXTI_IMR1_IM23_Msk                      /*!< Interrupt Mask on line 23 */
#define EXTI_IMR1_IM24_Pos                  (24U)
#define EXTI_IMR1_IM24_Msk                  (0x1UL << EXTI_IMR1_IM24_Pos)           /*!< 0x01000000 */
#define EXTI_IMR1_IM24                      EXTI_IMR1_IM24_Msk                      /*!< Interrupt Mask on line 24 */
#define EXTI_IMR1_IM25_Pos                  (25U)
#define EXTI_IMR1_IM25_Msk                  (0x1UL << EXTI_IMR1_IM25_Pos)           /*!< 0x02000000 */
#define EXTI_IMR1_IM25                      EXTI_IMR1_IM25_Msk                      /*!< Interrupt Mask on line 25 */
#define EXTI_IMR1_IM26_Pos                  (26U)
#define EXTI_IMR1_IM26_Msk                  (0x1UL << EXTI_IMR1_IM26_Pos)           /*!< 0x04000000 */
#define EXTI_IMR1_IM26                      EXTI_IMR1_IM26_Msk                      /*!< Interrupt Mask on line 26 */
#define EXTI_IMR1_IM27_Pos                  (27U)
#define EXTI_IMR1_IM27_Msk                  (0x1UL << EXTI_IMR1_IM27_Pos)           /*!< 0x08000000 */
#define EXTI_IMR1_IM27                      EXTI_IMR1_IM27_Msk                      /*!< Interrupt Mask on line 27 */
#define EXTI_IMR1_IM28_Pos                  (28U)
#define EXTI_IMR1_IM28_Msk                  (0x1UL << EXTI_IMR1_IM28_Pos)           /*!< 0x10000000 */
#define EXTI_IMR1_IM28                      EXTI_IMR1_IM28_Msk                      /*!< Interrupt Mask on line 28 */
#define EXTI_IMR1_IM29_Pos                  (29U)
#define EXTI_IMR1_IM29_Msk                  (0x1UL << EXTI_IMR1_IM29_Pos)           /*!< 0x20000000 */
#define EXTI_IMR1_IM29                      EXTI_IMR1_IM29_Msk                      /*!< Interrupt Mask on line 29 */
#define EXTI_IMR1_IM30_Pos                  (30U)
#define EXTI_IMR1_IM30_Msk                  (0x1UL << EXTI_IMR1_IM30_Pos)           /*!< 0x40000000 */
#define EXTI_IMR1_IM30                      EXTI_IMR1_IM30_Msk                      /*!< Interrupt Mask on line 30 */
#define EXTI_IMR1_IM31_Pos                  (31U)
#define EXTI_IMR1_IM31_Msk                  (0x1UL << EXTI_IMR1_IM31_Pos)           /*!< 0x80000000 */
#define EXTI_IMR1_IM31                      EXTI_IMR1_IM31_Msk                      /*!< Interrupt Mask on line 31 */

/*******************  Bit definition for EXTI_EMR1 register  ******************/
#define EXTI_EMR1_EM_Pos                    (0U)
#define EXTI_EMR1_EM_Msk                    (0xFFFFFFFFUL << EXTI_EMR1_EM_Pos)      /*!< 0xFFFFFFFF */
#define EXTI_EMR1_EM                        EXTI_EMR1_EM_Msk                        /*!< Event Mask */
#define EXTI_EMR1_EM0_Pos                   (0U)
#define EXTI_EMR1_EM0_Msk                   (0x1UL << EXTI_EMR1_EM0_Pos)            /*!< 0x00000001 */
#define EXTI_EMR1_EM0                       EXTI_EMR1_EM0_Msk                       /*!< Event Mask on line 0 */
#define EXTI_EMR1_EM1_Pos                   (1U)
#define EXTI_EMR1_EM1_Msk                   (0x1UL << EXTI_EMR1_EM1_Pos)            /*!< 0x00000002 */
#define EXTI_EMR1_EM1                       EXTI_EMR1_EM1_Msk                       /*!< Event Mask on line 1 */
#define EXTI_EMR1_EM2_Pos                   (2U)
#define EXTI_EMR1_EM2_Msk                   (0x1UL << EXTI_EMR1_EM2_Pos)            /*!< 0x00000004 */
#define EXTI_EMR1_EM2                       EXTI_EMR1_EM2_Msk                       /*!< Event Mask on line 2 */
#define EXTI_EMR1_EM3_Pos                   (3U)
#define EXTI_EMR1_EM3_Msk                   (0x1UL << EXTI_EMR1_EM3_Pos)            /*!< 0x00000008 */
#define EXTI_EMR1_EM3                       EXTI_EMR1_EM3_Msk                       /*!< Event Mask on line 3 */
#define EXTI_EMR1_EM4_Pos                   (4U)
#define EXTI_EMR1_EM4_Msk                   (0x1UL << EXTI_EMR1_EM4_Pos)            /*!< 0x00000010 */
#define EXTI_EMR1_EM4                       EXTI_EMR1_EM4_Msk                       /*!< Event Mask on line 4 */
#define EXTI_EMR1_EM5_Pos                   (5U)
#define EXTI_EMR1_EM5_Msk                   (0x1UL << EXTI_EMR1_EM5_Pos)            /*!< 0x00000020 */
#define EXTI_EMR1_EM5                       EXTI_EMR1_EM5_Msk                       /*!< Event Mask on line 5 */
#define EXTI_EMR1_EM6_Pos                   (6U)
#define EXTI_EMR1_EM6_Msk                   (0x1UL << EXTI_EMR1_EM6_Pos)            /*!< 0x00000040 */
#define EXTI_EMR1_EM6                       EXTI_EMR1_EM6_Msk                       /*!< Event Mask on line 6 */
#define EXTI_EMR1_EM7_Pos                   (7U)
#define EXTI_EMR1_EM7_Msk                   (0x1UL << EXTI_EMR1_EM7_Pos)            /*!< 0x00000080 */
#define EXTI_EMR1_EM7                       EXTI_EMR1_EM7_Msk                       /*!< Event Mask on line 7 */
#define EXTI_EMR1_EM8_Pos                   (8U)
#define EXTI_EMR1_EM8_Msk                   (0x1UL << EXTI_EMR1_EM8_Pos)            /*!< 0x00000100 */
#define EXTI_EMR1_EM8                       EXTI_EMR1_EM8_Msk                       /*!< Event Mask on line 8 */
#define EXTI_EMR1_EM9_Pos                   (9U)
#define EXTI_EMR1_EM9_Msk                   (0x1UL << EXTI_EMR1_EM9_Pos)            /*!< 0x00000200 */
#define EXTI_EMR1_EM9                       EXTI_EMR1_EM9_Msk                       /*!< Event Mask on line 9 */
#define EXTI_EMR1_EM10_Pos                  (10U)
#define EXTI_EMR1_EM10_Msk                  (0x1UL << EXTI_EMR1_EM10_Pos)           /*!< 0x00000400 */
#define EXTI_EMR1_EM10                      EXTI_EMR1_EM10_Msk                      /*!< Event Mask on line 10 */
#define EXTI_EMR1_EM11_Pos                  (11U)
#define EXTI_EMR1_EM11_Msk                  (0x1UL << EXTI_EMR1_EM11_Pos)           /*!< 0x00000800 */
#define EXTI_EMR1_EM11                      EXTI_EMR1_EM11_Msk                      /*!< Event Mask on line 11 */
#define EXTI_EMR1_EM12_Pos                  (12U)
#define EXTI_EMR1_EM12_Msk                  (0x1UL << EXTI_EMR1_EM12_Pos)           /*!< 0x00001000 */
#define EXTI_EMR1_EM12                      EXTI_EMR1_EM12_Msk                      /*!< Event Mask on line 12 */
#define EXTI_EMR1_EM13_Pos                  (13U)
#define EXTI_EMR1_EM13_Msk                  (0x1UL << EXTI_EMR1_EM13_Pos)           /*!< 0x00002000 */
#define EXTI_EMR1_EM13                      EXTI_EMR1_EM13_Msk                      /*!< Event Mask on line 13 */
#define EXTI_EMR1_EM14_Pos                  (14U)
#define EXTI_EMR1_EM14_Msk                  (0x1UL << EXTI_EMR1_EM14_Pos)           /*!< 0x00004000 */
#define EXTI_EMR1_EM14                      EXTI_EMR1_EM14_Msk                      /*!< Event Mask on line 14 */
#define EXTI_EMR1_EM15_Pos                  (15U)
#define EXTI_EMR1_EM15_Msk                  (0x1UL << EXTI_EMR1_EM15_Pos)           /*!< 0x00008000 */
#define EXTI_EMR1_EM15                      EXTI_EMR1_EM15_Msk                      /*!< Event Mask on line 15 */
#define EXTI_EMR1_EM16_Pos                  (16U)
#define EXTI_EMR1_EM16_Msk                  (0x1UL << EXTI_EMR1_EM16_Pos)           /*!< 0x00010000 */
#define EXTI_EMR1_EM16                      EXTI_EMR1_EM16_Msk                      /*!< Event Mask on line 16 */
#define EXTI_EMR1_EM17_Pos                  (17U)
#define EXTI_EMR1_EM17_Msk                  (0x1UL << EXTI_EMR1_EM17_Pos)           /*!< 0x00020000 */
#define EXTI_EMR1_EM17                      EXTI_EMR1_EM17_Msk                      /*!< Event Mask on line 17 */
#define EXTI_EMR1_EM18_Pos                  (18U)
#define EXTI_EMR1_EM18_Msk                  (0x1UL << EXTI_EMR1_EM18_Pos)           /*!< 0x00040000 */
#define EXTI_EMR1_EM18                      EXTI_EMR1_EM18_Msk                      /*!< Event Mask on line 18 */
#define EXTI_EMR1_EM19_Pos                  (19U)
#define EXTI_EMR1_EM19_Msk                  (0x1UL << EXTI_EMR1_EM19_Pos)           /*!< 0x00080000 */
#define EXTI_EMR1_EM19                      EXTI_EMR1_EM19_Msk                      /*!< Event Mask on line 19 */
#define EXTI_EMR1_EM20_Pos                  (20U)
#define EXTI_EMR1_EM20_Msk                  (0x1UL << EXTI_EMR1_EM20_Pos)           /*!< 0x00100000 */
#define EXTI_EMR1_EM20                      EXTI_EMR1_EM20_Msk                      /*!< Event Mask on line 20 */
#define EXTI_EMR1_EM21_Pos                  (21U)
#define EXTI_EMR1_EM21_Msk                  (0x1UL << EXTI_EMR1_EM21_Pos)           /*!< 0x00200000 */
#define EXTI_EMR1_EM21                      EXTI_EMR1_EM21_Msk                      /*!< Event Mask on line 21 */
#define EXTI_EMR1_EM22_Pos                  (22U)
#define EXTI_EMR1_EM22_Msk                  (0x1UL << EXTI_EMR1_EM22_Pos)           /*!< 0x00400000 */
#define EXTI_EMR1_EM22                      EXTI_EMR1_EM22_Msk                      /*!< Event Mask on line 22 */
#define EXTI_EMR1_EM23_Pos                  (23U)
#define EXTI_EMR1_EM23_Msk                  (0x1UL << EXTI_EMR1_EM23_Pos)           /*!< 0x00800000 */
#define EXTI_EMR1_EM23                      EXTI_EMR1_EM23_Msk                      /*!< Event Mask on line 23 */
#define EXTI_EMR1_EM24_Pos                  (24U)
#define EXTI_EMR1_EM24_Msk                  (0x1UL << EXTI_EMR1_EM24_Pos)           /*!< 0x01000000 */
#define EXTI_EMR1_EM24                      EXTI_EMR1_EM24_Msk                      /*!< Event Mask on line 24 */
#define EXTI_EMR1_EM25_Pos                  (25U)
#define EXTI_EMR1_EM25_Msk                  (0x1UL << EXTI_EMR1_EM25_Pos)           /*!< 0x02000000 */
#define EXTI_EMR1_EM25                      EXTI_EMR1_EM25_Msk                      /*!< Event Mask on line 25 */
#define EXTI_EMR1_EM26_Pos                  (26U)
#define EXTI_EMR1_EM26_Msk                  (0x1UL << EXTI_EMR1_EM26_Pos)           /*!< 0x04000000 */
#define EXTI_EMR1_EM26                      EXTI_EMR1_EM26_Msk                      /*!< Event Mask on line 26 */
#define EXTI_EMR1_EM27_Pos                  (27U)
#define EXTI_EMR1_EM27_Msk                  (0x1UL << EXTI_EMR1_EM27_Pos)           /*!< 0x08000000 */
#define EXTI_EMR1_EM27                      EXTI_EMR1_EM27_Msk                      /*!< Event Mask on line 27 */
#define EXTI_EMR1_EM28_Pos                  (28U)
#define EXTI_EMR1_EM28_Msk                  (0x1UL << EXTI_EMR1_EM28_Pos)           /*!< 0x10000000 */
#define EXTI_EMR1_EM28                      EXTI_EMR1_EM28_Msk                      /*!< Event Mask on line 28 */
#define EXTI_EMR1_EM29_Pos                  (29U)
#define EXTI_EMR1_EM29_Msk                  (0x1UL << EXTI_EMR1_EM29_Pos)           /*!< 0x20000000 */
#define EXTI_EMR1_EM29                      EXTI_EMR1_EM29_Msk                      /*!< Event Mask on line 29 */
#define EXTI_EMR1_EM30_Pos                  (30U)
#define EXTI_EMR1_EM30_Msk                  (0x1UL << EXTI_EMR1_EM30_Pos)           /*!< 0x40000000 */
#define EXTI_EMR1_EM30                      EXTI_EMR1_EM30_Msk                      /*!< Event Mask on line 30 */
#define EXTI_EMR1_EM31_Pos                  (31U)
#define EXTI_EMR1_EM31_Msk                  (0x1UL << EXTI_EMR1_EM31_Pos)           /*!< 0x80000000 */
#define EXTI_EMR1_EM31                      EXTI_EMR1_EM31_Msk                      /*!< Event Mask on line 31 */

/*******************  Bit definition for EXTI_IMR2 register  *******************/
#define EXTI_IMR2_IM_Pos                    (0U)
#define EXTI_IMR2_IM_Msk                    (0x03FFFFFFUL << EXTI_IMR2_IM_Pos)      /*!< 0x03FFFFFF */
#define EXTI_IMR2_IM                        EXTI_IMR2_IM_Msk                        /*!< Interrupt Mask */
#define EXTI_IMR2_IM32_Pos                  (0U)
#define EXTI_IMR2_IM32_Msk                  (0x1UL << EXTI_IMR2_IM32_Pos)           /*!< 0x00000001 */
#define EXTI_IMR2_IM32                      EXTI_IMR2_IM32_Msk                      /*!< Interrupt Mask on line 32 */
#define EXTI_IMR2_IM33_Pos                  (1U)
#define EXTI_IMR2_IM33_Msk                  (0x1UL << EXTI_IMR2_IM33_Pos)           /*!< 0x00000002 */
#define EXTI_IMR2_IM33                      EXTI_IMR2_IM33_Msk                      /*!< Interrupt Mask on line 33 */
#define EXTI_IMR2_IM34_Pos                  (2U)
#define EXTI_IMR2_IM34_Msk                  (0x1UL << EXTI_IMR2_IM34_Pos)           /*!< 0x00000004 */
#define EXTI_IMR2_IM34                      EXTI_IMR2_IM34_Msk                      /*!< Interrupt Mask on line 34 */
#define EXTI_IMR2_IM35_Pos                  (3U)
#define EXTI_IMR2_IM35_Msk                  (0x1UL << EXTI_IMR2_IM35_Pos)           /*!< 0x00000008 */
#define EXTI_IMR2_IM35                      EXTI_IMR2_IM35_Msk                      /*!< Interrupt Mask on line 35 */
#define EXTI_IMR2_IM36_Pos                  (4U)
#define EXTI_IMR2_IM36_Msk                  (0x1UL << EXTI_IMR2_IM36_Pos)           /*!< 0x00000010 */
#define EXTI_IMR2_IM36                      EXTI_IMR2_IM36_Msk                      /*!< Interrupt Mask on line 36 */
#define EXTI_IMR2_IM37_Pos                  (5U)
#define EXTI_IMR2_IM37_Msk                  (0x1UL << EXTI_IMR2_IM37_Pos)           /*!< 0x00000020 */
#define EXTI_IMR2_IM37                      EXTI_IMR2_IM37_Msk                      /*!< Interrupt Mask on line 37 */
#define EXTI_IMR2_IM38_Pos                  (6U)
#define EXTI_IMR2_IM38_Msk                  (0x1UL << EXTI_IMR2_IM38_Pos)           /*!< 0x00000040 */
#define EXTI_IMR2_IM38                      EXTI_IMR2_IM38_Msk                      /*!< Interrupt Mask on line 38 */
#define EXTI_IMR2_IM39_Pos                  (7U)
#define EXTI_IMR2_IM39_Msk                  (0x1UL << EXTI_IMR2_IM39_Pos)           /*!< 0x00000080 */
#define EXTI_IMR2_IM39                      EXTI_IMR2_IM39_Msk                      /*!< Interrupt Mask on line 39 */
#define EXTI_IMR2_IM40_Pos                  (8U)
#define EXTI_IMR2_IM40_Msk                  (0x1UL << EXTI_IMR2_IM40_Pos)           /*!< 0x00000100 */
#define EXTI_IMR2_IM40                      EXTI_IMR2_IM40_Msk                      /*!< Interrupt Mask on line 40 */
#define EXTI_IMR2_IM41_Pos                  (9U)
#define EXTI_IMR2_IM41_Msk                  (0x1UL << EXTI_IMR2_IM41_Pos)           /*!< 0x00000200 */
#define EXTI_IMR2_IM41                      EXTI_IMR2_IM41_Msk                      /*!< Interrupt Mask on line 41 */
#define EXTI_IMR2_IM42_Pos                  (10U)
#define EXTI_IMR2_IM42_Msk                  (0x1UL << EXTI_IMR2_IM42_Pos)           /*!< 0x00000400 */
#define EXTI_IMR2_IM42                      EXTI_IMR2_IM42_Msk                      /*!< Interrupt Mask on line 42 */
#define EXTI_IMR2_IM43_Pos                  (11U)
#define EXTI_IMR2_IM43_Msk                  (0x1UL << EXTI_IMR2_IM43_Pos)           /*!< 0x00000800 */
#define EXTI_IMR2_IM43                      EXTI_IMR2_IM43_Msk                      /*!< Interrupt Mask on line 43 */
#define EXTI_IMR2_IM44_Pos                  (12U)
#define EXTI_IMR2_IM44_Msk                  (0x1UL << EXTI_IMR2_IM44_Pos)           /*!< 0x00001000 */
#define EXTI_IMR2_IM44                      EXTI_IMR2_IM44_Msk                      /*!< Interrupt Mask on line 44 */
#define EXTI_IMR2_IM45_Pos                  (13U)
#define EXTI_IMR2_IM45_Msk                  (0x1UL << EXTI_IMR2_IM45_Pos)           /*!< 0x00002000 */
#define EXTI_IMR2_IM45                      EXTI_IMR2_IM45_Msk                      /*!< Interrupt Mask on line 45 */
#define EXTI_IMR2_IM46_Pos                  (14U)
#define EXTI_IMR2_IM46_Msk                  (0x1UL << EXTI_IMR2_IM46_Pos)           /*!< 0x00004000 */
#define EXTI_IMR2_IM46                      EXTI_IMR2_IM46_Msk                      /*!< Interrupt Mask on line 46 */
#define EXTI_IMR2_IM47_Pos                  (15U)
#define EXTI_IMR2_IM47_Msk                  (0x1UL << EXTI_IMR2_IM47_Pos)           /*!< 0x00008000 */
#define EXTI_IMR2_IM47                      EXTI_IMR2_IM47_Msk                      /*!< Interrupt Mask on line 47 */
#define EXTI_IMR2_IM48_Pos                  (16U)
#define EXTI_IMR2_IM48_Msk                  (0x1UL << EXTI_IMR2_IM48_Pos)           /*!< 0x00010000 */
#define EXTI_IMR2_IM48                      EXTI_IMR2_IM48_Msk                      /*!< Interrupt Mask on line 48 */
#define EXTI_IMR2_IM49_Pos                  (17U)
#define EXTI_IMR2_IM49_Msk                  (0x1UL << EXTI_IMR2_IM49_Pos)           /*!< 0x00020000 */
#define EXTI_IMR2_IM49                      EXTI_IMR2_IM49_Msk                      /*!< Interrupt Mask on line 49 */
#define EXTI_IMR2_IM50_Pos                  (18U)
#define EXTI_IMR2_IM50_Msk                  (0x1UL << EXTI_IMR2_IM50_Pos)           /*!< 0x00040000 */
#define EXTI_IMR2_IM50                      EXTI_IMR2_IM50_Msk                      /*!< Interrupt Mask on line 50 */
#define EXTI_IMR2_IM51_Pos                  (19U)
#define EXTI_IMR2_IM51_Msk                  (0x1UL << EXTI_IMR2_IM51_Pos)           /*!< 0x00080000 */
#define EXTI_IMR2_IM51                      EXTI_IMR2_IM51_Msk                      /*!< Interrupt Mask on line 51 */
#define EXTI_IMR2_IM52_Pos                  (20U)
#define EXTI_IMR2_IM52_Msk                  (0x1UL << EXTI_IMR2_IM52_Pos)           /*!< 0x00100000 */
#define EXTI_IMR2_IM52                      EXTI_IMR2_IM52_Msk                      /*!< Interrupt Mask on line 52 */
#define EXTI_IMR2_IM53_Pos                  (21U)
#define EXTI_IMR2_IM53_Msk                  (0x1UL << EXTI_IMR2_IM53_Pos)           /*!< 0x00200000 */
#define EXTI_IMR2_IM53                      EXTI_IMR2_IM53_Msk                      /*!< Interrupt Mask on line 53 */
#define EXTI_IMR2_IM54_Pos                  (22U)
#define EXTI_IMR2_IM54_Msk                  (0x1UL << EXTI_IMR2_IM54_Pos)           /*!< 0x00400000 */
#define EXTI_IMR2_IM54                      EXTI_IMR2_IM54_Msk                      /*!< Interrupt Mask on line 54 */
#define EXTI_IMR2_IM55_Pos                  (23U)
#define EXTI_IMR2_IM55_Msk                  (0x1UL << EXTI_IMR2_IM55_Pos)           /*!< 0x00800000 */
#define EXTI_IMR2_IM55                      EXTI_IMR2_IM55_Msk                      /*!< Interrupt Mask on line 55 */
#define EXTI_IMR2_IM56_Pos                  (24U)
#define EXTI_IMR2_IM56_Msk                  (0x1UL << EXTI_IMR2_IM56_Pos)           /*!< 0x01000000 */
#define EXTI_IMR2_IM56                      EXTI_IMR2_IM56_Msk                      /*!< Interrupt Mask on line 56 */
#define EXTI_IMR2_IM57_Pos                  (25U)
#define EXTI_IMR2_IM57_Msk                  (0x1UL << EXTI_IMR2_IM57_Pos)           /*!< 0x02000000 */
#define EXTI_IMR2_IM57                      EXTI_IMR2_IM57_Msk                      /*!< Interrupt Mask on line 57 */


/*******************  Bit definition for EXTI_EMR2 register  *******************/
#define EXTI_EMR2_EM_Pos                    (0U)
#define EXTI_EMR2_EM_Msk                    (0x03FFFFFFUL << EXTI_EMR2_EM_Pos)      /*!< 0x03FFFFFF */
#define EXTI_EMR2_EM                        EXTI_EMR2_EM_Msk                        /*!< Event Mask */
#define EXTI_EMR2_EM32_Pos                  (0U)
#define EXTI_EMR2_EM32_Msk                  (0x1UL << EXTI_EMR2_EM32_Pos)           /*!< 0x00000001 */
#define EXTI_EMR2_EM32                      EXTI_EMR2_EM32_Msk                      /*!< Event Mask on line 32*/
#define EXTI_EMR2_EM33_Pos                  (1U)
#define EXTI_EMR2_EM33_Msk                  (0x1UL << EXTI_EMR2_EM33_Pos)           /*!< 0x00000002 */
#define EXTI_EMR2_EM33                      EXTI_EMR2_EM33_Msk                      /*!< Event Mask on line 33*/
#define EXTI_EMR2_EM34_Pos                  (2U)
#define EXTI_EMR2_EM34_Msk                  (0x1UL << EXTI_EMR2_EM34_Pos)           /*!< 0x00000004 */
#define EXTI_EMR2_EM34                      EXTI_EMR2_EM34_Msk                      /*!< Event Mask on line 34*/
#define EXTI_EMR2_EM35_Pos                  (3U)
#define EXTI_EMR2_EM35_Msk                  (0x1UL << EXTI_EMR2_EM35_Pos)           /*!< 0x00000008 */
#define EXTI_EMR2_EM35                      EXTI_EMR2_EM35_Msk                      /*!< Event Mask on line 35*/
#define EXTI_EMR2_EM36_Pos                  (4U)
#define EXTI_EMR2_EM36_Msk                  (0x1UL << EXTI_EMR2_EM36_Pos)           /*!< 0x00000010 */
#define EXTI_EMR2_EM36                      EXTI_EMR2_EM36_Msk                      /*!< Event Mask on line 36*/
#define EXTI_EMR2_EM37_Pos                  (5U)
#define EXTI_EMR2_EM37_Msk                  (0x1UL << EXTI_EMR2_EM37_Pos)           /*!< 0x00000020 */
#define EXTI_EMR2_EM37                      EXTI_EMR2_EM37_Msk                      /*!< Event Mask on line 37*/
#define EXTI_EMR2_EM38_Pos                  (6U)
#define EXTI_EMR2_EM38_Msk                  (0x1UL << EXTI_EMR2_EM38_Pos)           /*!< 0x00000040 */
#define EXTI_EMR2_EM38                      EXTI_EMR2_EM38_Msk                      /*!< Event Mask on line 38*/
#define EXTI_EMR2_EM39_Pos                  (7U)
#define EXTI_EMR2_EM39_Msk                  (0x1UL << EXTI_EMR2_EM39_Pos)           /*!< 0x00000080 */
#define EXTI_EMR2_EM39                      EXTI_EMR2_EM39_Msk                      /*!< Event Mask on line 39*/
#define EXTI_EMR2_EM40_Pos                  (8U)
#define EXTI_EMR2_EM40_Msk                  (0x1UL << EXTI_EMR2_EM40_Pos)           /*!< 0x00000100 */
#define EXTI_EMR2_EM40                      EXTI_EMR2_EM40_Msk                      /*!< Event Mask on line 40*/
#define EXTI_EMR2_EM41_Pos                  (9U)
#define EXTI_EMR2_EM41_Msk                  (0x1UL << EXTI_EMR2_EM41_Pos)           /*!< 0x00000200 */
#define EXTI_EMR2_EM41                      EXTI_EMR2_EM41_Msk                      /*!< Event Mask on line 41*/
#define EXTI_EMR2_EM42_Pos                  (10U)
#define EXTI_EMR2_EM42_Msk                  (0x1UL << EXTI_EMR2_EM42_Pos)           /*!< 0x00000400 */
#define EXTI_EMR2_EM42                      EXTI_EMR2_EM42_Msk                      /*!< Event Mask on line 42 */
#define EXTI_EMR2_EM43_Pos                  (11U)
#define EXTI_EMR2_EM43_Msk                  (0x1UL << EXTI_EMR2_EM43_Pos)           /*!< 0x00000800 */
#define EXTI_EMR2_EM43                      EXTI_EMR2_EM43_Msk                      /*!< Event Mask on line 43 */
#define EXTI_EMR2_EM44_Pos                  (12U)
#define EXTI_EMR2_EM44_Msk                  (0x1UL << EXTI_EMR2_EM44_Pos)           /*!< 0x00001000 */
#define EXTI_EMR2_EM44                      EXTI_EMR2_EM44_Msk                      /*!< Event Mask on line 44 */
#define EXTI_EMR2_EM45_Pos                  (13U)
#define EXTI_EMR2_EM45_Msk                  (0x1UL << EXTI_EMR2_EM45_Pos)           /*!< 0x00002000 */
#define EXTI_EMR2_EM45                      EXTI_EMR2_EM45_Msk                      /*!< Event Mask on line 45 */
#define EXTI_EMR2_EM46_Pos                  (14U)
#define EXTI_EMR2_EM46_Msk                  (0x1UL << EXTI_EMR2_EM46_Pos)           /*!< 0x00004000 */
#define EXTI_EMR2_EM46                      EXTI_EMR2_EM46_Msk                      /*!< Event Mask on line 46 */
#define EXTI_EMR2_EM47_Pos                  (15U)
#define EXTI_EMR2_EM47_Msk                  (0x1UL << EXTI_EMR2_EM47_Pos)           /*!< 0x00008000 */
#define EXTI_EMR2_EM47                      EXTI_EMR2_EM47_Msk                      /*!< Event Mask on line 47 */
#define EXTI_EMR2_EM48_Pos                  (16U)
#define EXTI_EMR2_EM48_Msk                  (0x1UL << EXTI_EMR2_EM48_Pos)           /*!< 0x00010000 */
#define EXTI_EMR2_EM48                      EXTI_EMR2_EM48_Msk                      /*!< Event Mask on line 48 */
#define EXTI_EMR2_EM49_Pos                  (17U)
#define EXTI_EMR2_EM49_Msk                  (0x1UL << EXTI_EMR2_EM49_Pos)           /*!< 0x00020000 */
#define EXTI_EMR2_EM49                      EXTI_EMR2_EM49_Msk                      /*!< Event Mask on line 49 */
#define EXTI_EMR2_EM50_Pos                  (18U)
#define EXTI_EMR2_EM50_Msk                  (0x1UL << EXTI_EMR2_EM50_Pos)           /*!< 0x00040000 */
#define EXTI_EMR2_EM50                      EXTI_EMR2_EM50_Msk                      /*!< Event Mask on line 50 */
#define EXTI_EMR2_EM51_Pos                  (19U)
#define EXTI_EMR2_EM51_Msk                  (0x1UL << EXTI_EMR2_EM51_Pos)           /*!< 0x00080000 */
#define EXTI_EMR2_EM51                      EXTI_EMR2_EM51_Msk                      /*!< Event Mask on line 51 */
#define EXTI_EMR2_EM52_Pos                  (20U)
#define EXTI_EMR2_EM52_Msk                  (0x1UL << EXTI_EMR2_EM52_Pos)           /*!< 0x00100000 */
#define EXTI_EMR2_EM52                      EXTI_EMR2_EM52_Msk                      /*!< Event Mask on line 52 */
#define EXTI_EMR2_EM53_Pos                  (21U)
#define EXTI_EMR2_EM53_Msk                  (0x1UL << EXTI_EMR2_EM53_Pos)           /*!< 0x00200000 */
#define EXTI_EMR2_EM53                      EXTI_EMR2_EM53_Msk                      /*!< Event Mask on line 53 */
#define EXTI_EMR2_EM54_Pos                  (22U)
#define EXTI_EMR2_EM54_Msk                  (0x1UL << EXTI_EMR2_EM54_Pos)           /*!< 0x00400000 */
#define EXTI_EMR2_EM54                      EXTI_EMR2_EM54_Msk                      /*!< Event Mask on line 54 */
#define EXTI_EMR2_EM55_Pos                  (23U)
#define EXTI_EMR2_EM55_Msk                  (0x1UL << EXTI_EMR2_EM55_Pos)           /*!< 0x00800000 */
#define EXTI_EMR2_EM55                      EXTI_EMR2_EM55_Msk                      /*!< Event Mask on line 55 */
#define EXTI_EMR2_EM56_Pos                  (24U)
#define EXTI_EMR2_EM56_Msk                  (0x1UL << EXTI_EMR2_EM56_Pos)           /*!< 0x01000000 */
#define EXTI_EMR2_EM56                      EXTI_EMR2_EM56_Msk                      /*!< Event Mask on line 56 */
#define EXTI_EMR2_EM57_Pos                  (25U)
#define EXTI_EMR2_EM57_Msk                  (0x1UL << EXTI_EMR2_EM57_Pos)           /*!< 0x02000000 */
#define EXTI_EMR2_EM57                      EXTI_EMR2_EM57_Msk                      /*!< Event Mask on line 57 */

/******************************************************************************/
/*                                                                            */
/*                 Flexible Datarate Controller Area Network                  */
/*                                                                            */
/******************************************************************************/
/*!<FDCAN control and status registers */
/*****************  Bit definition for FDCAN_CREL register  *******************/
#define FDCAN_CREL_DAY_Pos                  (0U)
#define FDCAN_CREL_DAY_Msk                  (0xFFUL << FDCAN_CREL_DAY_Pos)          /*!< 0x000000FF */
#define FDCAN_CREL_DAY                      FDCAN_CREL_DAY_Msk                      /*!<Timestamp Day                           */
#define FDCAN_CREL_MON_Pos                  (8U)
#define FDCAN_CREL_MON_Msk                  (0xFFUL << FDCAN_CREL_MON_Pos)          /*!< 0x0000FF00 */
#define FDCAN_CREL_MON                      FDCAN_CREL_MON_Msk                      /*!<Timestamp Month                         */
#define FDCAN_CREL_YEAR_Pos                 (16U)
#define FDCAN_CREL_YEAR_Msk                 (0xFUL << FDCAN_CREL_YEAR_Pos)          /*!< 0x000F0000 */
#define FDCAN_CREL_YEAR                     FDCAN_CREL_YEAR_Msk                     /*!<Timestamp Year                          */
#define FDCAN_CREL_SUBSTEP_Pos              (20U)
#define FDCAN_CREL_SUBSTEP_Msk              (0xFUL << FDCAN_CREL_SUBSTEP_Pos)       /*!< 0x00F00000 */
#define FDCAN_CREL_SUBSTEP                  FDCAN_CREL_SUBSTEP_Msk                  /*!<Sub-step of Core release                */
#define FDCAN_CREL_STEP_Pos                 (24U)
#define FDCAN_CREL_STEP_Msk                 (0xFUL << FDCAN_CREL_STEP_Pos)          /*!< 0x0F000000 */
#define FDCAN_CREL_STEP                     FDCAN_CREL_STEP_Msk                     /*!<Step of Core release                    */
#define FDCAN_CREL_REL_Pos                  (28U)
#define FDCAN_CREL_REL_Msk                  (0xFUL << FDCAN_CREL_REL_Pos)           /*!< 0xF0000000 */
#define FDCAN_CREL_REL                      FDCAN_CREL_REL_Msk                      /*!<Core release                            */

/*****************  Bit definition for FDCAN_ENDN register  *******************/
#define FDCAN_ENDN_ETV_Pos                  (0U)
#define FDCAN_ENDN_ETV_Msk                  (0xFFFFFFFFUL << FDCAN_ENDN_ETV_Pos)    /*!< 0xFFFFFFFF */
#define FDCAN_ENDN_ETV                      FDCAN_ENDN_ETV_Msk                      /*!<Endianness Test Value                   */

/*****************  Bit definition for FDCAN_DBTP register  *******************/
#define FDCAN_DBTP_DSJW_Pos                 (0U)
#define FDCAN_DBTP_DSJW_Msk                 (0xFUL << FDCAN_DBTP_DSJW_Pos)          /*!< 0x0000000F */
#define FDCAN_DBTP_DSJW                     FDCAN_DBTP_DSJW_Msk                     /*!<Synchronization Jump Width              */
#define FDCAN_DBTP_DTSEG2_Pos               (4U)
#define FDCAN_DBTP_DTSEG2_Msk               (0xFUL << FDCAN_DBTP_DTSEG2_Pos)        /*!< 0x000000F0 */
#define FDCAN_DBTP_DTSEG2                   FDCAN_DBTP_DTSEG2_Msk                   /*!<Data time segment after sample point    */
#define FDCAN_DBTP_DTSEG1_Pos               (8U)
#define FDCAN_DBTP_DTSEG1_Msk               (0x1FUL << FDCAN_DBTP_DTSEG1_Pos)       /*!< 0x00001F00 */
#define FDCAN_DBTP_DTSEG1                   FDCAN_DBTP_DTSEG1_Msk                   /*!<Data time segment before sample point   */
#define FDCAN_DBTP_DBRP_Pos                 (16U)
#define FDCAN_DBTP_DBRP_Msk                 (0x1FUL << FDCAN_DBTP_DBRP_Pos)         /*!< 0x001F0000 */
#define FDCAN_DBTP_DBRP                     FDCAN_DBTP_DBRP_Msk                     /*!<Data BIt Rate Prescaler                 */
#define FDCAN_DBTP_TDC_Pos                  (23U)
#define FDCAN_DBTP_TDC_Msk                  (0x1UL << FDCAN_DBTP_TDC_Pos)           /*!< 0x00800000 */
#define FDCAN_DBTP_TDC                      FDCAN_DBTP_TDC_Msk                      /*!<Transceiver Delay Compensation          */

/*****************  Bit definition for FDCAN_TEST register  *******************/
#define FDCAN_TEST_LBCK_Pos                 (4U)
#define FDCAN_TEST_LBCK_Msk                 (0x1UL << FDCAN_TEST_LBCK_Pos)          /*!< 0x00000010 */
#define FDCAN_TEST_LBCK                     FDCAN_TEST_LBCK_Msk                     /*!<Loop Back mode                           */
#define FDCAN_TEST_TX_Pos                   (5U)
#define FDCAN_TEST_TX_Msk                   (0x3UL << FDCAN_TEST_TX_Pos)            /*!< 0x00000060 */
#define FDCAN_TEST_TX                       FDCAN_TEST_TX_Msk                       /*!<Control of Transmit Pin                  */
#define FDCAN_TEST_RX_Pos                   (7U)
#define FDCAN_TEST_RX_Msk                   (0x1UL << FDCAN_TEST_RX_Pos)            /*!< 0x00000080 */
#define FDCAN_TEST_RX                       FDCAN_TEST_RX_Msk                       /*!<Receive Pin                              */

/*****************  Bit definition for FDCAN_RWD register  ********************/
#define FDCAN_RWD_WDC_Pos                   (0U)
#define FDCAN_RWD_WDC_Msk                   (0xFFUL << FDCAN_RWD_WDC_Pos)           /*!< 0x000000FF */
#define FDCAN_RWD_WDC                       FDCAN_RWD_WDC_Msk                       /*!<Watchdog configuration                   */
#define FDCAN_RWD_WDV_Pos                   (8U)
#define FDCAN_RWD_WDV_Msk                   (0xFFUL << FDCAN_RWD_WDV_Pos)           /*!< 0x0000FF00 */
#define FDCAN_RWD_WDV                       FDCAN_RWD_WDV_Msk                       /*!<Watchdog value                           */

/*****************  Bit definition for FDCAN_CCCR register  ********************/
#define FDCAN_CCCR_INIT_Pos                 (0U)
#define FDCAN_CCCR_INIT_Msk                 (0x1UL << FDCAN_CCCR_INIT_Pos)          /*!< 0x00000001 */
#define FDCAN_CCCR_INIT                     FDCAN_CCCR_INIT_Msk                     /*!<Initialization                           */
#define FDCAN_CCCR_CCE_Pos                  (1U)
#define FDCAN_CCCR_CCE_Msk                  (0x1UL << FDCAN_CCCR_CCE_Pos)           /*!< 0x00000002 */
#define FDCAN_CCCR_CCE                      FDCAN_CCCR_CCE_Msk                      /*!<Configuration Change Enable              */
#define FDCAN_CCCR_ASM_Pos                  (2U)
#define FDCAN_CCCR_ASM_Msk                  (0x1UL << FDCAN_CCCR_ASM_Pos)           /*!< 0x00000004 */
#define FDCAN_CCCR_ASM                      FDCAN_CCCR_ASM_Msk                      /*!<ASM Restricted Operation Mode            */
#define FDCAN_CCCR_CSA_Pos                  (3U)
#define FDCAN_CCCR_CSA_Msk                  (0x1UL << FDCAN_CCCR_CSA_Pos)           /*!< 0x00000008 */
#define FDCAN_CCCR_CSA                      FDCAN_CCCR_CSA_Msk                      /*!<Clock Stop Acknowledge                   */
#define FDCAN_CCCR_CSR_Pos                  (4U)
#define FDCAN_CCCR_CSR_Msk                  (0x1UL << FDCAN_CCCR_CSR_Pos)           /*!< 0x00000010 */
#define FDCAN_CCCR_CSR                      FDCAN_CCCR_CSR_Msk                      /*!<Clock Stop Request                       */
#define FDCAN_CCCR_MON_Pos                  (5U)
#define FDCAN_CCCR_MON_Msk                  (0x1UL << FDCAN_CCCR_MON_Pos)           /*!< 0x00000020 */
#define FDCAN_CCCR_MON                      FDCAN_CCCR_MON_Msk                      /*!<Bus Monitoring Mode                      */
#define FDCAN_CCCR_DAR_Pos                  (6U)
#define FDCAN_CCCR_DAR_Msk                  (0x1UL << FDCAN_CCCR_DAR_Pos)           /*!< 0x00000040 */
#define FDCAN_CCCR_DAR                      FDCAN_CCCR_DAR_Msk                      /*!<Disable Automatic Retransmission         */
#define FDCAN_CCCR_TEST_Pos                 (7U)
#define FDCAN_CCCR_TEST_Msk                 (0x1UL << FDCAN_CCCR_TEST_Pos)          /*!< 0x00000080 */
#define FDCAN_CCCR_TEST                     FDCAN_CCCR_TEST_Msk                     /*!<Test Mode Enable                         */
#define FDCAN_CCCR_FDOE_Pos                 (8U)
#define FDCAN_CCCR_FDOE_Msk                 (0x1UL << FDCAN_CCCR_FDOE_Pos)          /*!< 0x00000100 */
#define FDCAN_CCCR_FDOE                     FDCAN_CCCR_FDOE_Msk                     /*!<FD Operation Enable                      */
#define FDCAN_CCCR_BRSE_Pos                 (9U)
#define FDCAN_CCCR_BRSE_Msk                 (0x1UL << FDCAN_CCCR_BRSE_Pos)          /*!< 0x00000200 */
#define FDCAN_CCCR_BRSE                     FDCAN_CCCR_BRSE_Msk                     /*!<FDCAN Bit Rate Switching                 */
#define FDCAN_CCCR_PXHD_Pos                 (12U)
#define FDCAN_CCCR_PXHD_Msk                 (0x1UL << FDCAN_CCCR_PXHD_Pos)          /*!< 0x00001000 */
#define FDCAN_CCCR_PXHD                     FDCAN_CCCR_PXHD_Msk                     /*!<Protocol Exception Handling Disable      */
#define FDCAN_CCCR_EFBI_Pos                 (13U)
#define FDCAN_CCCR_EFBI_Msk                 (0x1UL << FDCAN_CCCR_EFBI_Pos)          /*!< 0x00002000 */
#define FDCAN_CCCR_EFBI                     FDCAN_CCCR_EFBI_Msk                     /*!<Edge Filtering during Bus Integration    */
#define FDCAN_CCCR_TXP_Pos                  (14U)
#define FDCAN_CCCR_TXP_Msk                  (0x1UL << FDCAN_CCCR_TXP_Pos)           /*!< 0x00004000 */
#define FDCAN_CCCR_TXP                      FDCAN_CCCR_TXP_Msk                      /*!<Two CAN bit times Pause                  */
#define FDCAN_CCCR_NISO_Pos                 (15U)
#define FDCAN_CCCR_NISO_Msk                 (0x1UL << FDCAN_CCCR_NISO_Pos)          /*!< 0x00008000 */
#define FDCAN_CCCR_NISO                     FDCAN_CCCR_NISO_Msk                     /*!<Non ISO Operation                        */

/*****************  Bit definition for FDCAN_NBTP register  ******************* */
#define FDCAN_NBTP_NTSEG2_Pos               (0U)
#define FDCAN_NBTP_NTSEG2_Msk               (0x7FUL << FDCAN_NBTP_NTSEG2_Pos)       /*!< 0x0000007F */
#define FDCAN_NBTP_NTSEG2                   FDCAN_NBTP_NTSEG2_Msk                   /*!<Nominal Time segment after sample point  */
#define FDCAN_NBTP_NTSEG1_Pos               (8U)
#define FDCAN_NBTP_NTSEG1_Msk               (0xFFUL << FDCAN_NBTP_NTSEG1_Pos)       /*!< 0x0000FF00 */
#define FDCAN_NBTP_NTSEG1                   FDCAN_NBTP_NTSEG1_Msk                   /*!<Nominal Time segment before sample point */
#define FDCAN_NBTP_NBRP_Pos                 (16U)
#define FDCAN_NBTP_NBRP_Msk                 (0x1FFUL << FDCAN_NBTP_NBRP_Pos)        /*!< 0x01FF0000 */
#define FDCAN_NBTP_NBRP                     FDCAN_NBTP_NBRP_Msk                     /*!<Bit Rate Prescaler                       */
#define FDCAN_NBTP_NSJW_Pos                 (25U)
#define FDCAN_NBTP_NSJW_Msk                 (0x7FUL << FDCAN_NBTP_NSJW_Pos)         /*!< 0xFE000000 */
#define FDCAN_NBTP_NSJW                     FDCAN_NBTP_NSJW_Msk                     /*!<Nominal (Re)Synchronization Jump Width   */

/*****************  Bit definition for FDCAN_TSCC register  ********************/
#define FDCAN_TSCC_TSS_Pos                  (0U)
#define FDCAN_TSCC_TSS_Msk                  (0x3UL << FDCAN_TSCC_TSS_Pos)           /*!< 0x00000003 */
#define FDCAN_TSCC_TSS                      FDCAN_TSCC_TSS_Msk                      /*!<Timestamp Select                         */
#define FDCAN_TSCC_TCP_Pos                  (16U)
#define FDCAN_TSCC_TCP_Msk                  (0xFUL << FDCAN_TSCC_TCP_Pos)           /*!< 0x000F0000 */
#define FDCAN_TSCC_TCP                      FDCAN_TSCC_TCP_Msk                      /*!<Timestamp Counter Prescaler              */

/*****************  Bit definition for FDCAN_TSCV register  ********************/
#define FDCAN_TSCV_TSC_Pos                  (0U)
#define FDCAN_TSCV_TSC_Msk                  (0xFFFFUL << FDCAN_TSCV_TSC_Pos)        /*!< 0x0000FFFF */
#define FDCAN_TSCV_TSC                      FDCAN_TSCV_TSC_Msk                      /*!<Timestamp Counter                        */

/*****************  Bit definition for FDCAN_TOCC register  ********************/
#define FDCAN_TOCC_ETOC_Pos                 (0U)
#define FDCAN_TOCC_ETOC_Msk                 (0x1UL << FDCAN_TOCC_ETOC_Pos)          /*!< 0x00000001 */
#define FDCAN_TOCC_ETOC                     FDCAN_TOCC_ETOC_Msk                     /*!<Enable Timeout Counter                   */
#define FDCAN_TOCC_TOS_Pos                  (1U)
#define FDCAN_TOCC_TOS_Msk                  (0x3UL << FDCAN_TOCC_TOS_Pos)           /*!< 0x00000006 */
#define FDCAN_TOCC_TOS                      FDCAN_TOCC_TOS_Msk                      /*!<Timeout Select                           */
#define FDCAN_TOCC_TOP_Pos                  (16U)
#define FDCAN_TOCC_TOP_Msk                  (0xFFFFUL << FDCAN_TOCC_TOP_Pos)        /*!< 0xFFFF0000 */
#define FDCAN_TOCC_TOP                      FDCAN_TOCC_TOP_Msk                      /*!<Timeout Period                           */

/*****************  Bit definition for FDCAN_TOCV register  ******************* */
#define FDCAN_TOCV_TOC_Pos                  (0U)
#define FDCAN_TOCV_TOC_Msk                  (0xFFFFUL << FDCAN_TOCV_TOC_Pos)        /*!< 0x0000FFFF */
#define FDCAN_TOCV_TOC                      FDCAN_TOCV_TOC_Msk                      /*!<Timeout Counter                          */

/*****************  Bit definition for FDCAN_ECR register  ******************** */
#define FDCAN_ECR_TEC_Pos                   (0U)
#define FDCAN_ECR_TEC_Msk                   (0xFFUL << FDCAN_ECR_TEC_Pos)           /*!< 0x000000FF */
#define FDCAN_ECR_TEC                       FDCAN_ECR_TEC_Msk                       /*!<Transmit Error Counter                   */
#define FDCAN_ECR_REC_Pos                   (8U)
#define FDCAN_ECR_REC_Msk                   (0x7FUL << FDCAN_ECR_REC_Pos)           /*!< 0x00007F00 */
#define FDCAN_ECR_REC                       FDCAN_ECR_REC_Msk                       /*!<Receive Error Counter                    */
#define FDCAN_ECR_RP_Pos                    (15U)
#define FDCAN_ECR_RP_Msk                    (0x1UL << FDCAN_ECR_RP_Pos)             /*!< 0x00008000 */
#define FDCAN_ECR_RP                        FDCAN_ECR_RP_Msk                        /*!<Receive Error Passive                    */
#define FDCAN_ECR_CEL_Pos                   (16U)
#define FDCAN_ECR_CEL_Msk                   (0xFFUL << FDCAN_ECR_CEL_Pos)           /*!< 0x00FF0000 */
#define FDCAN_ECR_CEL                       FDCAN_ECR_CEL_Msk                       /*!<CAN Error Logging                        */

/*****************  Bit definition for FDCAN_PSR register  ******************** */
#define FDCAN_PSR_LEC_Pos                   (0U)
#define FDCAN_PSR_LEC_Msk                   (0x7UL << FDCAN_PSR_LEC_Pos)            /*!< 0x00000007 */
#define FDCAN_PSR_LEC                       FDCAN_PSR_LEC_Msk                       /*!<Last Error Code                          */
#define FDCAN_PSR_ACT_Pos                   (3U)
#define FDCAN_PSR_ACT_Msk                   (0x3UL << FDCAN_PSR_ACT_Pos)            /*!< 0x00000018 */
#define FDCAN_PSR_ACT                       FDCAN_PSR_ACT_Msk                       /*!<Activity                                 */
#define FDCAN_PSR_EP_Pos                    (5U)
#define FDCAN_PSR_EP_Msk                    (0x1UL << FDCAN_PSR_EP_Pos)             /*!< 0x00000020 */
#define FDCAN_PSR_EP                        FDCAN_PSR_EP_Msk                        /*!<Error Passive                            */
#define FDCAN_PSR_EW_Pos                    (6U)
#define FDCAN_PSR_EW_Msk                    (0x1UL << FDCAN_PSR_EW_Pos)             /*!< 0x00000040 */
#define FDCAN_PSR_EW                        FDCAN_PSR_EW_Msk                        /*!<Warning Status                           */
#define FDCAN_PSR_BO_Pos                    (7U)
#define FDCAN_PSR_BO_Msk                    (0x1UL << FDCAN_PSR_BO_Pos)             /*!< 0x00000080 */
#define FDCAN_PSR_BO                        FDCAN_PSR_BO_Msk                        /*!<Bus_Off Status                           */
#define FDCAN_PSR_DLEC_Pos                  (8U)
#define FDCAN_PSR_DLEC_Msk                  (0x7UL << FDCAN_PSR_DLEC_Pos)           /*!< 0x00000700 */
#define FDCAN_PSR_DLEC                      FDCAN_PSR_DLEC_Msk                      /*!<Data Last Error Code                     */
#define FDCAN_PSR_RESI_Pos                  (11U)
#define FDCAN_PSR_RESI_Msk                  (0x1UL << FDCAN_PSR_RESI_Pos)           /*!< 0x00000800 */
#define FDCAN_PSR_RESI                      FDCAN_PSR_RESI_Msk                      /*!<ESI flag of last received FDCAN Message  */
#define FDCAN_PSR_RBRS_Pos                  (12U)
#define FDCAN_PSR_RBRS_Msk                  (0x1UL << FDCAN_PSR_RBRS_Pos)           /*!< 0x00001000 */
#define FDCAN_PSR_RBRS                      FDCAN_PSR_RBRS_Msk                      /*!<BRS flag of last received FDCAN Message  */
#define FDCAN_PSR_REDL_Pos                  (13U)
#define FDCAN_PSR_REDL_Msk                  (0x1UL << FDCAN_PSR_REDL_Pos)           /*!< 0x00002000 */
#define FDCAN_PSR_REDL                      FDCAN_PSR_REDL_Msk                      /*!<Received FDCAN Message                   */
#define FDCAN_PSR_PXE_Pos                   (14U)
#define FDCAN_PSR_PXE_Msk                   (0x1UL << FDCAN_PSR_PXE_Pos)            /*!< 0x00004000 */
#define FDCAN_PSR_PXE                       FDCAN_PSR_PXE_Msk                       /*!<Protocol Exception Event                 */
#define FDCAN_PSR_TDCV_Pos                  (16U)
#define FDCAN_PSR_TDCV_Msk                  (0x7FUL << FDCAN_PSR_TDCV_Pos)          /*!< 0x007F0000 */
#define FDCAN_PSR_TDCV                      FDCAN_PSR_TDCV_Msk                      /*!<Transmitter Delay Compensation Value     */

/*****************  Bit definition for FDCAN_TDCR register  ******************* */
#define FDCAN_TDCR_TDCF_Pos                 (0U)
#define FDCAN_TDCR_TDCF_Msk                 (0x7FUL << FDCAN_TDCR_TDCF_Pos)         /*!< 0x0000007F */
#define FDCAN_TDCR_TDCF                     FDCAN_TDCR_TDCF_Msk                     /*!<Transmitter Delay Compensation Filter    */
#define FDCAN_TDCR_TDCO_Pos                 (8U)
#define FDCAN_TDCR_TDCO_Msk                 (0x7FUL << FDCAN_TDCR_TDCO_Pos)         /*!< 0x00007F00 */
#define FDCAN_TDCR_TDCO                     FDCAN_TDCR_TDCO_Msk                     /*!<Transmitter Delay Compensation Offset    */

/*****************  Bit definition for FDCAN_IR register  ********************* */
#define FDCAN_IR_RF0N_Pos                   (0U)
#define FDCAN_IR_RF0N_Msk                   (0x1UL << FDCAN_IR_RF0N_Pos)            /*!< 0x00000001 */
#define FDCAN_IR_RF0N                       FDCAN_IR_RF0N_Msk                       /*!<Rx FIFO 0 New Message                    */
#define FDCAN_IR_RF0F_Pos                   (1U)
#define FDCAN_IR_RF0F_Msk                   (0x1UL << FDCAN_IR_RF0F_Pos)            /*!< 0x00000002 */
#define FDCAN_IR_RF0F                       FDCAN_IR_RF0F_Msk                       /*!<Rx FIFO 0 Full                           */
#define FDCAN_IR_RF0L_Pos                   (2U)
#define FDCAN_IR_RF0L_Msk                   (0x1UL << FDCAN_IR_RF0L_Pos)            /*!< 0x00000004 */
#define FDCAN_IR_RF0L                       FDCAN_IR_RF0L_Msk                       /*!<Rx FIFO 0 Message Lost                   */
#define FDCAN_IR_RF1N_Pos                   (3U)
#define FDCAN_IR_RF1N_Msk                   (0x1UL << FDCAN_IR_RF1N_Pos)            /*!< 0x00000008 */
#define FDCAN_IR_RF1N                       FDCAN_IR_RF1N_Msk                       /*!<Rx FIFO 1 New Message                    */
#define FDCAN_IR_RF1F_Pos                   (4U)
#define FDCAN_IR_RF1F_Msk                   (0x1UL << FDCAN_IR_RF1F_Pos)            /*!< 0x00000010 */
#define FDCAN_IR_RF1F                       FDCAN_IR_RF1F_Msk                       /*!<Rx FIFO 1 Full                           */
#define FDCAN_IR_RF1L_Pos                   (5U)
#define FDCAN_IR_RF1L_Msk                   (0x1UL << FDCAN_IR_RF1L_Pos)            /*!< 0x00000020 */
#define FDCAN_IR_RF1L                       FDCAN_IR_RF1L_Msk                       /*!<Rx FIFO 1 Message Lost                   */
#define FDCAN_IR_HPM_Pos                    (6U)
#define FDCAN_IR_HPM_Msk                    (0x1UL << FDCAN_IR_HPM_Pos)             /*!< 0x00000040 */
#define FDCAN_IR_HPM                        FDCAN_IR_HPM_Msk                        /*!<High Priority Message                    */
#define FDCAN_IR_TC_Pos                     (7U)
#define FDCAN_IR_TC_Msk                     (0x1UL << FDCAN_IR_TC_Pos)              /*!< 0x00000080 */
#define FDCAN_IR_TC                         FDCAN_IR_TC_Msk                         /*!<Transmission Completed                   */
#define FDCAN_IR_TCF_Pos                    (8U)
#define FDCAN_IR_TCF_Msk                    (0x1UL << FDCAN_IR_TCF_Pos)             /*!< 0x00000100 */
#define FDCAN_IR_TCF                        FDCAN_IR_TCF_Msk                        /*!<Transmission Cancellation Finished       */
#define FDCAN_IR_TFE_Pos                    (9U)
#define FDCAN_IR_TFE_Msk                    (0x1UL << FDCAN_IR_TFE_Pos)             /*!< 0x00000200 */
#define FDCAN_IR_TFE                        FDCAN_IR_TFE_Msk                        /*!<Tx FIFO Empty                            */
#define FDCAN_IR_TEFN_Pos                   (10U)
#define FDCAN_IR_TEFN_Msk                   (0x1UL << FDCAN_IR_TEFN_Pos)            /*!< 0x00000400 */
#define FDCAN_IR_TEFN                       FDCAN_IR_TEFN_Msk                       /*!<Tx Event FIFO New Entry                  */
#define FDCAN_IR_TEFF_Pos                   (11U)
#define FDCAN_IR_TEFF_Msk                   (0x1UL << FDCAN_IR_TEFF_Pos)            /*!< 0x00000800 */
#define FDCAN_IR_TEFF                       FDCAN_IR_TEFF_Msk                       /*!<Tx Event FIFO Full                       */
#define FDCAN_IR_TEFL_Pos                   (12U)
#define FDCAN_IR_TEFL_Msk                   (0x1UL << FDCAN_IR_TEFL_Pos)            /*!< 0x00001000 */
#define FDCAN_IR_TEFL                       FDCAN_IR_TEFL_Msk                       /*!<Tx Event FIFO Element Lost               */
#define FDCAN_IR_TSW_Pos                    (13U)
#define FDCAN_IR_TSW_Msk                    (0x1UL << FDCAN_IR_TSW_Pos)             /*!< 0x00002000 */
#define FDCAN_IR_TSW                        FDCAN_IR_TSW_Msk                        /*!<Timestamp Wraparound                     */
#define FDCAN_IR_MRAF_Pos                   (14U)
#define FDCAN_IR_MRAF_Msk                   (0x1UL << FDCAN_IR_MRAF_Pos)            /*!< 0x00004000 */
#define FDCAN_IR_MRAF                       FDCAN_IR_MRAF_Msk                       /*!<Message RAM Access Failure               */
#define FDCAN_IR_TOO_Pos                    (15U)
#define FDCAN_IR_TOO_Msk                    (0x1UL << FDCAN_IR_TOO_Pos)             /*!< 0x00008000 */
#define FDCAN_IR_TOO                        FDCAN_IR_TOO_Msk                        /*!<Timeout Occurred                         */
#define FDCAN_IR_ELO_Pos                    (16U)
#define FDCAN_IR_ELO_Msk                    (0x1UL << FDCAN_IR_ELO_Pos)             /*!< 0x00010000 */
#define FDCAN_IR_ELO                        FDCAN_IR_ELO_Msk                        /*!<Error Logging Overflow                   */
#define FDCAN_IR_EP_Pos                     (17U)
#define FDCAN_IR_EP_Msk                     (0x1UL << FDCAN_IR_EP_Pos)              /*!< 0x00020000 */
#define FDCAN_IR_EP                         FDCAN_IR_EP_Msk                         /*!<Error Passive                            */
#define FDCAN_IR_EW_Pos                     (18U)
#define FDCAN_IR_EW_Msk                     (0x1UL << FDCAN_IR_EW_Pos)              /*!< 0x00040000 */
#define FDCAN_IR_EW                         FDCAN_IR_EW_Msk                         /*!<Warning Status                           */
#define FDCAN_IR_BO_Pos                     (19U)
#define FDCAN_IR_BO_Msk                     (0x1UL << FDCAN_IR_BO_Pos)              /*!< 0x00080000 */
#define FDCAN_IR_BO                         FDCAN_IR_BO_Msk                         /*!<Bus_Off Status                           */
#define FDCAN_IR_WDI_Pos                    (20U)
#define FDCAN_IR_WDI_Msk                    (0x1UL << FDCAN_IR_WDI_Pos)             /*!< 0x00100000 */
#define FDCAN_IR_WDI                        FDCAN_IR_WDI_Msk                        /*!<Watchdog Interrupt                       */
#define FDCAN_IR_PEA_Pos                    (21U)
#define FDCAN_IR_PEA_Msk                    (0x1UL << FDCAN_IR_PEA_Pos)             /*!< 0x00200000 */
#define FDCAN_IR_PEA                        FDCAN_IR_PEA_Msk                        /*!<Protocol Error in Arbitration Phase      */
#define FDCAN_IR_PED_Pos                    (22U)
#define FDCAN_IR_PED_Msk                    (0x1UL << FDCAN_IR_PED_Pos)             /*!< 0x00400000 */
#define FDCAN_IR_PED                        FDCAN_IR_PED_Msk                        /*!<Protocol Error in Data Phase             */
#define FDCAN_IR_ARA_Pos                    (23U)
#define FDCAN_IR_ARA_Msk                    (0x1UL << FDCAN_IR_ARA_Pos)             /*!< 0x00800000 */
#define FDCAN_IR_ARA                        FDCAN_IR_ARA_Msk                        /*!<Access to Reserved Address               */

/*****************  Bit definition for FDCAN_IE register  ********************* */
#define FDCAN_IE_RF0NE_Pos                  (0U)
#define FDCAN_IE_RF0NE_Msk                  (0x1UL << FDCAN_IE_RF0NE_Pos)           /*!< 0x00000001 */
#define FDCAN_IE_RF0NE                      FDCAN_IE_RF0NE_Msk                      /*!<Rx FIFO 0 New Message Enable             */
#define FDCAN_IE_RF0FE_Pos                  (1U)
#define FDCAN_IE_RF0FE_Msk                  (0x1UL << FDCAN_IE_RF0FE_Pos)           /*!< 0x00000002 */
#define FDCAN_IE_RF0FE                      FDCAN_IE_RF0FE_Msk                      /*!<Rx FIFO 0 Full Enable                    */
#define FDCAN_IE_RF0LE_Pos                  (2U)
#define FDCAN_IE_RF0LE_Msk                  (0x1UL << FDCAN_IE_RF0LE_Pos)           /*!< 0x00000004 */
#define FDCAN_IE_RF0LE                      FDCAN_IE_RF0LE_Msk                      /*!<Rx FIFO 0 Message Lost Enable            */
#define FDCAN_IE_RF1NE_Pos                  (3U)
#define FDCAN_IE_RF1NE_Msk                  (0x1UL << FDCAN_IE_RF1NE_Pos)           /*!< 0x00000008 */
#define FDCAN_IE_RF1NE                      FDCAN_IE_RF1NE_Msk                      /*!<Rx FIFO 1 New Message Enable             */
#define FDCAN_IE_RF1FE_Pos                  (4U)
#define FDCAN_IE_RF1FE_Msk                  (0x1UL << FDCAN_IE_RF1FE_Pos)           /*!< 0x00000010 */
#define FDCAN_IE_RF1FE                      FDCAN_IE_RF1FE_Msk                      /*!<Rx FIFO 1 Full Enable                    */
#define FDCAN_IE_RF1LE_Pos                  (5U)
#define FDCAN_IE_RF1LE_Msk                  (0x1UL << FDCAN_IE_RF1LE_Pos)           /*!< 0x00000020 */
#define FDCAN_IE_RF1LE                      FDCAN_IE_RF1LE_Msk                      /*!<Rx FIFO 1 Message Lost Enable            */
#define FDCAN_IE_HPME_Pos                   (6U)
#define FDCAN_IE_HPME_Msk                   (0x1UL << FDCAN_IE_HPME_Pos)            /*!< 0x00000040 */
#define FDCAN_IE_HPME                       FDCAN_IE_HPME_Msk                       /*!<High Priority Message Enable             */
#define FDCAN_IE_TCE_Pos                    (7U)
#define FDCAN_IE_TCE_Msk                    (0x1UL << FDCAN_IE_TCE_Pos)             /*!< 0x00000080 */
#define FDCAN_IE_TCE                        FDCAN_IE_TCE_Msk                        /*!<Transmission Completed Enable            */
#define FDCAN_IE_TCFE_Pos                   (8U)
#define FDCAN_IE_TCFE_Msk                   (0x1UL << FDCAN_IE_TCFE_Pos)            /*!< 0x00000100 */
#define FDCAN_IE_TCFE                       FDCAN_IE_TCFE_Msk                       /*!<Transmission Cancellation Finished Enable*/
#define FDCAN_IE_TFEE_Pos                   (9U)
#define FDCAN_IE_TFEE_Msk                   (0x1UL << FDCAN_IE_TFEE_Pos)            /*!< 0x00000200 */
#define FDCAN_IE_TFEE                       FDCAN_IE_TFEE_Msk                       /*!<Tx FIFO Empty Enable                     */
#define FDCAN_IE_TEFNE_Pos                  (10U)
#define FDCAN_IE_TEFNE_Msk                  (0x1UL << FDCAN_IE_TEFNE_Pos)           /*!< 0x00000400 */
#define FDCAN_IE_TEFNE                      FDCAN_IE_TEFNE_Msk                      /*!<Tx Event FIFO New Entry Enable           */
#define FDCAN_IE_TEFFE_Pos                  (11U)
#define FDCAN_IE_TEFFE_Msk                  (0x1UL << FDCAN_IE_TEFFE_Pos)           /*!< 0x00000800 */
#define FDCAN_IE_TEFFE                      FDCAN_IE_TEFFE_Msk                      /*!<Tx Event FIFO Full Enable                */
#define FDCAN_IE_TEFLE_Pos                  (12U)
#define FDCAN_IE_TEFLE_Msk                  (0x1UL << FDCAN_IE_TEFLE_Pos)           /*!< 0x00001000 */
#define FDCAN_IE_TEFLE                      FDCAN_IE_TEFLE_Msk                      /*!<Tx Event FIFO Element Lost Enable        */
#define FDCAN_IE_TSWE_Pos                   (13U)
#define FDCAN_IE_TSWE_Msk                   (0x1UL << FDCAN_IE_TSWE_Pos)            /*!< 0x00002000 */
#define FDCAN_IE_TSWE                       FDCAN_IE_TSWE_Msk                       /*!<Timestamp Wraparound Enable              */
#define FDCAN_IE_MRAFE_Pos                  (14U)
#define FDCAN_IE_MRAFE_Msk                  (0x1UL << FDCAN_IE_MRAFE_Pos)           /*!< 0x00004000 */
#define FDCAN_IE_MRAFE                      FDCAN_IE_MRAFE_Msk                      /*!<Message RAM Access Failure Enable        */
#define FDCAN_IE_TOOE_Pos                   (15U)
#define FDCAN_IE_TOOE_Msk                   (0x1UL << FDCAN_IE_TOOE_Pos)            /*!< 0x00008000 */
#define FDCAN_IE_TOOE                       FDCAN_IE_TOOE_Msk                       /*!<Timeout Occurred Enable                  */
#define FDCAN_IE_ELOE_Pos                   (16U)
#define FDCAN_IE_ELOE_Msk                   (0x1UL << FDCAN_IE_ELOE_Pos)            /*!< 0x00010000 */
#define FDCAN_IE_ELOE                       FDCAN_IE_ELOE_Msk                       /*!<Error Logging Overflow Enable            */
#define FDCAN_IE_EPE_Pos                    (17U)
#define FDCAN_IE_EPE_Msk                    (0x1UL << FDCAN_IE_EPE_Pos)             /*!< 0x00020000 */
#define FDCAN_IE_EPE                        FDCAN_IE_EPE_Msk                        /*!<Error Passive Enable                     */
#define FDCAN_IE_EWE_Pos                    (18U)
#define FDCAN_IE_EWE_Msk                    (0x1UL << FDCAN_IE_EWE_Pos)             /*!< 0x00040000 */
#define FDCAN_IE_EWE                        FDCAN_IE_EWE_Msk                        /*!<Warning Status Enable                    */
#define FDCAN_IE_BOE_Pos                    (19U)
#define FDCAN_IE_BOE_Msk                    (0x1UL << FDCAN_IE_BOE_Pos)             /*!< 0x00080000 */
#define FDCAN_IE_BOE                        FDCAN_IE_BOE_Msk                        /*!<Bus_Off Status Enable                    */
#define FDCAN_IE_WDIE_Pos                   (20U)
#define FDCAN_IE_WDIE_Msk                   (0x1UL << FDCAN_IE_WDIE_Pos)            /*!< 0x00100000 */
#define FDCAN_IE_WDIE                       FDCAN_IE_WDIE_Msk                       /*!<Watchdog Interrupt Enable                */
#define FDCAN_IE_PEAE_Pos                   (21U)
#define FDCAN_IE_PEAE_Msk                   (0x1UL << FDCAN_IE_PEAE_Pos)            /*!< 0x00200000 */
#define FDCAN_IE_PEAE                       FDCAN_IE_PEAE_Msk                       /*!<Protocol Error in Arbitration Phase Enable*/
#define FDCAN_IE_PEDE_Pos                   (22U)
#define FDCAN_IE_PEDE_Msk                   (0x1UL << FDCAN_IE_PEDE_Pos)            /*!< 0x00400000 */
#define FDCAN_IE_PEDE                       FDCAN_IE_PEDE_Msk                       /*!<Protocol Error in Data Phase Enable      */
#define FDCAN_IE_ARAE_Pos                   (23U)
#define FDCAN_IE_ARAE_Msk                   (0x1UL << FDCAN_IE_ARAE_Pos)            /*!< 0x00800000 */
#define FDCAN_IE_ARAE                       FDCAN_IE_ARAE_Msk                       /*!<Access to Reserved Address Enable        */

/*****************  Bit definition for FDCAN_ILS register  ******************** **/
#define FDCAN_ILS_RXFIFO0_Pos               (0U)
#define FDCAN_ILS_RXFIFO0_Msk               (0x1UL << FDCAN_ILS_RXFIFO0_Pos)        /*!< 0x00000001 */
#define FDCAN_ILS_RXFIFO0                   FDCAN_ILS_RXFIFO0_Msk                   /*!<Rx FIFO 0 Message Lost
                                                                                        Rx FIFO 0 is Full
                                                                                        Rx FIFO 0 Has New Message                */
#define FDCAN_ILS_RXFIFO1_Pos               (1U)
#define FDCAN_ILS_RXFIFO1_Msk               (0x1UL << FDCAN_ILS_RXFIFO1_Pos)        /*!< 0x00000002 */
#define FDCAN_ILS_RXFIFO1                   FDCAN_ILS_RXFIFO1_Msk                   /*!<Rx FIFO 1 Message Lost
                                                                                        Rx FIFO 1 is Full
                                                                                        Rx FIFO 1 Has New Message                */
#define FDCAN_ILS_SMSG_Pos                  (2U)
#define FDCAN_ILS_SMSG_Msk                  (0x1UL << FDCAN_ILS_SMSG_Pos)           /*!< 0x00000004 */
#define FDCAN_ILS_SMSG                      FDCAN_ILS_SMSG_Msk                      /*!<Transmission Cancellation Finished
                                                                                        Transmission Completed
                                                                                        High Priority Message                    */
#define FDCAN_ILS_TFERR_Pos                 (3U)
#define FDCAN_ILS_TFERR_Msk                 (0x1UL << FDCAN_ILS_TFERR_Pos)          /*!< 0x00000008 */
#define FDCAN_ILS_TFERR                     FDCAN_ILS_TFERR_Msk                     /*!<Tx Event FIFO Element Lost
                                                                                        Tx Event FIFO Full
                                                                                        Tx Event FIFO New Entry
                                                                                        Tx FIFO Empty Interrupt Line             */
#define FDCAN_ILS_MISC_Pos                  (4U)
#define FDCAN_ILS_MISC_Msk                  (0x1UL << FDCAN_ILS_MISC_Pos)           /*!< 0x00000010 */
#define FDCAN_ILS_MISC                      FDCAN_ILS_MISC_Msk                      /*!<Timeout Occurred
                                                                                        Message RAM Access Failure
                                                                                        Timestamp Wraparound                    */
#define FDCAN_ILS_BERR_Pos                  (5U)
#define FDCAN_ILS_BERR_Msk                  (0x1UL << FDCAN_ILS_BERR_Pos)           /*!< 0x00000020 */
#define FDCAN_ILS_BERR                      FDCAN_ILS_BERR_Msk                      /*!<Error Passive
                                                                                        Error Logging Overflow                   */
#define FDCAN_ILS_PERR_Pos                  (6U)
#define FDCAN_ILS_PERR_Msk                  (0x1UL << FDCAN_ILS_PERR_Pos)           /*!< 0x00000040 */
#define FDCAN_ILS_PERR                      FDCAN_ILS_PERR_Msk                      /*!<Access to Reserved Address Line
                                                                                        Protocol Error in Data Phase Line
                                                                                        Protocol Error in Arbitration Phase Line
                                                                                        Watchdog Interrupt Line
                                                                                        Bus_Off Status
                                                                                        Warning Status                           */

/*****************  Bit definition for FDCAN_ILE register  ******************** **/
#define FDCAN_ILE_EINT0_Pos                 (0U)
#define FDCAN_ILE_EINT0_Msk                 (0x1UL << FDCAN_ILE_EINT0_Pos)          /*!< 0x00000001 */
#define FDCAN_ILE_EINT0                     FDCAN_ILE_EINT0_Msk                     /*!<Enable Interrupt Line 0                  */
#define FDCAN_ILE_EINT1_Pos                 (1U)
#define FDCAN_ILE_EINT1_Msk                 (0x1UL << FDCAN_ILE_EINT1_Pos)          /*!< 0x00000002 */
#define FDCAN_ILE_EINT1                     FDCAN_ILE_EINT1_Msk                     /*!<Enable Interrupt Line 1                  */

/*****************  Bit definition for FDCAN_RXGFC register  ****************** **/
#define FDCAN_RXGFC_RRFE_Pos                (0U)
#define FDCAN_RXGFC_RRFE_Msk                (0x1UL << FDCAN_RXGFC_RRFE_Pos)         /*!< 0x00000001 */
#define FDCAN_RXGFC_RRFE                    FDCAN_RXGFC_RRFE_Msk                    /*!<Reject Remote Frames Extended            */
#define FDCAN_RXGFC_RRFS_Pos                (1U)
#define FDCAN_RXGFC_RRFS_Msk                (0x1UL << FDCAN_RXGFC_RRFS_Pos)         /*!< 0x00000002 */
#define FDCAN_RXGFC_RRFS                    FDCAN_RXGFC_RRFS_Msk                    /*!<Reject Remote Frames Standard            */
#define FDCAN_RXGFC_ANFE_Pos                (2U)
#define FDCAN_RXGFC_ANFE_Msk                (0x3UL << FDCAN_RXGFC_ANFE_Pos)         /*!< 0x0000000C */
#define FDCAN_RXGFC_ANFE                    FDCAN_RXGFC_ANFE_Msk                    /*!<Accept Non-matching Frames Extended      */
#define FDCAN_RXGFC_ANFS_Pos                (4U)
#define FDCAN_RXGFC_ANFS_Msk                (0x3UL << FDCAN_RXGFC_ANFS_Pos)         /*!< 0x00000030 */
#define FDCAN_RXGFC_ANFS                    FDCAN_RXGFC_ANFS_Msk                    /*!<Accept Non-matching Frames Standard      */
#define FDCAN_RXGFC_F1OM_Pos                (8U)
#define FDCAN_RXGFC_F1OM_Msk                (0x1UL << FDCAN_RXGFC_F1OM_Pos)         /*!< 0x00000100 */
#define FDCAN_RXGFC_F1OM                    FDCAN_RXGFC_F1OM_Msk                    /*!<FIFO 1 operation mode                    */
#define FDCAN_RXGFC_F0OM_Pos                (9U)
#define FDCAN_RXGFC_F0OM_Msk                (0x1UL << FDCAN_RXGFC_F0OM_Pos)         /*!< 0x00000200 */
#define FDCAN_RXGFC_F0OM                    FDCAN_RXGFC_F0OM_Msk                    /*!<FIFO 0 operation mode                    */
#define FDCAN_RXGFC_LSS_Pos                 (16U)
#define FDCAN_RXGFC_LSS_Msk                 (0x1FUL << FDCAN_RXGFC_LSS_Pos)         /*!< 0x001F0000 */
#define FDCAN_RXGFC_LSS                     FDCAN_RXGFC_LSS_Msk                     /*!<List Size Standard                       */
#define FDCAN_RXGFC_LSE_Pos                 (24U)
#define FDCAN_RXGFC_LSE_Msk                 (0xFUL << FDCAN_RXGFC_LSE_Pos)          /*!< 0x0F000000 */
#define FDCAN_RXGFC_LSE                     FDCAN_RXGFC_LSE_Msk                     /*!<List Size Extended                       */

/*****************  Bit definition for FDCAN_XIDAM register  ****************** **/
#define FDCAN_XIDAM_EIDM_Pos                (0U)
#define FDCAN_XIDAM_EIDM_Msk                (0x1FFFFFFFUL << FDCAN_XIDAM_EIDM_Pos)  /*!< 0x1FFFFFFF */
#define FDCAN_XIDAM_EIDM                    FDCAN_XIDAM_EIDM_Msk                    /*!<Extended ID Mask                         */

/*****************  Bit definition for FDCAN_HPMS register  ******************* **/
#define FDCAN_HPMS_BIDX_Pos                 (0U)
#define FDCAN_HPMS_BIDX_Msk                 (0x7UL << FDCAN_HPMS_BIDX_Pos)          /*!< 0x00000007 */
#define FDCAN_HPMS_BIDX                     FDCAN_HPMS_BIDX_Msk                     /*!<Buffer Index                             */
#define FDCAN_HPMS_MSI_Pos                  (6U)
#define FDCAN_HPMS_MSI_Msk                  (0x3UL << FDCAN_HPMS_MSI_Pos)           /*!< 0x000000C0 */
#define FDCAN_HPMS_MSI                      FDCAN_HPMS_MSI_Msk                      /*!<Message Storage Indicator                */
#define FDCAN_HPMS_FIDX_Pos                 (8U)
#define FDCAN_HPMS_FIDX_Msk                 (0x1FUL << FDCAN_HPMS_FIDX_Pos)         /*!< 0x00001F00 */
#define FDCAN_HPMS_FIDX                     FDCAN_HPMS_FIDX_Msk                     /*!<Filter Index                             */
#define FDCAN_HPMS_FLST_Pos                 (15U)
#define FDCAN_HPMS_FLST_Msk                 (0x1UL << FDCAN_HPMS_FLST_Pos)          /*!< 0x00008000 */
#define FDCAN_HPMS_FLST                     FDCAN_HPMS_FLST_Msk                     /*!<Filter List                              */

/*****************  Bit definition for FDCAN_RXF0S register  ****************** **/
#define FDCAN_RXF0S_F0FL_Pos                (0U)
#define FDCAN_RXF0S_F0FL_Msk                (0xFUL << FDCAN_RXF0S_F0FL_Pos)         /*!< 0x0000000F */
#define FDCAN_RXF0S_F0FL                    FDCAN_RXF0S_F0FL_Msk                    /*!<Rx FIFO 0 Fill Level                     */
#define FDCAN_RXF0S_F0GI_Pos                (8U)
#define FDCAN_RXF0S_F0GI_Msk                (0x3UL << FDCAN_RXF0S_F0GI_Pos)         /*!< 0x00000300 */
#define FDCAN_RXF0S_F0GI                    FDCAN_RXF0S_F0GI_Msk                    /*!<Rx FIFO 0 Get Index                      */
#define FDCAN_RXF0S_F0PI_Pos                (16U)
#define FDCAN_RXF0S_F0PI_Msk                (0x3UL << FDCAN_RXF0S_F0PI_Pos)         /*!< 0x00030000 */
#define FDCAN_RXF0S_F0PI                    FDCAN_RXF0S_F0PI_Msk                    /*!<Rx FIFO 0 Put Index                      */
#define FDCAN_RXF0S_F0F_Pos                 (24U)
#define FDCAN_RXF0S_F0F_Msk                 (0x1UL << FDCAN_RXF0S_F0F_Pos)          /*!< 0x01000000 */
#define FDCAN_RXF0S_F0F                     FDCAN_RXF0S_F0F_Msk                     /*!<Rx FIFO 0 Full                           */
#define FDCAN_RXF0S_RF0L_Pos                (25U)
#define FDCAN_RXF0S_RF0L_Msk                (0x1UL << FDCAN_RXF0S_RF0L_Pos)         /*!< 0x02000000 */
#define FDCAN_RXF0S_RF0L                    FDCAN_RXF0S_RF0L_Msk                    /*!<Rx FIFO 0 Message Lost                   */

/*****************  Bit definition for FDCAN_RXF0A register  ****************** **/
#define FDCAN_RXF0A_F0AI_Pos                (0U)
#define FDCAN_RXF0A_F0AI_Msk                (0x7UL << FDCAN_RXF0A_F0AI_Pos)         /*!< 0x00000007 */
#define FDCAN_RXF0A_F0AI                    FDCAN_RXF0A_F0AI_Msk                    /*!<Rx FIFO 0 Acknowledge Index              */

/*****************  Bit definition for FDCAN_RXF1S register  ****************** **/
#define FDCAN_RXF1S_F1FL_Pos                (0U)
#define FDCAN_RXF1S_F1FL_Msk                (0xFUL << FDCAN_RXF1S_F1FL_Pos)         /*!< 0x0000000F */
#define FDCAN_RXF1S_F1FL                    FDCAN_RXF1S_F1FL_Msk                    /*!<Rx FIFO 1 Fill Level                     */
#define FDCAN_RXF1S_F1GI_Pos                (8U)
#define FDCAN_RXF1S_F1GI_Msk                (0x3UL << FDCAN_RXF1S_F1GI_Pos)         /*!< 0x00000300 */
#define FDCAN_RXF1S_F1GI                    FDCAN_RXF1S_F1GI_Msk                    /*!<Rx FIFO 1 Get Index                      */
#define FDCAN_RXF1S_F1PI_Pos                (16U)
#define FDCAN_RXF1S_F1PI_Msk                (0x3UL << FDCAN_RXF1S_F1PI_Pos)         /*!< 0x00030000 */
#define FDCAN_RXF1S_F1PI                    FDCAN_RXF1S_F1PI_Msk                    /*!<Rx FIFO 1 Put Index                      */
#define FDCAN_RXF1S_F1F_Pos                 (24U)
#define FDCAN_RXF1S_F1F_Msk                 (0x1UL << FDCAN_RXF1S_F1F_Pos)          /*!< 0x01000000 */
#define FDCAN_RXF1S_F1F                     FDCAN_RXF1S_F1F_Msk                     /*!<Rx FIFO 1 Full                           */
#define FDCAN_RXF1S_RF1L_Pos                (25U)
#define FDCAN_RXF1S_RF1L_Msk                (0x1UL << FDCAN_RXF1S_RF1L_Pos)         /*!< 0x02000000 */
#define FDCAN_RXF1S_RF1L                    FDCAN_RXF1S_RF1L_Msk                    /*!<Rx FIFO 1 Message Lost                   */

/*****************  Bit definition for FDCAN_RXF1A register  ****************** **/
#define FDCAN_RXF1A_F1AI_Pos                (0U)
#define FDCAN_RXF1A_F1AI_Msk                (0x7UL << FDCAN_RXF1A_F1AI_Pos)         /*!< 0x00000007 */
#define FDCAN_RXF1A_F1AI                    FDCAN_RXF1A_F1AI_Msk                    /*!<Rx FIFO 1 Acknowledge Index              */

/*****************  Bit definition for FDCAN_TXBC register  ******************* **/
#define FDCAN_TXBC_TFQM_Pos                 (24U)
#define FDCAN_TXBC_TFQM_Msk                 (0x1UL << FDCAN_TXBC_TFQM_Pos)          /*!< 0x01000000 */
#define FDCAN_TXBC_TFQM                     FDCAN_TXBC_TFQM_Msk                     /*!<Tx FIFO/Queue Mode                       */

/*****************  Bit definition for FDCAN_TXFQS register  ****************** ***/
#define FDCAN_TXFQS_TFFL_Pos                (0U)
#define FDCAN_TXFQS_TFFL_Msk                (0x7UL << FDCAN_TXFQS_TFFL_Pos)         /*!< 0x00000007 */
#define FDCAN_TXFQS_TFFL                    FDCAN_TXFQS_TFFL_Msk                    /*!<Tx FIFO Free Level                       */
#define FDCAN_TXFQS_TFGI_Pos                (8U)
#define FDCAN_TXFQS_TFGI_Msk                (0x3UL << FDCAN_TXFQS_TFGI_Pos)         /*!< 0x00000300 */
#define FDCAN_TXFQS_TFGI                    FDCAN_TXFQS_TFGI_Msk                    /*!<Tx FIFO Get Index                        */
#define FDCAN_TXFQS_TFQPI_Pos               (16U)
#define FDCAN_TXFQS_TFQPI_Msk               (0x3UL << FDCAN_TXFQS_TFQPI_Pos)        /*!< 0x00030000 */
#define FDCAN_TXFQS_TFQPI                   FDCAN_TXFQS_TFQPI_Msk                   /*!<Tx FIFO/Queue Put Index                  */
#define FDCAN_TXFQS_TFQF_Pos                (21U)
#define FDCAN_TXFQS_TFQF_Msk                (0x1UL << FDCAN_TXFQS_TFQF_Pos)         /*!< 0x00200000 */
#define FDCAN_TXFQS_TFQF                    FDCAN_TXFQS_TFQF_Msk                    /*!<Tx FIFO/Queue Full                       */

/*****************  Bit definition for FDCAN_TXBRP register  ****************** ***/
#define FDCAN_TXBRP_TRP_Pos                 (0U)
#define FDCAN_TXBRP_TRP_Msk                 (0x7UL << FDCAN_TXBRP_TRP_Pos)          /*!< 0x00000007 */
#define FDCAN_TXBRP_TRP                     FDCAN_TXBRP_TRP_Msk                     /*!<Transmission Request Pending             */

/*****************  Bit definition for FDCAN_TXBAR register  ****************** ***/
#define FDCAN_TXBAR_AR_Pos                  (0U)
#define FDCAN_TXBAR_AR_Msk                  (0x7UL << FDCAN_TXBAR_AR_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBAR_AR                      FDCAN_TXBAR_AR_Msk                      /*!<Add Request                              */

/*****************  Bit definition for FDCAN_TXBCR register  ****************** ***/
#define FDCAN_TXBCR_CR_Pos                  (0U)
#define FDCAN_TXBCR_CR_Msk                  (0x7UL << FDCAN_TXBCR_CR_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBCR_CR                      FDCAN_TXBCR_CR_Msk                      /*!<Cancellation Request                     */

/*****************  Bit definition for FDCAN_TXBTO register  ****************** ***/
#define FDCAN_TXBTO_TO_Pos                  (0U)
#define FDCAN_TXBTO_TO_Msk                  (0x7UL << FDCAN_TXBTO_TO_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBTO_TO                      FDCAN_TXBTO_TO_Msk                      /*!<Transmission Occurred                    */

/*****************  Bit definition for FDCAN_TXBCF register  ****************** ***/
#define FDCAN_TXBCF_CF_Pos                  (0U)
#define FDCAN_TXBCF_CF_Msk                  (0x7UL << FDCAN_TXBCF_CF_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBCF_CF                      FDCAN_TXBCF_CF_Msk                      /*!<Cancellation Finished                    */

/*****************  Bit definition for FDCAN_TXBTIE register  ***************** ***/
#define FDCAN_TXBTIE_TIE_Pos                (0U)
#define FDCAN_TXBTIE_TIE_Msk                (0x7UL << FDCAN_TXBTIE_TIE_Pos)         /*!< 0x00000007 */
#define FDCAN_TXBTIE_TIE                    FDCAN_TXBTIE_TIE_Msk                    /*!<Transmission Interrupt Enable            */

/*****************  Bit definition for FDCAN_ TXBCIE register  **************** ***/
#define FDCAN_TXBCIE_CFIE_Pos               (0U)
#define FDCAN_TXBCIE_CFIE_Msk               (0x7UL << FDCAN_TXBCIE_CFIE_Pos)        /*!< 0x00000007 */
#define FDCAN_TXBCIE_CFIE                   FDCAN_TXBCIE_CFIE_Msk                   /*!<Cancellation Finished Interrupt Enable   */

/*****************  Bit definition for FDCAN_TXEFS register  ****************** ***/
#define FDCAN_TXEFS_EFFL_Pos                (0U)
#define FDCAN_TXEFS_EFFL_Msk                (0x7UL << FDCAN_TXEFS_EFFL_Pos)         /*!< 0x00000007 */
#define FDCAN_TXEFS_EFFL                    FDCAN_TXEFS_EFFL_Msk                    /*!<Event FIFO Fill Level                    */
#define FDCAN_TXEFS_EFGI_Pos                (8U)
#define FDCAN_TXEFS_EFGI_Msk                (0x3UL << FDCAN_TXEFS_EFGI_Pos)         /*!< 0x00000300 */
#define FDCAN_TXEFS_EFGI                    FDCAN_TXEFS_EFGI_Msk                    /*!<Event FIFO Get Index                     */
#define FDCAN_TXEFS_EFPI_Pos                (16U)
#define FDCAN_TXEFS_EFPI_Msk                (0x3UL << FDCAN_TXEFS_EFPI_Pos)         /*!< 0x00030000 */
#define FDCAN_TXEFS_EFPI                    FDCAN_TXEFS_EFPI_Msk                    /*!<Event FIFO Put Index                     */
#define FDCAN_TXEFS_EFF_Pos                 (24U)
#define FDCAN_TXEFS_EFF_Msk                 (0x1UL << FDCAN_TXEFS_EFF_Pos)          /*!< 0x01000000 */
#define FDCAN_TXEFS_EFF                     FDCAN_TXEFS_EFF_Msk                     /*!<Event FIFO Full                          */
#define FDCAN_TXEFS_TEFL_Pos                (25U)
#define FDCAN_TXEFS_TEFL_Msk                (0x1UL << FDCAN_TXEFS_TEFL_Pos)         /*!< 0x02000000 */
#define FDCAN_TXEFS_TEFL                    FDCAN_TXEFS_TEFL_Msk                    /*!<Tx Event FIFO Element Lost               */

/*****************  Bit definition for FDCAN_TXEFA register  ****************** ***/
#define FDCAN_TXEFA_EFAI_Pos                (0U)
#define FDCAN_TXEFA_EFAI_Msk                (0x3UL << FDCAN_TXEFA_EFAI_Pos)         /*!< 0x00000003 */
#define FDCAN_TXEFA_EFAI                    FDCAN_TXEFA_EFAI_Msk                    /*!<Event FIFO Acknowledge Index             */

/*!<FDCAN config registers */
/*****************  Bit definition for FDCAN_CKDIV register  ****************** ***/
#define FDCAN_CKDIV_PDIV_Pos                (0U)
#define FDCAN_CKDIV_PDIV_Msk                (0xFUL << FDCAN_CKDIV_PDIV_Pos)         /*!< 0x0000000F */
#define FDCAN_CKDIV_PDIV                    FDCAN_CKDIV_PDIV_Msk                    /*!<Input Clock Divider                      */

/******************************************************************************/
/*                                                                            */
/*                          HDMI-CEC (CEC)                                    */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for CEC_CR register  *********************/
#define CEC_CR_CECEN_Pos         (0U)
#define CEC_CR_CECEN_Msk         (0x1UL << CEC_CR_CECEN_Pos)                   /*!< 0x00000001 */
#define CEC_CR_CECEN             CEC_CR_CECEN_Msk                              /*!< CEC Enable                                */
#define CEC_CR_TXSOM_Pos         (1U)
#define CEC_CR_TXSOM_Msk         (0x1UL << CEC_CR_TXSOM_Pos)                   /*!< 0x00000002 */
#define CEC_CR_TXSOM             CEC_CR_TXSOM_Msk                              /*!< CEC Tx Start Of Message                   */
#define CEC_CR_TXEOM_Pos         (2U)
#define CEC_CR_TXEOM_Msk         (0x1UL << CEC_CR_TXEOM_Pos)                   /*!< 0x00000004 */
#define CEC_CR_TXEOM             CEC_CR_TXEOM_Msk                              /*!< CEC Tx End Of Message                     */

/*******************  Bit definition for CEC_CFGR register  *******************/
#define CEC_CFGR_SFT_Pos         (0U)
#define CEC_CFGR_SFT_Msk         (0x7UL << CEC_CFGR_SFT_Pos)                   /*!< 0x00000007 */
#define CEC_CFGR_SFT             CEC_CFGR_SFT_Msk                              /*!< CEC Signal Free Time                      */
#define CEC_CFGR_RXTOL_Pos       (3U)
#define CEC_CFGR_RXTOL_Msk       (0x1UL << CEC_CFGR_RXTOL_Pos)                 /*!< 0x00000008 */
#define CEC_CFGR_RXTOL           CEC_CFGR_RXTOL_Msk                            /*!< CEC Tolerance                             */
#define CEC_CFGR_BRESTP_Pos      (4U)
#define CEC_CFGR_BRESTP_Msk      (0x1UL << CEC_CFGR_BRESTP_Pos)                /*!< 0x00000010 */
#define CEC_CFGR_BRESTP          CEC_CFGR_BRESTP_Msk                           /*!< CEC Rx Stop                               */
#define CEC_CFGR_BREGEN_Pos      (5U)
#define CEC_CFGR_BREGEN_Msk      (0x1UL << CEC_CFGR_BREGEN_Pos)                /*!< 0x00000020 */
#define CEC_CFGR_BREGEN          CEC_CFGR_BREGEN_Msk                           /*!< CEC Bit Rising Error generation           */
#define CEC_CFGR_LBPEGEN_Pos     (6U)
#define CEC_CFGR_LBPEGEN_Msk     (0x1UL << CEC_CFGR_LBPEGEN_Pos)               /*!< 0x00000040 */
#define CEC_CFGR_LBPEGEN         CEC_CFGR_LBPEGEN_Msk                          /*!< CEC Long Bit Period Error generation      */
#define CEC_CFGR_SFTOPT_Pos      (8U)
#define CEC_CFGR_SFTOPT_Msk      (0x1UL << CEC_CFGR_SFTOPT_Pos)                /*!< 0x00000100 */
#define CEC_CFGR_SFTOPT          CEC_CFGR_SFTOPT_Msk                           /*!< CEC Signal Free Time optional             */
#define CEC_CFGR_BRDNOGEN_Pos    (7U)
#define CEC_CFGR_BRDNOGEN_Msk    (0x1UL << CEC_CFGR_BRDNOGEN_Pos)              /*!< 0x00000080 */
#define CEC_CFGR_BRDNOGEN        CEC_CFGR_BRDNOGEN_Msk                         /*!< CEC Broadcast No error generation         */
#define CEC_CFGR_OAR_Pos         (16U)
#define CEC_CFGR_OAR_Msk         (0x7FFFUL << CEC_CFGR_OAR_Pos)                /*!< 0x7FFF0000 */
#define CEC_CFGR_OAR             CEC_CFGR_OAR_Msk                              /*!< CEC Own Address                           */
#define CEC_CFGR_LSTN_Pos        (31U)
#define CEC_CFGR_LSTN_Msk        (0x1UL << CEC_CFGR_LSTN_Pos)                  /*!< 0x80000000 */
#define CEC_CFGR_LSTN            CEC_CFGR_LSTN_Msk                             /*!< CEC Listen mode                           */

/*******************  Bit definition for CEC_TXDR register  *******************/
#define CEC_TXDR_TXD_Pos         (0U)
#define CEC_TXDR_TXD_Msk         (0xFFUL << CEC_TXDR_TXD_Pos)                  /*!< 0x000000FF */
#define CEC_TXDR_TXD             CEC_TXDR_TXD_Msk                              /*!< CEC Tx Data                               */

/*******************  Bit definition for CEC_RXDR register  *******************/
#define CEC_RXDR_RXD_Pos         (0U)
#define CEC_RXDR_RXD_Msk         (0xFFUL << CEC_RXDR_RXD_Pos)                  /*!< 0x000000FF */
#define CEC_RXDR_RXD             CEC_RXDR_RXD_Msk                              /*!< CEC Rx Data                               */

/*******************  Bit definition for CEC_ISR register  ********************/
#define CEC_ISR_RXBR_Pos         (0U)
#define CEC_ISR_RXBR_Msk         (0x1UL << CEC_ISR_RXBR_Pos)                   /*!< 0x00000001 */
#define CEC_ISR_RXBR             CEC_ISR_RXBR_Msk                              /*!< CEC Rx-Byte Received                      */
#define CEC_ISR_RXEND_Pos        (1U)
#define CEC_ISR_RXEND_Msk        (0x1UL << CEC_ISR_RXEND_Pos)                  /*!< 0x00000002 */
#define CEC_ISR_RXEND            CEC_ISR_RXEND_Msk                             /*!< CEC End Of Reception                      */
#define CEC_ISR_RXOVR_Pos        (2U)
#define CEC_ISR_RXOVR_Msk        (0x1UL << CEC_ISR_RXOVR_Pos)                  /*!< 0x00000004 */
#define CEC_ISR_RXOVR            CEC_ISR_RXOVR_Msk                             /*!< CEC Rx-Overrun                            */
#define CEC_ISR_BRE_Pos          (3U)
#define CEC_ISR_BRE_Msk          (0x1UL << CEC_ISR_BRE_Pos)                    /*!< 0x00000008 */
#define CEC_ISR_BRE              CEC_ISR_BRE_Msk                               /*!< CEC Rx Bit Rising Error                   */
#define CEC_ISR_SBPE_Pos         (4U)
#define CEC_ISR_SBPE_Msk         (0x1UL << CEC_ISR_SBPE_Pos)                   /*!< 0x00000010 */
#define CEC_ISR_SBPE             CEC_ISR_SBPE_Msk                              /*!< CEC Rx Short Bit period Error             */
#define CEC_ISR_LBPE_Pos         (5U)
#define CEC_ISR_LBPE_Msk         (0x1UL << CEC_ISR_LBPE_Pos)                   /*!< 0x00000020 */
#define CEC_ISR_LBPE             CEC_ISR_LBPE_Msk                              /*!< CEC Rx Long Bit period Error              */
#define CEC_ISR_RXACKE_Pos       (6U)
#define CEC_ISR_RXACKE_Msk       (0x1UL << CEC_ISR_RXACKE_Pos)                 /*!< 0x00000040 */
#define CEC_ISR_RXACKE           CEC_ISR_RXACKE_Msk                            /*!< CEC Rx Missing Acknowledge                */
#define CEC_ISR_ARBLST_Pos       (7U)
#define CEC_ISR_ARBLST_Msk       (0x1UL << CEC_ISR_ARBLST_Pos)                 /*!< 0x00000080 */
#define CEC_ISR_ARBLST           CEC_ISR_ARBLST_Msk                            /*!< CEC Arbitration Lost                      */
#define CEC_ISR_TXBR_Pos         (8U)
#define CEC_ISR_TXBR_Msk         (0x1UL << CEC_ISR_TXBR_Pos)                   /*!< 0x00000100 */
#define CEC_ISR_TXBR             CEC_ISR_TXBR_Msk                              /*!< CEC Tx Byte Request                       */
#define CEC_ISR_TXEND_Pos        (9U)
#define CEC_ISR_TXEND_Msk        (0x1UL << CEC_ISR_TXEND_Pos)                  /*!< 0x00000200 */
#define CEC_ISR_TXEND            CEC_ISR_TXEND_Msk                             /*!< CEC End of Transmission                   */
#define CEC_ISR_TXUDR_Pos        (10U)
#define CEC_ISR_TXUDR_Msk        (0x1UL << CEC_ISR_TXUDR_Pos)                  /*!< 0x00000400 */
#define CEC_ISR_TXUDR            CEC_ISR_TXUDR_Msk                             /*!< CEC Tx-Buffer Underrun                    */
#define CEC_ISR_TXERR_Pos        (11U)
#define CEC_ISR_TXERR_Msk        (0x1UL << CEC_ISR_TXERR_Pos)                  /*!< 0x00000800 */
#define CEC_ISR_TXERR            CEC_ISR_TXERR_Msk                             /*!< CEC Tx-Error                              */
#define CEC_ISR_TXACKE_Pos       (12U)
#define CEC_ISR_TXACKE_Msk       (0x1UL << CEC_ISR_TXACKE_Pos)                 /*!< 0x00001000 */
#define CEC_ISR_TXACKE           CEC_ISR_TXACKE_Msk                            /*!< CEC Tx Missing Acknowledge                */

/*******************  Bit definition for CEC_IER register  ********************/
#define CEC_IER_RXBRIE_Pos       (0U)
#define CEC_IER_RXBRIE_Msk       (0x1UL << CEC_IER_RXBRIE_Pos)                 /*!< 0x00000001 */
#define CEC_IER_RXBRIE           CEC_IER_RXBRIE_Msk                            /*!< CEC Rx-Byte Received IT Enable            */
#define CEC_IER_RXENDIE_Pos      (1U)
#define CEC_IER_RXENDIE_Msk      (0x1UL << CEC_IER_RXENDIE_Pos)                /*!< 0x00000002 */
#define CEC_IER_RXENDIE          CEC_IER_RXENDIE_Msk                           /*!< CEC End Of Reception IT Enable            */
#define CEC_IER_RXOVRIE_Pos      (2U)
#define CEC_IER_RXOVRIE_Msk      (0x1UL << CEC_IER_RXOVRIE_Pos)                /*!< 0x00000004 */
#define CEC_IER_RXOVRIE          CEC_IER_RXOVRIE_Msk                           /*!< CEC Rx-Overrun IT Enable                  */
#define CEC_IER_BREIE_Pos        (3U)
#define CEC_IER_BREIE_Msk        (0x1UL << CEC_IER_BREIE_Pos)                  /*!< 0x00000008 */
#define CEC_IER_BREIE            CEC_IER_BREIE_Msk                             /*!< CEC Rx Bit Rising Error IT Enable         */
#define CEC_IER_SBPEIE_Pos       (4U)
#define CEC_IER_SBPEIE_Msk       (0x1UL << CEC_IER_SBPEIE_Pos)                 /*!< 0x00000010 */
#define CEC_IER_SBPEIE           CEC_IER_SBPEIE_Msk                            /*!< CEC Rx Short Bit period Error IT Enable   */
#define CEC_IER_LBPEIE_Pos       (5U)
#define CEC_IER_LBPEIE_Msk       (0x1UL << CEC_IER_LBPEIE_Pos)                 /*!< 0x00000020 */
#define CEC_IER_LBPEIE           CEC_IER_LBPEIE_Msk                            /*!< CEC Rx Long Bit period Error IT Enable    */
#define CEC_IER_RXACKEIE_Pos     (6U)
#define CEC_IER_RXACKEIE_Msk     (0x1UL << CEC_IER_RXACKEIE_Pos)               /*!< 0x00000040 */
#define CEC_IER_RXACKEIE         CEC_IER_RXACKEIE_Msk                          /*!< CEC Rx Missing Acknowledge IT Enable      */
#define CEC_IER_ARBLSTIE_Pos     (7U)
#define CEC_IER_ARBLSTIE_Msk     (0x1UL << CEC_IER_ARBLSTIE_Pos)               /*!< 0x00000080 */
#define CEC_IER_ARBLSTIE         CEC_IER_ARBLSTIE_Msk                          /*!< CEC Arbitration Lost IT Enable            */
#define CEC_IER_TXBRIE_Pos       (8U)
#define CEC_IER_TXBRIE_Msk       (0x1UL << CEC_IER_TXBRIE_Pos)                 /*!< 0x00000100 */
#define CEC_IER_TXBRIE           CEC_IER_TXBRIE_Msk                            /*!< CEC Tx Byte Request  IT Enable            */
#define CEC_IER_TXENDIE_Pos      (9U)
#define CEC_IER_TXENDIE_Msk      (0x1UL << CEC_IER_TXENDIE_Pos)                /*!< 0x00000200 */
#define CEC_IER_TXENDIE          CEC_IER_TXENDIE_Msk                           /*!< CEC End of Transmission IT Enable         */
#define CEC_IER_TXUDRIE_Pos      (10U)
#define CEC_IER_TXUDRIE_Msk      (0x1UL << CEC_IER_TXUDRIE_Pos)                /*!< 0x00000400 */
#define CEC_IER_TXUDRIE          CEC_IER_TXUDRIE_Msk                           /*!< CEC Tx-Buffer Underrun IT Enable          */
#define CEC_IER_TXERRIE_Pos      (11U)
#define CEC_IER_TXERRIE_Msk      (0x1UL << CEC_IER_TXERRIE_Pos)                /*!< 0x00000800 */
#define CEC_IER_TXERRIE          CEC_IER_TXERRIE_Msk                           /*!< CEC Tx-Error IT Enable                    */
#define CEC_IER_TXACKEIE_Pos     (12U)
#define CEC_IER_TXACKEIE_Msk     (0x1UL << CEC_IER_TXACKEIE_Pos)               /*!< 0x00001000 */
#define CEC_IER_TXACKEIE         CEC_IER_TXACKEIE_Msk                          /*!< CEC Tx Missing Acknowledge IT Enable      */

/******************************************************************************/
/*                                                                            */
/*                                    FLASH                                   */
/*                                                                            */
/******************************************************************************/
#define FLASH_LATENCY_DEFAULT               FLASH_ACR_LATENCY_3WS                   /*!< FLASH Three Latency cycle */
#define FLASH_BLOCKBASED_NB_REG             (4U)                                    /*!< 4 Block-based registers for each Flash bank */
#define FLASH_SIZE_DEFAULT                  (0x200000U)                             /*!< FLASH Size */
#define FLASH_SECTOR_NB                     (128U)                                  /*!< Flash Sector number */
#define FLASH_SIZE                          ((((*((uint16_t *)FLASHSIZE_BASE)) == 0xFFFFU)) ? FLASH_SIZE_DEFAULT : \
                                            ((((*((uint16_t *)FLASHSIZE_BASE)) == 0x0000U)) ? FLASH_SIZE_DEFAULT : \
                                            (((uint32_t)(*((uint16_t *)FLASHSIZE_BASE)) & (0xFFFFU)) << 10U)))
#define FLASH_BANK_SIZE                     (FLASH_SIZE >> 1U)                      /*!< FLASH Bank Size */
#define FLASH_SECTOR_SIZE                   0x2000U                                 /*!< Flash Sector Size: 8 KB */

/*******************  Bits definition for FLASH_ACR register  *****************/
#define FLASH_ACR_LATENCY_Pos               (0U)
#define FLASH_ACR_LATENCY_Msk               (0xFUL << FLASH_ACR_LATENCY_Pos)        /*!< 0x0000000F */
#define FLASH_ACR_LATENCY                   FLASH_ACR_LATENCY_Msk                   /*!< Latency    */
#define FLASH_ACR_LATENCY_0WS               (0x00000000U)
#define FLASH_ACR_LATENCY_1WS               (0x00000001U)
#define FLASH_ACR_LATENCY_2WS               (0x00000002U)
#define FLASH_ACR_LATENCY_3WS               (0x00000003U)
#define FLASH_ACR_LATENCY_4WS               (0x00000004U)
#define FLASH_ACR_LATENCY_5WS               (0x00000005U)
#define FLASH_ACR_LATENCY_6WS               (0x00000006U)
#define FLASH_ACR_LATENCY_7WS               (0x00000007U)
#define FLASH_ACR_LATENCY_8WS               (0x00000008U)
#define FLASH_ACR_LATENCY_9WS               (0x00000009U)
#define FLASH_ACR_LATENCY_10WS              (0x0000000AU)
#define FLASH_ACR_LATENCY_11WS              (0x0000000BU)
#define FLASH_ACR_LATENCY_12WS              (0x0000000CU)
#define FLASH_ACR_LATENCY_13WS              (0x0000000DU)
#define FLASH_ACR_LATENCY_14WS              (0x0000000EU)
#define FLASH_ACR_LATENCY_15WS              (0x0000000FU)
#define FLASH_ACR_WRHIGHFREQ_Pos            (4U)
#define FLASH_ACR_WRHIGHFREQ_Msk            (0x3UL << FLASH_ACR_WRHIGHFREQ_Pos)     /*!< 0x00000030 */
#define FLASH_ACR_WRHIGHFREQ                FLASH_ACR_WRHIGHFREQ_Msk                /*!< Flash signal delay */
#define FLASH_ACR_WRHIGHFREQ_0              (0x1UL << FLASH_ACR_WRHIGHFREQ_Pos)     /*!< 0x00000010 */
#define FLASH_ACR_WRHIGHFREQ_1              (0x2UL << FLASH_ACR_WRHIGHFREQ_Pos)     /*!< 0x00000020 */
#define FLASH_ACR_PRFTEN_Pos                (8U)
#define FLASH_ACR_PRFTEN_Msk                (0x1UL << FLASH_ACR_PRFTEN_Pos)         /*!< 0x00000100 */
#define FLASH_ACR_PRFTEN                    FLASH_ACR_PRFTEN_Msk                    /*!< Prefetch enable */

/*******************  Bits definition for FLASH_OPSR register  ***************/
#define FLASH_OPSR_ADDR_OP_Pos              (0U)
#define FLASH_OPSR_ADDR_OP_Msk              (0xFFFFFUL << FLASH_OPSR_ADDR_OP_Pos)   /*!< 0x000FFFFF */
#define FLASH_OPSR_ADDR_OP                  FLASH_OPSR_ADDR_OP_Msk                  /*!< Interrupted operation address */
#define FLASH_OPSR_DATA_OP_Pos              (21U)
#define FLASH_OPSR_DATA_OP_Msk              (0x1UL << FLASH_OPSR_DATA_OP_Pos)       /*!< 0x00200000 */
#define FLASH_OPSR_DATA_OP                  FLASH_OPSR_DATA_OP_Msk                  /*!< Operation in Flash high-cycle data area interrupted */
#define FLASH_OPSR_BK_OP_Pos                (22U)
#define FLASH_OPSR_BK_OP_Msk                (0x1UL << FLASH_OPSR_BK_OP_Pos)         /*!< 0x00400000 */
#define FLASH_OPSR_BK_OP                    FLASH_OPSR_BK_OP_Msk                    /*!< Interrupted operation bank */
#define FLASH_OPSR_SYSF_OP_Pos              (23U)
#define FLASH_OPSR_SYSF_OP_Msk              (0x1UL << FLASH_OPSR_SYSF_OP_Pos)       /*!< 0x00800000 */
#define FLASH_OPSR_SYSF_OP                  FLASH_OPSR_SYSF_OP_Msk                  /*!< Operation in System Flash interrupted */
#define FLASH_OPSR_OTP_OP_Pos               (24U)
#define FLASH_OPSR_OTP_OP_Msk               (0x1UL << FLASH_OPSR_OTP_OP_Pos)        /*!< 0x01000000 */
#define FLASH_OPSR_OTP_OP                   FLASH_OPSR_OTP_OP_Msk                   /*!< Operation in OTP area interrupted */
#define FLASH_OPSR_CODE_OP_Pos              (29U)
#define FLASH_OPSR_CODE_OP_Msk              (0x7UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0xE0000000 */
#define FLASH_OPSR_CODE_OP                  FLASH_OPSR_CODE_OP_Msk                  /*!< Flash memory operation code */
#define FLASH_OPSR_CODE_OP_0                (0x1UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x20000000 */
#define FLASH_OPSR_CODE_OP_1                (0x2UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x40000000 */
#define FLASH_OPSR_CODE_OP_2                (0x4UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x80000000 */

/*******************  Bits definition for FLASH_OPTCR register  *******************/
#define FLASH_OPTCR_OPTLOCK_Pos             (0U)
#define FLASH_OPTCR_OPTLOCK_Msk             (0x1UL << FLASH_OPTCR_OPTLOCK_Pos)      /*!< 0x00000001 */
#define FLASH_OPTCR_OPTLOCK                 FLASH_OPTCR_OPTLOCK_Msk                 /*!< FLASH_OPTCR lock option configuration bit */
#define FLASH_OPTCR_OPTSTART_Pos            (1U)
#define FLASH_OPTCR_OPTSTART_Msk            (0x1UL << FLASH_OPTCR_OPTSTART_Pos)     /*!< 0x00000002 */
#define FLASH_OPTCR_OPTSTART                FLASH_OPTCR_OPTSTART_Msk                /*!< Option byte start change option configuration bit */
#define FLASH_OPTCR_SWAP_BANK_Pos           (31U)
#define FLASH_OPTCR_SWAP_BANK_Msk           (0x1UL << FLASH_OPTCR_SWAP_BANK_Pos)    /*!< 0x80000000 */
#define FLASH_OPTCR_SWAP_BANK               FLASH_OPTCR_SWAP_BANK_Msk               /*!< Bank swapping option configuration bit */

/*******************  Bits definition for FLASH_SR register  ***********************/
#define FLASH_SR_BSY_Pos                    (0U)
#define FLASH_SR_BSY_Msk                    (0x1UL << FLASH_SR_BSY_Pos)             /*!< 0x00000001 */
#define FLASH_SR_BSY                        FLASH_SR_BSY_Msk                        /*!< Busy flag */
#define FLASH_SR_WBNE_Pos                   (1U)
#define FLASH_SR_WBNE_Msk                   (0x1UL << FLASH_SR_WBNE_Pos)            /*!< 0x00000002 */
#define FLASH_SR_WBNE                       FLASH_SR_WBNE_Msk                       /*!< Write buffer not empty flag */
#define FLASH_SR_DBNE_Pos                   (3U)
#define FLASH_SR_DBNE_Msk                   (0x1UL << FLASH_SR_DBNE_Pos)            /*!< 0x00000008 */
#define FLASH_SR_DBNE                       FLASH_SR_DBNE_Msk                       /*!< Data buffer not empty flag */
#define FLASH_SR_EOP_Pos                    (16U)
#define FLASH_SR_EOP_Msk                    (0x1UL << FLASH_SR_EOP_Pos)             /*!< 0x00010000 */
#define FLASH_SR_EOP                        FLASH_SR_EOP_Msk                        /*!< End-of-program flag */
#define FLASH_SR_WRPERR_Pos                 (17U)
#define FLASH_SR_WRPERR_Msk                 (0x1UL << FLASH_SR_WRPERR_Pos)          /*!< 0x00020000 */
#define FLASH_SR_WRPERR                     FLASH_SR_WRPERR_Msk                     /*!< Write protection error flag */
#define FLASH_SR_PGSERR_Pos                 (18U)
#define FLASH_SR_PGSERR_Msk                 (0x1UL << FLASH_SR_PGSERR_Pos)          /*!< 0x00040000 */
#define FLASH_SR_PGSERR                     FLASH_SR_PGSERR_Msk                     /*!< Programming sequence error flag */
#define FLASH_SR_STRBERR_Pos                (19U)
#define FLASH_SR_STRBERR_Msk                (0x1UL << FLASH_SR_STRBERR_Pos)         /*!< 0x00080000 */
#define FLASH_SR_STRBERR                    FLASH_SR_STRBERR_Msk                    /*!< Strobe error flag */
#define FLASH_SR_INCERR_Pos                 (20U)
#define FLASH_SR_INCERR_Msk                 (0x1UL << FLASH_SR_INCERR_Pos)          /*!< 0x00100000 */
#define FLASH_SR_INCERR                     FLASH_SR_INCERR_Msk                     /*!< Inconsistency error flag */
#define FLASH_SR_OBKERR_Pos                 (21U)
#define FLASH_SR_OBKERR_Msk                 (0x1UL << FLASH_SR_OBKERR_Pos)          /*!< 0x00200000 */
#define FLASH_SR_OBKERR                     FLASH_SR_OBKERR_Msk                     /*!< OBK general error flag */
#define FLASH_SR_OBKWERR_Pos                (22U)
#define FLASH_SR_OBKWERR_Msk                (0x1UL << FLASH_SR_OBKWERR_Pos)         /*!< 0x00400000 */
#define FLASH_SR_OBKWERR                    FLASH_SR_OBKWERR_Msk                    /*!< OBK write error flag */
#define FLASH_SR_OPTCHANGEERR_Pos           (23U)
#define FLASH_SR_OPTCHANGEERR_Msk           (0x1UL << FLASH_SR_OPTCHANGEERR_Pos)    /*!< 0x00800000 */
#define FLASH_SR_OPTCHANGEERR               FLASH_SR_OPTCHANGEERR_Msk               /*!< Option byte change error flag */

/*******************  Bits definition for FLASH_CR register  ***********************/
#define FLASH_CR_LOCK_Pos                   (0U)
#define FLASH_CR_LOCK_Msk                   (0x1UL << FLASH_CR_LOCK_Pos)            /*!< 0x00000001 */
#define FLASH_CR_LOCK                       FLASH_CR_LOCK_Msk                       /*!< Configuration lock bit */
#define FLASH_CR_PG_Pos                     (1U)
#define FLASH_CR_PG_Msk                     (0x1UL << FLASH_CR_PG_Pos)              /*!< 0x00000002 */
#define FLASH_CR_PG                         FLASH_CR_PG_Msk                         /*!< Programming control bit */
#define FLASH_CR_SER_Pos                    (2U)
#define FLASH_CR_SER_Msk                    (0x1UL << FLASH_CR_SER_Pos)             /*!< 0x00000004 */
#define FLASH_CR_SER                        FLASH_CR_SER_Msk                        /*!< Sector erase request */
#define FLASH_CR_BER_Pos                    (3U)
#define FLASH_CR_BER_Msk                    (0x1UL << FLASH_CR_BER_Pos)             /*!< 0x00000008 */
#define FLASH_CR_BER                        FLASH_CR_BER_Msk                        /*!< Bank erase request */
#define FLASH_CR_FW_Pos                     (4U)
#define FLASH_CR_FW_Msk                     (0x1UL << FLASH_CR_FW_Pos)              /*!< 0x00000010 */
#define FLASH_CR_FW                         FLASH_CR_FW_Msk                         /*!< Write forcing control bit */
#define FLASH_CR_START_Pos                  (5U)
#define FLASH_CR_START_Msk                  (0x1UL << FLASH_CR_START_Pos)           /*!< 0x00000020 */
#define FLASH_CR_START                      FLASH_CR_START_Msk                      /*!< Erase start control bit */
#define FLASH_CR_SNB_Pos                    (6U)
#define FLASH_CR_SNB_Msk                    (0x7FUL << FLASH_CR_SNB_Pos)            /*!< 0x00001FC0 */
#define FLASH_CR_SNB                        FLASH_CR_SNB_Msk                        /*!< Sector erase selection number */
#define FLASH_CR_SNB_0                      (0x01UL << FLASH_CR_SNB_Pos)            /*!< 0x00000040 */
#define FLASH_CR_SNB_1                      (0x02UL << FLASH_CR_SNB_Pos)            /*!< 0x00000080 */
#define FLASH_CR_SNB_2                      (0x04UL << FLASH_CR_SNB_Pos)            /*!< 0x00000100 */
#define FLASH_CR_SNB_3                      (0x08UL << FLASH_CR_SNB_Pos)            /*!< 0x00000200 */
#define FLASH_CR_SNB_4                      (0x10UL << FLASH_CR_SNB_Pos)            /*!< 0x00000400 */
#define FLASH_CR_SNB_5                      (0x20UL << FLASH_CR_SNB_Pos)            /*!< 0x00000800 */
#define FLASH_CR_SNB_6                      (0x40UL << FLASH_CR_SNB_Pos)            /*!< 0x00001000 */
#define FLASH_CR_MER_Pos                    (15U)
#define FLASH_CR_MER_Msk                    (0x1UL << FLASH_CR_MER_Pos)             /*!< 0x00008000 */
#define FLASH_CR_MER                        FLASH_CR_MER_Msk                        /*!< Mass erase */
#define FLASH_CR_EOPIE_Pos                  (16U)
#define FLASH_CR_EOPIE_Msk                  (0x1UL << FLASH_CR_EOPIE_Pos)           /*!< 0x00010000 */
#define FLASH_CR_EOPIE                      FLASH_CR_EOPIE_Msk                      /*!< End-of-operation interrupt control bit */
#define FLASH_CR_WRPERRIE_Pos               (17U)
#define FLASH_CR_WRPERRIE_Msk               (0x1UL << FLASH_CR_WRPERRIE_Pos)        /*!< 0x00020000 */
#define FLASH_CR_WRPERRIE                   FLASH_CR_WRPERRIE_Msk                   /*!< Write protection error interrupt enable bit */
#define FLASH_CR_PGSERRIE_Pos               (18U)
#define FLASH_CR_PGSERRIE_Msk               (0x1UL << FLASH_CR_PGSERRIE_Pos)        /*!< 0x00040000 */
#define FLASH_CR_PGSERRIE                   FLASH_CR_PGSERRIE_Msk                   /*!< Programming sequence error interrupt enable bit */
#define FLASH_CR_STRBERRIE_Pos              (19U)
#define FLASH_CR_STRBERRIE_Msk              (0x1UL << FLASH_CR_STRBERRIE_Pos)       /*!< 0x00080000 */
#define FLASH_CR_STRBERRIE                  FLASH_CR_STRBERRIE_Msk                  /*!< Strobe error interrupt enable bit */
#define FLASH_CR_INCERRIE_Pos               (20U)
#define FLASH_CR_INCERRIE_Msk               (0x1UL << FLASH_CR_INCERRIE_Pos)        /*!< 0x00100000 */
#define FLASH_CR_INCERRIE                   FLASH_CR_INCERRIE_Msk                   /*!< Inconsistency error interrupt enable bit */
#define FLASH_CR_OBKERRIE_Pos               (21U)
#define FLASH_CR_OBKERRIE_Msk               (0x1UL << FLASH_CR_OBKERRIE_Pos)        /*!< 0x00200000 */
#define FLASH_CR_OBKERRIE                   FLASH_CR_OBKERRIE_Msk                   /*!< OBK general error interrupt enable bitt */
#define FLASH_CR_OBKWERRIE_Pos              (22U)
#define FLASH_CR_OBKWERRIE_Msk              (0x1UL << FLASH_CR_OBKWERRIE_Pos)       /*!< 0x00400000 */
#define FLASH_CR_OBKWERRIE                  FLASH_CR_OBKWERRIE_Msk                  /*!< OBK write error interrupt enable bit */
#define FLASH_CR_OPTCHANGEERRIE_Pos         (23U)
#define FLASH_CR_OPTCHANGEERRIE_Msk         (0x1UL << FLASH_CR_OPTCHANGEERRIE_Pos)  /*!< 0x00800000 */
#define FLASH_CR_OPTCHANGEERRIE             FLASH_CR_OPTCHANGEERRIE_Msk             /*!< Option byte change error interrupt enable bit */
#define FLASH_CR_INV_Pos                    (29U)
#define FLASH_CR_INV_Msk                    (0x1UL << FLASH_CR_INV_Pos)             /*!< 0x20000000 */
#define FLASH_CR_INV                        FLASH_CR_INV_Msk                        /*!< Flash Security State Invert */
#define FLASH_CR_BKSEL_Pos                  (31U)
#define FLASH_CR_BKSEL_Msk                  (0x1UL << FLASH_CR_BKSEL_Pos)           /*!< 0x10000000 */
#define FLASH_CR_BKSEL                      FLASH_CR_BKSEL_Msk                      /*!< Bank selector */

/*******************  Bits definition for FLASH_CCR register  *******************/
#define FLASH_CCR_CLR_EOP_Pos               (16U)
#define FLASH_CCR_CLR_EOP_Msk               (0x1UL << FLASH_CCR_CLR_EOP_Pos)        /*!< 0x00010000 */
#define FLASH_CCR_CLR_EOP                   FLASH_CCR_CLR_EOP_Msk                   /*!< EOP flag clear bit */
#define FLASH_CCR_CLR_WRPERR_Pos            (17U)
#define FLASH_CCR_CLR_WRPERR_Msk            (0x1UL << FLASH_CCR_CLR_WRPERR_Pos)     /*!< 0x00020000 */
#define FLASH_CCR_CLR_WRPERR                FLASH_CCR_CLR_WRPERR_Msk                /*!< WRPERR flag clear bit */
#define FLASH_CCR_CLR_PGSERR_Pos            (18U)
#define FLASH_CCR_CLR_PGSERR_Msk            (0x1UL << FLASH_CCR_CLR_PGSERR_Pos)     /*!< 0x00040000 */
#define FLASH_CCR_CLR_PGSERR                FLASH_CCR_CLR_PGSERR_Msk                /*!< PGSERR flag clear bit */
#define FLASH_CCR_CLR_STRBERR_Pos           (19U)
#define FLASH_CCR_CLR_STRBERR_Msk           (0x1UL << FLASH_CCR_CLR_STRBERR_Pos)    /*!< 0x00080000 */
#define FLASH_CCR_CLR_STRBERR               FLASH_CCR_CLR_STRBERR_Msk               /*!< STRBERR flag clear bit */
#define FLASH_CCR_CLR_INCERR_Pos            (20U)
#define FLASH_CCR_CLR_INCERR_Msk            (0x1UL << FLASH_CCR_CLR_INCERR_Pos)     /*!< 0x00100000 */
#define FLASH_CCR_CLR_INCERR                FLASH_CCR_CLR_INCERR_Msk                /*!< INCERR flag clear bit */
#define FLASH_CCR_CLR_OBKERR_Pos            (21U)
#define FLASH_CCR_CLR_OBKERR_Msk            (0x1UL << FLASH_CCR_CLR_OBKERR_Pos)     /*!< 0x00200000 */
#define FLASH_CCR_CLR_OBKERR                FLASH_CCR_CLR_OBKERR_Msk                /*!< OBKERR flag clear bit */
#define FLASH_CCR_CLR_OBKWERR_Pos           (22U)
#define FLASH_CCR_CLR_OBKWERR_Msk           (0x1UL << FLASH_CCR_CLR_OBKWERR_Pos)    /*!< 0x00400000 */
#define FLASH_CCR_CLR_OBKWERR               FLASH_CCR_CLR_OBKWERR_Msk               /*!< OBKWERR flag clear bit */
#define FLASH_CCR_CLR_OPTCHANGEERR_Pos      (23U)
#define FLASH_CCR_CLR_OPTCHANGEERR_Msk      (0x1UL << FLASH_CCR_CLR_OPTCHANGEERR_Pos) /*!< 0x00800000 */
#define FLASH_CCR_CLR_OPTCHANGEERR          FLASH_CCR_CLR_OPTCHANGEERR_Msk            /*!< Option byte change error clear bit */

/******************  Bits definition for FLASH_PRIVCFGR register  ***********/
#define FLASH_PRIVCFGR_SPRIV_Pos            (0U)
#define FLASH_PRIVCFGR_SPRIV_Msk            (0x1UL << FLASH_PRIVCFGR_SPRIV_Pos)     /*!< 0x00000001 */
#define FLASH_PRIVCFGR_SPRIV                FLASH_PRIVCFGR_SPRIV_Msk                /*!< Privilege protection for secure registers */
#define FLASH_PRIVCFGR_NSPRIV_Pos           (1U)
#define FLASH_PRIVCFGR_NSPRIV_Msk           (0x1UL << FLASH_PRIVCFGR_NSPRIV_Pos)    /*!< 0x00000002 */
#define FLASH_PRIVCFGR_NSPRIV               FLASH_PRIVCFGR_NSPRIV_Msk               /*!< Privilege protection for non-secure registers */

/******************  Bits definition for FLASH_OBKCFGR register  *****************/
#define FLASH_OBKCFGR_LOCK_Pos              (0U)
#define FLASH_OBKCFGR_LOCK_Msk              (0x1UL << FLASH_OBKCFGR_LOCK_Pos)       /*!< 0x00000001 */
#define FLASH_OBKCFGR_LOCK                  FLASH_OBKCFGR_LOCK_Msk                  /*!< OBKCFGR lock */
#define FLASH_OBKCFGR_SWAP_SECT_REQ_Pos     (1U)
#define FLASH_OBKCFGR_SWAP_SECT_REQ_Msk     (0x1UL << FLASH_OBKCFGR_SWAP_SECT_REQ_Pos) /*!< 0x00000002 */
#define FLASH_OBKCFGR_SWAP_SECT_REQ         FLASH_OBKCFGR_SWAP_SECT_REQ_Msk            /*!< OBK swap sector request */
#define FLASH_OBKCFGR_ALT_SECT_Pos          (2U)
#define FLASH_OBKCFGR_ALT_SECT_Msk          (0x1UL << FLASH_OBKCFGR_ALT_SECT_Pos)   /*!< 0x00000004 */
#define FLASH_OBKCFGR_ALT_SECT              FLASH_OBKCFGR_ALT_SECT_Msk              /*!< Alternate sector */
#define FLASH_OBKCFGR_ALT_SECT_ERASE_Pos    (3U)
#define FLASH_OBKCFGR_ALT_SECT_ERASE_Msk    (0x1UL << FLASH_OBKCFGR_ALT_SECT_ERASE_Pos) /*!< 0x00000008 */
#define FLASH_OBKCFGR_ALT_SECT_ERASE        FLASH_OBKCFGR_ALT_SECT_ERASE_Msk            /*!< Alternate sector erase */
#define FLASH_OBKCFGR_SWAP_OFFSET_Pos       (16U)
#define FLASH_OBKCFGR_SWAP_OFFSET_Msk       (0x1FFUL << FLASH_OBKCFGR_SWAP_OFFSET_Pos) /*!< 0x01FF0000 */
#define FLASH_OBKCFGR_SWAP_OFFSET           FLASH_OBKCFGR_SWAP_OFFSET_Msk              /*!< Swap offset */

/******************  Bits definition for FLASH_HDPEXTR register  *****************/
#define FLASH_HDPEXTR_HDP1_EXT_Pos          (0U)
#define FLASH_HDPEXTR_HDP1_EXT_Msk          (0x7FUL << FLASH_HDPEXTR_HDP1_EXT_Pos)  /*!< 0x0000007F */
#define FLASH_HDPEXTR_HDP1_EXT              FLASH_HDPEXTR_HDP1_EXT_Msk              /*!< HDP area extension in 8kB sectors in bank 1 */
#define FLASH_HDPEXTR_HDP2_EXT_Pos          (16U)
#define FLASH_HDPEXTR_HDP2_EXT_Msk          (0x7FUL << FLASH_HDPEXTR_HDP2_EXT_Pos)  /*!< 0x007F0000 */
#define FLASH_HDPEXTR_HDP2_EXT              FLASH_HDPEXTR_HDP2_EXT_Msk              /*!< HDP area extension in 8kB sectors in bank 2 */

/*******************  Bits definition for FLASH_OPTSR register  ***************/
#define FLASH_OPTSR_BOR_LEV_Pos             (0U)
#define FLASH_OPTSR_BOR_LEV_Msk             (0x3UL << FLASH_OPTSR_BOR_LEV_Pos)      /*!< 0x00000003 */
#define FLASH_OPTSR_BOR_LEV                 FLASH_OPTSR_BOR_LEV_Msk                 /*!< Brownout level option bit */
#define FLASH_OPTSR_BOR_LEV_0               (0x1UL << FLASH_OPTSR_BOR_LEV_Pos)      /*!< 0x00000001 */
#define FLASH_OPTSR_BOR_LEV_1               (0x2UL << FLASH_OPTSR_BOR_LEV_Pos)      /*!< 0x00000002 */
#define FLASH_OPTSR_BORH_EN_Pos             (2U)
#define FLASH_OPTSR_BORH_EN_Msk             (0x1UL << FLASH_OPTSR_BORH_EN_Pos)      /*!< 0x00000004 */
#define FLASH_OPTSR_BORH_EN                 FLASH_OPTSR_BORH_EN_Msk                 /*!< Brownout high enable configuration bit */
#define FLASH_OPTSR_IWDG_SW_Pos             (3U)
#define FLASH_OPTSR_IWDG_SW_Msk             (0x1UL << FLASH_OPTSR_IWDG_SW_Pos)      /*!< 0x00000008 */
#define FLASH_OPTSR_IWDG_SW                 FLASH_OPTSR_IWDG_SW_Msk                 /*!< IWDG control mode option bit */
#define FLASH_OPTSR_WWDG_SW_Pos             (4U)
#define FLASH_OPTSR_WWDG_SW_Msk             (0x1UL << FLASH_OPTSR_WWDG_SW_Pos)      /*!< 0x00000010 */
#define FLASH_OPTSR_WWDG_SW                 FLASH_OPTSR_WWDG_SW_Msk                 /*!< WWDG control mode option bit */
#define FLASH_OPTSR_NRST_STOP_Pos           (6U)
#define FLASH_OPTSR_NRST_STOP_Msk           (0x1UL << FLASH_OPTSR_NRST_STOP_Pos)    /*!< 0x00000040 */
#define FLASH_OPTSR_NRST_STOP               FLASH_OPTSR_NRST_STOP_Msk               /*!< Stop mode entry reset option bit */
#define FLASH_OPTSR_NRST_STDBY_Pos          (7U)
#define FLASH_OPTSR_NRST_STDBY_Msk          (0x1UL << FLASH_OPTSR_NRST_STDBY_Pos)   /*!< 0x00000080 */
#define FLASH_OPTSR_NRST_STDBY              FLASH_OPTSR_NRST_STDBY_Msk              /*!< Standby mode entry reset option bit */
#define FLASH_OPTSR_PRODUCT_STATE_Pos       (8U)
#define FLASH_OPTSR_PRODUCT_STATE_Msk       (0xFFUL << FLASH_OPTSR_PRODUCT_STATE_Pos) /*!< 0x0000FF00 */
#define FLASH_OPTSR_PRODUCT_STATE           FLASH_OPTSR_PRODUCT_STATE_Msk             /*!< Life state code option byte */
#define FLASH_OPTSR_IO_VDD_HSLV_Pos         (16U)
#define FLASH_OPTSR_IO_VDD_HSLV_Msk         (0x1UL << FLASH_OPTSR_IO_VDD_HSLV_Pos)  /*!< 0x00010000 */
#define FLASH_OPTSR_IO_VDD_HSLV             FLASH_OPTSR_IO_VDD_HSLV_Msk             /*!< VDD I/O high-speed at low-voltage option bit */
#define FLASH_OPTSR_IO_VDDIO2_HSLV_Pos      (17U)
#define FLASH_OPTSR_IO_VDDIO2_HSLV_Msk      (0x1UL << FLASH_OPTSR_IO_VDDIO2_HSLV_Pos) /*!< 0x00020000 */
#define FLASH_OPTSR_IO_VDDIO2_HSLV          FLASH_OPTSR_IO_VDDIO2_HSLV_Msk            /*!< VDDIO2 I/O high-speed at low-voltage option bit */
#define FLASH_OPTSR_IWDG_STOP_Pos           (20U)
#define FLASH_OPTSR_IWDG_STOP_Msk           (0x1UL << FLASH_OPTSR_IWDG_STOP_Pos)    /*!< 0x00100000 */
#define FLASH_OPTSR_IWDG_STOP               FLASH_OPTSR_IWDG_STOP_Msk               /*!< Independent watchdog counter freeze in Stop mode */
#define FLASH_OPTSR_IWDG_STDBY_Pos          (21U)
#define FLASH_OPTSR_IWDG_STDBY_Msk          (0x1UL << FLASH_OPTSR_IWDG_STDBY_Pos)   /*!< 0x00200000 */
#define FLASH_OPTSR_IWDG_STDBY              FLASH_OPTSR_IWDG_STDBY_Msk              /*!< Independent watchdog counter freeze in Standby mode */
#define FLASH_OPTSR_BOOT_UBE_Pos            (22U)
#define FLASH_OPTSR_BOOT_UBE_Msk            (0xFFUL << FLASH_OPTSR_BOOT_UBE_Pos)    /*!< 0x3FC00000 */
#define FLASH_OPTSR_BOOT_UBE                FLASH_OPTSR_BOOT_UBE_Msk                /*!< Unique boot entry option byte */
#define FLASH_OPTSR_SWAP_BANK_Pos           (31U)
#define FLASH_OPTSR_SWAP_BANK_Msk           (0x1UL << FLASH_OPTSR_SWAP_BANK_Pos)    /*!< 0x80000000 */
#define FLASH_OPTSR_SWAP_BANK               FLASH_OPTSR_SWAP_BANK_Msk               /*!< Bank swapping option bit */

/*******************  Bits definition for FLASH_EPOCHR register  ***************/
#define FLASH_EPOCHR_EPOCH_Pos              (0U)
#define FLASH_EPOCHR_EPOCH_Msk              (0xFFFFFFUL << FLASH_EPOCHR_EPOCH_Pos)  /*!< 0x00FFFFFF */
#define FLASH_EPOCHR_EPOCH                  FLASH_EPOCHR_EPOCH_Msk                  /*!< EPOCH counter */

/*******************  Bits definition for FLASH_OPTSR2 register  ***************/
#define FLASH_OPTSR2_SRAM1_3_RST_Pos        (2U)
#define FLASH_OPTSR2_SRAM1_3_RST_Msk        (0x1UL << FLASH_OPTSR2_SRAM1_3_RST_Pos)  /*!< 0x00000004 */
#define FLASH_OPTSR2_SRAM1_3_RST            FLASH_OPTSR2_SRAM1_3_RST_Msk             /*!< SRAM1 and SRAM3 erased when a system reset occurs */
#define FLASH_OPTSR2_SRAM2_RST_Pos          (3U)
#define FLASH_OPTSR2_SRAM2_RST_Msk          (0x1UL << FLASH_OPTSR2_SRAM2_RST_Pos)   /*!< 0x00000008 */
#define FLASH_OPTSR2_SRAM2_RST              FLASH_OPTSR2_SRAM2_RST_Msk              /*!< SRAM2 erased when a system reset occurs*/
#define FLASH_OPTSR2_BKPRAM_ECC_Pos         (4U)
#define FLASH_OPTSR2_BKPRAM_ECC_Msk         (0x1UL << FLASH_OPTSR2_BKPRAM_ECC_Pos)  /*!< 0x00000010 */
#define FLASH_OPTSR2_BKPRAM_ECC             FLASH_OPTSR2_BKPRAM_ECC_Msk             /*!< Backup RAM ECC detection and correction enable */
#define FLASH_OPTSR2_SRAM3_ECC_Pos          (5U)
#define FLASH_OPTSR2_SRAM3_ECC_Msk          (0x1UL << FLASH_OPTSR2_SRAM3_ECC_Pos)   /*!< 0x00000020 */
#define FLASH_OPTSR2_SRAM3_ECC              FLASH_OPTSR2_SRAM3_ECC_Msk              /*!< SRAM3 ECC detection and correction enable */
#define FLASH_OPTSR2_SRAM2_ECC_Pos          (6U)
#define FLASH_OPTSR2_SRAM2_ECC_Msk          (0x1UL << FLASH_OPTSR2_SRAM2_ECC_Pos)   /*!< 0x00000040 */
#define FLASH_OPTSR2_SRAM2_ECC              FLASH_OPTSR2_SRAM2_ECC_Msk              /*!< SRAM2 ECC detection and correction disable */
#define FLASH_OPTSR2_USBPD_DIS_Pos          (8U)
#define FLASH_OPTSR2_USBPD_DIS_Msk          (0x1UL << FLASH_OPTSR2_USBPD_DIS_Pos)   /*!< 0x00000100 */
#define FLASH_OPTSR2_USBPD_DIS              FLASH_OPTSR2_USBPD_DIS_Msk              /*!< USB power delivery configuration disable */
#define FLASH_OPTSR2_TZEN_Pos               (24U)
#define FLASH_OPTSR2_TZEN_Msk               (0xFFUL << FLASH_OPTSR2_TZEN_Pos)       /*!< 0xFF000000 */
#define FLASH_OPTSR2_TZEN                   FLASH_OPTSR2_TZEN_Msk                   /*!< TrustZone enable */

/****************  Bits definition for FLASH_BOOTR register  **********************/
#define FLASH_BOOTR_BOOT_LOCK_Pos           (0U)
#define FLASH_BOOTR_BOOT_LOCK_Msk           (0xFFUL << FLASH_BOOTR_BOOT_LOCK_Pos)   /*!< 0x000000FF */
#define FLASH_BOOTR_BOOT_LOCK               FLASH_BOOTR_BOOT_LOCK_Msk               /*!< Boot Lock */
#define FLASH_BOOTR_BOOTADD_Pos             (8U)
#define FLASH_BOOTR_BOOTADD_Msk             (0xFFFFFFUL << FLASH_BOOTR_BOOTADD_Pos) /*!< 0xFFFFFF00 */
#define FLASH_BOOTR_BOOTADD                 FLASH_BOOTR_BOOTADD_Msk                 /*!< Boot address */

/****************  Bits definition for FLASH_PRIVBBR register  *******************/
#define FLASH_PRIVBBR_PRIVBB_Pos            (0U)
#define FLASH_PRIVBBR_PRIVBB_Msk            (0xFFFFFFFFUL << FLASH_PRIVBBR_PRIVBB_Pos) /*!< 0xFFFFFFFF */
#define FLASH_PRIVBBR_PRIVBB                FLASH_PRIVBBR_PRIVBB_Msk                   /*!< Privileged/unprivileged 8-Kbyte Flash sector attribute */

/*****************  Bits definition for FLASH_SECWMR register  ********************/
#define FLASH_SECWMR_SECWM_STRT_Pos         (0U)
#define FLASH_SECWMR_SECWM_STRT_Msk         (0x7FUL << FLASH_SECWMR_SECWM_STRT_Pos) /*!< 0x0000007F */
#define FLASH_SECWMR_SECWM_STRT             FLASH_SECWMR_SECWM_STRT_Msk             /*!< Start sector of secure area */
#define FLASH_SECWMR_SECWM_END_Pos          (16U)
#define FLASH_SECWMR_SECWM_END_Msk          (0x7FUL << FLASH_SECWMR_SECWM_END_Pos)  /*!< 0x007F0000 */
#define FLASH_SECWMR_SECWM_END              FLASH_SECWMR_SECWM_END_Msk              /*!< End sector of secure area */

/*****************  Bits definition for FLASH_WRPR register  *********************/
#define FLASH_WRPR_WRPSG_Pos                (0U)
#define FLASH_WRPR_WRPSG_Msk                (0xFFFFFFFFUL << FLASH_WRPR_WRPSG_Pos) /*!< 0xFFFFFFFF */
#define FLASH_WRPR_WRPSG                    FLASH_WRPR_WRPSG_Msk  /*!< Sector group protection option status */

/*****************  Bits definition for FLASH_EDATA register  ********************/
#define FLASH_EDATAR_EDATA_STRT_Pos         (0U)
#define FLASH_EDATAR_EDATA_STRT_Msk         (0x7UL << FLASH_EDATAR_EDATA_STRT_Pos)  /*!< 0x00000007 */
#define FLASH_EDATAR_EDATA_STRT             FLASH_EDATAR_EDATA_STRT_Msk             /*!< Flash high-cycle data start sector */
#define FLASH_EDATAR_EDATA_EN_Pos           (15U)
#define FLASH_EDATAR_EDATA_EN_Msk           (0x1UL << FLASH_EDATAR_EDATA_EN_Pos)    /*!< 0x00008000 */
#define FLASH_EDATAR_EDATA_EN               FLASH_EDATAR_EDATA_EN_Msk               /*!< Flash high-cycle data enable */

/*****************  Bits definition for FLASH_HDPR register  ********************/
#define FLASH_HDPR_HDP_STRT_Pos             (0U)
#define FLASH_HDPR_HDP_STRT_Msk             (0x7FUL << FLASH_HDPR_HDP_STRT_Pos)     /*!< 0x0000007F */
#define FLASH_HDPR_HDP_STRT                 FLASH_HDPR_HDP_STRT_Msk                 /*!< Start sector of hide protection area */
#define FLASH_HDPR_HDP_END_Pos              (16U)
#define FLASH_HDPR_HDP_END_Msk              (0x7FUL << FLASH_HDPR_HDP_END_Pos)      /*!< 0x007F0000 */
#define FLASH_HDPR_HDP_END                  FLASH_HDPR_HDP_END_Msk                  /*!< End sector of hide protection area */

/*******************  Bits definition for FLASH_ECCR register  ***************/
#define FLASH_ECCR_ADDR_ECC_Pos             (0U)
#define FLASH_ECCR_ADDR_ECC_Msk             (0xFFFFUL << FLASH_ECCR_ADDR_ECC_Pos)   /*!< 0x0000FFFF */
#define FLASH_ECCR_ADDR_ECC                 FLASH_ECCR_ADDR_ECC_Msk                 /*!< ECC fail address */
#define FLASH_ECCR_OBK_ECC_Pos              (20U)
#define FLASH_ECCR_OBK_ECC_Msk              (0x1UL << FLASH_ECCR_OBK_ECC_Pos)       /*!< 0x00200000 */
#define FLASH_ECCR_OBK_ECC                  FLASH_ECCR_OBK_ECC_Msk                  /*!< Flash OB Keys storage area ECC fail */
#define FLASH_ECCR_DATA_ECC_Pos             (21U)
#define FLASH_ECCR_DATA_ECC_Msk             (0x1UL << FLASH_ECCR_DATA_ECC_Pos)      /*!< 0x00400000 */
#define FLASH_ECCR_DATA_ECC                 FLASH_ECCR_DATA_ECC_Msk                 /*!< Flash high-cycle data ECC fail */
#define FLASH_ECCR_BK_ECC_Pos               (22U)
#define FLASH_ECCR_BK_ECC_Msk               (0x1UL << FLASH_ECCR_BK_ECC_Pos)        /*!< 0x00400000 */
#define FLASH_ECCR_BK_ECC                   FLASH_ECCR_BK_ECC_Msk                   /*!< ECC fail bank */
#define FLASH_ECCR_SYSF_ECC_Pos             (23U)
#define FLASH_ECCR_SYSF_ECC_Msk             (0x1UL << FLASH_ECCR_SYSF_ECC_Pos)      /*!< 0x00800000 */
#define FLASH_ECCR_SYSF_ECC                 FLASH_ECCR_SYSF_ECC_Msk                 /*!< System Flash ECC fail */
#define FLASH_ECCR_OTP_ECC_Pos              (24U)
#define FLASH_ECCR_OTP_ECC_Msk              (0x1UL << FLASH_ECCR_OTP_ECC_Pos)       /*!< 0x01000000 */
#define FLASH_ECCR_OTP_ECC                  FLASH_ECCR_OTP_ECC_Msk                  /*!< Flash OTP ECC fail */
#define FLASH_ECCR_ECCIE_Pos                (25U)
#define FLASH_ECCR_ECCIE_Msk                (0x1UL << FLASH_ECCR_ECCIE_Pos)         /*!< 0x02000000 */
#define FLASH_ECCR_ECCIE                    FLASH_ECCR_ECCIE_Msk                    /*!< ECC correction interrupt enable */
#define FLASH_ECCR_ECCC_Pos                 (30U)
#define FLASH_ECCR_ECCC_Msk                 (0x1UL << FLASH_ECCR_ECCC_Pos)          /*!< 0x40000000 */
#define FLASH_ECCR_ECCC                     FLASH_ECCR_ECCC_Msk                     /*!< ECC correction */
#define FLASH_ECCR_ECCD_Pos                 (31U)
#define FLASH_ECCR_ECCD_Msk                 (0x1UL << FLASH_ECCR_ECCD_Pos)          /*!< 0x80000000 */
#define FLASH_ECCR_ECCD                     FLASH_ECCR_ECCD_Msk                     /*!< ECC detection */

/*******************  Bits definition for FLASH_ECCDR register  ***************/
#define FLASH_ECCDR_FAIL_DATA_Pos           (0U)
#define FLASH_ECCDR_FAIL_DATA_Msk           (0xFFFFUL << FLASH_ECCDR_FAIL_DATA_Pos) /*!< 0x0000FFFF */
#define FLASH_ECCDR_FAIL_DATA               FLASH_ECCDR_FAIL_DATA_Msk               /*!< ECC fail data */

/******************************************************************************/
/*                                                                            */
/*                Filter Mathematical ACcelerator unit (FMAC)                 */
/*                                                                            */
/******************************************************************************/
/*****************  Bit definition for FMAC_X1BUFCFG register  ****************/
#define FMAC_X1BUFCFG_X1_BASE_Pos           (0U)
#define FMAC_X1BUFCFG_X1_BASE_Msk           (0xFFUL << FMAC_X1BUFCFG_X1_BASE_Pos)   /*!< 0x000000FF */
#define FMAC_X1BUFCFG_X1_BASE               FMAC_X1BUFCFG_X1_BASE_Msk               /*!< Base address of X1 buffer */
#define FMAC_X1BUFCFG_X1_BUF_SIZE_Pos       (8U)
#define FMAC_X1BUFCFG_X1_BUF_SIZE_Msk       (0xFFUL << FMAC_X1BUFCFG_X1_BUF_SIZE_Pos) /*!< 0x0000FF00 */
#define FMAC_X1BUFCFG_X1_BUF_SIZE           FMAC_X1BUFCFG_X1_BUF_SIZE_Msk           /*!< Allocated size of X1 buffer in 16-bit words */
#define FMAC_X1BUFCFG_FULL_WM_Pos           (24U)
#define FMAC_X1BUFCFG_FULL_WM_Msk           (0x3UL << FMAC_X1BUFCFG_FULL_WM_Pos)    /*!< 0x03000000 */
#define FMAC_X1BUFCFG_FULL_WM               FMAC_X1BUFCFG_FULL_WM_Msk               /*!< Watermark for buffer full flag */

/*****************  Bit definition for FMAC_X2BUFCFG register  ****************/
#define FMAC_X2BUFCFG_X2_BASE_Pos           (0U)
#define FMAC_X2BUFCFG_X2_BASE_Msk           (0xFFUL << FMAC_X2BUFCFG_X2_BASE_Pos)   /*!< 0x000000FF */
#define FMAC_X2BUFCFG_X2_BASE               FMAC_X2BUFCFG_X2_BASE_Msk               /*!< Base address of X2 buffer */
#define FMAC_X2BUFCFG_X2_BUF_SIZE_Pos       (8U)
#define FMAC_X2BUFCFG_X2_BUF_SIZE_Msk       (0xFFUL << FMAC_X2BUFCFG_X2_BUF_SIZE_Pos) /*!< 0x0000FF00 */
#define FMAC_X2BUFCFG_X2_BUF_SIZE           FMAC_X2BUFCFG_X2_BUF_SIZE_Msk           /*!< Size of X2 buffer in 16-bit words */

/*****************  Bit definition for FMAC_YBUFCFG register  *****************/
#define FMAC_YBUFCFG_Y_BASE_Pos             (0U)
#define FMAC_YBUFCFG_Y_BASE_Msk             (0xFFUL << FMAC_YBUFCFG_Y_BASE_Pos)     /*!< 0x000000FF */
#define FMAC_YBUFCFG_Y_BASE                 FMAC_YBUFCFG_Y_BASE_Msk                 /*!< Base address of Y buffer */
#define FMAC_YBUFCFG_Y_BUF_SIZE_Pos         (8U)
#define FMAC_YBUFCFG_Y_BUF_SIZE_Msk         (0xFFUL << FMAC_YBUFCFG_Y_BUF_SIZE_Pos) /*!< 0x0000FF00 */
#define FMAC_YBUFCFG_Y_BUF_SIZE             FMAC_YBUFCFG_Y_BUF_SIZE_Msk             /*!< Size of Y buffer in 16-bit words */
#define FMAC_YBUFCFG_EMPTY_WM_Pos           (24U)
#define FMAC_YBUFCFG_EMPTY_WM_Msk           (0x3UL << FMAC_YBUFCFG_EMPTY_WM_Pos)    /*!< 0x03000000 */
#define FMAC_YBUFCFG_EMPTY_WM               FMAC_YBUFCFG_EMPTY_WM_Msk               /*!< Watermark for buffer empty flag */

/******************  Bit definition for FMAC_PARAM register  ******************/
#define FMAC_PARAM_P_Pos                    (0U)
#define FMAC_PARAM_P_Msk                    (0xFFUL << FMAC_PARAM_P_Pos)            /*!< 0x000000FF */
#define FMAC_PARAM_P                        FMAC_PARAM_P_Msk                        /*!< Input parameter P */
#define FMAC_PARAM_Q_Pos                    (8U)
#define FMAC_PARAM_Q_Msk                    (0xFFUL << FMAC_PARAM_Q_Pos)            /*!< 0x0000FF00 */
#define FMAC_PARAM_Q                        FMAC_PARAM_Q_Msk                        /*!< Input parameter Q */
#define FMAC_PARAM_R_Pos                    (16U)
#define FMAC_PARAM_R_Msk                    (0xFFUL << FMAC_PARAM_R_Pos)            /*!< 0x00FF0000 */
#define FMAC_PARAM_R                        FMAC_PARAM_R_Msk                        /*!< Input parameter R */
#define FMAC_PARAM_FUNC_Pos                 (24U)
#define FMAC_PARAM_FUNC_Msk                 (0x7FUL << FMAC_PARAM_FUNC_Pos)         /*!< 0x7F000000 */
#define FMAC_PARAM_FUNC                     FMAC_PARAM_FUNC_Msk                     /*!< Function */
#define FMAC_PARAM_FUNC_0                   (0x1UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x01000000 */
#define FMAC_PARAM_FUNC_1                   (0x2UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x02000000 */
#define FMAC_PARAM_FUNC_2                   (0x4UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x04000000 */
#define FMAC_PARAM_FUNC_3                   (0x8UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x08000000 */
#define FMAC_PARAM_FUNC_4                   (0x10UL << FMAC_PARAM_FUNC_Pos)         /*!< 0x10000000 */
#define FMAC_PARAM_FUNC_5                   (0x20UL << FMAC_PARAM_FUNC_Pos)         /*!< 0x20000000 */
#define FMAC_PARAM_FUNC_6                   (0x40UL << FMAC_PARAM_FUNC_Pos)         /*!< 0x40000000 */
#define FMAC_PARAM_START_Pos                (31U)
#define FMAC_PARAM_START_Msk                (0x1UL << FMAC_PARAM_START_Pos)         /*!< 0x80000000 */
#define FMAC_PARAM_START                    FMAC_PARAM_START_Msk                    /*!< Enable execution */

/********************  Bit definition for FMAC_CR register  *******************/
#define FMAC_CR_RIEN_Pos                    (0U)
#define FMAC_CR_RIEN_Msk                    (0x1UL << FMAC_CR_RIEN_Pos)             /*!< 0x00000001 */
#define FMAC_CR_RIEN                        FMAC_CR_RIEN_Msk                        /*!< Enable read interrupt */
#define FMAC_CR_WIEN_Pos                    (1U)
#define FMAC_CR_WIEN_Msk                    (0x1UL << FMAC_CR_WIEN_Pos)             /*!< 0x00000002 */
#define FMAC_CR_WIEN                        FMAC_CR_WIEN_Msk                        /*!< Enable write interrupt */
#define FMAC_CR_OVFLIEN_Pos                 (2U)
#define FMAC_CR_OVFLIEN_Msk                 (0x1UL << FMAC_CR_OVFLIEN_Pos)          /*!< 0x00000004 */
#define FMAC_CR_OVFLIEN                     FMAC_CR_OVFLIEN_Msk                     /*!< Enable overflow error interrupts */
#define FMAC_CR_UNFLIEN_Pos                 (3U)
#define FMAC_CR_UNFLIEN_Msk                 (0x1UL << FMAC_CR_UNFLIEN_Pos)          /*!< 0x00000008 */
#define FMAC_CR_UNFLIEN                     FMAC_CR_UNFLIEN_Msk                     /*!< Enable underflow error interrupts */
#define FMAC_CR_SATIEN_Pos                  (4U)
#define FMAC_CR_SATIEN_Msk                  (0x1UL << FMAC_CR_SATIEN_Pos)           /*!< 0x00000010 */
#define FMAC_CR_SATIEN                      FMAC_CR_SATIEN_Msk                      /*!< Enable saturation error interrupts */
#define FMAC_CR_DMAREN_Pos                  (8U)
#define FMAC_CR_DMAREN_Msk                  (0x1UL << FMAC_CR_DMAREN_Pos)           /*!< 0x00000100 */
#define FMAC_CR_DMAREN                      FMAC_CR_DMAREN_Msk                      /*!< Enable DMA read channel requests */
#define FMAC_CR_DMAWEN_Pos                  (9U)
#define FMAC_CR_DMAWEN_Msk                  (0x1UL << FMAC_CR_DMAWEN_Pos)           /*!< 0x00000200 */
#define FMAC_CR_DMAWEN                      FMAC_CR_DMAWEN_Msk                      /*!< Enable DMA write channel requests */
#define FMAC_CR_CLIPEN_Pos                  (15U)
#define FMAC_CR_CLIPEN_Msk                  (0x1UL << FMAC_CR_CLIPEN_Pos)           /*!< 0x00008000 */
#define FMAC_CR_CLIPEN                      FMAC_CR_CLIPEN_Msk                      /*!< Enable clipping */
#define FMAC_CR_RESET_Pos                   (16U)
#define FMAC_CR_RESET_Msk                   (0x1UL << FMAC_CR_RESET_Pos)            /*!< 0x00010000 */
#define FMAC_CR_RESET                       FMAC_CR_RESET_Msk                       /*!< Reset filter mathematical accelerator unit */

/*******************  Bit definition for FMAC_SR register  ********************/
#define FMAC_SR_YEMPTY_Pos                  (0U)
#define FMAC_SR_YEMPTY_Msk                  (0x1UL << FMAC_SR_YEMPTY_Pos)           /*!< 0x00000001 */
#define FMAC_SR_YEMPTY                      FMAC_SR_YEMPTY_Msk                      /*!< Y buffer empty flag */
#define FMAC_SR_X1FULL_Pos                  (1U)
#define FMAC_SR_X1FULL_Msk                  (0x1UL << FMAC_SR_X1FULL_Pos)           /*!< 0x00000002 */
#define FMAC_SR_X1FULL                      FMAC_SR_X1FULL_Msk                      /*!< X1 buffer full flag */
#define FMAC_SR_OVFL_Pos                    (8U)
#define FMAC_SR_OVFL_Msk                    (0x1UL << FMAC_SR_OVFL_Pos)             /*!< 0x00000100 */
#define FMAC_SR_OVFL                        FMAC_SR_OVFL_Msk                        /*!< Overflow error flag */
#define FMAC_SR_UNFL_Pos                    (9U)
#define FMAC_SR_UNFL_Msk                    (0x1UL << FMAC_SR_UNFL_Pos)             /*!< 0x00000200 */
#define FMAC_SR_UNFL                        FMAC_SR_UNFL_Msk                        /*!< Underflow error flag */
#define FMAC_SR_SAT_Pos                     (10U)
#define FMAC_SR_SAT_Msk                     (0x1UL << FMAC_SR_SAT_Pos)              /*!< 0x00000400 */
#define FMAC_SR_SAT                         FMAC_SR_SAT_Msk                         /*!< Saturation error flag */

/******************  Bit definition for FMAC_WDATA register  ******************/
#define FMAC_WDATA_WDATA_Pos                (0U)
#define FMAC_WDATA_WDATA_Msk                (0xFFFFUL << FMAC_WDATA_WDATA_Pos)      /*!< 0x0000FFFF */
#define FMAC_WDATA_WDATA                    FMAC_WDATA_WDATA_Msk                    /*!< Write data */

/******************  Bit definition for FMACX_RDATA register  *****************/
#define FMAC_RDATA_RDATA_Pos                (0U)
#define FMAC_RDATA_RDATA_Msk                (0xFFFFUL << FMAC_RDATA_RDATA_Pos)      /*!< 0x0000FFFF */
#define FMAC_RDATA_RDATA                    FMAC_RDATA_RDATA_Msk                    /*!< Read data */

/******************************************************************************/
/*                                                                            */
/*                          Flexible Memory Controller                        */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for FMC_BCR1 register  *******************/
#define FMC_BCR1_CCLKEN_Pos                 (20U)
#define FMC_BCR1_CCLKEN_Msk                 (0x1UL << FMC_BCR1_CCLKEN_Pos)          /*!< 0x00100000 */
#define FMC_BCR1_CCLKEN                     FMC_BCR1_CCLKEN_Msk                     /*!<Continuous clock enable    */
#define FMC_BCR1_WFDIS_Pos                  (21U)
#define FMC_BCR1_WFDIS_Msk                  (0x1UL << FMC_BCR1_WFDIS_Pos)           /*!< 0x00200000 */
#define FMC_BCR1_WFDIS                      FMC_BCR1_WFDIS_Msk                      /*!<Write FIFO Disable         */
#define FMC_BCR1_FMCEN_Pos                  (31U)
#define FMC_BCR1_FMCEN_Msk                  (0x1UL << FMC_BCR1_FMCEN_Pos)           /*!< 0x80000000 */
#define FMC_BCR1_FMCEN                      FMC_BCR1_FMCEN_Msk                      /*!<FMC controller Enable */

/******************  Bit definition for FMC_BCRx registers (x=1..4)  *********/
#define FMC_BCRx_MBKEN_Pos                  (0U)
#define FMC_BCRx_MBKEN_Msk                  (0x1UL << FMC_BCRx_MBKEN_Pos)           /*!< 0x00000001 */
#define FMC_BCRx_MBKEN                      FMC_BCRx_MBKEN_Msk                      /*!<Memory bank enable bit                 */
#define FMC_BCRx_MUXEN_Pos                  (1U)
#define FMC_BCRx_MUXEN_Msk                  (0x1UL << FMC_BCRx_MUXEN_Pos)           /*!< 0x00000002 */
#define FMC_BCRx_MUXEN                      FMC_BCRx_MUXEN_Msk                      /*!<Address/data multiplexing enable bit   */
#define FMC_BCRx_MTYP_Pos                   (2U)
#define FMC_BCRx_MTYP_Msk                   (0x3UL << FMC_BCRx_MTYP_Pos)            /*!< 0x0000000C */
#define FMC_BCRx_MTYP                       FMC_BCRx_MTYP_Msk                       /*!<MTYP[1:0] bits (Memory type)           */
#define FMC_BCRx_MTYP_0                     (0x1UL << FMC_BCRx_MTYP_Pos)            /*!< 0x00000004 */
#define FMC_BCRx_MTYP_1                     (0x2UL << FMC_BCRx_MTYP_Pos)            /*!< 0x00000008 */
#define FMC_BCRx_MWID_Pos                   (4U)
#define FMC_BCRx_MWID_Msk                   (0x3UL << FMC_BCRx_MWID_Pos)            /*!< 0x00000030 */
#define FMC_BCRx_MWID                       FMC_BCRx_MWID_Msk                       /*!<MWID[1:0] bits (Memory data bus width) */
#define FMC_BCRx_MWID_0                     (0x1UL << FMC_BCRx_MWID_Pos)            /*!< 0x00000010 */
#define FMC_BCRx_MWID_1                     (0x2UL << FMC_BCRx_MWID_Pos)            /*!< 0x00000020 */
#define FMC_BCRx_FACCEN_Pos                 (6U)
#define FMC_BCRx_FACCEN_Msk                 (0x1UL << FMC_BCRx_FACCEN_Pos)          /*!< 0x00000040 */
#define FMC_BCRx_FACCEN                     FMC_BCRx_FACCEN_Msk                     /*!<Flash access enable        */
#define FMC_BCRx_BURSTEN_Pos                (8U)
#define FMC_BCRx_BURSTEN_Msk                (0x1UL << FMC_BCRx_BURSTEN_Pos)         /*!< 0x00000100 */
#define FMC_BCRx_BURSTEN                    FMC_BCRx_BURSTEN_Msk                    /*!<Burst enable bit           */
#define FMC_BCRx_WAITPOL_Pos                (9U)
#define FMC_BCRx_WAITPOL_Msk                (0x1UL << FMC_BCRx_WAITPOL_Pos)         /*!< 0x00000200 */
#define FMC_BCRx_WAITPOL                    FMC_BCRx_WAITPOL_Msk                    /*!<Wait signal polarity bit   */
#define FMC_BCRx_WAITCFG_Pos                (11U)
#define FMC_BCRx_WAITCFG_Msk                (0x1UL << FMC_BCRx_WAITCFG_Pos)         /*!< 0x00000800 */
#define FMC_BCRx_WAITCFG                    FMC_BCRx_WAITCFG_Msk                    /*!<Wait timing configuration  */
#define FMC_BCRx_WREN_Pos                   (12U)
#define FMC_BCRx_WREN_Msk                   (0x1UL << FMC_BCRx_WREN_Pos)            /*!< 0x00001000 */
#define FMC_BCRx_WREN                       FMC_BCRx_WREN_Msk                       /*!<Write enable bit           */
#define FMC_BCRx_WAITEN_Pos                 (13U)
#define FMC_BCRx_WAITEN_Msk                 (0x1UL << FMC_BCRx_WAITEN_Pos)          /*!< 0x00002000 */
#define FMC_BCRx_WAITEN                     FMC_BCRx_WAITEN_Msk                     /*!<Wait enable bit            */
#define FMC_BCRx_EXTMOD_Pos                 (14U)
#define FMC_BCRx_EXTMOD_Msk                 (0x1UL << FMC_BCRx_EXTMOD_Pos)          /*!< 0x00004000 */
#define FMC_BCRx_EXTMOD                     FMC_BCRx_EXTMOD_Msk                     /*!<Extended mode enable       */
#define FMC_BCRx_ASYNCWAIT_Pos              (15U)
#define FMC_BCRx_ASYNCWAIT_Msk              (0x1UL << FMC_BCRx_ASYNCWAIT_Pos)       /*!< 0x00008000 */
#define FMC_BCRx_ASYNCWAIT                  FMC_BCRx_ASYNCWAIT_Msk                  /*!<Asynchronous wait          */
#define FMC_BCRx_CPSIZE_Pos                 (16U)
#define FMC_BCRx_CPSIZE_Msk                 (0x7UL << FMC_BCRx_CPSIZE_Pos)          /*!< 0x00070000 */
#define FMC_BCRx_CPSIZE                     FMC_BCRx_CPSIZE_Msk                     /*!<PSIZE[2:0] bits CRAM Page Size */
#define FMC_BCRx_CPSIZE_0                   (0x1UL << FMC_BCRx_CPSIZE_Pos)          /*!< 0x00010000 */
#define FMC_BCRx_CPSIZE_1                   (0x2UL << FMC_BCRx_CPSIZE_Pos)          /*!< 0x00020000 */
#define FMC_BCRx_CPSIZE_2                   (0x4UL << FMC_BCRx_CPSIZE_Pos)          /*!< 0x00040000 */
#define FMC_BCRx_CBURSTRW_Pos               (19U)
#define FMC_BCRx_CBURSTRW_Msk               (0x1UL << FMC_BCRx_CBURSTRW_Pos)        /*!< 0x00080000 */
#define FMC_BCRx_CBURSTRW                   FMC_BCRx_CBURSTRW_Msk                   /*!<Write burst enable         */
#define FMC_BCRx_NBLSET_Pos                 (22U)
#define FMC_BCRx_NBLSET_Msk                 (0x3UL << FMC_BCRx_NBLSET_Pos)          /*!< 0x00C00000 */
#define FMC_BCRx_NBLSET                     FMC_BCRx_NBLSET_Msk                     /*!<Byte lane (NBL) setup      */
#define FMC_BCRx_NBLSET_0                   (0x1UL << FMC_BCRx_NBLSET_Pos)          /*!< 0x00400000 */
#define FMC_BCRx_NBLSET_1                   (0x2UL << FMC_BCRx_NBLSET_Pos)          /*!< 0x00800000 */

/******************  Bit definition for FMC_BTRx registers (x=1..4)  *********/
#define FMC_BTRx_ADDSET_Pos                 (0U)
#define FMC_BTRx_ADDSET_Msk                 (0xFUL << FMC_BTRx_ADDSET_Pos)          /*!< 0x0000000F */
#define FMC_BTRx_ADDSET                     FMC_BTRx_ADDSET_Msk                     /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BTRx_ADDSET_0                   (0x1UL << FMC_BTRx_ADDSET_Pos)          /*!< 0x00000001 */
#define FMC_BTRx_ADDSET_1                   (0x2UL << FMC_BTRx_ADDSET_Pos)          /*!< 0x00000002 */
#define FMC_BTRx_ADDSET_2                   (0x4UL << FMC_BTRx_ADDSET_Pos)          /*!< 0x00000004 */
#define FMC_BTRx_ADDSET_3                   (0x8UL << FMC_BTRx_ADDSET_Pos)          /*!< 0x00000008 */
#define FMC_BTRx_ADDHLD_Pos                 (4U)
#define FMC_BTRx_ADDHLD_Msk                 (0xFUL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x000000F0 */
#define FMC_BTRx_ADDHLD                     FMC_BTRx_ADDHLD_Msk                     /*!<ADDHLD[3:0] bits (Address-hold phase duration)  */
#define FMC_BTRx_ADDHLD_0                   (0x1UL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x00000010 */
#define FMC_BTRx_ADDHLD_1                   (0x2UL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x00000020 */
#define FMC_BTRx_ADDHLD_2                   (0x4UL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x00000040 */
#define FMC_BTRx_ADDHLD_3                   (0x8UL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x00000080 */
#define FMC_BTRx_DATAST_Pos                 (8U)
#define FMC_BTRx_DATAST_Msk                 (0xFFUL << FMC_BTRx_DATAST_Pos)         /*!< 0x0000FF00 */
#define FMC_BTRx_DATAST                     FMC_BTRx_DATAST_Msk                     /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BTRx_DATAST_0                   (0x01UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00000100 */
#define FMC_BTRx_DATAST_1                   (0x02UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00000200 */
#define FMC_BTRx_DATAST_2                   (0x04UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00000400 */
#define FMC_BTRx_DATAST_3                   (0x08UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00000800 */
#define FMC_BTRx_DATAST_4                   (0x10UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00001000 */
#define FMC_BTRx_DATAST_5                   (0x20UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00002000 */
#define FMC_BTRx_DATAST_6                   (0x40UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00004000 */
#define FMC_BTRx_DATAST_7                   (0x80UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00008000 */
#define FMC_BTRx_BUSTURN_Pos                (16U)
#define FMC_BTRx_BUSTURN_Msk                (0xFUL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x000F0000 */
#define FMC_BTRx_BUSTURN                    FMC_BTRx_BUSTURN_Msk                    /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BTRx_BUSTURN_0                  (0x1UL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x00010000 */
#define FMC_BTRx_BUSTURN_1                  (0x2UL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x00020000 */
#define FMC_BTRx_BUSTURN_2                  (0x4UL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x00040000 */
#define FMC_BTRx_BUSTURN_3                  (0x8UL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x00080000 */
#define FMC_BTRx_CLKDIV_Pos                 (20U)
#define FMC_BTRx_CLKDIV_Msk                 (0xFUL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00F00000 */
#define FMC_BTRx_CLKDIV                     FMC_BTRx_CLKDIV_Msk                     /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BTRx_CLKDIV_0                   (0x1UL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00100000 */
#define FMC_BTRx_CLKDIV_1                   (0x2UL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00200000 */
#define FMC_BTRx_CLKDIV_2                   (0x4UL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00400000 */
#define FMC_BTRx_CLKDIV_3                   (0x8UL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00800000 */
#define FMC_BTRx_DATLAT_Pos                 (24U)
#define FMC_BTRx_DATLAT_Msk                 (0xFUL << FMC_BTRx_DATLAT_Pos)          /*!< 0x0F000000 */
#define FMC_BTRx_DATLAT                     FMC_BTRx_DATLAT_Msk                     /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BTRx_DATLAT_0                   (0x1UL << FMC_BTRx_DATLAT_Pos)          /*!< 0x01000000 */
#define FMC_BTRx_DATLAT_1                   (0x2UL << FMC_BTRx_DATLAT_Pos)          /*!< 0x02000000 */
#define FMC_BTRx_DATLAT_2                   (0x4UL << FMC_BTRx_DATLAT_Pos)          /*!< 0x04000000 */
#define FMC_BTRx_DATLAT_3                   (0x8UL << FMC_BTRx_DATLAT_Pos)          /*!< 0x08000000 */
#define FMC_BTRx_ACCMOD_Pos                 (28U)
#define FMC_BTRx_ACCMOD_Msk                 (0x3UL << FMC_BTRx_ACCMOD_Pos)          /*!< 0x30000000 */
#define FMC_BTRx_ACCMOD                     FMC_BTRx_ACCMOD_Msk                     /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BTRx_ACCMOD_0                   (0x1UL << FMC_BTRx_ACCMOD_Pos)          /*!< 0x10000000 */
#define FMC_BTRx_ACCMOD_1                   (0x2UL << FMC_BTRx_ACCMOD_Pos)          /*!< 0x20000000 */
#define FMC_BTRx_DATAHLD_Pos                (30U)
#define FMC_BTRx_DATAHLD_Msk                (0x3UL << FMC_BTRx_DATAHLD_Pos)         /*!< 0xC0000000 */
#define FMC_BTRx_DATAHLD                    FMC_BTRx_DATAHLD_Msk                    /*!<DATAHLD[1:0] bits (Data hold phase duration) */
#define FMC_BTRx_DATAHLD_0                  (0x1UL << FMC_BTRx_DATAHLD_Pos)         /*!< 0x40000000 */
#define FMC_BTRx_DATAHLD_1                  (0x2UL << FMC_BTRx_DATAHLD_Pos)         /*!< 0x80000000 */

/******************  Bit definition for FMC_BWTRx registers (x=1..4)  *********/
#define FMC_BWTRx_ADDSET_Pos                (0U)
#define FMC_BWTRx_ADDSET_Msk                (0xFUL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x0000000F */
#define FMC_BWTRx_ADDSET                    FMC_BWTRx_ADDSET_Msk                    /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BWTRx_ADDSET_0                  (0x1UL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x00000001 */
#define FMC_BWTRx_ADDSET_1                  (0x2UL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x00000002 */
#define FMC_BWTRx_ADDSET_2                  (0x4UL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x00000004 */
#define FMC_BWTRx_ADDSET_3                  (0x8UL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x00000008 */
#define FMC_BWTRx_ADDHLD_Pos                (4U)
#define FMC_BWTRx_ADDHLD_Msk                (0xFUL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x000000F0 */
#define FMC_BWTRx_ADDHLD                    FMC_BWTRx_ADDHLD_Msk                    /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BWTRx_ADDHLD_0                  (0x1UL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x00000010 */
#define FMC_BWTRx_ADDHLD_1                  (0x2UL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x00000020 */
#define FMC_BWTRx_ADDHLD_2                  (0x4UL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x00000040 */
#define FMC_BWTRx_ADDHLD_3                  (0x8UL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x00000080 */
#define FMC_BWTRx_DATAST_Pos                (8U)
#define FMC_BWTRx_DATAST_Msk                (0xFFUL << FMC_BWTRx_DATAST_Pos)        /*!< 0x0000FF00 */
#define FMC_BWTRx_DATAST                    FMC_BWTRx_DATAST_Msk                    /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BWTRx_DATAST_0                  (0x01UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00000100 */
#define FMC_BWTRx_DATAST_1                  (0x02UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00000200 */
#define FMC_BWTRx_DATAST_2                  (0x04UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00000400 */
#define FMC_BWTRx_DATAST_3                  (0x08UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00000800 */
#define FMC_BWTRx_DATAST_4                  (0x10UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00001000 */
#define FMC_BWTRx_DATAST_5                  (0x20UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00002000 */
#define FMC_BWTRx_DATAST_6                  (0x40UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00004000 */
#define FMC_BWTRx_DATAST_7                  (0x80UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00008000 */
#define FMC_BWTRx_BUSTURN_Pos               (16U)
#define FMC_BWTRx_BUSTURN_Msk               (0xFUL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x000F0000 */
#define FMC_BWTRx_BUSTURN                   FMC_BWTRx_BUSTURN_Msk                   /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BWTRx_BUSTURN_0                 (0x1UL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x00010000 */
#define FMC_BWTRx_BUSTURN_1                 (0x2UL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x00020000 */
#define FMC_BWTRx_BUSTURN_2                 (0x4UL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x00040000 */
#define FMC_BWTRx_BUSTURN_3                 (0x8UL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x00080000 */
#define FMC_BWTRx_ACCMOD_Pos                (28U)
#define FMC_BWTRx_ACCMOD_Msk                (0x3UL << FMC_BWTRx_ACCMOD_Pos)         /*!< 0x30000000 */
#define FMC_BWTRx_ACCMOD                    FMC_BWTRx_ACCMOD_Msk                    /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BWTRx_ACCMOD_0                  (0x1UL << FMC_BWTRx_ACCMOD_Pos)         /*!< 0x10000000 */
#define FMC_BWTRx_ACCMOD_1                  (0x2UL << FMC_BWTRx_ACCMOD_Pos)         /*!< 0x20000000 */
#define FMC_BWTRx_DATAHLD_Pos               (30U)
#define FMC_BWTRx_DATAHLD_Msk               (0x3UL << FMC_BWTRx_DATAHLD_Pos)        /*!< 0xC0000000 */
#define FMC_BWTRx_DATAHLD                   FMC_BWTRx_DATAHLD_Msk                   /*!<DATAHLD[1:0] bits (Data hold phase duration) */
#define FMC_BWTRx_DATAHLD_0                 (0x1UL << FMC_BWTRx_DATAHLD_Pos)        /*!< 0x40000000 */
#define FMC_BWTRx_DATAHLD_1                 (0x2UL << FMC_BWTRx_DATAHLD_Pos)        /*!< 0x80000000 */

/******************  Bit definition for FMC_PCSCNTR register ******************/
#define FMC_PCSCNTR_CSCOUNT_Pos             (0U)
#define FMC_PCSCNTR_CSCOUNT_Msk             (0xFFFFUL << FMC_PCSCNTR_CSCOUNT_Pos)   /*!< 0x0000FFFF */
#define FMC_PCSCNTR_CSCOUNT                 FMC_PCSCNTR_CSCOUNT_Msk                 /*!<CSCOUNT[15:0] bits (Chip select counter) */
#define FMC_PCSCNTR_CNTB1EN_Pos             (16U)
#define FMC_PCSCNTR_CNTB1EN_Msk             (0x1UL << FMC_PCSCNTR_CNTB1EN_Pos)      /*!< 0x00010000 */
#define FMC_PCSCNTR_CNTB1EN                 FMC_PCSCNTR_CNTB1EN_Msk                 /*!<Counter PSRAM/NOR Bank1_1 enable */
#define FMC_PCSCNTR_CNTB2EN_Pos             (17U)
#define FMC_PCSCNTR_CNTB2EN_Msk             (0x1UL << FMC_PCSCNTR_CNTB2EN_Pos)      /*!< 0x00020000 */
#define FMC_PCSCNTR_CNTB2EN                 FMC_PCSCNTR_CNTB2EN_Msk                 /*!<Counter PSRAM/NOR Bank1_2 enable */
#define FMC_PCSCNTR_CNTB3EN_Pos             (18U)
#define FMC_PCSCNTR_CNTB3EN_Msk             (0x1UL << FMC_PCSCNTR_CNTB3EN_Pos)      /*!< 0x00040000 */
#define FMC_PCSCNTR_CNTB3EN                 FMC_PCSCNTR_CNTB3EN_Msk                 /*!<Counter PSRAM/NOR Bank1_3 enable */
#define FMC_PCSCNTR_CNTB4EN_Pos             (19U)
#define FMC_PCSCNTR_CNTB4EN_Msk             (0x1UL << FMC_PCSCNTR_CNTB4EN_Pos)      /*!< 0x00080000 */
#define FMC_PCSCNTR_CNTB4EN                 FMC_PCSCNTR_CNTB4EN_Msk                 /*!<Counter PSRAM/NOR Bank1_4 enable */

/******************  Bit definition for FMC_PCR register  *******************/
#define FMC_PCR_PWAITEN_Pos                 (1U)
#define FMC_PCR_PWAITEN_Msk                 (0x1UL << FMC_PCR_PWAITEN_Pos)          /*!< 0x00000002 */
#define FMC_PCR_PWAITEN                     FMC_PCR_PWAITEN_Msk                     /*!<Wait feature enable bit                   */
#define FMC_PCR_PBKEN_Pos                   (2U)
#define FMC_PCR_PBKEN_Msk                   (0x1UL << FMC_PCR_PBKEN_Pos)            /*!< 0x00000004 */
#define FMC_PCR_PBKEN                       FMC_PCR_PBKEN_Msk                       /*!<NAND Flash memory bank enable bit */
#define FMC_PCR_PTYP_Pos                    (3U)
#define FMC_PCR_PTYP_Msk                    (0x1UL << FMC_PCR_PTYP_Pos)             /*!< 0x00000008 */
#define FMC_PCR_PTYP                        FMC_PCR_PTYP_Msk                        /*!<Memory type                               */
#define FMC_PCR_PWID_Pos                    (4U)
#define FMC_PCR_PWID_Msk                    (0x3UL << FMC_PCR_PWID_Pos)             /*!< 0x00000030 */
#define FMC_PCR_PWID                        FMC_PCR_PWID_Msk                        /*!<PWID[1:0] bits (NAND Flash databus width) */
#define FMC_PCR_PWID_0                      (0x1UL << FMC_PCR_PWID_Pos)             /*!< 0x00000010 */
#define FMC_PCR_PWID_1                      (0x2UL << FMC_PCR_PWID_Pos)             /*!< 0x00000020 */
#define FMC_PCR_ECCEN_Pos                   (6U)
#define FMC_PCR_ECCEN_Msk                   (0x1UL << FMC_PCR_ECCEN_Pos)            /*!< 0x00000040 */
#define FMC_PCR_ECCEN                       FMC_PCR_ECCEN_Msk                       /*!<ECC computation logic enable bit          */
#define FMC_PCR_TCLR_Pos                    (9U)
#define FMC_PCR_TCLR_Msk                    (0xFUL << FMC_PCR_TCLR_Pos)             /*!< 0x00001E00 */
#define FMC_PCR_TCLR                        FMC_PCR_TCLR_Msk                        /*!<TCLR[3:0] bits (CLE to RE delay)          */
#define FMC_PCR_TCLR_0                      (0x1UL << FMC_PCR_TCLR_Pos)             /*!< 0x00000200 */
#define FMC_PCR_TCLR_1                      (0x2UL << FMC_PCR_TCLR_Pos)             /*!< 0x00000400 */
#define FMC_PCR_TCLR_2                      (0x4UL << FMC_PCR_TCLR_Pos)             /*!< 0x00000800 */
#define FMC_PCR_TCLR_3                      (0x8UL << FMC_PCR_TCLR_Pos)             /*!< 0x00001000 */
#define FMC_PCR_TAR_Pos                     (13U)
#define FMC_PCR_TAR_Msk                     (0xFUL << FMC_PCR_TAR_Pos)              /*!< 0x0001E000 */
#define FMC_PCR_TAR                         FMC_PCR_TAR_Msk                         /*!<TAR[3:0] bits (ALE to RE delay)           */
#define FMC_PCR_TAR_0                       (0x1UL << FMC_PCR_TAR_Pos)              /*!< 0x00002000 */
#define FMC_PCR_TAR_1                       (0x2UL << FMC_PCR_TAR_Pos)              /*!< 0x00004000 */
#define FMC_PCR_TAR_2                       (0x4UL << FMC_PCR_TAR_Pos)              /*!< 0x00008000 */
#define FMC_PCR_TAR_3                       (0x8UL << FMC_PCR_TAR_Pos)              /*!< 0x00010000 */
#define FMC_PCR_ECCPS_Pos                   (17U)
#define FMC_PCR_ECCPS_Msk                   (0x7UL << FMC_PCR_ECCPS_Pos)            /*!< 0x000E0000 */
#define FMC_PCR_ECCPS                       FMC_PCR_ECCPS_Msk                       /*!<ECCPS[1:0] bits (ECC page size)           */
#define FMC_PCR_ECCPS_0                     (0x1UL << FMC_PCR_ECCPS_Pos)            /*!< 0x00020000 */
#define FMC_PCR_ECCPS_1                     (0x2UL << FMC_PCR_ECCPS_Pos)            /*!< 0x00040000 */
#define FMC_PCR_ECCPS_2                     (0x4UL << FMC_PCR_ECCPS_Pos)            /*!< 0x00080000 */

/*******************  Bit definition for FMC_SR register  *******************/
#define FMC_SR_IRS_Pos                      (0U)
#define FMC_SR_IRS_Msk                      (0x1UL << FMC_SR_IRS_Pos)               /*!< 0x00000001 */
#define FMC_SR_IRS                          FMC_SR_IRS_Msk                          /*!<Interrupt Rising Edge status                */
#define FMC_SR_ILS_Pos                      (1U)
#define FMC_SR_ILS_Msk                      (0x1UL << FMC_SR_ILS_Pos)               /*!< 0x00000002 */
#define FMC_SR_ILS                          FMC_SR_ILS_Msk                          /*!<Interrupt Level status                      */
#define FMC_SR_IFS_Pos                      (2U)
#define FMC_SR_IFS_Msk                      (0x1UL << FMC_SR_IFS_Pos)               /*!< 0x00000004 */
#define FMC_SR_IFS                          FMC_SR_IFS_Msk                          /*!<Interrupt Falling Edge status               */
#define FMC_SR_IREN_Pos                     (3U)
#define FMC_SR_IREN_Msk                     (0x1UL << FMC_SR_IREN_Pos)              /*!< 0x00000008 */
#define FMC_SR_IREN                         FMC_SR_IREN_Msk                         /*!<Interrupt Rising Edge detection Enable bit  */
#define FMC_SR_ILEN_Pos                     (4U)
#define FMC_SR_ILEN_Msk                     (0x1UL << FMC_SR_ILEN_Pos)              /*!< 0x00000010 */
#define FMC_SR_ILEN                         FMC_SR_ILEN_Msk                         /*!<Interrupt Level detection Enable bit        */
#define FMC_SR_IFEN_Pos                     (5U)
#define FMC_SR_IFEN_Msk                     (0x1UL << FMC_SR_IFEN_Pos)              /*!< 0x00000020 */
#define FMC_SR_IFEN                         FMC_SR_IFEN_Msk                         /*!<Interrupt Falling Edge detection Enable bit */
#define FMC_SR_FEMPT_Pos                    (6U)
#define FMC_SR_FEMPT_Msk                    (0x1UL << FMC_SR_FEMPT_Pos)             /*!< 0x00000040 */
#define FMC_SR_FEMPT                        FMC_SR_FEMPT_Msk                        /*!<FIFO empty                                  */

/******************  Bit definition for FMC_PMEM register  ******************/
#define FMC_PMEM_MEMSET_Pos                 (0U)
#define FMC_PMEM_MEMSET_Msk                 (0xFFUL << FMC_PMEM_MEMSET_Pos)         /*!< 0x000000FF */
#define FMC_PMEM_MEMSET                     FMC_PMEM_MEMSET_Msk                     /*!<MEMSET[7:0] bits (Common memory setup time) */
#define FMC_PMEM_MEMSET_0                   (0x01UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000001 */
#define FMC_PMEM_MEMSET_1                   (0x02UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000002 */
#define FMC_PMEM_MEMSET_2                   (0x04UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000004 */
#define FMC_PMEM_MEMSET_3                   (0x08UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000008 */
#define FMC_PMEM_MEMSET_4                   (0x10UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000010 */
#define FMC_PMEM_MEMSET_5                   (0x20UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000020 */
#define FMC_PMEM_MEMSET_6                   (0x40UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000040 */
#define FMC_PMEM_MEMSET_7                   (0x80UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000080 */
#define FMC_PMEM_MEMWAIT_Pos                (8U)
#define FMC_PMEM_MEMWAIT_Msk                (0xFFUL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x0000FF00 */
#define FMC_PMEM_MEMWAIT                    FMC_PMEM_MEMWAIT_Msk                    /*!<MEMWAIT[7:0] bits (Common memory wait time) */
#define FMC_PMEM_MEMWAIT_0                  (0x01UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00000100 */
#define FMC_PMEM_MEMWAIT_1                  (0x02UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00000200 */
#define FMC_PMEM_MEMWAIT_2                  (0x04UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00000400 */
#define FMC_PMEM_MEMWAIT_3                  (0x08UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00000800 */
#define FMC_PMEM_MEMWAIT_4                  (0x10UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00001000 */
#define FMC_PMEM_MEMWAIT_5                  (0x20UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00002000 */
#define FMC_PMEM_MEMWAIT_6                  (0x40UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00004000 */
#define FMC_PMEM_MEMWAIT_7                  (0x80UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00008000 */
#define FMC_PMEM_MEMHOLD_Pos                (16U)
#define FMC_PMEM_MEMHOLD_Msk                (0xFFUL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00FF0000 */
#define FMC_PMEM_MEMHOLD                    FMC_PMEM_MEMHOLD_Msk                    /*!<MEMHOLD[7:0] bits (Common memory hold time) */
#define FMC_PMEM_MEMHOLD_0                  (0x01UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00010000 */
#define FMC_PMEM_MEMHOLD_1                  (0x02UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00020000 */
#define FMC_PMEM_MEMHOLD_2                  (0x04UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00040000 */
#define FMC_PMEM_MEMHOLD_3                  (0x08UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00080000 */
#define FMC_PMEM_MEMHOLD_4                  (0x10UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00100000 */
#define FMC_PMEM_MEMHOLD_5                  (0x20UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00200000 */
#define FMC_PMEM_MEMHOLD_6                  (0x40UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00400000 */
#define FMC_PMEM_MEMHOLD_7                  (0x80UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00800000 */
#define FMC_PMEM_MEMHIZ_Pos                 (24U)
#define FMC_PMEM_MEMHIZ_Msk                 (0xFFUL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0xFF000000 */
#define FMC_PMEM_MEMHIZ                     FMC_PMEM_MEMHIZ_Msk                     /*!<MEMHIZ[7:0] bits (Common memory databus HiZ time) */
#define FMC_PMEM_MEMHIZ_0                   (0x01UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x01000000 */
#define FMC_PMEM_MEMHIZ_1                   (0x02UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x02000000 */
#define FMC_PMEM_MEMHIZ_2                   (0x04UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x04000000 */
#define FMC_PMEM_MEMHIZ_3                   (0x08UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x08000000 */
#define FMC_PMEM_MEMHIZ_4                   (0x10UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x10000000 */
#define FMC_PMEM_MEMHIZ_5                   (0x20UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x20000000 */
#define FMC_PMEM_MEMHIZ_6                   (0x40UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x40000000 */
#define FMC_PMEM_MEMHIZ_7                   (0x80UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x80000000 */

/******************  Bit definition for FMC_PATT register  ******************/
#define FMC_PATT_ATTSET_Pos                 (0U)
#define FMC_PATT_ATTSET_Msk                 (0xFFUL << FMC_PATT_ATTSET_Pos)         /*!< 0x000000FF */
#define FMC_PATT_ATTSET                     FMC_PATT_ATTSET_Msk                     /*!<ATTSET[7:0] bits (Attribute memory setup time) */
#define FMC_PATT_ATTSET_0                   (0x01UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000001 */
#define FMC_PATT_ATTSET_1                   (0x02UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000002 */
#define FMC_PATT_ATTSET_2                   (0x04UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000004 */
#define FMC_PATT_ATTSET_3                   (0x08UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000008 */
#define FMC_PATT_ATTSET_4                   (0x10UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000010 */
#define FMC_PATT_ATTSET_5                   (0x20UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000020 */
#define FMC_PATT_ATTSET_6                   (0x40UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000040 */
#define FMC_PATT_ATTSET_7                   (0x80UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000080 */
#define FMC_PATT_ATTWAIT_Pos                (8U)
#define FMC_PATT_ATTWAIT_Msk                (0xFFUL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x0000FF00 */
#define FMC_PATT_ATTWAIT                    FMC_PATT_ATTWAIT_Msk                    /*!<ATTWAIT[7:0] bits (Attribute memory wait time) */
#define FMC_PATT_ATTWAIT_0                  (0x01UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00000100 */
#define FMC_PATT_ATTWAIT_1                  (0x02UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00000200 */
#define FMC_PATT_ATTWAIT_2                  (0x04UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00000400 */
#define FMC_PATT_ATTWAIT_3                  (0x08UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00000800 */
#define FMC_PATT_ATTWAIT_4                  (0x10UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00001000 */
#define FMC_PATT_ATTWAIT_5                  (0x20UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00002000 */
#define FMC_PATT_ATTWAIT_6                  (0x40UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00004000 */
#define FMC_PATT_ATTWAIT_7                  (0x80UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00008000 */
#define FMC_PATT_ATTHOLD_Pos                (16U)
#define FMC_PATT_ATTHOLD_Msk                (0xFFUL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00FF0000 */
#define FMC_PATT_ATTHOLD                    FMC_PATT_ATTHOLD_Msk                    /*!<ATTHOLD[7:0] bits (Attribute memory hold time) */
#define FMC_PATT_ATTHOLD_0                  (0x01UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00010000 */
#define FMC_PATT_ATTHOLD_1                  (0x02UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00020000 */
#define FMC_PATT_ATTHOLD_2                  (0x04UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00040000 */
#define FMC_PATT_ATTHOLD_3                  (0x08UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00080000 */
#define FMC_PATT_ATTHOLD_4                  (0x10UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00100000 */
#define FMC_PATT_ATTHOLD_5                  (0x20UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00200000 */
#define FMC_PATT_ATTHOLD_6                  (0x40UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00400000 */
#define FMC_PATT_ATTHOLD_7                  (0x80UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00800000 */
#define FMC_PATT_ATTHIZ_Pos                 (24U)
#define FMC_PATT_ATTHIZ_Msk                 (0xFFUL << FMC_PATT_ATTHIZ_Pos)         /*!< 0xFF000000 */
#define FMC_PATT_ATTHIZ                     FMC_PATT_ATTHIZ_Msk                     /*!<ATTHIZ[7:0] bits (Attribute memory databus HiZ time) */
#define FMC_PATT_ATTHIZ_0                   (0x01UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x01000000 */
#define FMC_PATT_ATTHIZ_1                   (0x02UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x02000000 */
#define FMC_PATT_ATTHIZ_2                   (0x04UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x04000000 */
#define FMC_PATT_ATTHIZ_3                   (0x08UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x08000000 */
#define FMC_PATT_ATTHIZ_4                   (0x10UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x10000000 */
#define FMC_PATT_ATTHIZ_5                   (0x20UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x20000000 */
#define FMC_PATT_ATTHIZ_6                   (0x40UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x40000000 */
#define FMC_PATT_ATTHIZ_7                   (0x80UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x80000000 */

/******************  Bit definition for FMC_ECCR3 register  ******************/
#define FMC_ECCR3_ECC3_Pos                  (0U)
#define FMC_ECCR3_ECC3_Msk                  (0xFFFFFFFFUL << FMC_ECCR3_ECC3_Pos)    /*!< 0xFFFFFFFF */
#define FMC_ECCR3_ECC3                      FMC_ECCR3_ECC3_Msk                      /*!<ECC result */

/******************  Bit definition for FMC_SDCRx registers (x=1..4)  *********/
#define FMC_SDCRx_NC_Pos           (0U)
#define FMC_SDCRx_NC_Msk           (0x3UL << FMC_SDCRx_NC_Pos)                 /*!< 0x00000003 */
#define FMC_SDCRx_NC               FMC_SDCRx_NC_Msk                            /*!<NC[1:0] bits (Number of column bits) */
#define FMC_SDCRx_NC_0             (0x1UL << FMC_SDCRx_NC_Pos)                  /*!< 0x00000001 */
#define FMC_SDCRx_NC_1             (0x2UL << FMC_SDCRx_NC_Pos)                  /*!< 0x00000002 */

#define FMC_SDCRx_NR_Pos           (2U)
#define FMC_SDCRx_NR_Msk           (0x3UL << FMC_SDCRx_NR_Pos)                 /*!< 0x0000000C */
#define FMC_SDCRx_NR               FMC_SDCRx_NR_Msk                            /*!<NR[1:0] bits (Number of row bits) */
#define FMC_SDCRx_NR_0             (0x1UL << FMC_SDCRx_NR_Pos)                  /*!< 0x00000004 */
#define FMC_SDCRx_NR_1             (0x2UL << FMC_SDCRx_NR_Pos)                  /*!< 0x00000008 */

#define FMC_SDCRx_MWID_Pos         (4U)
#define FMC_SDCRx_MWID_Msk         (0x3UL << FMC_SDCRx_MWID_Pos)               /*!< 0x00000030 */
#define FMC_SDCRx_MWID             FMC_SDCRx_MWID_Msk                          /*!<NR[1:0] bits (Number of row bits) */
#define FMC_SDCRx_MWID_0           (0x1UL << FMC_SDCRx_MWID_Pos)                /*!< 0x00000010 */
#define FMC_SDCRx_MWID_1           (0x2UL << FMC_SDCRx_MWID_Pos)                /*!< 0x00000020 */

#define FMC_SDCRx_NB_Pos           (6U)
#define FMC_SDCRx_NB_Msk           (0x1UL << FMC_SDCRx_NB_Pos)                 /*!< 0x00000040 */
#define FMC_SDCRx_NB               FMC_SDCRx_NB_Msk                            /*!<Number of internal bank */

#define FMC_SDCRx_CAS_Pos          (7U)
#define FMC_SDCRx_CAS_Msk          (0x3UL << FMC_SDCRx_CAS_Pos)                /*!< 0x00000180 */
#define FMC_SDCRx_CAS              FMC_SDCRx_CAS_Msk                           /*!<CAS[1:0] bits (CAS latency) */
#define FMC_SDCRx_CAS_0            (0x1UL << FMC_SDCRx_CAS_Pos)                 /*!< 0x00000080 */
#define FMC_SDCRx_CAS_1            (0x2UL << FMC_SDCRx_CAS_Pos)                 /*!< 0x00000100 */

#define FMC_SDCRx_WP_Pos           (9U)
#define FMC_SDCRx_WP_Msk           (0x1UL << FMC_SDCRx_WP_Pos)                 /*!< 0x00000200 */
#define FMC_SDCRx_WP               FMC_SDCRx_WP_Msk                            /*!<Write protection */

#define FMC_SDCRx_SDCLK_Pos        (10U)
#define FMC_SDCRx_SDCLK_Msk        (0x3UL << FMC_SDCRx_SDCLK_Pos)              /*!< 0x00000C00 */
#define FMC_SDCRx_SDCLK            FMC_SDCRx_SDCLK_Msk                         /*!<SDRAM clock configuration */
#define FMC_SDCRx_SDCLK_0          (0x1UL << FMC_SDCRx_SDCLK_Pos)               /*!< 0x00000400 */
#define FMC_SDCRx_SDCLK_1          (0x2UL << FMC_SDCRx_SDCLK_Pos)               /*!< 0x00000800 */

#define FMC_SDCRx_RBURST_Pos       (12U)
#define FMC_SDCRx_RBURST_Msk       (0x1UL << FMC_SDCRx_RBURST_Pos)             /*!< 0x00001000 */
#define FMC_SDCRx_RBURST           FMC_SDCRx_RBURST_Msk                        /*!<Read burst */

#define FMC_SDCRx_RPIPE_Pos        (13U)
#define FMC_SDCRx_RPIPE_Msk        (0x3UL << FMC_SDCRx_RPIPE_Pos)              /*!< 0x00006000 */
#define FMC_SDCRx_RPIPE            FMC_SDCRx_RPIPE_Msk                         /*!<Write protection */
#define FMC_SDCRx_RPIPE_0          (0x1UL << FMC_SDCRx_RPIPE_Pos)               /*!< 0x00002000 */
#define FMC_SDCRx_RPIPE_1          (0x2UL << FMC_SDCRx_RPIPE_Pos)               /*!< 0x00004000 */

/******************  Bit definition for FMC_SDTRx(1,2) register  ******************/
#define FMC_SDTRx_TMRD_Pos         (0U)
#define FMC_SDTRx_TMRD_Msk         (0xFUL << FMC_SDTRx_TMRD_Pos)               /*!< 0x0000000F */
#define FMC_SDTRx_TMRD             FMC_SDTRx_TMRD_Msk                          /*!<TMRD[3:0] bits (Load mode register to active) */
#define FMC_SDTRx_TMRD_0           (0x1UL << FMC_SDTRx_TMRD_Pos)                /*!< 0x00000001 */
#define FMC_SDTRx_TMRD_1           (0x2UL << FMC_SDTRx_TMRD_Pos)                /*!< 0x00000002 */
#define FMC_SDTRx_TMRD_2           (0x4UL << FMC_SDTRx_TMRD_Pos)                /*!< 0x00000004 */
#define FMC_SDTRx_TMRD_3           (0x8UL << FMC_SDTRx_TMRD_Pos)                /*!< 0x00000008 */

#define FMC_SDTRx_TXSR_Pos         (4U)
#define FMC_SDTRx_TXSR_Msk         (0xFUL << FMC_SDTRx_TXSR_Pos)               /*!< 0x000000F0 */
#define FMC_SDTRx_TXSR             FMC_SDTRx_TXSR_Msk                          /*!<TXSR[3:0] bits (Exit self refresh) */
#define FMC_SDTRx_TXSR_0           (0x1UL << FMC_SDTRx_TXSR_Pos)                /*!< 0x00000010 */
#define FMC_SDTRx_TXSR_1           (0x2UL << FMC_SDTRx_TXSR_Pos)                /*!< 0x00000020 */
#define FMC_SDTRx_TXSR_2           (0x4UL << FMC_SDTRx_TXSR_Pos)                /*!< 0x00000040 */
#define FMC_SDTRx_TXSR_3           (0x8UL << FMC_SDTRx_TXSR_Pos)                /*!< 0x00000080 */

#define FMC_SDTRx_TRAS_Pos         (8U)
#define FMC_SDTRx_TRAS_Msk         (0xFUL << FMC_SDTRx_TRAS_Pos)               /*!< 0x00000F00 */
#define FMC_SDTRx_TRAS             FMC_SDTRx_TRAS_Msk                          /*!<TRAS[3:0] bits (Self refresh time) */
#define FMC_SDTRx_TRAS_0           (0x1UL << FMC_SDTRx_TRAS_Pos)                /*!< 0x00000100 */
#define FMC_SDTRx_TRAS_1           (0x2UL << FMC_SDTRx_TRAS_Pos)                /*!< 0x00000200 */
#define FMC_SDTRx_TRAS_2           (0x4UL << FMC_SDTRx_TRAS_Pos)                /*!< 0x00000400 */
#define FMC_SDTRx_TRAS_3           (0x8UL << FMC_SDTRx_TRAS_Pos)                /*!< 0x00000800 */

#define FMC_SDTRx_TRC_Pos          (12U)
#define FMC_SDTRx_TRC_Msk          (0xFUL << FMC_SDTRx_TRC_Pos)                /*!< 0x0000F000 */
#define FMC_SDTRx_TRC              FMC_SDTRx_TRC_Msk                           /*!<TRC[2:0] bits (Row cycle delay) */
#define FMC_SDTRx_TRC_0            (0x1UL << FMC_SDTRx_TRC_Pos)                 /*!< 0x00001000 */
#define FMC_SDTRx_TRC_1            (0x2UL << FMC_SDTRx_TRC_Pos)                 /*!< 0x00002000 */
#define FMC_SDTRx_TRC_2            (0x4UL << FMC_SDTRx_TRC_Pos)                 /*!< 0x00004000 */

#define FMC_SDTRx_TWR_Pos          (16U)
#define FMC_SDTRx_TWR_Msk          (0xFUL << FMC_SDTRx_TWR_Pos)                /*!< 0x000F0000 */
#define FMC_SDTRx_TWR              FMC_SDTRx_TWR_Msk                           /*!<TRC[2:0] bits (Write recovery delay) */
#define FMC_SDTRx_TWR_0            (0x1UL << FMC_SDTRx_TWR_Pos)                 /*!< 0x00010000 */
#define FMC_SDTRx_TWR_1            (0x2UL << FMC_SDTRx_TWR_Pos)                 /*!< 0x00020000 */
#define FMC_SDTRx_TWR_2            (0x4UL << FMC_SDTRx_TWR_Pos)                 /*!< 0x00040000 */

#define FMC_SDTRx_TRP_Pos          (20U)
#define FMC_SDTRx_TRP_Msk          (0xFUL << FMC_SDTRx_TRP_Pos)                /*!< 0x00F00000 */
#define FMC_SDTRx_TRP              FMC_SDTRx_TRP_Msk                           /*!<TRP[2:0] bits (Row precharge delay) */
#define FMC_SDTRx_TRP_0            (0x1UL << FMC_SDTRx_TRP_Pos)                 /*!< 0x00100000 */
#define FMC_SDTRx_TRP_1            (0x2UL << FMC_SDTRx_TRP_Pos)                 /*!< 0x00200000 */
#define FMC_SDTRx_TRP_2            (0x4UL << FMC_SDTRx_TRP_Pos)                 /*!< 0x00400000 */

#define FMC_SDTRx_TRCD_Pos         (24U)
#define FMC_SDTRx_TRCD_Msk         (0xFUL << FMC_SDTRx_TRCD_Pos)               /*!< 0x0F000000 */
#define FMC_SDTRx_TRCD             FMC_SDTRx_TRCD_Msk                          /*!<TRP[2:0] bits (Row to column delay) */
#define FMC_SDTRx_TRCD_0           (0x1UL << FMC_SDTRx_TRCD_Pos)                /*!< 0x01000000 */
#define FMC_SDTRx_TRCD_1           (0x2UL << FMC_SDTRx_TRCD_Pos)                /*!< 0x02000000 */
#define FMC_SDTRx_TRCD_2           (0x4UL << FMC_SDTRx_TRCD_Pos)                /*!< 0x04000000 */

/******************  Bit definition for FMC_SDCMR register  ******************/
#define FMC_SDCMR_MODE_Pos         (0U)
#define FMC_SDCMR_MODE_Msk         (0x7UL << FMC_SDCMR_MODE_Pos)               /*!< 0x00000007 */
#define FMC_SDCMR_MODE             FMC_SDCMR_MODE_Msk                          /*!<MODE[2:0] bits (Command mode) */
#define FMC_SDCMR_MODE_0           (0x1UL << FMC_SDCMR_MODE_Pos)                /*!< 0x00000001 */
#define FMC_SDCMR_MODE_1           (0x2UL << FMC_SDCMR_MODE_Pos)                /*!< 0x00000002 */
#define FMC_SDCMR_MODE_2           (0x4UL << FMC_SDCMR_MODE_Pos)                /*!< 0x00000004 */

#define FMC_SDCMR_CTB2_Pos         (3U)
#define FMC_SDCMR_CTB2_Msk         (0x1UL << FMC_SDCMR_CTB2_Pos)               /*!< 0x00000008 */
#define FMC_SDCMR_CTB2             FMC_SDCMR_CTB2_Msk                          /*!<Command target 2 */

#define FMC_SDCMR_CTB1_Pos         (4U)
#define FMC_SDCMR_CTB1_Msk         (0x1UL << FMC_SDCMR_CTB1_Pos)               /*!< 0x00000010 */
#define FMC_SDCMR_CTB1             FMC_SDCMR_CTB1_Msk                          /*!<Command target 1 */

#define FMC_SDCMR_NRFS_Pos         (5U)
#define FMC_SDCMR_NRFS_Msk         (0xFUL << FMC_SDCMR_NRFS_Pos)               /*!< 0x000001E0 */
#define FMC_SDCMR_NRFS             FMC_SDCMR_NRFS_Msk                          /*!<NRFS[3:0] bits (Number of auto-refresh) */
#define FMC_SDCMR_NRFS_0           (0x1UL << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000020 */
#define FMC_SDCMR_NRFS_1           (0x2UL << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000040 */
#define FMC_SDCMR_NRFS_2           (0x4UL << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000080 */
#define FMC_SDCMR_NRFS_3           (0x8UL << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000100 */

#define FMC_SDCMR_MRD_Pos          (9U)
#define FMC_SDCMR_MRD_Msk          (0x1FFFUL << FMC_SDCMR_MRD_Pos)             /*!< 0x003FFE00 */
#define FMC_SDCMR_MRD              FMC_SDCMR_MRD_Msk                           /*!<MRD[12:0] bits (Mode register definition) */

/******************  Bit definition for FMC_SDRTR register  ******************/
#define FMC_SDRTR_CRE_Pos          (0U)
#define FMC_SDRTR_CRE_Msk          (0x1UL << FMC_SDRTR_CRE_Pos)                /*!< 0x00000001 */
#define FMC_SDRTR_CRE              FMC_SDRTR_CRE_Msk                           /*!<Clear refresh error flag */

#define FMC_SDRTR_COUNT_Pos        (1U)
#define FMC_SDRTR_COUNT_Msk        (0x1FFFUL << FMC_SDRTR_COUNT_Pos)           /*!< 0x00003FFE */
#define FMC_SDRTR_COUNT            FMC_SDRTR_COUNT_Msk                         /*!<COUNT[12:0] bits (Refresh timer count) */

#define FMC_SDRTR_REIE_Pos         (14U)
#define FMC_SDRTR_REIE_Msk         (0x1UL << FMC_SDRTR_REIE_Pos)               /*!< 0x00004000 */
#define FMC_SDRTR_REIE             FMC_SDRTR_REIE_Msk                          /*!<RES interrupt enable */

/******************  Bit definition for FMC_SDSR register  ******************/
#define FMC_SDSR_RE_Pos            (0U)
#define FMC_SDSR_RE_Msk            (0x1UL << FMC_SDSR_RE_Pos)                  /*!< 0x00000001 */
#define FMC_SDSR_RE                FMC_SDSR_RE_Msk                             /*!<Refresh error flag */

#define FMC_SDSR_MODES1_Pos        (1U)
#define FMC_SDSR_MODES1_Msk        (0x3UL << FMC_SDSR_MODES1_Pos)              /*!< 0x00000006 */
#define FMC_SDSR_MODES1            FMC_SDSR_MODES1_Msk                         /*!<MODES1[1:0]bits (Status mode for bank 1) */
#define FMC_SDSR_MODES1_0          (0x1UL << FMC_SDSR_MODES1_Pos)               /*!< 0x00000002 */
#define FMC_SDSR_MODES1_1          (0x2UL << FMC_SDSR_MODES1_Pos)               /*!< 0x00000004 */

#define FMC_SDSR_MODES2_Pos        (3U)
#define FMC_SDSR_MODES2_Msk        (0x3UL << FMC_SDSR_MODES2_Pos)              /*!< 0x00000018 */
#define FMC_SDSR_MODES2            FMC_SDSR_MODES2_Msk                         /*!<MODES2[1:0]bits (Status mode for bank 2) */
#define FMC_SDSR_MODES2_0          (0x1UL << FMC_SDSR_MODES2_Pos)               /*!< 0x00000008 */
#define FMC_SDSR_MODES2_1          (0x2UL << FMC_SDSR_MODES2_Pos)               /*!< 0x00000010 */


/******************************************************************************/
/*                                                                            */
/*                       General Purpose IOs (GPIO)                           */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GPIO_MODER register  *****************/
#define GPIO_MODER_MODE0_Pos                (0U)
#define GPIO_MODER_MODE0_Msk                (0x3UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000003 */
#define GPIO_MODER_MODE0                    GPIO_MODER_MODE0_Msk
#define GPIO_MODER_MODE0_0                  (0x1UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000001 */
#define GPIO_MODER_MODE0_1                  (0x2UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000002 */
#define GPIO_MODER_MODE1_Pos                (2U)
#define GPIO_MODER_MODE1_Msk                (0x3UL << GPIO_MODER_MODE1_Pos)         /*!< 0x0000000C */
#define GPIO_MODER_MODE1                    GPIO_MODER_MODE1_Msk
#define GPIO_MODER_MODE1_0                  (0x1UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000004 */
#define GPIO_MODER_MODE1_1                  (0x2UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000008 */
#define GPIO_MODER_MODE2_Pos                (4U)
#define GPIO_MODER_MODE2_Msk                (0x3UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000030 */
#define GPIO_MODER_MODE2                    GPIO_MODER_MODE2_Msk
#define GPIO_MODER_MODE2_0                  (0x1UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000010 */
#define GPIO_MODER_MODE2_1                  (0x2UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000020 */
#define GPIO_MODER_MODE3_Pos                (6U)
#define GPIO_MODER_MODE3_Msk                (0x3UL << GPIO_MODER_MODE3_Pos)         /*!< 0x000000C0 */
#define GPIO_MODER_MODE3                    GPIO_MODER_MODE3_Msk
#define GPIO_MODER_MODE3_0                  (0x1UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000040 */
#define GPIO_MODER_MODE3_1                  (0x2UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000080 */
#define GPIO_MODER_MODE4_Pos                (8U)
#define GPIO_MODER_MODE4_Msk                (0x3UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000300 */
#define GPIO_MODER_MODE4                    GPIO_MODER_MODE4_Msk
#define GPIO_MODER_MODE4_0                  (0x1UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000100 */
#define GPIO_MODER_MODE4_1                  (0x2UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000200 */
#define GPIO_MODER_MODE5_Pos                (10U)
#define GPIO_MODER_MODE5_Msk                (0x3UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000C00 */
#define GPIO_MODER_MODE5                    GPIO_MODER_MODE5_Msk
#define GPIO_MODER_MODE5_0                  (0x1UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000400 */
#define GPIO_MODER_MODE5_1                  (0x2UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000800 */
#define GPIO_MODER_MODE6_Pos                (12U)
#define GPIO_MODER_MODE6_Msk                (0x3UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00003000 */
#define GPIO_MODER_MODE6                    GPIO_MODER_MODE6_Msk
#define GPIO_MODER_MODE6_0                  (0x1UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00001000 */
#define GPIO_MODER_MODE6_1                  (0x2UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00002000 */
#define GPIO_MODER_MODE7_Pos                (14U)
#define GPIO_MODER_MODE7_Msk                (0x3UL << GPIO_MODER_MODE7_Pos)         /*!< 0x0000C000 */
#define GPIO_MODER_MODE7                    GPIO_MODER_MODE7_Msk
#define GPIO_MODER_MODE7_0                  (0x1UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00004000 */
#define GPIO_MODER_MODE7_1                  (0x2UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00008000 */
#define GPIO_MODER_MODE8_Pos                (16U)
#define GPIO_MODER_MODE8_Msk                (0x3UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00030000 */
#define GPIO_MODER_MODE8                    GPIO_MODER_MODE8_Msk
#define GPIO_MODER_MODE8_0                  (0x1UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00010000 */
#define GPIO_MODER_MODE8_1                  (0x2UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00020000 */
#define GPIO_MODER_MODE9_Pos                (18U)
#define GPIO_MODER_MODE9_Msk                (0x3UL << GPIO_MODER_MODE9_Pos)         /*!< 0x000C0000 */
#define GPIO_MODER_MODE9                    GPIO_MODER_MODE9_Msk
#define GPIO_MODER_MODE9_0                  (0x1UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00040000 */
#define GPIO_MODER_MODE9_1                  (0x2UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00080000 */
#define GPIO_MODER_MODE10_Pos               (20U)
#define GPIO_MODER_MODE10_Msk               (0x3UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00300000 */
#define GPIO_MODER_MODE10                   GPIO_MODER_MODE10_Msk
#define GPIO_MODER_MODE10_0                 (0x1UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00100000 */
#define GPIO_MODER_MODE10_1                 (0x2UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00200000 */
#define GPIO_MODER_MODE11_Pos               (22U)
#define GPIO_MODER_MODE11_Msk               (0x3UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00C00000 */
#define GPIO_MODER_MODE11                   GPIO_MODER_MODE11_Msk
#define GPIO_MODER_MODE11_0                 (0x1UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00400000 */
#define GPIO_MODER_MODE11_1                 (0x2UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00800000 */
#define GPIO_MODER_MODE12_Pos               (24U)
#define GPIO_MODER_MODE12_Msk               (0x3UL << GPIO_MODER_MODE12_Pos)        /*!< 0x03000000 */
#define GPIO_MODER_MODE12                   GPIO_MODER_MODE12_Msk
#define GPIO_MODER_MODE12_0                 (0x1UL << GPIO_MODER_MODE12_Pos)        /*!< 0x01000000 */
#define GPIO_MODER_MODE12_1                 (0x2UL << GPIO_MODER_MODE12_Pos)        /*!< 0x02000000 */
#define GPIO_MODER_MODE13_Pos               (26U)
#define GPIO_MODER_MODE13_Msk               (0x3UL << GPIO_MODER_MODE13_Pos)        /*!< 0x0C000000 */
#define GPIO_MODER_MODE13                   GPIO_MODER_MODE13_Msk
#define GPIO_MODER_MODE13_0                 (0x1UL << GPIO_MODER_MODE13_Pos)        /*!< 0x04000000 */
#define GPIO_MODER_MODE13_1                 (0x2UL << GPIO_MODER_MODE13_Pos)        /*!< 0x08000000 */
#define GPIO_MODER_MODE14_Pos               (28U)
#define GPIO_MODER_MODE14_Msk               (0x3UL << GPIO_MODER_MODE14_Pos)        /*!< 0x30000000 */
#define GPIO_MODER_MODE14                   GPIO_MODER_MODE14_Msk
#define GPIO_MODER_MODE14_0                 (0x1UL << GPIO_MODER_MODE14_Pos)        /*!< 0x10000000 */
#define GPIO_MODER_MODE14_1                 (0x2UL << GPIO_MODER_MODE14_Pos)        /*!< 0x20000000 */
#define GPIO_MODER_MODE15_Pos               (30U)
#define GPIO_MODER_MODE15_Msk               (0x3UL << GPIO_MODER_MODE15_Pos)        /*!< 0xC0000000 */
#define GPIO_MODER_MODE15                   GPIO_MODER_MODE15_Msk
#define GPIO_MODER_MODE15_0                 (0x1UL << GPIO_MODER_MODE15_Pos)        /*!< 0x40000000 */
#define GPIO_MODER_MODE15_1                 (0x2UL << GPIO_MODER_MODE15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_OTYPER register  ****************/
#define GPIO_OTYPER_OT0_Pos                 (0U)
#define GPIO_OTYPER_OT0_Msk                 (0x1UL << GPIO_OTYPER_OT0_Pos)          /*!< 0x00000001 */
#define GPIO_OTYPER_OT0                     GPIO_OTYPER_OT0_Msk
#define GPIO_OTYPER_OT1_Pos                 (1U)
#define GPIO_OTYPER_OT1_Msk                 (0x1UL << GPIO_OTYPER_OT1_Pos)          /*!< 0x00000002 */
#define GPIO_OTYPER_OT1                     GPIO_OTYPER_OT1_Msk
#define GPIO_OTYPER_OT2_Pos                 (2U)
#define GPIO_OTYPER_OT2_Msk                 (0x1UL << GPIO_OTYPER_OT2_Pos)          /*!< 0x00000004 */
#define GPIO_OTYPER_OT2                     GPIO_OTYPER_OT2_Msk
#define GPIO_OTYPER_OT3_Pos                 (3U)
#define GPIO_OTYPER_OT3_Msk                 (0x1UL << GPIO_OTYPER_OT3_Pos)          /*!< 0x00000008 */
#define GPIO_OTYPER_OT3                     GPIO_OTYPER_OT3_Msk
#define GPIO_OTYPER_OT4_Pos                 (4U)
#define GPIO_OTYPER_OT4_Msk                 (0x1UL << GPIO_OTYPER_OT4_Pos)          /*!< 0x00000010 */
#define GPIO_OTYPER_OT4                     GPIO_OTYPER_OT4_Msk
#define GPIO_OTYPER_OT5_Pos                 (5U)
#define GPIO_OTYPER_OT5_Msk                 (0x1UL << GPIO_OTYPER_OT5_Pos)          /*!< 0x00000020 */
#define GPIO_OTYPER_OT5                     GPIO_OTYPER_OT5_Msk
#define GPIO_OTYPER_OT6_Pos                 (6U)
#define GPIO_OTYPER_OT6_Msk                 (0x1UL << GPIO_OTYPER_OT6_Pos)          /*!< 0x00000040 */
#define GPIO_OTYPER_OT6                     GPIO_OTYPER_OT6_Msk
#define GPIO_OTYPER_OT7_Pos                 (7U)
#define GPIO_OTYPER_OT7_Msk                 (0x1UL << GPIO_OTYPER_OT7_Pos)          /*!< 0x00000080 */
#define GPIO_OTYPER_OT7                     GPIO_OTYPER_OT7_Msk
#define GPIO_OTYPER_OT8_Pos                 (8U)
#define GPIO_OTYPER_OT8_Msk                 (0x1UL << GPIO_OTYPER_OT8_Pos)          /*!< 0x00000100 */
#define GPIO_OTYPER_OT8                     GPIO_OTYPER_OT8_Msk
#define GPIO_OTYPER_OT9_Pos                 (9U)
#define GPIO_OTYPER_OT9_Msk                 (0x1UL << GPIO_OTYPER_OT9_Pos)          /*!< 0x00000200 */
#define GPIO_OTYPER_OT9                     GPIO_OTYPER_OT9_Msk
#define GPIO_OTYPER_OT10_Pos                (10U)
#define GPIO_OTYPER_OT10_Msk                (0x1UL << GPIO_OTYPER_OT10_Pos)         /*!< 0x00000400 */
#define GPIO_OTYPER_OT10                    GPIO_OTYPER_OT10_Msk
#define GPIO_OTYPER_OT11_Pos                (11U)
#define GPIO_OTYPER_OT11_Msk                (0x1UL << GPIO_OTYPER_OT11_Pos)         /*!< 0x00000800 */
#define GPIO_OTYPER_OT11                    GPIO_OTYPER_OT11_Msk
#define GPIO_OTYPER_OT12_Pos                (12U)
#define GPIO_OTYPER_OT12_Msk                (0x1UL << GPIO_OTYPER_OT12_Pos)         /*!< 0x00001000 */
#define GPIO_OTYPER_OT12                    GPIO_OTYPER_OT12_Msk
#define GPIO_OTYPER_OT13_Pos                (13U)
#define GPIO_OTYPER_OT13_Msk                (0x1UL << GPIO_OTYPER_OT13_Pos)         /*!< 0x00002000 */
#define GPIO_OTYPER_OT13                    GPIO_OTYPER_OT13_Msk
#define GPIO_OTYPER_OT14_Pos                (14U)
#define GPIO_OTYPER_OT14_Msk                (0x1UL << GPIO_OTYPER_OT14_Pos)         /*!< 0x00004000 */
#define GPIO_OTYPER_OT14                    GPIO_OTYPER_OT14_Msk
#define GPIO_OTYPER_OT15_Pos                (15U)
#define GPIO_OTYPER_OT15_Msk                (0x1UL << GPIO_OTYPER_OT15_Pos)         /*!< 0x00008000 */
#define GPIO_OTYPER_OT15                    GPIO_OTYPER_OT15_Msk

/******************  Bits definition for GPIO_OSPEEDR register  ***************/
#define GPIO_OSPEEDR_OSPEED0_Pos            (0U)
#define GPIO_OSPEEDR_OSPEED0_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000003 */
#define GPIO_OSPEEDR_OSPEED0                GPIO_OSPEEDR_OSPEED0_Msk
#define GPIO_OSPEEDR_OSPEED0_0              (0x1UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000001 */
#define GPIO_OSPEEDR_OSPEED0_1              (0x2UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000002 */
#define GPIO_OSPEEDR_OSPEED1_Pos            (2U)
#define GPIO_OSPEEDR_OSPEED1_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x0000000C */
#define GPIO_OSPEEDR_OSPEED1                GPIO_OSPEEDR_OSPEED1_Msk
#define GPIO_OSPEEDR_OSPEED1_0              (0x1UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000004 */
#define GPIO_OSPEEDR_OSPEED1_1              (0x2UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000008 */
#define GPIO_OSPEEDR_OSPEED2_Pos            (4U)
#define GPIO_OSPEEDR_OSPEED2_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000030 */
#define GPIO_OSPEEDR_OSPEED2                GPIO_OSPEEDR_OSPEED2_Msk
#define GPIO_OSPEEDR_OSPEED2_0              (0x1UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000010 */
#define GPIO_OSPEEDR_OSPEED2_1              (0x2UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000020 */
#define GPIO_OSPEEDR_OSPEED3_Pos            (6U)
#define GPIO_OSPEEDR_OSPEED3_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x000000C0 */
#define GPIO_OSPEEDR_OSPEED3                GPIO_OSPEEDR_OSPEED3_Msk
#define GPIO_OSPEEDR_OSPEED3_0              (0x1UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000040 */
#define GPIO_OSPEEDR_OSPEED3_1              (0x2UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000080 */
#define GPIO_OSPEEDR_OSPEED4_Pos            (8U)
#define GPIO_OSPEEDR_OSPEED4_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000300 */
#define GPIO_OSPEEDR_OSPEED4                GPIO_OSPEEDR_OSPEED4_Msk
#define GPIO_OSPEEDR_OSPEED4_0              (0x1UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000100 */
#define GPIO_OSPEEDR_OSPEED4_1              (0x2UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000200 */
#define GPIO_OSPEEDR_OSPEED5_Pos            (10U)
#define GPIO_OSPEEDR_OSPEED5_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000C00 */
#define GPIO_OSPEEDR_OSPEED5                GPIO_OSPEEDR_OSPEED5_Msk
#define GPIO_OSPEEDR_OSPEED5_0              (0x1UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000400 */
#define GPIO_OSPEEDR_OSPEED5_1              (0x2UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000800 */
#define GPIO_OSPEEDR_OSPEED6_Pos            (12U)
#define GPIO_OSPEEDR_OSPEED6_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00003000 */
#define GPIO_OSPEEDR_OSPEED6                GPIO_OSPEEDR_OSPEED6_Msk
#define GPIO_OSPEEDR_OSPEED6_0              (0x1UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00001000 */
#define GPIO_OSPEEDR_OSPEED6_1              (0x2UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00002000 */
#define GPIO_OSPEEDR_OSPEED7_Pos            (14U)
#define GPIO_OSPEEDR_OSPEED7_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x0000C000 */
#define GPIO_OSPEEDR_OSPEED7                GPIO_OSPEEDR_OSPEED7_Msk
#define GPIO_OSPEEDR_OSPEED7_0              (0x1UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00004000 */
#define GPIO_OSPEEDR_OSPEED7_1              (0x2UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00008000 */
#define GPIO_OSPEEDR_OSPEED8_Pos            (16U)
#define GPIO_OSPEEDR_OSPEED8_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00030000 */
#define GPIO_OSPEEDR_OSPEED8                GPIO_OSPEEDR_OSPEED8_Msk
#define GPIO_OSPEEDR_OSPEED8_0              (0x1UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00010000 */
#define GPIO_OSPEEDR_OSPEED8_1              (0x2UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00020000 */
#define GPIO_OSPEEDR_OSPEED9_Pos            (18U)
#define GPIO_OSPEEDR_OSPEED9_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x000C0000 */
#define GPIO_OSPEEDR_OSPEED9                GPIO_OSPEEDR_OSPEED9_Msk
#define GPIO_OSPEEDR_OSPEED9_0              (0x1UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00040000 */
#define GPIO_OSPEEDR_OSPEED9_1              (0x2UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00080000 */
#define GPIO_OSPEEDR_OSPEED10_Pos           (20U)
#define GPIO_OSPEEDR_OSPEED10_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00300000 */
#define GPIO_OSPEEDR_OSPEED10               GPIO_OSPEEDR_OSPEED10_Msk
#define GPIO_OSPEEDR_OSPEED10_0             (0x1UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00100000 */
#define GPIO_OSPEEDR_OSPEED10_1             (0x2UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00200000 */
#define GPIO_OSPEEDR_OSPEED11_Pos           (22U)
#define GPIO_OSPEEDR_OSPEED11_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00C00000 */
#define GPIO_OSPEEDR_OSPEED11               GPIO_OSPEEDR_OSPEED11_Msk
#define GPIO_OSPEEDR_OSPEED11_0             (0x1UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00400000 */
#define GPIO_OSPEEDR_OSPEED11_1             (0x2UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00800000 */
#define GPIO_OSPEEDR_OSPEED12_Pos           (24U)
#define GPIO_OSPEEDR_OSPEED12_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x03000000 */
#define GPIO_OSPEEDR_OSPEED12               GPIO_OSPEEDR_OSPEED12_Msk
#define GPIO_OSPEEDR_OSPEED12_0             (0x1UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x01000000 */
#define GPIO_OSPEEDR_OSPEED12_1             (0x2UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x02000000 */
#define GPIO_OSPEEDR_OSPEED13_Pos           (26U)
#define GPIO_OSPEEDR_OSPEED13_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x0C000000 */
#define GPIO_OSPEEDR_OSPEED13               GPIO_OSPEEDR_OSPEED13_Msk
#define GPIO_OSPEEDR_OSPEED13_0             (0x1UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x04000000 */
#define GPIO_OSPEEDR_OSPEED13_1             (0x2UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x08000000 */
#define GPIO_OSPEEDR_OSPEED14_Pos           (28U)
#define GPIO_OSPEEDR_OSPEED14_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x30000000 */
#define GPIO_OSPEEDR_OSPEED14               GPIO_OSPEEDR_OSPEED14_Msk
#define GPIO_OSPEEDR_OSPEED14_0             (0x1UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x10000000 */
#define GPIO_OSPEEDR_OSPEED14_1             (0x2UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x20000000 */
#define GPIO_OSPEEDR_OSPEED15_Pos           (30U)
#define GPIO_OSPEEDR_OSPEED15_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0xC0000000 */
#define GPIO_OSPEEDR_OSPEED15               GPIO_OSPEEDR_OSPEED15_Msk
#define GPIO_OSPEEDR_OSPEED15_0             (0x1UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x40000000 */
#define GPIO_OSPEEDR_OSPEED15_1             (0x2UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x80000000 */

/******************  Bits definition for GPIO_PUPDR register  *****************/
#define GPIO_PUPDR_PUPD0_Pos                (0U)
#define GPIO_PUPDR_PUPD0_Msk                (0x3UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000003 */
#define GPIO_PUPDR_PUPD0                    GPIO_PUPDR_PUPD0_Msk
#define GPIO_PUPDR_PUPD0_0                  (0x1UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000001 */
#define GPIO_PUPDR_PUPD0_1                  (0x2UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000002 */
#define GPIO_PUPDR_PUPD1_Pos                (2U)
#define GPIO_PUPDR_PUPD1_Msk                (0x3UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x0000000C */
#define GPIO_PUPDR_PUPD1                    GPIO_PUPDR_PUPD1_Msk
#define GPIO_PUPDR_PUPD1_0                  (0x1UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000004 */
#define GPIO_PUPDR_PUPD1_1                  (0x2UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000008 */
#define GPIO_PUPDR_PUPD2_Pos                (4U)
#define GPIO_PUPDR_PUPD2_Msk                (0x3UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000030 */
#define GPIO_PUPDR_PUPD2                    GPIO_PUPDR_PUPD2_Msk
#define GPIO_PUPDR_PUPD2_0                  (0x1UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000010 */
#define GPIO_PUPDR_PUPD2_1                  (0x2UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000020 */
#define GPIO_PUPDR_PUPD3_Pos                (6U)
#define GPIO_PUPDR_PUPD3_Msk                (0x3UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x000000C0 */
#define GPIO_PUPDR_PUPD3                    GPIO_PUPDR_PUPD3_Msk
#define GPIO_PUPDR_PUPD3_0                  (0x1UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000040 */
#define GPIO_PUPDR_PUPD3_1                  (0x2UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000080 */
#define GPIO_PUPDR_PUPD4_Pos                (8U)
#define GPIO_PUPDR_PUPD4_Msk                (0x3UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000300 */
#define GPIO_PUPDR_PUPD4                    GPIO_PUPDR_PUPD4_Msk
#define GPIO_PUPDR_PUPD4_0                  (0x1UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000100 */
#define GPIO_PUPDR_PUPD4_1                  (0x2UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000200 */
#define GPIO_PUPDR_PUPD5_Pos                (10U)
#define GPIO_PUPDR_PUPD5_Msk                (0x3UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000C00 */
#define GPIO_PUPDR_PUPD5                    GPIO_PUPDR_PUPD5_Msk
#define GPIO_PUPDR_PUPD5_0                  (0x1UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000400 */
#define GPIO_PUPDR_PUPD5_1                  (0x2UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000800 */
#define GPIO_PUPDR_PUPD6_Pos                (12U)
#define GPIO_PUPDR_PUPD6_Msk                (0x3UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00003000 */
#define GPIO_PUPDR_PUPD6                    GPIO_PUPDR_PUPD6_Msk
#define GPIO_PUPDR_PUPD6_0                  (0x1UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00001000 */
#define GPIO_PUPDR_PUPD6_1                  (0x2UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00002000 */
#define GPIO_PUPDR_PUPD7_Pos                (14U)
#define GPIO_PUPDR_PUPD7_Msk                (0x3UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x0000C000 */
#define GPIO_PUPDR_PUPD7                    GPIO_PUPDR_PUPD7_Msk
#define GPIO_PUPDR_PUPD7_0                  (0x1UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00004000 */
#define GPIO_PUPDR_PUPD7_1                  (0x2UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00008000 */
#define GPIO_PUPDR_PUPD8_Pos                (16U)
#define GPIO_PUPDR_PUPD8_Msk                (0x3UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00030000 */
#define GPIO_PUPDR_PUPD8                    GPIO_PUPDR_PUPD8_Msk
#define GPIO_PUPDR_PUPD8_0                  (0x1UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00010000 */
#define GPIO_PUPDR_PUPD8_1                  (0x2UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00020000 */
#define GPIO_PUPDR_PUPD9_Pos                (18U)
#define GPIO_PUPDR_PUPD9_Msk                (0x3UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x000C0000 */
#define GPIO_PUPDR_PUPD9                    GPIO_PUPDR_PUPD9_Msk
#define GPIO_PUPDR_PUPD9_0                  (0x1UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00040000 */
#define GPIO_PUPDR_PUPD9_1                  (0x2UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00080000 */
#define GPIO_PUPDR_PUPD10_Pos               (20U)
#define GPIO_PUPDR_PUPD10_Msk               (0x3UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00300000 */
#define GPIO_PUPDR_PUPD10                   GPIO_PUPDR_PUPD10_Msk
#define GPIO_PUPDR_PUPD10_0                 (0x1UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00100000 */
#define GPIO_PUPDR_PUPD10_1                 (0x2UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00200000 */
#define GPIO_PUPDR_PUPD11_Pos               (22U)
#define GPIO_PUPDR_PUPD11_Msk               (0x3UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00C00000 */
#define GPIO_PUPDR_PUPD11                   GPIO_PUPDR_PUPD11_Msk
#define GPIO_PUPDR_PUPD11_0                 (0x1UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00400000 */
#define GPIO_PUPDR_PUPD11_1                 (0x2UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00800000 */
#define GPIO_PUPDR_PUPD12_Pos               (24U)
#define GPIO_PUPDR_PUPD12_Msk               (0x3UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x03000000 */
#define GPIO_PUPDR_PUPD12                   GPIO_PUPDR_PUPD12_Msk
#define GPIO_PUPDR_PUPD12_0                 (0x1UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x01000000 */
#define GPIO_PUPDR_PUPD12_1                 (0x2UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x02000000 */
#define GPIO_PUPDR_PUPD13_Pos               (26U)
#define GPIO_PUPDR_PUPD13_Msk               (0x3UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x0C000000 */
#define GPIO_PUPDR_PUPD13                   GPIO_PUPDR_PUPD13_Msk
#define GPIO_PUPDR_PUPD13_0                 (0x1UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x04000000 */
#define GPIO_PUPDR_PUPD13_1                 (0x2UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x08000000 */
#define GPIO_PUPDR_PUPD14_Pos               (28U)
#define GPIO_PUPDR_PUPD14_Msk               (0x3UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x30000000 */
#define GPIO_PUPDR_PUPD14                   GPIO_PUPDR_PUPD14_Msk
#define GPIO_PUPDR_PUPD14_0                 (0x1UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x10000000 */
#define GPIO_PUPDR_PUPD14_1                 (0x2UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x20000000 */
#define GPIO_PUPDR_PUPD15_Pos               (30U)
#define GPIO_PUPDR_PUPD15_Msk               (0x3UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0xC0000000 */
#define GPIO_PUPDR_PUPD15                   GPIO_PUPDR_PUPD15_Msk
#define GPIO_PUPDR_PUPD15_0                 (0x1UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x40000000 */
#define GPIO_PUPDR_PUPD15_1                 (0x2UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_IDR register  *******************/
#define GPIO_IDR_ID0_Pos                    (0U)
#define GPIO_IDR_ID0_Msk                    (0x1UL << GPIO_IDR_ID0_Pos)             /*!< 0x00000001 */
#define GPIO_IDR_ID0                        GPIO_IDR_ID0_Msk
#define GPIO_IDR_ID1_Pos                    (1U)
#define GPIO_IDR_ID1_Msk                    (0x1UL << GPIO_IDR_ID1_Pos)             /*!< 0x00000002 */
#define GPIO_IDR_ID1                        GPIO_IDR_ID1_Msk
#define GPIO_IDR_ID2_Pos                    (2U)
#define GPIO_IDR_ID2_Msk                    (0x1UL << GPIO_IDR_ID2_Pos)             /*!< 0x00000004 */
#define GPIO_IDR_ID2                        GPIO_IDR_ID2_Msk
#define GPIO_IDR_ID3_Pos                    (3U)
#define GPIO_IDR_ID3_Msk                    (0x1UL << GPIO_IDR_ID3_Pos)             /*!< 0x00000008 */
#define GPIO_IDR_ID3                        GPIO_IDR_ID3_Msk
#define GPIO_IDR_ID4_Pos                    (4U)
#define GPIO_IDR_ID4_Msk                    (0x1UL << GPIO_IDR_ID4_Pos)             /*!< 0x00000010 */
#define GPIO_IDR_ID4                        GPIO_IDR_ID4_Msk
#define GPIO_IDR_ID5_Pos                    (5U)
#define GPIO_IDR_ID5_Msk                    (0x1UL << GPIO_IDR_ID5_Pos)             /*!< 0x00000020 */
#define GPIO_IDR_ID5                        GPIO_IDR_ID5_Msk
#define GPIO_IDR_ID6_Pos                    (6U)
#define GPIO_IDR_ID6_Msk                    (0x1UL << GPIO_IDR_ID6_Pos)             /*!< 0x00000040 */
#define GPIO_IDR_ID6                        GPIO_IDR_ID6_Msk
#define GPIO_IDR_ID7_Pos                    (7U)
#define GPIO_IDR_ID7_Msk                    (0x1UL << GPIO_IDR_ID7_Pos)             /*!< 0x00000080 */
#define GPIO_IDR_ID7                        GPIO_IDR_ID7_Msk
#define GPIO_IDR_ID8_Pos                    (8U)
#define GPIO_IDR_ID8_Msk                    (0x1UL << GPIO_IDR_ID8_Pos)             /*!< 0x00000100 */
#define GPIO_IDR_ID8                        GPIO_IDR_ID8_Msk
#define GPIO_IDR_ID9_Pos                    (9U)
#define GPIO_IDR_ID9_Msk                    (0x1UL << GPIO_IDR_ID9_Pos)             /*!< 0x00000200 */
#define GPIO_IDR_ID9                        GPIO_IDR_ID9_Msk
#define GPIO_IDR_ID10_Pos                   (10U)
#define GPIO_IDR_ID10_Msk                   (0x1UL << GPIO_IDR_ID10_Pos)            /*!< 0x00000400 */
#define GPIO_IDR_ID10                       GPIO_IDR_ID10_Msk
#define GPIO_IDR_ID11_Pos                   (11U)
#define GPIO_IDR_ID11_Msk                   (0x1UL << GPIO_IDR_ID11_Pos)            /*!< 0x00000800 */
#define GPIO_IDR_ID11                       GPIO_IDR_ID11_Msk
#define GPIO_IDR_ID12_Pos                   (12U)
#define GPIO_IDR_ID12_Msk                   (0x1UL << GPIO_IDR_ID12_Pos)            /*!< 0x00001000 */
#define GPIO_IDR_ID12                       GPIO_IDR_ID12_Msk
#define GPIO_IDR_ID13_Pos                   (13U)
#define GPIO_IDR_ID13_Msk                   (0x1UL << GPIO_IDR_ID13_Pos)            /*!< 0x00002000 */
#define GPIO_IDR_ID13                       GPIO_IDR_ID13_Msk
#define GPIO_IDR_ID14_Pos                   (14U)
#define GPIO_IDR_ID14_Msk                   (0x1UL << GPIO_IDR_ID14_Pos)            /*!< 0x00004000 */
#define GPIO_IDR_ID14                       GPIO_IDR_ID14_Msk
#define GPIO_IDR_ID15_Pos                   (15U)
#define GPIO_IDR_ID15_Msk                   (0x1UL << GPIO_IDR_ID15_Pos)            /*!< 0x00008000 */
#define GPIO_IDR_ID15                       GPIO_IDR_ID15_Msk

/******************  Bits definition for GPIO_ODR register  *******************/
#define GPIO_ODR_OD0_Pos                    (0U)
#define GPIO_ODR_OD0_Msk                    (0x1UL << GPIO_ODR_OD0_Pos)             /*!< 0x00000001 */
#define GPIO_ODR_OD0                        GPIO_ODR_OD0_Msk
#define GPIO_ODR_OD1_Pos                    (1U)
#define GPIO_ODR_OD1_Msk                    (0x1UL << GPIO_ODR_OD1_Pos)             /*!< 0x00000002 */
#define GPIO_ODR_OD1                        GPIO_ODR_OD1_Msk
#define GPIO_ODR_OD2_Pos                    (2U)
#define GPIO_ODR_OD2_Msk                    (0x1UL << GPIO_ODR_OD2_Pos)             /*!< 0x00000004 */
#define GPIO_ODR_OD2                        GPIO_ODR_OD2_Msk
#define GPIO_ODR_OD3_Pos                    (3U)
#define GPIO_ODR_OD3_Msk                    (0x1UL << GPIO_ODR_OD3_Pos)             /*!< 0x00000008 */
#define GPIO_ODR_OD3                        GPIO_ODR_OD3_Msk
#define GPIO_ODR_OD4_Pos                    (4U)
#define GPIO_ODR_OD4_Msk                    (0x1UL << GPIO_ODR_OD4_Pos)             /*!< 0x00000010 */
#define GPIO_ODR_OD4                        GPIO_ODR_OD4_Msk
#define GPIO_ODR_OD5_Pos                    (5U)
#define GPIO_ODR_OD5_Msk                    (0x1UL << GPIO_ODR_OD5_Pos)             /*!< 0x00000020 */
#define GPIO_ODR_OD5                        GPIO_ODR_OD5_Msk
#define GPIO_ODR_OD6_Pos                    (6U)
#define GPIO_ODR_OD6_Msk                    (0x1UL << GPIO_ODR_OD6_Pos)             /*!< 0x00000040 */
#define GPIO_ODR_OD6                        GPIO_ODR_OD6_Msk
#define GPIO_ODR_OD7_Pos                    (7U)
#define GPIO_ODR_OD7_Msk                    (0x1UL << GPIO_ODR_OD7_Pos)             /*!< 0x00000080 */
#define GPIO_ODR_OD7                        GPIO_ODR_OD7_Msk
#define GPIO_ODR_OD8_Pos                    (8U)
#define GPIO_ODR_OD8_Msk                    (0x1UL << GPIO_ODR_OD8_Pos)             /*!< 0x00000100 */
#define GPIO_ODR_OD8                        GPIO_ODR_OD8_Msk
#define GPIO_ODR_OD9_Pos                    (9U)
#define GPIO_ODR_OD9_Msk                    (0x1UL << GPIO_ODR_OD9_Pos)             /*!< 0x00000200 */
#define GPIO_ODR_OD9                        GPIO_ODR_OD9_Msk
#define GPIO_ODR_OD10_Pos                   (10U)
#define GPIO_ODR_OD10_Msk                   (0x1UL << GPIO_ODR_OD10_Pos)            /*!< 0x00000400 */
#define GPIO_ODR_OD10                       GPIO_ODR_OD10_Msk
#define GPIO_ODR_OD11_Pos                   (11U)
#define GPIO_ODR_OD11_Msk                   (0x1UL << GPIO_ODR_OD11_Pos)            /*!< 0x00000800 */
#define GPIO_ODR_OD11                       GPIO_ODR_OD11_Msk
#define GPIO_ODR_OD12_Pos                   (12U)
#define GPIO_ODR_OD12_Msk                   (0x1UL << GPIO_ODR_OD12_Pos)            /*!< 0x00001000 */
#define GPIO_ODR_OD12                       GPIO_ODR_OD12_Msk
#define GPIO_ODR_OD13_Pos                   (13U)
#define GPIO_ODR_OD13_Msk                   (0x1UL << GPIO_ODR_OD13_Pos)            /*!< 0x00002000 */
#define GPIO_ODR_OD13                       GPIO_ODR_OD13_Msk
#define GPIO_ODR_OD14_Pos                   (14U)
#define GPIO_ODR_OD14_Msk                   (0x1UL << GPIO_ODR_OD14_Pos)            /*!< 0x00004000 */
#define GPIO_ODR_OD14                       GPIO_ODR_OD14_Msk
#define GPIO_ODR_OD15_Pos                   (15U)
#define GPIO_ODR_OD15_Msk                   (0x1UL << GPIO_ODR_OD15_Pos)            /*!< 0x00008000 */
#define GPIO_ODR_OD15                       GPIO_ODR_OD15_Msk

/******************  Bits definition for GPIO_BSRR register  ******************/
#define GPIO_BSRR_BS0_Pos                   (0U)
#define GPIO_BSRR_BS0_Msk                   (0x1UL << GPIO_BSRR_BS0_Pos)            /*!< 0x00000001 */
#define GPIO_BSRR_BS0                       GPIO_BSRR_BS0_Msk
#define GPIO_BSRR_BS1_Pos                   (1U)
#define GPIO_BSRR_BS1_Msk                   (0x1UL << GPIO_BSRR_BS1_Pos)            /*!< 0x00000002 */
#define GPIO_BSRR_BS1                       GPIO_BSRR_BS1_Msk
#define GPIO_BSRR_BS2_Pos                   (2U)
#define GPIO_BSRR_BS2_Msk                   (0x1UL << GPIO_BSRR_BS2_Pos)            /*!< 0x00000004 */
#define GPIO_BSRR_BS2                       GPIO_BSRR_BS2_Msk
#define GPIO_BSRR_BS3_Pos                   (3U)
#define GPIO_BSRR_BS3_Msk                   (0x1UL << GPIO_BSRR_BS3_Pos)            /*!< 0x00000008 */
#define GPIO_BSRR_BS3                       GPIO_BSRR_BS3_Msk
#define GPIO_BSRR_BS4_Pos                   (4U)
#define GPIO_BSRR_BS4_Msk                   (0x1UL << GPIO_BSRR_BS4_Pos)            /*!< 0x00000010 */
#define GPIO_BSRR_BS4                       GPIO_BSRR_BS4_Msk
#define GPIO_BSRR_BS5_Pos                   (5U)
#define GPIO_BSRR_BS5_Msk                   (0x1UL << GPIO_BSRR_BS5_Pos)            /*!< 0x00000020 */
#define GPIO_BSRR_BS5                       GPIO_BSRR_BS5_Msk
#define GPIO_BSRR_BS6_Pos                   (6U)
#define GPIO_BSRR_BS6_Msk                   (0x1UL << GPIO_BSRR_BS6_Pos)            /*!< 0x00000040 */
#define GPIO_BSRR_BS6                       GPIO_BSRR_BS6_Msk
#define GPIO_BSRR_BS7_Pos                   (7U)
#define GPIO_BSRR_BS7_Msk                   (0x1UL << GPIO_BSRR_BS7_Pos)            /*!< 0x00000080 */
#define GPIO_BSRR_BS7                       GPIO_BSRR_BS7_Msk
#define GPIO_BSRR_BS8_Pos                   (8U)
#define GPIO_BSRR_BS8_Msk                   (0x1UL << GPIO_BSRR_BS8_Pos)            /*!< 0x00000100 */
#define GPIO_BSRR_BS8                       GPIO_BSRR_BS8_Msk
#define GPIO_BSRR_BS9_Pos                   (9U)
#define GPIO_BSRR_BS9_Msk                   (0x1UL << GPIO_BSRR_BS9_Pos)            /*!< 0x00000200 */
#define GPIO_BSRR_BS9                       GPIO_BSRR_BS9_Msk
#define GPIO_BSRR_BS10_Pos                  (10U)
#define GPIO_BSRR_BS10_Msk                  (0x1UL << GPIO_BSRR_BS10_Pos)           /*!< 0x00000400 */
#define GPIO_BSRR_BS10                      GPIO_BSRR_BS10_Msk
#define GPIO_BSRR_BS11_Pos                  (11U)
#define GPIO_BSRR_BS11_Msk                  (0x1UL << GPIO_BSRR_BS11_Pos)           /*!< 0x00000800 */
#define GPIO_BSRR_BS11                      GPIO_BSRR_BS11_Msk
#define GPIO_BSRR_BS12_Pos                  (12U)
#define GPIO_BSRR_BS12_Msk                  (0x1UL << GPIO_BSRR_BS12_Pos)           /*!< 0x00001000 */
#define GPIO_BSRR_BS12                      GPIO_BSRR_BS12_Msk
#define GPIO_BSRR_BS13_Pos                  (13U)
#define GPIO_BSRR_BS13_Msk                  (0x1UL << GPIO_BSRR_BS13_Pos)           /*!< 0x00002000 */
#define GPIO_BSRR_BS13                      GPIO_BSRR_BS13_Msk
#define GPIO_BSRR_BS14_Pos                  (14U)
#define GPIO_BSRR_BS14_Msk                  (0x1UL << GPIO_BSRR_BS14_Pos)           /*!< 0x00004000 */
#define GPIO_BSRR_BS14                      GPIO_BSRR_BS14_Msk
#define GPIO_BSRR_BS15_Pos                  (15U)
#define GPIO_BSRR_BS15_Msk                  (0x1UL << GPIO_BSRR_BS15_Pos)           /*!< 0x00008000 */
#define GPIO_BSRR_BS15                      GPIO_BSRR_BS15_Msk
#define GPIO_BSRR_BR0_Pos                   (16U)
#define GPIO_BSRR_BR0_Msk                   (0x1UL << GPIO_BSRR_BR0_Pos)            /*!< 0x00010000 */
#define GPIO_BSRR_BR0                       GPIO_BSRR_BR0_Msk
#define GPIO_BSRR_BR1_Pos                   (17U)
#define GPIO_BSRR_BR1_Msk                   (0x1UL << GPIO_BSRR_BR1_Pos)            /*!< 0x00020000 */
#define GPIO_BSRR_BR1                       GPIO_BSRR_BR1_Msk
#define GPIO_BSRR_BR2_Pos                   (18U)
#define GPIO_BSRR_BR2_Msk                   (0x1UL << GPIO_BSRR_BR2_Pos)            /*!< 0x00040000 */
#define GPIO_BSRR_BR2                       GPIO_BSRR_BR2_Msk
#define GPIO_BSRR_BR3_Pos                   (19U)
#define GPIO_BSRR_BR3_Msk                   (0x1UL << GPIO_BSRR_BR3_Pos)            /*!< 0x00080000 */
#define GPIO_BSRR_BR3                       GPIO_BSRR_BR3_Msk
#define GPIO_BSRR_BR4_Pos                   (20U)
#define GPIO_BSRR_BR4_Msk                   (0x1UL << GPIO_BSRR_BR4_Pos)            /*!< 0x00100000 */
#define GPIO_BSRR_BR4                       GPIO_BSRR_BR4_Msk
#define GPIO_BSRR_BR5_Pos                   (21U)
#define GPIO_BSRR_BR5_Msk                   (0x1UL << GPIO_BSRR_BR5_Pos)            /*!< 0x00200000 */
#define GPIO_BSRR_BR5                       GPIO_BSRR_BR5_Msk
#define GPIO_BSRR_BR6_Pos                   (22U)
#define GPIO_BSRR_BR6_Msk                   (0x1UL << GPIO_BSRR_BR6_Pos)            /*!< 0x00400000 */
#define GPIO_BSRR_BR6                       GPIO_BSRR_BR6_Msk
#define GPIO_BSRR_BR7_Pos                   (23U)
#define GPIO_BSRR_BR7_Msk                   (0x1UL << GPIO_BSRR_BR7_Pos)            /*!< 0x00800000 */
#define GPIO_BSRR_BR7                       GPIO_BSRR_BR7_Msk
#define GPIO_BSRR_BR8_Pos                   (24U)
#define GPIO_BSRR_BR8_Msk                   (0x1UL << GPIO_BSRR_BR8_Pos)            /*!< 0x01000000 */
#define GPIO_BSRR_BR8                       GPIO_BSRR_BR8_Msk
#define GPIO_BSRR_BR9_Pos                   (25U)
#define GPIO_BSRR_BR9_Msk                   (0x1UL << GPIO_BSRR_BR9_Pos)            /*!< 0x02000000 */
#define GPIO_BSRR_BR9                       GPIO_BSRR_BR9_Msk
#define GPIO_BSRR_BR10_Pos                  (26U)
#define GPIO_BSRR_BR10_Msk                  (0x1UL << GPIO_BSRR_BR10_Pos)           /*!< 0x04000000 */
#define GPIO_BSRR_BR10                      GPIO_BSRR_BR10_Msk
#define GPIO_BSRR_BR11_Pos                  (27U)
#define GPIO_BSRR_BR11_Msk                  (0x1UL << GPIO_BSRR_BR11_Pos)           /*!< 0x08000000 */
#define GPIO_BSRR_BR11                      GPIO_BSRR_BR11_Msk
#define GPIO_BSRR_BR12_Pos                  (28U)
#define GPIO_BSRR_BR12_Msk                  (0x1UL << GPIO_BSRR_BR12_Pos)           /*!< 0x10000000 */
#define GPIO_BSRR_BR12                      GPIO_BSRR_BR12_Msk
#define GPIO_BSRR_BR13_Pos                  (29U)
#define GPIO_BSRR_BR13_Msk                  (0x1UL << GPIO_BSRR_BR13_Pos)           /*!< 0x20000000 */
#define GPIO_BSRR_BR13                      GPIO_BSRR_BR13_Msk
#define GPIO_BSRR_BR14_Pos                  (30U)
#define GPIO_BSRR_BR14_Msk                  (0x1UL << GPIO_BSRR_BR14_Pos)           /*!< 0x40000000 */
#define GPIO_BSRR_BR14                      GPIO_BSRR_BR14_Msk
#define GPIO_BSRR_BR15_Pos                  (31U)
#define GPIO_BSRR_BR15_Msk                  (0x1UL << GPIO_BSRR_BR15_Pos)           /*!< 0x80000000 */
#define GPIO_BSRR_BR15                      GPIO_BSRR_BR15_Msk

/****************** Bit definition for GPIO_LCKR register *********************/
#define GPIO_LCKR_LCK0_Pos                  (0U)
#define GPIO_LCKR_LCK0_Msk                  (0x1UL << GPIO_LCKR_LCK0_Pos)           /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                      GPIO_LCKR_LCK0_Msk
#define GPIO_LCKR_LCK1_Pos                  (1U)
#define GPIO_LCKR_LCK1_Msk                  (0x1UL << GPIO_LCKR_LCK1_Pos)           /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                      GPIO_LCKR_LCK1_Msk
#define GPIO_LCKR_LCK2_Pos                  (2U)
#define GPIO_LCKR_LCK2_Msk                  (0x1UL << GPIO_LCKR_LCK2_Pos)           /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                      GPIO_LCKR_LCK2_Msk
#define GPIO_LCKR_LCK3_Pos                  (3U)
#define GPIO_LCKR_LCK3_Msk                  (0x1UL << GPIO_LCKR_LCK3_Pos)           /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                      GPIO_LCKR_LCK3_Msk
#define GPIO_LCKR_LCK4_Pos                  (4U)
#define GPIO_LCKR_LCK4_Msk                  (0x1UL << GPIO_LCKR_LCK4_Pos)           /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                      GPIO_LCKR_LCK4_Msk
#define GPIO_LCKR_LCK5_Pos                  (5U)
#define GPIO_LCKR_LCK5_Msk                  (0x1UL << GPIO_LCKR_LCK5_Pos)           /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                      GPIO_LCKR_LCK5_Msk
#define GPIO_LCKR_LCK6_Pos                  (6U)
#define GPIO_LCKR_LCK6_Msk                  (0x1UL << GPIO_LCKR_LCK6_Pos)           /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                      GPIO_LCKR_LCK6_Msk
#define GPIO_LCKR_LCK7_Pos                  (7U)
#define GPIO_LCKR_LCK7_Msk                  (0x1UL << GPIO_LCKR_LCK7_Pos)           /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                      GPIO_LCKR_LCK7_Msk
#define GPIO_LCKR_LCK8_Pos                  (8U)
#define GPIO_LCKR_LCK8_Msk                  (0x1UL << GPIO_LCKR_LCK8_Pos)           /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                      GPIO_LCKR_LCK8_Msk
#define GPIO_LCKR_LCK9_Pos                  (9U)
#define GPIO_LCKR_LCK9_Msk                  (0x1UL << GPIO_LCKR_LCK9_Pos)           /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                      GPIO_LCKR_LCK9_Msk
#define GPIO_LCKR_LCK10_Pos                 (10U)
#define GPIO_LCKR_LCK10_Msk                 (0x1UL << GPIO_LCKR_LCK10_Pos)          /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                     GPIO_LCKR_LCK10_Msk
#define GPIO_LCKR_LCK11_Pos                 (11U)
#define GPIO_LCKR_LCK11_Msk                 (0x1UL << GPIO_LCKR_LCK11_Pos)          /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                     GPIO_LCKR_LCK11_Msk
#define GPIO_LCKR_LCK12_Pos                 (12U)
#define GPIO_LCKR_LCK12_Msk                 (0x1UL << GPIO_LCKR_LCK12_Pos)          /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                     GPIO_LCKR_LCK12_Msk
#define GPIO_LCKR_LCK13_Pos                 (13U)
#define GPIO_LCKR_LCK13_Msk                 (0x1UL << GPIO_LCKR_LCK13_Pos)          /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                     GPIO_LCKR_LCK13_Msk
#define GPIO_LCKR_LCK14_Pos                 (14U)
#define GPIO_LCKR_LCK14_Msk                 (0x1UL << GPIO_LCKR_LCK14_Pos)          /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                     GPIO_LCKR_LCK14_Msk
#define GPIO_LCKR_LCK15_Pos                 (15U)
#define GPIO_LCKR_LCK15_Msk                 (0x1UL << GPIO_LCKR_LCK15_Pos)          /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                     GPIO_LCKR_LCK15_Msk
#define GPIO_LCKR_LCKK_Pos                  (16U)
#define GPIO_LCKR_LCKK_Msk                  (0x1UL << GPIO_LCKR_LCKK_Pos)           /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                      GPIO_LCKR_LCKK_Msk

/****************** Bit definition for GPIO_AFRL register *********************/
#define GPIO_AFRL_AFSEL0_Pos                (0U)
#define GPIO_AFRL_AFSEL0_Msk                (0xFUL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x0000000F */
#define GPIO_AFRL_AFSEL0                    GPIO_AFRL_AFSEL0_Msk
#define GPIO_AFRL_AFSEL0_0                  (0x1UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000001 */
#define GPIO_AFRL_AFSEL0_1                  (0x2UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000002 */
#define GPIO_AFRL_AFSEL0_2                  (0x4UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000004 */
#define GPIO_AFRL_AFSEL0_3                  (0x8UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000008 */
#define GPIO_AFRL_AFSEL1_Pos                (4U)
#define GPIO_AFRL_AFSEL1_Msk                (0xFUL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRL_AFSEL1                    GPIO_AFRL_AFSEL1_Msk
#define GPIO_AFRL_AFSEL1_0                  (0x1UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000010 */
#define GPIO_AFRL_AFSEL1_1                  (0x2UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000020 */
#define GPIO_AFRL_AFSEL1_2                  (0x4UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000040 */
#define GPIO_AFRL_AFSEL1_3                  (0x8UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000080 */
#define GPIO_AFRL_AFSEL2_Pos                (8U)
#define GPIO_AFRL_AFSEL2_Msk                (0xFUL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRL_AFSEL2                    GPIO_AFRL_AFSEL2_Msk
#define GPIO_AFRL_AFSEL2_0                  (0x1UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000100 */
#define GPIO_AFRL_AFSEL2_1                  (0x2UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000200 */
#define GPIO_AFRL_AFSEL2_2                  (0x4UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000400 */
#define GPIO_AFRL_AFSEL2_3                  (0x8UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000800 */
#define GPIO_AFRL_AFSEL3_Pos                (12U)
#define GPIO_AFRL_AFSEL3_Msk                (0xFUL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRL_AFSEL3                    GPIO_AFRL_AFSEL3_Msk
#define GPIO_AFRL_AFSEL3_0                  (0x1UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00001000 */
#define GPIO_AFRL_AFSEL3_1                  (0x2UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00002000 */
#define GPIO_AFRL_AFSEL3_2                  (0x4UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00004000 */
#define GPIO_AFRL_AFSEL3_3                  (0x8UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00008000 */
#define GPIO_AFRL_AFSEL4_Pos                (16U)
#define GPIO_AFRL_AFSEL4_Msk                (0xFUL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRL_AFSEL4                    GPIO_AFRL_AFSEL4_Msk
#define GPIO_AFRL_AFSEL4_0                  (0x1UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00010000 */
#define GPIO_AFRL_AFSEL4_1                  (0x2UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00020000 */
#define GPIO_AFRL_AFSEL4_2                  (0x4UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00040000 */
#define GPIO_AFRL_AFSEL4_3                  (0x8UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00080000 */
#define GPIO_AFRL_AFSEL5_Pos                (20U)
#define GPIO_AFRL_AFSEL5_Msk                (0xFUL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRL_AFSEL5                    GPIO_AFRL_AFSEL5_Msk
#define GPIO_AFRL_AFSEL5_0                  (0x1UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00100000 */
#define GPIO_AFRL_AFSEL5_1                  (0x2UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00200000 */
#define GPIO_AFRL_AFSEL5_2                  (0x4UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00400000 */
#define GPIO_AFRL_AFSEL5_3                  (0x8UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00800000 */
#define GPIO_AFRL_AFSEL6_Pos                (24U)
#define GPIO_AFRL_AFSEL6_Msk                (0xFUL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRL_AFSEL6                    GPIO_AFRL_AFSEL6_Msk
#define GPIO_AFRL_AFSEL6_0                  (0x1UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x01000000 */
#define GPIO_AFRL_AFSEL6_1                  (0x2UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x02000000 */
#define GPIO_AFRL_AFSEL6_2                  (0x4UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x04000000 */
#define GPIO_AFRL_AFSEL6_3                  (0x8UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x08000000 */
#define GPIO_AFRL_AFSEL7_Pos                (28U)
#define GPIO_AFRL_AFSEL7_Msk                (0xFUL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRL_AFSEL7                    GPIO_AFRL_AFSEL7_Msk
#define GPIO_AFRL_AFSEL7_0                  (0x1UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x10000000 */
#define GPIO_AFRL_AFSEL7_1                  (0x2UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x20000000 */
#define GPIO_AFRL_AFSEL7_2                  (0x4UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x40000000 */
#define GPIO_AFRL_AFSEL7_3                  (0x8UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x80000000 */

/****************** Bit definition for GPIO_AFRH register *********************/
#define GPIO_AFRH_AFSEL8_Pos                (0U)
#define GPIO_AFRH_AFSEL8_Msk                (0xFUL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x0000000F */
#define GPIO_AFRH_AFSEL8                    GPIO_AFRH_AFSEL8_Msk
#define GPIO_AFRH_AFSEL8_0                  (0x1UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000001 */
#define GPIO_AFRH_AFSEL8_1                  (0x2UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000002 */
#define GPIO_AFRH_AFSEL8_2                  (0x4UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000004 */
#define GPIO_AFRH_AFSEL8_3                  (0x8UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000008 */
#define GPIO_AFRH_AFSEL9_Pos                (4U)
#define GPIO_AFRH_AFSEL9_Msk                (0xFUL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRH_AFSEL9                    GPIO_AFRH_AFSEL9_Msk
#define GPIO_AFRH_AFSEL9_0                  (0x1UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000010 */
#define GPIO_AFRH_AFSEL9_1                  (0x2UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000020 */
#define GPIO_AFRH_AFSEL9_2                  (0x4UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000040 */
#define GPIO_AFRH_AFSEL9_3                  (0x8UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000080 */
#define GPIO_AFRH_AFSEL10_Pos               (8U)
#define GPIO_AFRH_AFSEL10_Msk               (0xFUL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000F00 */
#define GPIO_AFRH_AFSEL10                   GPIO_AFRH_AFSEL10_Msk
#define GPIO_AFRH_AFSEL10_0                 (0x1UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000100 */
#define GPIO_AFRH_AFSEL10_1                 (0x2UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000200 */
#define GPIO_AFRH_AFSEL10_2                 (0x4UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000400 */
#define GPIO_AFRH_AFSEL10_3                 (0x8UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000800 */
#define GPIO_AFRH_AFSEL11_Pos               (12U)
#define GPIO_AFRH_AFSEL11_Msk               (0xFUL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x0000F000 */
#define GPIO_AFRH_AFSEL11                   GPIO_AFRH_AFSEL11_Msk
#define GPIO_AFRH_AFSEL11_0                 (0x1UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00001000 */
#define GPIO_AFRH_AFSEL11_1                 (0x2UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00002000 */
#define GPIO_AFRH_AFSEL11_2                 (0x4UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00004000 */
#define GPIO_AFRH_AFSEL11_3                 (0x8UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00008000 */
#define GPIO_AFRH_AFSEL12_Pos               (16U)
#define GPIO_AFRH_AFSEL12_Msk               (0xFUL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x000F0000 */
#define GPIO_AFRH_AFSEL12                   GPIO_AFRH_AFSEL12_Msk
#define GPIO_AFRH_AFSEL12_0                 (0x1UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00010000 */
#define GPIO_AFRH_AFSEL12_1                 (0x2UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00020000 */
#define GPIO_AFRH_AFSEL12_2                 (0x4UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00040000 */
#define GPIO_AFRH_AFSEL12_3                 (0x8UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00080000 */
#define GPIO_AFRH_AFSEL13_Pos               (20U)
#define GPIO_AFRH_AFSEL13_Msk               (0xFUL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00F00000 */
#define GPIO_AFRH_AFSEL13                   GPIO_AFRH_AFSEL13_Msk
#define GPIO_AFRH_AFSEL13_0                 (0x1UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00100000 */
#define GPIO_AFRH_AFSEL13_1                 (0x2UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00200000 */
#define GPIO_AFRH_AFSEL13_2                 (0x4UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00400000 */
#define GPIO_AFRH_AFSEL13_3                 (0x8UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00800000 */
#define GPIO_AFRH_AFSEL14_Pos               (24U)
#define GPIO_AFRH_AFSEL14_Msk               (0xFUL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x0F000000 */
#define GPIO_AFRH_AFSEL14                   GPIO_AFRH_AFSEL14_Msk
#define GPIO_AFRH_AFSEL14_0                 (0x1UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x01000000 */
#define GPIO_AFRH_AFSEL14_1                 (0x2UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x02000000 */
#define GPIO_AFRH_AFSEL14_2                 (0x4UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x04000000 */
#define GPIO_AFRH_AFSEL14_3                 (0x8UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x08000000 */
#define GPIO_AFRH_AFSEL15_Pos               (28U)
#define GPIO_AFRH_AFSEL15_Msk               (0xFUL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0xF0000000 */
#define GPIO_AFRH_AFSEL15                   GPIO_AFRH_AFSEL15_Msk
#define GPIO_AFRH_AFSEL15_0                 (0x1UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x10000000 */
#define GPIO_AFRH_AFSEL15_1                 (0x2UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x20000000 */
#define GPIO_AFRH_AFSEL15_2                 (0x4UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x40000000 */
#define GPIO_AFRH_AFSEL15_3                 (0x8UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_BRR register  ******************/
#define GPIO_BRR_BR0_Pos                    (0U)
#define GPIO_BRR_BR0_Msk                    (0x1UL << GPIO_BRR_BR0_Pos)             /*!< 0x00000001 */
#define GPIO_BRR_BR0                        GPIO_BRR_BR0_Msk
#define GPIO_BRR_BR1_Pos                    (1U)
#define GPIO_BRR_BR1_Msk                    (0x1UL << GPIO_BRR_BR1_Pos)             /*!< 0x00000002 */
#define GPIO_BRR_BR1                        GPIO_BRR_BR1_Msk
#define GPIO_BRR_BR2_Pos                    (2U)
#define GPIO_BRR_BR2_Msk                    (0x1UL << GPIO_BRR_BR2_Pos)             /*!< 0x00000004 */
#define GPIO_BRR_BR2                        GPIO_BRR_BR2_Msk
#define GPIO_BRR_BR3_Pos                    (3U)
#define GPIO_BRR_BR3_Msk                    (0x1UL << GPIO_BRR_BR3_Pos)             /*!< 0x00000008 */
#define GPIO_BRR_BR3                        GPIO_BRR_BR3_Msk
#define GPIO_BRR_BR4_Pos                    (4U)
#define GPIO_BRR_BR4_Msk                    (0x1UL << GPIO_BRR_BR4_Pos)             /*!< 0x00000010 */
#define GPIO_BRR_BR4                        GPIO_BRR_BR4_Msk
#define GPIO_BRR_BR5_Pos                    (5U)
#define GPIO_BRR_BR5_Msk                    (0x1UL << GPIO_BRR_BR5_Pos)             /*!< 0x00000020 */
#define GPIO_BRR_BR5                        GPIO_BRR_BR5_Msk
#define GPIO_BRR_BR6_Pos                    (6U)
#define GPIO_BRR_BR6_Msk                    (0x1UL << GPIO_BRR_BR6_Pos)             /*!< 0x00000040 */
#define GPIO_BRR_BR6                        GPIO_BRR_BR6_Msk
#define GPIO_BRR_BR7_Pos                    (7U)
#define GPIO_BRR_BR7_Msk                    (0x1UL << GPIO_BRR_BR7_Pos)             /*!< 0x00000080 */
#define GPIO_BRR_BR7                        GPIO_BRR_BR7_Msk
#define GPIO_BRR_BR8_Pos                    (8U)
#define GPIO_BRR_BR8_Msk                    (0x1UL << GPIO_BRR_BR8_Pos)             /*!< 0x00000100 */
#define GPIO_BRR_BR8                        GPIO_BRR_BR8_Msk
#define GPIO_BRR_BR9_Pos                    (9U)
#define GPIO_BRR_BR9_Msk                    (0x1UL << GPIO_BRR_BR9_Pos)             /*!< 0x00000200 */
#define GPIO_BRR_BR9                        GPIO_BRR_BR9_Msk
#define GPIO_BRR_BR10_Pos                   (10U)
#define GPIO_BRR_BR10_Msk                   (0x1UL << GPIO_BRR_BR10_Pos)            /*!< 0x00000400 */
#define GPIO_BRR_BR10                       GPIO_BRR_BR10_Msk
#define GPIO_BRR_BR11_Pos                   (11U)
#define GPIO_BRR_BR11_Msk                   (0x1UL << GPIO_BRR_BR11_Pos)            /*!< 0x00000800 */
#define GPIO_BRR_BR11                       GPIO_BRR_BR11_Msk
#define GPIO_BRR_BR12_Pos                   (12U)
#define GPIO_BRR_BR12_Msk                   (0x1UL << GPIO_BRR_BR12_Pos)            /*!< 0x00001000 */
#define GPIO_BRR_BR12                       GPIO_BRR_BR12_Msk
#define GPIO_BRR_BR13_Pos                   (13U)
#define GPIO_BRR_BR13_Msk                   (0x1UL << GPIO_BRR_BR13_Pos)            /*!< 0x00002000 */
#define GPIO_BRR_BR13                       GPIO_BRR_BR13_Msk
#define GPIO_BRR_BR14_Pos                   (14U)
#define GPIO_BRR_BR14_Msk                   (0x1UL << GPIO_BRR_BR14_Pos)            /*!< 0x00004000 */
#define GPIO_BRR_BR14                       GPIO_BRR_BR14_Msk
#define GPIO_BRR_BR15_Pos                   (15U)
#define GPIO_BRR_BR15_Msk                   (0x1UL << GPIO_BRR_BR15_Pos)            /*!< 0x00008000 */
#define GPIO_BRR_BR15                       GPIO_BRR_BR15_Msk

/******************  Bits definition for GPIO_HSLVR register  ******************/
#define GPIO_HSLVR_HSLV0_Pos                (0U)
#define GPIO_HSLVR_HSLV0_Msk                (0x1UL << GPIO_HSLVR_HSLV0_Pos)         /*!< 0x00000001 */
#define GPIO_HSLVR_HSLV0                    GPIO_HSLVR_HSLV0_Msk
#define GPIO_HSLVR_HSLV1_Pos                (1U)
#define GPIO_HSLVR_HSLV1_Msk                (0x1UL << GPIO_HSLVR_HSLV1_Pos)         /*!< 0x00000002 */
#define GPIO_HSLVR_HSLV1                    GPIO_HSLVR_HSLV1_Msk
#define GPIO_HSLVR_HSLV2_Pos                (2U)
#define GPIO_HSLVR_HSLV2_Msk                (0x1UL << GPIO_HSLVR_HSLV2_Pos)         /*!< 0x00000004 */
#define GPIO_HSLVR_HSLV2                    GPIO_HSLVR_HSLV2_Msk
#define GPIO_HSLVR_HSLV3_Pos                (3U)
#define GPIO_HSLVR_HSLV3_Msk                (0x1UL << GPIO_HSLVR_HSLV3_Pos)         /*!< 0x00000008 */
#define GPIO_HSLVR_HSLV3                    GPIO_HSLVR_HSLV3_Msk
#define GPIO_HSLVR_HSLV4_Pos                (4U)
#define GPIO_HSLVR_HSLV4_Msk                (0x1UL << GPIO_HSLVR_HSLV4_Pos)         /*!< 0x00000010 */
#define GPIO_HSLVR_HSLV4                    GPIO_HSLVR_HSLV4_Msk
#define GPIO_HSLVR_HSLV5_Pos                (5U)
#define GPIO_HSLVR_HSLV5_Msk                (0x1UL << GPIO_HSLVR_HSLV5_Pos)         /*!< 0x00000020 */
#define GPIO_HSLVR_HSLV5                    GPIO_HSLVR_HSLV5_Msk
#define GPIO_HSLVR_HSLV6_Pos                (6U)
#define GPIO_HSLVR_HSLV6_Msk                (0x1UL << GPIO_HSLVR_HSLV6_Pos)         /*!< 0x00000040 */
#define GPIO_HSLVR_HSLV6                    GPIO_HSLVR_HSLV6_Msk
#define GPIO_HSLVR_HSLV7_Pos                (7U)
#define GPIO_HSLVR_HSLV7_Msk                (0x1UL << GPIO_HSLVR_HSLV7_Pos)         /*!< 0x00000080 */
#define GPIO_HSLVR_HSLV7                    GPIO_HSLVR_HSLV7_Msk
#define GPIO_HSLVR_HSLV8_Pos                (8U)
#define GPIO_HSLVR_HSLV8_Msk                (0x1UL << GPIO_HSLVR_HSLV8_Pos)         /*!< 0x00000100 */
#define GPIO_HSLVR_HSLV8                    GPIO_HSLVR_HSLV8_Msk
#define GPIO_HSLVR_HSLV9_Pos                (9U)
#define GPIO_HSLVR_HSLV9_Msk                (0x1UL << GPIO_HSLVR_HSLV9_Pos)         /*!< 0x00000200 */
#define GPIO_HSLVR_HSLV9                    GPIO_HSLVR_HSLV9_Msk
#define GPIO_HSLVR_HSLV10_Pos               (10U)
#define GPIO_HSLVR_HSLV10_Msk               (0x1UL << GPIO_HSLVR_HSLV10_Pos)        /*!< 0x00000400 */
#define GPIO_HSLVR_HSLV10                   GPIO_HSLVR_HSLV10_Msk
#define GPIO_HSLVR_HSLV11_Pos               (11U)
#define GPIO_HSLVR_HSLV11_Msk               (0x1UL << GPIO_HSLVR_HSLV11_Pos)        /*!< 0x00000800 */
#define GPIO_HSLVR_HSLV11                   GPIO_HSLVR_HSLV11_Msk
#define GPIO_HSLVR_HSLV12_Pos               (12U)
#define GPIO_HSLVR_HSLV12_Msk               (0x1UL << GPIO_HSLVR_HSLV12_Pos)        /*!< 0x00001000 */
#define GPIO_HSLVR_HSLV12                   GPIO_HSLVR_HSLV12_Msk
#define GPIO_HSLVR_HSLV13_Pos               (13U)
#define GPIO_HSLVR_HSLV13_Msk               (0x1UL << GPIO_HSLVR_HSLV13_Pos)        /*!< 0x00002000 */
#define GPIO_HSLVR_HSLV13                   GPIO_HSLVR_HSLV13_Msk
#define GPIO_HSLVR_HSLV14_Pos               (14U)
#define GPIO_HSLVR_HSLV14_Msk               (0x1UL << GPIO_HSLVR_HSLV14_Pos)        /*!< 0x00004000 */
#define GPIO_HSLVR_HSLV14                   GPIO_HSLVR_HSLV14_Msk
#define GPIO_HSLVR_HSLV15_Pos               (15U)
#define GPIO_HSLVR_HSLV15_Msk               (0x1UL << GPIO_HSLVR_HSLV15_Pos)        /*!< 0x00008000 */
#define GPIO_HSLVR_HSLV15                   GPIO_HSLVR_HSLV15_Msk

/******************  Bits definition for GPIO_SECCFGR register  ******************/
#define GPIO_SECCFGR_SEC0_Pos               (0U)
#define GPIO_SECCFGR_SEC0_Msk               (0x1UL << GPIO_SECCFGR_SEC0_Pos)        /*!< 0x00000001 */
#define GPIO_SECCFGR_SEC0                   GPIO_SECCFGR_SEC0_Msk
#define GPIO_SECCFGR_SEC1_Pos               (1U)
#define GPIO_SECCFGR_SEC1_Msk               (0x1UL << GPIO_SECCFGR_SEC1_Pos)        /*!< 0x00000002 */
#define GPIO_SECCFGR_SEC1                   GPIO_SECCFGR_SEC1_Msk
#define GPIO_SECCFGR_SEC2_Pos               (2U)
#define GPIO_SECCFGR_SEC2_Msk               (0x1UL << GPIO_SECCFGR_SEC2_Pos)        /*!< 0x00000004 */
#define GPIO_SECCFGR_SEC2                   GPIO_SECCFGR_SEC2_Msk
#define GPIO_SECCFGR_SEC3_Pos               (3U)
#define GPIO_SECCFGR_SEC3_Msk               (0x1UL << GPIO_SECCFGR_SEC3_Pos)        /*!< 0x00000008 */
#define GPIO_SECCFGR_SEC3                   GPIO_SECCFGR_SEC3_Msk
#define GPIO_SECCFGR_SEC4_Pos               (4U)
#define GPIO_SECCFGR_SEC4_Msk               (0x1UL << GPIO_SECCFGR_SEC4_Pos)        /*!< 0x00000010 */
#define GPIO_SECCFGR_SEC4                   GPIO_SECCFGR_SEC4_Msk
#define GPIO_SECCFGR_SEC5_Pos               (5U)
#define GPIO_SECCFGR_SEC5_Msk               (0x1UL << GPIO_SECCFGR_SEC5_Pos)        /*!< 0x00000020 */
#define GPIO_SECCFGR_SEC5                   GPIO_SECCFGR_SEC5_Msk
#define GPIO_SECCFGR_SEC6_Pos               (6U)
#define GPIO_SECCFGR_SEC6_Msk               (0x1UL << GPIO_SECCFGR_SEC6_Pos)        /*!< 0x00000040 */
#define GPIO_SECCFGR_SEC6                   GPIO_SECCFGR_SEC6_Msk
#define GPIO_SECCFGR_SEC7_Pos               (7U)
#define GPIO_SECCFGR_SEC7_Msk               (0x1UL << GPIO_SECCFGR_SEC7_Pos)        /*!< 0x00000080 */
#define GPIO_SECCFGR_SEC7                   GPIO_SECCFGR_SEC7_Msk
#define GPIO_SECCFGR_SEC8_Pos               (8U)
#define GPIO_SECCFGR_SEC8_Msk               (0x1UL << GPIO_SECCFGR_SEC8_Pos)        /*!< 0x00000100 */
#define GPIO_SECCFGR_SEC8                   GPIO_SECCFGR_SEC8_Msk
#define GPIO_SECCFGR_SEC9_Pos               (9U)
#define GPIO_SECCFGR_SEC9_Msk               (0x1UL << GPIO_SECCFGR_SEC9_Pos)        /*!< 0x00000200 */
#define GPIO_SECCFGR_SEC9                   GPIO_SECCFGR_SEC9_Msk
#define GPIO_SECCFGR_SEC10_Pos              (10U)
#define GPIO_SECCFGR_SEC10_Msk              (0x1UL << GPIO_SECCFGR_SEC10_Pos)       /*!< 0x00000400 */
#define GPIO_SECCFGR_SEC10                  GPIO_SECCFGR_SEC10_Msk
#define GPIO_SECCFGR_SEC11_Pos              (11U)
#define GPIO_SECCFGR_SEC11_Msk              (0x1UL << GPIO_SECCFGR_SEC11_Pos)       /*!< 0x00000800 */
#define GPIO_SECCFGR_SEC11                  GPIO_SECCFGR_SEC11_Msk
#define GPIO_SECCFGR_SEC12_Pos              (12U)
#define GPIO_SECCFGR_SEC12_Msk              (0x1UL << GPIO_SECCFGR_SEC12_Pos)       /*!< 0x00001000 */
#define GPIO_SECCFGR_SEC12                  GPIO_SECCFGR_SEC12_Msk
#define GPIO_SECCFGR_SEC13_Pos              (13U)
#define GPIO_SECCFGR_SEC13_Msk              (0x1UL << GPIO_SECCFGR_SEC13_Pos)       /*!< 0x00002000 */
#define GPIO_SECCFGR_SEC13                  GPIO_SECCFGR_SEC13_Msk
#define GPIO_SECCFGR_SEC14_Pos              (14U)
#define GPIO_SECCFGR_SEC14_Msk              (0x1UL << GPIO_SECCFGR_SEC14_Pos)       /*!< 0x00004000 */
#define GPIO_SECCFGR_SEC14                  GPIO_SECCFGR_SEC14_Msk
#define GPIO_SECCFGR_SEC15_Pos              (15U)
#define GPIO_SECCFGR_SEC15_Msk              (0x1UL << GPIO_SECCFGR_SEC15_Pos)       /*!< 0x00008000 */
#define GPIO_SECCFGR_SEC15                  GPIO_SECCFGR_SEC15_Msk

/******************************************************************************/
/*                                                                            */
/*                                 ICACHE                                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for ICACHE_CR register  *******************/
#define ICACHE_CR_EN_Pos                    (0U)
#define ICACHE_CR_EN_Msk                    (0x1UL << ICACHE_CR_EN_Pos)             /*!< 0x00000001 */
#define ICACHE_CR_EN                        ICACHE_CR_EN_Msk                        /*!< Enable */
#define ICACHE_CR_CACHEINV_Pos              (1U)
#define ICACHE_CR_CACHEINV_Msk              (0x1UL << ICACHE_CR_CACHEINV_Pos)       /*!< 0x00000002 */
#define ICACHE_CR_CACHEINV                  ICACHE_CR_CACHEINV_Msk                  /*!< Cache invalidation */
#define ICACHE_CR_WAYSEL_Pos                (2U)
#define ICACHE_CR_WAYSEL_Msk                (0x1UL << ICACHE_CR_WAYSEL_Pos)         /*!< 0x00000004 */
#define ICACHE_CR_WAYSEL                    ICACHE_CR_WAYSEL_Msk                    /*!< Ways selection */
#define ICACHE_CR_HITMEN_Pos                (16U)
#define ICACHE_CR_HITMEN_Msk                (0x1UL << ICACHE_CR_HITMEN_Pos)         /*!< 0x00010000 */
#define ICACHE_CR_HITMEN                    ICACHE_CR_HITMEN_Msk                    /*!< Hit monitor enable */
#define ICACHE_CR_MISSMEN_Pos               (17U)
#define ICACHE_CR_MISSMEN_Msk               (0x1UL << ICACHE_CR_MISSMEN_Pos)        /*!< 0x00020000 */
#define ICACHE_CR_MISSMEN                   ICACHE_CR_MISSMEN_Msk                   /*!< Miss monitor enable */
#define ICACHE_CR_HITMRST_Pos               (18U)
#define ICACHE_CR_HITMRST_Msk               (0x1UL << ICACHE_CR_HITMRST_Pos)        /*!< 0x00040000 */
#define ICACHE_CR_HITMRST                   ICACHE_CR_HITMRST_Msk                   /*!< Hit monitor reset */
#define ICACHE_CR_MISSMRST_Pos              (19U)
#define ICACHE_CR_MISSMRST_Msk              (0x1UL << ICACHE_CR_MISSMRST_Pos)       /*!< 0x00080000 */
#define ICACHE_CR_MISSMRST                  ICACHE_CR_MISSMRST_Msk                  /*!< Miss monitor reset */

/******************  Bit definition for ICACHE_SR register  *******************/
#define ICACHE_SR_BUSYF_Pos                 (0U)
#define ICACHE_SR_BUSYF_Msk                 (0x1UL << ICACHE_SR_BUSYF_Pos)          /*!< 0x00000001 */
#define ICACHE_SR_BUSYF                     ICACHE_SR_BUSYF_Msk                     /*!< Busy flag */
#define ICACHE_SR_BSYENDF_Pos               (1U)
#define ICACHE_SR_BSYENDF_Msk               (0x1UL << ICACHE_SR_BSYENDF_Pos)        /*!< 0x00000002 */
#define ICACHE_SR_BSYENDF                   ICACHE_SR_BSYENDF_Msk                   /*!< Busy end flag */
#define ICACHE_SR_ERRF_Pos                  (2U)
#define ICACHE_SR_ERRF_Msk                  (0x1UL << ICACHE_SR_ERRF_Pos)           /*!< 0x00000004 */
#define ICACHE_SR_ERRF                      ICACHE_SR_ERRF_Msk                      /*!< Cache error flag */

/******************  Bit definition for ICACHE_IER register  ******************/
#define ICACHE_IER_BSYENDIE_Pos             (1U)
#define ICACHE_IER_BSYENDIE_Msk             (0x1UL << ICACHE_IER_BSYENDIE_Pos)      /*!< 0x00000002 */
#define ICACHE_IER_BSYENDIE                 ICACHE_IER_BSYENDIE_Msk                 /*!< Busy end interrupt enable */
#define ICACHE_IER_ERRIE_Pos                (2U)
#define ICACHE_IER_ERRIE_Msk                (0x1UL << ICACHE_IER_ERRIE_Pos)         /*!< 0x00000004 */
#define ICACHE_IER_ERRIE                    ICACHE_IER_ERRIE_Msk                    /*!< Cache error interrupt enable */

/******************  Bit definition for ICACHE_FCR register  ******************/
#define ICACHE_FCR_CBSYENDF_Pos             (1U)
#define ICACHE_FCR_CBSYENDF_Msk             (0x1UL << ICACHE_FCR_CBSYENDF_Pos)      /*!< 0x00000002 */
#define ICACHE_FCR_CBSYENDF                 ICACHE_FCR_CBSYENDF_Msk                 /*!< Busy end flag clear */
#define ICACHE_FCR_CERRF_Pos                (2U)
#define ICACHE_FCR_CERRF_Msk                (0x1UL << ICACHE_FCR_CERRF_Pos)         /*!< 0x00000004 */
#define ICACHE_FCR_CERRF                    ICACHE_FCR_CERRF_Msk                    /*!< Cache error flag clear */

/******************  Bit definition for ICACHE_HMONR register  ****************/
#define ICACHE_HMONR_HITMON_Pos             (0U)
#define ICACHE_HMONR_HITMON_Msk             (0xFFFFFFFFUL << ICACHE_HMONR_HITMON_Pos) /*!< 0xFFFFFFFF */
#define ICACHE_HMONR_HITMON                 ICACHE_HMONR_HITMON_Msk                 /*!< Cache hit monitor register */

/******************  Bit definition for ICACHE_MMONR register  ****************/
#define ICACHE_MMONR_MISSMON_Pos            (0U)
#define ICACHE_MMONR_MISSMON_Msk            (0xFFFFUL << ICACHE_MMONR_MISSMON_Pos)  /*!< 0x0000FFFF */
#define ICACHE_MMONR_MISSMON                ICACHE_MMONR_MISSMON_Msk                /*!< Cache miss monitor register */

/******************  Bit definition for ICACHE_CRRx register  *****************/
#define ICACHE_CRRx_BASEADDR_Pos            (0U)
#define ICACHE_CRRx_BASEADDR_Msk            (0xFFUL << ICACHE_CRRx_BASEADDR_Pos)    /*!< 0x000000FF */
#define ICACHE_CRRx_BASEADDR                ICACHE_CRRx_BASEADDR_Msk                /*!< Base address of region X to remap */
#define ICACHE_CRRx_RSIZE_Pos               (9U)
#define ICACHE_CRRx_RSIZE_Msk               (0x7UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000E00 */
#define ICACHE_CRRx_RSIZE                   ICACHE_CRRx_RSIZE_Msk                   /*!< Region X size */
#define ICACHE_CRRx_RSIZE_0                 (0x1UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000200 */
#define ICACHE_CRRx_RSIZE_1                 (0x2UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000400 */
#define ICACHE_CRRx_RSIZE_2                 (0x4UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000800 */
#define ICACHE_CRRx_REN_Pos                 (15U)
#define ICACHE_CRRx_REN_Msk                 (0x1UL << ICACHE_CRRx_REN_Pos)          /*!< 0x00008000 */
#define ICACHE_CRRx_REN                     ICACHE_CRRx_REN_Msk                     /*!< Region X enable */
#define ICACHE_CRRx_REMAPADDR_Pos           (16U)
#define ICACHE_CRRx_REMAPADDR_Msk           (0x7FFUL << ICACHE_CRRx_REMAPADDR_Pos)  /*!< 0x07FF0000 */
#define ICACHE_CRRx_REMAPADDR               ICACHE_CRRx_REMAPADDR_Msk               /*!< Remap address of Region X to be remapped */
#define ICACHE_CRRx_MSTSEL_Pos              (28U)
#define ICACHE_CRRx_MSTSEL_Msk              (0x1UL << ICACHE_CRRx_MSTSEL_Pos)       /*!< 0x10000000 */
#define ICACHE_CRRx_MSTSEL                  ICACHE_CRRx_MSTSEL_Msk                  /*!< Region X AHB cache master selection */
#define ICACHE_CRRx_HBURST_Pos              (31U)
#define ICACHE_CRRx_HBURST_Msk              (0x1UL << ICACHE_CRRx_HBURST_Pos)       /*!< 0x80000000 */
#define ICACHE_CRRx_HBURST                  ICACHE_CRRx_HBURST_Msk                  /*!< Region X output burst type */


/******************************************************************************/
/*                                                                            */
/*                                 DCACHE                                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for DCACHE_CR register  *******************/
#define DCACHE_CR_EN_Pos                    (0U)
#define DCACHE_CR_EN_Msk                    (0x1UL << DCACHE_CR_EN_Pos)             /*!< 0x00000001 */
#define DCACHE_CR_EN                        DCACHE_CR_EN_Msk                        /*!< Enable */
#define DCACHE_CR_CACHEINV_Pos              (1U)
#define DCACHE_CR_CACHEINV_Msk              (0x1UL << DCACHE_CR_CACHEINV_Pos)       /*!< 0x00000002 */
#define DCACHE_CR_CACHEINV                  DCACHE_CR_CACHEINV_Msk                  /*!< Cache invalidation */
#define DCACHE_CR_CACHECMD_Pos              (8U)
#define DCACHE_CR_CACHECMD_Msk              (0x7UL << DCACHE_CR_CACHECMD_Pos)       /*!< 0x00000700 */
#define DCACHE_CR_CACHECMD                  DCACHE_CR_CACHECMD_Msk                  /*!< Cache command */
#define DCACHE_CR_CACHECMD_0                (0x1UL << DCACHE_CR_CACHECMD_Pos)       /*!< 0x00000100 */
#define DCACHE_CR_CACHECMD_1                (0x2UL << DCACHE_CR_CACHECMD_Pos)       /*!< 0x00000200 */
#define DCACHE_CR_CACHECMD_2                (0x4UL << DCACHE_CR_CACHECMD_Pos)       /*!< 0x00000400 */
#define DCACHE_CR_STARTCMD_Pos              (11U)
#define DCACHE_CR_STARTCMD_Msk              (0x1UL << DCACHE_CR_STARTCMD_Pos)       /*!< 0x00000800 */
#define DCACHE_CR_STARTCMD                  DCACHE_CR_STARTCMD_Msk                  /*!< Start command */
#define DCACHE_CR_RHITMEN_Pos               (16U)
#define DCACHE_CR_RHITMEN_Msk               (0x1UL << DCACHE_CR_RHITMEN_Pos)        /*!< 0x00010000 */
#define DCACHE_CR_RHITMEN                   DCACHE_CR_RHITMEN_Msk                   /*!< Read Hit monitor enable */
#define DCACHE_CR_RMISSMEN_Pos              (17U)
#define DCACHE_CR_RMISSMEN_Msk              (0x1UL << DCACHE_CR_RMISSMEN_Pos)       /*!< 0x00020000 */
#define DCACHE_CR_RMISSMEN                  DCACHE_CR_RMISSMEN_Msk                  /*!< Read Miss monitor enable */
#define DCACHE_CR_RHITMRST_Pos              (18U)
#define DCACHE_CR_RHITMRST_Msk              (0x1UL << DCACHE_CR_RHITMRST_Pos)       /*!< 0x00040000 */
#define DCACHE_CR_RHITMRST                  DCACHE_CR_RHITMRST_Msk                  /*!< Read Hit monitor reset */
#define DCACHE_CR_RMISSMRST_Pos             (19U)
#define DCACHE_CR_RMISSMRST_Msk             (0x1UL << DCACHE_CR_RMISSMRST_Pos)      /*!< 0x00080000 */
#define DCACHE_CR_RMISSMRST                 DCACHE_CR_RMISSMRST_Msk                 /*!< Read Miss monitor reset */
#define DCACHE_CR_WHITMEN_Pos               (20U)
#define DCACHE_CR_WHITMEN_Msk               (0x1UL << DCACHE_CR_WHITMEN_Pos)        /*!< 0x00100000 */
#define DCACHE_CR_WHITMEN                   DCACHE_CR_WHITMEN_Msk                   /*!< Write Hit monitor enable */
#define DCACHE_CR_WMISSMEN_Pos              (21U)
#define DCACHE_CR_WMISSMEN_Msk              (0x1UL << DCACHE_CR_WMISSMEN_Pos)       /*!< 0x00200000 */
#define DCACHE_CR_WMISSMEN                  DCACHE_CR_WMISSMEN_Msk                  /*!< Write Miss monitor enable */
#define DCACHE_CR_WHITMRST_Pos              (22U)
#define DCACHE_CR_WHITMRST_Msk              (0x1UL << DCACHE_CR_WHITMRST_Pos)       /*!< 0x00400000 */
#define DCACHE_CR_WHITMRST                  DCACHE_CR_WHITMRST_Msk                  /*!< Write Hit monitor reset */
#define DCACHE_CR_WMISSMRST_Pos             (23U)
#define DCACHE_CR_WMISSMRST_Msk             (0x1UL << DCACHE_CR_WMISSMRST_Pos)      /*!< 0x00800000 */
#define DCACHE_CR_WMISSMRST                 DCACHE_CR_WMISSMRST_Msk                 /*!< Write Miss monitor reset */
#define DCACHE_CR_HBURST_Pos                (31U)
#define DCACHE_CR_HBURST_Msk                (0x1UL << DCACHE_CR_HBURST_Pos)         /*!< 0x80000000 */
#define DCACHE_CR_HBURST                    DCACHE_CR_HBURST_Msk                    /*!< Read burst type */

/******************  Bit definition for DCACHE_SR register  *******************/
#define DCACHE_SR_BUSYF_Pos                 (0U)
#define DCACHE_SR_BUSYF_Msk                 (0x1UL << DCACHE_SR_BUSYF_Pos)          /*!< 0x00000001 */
#define DCACHE_SR_BUSYF                     DCACHE_SR_BUSYF_Msk                     /*!< Busy flag */
#define DCACHE_SR_BSYENDF_Pos               (1U)
#define DCACHE_SR_BSYENDF_Msk               (0x1UL << DCACHE_SR_BSYENDF_Pos)        /*!< 0x00000002 */
#define DCACHE_SR_BSYENDF                   DCACHE_SR_BSYENDF_Msk                   /*!< Busy end flag */
#define DCACHE_SR_ERRF_Pos                  (2U)
#define DCACHE_SR_ERRF_Msk                  (0x1UL << DCACHE_SR_ERRF_Pos)           /*!< 0x00000004 */
#define DCACHE_SR_ERRF                      DCACHE_SR_ERRF_Msk                      /*!< Cache error flag */
#define DCACHE_SR_BUSYCMDF_Pos              (3U)
#define DCACHE_SR_BUSYCMDF_Msk              (0x1UL << DCACHE_SR_BUSYCMDF_Pos)       /*!< 0x00000008 */
#define DCACHE_SR_BUSYCMDF                  DCACHE_SR_BUSYCMDF_Msk                  /*!< Busy command flag */
#define DCACHE_SR_CMDENDF_Pos               (4U)
#define DCACHE_SR_CMDENDF_Msk               (0x1UL << DCACHE_SR_CMDENDF_Pos)        /*!< 0x00000010 */
#define DCACHE_SR_CMDENDF                   DCACHE_SR_CMDENDF_Msk                   /*!< Command end flag */

/******************  Bit definition for DCACHE_IER register  ******************/
#define DCACHE_IER_BSYENDIE_Pos             (1U)
#define DCACHE_IER_BSYENDIE_Msk             (0x1UL << DCACHE_IER_BSYENDIE_Pos)      /*!< 0x00000002 */
#define DCACHE_IER_BSYENDIE                 DCACHE_IER_BSYENDIE_Msk                 /*!< Busy end interrupt enable */
#define DCACHE_IER_ERRIE_Pos                (2U)
#define DCACHE_IER_ERRIE_Msk                (0x1UL << DCACHE_IER_ERRIE_Pos)         /*!< 0x00000004 */
#define DCACHE_IER_ERRIE                    DCACHE_IER_ERRIE_Msk                    /*!< Cache error interrupt enable */
#define DCACHE_IER_CMDENDIE_Pos             (4U)
#define DCACHE_IER_CMDENDIE_Msk             (0x1UL << DCACHE_IER_CMDENDIE_Pos)      /*!< 0x00000010 */
#define DCACHE_IER_CMDENDIE                 DCACHE_IER_CMDENDIE_Msk                 /*!< Command end interrupt enable */

/******************  Bit definition for DCACHE_FCR register  ******************/
#define DCACHE_FCR_CBSYENDF_Pos             (1U)
#define DCACHE_FCR_CBSYENDF_Msk             (0x1UL << DCACHE_FCR_CBSYENDF_Pos)       /*!< 0x00000002 */
#define DCACHE_FCR_CBSYENDF                 DCACHE_FCR_CBSYENDF_Msk                  /*!< Busy end flag clear */
#define DCACHE_FCR_CERRF_Pos                (2U)
#define DCACHE_FCR_CERRF_Msk                (0x1UL << DCACHE_FCR_CERRF_Pos)          /*!< 0x00000004 */
#define DCACHE_FCR_CERRF                    DCACHE_FCR_CERRF_Msk                     /*!< Cache error flag clear */
#define DCACHE_FCR_CCMDENDF_Pos             (4U)
#define DCACHE_FCR_CCMDENDF_Msk             (0x1UL << DCACHE_FCR_CCMDENDF_Pos)       /*!< 0x00000010 */
#define DCACHE_FCR_CCMDENDF                 DCACHE_FCR_CCMDENDF_Msk                  /*!< Command end flag clear */

/******************  Bit definition for DCACHE_RHMONR register  ****************/
#define DCACHE_RHMONR_RHITMON_Pos           (0U)
#define DCACHE_RHMONR_RHITMON_Msk           (0xFFFFFFFFUL << DCACHE_RHMONR_RHITMON_Pos) /*!< 0xFFFFFFFF */
#define DCACHE_RHMONR_RHITMON               DCACHE_RHMONR_RHITMON_Msk               /*!< Cache Read hit monitor register */

/******************  Bit definition for DCACHE_RMMONR register  ****************/
#define DCACHE_RMMONR_RMISSMON_Pos          (0U)
#define DCACHE_RMMONR_RMISSMON_Msk          (0xFFFFUL << DCACHE_RMMONR_RMISSMON_Pos) /*!< 0x0000FFFF */
#define DCACHE_RMMONR_RMISSMON              DCACHE_RMMONR_RMISSMON_Msk              /*!< Cache Read miss monitor register */

/******************  Bit definition for DCACHE_WHMONR register  ****************/
#define DCACHE_WHMONR_WHITMON_Pos           (0U)
#define DCACHE_WHMONR_WHITMON_Msk           (0xFFFFFFFFUL << DCACHE_WHMONR_WHITMON_Pos) /*!< 0xFFFFFFFF */
#define DCACHE_WHMONR_WHITMON               DCACHE_WHMONR_WHITMON_Msk               /*!< Cache Read hit monitor register */

/******************  Bit definition for DCACHE_WMMONR register  ****************/
#define DCACHE_WMMONR_WMISSMON_Pos          (0U)
#define DCACHE_WMMONR_WMISSMON_Msk          (0xFFFFUL << DCACHE_WMMONR_WMISSMON_Pos) /*!< 0x0000FFFF */
#define DCACHE_WMMONR_WMISSMON              DCACHE_WMMONR_WMISSMON_Msk              /*!< Cache Read miss monitor register */

/******************  Bit definition for DCACHE_CMDRSADDRR register  ****************/
#define DCACHE_CMDRSADDRR_CMDSTARTADDR_Pos  (0U)
#define DCACHE_CMDRSADDRR_CMDSTARTADDR_Msk  (0xFFFFFFF0UL << DCACHE_CMDRSADDRR_CMDSTARTADDR_Pos) /*!< 0xFFFFFFF0 */
#define DCACHE_CMDRSADDRR_CMDSTARTADDR      DCACHE_CMDRSADDRR_CMDSTARTADDR_Msk      /*!< Command start address */

/******************  Bit definition for DCACHE_CMDREADDRR register  ****************/
#define DCACHE_CMDREADDRR_CMDENDADDR_Pos    (0U)
#define DCACHE_CMDREADDRR_CMDENDADDR_Msk    (0xFFFFFFF0UL << DCACHE_CMDREADDRR_CMDENDADDR_Pos) /*!< 0xFFFFFFF0 */
#define DCACHE_CMDREADDRR_CMDENDADDR        DCACHE_CMDREADDRR_CMDENDADDR_Msk        /*!< Command end address */

/******************************************************************************/
/*                                                                            */
/*                    Digital Temperature Sensor (DTS)                        */
/*                                                                            */
/******************************************************************************/

/******************  Bit definition for DTS_CFGR1 register  ******************/
#define DTS_CFGR1_TS1_EN_Pos               (0U)
#define DTS_CFGR1_TS1_EN_Msk               (0x1UL << DTS_CFGR1_TS1_EN_Pos) /*!< 0x00000001 */
#define DTS_CFGR1_TS1_EN                   DTS_CFGR1_TS1_EN_Msk        /*!< DTS Enable */
#define DTS_CFGR1_TS1_START_Pos            (4U)
#define DTS_CFGR1_TS1_START_Msk            (0x1UL << DTS_CFGR1_TS1_START_Pos) /*!< 0x00000010 */
#define DTS_CFGR1_TS1_START                DTS_CFGR1_TS1_START_Msk     /*!< Proceed to a frequency measurement on DTS */
#define DTS_CFGR1_TS1_INTRIG_SEL_Pos       (8U)
#define DTS_CFGR1_TS1_INTRIG_SEL_Msk       (0xFUL << DTS_CFGR1_TS1_INTRIG_SEL_Pos) /*!< 0x00000F00 */
#define DTS_CFGR1_TS1_INTRIG_SEL           DTS_CFGR1_TS1_INTRIG_SEL_Msk /*!< Input triggers selection bits [3:0] for DTS */
#define DTS_CFGR1_TS1_INTRIG_SEL_0         (0x1UL << DTS_CFGR1_TS1_INTRIG_SEL_Pos) /*!< 0x00000100 */
#define DTS_CFGR1_TS1_INTRIG_SEL_1         (0x2UL << DTS_CFGR1_TS1_INTRIG_SEL_Pos) /*!< 0x00000200 */
#define DTS_CFGR1_TS1_INTRIG_SEL_2         (0x4UL << DTS_CFGR1_TS1_INTRIG_SEL_Pos) /*!< 0x00000400 */
#define DTS_CFGR1_TS1_INTRIG_SEL_3         (0x8UL << DTS_CFGR1_TS1_INTRIG_SEL_Pos) /*!< 0x00000800 */
#define DTS_CFGR1_TS1_SMP_TIME_Pos         (16U)
#define DTS_CFGR1_TS1_SMP_TIME_Msk         (0xFUL << DTS_CFGR1_TS1_SMP_TIME_Pos) /*!< 0x000F0000 */
#define DTS_CFGR1_TS1_SMP_TIME             DTS_CFGR1_TS1_SMP_TIME_Msk  /*!< Sample time [3:0] for DTS */
#define DTS_CFGR1_TS1_SMP_TIME_0           (0x1UL << DTS_CFGR1_TS1_SMP_TIME_Pos) /*!< 0x00010000 */
#define DTS_CFGR1_TS1_SMP_TIME_1           (0x2UL << DTS_CFGR1_TS1_SMP_TIME_Pos) /*!< 0x00020000 */
#define DTS_CFGR1_TS1_SMP_TIME_2           (0x4UL << DTS_CFGR1_TS1_SMP_TIME_Pos) /*!< 0x00040000 */
#define DTS_CFGR1_TS1_SMP_TIME_3           (0x8UL << DTS_CFGR1_TS1_SMP_TIME_Pos) /*!< 0x00080000 */
#define DTS_CFGR1_REFCLK_SEL_Pos           (20U)
#define DTS_CFGR1_REFCLK_SEL_Msk           (0x1UL << DTS_CFGR1_REFCLK_SEL_Pos) /*!< 0x00100000 */
#define DTS_CFGR1_REFCLK_SEL               DTS_CFGR1_REFCLK_SEL_Msk    /*!< Reference Clock Selection */
#define DTS_CFGR1_Q_MEAS_OPT_Pos           (21U)
#define DTS_CFGR1_Q_MEAS_OPT_Msk           (0x1UL << DTS_CFGR1_Q_MEAS_OPT_Pos) /*!< 0x00200000 */
#define DTS_CFGR1_Q_MEAS_OPT               DTS_CFGR1_Q_MEAS_OPT_Msk    /*!< Quick measure option bit  */
#define DTS_CFGR1_HSREF_CLK_DIV_Pos        (24U)
#define DTS_CFGR1_HSREF_CLK_DIV_Msk        (0x7FUL << DTS_CFGR1_HSREF_CLK_DIV_Pos) /*!< 0x7F000000 */
#define DTS_CFGR1_HSREF_CLK_DIV            DTS_CFGR1_HSREF_CLK_DIV_Msk /*!< High Speed Clock Divider Ratio [6:0]*/

/******************  Bit definition for DTS_T0VALR1 register  ******************/
#define DTS_T0VALR1_TS1_FMT0_Pos           (0U)
#define DTS_T0VALR1_TS1_FMT0_Msk           (0xFFFFUL << DTS_T0VALR1_TS1_FMT0_Pos) /*!< 0x0000FFFF */
#define DTS_T0VALR1_TS1_FMT0               DTS_T0VALR1_TS1_FMT0_Msk    /*!< Engineering value of the measured frequency at T0 for DTS */
#define DTS_T0VALR1_TS1_T0_Pos             (16U)
#define DTS_T0VALR1_TS1_T0_Msk             (0x3UL << DTS_T0VALR1_TS1_T0_Pos) /*!< 0x00030000 */
#define DTS_T0VALR1_TS1_T0                 DTS_T0VALR1_TS1_T0_Msk      /*!< Engineering value of the DTSerature T0 for DTS */

/******************  Bit definition for DTS_RAMPVALR register  ******************/
#define DTS_RAMPVALR_TS1_RAMP_COEFF_Pos    (0U)
#define DTS_RAMPVALR_TS1_RAMP_COEFF_Msk    (0xFFFFUL << DTS_RAMPVALR_TS1_RAMP_COEFF_Pos) /*!< 0x0000FFFF */
#define DTS_RAMPVALR_TS1_RAMP_COEFF        DTS_RAMPVALR_TS1_RAMP_COEFF_Msk /*!< Engineering value of the ramp coefficient for DTS */

/******************  Bit definition for DTS_ITR1 register      ******************/
#define DTS_ITR1_TS1_LITTHD_Pos            (0U)
#define DTS_ITR1_TS1_LITTHD_Msk            (0xFFFFUL << DTS_ITR1_TS1_LITTHD_Pos) /*!< 0x0000FFFF */
#define DTS_ITR1_TS1_LITTHD                DTS_ITR1_TS1_LITTHD_Msk     /*!< Low interrupt threshold[15:0] for DTS */
#define DTS_ITR1_TS1_HITTHD_Pos            (16U)
#define DTS_ITR1_TS1_HITTHD_Msk            (0xFFFFUL << DTS_ITR1_TS1_HITTHD_Pos) /*!< 0xFFFF0000 */
#define DTS_ITR1_TS1_HITTHD                DTS_ITR1_TS1_HITTHD_Msk     /*!< High interrupt threshold[15:0] for DTS */

/******************  Bit definition for DTS_DR register        ******************/
#define DTS_DR_TS1_MFREQ_Pos               (0U)
#define DTS_DR_TS1_MFREQ_Msk               (0xFFFFUL << DTS_DR_TS1_MFREQ_Pos) /*!< 0x0000FFFF */
#define DTS_DR_TS1_MFREQ                   DTS_DR_TS1_MFREQ_Msk        /*!< Measured Frequency[15:0] for DTS */

/******************  Bit definition for DTS_SR register        ******************/
#define DTS_SR_TS1_ITEF_Pos                (0U)
#define DTS_SR_TS1_ITEF_Msk                (0x1UL << DTS_SR_TS1_ITEF_Pos) /*!< 0x00000001 */
#define DTS_SR_TS1_ITEF                    DTS_SR_TS1_ITEF_Msk         /*!< Interrupt flag for end of measure for DTS */
#define DTS_SR_TS1_ITLF_Pos                (1U)
#define DTS_SR_TS1_ITLF_Msk                (0x1UL << DTS_SR_TS1_ITLF_Pos) /*!< 0x00000002 */
#define DTS_SR_TS1_ITLF                    DTS_SR_TS1_ITLF_Msk         /*!< Interrupt flag for low threshold for DTS  */
#define DTS_SR_TS1_ITHF_Pos                (2U)
#define DTS_SR_TS1_ITHF_Msk                (0x1UL << DTS_SR_TS1_ITHF_Pos) /*!< 0x00000004 */
#define DTS_SR_TS1_ITHF                    DTS_SR_TS1_ITHF_Msk         /*!< Interrupt flag for high threshold for DTS */
#define DTS_SR_TS1_AITEF_Pos               (4U)
#define DTS_SR_TS1_AITEF_Msk               (0x1UL << DTS_SR_TS1_AITEF_Pos) /*!< 0x00000010 */
#define DTS_SR_TS1_AITEF                   DTS_SR_TS1_AITEF_Msk        /*!< Asynchronous interrupt flag for end of measure for DTS */
#define DTS_SR_TS1_AITLF_Pos               (5U)
#define DTS_SR_TS1_AITLF_Msk               (0x1UL << DTS_SR_TS1_AITLF_Pos) /*!< 0x00000020 */
#define DTS_SR_TS1_AITLF                   DTS_SR_TS1_AITLF_Msk        /*!< Asynchronous interrupt flag for low threshold for DTS  */
#define DTS_SR_TS1_AITHF_Pos               (6U)
#define DTS_SR_TS1_AITHF_Msk               (0x1UL << DTS_SR_TS1_AITHF_Pos) /*!< 0x00000040 */
#define DTS_SR_TS1_AITHF                   DTS_SR_TS1_AITHF_Msk        /*!< Asynchronous interrupt flag for high threshold for DTS */
#define DTS_SR_TS1_RDY_Pos                 (15U)
#define DTS_SR_TS1_RDY_Msk                 (0x1UL << DTS_SR_TS1_RDY_Pos) /*!< 0x00008000 */
#define DTS_SR_TS1_RDY                     DTS_SR_TS1_RDY_Msk          /*!< DTS ready flag */

/******************  Bit definition for DTS_ITENR register      ******************/
#define DTS_ITENR_TS1_ITEEN_Pos            (0U)
#define DTS_ITENR_TS1_ITEEN_Msk            (0x1UL << DTS_ITENR_TS1_ITEEN_Pos) /*!< 0x00000001 */
#define DTS_ITENR_TS1_ITEEN                DTS_ITENR_TS1_ITEEN_Msk     /*!< Enable interrupt flag for end of measure for DTS */
#define DTS_ITENR_TS1_ITLEN_Pos            (1U)
#define DTS_ITENR_TS1_ITLEN_Msk            (0x1UL << DTS_ITENR_TS1_ITLEN_Pos) /*!< 0x00000002 */
#define DTS_ITENR_TS1_ITLEN                DTS_ITENR_TS1_ITLEN_Msk     /*!< Enable interrupt flag for low threshold for DTS  */
#define DTS_ITENR_TS1_ITHEN_Pos            (2U)
#define DTS_ITENR_TS1_ITHEN_Msk            (0x1UL << DTS_ITENR_TS1_ITHEN_Pos) /*!< 0x00000004 */
#define DTS_ITENR_TS1_ITHEN                DTS_ITENR_TS1_ITHEN_Msk     /*!< Enable interrupt flag for high threshold for DTS */
#define DTS_ITENR_TS1_AITEEN_Pos           (4U)
#define DTS_ITENR_TS1_AITEEN_Msk           (0x1UL << DTS_ITENR_TS1_AITEEN_Pos) /*!< 0x00000010 */
#define DTS_ITENR_TS1_AITEEN               DTS_ITENR_TS1_AITEEN_Msk    /*!< Enable asynchronous interrupt flag for end of measure for DTS */
#define DTS_ITENR_TS1_AITLEN_Pos           (5U)
#define DTS_ITENR_TS1_AITLEN_Msk           (0x1UL << DTS_ITENR_TS1_AITLEN_Pos) /*!< 0x00000020 */
#define DTS_ITENR_TS1_AITLEN               DTS_ITENR_TS1_AITLEN_Msk    /*!< Enable Asynchronous interrupt flag for low threshold for DTS  */
#define DTS_ITENR_TS1_AITHEN_Pos           (6U)
#define DTS_ITENR_TS1_AITHEN_Msk           (0x1UL << DTS_ITENR_TS1_AITHEN_Pos) /*!< 0x00000040 */
#define DTS_ITENR_TS1_AITHEN               DTS_ITENR_TS1_AITHEN_Msk    /*!< Enable asynchronous interrupt flag for high threshold for DTS */

/******************  Bit definition for DTS_ICIFR register      ******************/
#define DTS_ICIFR_TS1_CITEF_Pos            (0U)
#define DTS_ICIFR_TS1_CITEF_Msk            (0x1UL << DTS_ICIFR_TS1_CITEF_Pos) /*!< 0x00000001 */
#define DTS_ICIFR_TS1_CITEF                DTS_ICIFR_TS1_CITEF_Msk     /*!< Clear the IT flag for End Of Measure for DTS */
#define DTS_ICIFR_TS1_CITLF_Pos            (1U)
#define DTS_ICIFR_TS1_CITLF_Msk            (0x1UL << DTS_ICIFR_TS1_CITLF_Pos) /*!< 0x00000002 */
#define DTS_ICIFR_TS1_CITLF                DTS_ICIFR_TS1_CITLF_Msk     /*!< Clear the IT flag for low threshold for DTS  */
#define DTS_ICIFR_TS1_CITHF_Pos            (2U)
#define DTS_ICIFR_TS1_CITHF_Msk            (0x1UL << DTS_ICIFR_TS1_CITHF_Pos) /*!< 0x00000004 */
#define DTS_ICIFR_TS1_CITHF                DTS_ICIFR_TS1_CITHF_Msk     /*!< Clear the IT flag for high threshold on DTS  */
#define DTS_ICIFR_TS1_CAITEF_Pos           (4U)
#define DTS_ICIFR_TS1_CAITEF_Msk           (0x1UL << DTS_ICIFR_TS1_CAITEF_Pos) /*!< 0x00000010 */
#define DTS_ICIFR_TS1_CAITEF               DTS_ICIFR_TS1_CAITEF_Msk    /*!< Clear the asynchronous IT flag for End Of Measure for DTS */
#define DTS_ICIFR_TS1_CAITLF_Pos           (5U)
#define DTS_ICIFR_TS1_CAITLF_Msk           (0x1UL << DTS_ICIFR_TS1_CAITLF_Pos) /*!< 0x00000020 */
#define DTS_ICIFR_TS1_CAITLF               DTS_ICIFR_TS1_CAITLF_Msk    /*!< Clear the asynchronous IT flag for low threshold for DTS  */
#define DTS_ICIFR_TS1_CAITHF_Pos           (6U)
#define DTS_ICIFR_TS1_CAITHF_Msk           (0x1UL << DTS_ICIFR_TS1_CAITHF_Pos) /*!< 0x00000040 */
#define DTS_ICIFR_TS1_CAITHF               DTS_ICIFR_TS1_CAITHF_Msk    /*!< Clear the asynchronous IT flag for high threshold on DTS  */

/******************************************************************************/
/*                                                                            */
/*                                    TIM                                     */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for TIM_CR1 register  ********************/
#define TIM_CR1_CEN_Pos                     (0U)
#define TIM_CR1_CEN_Msk                     (0x1UL << TIM_CR1_CEN_Pos)              /*!< 0x00000001 */
#define TIM_CR1_CEN                         TIM_CR1_CEN_Msk                         /*!<Counter enable */
#define TIM_CR1_UDIS_Pos                    (1U)
#define TIM_CR1_UDIS_Msk                    (0x1UL << TIM_CR1_UDIS_Pos)             /*!< 0x00000002 */
#define TIM_CR1_UDIS                        TIM_CR1_UDIS_Msk                        /*!<Update disable */
#define TIM_CR1_URS_Pos                     (2U)
#define TIM_CR1_URS_Msk                     (0x1UL << TIM_CR1_URS_Pos)              /*!< 0x00000004 */
#define TIM_CR1_URS                         TIM_CR1_URS_Msk                         /*!<Update request source */
#define TIM_CR1_OPM_Pos                     (3U)
#define TIM_CR1_OPM_Msk                     (0x1UL << TIM_CR1_OPM_Pos)              /*!< 0x00000008 */
#define TIM_CR1_OPM                         TIM_CR1_OPM_Msk                         /*!<One pulse mode */
#define TIM_CR1_DIR_Pos                     (4U)
#define TIM_CR1_DIR_Msk                     (0x1UL << TIM_CR1_DIR_Pos)              /*!< 0x00000010 */
#define TIM_CR1_DIR                         TIM_CR1_DIR_Msk                         /*!<Direction */
#define TIM_CR1_CMS_Pos                     (5U)
#define TIM_CR1_CMS_Msk                     (0x3UL << TIM_CR1_CMS_Pos)              /*!< 0x00000060 */
#define TIM_CR1_CMS                         TIM_CR1_CMS_Msk                         /*!<CMS[1:0] bits (Center-aligned mode selection) */
#define TIM_CR1_CMS_0                       (0x1UL << TIM_CR1_CMS_Pos)              /*!< 0x00000020 */
#define TIM_CR1_CMS_1                       (0x2UL << TIM_CR1_CMS_Pos)              /*!< 0x00000040 */
#define TIM_CR1_ARPE_Pos                    (7U)
#define TIM_CR1_ARPE_Msk                    (0x1UL << TIM_CR1_ARPE_Pos)             /*!< 0x00000080 */
#define TIM_CR1_ARPE                        TIM_CR1_ARPE_Msk                        /*!<Auto-reload preload enable */
#define TIM_CR1_CKD_Pos                     (8U)
#define TIM_CR1_CKD_Msk                     (0x3UL << TIM_CR1_CKD_Pos)              /*!< 0x00000300 */
#define TIM_CR1_CKD                         TIM_CR1_CKD_Msk                         /*!<CKD[1:0] bits (clock division) */
#define TIM_CR1_CKD_0                       (0x1UL << TIM_CR1_CKD_Pos)              /*!< 0x00000100 */
#define TIM_CR1_CKD_1                       (0x2UL << TIM_CR1_CKD_Pos)              /*!< 0x00000200 */
#define TIM_CR1_UIFREMAP_Pos                (11U)
#define TIM_CR1_UIFREMAP_Msk                (0x1UL << TIM_CR1_UIFREMAP_Pos)         /*!< 0x00000800 */
#define TIM_CR1_UIFREMAP                    TIM_CR1_UIFREMAP_Msk                    /*!<Update interrupt flag remap */
#define TIM_CR1_DITHEN_Pos                  (12U)
#define TIM_CR1_DITHEN_Msk                  (0x1UL << TIM_CR1_DITHEN_Pos)           /*!< 0x00001000 */
#define TIM_CR1_DITHEN                      TIM_CR1_DITHEN_Msk                      /*!<Dithering enable */

/*******************  Bit definition for TIM_CR2 register  ********************/
#define TIM_CR2_CCPC_Pos                    (0U)
#define TIM_CR2_CCPC_Msk                    (0x1UL << TIM_CR2_CCPC_Pos)             /*!< 0x00000001 */
#define TIM_CR2_CCPC                        TIM_CR2_CCPC_Msk                        /*!<Capture/Compare Preloaded Control */
#define TIM_CR2_CCUS_Pos                    (2U)
#define TIM_CR2_CCUS_Msk                    (0x1UL << TIM_CR2_CCUS_Pos)             /*!< 0x00000004 */
#define TIM_CR2_CCUS                        TIM_CR2_CCUS_Msk                        /*!<Capture/Compare Control Update Selection */
#define TIM_CR2_CCDS_Pos                    (3U)
#define TIM_CR2_CCDS_Msk                    (0x1UL << TIM_CR2_CCDS_Pos)             /*!< 0x00000008 */
#define TIM_CR2_CCDS                        TIM_CR2_CCDS_Msk                        /*!<Capture/Compare DMA Selection */
#define TIM_CR2_MMS_Pos                     (4U)
#define TIM_CR2_MMS_Msk                     (0x200007UL << TIM_CR2_MMS_Pos)         /*!< 0x02000070 */
#define TIM_CR2_MMS                         TIM_CR2_MMS_Msk                         /*!<MMS[3:0] bits (Master Mode Selection) */
#define TIM_CR2_MMS_0                       (0x000001UL << TIM_CR2_MMS_Pos)         /*!< 0x00000010 */
#define TIM_CR2_MMS_1                       (0x000002UL << TIM_CR2_MMS_Pos)         /*!< 0x00000020 */
#define TIM_CR2_MMS_2                       (0x000004UL << TIM_CR2_MMS_Pos)         /*!< 0x00000040 */
#define TIM_CR2_MMS_3                       (0x200000UL << TIM_CR2_MMS_Pos)         /*!< 0x02000000 */
#define TIM_CR2_TI1S_Pos                    (7U)
#define TIM_CR2_TI1S_Msk                    (0x1UL << TIM_CR2_TI1S_Pos)             /*!< 0x00000080 */
#define TIM_CR2_TI1S                        TIM_CR2_TI1S_Msk                        /*!<TI1 Selection */
#define TIM_CR2_OIS1_Pos                    (8U)
#define TIM_CR2_OIS1_Msk                    (0x1UL << TIM_CR2_OIS1_Pos)             /*!< 0x00000100 */
#define TIM_CR2_OIS1                        TIM_CR2_OIS1_Msk                        /*!<Output Idle state 1 (OC1 output) */
#define TIM_CR2_OIS1N_Pos                   (9U)
#define TIM_CR2_OIS1N_Msk                   (0x1UL << TIM_CR2_OIS1N_Pos)            /*!< 0x00000200 */
#define TIM_CR2_OIS1N                       TIM_CR2_OIS1N_Msk                       /*!<Output Idle state 1 (OC1N output) */
#define TIM_CR2_OIS2_Pos                    (10U)
#define TIM_CR2_OIS2_Msk                    (0x1UL << TIM_CR2_OIS2_Pos)             /*!< 0x00000400 */
#define TIM_CR2_OIS2                        TIM_CR2_OIS2_Msk                        /*!<Output Idle state 2 (OC2 output) */
#define TIM_CR2_OIS2N_Pos                   (11U)
#define TIM_CR2_OIS2N_Msk                   (0x1UL << TIM_CR2_OIS2N_Pos)            /*!< 0x00000800 */
#define TIM_CR2_OIS2N                       TIM_CR2_OIS2N_Msk                       /*!<Output Idle state 2 (OC2N output) */
#define TIM_CR2_OIS3_Pos                    (12U)
#define TIM_CR2_OIS3_Msk                    (0x1UL << TIM_CR2_OIS3_Pos)             /*!< 0x00001000 */
#define TIM_CR2_OIS3                        TIM_CR2_OIS3_Msk                        /*!<Output Idle state 3 (OC3 output) */
#define TIM_CR2_OIS3N_Pos                   (13U)
#define TIM_CR2_OIS3N_Msk                   (0x1UL << TIM_CR2_OIS3N_Pos)            /*!< 0x00002000 */
#define TIM_CR2_OIS3N                       TIM_CR2_OIS3N_Msk                       /*!<Output Idle state 3 (OC3N output) */
#define TIM_CR2_OIS4_Pos                    (14U)
#define TIM_CR2_OIS4_Msk                    (0x1UL << TIM_CR2_OIS4_Pos)             /*!< 0x00004000 */
#define TIM_CR2_OIS4                        TIM_CR2_OIS4_Msk                        /*!<Output Idle state 4 (OC4 output) */
#define TIM_CR2_OIS4N_Pos                   (15U)
#define TIM_CR2_OIS4N_Msk                   (0x1UL << TIM_CR2_OIS4N_Pos)            /*!< 0x00008000 */
#define TIM_CR2_OIS4N                       TIM_CR2_OIS4N_Msk                       /*!<Output Idle state 4 (OC4N output) */
#define TIM_CR2_OIS5_Pos                    (16U)
#define TIM_CR2_OIS5_Msk                    (0x1UL << TIM_CR2_OIS5_Pos)             /*!< 0x00010000 */
#define TIM_CR2_OIS5                        TIM_CR2_OIS5_Msk                        /*!<Output Idle state 5 (OC5 output) */
#define TIM_CR2_OIS6_Pos                    (18U)
#define TIM_CR2_OIS6_Msk                    (0x1UL << TIM_CR2_OIS6_Pos)             /*!< 0x00040000 */
#define TIM_CR2_OIS6                        TIM_CR2_OIS6_Msk                        /*!<Output Idle state 6 (OC6 output) */
#define TIM_CR2_MMS2_Pos                    (20U)
#define TIM_CR2_MMS2_Msk                    (0xFUL << TIM_CR2_MMS2_Pos)             /*!< 0x00F00000 */
#define TIM_CR2_MMS2                        TIM_CR2_MMS2_Msk                        /*!<MMS[2:0] bits (Master Mode Selection) */
#define TIM_CR2_MMS2_0                      (0x1UL << TIM_CR2_MMS2_Pos)             /*!< 0x00100000 */
#define TIM_CR2_MMS2_1                      (0x2UL << TIM_CR2_MMS2_Pos)             /*!< 0x00200000 */
#define TIM_CR2_MMS2_2                      (0x4UL << TIM_CR2_MMS2_Pos)             /*!< 0x00400000 */
#define TIM_CR2_MMS2_3                      (0x8UL << TIM_CR2_MMS2_Pos)             /*!< 0x00800000 */

/*******************  Bit definition for TIM_SMCR register  *******************/
#define TIM_SMCR_SMS_Pos                    (0U)
#define TIM_SMCR_SMS_Msk                    (0x10007UL << TIM_SMCR_SMS_Pos)         /*!< 0x00010007 */
#define TIM_SMCR_SMS                        TIM_SMCR_SMS_Msk                        /*!<SMS[2:0] bits (Slave mode selection) */
#define TIM_SMCR_SMS_0                      (0x00001UL << TIM_SMCR_SMS_Pos)         /*!< 0x00000001 */
#define TIM_SMCR_SMS_1                      (0x00002UL << TIM_SMCR_SMS_Pos)         /*!< 0x00000002 */
#define TIM_SMCR_SMS_2                      (0x00004UL << TIM_SMCR_SMS_Pos)         /*!< 0x00000004 */
#define TIM_SMCR_SMS_3                      (0x10000UL << TIM_SMCR_SMS_Pos)         /*!< 0x00010000 */
#define TIM_SMCR_OCCS_Pos                   (3U)
#define TIM_SMCR_OCCS_Msk                   (0x1UL << TIM_SMCR_OCCS_Pos)            /*!< 0x00000008 */
#define TIM_SMCR_OCCS                       TIM_SMCR_OCCS_Msk                       /*!< OCREF clear selection */
#define TIM_SMCR_TS_Pos                     (4U)
#define TIM_SMCR_TS_Msk                     (0x30007UL << TIM_SMCR_TS_Pos)          /*!< 0x00300070 */
#define TIM_SMCR_TS                         TIM_SMCR_TS_Msk                         /*!<TS[2:0] bits (Trigger selection) */
#define TIM_SMCR_TS_0                       (0x00001UL << TIM_SMCR_TS_Pos)          /*!< 0x00000010 */
#define TIM_SMCR_TS_1                       (0x00002UL << TIM_SMCR_TS_Pos)          /*!< 0x00000020 */
#define TIM_SMCR_TS_2                       (0x00004UL << TIM_SMCR_TS_Pos)          /*!< 0x00000040 */
#define TIM_SMCR_TS_3                       (0x10000UL << TIM_SMCR_TS_Pos)          /*!< 0x00100000 */
#define TIM_SMCR_TS_4                       (0x20000UL << TIM_SMCR_TS_Pos)          /*!< 0x00200000 */
#define TIM_SMCR_MSM_Pos                    (7U)
#define TIM_SMCR_MSM_Msk                    (0x1UL << TIM_SMCR_MSM_Pos)             /*!< 0x00000080 */
#define TIM_SMCR_MSM                        TIM_SMCR_MSM_Msk                        /*!<Master/slave mode */
#define TIM_SMCR_ETF_Pos                    (8U)
#define TIM_SMCR_ETF_Msk                    (0xFUL << TIM_SMCR_ETF_Pos)             /*!< 0x00000F00 */
#define TIM_SMCR_ETF                        TIM_SMCR_ETF_Msk                        /*!<ETF[3:0] bits (External trigger filter) */
#define TIM_SMCR_ETF_0                      (0x1UL << TIM_SMCR_ETF_Pos)             /*!< 0x00000100 */
#define TIM_SMCR_ETF_1                      (0x2UL << TIM_SMCR_ETF_Pos)             /*!< 0x00000200 */
#define TIM_SMCR_ETF_2                      (0x4UL << TIM_SMCR_ETF_Pos)             /*!< 0x00000400 */
#define TIM_SMCR_ETF_3                      (0x8UL << TIM_SMCR_ETF_Pos)             /*!< 0x00000800 */
#define TIM_SMCR_ETPS_Pos                   (12U)
#define TIM_SMCR_ETPS_Msk                   (0x3UL << TIM_SMCR_ETPS_Pos)            /*!< 0x00003000 */
#define TIM_SMCR_ETPS                       TIM_SMCR_ETPS_Msk                       /*!<ETPS[1:0] bits (External trigger prescaler) */
#define TIM_SMCR_ETPS_0                     (0x1UL << TIM_SMCR_ETPS_Pos)            /*!< 0x00001000 */
#define TIM_SMCR_ETPS_1                     (0x2UL << TIM_SMCR_ETPS_Pos)            /*!< 0x00002000 */
#define TIM_SMCR_ECE_Pos                    (14U)
#define TIM_SMCR_ECE_Msk                    (0x1UL << TIM_SMCR_ECE_Pos)             /*!< 0x00004000 */
#define TIM_SMCR_ECE                        TIM_SMCR_ECE_Msk                        /*!<External clock enable */
#define TIM_SMCR_ETP_Pos                    (15U)
#define TIM_SMCR_ETP_Msk                    (0x1UL << TIM_SMCR_ETP_Pos)             /*!< 0x00008000 */
#define TIM_SMCR_ETP                        TIM_SMCR_ETP_Msk                        /*!<External trigger polarity */
#define TIM_SMCR_SMSPE_Pos                  (24U)
#define TIM_SMCR_SMSPE_Msk                  (0x1UL << TIM_SMCR_SMSPE_Pos)           /*!< 0x02000000 */
#define TIM_SMCR_SMSPE                      TIM_SMCR_SMSPE_Msk                      /*!<SMS preload enable */
#define TIM_SMCR_SMSPS_Pos                  (25U)
#define TIM_SMCR_SMSPS_Msk                  (0x1UL << TIM_SMCR_SMSPS_Pos)           /*!< 0x04000000 */
#define TIM_SMCR_SMSPS                      TIM_SMCR_SMSPS_Msk                      /*!<SMS preload source */

/*******************  Bit definition for TIM_DIER register  *******************/
#define TIM_DIER_UIE_Pos                    (0U)
#define TIM_DIER_UIE_Msk                    (0x1UL << TIM_DIER_UIE_Pos)             /*!< 0x00000001 */
#define TIM_DIER_UIE                        TIM_DIER_UIE_Msk                        /*!<Update interrupt enable */
#define TIM_DIER_CC1IE_Pos                  (1U)
#define TIM_DIER_CC1IE_Msk                  (0x1UL << TIM_DIER_CC1IE_Pos)           /*!< 0x00000002 */
#define TIM_DIER_CC1IE                      TIM_DIER_CC1IE_Msk                      /*!<Capture/Compare 1 interrupt enable */
#define TIM_DIER_CC2IE_Pos                  (2U)
#define TIM_DIER_CC2IE_Msk                  (0x1UL << TIM_DIER_CC2IE_Pos)           /*!< 0x00000004 */
#define TIM_DIER_CC2IE                      TIM_DIER_CC2IE_Msk                      /*!<Capture/Compare 2 interrupt enable */
#define TIM_DIER_CC3IE_Pos                  (3U)
#define TIM_DIER_CC3IE_Msk                  (0x1UL << TIM_DIER_CC3IE_Pos)           /*!< 0x00000008 */
#define TIM_DIER_CC3IE                      TIM_DIER_CC3IE_Msk                      /*!<Capture/Compare 3 interrupt enable */
#define TIM_DIER_CC4IE_Pos                  (4U)
#define TIM_DIER_CC4IE_Msk                  (0x1UL << TIM_DIER_CC4IE_Pos)           /*!< 0x00000010 */
#define TIM_DIER_CC4IE                      TIM_DIER_CC4IE_Msk                      /*!<Capture/Compare 4 interrupt enable */
#define TIM_DIER_COMIE_Pos                  (5U)
#define TIM_DIER_COMIE_Msk                  (0x1UL << TIM_DIER_COMIE_Pos)           /*!< 0x00000020 */
#define TIM_DIER_COMIE                      TIM_DIER_COMIE_Msk                      /*!<COM interrupt enable */
#define TIM_DIER_TIE_Pos                    (6U)
#define TIM_DIER_TIE_Msk                    (0x1UL << TIM_DIER_TIE_Pos)             /*!< 0x00000040 */
#define TIM_DIER_TIE                        TIM_DIER_TIE_Msk                        /*!<Trigger interrupt enable */
#define TIM_DIER_BIE_Pos                    (7U)
#define TIM_DIER_BIE_Msk                    (0x1UL << TIM_DIER_BIE_Pos)             /*!< 0x00000080 */
#define TIM_DIER_BIE                        TIM_DIER_BIE_Msk                        /*!<Break interrupt enable */
#define TIM_DIER_UDE_Pos                    (8U)
#define TIM_DIER_UDE_Msk                    (0x1UL << TIM_DIER_UDE_Pos)             /*!< 0x00000100 */
#define TIM_DIER_UDE                        TIM_DIER_UDE_Msk                        /*!<Update DMA request enable */
#define TIM_DIER_CC1DE_Pos                  (9U)
#define TIM_DIER_CC1DE_Msk                  (0x1UL << TIM_DIER_CC1DE_Pos)           /*!< 0x00000200 */
#define TIM_DIER_CC1DE                      TIM_DIER_CC1DE_Msk                      /*!<Capture/Compare 1 DMA request enable */
#define TIM_DIER_CC2DE_Pos                  (10U)
#define TIM_DIER_CC2DE_Msk                  (0x1UL << TIM_DIER_CC2DE_Pos)           /*!< 0x00000400 */
#define TIM_DIER_CC2DE                      TIM_DIER_CC2DE_Msk                      /*!<Capture/Compare 2 DMA request enable */
#define TIM_DIER_CC3DE_Pos                  (11U)
#define TIM_DIER_CC3DE_Msk                  (0x1UL << TIM_DIER_CC3DE_Pos)           /*!< 0x00000800 */
#define TIM_DIER_CC3DE                      TIM_DIER_CC3DE_Msk                      /*!<Capture/Compare 3 DMA request enable */
#define TIM_DIER_CC4DE_Pos                  (12U)
#define TIM_DIER_CC4DE_Msk                  (0x1UL << TIM_DIER_CC4DE_Pos)           /*!< 0x00001000 */
#define TIM_DIER_CC4DE                      TIM_DIER_CC4DE_Msk                      /*!<Capture/Compare 4 DMA request enable */
#define TIM_DIER_COMDE_Pos                  (13U)
#define TIM_DIER_COMDE_Msk                  (0x1UL << TIM_DIER_COMDE_Pos)           /*!< 0x00002000 */
#define TIM_DIER_COMDE                      TIM_DIER_COMDE_Msk                      /*!<COM DMA request enable */
#define TIM_DIER_TDE_Pos                    (14U)
#define TIM_DIER_TDE_Msk                    (0x1UL << TIM_DIER_TDE_Pos)             /*!< 0x00004000 */
#define TIM_DIER_TDE                        TIM_DIER_TDE_Msk                        /*!<Trigger DMA request enable */
#define TIM_DIER_IDXIE_Pos                  (20U)
#define TIM_DIER_IDXIE_Msk                  (0x1UL << TIM_DIER_IDXIE_Pos)           /*!< 0x00100000 */
#define TIM_DIER_IDXIE                      TIM_DIER_IDXIE_Msk                      /*!<Encoder index interrupt enable */
#define TIM_DIER_DIRIE_Pos                  (21U)
#define TIM_DIER_DIRIE_Msk                  (0x1UL << TIM_DIER_DIRIE_Pos)           /*!< 0x00200000 */
#define TIM_DIER_DIRIE                      TIM_DIER_DIRIE_Msk                      /*!<Encoder direction change interrupt enable */
#define TIM_DIER_IERRIE_Pos                 (22U)
#define TIM_DIER_IERRIE_Msk                 (0x1UL << TIM_DIER_IERRIE_Pos)          /*!< 0x00400000 */
#define TIM_DIER_IERRIE                     TIM_DIER_IERRIE_Msk                     /*!<Encoder index error enable */
#define TIM_DIER_TERRIE_Pos                 (23U)
#define TIM_DIER_TERRIE_Msk                 (0x1UL << TIM_DIER_TERRIE_Pos)          /*!< 0x00800000 */
#define TIM_DIER_TERRIE                     TIM_DIER_TERRIE_Msk                     /*!<Encoder transition error enable */

/********************  Bit definition for TIM_SR register  ********************/
#define TIM_SR_UIF_Pos                      (0U)
#define TIM_SR_UIF_Msk                      (0x1UL << TIM_SR_UIF_Pos)               /*!< 0x00000001 */
#define TIM_SR_UIF                          TIM_SR_UIF_Msk                          /*!<Update interrupt Flag */
#define TIM_SR_CC1IF_Pos                    (1U)
#define TIM_SR_CC1IF_Msk                    (0x1UL << TIM_SR_CC1IF_Pos)             /*!< 0x00000002 */
#define TIM_SR_CC1IF                        TIM_SR_CC1IF_Msk                        /*!<Capture/Compare 1 interrupt Flag */
#define TIM_SR_CC2IF_Pos                    (2U)
#define TIM_SR_CC2IF_Msk                    (0x1UL << TIM_SR_CC2IF_Pos)             /*!< 0x00000004 */
#define TIM_SR_CC2IF                        TIM_SR_CC2IF_Msk                        /*!<Capture/Compare 2 interrupt Flag */
#define TIM_SR_CC3IF_Pos                    (3U)
#define TIM_SR_CC3IF_Msk                    (0x1UL << TIM_SR_CC3IF_Pos)             /*!< 0x00000008 */
#define TIM_SR_CC3IF                        TIM_SR_CC3IF_Msk                        /*!<Capture/Compare 3 interrupt Flag */
#define TIM_SR_CC4IF_Pos                    (4U)
#define TIM_SR_CC4IF_Msk                    (0x1UL << TIM_SR_CC4IF_Pos)             /*!< 0x00000010 */
#define TIM_SR_CC4IF                        TIM_SR_CC4IF_Msk                        /*!<Capture/Compare 4 interrupt Flag */
#define TIM_SR_COMIF_Pos                    (5U)
#define TIM_SR_COMIF_Msk                    (0x1UL << TIM_SR_COMIF_Pos)             /*!< 0x00000020 */
#define TIM_SR_COMIF                        TIM_SR_COMIF_Msk                        /*!<COM interrupt Flag */
#define TIM_SR_TIF_Pos                      (6U)
#define TIM_SR_TIF_Msk                      (0x1UL << TIM_SR_TIF_Pos)               /*!< 0x00000040 */
#define TIM_SR_TIF                          TIM_SR_TIF_Msk                          /*!<Trigger interrupt Flag */
#define TIM_SR_BIF_Pos                      (7U)
#define TIM_SR_BIF_Msk                      (0x1UL << TIM_SR_BIF_Pos)               /*!< 0x00000080 */
#define TIM_SR_BIF                          TIM_SR_BIF_Msk                          /*!<Break interrupt Flag */
#define TIM_SR_B2IF_Pos                     (8U)
#define TIM_SR_B2IF_Msk                     (0x1UL << TIM_SR_B2IF_Pos)              /*!< 0x00000100 */
#define TIM_SR_B2IF                         TIM_SR_B2IF_Msk                         /*!<Break 2 interrupt Flag */
#define TIM_SR_CC1OF_Pos                    (9U)
#define TIM_SR_CC1OF_Msk                    (0x1UL << TIM_SR_CC1OF_Pos)             /*!< 0x00000200 */
#define TIM_SR_CC1OF                        TIM_SR_CC1OF_Msk                        /*!<Capture/Compare 1 Overcapture Flag */
#define TIM_SR_CC2OF_Pos                    (10U)
#define TIM_SR_CC2OF_Msk                    (0x1UL << TIM_SR_CC2OF_Pos)             /*!< 0x00000400 */
#define TIM_SR_CC2OF                        TIM_SR_CC2OF_Msk                        /*!<Capture/Compare 2 Overcapture Flag */
#define TIM_SR_CC3OF_Pos                    (11U)
#define TIM_SR_CC3OF_Msk                    (0x1UL << TIM_SR_CC3OF_Pos)             /*!< 0x00000800 */
#define TIM_SR_CC3OF                        TIM_SR_CC3OF_Msk                        /*!<Capture/Compare 3 Overcapture Flag */
#define TIM_SR_CC4OF_Pos                    (12U)
#define TIM_SR_CC4OF_Msk                    (0x1UL << TIM_SR_CC4OF_Pos)             /*!< 0x00001000 */
#define TIM_SR_CC4OF                        TIM_SR_CC4OF_Msk                        /*!<Capture/Compare 4 Overcapture Flag */
#define TIM_SR_SBIF_Pos                     (13U)
#define TIM_SR_SBIF_Msk                     (0x1UL << TIM_SR_SBIF_Pos)              /*!< 0x00002000 */
#define TIM_SR_SBIF                         TIM_SR_SBIF_Msk                         /*!<System Break interrupt Flag */
#define TIM_SR_CC5IF_Pos                    (16U)
#define TIM_SR_CC5IF_Msk                    (0x1UL << TIM_SR_CC5IF_Pos)             /*!< 0x00010000 */
#define TIM_SR_CC5IF                        TIM_SR_CC5IF_Msk                        /*!<Capture/Compare 5 interrupt Flag */
#define TIM_SR_CC6IF_Pos                    (17U)
#define TIM_SR_CC6IF_Msk                    (0x1UL << TIM_SR_CC6IF_Pos)             /*!< 0x00020000 */
#define TIM_SR_CC6IF                        TIM_SR_CC6IF_Msk                        /*!<Capture/Compare 6 interrupt Flag */
#define TIM_SR_IDXF_Pos                     (20U)
#define TIM_SR_IDXF_Msk                     (0x1UL << TIM_SR_IDXF_Pos)              /*!< 0x00100000 */
#define TIM_SR_IDXF                         TIM_SR_IDXF_Msk                         /*!<Encoder index interrupt flag */
#define TIM_SR_DIRF_Pos                     (21U)
#define TIM_SR_DIRF_Msk                     (0x1UL << TIM_SR_DIRF_Pos)              /*!< 0x00200000 */
#define TIM_SR_DIRF                         TIM_SR_DIRF_Msk                         /*!<Encoder direction change interrupt flag */
#define TIM_SR_IERRF_Pos                    (22U)
#define TIM_SR_IERRF_Msk                    (0x1UL << TIM_SR_IERRF_Pos)             /*!< 0x00400000 */
#define TIM_SR_IERRF                        TIM_SR_IERRF_Msk                        /*!<Encoder index error flag */
#define TIM_SR_TERRF_Pos                    (23U)
#define TIM_SR_TERRF_Msk                    (0x1UL << TIM_SR_TERRF_Pos)             /*!< 0x00800000 */
#define TIM_SR_TERRF                        TIM_SR_TERRF_Msk                        /*!<Encoder transition error flag */

/*******************  Bit definition for TIM_EGR register  ********************/
#define TIM_EGR_UG_Pos                      (0U)
#define TIM_EGR_UG_Msk                      (0x1UL << TIM_EGR_UG_Pos)               /*!< 0x00000001 */
#define TIM_EGR_UG                          TIM_EGR_UG_Msk                          /*!<Update Generation */
#define TIM_EGR_CC1G_Pos                    (1U)
#define TIM_EGR_CC1G_Msk                    (0x1UL << TIM_EGR_CC1G_Pos)             /*!< 0x00000002 */
#define TIM_EGR_CC1G                        TIM_EGR_CC1G_Msk                        /*!<Capture/Compare 1 Generation */
#define TIM_EGR_CC2G_Pos                    (2U)
#define TIM_EGR_CC2G_Msk                    (0x1UL << TIM_EGR_CC2G_Pos)             /*!< 0x00000004 */
#define TIM_EGR_CC2G                        TIM_EGR_CC2G_Msk                        /*!<Capture/Compare 2 Generation */
#define TIM_EGR_CC3G_Pos                    (3U)
#define TIM_EGR_CC3G_Msk                    (0x1UL << TIM_EGR_CC3G_Pos)             /*!< 0x00000008 */
#define TIM_EGR_CC3G                        TIM_EGR_CC3G_Msk                        /*!<Capture/Compare 3 Generation */
#define TIM_EGR_CC4G_Pos                    (4U)
#define TIM_EGR_CC4G_Msk                    (0x1UL << TIM_EGR_CC4G_Pos)             /*!< 0x00000010 */
#define TIM_EGR_CC4G                        TIM_EGR_CC4G_Msk                        /*!<Capture/Compare 4 Generation */
#define TIM_EGR_COMG_Pos                    (5U)
#define TIM_EGR_COMG_Msk                    (0x1UL << TIM_EGR_COMG_Pos)             /*!< 0x00000020 */
#define TIM_EGR_COMG                        TIM_EGR_COMG_Msk                        /*!<Capture/Compare Control Update Generation */
#define TIM_EGR_TG_Pos                      (6U)
#define TIM_EGR_TG_Msk                      (0x1UL << TIM_EGR_TG_Pos)               /*!< 0x00000040 */
#define TIM_EGR_TG                          TIM_EGR_TG_Msk                          /*!<Trigger Generation */
#define TIM_EGR_BG_Pos                      (7U)
#define TIM_EGR_BG_Msk                      (0x1UL << TIM_EGR_BG_Pos)               /*!< 0x00000080 */
#define TIM_EGR_BG                          TIM_EGR_BG_Msk                          /*!<Break Generation */
#define TIM_EGR_B2G_Pos                     (8U)
#define TIM_EGR_B2G_Msk                     (0x1UL << TIM_EGR_B2G_Pos)              /*!< 0x00000100 */
#define TIM_EGR_B2G                         TIM_EGR_B2G_Msk                         /*!<Break 2 Generation */


/******************  Bit definition for TIM_CCMR1 register  *******************/
#define TIM_CCMR1_CC1S_Pos                  (0U)
#define TIM_CCMR1_CC1S_Msk                  (0x3UL << TIM_CCMR1_CC1S_Pos)           /*!< 0x00000003 */
#define TIM_CCMR1_CC1S                      TIM_CCMR1_CC1S_Msk                      /*!<CC1S[1:0] bits (Capture/Compare 1 Selection) */
#define TIM_CCMR1_CC1S_0                    (0x1UL << TIM_CCMR1_CC1S_Pos)           /*!< 0x00000001 */
#define TIM_CCMR1_CC1S_1                    (0x2UL << TIM_CCMR1_CC1S_Pos)           /*!< 0x00000002 */
#define TIM_CCMR1_OC1FE_Pos                 (2U)
#define TIM_CCMR1_OC1FE_Msk                 (0x1UL << TIM_CCMR1_OC1FE_Pos)          /*!< 0x00000004 */
#define TIM_CCMR1_OC1FE                     TIM_CCMR1_OC1FE_Msk                     /*!<Output Compare 1 Fast enable */
#define TIM_CCMR1_OC1PE_Pos                 (3U)
#define TIM_CCMR1_OC1PE_Msk                 (0x1UL << TIM_CCMR1_OC1PE_Pos)          /*!< 0x00000008 */
#define TIM_CCMR1_OC1PE                     TIM_CCMR1_OC1PE_Msk                     /*!<Output Compare 1 Preload enable */
#define TIM_CCMR1_OC1M_Pos                  (4U)
#define TIM_CCMR1_OC1M_Msk                  (0x1007UL << TIM_CCMR1_OC1M_Pos)        /*!< 0x00010070 */
#define TIM_CCMR1_OC1M                      TIM_CCMR1_OC1M_Msk                      /*!<OC1M[2:0] bits (Output Compare 1 Mode) */
#define TIM_CCMR1_OC1M_0                    (0x0001UL << TIM_CCMR1_OC1M_Pos)        /*!< 0x00000010 */
#define TIM_CCMR1_OC1M_1                    (0x0002UL << TIM_CCMR1_OC1M_Pos)        /*!< 0x00000020 */
#define TIM_CCMR1_OC1M_2                    (0x0004UL << TIM_CCMR1_OC1M_Pos)        /*!< 0x00000040 */
#define TIM_CCMR1_OC1M_3                    (0x1000UL << TIM_CCMR1_OC1M_Pos)        /*!< 0x00010000 */
#define TIM_CCMR1_OC1CE_Pos                 (7U)
#define TIM_CCMR1_OC1CE_Msk                 (0x1UL << TIM_CCMR1_OC1CE_Pos)          /*!< 0x00000080 */
#define TIM_CCMR1_OC1CE                     TIM_CCMR1_OC1CE_Msk                     /*!<Output Compare 1 Clear Enable */
#define TIM_CCMR1_CC2S_Pos                  (8U)
#define TIM_CCMR1_CC2S_Msk                  (0x3UL << TIM_CCMR1_CC2S_Pos)           /*!< 0x00000300 */
#define TIM_CCMR1_CC2S                      TIM_CCMR1_CC2S_Msk                      /*!<CC2S[1:0] bits (Capture/Compare 2 Selection) */
#define TIM_CCMR1_CC2S_0                    (0x1UL << TIM_CCMR1_CC2S_Pos)           /*!< 0x00000100 */
#define TIM_CCMR1_CC2S_1                    (0x2UL << TIM_CCMR1_CC2S_Pos)           /*!< 0x00000200 */
#define TIM_CCMR1_OC2FE_Pos                 (10U)
#define TIM_CCMR1_OC2FE_Msk                 (0x1UL << TIM_CCMR1_OC2FE_Pos)          /*!< 0x00000400 */
#define TIM_CCMR1_OC2FE                     TIM_CCMR1_OC2FE_Msk                     /*!<Output Compare 2 Fast enable */
#define TIM_CCMR1_OC2PE_Pos                 (11U)
#define TIM_CCMR1_OC2PE_Msk                 (0x1UL << TIM_CCMR1_OC2PE_Pos)          /*!< 0x00000800 */
#define TIM_CCMR1_OC2PE                     TIM_CCMR1_OC2PE_Msk                     /*!<Output Compare 2 Preload enable */
#define TIM_CCMR1_OC2M_Pos                  (12U)
#define TIM_CCMR1_OC2M_Msk                  (0x1007UL << TIM_CCMR1_OC2M_Pos)        /*!< 0x01007000 */
#define TIM_CCMR1_OC2M                      TIM_CCMR1_OC2M_Msk                      /*!<OC2M[2:0] bits (Output Compare 2 Mode) */
#define TIM_CCMR1_OC2M_0                    (0x0001UL << TIM_CCMR1_OC2M_Pos)        /*!< 0x00001000 */
#define TIM_CCMR1_OC2M_1                    (0x0002UL << TIM_CCMR1_OC2M_Pos)        /*!< 0x00002000 */
#define TIM_CCMR1_OC2M_2                    (0x0004UL << TIM_CCMR1_OC2M_Pos)        /*!< 0x00004000 */
#define TIM_CCMR1_OC2M_3                    (0x1000UL << TIM_CCMR1_OC2M_Pos)        /*!< 0x01000000 */
#define TIM_CCMR1_OC2CE_Pos                 (15U)
#define TIM_CCMR1_OC2CE_Msk                 (0x1UL << TIM_CCMR1_OC2CE_Pos)          /*!< 0x00008000 */
#define TIM_CCMR1_OC2CE                     TIM_CCMR1_OC2CE_Msk                     /*!<Output Compare 2 Clear Enable */

/*----------------------------------------------------------------------------*/
#define TIM_CCMR1_IC1PSC_Pos                (2U)
#define TIM_CCMR1_IC1PSC_Msk                (0x3UL << TIM_CCMR1_IC1PSC_Pos)         /*!< 0x0000000C */
#define TIM_CCMR1_IC1PSC                    TIM_CCMR1_IC1PSC_Msk                    /*!<IC1PSC[1:0] bits (Input Capture 1 Prescaler) */
#define TIM_CCMR1_IC1PSC_0                  (0x1UL << TIM_CCMR1_IC1PSC_Pos)         /*!< 0x00000004 */
#define TIM_CCMR1_IC1PSC_1                  (0x2UL << TIM_CCMR1_IC1PSC_Pos)         /*!< 0x00000008 */
#define TIM_CCMR1_IC1F_Pos                  (4U)
#define TIM_CCMR1_IC1F_Msk                  (0xFUL << TIM_CCMR1_IC1F_Pos)           /*!< 0x000000F0 */
#define TIM_CCMR1_IC1F                      TIM_CCMR1_IC1F_Msk                      /*!<IC1F[3:0] bits (Input Capture 1 Filter) */
#define TIM_CCMR1_IC1F_0                    (0x1UL << TIM_CCMR1_IC1F_Pos)           /*!< 0x00000010 */
#define TIM_CCMR1_IC1F_1                    (0x2UL << TIM_CCMR1_IC1F_Pos)           /*!< 0x00000020 */
#define TIM_CCMR1_IC1F_2                    (0x4UL << TIM_CCMR1_IC1F_Pos)           /*!< 0x00000040 */
#define TIM_CCMR1_IC1F_3                    (0x8UL << TIM_CCMR1_IC1F_Pos)           /*!< 0x00000080 */
#define TIM_CCMR1_IC2PSC_Pos                (10U)
#define TIM_CCMR1_IC2PSC_Msk                (0x3UL << TIM_CCMR1_IC2PSC_Pos)         /*!< 0x00000C00 */
#define TIM_CCMR1_IC2PSC                    TIM_CCMR1_IC2PSC_Msk                    /*!<IC2PSC[1:0] bits (Input Capture 2 Prescaler) */
#define TIM_CCMR1_IC2PSC_0                  (0x1UL << TIM_CCMR1_IC2PSC_Pos)         /*!< 0x00000400 */
#define TIM_CCMR1_IC2PSC_1                  (0x2UL << TIM_CCMR1_IC2PSC_Pos)         /*!< 0x00000800 */
#define TIM_CCMR1_IC2F_Pos                  (12U)
#define TIM_CCMR1_IC2F_Msk                  (0xFUL << TIM_CCMR1_IC2F_Pos)           /*!< 0x0000F000 */
#define TIM_CCMR1_IC2F                      TIM_CCMR1_IC2F_Msk                      /*!<IC2F[3:0] bits (Input Capture 2 Filter) */
#define TIM_CCMR1_IC2F_0                    (0x1UL << TIM_CCMR1_IC2F_Pos)           /*!< 0x00001000 */
#define TIM_CCMR1_IC2F_1                    (0x2UL << TIM_CCMR1_IC2F_Pos)           /*!< 0x00002000 */
#define TIM_CCMR1_IC2F_2                    (0x4UL << TIM_CCMR1_IC2F_Pos)           /*!< 0x00004000 */
#define TIM_CCMR1_IC2F_3                    (0x8UL << TIM_CCMR1_IC2F_Pos)           /*!< 0x00008000 */

/******************  Bit definition for TIM_CCMR2 register  *******************/
#define TIM_CCMR2_CC3S_Pos                  (0U)
#define TIM_CCMR2_CC3S_Msk                  (0x3UL << TIM_CCMR2_CC3S_Pos)           /*!< 0x00000003 */
#define TIM_CCMR2_CC3S                      TIM_CCMR2_CC3S_Msk                      /*!<CC3S[1:0] bits (Capture/Compare 3 Selection) */
#define TIM_CCMR2_CC3S_0                    (0x1UL << TIM_CCMR2_CC3S_Pos)           /*!< 0x00000001 */
#define TIM_CCMR2_CC3S_1                    (0x2UL << TIM_CCMR2_CC3S_Pos)           /*!< 0x00000002 */
#define TIM_CCMR2_OC3FE_Pos                 (2U)
#define TIM_CCMR2_OC3FE_Msk                 (0x1UL << TIM_CCMR2_OC3FE_Pos)          /*!< 0x00000004 */
#define TIM_CCMR2_OC3FE                     TIM_CCMR2_OC3FE_Msk                     /*!<Output Compare 3 Fast enable */
#define TIM_CCMR2_OC3PE_Pos                 (3U)
#define TIM_CCMR2_OC3PE_Msk                 (0x1UL << TIM_CCMR2_OC3PE_Pos)          /*!< 0x00000008 */
#define TIM_CCMR2_OC3PE                     TIM_CCMR2_OC3PE_Msk                     /*!<Output Compare 3 Preload enable */
#define TIM_CCMR2_OC3M_Pos                  (4U)
#define TIM_CCMR2_OC3M_Msk                  (0x1007UL << TIM_CCMR2_OC3M_Pos)        /*!< 0x00010070 */
#define TIM_CCMR2_OC3M                      TIM_CCMR2_OC3M_Msk                      /*!<OC3M[2:0] bits (Output Compare 3 Mode) */
#define TIM_CCMR2_OC3M_0                    (0x0001UL << TIM_CCMR2_OC3M_Pos)        /*!< 0x00000010 */
#define TIM_CCMR2_OC3M_1                    (0x0002UL << TIM_CCMR2_OC3M_Pos)        /*!< 0x00000020 */
#define TIM_CCMR2_OC3M_2                    (0x0004UL << TIM_CCMR2_OC3M_Pos)        /*!< 0x00000040 */
#define TIM_CCMR2_OC3M_3                    (0x1000UL << TIM_CCMR2_OC3M_Pos)        /*!< 0x00010000 */
#define TIM_CCMR2_OC3CE_Pos                 (7U)
#define TIM_CCMR2_OC3CE_Msk                 (0x1UL << TIM_CCMR2_OC3CE_Pos)          /*!< 0x00000080 */
#define TIM_CCMR2_OC3CE                     TIM_CCMR2_OC3CE_Msk                     /*!<Output Compare 3 Clear Enable */
#define TIM_CCMR2_CC4S_Pos                  (8U)
#define TIM_CCMR2_CC4S_Msk                  (0x3UL << TIM_CCMR2_CC4S_Pos)           /*!< 0x00000300 */
#define TIM_CCMR2_CC4S                      TIM_CCMR2_CC4S_Msk                      /*!<CC4S[1:0] bits (Capture/Compare 4 Selection) */
#define TIM_CCMR2_CC4S_0                    (0x1UL << TIM_CCMR2_CC4S_Pos)           /*!< 0x00000100 */
#define TIM_CCMR2_CC4S_1                    (0x2UL << TIM_CCMR2_CC4S_Pos)           /*!< 0x00000200 */
#define TIM_CCMR2_OC4FE_Pos                 (10U)
#define TIM_CCMR2_OC4FE_Msk                 (0x1UL << TIM_CCMR2_OC4FE_Pos)          /*!< 0x00000400 */
#define TIM_CCMR2_OC4FE                     TIM_CCMR2_OC4FE_Msk                     /*!<Output Compare 4 Fast enable */
#define TIM_CCMR2_OC4PE_Pos                 (11U)
#define TIM_CCMR2_OC4PE_Msk                 (0x1UL << TIM_CCMR2_OC4PE_Pos)          /*!< 0x00000800 */
#define TIM_CCMR2_OC4PE                     TIM_CCMR2_OC4PE_Msk                     /*!<Output Compare 4 Preload enable */
#define TIM_CCMR2_OC4M_Pos                  (12U)
#define TIM_CCMR2_OC4M_Msk                  (0x1007UL << TIM_CCMR2_OC4M_Pos)        /*!< 0x01007000 */
#define TIM_CCMR2_OC4M                      TIM_CCMR2_OC4M_Msk                      /*!<OC4M[2:0] bits (Output Compare 4 Mode) */
#define TIM_CCMR2_OC4M_0                    (0x0001UL << TIM_CCMR2_OC4M_Pos)        /*!< 0x00001000 */
#define TIM_CCMR2_OC4M_1                    (0x0002UL << TIM_CCMR2_OC4M_Pos)        /*!< 0x00002000 */
#define TIM_CCMR2_OC4M_2                    (0x0004UL << TIM_CCMR2_OC4M_Pos)        /*!< 0x00004000 */
#define TIM_CCMR2_OC4M_3                    (0x1000UL << TIM_CCMR2_OC4M_Pos)        /*!< 0x01000000 */
#define TIM_CCMR2_OC4CE_Pos                 (15U)
#define TIM_CCMR2_OC4CE_Msk                 (0x1UL << TIM_CCMR2_OC4CE_Pos)          /*!< 0x00008000 */
#define TIM_CCMR2_OC4CE                     TIM_CCMR2_OC4CE_Msk                     /*!<Output Compare 4 Clear Enable */

/*----------------------------------------------------------------------------*/
#define TIM_CCMR2_IC3PSC_Pos                (2U)
#define TIM_CCMR2_IC3PSC_Msk                (0x3UL << TIM_CCMR2_IC3PSC_Pos)         /*!< 0x0000000C */
#define TIM_CCMR2_IC3PSC                    TIM_CCMR2_IC3PSC_Msk                    /*!<IC3PSC[1:0] bits (Input Capture 3 Prescaler) */
#define TIM_CCMR2_IC3PSC_0                  (0x1UL << TIM_CCMR2_IC3PSC_Pos)         /*!< 0x00000004 */
#define TIM_CCMR2_IC3PSC_1                  (0x2UL << TIM_CCMR2_IC3PSC_Pos)         /*!< 0x00000008 */
#define TIM_CCMR2_IC3F_Pos                  (4U)
#define TIM_CCMR2_IC3F_Msk                  (0xFUL << TIM_CCMR2_IC3F_Pos)           /*!< 0x000000F0 */
#define TIM_CCMR2_IC3F                      TIM_CCMR2_IC3F_Msk                      /*!<IC3F[3:0] bits (Input Capture 3 Filter) */
#define TIM_CCMR2_IC3F_0                    (0x1UL << TIM_CCMR2_IC3F_Pos)           /*!< 0x00000010 */
#define TIM_CCMR2_IC3F_1                    (0x2UL << TIM_CCMR2_IC3F_Pos)           /*!< 0x00000020 */
#define TIM_CCMR2_IC3F_2                    (0x4UL << TIM_CCMR2_IC3F_Pos)           /*!< 0x00000040 */
#define TIM_CCMR2_IC3F_3                    (0x8UL << TIM_CCMR2_IC3F_Pos)           /*!< 0x00000080 */
#define TIM_CCMR2_IC4PSC_Pos                (10U)
#define TIM_CCMR2_IC4PSC_Msk                (0x3UL << TIM_CCMR2_IC4PSC_Pos)         /*!< 0x00000C00 */
#define TIM_CCMR2_IC4PSC                    TIM_CCMR2_IC4PSC_Msk                    /*!<IC4PSC[1:0] bits (Input Capture 4 Prescaler) */
#define TIM_CCMR2_IC4PSC_0                  (0x1UL << TIM_CCMR2_IC4PSC_Pos)         /*!< 0x00000400 */
#define TIM_CCMR2_IC4PSC_1                  (0x2UL << TIM_CCMR2_IC4PSC_Pos)         /*!< 0x00000800 */
#define TIM_CCMR2_IC4F_Pos                  (12U)
#define TIM_CCMR2_IC4F_Msk                  (0xFUL << TIM_CCMR2_IC4F_Pos)           /*!< 0x0000F000 */
#define TIM_CCMR2_IC4F                      TIM_CCMR2_IC4F_Msk                      /*!<IC4F[3:0] bits (Input Capture 4 Filter) */
#define TIM_CCMR2_IC4F_0                    (0x1UL << TIM_CCMR2_IC4F_Pos)           /*!< 0x00001000 */
#define TIM_CCMR2_IC4F_1                    (0x2UL << TIM_CCMR2_IC4F_Pos)           /*!< 0x00002000 */
#define TIM_CCMR2_IC4F_2                    (0x4UL << TIM_CCMR2_IC4F_Pos)           /*!< 0x00004000 */
#define TIM_CCMR2_IC4F_3                    (0x8UL << TIM_CCMR2_IC4F_Pos)           /*!< 0x00008000 */

/******************  Bit definition for TIM_CCMR3 register  *******************/
#define TIM_CCMR3_OC5FE_Pos                 (2U)
#define TIM_CCMR3_OC5FE_Msk                 (0x1UL << TIM_CCMR3_OC5FE_Pos)          /*!< 0x00000004 */
#define TIM_CCMR3_OC5FE                     TIM_CCMR3_OC5FE_Msk                     /*!<Output Compare 5 Fast enable */
#define TIM_CCMR3_OC5PE_Pos                 (3U)
#define TIM_CCMR3_OC5PE_Msk                 (0x1UL << TIM_CCMR3_OC5PE_Pos)          /*!< 0x00000008 */
#define TIM_CCMR3_OC5PE                     TIM_CCMR3_OC5PE_Msk                     /*!<Output Compare 5 Preload enable */
#define TIM_CCMR3_OC5M_Pos                  (4U)
#define TIM_CCMR3_OC5M_Msk                  (0x1007UL << TIM_CCMR3_OC5M_Pos)        /*!< 0x00010070 */
#define TIM_CCMR3_OC5M                      TIM_CCMR3_OC5M_Msk                      /*!<OC5M[3:0] bits (Output Compare 5 Mode) */
#define TIM_CCMR3_OC5M_0                    (0x0001UL << TIM_CCMR3_OC5M_Pos)        /*!< 0x00000010 */
#define TIM_CCMR3_OC5M_1                    (0x0002UL << TIM_CCMR3_OC5M_Pos)        /*!< 0x00000020 */
#define TIM_CCMR3_OC5M_2                    (0x0004UL << TIM_CCMR3_OC5M_Pos)        /*!< 0x00000040 */
#define TIM_CCMR3_OC5M_3                    (0x1000UL << TIM_CCMR3_OC5M_Pos)        /*!< 0x00010000 */
#define TIM_CCMR3_OC5CE_Pos                 (7U)
#define TIM_CCMR3_OC5CE_Msk                 (0x1UL << TIM_CCMR3_OC5CE_Pos)          /*!< 0x00000080 */
#define TIM_CCMR3_OC5CE                     TIM_CCMR3_OC5CE_Msk                     /*!<Output Compare 5 Clear Enable */
#define TIM_CCMR3_OC6FE_Pos                 (10U)
#define TIM_CCMR3_OC6FE_Msk                 (0x1UL << TIM_CCMR3_OC6FE_Pos)          /*!< 0x00000400 */
#define TIM_CCMR3_OC6FE                     TIM_CCMR3_OC6FE_Msk                     /*!<Output Compare 6 Fast enable */
#define TIM_CCMR3_OC6PE_Pos                 (11U)
#define TIM_CCMR3_OC6PE_Msk                 (0x1UL << TIM_CCMR3_OC6PE_Pos)          /*!< 0x00000800 */
#define TIM_CCMR3_OC6PE                     TIM_CCMR3_OC6PE_Msk                     /*!<Output Compare 6 Preload enable */
#define TIM_CCMR3_OC6M_Pos                  (12U)
#define TIM_CCMR3_OC6M_Msk                  (0x1007UL << TIM_CCMR3_OC6M_Pos)        /*!< 0x01007000 */
#define TIM_CCMR3_OC6M                      TIM_CCMR3_OC6M_Msk                      /*!<OC6M[3:0] bits (Output Compare 6 Mode) */
#define TIM_CCMR3_OC6M_0                    (0x0001UL << TIM_CCMR3_OC6M_Pos)        /*!< 0x00001000 */
#define TIM_CCMR3_OC6M_1                    (0x0002UL << TIM_CCMR3_OC6M_Pos)        /*!< 0x00002000 */
#define TIM_CCMR3_OC6M_2                    (0x0004UL << TIM_CCMR3_OC6M_Pos)        /*!< 0x00004000 */
#define TIM_CCMR3_OC6M_3                    (0x1000UL << TIM_CCMR3_OC6M_Pos)        /*!< 0x01000000 */
#define TIM_CCMR3_OC6CE_Pos                 (15U)
#define TIM_CCMR3_OC6CE_Msk                 (0x1UL << TIM_CCMR3_OC6CE_Pos)          /*!< 0x00008000 */
#define TIM_CCMR3_OC6CE                     TIM_CCMR3_OC6CE_Msk                     /*!<Output Compare 6 Clear Enable */

/*******************  Bit definition for TIM_CCER register  *******************/
#define TIM_CCER_CC1E_Pos                   (0U)
#define TIM_CCER_CC1E_Msk                   (0x1UL << TIM_CCER_CC1E_Pos)            /*!< 0x00000001 */
#define TIM_CCER_CC1E                       TIM_CCER_CC1E_Msk                       /*!<Capture/Compare 1 output enable */
#define TIM_CCER_CC1P_Pos                   (1U)
#define TIM_CCER_CC1P_Msk                   (0x1UL << TIM_CCER_CC1P_Pos)            /*!< 0x00000002 */
#define TIM_CCER_CC1P                       TIM_CCER_CC1P_Msk                       /*!<Capture/Compare 1 output Polarity */
#define TIM_CCER_CC1NE_Pos                  (2U)
#define TIM_CCER_CC1NE_Msk                  (0x1UL << TIM_CCER_CC1NE_Pos)           /*!< 0x00000004 */
#define TIM_CCER_CC1NE                      TIM_CCER_CC1NE_Msk                      /*!<Capture/Compare 1 Complementary output enable */
#define TIM_CCER_CC1NP_Pos                  (3U)
#define TIM_CCER_CC1NP_Msk                  (0x1UL << TIM_CCER_CC1NP_Pos)           /*!< 0x00000008 */
#define TIM_CCER_CC1NP                      TIM_CCER_CC1NP_Msk                      /*!<Capture/Compare 1 Complementary output Polarity */
#define TIM_CCER_CC2E_Pos                   (4U)
#define TIM_CCER_CC2E_Msk                   (0x1UL << TIM_CCER_CC2E_Pos)            /*!< 0x00000010 */
#define TIM_CCER_CC2E                       TIM_CCER_CC2E_Msk                       /*!<Capture/Compare 2 output enable */
#define TIM_CCER_CC2P_Pos                   (5U)
#define TIM_CCER_CC2P_Msk                   (0x1UL << TIM_CCER_CC2P_Pos)            /*!< 0x00000020 */
#define TIM_CCER_CC2P                       TIM_CCER_CC2P_Msk                       /*!<Capture/Compare 2 output Polarity */
#define TIM_CCER_CC2NE_Pos                  (6U)
#define TIM_CCER_CC2NE_Msk                  (0x1UL << TIM_CCER_CC2NE_Pos)           /*!< 0x00000040 */
#define TIM_CCER_CC2NE                      TIM_CCER_CC2NE_Msk                      /*!<Capture/Compare 2 Complementary output enable */
#define TIM_CCER_CC2NP_Pos                  (7U)
#define TIM_CCER_CC2NP_Msk                  (0x1UL << TIM_CCER_CC2NP_Pos)           /*!< 0x00000080 */
#define TIM_CCER_CC2NP                      TIM_CCER_CC2NP_Msk                      /*!<Capture/Compare 2 Complementary output Polarity */
#define TIM_CCER_CC3E_Pos                   (8U)
#define TIM_CCER_CC3E_Msk                   (0x1UL << TIM_CCER_CC3E_Pos)            /*!< 0x00000100 */
#define TIM_CCER_CC3E                       TIM_CCER_CC3E_Msk                       /*!<Capture/Compare 3 output enable */
#define TIM_CCER_CC3P_Pos                   (9U)
#define TIM_CCER_CC3P_Msk                   (0x1UL << TIM_CCER_CC3P_Pos)            /*!< 0x00000200 */
#define TIM_CCER_CC3P                       TIM_CCER_CC3P_Msk                       /*!<Capture/Compare 3 output Polarity */
#define TIM_CCER_CC3NE_Pos                  (10U)
#define TIM_CCER_CC3NE_Msk                  (0x1UL << TIM_CCER_CC3NE_Pos)           /*!< 0x00000400 */
#define TIM_CCER_CC3NE                      TIM_CCER_CC3NE_Msk                      /*!<Capture/Compare 3 Complementary output enable */
#define TIM_CCER_CC3NP_Pos                  (11U)
#define TIM_CCER_CC3NP_Msk                  (0x1UL << TIM_CCER_CC3NP_Pos)           /*!< 0x00000800 */
#define TIM_CCER_CC3NP                      TIM_CCER_CC3NP_Msk                      /*!<Capture/Compare 3 Complementary output Polarity */
#define TIM_CCER_CC4E_Pos                   (12U)
#define TIM_CCER_CC4E_Msk                   (0x1UL << TIM_CCER_CC4E_Pos)            /*!< 0x00001000 */
#define TIM_CCER_CC4E                       TIM_CCER_CC4E_Msk                       /*!<Capture/Compare 4 output enable */
#define TIM_CCER_CC4P_Pos                   (13U)
#define TIM_CCER_CC4P_Msk                   (0x1UL << TIM_CCER_CC4P_Pos)            /*!< 0x00002000 */
#define TIM_CCER_CC4P                       TIM_CCER_CC4P_Msk                       /*!<Capture/Compare 4 output Polarity */
#define TIM_CCER_CC4NE_Pos                  (14U)
#define TIM_CCER_CC4NE_Msk                  (0x1UL << TIM_CCER_CC4NE_Pos)           /*!< 0x00004000 */
#define TIM_CCER_CC4NE                      TIM_CCER_CC4NE_Msk                      /*!<Capture/Compare 4 Complementary output enable */
#define TIM_CCER_CC4NP_Pos                  (15U)
#define TIM_CCER_CC4NP_Msk                  (0x1UL << TIM_CCER_CC4NP_Pos)           /*!< 0x00008000 */
#define TIM_CCER_CC4NP                      TIM_CCER_CC4NP_Msk                      /*!<Capture/Compare 4 Complementary output Polarity */
#define TIM_CCER_CC5E_Pos                   (16U)
#define TIM_CCER_CC5E_Msk                   (0x1UL << TIM_CCER_CC5E_Pos)            /*!< 0x00010000 */
#define TIM_CCER_CC5E                       TIM_CCER_CC5E_Msk                       /*!<Capture/Compare 5 output enable */
#define TIM_CCER_CC5P_Pos                   (17U)
#define TIM_CCER_CC5P_Msk                   (0x1UL << TIM_CCER_CC5P_Pos)            /*!< 0x00020000 */
#define TIM_CCER_CC5P                       TIM_CCER_CC5P_Msk                       /*!<Capture/Compare 5 output Polarity */
#define TIM_CCER_CC6E_Pos                   (20U)
#define TIM_CCER_CC6E_Msk                   (0x1UL << TIM_CCER_CC6E_Pos)            /*!< 0x00100000 */
#define TIM_CCER_CC6E                       TIM_CCER_CC6E_Msk                       /*!<Capture/Compare 6 output enable */
#define TIM_CCER_CC6P_Pos                   (21U)
#define TIM_CCER_CC6P_Msk                   (0x1UL << TIM_CCER_CC6P_Pos)            /*!< 0x00200000 */
#define TIM_CCER_CC6P                       TIM_CCER_CC6P_Msk                       /*!<Capture/Compare 6 output Polarity */

/*******************  Bit definition for TIM_CNT register  ********************/
#define TIM_CNT_CNT_Pos                     (0U)
#define TIM_CNT_CNT_Msk                     (0xFFFFFFFFUL << TIM_CNT_CNT_Pos)       /*!< 0xFFFFFFFF */
#define TIM_CNT_CNT                         TIM_CNT_CNT_Msk                         /*!<Counter Value */
#define TIM_CNT_UIFCPY_Pos                  (31U)
#define TIM_CNT_UIFCPY_Msk                  (0x1UL << TIM_CNT_UIFCPY_Pos)           /*!< 0x80000000 */
#define TIM_CNT_UIFCPY                      TIM_CNT_UIFCPY_Msk                      /*!<Update interrupt flag copy (if UIFREMAP=1) */

/*******************  Bit definition for TIM_PSC register  ********************/
#define TIM_PSC_PSC_Pos                     (0U)
#define TIM_PSC_PSC_Msk                     (0xFFFFUL << TIM_PSC_PSC_Pos)           /*!< 0x0000FFFF */
#define TIM_PSC_PSC                         TIM_PSC_PSC_Msk                         /*!<Prescaler Value */

/*******************  Bit definition for TIM_ARR register  ********************/
#define TIM_ARR_ARR_Pos                     (0U)
#define TIM_ARR_ARR_Msk                     (0xFFFFFFFFUL << TIM_ARR_ARR_Pos)       /*!< 0xFFFFFFFF */
#define TIM_ARR_ARR                         TIM_ARR_ARR_Msk                         /*!<Actual auto-reload Value */

/*******************  Bit definition for TIM_RCR register  ********************/
#define TIM_RCR_REP_Pos                     (0U)
#define TIM_RCR_REP_Msk                     (0xFFFFUL << TIM_RCR_REP_Pos)           /*!< 0x0000FFFF */
#define TIM_RCR_REP                         TIM_RCR_REP_Msk                         /*!<Repetition Counter Value */

/*******************  Bit definition for TIM_CCR1 register  *******************/
#define TIM_CCR1_CCR1_Pos                   (0U)
#define TIM_CCR1_CCR1_Msk                   (0xFFFFFFFFUL << TIM_CCR1_CCR1_Pos)     /*!< 0xFFFFFFFF */
#define TIM_CCR1_CCR1                       TIM_CCR1_CCR1_Msk                       /*!<Capture/Compare 1 Value */

/*******************  Bit definition for TIM_CCR2 register  *******************/
#define TIM_CCR2_CCR2_Pos                   (0U)
#define TIM_CCR2_CCR2_Msk                   (0xFFFFFFFFUL << TIM_CCR2_CCR2_Pos)     /*!< 0xFFFFFFFF */
#define TIM_CCR2_CCR2                       TIM_CCR2_CCR2_Msk                       /*!<Capture/Compare 2 Value */

/*******************  Bit definition for TIM_CCR3 register  *******************/
#define TIM_CCR3_CCR3_Pos                   (0U)
#define TIM_CCR3_CCR3_Msk                   (0xFFFFFFFFUL << TIM_CCR3_CCR3_Pos)     /*!< 0xFFFFFFFF */
#define TIM_CCR3_CCR3                       TIM_CCR3_CCR3_Msk                       /*!<Capture/Compare 3 Value */

/*******************  Bit definition for TIM_CCR4 register  *******************/
#define TIM_CCR4_CCR4_Pos                   (0U)
#define TIM_CCR4_CCR4_Msk                   (0xFFFFFFFFUL << TIM_CCR4_CCR4_Pos)     /*!< 0xFFFFFFFF */
#define TIM_CCR4_CCR4                       TIM_CCR4_CCR4_Msk                       /*!<Capture/Compare 4 Value */

/*******************  Bit definition for TIM_CCR5 register  *******************/
#define TIM_CCR5_CCR5_Pos                   (0U)
#define TIM_CCR5_CCR5_Msk                   (0xFFFFFUL << TIM_CCR5_CCR5_Pos)        /*!< 0x000FFFFF */
#define TIM_CCR5_CCR5                       TIM_CCR5_CCR5_Msk                       /*!<Capture/Compare 5 Value */
#define TIM_CCR5_GC5C1_Pos                  (29U)
#define TIM_CCR5_GC5C1_Msk                  (0x1UL << TIM_CCR5_GC5C1_Pos)           /*!< 0x20000000 */
#define TIM_CCR5_GC5C1                      TIM_CCR5_GC5C1_Msk                      /*!<Group Channel 5 and Channel 1 */
#define TIM_CCR5_GC5C2_Pos                  (30U)
#define TIM_CCR5_GC5C2_Msk                  (0x1UL << TIM_CCR5_GC5C2_Pos)           /*!< 0x40000000 */
#define TIM_CCR5_GC5C2                      TIM_CCR5_GC5C2_Msk                      /*!<Group Channel 5 and Channel 2 */
#define TIM_CCR5_GC5C3_Pos                  (31U)
#define TIM_CCR5_GC5C3_Msk                  (0x1UL << TIM_CCR5_GC5C3_Pos)           /*!< 0x80000000 */
#define TIM_CCR5_GC5C3                      TIM_CCR5_GC5C3_Msk                      /*!<Group Channel 5 and Channel 3 */

/*******************  Bit definition for TIM_CCR6 register  *******************/
#define TIM_CCR6_CCR6_Pos                   (0U)
#define TIM_CCR6_CCR6_Msk                   (0xFFFFFUL << TIM_CCR6_CCR6_Pos)        /*!< 0x000FFFFF */
#define TIM_CCR6_CCR6                       TIM_CCR6_CCR6_Msk                       /*!<Capture/Compare 6 Value */

/*******************  Bit definition for TIM_BDTR register  *******************/
#define TIM_BDTR_DTG_Pos                    (0U)
#define TIM_BDTR_DTG_Msk                    (0xFFUL << TIM_BDTR_DTG_Pos)            /*!< 0x000000FF */
#define TIM_BDTR_DTG                        TIM_BDTR_DTG_Msk                        /*!<DTG[0:7] bits (Dead-Time Generator set-up) */
#define TIM_BDTR_DTG_0                      (0x01UL << TIM_BDTR_DTG_Pos)            /*!< 0x00000001 */
#define TIM_BDTR_DTG_1                      (0x02UL << TIM_BDTR_DTG_Pos)            /*!< 0x00000002 */
#define TIM_BDTR_DTG_2                      (0x04UL << TIM_BDTR_DTG_Pos)            /*!< 0x00000004 */
#define TIM_BDTR_DTG_3                      (0x08UL << TIM_BDTR_DTG_Pos)            /*!< 0x00000008 */
#define TIM_BDTR_DTG_4                      (0x10UL << TIM_BDTR_DTG_Pos)            /*!< 0x00000010 */
#define TIM_BDTR_DTG_5                      (0x20UL << TIM_BDTR_DTG_Pos)            /*!< 0x00000020 */
#define TIM_BDTR_DTG_6                      (0x40UL << TIM_BDTR_DTG_Pos)            /*!< 0x00000040 */
#define TIM_BDTR_DTG_7                      (0x80UL << TIM_BDTR_DTG_Pos)            /*!< 0x00000080 */
#define TIM_BDTR_LOCK_Pos                   (8U)
#define TIM_BDTR_LOCK_Msk                   (0x3UL << TIM_BDTR_LOCK_Pos)            /*!< 0x00000300 */
#define TIM_BDTR_LOCK                       TIM_BDTR_LOCK_Msk                       /*!<LOCK[1:0] bits (Lock Configuration) */
#define TIM_BDTR_LOCK_0                     (0x1UL << TIM_BDTR_LOCK_Pos)            /*!< 0x00000100 */
#define TIM_BDTR_LOCK_1                     (0x2UL << TIM_BDTR_LOCK_Pos)            /*!< 0x00000200 */
#define TIM_BDTR_OSSI_Pos                   (10U)
#define TIM_BDTR_OSSI_Msk                   (0x1UL << TIM_BDTR_OSSI_Pos)            /*!< 0x00000400 */
#define TIM_BDTR_OSSI                       TIM_BDTR_OSSI_Msk                       /*!<Off-State Selection for Idle mode */
#define TIM_BDTR_OSSR_Pos                   (11U)
#define TIM_BDTR_OSSR_Msk                   (0x1UL << TIM_BDTR_OSSR_Pos)            /*!< 0x00000800 */
#define TIM_BDTR_OSSR                       TIM_BDTR_OSSR_Msk                       /*!<Off-State Selection for Run mode */
#define TIM_BDTR_BKE_Pos                    (12U)
#define TIM_BDTR_BKE_Msk                    (0x1UL << TIM_BDTR_BKE_Pos)             /*!< 0x00001000 */
#define TIM_BDTR_BKE                        TIM_BDTR_BKE_Msk                        /*!<Break enable for Break 1 */
#define TIM_BDTR_BKP_Pos                    (13U)
#define TIM_BDTR_BKP_Msk                    (0x1UL << TIM_BDTR_BKP_Pos)             /*!< 0x00002000 */
#define TIM_BDTR_BKP                        TIM_BDTR_BKP_Msk                        /*!<Break Polarity for Break 1 */
#define TIM_BDTR_AOE_Pos                    (14U)
#define TIM_BDTR_AOE_Msk                    (0x1UL << TIM_BDTR_AOE_Pos)             /*!< 0x00004000 */
#define TIM_BDTR_AOE                        TIM_BDTR_AOE_Msk                        /*!<Automatic Output enable */
#define TIM_BDTR_MOE_Pos                    (15U)
#define TIM_BDTR_MOE_Msk                    (0x1UL << TIM_BDTR_MOE_Pos)             /*!< 0x00008000 */
#define TIM_BDTR_MOE                        TIM_BDTR_MOE_Msk                        /*!<Main Output enable */
#define TIM_BDTR_BKF_Pos                    (16U)
#define TIM_BDTR_BKF_Msk                    (0xFUL << TIM_BDTR_BKF_Pos)             /*!< 0x000F0000 */
#define TIM_BDTR_BKF                        TIM_BDTR_BKF_Msk                        /*!<Break Filter for Break 1 */
#define TIM_BDTR_BK2F_Pos                   (20U)
#define TIM_BDTR_BK2F_Msk                   (0xFUL << TIM_BDTR_BK2F_Pos)            /*!< 0x00F00000 */
#define TIM_BDTR_BK2F                       TIM_BDTR_BK2F_Msk                       /*!<Break Filter for Break 2 */
#define TIM_BDTR_BK2E_Pos                   (24U)
#define TIM_BDTR_BK2E_Msk                   (0x1UL << TIM_BDTR_BK2E_Pos)            /*!< 0x01000000 */
#define TIM_BDTR_BK2E                       TIM_BDTR_BK2E_Msk                       /*!<Break enable for Break 2 */
#define TIM_BDTR_BK2P_Pos                   (25U)
#define TIM_BDTR_BK2P_Msk                   (0x1UL << TIM_BDTR_BK2P_Pos)            /*!< 0x02000000 */
#define TIM_BDTR_BK2P                       TIM_BDTR_BK2P_Msk                       /*!<Break Polarity for Break 2 */
#define TIM_BDTR_BKDSRM_Pos                 (26U)
#define TIM_BDTR_BKDSRM_Msk                 (0x1UL << TIM_BDTR_BKDSRM_Pos)          /*!< 0x04000000 */
#define TIM_BDTR_BKDSRM                     TIM_BDTR_BKDSRM_Msk                     /*!<Break disarming/re-arming */
#define TIM_BDTR_BK2DSRM_Pos                (27U)
#define TIM_BDTR_BK2DSRM_Msk                (0x1UL << TIM_BDTR_BK2DSRM_Pos)         /*!< 0x08000000 */
#define TIM_BDTR_BK2DSRM                    TIM_BDTR_BK2DSRM_Msk                    /*!<Break2 disarming/re-arming */
#define TIM_BDTR_BKBID_Pos                  (28U)
#define TIM_BDTR_BKBID_Msk                  (0x1UL << TIM_BDTR_BKBID_Pos)           /*!< 0x10000000 */
#define TIM_BDTR_BKBID                      TIM_BDTR_BKBID_Msk                      /*!<Break BIDirectional */
#define TIM_BDTR_BK2BID_Pos                 (29U)
#define TIM_BDTR_BK2BID_Msk                 (0x1UL << TIM_BDTR_BK2BID_Pos)          /*!< 0x20000000 */
#define TIM_BDTR_BK2BID                     TIM_BDTR_BK2BID_Msk                     /*!<Break2 BIDirectional */

/*******************  Bit definition for TIM_DCR register  ********************/
#define TIM_DCR_DBA_Pos                     (0U)
#define TIM_DCR_DBA_Msk                     (0x1FUL << TIM_DCR_DBA_Pos)             /*!< 0x0000001F */
#define TIM_DCR_DBA                         TIM_DCR_DBA_Msk                         /*!<DBA[4:0] bits (DMA Base Address) */
#define TIM_DCR_DBA_0                       (0x01UL << TIM_DCR_DBA_Pos)             /*!< 0x00000001 */
#define TIM_DCR_DBA_1                       (0x02UL << TIM_DCR_DBA_Pos)             /*!< 0x00000002 */
#define TIM_DCR_DBA_2                       (0x04UL << TIM_DCR_DBA_Pos)             /*!< 0x00000004 */
#define TIM_DCR_DBA_3                       (0x08UL << TIM_DCR_DBA_Pos)             /*!< 0x00000008 */
#define TIM_DCR_DBA_4                       (0x10UL << TIM_DCR_DBA_Pos)             /*!< 0x00000010 */
#define TIM_DCR_DBL_Pos                     (8U)
#define TIM_DCR_DBL_Msk                     (0x1FUL << TIM_DCR_DBL_Pos)             /*!< 0x00001F00 */
#define TIM_DCR_DBL                         TIM_DCR_DBL_Msk                         /*!<DBL[4:0] bits (DMA Burst Length) */
#define TIM_DCR_DBL_0                       (0x01UL << TIM_DCR_DBL_Pos)             /*!< 0x00000100 */
#define TIM_DCR_DBL_1                       (0x02UL << TIM_DCR_DBL_Pos)             /*!< 0x00000200 */
#define TIM_DCR_DBL_2                       (0x04UL << TIM_DCR_DBL_Pos)             /*!< 0x00000400 */
#define TIM_DCR_DBL_3                       (0x08UL << TIM_DCR_DBL_Pos)             /*!< 0x00000800 */
#define TIM_DCR_DBL_4                       (0x10UL << TIM_DCR_DBL_Pos)             /*!< 0x00001000 */
#define TIM_DCR_DBSS_Pos                    (16U)
#define TIM_DCR_DBSS_Msk                    (0xFUL << TIM_DCR_DBSS_Pos)             /*!< 0x00000F00 */
#define TIM_DCR_DBSS                        TIM_DCR_DBSS_Msk                        /*!<DBSS[19:16] bits (DMA Burst Source Selection) */
#define TIM_DCR_DBSS_0                      (0x01UL << TIM_DCR_DBSS_Pos)            /*!< 0x00000100 */
#define TIM_DCR_DBSS_1                      (0x02UL << TIM_DCR_DBSS_Pos)            /*!< 0x00000200 */
#define TIM_DCR_DBSS_2                      (0x04UL << TIM_DCR_DBSS_Pos)            /*!< 0x00000400 */
#define TIM_DCR_DBSS_3                      (0x08UL << TIM_DCR_DBSS_Pos)            /*!< 0x00000800 */

/*******************  Bit definition for TIM1_AF1 register  *******************/
#define TIM1_AF1_BKINE_Pos                  (0U)
#define TIM1_AF1_BKINE_Msk                  (0x1UL << TIM1_AF1_BKINE_Pos)           /*!< 0x00000001 */
#define TIM1_AF1_BKINE                      TIM1_AF1_BKINE_Msk                      /*!<BRK BKIN input enable */
#define TIM1_AF1_BKCMP1E_Pos                (1U)
#define TIM1_AF1_BKCMP1E_Msk                (0x1UL << TIM1_AF1_BKCMP1E_Pos)         /*!< 0x00000002 */
#define TIM1_AF1_BKCMP1E                    TIM1_AF1_BKCMP1E_Msk                    /*!<BRK COMP1 enable */
#define TIM1_AF1_BKCMP2E_Pos                (2U)
#define TIM1_AF1_BKCMP2E_Msk                (0x1UL << TIM1_AF1_BKCMP2E_Pos)         /*!< 0x00000004 */
#define TIM1_AF1_BKCMP2E                    TIM1_AF1_BKCMP2E_Msk                    /*!<BRK COMP2 enable */
#define TIM1_AF1_BKDF1BK0E_Pos              (8U)
#define TIM1_AF1_BKDF1BK0E_Msk              (0x1UL << TIM1_AF1_BKDF1BK0E_Pos)       /*!< 0x00000100 */
#define TIM1_AF1_BKDF1BK0E                  TIM1_AF1_BKDF1BK0E_Msk                  /*!<BRK mdf1_break[0](TIM1) or mdf1_break[2](TIM2) enable */
#define TIM1_AF1_BKINP_Pos                  (9U)
#define TIM1_AF1_BKINP_Msk                  (0x1UL << TIM1_AF1_BKINP_Pos)           /*!< 0x00000200 */
#define TIM1_AF1_BKINP                      TIM1_AF1_BKINP_Msk                      /*!<BRK BKIN input polarity */
#define TIM1_AF1_BKCMP1P_Pos                (10U)
#define TIM1_AF1_BKCMP1P_Msk                (0x1UL << TIM1_AF1_BKCMP1P_Pos)         /*!< 0x00000400 */
#define TIM1_AF1_BKCMP1P                    TIM1_AF1_BKCMP1P_Msk                    /*!<BRK COMP1 input polarity */
#define TIM1_AF1_BKCMP2P_Pos                (11U)
#define TIM1_AF1_BKCMP2P_Msk                (0x1UL << TIM1_AF1_BKCMP2P_Pos)         /*!< 0x00000800 */
#define TIM1_AF1_BKCMP2P                    TIM1_AF1_BKCMP2P_Msk                    /*!<BRK COMP2 input polarity */
#define TIM1_AF1_ETRSEL_Pos                 (14U)
#define TIM1_AF1_ETRSEL_Msk                 (0xFUL << TIM1_AF1_ETRSEL_Pos)          /*!< 0x0003C000 */
#define TIM1_AF1_ETRSEL                     TIM1_AF1_ETRSEL_Msk                     /*!<ETRSEL[3:0] bits (TIM1 ETR source selection) */
#define TIM1_AF1_ETRSEL_0                   (0x1UL << TIM1_AF1_ETRSEL_Pos)          /*!< 0x00004000 */
#define TIM1_AF1_ETRSEL_1                   (0x2UL << TIM1_AF1_ETRSEL_Pos)          /*!< 0x00008000 */
#define TIM1_AF1_ETRSEL_2                   (0x4UL << TIM1_AF1_ETRSEL_Pos)          /*!< 0x00010000 */
#define TIM1_AF1_ETRSEL_3                   (0x8UL << TIM1_AF1_ETRSEL_Pos)          /*!< 0x00020000 */

/*******************  Bit definition for TIM1_AF2 register  *********************/
#define TIM1_AF2_BK2INE_Pos                 (0U)
#define TIM1_AF2_BK2INE_Msk                 (0x1UL << TIM1_AF2_BK2INE_Pos)          /*!< 0x00000001 */
#define TIM1_AF2_BK2INE                     TIM1_AF2_BK2INE_Msk                     /*!<BRK2 BKIN input enable */
#define TIM1_AF2_BK2CMP1E_Pos               (1U)
#define TIM1_AF2_BK2CMP1E_Msk               (0x1UL << TIM1_AF2_BK2CMP1E_Pos)        /*!< 0x00000002 */
#define TIM1_AF2_BK2CMP1E                   TIM1_AF2_BK2CMP1E_Msk                   /*!<BRK2 COMP1 enable */
#define TIM1_AF2_BK2CMP2E_Pos               (2U)
#define TIM1_AF2_BK2CMP2E_Msk               (0x1UL << TIM1_AF2_BK2CMP2E_Pos)        /*!< 0x00000004 */
#define TIM1_AF2_BK2CMP2E                   TIM1_AF2_BK2CMP2E_Msk                   /*!<BRK2 COMP2 enable */
#define TIM1_AF2_BK2DF1BK1E_Pos             (8U)
#define TIM1_AF2_BK2DF1BK1E_Msk             (0x1UL << TIM1_AF2_BK2DF1BK1E_Pos)      /*!< 0x00000100 */
#define TIM1_AF2_BK2DF1BK1E                 TIM1_AF2_BK2DF1BK1E_Msk                 /*!<BRK2 mdf1_break[1](TIM1) or mdf1_break[3](TIM8) enable */
#define TIM1_AF2_BK2INP_Pos                 (9U)
#define TIM1_AF2_BK2INP_Msk                 (0x1UL << TIM1_AF2_BK2INP_Pos)          /*!< 0x00000200 */
#define TIM1_AF2_BK2INP                     TIM1_AF2_BK2INP_Msk                     /*!<BRK2 BKIN input polarity */
#define TIM1_AF2_BK2CMP1P_Pos               (10U)
#define TIM1_AF2_BK2CMP1P_Msk               (0x1UL << TIM1_AF2_BK2CMP1P_Pos)        /*!< 0x00000400 */
#define TIM1_AF2_BK2CMP1P                   TIM1_AF2_BK2CMP1P_Msk                   /*!<BRK2 COMP1 input polarity */
#define TIM1_AF2_BK2CMP2P_Pos               (11U)
#define TIM1_AF2_BK2CMP2P_Msk               (0x1UL << TIM1_AF2_BK2CMP2P_Pos)        /*!< 0x00000800 */
#define TIM1_AF2_BK2CMP2P                   TIM1_AF2_BK2CMP2P_Msk                   /*!<BRK2 COMP2 input polarity */
#define TIM1_AF2_OCRSEL_Pos                 (16U)
#define TIM1_AF2_OCRSEL_Msk                 (0x1UL << TIM1_AF2_OCRSEL_Pos)          /*!< 0x00010000 */
#define TIM1_AF2_OCRSEL                     TIM1_AF2_OCRSEL_Msk                     /*!<OCREF_CLR source selection */
#define TIM1_AF2_OCRSEL_0                   (0x1UL << TIM1_AF2_OCRSEL_Pos)          /*!< 0x00010000 */

/*******************  Bit definition for TIM_OR1 register  *********************/
#define TIM_OR1_RTCPREEN_Pos                 (1U)
#define TIM_OR1_RTCPREEN_Msk                 (0x1UL << TIM_OR1_RTCPREEN_Pos)           /*!< 0x00000002 */
#define TIM_OR1_RTCPREEN                     TIM_OR1_RTCPREEN_Msk                      /*!< RTCPRE HSE divider enable */

/*******************  Bit definition for TIM_TISEL register  *********************/
#define TIM_TISEL_TI1SEL_Pos                (0U)
#define TIM_TISEL_TI1SEL_Msk                (0xFUL << TIM_TISEL_TI1SEL_Pos)         /*!< 0x0000000F */
#define TIM_TISEL_TI1SEL                    TIM_TISEL_TI1SEL_Msk                    /*!<TI1SEL[3:0] bits (TIM1 TI1 SEL)*/
#define TIM_TISEL_TI1SEL_0                  (0x1UL << TIM_TISEL_TI1SEL_Pos)         /*!< 0x00000001 */
#define TIM_TISEL_TI1SEL_1                  (0x2UL << TIM_TISEL_TI1SEL_Pos)         /*!< 0x00000002 */
#define TIM_TISEL_TI1SEL_2                  (0x4UL << TIM_TISEL_TI1SEL_Pos)         /*!< 0x00000004 */
#define TIM_TISEL_TI1SEL_3                  (0x8UL << TIM_TISEL_TI1SEL_Pos)         /*!< 0x00000008 */
#define TIM_TISEL_TI2SEL_Pos                (8U)
#define TIM_TISEL_TI2SEL_Msk                (0xFUL << TIM_TISEL_TI2SEL_Pos)         /*!< 0x00000F00 */
#define TIM_TISEL_TI2SEL                    TIM_TISEL_TI2SEL_Msk                    /*!<TI2SEL[3:0] bits (TIM1 TI2 SEL)*/
#define TIM_TISEL_TI2SEL_0                  (0x1UL << TIM_TISEL_TI2SEL_Pos)         /*!< 0x00000100 */
#define TIM_TISEL_TI2SEL_1                  (0x2UL << TIM_TISEL_TI2SEL_Pos)         /*!< 0x00000200 */
#define TIM_TISEL_TI2SEL_2                  (0x4UL << TIM_TISEL_TI2SEL_Pos)         /*!< 0x00000400 */
#define TIM_TISEL_TI2SEL_3                  (0x8UL << TIM_TISEL_TI2SEL_Pos)         /*!< 0x00000800 */
#define TIM_TISEL_TI3SEL_Pos                (16U)
#define TIM_TISEL_TI3SEL_Msk                (0xFUL << TIM_TISEL_TI3SEL_Pos)         /*!< 0x000F0000 */
#define TIM_TISEL_TI3SEL                    TIM_TISEL_TI3SEL_Msk                    /*!<TI3SEL[3:0] bits (TIM1 TI3 SEL)*/
#define TIM_TISEL_TI3SEL_0                  (0x1UL << TIM_TISEL_TI3SEL_Pos)         /*!< 0x00010000 */
#define TIM_TISEL_TI3SEL_1                  (0x2UL << TIM_TISEL_TI3SEL_Pos)         /*!< 0x00020000 */
#define TIM_TISEL_TI3SEL_2                  (0x4UL << TIM_TISEL_TI3SEL_Pos)         /*!< 0x00040000 */
#define TIM_TISEL_TI3SEL_3                  (0x8UL << TIM_TISEL_TI3SEL_Pos)         /*!< 0x00080000 */
#define TIM_TISEL_TI4SEL_Pos                (24U)
#define TIM_TISEL_TI4SEL_Msk                (0xFUL << TIM_TISEL_TI4SEL_Pos)         /*!< 0x0F000000 */
#define TIM_TISEL_TI4SEL                    TIM_TISEL_TI4SEL_Msk                    /*!<TI4SEL[3:0] bits (TIM1 TI4 SEL)*/
#define TIM_TISEL_TI4SEL_0                  (0x1UL << TIM_TISEL_TI4SEL_Pos)         /*!< 0x01000000 */
#define TIM_TISEL_TI4SEL_1                  (0x2UL << TIM_TISEL_TI4SEL_Pos)         /*!< 0x02000000 */
#define TIM_TISEL_TI4SEL_2                  (0x4UL << TIM_TISEL_TI4SEL_Pos)         /*!< 0x04000000 */
#define TIM_TISEL_TI4SEL_3                  (0x8UL << TIM_TISEL_TI4SEL_Pos)         /*!< 0x08000000 */

/*******************  Bit definition for TIM_DTR2 register  *********************/
#define TIM_DTR2_DTGF_Pos                   (0U)
#define TIM_DTR2_DTGF_Msk                   (0xFFUL << TIM_DTR2_DTGF_Pos)           /*!< 0x0000000F */
#define TIM_DTR2_DTGF                       TIM_DTR2_DTGF_Msk                       /*!<DTGF[7:0] bits (Deadtime falling edge generator setup)*/
#define TIM_DTR2_DTGF_0                     (0x01UL << TIM_DTR2_DTGF_Pos)           /*!< 0x00000001 */
#define TIM_DTR2_DTGF_1                     (0x02UL << TIM_DTR2_DTGF_Pos)           /*!< 0x00000002 */
#define TIM_DTR2_DTGF_2                     (0x04UL << TIM_DTR2_DTGF_Pos)           /*!< 0x00000004 */
#define TIM_DTR2_DTGF_3                     (0x08UL << TIM_DTR2_DTGF_Pos)           /*!< 0x00000008 */
#define TIM_DTR2_DTGF_4                     (0x10UL << TIM_DTR2_DTGF_Pos)           /*!< 0x00000010 */
#define TIM_DTR2_DTGF_5                     (0x20UL << TIM_DTR2_DTGF_Pos)           /