---
name: "\U0001F41B Bug report"
about: Report a bug or unexpected behavior while using the STM32 core
title: ''
labels: bug
assignees: ''

---

**Please, before reporting any issue**
- Make sure you are using the latest Arduino_Core_STM32 version.
  https://github.com/stm32duino/Arduino_Core_STM32/releases/latest
- Make sure the issue is not already reported/fixed on GitHub or discussed on the [stm32duino forum](https://stm32duino.com)
- Submit a GitHub issue only for reporting a problem related to the [Arduino_Core_STM32](https://github.com/stm32duino/Arduino_Core_STM32).
- **Avoid** to submit a GitHub issue for project troubleshooting.

Any questions/feedback/suggestions should be discussed on the [stm32duino forum](https://stm32duino.com):
  * questions on the [STM32 Core](https://www.stm32duino.com/viewforum.php?f=35)
  * bugs/enhancements on the [STM core: Bugs and enhancements](https://www.stm32duino.com/viewforum.php?f=38)


&#x26A0; When reporting any issue, please try to provide all relevant information to help on its resolution.

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Complete source code which can be used to reproduce the issue. Please try to be as generic as possible (no extra code, extra hardware,...)

Steps to reproduce the behavior:
1. Plug
2. Press USER_BTN
3. See error

**Expected behavior**
A clear and concise description of what you expected to happen.

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Desktop (please complete the following information):**
 - OS: [e.g. Windows]
 - Arduino IDE version: [e.g. 1.8.8]
 - STM32 core version: [e.g. 1.4.0]
 - Tools menu settings if not the default: [e.g. Newlib Standard, No Serial]
 - Upload method: [e.g. SWD]

**Board (please complete the following information):**
 - Name: [e.g. Nucleo F429ZI]
 - Hardware Revision: [e.g. Rev B]
 - Extra hardware used if any: [e.g. X-Nucleo IKS01A1]

**Additional context**
Add any other context about the problem here.
