// Created on: 1995-03-13
// Created by: Robert COUBLANC
// Copyright (c) 1995-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Select3D_SensitiveCurve.hxx>

#include <gp_Pnt.hxx>
#include <NCollection_Array1.hxx>

IMPLEMENT_STANDARD_RTTIEXT(Select3D_SensitiveCurve, Select3D_SensitivePoly)

//=================================================================================================

Select3D_SensitiveCurve::Select3D_SensitiveCurve(
  const occ::handle<SelectMgr_EntityOwner>&       theOwnerId,
  const occ::handle<NCollection_HArray1<gp_Pnt>>& thePoints)
    : Select3D_SensitivePoly(theOwnerId, thePoints, true)

{
  SetSensitivityFactor(3);
}

//=================================================================================================

Select3D_SensitiveCurve::Select3D_SensitiveCurve(
  const occ::handle<SelectMgr_EntityOwner>& theOwnerId,
  const NCollection_Array1<gp_Pnt>&         thePoints)
    : Select3D_SensitivePoly(theOwnerId, thePoints, true)
{
  SetSensitivityFactor(3);
}

//=================================================================================================

occ::handle<Select3D_SensitiveEntity> Select3D_SensitiveCurve::GetConnected()
{
  occ::handle<NCollection_HArray1<gp_Pnt>> aPoints =
    new NCollection_HArray1<gp_Pnt>(1, myPolyg.Size());
  for (int anIndex = 1; anIndex <= myPolyg.Size(); ++anIndex)
  {
    aPoints->SetValue(anIndex, myPolyg.Pnt(anIndex - 1));
  }
  occ::handle<Select3D_SensitiveEntity> aNewEntity =
    new Select3D_SensitiveCurve(myOwnerId, aPoints);
  return aNewEntity;
}
