// Created on: 2001-08-28
// Created by: data exchange team
// Copyright (c) 2001-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _ShapeCustom_Curve_HeaderFile
#define _ShapeCustom_Curve_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Handle.hxx>

class Geom_Curve;

//! Converts BSpline curve to periodic
class ShapeCustom_Curve
{
public:
  DEFINE_STANDARD_ALLOC

  Standard_EXPORT ShapeCustom_Curve();

  Standard_EXPORT ShapeCustom_Curve(const occ::handle<Geom_Curve>& C);

  Standard_EXPORT void Init(const occ::handle<Geom_Curve>& C);

  //! Tries to convert the Curve to the Periodic form
  //! Returns the resulting curve
  //! Works only if the Curve is BSpline and is closed with
  //! Precision::Confusion()
  //! Else, or in case of failure, returns a Null Handle
  Standard_EXPORT occ::handle<Geom_Curve> ConvertToPeriodic(const bool   substitute,
                                                            const double preci = -1);

private:
  occ::handle<Geom_Curve> myCurve;
};

#endif // _ShapeCustom_Curve_HeaderFile
