// Created on: 1993-02-03
// Created by: Laurent BOURESCHE
// Copyright (c) 1993-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Sweep_NumShape.hxx>

//=================================================================================================

Sweep_NumShape::Sweep_NumShape()
    : myType(TopAbs_SHAPE),
      myIndex(0),
      myClosed(false),
      myBegInf(false),
      myEndInf(false)

{
}

//=================================================================================================

Sweep_NumShape::Sweep_NumShape(const int              Index,
                               const TopAbs_ShapeEnum Type,
                               const bool             Closed,
                               const bool             BegInf,
                               const bool             EndInf)
    : myType(Type),
      myIndex(Index),
      myClosed(Closed),
      myBegInf(BegInf),
      myEndInf(EndInf)
{
}

//=================================================================================================

void Sweep_NumShape::Init(const int              Index,
                          const TopAbs_ShapeEnum Type,
                          const bool             Closed,
                          const bool             BegInf,
                          const bool             EndInf)
{
  myIndex  = Index;
  myType   = Type;
  myClosed = Closed;
  myBegInf = BegInf;
  myEndInf = EndInf;
}

//=================================================================================================

TopAbs_Orientation Sweep_NumShape::Orientation() const
{
  if (myType == TopAbs_EDGE)
  {
    return TopAbs_FORWARD;
  }
  else
  {
    if (myIndex == 2)
    {
      return TopAbs_FORWARD;
    }
    else
    {
      return TopAbs_REVERSED;
    }
  }
}
