// Created on: 1993-06-25
// Created by: Laurent BOURESCHE
// Copyright (c) 1993-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <BRepSweep_Prism.hxx>
#include <BRepSweep_Translation.hxx>
#include <gp_Dir.hxx>
#include <gp_Trsf.hxx>
#include <gp_Vec.hxx>
#include <Precision.hxx>
#include <Standard_ConstructionError.hxx>
#include <Sweep_NumShape.hxx>
#include <TopLoc_Location.hxx>
#include <TopoDS_Shape.hxx>

//=================================================================================================

BRepSweep_Prism::BRepSweep_Prism(const TopoDS_Shape& S,
                                 const gp_Vec&       V,
                                 const bool          C,
                                 const bool          Canonize)
    : myTranslation(S, NumShape(), Location(V), V, C, Canonize)
{
  Standard_ConstructionError_Raise_if(V.Magnitude() <= Precision::Confusion(),
                                      "BRepSweep_Prism::Constructor");
}

//=================================================================================================

BRepSweep_Prism::BRepSweep_Prism(const TopoDS_Shape& S,
                                 const gp_Dir&       D,
                                 const bool          Inf,
                                 const bool          C,
                                 const bool          Canonize)
    : myTranslation(S, NumShape(Inf), Location(D), D, C, Canonize)
{
}

//=================================================================================================

TopoDS_Shape BRepSweep_Prism::Shape()
{
  return myTranslation.Shape();
}

//=================================================================================================

TopoDS_Shape BRepSweep_Prism::Shape(const TopoDS_Shape& aGenS)
{
  return myTranslation.Shape(aGenS);
}

//=================================================================================================

TopoDS_Shape BRepSweep_Prism::FirstShape()
{
  return myTranslation.FirstShape();
}

//=================================================================================================

TopoDS_Shape BRepSweep_Prism::FirstShape(const TopoDS_Shape& aGenS)
{
  return myTranslation.FirstShape(aGenS);
}

//=================================================================================================

TopoDS_Shape BRepSweep_Prism::LastShape()
{
  return myTranslation.LastShape();
}

//=================================================================================================

TopoDS_Shape BRepSweep_Prism::LastShape(const TopoDS_Shape& aGenS)
{
  return myTranslation.LastShape(aGenS);
}

//=================================================================================================

gp_Vec BRepSweep_Prism::Vec() const
{
  return myTranslation.Vec();
}

//=================================================================================================

Sweep_NumShape BRepSweep_Prism::NumShape() const
{
  return Sweep_NumShape(2, TopAbs_EDGE);
}

//=================================================================================================

Sweep_NumShape BRepSweep_Prism::NumShape(const bool Inf) const
{
  Sweep_NumShape N;
  if (Inf)
  {
    N.Init(0, TopAbs_EDGE, false, true, true);
  }
  else
  {
    N.Init(1, TopAbs_EDGE, false, false, true);
  }
  return N;
}

//=================================================================================================

TopLoc_Location BRepSweep_Prism::Location(const gp_Vec& V) const
{
  gp_Trsf gpt;
  gpt.SetTranslation(V);
  TopLoc_Location L(gpt);
  return L;
}

//=================================================================================================

bool BRepSweep_Prism::IsUsed(const TopoDS_Shape& aGenS) const
{
  return myTranslation.IsUsed(aGenS);
}

//=================================================================================================

bool BRepSweep_Prism::GenIsUsed(const TopoDS_Shape& aGenS) const
{
  return myTranslation.GenIsUsed(aGenS);
}
