// Created on: 1993-07-23
// Created by: Remi LEQUETTE
// Copyright (c) 1993-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <BRepBuilderAPI.hxx>
#include <BRepPrim_Revolution.hxx>
#include <BRepPrimAPI_MakeRevolution.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Curve.hxx>
#include <Geom_Plane.hxx>
#include <GeomProjLib.hxx>
#include <gp_Ax2.hxx>

//=================================================================================================

static occ::handle<Geom2d_Curve> Project(const occ::handle<Geom_Curve>& M, const gp_Ax3& Axis)
{
  occ::handle<Geom2d_Curve> C;
  C = GeomProjLib::Curve2d(M, new Geom_Plane(Axis));
  return C;
}

static occ::handle<Geom2d_Curve> Project(const occ::handle<Geom_Curve>& M)
{
  return Project(M, gp_Ax2(gp::Origin(), -gp::DY(), gp::DX()));
}

//=================================================================================================

BRepPrimAPI_MakeRevolution::BRepPrimAPI_MakeRevolution(const occ::handle<Geom_Curve>& Meridian)
    : myRevolution(gp::XOY(),
                   Meridian->FirstParameter(),
                   Meridian->LastParameter(),
                   Meridian,
                   Project(Meridian))
{
}

//=================================================================================================

BRepPrimAPI_MakeRevolution::BRepPrimAPI_MakeRevolution(const occ::handle<Geom_Curve>& Meridian,
                                                       const double                   angle)
    : myRevolution(gp_Ax2(gp_Pnt(0, 0, 0), gp_Dir(gp_Dir::D::Z), gp_Dir(gp_Dir::D::X)),
                   Meridian->FirstParameter(),
                   Meridian->LastParameter(),
                   Meridian,
                   Project(Meridian))
{
  myRevolution.Angle(angle);
}

//=================================================================================================

BRepPrimAPI_MakeRevolution::BRepPrimAPI_MakeRevolution(const occ::handle<Geom_Curve>& Meridian,
                                                       const double                   VMin,
                                                       const double                   VMax)
    : myRevolution(gp_Ax2(gp_Pnt(0, 0, 0), gp_Dir(gp_Dir::D::Z), gp_Dir(gp_Dir::D::X)),
                   VMin,
                   VMax,
                   Meridian,
                   Project(Meridian))
{
}

//=================================================================================================

BRepPrimAPI_MakeRevolution::BRepPrimAPI_MakeRevolution(const occ::handle<Geom_Curve>& Meridian,
                                                       const double                   VMin,
                                                       const double                   VMax,
                                                       const double                   angle)
    : myRevolution(gp_Ax2(gp_Pnt(0, 0, 0), gp_Dir(gp_Dir::D::Z), gp_Dir(gp_Dir::D::X)),
                   VMin,
                   VMax,
                   Meridian,
                   Project(Meridian))
{
  myRevolution.Angle(angle);
}

//=================================================================================================

BRepPrimAPI_MakeRevolution::BRepPrimAPI_MakeRevolution(const gp_Ax2&                  Axes,
                                                       const occ::handle<Geom_Curve>& Meridian)
    : myRevolution(Axes,
                   Meridian->FirstParameter(),
                   Meridian->LastParameter(),
                   Meridian,
                   Project(Meridian))
{
}

//=================================================================================================

BRepPrimAPI_MakeRevolution::BRepPrimAPI_MakeRevolution(const gp_Ax2&                  Axes,
                                                       const occ::handle<Geom_Curve>& Meridian,
                                                       const double                   angle)
    : myRevolution(Axes,
                   Meridian->FirstParameter(),
                   Meridian->LastParameter(),
                   Meridian,
                   Project(Meridian))
{
  myRevolution.Angle(angle);
}

//=================================================================================================

BRepPrimAPI_MakeRevolution::BRepPrimAPI_MakeRevolution(const gp_Ax2&                  Axes,
                                                       const occ::handle<Geom_Curve>& Meridian,
                                                       const double                   VMin,
                                                       const double                   VMax)
    : myRevolution(Axes, VMin, VMax, Meridian, Project(Meridian))
{
}

//=================================================================================================

BRepPrimAPI_MakeRevolution::BRepPrimAPI_MakeRevolution(const gp_Ax2&                  Axes,
                                                       const occ::handle<Geom_Curve>& Meridian,
                                                       const double                   VMin,
                                                       const double                   VMax,
                                                       const double                   angle)
    : myRevolution(Axes, VMin, VMax, Meridian, Project(Meridian))
{
  myRevolution.Angle(angle);
}

//=================================================================================================

void* BRepPrimAPI_MakeRevolution::OneAxis()
{
  return &myRevolution;
}

//=================================================================================================

BRepPrim_Revolution& BRepPrimAPI_MakeRevolution::Revolution()
{
  return myRevolution;
}
