// Created on: 1995-12-05
// Created by: Laurent BOURESCHE
// Copyright (c) 1995-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <GeomFill_DegeneratedBound.hxx>
#include <gp_Pnt.hxx>
#include <gp_Vec.hxx>
#include <Standard_Type.hxx>

IMPLEMENT_STANDARD_RTTIEXT(GeomFill_DegeneratedBound, GeomFill_Boundary)

//=================================================================================================

GeomFill_DegeneratedBound::GeomFill_DegeneratedBound(const gp_Pnt& Point,
                                                     const double  First,
                                                     const double  Last,
                                                     const double  Tol3d,
                                                     const double  Tolang)
    : GeomFill_Boundary(Tol3d, Tolang),
      myPoint(Point),
      myFirst(First),
      myLast(Last)
{
}

//=================================================================================================

// gp_Pnt GeomFill_DegeneratedBound::Value(const double U) const
gp_Pnt GeomFill_DegeneratedBound::Value(const double) const
{
  return myPoint;
}

//=================================================================================================

// void GeomFill_DegeneratedBound::D1(const double U,
void GeomFill_DegeneratedBound::D1(const double, gp_Pnt& P, gp_Vec& V) const
{
  P = myPoint;
  V.SetCoord(0., 0., 0.);
}

//=================================================================================================

void GeomFill_DegeneratedBound::Reparametrize(const double First,
                                              const double Last,
                                              const bool,
                                              const bool,
                                              const double,
                                              const double,
                                              const bool)
{
  myFirst = First;
  myLast  = Last;
}

//=================================================================================================

void GeomFill_DegeneratedBound::Bounds(double& First, double& Last) const
{
  First = myFirst;
  Last  = myLast;
}

//=================================================================================================

bool GeomFill_DegeneratedBound::IsDegenerated() const
{
  return true;
}
