// Created on: 1995-11-03
// Created by: Laurent BOURESCHE
// Copyright (c) 1995-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <GeomFill_Boundary.hxx>
#include <gp_Pnt.hxx>
#include <gp_Vec.hxx>
#include <Standard_Type.hxx>

IMPLEMENT_STANDARD_RTTIEXT(GeomFill_Boundary, Standard_Transient)

//=================================================================================================

GeomFill_Boundary::GeomFill_Boundary(const double Tol3d, const double Tolang)
    : myT3d(Tol3d),
      myTang(Tolang)
{
}

//=================================================================================================

bool GeomFill_Boundary::HasNormals() const
{
  return false;
}

//=================================================================================================

gp_Vec GeomFill_Boundary::Norm(const double) const
{
  throw Standard_Failure("GeomFill_Boundary::Norm : Undefined normals");
}

//=================================================================================================

void GeomFill_Boundary::D1Norm(const double, gp_Vec&, gp_Vec&) const
{
  throw Standard_Failure("GeomFill_Boundary::Norm : Undefined normals");
}

//=================================================================================================

void GeomFill_Boundary::Points(gp_Pnt& PFirst, gp_Pnt& PLast) const
{
  double f, l;
  Bounds(f, l);
  PFirst = Value(f);
  PLast  = Value(l);
}

//=================================================================================================

double GeomFill_Boundary::Tol3d() const
{
  return myT3d;
}

//=================================================================================================

void GeomFill_Boundary::Tol3d(const double Tol)
{
  myT3d = Tol;
}

//=================================================================================================

double GeomFill_Boundary::Tolang() const
{
  return myTang;
}

//=================================================================================================

void GeomFill_Boundary::Tolang(const double Tol)
{
  myTang = Tol;
}
