// Created on: 1996-10-11
// Created by: Philippe MANGIN
// Copyright (c) 1996-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <FairCurve_Newton.hxx>
#include <math_MultipleVarFunctionWithHessian.hxx>

//=================================================================================================

FairCurve_Newton::FairCurve_Newton(const math_MultipleVarFunctionWithHessian& theFunction,
                                   const double                               theSpatialTolerance,
                                   const double                               theCriteriumTolerance,
                                   const int                                  theNbIterations,
                                   const double                               theConvexity,
                                   const bool                                 theWithSingularity)
    : math_NewtonMinimum(theFunction,
                         theCriteriumTolerance,
                         theNbIterations,
                         theConvexity,
                         theWithSingularity),
      mySpTol(theSpatialTolerance)
{
}

//=======================================================================
// function : IsConverged
// purpose  : Convert if the steps are too small or if the criterion
//           progresses little with a reasonable step, this last
//           requirement allows detecting infinite slidings
//           (case when the criterion varies troo slowly).
//=======================================================================
bool FairCurve_Newton::IsConverged() const
{
  const double N = TheStep.Norm();
  return (N <= 0.01 * mySpTol)
         || (N <= mySpTol
             && std::abs(TheMinimum - PreviousMinimum) <= XTol * std::abs(PreviousMinimum));
}
