// Copyright (c) 1997-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// #ifndef OCCT_DEBUG
#define No_Standard_RangeError
#define No_Standard_OutOfRange
#define No_Standard_DimensionError

// #endif

#include <math.hxx>
#include <math_ComputeGaussPointsAndWeights.hxx>

int math::GaussPointsMax()
{
  return 61;
}

static const double Point[] = {0.0e+00,
                               0.0e+00,                                 // N = 1
                               0.577350269189625764509148780501958e+00, // N = 2
                               0.774596669241483377035853079956480e+00, // N = 3
                               0.0e+00,
                               0.861136311594052575223946488892810e+00, // N = 4
                               0.339981043584856264802665759103245e+00,
                               0.906179845938663992797626878299393e+00, // N = 5
                               0.538469310105683091036314420700209e+00,
                               0.0e+00,
                               0.932469514203152027812301554493994e+00, // N = 6
                               0.661209386466264513661399595019906e+00,
                               0.238619186083196908630501721680712e+00,
                               0.949107912342758524526189684047851e+00, // N = 7
                               0.741531185599394439863864773280789e+00,
                               0.405845151377397166906606412076961e+00,
                               0.0e+00,
                               0.960289856497536231683560868569472e+00, // N = 8
                               0.796666477413626739591553936475831e+00,
                               0.525532409916328985817739049189246e+00,
                               0.183434642495649804939476142360184e+00,
                               0.968160239507626089835576202903672e+00, // N = 9
                               0.836031107326635794299429788069735e+00,
                               0.613371432700590397308702039341474e+00,
                               0.324253423403808929038538014643337e+00,
                               0.0e+00,
                               0.973906528517171720077964012084452e+00, // N = 10
                               0.865063366688984510732096688423493e+00,
                               0.679409568299024406234327365114874e+00,
                               0.433395394129247190799265943165784e+00,
                               0.148874338981631210884826001129720e+00,
                               0.978228658146056992803938001122856e+00, // N = 11
                               0.887062599768095299075157769303928e+00,
                               0.730152005574049324093416252031154e+00,
                               0.519096129206811815925725669458610e+00,
                               0.269543155952344972331531985400861e+00,
                               0.0e+00,
                               0.981560634246719250690549090149283e+00, // N = 12
                               0.904117256370474856678465866119096e+00,
                               0.769902674194304687036893833212819e+00,
                               0.587317954286617447296702418940535e+00,
                               0.367831498998180193752691536643721e+00,
                               0.125233408511468915472441369463853e+00,
                               0.984183054718588149472829448807119e+00, // N = 13
                               0.917598399222977965206547836500699e+00,
                               0.801578090733309912794206489582858e+00,
                               0.642349339440340220643984606995517e+00,
                               0.448492751036446852877912852127640e+00,
                               0.230458315955134794065528121097989e+00,
                               0.0e+00,
                               0.986283808696812338841597266704064e+00, // N = 14
                               0.928434883663573517336391139377848e+00,
                               0.827201315069764993189794742650405e+00,
                               0.687292904811685470148019803019327e+00,
                               0.515248636358154091965290718551190e+00,
                               0.319112368927889760435671824168475e+00,
                               0.108054948707343662066244650219835e+00,
                               0.987992518020485428489565718586659e+00, // N = 15
                               0.937273392400705904307758947710112e+00,
                               0.848206583410427216200648320774263e+00,
                               0.724417731360170047416186054613928e+00,
                               0.570972172608538847537226737253913e+00,
                               0.394151347077563369897207370981046e+00,
                               0.201194093997434522300628303394596e+00,
                               0.0e+00,
                               0.989400934991649932596154173450404e+00, // N = 16
                               0.944575023073232576077988415534452e+00,
                               0.865631202387831743880467897712467e+00,
                               0.755404408355003033895101194847403e+00,
                               0.617876244402643748446671764048800e+00,
                               0.458016777657227386342419442983577e+00,
                               0.281603550779258913230460501460496e+00,
                               0.950125098376374401853193354249581e-01,
                               0.990575475314417335675434019940707e+00, // N = 17
                               0.950675521768767761222716957895783e+00,
                               0.880239153726985902122955694488141e+00,
                               0.781514003896801406925230055520479e+00,
                               0.657671159216690765850302216643003e+00,
                               0.512690537086476967886246568629553e+00,
                               0.351231763453876315297185517095346e+00,
                               0.178484181495847855850677493654066e+00,
                               0.0e+00,
                               0.991565168420930946730016004706406e+00, // N = 18
                               0.955823949571397755181195892928630e+00,
                               0.892602466497555739206060591127977e+00,
                               0.803704958972523115682417455014383e+00,
                               0.691687043060353207874891081288922e+00,
                               0.559770831073947534607871548525322e+00,
                               0.411751161462842646035931793833052e+00,
                               0.251886225691505509588972854877911e+00,
                               0.847750130417353012422618529357838e-01,
                               0.992406843843584403189017670254354e+00, // N = 19
                               0.960208152134830030852778840685415e+00,
                               0.903155903614817901642660928533756e+00,
                               0.822714656537142824978922486712007e+00,
                               0.720966177335229378617095860824125e+00,
                               0.600545304661681023469638164946193e+00,
                               0.464570741375960945717267148104109e+00,
                               0.316564099963629831990117328849845e+00,
                               0.160358645640225375868096115740744e+00,
                               0.0e+00,
                               0.993128599185094924786122388473126e+00, // N = 20
                               0.963971927277913791267666131192107e+00,
                               0.912234428251325905867752441208091e+00,
                               0.839116971822218823394529061698667e+00,
                               0.746331906460150792614305070356382e+00,
                               0.636053680726515025452836696226146e+00,
                               0.510867001950827098004364050955266e+00,
                               0.373706088715419560672548177024927e+00,
                               0.227785851141645078080496195368575e+00,
                               0.765265211334973337546404093988382e-01,
                               0.993752170620389500260242035940332e+00, // N = 21
                               0.967226838566306294316622214904022e+00,
                               0.920099334150400828790187133718838e+00,
                               0.853363364583317283647250638585182e+00,
                               0.768439963475677908615877851306936e+00,
                               0.667138804197412319305966669990138e+00,
                               0.551618835887219807059018796724313e+00,
                               0.424342120207438783573668888543788e+00,
                               0.288021316802401096600792516064600e+00,
                               0.145561854160895090937030982338686e+00,
                               0.0e+00,
                               0.994294585482399292073031421168066e+00, // N = 22
                               0.970060497835428727123950986748560e+00,
                               0.926956772187174000520692939267243e+00,
                               0.865812577720300136536425637014974e+00,
                               0.787816805979208162004277955410719e+00,
                               0.694487263186682780050689835761995e+00,
                               0.587640403506911592958876927638605e+00,
                               0.469355837986757026406330710966410e+00,
                               0.341935820892084225158147420427379e+00,
                               0.207860426688221285478846533919546e+00,
                               0.697392733197222212138417961186281e-01,
                               0.994769334997552123523925715452405e+00, // N = 23
                               0.972542471218115231956024076799993e+00,
                               0.932971086826016102349196989085222e+00,
                               0.876752358270441667378156885913797e+00,
                               0.804888401618839892151118407002211e+00,
                               0.718661363131950194461624483747842e+00,
                               0.619609875763646156385097311649803e+00,
                               0.509501477846007549689793047866828e+00,
                               0.390301038030290831421488872880605e+00,
                               0.264135680970344930533869538283309e+00,
                               0.133256824298466110931742682241766e+00,
                               0.0e+00,
                               0.995187219997021360179997409695963e+00, // N = 24
                               0.974728555971309498198391993040647e+00,
                               0.938274552002732758523649001703114e+00,
                               0.886415527004401034213154341985133e+00,
                               0.820001985973902921953949872662897e+00,
                               0.740124191578554364243828103101925e+00,
                               0.648093651936975569252495786909868e+00,
                               0.545421471388839535658375617218405e+00,
                               0.433793507626045138487084231913343e+00,
                               0.315042679696163374386793291319810e+00,
                               0.191118867473616309158639820757070e+00,
                               0.640568928626056260850430826247450e-01,
                               0.995556969790498097908784946893469e+00, // N = 25
                               0.976663921459517511498315386374828e+00,
                               0.942974571228974339414011169665041e+00,
                               0.894991997878275368851042006816693e+00,
                               0.833442628760834001421021108670646e+00,
                               0.759259263037357630577282865216328e+00,
                               0.673566368473468364485120633243234e+00,
                               0.577662930241222967723689841613256e+00,
                               0.473002731445714960522182115009143e+00,
                               0.361172305809387837735821730127642e+00,
                               0.243866883720988432045190362797452e+00,
                               0.122864692610710396387359818808037e+00,
                               0.0e+00,
                               0.995885701145616929003216959418519e+00, // N = 26
                               0.978385445956470991100580354051874e+00,
                               0.947159066661714250135915283481245e+00,
                               0.902637861984307074217665599020455e+00,
                               0.845445942788498018797507061452577e+00,
                               0.776385948820678856192967247265337e+00,
                               0.696427260419957264863813913722192e+00,
                               0.606692293017618063231978746918554e+00,
                               0.508440714824505717695703064725394e+00,
                               0.403051755123486306481077377098892e+00,
                               0.292004839485956895142835382077830e+00,
                               0.176858820356890183969057748418345e+00,
                               0.592300934293132070937185751984034e-01,
                               0.996179262888988566938887208663978e+00, // N = 27
                               0.979923475961501222855873354920358e+00,
                               0.950900557814705006851908031700108e+00,
                               0.909482320677491104300645017620528e+00,
                               0.856207908018294490302737222871666e+00,
                               0.791771639070508227144397344046227e+00,
                               0.717013473739423699294816211647746e+00,
                               0.632907971946495140927734637635987e+00,
                               0.540551564579456894900300941559567e+00,
                               0.441148251750026880585974155689329e+00,
                               0.335993903638508899730319034207283e+00,
                               0.226459365439536858857239107360230e+00,
                               0.113972585609529966932894983869977e+00,
                               0.0e+00,
                               0.996442497573954449950436390674007e+00, // N = 28
                               0.981303165370872753694559944854359e+00,
                               0.954259280628938197254101840656842e+00,
                               0.915633026392132073869689422403264e+00,
                               0.865892522574395048942254567705472e+00,
                               0.805641370917179171447885955315246e+00,
                               0.735610878013631772028144510330697e+00,
                               0.656651094038864961219898176506815e+00,
                               0.569720471811401719308003283356526e+00,
                               0.475874224955118261034411847667546e+00,
                               0.376251516089078710221357209556062e+00,
                               0.272061627635178077676826356125771e+00,
                               0.164569282133380771281471777891166e+00,
                               0.550792898840342704265165273418800e-01,
                               0.996679442260596586163191533987124e+00, // N = 29
                               0.982545505261413174870926010927766e+00,
                               0.957285595778087725798208042852482e+00,
                               0.921180232953058785093753432653503e+00,
                               0.874637804920102790417793422545473e+00,
                               0.818185487615252444989572213975722e+00,
                               0.752462851734477133912610077390281e+00,
                               0.678214537602686515156185005352085e+00,
                               0.596281797138227820379586211191379e+00,
                               0.507592955124227642102627919627335e+00,
                               0.413152888174008663890706586031623e+00,
                               0.314031637867639934948195923191050e+00,
                               0.211352286166001074506375728902937e+00,
                               0.106278230132679230170982392430377e+00,
                               0.0e+00,
                               0.996893484074649540271630055317671e+00, // N = 30
                               0.983668123279747209970032570528774e+00,
                               0.960021864968307512216871038176021e+00,
                               0.926200047429274325879324263685316e+00,
                               0.882560535792052681543116468889778e+00,
                               0.829565762382768397442898117701654e+00,
                               0.767777432104826194917977341463632e+00,
                               0.697850494793315796932292387934439e+00,
                               0.620526182989242861140477556432087e+00,
                               0.536624148142019899264169793311055e+00,
                               0.447033769538089176780609900322852e+00,
                               0.352704725530878113471037207089371e+00,
                               0.254636926167889846439805129817806e+00,
                               0.153869913608583546963794672743256e+00,
                               0.514718425553176958330252131667226e-01,
                               0.997087481819477074055626559184650e+00, // N = 31
                               0.984685909665152484002465158219724e+00,
                               0.962503925092949661789052419632531e+00,
                               0.930756997896648164956945747416761e+00,
                               0.889760029948271043374192015019185e+00,
                               0.839920320146267340086904533281437e+00,
                               0.781733148416624940406360021026438e+00,
                               0.715776784586853283905970865155319e+00,
                               0.642706722924260346184418203261165e+00,
                               0.563249161407149262720944923592216e+00,
                               0.478193782044902480440594039356646e+00,
                               0.388385901608232943061351461287458e+00,
                               0.294718069981701616617903897671709e+00,
                               0.198121199335570628772412996032834e+00,
                               0.995553121523415203251747901189407e-01,
                               0.0e+00,
                               0.997263861849481563544981151066702e+00, // N = 32
                               0.985611511545268335400174989274245e+00,
                               0.964762255587506430773812000051285e+00,
                               0.934906075937739689170919084567802e+00,
                               0.896321155766052123965307272525312e+00,
                               0.849367613732569970133692995170930e+00,
                               0.794483795967942406963097301414607e+00,
                               0.732182118740289680387426664868980e+00,
                               0.663044266930215200975115168614811e+00,
                               0.587715757240762329040745476415515e+00,
                               0.506899908932229390023747474377153e+00,
                               0.421351276130635345364119436172526e+00,
                               0.331868602282127649779916805730176e+00,
                               0.239287362252137074544603209165502e+00,
                               0.144471961582796493485186373598811e+00,
                               0.483076656877383162348125704405022e-01,
                               0.997424694246455217266168057363019e+00, // N = 33
                               0.986455726230642488110375576002027e+00,
                               0.966822909689992768928377784220078e+00,
                               0.938694372611168350355835047808460e+00,
                               0.902316767743433583040531371887830e+00,
                               0.858009652676504064643061459435014e+00,
                               0.806162356274166589796200875764785e+00,
                               0.747230496449562157859055125262398e+00,
                               0.681731959969742786268215946711838e+00,
                               0.610242345836379027307287513572929e+00,
                               0.533389904786347643548894264990158e+00,
                               0.451850017272450695725993277240885e+00,
                               0.366339257748073341070220623253855e+00,
                               0.277609097152497029403248067298325e+00,
                               0.186439298827991572335798759218823e+00,
                               0.936310658547333856707429241225377e-01,
                               0.0e+00,
                               0.997571753790841919243372472354684e+00, // N = 34
                               0.987227816406309485049750276055879e+00,
                               0.968708262533344281764646612095310e+00,
                               0.942162397405107091631675938590244e+00,
                               0.907809677718324468800899846638584e+00,
                               0.865934638334564469263572125352058e+00,
                               0.816884227900933664591578886354187e+00,
                               0.761064876629873014187408974381904e+00,
                               0.698939113216262907933000105154353e+00,
                               0.631021727080528545317775755554132e+00,
                               0.557875500669746642736459886196742e+00,
                               0.480106545190327034194102680508252e+00,
                               0.398359277758645940631494752932366e+00,
                               0.313311081339463247458316765650981e+00,
                               0.225666691616449483868641180934347e+00,
                               0.136152357259182975894428824331118e+00,
                               0.455098219531025427490756708519302e-01,
                               0.997706569099600297260163068601969e+00, // N = 35
                               0.987935764443851498035117246119705e+00,
                               0.970437616039229833215070385421235e+00,
                               0.945345148207827329538726062559940e+00,
                               0.912854261359317614464936993689573e+00,
                               0.873219125025222331523282385917057e+00,
                               0.826749899092225406834050580360608e+00,
                               0.773810252286912555267423021824143e+00,
                               0.714814501556628783264408628981906e+00,
                               0.650224364665890388675792808879740e+00,
                               0.580545344749764509934502008212914e+00,
                               0.506322773241488615024297555830838e+00,
                               0.428137541517814254187620613002552e+00,
                               0.346601554430813945876979834930152e+00,
                               0.262352941209296057970895200455586e+00,
                               0.176051061165989569974303656445059e+00,
                               0.883713432756592636009294334975488e-01,
                               0.0e+00,
                               0.997830462484085836198828499668270e+00, // N = 36
                               0.988586478902212238073394890424680e+00,
                               0.972027691049697949335606399404572e+00,
                               0.948272984399507545202473277937562e+00,
                               0.917497774515659066075868287255494e+00,
                               0.879929800890397131982427042693919e+00,
                               0.835847166992475306418820992281084e+00,
                               0.785576230132206512827768932425190e+00,
                               0.729489171593556582090260484147818e+00,
                               0.668001236585521062097191342519143e+00,
                               0.601567658135980535079944975520867e+00,
                               0.530680285926245161640709080064297e+00,
                               0.455863944433420267207217669332683e+00,
                               0.377672547119689216322736389669641e+00,
                               0.296684995344028270503239047745163e+00,
                               0.213500892316865578943226228902714e+00,
                               0.128736103809384788651993388005152e+00,
                               0.430181984737086072269689782283634e-01,
                               0.997944582477913648940802962682757e+00, // N = 37
                               0.989185963214319186684100640799317e+00,
                               0.973493030056485744328890223257303e+00,
                               0.950972343262094821328576499759667e+00,
                               0.921781437412463742668143131089868e+00,
                               0.886124962155486078946149640462293e+00,
                               0.844252987340555967987456380756328e+00,
                               0.796459200509902293393046321552176e+00,
                               0.743078833981965262547047434759654e+00,
                               0.684486309130959357445523205836641e+00,
                               0.621092608408924483148152592597942e+00,
                               0.553342391861581781235098358083604e+00,
                               0.481710877803205554147192868895960e+00,
                               0.406700509318326110100931591612872e+00,
                               0.328837429883706999498471801339985e+00,
                               0.248667792791365758805567751487718e+00,
                               0.166753930239851976968671730411824e+00,
                               0.836704089547699019430483317363992e-01,
                               0.0e+00,
                               0.998049930535687619812846987992053e+00, // N = 38
                               0.989739454266385571944427184549425e+00,
                               0.974846328590153507640884569979646e+00,
                               0.953466330933529595670542153154359e+00,
                               0.925741332048584396825110560639529e+00,
                               0.891855739004632216794935748571609e+00,
                               0.852035021932362188859650175764213e+00,
                               0.806544167605316815551565212410440e+00,
                               0.755685903753970680737738187149712e+00,
                               0.699798680379184355912825816848099e+00,
                               0.639254415829681707180344873289419e+00,
                               0.574456021047807081132927500483698e+00,
                               0.505834717927931103240533716513971e+00,
                               0.433847169432376484373256162517984e+00,
                               0.358972440479435013256717621456562e+00,
                               0.281708809790165261360114071418698e+00,
                               0.202570453892116703203977781514606e+00,
                               0.122084025337867419869612381329407e+00,
                               0.407851479045782399133164323297849e-01,
                               0.998147383066432906005467835672606e+00, // N = 39
                               0.990251536854685983639785745206178e+00,
                               0.976098709333471053844837496021669e+00,
                               0.955775212324652277110903358756271e+00,
                               0.929409148486738229697812287670748e+00,
                               0.897167119292992887848293304361943e+00,
                               0.859252937999906153913796656392845e+00,
                               0.815906297430143104353232829495897e+00,
                               0.767401242931063499832272373900357e+00,
                               0.714044435894534679133867003267531e+00,
                               0.656173213432010910734425938336971e+00,
                               0.594153454957277988692890073931302e+00,
                               0.528377268660437473896343635816299e+00,
                               0.459260512309136048663246633114183e+00,
                               0.387240163971561455853881965636262e+00,
                               0.312771559248185922535996911785674e+00,
                               0.236325512461835767336006327332651e+00,
                               0.158385339997837799922701061361399e+00,
                               0.794438046087554775819170831926406e-01,
                               0.0e+00,
                               0.998237709710559200349619912686075e+00, // N = 40
                               0.990726238699457006453059775040808e+00,
                               0.977259949983774262663372680946589e+00,
                               0.957916819213791655804549152135004e+00,
                               0.932812808278676533360846048743322e+00,
                               0.902098806968874296728256187589215e+00,
                               0.865959503212259503820780965880230e+00,
                               0.824612230833311663196319386395722e+00,
                               0.778305651426519387694971962275149e+00,
                               0.727318255189927103280996392578681e+00,
                               0.671956684614179548379354522018864e+00,
                               0.612553889667980237952612446531931e+00,
                               0.549467125095128202075931305770301e+00,
                               0.483075801686178712908566574236461e+00,
                               0.413779204371605001524879745802697e+00,
                               0.341994090825758473007492481179385e+00,
                               0.268152185007253681141184344808589e+00,
                               0.192697580701371099715516852065149e+00,
                               0.116084070675255208483451284408024e+00,
                               0.387724175060508219331934440246233e-01,
                               0.998321588574771441519208974223705e+00, // N = 41
                               0.991167109699016308250070795872525e+00,
                               0.978338673561083384469244077197344e+00,
                               0.959906891730346226099368138818477e+00,
                               0.935976987497853825682398798945039e+00,
                               0.906685944758101172958298827319234e+00,
                               0.872201511692441408833691024365248e+00,
                               0.832721200401361331244265105957882e+00,
                               0.788471145047409372736223583034500e+00,
                               0.739704803069926181060168419345081e+00,
                               0.686701502034951289584603909723612e+00,
                               0.629764839072196320488649085698196e+00,
                               0.569220941610215869654747216161481e+00,
                               0.505416599199406032708336070154659e+00,
                               0.438717277051407088517119856734970e+00,
                               0.369505022640481441428366913299564e+00,
                               0.298176277341824865922982880478940e+00,
                               0.225139605633422775605786256655470e+00,
                               0.150813354863992163574377967884582e+00,
                               0.756232589891629969237661936512003e-01,
                               0.0e+00,
                               0.998399618990062415022927781463296e+00, // N = 42
                               0.991577288340860919792218766893773e+00,
                               0.979342508063748193709171838251135e+00,
                               0.961759365338204488746722921393144e+00,
                               0.938923557354988178533386869591188e+00,
                               0.910959724904127452583733188528731e+00,
                               0.878020569812172742712023103333721e+00,
                               0.840285983261816900925422245716031e+00,
                               0.797962053255487413232710909263336e+00,
                               0.751279935689480489568470972524974e+00,
                               0.700494590556171213741570111713478e+00,
                               0.645883388869247833957496268800083e+00,
                               0.587744597485109322840711350569167e+00,
                               0.526395749931192287592867558134914e+00,
                               0.462171912070421929759075029987511e+00,
                               0.395423852042975057677093954590322e+00,
                               0.326516124465411512197156589375750e+00,
                               0.255825079342879083966414791018702e+00,
                               0.183736806564854550852755639380743e+00,
                               0.110645027208519868349122545002641e+00,
                               0.369489431653517758130959800375594e-01,
                               0.998472332242507713517763639617892e+00, // N = 43
                               0.991959557593244146420361616318656e+00,
                               0.980278220980255331506013186231257e+00,
                               0.963486613014079993409717513624241e+00,
                               0.941671956847637861818802068415789e+00,
                               0.914947907206138729455924149718517e+00,
                               0.883453765218616863337782686372492e+00,
                               0.847353716209315048999052475209494e+00,
                               0.806835964136938635279083799946392e+00,
                               0.762111747194955121460326198457207e+00,
                               0.713414235268957054851921116939796e+00,
                               0.660997313751498133165134710481425e+00,
                               0.605134259639600935725083076991443e+00,
                               0.546116316660084719140405046318676e+00,
                               0.484251176785734724069633434782990e+00,
                               0.419861376029269252487279394553066e+00,
                               0.353282612864303806645476364143826e+00,
                               0.284861998032913627105722894838309e+00,
                               0.214956244860518209014878381473676e+00,
                               0.143929809510713310770299937610745e+00,
                               0.721529908745862354223272509555611e-01,
                               0.0e+00,
                               0.998540200636774224936355443939961e+00, // N = 44
                               0.992316392138515808482306011875058e+00,
                               0.981151833077913966663437527062428e+00,
                               0.965099650422493139393382794090751e+00,
                               0.944239509118194099203856527684750e+00,
                               0.918675259984175774322769738457655e+00,
                               0.888534238286043202338519476279211e+00,
                               0.853966595004710378728251826956267e+00,
                               0.815144539645135010487459731669594e+00,
                               0.772261479248755899017756368675330e+00,
                               0.725531053660717002606965008108191e+00,
                               0.675186070666122365333698962991269e+00,
                               0.621477345903575847802424682655772e+00,
                               0.564672453185470768424636824115519e+00,
                               0.505054391388202317982798351852400e+00,
                               0.442920174525411483834826593703385e+00,
                               0.378579352014707132511764672767536e+00,
                               0.312352466502785812236545163573171e+00,
                               0.244569456928201251507302434740513e+00,
                               0.175568014775516785746507749380977e+00,
                               0.105691901708653247117305848915122e+00,
                               0.352892369641353590581967046314164e-01,
                               0.998603645181936638156031355247083e+00, // N = 45
                               0.992649998447203741749363742306058e+00,
                               0.981968715034540568237972057759374e+00,
                               0.966608310396894604737431766398516e+00,
                               0.946641690995629061783102829849021e+00,
                               0.922163936719000388098076042261587e+00,
                               0.893291671753241738463891463414798e+00,
                               0.860162475960664225339297568328960e+00,
                               0.822934220502086337035704554816386e+00,
                               0.781784312593906291312379260687177e+00,
                               0.736908848945490352623732483121861e+00,
                               0.688521680771200525232021171270776e+00,
                               0.636853394453223359271223635752016e+00,
                               0.582150212569353186680967364814705e+00,
                               0.524672820462916067091134097288075e+00,
                               0.464695123919635098579601502651652e+00,
                               0.402502943858541914077974508525513e+00,
                               0.338392654250602161643404100032617e+00,
                               0.272669769752377560608765391615597e+00,
                               0.205647489783263745719787225471546e+00,
                               0.137645205983253028756590041423066e+00,
                               0.689869801631441724904146141038117e-01,
                               0.0e+00,
                               0.998663042133817981127427046421504e+00, // N = 46
                               0.992962348906174364078142523089128e+00,
                               0.982733669804166863472876038786077e+00,
                               0.968021391853991942739896665098728e+00,
                               0.948892363446089795618809025660387e+00,
                               0.925433798806753950979356073504075e+00,
                               0.897752711533941965699786051597052e+00,
                               0.865975394866858062916349354759152e+00,
                               0.830246837066066053032193245687497e+00,
                               0.790730057075274255189208695420202e+00,
                               0.747605359615666054000324297221213e+00,
                               0.701069512020405697512125057096471e+00,
                               0.651334846201997715106476748338911e+00,
                               0.598628289712715153177172600332153e+00,
                               0.543190330261802635270962686119799e+00,
                               0.485273918388164662772320194180171e+00,
                               0.425143313282828397322146863395939e+00,
                               0.363072877020995710123706978517266e+00,
                               0.299345822701870015483439256577863e+00,
                               0.234252922206269768626056115573798e+00,
                               0.168091179467103528606796737427702e+00,
                               0.101162475305584239515859657008649e+00,
                               0.337721900160520415195578318914398e-01,
                               0.998718728584212109182415298766244e+00, // N = 47
                               0.993255210987768634696250050789656e+00,
                               0.983451003071623708761548014861543e+00,
                               0.969346787326564497147555194965738e+00,
                               0.951003969257708442587260525593985e+00,
                               0.928502693012360648197752527188528e+00,
                               0.901941329438525356866845665812779e+00,
                               0.871436015796896316941142333462326e+00,
                               0.837120139899902121277753985014452e+00,
                               0.799143754167741942915549087247645e+00,
                               0.757672918445438633574011872922301e+00,
                               0.712888973409064301661875001616419e+00,
                               0.664987747390332729136703621284670e+00,
                               0.614178699956373608595462421641920e+00,
                               0.560684005934664194483058321657156e+00,
                               0.504737583863577919774289023290641e+00,
                               0.446584073104855702725182142531500e+00,
                               0.386477764084667139583302387593268e+00,
                               0.324681486337735902210761299180695e+00,
                               0.261465459214974570306982966205163e+00,
                               0.197106110279111807961491358370503e+00,
                               0.131884866554514897053823530724128e+00,
                               0.660869239163556751604737774741337e-01,
                               0.0e+00,
                               0.998771007252426118605061865434257e+00, // N = 48
                               0.993530172266350757533485837984753e+00,
                               0.984124583722826857767990395796528e+00,
                               0.970591592546247250436936111401991e+00,
                               0.952987703160430860741457183259686e+00,
                               0.931386690706554333100651991637703e+00,
                               0.905879136715569672831101054759270e+00,
                               0.876572020274247885901599188456379e+00,
                               0.843588261624393530712786162293998e+00,
                               0.807066204029442627081977356640102e+00,
                               0.767159032515740339253991454499670e+00,
                               0.724034130923814654674450332164464e+00,
                               0.677872379632663905211855745698417e+00,
                               0.628867396776513623995164326639663e+00,
                               0.577224726083972703817809333348778e+00,
                               0.523160974722233033678225863069105e+00,
                               0.466902904750958404544928862038908e+00,
                               0.408686481990716729916225495782758e+00,
                               0.348755886292160738159817937271552e+00,
                               0.287362487355455576735886461316879e+00,
                               0.224763790394689061224865440174684e+00,
                               0.161222356068891718056437390783498e+00,
                               0.970046992094626989300539558536245e-01,
                               0.323801709628693620333222431521344e-01,
                               0.998820150606635379388377922370521e+00, // N = 49
                               0.993788661944167790661804653715021e+00,
                               0.984757895914213004515964508950160e+00,
                               0.971762200901555380019912518394671e+00,
                               0.954853658674137233653247569568534e+00,
                               0.934100294755810149002284486628813e+00,
                               0.909585655828073285248027792568303e+00,
                               0.881408445573008910020122579228089e+00,
                               0.849682119844165701040456938369208e+00,
                               0.814534427359855431537883516496930e+00,
                               0.776106894345446635018536987637700e+00,
                               0.734554254237402696213588424826837e+00,
                               0.690043824425132113504765771963895e+00,
                               0.642754832419237664056855216227741e+00,
                               0.592877694108900712455864523076351e+00,
                               0.540613246991726066558225452023412e+00,
                               0.486171941452492042176976096809091e+00,
                               0.429772993341576524658584141773770e+00,
                               0.371643501262284888863734540949220e+00,
                               0.312017532119748762207860676505766e+00,
                               0.251135178612577273507155942824625e+00,
                               0.189241592461813586485310173859985e+00,
                               0.126585997269672051067985288575536e+00,
                               0.634206849826867860288348208784850e-01,
                               0.0e+00,
                               0.998866404420071050221644999046981e+00, // N = 50
                               0.994031969432090712513288194570931e+00,
                               0.985354084048005882464660736943510e+00,
                               0.972864385106692073592033244567523e+00,
                               0.956610955242807943085891706150152e+00,
                               0.936656618944877933693444958897581e+00,
                               0.913078556655791893129503150204595e+00,
                               0.885967979523613048619125535861321e+00,
                               0.855429769429946084620206390042546e+00,
                               0.821582070859335948353463508147553e+00,
                               0.784555832900399263905792879898874e+00,
                               0.744494302226068538260429633235185e+00,
                               0.701552468706822251089558191870754e+00,
                               0.655896465685439360781622614603340e+00,
                               0.607702927184950239180381642621237e+00,
                               0.557158304514650054315522973417736e+00,
                               0.504458144907464201651459121545089e+00,
                               0.449806334974038789147131468739551e+00,
                               0.393414311897565127394229253758021e+00,
                               0.335500245419437356836988257294405e+00,
                               0.276288193779531990327645278521138e+00,
                               0.216007236876041756847284532617092e+00,
                               0.154890589998145902071628620941110e+00,
                               0.931747015600861408544503776396003e-01,
                               0.310983383271888761123289896659492e-01,
                               0.998909990848903495224033648428656e+00, // N = 51
                               0.994261260436752574338102605940381e+00,
                               0.985915991735902996976915842059536e+00,
                               0.973903368019323866801093763881690e+00,
                               0.958267848613908194856034517292444e+00,
                               0.939067544002962383207157601720627e+00,
                               0.916373862309780230926378548666742e+00,
                               0.890271218029527303213730721913014e+00,
                               0.860856711182292371484219707914386e+00,
                               0.828239763823064832850725579237874e+00,
                               0.792541712099381205235396753810856e+00,
                               0.753895354485375525763787075691729e+00,
                               0.712444457577036644580542793115430e+00,
                               0.668343221175370086864466445393827e+00,
                               0.621755704600723273755041382116644e+00,
                               0.572855216351303836522394977743941e+00,
                               0.521823669366185842514087749682147e+00,
                               0.468850904286041063610457261750489e+00,
                               0.414133983226303877936871809544767e+00,
                               0.357876456688409509775201088533585e+00,
                               0.300287606335331939530245649643412e+00,
                               0.241581666447798703846733114869309e+00,
                               0.181977026957077545323998701169213e+00,
                               0.121695421018888766963820420963181e+00,
                               0.609611001505787247341947068432054e-01,
                               0.0e+00,
                               0.998951111103950278018054699838196e+00, // N = 52
                               0.994477590929216029684977516364457e+00,
                               0.986446195651549840513947880332682e+00,
                               0.974883884221744503438240575583190e+00,
                               0.959831826933086552445972636330204e+00,
                               0.941343853641359056710370283652786e+00,
                               0.919486128916424539944189548698567e+00,
                               0.894336890534495322515084505254327e+00,
                               0.865986162846067585261432981503674e+00,
                               0.834535432326734534963584819431080e+00,
                               0.800097283430468324334317675212598e+00,
                               0.762794995193744960279552606289236e+00,
                               0.722762099749983193676624685627976e+00,
                               0.680141904227167702092262345384622e+00,
                               0.635086977695245924298119668638400e+00,
                               0.587758604979579069902026675609997e+00,
                               0.538326209285827438375951068446420e+00,
                               0.486966745698096077782458249861024e+00,
                               0.433864067718761670309086567803508e+00,
                               0.379208269116093669246681766973017e+00,
                               0.323195003434807825501099066597845e+00,
                               0.266024783605001827472971730599104e+00,
                               0.207902264156366059686466128122335e+00,
                               0.149035508606949180488634040018114e+00,
                               0.896352446489005654888546911223992e-01,
                               0.299141097973387660436807760707999e-01,
                               0.998989947776328227308717791212126e+00, // N = 53
                               0.994681919308007078528606558174079e+00,
                               0.986947035023371521606448472303821e+00,
                               0.975810233714984582070103795268821e+00,
                               0.961309694623136332403443517217904e+00,
                               0.943495353464441879066821072026308e+00,
                               0.922428603042812128061445320035148e+00,
                               0.898182057875426625967237715458832e+00,
                               0.870839297558241351480432015469135e+00,
                               0.840494576545801375449789702087003e+00,
                               0.807252498416895478215250648050254e+00,
                               0.771227654925532307867136138137129e+00,
                               0.732544230807510253781699199233659e+00,
                               0.691335575601366723540834286889109e+00,
                               0.647743743916510068751092141287791e+00,
                               0.601919005713769327464295798295608e+00,
                               0.554019328277067881014734994473705e+00,
                               0.504209831657133437039116948768307e+00,
                               0.452662219461845791383144763582231e+00,
                               0.399554186953952977392563135999796e+00,
                               0.345068808495722356694310646077604e+00,
                               0.289393906451626206426547006593388e+00,
                               0.232721403724272593643363642199913e+00,
                               0.175246662155325750729791009132899e+00,
                               0.117167809071955150140256808779324e+00,
                               0.586850543002594650227119458332315e-01,
                               0.0e+00,
                               0.999026666867340983960600738628587e+00, // N = 54
                               0.994875117018338883775009093857024e+00,
                               0.987420637397343557973919278665868e+00,
                               0.976686328857903238311316464892393e+00,
                               0.962707645785923581151668047530001e+00,
                               0.945530975164995855172690141891805e+00,
                               0.925213359866651486227528234023990e+00,
                               0.901822286284701580784300839998063e+00,
                               0.875435454065568939184779288843327e+00,
                               0.846140515970772949431093530994647e+00,
                               0.814034785913567835453741271723255e+00,
                               0.779224915346254021541712528523965e+00,
                               0.741826538809184316284297613747209e+00,
                               0.701963889719172919385857342339648e+00,
                               0.659769387631983124692249575331223e+00,
                               0.615383198331127370729942640361260e+00,
                               0.568952768195209429731624518247519e+00,
                               0.520632334385933073327017180610482e+00,
                               0.470582412481382283683212143766264e+00,
                               0.418969263255204528036102697110816e+00,
                               0.365964340372191181984332108207166e+00,
                               0.311743720834468228882550390148026e+00,
                               0.256487520069997300077411214453172e+00,
                               0.200379293606213569778602462829285e+00,
                               0.143605427316256153947089762898790e+00,
                               0.863545182632482152854431777687496e-01,
                               0.288167481993417776562358475002271e-01,
                               0.999061419564818541226167774833173e+00, // N = 55
                               0.995057977847411877913032918602278e+00,
                               0.987868941198889192607043771506083e+00,
                               0.977515735503989211682648848405394e+00,
                               0.964031328593135192583226925656829e+00,
                               0.947458868041210743426703762384094e+00,
                               0.927851424720791693935995813424644e+00,
                               0.905271800744000027896859089109014e+00,
                               0.879792322419895505895168143496562e+00,
                               0.851494606617154471801946684813854e+00,
                               0.820469298559320912382366530312199e+00,
                               0.786815781127622365927101731712568e+00,
                               0.750641856348021908669593465267489e+00,
                               0.712063399986637838911033245145076e+00,
                               0.671203990319826395796089591318945e+00,
                               0.628194512249928140090660061053824e+00,
                               0.583172738026032102974303596733496e+00,
                               0.536282885908343296720599396946771e+00,
                               0.487675158187474097208263700182115e+00,
                               0.437505260037174591808481022197924e+00,
                               0.385933900740979429755848544098330e+00,
                               0.333126278890023885189471490218123e+00,
                               0.279251553200806538549862451176431e+00,
                               0.224482300647845483400189062402906e+00,
                               0.168993963646873208282842493511703e+00,
                               0.112964288059329266588437923888712e+00,
                               0.565727538183367763273376108931084e-01,
                               0.0e+00,
                               0.999094343801465585752843252460937e+00, // N = 56
                               0.995231226081069747987788275896544e+00,
                               0.988293715540161499600551128237394e+00,
                               0.978301709140256393942146980189338e+00,
                               0.965285901905490181071368349173363e+00,
                               0.949286479561962637900927761747548e+00,
                               0.930352880247496298605517576768188e+00,
                               0.908543620420655494331463136763581e+00,
                               0.883926108327827539709415300466113e+00,
                               0.856576433762748635992662052796269e+00,
                               0.826579132142881651459993328593579e+00,
                               0.794026922893866498085283636698268e+00,
                               0.759020422705128902190324418393661e+00,
                               0.721667834450188083526380135160209e+00,
                               0.682084612694470455501089126837094e+00,
                               0.640393106807006894268020252733450e+00,
                               0.596722182770663320104126651392904e+00,
                               0.551206824855534618754364367180926e+00,
                               0.503987718384381714195224248753744e+00,
                               0.455210814878459578948831595075495e+00,
                               0.405026880927091278118866961613668e+00,
                               0.353591032174954520969707327121873e+00,
                               0.301062253867220669053094233119869e+00,
                               0.247602909434337203972966554970932e+00,
                               0.193378238635275258240184723012659e+00,
                               0.138555846810376242012886580438492e+00,
                               0.833051868224353744402873554406624e-01,
                               0.277970352872754370940611967749205e-01,
                               0.999125565625262853047052586618274e+00, // N = 57
                               0.995395523678430309571007530945854e+00,
                               0.988696577650222058093291260155730e+00,
                               0.979047226709468710028855773441576e+00,
                               0.966476085171886675206260428648027e+00,
                               0.951020626447876751760081781501095e+00,
                               0.932726961067101693313768901958825e+00,
                               0.911649678521391216634801712415464e+00,
                               0.887851678882221326547729121167007e+00,
                               0.861403983262046944910565372183161e+00,
                               0.832385521150439120956435312702651e+00,
                               0.800882894547218242157003200042812e+00,
                               0.766990119359450195497563539840781e+00,
                               0.730808344744523322826905682560977e+00,
                               0.692445551199517739040646304470458e+00,
                               0.652016228280976891249368792302575e+00,
                               0.609641032908715365423855156086652e+00,
                               0.565446429269236759018985275962419e+00,
                               0.519564311391187606315153809436177e+00,
                               0.472131609517975709588060095348867e+00,
                               0.423289881451563950960024350669576e+00,
                               0.373184890086594458552134396251712e+00,
                               0.321966168395378640590207915796013e+00,
                               0.269786573161838765763345609800213e+00,
                               0.216801828796124036413613975979514e+00,
                               0.163170062591264251043280378321515e+00,
                               0.109051332808787800978526521310979e+00,
                               0.546071510016468242198305597373324e-01,
                               0.0e+00,
                               0.999155200407386632100251389048275e+00, // N = 58
                               0.995551476597290867571702540506380e+00,
                               0.989079008248442726803193205098877e+00,
                               0.979755014694350216706933313565414e+00,
                               0.967606202502924107423539738734020e+00,
                               0.952667557518869048757370801891805e+00,
                               0.934982137588259375374807917856005e+00,
                               0.914600928564352547452654336836524e+00,
                               0.891582692022030175339987617264199e+00,
                               0.865993794074807480347599878281901e+00,
                               0.837908013339373315981495773451357e+00,
                               0.807406327913088141428533979896158e+00,
                               0.774576681749652745172901784637459e+00,
                               0.739513731020042267867800226405069e+00,
                               0.702318571153908113474795784186639e+00,
                               0.663098445332125266433888930045430e+00,
                               0.621966435263079111033895970056397e+00,
                               0.579041135130225030489993237012348e+00,
                               0.534446309648847586399801286057781e+00,
                               0.488310537216718463615552644198239e+00,
                               0.440766839186839565193703058212541e+00,
                               0.391952296330753150371216941733927e+00,
                               0.342007653597995261248368267464475e+00,
                               0.291076914311109189533025268314528e+00,
                               0.239306924966153454428948509085552e+00,
                               0.186846951835761321374383881464019e+00,
                               0.133848250595466857022376847874542e+00,
                               0.804636302141427293098477923805032e-01,
                               0.268470123659423558033386895173800e-01,
                               0.999183353909294667205643068296996e+00, // N = 59
                               0.995699640383246036770413301974902e+00,
                               0.989442365133730846475898804788999e+00,
                               0.980427573956715736395688090400227e+00,
                               0.968680221681781276638192932260919e+00,
                               0.954233009376951119396793711348349e+00,
                               0.937126190353453860057655556210748e+00,
                               0.917407438788155306439449998259614e+00,
                               0.895131711743472079740397219725958e+00,
                               0.870361094292882260095209617544676e+00,
                               0.843164625816872200475346743480618e+00,
                               0.813618107288211571267677317694980e+00,
                               0.781803889862360905697315286202025e+00,
                               0.747810645278640231881518298098034e+00,
                               0.711733118677197731596627763229656e+00,
                               0.673671864504937227022507697048220e+00,
                               0.633732966238850097512836105433795e+00,
                               0.592027740704030144464136877018302e+00,
                               0.548672427808396384372261769039267e+00,
                               0.503787866557717978768086422389926e+00,
                               0.457499158253266690226215335874941e+00,
                               0.409935317810418966722823687397087e+00,
                               0.361228914169794809992312452701368e+00,
                               0.311515700803013700318360149087415e+00,
                               0.260934237342811711610616267415249e+00,
                               0.209625503392036544923366790631453e+00,
                               0.157732505587857968115217856271556e+00,
                               0.105399879016344143836914387761869e+00,
                               0.527734840883100039516803286033385e-01,
                               0.0e+00,
                               0.999210123227435862070008493811879e+00, // N = 60
                               0.995840525118838493161148614181831e+00,
                               0.989787895222221271450482647400812e+00,
                               0.981067201752599008939885831067381e+00,
                               0.969701788765052248615160049552028e+00,
                               0.955722255839996509135760625432896e+00,
                               0.939166276116422948124242613231917e+00,
                               0.920078476177627688588783024338264e+00,
                               0.898510310810045898328277872176401e+00,
                               0.874519922646898344644990343709189e+00,
                               0.848171984785929627768557743110825e+00,
                               0.819537526162145759257030139576634e+00,
                               0.788693739932264054658845269983062e+00,
                               0.755723775306585686849000838727920e+00,
                               0.720716513355730399465937730737008e+00,
                               0.683766327381355437214531572791347e+00,
                               0.644972828489477067814990715855943e+00,
                               0.604440597048510363444040497186835e+00,
                               0.562278900753944539178290960157120e+00,
                               0.518601400058569747417888018230881e+00,
                               0.473525841761707111108163217027638e+00,
                               0.427173741583078389307452839032456e+00,
                               0.379670056576797977154952671049762e+00,
                               0.331142848268448194252352965359391e+00,
                               0.281722937423261691690694860338387e+00,
                               0.231543551376029338010344631347002e+00,
                               0.180739964873425417240876941261828e+00,
                               0.129449135396945003146444164649577e+00,
                               0.778093339495365694192855070822253e-01,
                               0.259597723012477985891703854003448e-01,
                               0.999235597631363693039497410657766e+00, // N = 61
                               0.995974599815119342263598364501092e+00,
                               0.990116745232519013636920116523524e+00,
                               0.981676011284034567431767468750177e+00,
                               0.970674258833184712990754217961157e+00,
                               0.957140151912982705966175662483687e+00,
                               0.941108986681361549300197756536372e+00,
                               0.922622581382954797720565952303437e+00,
                               0.901729162474001419858887789619907e+00,
                               0.878483237214880895287229014520398e+00,
                               0.852945450847663489990814389171189e+00,
                               0.825182428108659939301652112000031e+00,
                               0.795266599282359652947553914700569e+00,
                               0.763276011172312195999923999232898e+00,
                               0.729294123449465109938543089998003e+00,
                               0.693409590894491155459373831275755e+00,
                               0.655716032095070871706527268032628e+00,
                               0.616311785197921724708389601544512e+00,
                               0.575299651350830618600472826084821e+00,
                               0.532786626502925265638471578622534e+00,
                               0.488883622262252118820699181845782e+00,
                               0.443705176538531601995589259889052e+00,
                               0.397369154725756609178291851404222e+00,
                               0.349996442204066834533434476861401e+00,
                               0.301710628963030712604486525466729e+00,
                               0.252637687169053495833690863334470e+00,
                               0.202905642518058499226947203343037e+00,
                               0.152644240230815300529506761773480e+00,
                               0.101984606562274068957208404764366e+00,
                               0.510589067079743493668875006189008e-01,
                               0.0e+00};

static const double Weight[] = {0.0e+00,
                                0.200000000000000000000000000000000e+01, // N = 1
                                0.100000000000000000000000000000000e+01, // N = 2
                                0.555555555555555555555555555555555e+00, // N = 3
                                0.888888888888888888888888888888889e+00,
                                0.347854845137453857373063949221999e+00, // N = 4
                                0.652145154862546142626936050778001e+00,
                                0.236926885056189087514264040719917e+00, // N = 5
                                0.478628670499366468041291514835638e+00,
                                0.568888888888888888888888888888889e+00,
                                0.171324492379170345040296142172733e+00, // N = 6
                                0.360761573048138607569833513837716e+00,
                                0.467913934572691047389870343989551e+00,
                                0.129484966168869693270611432679083e+00, // N = 7
                                0.279705391489276667901467771423778e+00,
                                0.381830050505118944950369775488978e+00,
                                0.417959183673469387755102040816324e+00,
                                0.101228536290376259152531354309963e+00, // N = 8
                                0.222381034453374470544355994426239e+00,
                                0.313706645877887287337962201986603e+00,
                                0.362683783378361982965150449277195e+00,
                                0.812743883615744119718921581105244e-01, // N = 9
                                0.180648160694857404058472031242912e+00,
                                0.260610696402935462318742869418636e+00,
                                0.312347077040002840068630406584444e+00,
                                0.330239355001259763164525069286978e+00,
                                0.666713443086881375935688098933317e-01, // N = 10
                                0.149451349150580593145776339657693e+00,
                                0.219086362515982043995534934228166e+00,
                                0.269266719309996355091226921569470e+00,
                                0.295524224714752870173892994651339e+00,
                                0.556685671161736664827537204425497e-01, // N = 11
                                0.125580369464904624634694299223937e+00,
                                0.186290210927734251426097641431661e+00,
                                0.233193764591990479918523704843169e+00,
                                0.262804544510246662180688869890515e+00,
                                0.272925086777900630714483528336339e+00,
                                0.471753363865118271946159614850133e-01, // N = 12
                                0.106939325995318430960254718194013e+00,
                                0.160078328543346226334652529543347e+00,
                                0.203167426723065921749064455809812e+00,
                                0.233492536538354808760849898924877e+00,
                                0.249147045813402785000562436042951e+00,
                                0.404840047653158795200215922009913e-01, // N = 13
                                0.921214998377284479144217759538088e-01,
                                0.138873510219787238463601776868882e+00,
                                0.178145980761945738280046691996084e+00,
                                0.207816047536888502312523219306048e+00,
                                0.226283180262897238412090186039811e+00,
                                0.232551553230873910194589515268787e+00,
                                0.351194603317518630318328761381690e-01, // N = 14
                                0.801580871597602098056332770628825e-01,
                                0.121518570687903184689414809072460e+00,
                                0.157203167158193534569601938623896e+00,
                                0.185538397477937813741716590125112e+00,
                                0.205198463721295603965924065661222e+00,
                                0.215263853463157790195876443316267e+00,
                                0.307532419961172683546283935771943e-01, // N = 15
                                0.703660474881081247092674164506892e-01,
                                0.107159220467171935011869546685734e+00,
                                0.139570677926154314447804794511208e+00,
                                0.166269205816993933553200860480891e+00,
                                0.186161000015562211026800561866565e+00,
                                0.198431485327111576456118326443407e+00,
                                0.202578241925561272880620199967656e+00,
                                0.271524594117540948517805724560368e-01, // N = 16
                                0.622535239386478928628438369945628e-01,
                                0.951585116824927848099251076018181e-01,
                                0.124628971255533872052476282192097e+00,
                                0.149595988816576732081501730547117e+00,
                                0.169156519395002538189312079030817e+00,
                                0.182603415044923588866763667969201e+00,
                                0.189450610455068496285396723208291e+00,
                                0.241483028685479319601100262874223e-01, // N = 17
                                0.554595293739872011294401653581783e-01,
                                0.850361483171791808835353701908650e-01,
                                0.111883847193403971094788385627117e+00,
                                0.135136368468525473286319981701965e+00,
                                0.154045761076810288081431594801964e+00,
                                0.168004102156450044509970663788286e+00,
                                0.176562705366992646325270990114256e+00,
                                0.179446470356206525458265644261812e+00,
                                0.216160135264833103133427102655130e-01, // N = 18
                                0.497145488949697964533349462010895e-01,
                                0.764257302548890565291296776163320e-01,
                                0.100942044106287165562813984928046e+00,
                                0.122555206711478460184519126798015e+00,
                                0.140642914670650651204731303753862e+00,
                                0.154684675126265244925418003835190e+00,
                                0.164276483745832722986053776466578e+00,
                                0.169142382963143591840656470134736e+00,
                                0.194617882297264770363120414644793e-01, // N = 19
                                0.448142267656996003328381574039431e-01,
                                0.690445427376412265807082579987094e-01,
                                0.914900216224499994644620941319334e-01,
                                0.111566645547333994716023901674946e+00,
                                0.128753962539336227675515784862361e+00,
                                0.142606702173606611775746109431414e+00,
                                0.152766042065859666778855400902497e+00,
                                0.158968843393954347649956439460513e+00,
                                0.161054449848783695979163625324809e+00,
                                0.176140071391521183118619623491302e-01, // N = 20
                                0.406014298003869413310399522706322e-01,
                                0.626720483341090635695065351819669e-01,
                                0.832767415767047487247581432329156e-01,
                                0.101930119817240435036750135466348e+00,
                                0.118194531961518417312377377718604e+00,
                                0.131688638449176626898494499748159e+00,
                                0.142096109318382051329298325072027e+00,
                                0.149172986472603746787828736999336e+00,
                                0.152753387130725850698084331956079e+00,
                                0.160172282577743333242246168579398e-01, // N = 21
                                0.369537897708524937999506683027812e-01,
                                0.571344254268572082836358264526385e-01,
                                0.761001136283793020170516533126966e-01,
                                0.934444234560338615532897410907539e-01,
                                0.108797299167148377663474578081143e+00,
                                0.121831416053728534195367177105957e+00,
                                0.132268938633337461781052574507564e+00,
                                0.139887394791073154722133423860591e+00,
                                0.144524403989970059063827166570068e+00,
                                0.146081133649690427191985147672526e+00,
                                0.146279952982722006849910980409279e-01, // N = 22
                                0.337749015848141547933022468735675e-01,
                                0.522933351526832859403120512609446e-01,
                                0.697964684245204880949614189253340e-01,
                                0.859416062170677274144436813628141e-01,
                                0.100414144442880964932078837856422e+00,
                                0.112932296080539218393400607417128e+00,
                                0.123252376810512424285560986159639e+00,
                                0.131173504787062370732964992516422e+00,
                                0.136541498346015171352573831229592e+00,
                                0.139251872855631993375410248339356e+00,
                                0.134118594871417720813094934295282e-01, // N = 23
                                0.309880058569794443106942196749048e-01,
                                0.480376717310846685716410715037491e-01,
                                0.642324214085258521271696153694344e-01,
                                0.792814117767189549228925246444880e-01,
                                0.929157660600351474770186174421938e-01,
                                0.104892091464541410074086184918183e+00,
                                0.114996640222411364941643512970691e+00,
                                0.123049084306729530467578400635032e+00,
                                0.128905722188082149978595339377180e+00,
                                0.132462039404696617371642464587308e+00,
                                0.133654572186106175351457110560180e+00,
                                0.123412297999871995468056670241292e-01, // N = 24
                                0.285313886289336631813078161424755e-01,
                                0.442774388174198061686027483473371e-01,
                                0.592985849154367807463677585232428e-01,
                                0.733464814110803057340336151500117e-01,
                                0.861901615319532759171852029475615e-01,
                                0.976186521041138882698806644404639e-01,
                                0.107444270115965634782577342387576e+00,
                                0.115505668053725601353344483876487e+00,
                                0.121670472927803391204463153443133e+00,
                                0.125837456346828296121375382504667e+00,
                                0.127938195346752156974056165213338e+00,
                                0.113937985010262879479029641285760e-01, // N = 25
                                0.263549866150321372619018153849308e-01,
                                0.409391567013063126556234878061658e-01,
                                0.549046959758351919259368913429170e-01,
                                0.680383338123569172071871854580119e-01,
                                0.801407003350010180132349597253873e-01,
                                0.910282619829636498114972206076789e-01,
                                0.100535949067050644202206890357531e+00,
                                0.108519624474263653116093957004116e+00,
                                0.114858259145711648339325546015923e+00,
                                0.119455763535784772228178126428148e+00,
                                0.122242442990310041688959518496597e+00,
                                0.123176053726715451203902872852701e+00,
                                0.105513726173430071556511877104122e-01, // N = 26
                                0.244178510926319087896158276999699e-01,
                                0.379623832943627639503031403683517e-01,
                                0.509758252971478119983199014950844e-01,
                                0.632740463295748355394536886745920e-01,
                                0.746841497656597458870757954790540e-01,
                                0.850458943134852392104477650671504e-01,
                                0.942138003559141484636648834149007e-01,
                                0.102059161094425423238414070130089e+00,
                                0.108471840528576590656579427177621e+00,
                                0.113361816546319666549440718687763e+00,
                                0.116660443485296582044662507678498e+00,
                                0.118321415279262276516371085754385e+00,
                                0.979899605129436026115005491579836e-02, // N = 27
                                0.226862315961806231960342068377974e-01,
                                0.352970537574197110225782887373276e-01,
                                0.474494125206150627040967109638731e-01,
                                0.589835368598335991103008321613220e-01,
                                0.697488237662455929843228905700173e-01,
                                0.796048677730577712630749569057360e-01,
                                0.884231585437569501943228042686763e-01,
                                0.960887273700285075656526456436726e-01,
                                0.102501637817745798671247711893808e+00,
                                0.107578285788533187212162982779084e+00,
                                0.111252488356845192672163097383528e+00,
                                0.113476346108965148620369947144452e+00,
                                0.114220867378956989045045738642052e+00,
                                0.912428259309451773881615569631855e-02, // N = 28
                                0.211321125927712597515003812942859e-01,
                                0.329014277823043799776308250272362e-01,
                                0.442729347590042278395878813243135e-01,
                                0.551073456757167454314829123943426e-01,
                                0.652729239669995957933975656147100e-01,
                                0.746462142345687790239318849300299e-01,
                                0.831134172289012183903964990431992e-01,
                                0.905717443930328409421860308063307e-01,
                                0.969306579979299158504890075865571e-01,
                                0.102112967578060769814216637758528e+00,
                                0.106055765922846417910416436445329e+00,
                                0.108711192258294135253571519592793e+00,
                                0.110047013016475196282376265548836e+00,
                                0.851690387874640965426381577347572e-02, // N = 29
                                0.197320850561227059838597996078192e-01,
                                0.307404922020936226444085265013693e-01,
                                0.414020625186828361048300262229884e-01,
                                0.515948269024979239125943704172896e-01,
                                0.612030906570791385421098602186590e-01,
                                0.701179332550512785695814722557421e-01,
                                0.782383271357637838281448972399983e-01,
                                0.854722573661725275453448395871070e-01,
                                0.917377571392587633479664164699553e-01,
                                0.969638340944086063019000669506585e-01,
                                0.101091273759914966121820571365711e+00,
                                0.104073310077729373913328459501218e+00,
                                0.105876155097320941406591333879246e+00,
                                0.106479381718314244246511117763216e+00,
                                0.796819249616660561546588320979440e-02, // N = 30
                                0.184664683110909591423021417545798e-01,
                                0.287847078833233693497191334338105e-01,
                                0.387991925696270495968019675782981e-01,
                                0.484026728305940529029380877991328e-01,
                                0.574931562176190664817217211374840e-01,
                                0.659742298821804951281285021811915e-01,
                                0.737559747377052062682438639500205e-01,
                                0.807558952294202153546949312507312e-01,
                                0.868997872010829798023875393459500e-01,
                                0.921225222377861287176326950378307e-01,
                                0.963687371746442596394686287290119e-01,
                                0.995934205867952670627802782841594e-01,
                                0.101762389748405504596428957296642e+00,
                                0.102852652893558840341285636117340e+00,
                                0.747083157924877585869687724099065e-02, // N = 31
                                0.173186207903105824631580131765678e-01,
                                0.270090191849794218006086595184583e-01,
                                0.364322739123854640243921219453832e-01,
                                0.454937075272011029023157967071035e-01,
                                0.541030824249168537116662949074201e-01,
                                0.621747865610284269103434659239060e-01,
                                0.696285832354103661677561766299470e-01,
                                0.763903865987766164263576828237694e-01,
                                0.823929917615892639038233996447944e-01,
                                0.875767406084778761261980322803715e-01,
                                0.918901138936414782153629019034390e-01,
                                0.952902429123195128072042280005919e-01,
                                0.977433353863287250934740272289929e-01,
                                0.992250112266723078748754708406477e-01,
                                0.997205447934264514275338784839920e-01,
                                0.701861000947009660040713138619486e-02, // N = 32
                                0.162743947309056706051705049405647e-01,
                                0.253920653092620594557524998697045e-01,
                                0.342738629130214331026878628853265e-01,
                                0.428358980222266806568785625642849e-01,
                                0.509980592623761761961633753381200e-01,
                                0.586840934785355471452834724909903e-01,
                                0.658222227763618468376501454904681e-01,
                                0.723457941088485062253992440937225e-01,
                                0.781938957870703064717410114205194e-01,
                                0.833119242269467552221989835884973e-01,
                                0.876520930044038111427715633570701e-01,
                                0.911738786957638847128685539410870e-01,
                                0.938443990808045656391802300089055e-01,
                                0.956387200792748594190819835027716e-01,
                                0.965400885147278005667648306528438e-01,
                                0.660622784758737805864922877032642e-02, // N = 33
                                0.153217015129346761279457699345655e-01,
                                0.239155481017494803505328778505850e-01,
                                0.323003586323289532815615102104468e-01,
                                0.404015413316695915634093067002850e-01,
                                0.481477428187116956701472176098583e-01,
                                0.554708466316635612849440094479191e-01,
                                0.623064825303174800316279007854007e-01,
                                0.685945728186567128059549594976362e-01,
                                0.742798548439541493424721583967375e-01,
                                0.793123647948867383639082229650415e-01,
                                0.836478760670387076139281584870639e-01,
                                0.872482876188443376072816466707219e-01,
                                0.900819586606385772397440656587539e-01,
                                0.921239866433168462132407122899904e-01,
                                0.933564260655961161609991257678634e-01,
                                0.937684461602099965673045293923944e-01,
                                0.622914055590868471860637566866174e-02, // N = 34
                                0.144501627485950354152009896359124e-01,
                                0.225637219854949700840939054778768e-01,
                                0.304913806384461318094427429868726e-01,
                                0.381665937963875163217654285664198e-01,
                                0.455256115233532724538225886938685e-01,
                                0.525074145726781061682465130210517e-01,
                                0.590541358275244931939610038625709e-01,
                                0.651115215540764113785448590388010e-01,
                                0.706293758142557249990390436899042e-01,
                                0.755619746600319312708340588066969e-01,
                                0.798684443397718447388186740901156e-01,
                                0.835130996998456551870202301621027e-01,
                                0.864657397470357497842467160803940e-01,
                                0.887018978356938692870764646651528e-01,
                                0.902030443706407295739421994186261e-01,
                                0.909567403302598736153376232912413e-01,
                                0.588343342044308497575394315283040e-02, // N = 35
                                0.136508283483614922664043342489063e-01,
                                0.213229799114835808834381716542737e-01,
                                0.288292601088942540487152733461378e-01,
                                0.361101158634633805327183978252812e-01,
                                0.431084223261702187823070359497274e-01,
                                0.497693704013535298051999699259647e-01,
                                0.560408162123701285783277091891905e-01,
                                0.618736719660801888870137944366278e-01,
                                0.672222852690869039643056733370462e-01,
                                0.720447947725600646654621467061200e-01,
                                0.763034571554420535386588459730511e-01,
                                0.799649422423242629326628121726383e-01,
                                0.830005937288565883799264208370588e-01,
                                0.853866533920991252259436672251274e-01,
                                0.871044469971835342433215048001668e-01,
                                0.881405304302754629707399355550232e-01,
                                0.884867949071042906382070005983414e-01,
                                0.556571966424504536125579260204086e-02, // N = 36
                                0.129159472840655744045072673326750e-01,
                                0.201815152977354715320927002754055e-01,
                                0.272986214985687790944198123801949e-01,
                                0.342138107703072299212416121536277e-01,
                                0.408757509236448954741132294083114e-01,
                                0.472350834902659784166141564033446e-01,
                                0.532447139777599190920283623401153e-01,
                                0.588601442453248173096729710098699e-01,
                                0.640397973550154895563852212861955e-01,
                                0.687453238357364426136897547484451e-01,
                                0.729418850056530613538736418755875e-01,
                                0.765984106458706745287581499737530e-01,
                                0.796878289120716019087254535846620e-01,
                                0.821872667043397095172231121156339e-01,
                                0.840782189796619349334581192102230e-01,
                                0.853466857393386274918504399709375e-01,
                                0.859832756703947474900850736892054e-01,
                                0.527305727949793935172120296846413e-02, // N = 37
                                0.122387801003075565263037796234417e-01,
                                0.191290444890839660435089980042715e-01,
                                0.258860369905589335227547710993802e-01,
                                0.324616398475214810672384195936448e-01,
                                0.388096025019345444889564332644499e-01,
                                0.448853646624371666574093504318489e-01,
                                0.506462976548246016038747992579043e-01,
                                0.560519879982749178085412831679986e-01,
                                0.610645165232259861309883138115698e-01,
                                0.656487228727512494840274587897768e-01,
                                0.697724515557003448850801367999320e-01,
                                0.734067772484881727246224102940733e-01,
                                0.765262075705292378858920668768501e-01,
                                0.791088618375293807671991171762515e-01,
                                0.811366245084650305098821274394437e-01,
                                0.825952722364372508912355821254682e-01,
                                0.834745736258627872522587327112268e-01,
                                0.837683609931389047970120750514186e-01,
                                0.500288074963934567590309956852149e-02, // N = 38
                                0.116134447164686741776836569482318e-01,
                                0.181565777096132368988901530206269e-01,
                                0.245797397382323758952263713380185e-01,
                                0.308395005451750546587452031620245e-01,
                                0.368940815940247381649360656714863e-01,
                                0.427031585046744342358668987964580e-01,
                                0.482280618607586833743486085881141e-01,
                                0.534320199103323199737476194657398e-01,
                                0.582803991469972060223085829895579e-01,
                                0.627409333921330540529606267321689e-01,
                                0.667839379791404119350464003530889e-01,
                                0.703825070668989547392868130219115e-01,
                                0.735126925847434571452095691532865e-01,
                                0.761536635484463960659894510856273e-01,
                                0.782878446582109480753799305149081e-01,
                                0.799010332435278215860273758642986e-01,
                                0.809824937705971006232679716771238e-01,
                                0.815250292803857866992189289704692e-01,
                                0.475294469163510137077675042087210e-02, // N = 39
                                0.110347889391645942426517991847001e-01,
                                0.172562290937249190408182314077432e-01,
                                0.233693848321781645946794838363440e-01,
                                0.293349559839033785922222175997544e-01,
                                0.351151114981313307610193904406787e-01,
                                0.406732768479338439390883512150343e-01,
                                0.459743011089166318841449405362516e-01,
                                0.509846652921294052140690848096193e-01,
                                0.556726903409162999073374707336450e-01,
                                0.600087360885961495749664671970510e-01,
                                0.639653881386823889866938650319631e-01,
                                0.675176309662312653630260693196325e-01,
                                0.706430059706087607701032020461776e-01,
                                0.733217534142686173811548189969739e-01,
                                0.755369373228360577047663382744344e-01,
                                0.772745525446820167285397935609001e-01,
                                0.785236132873711767250522140644442e-01,
                                0.792762225683684710101498006273823e-01,
                                0.795276221394428524173872204443145e-01,
                                0.452127709853319125848508507294927e-02, // N = 40
                                0.104982845311528136146364668266440e-01,
                                0.164210583819078887127423380858061e-01,
                                0.222458491941669572614516733163778e-01,
                                0.279370069800234010983476020081574e-01,
                                0.334601952825478473927707444428111e-01,
                                0.387821679744720176399133018691669e-01,
                                0.438709081856732719916865354815208e-01,
                                0.486958076350722320614617038823308e-01,
                                0.532278469839368243549451826570061e-01,
                                0.574397690993915513666228321544156e-01,
                                0.613062424929289391666009097335414e-01,
                                0.648040134566010380745416592730193e-01,
                                0.679120458152339038256953754182832e-01,
                                0.706116473912867796955265510162431e-01,
                                0.728865823958040590605108606145731e-01,
                                0.747231690579682642001919898117514e-01,
                                0.761103619006262423715663560707229e-01,
                                0.770398181642479655883089525855804e-01,
                                0.775059479784248112637240717735455e-01,
                                0.430614035816488768394588393952231e-02, // N = 41
                                0.999993877390594533848901042958917e-02,
                                0.156449384078185885306890867122376e-01,
                                0.212010633687795530758895427770357e-01,
                                0.266358992071104454671075370931667e-01,
                                0.319182117316992817873724972366412e-01,
                                0.370177167035079884349098521818212e-01,
                                0.419051951959096894296482462956402e-01,
                                0.465526483690143420605964350660644e-01,
                                0.509334542946174947813255440273393e-01,
                                0.550225192425787418798644118799982e-01,
                                0.587964209498719449913118102024445e-01,
                                0.622335425809663164715147643899562e-01,
                                0.653141964535274104363301435558487e-01,
                                0.680207367608767667353948358293654e-01,
                                0.703376606208174974816595826741789e-01,
                                0.722516968610230733960874867779371e-01,
                                0.737518820272234699393644210384210e-01,
                                0.748296231762215518910063525757063e-01,
                                0.754787470927158240273606390378492e-01,
                                0.756955356472983723187038409958360e-01,
                                0.410599860464908461061023555717252e-02, // N = 42
                                0.953622030174850241218140290025007e-02,
                                0.149224436973574941444470887695989e-01,
                                0.202278695690526447574727038771351e-01,
                                0.254229595261130478859924599653188e-01,
                                0.304792406996034683638741770807150e-01,
                                0.353690710975921108321682649311524e-01,
                                0.400657351806922617612268859168247e-01,
                                0.445435777719658778735942286930957e-01,
                                0.487781407928032450279671059065116e-01,
                                0.527462956991740703436828380965317e-01,
                                0.564263693580183816468350876909122e-01,
                                0.597982622275866543127356220087449e-01,
                                0.628435580450025764095778274276134e-01,
                                0.655456243649089789266190558161060e-01,
                                0.678897033765219448554488795494112e-01,
                                0.698629924925941597661171952026983e-01,
                                0.714547142651709829218466852761936e-01,
                                0.726561752438041048878376912508503e-01,
                                0.734608134534675282640391984885782e-01,
                                0.738642342321728799963637691291260e-01,
                                0.391949025384412728301313370513146e-02, // N = 43
                                0.910399663740140331903898555973831e-02,
                                0.142487564315764861087398564566926e-01,
                                0.193199014236839003968433523619754e-01,
                                0.242904566138388159005474613894009e-01,
                                0.291344132614984949169565674050855e-01,
                                0.338264920868602923435993731945424e-01,
                                0.383422221941326575737094433063429e-01,
                                0.426580571979820837626126510734454e-01,
                                0.467514947543465800116196327922125e-01,
                                0.506011927843901565228717483571105e-01,
                                0.541870803188817868646377209701441e-01,
                                0.574904619569105194267933125719596e-01,
                                0.604941152499912945204986825844190e-01,
                                0.631823804493961123252851197622471e-01,
                                0.655412421263227974928592788838597e-01,
                                0.675584022293651691916040212965895e-01,
                                0.692233441936566842823596175388094e-01,
                                0.705273877650850281257416306096107e-01,
                                0.714637342525141412981403060607628e-01,
                                0.720275019714219743452997245576738e-01,
                                0.722157516937989879783014072636609e-01,
                                0.374540480311277751558668544586289e-02, // N = 44
                                0.870048136752484411830559190599793e-02,
                                0.136195867555799855230599173946368e-01,
                                0.184714817368147491745923238895006e-01,
                                0.232314819020192106292483479722854e-01,
                                0.278757828212810100829517099944164e-01,
                                0.323812228120698208767462203957668e-01,
                                0.367253478138088736445557986189477e-01,
                                0.408865123103462189040366252645304e-01,
                                0.448439840819700314490116191019649e-01,
                                0.485780464483520375277895043812568e-01,
                                0.520700960917044618838249621676542e-01,
                                0.553027355637280525467830929029284e-01,
                                0.582598598775954953347783108211369e-01,
                                0.609267367015619680364045420889898e-01,
                                0.632900797332038549513215120354114e-01,
                                0.653381148791814349829448549870313e-01,
                                0.670606389062936523961369993025657e-01,
                                0.684490702693666609851969949400314e-01,
                                0.694964918615725780375803971548750e-01,
                                0.701976854735582125870852277180351e-01,
                                0.705491577893540688113908942761203e-01,
                                0.358266315528355892950758360217166e-02, // N = 45
                                0.832318929621824164697409358684734e-02,
                                0.130311049915827843220561191507863e-01,
                                0.176775352579375906107782182906942e-01,
                                0.222398475505787323930046829556212e-01,
                                0.266962139675776648049642257811481e-01,
                                0.310253749345154671638784990684112e-01,
                                0.352066922016090162477729047931937e-01,
                                0.392202367293024475681754804365179e-01,
                                0.430468807091649711524038030190039e-01,
                                0.466683877183733652717098312249616e-01,
                                0.500674992379520297909930394489517e-01,
                                0.532280167312689519510336910119930e-01,
                                0.561348787597864766410766341721373e-01,
                                0.587742327188417385772191795687547e-01,
                                0.611335008310665224992878345641582e-01,
                                0.632014400738199377530918242800216e-01,
                                0.649681957507234308533555512203219e-01,
                                0.664253484498425280911339334753702e-01,
                                0.675659541636075362708739476615854e-01,
                                0.683845773786696745330090234556449e-01,
                                0.688773169776613228805591571728431e-01,
                                0.690418248292320201111524467703311e-01,
                                0.343030086810704828642591584204214e-02, // N = 46
                                0.796989822972462246425032227433478e-02,
                                0.124798837709886841840621348806185e-01,
                                0.169335140078362380501085020830833e-01,
                                0.213099987541365010481533734035053e-01,
                                0.255892863971300106300339893464403e-01,
                                0.297518295522027558124601845315550e-01,
                                0.337786279991068965126618016297720e-01,
                                0.376513053573860713413554183915490e-01,
                                0.413521901096787296881730806590433e-01,
                                0.448643952773181267666818700675079e-01,
                                0.481718951017122005223525166184401e-01,
                                0.512595980071430213420289666520494e-01,
                                0.541134153858567544899943990877935e-01,
                                0.567203258439912358189601545343214e-01,
                                0.590684345955463148015173560040283e-01,
                                0.611470277246504810237160589363533e-01,
                                0.629466210643945081752876595999599e-01,
                                0.644590034671390695897601195774562e-01,
                                0.656772742677812073771971814716057e-01,
                                0.665958747684548873784014384472066e-01,
                                0.672106136006781758628359124722649e-01,
                                0.675186858490364588202031319579642e-01,
                                0.328745384252801487898311676209319e-02, // N = 47
                                0.763861629584883360846339404425152e-02,
                                0.119628484643123209613632008321552e-01,
                                0.162353331464330596673765255916666e-01,
                                0.204369381476684276319063978515533e-01,
                                0.245492116596588185215713425365295e-01,
                                0.285541507006433864965886921571564e-01,
                                0.324342355151847567612709713614516e-01,
                                0.361724965841749516324196621878303e-01,
                                0.397525861225310037587460580247897e-01,
                                0.431588486484795382587366872405725e-01,
                                0.463763890865059112269278110160970e-01,
                                0.493911377473611695938167194472575e-01,
                                0.521899117800571448614008820293490e-01,
                                0.547604727815302259634624240499499e-01,
                                0.570915802932315402247166706047302e-01,
                                0.591730409423388759822494087284767e-01,
                                0.609957530087396453316863886823380e-01,
                                0.625517462209216626482915091386668e-01,
                                0.638342166057170306275769226649446e-01,
                                0.648375562389457267154464097578265e-01,
                                0.655573777665497402366218607238262e-01,
                                0.659905335888104745223628873358430e-01,
                                0.661351296236554796553378625290386e-01,
                                0.315334605230583862368239796468966e-02, // N = 48
                                0.732755390127626210482494385417413e-02,
                                0.114772345792345394876558926395461e-01,
                                0.155793157229438487825975647427245e-01,
                                0.196161604573555277868723719155527e-01,
                                0.235707608393243791436801370538744e-01,
                                0.274265097083569480717107372624816e-01,
                                0.311672278327980889659588180242818e-01,
                                0.347772225647704388364694926767587e-01,
                                0.382413510658307063980450043607073e-01,
                                0.415450829434647491603841511752491e-01,
                                0.446745608566942804896973337543355e-01,
                                0.476166584924904747862626457488802e-01,
                                0.503590355538544749631023414365430e-01,
                                0.528901894851936670893200120166696e-01,
                                0.551995036999841628953878251461178e-01,
                                0.572772921004032156911637671817087e-01,
                                0.591148396983956357594672881911607e-01,
                                0.607044391658938800203930296862858e-01,
                                0.620394231598926639107670112310605e-01,
                                0.631141922862540256440434320324953e-01,
                                0.639242385846481866345893229648291e-01,
                                0.644661644359500822013881893167522e-01,
                                0.647376968126839225045888321571501e-01,
                                0.302727898892290510561231777613290e-02, // N = 49
                                0.703509959008645137354965995563251e-02,
                                0.110205510315935805166517377514429e-01,
                                0.149621449356246510635856987732352e-01,
                                0.188435958530894580085220759791957e-01,
                                0.226492015874466766465196542585839e-01,
                                0.263636189270660165647996295505485e-01,
                                0.299718846205838254945889782178363e-01,
                                0.334594667916221741130469643735188e-01,
                                0.368123209630006901836590905024859e-01,
                                0.400169457663730211664189759018262e-01,
                                0.430604369812595982872652208669184e-01,
                                0.459305393555958533614819312390256e-01,
                                0.486156958878282405019522327602869e-01,
                                0.511050943301445904501815002464393e-01,
                                0.533887107082589687587154970297695e-01,
                                0.554573496748035884888408982388678e-01,
                                0.573026815301874757128287200583188e-01,
                                0.589172757600272657385249712130531e-01,
                                0.602946309531520175669294852905813e-01,
                                0.614292009791929359872785217402887e-01,
                                0.623164173200572675182374705251817e-01,
                                0.629527074651956992712079615892779e-01,
                                0.633355092964917487602573446308019e-01,
                                0.634632814047905976070859561671424e-01,
                                0.290862255315514094172472914505657e-02, // N = 50
                                0.675979919574540167926474544526016e-02,
                                0.105905483836509689242872255474178e-01,
                                0.143808227614855742261641383116087e-01,
                                0.181155607134893895230313249790650e-01,
                                0.217802431701247930256455674224051e-01,
                                0.253606735700123897117859563343183e-01,
                                0.288429935805351980911187546390511e-01,
                                0.322137282235780163633237054970370e-01,
                                0.354598356151461542859558743555247e-01,
                                0.385687566125876749237823178407772e-01,
                                0.415284630901476978226912114495093e-01,
                                0.443275043388032752912251732594724e-01,
                                0.469550513039484329578982512899774e-01,
                                0.494009384494663147920769360809172e-01,
                                0.516557030695811386864773425606938e-01,
                                0.537106218889962464339854529760055e-01,
                                0.555577448062125177224591249057815e-01,
                                0.571899256477283835240727766218481e-01,
                                0.586008498132224459085195503254319e-01,
                                0.597850587042654574514555793402422e-01,
                                0.607379708417702160700874680495243e-01,
                                0.614558995903166636772026154856285e-01,
                                0.619360674206832433834351848662688e-01,
                                0.621766166553472623205770905078938e-01,
                                0.279680717108989546216606954644902e-02, // N = 51
                                0.650033778325259969307060260560534e-02,
                                0.101851912978217290967189198581895e-01,
                                0.138326340064778234876692987935644e-01,
                                0.174287147234010511276066594996303e-01,
                                0.209599884017032127916690979624938e-01,
                                0.244133005737814343142984277810598e-01,
                                0.277757985941624787538149541869123e-01,
                                0.310349712901600079580041445060616e-01,
                                0.341786932041883365545669197326863e-01,
                                0.371952689232602921339390119057043e-01,
                                0.400734762854964539254589560673463e-01,
                                0.428026079978800859429404138013489e-01,
                                0.453725114076500696293418725266796e-01,
                                0.477736262406231013255784824689290e-01,
                                0.499970201500574096251975435461280e-01,
                                0.520344219366970870569117174684084e-01,
                                0.538782523130455619005305302121576e-01,
                                0.555216520957386932548485210281212e-01,
                                0.569585077202586629708863622371194e-01,
                                0.581834739825921408454548343872306e-01,
                                0.591919939229615444689604536526858e-01,
                                0.599803157775032506093197451947697e-01,
                                0.605455069347377959064707614162811e-01,
                                0.608854648448563436488434628287051e-01,
                                0.609989248412058810561940823432652e-01,
                                0.269131695004711131997652715854612e-02, // N = 52
                                0.625552396297328019705487777633589e-02,
                                0.980263457946275119140613062703602e-02,
                                0.133151149823409590897738797839347e-01,
                                0.167800233963007367813999099531835e-01,
                                0.201848915079807937602648354493117e-01,
                                0.235175135539844621531701503520448e-01,
                                0.267659537465040120487346677284258e-01,
                                0.299185811471439465566437261335624e-01,
                                0.329641090897187974012819079259734e-01,
                                0.358916348350972328941312788592173e-01,
                                0.386906783104239779238914470343838e-01,
                                0.413512195005602728093812472667487e-01,
                                0.438637342590004079039491622147539e-01,
                                0.462192283727847945354635180974535e-01,
                                0.484092697440748966957288682228235e-01,
                                0.504260185663423769594325319649942e-01,
                                0.522622553839069930899678843007186e-01,
                                0.539114069327572652031713699402395e-01,
                                0.553675696693026530685906238937806e-01,
                                0.566255309023685968169272899052640e-01,
                                0.576807874525268276441318189886040e-01,
                                0.585295617718138686300805570699930e-01,
                                0.591688154660429703792904451353524e-01,
                                0.595962601712481582735091757073669e-01,
                                0.598103657452918602295343491145649e-01,
                                0.259168372056703272200955831415407e-02, // N = 53
                                0.602427622694867280283238231250656e-02,
                                0.944120228494034158938712708463553e-02,
                                0.128260261442403778263221225606566e-01,
                                0.161667252566874650921471741745227e-01,
                                0.194517211076368968489729754054327e-01,
                                0.226696730570702116513711460687235e-01,
                                0.258094825107575187839045119782342e-01,
                                0.288603236178237376225143751781823e-01,
                                0.318116784590193213760614954175702e-01,
                                0.346533725835342396040094849665233e-01,
                                0.373756098034829115928083033151167e-01,
                                0.399690058435403832061192815775294e-01,
                                0.424246206345200158850154550127607e-01,
                                0.447339891036728090604824716621663e-01,
                                0.468891503407503118962942304067238e-01,
                                0.488826750326991400182463240541013e-01,
                                0.507076910692927133141957059889118e-01,
                                0.523579072298727199154392189288701e-01,
                                0.538276348687310295152354320434724e-01,
                                0.551118075239336011323995728851755e-01,
                                0.562059983817397095119097061143641e-01,
                                0.571064355362671886322510408323139e-01,
                                0.578100149917131962183110324249716e-01,
                                0.583143113622560116448959849073058e-01,
                                0.586175862327202671108003258506728e-01,
                                0.587187941511643654251146874641968e-01,
                                0.249748183576159174033229250414578e-02, // N = 54
                                0.580561101523997898998187389956842e-02,
                                0.909936945550939249665989441765559e-02,
                                0.123633281288476207073771742590512e-01,
                                0.155863030359241252281015371669028e-01,
                                0.187575276214693728266093350652919e-01,
                                0.218664514228530824267270449654578e-01,
                                0.249027414672087669452873673508875e-01,
                                0.278563093105958738845344963935976e-01,
                                0.307173424978706730214031735441713e-01,
                                0.334763364643726455779258613767042e-01,
                                0.361241258403835490997185222423605e-01,
                                0.386519147821025197536536129323026e-01,
                                0.410513061366449719515933795885603e-01,
                                0.433143293095970152451018829626652e-01,
                                0.454334667282767111151435858654148e-01,
                                0.474016788064449912997108953724497e-01,
                                0.492124273245288879119465065852781e-01,
                                0.508596971461881476344187258377885e-01,
                                0.523380161982987442653009355308914e-01,
                                0.536424736475536121943655111672685e-01,
                                0.547687362130579845719591813081892e-01,
                                0.557130625605899867418185455638688e-01,
                                0.564723157306259651341720971326238e-01,
                                0.570439735587945977016201206419090e-01,
                                0.574261370541121144147579487991049e-01,
                                0.576175367071470244496417994126978e-01,
                                0.240832361997979146639521768878870e-02, // N = 55
                                0.559863226656077255816943102418702e-02,
                                0.877574610705851573177676319349140e-02,
                                0.119251607198486032327262777653945e-01,
                                0.150364583335117885752033387782781e-01,
                                0.180996145207290501768746396929775e-01,
                                0.211048016680164532431464313232941e-01,
                                0.240423880097255905802547095681775e-01,
                                0.269029614563962939311035660213081e-01,
                                0.296773577651610392526907720697430e-01,
                                0.323566892261858322750963373089604e-01,
                                0.349323728735898906274358063788280e-01,
                                0.373961578679655465293709869864708e-01,
                                0.397401518743371739235231854052991e-01,
                                0.419568463177187671847955697987667e-01,
                                0.440391404216066000888231496915833e-01,
                                0.459803639462838453005910895640042e-01,
                                0.477742985512006686547832826309376e-01,
                                0.494151977115517278931105580822351e-01,
                                0.508978051244939771111559767815813e-01,
                                0.522173715456320886006585411617747e-01,
                                0.533696700016054493711746319466697e-01,
                                0.543510093299111183055112906523036e-01,
                                0.551582460025086723279065816476839e-01,
                                0.557887941952841016933499741851860e-01,
                                0.562406340710843380656130586963110e-01,
                                0.565123182497719976495222310102389e-01,
                                0.566029764445604112177721668512012e-01,
                                0.232385537577324126890422613947032e-02, // N = 56
                                0.540252224601537190925186647397675e-02,
                                0.846906316330786565812613486180402e-02,
                                0.115098243403834131483340815614335e-01,
                                0.145150892780214604537252526538755e-01,
                                0.174755129114009174690477507814151e-01,
                                0.203819298824025993688444013475539e-01,
                                0.232253515625652827068985329293099e-01,
                                0.259969870583919714941002634538993e-01,
                                0.286882684738227492788897416147350e-01,
                                0.312908767473104528455728490533620e-01,
                                0.337967671156117592043489475070522e-01,
                                0.361981938723152027923247609329598e-01,
                                0.384877342592476726158937254941960e-01,
                                0.406583113847445313906411627234922e-01,
                                0.427032160846670696952367054771230e-01,
                                0.446161276526922847501326985102424e-01,
                                0.463911333730018899972638644959629e-01,
                                0.480227467936002678074540421187404e-01,
                                0.495059246830475711251135471112213e-01,
                                0.508360826177984848853577260580117e-01,
                                0.520091091517414067774472219180510e-01,
                                0.530213785240107599265604863619132e-01,
                                0.538697618657144802644397889590252e-01,
                                0.545516368708894161354131821398505e-01,
                                0.550648959017624190201246418808720e-01,
                                0.554079525032451250289243250655654e-01,
                                0.555797463065143944427894188029340e-01,
                                0.224375387225067557012638005784360e-02, // N = 57
                                0.521653347471884052265060813845318e-02,
                                0.817816006782115894711063950727136e-02,
                                0.111157637323359863831239483349987e-01,
                                0.140202707907536156415965493265979e-01,
                                0.168829590234416248347147395224072e-01,
                                0.196952706994885210130458168723211e-01,
                                0.224488078907762863256986944263591e-01,
                                0.251353509909180704824080353500251e-01,
                                0.277468814021801529398075091152708e-01,
                                0.302756048426940692700058015788578e-01,
                                0.327139743663715516173589213764931e-01,
                                0.350547127823125816354042428248872e-01,
                                0.372908343244173635879864917577868e-01,
                                0.394156654754801443429520359702166e-01,
                                0.414228648708011270314718469566759e-01,
                                0.433064422162152205049384450393011e-01,
                                0.450607761613812054709354847404573e-01,
                                0.466806310736415138750306008734841e-01,
                                0.481611726616877391156340060514772e-01,
                                0.494979824020197497172906853899895e-01,
                                0.506870707249274582261317096003564e-01,
                                0.517248889205176999915897272338709e-01,
                                0.526083397291774430779248438818170e-01,
                                0.533347865848192101202083369347245e-01,
                                0.539020614832986195888408772706440e-01,
                                0.543084714524985734517344522832567e-01,
                                0.545528036047618073234425982169500e-01,
                                0.546343287565840608635319613666036e-01,
                                0.216772324962752860609722283766349e-02, // N = 58
                                0.503998161265050099473450878388375e-02,
                                0.790197384999850553149676803933495e-02,
                                0.107415535328787474579077565721800e-01,
                                0.135502371129887348351430897439451e-01,
                                0.163198742349710699284450347325559e-01,
                                0.190424654618931506292476719739623e-01,
                                0.217101561401465815234238669570227e-01,
                                0.243152527249638252167325188580498e-01,
                                0.268502431819820872689164071701450e-01,
                                0.293078180441603473017116478087213e-01,
                                0.316808912538093047973485637749997e-01,
                                0.339626204934159321760220110314534e-01,
                                0.361464268670872760245627576015715e-01,
                                0.382260138458584118636328904280765e-01,
                                0.401953854098679026731470834636520e-01,
                                0.420488633295820913174656364948234e-01,
                                0.437811035336402714104862527700808e-01,
                                0.453871115148197013301040963200673e-01,
                                0.468622567290264945157696788052520e-01,
                                0.482022859454177809542925373509146e-01,
                                0.494033355089624557067845430582524e-01,
                                0.504619424799530741344865615837751e-01,
                                0.513750546182856833183799961824903e-01,
                                0.521400391836697741376828050049180e-01,
                                0.527546905263707994798962177284939e-01,
                                0.532172364465790117672575114630977e-01,
                                0.535263433040582752149865301145692e-01,
                                0.536811198633348445099834560135582e-01,
                                0.209549228454115085910348399866448e-02, // N = 59
                                0.487223916826538608120757620104404e-02,
                                0.763952945348786139675181360500841e-02,
                                0.103858855009953235440093874014652e-01,
                                0.131033663063442503276163214635613e-01,
                                0.157843473130815538403682535616050e-01,
                                0.184213427536098577567207525118749e-01,
                                0.210069982884367477059953925965200e-01,
                                0.235341053937141003165019887794142e-01,
                                0.259956197312984286578107581680860e-01,
                                0.283846802005354566338975069559749e-01,
                                0.306946278361112857642675133871340e-01,
                                0.329190242710452996686427782673800e-01,
                                0.350516696363997411414557323131216e-01,
                                0.370866198188711290155334282894867e-01,
                                0.390182030161600317914459046555289e-01,
                                0.408410355386869957112091216936823e-01,
                                0.425500368110670563987661617606025e-01,
                                0.441404435302978459585950547736296e-01,
                                0.456078229405092534443324554315076e-01,
                                0.469480851869628827201274335221608e-01,
                                0.481574947146065147241339086576990e-01,
                                0.492326806793616163320533984885165e-01,
                                0.501706463429962847475966730214137e-01,
                                0.509687774253940443177758031824192e-01,
                                0.516248493908914535720594792308901e-01,
                                0.521370336483759811944129010135149e-01,
                                0.525039026478278622063791750028691e-01,
                                0.527244338591281351836211334223332e-01,
                                0.527980126219896053956592277024162e-01,
                                0.202681196887342690388996289808517e-02, // N = 60
                                0.471272992695368602305977645798224e-02,
                                0.738993116334445829099336220995854e-02,
                                0.100475571822885548645559198461963e-01,
                                0.126781664768167038571573234696971e-01,
                                0.152746185967848027990793321778172e-01,
                                0.178299010142079887259503726334636e-01,
                                0.203371207294555471512356476061821e-01,
                                0.227895169440000734360714743015603e-01,
                                0.251804776215188925494546714794599e-01,
                                0.275035567499246495975154466014310e-01,
                                0.297524915007880415327130663973476e-01,
                                0.319212190192974929570620322653765e-01,
                                0.340038927249452944002641733996239e-01,
                                0.359948980510843516295557518336952e-01,
                                0.378888675692434812500509599695607e-01,
                                0.396806954523812685521295275707026e-01,
                                0.413655512355844458757874658762941e-01,
                                0.429388928359368111921249147914843e-01,
                                0.443964787957866109942779548140014e-01,
                                0.457343797161145778119773166609880e-01,
                                0.469489888489119652420074834392926e-01,
                                0.480370318199719788776383177148973e-01,
                                0.489955754557561750043496864560604e-01,
                                0.498220356905505025784307543078473e-01,
                                0.505141845325088140823421352653166e-01,
                                0.510701560698555711966604404473462e-01,
                                0.514884515009809615603083630970976e-01,
                                0.517679431749101672484980162649567e-01,
                                0.519078776312206306926327501092321e-01,
                                0.196145336166974360252310730973366e-02, // N = 61
                                0.456092400601278977476786109285585e-02,
                                0.715235499174801172822093992571763e-02,
                                0.972546183036006935395768780170789e-02,
                                0.122732635078106540710815130025685e-01,
                                0.147890658849421405025292203445132e-01,
                                0.172662929876068128853637188300865e-01,
                                0.196984777461065476769524151450002e-01,
                                0.220792731483141231707145991891915e-01,
                                0.244024671875490021487321528492655e-01,
                                0.266619985241463410358300646035491e-01,
                                0.288519720881873295896585861891525e-01,
                                0.309666743683954278525139227970176e-01,
                                0.330005882759102580974288931385501e-01,
                                0.349484075165312256369976536900406e-01,
                                0.368050504231597384343067782085192e-01,
                                0.385656732070035003411116743299607e-01,
                                0.402256825910009823395851326518323e-01,
                                0.417807477908831702713725738043242e-01,
                                0.432268118124981974387355798422097e-01,
                                0.445601020350801873493761666352158e-01,
                                0.457771400531469812900921756470556e-01,
                                0.468747507508036829804464696522911e-01,
                                0.478500705851001798415218786277589e-01,
                                0.487005550564075133439415118120847e-01,
                                0.494239853467433845759663731177030e-01,
                                0.500184741081758475637498109182848e-01,
                                0.504824703868021063730634389280763e-01,
                                0.508147636688145133850277829847859e-01,
                                0.510144870386962414093945916878333e-01,
                                0.510811194407819869756124378422272e-01};

// Les methodes GPoints et GWeights renvoient des vecteurs des points et
// poids de Gauss. Le calcul suivant permet de n'avoir stocke que la moitie
// des points etant donne qu'ils sont repetes 2 fois.

void math::GaussPoints(const int Index, math_Vector& GPoint)
{
  int Som = 0;
  int i;
  for (i = 1; i < Index; i++)
  {
    Som += (i + 1) >> 1;
  }
  int ind = (Index + 1) >> 1;

  for (i = 1; i <= ind; i++)
  {
    GPoint(i) = Point[Som + i];
    if ((i + ind) <= Index)
      GPoint(i + ind) = -GPoint(i);
  }
}

void math::GaussWeights(const int Index, math_Vector& GWeight)
{
  int Som = 0;
  int i;

  for (i = 1; i < Index; i++)
  {
    Som += (i + 1) >> 1;
  }
  int ind = (Index + 1) >> 1;

  for (i = 1; i <= ind; i++)
  {
    GWeight(i) = Weight[Som + i];
    if ((i + ind) <= Index)
      GWeight(i + ind) = GWeight(i);
  }
}

//  Modified by skv - Wed Dec  7 18:44:51 2005 Ordered Gauss Points. Begin

//=======================================================================
// function : OrderedGaussPointsAndWeights
// purpose  : Returns ordered Gauss points and weights.
//=======================================================================

bool math::OrderedGaussPointsAndWeights(const int Index, math_Vector& Points, math_Vector& Weights)
{
  if (Index < 1 ||                // Index is not positive
      Points.Length() != Index || // Inconsistent length of Points.
      Weights.Length() != Index)  // Inconsistent length of Weights.
    return false;

  if (Index <= 61)
  {
    // Get points from the array.
    int i;
    int aStartInd = 1;

    // Compute the index of starting point in the array.
    for (i = 1; i < Index; i++)
      aStartInd += (i + 1) / 2;

    // Get points from the array.
    int aNbPts   = Index / 2;
    int aLowerI  = Points.Lower();
    int anUpperI = Points.Upper();

    for (i = 0; i < aNbPts; i++)
    {
      Points.Value(aLowerI + i)   = -Point[aStartInd + i];
      Points.Value(anUpperI - i)  = Point[aStartInd + i];
      Weights.Value(aLowerI + i)  = Weight[aStartInd + i];
      Weights.Value(anUpperI - i) = Weight[aStartInd + i];
    }

    if (Index % 2 == 1)
    {
      // Index is odd.
      Points.Value(aLowerI + i)  = Point[aStartInd + i];
      Weights.Value(aLowerI + i) = Weight[aStartInd + i];
    }

    return true;
  }
  else
  {
    math_ComputeGaussPointsAndWeights PWcomputer(Index);
    if (!PWcomputer.IsDone())
      return false;
    Points  = PWcomputer.Points();
    Weights = PWcomputer.Weights();
    return true;
  }
}

//  Modified by skv - Wed Dec  7 18:44:51 2005 Ordered Gauss Points. End
