// Created on: 1994-03-28
// Created by: Remi LEQUETTE
// Copyright (c) 1994-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _DrawTrSurf_Point_HeaderFile
#define _DrawTrSurf_Point_HeaderFile

#include <gp_Pnt.hxx>
#include <Draw_MarkerShape.hxx>
#include <Draw_Color.hxx>
#include <Draw_Drawable3D.hxx>
#include <Draw_Interpretor.hxx>

//! A drawable point.
class DrawTrSurf_Point : public Draw_Drawable3D
{
  DEFINE_STANDARD_RTTIEXT(DrawTrSurf_Point, Draw_Drawable3D)
  Draw_Drawable3D_FACTORY
public:
  Standard_EXPORT DrawTrSurf_Point(const gp_Pnt&          P,
                                   const Draw_MarkerShape Shape,
                                   const Draw_Color&      Col);

  Standard_EXPORT DrawTrSurf_Point(const gp_Pnt2d&        P,
                                   const Draw_MarkerShape Shape,
                                   const Draw_Color&      Col);

  Standard_EXPORT void DrawOn(Draw_Display& dis) const override;

  //! Is a 3D object. (Default True).
  Standard_EXPORT bool Is3D() const override;

  gp_Pnt Point() const { return myPoint; }

  Standard_EXPORT void Point(const gp_Pnt& P);

  gp_Pnt2d Point2d() const { return gp_Pnt2d(myPoint.X(), myPoint.Y()); }

  Standard_EXPORT void Point2d(const gp_Pnt2d& P);

  void Color(const Draw_Color& theColor) { myColor = theColor; }

  Draw_Color Color() const { return myColor; }

  void Shape(const Draw_MarkerShape theS) { myShape = theS; }

  Draw_MarkerShape Shape() const { return myShape; }

  //! For variable copy.
  Standard_EXPORT occ::handle<Draw_Drawable3D> Copy() const override;

  //! For variable dump.
  Standard_EXPORT void Dump(Standard_OStream& S) const override;

  //! Save drawable into stream.
  Standard_EXPORT void Save(Standard_OStream& theStream) const override;

  //! For variable whatis command.
  Standard_EXPORT void Whatis(Draw_Interpretor& I) const override;

private:
  gp_Pnt           myPoint;
  bool             is3D;
  Draw_MarkerShape myShape;
  Draw_Color       myColor;
};

#endif // _DrawTrSurf_Point_HeaderFile
