// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <IFGraph_SubPartsIterator.hxx>
#include <IFSelect_DispGlobal.hxx>
#include <IFSelect_Selection.hxx>
#include <Interface_EntityIterator.hxx>
#include <Interface_Graph.hxx>
#include <Standard_Type.hxx>
#include <TCollection_AsciiString.hxx>

IMPLEMENT_STANDARD_RTTIEXT(IFSelect_DispGlobal, IFSelect_Dispatch)

// Generates a single packet with the final output
IFSelect_DispGlobal::IFSelect_DispGlobal() = default;

TCollection_AsciiString IFSelect_DispGlobal::Label() const
{
  return TCollection_AsciiString("One File for All Input");
}

bool IFSelect_DispGlobal::LimitedMax(const int /* nbent */, int& pcount) const
{
  pcount = 1;
  return true;
}

// 1 packet (from UniqueResult)
void IFSelect_DispGlobal::Packets(const Interface_Graph& G, IFGraph_SubPartsIterator& packs) const
{
  packs.AddPart();
  packs.GetFromIter(FinalSelection()->UniqueResult(G));
}
