// Created on: 1994-11-25
// Created by: Frederic MAUPAS
// Copyright (c) 1994-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _TopoDSToStep_HeaderFile
#define _TopoDSToStep_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Handle.hxx>

#include <TopoDSToStep_BuilderError.hxx>
#include <TopoDSToStep_MakeFaceError.hxx>
#include <TopoDSToStep_MakeWireError.hxx>
#include <TopoDSToStep_MakeEdgeError.hxx>
#include <TopoDSToStep_MakeVertexError.hxx>
class TCollection_HAsciiString;
class Transfer_FinderProcess;
class TopoDS_Shape;
class Standard_Transient;
class TopoDSToStep_Tool;

//! This package implements the mapping between CAS.CAD
//! Shape representation and AP214 Shape Representation.
//! The target schema is pms_c4 (a subset of AP214)
//!
//! How to use this Package :
//!
//! Entry point are context dependent. It can be :
//! MakeManifoldSolidBrep
//! MakeBrepWithVoids
//! MakeFacetedBrep
//! MakeFacetedBrepAndBrepWithVoids
//! MakeShellBasedSurfaceModel
//! Each of these classes call the Builder
//! The class tool centralizes some common information.
class TopoDSToStep
{
public:
  DEFINE_STANDARD_ALLOC

  Standard_EXPORT static occ::handle<TCollection_HAsciiString> DecodeBuilderError(
    const TopoDSToStep_BuilderError E);

  Standard_EXPORT static occ::handle<TCollection_HAsciiString> DecodeFaceError(
    const TopoDSToStep_MakeFaceError E);

  Standard_EXPORT static occ::handle<TCollection_HAsciiString> DecodeWireError(
    const TopoDSToStep_MakeWireError E);

  Standard_EXPORT static occ::handle<TCollection_HAsciiString> DecodeEdgeError(
    const TopoDSToStep_MakeEdgeError E);

  //! Returns a new shape without undirect surfaces.
  Standard_EXPORT static occ::handle<TCollection_HAsciiString> DecodeVertexError(
    const TopoDSToStep_MakeVertexError E);

  //! Adds an entity into the list of results (binders) for
  //! shape stored in FinderProcess
  Standard_EXPORT static void AddResult(const occ::handle<Transfer_FinderProcess>& FP,
                                        const TopoDS_Shape&                        Shape,
                                        const occ::handle<Standard_Transient>&     entity);

  //! Adds all entities recorded in Tool into the map of results
  //! (binders) stored in FinderProcess
  Standard_EXPORT static void AddResult(const occ::handle<Transfer_FinderProcess>& FP,
                                        const TopoDSToStep_Tool&                   Tool);
};

#endif // _TopoDSToStep_HeaderFile
