// Created on : Thu Mar 24 18:30:12 2022
// Created by: snn
// Generator: Express (EXPRESS -> CASCADE/XSTEP Translator) V2.0
// Copyright (c) Open CASCADE 2022
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <StepVisual_TessellatedVertex.hxx>

IMPLEMENT_STANDARD_RTTIEXT(StepVisual_TessellatedVertex, StepVisual_TessellatedStructuredItem)

//=================================================================================================

StepVisual_TessellatedVertex::StepVisual_TessellatedVertex()
{
  myPointIndex         = 0;
  myHasTopologicalLink = false;
}

//=================================================================================================

void StepVisual_TessellatedVertex::Init(
  const occ::handle<TCollection_HAsciiString>&   theRepresentationItem_Name,
  const occ::handle<StepVisual_CoordinatesList>& theCoordinates,
  const bool                                     theHasTopologicalLink,
  const occ::handle<StepShape_VertexPoint>&      theTopologicalLink,
  const int                                      thePointIndex)
{
  StepVisual_TessellatedStructuredItem::Init(theRepresentationItem_Name);

  myCoordinates = theCoordinates;

  myHasTopologicalLink = theHasTopologicalLink;
  if (myHasTopologicalLink)
  {
    myTopologicalLink = theTopologicalLink;
  }
  else
  {
    myTopologicalLink.Nullify();
  }

  myPointIndex = thePointIndex;
}

//=================================================================================================

occ::handle<StepVisual_CoordinatesList> StepVisual_TessellatedVertex::Coordinates() const
{
  return myCoordinates;
}

//=================================================================================================

void StepVisual_TessellatedVertex::SetCoordinates(
  const occ::handle<StepVisual_CoordinatesList>& theCoordinates)
{
  myCoordinates = theCoordinates;
}

//=================================================================================================

occ::handle<StepShape_VertexPoint> StepVisual_TessellatedVertex::TopologicalLink() const
{
  return myTopologicalLink;
}

//=================================================================================================

void StepVisual_TessellatedVertex::SetTopologicalLink(
  const occ::handle<StepShape_VertexPoint>& theTopologicalLink)
{
  myTopologicalLink = theTopologicalLink;
}

//=================================================================================================

bool StepVisual_TessellatedVertex::HasTopologicalLink() const
{
  return myHasTopologicalLink;
}

//=================================================================================================

int StepVisual_TessellatedVertex::PointIndex() const
{
  return myPointIndex;
}

//=================================================================================================

void StepVisual_TessellatedVertex::SetPointIndex(const int thePointIndex)
{
  myPointIndex = thePointIndex;
}
