// Created on: 2015-07-22
// Created by: Irina KRYLOVA
// Copyright (c) 2015 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Standard_Type.hxx>
#include <StepBasic_MeasureWithUnit.hxx>
#include <StepRepr_MeasureRepresentationItem.hxx>
#include <StepRepr_RepresentationItem.hxx>
#include <StepRepr_ReprItemAndMeasureWithUnit.hxx>

IMPLEMENT_STANDARD_RTTIEXT(StepRepr_ReprItemAndMeasureWithUnit, StepRepr_RepresentationItem)

//=================================================================================================

StepRepr_ReprItemAndMeasureWithUnit::StepRepr_ReprItemAndMeasureWithUnit()
{
  myMeasureWithUnit           = new StepBasic_MeasureWithUnit();
  myMeasureRepresentationItem = new StepRepr_MeasureRepresentationItem();
}

//=================================================================================================

void StepRepr_ReprItemAndMeasureWithUnit::Init(const occ::handle<StepBasic_MeasureWithUnit>&   aMWU,
                                               const occ::handle<StepRepr_RepresentationItem>& aRI)
{
  myMeasureWithUnit = aMWU;
  SetName(aRI->Name());
}

//=================================================================================================

occ::handle<StepRepr_MeasureRepresentationItem> StepRepr_ReprItemAndMeasureWithUnit::
  GetMeasureRepresentationItem() const
{
  return myMeasureRepresentationItem;
}

//=================================================================================================

void StepRepr_ReprItemAndMeasureWithUnit::SetMeasureWithUnit(
  const occ::handle<StepBasic_MeasureWithUnit>& aMWU)
{
  myMeasureWithUnit = aMWU;
}

//=================================================================================================

occ::handle<StepBasic_MeasureWithUnit> StepRepr_ReprItemAndMeasureWithUnit::GetMeasureWithUnit()
  const
{
  return myMeasureWithUnit;
}

//=================================================================================================

occ::handle<StepRepr_RepresentationItem> StepRepr_ReprItemAndMeasureWithUnit::
  GetRepresentationItem() const
{
  occ::handle<StepRepr_RepresentationItem> RI = new StepRepr_RepresentationItem();
  RI->Init(Name());
  return RI;
}
