// Copyright (c) 2025 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// A Bison parser, made by GNU Bison 3.7.4.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2020 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// NOLINTBEGIN - Bison-generated file, do not modify with clang-tidy

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.

// "%code top" blocks.

// This file is part of Open CASCADE Technology software library.
// This file is generated, do not modify it directly; edit source file step.yacc instead.

// Take the name prefix into account.
#define yylex steplex

#include "step.tab.hxx"

// Unqualified %code blocks.

#undef yylex
#define yylex scanner->lex
#define StepData scanner->myDataModel

// disable MSVC warnings in bison code
#ifdef _MSC_VER
  #pragma warning(disable : 4065 4244 4131 4127 4702)
#endif
void StepFile_Interrupt(const char* theErrorMessage, const bool theIsFail);

#ifndef YY_
  #if defined YYENABLE_NLS && YYENABLE_NLS
    #if ENABLE_NLS
      #include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
      #define YY_(msgid) dgettext("bison-runtime", msgid)
    #endif
  #endif
  #ifndef YY_
    #define YY_(msgid) msgid
  #endif
#endif

// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
  #if defined __GNUC__ && !defined __EXCEPTIONS
    #define YY_EXCEPTIONS 0
  #else
    #define YY_EXCEPTIONS 1
  #endif
#endif

// Enable debugging if requested.
#if YYDEBUG

  // A pseudo ostream that takes yydebug_ into account.
  #define YYCDEBUG                                                                                 \
    if (yydebug_)                                                                                  \
    (*yycdebug_)

  #define YY_SYMBOL_PRINT(Title, Symbol)                                                           \
    do                                                                                             \
    {                                                                                              \
      if (yydebug_)                                                                                \
      {                                                                                            \
        *yycdebug_ << Title << ' ';                                                                \
        yy_print_(*yycdebug_, Symbol);                                                             \
        *yycdebug_ << '\n';                                                                        \
      }                                                                                            \
    } while (false)

  #define YY_REDUCE_PRINT(Rule)                                                                    \
    do                                                                                             \
    {                                                                                              \
      if (yydebug_)                                                                                \
        yy_reduce_print_(Rule);                                                                    \
    } while (false)

  #define YY_STACK_PRINT()                                                                         \
    do                                                                                             \
    {                                                                                              \
      if (yydebug_)                                                                                \
        yy_stack_print_();                                                                         \
    } while (false)

#else // !YYDEBUG

  #define YYCDEBUG                                                                                 \
    if (false)                                                                                     \
    std::cerr
  #define YY_SYMBOL_PRINT(Title, Symbol) YYUSE(Symbol)
  #define YY_REDUCE_PRINT(Rule) static_cast<void>(0)
  #define YY_STACK_PRINT() static_cast<void>(0)

#endif // !YYDEBUG

#define yyerrok (yyerrstatus_ = 0)
#define yyclearin (yyla.clear())

#define YYACCEPT goto yyacceptlab
#define YYABORT goto yyabortlab
#define YYERROR goto yyerrorlab
#define YYRECOVERING() (!!yyerrstatus_)

namespace step
{

/// Build a parser object.
parser::parser(step::scanner* scanner_yyarg)
#if YYDEBUG
    : yydebug_(false),
      yycdebug_(&std::cerr),
#else
    :
#endif
      scanner(scanner_yyarg)
{
}

parser::~parser() = default;

parser::syntax_error::~syntax_error() YY_NOEXCEPT YY_NOTHROW = default;

/*---------------.
| symbol kinds.  |
`---------------*/

// basic_symbol.
template <typename Base>
parser::basic_symbol<Base>::basic_symbol(const basic_symbol& that)
    : Base(that),
      value(that.value)
{
}

/// Constructor for valueless symbols.
template <typename Base>
parser::basic_symbol<Base>::basic_symbol(typename Base::kind_type t)
    : Base(t),
      value()
{
}

template <typename Base>
parser::basic_symbol<Base>::basic_symbol(typename Base::kind_type t, YY_RVREF(semantic_type) v)
    : Base(t),
      value(YY_MOVE(v))
{
}

template <typename Base>
parser::symbol_kind_type parser::basic_symbol<Base>::type_get() const YY_NOEXCEPT
{
  return this->kind();
}

template <typename Base>
bool parser::basic_symbol<Base>::empty() const YY_NOEXCEPT
{
  return this->kind() == symbol_kind::S_YYEMPTY;
}

template <typename Base>
void parser::basic_symbol<Base>::move(basic_symbol& s)
{
  super_type::move(s);
  value = YY_MOVE(s.value);
}

// by_kind.
parser::by_kind::by_kind()
    : kind_(symbol_kind::S_YYEMPTY)
{
}

#if 201103L <= YY_CPLUSPLUS
parser::by_kind::by_kind(by_kind&& that)
    : kind_(that.kind_)
{
  that.clear();
}
#endif

parser::by_kind::by_kind(const by_kind& that)

  = default;

parser::by_kind::by_kind(token_kind_type t)
    : kind_(yytranslate_(t))
{
}

void parser::by_kind::clear()
{
  kind_ = symbol_kind::S_YYEMPTY;
}

void parser::by_kind::move(by_kind& that)
{
  kind_ = that.kind_;
  that.clear();
}

parser::symbol_kind_type parser::by_kind::kind() const YY_NOEXCEPT
{
  return kind_;
}

parser::symbol_kind_type parser::by_kind::type_get() const YY_NOEXCEPT
{
  return this->kind();
}

// by_state.
parser::by_state::by_state() YY_NOEXCEPT : state(empty_state) {}

parser::by_state::by_state(const by_state& that) YY_NOEXCEPT = default;

void parser::by_state::clear() YY_NOEXCEPT
{
  state = empty_state;
}

void parser::by_state::move(by_state& that)
{
  state = that.state;
  that.clear();
}

parser::by_state::by_state(state_type s) YY_NOEXCEPT : state(s) {}

parser::symbol_kind_type parser::by_state::kind() const YY_NOEXCEPT
{
  if (state == empty_state)
    return symbol_kind::S_YYEMPTY;
  else
    return YY_CAST(symbol_kind_type, yystos_[+state]);
}

parser::stack_symbol_type::stack_symbol_type() = default;

parser::stack_symbol_type::stack_symbol_type(YY_RVREF(stack_symbol_type) that)
    : super_type(YY_MOVE(that.state), YY_MOVE(that.value))
{
#if 201103L <= YY_CPLUSPLUS
  // that is emptied.
  that.state = empty_state;
#endif
}

parser::stack_symbol_type::stack_symbol_type(state_type s, YY_MOVE_REF(symbol_type) that)
    : super_type(s, YY_MOVE(that.value))
{
  // that is emptied.
  that.kind_ = symbol_kind::S_YYEMPTY;
}

#if YY_CPLUSPLUS < 201103L
parser::stack_symbol_type& parser::stack_symbol_type::operator=(const stack_symbol_type& that)
{
  state = that.state;
  value = that.value;
  return *this;
}

parser::stack_symbol_type& parser::stack_symbol_type::operator=(stack_symbol_type& that)
{
  state = that.state;
  value = that.value;
  // that is emptied.
  that.state = empty_state;
  return *this;
}
#endif

template <typename Base>
void parser::yy_destroy_(const char* yymsg, basic_symbol<Base>& yysym) const
{
  if (yymsg)
    YY_SYMBOL_PRINT(yymsg, yysym);

  // User destructor.
  YYUSE(yysym.kind());
}

#if YYDEBUG
template <typename Base>
void parser::yy_print_(std::ostream& yyo, const basic_symbol<Base>& yysym) const
{
  std::ostream& yyoutput = yyo;
  YYUSE(yyoutput);
  if (yysym.empty())
    yyo << "empty symbol";
  else
  {
    symbol_kind_type yykind = yysym.kind();
    yyo << (yykind < YYNTOKENS ? "token" : "nterm") << ' ' << yysym.name() << " (";
    YYUSE(yykind);
    yyo << ')';
  }
}
#endif

void parser::yypush_(const char* m, YY_MOVE_REF(stack_symbol_type) sym)
{
  if (m)
    YY_SYMBOL_PRINT(m, sym);
  yystack_.push(YY_MOVE(sym));
}

void parser::yypush_(const char* m, state_type s, YY_MOVE_REF(symbol_type) sym)
{
#if 201103L <= YY_CPLUSPLUS
  yypush_(m, stack_symbol_type(s, std::move(sym)));
#else
  stack_symbol_type ss(s, sym);
  yypush_(m, ss);
#endif
}

void parser::yypop_(int n)
{
  yystack_.pop(n);
}

#if YYDEBUG
std::ostream& parser::debug_stream() const
{
  return *yycdebug_;
}

void parser::set_debug_stream(std::ostream& o)
{
  yycdebug_ = &o;
}

parser::debug_level_type parser::debug_level() const
{
  return yydebug_;
}

void parser::set_debug_level(debug_level_type l)
{
  yydebug_ = l;
}
#endif // YYDEBUG

parser::state_type parser::yy_lr_goto_state_(state_type yystate, int yysym)
{
  int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
  if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
    return yytable_[yyr];
  else
    return yydefgoto_[yysym - YYNTOKENS];
}

bool parser::yy_pact_value_is_default_(int yyvalue)
{
  return yyvalue == yypact_ninf_;
}

bool parser::yy_table_value_is_error_(int yyvalue)
{
  return yyvalue == yytable_ninf_;
}

int parser::operator()()
{
  return parse();
}

int parser::parse()
{
  int yyn;
  /// Length of the RHS of the rule being reduced.
  int yylen = 0;

  // Error handling.
  int yyerrstatus_ = 0;

  /// The lookahead symbol.
  symbol_type yyla;

  /// The return value of parse ().
  int yyresult;

#if YY_EXCEPTIONS
  try
#endif // YY_EXCEPTIONS
  {
    YYCDEBUG << "Starting parse\n";

    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear();
    yypush_(YY_NULLPTR, 0, YY_MOVE(yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int(yystack_[0].state) << '\n';
    YY_STACK_PRINT();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;

  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_(yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty())
    {
      YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
      {
        yyla.kind_ = yytranslate_(yylex(&yyla.value));
      }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
      {
        YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
        error(yyexc);
        goto yyerrlab1;
      }
#endif // YY_EXCEPTIONS
    }
    YY_SYMBOL_PRINT("Next token is", yyla);

    if (yyla.kind() == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind())
    {
      goto yydefault;
    }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
    {
      if (yy_table_value_is_error_(yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_("Shifting", state_type(yyn), YY_MOVE(yyla));
    goto yynewstate;

  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;

  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_(yystack_[yylen].state, yyr1_[yyn]);
      /* If YYLEN is nonzero, implement the default value of the
         action: '$$ = $1'.  Otherwise, use the top of the stack.

         Otherwise, the following line sets YYLHS.VALUE to garbage.
         This behavior is undocumented and Bison users should not rely
         upon it.  */
      if (yylen)
        yylhs.value = yystack_[yylen - 1].value;
      else
        yylhs.value = yystack_[0].value;

      // Perform the reduction.
      YY_REDUCE_PRINT(yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
      {
        switch (yyn)
        {
          case 11: // stepf: stepf3
          {
            return (0); /*  fini pour celui-la  */
          }
          break;

          case 16: // endhead: DATA
          {
            StepData->FinalOfHead();
          }
          break;

          case 17: // unarg: IDENT
          {
            StepData->SetTypeArg(Interface_ParamIdent);
            StepData->CreateNewArg();
          }
          break;

          case 18: // unarg: QUID
          {        /* deja fait par lex*/
            StepData->CreateNewArg();
          }
          break;

          case 19: // unarg: listarg
          {
            StepData->CreateNewArg();
          }
          break;

          case 20: // unarg: listype listarg
          {
            StepData->CreateNewArg();
          }
          break;

          case 21: // unarg: error
          {
            StepData->CreateErrorArg();
          }
          break;

          case 22: // listype: TYPE
          {
            StepData->RecordTypeText();
          }
          break;

          case 23: // deblist: '('
          {
            StepData->RecordListStart();
          }
          break;

          case 24: // finlist: ')'
          {
            if (StepData->GetModePrint() > 0)
            {
              printf("Record no : %d -- ", StepData->GetNbRecord() + 1);
              StepData->PrintCurrentRecord();
            }
            StepData->RecordNewEntity();
            yyerrstatus_ = 0;
          }
          break;

          case 39: // debscop: SCOPE
          {
            StepData->AddNewScope();
          }
          break;

          case 40: // unid: IDENT
          {
            StepData->SetTypeArg(Interface_ParamIdent);
            StepData->CreateNewArg();
          }
          break;

          case 43: // debexp: '/'
          {
            StepData->RecordListStart();
          }
          break;

          case 44: // finscop: ENDSCOPE
          {
            StepData->FinalOfScope();
          }
          break;

          case 45: // finscop: ENDSCOPE debexp export '/'
          {
            printf("***  Warning : Export List not yet processed\n");
            StepData->RecordNewEntity();
            StepData->FinalOfScope();
          }
          break;

          case 46: // entlab: ENTITY
          {
            StepData->RecordIdent();
          }
          break;

          case 47: // enttype: TYPE
          {
            StepData->RecordType();
          }
          break;

          default:
            break;
        }
      }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
      {
        YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
        error(yyexc);
        YYERROR;
      }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT("-> $$ =", yylhs);
      yypop_(yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_(YY_NULLPTR, YY_MOVE(yylhs));
    }
    goto yynewstate;

  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
    {
      context     yyctx(*this, yyla);
      std::string msg = yysyntax_error_(yyctx);
      error(YY_MOVE(msg));
    }

    if (yyerrstatus_ == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      // Return failure if at end of input.
      if (yyla.kind() == symbol_kind::S_YYEOF)
        YYABORT;
      else if (!yyla.empty())
      {
        yy_destroy_("Error: discarding", yyla);
        yyla.clear();
      }
    }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;

  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_(yylen);
    yylen = 0;
    YY_STACK_PRINT();
    goto yyerrlab1;

  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3; // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
    {
      yyn = yypact_[+yystack_[0].state];
      if (!yy_pact_value_is_default_(yyn))
      {
        yyn += symbol_kind::S_YYerror;
        if (0 <= yyn && yyn <= yylast_ && yycheck_[yyn] == symbol_kind::S_YYerror)
        {
          yyn = yytable_[yyn];
          if (0 < yyn)
            break;
        }
      }

      // Pop the current state because it cannot handle the error token.
      if (yystack_.size() == 1)
        YYABORT;

      yy_destroy_("Error: popping", yystack_[0]);
      yypop_();
      YY_STACK_PRINT();
    }
    {
      stack_symbol_type error_token;

      // Shift the error token.
      error_token.state = state_type(yyn);
      yypush_("Shifting", YY_MOVE(error_token));
    }
    goto yynewstate;

  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;

  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;

  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty())
      yy_destroy_("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_(yylen);
    YY_STACK_PRINT();
    while (1 < yystack_.size())
    {
      yy_destroy_("Cleanup: popping", yystack_[0]);
      yypop_();
    }

    return yyresult;
  }
#if YY_EXCEPTIONS
  catch (...)
  {
    YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
    // Do not try to display the values of the reclaimed symbols,
    // as their printers might throw an exception.
    if (!yyla.empty())
      yy_destroy_(YY_NULLPTR, yyla);

    while (1 < yystack_.size())
    {
      yy_destroy_(YY_NULLPTR, yystack_[0]);
      yypop_();
    }
    throw;
  }
#endif // YY_EXCEPTIONS
}

void parser::error(const syntax_error& yyexc)
{
  error(yyexc.what());
}

/* Return YYSTR after stripping away unnecessary quotes and
   backslashes, so that it's suitable for yyerror.  The heuristic is
   that double-quoting is unnecessary unless the string contains an
   apostrophe, a comma, or backslash (other than backslash-backslash).
   YYSTR is taken from yytname.  */
std::string parser::yytnamerr_(const char* yystr)
{
  if (*yystr == '"')
  {
    std::string yyr;
    char const* yyp = yystr;

    for (;;)
      switch (*++yyp)
      {
        case '\'':
        case ',':
          goto do_not_strip_quotes;

        case '\\':
          if (*++yyp != '\\')
            goto do_not_strip_quotes;
          else
            goto append;

        append:
        default:
          yyr += *yyp;
          break;

        case '"':
          return yyr;
      }
  do_not_strip_quotes:;
  }

  return yystr;
}

std::string parser::symbol_name(symbol_kind_type yysymbol)
{
  return yytnamerr_(yytname_[yysymbol]);
}

// parser::context.
parser::context::context(const parser& yyparser, const symbol_type& yyla)
    : yyparser_(yyparser),
      yyla_(yyla)
{
}

int parser::context::expected_tokens(symbol_kind_type yyarg[], int yyargn) const
{
  // Actual number of expected tokens
  int yycount = 0;

  int yyn = yypact_[+yyparser_.yystack_[0].state];
  if (!yy_pact_value_is_default_(yyn))
  {
    /* Start YYX at -YYN if negative to avoid negative indexes in
       YYCHECK.  In other words, skip the first -YYN actions for
       this state because they are default actions.  */
    int yyxbegin = yyn < 0 ? -yyn : 0;
    // Stay within bounds of both yycheck and yytname.
    int yychecklim = yylast_ - yyn + 1;
    int yyxend     = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
    for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
      if (yycheck_[yyx + yyn] == yyx && yyx != symbol_kind::S_YYerror
          && !yy_table_value_is_error_(yytable_[yyx + yyn]))
      {
        if (!yyarg)
          ++yycount;
        else if (yycount == yyargn)
          return 0;
        else
          yyarg[yycount++] = YY_CAST(symbol_kind_type, yyx);
      }
  }

  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = symbol_kind::S_YYEMPTY;
  return yycount;
}

int parser::yy_syntax_error_arguments_(const context&   yyctx,
                                       symbol_kind_type yyarg[],
                                       int              yyargn) const
{
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yyla) is
       if this state is a consistent state with a default action.
       Thus, detecting the absence of a lookahead is sufficient to
       determine that there is no unexpected or expected token to
       report.  In that case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is
       a consistent state with a default action.  There might have
       been a previous inconsistent state, consistent state with a
       non-default action, or user semantic action that manipulated
       yyla.  (However, yyla is currently not documented for users.)
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */

  if (!yyctx.lookahead().empty())
  {
    if (yyarg)
      yyarg[0] = yyctx.token();
    int yyn = yyctx.expected_tokens(yyarg ? yyarg + 1 : yyarg, yyargn - 1);
    return yyn + 1;
  }
  return 0;
}

// Generate an error message.
std::string parser::yysyntax_error_(const context& yyctx) const
{
  // Its maximum.
  enum
  {
    YYARGS_MAX = 5
  };

  // Arguments of yyformat.
  symbol_kind_type yyarg[YYARGS_MAX];
  int              yycount = yy_syntax_error_arguments_(yyctx, yyarg, YYARGS_MAX);

  char const* yyformat = YY_NULLPTR;
  switch (yycount)
  {
#define YYCASE_(N, S)                                                                              \
  case N:                                                                                          \
    yyformat = S;                                                                                  \
    break
    default: // Avoid compiler warnings.
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
  }

  std::string yyres;
  // Argument number.
  std::ptrdiff_t yyi = 0;
  for (char const* yyp = yyformat; *yyp; ++yyp)
    if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
    {
      yyres += symbol_name(yyarg[yyi++]);
      ++yyp;
    }
    else
      yyres += *yyp;
  return yyres;
}

const signed char parser::yypact_ninf_ = -24;

const signed char parser::yytable_ninf_ = -9;

const signed char parser::yypact_[] = {
  26,  5,   -24, -24, -24, 35,  29,  -24, -24, 41,  -24, 43,  -24, 36,  -24, 45,  41,
  -24, -24, 3,   38,  -24, -24, 40,  -24, 32,  45,  -24, -24, -24, -24, -24, -24, 36,
  -24, -24, 9,   -24, 60,  56,  -24, -3,  51,  -24, 17,  -24, -24, -24, 53,  44,  6,
  36,  59,  -24, 0,   36,  -24, 42,  6,   2,   -24, 47,  -24, -24, 36,  -24, -24, 55,
  2,   49,  -24, 52,  -24, -24, -24, -14, 50,  -24, -24, 55,  -24, -24, -24};

const signed char parser::yydefact_[] = {
  0,  0,  9,  10, 11, 0,  0,  1,  15, 0,  47, 0,  12, 0,  16, 0,  0,  13, 23, 0,  0,
  34, 46, 0,  29, 0,  0,  21, 22, 17, 18, 24, 27, 0,  25, 19, 0,  14, 34, 0,  30, 0,
  0,  20, 0,  26, 7,  39, 0,  0,  0,  0,  0,  28, 0,  0,  31, 44, 0,  0,  37, 4,  6,
  38, 0,  35, 43, 0,  0,  0,  2,  5,  36, 40, 41, 0,  0,  33, 3,  0,  45, 32, 42};

const signed char parser::yypgoto_[] = {-24, -24, -24, -24, -24, -24, -24, -24, 62,
                                        58,  31,  -24, -24, 46,  -13, -24, -23, -21,
                                        -24, -6,  -24, -2,  -24, -24, 18,  -24, -5};

const signed char parser::yydefgoto_[] = {-1, 71, 62, 2,  3,  4,  5,  11, 12, 15, 32, 33, 19, 34,
                                          35, 36, 23, 24, 54, 49, 50, 74, 75, 67, 59, 25, 51};

const signed char parser::yytable_[] = {
  20, 13, 40, 42, 27, 47, 13, 21, 10, 6,  79, 10, 80, 10, 28, 57, 22, 29, 27, 48, 43,
  40, 30, 63, 48, 18, 31, 58, 28, 1,  8,  29, 31, 44, 9,  7,  30, 40, 60, 18, 10, 38,
  65, 55, 8,  39, 21, 14, 16, 64, 22, 72, 21, 69, 10, 22, 52, 41, 18, 37, -8, 22, 76,
  46, 10, 56, 61, 70, 66, 73, 77, 81, 78, 17, 26, 53, 68, 82, 0,  0,  0,  0,  45};

const signed char parser::yycheck_[] = {
  13, 6,  23, 26, 1,  8,  11, 1,  11, 4,  24, 11, 26, 11, 11, 9,  10, 14, 1,  22, 33,
  42, 19, 23, 22, 22, 23, 50, 11, 3,  1,  14, 23, 24, 5,  0,  19, 58, 51, 22, 11, 1,
  55, 48, 1,  5,  1,  6,  5,  54, 10, 64, 1,  59, 11, 10, 5,  25, 22, 21, 0,  10, 68,
  7,  11, 21, 7,  20, 26, 14, 21, 21, 20, 11, 16, 44, 58, 79, -1, -1, -1, -1, 36};

const signed char parser::yystos_[] = {
  0,  3,  30, 31, 32, 33, 4,  0,  1,  5,  11, 34, 35, 53, 6,  36, 5,  35, 22, 39, 41,
  1,  10, 43, 44, 52, 36, 1,  11, 14, 19, 23, 37, 38, 40, 41, 42, 21, 1,  5,  44, 25,
  43, 41, 24, 40, 7,  8,  22, 46, 47, 53, 5,  37, 45, 53, 21, 9,  43, 51, 41, 7,  29,
  23, 53, 41, 26, 50, 51, 46, 20, 28, 41, 14, 48, 49, 46, 21, 20, 24, 26, 21, 48};

const signed char parser::yyr1_[] = {
  0,  27, 28, 28, 29, 29, 30, 31, 32, 33, 33, 33, 34, 34, 35, 35, 36, 37, 37, 37, 37, 37, 38, 39,
  40, 41, 41, 42, 42, 43, 43, 44, 44, 44, 44, 45, 45, 46, 46, 47, 48, 49, 49, 50, 51, 51, 52, 53};

const signed char parser::yyr2_[] = {0, 2, 1, 2, 1, 2, 8, 7, 6, 1, 1, 1, 1, 2, 3, 1,
                                     1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 3, 1, 3, 1, 2, 4,
                                     7, 6, 1, 2, 3, 2, 3, 1, 1, 1, 3, 1, 1, 4, 1, 1};

#if YYDEBUG || 1
// YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
// First, the terminals, then, starting at \a YYNTOKENS, nonterminals.
const char* const parser::yytname_[] = {"\"end of file\"",
                                        "error",
                                        "\"invalid token\"",
                                        "STEP",
                                        "HEADER",
                                        "ENDSEC",
                                        "DATA",
                                        "ENDSTEP",
                                        "SCOPE",
                                        "ENDSCOPE",
                                        "ENTITY",
                                        "TYPE",
                                        "INTEGER",
                                        "FLOAT",
                                        "IDENT",
                                        "TEXT",
                                        "NONDEF",
                                        "ENUM",
                                        "HEXA",
                                        "QUID",
                                        "' '",
                                        "';'",
                                        "'('",
                                        "')'",
                                        "','",
                                        "'='",
                                        "'/'",
                                        "$accept",
                                        "finvide",
                                        "finstep",
                                        "stepf1",
                                        "stepf2",
                                        "stepf3",
                                        "stepf",
                                        "headl",
                                        "headent",
                                        "endhead",
                                        "unarg",
                                        "listype",
                                        "deblist",
                                        "finlist",
                                        "listarg",
                                        "arglist",
                                        "model",
                                        "bloc",
                                        "plex",
                                        "unent",
                                        "debscop",
                                        "unid",
                                        "export",
                                        "debexp",
                                        "finscop",
                                        "entlab",
                                        "enttype",
                                        YY_NULLPTR};
#endif

#if YYDEBUG
const unsigned char parser::yyrline_[] = {
  0,   96,  96,  97,  98,  99,  100, 101, 102, 103, 103, 103, 106, 107, 109, 110,
  112, 115, 116, 117, 118, 119, 122, 125, 128, 133, 134, 136, 137, 139, 140, 142,
  143, 144, 145, 147, 148, 150, 151, 153, 156, 159, 160, 162, 165, 167, 172, 175};

void parser::yy_stack_print_() const
{
  *yycdebug_ << "Stack now";
  for (stack_type::const_iterator i = yystack_.begin(), i_end = yystack_.end(); i != i_end; ++i)
    *yycdebug_ << ' ' << int(i->state);
  *yycdebug_ << '\n';
}

void parser::yy_reduce_print_(int yyrule) const
{
  int yylno  = yyrline_[yyrule];
  int yynrhs = yyr2_[yyrule];
  // Print the symbols being reduced, and their result.
  *yycdebug_ << "Reducing stack by rule " << yyrule - 1 << " (line " << yylno << "):\n";
  // The symbols being reduced.
  for (int yyi = 0; yyi < yynrhs; yyi++)
    YY_SYMBOL_PRINT("   $" << yyi + 1 << " =", yystack_[(yynrhs) - (yyi + 1)]);
}
#endif // YYDEBUG

parser::symbol_kind_type parser::yytranslate_(int t)
{
  // YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to
  // TOKEN-NUM as returned by yylex.
  static const signed char translate_table[] = {
    0, 2, 2, 2,  2,  2,  2, 2, 2, 2, 2, 2, 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 2,  20, 2,  2, 2, 2, 2, 2, 2, 22, 23, 2,  2,  24, 2,  2,  26, 2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 21, 2,  25, 2, 2, 2, 2, 2, 2, 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 2,  2,  2,  2, 2, 2, 2, 2, 2, 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 2,  2,  2,  2, 2, 2, 2, 2, 2, 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 2,  2,  2,  2, 2, 2, 2, 2, 2, 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 2,  2,  2,  2, 2, 2, 2, 2, 2, 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 2,  2,  2,  2, 2, 2, 2, 2, 2, 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 2,  2,  2,  2, 2, 2, 2, 2, 2, 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 2, 2, 2, 2, 2,
    2, 2, 2, 2,  1,  2,  3, 4, 5, 6, 7, 8, 9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
  // Last valid token kind.
  const int code_max = 274;

  if (t <= 0)
    return symbol_kind::S_YYEOF;
  else if (t <= code_max)
    return YY_CAST(symbol_kind_type, translate_table[t]);
  else
    return symbol_kind::S_YYUNDEF;
}

} // namespace step

void step::parser::error(const std::string& m)
{
  char newmess[120];
  bool isSyntax = strncmp(m.c_str(), "syntax error", 12) == 0;
  if (isSyntax && m.length() > 13)
    Sprintf(newmess,
            "Undefined Parsing: Line %d: %s: %s",
            scanner->lineno() + 1,
            "Incorrect syntax",
            m.c_str() + 14);
  else if (isSyntax)
    Sprintf(newmess, "Undefined Parsing: Line %d: Incorrect syntax", scanner->lineno() + 1);
  else
    Sprintf(newmess, "Undefined Parsing: Line %d: %s", scanner->lineno() + 1, m.c_str());

  StepFile_Interrupt(newmess, false);

  StepData->AddError(newmess);
}

// NOLINTEND
