// Created on: 1997-04-01
// Created by: Christian CAILLET
// Copyright (c) 1997-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _StepData_FieldListN_HeaderFile
#define _StepData_FieldListN_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Handle.hxx>

#include <StepData_Field.hxx>
#include <NCollection_Array1.hxx>
#include <StepData_FieldList.hxx>
class StepData_Field;

//! Describes a list of fields, in a general way
//! This basic class is for a null size list
//! Subclasses are for 1, N (fixed) or Dynamic sizes
class StepData_FieldListN : public StepData_FieldList
{
public:
  DEFINE_STANDARD_ALLOC

  //! Creates a FieldListN of <nb> Fields
  Standard_EXPORT StepData_FieldListN(const int nb);

  //! Returns the count of fields. Here, returns starting <nb>
  Standard_EXPORT int NbFields() const override;

  //! Returns the field n0 <num> between 1 and NbFields (read only)
  Standard_EXPORT const StepData_Field& Field(const int num) const override;

  //! Returns the field n0 <num> between 1 and NbFields, in order to
  //! modify its content
  Standard_EXPORT StepData_Field& CField(const int num) override;

private:
  NCollection_Array1<StepData_Field> thefields;
};

#endif // _StepData_FieldListN_HeaderFile
