// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Interface_Check.hxx>
#include <Interface_EntityIterator.hxx>
#include "RWStepShape_RWLoopAndPath.pxx"
#include <StepData_StepReaderData.hxx>
#include <StepData_StepWriter.hxx>
#include <StepShape_LoopAndPath.hxx>
#include <StepShape_OrientedEdge.hxx>

RWStepShape_RWLoopAndPath::RWStepShape_RWLoopAndPath() = default;

void RWStepShape_RWLoopAndPath::ReadStep(const occ::handle<StepData_StepReaderData>& data,
                                         const int                                   num0,
                                         occ::handle<Interface_Check>&               ach,
                                         const occ::handle<StepShape_LoopAndPath>&   ent) const
{

  int num = num0;

  // --- Instance of plex component Loop ---

  if (!data->CheckNbParams(num, 0, ach, "loop"))
    return;

  num = data->NextForComplex(num);

  // --- Instance of plex component Path ---

  if (!data->CheckNbParams(num, 1, ach, "path"))
    return;

  // --- field : edgeList ---

  occ::handle<NCollection_HArray1<occ::handle<StepShape_OrientedEdge>>> aEdgeList;
  occ::handle<StepShape_OrientedEdge>                                   anent1;
  int                                                                   nsub1;
  if (data->ReadSubList(num, 1, "edge_list", ach, nsub1))
  {
    int nb1   = data->NbParams(nsub1);
    aEdgeList = new NCollection_HArray1<occ::handle<StepShape_OrientedEdge>>(1, nb1);
    for (int i1 = 1; i1 <= nb1; i1++)
    {
      // szv#4:S4163:12Mar99 `bool stat1 =` not needed
      if (data->ReadEntity(nsub1,
                           i1,
                           "oriented_edge",
                           ach,
                           STANDARD_TYPE(StepShape_OrientedEdge),
                           anent1))
        aEdgeList->SetValue(i1, anent1);
    }
  }

  num = data->NextForComplex(num);

  // --- Instance of plex component RepresentationItem ---

  if (!data->CheckNbParams(num, 1, ach, "representation_item"))
    return;

  // --- field : name ---

  occ::handle<TCollection_HAsciiString> aName;
  // szv#4:S4163:12Mar99 `bool stat2 =` not needed
  data->ReadString(num, 1, "name", ach, aName);

  num = data->NextForComplex(num);

  // --- Instance of common supertype TopologicalRepresentationItem ---

  if (!data->CheckNbParams(num, 0, ach, "topological_representation_item"))
    return;

  //--- Initialisation of the red entity ---

  ent->Init(aName, aEdgeList);
}

void RWStepShape_RWLoopAndPath::WriteStep(StepData_StepWriter&                      SW,
                                          const occ::handle<StepShape_LoopAndPath>& ent) const
{

  // --- Instance of plex component Loop ---

  SW.StartEntity("LOOP");

  // --- Instance of plex component Path ---

  SW.StartEntity("PATH");
  // --- field : edgeList ---

  SW.OpenSub();
  for (int i1 = 1; i1 <= ent->NbEdgeList(); i1++)
  {
    SW.Send(ent->EdgeListValue(i1));
  }
  SW.CloseSub();

  // --- Instance of plex component RepresentationItem ---

  SW.StartEntity("REPRESENTATION_ITEM");
  // --- field : name ---

  SW.Send(ent->Name());

  // --- Instance of common supertype TopologicalRepresentationItem ---

  SW.StartEntity("TOPOLOGICAL_REPRESENTATION_ITEM");
}

void RWStepShape_RWLoopAndPath::Share(const occ::handle<StepShape_LoopAndPath>& ent,
                                      Interface_EntityIterator&                 iter) const
{

  int nbElem1 = ent->NbEdgeList();
  for (int is1 = 1; is1 <= nbElem1; is1++)
  {
    iter.GetOneItem(ent->EdgeListValue(is1));
  }
}
