// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Interface_EntityIterator.hxx>
#include "RWStepShape_RWBooleanResult.pxx"
#include <StepData_StepReaderData.hxx>
#include <StepData_StepWriter.hxx>
#include <StepShape_BooleanResult.hxx>
#include <StepShape_SolidModel.hxx>
#include <TCollection_AsciiString.hxx>

#include "RWStepShape_RWBooleanOperator.pxx"

RWStepShape_RWBooleanResult::RWStepShape_RWBooleanResult() = default;

void RWStepShape_RWBooleanResult::ReadStep(const occ::handle<StepData_StepReaderData>& data,
                                           const int                                   num,
                                           occ::handle<Interface_Check>&               ach,
                                           const occ::handle<StepShape_BooleanResult>& ent) const
{

  // --- Number of Parameter Control ---

  if (!data->CheckNbParams(num, 4, ach, "boolean_result"))
    return;

  // --- inherited field : name ---

  occ::handle<TCollection_HAsciiString> aName;
  // szv#4:S4163:12Mar99 `bool stat1 =` not needed
  data->ReadString(num, 1, "name", ach, aName);

  // --- own field : operator ---

  StepShape_BooleanOperator aOperator = StepShape_boDifference;
  if (data->ParamType(num, 2) == Interface_ParamEnum)
  {
    const char* text = data->ParamCValue(num, 2);
    if (!RWStepShape_RWBooleanOperator::ConvertToEnum(text, aOperator))
    {
      ach->AddFail("Enumeration boolean_operator has not an allowed value");
    }
  }
  else
    ach->AddFail("Parameter #2 (operator) is not an enumeration");

  // --- own field : firstOperand (is a select type) ---

  // firstOperand Type can be : SolidModel
  //                            HalfSpaceSolid
  //                            CsgPrimitive (Select Type)
  //                              sphere
  //                              block
  //                              right_angular_wedge
  //                              torus
  //                              right_circular_cone
  //                              right_circular_cylinder
  //                            BooleanResult
  // pour que le code soit correct, il faut tester ces types un par un
  // comme on n'implemente pas la CSG (Decembre 1995), on ne fait pas
  // Au cas ou cela change : il faut creer un select type
  // StepShape_BooleanOperand dans lequel on met la vraie valeur instanciee,
  // on l'occurrence un autre Select Type si cette valeur est sphere,
  // block, ...

  // StepShape_BooleanOperand aFirstOperand;
  // bool stat3;
  // stat3 = data->ReadEntity(num,3,"first_operand",ach,aFirstOperand);
  occ::handle<StepShape_SolidModel> aSolidModel1;
  // szv#4:S4163:12Mar99 `bool stat3 =` not needed
  data->ReadEntity(num, 3, "first_operand", ach, STANDARD_TYPE(StepShape_SolidModel), aSolidModel1);
  StepShape_BooleanOperand aFirstOperand;
  aFirstOperand.SetSolidModel(aSolidModel1);

  // --- own field : secondOperand ---

  // StepShape_BooleanOperand aSecondOperand;
  // bool stat4;
  // stat4 = data->ReadEntity(num,4,"second_operand",ach,aSecondOperand);
  occ::handle<StepShape_SolidModel> aSolidModel2;
  // szv#4:S4163:12Mar99 `bool stat4 =` not needed
  data
    ->ReadEntity(num, 4, "second_operand", ach, STANDARD_TYPE(StepShape_SolidModel), aSolidModel2);

  StepShape_BooleanOperand aSecondOperand;
  aSecondOperand.SetSolidModel(aSolidModel2);

  //--- Initialisation of the read entity ---

  ent->Init(aName, aOperator, aFirstOperand, aSecondOperand);
}

void RWStepShape_RWBooleanResult::WriteStep(StepData_StepWriter&                        SW,
                                            const occ::handle<StepShape_BooleanResult>& ent) const
{

  // --- inherited field name ---

  SW.Send(ent->Name());

  // --- own field : operator ---

  SW.SendEnum(RWStepShape_RWBooleanOperator::ConvertToString(ent->Operator()));

  // --- own field : firstOperand ---
  // --- idem au ReadStep : il faut envoyer le bon type :
  // au cas ou : switch(ent->FirstOperand().TypeOfContent())
  //               case 1: SW.Send(ent->FirstOperand().SolidModel())
  //               case 2: ...

  SW.Send(ent->FirstOperand().SolidModel());

  // --- own field : secondOperand ---

  SW.Send(ent->SecondOperand().SolidModel());
}

void RWStepShape_RWBooleanResult::Share(const occ::handle<StepShape_BooleanResult>& ent,
                                        Interface_EntityIterator&                   iter) const
{

  // idem
  iter.GetOneItem(ent->FirstOperand().SolidModel());

  iter.GetOneItem(ent->SecondOperand().SolidModel());
}
