// Created on: 2000-07-03
// Created by: Andrey BETENEV
// Copyright (c) 2000-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// Generator:	ExpToCas (EXPRESS -> CASCADE/XSTEP Translator) V1.1

#include <Interface_EntityIterator.hxx>
#include "RWStepRepr_RWProductDefinitionShape.pxx"
#include <StepData_StepReaderData.hxx>
#include <StepData_StepWriter.hxx>
#include <StepRepr_ProductDefinitionShape.hxx>

//=================================================================================================

RWStepRepr_RWProductDefinitionShape::RWStepRepr_RWProductDefinitionShape() = default;

//=================================================================================================

void RWStepRepr_RWProductDefinitionShape::ReadStep(
  const occ::handle<StepData_StepReaderData>&         data,
  const int                                           num,
  occ::handle<Interface_Check>&                       ach,
  const occ::handle<StepRepr_ProductDefinitionShape>& ent) const
{
  // Check number of parameters
  if (!data->CheckNbParams(num, 3, ach, "product_definition_shape"))
    return;

  // Inherited fields of PropertyDefinition

  occ::handle<TCollection_HAsciiString> aPropertyDefinition_Name;
  data->ReadString(num, 1, "property_definition.name", ach, aPropertyDefinition_Name);

  occ::handle<TCollection_HAsciiString> aPropertyDefinition_Description;
  bool                                  hasPropertyDefinition_Description = true;
  if (data->IsParamDefined(num, 2))
  {
    data->ReadString(num,
                     2,
                     "property_definition.description",
                     ach,
                     aPropertyDefinition_Description);
  }
  else
  {
    hasPropertyDefinition_Description = false;
  }

  StepRepr_CharacterizedDefinition aPropertyDefinition_Definition;
  data->ReadEntity(num, 3, "property_definition.definition", ach, aPropertyDefinition_Definition);

  // Initialize entity
  ent->Init(aPropertyDefinition_Name,
            hasPropertyDefinition_Description,
            aPropertyDefinition_Description,
            aPropertyDefinition_Definition);
}

//=================================================================================================

void RWStepRepr_RWProductDefinitionShape::WriteStep(
  StepData_StepWriter&                                SW,
  const occ::handle<StepRepr_ProductDefinitionShape>& ent) const
{

  // Inherited fields of PropertyDefinition

  SW.Send(ent->StepRepr_PropertyDefinition::Name());

  if (ent->StepRepr_PropertyDefinition::HasDescription())
  {
    SW.Send(ent->StepRepr_PropertyDefinition::Description());
  }
  else
    SW.SendUndef();

  SW.Send(ent->StepRepr_PropertyDefinition::Definition().Value());
}

//=================================================================================================

void RWStepRepr_RWProductDefinitionShape::Share(
  const occ::handle<StepRepr_ProductDefinitionShape>& ent,
  Interface_EntityIterator&                           iter) const
{

  // Inherited fields of PropertyDefinition

  iter.AddItem(ent->StepRepr_PropertyDefinition::Definition().Value());
}
