// Created on: 1999-02-15
// Created by: Andrey BETENEV
// Copyright (c) 1999-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// S4132: reading complex type bounded_curve + surface_curve
//        which is necessary for reading curve_bounded_surfaces
//        This class is based on RWSurfaceCurve

#include <Interface_Check.hxx>
#include <Interface_EntityIterator.hxx>
#include "RWStepGeom_RWSurfaceCurve.pxx"
#include "RWStepGeom_RWSurfaceCurveAndBoundedCurve.pxx"
#include <StepData_StepReaderData.hxx>
#include <StepData_StepWriter.hxx>
#include <StepGeom_BoundedCurve.hxx>
#include <StepGeom_Curve.hxx>
#include <StepGeom_SurfaceCurveAndBoundedCurve.hxx>
#include <TCollection_AsciiString.hxx>

#include "RWStepGeom_RWPreferredSurfaceCurveRepresentation.pxx"

RWStepGeom_RWSurfaceCurveAndBoundedCurve::RWStepGeom_RWSurfaceCurveAndBoundedCurve() = default;

void RWStepGeom_RWSurfaceCurveAndBoundedCurve::ReadStep(
  const occ::handle<StepData_StepReaderData>&              data,
  const int                                                num,
  occ::handle<Interface_Check>&                            ach,
  const occ::handle<StepGeom_SurfaceCurveAndBoundedCurve>& ent) const
{

  // BOUNDED_CURVE: skip
  int num1 = num;

  // CURVE: skip
  num1 = data->NextForComplex(num1);

  // GEOMETRIC_REPRESENTATION_ITEM: skip
  num1 = data->NextForComplex(num1);

  // REPRESENTATION_ITEM: read name
  num1 = data->NextForComplex(num1);
  if (!data->CheckNbParams(num1, 1, ach, "representation_item"))
    return;

  occ::handle<TCollection_HAsciiString> aName;
  data->ReadString(num1, 1, "name", ach, aName);

  // SURFACE_CURVE: read data
  num1 = data->NextForComplex(num1);
  if (!data->CheckNbParams(num1, 3, ach, "surface_curve"))
    return;

  // --- own field : curve3d ---
  occ::handle<StepGeom_Curve> aCurve3d;
  data->ReadEntity(num1, 1, "curve_3d", ach, STANDARD_TYPE(StepGeom_Curve), aCurve3d);

  // --- own field : associatedGeometry ---
  occ::handle<NCollection_HArray1<StepGeom_PcurveOrSurface>> aAssociatedGeometry;
  StepGeom_PcurveOrSurface                                   aAssociatedGeometryItem;
  int                                                        nsub3;
  if (data->ReadSubList(num1, 2, "associated_geometry", ach, nsub3))
  {
    int nb3             = data->NbParams(nsub3);
    aAssociatedGeometry = new NCollection_HArray1<StepGeom_PcurveOrSurface>(1, nb3);
    for (int i3 = 1; i3 <= nb3; i3++)
    {
      // szv#4:S4163:12Mar99 `bool stat3 =` not needed
      if (data->ReadEntity(nsub3, i3, "associated_geometry", ach, aAssociatedGeometryItem))
        aAssociatedGeometry->SetValue(i3, aAssociatedGeometryItem);
    }
  }

  // --- own field : masterRepresentation ---
  StepGeom_PreferredSurfaceCurveRepresentation aMasterRepresentation = StepGeom_pscrCurve3d;
  if (data->ParamType(num1, 3) == Interface_ParamEnum)
  {
    const char* text = data->ParamCValue(num1, 3);
    if (!RWStepGeom_RWPreferredSurfaceCurveRepresentation::ConvertToEnum(text,
                                                                         aMasterRepresentation))
    {
      ach->AddFail("Enumeration preferred_surface_curve_representation has not an allowed value");
    }
  }
  else
    ach->AddFail("Parameter #3 (master_representation) is not an enumeration");

  //--- Initialisation of the read entity ---

  ent->Init(aName, aCurve3d, aAssociatedGeometry, aMasterRepresentation);
  ent->BoundedCurve() = new StepGeom_BoundedCurve;
  ent->BoundedCurve()->Init(aName);
}

void RWStepGeom_RWSurfaceCurveAndBoundedCurve::WriteStep(
  StepData_StepWriter&                                     SW,
  const occ::handle<StepGeom_SurfaceCurveAndBoundedCurve>& ent) const
{

  SW.StartEntity("BOUNDED_CURVE");
  SW.StartEntity("CURVE");
  SW.StartEntity("GEOMETRIC_REPRESENTATION_ITEM");

  SW.StartEntity("REPRESENTATION_ITEM");
  SW.Send(ent->Name());

  // --- Instance of plex component BoundedCurve ---
  SW.StartEntity("SURFACE_CURVE");

  // --- own field : curve3d ---
  SW.Send(ent->Curve3d());

  // --- own field : associatedGeometry ---
  SW.OpenSub();
  for (int i3 = 1; i3 <= ent->NbAssociatedGeometry(); i3++)
  {
    if (!ent->AssociatedGeometryValue(i3).Value().IsNull())
    {
      SW.Send(ent->AssociatedGeometryValue(i3).Value());
    }
  }
  SW.CloseSub();

  // --- own field : masterRepresentation ---
  SW.SendEnum(
    RWStepGeom_RWPreferredSurfaceCurveRepresentation::ConvertToString(ent->MasterRepresentation()));
}

void RWStepGeom_RWSurfaceCurveAndBoundedCurve::Share(
  const occ::handle<StepGeom_SurfaceCurveAndBoundedCurve>& ent,
  Interface_EntityIterator&                                iter) const
{
  RWStepGeom_RWSurfaceCurve tool;
  tool.Share(ent, iter);
}
